LagerAuswahlSattelController = function() {
	LagerAuswahlSattelController.superclass.constructor.call(this);
};

EasyKat.extend(LagerAuswahlSattelController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		//bestimme Default Daten
		Sattel.setDefaultData(oDlgLagerSession);
		
		//Erstelle GUI Daten
		var oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
		oResult.Table = {};
		var oCurrency 			= Base.Store.getWaehrungsData();
		var strPriceHeader 		= translate("TCH_PREIS")+"["+oCurrency.CURRENCY_UNIT+"]";
		oResult.Table.Header 	= [[7,strPriceHeader]];
		
		if(oDlgLagerSession.bLastKetteDialog){
			var oDataResult;
			var myData = Sattel.getClientTable(oDlgLagerSession);
			
			if(myData.length == 0)
				oResult.Table.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.Table.store = myData;
				
			oResult.Table.sel	= oDlgLagerSession.AuswahlSattel.strResultId;	
		}
		
		echo oResult.toJSON(); 
	},
	setNumberfieldAction : function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strNumberFieldId 	= HttpRequest.get("numberfieldid"); 	
		var strNumberFieldValue = HttpRequest.get("numberfieldvalue");	
		
		if(strNumberFieldId == "LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER")
			oDlgLagerSession.AuswahlSattel.dSonderLayer	= strNumberFieldValue;
		else if(strNumberFieldId == "LAGER_SATTEL_LAENGE_SONDER")
			oDlgLagerSession.AuswahlSattel.dSonderLength = strNumberFieldValue;
			
		var oResult = {};
		echo oResult.toJSON();
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		
		strComboBoxId = strComboBoxId.replace("LAGER_","");
		strComboBoxId = strComboBoxId.replace("_COMBO","");
		
		switch(strComboBoxId){
			case "SATTEL_LAENGE" 		:
					oDlgLagerSession.AuswahlSattel.strSelComboLength 		= strComboBoxValue;
				break;
			case "SATTEL_OBERFLAECHE" 	:
					oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel 	= strComboBoxValue;
				break;
		}
		
		var oResult = {};
		echo oResult.toJSON();
	},
	setCheckBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strCheckBoxId 	 = HttpRequest.get("checkboxid"); 	
		var strCheckBoxValue = HttpRequest.get("checkboxvalue");	
		
		strCheckBoxValue = (strCheckBoxValue == 'true' || strCheckBoxValue == true) ? true : false;
		
		var oResult = {};
		if(strCheckBoxId == 'LAGER_SATTEL_ZYLIDER'){
			oDlgLagerSession.AuswahlSattel.bActuator = strCheckBoxValue;
			oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart 	= true;
			oDlgLagerSession.AuswahlSattel.bRadioWeldEnd 			= false;
			
			if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && !strCheckBoxValue)
				oDlgLagerSession.AuswahlSattel.bUpliftRestraint = false;
			
			oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
		}
		else{
			strCheckBoxId = strCheckBoxId.replace("LAGER_SATTEL_","");
			switch(strCheckBoxId){
				case "ABHEBESICHERUNG" :
						oDlgLagerSession.AuswahlSattel.bUpliftRestraint = strCheckBoxValue;
					break;
				case "ROHRUMSCHLUSS" :
						oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart = strCheckBoxValue;
						oDlgLagerSession.AuswahlSattel.bRadioWeldEnd = !strCheckBoxValue;
						oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
					break;
				case "ANSCHWEISSEN" :
						oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart = !strCheckBoxValue;
						oDlgLagerSession.AuswahlSattel.bRadioWeldEnd = strCheckBoxValue;
						oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
					break;
				case "AUFLAGEDURCHMESSER_SONDER_CHECK" :
						oDlgLagerSession.AuswahlSattel.bSonderLayer = strCheckBoxValue;
					break;
				case "LAENGE_SONDER_CHECK" :
						oDlgLagerSession.AuswahlSattel.bSonderLength = strCheckBoxValue;
						// -Schu-
						if (!strCheckBoxValue)
							oDlgLagerSession.AuswahlSattel.dSonderLength	= 0;
						oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
					break;	
			}
		}
		
		echo oResult.toJSON();
	},
	setRadioAction: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strRadioId 	 		= HttpRequest.get("radiogroup"); 	
		var strRadioValue 		= HttpRequest.get("radiovalue");	
		
		if(strRadioId == "LAGER_SATTEL_ROHRUMSCHLUSS_R")
			oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = strRadioValue;
		else if(strRadioId == "LAGER_SATTEL_ANSCHWEISSEN_R")
			oDlgLagerSession.AuswahlSattel.strRadioWeldEnd = strRadioValue;
			
		var oResult = Controller.Lager.Common.getDataAuswahlSattel(oDlgLagerSession);
		echo oResult.toJSON();
	},
	setTableSelAction: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strTableSelection 	= HttpRequest.get("selection");
		if(strTableSelection == '-')
			this._cleanUp();
		else{
			oDlgLagerSession.AuswahlSattel.strResultId = strTableSelection;
			oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel = {};
			oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel = getDataFromLagerCacheObject('AuswahlSattel','TABLE',strTableSelection);
			if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint){
				oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung = {};
				oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung = getDataFromLagerCacheObject('AuswahlAbhebesicherung','TABLE',strTableSelection);
			}		
		}
		
		var oResult = {};
		echo oResult.toJSON();
	},
	getButtonAction: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		var oResult 			= {};
		oResult.Table 			= {};
		oDlgLagerSession.bLastKetteDialog = false;
		caMainController.getLagerTopologieklasse().setEmptyProduct();
		
		this._cleanUp();
		
		var oDataResult 		= Sattel.Search.getSearchResult(oDlgLagerSession);
		
		if(oDataResult.Error)
			oResult.Table.Error = oDataResult.Error;
		
		if(oDataResult.aTableData)
			oResult.Table.store = oDataResult.aTableData;
		
		echo oResult.toJSON();
	},
	setValuesAction : function(){        
		var oDlgLager = caMainController.getLagerTopologieklasse().getDlgLagerSession();
		caMainController.getLagerTopologieklasse().setSattel(oDlgLager);
	},
	_cleanUp: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.AuswahlSattel.strResultId 		= '';
		oDlgLagerSession.AuswahlSattel.oSearchResult 	= {};
		setDataIntoLagerCacheObject('AuswahlSattel','TABLE');
		setDataIntoLagerCacheObject('AuswahlSattel','TEMP_TABLE');
		setDataIntoLagerCacheObject('AuswahlAbhebesicherung','TABLE');
	}
});