LagerAuswahlRollenlagerDirektController = function() {
	LagerAuswahlRollenlagerDirektController.superclass.constructor.call(this);
};

EasyKat.extend(LagerAuswahlRollenlagerDirektController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var oResult = Controller.Lager.Common.getDataAuswahlRollenlagerDirekt(oDlgLagerSession);
		echo oResult.toJSON(); 
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		var oResult = {};
		strComboBoxId = strComboBoxId.replace("LAGER_ROLLENLAGER_DIREKT_","");
		switch(strComboBoxId){
			case "DZ_RL" 	:
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDZ_RL		= strComboBoxValue;
				break;
			case "Z_RL" 	:
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboZ_RL		= strComboBoxValue;
				break;
			case "DK_RL" 	:
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDK_RL		= strComboBoxValue;
				break;
			case "DZ_RL_SV" :
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDZ_RL_SV	= strComboBoxValue;
				break;
			case "Z_RL_SV" 	:
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboZ_RL_SV	= strComboBoxValue;
				break;
			case "DK_RL_SV" :
					oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDK_RL_SV	= strComboBoxValue;
				break;
			case "TRAEGERART":
					oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = strComboBoxValue;
					var oBeam		= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,"LAGER_ROLLEN_TRAEGER_ART"); 
					var aComboStore = [['TRAEGERTYP',oBeam.store.storeTGroesse]];
					var aComboSel 	= [['TRAEGERTYP',oDlgLagerSession.AuswahlStandard.strSelComboBeamSize]];
					oResult.value 	= {};
					oResult.value.aComboSel = aComboSel;
					oResult.store = aComboStore;
				break;
			case "TRAEGERTYP":
					oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strComboBoxValue;
					var oBeam  = Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,"LAGER_ROLLEN_TRAEGER_GROESSE"); 
					var aValue = [
						['HOEHE', oDlgLagerSession.AuswahlStandard.dBeamHeight,true],
						['BREITE',oDlgLagerSession.AuswahlStandard.dBeamWidth,true],
						['FLANSCHDICKE',oDlgLagerSession.AuswahlStandard.dBeamThickness,true]
					];
					oResult.value 	= {};
					oResult.value.numberfield = aValue;
				break;
		};
		
		
		//if((strComboBoxId != "TRAEGERART") || (strComboBoxId != "TRAEGERTYP")){
		if((strComboBoxId != "TRAEGERART") && (strComboBoxId != "TRAEGERTYP")){
			var bIsKlemmbar = Lager.Search.LagerTyp.isRollenlagerKlemmbar(strComboBoxValue);
			oResult.checkbox = {};
			if(bIsKlemmbar){
				oResult.checkbox.disable 	= false;
				oResult.checkbox.klemmbar	= (oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck*1 ? true : false);
			}
			else{
				oResult.checkbox.disable 	= true;
				oResult.checkbox.klemmbar 	= false;
				//oDlgLagerSession.AuswahlStandard.bCheck = false;
				oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck = false;
			}
		}
		
		echo oResult.toJSON();
	},
	setCheckBoxAction : function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var bValue = (HttpRequest.get("value") == "true" || HttpRequest.get("value") == true)? true : false;
		var strId  = HttpRequest.get("checkid");
		
		if(strId == "KLEMMBAR")
			oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck = bValue;
		
		var oResult = {};
		echo oResult.toJSON();		
	},
	setRadioAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strRadioId 	 	= HttpRequest.get("radioid"); 	
		var strRadioValue 	= HttpRequest.get("radiovalue");	
		
		oDlgLagerSession.AuswahlRollenlagerDirekt.strRadio = strRadioValue;
		
		var oResult = {};
		echo oResult.toJSON();
	},
	setValuesAction : function(){      
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		//hole Selection Data
		var strSelection = 'strSelCombo'+oDlgLagerSession.AuswahlRollenlagerDirekt.strRadio;
		oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager 	= {};
		oDlgLagerSession.AuswahlRollenlagerDirekt.strResultId						= oDlgLagerSession.AuswahlRollenlagerDirekt[strSelection];
		oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager  = Lager.Search.LagerTyp.Rollenlager_Direkt(oDlgLagerSession,oDlgLagerSession.AuswahlRollenlagerDirekt.strResultId);
				
		if(oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck){
			//search Klemmsystem
			var BtrForSearch	= "140";
			if((oDlgLagerSession.AuswahlStandard.dBeamWidth*1) > 120){
				strVarKlemm	= 'KOT 20-RL-T'+(oDlgLagerSession.AuswahlStandard.dBeamWidth);
				if ((oDlgLagerSession.AuswahlStandard.dBeamWidth*1) > 140)
					BtrForSearch	= "-";
			}
			else{
				strVarKlemm		= 'KOT 09-RL-T'+(oDlgLagerSession.AuswahlStandard.dBeamWidth);
				BtrForSearch	= "120";
			}
			oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem = Klemmsystem.Search.KlemmsystemTyp.Direkt(strVarKlemm, BtrForSearch);
			oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem.H				= oDlg.AuswahlStandard.dBeamHeight;
			oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem.B				= oDlg.AuswahlStandard.dBeamWidth;	
			oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem.TG				= oDlg.AuswahlStandard.dBeamThickness;
		}	
		
		//--> Lastkette
		var oDlgLager = caMainController.getLagerTopologieklasse().getDlgLagerSession();
		caMainController.getLagerTopologieklasse().setRollenLager(oDlgLager,"DIREKT");
	}
});