LagerAuswahlRollenlagerController = function() {
	LagerAuswahlRollenlagerController.superclass.constructor.call(this);
};

EasyKat.extend(LagerAuswahlRollenlagerController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		this._buildDialogId(oDlgLagerSession);
		
		var oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession); 
		
		if(oDlgLagerSession.bLastKetteDialog){
			//hier wird nun noch die Tabelle gebraucht !!
			var oDataResult = {};
			var strSelection = oDlgLagerSession.AuswahlRollenlager.strResultId;
			switch(oDlgLagerSession.AuswahlRollenlager.strDialogId){			
				case "ROLLENLAGER_P" : //hier handelt es sich um ein Lager ohne Klemmsystem wird also in Lager.search.getSearchResult weitergeleitet
				case "ROLLENLAGER_S" :
						var aResult = Lager.getClientTable(oDlgLagerSession,oDlgLagerSession.AuswahlRollenlager.strDialogId); 
						if(typeof (aResult) == "object")
							oDataResult.aTableData = aResult;
						else
							oDataResult.Error = aResult;
					break;
				case "ROLLENLAGER_K" :
						oDataResult.aTableData = Klemmsystem.getClientTable(oDlgLagerSession,true);
					break;
				case "ROLLENLAGER_U_SATTEL":
					oDataResult = {};
					oDataResult.aTableData = Abhebesicherung.getClientTable(oDlgLagerSession);					
				break;	
			}		
			
			if(oDataResult.Error)
				oResult.resulttable.Error = oDataResult.Error;
			
			if(oDataResult.aTableData){
				oResult.resulttable.store 	= oDataResult.aTableData;
				oResult.resulttable.sel		= strSelection;
			}
		}
		echo oResult.toJSON(); 
	},
	setNumberfieldAction : function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strNumberFieldId 	= HttpRequest.get("numberfieldid"); 	
		var strNumberFieldValue = HttpRequest.get("numberfieldvalue");	
		var oResult 			= {};
		oDlgLagerSession.bLastKetteDialog = false;
		switch(strNumberFieldId){
			case "LAGER_ROLLEN_TRAEGER_HOEHE" :	
					oDlgLagerSession.AuswahlStandard.dBeamHeight				= strNumberFieldValue;
				break;
			case "LAGER_ROLLEN_TRAEGER_BREITE" :
					oDlgLagerSession.AuswahlStandard.dBeamWidth					= strNumberFieldValue;
				break;	
			case "LAGER_ROLLEN_TRAEGER_FLANSCHDICKE" :
					oDlgLagerSession.AuswahlStandard.dBeamThickness				= strNumberFieldValue;
				break;		
			case "LAGER_ROLLEN_SATTEL_ROHRAUSSENDURCHMESSER" :
					oDlgLagerSession.AuswahlRollenlager.dSattelOuterDiameter 	= strNumberFieldValue*1;
					oResult.fieldset 				= {};
					oResult.fieldset.lager_sattel 	= {};
					oResult.fieldset.lager_sattel.show 	= true;
					oResult.fieldset.lager_sattel.value = true;					
				break;	
			case "LAGER_ROLLEN_SATTEL_AUFLAGEDURCHMESSER" :
					oDlgLagerSession.AuswahlRollenlager.dSattelBearingDiameter 	= strNumberFieldValue*1;		
					
					oResult.fieldset 				= {};
					oResult.fieldset.lager_sattel 	= {};
					oResult.fieldset.lager_sattel.show 	= true;
					oResult.fieldset.lager_sattel.value = true;						
				break;
			case "LAGER_ROLLEN_SATTEL_SATTELLAENGE" :
					oDlgLagerSession.AuswahlRollenlager.dSattelLength 			= strNumberFieldValue*1; 
					oResult.fieldset 				= {};
					oResult.fieldset.lager_sattel 	= {};
					oResult.fieldset.lager_sattel.show 	= true;
					oResult.fieldset.lager_sattel.value = true;	
				break;
			case "LAGER_ROLLEN_AUFLAGE_DURCHMESSER" :
					oDlgLagerSession.AuswahlRollenlager.dSupportDiameter 		= strNumberFieldValue; 
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,'LAGER_ROLLENLAGER_ART');
				break;
			case "LAGER_ROLLEN_FUSSBREITE" :
					oDlgLagerSession.AuswahlRollenlager.dFeetWide 				= strNumberFieldValue; 
				break;	
		}
		
		
		echo oResult.toJSON();
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = {};
		if(strComboBoxId == 'LAGER_ROLLENLAGER_ART' || strComboBoxId == 'LAGER_ROLLENLAGER_TYP'){
			oDlgLagerSession.AuswahlRollenlager.dSupportDiameter 	= 0; 
			oDlgLagerSession.AuswahlRollenlager.dFeetWide			= 0;
		}
		
		switch(strComboBoxId){
			case "LAGER_ROLLENLAGER_ART" :
					oDlgLagerSession.AuswahlRollenlager.strSelComboTyp = strComboBoxValue;
					
					if(strComboBoxValue!="ZYLINDER")
						oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint =	false;
					
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,strComboBoxId);				
				break;
			case "LAGER_ROLLEN_TRAEGER_GROESSE" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strComboBoxValue;
					var oBeam = Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,strComboBoxId);
					oResult.fieldset = {};
					oResult.fieldset.lager_traeger = oBeam;
				break;
			case "LAGER_ROLLEN_TRAEGER_ART" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = strComboBoxValue;
					var oBeam = Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,strComboBoxId);
					oResult.fieldset = {};
					oResult.fieldset.lager_traeger  = oBeam;					
				break;
			case "LAGER_ROLLENLAGER_TYP" :
					oDlgLagerSession.AuswahlRollenlager.strSelComboType = strComboBoxValue;
					//Bestimmung von der Werkstoff + Oberfl
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,strComboBoxId);
				break;
			case "LAGER_ROLLENLAGER_MATERIAL" :
					oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial = strComboBoxValue;
					//Bestimmung von der Oberfl
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,strComboBoxId);
				break;
			case "LAGER_ROLLENLAGER_OBERFLAECHE" :
					oDlgLagerSession.AuswahlRollenlager.strSelComboGroundLevel = strComboBoxValue;
				break;	
		}		
		
		echo oResult.toJSON();
	},
	setCheckBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strCheckBoxId 	 = HttpRequest.get("checkboxid"); 	
		var strCheckBoxValue = HttpRequest.get("checkboxvalue") == 'true' ? true : false;	
		oDlgLagerSession.bLastKetteDialog = false;
		oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint = strCheckBoxValue;
		
		var oResult = {};
		echo oResult.toJSON();
	},
	setRadioAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strRadioId 	 	= HttpRequest.get("radiogroup"); 	
		var strRadioValue 	= HttpRequest.get("radiovalue");	
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = {};
		switch(strRadioId){
			case "LAGER_ROLLENLAGER_COLUMN_FUNCTION" :
					oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing = strRadioValue ;
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,"RADIO");
					if (oDlgLagerSession.AuswahlRollenlager.strDialogId == "ROLLENLAGER_P" &&
						oResult.fieldset.lager_function.value.vAbhebesicherung)
							oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint = true;
				break;
			case "LAGER_LAGERSYSTEM_R" :  
			case "LAGER_ROLLENLAGER_COLUMN_BEFESTIGUNG" :
					oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction = strRadioValue ;
					oResult = Controller.Lager.Common.getDataAuswahlRollenlager(oDlgLagerSession,"RADIO");
				break;
			case "LAGER_LS_ABHEBESICHERUNG" :
					oDlgLagerSession.AuswahlRollenlager.strSelRadioFixed = strRadioValue;
				break;
			case "LAGER_ROLLENLAGER_ART_WERK" :
					oDlgLagerSession.AuswahlRollenlager.strSelRadioWerk  =  strRadioValue.replace("LAGER_ROLLENLAGER_ART_WERKSTOFF_","");
				break;
		}
		echo oResult.toJSON();
	},
	setTableSelAction: function(){		
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strTableSelection 	= HttpRequest.get("selection");
		if(strTableSelection == '-')
			this._cleanUp();
		else{
			oDlgLagerSession.AuswahlRollenlager.strResultId = strTableSelection;	
			oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager = {};
			if(oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_U_SATTEL')
				oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager = getDataFromLagerCacheObject('AuswahlAbhebesicherung','TABLE',strTableSelection);
			else if(oDlgLagerSession.AuswahlRollenlager.strDialogId != "LAGERSYSTEM" && oDlgLagerSession.AuswahlRollenlager.strDialogId != "KLEMMSYSTEM_GLEITLAGER")
				oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager = getDataFromLagerCacheObject('AuswahlRollenlager','TABLE',strTableSelection);
		}
		
		var oResult = {};
		echo oResult.toJSON();
		
	},
	getButtonAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var storeData, strError;
		this._cleanUp();		
		
		var oResult 				= {};
		oResult.resulttable 		= {};
		
		var oDataResult;
		
		switch(oDlgLagerSession.AuswahlRollenlager.strDialogId){			
			case "ROLLENLAGER_P" : //hier handelt es sich um ein Lager ohne Klemmsystem wird also in Lager.search.getSearchResult weitergeleitet
			case "ROLLENLAGER_S" :
					oDataResult = Lager.Search.getSearchResult(oDlgLagerSession,oDlgLagerSession.AuswahlRollenlager.strDialogId);
				break;
			case "ROLLENLAGER_K" :
					setDataIntoLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE');
					oDataResult = Klemmsystem.Search.getSearchResult(oDlgLagerSession);
				break;
			case "ROLLENLAGER_U_SATTEL":
				var strTable = "A";
				if(oDlgLagerSession.AuswahlRollenlager.strSelComboTyp == 'DOPPELZYLINDER')
					strTable +="D";
				else
					strTable +="K";
				
				oDataResult = {};
				//oDataResult.aTableData = [];
				//oDataResult.aTableData = Abhebesicherung.Search.getSearchResult(oDlgLagerSession,{},oDlgLagerSession.AuswahlRollenlager.strDialogId,strTable).aTableData;	
				oDataResult	= Abhebesicherung.Search.getSearchResult(oDlgLagerSession,{},oDlgLagerSession.AuswahlRollenlager.strDialogId,strTable);
			break;	
		}		
		
		if(oDataResult.Error)
			oResult.resulttable.Error = oDataResult.Error;
		else if(oDataResult.strError)
			oResult.resulttable.Error = oDataResult.strError;
		
		if(oDataResult.aTableData)
			oResult.resulttable.store = oDataResult.aTableData;
		
		echo oResult.toJSON();
	},
	setValuesAction : function(){        
		//--> Lastkette
		var oDlgLagerSession	= getDialogObjectSession("LAGER");	
		if(oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction == 'KLEMMBAR'){
			var strVarKlemm		= "T";
			var BtrForSearch	= "140";
			if((oDlgLagerSession.AuswahlStandard.dBeamWidth*1) > 120){
				strVarKlemm = 'KOT 20-RL-T'+(oDlgLagerSession.AuswahlStandard.dBeamWidth);
				if ((oDlgLagerSession.AuswahlStandard.dBeamWidth*1) > 140)
					BtrForSearch	= "-";
			}
			else{
				strVarKlemm		= 'KOT 09-RL-T'+(oDlgLagerSession.AuswahlStandard.dBeamWidth);
				BtrForSearch	= "120";
			}
				
			oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultKlemmsystem		= Klemmsystem.Search.KlemmsystemTyp.Direkt(strVarKlemm, BtrForSearch);
			oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultKlemmsystem.H		= oDlg.AuswahlStandard.dBeamHeight;
			oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultKlemmsystem.B		= oDlg.AuswahlStandard.dBeamWidth;	
			oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultKlemmsystem.TG		= oDlg.AuswahlStandard.dBeamThickness;
		}
		
		if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_SYROLLSA"){
			if(!oDlgLagerSession.AuswahlSattel.bActuator && oDlgLagerSession.AuswahlSattel.bUpliftRestraint){
				var strObfl	 			= oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel;
				var strSattellaenge 	= oDlgLagerSession.AuswahlSattel.strSelComboLength;
				var strWerkstoff    	= Lager.getWerkstoffeNumber(oDlgLagerSession);		// Sattelwerkstoff
				// Werkstoff fr AHS ist nicht zwingend identisch zum Sattelwekstoff -> Wert aus Tabelle nehmen
				var strWerkstoff_AHS	= oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.WST_AHS;
				var strBau_F 			= oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager.BAU_F;
				if((strBau_F*1)>900)
					strBau_F = (strBau_F*1) - 900;
					
				var strTable 		= oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager.TYP_AHS_SATTEL;
				//if(oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "-")
				var t1 = (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo*1 > 0 ? true : false);
				var t2 = (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder*1 ? true : false);
				if((oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "STD") || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder*1)
					strTable = oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultRollenlager.TYP_AHS_MANTEL;
				
				oDlgLagerSession.AuswahlRollenlager.oSearchResult.oResultAbhebesicherung = Abhebesicherung.Search.Abhebesicherungtyp.SattelDirekt(oDlgLagerSession,strTable,strBau_F,strWerkstoff_AHS,strSattellaenge,strObfl);
			}
		}
		
		var oDlgLager 			= caMainController.getLagerTopologieklasse().getDlgLagerSession();
		if(oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_U_SATTEL')
			caMainController.getLagerTopologieklasse().setRollenLager(oDlgLager,"ABHEBSICHERUNG");
		else
			caMainController.getLagerTopologieklasse().setRollenLager(oDlgLager,"STANDARD");
	},
	_cleanUp: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.AuswahlRollenlager.strResultId 	= '';
		oDlgLagerSession.AuswahlRollenlager.oSearchResult 	= {};
		setDataIntoLagerCacheObject('AuswahlRollenlager','TABLE');
		
		if(oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_U_SATTEL')
			setDataIntoLagerCacheObject('AuswahlAbhebesicherung','TABLE');
		
	},
	/**
	 * private function
	 * Festlegen welches aussehen der Dialog bekommen soll
	 */
	_buildDialogId : function(oDlgLagerSession){
		var strLastID = oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-1)];
		if(strLastID == 'lager.auswahl_rollenlager') //das kommt nur vor wenn man von der Lastkette aus kommt
			strLastID = oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-2)];
			
		if((oDlgLagerSession.Systemcharakteristik.bSel_krT == false) && 
			(strLastID !== "lager.auswahl_sattel") &&
			(strLastID !== "lager.systemcharakteristik"))
			oDlgLagerSession.AuswahlRollenlager.strDialogId = "ROLLENLAGER_P";
		
		else if(strLastID == "lager.auswahl_sattel")
			oDlgLagerSession.AuswahlRollenlager.strDialogId = "ROLLENLAGER_S";
		
		else if((strLastID === "lager.systemcharakteristik") &&
			(oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager === 'AfR'))
			oDlgLagerSession.AuswahlRollenlager.strDialogId = "ROLLENLAGER_U_SATTEL";
		
		else 
			oDlgLagerSession.AuswahlRollenlager.strDialogId = "ROLLENLAGER_K";
			
			
	}
});