LagerAuswahlKlemmsystemController = function() {
	LagerAuswahlKlemmsystemController.superclass.constructor.call(this);
};

EasyKat.extend(LagerAuswahlKlemmsystemController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strLastID 			= oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-1)];
		
		if(strLastID == "lager.auswahl_klemmsystem") //kommt genau dann vor, wenn als Vorgnger Dialog die Lastkette ist
			strLastID = oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-2)];
		
		if((oDlgLagerSession.AuswahlStandard.strSelComboFunction == "2W_PLUS" && 
			oDlgLagerSession.AuswahlStandard.bGaT == true) || ( strLastID == "lager.auswahl_standard"))
			oDlgLagerSession.Klemmsystem.strDialogId = "LAGERSYSTEM";
		else
			oDlgLagerSession.Klemmsystem.strDialogId = "ZUBEHOER";
			
		var oResult = _getGUIData(oDlgLagerSession);
		
		if(oDlgLagerSession.bLastKetteDialog){
			var oDataResult;
			var myData = Klemmsystem.getClientTable(oDlgLagerSession);
			
			if(myData.length == 0)
				oResult.Table.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.Table.store = myData;
				
			oResult.Table.sel	= oDlgLagerSession.Klemmsystem.strResultId;	
		}
		
		echo oResult.toJSON();	
	},
	setCheckBoxAction: function(){
		var oResult = {};
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strId 	= HttpRequest.get('checkboxid');
		var bValue 	= HttpRequest.get('checkboxvalue') == 'true' ? true : false;
		strId = strId.replace("LAGER_KLEMMSYSTEM_","");
		
		switch(strId){
			case "FUNCTION_FC_AB"	:
					oDlgLagerSession.Klemmsystem.bUpliftRestraint	= bValue;
					if(!bValue)
						oDlgLagerSession.Klemmsystem.bUpliftRestraint4 = bValue;
					
					oResult = _getGUIData(oDlgLagerSession,strId);
				break;
			case "FUNCTION_FC_AB4"	:
					oDlgLagerSession.Klemmsystem.bUpliftRestraint4 	= bValue;
					oResult = _getGUIData(oDlgLagerSession,strId);
					oResult = {'success' : true};
				break;
			case "FUNCTION_FC_GLT"	:
					oDlgLagerSession.Klemmsystem.bGaT = bValue;
					if (!bValue)
						oDlgLagerSession.Klemmsystem.strSelComboFunction = 'GEFUEHRT';
					oResult = _getGUIData(oDlgLagerSession,strId);
				break;		
		}
		
		echo oResult.toJSON(); 
	},
	setRadioAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strRadioId 	 	= HttpRequest.get("radiogroup"); 	
		var strRadioValue 	= HttpRequest.get("radiovalue");	
		
		var oResult = {};
		switch(strRadioId){
			case "LAGER_LS_ABHEBESICHERUNG" :
					oDlgLagerSession.Klemmsystem.strSelRadioFixed = strRadioValue;
				break;
		}
		echo oResult.toJSON();
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		var oResult = {'success' : true};
		strComboBoxId = strComboBoxId.replace("LAGER_KLEMMSYSTEM_","");
		switch(strComboBoxId){
			case "FUNCTION_FC_LFUSS" :
					oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport = strComboBoxValue;
					oResult = _getGUIData(oDlgLagerSession,strComboBoxId);
				break;
			case "FUNCTION_FC" :
					oDlgLagerSession.Klemmsystem.strSelComboFunction = strComboBoxValue;
					if(strComboBoxValue=="LOSLAGER" || strComboBoxValue=="LOSE"){
						oDlgLagerSession.Klemmsystem.bGaT = true;
						oDlgLagerSession.Klemmsystem.bUpliftRestraint 	= false;
						oDlgLagerSession.Klemmsystem.bUpliftRestraint4 	= false;
					}	
					
					oResult = _getGUIData(oDlgLagerSession,strComboBoxId);
				break;	
			case "TRAEGER_ART" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = strComboBoxValue;
					oResult = _getGUIData(oDlgLagerSession,strComboBoxId);
				break;
			case "TRAEGER_GROESSE" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strComboBoxValue;
					oResult = _getGUIData(oDlgLagerSession,strComboBoxId);
				break;	
		};
		
		echo oResult.toJSON(); 
	},
	setNumberfieldAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var oResult 			= {};
		var strNumberfieldId 	= HttpRequest.get("numberfieldid");
		var strNumberfieldValue = HttpRequest.get("numberfieldvalue");
		strNumberfieldId 		= strNumberfieldId.replace("LAGER_KLEMMSYSTEM_TRAEGER_","");
		switch(strNumberfieldId){
			case "HOEHE"	:
					oDlgLagerSession.AuswahlStandard.dBeamHeight	= strNumberfieldValue;
				break;
			case "BREITE"	:
					oDlgLagerSession.AuswahlStandard.dBeamWidth		= strNumberfieldValue;
				break;
			case "FLANSCHDICKE"	:
					oDlgLagerSession.AuswahlStandard.dBeamThickness = strNumberfieldValue;
				break;
			case "LAGER_KLEMMSYSTEM_SONST_BREITE" :
					oDlgLagerSession.Klemmsystem.dOtherWidthBaseOfTheSupport = (strNumberfieldValue*1)
				break;
		}
		
		echo oResult.toJSON(); 
	},
	setTableSelAction: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strTableSelection 	= HttpRequest.get("selection");
		if(strTableSelection == '-')
			this._cleanUp();
		else{
			oDlgLagerSession.Klemmsystem.strResultId = strTableSelection;	
			oDlgLagerSession.Klemmsystem.oSearchResult.oResultKlemmsystem = {};
			oDlgLagerSession.Klemmsystem.oSearchResult.oResultKlemmsystem = getDataFromLagerCacheObject('AuswahlKlemmsystem','TABLE',strTableSelection);
		}
		
		var oResult = {'success' : true};
		echo oResult.toJSON(); 
	},
	getButtonAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");		
		this._cleanUp();
		
		var storeData, strError;
		var oResult 		= {};
		oResult.Table 		= {};
		
		var oDataResult 	= Klemmsystem.Search.getSearchResult(oDlgLagerSession);
		
		if(oDataResult.Error)
			oResult.Table.Error = oDataResult.Error;
		
		if(oDataResult.aTableData)
			oResult.Table.store = oDataResult.aTableData;
		
		echo oResult.toJSON();
	},
	setValuesAction : function(){ 
		//--> Lastkette
		var oDlgLager = caMainController.getLagerTopologieklasse().getDlgLagerSession();
		caMainController.getLagerTopologieklasse().setKlemmsystem(oDlgLager);
	},
	_cleanUp: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.Klemmsystem.strResultId 		= '';
		oDlgLagerSession.Klemmsystem.oSearchResult 	= {};
		setDataIntoLagerCacheObject('AuswahlKlemmsystem','TABLE');
	},
	
	_getGUIData: function(oDlgLagerSession,strEventId){
		/**
		 * setze bersichtsbild fr aktuelles Klemmsystem (ehemals im client definiert)
		 * @returns	{String}
		 */
		var __getPicture = function(oDlgLagerSession){
			var strLagerfunktion 		= oDlgLagerSession.Klemmsystem.strSelComboFunction;		
			var bIsGleitunterlage 		= oDlgLagerSession.Klemmsystem.bUpliftRestraint;
			var bIsAbhebesicherung 		= oDlgLagerSession.Klemmsystem.bUpliftRestraint4;
			var bIsAbhebesicherung4fach = oDlgLagerSession.Klemmsystem.bGaT;
			var nIndexTraegergroesse 	= oDlgLagerSession.AuswahlStandard.strSelComboBeamSize;
			var strProfilart 			= oDlgLagerSession.AuswahlStandard.strSelComboBeamArt;
			
			var strBild = 'blank.gif';

			// wenn keine Gleitunterlage: die Bilder sind fr alle Lagerfunktionen gleich
			if ( !bIsGleitunterlage ){
				// bei U- und L-Profilen
				if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) ){
					if ( strProfilart == 'U_PROFIL' ){
						if ( bIsAbhebesicherung )
							strBild = 'B_KZU20.jpg';
						else 
							strBild = 'B_KOU20.jpg';
					}
					else{
						if ( bIsAbhebesicherung )
							strBild = 'B_KZL20.jpg';
						else 
							strBild = 'B_KOL20.jpg';
					}
				}
				else{
					if ( bIsAbhebesicherung ){
						if ( bIsAbhebesicherung4fach )
							strBild = 'B_KAT20.jpg';
						else strBild = 'B_KZT20.jpg';
					}
					else 
						strBild = 'B_KOT20.jpg';
				}
			}
			else{
				// wenn Gleitunterlage gewhlt
				if ( strLagerfunktion == 'FUEHRUNGSLAGER' ){
					// bei U- und L-Profilen fr Fhrungslager
					if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) ){
						if ( strProfilart == 'U_PROFIL' ){
							if ( bIsAbhebesicherung )
								strBild = 'B_KZU40.jpg';
							else 
								strBild = 'B_KOU40.jpg';
						}
						else{
							if ( bIsAbhebesicherung )
								strBild = 'B_KZL40.jpg';
							else 
								strBild = 'B_KOL40.jpg';
						}
					}
					else{
						if ( nIndexTraegergroesse <= 0 ){    // T-Profile, Defaultwert
							if ( bIsAbhebesicherung ){
								if ( bIsAbhebesicherung4fach )
									strBild = 'B_KAT40_1.jpg';
								else strBild = 'B_KZT40_1.jpg';
							}
							else 
								strBild = 'B_KOT40_1.jpg';
						}
						else{
							if ( bIsAbhebesicherung ){
								if ( bIsAbhebesicherung4fach )
									strBild = 'B_KAT40_2.jpg';
								else 
									strBild = 'B_KZT40_2.jpg';
							}
							else 
								strBild = 'B_KOT40_2.jpg';
						}
					}
				}
				else{
					// bei U- und L-Profilen fr Loslager
					if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) ){
						if ( strProfilart == 'U_PROFIL' )
							strBild = 'B_KLU40.jpg';
						else 
							strBild = 'B_KLL40.jpg';
					}
					else{
						if ( nIndexTraegergroesse <= 0 )     // T-Profile, Defaultwert
							strBild = 'B_KLT40_1.jpg';
						else 
							strBild = 'B_KLT40_2.jpg';
					}
				}
			}

			// setze Bild
			var strFile = 'catalog/client/custom/img/WITgifs/RH/' + 'Var1_' + strBild;
			//var strHtml = '<img src="' + strFile + '" />';
			return strFile;
		}
		
		//Schaltlogik hinzufgen
		//LAGER_LAGERSYSTEM_FUNCTION / LAGER_KLEMMSYSTEM_FUNCTION
		
	
		
		if(!strEventId)
			strEventId = 'ALL';
		
		var oRet 		= {};
		var oFunction 	= {};
		
		if(strEventId == 'ALL' || strEventId == 'TRAEGER_ART' || strEventId == 'TRAEGER_GROESSE'){
			var strComboEvent;
			if(strEventId !== 'ALL')
				strComboEvent = 'LAGER_'+strEventId;
				
			var oBeam			= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,strComboEvent);
			oRet.TraegerField 	= oBeam;
		}
		
		if(oDlgLagerSession.Klemmsystem.strDialogId === 'LAGERSYSTEM'){
			oDlgLagerSession.Klemmsystem.strSelComboFunction = oDlgLagerSession.AuswahlStandard.strSelRadioFunction;
			oDlgLagerSession.Klemmsystem.bGaT				 = oDlgLagerSession.AuswahlStandard.bGaT;
			
			var oData 			= Klemmsystem.getDataAbhebesicherung(oDlgLagerSession);
			var oFunction 		= Controller.Lager.Common.AuswahlRollenlager.getFieldSetFunction(oDlgLagerSession,oData,'KLEMMSYSTEM');
			oRet.FunctionField  = oFunction;
			
			oRet.title 	= translate("LAGER_AUSWAHL_LAGERSYSTEM");		
		}
		else{
			//Function
			if(strEventId == 'ALL' || strEventId == 'FUNCTION_FC'){
				var aComboFunction 	= [
					['GEFUEHRT',translate("ID_FUEHRUNGSLAGER")],
					['LOSE',translate("ID_LOSLAGER")]
				];
				
				var aComboWidthBase = new Array();
				var sqlString 		= "select BREITE from KXX GROUP BY BREITE";
				var strDBCache 		= "KXX_TRAEGER";
				if ( dbselect( "LAGER2", sqlString, strDBCache ) ){
					while ( !dbiseof( strDBCache ) ){
						var strBreite = dbgetstring( strDBCache, "BREITE" );
						if((strBreite*1) == 0 && ((oDlgLagerSession.Klemmsystem.strSelComboFunction == 'LOSLAGER') || (oDlgLagerSession.Klemmsystem.strSelComboFunction == 'LOSE')))
							aComboWidthBase.push( [ 'SONST', translate("ID_SONSTIGE") ] );
						else if((strBreite*1) !== 0	)
							aComboWidthBase.push( [ strBreite, strBreite ] );
						dbskip( strDBCache );
					}
				}
				
				if(!Base.hasValueIntoArrayPositionNull(aComboWidthBase,oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport))
					oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport = aComboWidthBase[0][0];
			}	
			
			if(strEventId == 'ALL'){
				oFunction.combo =  [
					//Data Array, Selection Value , client Store Name, client ID
					//[aComboFunction,oDlgLagerSession.Klemmsystem.strSelComboFunction,'storeFunction','FUNCTION_FC'],
					[aComboFunction,translate('ID_' + oDlgLagerSession.Klemmsystem.strSelComboFunction),'storeFunction','FUNCTION_FC'],
					[aComboWidthBase,oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport,'storeFunction_LFUSS','FUNCTION_FC_LFUSS']
				];			
			}
			else if(strEventId == 'FUNCTION_FC'){
				oFunction.combo =  [
					[aComboWidthBase,oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport,'storeFunction_LFUSS','FUNCTION_FC_LFUSS']
				];		
			}
			else if (strEventId == 'FUNCTION_FC_GLT'){
				var aComboFunction 	= [
					['GEFUEHRT',translate("ID_FUEHRUNGSLAGER")],
					['LOSE',translate("ID_LOSLAGER")]
				];
				oFunction.combo =  [
					[aComboFunction,translate("ID_FUEHRUNGSLAGER"),'storeFunction','FUNCTION_FC']
					];
			}
			
			if(strEventId == 'ALL' || strEventId == 'FUNCTION_FC'){
				oFunction.checkbox = [
					['FC_AB',oDlgLagerSession.Klemmsystem.bUpliftRestraint],
					['FC_AB4',oDlgLagerSession.Klemmsystem.bUpliftRestraint4],
					['FC_GLT',oDlgLagerSession.Klemmsystem.bGaT]
				];
			}
			else if (strEventId == 'TRAEGER_ART' && oBeam.value.vTArt.length > 3){
				oFunction.checkbox = [
					['FC_AB4', false]
				]
			}
			
			oFunction.hide = [ 
				['FC_LFUSS_FORM' , (oDlgLagerSession.Klemmsystem.bGaT ? false : true)]				
			];
			
			if (strEventId == 'TRAEGER_ART' && oBeam.value.vTArt.length > 3){
				oFunction.disabled = [
					['FC_AB4', true]
				]
			}
			else{
				oFunction.disabled = [
					['FC_AB', ((oDlgLagerSession.Klemmsystem.strSelComboFunction == 'LOSLAGER') || (oDlgLagerSession.Klemmsystem.strSelComboFunction == 'LOSE') ? true : false)],
					['FC_AB4', (oDlgLagerSession.Klemmsystem.bUpliftRestraint ? false : true)]
				];
			}
			if(oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport == 'SONST')
				oFunction.valueNumberfield = [
					['LAGER_KLEMMSYSTEM_SONST_BREITE', oDlgLagerSession.Klemmsystem.dOtherWidthBaseOfTheSupport]
				]
			
			oRet.FunctionField 	= oFunction; 
			oRet.title	= translate("LAGER_KLEMMSYSTEM_GLEITLAGER");			
		}
		
		oRet.image	= __getPicture(oDlgLagerSession);
		oRet.hide   = [
			["LAGER_LAGERSYSTEM_FUNCTION",(oDlgLagerSession.Klemmsystem.strDialogId === 'LAGERSYSTEM') ? false : true], 
			["LAGER_KLEMMSYSTEM_FUNCTION",(oDlgLagerSession.Klemmsystem.strDialogId === 'LAGERSYSTEM') ? true : false],
			["LAGER_KLEMMSYSTEM_SONST_BREITE_FORM", (oDlgLagerSession.Klemmsystem.strSelComboWidthBaseOfTheSupport == 'SONST') ? false: true]
		];
		
		if(strEventId == 'ALL'){
			oRet.Table = {};
			var oCurrency 		= Base.Store.getWaehrungsData();
			var strPriceHeader 	= translate("TCH_PREIS")+"["+oCurrency.CURRENCY_UNIT+"]";
			oRet.Table.Header 	= [[5,strPriceHeader]];			
		}
		
		return oRet;
	}	 
});