/**
 * SAP_RFC - Klasse
 * Hier mal nach ECMA 4
 */
class SAP_RFC
{
	/**
	 * Plugin
	 * @var object
	 */
	var rfcPlugin;
	var rfcUtf8;
	
	/**
	 * Constructor
	 */
	function SAP_RFC(plugIn, exportClass)
	{
		this.rfcPlugin = new saprfc_plugin(plugIn, exportClass);
		this.rfcUtf8 = true;
	}
	
	function useUtf8Encoding(bUtfEnc) {
		this.rfcUtf8 = bUtfEnc;
	}
	
	
	/**
	 * Returns the plugin
	 * @return	object	plugin
	 */
	function getPlugin() {
		return this.rfcPlugin;
	}


	/**
	 * SAP Tabelle -> Script Tabelle
	 *
	 * @param
	 * @param
	 * @param
	 */
	function tableReader(filePath, tabFormat)
	{
		var resultTable = [];
		var nCols = tabFormat.length;
		
		var f = new FileStream(filePath, "rt");
		
		while( f.ok() )
		{
			var rowData = {};
			var row 	= f.readLine();
			var width, val, pos=0;
			
			for(var i=0 ; i<nCols ; i++)
			{
				width = tabFormat[i].width;

				if(this.rfcUtf8)	// Unicode/Utf8
					val = row.substringUtf8(pos, pos + width);
				else				// ANSI
					val = row.substring(pos, pos + width);
				
				rowData[tabFormat[i].name] = val;
				pos += width;
			}
			
			resultTable.push(rowData);
			rowData = null;
		}
		
		return resultTable;
	}

    
	function tableReaderCSV(filePath, tabFormat, strPrefix)
	{
		var resultTable = [];
		var nCols = tabFormat.length;
		
		var f = new FileStream(filePath, "rt");
		var lenPrefix = strlen(strPrefix);
        var nAnzColInString;
        
		while( f.ok() )
		{
			var rowData = {};
			var row 	= f.readLine();
			var width, val, pos=0;
			
            row = trimright(row, "\r\n");
            row = trimright(row, "\\r\\n");
            row = trimright(row, "\n");
            if ((strlen(row) == 0) ||
                (left(row, 2) == "//") ||
                (left(row, lenPrefix) != strPrefix))
                continue;

            delete("TMP.SPARFC.SPLITTER", "");
            nAnzColInString = stringtoarray(row, "TMP.SPARFC.SPLITTER.TABLE", ";");
                
			for(var i=0 ; i<nCols ; i++)
			{
				width = tabFormat[i].width;
                if (i > (nAnzColInString-1))
                    val = "";  // laut Format sollen Spalten dazu, aber kein Wert da ...
                else
                    val = getstring("VALUE", "TMP.SPARFC.SPLITTER.TABLE["+i+"]");
				
				rowData[tabFormat[i].name] = val;
				pos += width;
			}
			
			resultTable.push(rowData);
			rowData = null;
		}
		
		return resultTable;
	}


	/**
	 * Script Tabelle -> SAP Tabelle
	 *
	 * @param
	 * @param
	 * @param
	 * @return
	 */
	function tableWriter(filePath, tabFormat, inTable)
	{
		var nCols = tabFormat.length;
		var nLines = inTable.length;
			
		var f = new FileStream(filePath, "wt");
		
		for(var n=0 ; n<nLines ; n++)
		{
			var rowData = inTable[n];
			var width, fmt, fillc, fillpos, val;
			var row="";

			for(var i=0 ; i<nCols ; i++)
			{
				width 	= tabFormat[i].width;
				fmt 	= tabFormat[i].formatstr || '%s';
				fillc 	= tabFormat[i].fillchar || ' ';
                fillpos = tabFormat[i].fillpos  || 'r';
				
				val = rowData[tabFormat[i].name];
				// val = formatstring(val, fmt);
                val = sprintf(fmt, val);
				
				if(this.rfcUtf8) {	// Unicode/Utf8
					while(val.lengthUtf8 < width)
					{
						if (fillpos == 'r')
							val += fillc;
						else
							val = fillc + val;
					}
					val = val.leftUtf8(width);
				}
				else {				 // ANSI
					while(val.length < width)
					{
						if (fillpos == 'r')
							val += fillc;
						else
							val = fillc + val;
					}
					val = left(val, width);
				}
					
                // -mw- : warum das da: ????
				// val = val.substring(0, width-1);
				row += val;
			}
			
			f.writeLine(row);
		}
		
		f.close();
	}
	
	/**
	 * Returns Table Width
	 *
	 * @param
	 * @return
	 */
	function GetTableWidth(tabFormat)
	{
		var tabWidth = 0;
		var nCols = tabFormat.length;
		
		for(var i=0 ; i<nCols ; i++) {
			tabWidth += parseInt(tabFormat[i].width);
		}
		return tabWidth;
	}
}
