/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * Alle diese Funktionen sollten unbedingt in einem Util Namespace
 * gekapselt werden, da es gute Chancen gibt, dass spter mal jemand
 * seine Funktionen genau so nennt
 *
 */
function findInArray(value, myArray)
{
    for (var i = 0; i < myArray.length; i++)
    {
        if (myArray[i] == value)
            return i;
        else if (myArray[i].value)
        {
            if (myArray[i].value == value)
                return i;
        }
        
    }
    return -1;
}

function stringToSAP(myString)
{
    var bSapUTF = 1;
    if (bSapUTF)
        return (myString);
    
    return(utf8toansi(myString));
}
 
function getPathFromFilename(strFilename)
{
    var i, Ordner = "";
    for (i = strFilename.length; i > 0; --i)
        if (strFilename.charAt(i-1) == '\\')
            break;

    if (i > 0)
        Ordner = left(strFilename, i-1);
    return Ordner;
}

function replaceSpecialChars(strInput, oWas)
{
    var strOutput = strInput;
    if (oWas.FuerCSV)
        strOutput = strOutput.replace(";", ",");

    if (oWas.FuerDateiname)
    {
        strOutput = strOutput.replace(" ", "_");
        strOutput = strOutput.replace(";", "_");
        strOutput = strOutput.replace(",", "_");
        strOutput = strOutput.replace("+", "_");
        strOutput = strOutput.replace("", "_");
        strOutput = strOutput.replace(".", "_");
        strOutput = strOutput.replace("/", "_");
        strOutput = strOutput.replace("\\", "_");
        strOutput = strOutput.replace("?", "_");
        strOutput = strOutput.replace("*", "_");
        strOutput = strOutput.replace("&", "_");
        strOutput = strOutput.replace("%", "_");
        strOutput = strOutput.replace("$", "_");
        strOutput = strOutput.replace("", "_");
        strOutput = strOutput.replace("'", "_");
        strOutput = strOutput.replace("\"", "_");
    }
    
    return strOutput;
}
 
function atoi(input)
{
    var ret = atod(input);
    return int(ret);
}

// nk - Anzahl Nachkommastellen (-1: 0 rechts entfernen)
function atod(input, nk)
{
	input = input.replace("EX", "e");
	input = input.replace(",", ".");
    var ret = parseFloat(input);
	if(isNaN(ret)) return 0.0;

	var nNachKomma = 10;
	if(nk != null && nk > -1) nNachKomma = nk;

	// Zahl mit Nachkommastellen formatieren
    ret = ret.toFixed(nNachKomma);

	// 0 rechts entfernen, .0 bleibt
	if(nk == -1 && find(ret, ".") > 0)
	{
		var nLen = strlen(ret)-1;
		while(nLen > 1 && ret[nLen] == "0" && ret[nLen-1] != ".")
			nLen--;
		ret = left(ret, nLen+1);
	}
    return ret;
}

function atof(input, nk) { return atod(input, nk); }


function trimNumbersLeft(input)
{
    var ret;
	var strNum = parseFloat(input);
	if(isNaN(strNum))
		return input;
    ret = replace(input, strNum, "");
	if(ret == input)
	{
		if(find(strNum, ".") > -1)
			strNum = replace(strNum, ".", ",");
		else
			strNum = replace(strNum, ",", ".");
		ret = replace(input, strNum, "");
	}
    return ret;
}

function transWithUnit(id,unit)
{
    var ret = translate(id);
	var i = find(ret, unit);
	if(find(ret, "("+unit+")") > -1)
	{
		ret = replace(ret, "("+unit+")", "&#10;("+unit+")");
	}
	else if(find(ret, "["+unit+"]") > -1)
	{
		ret = replace(ret, "["+unit+"]", "&#10;["+unit+"]");
	}
	else
	{
		ret = ret + "&#10;("+unit+")";
	}
    return ret;
}

function getVarDelimited(arr, idx)
{
	if(idx >= arr.length)
		return "";
	return arr[idx];
}

function splitVarDelimiter(id,delim)
{
    var ret = [];
	var idx = 0;
	var i = 0;
	var buf;
	while(idx < strlen(delim) && i < strlen(id))
	{
		buf = "";
		for(; i < strlen(id) && id[i] != delim[idx]; i++)
			buf += id[i];
		ret[idx] = buf;
		idx++;
		i++;
	}
	if(i < strlen(id))
	{
		buf = substr(id, i+1, strlen(id));
		ret[idx] = buf;
	}

    return ret;
}

function RUNDEN(input)      // wird in STUECKLISTE benutzt, irgendwann ersetzen durch Round..
{
    return (fround(input, 0));
}

function PI()      // wird in STUECKLISTE benutzt
{
    // alert(Math.PI);
    return (Math.PI);
}

function RoundDoubleToInt(input)
{
    return (fround(input, 0));
}

function ground(val, stellen)
{
    // Runde double auf n signifikante (Vor- und Nach-)Kommastellen
    var res;
	var nachk;

    if (abs(val) < 10.0) nachk = stellen-1;
    else
    {	if (abs(val) < 100.0) nachk = stellen-2;
    	else
    	{	if (abs(val) < 1000.0) nachk = stellen-3;
    		else					nachk = stellen-4;
    	}
    }
    nachk = max(0,nachk);
    res = fround(val, nachk);
    return res;
}

function fround(val, dec)
{
    // Kommazahl auf anzStellen Nachkommastellen runden
	// Das produziert vermutlich Rundungsfehler
    // Math.ceil(val*Math.pow(10,dec))/Math.pow(10,dec);
	if (typeof val == "undefined")
		return 0;

	ret = parseFloat(val.toFixed(dec)); // toFixed, das liefert einen String zurck !!!
	return isNaN(ret) ? 0 : ret;
}

// Aufpassen jetzt !!!
// parseFloat liefert fr Strings die es nicht parsen kann
// ganz Standardkonform NaN. Deshalb kann man sich nicht mehr darauf
// verlassem dass hier dRet 0 ist nach dem parseFloat.
function inputStringToDouble(strVal)
{
    // @@@ Umwandlung Input-String in Zahl eventuell nach C++ ?
    // bessere Erkennung div. Eingaben, z.B. 1.234,78 vs. 1,234.78
    strVal = replace(strVal, ",", ".");
    var dRet = parseFloat(strVal);
    return isNaN(dRet) ? 0 : dRet;
}

// Aus Flexperte:
function Deg2Rad(/*double*/ degValue)
{
	if (degValue < 0.0 || degValue >= 360.0)
	{
        // @@@@@@@@ FloatModulo ... --> in EasySkript !?!?
		degValue = fmod(degValue,360.0);
	}
	return degValue * 3.14159265358 / 180.0;
}

function Rad2Deg(/*double*/ radValue)
{
	if (radValue < 0.0 || radValue >= 2.0 * 3.14159265358)
	{
        // @@@@@@@@ FloatModulo ... --> in EasySkript !?!?
		radValue = fmod(radValue,(2 * 3.14159265358));
	}
	return radValue * 180.0 / 3.14159265358;
}

function SinDeg(/*double*/ d)
{
	return sin(Deg2Rad(d));
}

function CosDeg(/*double*/ d)
{
	return cos(Deg2Rad(d));
}

function TanDeg(/*double*/ d)
{
	return tan(Deg2Rad(d));
}

function ArcSinDeg(/*double*/ d)
{
	return asin(Deg2Rad(d));
}

function compareInt(int1, int2)
{
    // @@@ parseInt erforderlich?
    if (int1 == int2)
        return 1;
    if (abs(int1 - int2) < 0.9)
        return 1;

    return 0;
}

// Spalte  0:		Index
// Spalte  1:		Typkuerzel
// Spalten 2-4:		Datentabellen mit Infos zum Produkt
// Spalte  5:		Klassenname
var theProduktInfoList = [
  [ "DEFAULT", "DEFAULT", "",     "",          "",			""],
  [ "FHG",     "FHG",  "FHG",     "",          "",			"Federhaenger"],
  [	"FHD",     "FHD",  "FHD",     "",          "",			"Federhaenger"],
  [	"FHS",     "FHS",  "FHS",     "",          "",			"Federhaenger"],
  [	"FSS",     "FSS",  "FST",     "",          "",			"Federhaenger"],
  [	"FSP",     "FSP",  "FST",     "",          "",			"Federhaenger"],
  [	"FSG",     "FSG",  "FSG",     "FSG_SPA",   "",			"Federhaenger"],
  [	"FDT",     "FDT",  "FDT",     "FDT_TRAV",  "",			"Federhaenger"],
  [	"KHD",     "KHD",  "KHD_EMA", "KHD_KMA",   "KHD_LGV",	"Konstanthaenger"],
  [	"KVD",     "KVD",  "KVD_EMA", "KVD_KMA",   "KVD_LGV",	"Konstanthaenger"],
  [	"KHS",     "KHS",  "KHS_EMA", "KHS_KMA",   "KHS_LGV",	"Konstanthaenger"],
  [	"KVS",     "KVS",  "KVS_EMA", "KVS_KMA",   "KVS_LGV",	"Konstanthaenger"],
  [	"KSR",     "KSR",  "KST_EMA", "KST_KMA",   "KST_BMA",	"Konstanthaenger"],
  [	"KSP",     "KSP",  "KST_EMA", "KST_KMA",   "KST_BMA",	"Konstanthaenger"],
  [	"LUR",     "LUR",  "LUR",     "",          "",			"Horizontalschelle"],
  [	"LUS",     "LUS",  "LUS",     "",          "",			"Horizontalschelle"],
  [	"LRN",     "LRN",  "LRN",     "",          "",			"Horizontalschelle"],
  [	"HZN",     "HZN",  "HZN",     "",          "",			"Horizontalschelle"],
  [	"HZV",     "HZV",  "HZV",     "",          "",			"Horizontalschelle"],
  [	"HZS",     "HZS",  "HZS",     "",          "",			"Horizontalschelle"],
  [	"HDN",     "HDN",  "HDN",     "HDN_MAS",   "",			"Horizontalschelle"],
  [	"HDV",     "HDV",  "HDV",     "HDV_MAS",   "",			"Horizontalschelle"],
  [	"HDS",     "HDS",  "HDS",     "HDS_MAS",   "",			"Horizontalschelle"],
  [	"HBN",     "HBN",  "HBN",     "HB_MAS",    "HBN_BOL",	"Horizontalschelle"],
  [	"HBV",     "HBV",  "HBV",     "HB_MAS",    "HBV_BOL",	"Horizontalschelle"],
  [	"HBS",     "HBS",  "HBS",     "HB_MAS",    "HBS_BOL",	"Horizontalschelle"],
  [	"HGN",     "HGN",  "HGN",     "HGN_MAS",   "HGN_MASSHERZ",	"Horizontalschelle"],
  [	"HGV",     "HGV",  "HGV",     "HGV_MAS",   "HGV_MASSHERZ",	"Horizontalschelle"],
  [	"TRG",     "TRG",  "",        "",          "",			""],
  [	"VBK",     "VBK",  "VBK",     "VBK_MAS",   "",			"Vertikalschelle"],
  [	"VKK",     "VKK",  "VKK",	  "VKK_MAS",   "VKK_GR",	"Vertikalschelle"],
  [	"VJK",     "VJK",  "VKK",	  "VKK_MAS",   "VKK_GR",	"Vertikalschelle"],
  [	"VJR",     "VJR",  "VKR",	  "VKR_MAS",   "VKR_GR",	"Vertikalschelle"],
  [	"VKR",     "VKR",  "VKR",	  "VKR_MAS",   "VKR_GR",	"Vertikalschelle"],
  [	"VSR",     "VSR",  "VSR",	  "VSR_VPR_MAS",   "",		"Vertikalschelle"],
  [	"VPR",     "VPR",  "VPR",	  "VSR_VPR_MAS",   "",		"Vertikalschelle"],
  [	"VGR",     "VGR",  "VGR",	  "VGR_MAS",   "",			"Vertikalschelle"],
  [	"ZGM",     "ZGM",  "ZGM",     "",          "",			"Zubehoer"],
  [	"ZGM",     "ZGI",  "ZGM",     "",          "",			"Zubehoer"],
  [	"ZGW",     "ZGW",  "ZGW",     "",          "",			"Zubehoer"],  
  [	"ZHM",     "ZHM",  "ZHM",     "",          "",			"Zubehoer"],
  [	"ZHM",     "ZHI",  "ZHM",     "",          "",			"Zubehoer"],
  [	"ZKN",     "ZKN",  "ZKN_LGV", "ZKN_MAS",   "",			"Zubehoer"],
  [	"ZKK",     "ZKK",  "ZKK_LGV", "ZKK_MAS",   "",			"Zubehoer"],
  [	"ZKB",     "ZKN",  "ZKN_LGV", "ZKN_MAS",   "",			"Zubehoer"],
  [	"ZLK",     "ZLK",  "ZLK",     "",          "",			"Zubehoer"],
  [	"ZLN",     "ZLN",  "ZLN",     "",          "",			"Zubehoer"],
  [	"ZLV",     "ZLV",  "ZLV",     "",          "",			"Horizontalschelle"],
  [	"ZLB",     "ZLB",  "ZLB",     "ZLB_LGV",   "",			"Horizontalschelle"],
  [	"ZLM",     "ZLM",  "ZLM",     "",          "",			"Zubehoer"],
  [	"ZLM",     "ZLI",  "ZLM",     "",          "",			"Zubehoer"],
  [	"ZMM",     "ZMM",  "ZMM",     "",          "",			"Zubehoer"],
  [	"ZMM",     "ZMI",  "ZMM",     "",          "",			"Zubehoer"],
  [	"ZOM",     "ZOM",  "ZOM",     "",          "",			"Zubehoer"],
  [	"ZOM",     "ZOI",  "ZOM",     "",          "",			"Zubehoer"],
  [	"ZPK",     "ZPK",  "ZPK",     "",          "",			"Zubehoer"],
  [	"ZRM",     "ZRM",  "ZRM",     "",          "",			"Zubehoer"],
  [	"ZRM",     "ZRI",  "ZRM",     "",          "",			"Zubehoer"],
  [	"ZSM",     "ZSM",  "ZSM",     "",          "",			"Zubehoer"],
  [	"ZSM",     "ZSI",  "ZSM",     "",          "",			"Zubehoer"],
  [	"ZTN",     "ZTN",  "ZTN_TYP", "ZTN_MAS",   "",			"Zubehoer"],
  [	"ZVN",     "ZVN",  "ZVN",     "ZVN_MAS",   "",			"Zubehoer"],
  [	"ZVV",     "ZVV",  "ZVV",     "ZVV_MAS",   "",			"Zubehoer"],
  [	"ZVS",     "ZVS",  "ZVS",     "ZVS_MAS",   "",			"Zubehoer"],
  [	"SON",     "SON",  "",        "",          "",			""],
  [	"ZZF",     "ZZF",  "ZZF",     "ZZF_P",     "",			"Zubehoer"],
  [	"ZZK",     "ZZK",  "ZZK",     "ZZK_P",     "",			"Zubehoer"],
  [	"MSN",     "MSN",  "MSN",     "",          "",			"Horizontalschelle"],
  [	"MSL",     "MSL",  "MSL",     "",          "",			"Horizontalschelle"],
  [	"MBS",     "MBS",  "MBS",     "",          "",			"Zubehoer"],
  [	"MBW",     "MBW",  "MBW",     "",          "",			"Zubehoer"],
  [	"SSG",     "SSG",  "SSG",     "SSG_SPA",   "",			"Federhaenger"],
  [	"SSG_PSS", "SSG",  "SSG_PSS", "",          "",			"Federhaenger"],
  [	"SSB",     "SSB",  "SSB_PSS", "SSB_NORM",  "",			"Federhaenger"],
  [	"SSB_PSS", "SSB",  "SSB_PSS", "SSB_NORM",  "",			"Federhaenger"],
  [	"SBV",     "SBV",  "SBV",     "",          "",			"Zubehoer"],
  [	"STF",     "STF",  "SPAL",    "",          "",			"Horizontalschelle"],
  [	"LTD",     "LTD",  "LTD",     "",          "",			"Horizontalschelle"]
];

function GetProduktTabelle(/* String */ typid, /* int */ tabnr)
{
    if ((tabnr < 1) || (tabnr > 3))
        return "";
    for(var i = 0; i < theProduktInfoList.length; i++)
    {
        if (theProduktInfoList[i][0] == typid)
            return theProduktInfoList[i][tabnr+1];
    }
    return("");
}

function GetKlassenname(/* String */ typid)
{
    for(var i = 0; i < theProduktInfoList.length; i++)
    {
        if (theProduktInfoList[i][0] == typid && theProduktInfoList[i][5] != "");
            return theProduktInfoList[i][5];
    }
	var klasse = '';
	/*
	if (typid == "LKG" || typid == "LSG" || typid == "LKF" || typid == "LSF" || typid == "LVG" || typid == "IKG" ||
		typid == "LKL" || typid == "LSL" || typid == "LVL" || typid == "IKL" || typid == "FLN" || typid == "FVN" ||
		typid == "FSN" || typid == "FSD" || typid == "FLV" || typid == "LUR")
	*/
	// Basistypen Flexperte 5
	if (typid == "LKF" || typid == "LSF" || typid == "LXF" ||	// Mehrfachfhrungen
		typid == "LKL" || typid == "LSL" || typid == "LXL" ||	// Loslager feste Hhe
		typid == "LKG" ||										// LKG 10
		typid == "LVL" || typid == "LVS" ||						// Loslager variable Hhe
		typid == "IKL" ||										// Loslager vorisoliert
		typid == "FLN" || typid == "FVN" || typid == "FLV" ||	// Festlager klemmbar
		typid == "FSN" || typid == "FSD")						// Festlager schraubbar
	{
		klasse = "Lager2";
	}
	else if ( ( typid == "KZT" ) || ( typid == "KAT" ) || ( typid == "KOT" ) || ( typid == "KOU" ) || ( typid == "KOL" ) ||
			  ( typid == "KZU" ) || ( typid == "KZL" ) || ( typid == "KLT" ) || ( typid == "KOT" ) || ( typid == "KLU" ) ||
			  ( typid == "KLL" ) )
		klasse = "Klemmsystem2";
	else if ( ( typid == "LAW" ) )
		klasse = "Abhebesicherung2";
	//else if ( ( typid == "LGV" ) || ( typid == "LGA" ) )
	
	//@@@ LGE Test
	else if ( ( typid == "LGV" ) || ( typid == "LGA" ) || (typid == "LGE") )
		klasse = "Gleitelement2";
	
    return(klasse);
}

function GetRADfromNennweite(/* int */ iNennweite)
{
	var strSQLStatement = "select * from ROHRD WHERE NENNWEITE="+iNennweite;
	var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
	if (numRet > 0)
		return replace(dbgetstring("ROHRD", "D"), ",", ".");
	return 0.0;
}

function GetNextNennweiteFromRAD(/* int */ iRad)
{
	var retObj = {  success: true,
					setStdDN: false,
					DN:	"",
					D: ""
					};
	var toleranz = 0;
	var numRet = dbselect("CASCADE", "select * from DELDA_D WHERE abs(D_BIS)>="+iRad+" order by abs(D_BIS) ", "DELDA")
	if (numRet > 0)
		toleranz = dbgetdouble("DELDA", "DEL_D");

	var strSQLStatement = "select * from ROHRD WHERE abs(D)>" + (iRad-toleranz) + " order by abs(NENNWEITE)";
	var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD")
	if (numRet > 0)
	{
		retObj.DN = dbgetstring("ROHRD", "NENNWEITE");
		retObj.D  = dbgetstring("ROHRD", "D");
		var actD  = dbgetdouble("ROHRD", "D");
		if (abs(iRad - actD) <= toleranz)
			retObj.setStdDN = true;
	}
	else
		retObj.success = false;
		
	return retObj;
}

function berechneNettoPreis(dPreis, strRabatt)
{
    if (dPreis <= 0)
        return dPreis;

    var dRabattFaktor = inputStringToDouble(strRabatt);

    if (dRabattFaktor < 1)
        return dPreis;
    else if (dRabattFaktor >= 100)
        return 0;
    else
    {
        var dNettoPreis = fround(dPreis * (1 - (dRabattFaktor / 100)), 2);
        return dNettoPreis;
    }

}

function serializeInObject(/* String */ strPath, /* String */ strObjLocation)
{
    var myObject = null;
    var strClassName = getstring("__CLASSNAME__",strPath + "." + strObjLocation)
    if (strClassName != "")
    {
        var strClassVariable = eval(strClassName);
        if (typeof strClassVariable == "undefined")
        {
            // throw new EasyKat.Controller.Dispatcher.Exception("Controller \"" + className + "\" is not an instance of EasyKat.Controller.Action.");
            // Log schreiben ???
            return null;
        }
        else
        {
            myObject = new strClassVariable();
            myObject.serializeIn(strPath + "." + strObjLocation);
        }
    }
    return myObject;
}

function trimWhite(strString)
{
	strString = trimleft(trimright(strString, " "), " ");
	strString = trimleft(trimright(strString, "\t"), "\t");

	return strString;
}


