/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007-2008 Plan Software GmbH (http://www.plansoft.de)
 */


CaTypsucheManager = function(myMainController)
{
	/**
     * myMainController ... Verweis auf einen MainController
     * @var myMainController
     */
	this.myMainController = myMainController;

	this.bError   = false;
	this.msgOK    = translate("Typnummer korrekt angegeben !");
	this.msgError = '';
};


CaTypsucheManager.prototype =
{

	/**
		Analysiere einen Typenschlssel, schreibe die Ergebnisse in DLGDATA
	*/
    analysiereTypnummer : function(strTyp)   {
        delete("", "DLGDATA");

		var oRes = this.createProductFromTyp(strTyp);
		if (oRes.msg != '') {
			this.bError   = true;
			this.msgError = oRes.msg;
			return;
		}

		strTyp = oRes.oProduct.m_Ptyp;
		this.msgOK = "Typnummer " + strTyp + " korrekt !";

		// Produktdaten
		var retObj = oRes.oProduct.getASTLDaten(caMainController);
		var strDescr = "", strDescrShort = "";
		for (j=0; j < retObj.aTexte.length; j++)
		{
			if(retObj.aTexte[j] != "")
				strDescr += retObj.aTexte[j] + "<br>";
			if(j==1) strDescrShort = strDescr;
		}
		strDescr = left(strDescr, strlen(strDescr)-4);
		if (strDescrShort == "") 
			strDescrShort = strDescr;
		if (right(strDescr, 4) == "<br>") 
			strDescr = left(strDescr, strlen(strDescr)-4);
		if (right(strDescrShort, 4) == "<br>") 
			strDescrShort = left(strDescrShort, strlen(strDescrShort)-4);
		if (strDescr == "") {
			strDescr      = strTyp;
			strDescrShort = strTyp;
		}

		// Hier steht die aktuelle Zeile einer zu importierendenn Typenschlsseldatei, soweit vorhanden ...:
		var	strPathToImportfile = arraypath("TEMP.TYPNUMMERDATEN", getint("TYPNUMMER_WORK_INDEX", "TEMP"));
		//var aDaten = this.getVariousPosinfos(strPathToImportfile, strDescr, strDescrShort, oRes.oProduct.matnr);
		var aDaten = this.getVariousPosinfos(strPathToImportfile, strDescr, strDescrShort, retObj.matnr);

		// Ergebnistabelle erweitern
		// Hier steht die angezeigte Liste im Reiter Typenschlsselanalyse mit den Checkboxen, was bernommen werden soll:
		var nPos 	= getsize("TEMP.TYPNUMMER_ITEMS", "");
		var Target 	= "TEMP.TYPNUMMER_ITEMS[" + nPos + "]";

		// Produkt in die temporre Projektliste einfgen
		var aDaten = this.addProductToTmpProjectlist(oRes.oProduct, Target, aDaten, nPos);


	},

	createProductFromTyp : function(strTyp, bHaengerDurchlaufen)
	{
		var oRet = {
			msg:      '',
			oProduct: null 
		}
		
		if(strlen(strTyp) <= 5)		{
			oRet.msg  = "Typnummer " + strTyp + " *** unvollstaendig !";
			return oRet;
		}

		var strTyp3 = left(strTyp, 3);
		var klasse = GetKlassenname(strTyp3);

		if(klasse == "")		{
			oRet.msg = "Typnummer " + strTyp + " *** UNBEKANNTES PRODUKT !";
			return oRet;
		}

		if (find(strTyp, " ") == -1) {
			oRet.msg = "Typnummer ("+klasse+") " + strTyp + " *** NICHT korrekt !";
			return oRet;
		}

		var topKlasse = eval(klasse);
		if (typeof topKlasse == "undefined" || ! topKlasse) {
			oRet.msg = "Typnummer ("+klasse+") " + strTyp + " *** NICHT korrekt !";
			return oRet;
		}

		var produktObjekt = new topKlasse();

		// analysieren - Leerstring=OK sonst Meldung als Rckgabe mglich oder "*"
		//var sOK = produktObjekt.fromTyp(strTyp);
		var sOK = produktObjekt.fromTyp(strTyp, bHaengerDurchlaufen);
		if (sOK != "") {
			oRet.msg = "Typnummer " + strTyp + " (" + klasse + ")";
			if(sOK != "ERR")
				oRet.msg += "\r\n" + translate("Fehler") + ": " + sOK;
			else
				oRet.msg += " *** unvollstaendig !";
			delete("", "DLGDATA");
			return oRet;
		}
		
		oRet.oProduct = produktObjekt;

		return oRet;
	},
	
	getVariousPosinfos : function(strPathToImportfile, strDescr, strDescrShort, matnr)
	{

		// zustzliche Daten pro Typnummer aus Datei vorhanden ?
		var bFileImport = ((getstring("IMPORT_FILE_NAME", "TEMP") != "") && (strPathToImportfile != ""));

		// Daten aus der Importdatei oder Default bei manueller Eingabe
		var aDaten  = {
				qty:			bFileImport ? getint   ("VALUE", arraypath(strPathToImportfile, 1)) : 1,
				preis1: 		bFileImport ? getdouble("VALUE", arraypath(strPathToImportfile, 2)) : 0.00,
				preis2: 		bFileImport ? getdouble("VALUE", arraypath(strPathToImportfile, 3)) : 0.00,
				preis3:			bFileImport ? getdouble("VALUE", arraypath(strPathToImportfile, 4)) : 0.00,
				customer_code:	bFileImport ? getstring("VALUE", arraypath(strPathToImportfile, 5)) : "",
				markierung: 	bFileImport ? getstring("VALUE", arraypath(strPathToImportfile, 6)) : getstring("MARKIERUNG_STUECK", "TEMP"),
				matnr:			matnr,
				ordercode: 		strDescr,
				ordercodeshort: strDescrShort,
				calc_preis: 	0
			};

		// Sicherheitscheck:
		if (bFileImport)	{
			aDaten.qty    = (aDaten.qty == null || aDaten.qty == 0) ? 1 : aDaten.qty;
			aDaten.preis1 = (aDaten.preis1 == null || aDaten.preis1 == 0) ? atod(prod.m_Ppreis,2) : aDaten.preis1;
			aDaten.preis1 = (aDaten.preis1 == null) ? 0 : aDaten.preis1;
			aDaten.preis2 = (aDaten.preis2 == null) ? 0 : aDaten.preis2;
			aDaten.preis3 = (aDaten.preis3 == null) ? 0 : aDaten.preis3;
			aDaten.customer_code = (aDaten.customer_code == null) ? "" : aDaten.customer_code;
			aDaten.markierung    = (aDaten.markierung == null) ? "" : trimleft(aDaten.markierung, " ");
		}
		
		return aDaten;
	},
	
	/**
		bernehme eine Auswahl in die Vorschau-Tabelle der bersetzten Typenschlssel, woebei der Zielpfad frei whlbar ist
	*/
	uebernehmeAuswahlInTabelle : function(strTargetpath)
	{
		delete("", strTargetpath);
		copy("DLGDATA", strTargetpath);
		setstring("PROJECT.SETTINGS.PROJ_MODIFIED_FLAG", "", "MODIFIED");		
	},
	
	/**
		Parameter "info" ist nur belegt, wenn eine Datei mit Typenschlsseln eingelesen wurde; diese enthlt dann weitere Infos 
	*/
	addProductToTmpProjectlist : function(prod, Target, aDaten, nPos)
	{
		// zustzliche Daten pro Typnummer vorhanden ?
		var bFileImport = (getstring("IMPORT_FILE_NAME", "TEMP") != "");

		var strDlgdata = "DLGDATA";
		var strForms   = "DLGDATA.CA.FORMS";

		setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", strForms, "");
		setstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR",  strForms, "");
		setstring("UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN",    strForms, "");
		if ((getstring("IDC_AS_MARKIERUNG_CHECK","")=="true") && (aDaten.markierung != ""))
			setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", strForms, aDaten.markierung);
		// Zeichnungsnummer
		if ((getstring("IDC_AS_ZEICHNUNGSNR_CHECK","")=="true") && (aDaten.markierung != ""))
			setstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", strForms, aDaten.markierung);

		var topo = new CaTopoEinzel(caMainController.dataAccess, caMainController.presets);
		var tmpCaMainController = new CaController();

		tmpCaMainController.topologieKlasse = topo;

		// 20.08.08 mb Daten bernehmen
		if(prod.a_lgv) tmpCaMainController.topologieKlasse.a_lgv = prod.a_lgv;
		else if(prod.lgv) 	tmpCaMainController.topologieKlasse.a_lgv = prod.lgv;
		else if(prod.m_strLGG) 	tmpCaMainController.topologieKlasse.a_lgv = prod.m_strLGG;

 		if(prod.isHaenger() || prod.isStuetze())
		{
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", strForms, "EINZEL_HAENGER");
			setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", strForms, "HORIZONTAL");
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", strForms, "HAENGEND_EINFACH");

            setstring("IDC_BESCHICHTUNG", "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER", "OHNE");
            setstring("IDC_BLOCKIERUNG",  "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER", "BLOCK_MITTIG");
            
            if(prod.isStuetze())
			{
				setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", strForms, "STUETZEND_EINFACH");
			}
			else if(prod.m_Ptypid == "SSG")
			{
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", strForms, "EINZEL_HAENGER");
				//setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", strForms, "GELENKSTREBE");
				setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", strForms, "STUETZEND_EINFACH");
			}
            else if(prod.m_Ptypid == "FDT")
			{
				setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", strForms, "HAENGEND_DOPPEL");
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", strForms, prod.spannweite);
			}

			tmpCaMainController.topologieKlasse.Haenger = prod;
			tmpCaMainController.topologieKlasse.bHaenger = 1;
            
            tmpCaMainController.setHaengerOptions("OHNE", prod.m_Pblock, "FROM_TYPSUCHE");
            tmpCaMainController.topologieKlasse.initHaenger(prod.m_Ptypid, prod.spannweite);

            var LKMatInfo = tmpCaMainController.topologieKlasse.getLastkettenIdent(tmpCaMainController);    
            var strDescr = "";
			for (j=0; j < LKMatInfo.aTexte.length; j++)
			{
				if(LKMatInfo.aTexte[j] != "")
					strDescr += LKMatInfo.aTexte[j] + "<br>";
            }
            aDaten.matnr 		  	= LKMatInfo.matnr;
            aDaten.ordercode 		= strDescr;
            aDaten.ordercodeshort 	= LKMatInfo.aTexte[0] + "<br>" + LKMatInfo.aTexte[1];
		}
		else if(prod.isSchelle() && (! prod.isLager()))
		{
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", strForms, "EINZEL_SCHELLE");
			if(prod.isHschelle())
			{
				setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", strForms, "HORIZONTAL");
			}
			else
			{
				setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", strForms, einbaumass);
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", strForms, ""+prod.spannweite);
			}
			tmpCaMainController.topologieKlasse.Schelle = prod;
			tmpCaMainController.topologieKlasse.bSchelle = 1;
		}
		else if(prod.isLager())
		{
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", strForms, "EINZEL_LAGER");
			tmpCaMainController.topologieKlasse.Lager = prod;
			tmpCaMainController.topologieKlasse.bLager = 1;
		}
		else
		{
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", 	strForms, "EINZEL_ZUBEHOER");
			setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", 	strForms, "HORIZONTAL");
			setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", strForms, "HAENGEND_EINFACH");
			tmpCaMainController.topologieKlasse.Zubehoer = prod;
			tmpCaMainController.topologieKlasse.bZubehoer = 1;
		}


        var stkList = [];
        var oOptions = tmpCaMainController.presets.getPreisOptions();
        tmpCaMainController.dataAccess.setSollwerteEinfuegepunkt("vertikal", 0);
        tmpCaMainController.topologieKlasse.berechneSystemmassInitial();
        tmpCaMainController.topologieKlasse.getStueckliste(stkList);
        tmpCaMainController.topologieKlasse.bestimmeMutternPreiseGewichte(stkList, true);               // bestimmt Preis-Status
        tmpCaMainController.topologieKlasse.getStuecklisteForDisplay(oOptions, tmpCaMainController);    // bestimmt Matnr-Status
		tmpCaMainController.topologieKlasse.serializeOut("DLGDATA.CA.SELECTION.TOPOCLASS");

		aDaten.calc_preis = tmpCaMainController.topologieKlasse.gesamtPreis;

		// Preis "Eingabe" auf ber.Preis setzen
		if(!bFileImport)
			aDaten.preis1 = aDaten.calc_preis;

		// Ergebnistabelle
		// short ist spter Volltext
		setstring("POS", 			 	  	strDlgdata, ((nPos + 1)*10));
		setstring("IMPORT_CHECK", 	 	  	strDlgdata, "true");
		setstring("SHORTTEXT",				strDlgdata, aDaten.ordercode);
		setstring("ORDERCODE",				strDlgdata, "Typsuche<br>" + (aDaten.markierung!="" ? aDaten.markierung+"<br>" : "") + aDaten.ordercode);
		setstring("ORDERCODE_SHORT", 	  	strDlgdata, aDaten.ordercodeshort);
		setstring("ORDERCODE_PROJECTLIST",	strDlgdata, aDaten.ordercodeshort);
		setstring("IDENT",					strDlgdata, aDaten.matnr);
		setstring("CUSTOMER_CODE",			strDlgdata, aDaten.customer_code);
		setstring("MARKIERUNG",				strDlgdata, aDaten.markierung);
		setstring("QTY",					strDlgdata, aDaten.qty);
		setstring("STATUS_PREIS",			strDlgdata, tmpCaMainController.topologieKlasse.preisStatus);
		setstring("STATUS_MATNR",			strDlgdata, tmpCaMainController.topologieKlasse.matStatus);
		setdouble("DUNITWEIGHT",			strDlgdata, tmpCaMainController.topologieKlasse.gesamtGewicht);
		setdouble("DUNITPRICE",				strDlgdata, atof(aDaten.preis1, 2));
		setstring("UNITPRICE",				strDlgdata, atof(aDaten.calc_preis, 2));
		setstring("UNITPRICE_ALL_INCLUDED",	strDlgdata, atof(aDaten.calc_preis, 2));
		setstring("FORCEDUNITPRICE",		strDlgdata, "");
		setstring("POSPRICE",				strDlgdata, atof((aDaten.qty * aDaten.preis1) + aDaten.preis2 + aDaten.preis3, 2));
		setstring("POSPRICE_MINUSADDED",	strDlgdata, atof(aDaten.preis1, 2));
        if (aDaten.preis2 > 0)
            setstring("INT_ACCEPT_SET_PRICE",	strDlgdata, atof(aDaten.preis2, 2));
        else
            setstring("INT_ACCEPT_SET_PRICE",	strDlgdata, "");
        if (aDaten.preis3 > 0)
            setstring("EXT_ACCEPT_SET_PRICE",	strDlgdata, atof(aDaten.preis3, 2));
        else
            setstring("EXT_ACCEPT_SET_PRICE",	strDlgdata, "");
		setdouble("DADDEDPOSPRICE",				strDlgdata, atof(aDaten.preis1));
		setstring("CACHE_DRAWING_FILE_PDF",		strDlgdata, "");
		setstring("CACHE_DRAWING_FILE_PDF_SAP",	strDlgdata, "");
		setstring("CACHE_DRAWING_FILE_DXF",		strDlgdata, "");

		// Wichtig: den letzten Screen merken, der zu diesem Weg gefhrt hat:
		setstring("MODIFY_ENTRY_SCREEN", 		strDlgdata, "IDD_TYPNUMMER");    // ndern nicht erlaubt!
		
		// Sowie den Produktbereich (welcher "Experte" ist zustndig?)
		setstring("PRODUCT_AREA", 				strDlgdata, "CA")
		setstring("PRODUCT_AREA_SOURCE", 		strDlgdata, "Typsuche")

		// Kopiert das Produkt aus DLGDATA in PROJECT.POSITIONS..., als neue oder genderte Position
		// specialexec("UebernehmeAuswahlInProjektliste");
		// Jetzt neu, kopiere nur nach "TEMP.TYPNUMMER_ITEMS" ...  Von dort kann man dann spter direkt in die Projektliste kopieren ...:
		this.uebernehmeAuswahlInTabelle(Target);

		return aDaten;
	}

};
