/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoStuetzend = function(pdataAccess, ppresets)
{
	CaTopoStuetzend.superclass.constructor.call(this, pdataAccess, ppresets);
	    
    // Die Infos zur den Bauteilen der Lastkette:
    this.Haenger        = null;
    this.Schelle        = null;     //-mw- @@@ prfen: wo wird explizit auf Schelle verwiesen ... Hier ist das Lager bei Einzel, die Schelle bei Doppelt belegt!
    this.Zwischenstueck = null;
	// this.Lager 			= null; -mw- 21.5.2012 auskommentiert
	this.bLager 		= false;
	this.TopoLager2 	= null;		// -mw- 21.5.2012 neu - fr das Lager auf der EINZELNEN Sttze 

    this.DrehungUL      = 0;
    this.DrehungUR      = 180;
    var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
	if (AchsDirInfo[9]	!= "LG_Var1")
		this.DrehungO       = 0;
	else
		this.DrehungO       = 90;
};

EasyKat.extend(CaTopoStuetzend, CaTopo, {

    serializeIn : function(strPath) 
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) != "CaTopoStuetzend")
        {   
            // ist noch nichts da
            return 0;     
        }

        // Oberklasse hier auch aufrufen
        CaTopo.prototype.serializeIn.call(this, strPath);       
        
        // Objekte einlesen:
		// serializeIn ist eine Methode
		// serializeInObject ist eine globale Funktion
        this.Haenger            = serializeInObject(strPath, "Haenger");
        this.Schelle            = serializeInObject(strPath, "Schelle");
        this.Zwischenstueck     = serializeInObject(strPath, "Zwischenstueck");
        // this.Lager			    = serializeInObject(strPath, "Lager");
		this.TopoLager2 = serializeInObject(strPath, "TopoLager2");
		
		this.DrehungUL      = getdouble("DrehungUL",strPath);
        
		this.DrehungUR      = getdouble("DrehungUR",strPath);
        /*
		var RVektor = (getstring('pipeorient', 'DLGDATA.CA.FINDATA.FINOBJECT.pipe')).split(' ');
        
		var KSVariante	= getstring("KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var KSVertikale	= right(left(getstring("KOORD_IMG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 11), 1);
		var KSRohrachse	= left(getstring("IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 1);
		
		var KSrot	=	90;
		if (KSVertikale == "Z" && KSRohrachse =="X" && (KSVariante == "Var1" || KSVariante == "Var3"))
			KSrot	=	0;
		else if (KSVertikale == "Y" && KSRohrachse =="Z" && (KSVariante == "Var1" || KSVariante == "Var3"))
			KSrot	=	0;
		else if (KSVertikale == "X" && KSRohrachse =="Y" && (KSVariante == "Var1" || KSVariante == "Var3"))
			KSrot	=	0;
		
		if ((abs(RVektor[1]) == 1) || KSrot == 90)
			this.DrehungO		= 90;
		else
			this.DrehungO       = getdouble("DrehungO",strPath);
		*/
		this.bLager = getbool( 'bLager', strPath );

        return 1;
    },

    serializeOut : function(strPath) 
	{
        // Erstmal vorherige Daten wegputzen ...
        delete(strPath, "");
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoStuetzend");

        CaTopo.prototype.serializeOut.call(this, strPath);
        
        // Objekte:
        if (this.Haenger)
            this.Haenger.serializeOut(strPath + ".Haenger");
        if (this.Schelle)
            this.Schelle.serializeOut(strPath + ".Schelle");
        if (this.Zwischenstueck)
            this.Zwischenstueck.serializeOut(strPath + ".Zwischenstueck");
		if ( this.TopoLager2 )
			this.TopoLager2.serializeOut( strPath + ".TopoLager2" );

        setdouble("DrehungUL",        strPath, this.DrehungUL);
        setdouble("DrehungUR",        strPath, this.DrehungUR);
        //setdouble("DrehungO",         strPath, this.DrehungO);
		var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
		if (AchsDirInfo[9]	!= "LG_Var1")
			setdouble("DrehungO", strPath, 0);
		else
			setdouble("DrehungO", strPath, 90);
		
		setbool( "bLager", strPath, this.bLager );
    },
    
    getLastkettenIdent : function(theMainController)
    {
        var bFHaenger = 0;
        if (this.Haenger && this.Haenger.isFHaenger())
            bFHaenger = 1;
        return this.getLastkettenIdentGeneric(theMainController, bFHaenger);
    },
    
    getCurrentHaenger : function()
    {
        return(this.Haenger);
    },
    
    setHaenger : function(myHaenger)
    {
        this.Haenger = myHaenger;
    },
    
    initHaenger : function(strSelectedHaenger, nSpannweite)
    {
        if (this.Haenger)
            this.Haenger.Selected(strSelectedHaenger, nSpannweite, /*bErstmals*/ 1);
        return (1);
    },
    
    setOberenAnschluss : function(strSelectedTeil)
    {
        return;
    },
    
    getEinzelprodukt : function() 
    {
        return null;    // kommt hier nicht vor, immer Lastkette
    },
        
    getLager : function() 
    {
        return( this.Lager );
    },
    
    setLager : function( oLager ) 
    {
        this.Lager = oLager;
    },
    
	/**
     *  Basis-Navigationsfunktion
     */

	getNextPanel : function(activePanel) 
    {
		var nextPanel       = {};
        var lkTyp           = this.dataAccess.getLastketteTyp();
        var bSchelle        = this.dataAccess.getLastketteMitSchelle();
		// Lager in dieser Topologie nur bei beweglich, horizontal, sttzend einfach
		var bLager = this.dataAccess.isLastketteMitLagerMoeglich();

		this.bLager = false;
        switch(activePanel) 
        {
            case 'systemcharakteristik':
                nextPanel = CaPanels.sollwerte_halterungspunkt;
                break;
            case 'sollwerte_halterungspunkt':
                nextPanel = CaPanels.auswahl_haengergroesse;
                break;
            case 'auswahl_haengergroesse':
			// 	 nextPanel = CaPanels.konfiguration_haenger;	// -Schu- Haengerkonfig nur ueber CascadePresets gesteuert
				// - Sch 100329 - sontst kommen die Info-Texte nicht (wurde sonst im KofigurationHaengerController festgelegt)
					if (getstring ("ACT_SELECTED_HANGERTYPE","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE") == "F")
					{
						var strBeschichtung = getstring("TERROSON_FH","PROJECT.SETTINGS.CASCADE");
						if (strBeschichtung == "true")
							strBeschichtung = "TERROSON";
						else
							strBeschichtung = "";
							
						var strBlockierung  = getstring("FH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
						if (strBlockierung == "IDC_FH_BLOCKMITTIG_RADIOBUTTON")
							strBlockierung = "BLOCK_MITTIG";
						else if (strBlockierung == "IDC_FH_BLOCKNEIN_RADIOBUTTON")
							strBlockierung = "BLOCK_NEIN";
						else
							strBlockierung = "BLOCK_JA";
					}
					else
					{
						var strBeschichtung = getstring("TERROSON_KH","PROJECT.SETTINGS.CASCADE");
						if (strBeschichtung == "true")
							strBeschichtung = "TERROSON";
						else
							strBeschichtung = "";
							
						var strBlockierung  = getstring("KH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
						if (strBlockierung == "IDC_KH_BLOCKMITTIG_RADIOBUTTON")
							strBlockierung = "BLOCK_MITTIG";
						else if (strBlockierung == "IDC_KH_BLOCKNEIN_RADIOBUTTON")
							strBlockierung = "BLOCK_NEIN";
						else
							strBlockierung = "BLOCK_JA";
					}
				caMainController.setHaengerOptions(strBeschichtung, strBlockierung, "FROM_DIALOG");
				nextPanel = CaPanels.auswahl_haengertyp;
                break;
            //case 'konfiguration_haenger':
            //    nextPanel = CaPanels.auswahl_haengertyp;
            //    break;
            case 'auswahl_haengertyp':
                if ( bLager && bSchelle )
				{
					this.bLager = true;
					//-- 21. Mai 2012 Umlenken der Dialoge
					// vor dem Wechsel zum Lagerdialog werden die Werte vorbelegt
					// this.dataAccess.LagerDaten.setzeStartwerteFuerBetriebsbedingungen();
					// nextPanel = CaPanels.lager_betriebsbedingungen;
					this.TopoLager2 = new CaTopoLager2 ( this.dataAccess, this.presets );
					nextPanel = {
						'id': 'lager.sollwerte_rohrumschliessendesteil',
						'title': translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL')
					};		
					/////////////////////////////////////////////////////////////////////////////////
					//setze Default Werte fr DialogObject
					var oForms				= Base.Store.getForms();
					var oFormsSystemchar	= oForms.SYSTEMCHARAKTERISTIK;
					var oFormsSollwertHal	= oForms.SOLLWERTE_HALTERUNGSPUNKT;
					var oFormsHaengertyp	= oForms.AUSWAHL_HAENGERTYP;
					var oDlgSessionLager 	= this.TopoLager2.getDlgLagerSession();
					
					oDlgSessionLager.bLastKettePathSelection = true;
					
					var oUpdateSystemchar 	= oDlgSessionLager.Systemcharakteristik;
					var oUpdateSollwertHal	= oDlgSessionLager.SollwerteHalterungspunkt.oTable;
					
					oUpdateSystemchar.strSelRadioRohrichtung 	= 'LAGER_'+oFormsSystemchar.IDC_ROHRRICHTUNG;
					oUpdateSystemchar.strSelRadioRohrverlauf 	= 'LAGER_'+oFormsSystemchar.IDC_ROHRVERLAUF;
					oUpdateSystemchar.dAlpha					= oFormsSystemchar.SCHRAEG_ALPHA ? oFormsSystemchar.SCHRAEG_ALPHA : 0;
					oUpdateSystemchar.dBeta						= oFormsSystemchar.SCHRAEG_BETA ? oFormsSystemchar.SCHRAEG_BETA: 0;
					
					if((oFormsSystemchar.IDC_LASTABTRAGUNG == 'HAENGEND_DOPPEL') || (oFormsSystemchar.IDC_LASTABTRAGUNG == 'STUETZEND_EINFACH')){
						if ((oFormsHaengertyp.IDC_IMAGE_ID == 'FSP') ||
							(oFormsHaengertyp.IDC_IMAGE_ID == 'KSP'))
							oUpdateSystemchar.strSelRadioLager = 'LAGER_EPG';
						else
							oUpdateSystemchar.strSelRadioLager = 'LAGER_SSG';
					}
					else
						alert("Das sollte nicht vorkommen: "+oFormsSystemchar.IDC_LASTABTRAGUNG);
					
					//Tabelle update
					var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
					oUpdateSollwertHal	= {
						'last_plus' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[6]]
						},
						'zusatzlast' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[6]]
						},
						'last_minus' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[6]]
						},
						'ueberlast' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[6]]
						},
						'bewegung_plus' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[6]]
						},
						'bewegung_minus' : {
							'axial' 	: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[7]],
							'quer'		: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[8]],
							'schief' 	: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[6]]
						}
					}
					oDlgSessionLager.SollwerteHalterungspunkt.oTable = oUpdateSollwertHal;
				}				
                else if (bSchelle)
                    nextPanel = CaPanels.sollwerte_rohrumschliessendes_teil
                else if (this.bVertikal)
                    nextPanel = CaPanels.sollwerte_spannweite;
                else
                    nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'sollwerte_spannweite':
                nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'sollwerte_rohrumschliessendes_teil':
                nextPanel = CaPanels.auswahl_schelle;
                break;
            case 'auswahl_schelle':
				/*
				if ( bLager )   // -mw- das kann raus, wenn aktueller weg funktioniert
				{
					this.bLager = true;
					// vor dem Wechsel zum Lagerdialog werden die Werte vorbelegt
					this.dataAccess.LagerDaten.setzeStartwerteFuerBetriebsbedingungen();
					nextPanel = CaPanels.lager_betriebsbedingungen;
				}
                else
				*/
				nextPanel = CaPanels.uebersicht_lastkette;
                break;
			case 'lager_betriebsbedingungen':
				this.bLager = true;
                nextPanel = CaPanels.lager_auswahl;  
				break;
			case 'lager_auswahl':
				this.bLager = true;
				if ( this.Lager && this.Lager.isHoehenverstellbar() )
					nextPanel = CaPanels.lager_hoeheneingaben;  
				else if ( this.Lager && this.Lager.isConfigurable() )
					nextPanel = CaPanels.lager_konfiguration;  
				else nextPanel = CaPanels.uebersicht_lastkette;  
				break;
			case 'lager_hoeheneingaben':
				this.bLager = true;
				if ( this.Lager && this.Lager.isConfigurable() )
					nextPanel = CaPanels.lager_konfiguration;  
				else nextPanel = CaPanels.uebersicht_lastkette;  
				break;
			case 'lager_konfiguration':
			case 'neue_lagerauswahl_fertig':
				this.bLager = true;
				nextPanel = CaPanels.uebersicht_lastkette;  
				break;
            default:
                nextPanel = {};
                break;
        }

        // Hier immer ein CleanUp fr alles ab einschlielich dem next Panel
        // durchfhren (wichtig, auch fr bersprungene Dialoge):
        this.cleanUp(nextPanel.id);
        
        // Ausnahmsweise: Initialisierung eines Dialogs hier
        if (nextPanel.id == 'uebersicht_lastkette')    
            this.berechneSystemmassInitial();
            
        return nextPanel.toJSON();
	},
	
	cleanUp : function(nextPanel) 
	{
        switch(nextPanel) 
        {
            case 'systemcharakteristik':
            case 'sollwerte_halterungspunkt':
            case 'auswahl_haengergroesse':  // Hnger wird bereits hier angelegt und spter nur noch spezialisiert
                this.Haenger  = null;
				this.TopoLager2 = null;
            case 'auswahl_haengertyp':
            case 'sollwerte_rohrumschliessendes_teil':
            case 'auswahl_schelle':
                this.Schelle  = null;
                this.Zwischenstueck = null;
                this.Mutter = null;
				this.Lager = null;
                //this.DrehungUL      = 0;
                //this.DrehungUR      = 180;
                //this.DrehungO       = 0;
            default:
                break;
        }
    },

    berechneSystemmassInitial : function()
    {
        // --> Aufruf wenn nextPanel = Schlusspanel
		var AchsDirInfo			= this.dataAccess.getAchsKSInfo();
		var dLevelRMT           = this.dataAccess.getSollwerteEinfuegepunkt("vertikal", AchsDirInfo[6]);
        var summeEma            = 0;

        if (this.Haenger)
            summeEma += this.Haenger.m_Pemass;	// Hier Standard-Emass ohne Anpassung
        if (this.Schelle)
            summeEma += this.Schelle.m_Pemass;
        if (this.Lager)
            summeEma += this.Lager.m_Pemass;
		if (this.TopoLager2)
            summeEma += this.TopoLager2.Lager.m_Pemass;
                    
        var dLevelUBA = dLevelRMT - summeEma;

        // Initiale Hhenlevel speichern:
        setstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUBA);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);

        // -mw- 05/2008: Zwischenstck bei Initialisierung immer zurcksetzen!
        this.Zwischenstueck = null;

        // Check ob eine Vorgabe fr Hhenlevel da (bei Import STK)
        var h1 = getstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        var h3 = getstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        // -mw- 26.10.09: Wenn aus FIN-Datei eine Vorgabe "0" kommt, soll diese auch umgesetzt werden
        if (((h1 != "") /* && (h1 != "0") */) || ((h3 != "") /* && (h3 != "0") */))     // h2 knnte leer sein
        {
			if ((h3 != "") /* && (h3 != "0") */)
				setstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
			if ((h1 != "") /* && (h1 != "0") */)
				setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h1);
            this.berechneFlexibleTeileAusSystemmass("UNTEN");
            /* -Schu- 15.7.2010 -> Vorgaben sollen bei zurck und vor wieder eingestellt werden
			setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
            setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
			*/
        }
    },
    
    berechneFlexibleTeileAusSystemmass : function(woVerschoben)
    {
        // Hier gehts eigentlichnur darum, das Zwischenstck zu dimensionieren
        // bzw. die Einstellreserver der Sttze zu nutzen.		
		var strMessage = "";

        var dLevelUBA   = inputStringToDouble(getstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
        var dLevelRMT   = inputStringToDouble(getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));

        var summeEma    = 0;
        var emaSchelle  = 0;
        var hdiff       = dLevelRMT - dLevelUBA;

        if (this.Schelle)
            emaSchelle = this.Schelle.m_Pemass;
        else if (this.Lager)
            emaSchelle = this.Lager.m_Pemass;
		else if (this.TopoLager2)
            emaSchelle = this.TopoLager2.Lager.m_Pemass;

        if (this.Haenger)
            summeEma = this.Haenger.m_Pemass;	// Hier Standard-Emass ohne Anpassung
        summeEma += emaSchelle;
        
        var sollZwischenstueckLaenge = hdiff - summeEma;

        // Erst versuchen, die Einstellreserve des Hngers zu nutzen
        var oZulaessigeAnpassung = this.Haenger.getZulaessigeAnpassungEmass();
		
		this.Haenger.AnpassungEmass = 0;
		if ((sollZwischenstueckLaenge > 0) && (sollZwischenstueckLaenge <= oZulaessigeAnpassung.dEoben))
		{
			this.Haenger.AnpassungEmass = sollZwischenstueckLaenge;
			sollZwischenstueckLaenge = 0;
		}
		if ((sollZwischenstueckLaenge < 0) && (sollZwischenstueckLaenge >= oZulaessigeAnpassung.dEunten))
		{
			this.Haenger.AnpassungEmass = sollZwischenstueckLaenge;
			sollZwischenstueckLaenge = 0;
		}
		
        this.Zwischenstueck = null;
        // Dies wird nur ausgefhrt, wenn eine Anpassung erforderlich ist,
        // die nicht durch die Einstellreserve des Hngers abgedeckt wird:
        if (sollZwischenstueckLaenge > 0)
        {
            var strTyp = "ZZF";
            var strXMass = "";
            if (this.Haenger.isKHaenger())
			{
                strTyp = "ZZK";
				strXMass = this.Haenger.X; 
            }
			
            var myZwischenstueck = new Zubehoer();    
            myZwischenstueck.InitZZX(strTyp, this.Haenger.groesse, sollZwischenstueckLaenge, strXMass, this.Haenger, oZulaessigeAnpassung);

            this.Zwischenstueck = myZwischenstueck;
            
            // Bei der Auslegung musste die Sollnge Zwischenstck evtl. gendert werden
            // Meldung an Benutzer wre dann hilfreich.
            dLevelUBA = dLevelRMT - (this.Haenger.getEmass() + emaSchelle) - this.Zwischenstueck.m_Pemass;
			
			if (hdiff != (dLevelRMT - dLevelUBA))
				strMessage =  translate("IDP_SYSMASS_ZWISCH");	

            /* // Grauzone, Zwischenstck kann nicht beliebig klein gefertigt werden
			else if (this.Zwischenstueck.m_Pemass > sollZwischenstueckLaenge)
				strMessage =  translate("IDP_SYSMASS_ZWISCH_MIN");	
            */
        }
        else if (sollZwischenstueckLaenge < 0)
        {
            // Hier noch die Verstellreserve ausnutzen, nur den Rest verschieben:
			this.Haenger.AnpassungEmass = oZulaessigeAnpassung.dEunten;
			sollZwischenstueckLaenge = sollZwischenstueckLaenge - oZulaessigeAnpassung.dEunten; // dUnten ist negativ oder 0
            
            dLevelUBA = dLevelRMT - (this.Haenger.getEmass() + emaSchelle); // Hier Emass mit Anpassung

			// Meldung dass ein Hhenlevel verschoben werden musste
			strMessage =  translate("IDP_SYSMASS_ABSTAND");	// 
        }
        
        // Hhenlevel zurckspeichern:
        caMainController.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelRMT); 
        setstring("IDC_LAGER_ROHRM_Z", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN", dLevelRMT);
        setstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUBA);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
		
		// -Schu- 15.7.2010 -> Einmal gemachte Vorgaben sollen bei zurck und vor wieder eingestellt werden
		setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
		setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUBA);
    
        return strMessage;
    },
    
    setDrehung : function(strDrehteil)
    {
        /*
		if (strDrehteil == "OL")
            this.DrehungUL += 90;       // U / O ist OK, wir mappen hier von der hngenden LK
        if (strDrehteil == "OR")
            this.DrehungUR += 90;
		*/
		// momentan ist die Drehung direkt abhngig
		if ((strDrehteil == "OL") || (strDrehteil == "OR")){
			this.DrehungUL += 90;
			this.DrehungUR += 90;
		}
        if ((strDrehteil == "U") && (! this.bDoppelt))  // wenn man eine doppelte LK an der Schelle dreht, kann man nichts mehr sehen
            this.DrehungO += 90;

        if (this.DrehungUL >= 360) this.DrehungUL = 0;
        if (this.DrehungUR >= 360) this.DrehungUR = 0;
        if (this.DrehungO  >= 360) this.DrehungO  = 0;

    },

    calculateZusatzlast : function()	
    {
        var zusgew = 0;

        //-mw- Hier ist das Lager bei Einzel, die Schelle bei Doppelt belegt!
        if (this.Schelle)
            zusgew = zusgew + (this.Schelle.m_Pgewicht);
        if (this.Lager)
            zusgew = zusgew + (this.Lager.m_Pgewicht);
		if (this.TopoLager2)
			zusgew = zusgew + (this.TopoLager2.Lager.m_Pgewicht);
        
        var zusatzLast = fround(zusgew / 100, 2);  // Umrechnung kg zu kN
        
        return zusatzLast;
    },
        
    getTopologie : function(strDlg, DrehButtonClicked)
    {
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        // Zuerst mal ein Dummy-Pic hinterlegen, nachher schauen, ob es ein echtes gibt.
        var DrehO	= this.DrehungO + (DrehButtonClicked == "U" ? 90 : 0);
		// OL und OR derzeit direkt abhngig
		//var DrehOL	= this.DrehungOL + (DrehButtonClicked == "OL" ? 90 : 0);
		//var DrehOR	= this.DrehungOR + (DrehButtonClicked == "OR" ? 90 : 0);
		var DrehUL	= this.DrehungUL + ((DrehButtonClicked == "OL" || DrehButtonClicked == "OR") ? 90 : 0);
		var DrehUR	= this.DrehungUR + ((DrehButtonClicked == "OL" || DrehButtonClicked == "OR") ? 90 : 0);
		DrehO	= (DrehO >= 360 ? DrehO - 360 : DrehO);
		DrehUL	= (DrehUL >= 360 ? DrehUL - 360 : DrehUL);
		DrehUR	= (DrehUR >= 360 ? DrehUR - 360 : DrehUR);
		
		var strSchellentypPic = "catalog/client/custom/img/prinzip/LA.gif";
        if (this.bDoppelt && this.bVertikal)
            strSchellentypPic = "catalog/client/custom/img/prinzip/VS.gif";
        if (! this.dataAccess.getLastketteMitSchelle() ||
            (strDlg == 'uebersicht_lastkette') ||
            this.bLager)
            strSchellentypPic = "catalog/client/custom/img/prinzip/Empty.gif"; // weil hier der Algorithmus ein Bild braucht ...;

        if (this.Schelle)
            strSchellentypPic = this.Schelle.getTopoPic(DrehO);

        var strHaengertypPic = "catalog/client/custom/img/prinzip/H.png";
        if (this.Haenger)
            strHaengertypPic = this.Haenger.getTopoPic(DrehUL);

        var strZwischPic = "";
        if (this.Zwischenstueck)
            strZwischPic = "catalog/client/custom/img/panels/TZWISCH.png";
		var strLagerPic = '';
		if ( this.Lager )
			strLagerPic = this.Lager.getTopoPic( DrehUL, false );
		else if ( this.TopoLager2 )
			strLagerPic = this.TopoLager2.Lager.getTopoPic( DrehO, false );
		else if ( this.bLager )
			strLagerPic = "catalog/client/custom/img/panels/THAN.png";
            
        var rows;
        if (this.bDoppelt)
        {
            rows = { topoTyp: "3", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureTop: '' };
			var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehU + "_" + DrehOL + "_" + DrehOR;
				else {
					LKParts		+= DrehU + "_";
					if (DrehOL*1 == 0 || DrehOL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
					if (DrehOR*1 == 0 || DrehOR*1 == 180)
						LKParts	+= "_0";
					else
						LKParts	+= "_90";
				}
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\doppel\\" + LKParts + ".png")){
					rows.PictureBottom = "catalog/client/custom/img/LK/doppel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					DoStd	= false;
				}
			}
			if (DoStd){
				rows.PictureTop = strSchellentypPic;
				rows.PicturesLeft.push( { id : "topology-img2" , src : strHaengertypPic } );
				if (strZwischPic != "")
					rows.PicturesLeft.push( { id : "topology-img9" , src : strZwischPic } );
				if (this.Haenger)
					strHaengertypPic = this.Haenger.getTopoPic(DrehUR);
				rows.PicturesRight.push( { id : "topology-img3" , src : strHaengertypPic } );
				if (strZwischPic != "")
					rows.PicturesRight.push( { id : "topology-img8" , src : strZwischPic } );
			}
        }
		else
        {   
            rows = { topoTyp: "1", Pictures: [] };
			var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehO + "_" + DrehUL;
				else {
					LKParts		+= DrehO + "_";
					if (DrehUL*1 == 0 || DrehUL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
				}
				// prfen, ob die Datei existiert -> falls nicht bisherige Darstellung verwenden
				//var strPrgPath  = getstddirectory("PROGRAM");
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\einzel\\" + LKParts + ".png")){
					//rows.Pictures.push( { id : "topology-img1" , src : "catalog/client/custom/img/LK/LK_" + LKParts + ".png" } );
					
					rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
					rows.PictureBottom = "catalog/client/custom/img/LK/einzel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					
					DoStd	= false;
				}
			}
			if (DoStd){
				if ( strLagerPic != '' )
					rows.Pictures.push( { id : "topology-img1" , src : strLagerPic } );
				rows.Pictures.push( { id : "topology-img2" , src : strHaengertypPic } );
				if (strZwischPic != "")
					rows.Pictures.push( { id : "topology-img3" , src : strZwischPic } );
			}
        }
        return rows;
    },
    
	getStueckliste : function(stkList) 
	{
        var stkListPart;
        var oHoehenmasse = this.dataAccess.getHoehenMasse(this.isDritteHLinie());
        var dSpannweite  = this.getSpannweite();
        var dLeft     = 0;
        var dMiddle   = 0;
        var dRight    = 0;
        var dZ        = atoi(oHoehenmasse.H1);
        
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        
        var strangQty = 1;      // bei einfach hngend und asymmetrisch doppel
        if (this.bDoppelt)
        {
            strangQty = 2;
            var dLeft   = 0;
            var dMiddle = dSpannweite / 2;
            var dRight  = dSpannweite;
        }
            
        if (this.Schelle)   // Schelle immer nur einmal
        {
            stkListPart = {anz: 1, funktion : "SCH", position : "O", 
                           produkt : this.Schelle,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungO}] };
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.getEmass();
        }
        if ( this.Lager )
        {
            stkListPart = { anz: 1, funktion : "LAG", position : "O", 
                            produkt : this.Lager,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungO}]  };
            stkList.push( stkListPart );
            dZ = dZ - stkListPart.produkt.getEmass();
        }
		
		if (this.TopoLager2){
			this.TopoLager2.getStueckliste(stkList);
			var isUndefined	= typeof(stkList[0]);
			if (isUndefined != "undefined")
				dZ = dZ - stkList[0].produkt.getEmass();
		}
		
        if (this.Haenger)    
        {
            if (this.bDoppelt)
            {
                stkListPart = {anz: strangQty, funktion : "HNG", position : "U", 
                               produkt : this.Haenger,
                               threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungUL},
                                          {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungUR}] };
            }
            else
            {
                stkListPart = {anz: strangQty, funktion : "HNG", position : "U", 
                               produkt : this.Haenger,
                               threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungUL}] };
            }
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.getEmass();
        }
        if (this.Zwischenstueck)    
        {
            if (this.bDoppelt)
            {
                stkListPart = {anz: strangQty, funktion : "HNG", position : "U", 
                               produkt : this.Zwischenstueck,
                               threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungUL},
                                          {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungUR}] };
            }
            else
            {
                stkListPart = {anz: strangQty, funktion : "HNG", position : "U", 
                               produkt : this.Zwischenstueck,
                               threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungUL}] };
            }
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.getEmass();
        }
		/*
		if( this.TopoLager2){
			this.TopoLager2.getStueckliste(stkList)
		}
        */
        // Jetzt ber die Liste iterieren und die Anzahl der Muttern bestimmen, sowie Gesamtgewicht und Gesamtpreis...
        this.bestimmeMutternPreiseGewichte(stkList, 0);     // mit Muttern

        return;
    },

    getCADDaten : function()
    {
		// Allgemeine Einstellungen zur Darstellung:
        var aParams = this.getGlobalCADParameters();
		// Parameter des Modells
		aParams		= this.getCADParameters(aParams);
		
		return( aParams );
    }

});

