/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoSegmentStrang = function(pdataAccess)
{
	/**
     * dataAccess ... Verweis auf Objekt, das im Controller angelegt wurde
     * @var dataAccess
     */
	this.dataAccess = pdataAccess;
	    
    // Die Infos zur den Bauteilen des Strangs:
    this.Haenger                    = null;
    this.ObererAnschluss            = null;
    this.Stahlbau                   = null;
    this.OberesVerbindendesTeil1    = null; 	// Gabel, se
    this.ObereVerbindendeTeile      = [];		// Array von Zubehr-Objekten
    this.UnteresVerbindendesTeil1   = null; 	// Gabel, se
    this.UntereVerbindendeTeile     = [];    	// Array von Zubehr-Objekten --> Gewindestangen, Hlsen
    
    this.minGewindestangenLaengeOben  = 0;
    this.minGewindestangenLaengeUnten = 0;
};

CaTopoSegmentStrang.prototype = 
{
    serializeIn : function(strPath) 
	{
        var  i, part_anz;

        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return 0;     // ist noch nichts da

        // Objekte einlesen:
        this.Haenger = serializeInObject(strPath, "Haenger");
        this.UnteresVerbindendesTeil1 = serializeInObject(strPath, "UnteresVerbindendesTeil1");
        this.OberesVerbindendesTeil1 = serializeInObject(strPath, "OberesVerbindendesTeil1");
        this.ObererAnschluss = serializeInObject(strPath, "ObererAnschluss");

        part_anz = getdouble("UVT.PART_ANZ", strPath);
        for(i = 0; i < part_anz; i++)
        {
            this.UntereVerbindendeTeile.push(serializeInObject(strPath, "UVT.PARTS["+i+"].PART"));
        }
        part_anz = getdouble("OVT.PART_ANZ", strPath);
        for(i = 0; i < part_anz; i++)
        {
            this.ObereVerbindendeTeile.push(serializeInObject(strPath, "OVT.PARTS["+i+"].PART"));
        }

        this.minGewindestangenLaengeOben  = getdouble("minGewindestangenLaengeOben",strPath);
        this.minGewindestangenLaengeUnten = getdouble("minGewindestangenLaengeUnten",strPath);

        return 1;
    },

    serializeOut : function(strPath) 
	{
        var  i;
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoSegmentStrang");

        // Objekte:
        this.Haenger.serializeOut(strPath + ".Haenger");
        this.UnteresVerbindendesTeil1.serializeOut(strPath + ".UnteresVerbindendesTeil1");
        this.OberesVerbindendesTeil1.serializeOut(strPath + ".OberesVerbindendesTeil1");
        this.ObererAnschluss.serializeOut(strPath + ".ObererAnschluss");

        setdouble("UVT.PART_ANZ", strPath, this.UntereVerbindendeTeile.length);
        for(i = 0; i < this.UntereVerbindendeTeile.length; i++)
            this.UntereVerbindendeTeile[i].serializeOut(strPath + ".UVT.PARTS["+i+"].PART");

        setdouble("OVT.PART_ANZ", strPath, this.ObereVerbindendeTeile.length);
        for(i = 0; i < this.ObereVerbindendeTeile.length; i++)
            this.ObereVerbindendeTeile[i].serializeOut(strPath + ".OVT.PARTS["+i+"].PART");

        setdouble("minGewindestangenLaengeOben",strPath,this.minGewindestangenLaengeOben);
        setdouble("minGewindestangenLaengeUnten",strPath,this.minGewindestangenLaengeUnten);
    },
    
    getHaengerTypId : function()
    {
        if (this.Haenger)
            return (this.Haenger.m_Ptypid);
        return ("");
    },

    getHaengerCPartId : function()
    {
        if (this.Haenger)
            return (this.Haenger.m_Pcpartid);
        return ("");
    },
    
    setOberenAnschluss : function(strSelectedTeil)
    {
        if (strSelectedTeil == "OHNE")
        {
            this.ObererAnschluss = null;
            return;
        }    
        var myObAnschluss = new Zubehoer();    

        var strLogicId = "";

        switch (strSelectedTeil)
        {	case "ZLN":
                    strLogicId = "IDL_C_ZLN_O_1";
                break;
            case "ZLK":
                    strLogicId = "IDL_C_ZLK_1";
                break;
            case "ZPK":
                    strLogicId = "IDL_C_ZPK_O";
                break;
            case "ZKN":
                    strLogicId = "IDL_C_ZKN";
                break;
            case "ZKK":
                    strLogicId = "IDL_C_ZKK";
                break;
			case "ZGW":
                    strLogicId = "IDL_C_ZGW_O";
                break;
        }

        if ((strSelectedTeil == "ZKN") || (strSelectedTeil == "ZKK"))
        {
            // hier nur den Typ initialisieren ... Auslegung erst spter wenn Stahlbau klar
            myObAnschluss.m_Ptypid = strSelectedTeil;
            myObAnschluss.m_Pcpartid = strLogicId;  // aufpassen, dass die nicht spter wieder berpinnt wird ....
            this.ObererAnschluss = myObAnschluss;
        }   
        else
        {

            if (myObAnschluss.Init( strSelectedTeil, caMainController.topologieKlasse.a_lgv, strLogicId) >= 0)
                this.ObererAnschluss = myObAnschluss;
        }    
    },

    setObereVerbindendeTeile : function(strSelectedTeil, lgv)
    {
        if (strSelectedTeil == "OHNE") 
        {
            this.OberesVerbindendesTeil1 = null;
            this.ObereVerbindendeTeile.length = 0;
            return;
        }    
        
        var b_beweglich      = this.dataAccess.getLastketteTyp();
        var strHaengertyp    = "";
        var strHaengerPartId = "";
        if (this.Haenger)
        {
            strHaengertyp    = this.Haenger.m_Ptypid;
            strHaengerPartId = this.Haenger.m_Pcpartid; 
        }
        
        var zub1 = new Zubehoer();		// die Gewindestange
        if ((b_beweglich == "STARR") && (strHaengerPartId == "IDL_C_ZSM_2"))   
        {	
            // oben links, unten rechts
            zub1.Init("ZLM", lgv, "IDL_C_ZRM_U_1");
        }
        else if ((b_beweglich == "STARR") && (strHaengertyp == "ZRM"))   
        {
            // Auswahl starre Lastkette mit nur einer Gewindestange
            // nichts tun, wir haben schon ne Gewindestange
            zub1 = null;
        }
        else
        {	
            zub1.Init("ZRM", lgv, "IDL_C_ZRM_O");
            zub1.InitZRM("IDL_T_ZRM_ZGM_O", this.Haenger);  // Annahme
            
            this.minGewindestangenLaengeOben = zub1.m_Pemass;
        }

        var zub2 = null;
        if (strSelectedTeil == "ZRMZGMO")
        {
            zub2 = new Zubehoer();		// die Gabel
            zub2.Init("ZGM", lgv, "IDL_C_ZGM_O");
        }        
        else if (strSelectedTeil == "ZRMZOMO")
        {
            zub2 = new Zubehoer();		// die se
            zub2.Init("ZOM", lgv, "IDL_C_ZOM_O");
            zub2.InitZOM("ZOM", lgv, "IDL_C_ZOM_O", 0);
        }
        else if (strSelectedTeil == "ZRMZMMO")
        {
            zub2 = new Zubehoer();		// die Doppelmutter
            zub2.Init("ZMM", lgv, "IDL_C_ZMM_O");
        }

        // Erstmal alles zurcksetzen
        this.OberesVerbindendesTeil1 = null;
        this.ObereVerbindendeTeile.length = 0;

        if (zub2)
            this.OberesVerbindendesTeil1 = zub2;
        
        if (zub1)   // Eine Gewindestange rein fr den Anfang
            this.ObereVerbindendeTeile.push(zub1);
        
        return (1);
    },

    setUntereVerbindendeTeile : function(strSelectedTeil, lgv)
    {
        // ZRMZOMU, ZRMZGMU, ZRMU, zuknftig auch noch mehr ...

        if (strSelectedTeil == "OHNE")
        {
            // Alles zurcksetzen
            this.UntereVerbindendeTeile.length = 0;
            this.UnteresVerbindendesTeil1 = null;
            return 1;
        }
        
        var strAutoAuswahlTyp  = "";
        if (strSelectedTeil == "ZRMZOMU")
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZOM_U";
        else if (strSelectedTeil == "ZRMZGMU")
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZGM_U";
        else if (strSelectedTeil == "ZRMZPKU")
            strAutoAuswahlTyp  = "IDL_T_ZPK";
        else if (strSelectedTeil == "ZRMZMMU")
            strAutoAuswahlTyp  = "IDL_T_ZMM";
		//else if (strSelectedTeil == "ZGWU")
        //    strAutoAuswahlTyp  = "IDL_T_ZRM_ZOM_ZGW_U";

        var b_beweglich      = this.dataAccess.getLastketteTyp();
        var strHaengertyp    = "";
        var strHaengerPartId = "";
        if (this.Haenger)
        {
            strHaengertyp = this.Haenger.m_Ptypid;
            strHaengerPartId = this.Haenger.m_Pcpartid; 
        }
        var bIsStarrZRM = 0;
        if ((b_beweglich == "STARR") && 
            (strHaengertyp == "ZRM"))   // Auswahl starre Lastkette mit nur einer Gewindestange
            bIsStarrZRM = 1;

        // die Gewindestange:
        var zub1 = null;
        if (! bIsStarrZRM)
        {
            zub1 = new Zubehoer();		
            if ((b_beweglich == "STARR") && 
                (strHaengerPartId == "IDL_C_ZSM_1"))   // oben rechts, unten links
            {	
                zub1.Init("ZLM", lgv, "IDL_C_ZRM_U_1");
            }
            else
            {
                // Mindestgew.stangenlngen bestimmen
                zub1.Init("ZRM", lgv, "IDL_C_ZRM_U_1");
                zub1.InitZRM(strAutoAuswahlTyp, this.Haenger);  
                this.minGewindestangenLaengeUnten = zub1.m_Pemass;
            }
        }
        
        var zub2 = null;
        if (strSelectedTeil == "ZRMZGMU")
        {	
            // die Gabel:
            zub2 = new Zubehoer();
            zub2.Init("ZGM", lgv, "IDL_C_ZGM_U");
        }
        else if (strSelectedTeil == "ZRMZOMU" || strSelectedTeil == "ZGWU")
        {	
            // die se:
            zub2 = new Zubehoer();
            zub2.InitZOM("ZOM", lgv, "IDL_C_ZOM_U", 0);
        }
        else if (strSelectedTeil == "ZRMZPKU")
        {	
            // das ZPK:
            zub2 = new Zubehoer();
            zub2.Init("ZPK", lgv, "IDL_C_ZPK_U");
        }
        else if (strSelectedTeil == "ZRMZMMU")
        {	
            // 2 Muttern:
            zub2 = new Zubehoer();
            zub2.Init("ZMM", lgv, "IDL_C_ZMM_U");
        }
		
		/*var zub3 = null;
		if (strSelectedTeil == "ZGWU")
		{
			// ZGW
			zub3 = new Zubehoer();
			zub3.Init("ZGW", lgv, "IDL_C_ZGW_U");
		}*/

        // Erstmal alles zurcksetzen
        this.UntereVerbindendeTeile.length = 0;
        this.UnteresVerbindendesTeil1 = null;
            
        if (zub1)   // Dann eine Gewindestange rein fr den Anfang
            this.UntereVerbindendeTeile.push(zub1);

        if (zub2)
            this.UnteresVerbindendesTeil1 = zub2;

        return (1);
    },
    
    autoAuswahlUntereTeile : function(Schelle, Lasche, Traverse, lgv)
    {
        if ((! Schelle) && (! Traverse)) // @@@@@@@@@ ebenso bei Sonderteil als Schelle
            return 0;   // Auswahl der UVT ber Maske
        
        var strSelectedSchelle = (Schelle) ? Schelle.m_Ptypid : "";
        var strAutoAuswahlTyp  = "";
        
		if (left(strSelectedSchelle, 2) == "HZ")
        {	// je nach Auslegung (Lasche ja/nein) se oder Gabel
            if (Lasche == null)
                strAutoAuswahlTyp  = "IDL_T_ZRM_ZOM_U";
            else
                strAutoAuswahlTyp  = "IDL_T_ZRM_ZGM_U";
        }
        else if ((left(strSelectedSchelle, 2) == "HD") || 
                 (left(strSelectedSchelle, 2) == "HB") ||
                 (left(strSelectedSchelle, 2) == "VB"))
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZOM_U";
        else if (strSelectedSchelle == "ZLN") 
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZGM_U";
        else
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZGM_U";

        var b_beweglich      = this.dataAccess.getLastketteTyp();
        var strHaengertyp    = "";
        var strHaengerPartId = "";
        if (this.Haenger)
        {
            strHaengertyp = this.Haenger.m_Ptypid;
            strHaengerPartId = this.Haenger.m_Pcpartid; 
        }
                
        // die Gewindestange:
        var zub1 = new Zubehoer();		
        if ((b_beweglich == "STARR") && 
            (strHaengerPartId == "IDL_C_ZSM_1"))   // oben rechts, unten links
        {	
            zub1.Init("ZLM", lgv, "IDL_C_ZRM_U_1");
        }
        else if ((b_beweglich == "STARR") && 
                 (strHaengertyp == "ZRM"))   // Auswahl starre Lastkette mit nur einer Gewindestange
        {
            // nichts tun, wir haben schon ne Gewindestange
            zub1 = null;
        }
        else
        {	// Mindestgew.stangenlngen bestimmen
            zub1.Init("ZRM", lgv, "IDL_C_ZRM_U_1");
            zub1.InitZRM(strAutoAuswahlTyp, this.Haenger);  
            this.minGewindestangenLaengeUnten = zub1.m_Pemass;
        }
        
        var zub2 = new Zubehoer();
        if (strAutoAuswahlTyp == "IDL_T_ZRM_ZGM_U")
        {	
            // die Gabel:
            zub2.Init("ZGM", lgv, "IDL_C_ZGM_U");
        }
        else if (strAutoAuswahlTyp == "IDL_T_ZRM_ZOM_U")
        {	
            // die se:
            // die verrckte Prfung,ob die Schraube der Schelle durch die se pat:
            var ncMass = 0;
            if (left(strSelectedSchelle, 2) == "HZ")
            {
                // @@@@@@@@@@ testen, ob das funktioniert:  ncMass Schelle zum Abgleich se
                // eventuell muss da auch noch eine Meldung raus ?!$!&$!!!
                Schelle.getAdditionalDataToStore("TMP.AUSLEGUNG.HSCHELLE");
                ncMass = Schelle.getMass("TMP.AUSLEGUNG.HSCHELLE", "c");
            }
            zub2.InitZOM("ZOM", lgv, "IDL_C_ZOM_U", ncMass);
        }

        // Erstmal alles zurcksetzen
        this.UntereVerbindendeTeile.length = 0;
        this.UnteresVerbindendesTeil1 = null;

        if (zub1)   // Dann eine Gewindestange rein fr den Anfang
            this.UntereVerbindendeTeile.push(zub1);

        if (zub2)
            this.UnteresVerbindendesTeil1 = zub2;
        
        return (1);
    },

    autoAuswahlObereTeile : function(lgv)
    {
        // bei KH, Sttzen und FHS wird nicht nach hier verzweigt
        if (! this.ObererAnschluss) 
            return 0;   // Auswahl der OVT ber Maske, falls ntig
        
        var strSelectedObererAnschluss = this.ObererAnschluss.m_Ptypid;
        var strAutoAuswahlTyp  = "";
		if ((strSelectedObererAnschluss == "ZLN") || (strSelectedObererAnschluss == "ZLK") || 
            (strSelectedObererAnschluss == "ZKN") || (strSelectedObererAnschluss == "ZKK") ||
			(strSelectedObererAnschluss == "ZKB"))
            strAutoAuswahlTyp  = "IDL_T_ZRM_ZGM_O";
		else if (strSelectedObererAnschluss == "ZGW")
        	strAutoAuswahlTyp  = "IDL_T_ZRM_ZOM_O";
        else if (strSelectedObererAnschluss == "ZPK")
        	strAutoAuswahlTyp  = "IDL_T_ZRM_O";

        // fr die Topologie brauchen wir die gesetzte Auswahl!
        // ! nicht mehr !
        // setstring("IDC_AWOT_IMAGE_ID","DLGDATA.CA.FORMS.AUSWAHL_OBERE_TEILE", strAutoAuswahlTyp);

        var b_beweglich      = this.dataAccess.getLastketteTyp();
        var strHaengertyp    = "";
        var strHaengerPartId = "";
        if (this.Haenger)
        {
            strHaengertyp    = this.Haenger.m_Ptypid;
            strHaengerPartId = this.Haenger.m_Pcpartid; 
        }
        
        var zub1 = new Zubehoer();		// die Gewindestange
        if ((b_beweglich == "STARR") && (strHaengerPartId == "IDL_C_ZSM_2"))   
        {	
            // oben links, unten rechts
            zub1.Init("ZLM", lgv, "IDL_C_ZRM_U_1");
        }
        else if ((b_beweglich == "STARR") && (strHaengertyp == "ZRM"))   
        {
            // Auswahl starre Lastkette mit nur einer Gewindestange
            // nichts tun, wir haben schon ne Gewindestange
            zub1 = null;
        }
        else
        {	
            zub1.Init("ZRM", lgv, "IDL_C_ZRM_O");
            if (strSelectedObererAnschluss == "ZPK")
                zub1.InitZRM("IDL_T_ZPK", this.Haenger);
            else
                zub1.InitZRM(strAutoAuswahlTyp, this.Haenger);
            
            this.minGewindestangenLaengeOben = zub1.m_Pemass;
        }

        var zub2 = null;
        if (strAutoAuswahlTyp == "IDL_T_ZRM_ZGM_O")
        {
            zub2 = new Zubehoer();		// die Gabel
            zub2.Init("ZGM", lgv, "IDL_C_ZGM_O");
        }        
        else if (strAutoAuswahlTyp == "IDL_T_ZRM_ZOM_O")
        {
            // Bei freier Auswahl OVT kann das hier vorkommen ...
            zub2 = new Zubehoer();		// die se
            zub2.Init("ZOM", lgv, "IDL_C_ZOM_O");
        }

        // Erstmal alles zurcksetzen
        this.OberesVerbindendesTeil1 = null;
        this.ObereVerbindendeTeile.length = 0;

        if (zub2)
            this.OberesVerbindendesTeil1 = zub2;
        
        if (zub1)   // Eine Gewindestange rein fr den Anfang
            this.ObereVerbindendeTeile.push(zub1);
        
        return (1);
    },
    
    passeGewindestangenAn : function(strAnpassOrt, vorschlagGewindestangen, lgv)
    {
        var zub1, zub2;
        if (strAnpassOrt == "MITTE")
        {
            // Hier kann nur eine einzige Gewindestange vorkommen
			this.UntereVerbindendeTeile.length = 0;
			this.Haenger.AnpassZRM(vorschlagGewindestangen[0]);
			if (vorschlagGewindestangen.length > 1){
				for (var i = (vorschlagGewindestangen.length - 1); i > 0 ; i--)
				{
					var zub1 = new Zubehoer();		// die Hlse
					zub1.Init("ZHM", lgv, "IDL_C_ZHM");
					this.UntereVerbindendeTeile.push(zub1);
					
					var zub2 = new Zubehoer();		// die Gewindestange
					zub2.Init("ZRM", lgv, "IDL_C_ZRM_O");
					zub2.AnpassZRM(vorschlagGewindestangen[i]);
					this.UntereVerbindendeTeile.push(zub2);
				}
			}
			var halt;
        }
        else if (strAnpassOrt == "OBEN")
        {
            this.ObereVerbindendeTeile.length = 0;
            for (var i = 0; i < vorschlagGewindestangen.length; i++)
            {
                var zub1 = new Zubehoer();		// die Gewindestange
                zub1.Init("ZRM", lgv, "IDL_C_ZRM_O");
                zub1.AnpassZRM(vorschlagGewindestangen[i]);
                this.ObereVerbindendeTeile.push(zub1);

                if (i < (vorschlagGewindestangen.length - 1))   // Hlse nur zwischen den Stangen
                {
                    var zub2 = new Zubehoer();		// die Hlse
                    zub2.Init("ZHM", lgv, "IDL_C_ZHM");
                    this.ObereVerbindendeTeile.push(zub2);
                }
            }
        }
        else
        {
            this.UntereVerbindendeTeile.length = 0;
            for (var i = (vorschlagGewindestangen.length - 1); i >= 0 ; i--)
            {
                var zub1 = new Zubehoer();		// die Gewindestange
                zub1.Init("ZRM", lgv, "IDL_C_ZRM_O");
                zub1.AnpassZRM(vorschlagGewindestangen[i]);
                this.UntereVerbindendeTeile.push(zub1);

                if (i > 0)   // Hlse nur zwischen den Stangen
                {
                    var zub2 = new Zubehoer();		// die Hlse
                    zub2.Init("ZHM", lgv, "IDL_C_ZHM");
                    this.UntereVerbindendeTeile.push(zub2);
                }
            }
        }
    },
    
    getTopologie : function(strDlg, picArr, DrehungO, DrehungU)
    {
        var strObererAnschlussPic = "";
        if (this.ObererAnschluss)
            strObererAnschlussPic = this.ObererAnschluss.getTopoPic(DrehungO);
        else
        {
            // prfen ob da berhaupt einer kommt:
            if (strDlg == 'uebersicht_lastkette')
                strObererAnschlussPic = "";
            else if ((this.Haenger && (! this.Haenger.isHaengerStehend())) ||
                (! this.Haenger))
                strObererAnschlussPic = "catalog/client/custom/img/prinzip/Dummy_Oben.png";
        }
        
        var strObereVerbindende1Pic = "";
        var strObereVerbindende2Pic = "";
        if (this.OberesVerbindendesTeil1)
            strObereVerbindende1Pic = this.OberesVerbindendesTeil1.getTopoPic(DrehungO);
		
		if (find(strObereVerbindende1Pic, "ZRM") >= 0 )	// brauchen keine 2 ZRM's
			strObereVerbindende2Pic = "";
        else if (this.ObereVerbindendeTeile.length > 0) 
            strObereVerbindende2Pic = "catalog/client/custom/img/panels/TZRMO.png";
        else
        {
            if (this.Haenger && this.Haenger.isHaengerObenFlexibel())
                strObereVerbindende2Pic = "catalog/client/custom/img/prinzip/GS.gif";
        }

        var strHaengertypPic = "catalog/client/custom/img/prinzip/H.png";
        if (this.Haenger)
            strHaengertypPic = this.Haenger.getTopoPic(DrehungO);
        if (this.Haenger && (this.Haenger.m_Ptypid == "FDT"))
            strHaengertypPic = "";  // Wird unten als "Traverse" dargestellt

        var strUntereVerbindende1Pic = "";
        var strUntereVerbindende2Pic = "";
        if (this.UnteresVerbindendesTeil1)
            strUntereVerbindende1Pic = this.UnteresVerbindendesTeil1.getTopoPic(DrehungU);
            
		if (find(strUntereVerbindende1Pic, "ZRM") >= 0 )	// brauchen keine 2 ZRM's
			strUntereVerbindende2Pic = "";
        else if (this.UntereVerbindendeTeile.length > 0)
            strUntereVerbindende2Pic = "catalog/client/custom/img/panels/TZRMU.png";
        else if (this.Haenger && (this.Haenger.isZRMHaenger() || (this.Haenger.m_Ptypid == "FDT")))
            strUntereVerbindende2Pic = "";
        else
            strUntereVerbindende2Pic = "catalog/client/custom/img/prinzip/GS.gif";

		if (((find(strObereVerbindende1Pic, "ZRM") >= 0 ) ||
			 (find(strUntereVerbindende1Pic, "ZRM") >= 0 )) &&
			(find(strHaengertypPic, "ZRM") >= 0 ))
			strHaengertypPic = "";
            
        if (strObererAnschlussPic != "")
            picArr.push( { id : "topology-img1" , src : strObererAnschlussPic } );
        if (strObereVerbindende1Pic != "")
            picArr.push( { id : "topology-img2" , src : strObereVerbindende1Pic } );
        if (strObereVerbindende2Pic != "")
            picArr.push( { id : "topology-img3" , src : strObereVerbindende2Pic } );
        if (strHaengertypPic != "")
            picArr.push( { id : "topology-img4" , src : strHaengertypPic } );            
        if (strUntereVerbindende2Pic != "")
            picArr.push( { id : "topology-img5" , src : strUntereVerbindende2Pic } );
        if (strUntereVerbindende1Pic != "")
            picArr.push( { id : "topology-img6" , src : strUntereVerbindende1Pic } );
        
        return picArr;
    },
    
	getStueckliste : function(stkList, strangPos, strangQty, HoehenmassH1, dLeft, dMiddle, dRight, DrehungOL, DrehungOR, DrehungU, Traverse, Schelle, Lasche ) 
	{
        var stkListPart;
        var threeDInfo;
        var i;
        var dZ = atoi(HoehenmassH1);
        
        if (this.ObererAnschluss)
        {
            if (strangQty == 1)
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : DrehungOR}];
            stkListPart = {anz: strangQty, funktion : "OBT", position : strangPos, 
                           produkt : this.ObererAnschluss,
                           threeD  : threeDInfo};
            stkList.push(stkListPart);
            if (this.ObererAnschluss.isAusserhalbSystemMass())
                dZ = dZ + atoi(stkListPart.produkt.m_Pemass);
            else
                dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        if (this.OberesVerbindendesTeil1)
        {
			var nBaseQuantity = 1;	// Stckzahl, in der ein Teil im Strangs vorkommt; einzige Ausnahme bisher: Doppelmutter

            if (strangQty == 1)
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : DrehungOR}];
 
			if (this.OberesVerbindendesTeil1.m_Ptypid == "ZMM")
				nBaseQuantity = 2;
			stkListPart = {anz: (nBaseQuantity * strangQty), funktion : "OBT", position : strangPos, 
                            produkt : this.OberesVerbindendesTeil1,
                            threeD  : threeDInfo};
            stkList.push(stkListPart);
            if (this.OberesVerbindendesTeil1.isAusserhalbSystemMass())		// wg. ZMM
                dZ = dZ + atoi(stkListPart.produkt.m_Pemass);
            else
				dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        // obere verbindende Teile:
        for(i = 0; i < this.ObereVerbindendeTeile.length; i++)
        {
            if (strangQty == 1)
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : DrehungOR}];
            stkListPart = {anz: strangQty, funktion : "OVT", position : strangPos, 
                            produkt : this.ObereVerbindendeTeile[i],
                            threeD  : threeDInfo};
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        if (this.Haenger)
        {
            // Sonderfall Doppelhnger mit eingebauter Traverse FDT:
            var haengQty = strangQty;
            if (this.Haenger.m_Ptypid == "FDT")
			{
                haengQty = 1;
				dZ = dZ - this.Haenger.m_Pemass;
			}
            if (haengQty == 1)
                //threeDInfo = [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehungOR}];	// warum hier "OR"???
				threeDInfo = [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehungOL}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : DrehungOR}];
            stkListPart = {anz: haengQty, funktion : "HNG", position : strangPos, 
                            produkt : this.Haenger,
                            threeD  : threeDInfo};
            stkList.push(stkListPart);
            if (this.Haenger.isAusserhalbSystemMass())
            {
				dZ = dZ + stkListPart.produkt.m_Pemass;
			}
            else
			{
				if (this.Haenger.m_Ptypid != "FDT")
					dZ = dZ - stkListPart.produkt.m_Pemass;
			}
        }
        // untere verbindende Teile
        for(i = 0; i < this.UntereVerbindendeTeile.length; i++)
        {
            if (strangQty == 1)
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : DrehungOL},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : DrehungOR}];
            stkListPart = {anz: strangQty, funktion : "UVT", position : strangPos, 
                            produkt : this.UntereVerbindendeTeile[i],
                            threeD  : threeDInfo};
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        if (this.UnteresVerbindendesTeil1)
        {
            var Drehung1 = DrehungOL;
            var Drehung2 = DrehungOR;
			var nBaseQuantity = 1;	// Stckzahl, in der ein Teil im Strangs vorkommt; einzige Ausnahme bisher: Doppelmutter
            /*	// nicht mehr notwendig -Schu- 120618
			if (Traverse)
            {
                // Bei Traversen muss die Gabel in einer bestimmten Position stehen
                Drehung1 = 90;
                Drehung2 = 90;
            }
            else */ if (Schelle && Schelle.isVschelle())
            {
                
				if (Schelle.m_Ptypid == "VBK")
                {
                    // Bei VBK muss die se in einer bestimmten Position stehen
                    Drehung1 = 0;
                    Drehung2 = 0;
                }
                else
                {
                    // Bei anderen V-Schellen muss die Gabel in einer bestimmten Position stehen
                    Drehung1 = 90;
                    Drehung2 = 90;
                }
            }
            else if (Lasche || (Schelle && (Schelle.isHschelle() || left(Schelle.m_Ptypid,2)=="ZL") && !Schelle.isLager() ))
            {
                // Gabel so drehen wie Lasche
                Drehung1 = DrehungU;
                Drehung2 = DrehungU;
            }

            if (this.UnteresVerbindendesTeil1.isAusserhalbSystemMass())
                dZ = dZ + atoi(this.UnteresVerbindendesTeil1.m_Pemass);
            
            if (strangQty == 1)
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : Drehung1}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : Drehung1},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : Drehung2}];
			if (this.UnteresVerbindendesTeil1.m_Ptypid == "ZMM")
				nBaseQuantity = 2;
            stkListPart = {anz: (nBaseQuantity * strangQty), funktion : "SCH", position : "U", 
                            produkt : this.UnteresVerbindendesTeil1,
                            threeD  : threeDInfo};
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.m_Pemass;
        }
    
        return dZ;
    },

    getCADDaten : function(nStartPos, nHaengerPos, nPosNr, DrehungO, DrehungU)
    {
        // ACHTUNG! nStartPos ist bei einfacher LK == 1, d.h. nStartPos + 23 == 24 usw.
        var nTyp = "L";
        var aParams = new Array();
		var aCollection = null;

        if (this.ObererAnschluss)
        {
            aCollection = this.ObererAnschluss.getCADDaten(nStartPos, nPosNr, DrehungO, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        if (this.OberesVerbindendesTeil1)
        {
            aCollection = this.OberesVerbindendesTeil1.getCADDaten(nStartPos + 1, nPosNr, DrehungO, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        // obere verbindende Teile:
        for(i = 0; i < this.ObereVerbindendeTeile.length; i++)
        {
            aCollection = this.ObereVerbindendeTeile[i].getCADDaten(nStartPos + 2 + i, nPosNr, DrehungO, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        if (this.Haenger && (nHaengerPos <= 51))    // letzteres wegen FDT: soll nur einmal ausgegeben werden ...
        {
            aCollection = this.Haenger.getCADDaten(nHaengerPos, nPosNr, DrehungO, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        else if (this.Haenger && (nHaengerPos > 51))
            nPosNr++;   // damit bei FDT der FDT und das Lager nicht dieselbe Posnr haben.
        
        // untere verbindende Teile
        // Wenn hier ein ZLM drin, dann dieses an der letzten Stelle ausgeben
        for(i = 0; i < this.UntereVerbindendeTeile.length; i++)
        {
            if (this.UntereVerbindendeTeile[i].m_Ptypid == "ZLM")
                aCollection = this.UntereVerbindendeTeile[i].getCADDaten(nStartPos + 22, nPosNr);
            else
                aCollection = this.UntereVerbindendeTeile[i].getCADDaten(nStartPos + 14 + i, nPosNr);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        
        // von unten nach oben aufbauen, damit Linksgewindestange ZLM bei Starr ganz unten steht
        // (das Spannschloss steht dann nmlich an zweitunterster Position)
        // So gehts leider nicht, weil sonst die normalen Gewindestangen anders herum ausgegeben werden
        // als in der Stckliste
        /*
        var topIndex = this.UntereVerbindendeTeile.length - 1;
        for(i = topIndex; i >= 0 ; i--)
        {
            aCollection = this.UntereVerbindendeTeile[i].getCADDaten((nStartPos + 22) - (topIndex - i), nPosNr, DrehungO, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }
        */
        
        if (this.UnteresVerbindendesTeil1)
        {
            aCollection = this.UnteresVerbindendesTeil1.getCADDaten(nStartPos + 23, nPosNr, DrehungU, nTyp);
			aParams = aParams.concat( aCollection[0] );
			nPosNr = aCollection[1];
        }

        //return( aParams );
        return( [ aParams, nPosNr ] );
    }
};

