/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoLager2 = function(pdataAccess, ppresets)
{
	CaTopoEinzel.superclass.constructor.call(this, pdataAccess, ppresets);

    // Die Infos zur den Bauteilen der Lager
	this.Lager			 = null;
	this.Klemmsystem     = null;
	this.Abhebesicherung = null;  // sowohl fr Gleitlager als auch Rollenlager
	this.Gleitelement    = null;
    
	this.Rollenlager	 = null;
	this.Sattel	 		 = null;

    this.Drehung        = 0;
    
    // Das Dialogobjekt ersetzt den Store und den DataAccess
	this.oDlgLagerSession = null;
	

    // Weitere Convenience bei spteren Abfragen:
    //this.bGleitlager   = false;
    //this.bRollenlager  = false;
//    if ( lkTyp == "EINZEL_HAENGER" )  
// 		this.bHaenger = 1;

};

EasyKat.extend(CaTopoLager2, CaTopo, {

    serializeIn : function(strPath) 
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) != "CaTopoLager2")
        {   
            // ist noch nichts da
            return 0;     
        }

        // Oberklasse hier auch aufrufen
        CaTopo.prototype.serializeIn.call(this, strPath);       
        
        // Objekte einlesen:
		// serializeIn ist eine Methode
		// serializeInObject ist eine globale Funktion
        this.Lager 				= serializeInObject( strPath, "Lager" );
        this.Klemmsystem 		= serializeInObject( strPath, "Klemmsystem" );
		this.Abhebesicherung 	= serializeInObject( strPath, "Abhebesicherung" );		
		this.Gleitelement 		= serializeInObject( strPath, "Gleitelement" );
		this.Rollenlager 		= serializeInObject( strPath, "Rollenlager" );
		this.Sattel				= serializeInObject( strPath, "Sattel" );
		
		// Achtung: boolesche Variablen werden zu 0 und 1 konvertiert !
		if (getstring("DLGDATA.CA.FORMS.LAGER2DATAEXISTS", "") == "X")
			this.oDlgLagerSession = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER2DATA" );
        /*
		var RVektor = (getstring('pipeorient', 'DLGDATA.CA.FINDATA.FINOBJECT.pipe')).split(' ');
        if (abs(RVektor[1]) == 1)
			this.Drehung	= 90;
		else if (RVektor[0] == ""){
		//	this.Drehung	= getdouble("Drehung",strPath);
			var VertiAchs	= right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"), 1);
			var VertiDir	= right(getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"), 3);
			var RohrRicht	= left(right(this.oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung,7),1);
			var KSVariante	= right(getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"), 4);
			this.Drehung	= 0;
			switch (VertiAchs){
				case 'Z' :
					if ((RohrRicht == "X" && (KSVariante == "Var1" || KSVariante == "Var3")) ||
						(RohrRicht == "Y" && (KSVariante == "Var2" || KSVariante == "Var4")))
						this.Drehung	= 90;
					break;
				case 'Y' :
					if ((RohrRicht == "Z" && (KSVariante == "Var1" || KSVariante == "Var3")) ||
						(RohrRicht == "X" && (KSVariante == "Var2" || KSVariante == "Var4")))
						this.Drehung	= 90;
					break;
				case 'X' :
					if ((RohrRicht == "Y" && (KSVariante == "Var1" || KSVariante == "Var3")) ||
						(RohrRicht == "Z" && (KSVariante == "Var2" || KSVariante == "Var4")))
						this.Drehung	= 90;
					break;
				default :
					break;
			}
		}
		*/
        return 1;
    },

    serializeOut : function(strPath) 
	{
        // Erstmal vorherige Daten wegputzen ...
        delete(strPath, "");
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoLager2");

        CaTopo.prototype.serializeOut.call(this, strPath);
        
        // Objekte:
        if ( this.Lager )
            this.Lager.serializeOut( strPath + ".Lager" );
        if ( this.Klemmsystem )
            this.Klemmsystem.serializeOut( strPath + ".Klemmsystem" );
		if ( this.Abhebesicherung )
            this.Abhebesicherung.serializeOut( strPath + ".Abhebesicherung" );	
		if ( this.Gleitelement )
            this.Gleitelement.serializeOut( strPath + ".Gleitelement" );	
		if ( this.Rollenlager )
            this.Rollenlager.serializeOut( strPath + ".Rollenlager" );
		if ( this.Sattel )
            this.Sattel.serializeOut( strPath + ".Sattel" );
			
		if (this.oDlgLagerSession) {
			this.oDlgLagerSession.toStorage("DLGDATA.CA.FORMS.LAGER2DATA", false);   // kein merge
			setstring("DLGDATA.CA.FORMS.LAGER2DATAEXISTS", "", "X");
		}
		
        setdouble("Drehung",        strPath, this.Drehung);
    },
	
	
	/**
	 * ist Klemmsystem ?
	 * @return {Boolean}
	 */
	isKlemmsystem: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
		if (this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ZUBEHOER"){
			switch(this.oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager){
				case "KG" :
				case "KR" :
					return true;
				default :
					return false;
			}
		}
		else
			return false;
	},
	/**
	 * ist Gleitlager ?
	 * @return {Boolean}
	 */
	isGleitlager: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
		switch(this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager){
			case "LAGER_SPG" :
			case "LAGER_SSG" :
			case "LAGER_EPG" :
				return true;
			default :
				return false;
		}	
	},
	/**
	 * ist Festlager ?
	 * @return {Boolean}
	 */
	isFestlager: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
			
		if(this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS")
			return true;
		else 
			return false;
	},
	/**
	 * ist isRollenlager ?
	 * @return {Boolean}
	 */
	isRollenlager: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
			
		if(this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ROLL")
			return true;
		else 
			return false;
	},
	/**
	 * ist Sattel
	 * @return {Boolean}
	 */
	isSattel: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
			
		switch(this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager){
			case "LAGER_SAROLL" :
			case "LAGER_SYROLLSA" :
				return true;
			default :
				return false;
		}
	},
	/**
	 * ist Klemmsystem fr Rollenlager
	 * @return {Boolean}
	 */
	isKlemmsys_RL: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
			
		switch(this.oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager){
			case "KR" :
				return true;
			default :
				return false;
		}
	},
	
	/**
	 * ist Abhebesicherung fr Rollenlager
	 * @return {Boolean}
	 */
	isAHS_RL: function(){
		if(!this.oDlgLagerSession)
			alert('ERROR: Lager Object is null');
			
		switch(this.oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager){
			case "AfR" :
				return true;
			default :
				return false;
		}
	},
	
	isSingleProduct: function(){
		var dCount = 0;
		if(this.Lager)
			dCount +=1;
			
		if(this.Klemmsystem && this.Klemmsystem.strBaureihe != "KSY")
		// die virtuellen Klemmsysteme fr LKx 10 werden nicht gezhlt -> Lager als Einzelprodukt
			dCount +=1;
		
		if(this.Abhebesicherung)
			dCount +=1;
	
		if(this.Gleitelement)
			dCount +=1;
    
		if(this.Rollenlager)
			dCount +=1;
		
		if(this.Sattel)
			dCount +=1;
		
		if (this.Sonderteile.length > 0)
			dCount +=1;
		
		return  (dCount <= 1 ? true : false);	
	},

	getSpecialLagerInfo : function()
	{
		var bIsLagerMitKlemmsystem = false;
		if (this.Lager && this.Klemmsystem)		// normale Auswahl ber Flexperte
			bIsLagerMitKlemmsystem = true;
		
		var bIsSpecialLagerMitKlemmsystem = false;
		if (this.Lager && this.Lager.strBauF*1 == 10 && left(this.Lager.strBaureihe, 2) == "LK")	// Auswahl ber eFIN -> hier fehlt das Pseudo-Klemmsystem
			bIsSpecialLagerMitKlemmsystem = true;
			
		if (this.Lager){
			var SAPKlasse			= this.Lager.getSAPKlassenName();
			// hier brauchen wir noch oProfil fr die Lager LKx 10
			var strProfilform		= "";
			var strTraegerbreite	= "";
			if (bIsLagerMitKlemmsystem){
				strProfilform		= toupper(right(left(this.Klemmsystem.m_Ptyp, 8), 1));
				if (strProfilform == "T" && right(this.Klemmsystem.m_Ptyp, 3)*1 <= 140)
					strTraegerbreite	= "140";
			}
			else if (bIsSpecialLagerMitKlemmsystem){
				strProfilform		= toupper(right(left(this.Lager.m_Ptyp, 17), 1));
				if (strProfilform == "T" && right(left(this.Lager.m_Ptyp, 20), 3)*1 <= 140)
					strTraegerbreite	= "140";
			}
			var oProfil = {
			strTraegerbreite	: strTraegerbreite,
			strProfilform		: strProfilform
			}
			var isSAPKonfigurierbar	= this.Lager.isSAPKonfigurierbar(SAPKlasse, oProfil);
		}
		else if (this.Sattel){
			var SAPKlasse			= this.Sattel.getSAPKlassenName();
			var isSAPKonfigurierbar	= this.Sattel.isSAPKonfigurierbar(SAPKlasse);
		}
		else if (this.Abhebesicherung){
			var SAPKlasse			= this.Abhebesicherung.getSAPKlassenName();
			var isSAPKonfigurierbar	= this.Abhebesicherung.isSAPKonfigurierbar(SAPKlasse);
		}
		else if (this.Klemmsystem){
			var SAPKlasse			= this.Klemmsystem.getSAPKlassenName();
			var isSAPKonfigurierbar	= this.Klemmsystem.isSAPKonfigurierbar(SAPKlasse);
		}
		
		var bSonderteile	= (this.Sonderteile.length > 0 ? true : false);
		
		var bIsRLAuswahl	= (this.isSattel() || this.isAHS_RL() || this.isRollenlager() ? true : false);	// Auflsung wie Lager bis FL 4.3.052
		
		var bIsAuswahlKSeinzel	= (this.Klemmsystem && !this.Lager && !this.isSattel() ? true : false );
		
		var bIsAuswahlAHSeinzel	= (this.Abhebesicherung && !this.isSattel() && !this.isRollenlager() && !this.Lager ? true : false );
		
		var retObj = {
			bIsLagerAuswahl : true,
			bIsEinzelprodukt : this.isSingleProduct(),
			bIsConfigurable : isSAPKonfigurierbar,
		//	bIsConfigurable : this.Lager.isSAPKonfigurierbar(SAPKlasse),
			bIsLagerMitKlemmsystem : bIsLagerMitKlemmsystem,
			bIsRLAuswahl : bIsRLAuswahl,
			bIsAuswahlKSeinzel : bIsAuswahlKSeinzel,
			bIsAuswahlAHSeinzel : bIsAuswahlAHSeinzel,
			bSonderteile : bSonderteile
		};
		return retObj;
	},
	
    
	/**
	 * hole Daten fr die Lastenkette
	 */
    getLastkettenIdent : function(theMainController){
        return this.getLastketten2IdentGeneric(theMainController);
    },
	/**
	 * Vorbereitung der Daten fr Funktion CaTypsucheManager --> bergabe an Projectliste
	 * SAP Merkmale Suchen, etc. 
	 */
	getLastketten2IdentGeneric: function(theMainController){
		
        // Sonderfall: bei Produktauslegung Einzel soll hier die Matnr
        // des Einzelprodukts zurckgeliefert werden, nicht die der Lastkette
		// Achtung!!! gilt nur wenn das Einzelprodukt nicht aufgelst wird
		var LagerInfo	= this.getSpecialLagerInfo();
		var StkList		= [];
		this.getStueckliste(StkList);
		//if (this.isSingleProduct()){
		//if (LagerInfo.bIsEinzelprodukt && !LagerInfo.bIsConfigurable){
		//if (LagerInfo.bIsEinzelprodukt && (!LagerInfo.bIsConfigurable || LagerInfo.bIsRLAuswahl)){
		if (LagerInfo.bIsEinzelprodukt && (!LagerInfo.bIsConfigurable || LagerInfo.bIsAuswahlKSeinzel || LagerInfo.bIsRLAuswahl)){
			var einzelProdukt	= this.getEinzelprodukt();
			//var isConfigurable	= this.Lager.isSAPKonfigurierbar(einzelProdukt.getSAPKlassenName());
			//if (!isConfigurable) {
				var astlDaten = einzelProdukt.getASTLDaten(theMainController);
				var retObj = {matnr			: astlDaten.matnr,
							  aTexte		: astlDaten.aTexte,
							  mat_kurz_txt	: "",
							  klasse		: einzelProdukt.getSAPKlassenName(),
							  typ			: einzelProdukt.getSAPTyp()
							};
				return retObj;
			//}
		}
		// Bei Nicht-Einzelprodukten gehen wir einen anderen Weg als sonst.
		// Wir fragen nicht die Tabelle MATERIAL ab sondern eine spezielle Tabelle LK_MATNR_SAPKLASSEN
		// LAGERART BAU_F WERKSTOFF_37 HOEHENVERSTELLBAR VORISOLIERT GLEITUNTERLAGE SCHRAUBBAR_EINFACH SCHRAUBBAR_DOPPELT NENNHOEHE_60 SONDER BEZEICHNUNG SAP_KLASSE IDENT
		var oDlgSession = this.oDlgLagerSession;
		var oDlgAuswahl = oDlgSession.AuswahlStandard;	// @@@ Bei Rollenlagern ein anderer Dialog !!!
		var strLagerart = '';  // FP Festlager, FL Fhrungslager, LL Loslager 
		if (this.isFestlager()){
			strLagerart		= 'FP';
			var strSuffix	= "";
			if (oDlgAuswahl.oSearchResult.oResultLager.WERKSTOFF >= 41 &&  oDlgAuswahl.oSearchResult.oResultLager.WERKSTOFF <= 80)
				strSuffix	= "_VA";
			strLagerart		+= strSuffix;
		}
		else if (this.isGleitlager()) {
			if (oDlgAuswahl.strSelRadioFunction == 'LOSE')
				strLagerart = 'LL';
			else
				strLagerart = 'FL';
			// fr die 10er Typen brauchen wir die Unterscheidung der Trger
			var strSuffix	=	"";
			if (oDlgSession.AuswahlStandard.oSearchResult.oResultLager.BAU_F*1 == 10){
				if (left(oDlgAuswahl.strSelComboBeamArt, 1) == "L" || left(oDlgAuswahl.strSelComboBeamArt, 1) == "U")
					strSuffix	= "_LU";
				else
					strSuffix	= "_T";
			}
			strLagerart	+=	strSuffix;
		}
		else if (this.isKlemmsystem()){
			strLagerart = 'KS';
		}
		else if (this.isSattel() || this.isRollenlager()){	//auch System RL/Sattel gibt 1 zurck
			var KSY, SAT, AHS, ROL;
			KSY = SAT = AHS = ROL = 0;
			for (var i = 0; i < StkList.length; i++)
			{
				switch (StkList[i].funktion){
				case "KSY":{
					KSY = 1;
					var PosKSY = i;
					break;
					}
				case "SAT":{
					SAT = 1;
					var PosSAT = i;
					break;
					}
				case "ABE":{
					AHS = 1;
					var PosAHS = i;
					break;
					}
				case "ROL":{
					ROL = 1;
					var PosROL = i;
					break;
					}
				}
			}
			var SAT_AHS		= '0';
			if (SAT && AHS)
				SAT_AHS		= '1';
			
			var SeitlVersch	= '0';
			
			if (left(toupper(StkList[PosROL].produkt.m_Ptypid), 2) == "RD")
				strLagerart	= 'DZRL';
			else if (left(toupper(StkList[PosROL].produkt.m_Ptypid), 2) == "RK")
				strLagerart	= 'DKRL';
			else if (left(toupper(StkList[PosROL].produkt.m_Ptypid), 2) == "RZ")
				strLagerart	= 'ZYRL';
			if ((right(toupper(StkList[PosROL].produkt.m_Ptypid), 1) == "L") &&
				(left(toupper(StkList[PosROL].produkt.m_Ptypid), 2) != "RZ"))
			{
				strLagerart		+= '_SV';
				SeitlVersch		= '1';
			}
		}
		
		//Unterscheidung in Gleitlager/Festlager und Rollenlager
		if ((right(strLagerart, 2) != 'RL') && (right(strLagerart, 2) != 'SV') && !this.isKlemmsystem())
		{
			var strGrundtyp	= "LG";	// LG ... (Gleit-)Lager
			var dbNameTable = "LK_MATNR_SAPKLASSEN";
			var strSql 		= "SELECT * FROM LK_MATNR_SAPKLASSEN WHERE LAGERART = '"+strLagerart+"' ";
			strSql 	= strSql + " AND BAU_F = '" + oDlgAuswahl.oSearchResult.oResultLager.BAU_F + "' ";
			strSql 	= strSql + " AND WERKSTOFF_37 = '" + ((oDlgAuswahl.oSearchResult.oResultLager.WERKSTOFF == '37') ? '1' : '0') + "' ";
			strSql 	= strSql + " AND HOEHENVERSTELLBAR = '" + ((oDlgAuswahl.bHoehenverstellbar) ? '1' : '0') + "' ";
			strSql 	= strSql + " AND VORISOLIERT = '" + ((this.getIsolierung() == 'ID_VORISOLIERT') ? '1' : '0') + "' ";
			if (oDlgSession.Systemcharakteristik.strSelRadioLager != "LAGER_FS")
				strSql 	= strSql + " AND GEFUEHRT_MEHRFACH = '" + ((oDlgAuswahl.strSelRadioFunction == 'GEFUEHRT_MEHRFACH') ? '1' : '0') + "' ";
			else
				strSql 	= strSql + " AND GEFUEHRT_MEHRFACH = '0' ";
			if (oDlgAuswahl.bGaT) {
				strSql 	+= " AND GLEITUNTERLAGE = 'AM_TRAEGER' ";
			}
			else {
				switch(oDlgSession.Systemcharakteristik.strSelRadioLager){
					case "LAGER_FS":
						strSql 	+= " AND GLEITUNTERLAGE = '0' ";
						break;
					case "LAGER_SPG" :
						strSql 	+= " AND GLEITUNTERLAGE = 'AM_SCHLITTEN' ";
						break;
					case "LAGER_SSG" :
						strSql 	+= " AND GLEITUNTERLAGE = '0' ";
						break;
					case "LAGER_EPG" :
						strSql 	+= " AND GLEITUNTERLAGE = 'AM_SCHLITTEN_VA' ";
						break;
				}
			}
			
			if (left(oDlgAuswahl.strSelComboSlidingPart, 2) == 'LG'){
				strSql 	+= " AND ZUSATZELEMENT = 'LGX' ";
			}
			
			if (oDlgAuswahl.strSelRadioFixed == 'SCHRAUBBAR') {
				if (oDlgAuswahl.strSelRadioFixedScrewOn == 'EINFACH') {
					strSql 	+= " AND SCHRAUBBAR_EINFACH = '1' ";
				}
				else {
					strSql 	+= " AND ((SCHRAUBBAR_EINFACH = '0') OR (SCHRAUBBAR_EINFACH = '')) ";
				}
				if (oDlgAuswahl.strSelRadioFixedScrewOn == 'DOPPELT') {
					strSql 	+= " AND SCHRAUBBAR_DOPPELT = '1' ";
				}
				else {
					strSql 	+= " AND ((SCHRAUBBAR_DOPPELT = '0') OR (SCHRAUBBAR_DOPPELT = '')) ";
				}
			}
			else {
				strSql 	+= " AND ((SCHRAUBBAR_EINFACH = '0') OR (SCHRAUBBAR_EINFACH = '')) ";
				strSql 	+= " AND ((SCHRAUBBAR_DOPPELT = '0') OR (SCHRAUBBAR_DOPPELT = '')) ";
			}
			
			if ((oDlgSession.Systemcharakteristik.strSelRadioLager != "LAGER_FS" && oDlgAuswahl.strSelComboAccessory == 'KLEMMBAR') || 
				(oDlgSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlgAuswahl.strSelRadioFixed == 'KLEMMBAR'))
				strSql 	+= " AND KLEMMSYSTEM = '1' ";
			else
				strSql 	+= " AND KLEMMSYSTEM = '0' ";
			
			if ((oDlgAuswahl.oSearchResult.oResultLager.NH * 1) <= 60) {	// oder auch '40'
				strSql 	+= " AND NENNHOEHE_60 = '1' ";
			}
			else {
				strSql 	+= " AND ((NENNHOEHE_60 = '0') OR (NENNHOEHE_60 = '')) ";
			}
			
			strSql 	+= " AND SONDER = '0' ";
		}
		else if ((right(strLagerart, 2) != 'RL') && (right(strLagerart, 2) != 'SV') && this.isKlemmsystem()){
			var strGrundtyp	= "LG";	// LG ... Klemmsystem fr (Gleit-)Lager
			var dbNameTable = "LK_MATNR_SAPKLASSEN";
			var strSql 		= "SELECT * FROM LK_MATNR_SAPKLASSEN WHERE LAGERART = '"+strLagerart+"' ";
			strSql			= strSql + " AND SONDER = '1' ";	// Sonderteile in der LK
		}
		else
		{
			var strGrundtyp	= "RL";	// RL ... Rollenlager
			var dbNameTable = "LK_MATNR_SAPKLASSEN_RL";
			var strSql 		= "SELECT * FROM LK_MATNR_SAPKLASSEN_RL WHERE LAGERART = '"+strLagerart+"' ";
			strSql 	= strSql + " AND SATTEL_AHS = '" + SAT_AHS + "' ";
			strSql 	= strSql + " AND SEITL_VERSCH = '" + SeitlVersch + "' ";
			strSql 	= strSql + " AND SONDER = '0' ";
		}

		var retObj = {
			klasse			: '',
			matnr			: '',
			matnr_lk_lg		: '',						// das wird bei Sonderteilen gebraucht
			mat_kurz_txt	: '',						// hier leer ... @@@ wird es gebraucht und wenn ja was soll rein?
			typ				: ('LK_' + strGrundtyp),	// hier LK-Lager zur Unterscheidung zu einzelnen Lagern
			aTexte			: []
		}
		
		if (LagerInfo.bSonderteile){
			// 13.04.2016 - neues Vorgehen bei Sonderteilen
			// -Schu- wir merken uns die bergeordnete Mat.Nr. der Lagerlastkette, da diese in der 1. Ebene der StLi stehen soll
			var dbName				= 'LAGER2';
			var dTableDatenLength	= dbselect( dbName, strSql, dbNameTable );
			if ( dTableDatenLength > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					retObj.matnr_lk_lg  = dbgetstring(dbNameTable,"IDENT");
					dbskip( dbNameTable );
				}
			}
				
			dbName	= 'SAP_M';
			strSql	= "SELECT * FROM MATERIAL WHERE KLASSE = 'SPZ' AND MERKM_4 = 'LK1_RH_SO'";
			var dTableDatenLength 	= dbselect( dbName, strSql, dbNameTable );
			if ( dTableDatenLength > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					retObj.klasse = dbgetstring(dbNameTable,"KLASSE");
					retObj.matnr  = dbgetstring(dbNameTable,"MAT_NR");
					var strSubtyp = dbgetstring(dbNameTable,"MERKM_4");
					dbskip( dbNameTable );
				}
			}
		}
		else{
			var dbName		= 'LAGER2';
			var dTableDatenLength 	= dbselect( dbName, strSql, dbNameTable );
			if ( dTableDatenLength > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					retObj.klasse		= dbgetstring(dbNameTable,"SAP_KLASSE");
					retObj.matnr		= dbgetstring(dbNameTable,"IDENT");
					retObj.matnr_lk_lg	= dbgetstring(dbNameTable,"IDENT");	// hier eigentlich nicht erforderlich
					var strSubtyp		= dbgetstring(dbNameTable,"TYP");
					dbskip( dbNameTable );
				}
			}
		}

		// Jetzt die Texte ergnzen ... :
		//var strSubtyp = "";		// @@@ eventuell hier besonderen Subtyp ???
		// Texte der LK
		var strSQLStatement	= "select * from TEXT_KONFIG_ID where KLASSE='"+retObj.klasse+"' and TYP='"+retObj.typ+"' and SUB_TYP='"+strSubtyp+"' order by abs(ZEILEN_NR) ";
		var numRet			= dbselect("SAP_V", strSQLStatement, "TEXTE_KONFIG");
		if (numRet > 0)
		{	/*
			var massPath = "TMP.MAT_ADDITIONAL_DATA";
			if ((this.m_Ptyp == "LK") || (this.m_Ptypid == "LK1_RH_SO"))
				this.getAdditionalDataToStore(massPath, theMainController);  // Aufruf der Methode hier
			else
				this.getAdditionalDataToStore(massPath);    // Aufruf am jeweiligen Produkt
			*/
			
			while (dbiseof("TEXTE_KONFIG") == 0)
			{
				var strText = dbgetstring("TEXTE_KONFIG", "ID");
				if (strText != "")
					strText = translate(strText);
				strText = this.replaceMasse(strText, StkList, oDlgSession, strLagerart);
				if (strText != "")
					retObj.aTexte.push(strText);
				dbskip("TEXTE_KONFIG");
			}
		}
		
		return retObj;
	},
	
	replaceMasse : function(m_wert, StkList, SessionObj, strLagerartGrundtyp){
		var nDepth		= 0;
        var strRepVal	= "", strReplacement = "";
        var strResult	= m_wert;
        var nLength		= m_wert.length;
		var lastPosStd	= -1;	// letzte Position die kein Sonderteil ist
		
        // Bestimme die StLi-Positionen fr Lager, Klemmsystem, Rollenlager
		var StkPos_LAG	= (-1);
		var StkPos_KSY	= (-1);
		var StkPos_ROL	= (-1);
		var StkPos_SAT	= (-1);
		var StkPos_ABE	= (-1);
		var StkPos_GEL	= (-1);
		
		for (var Pos = 0; Pos < StkList.length; Pos++)
		{
			switch(StkList[Pos].funktion){
			case "LAG":
				StkPos_LAG	= Pos;
				break;
			case "KSY":
				StkPos_KSY	= Pos;
				break;
			case "ROL":
				StkPos_ROL	= Pos;
				break;
			case "SAT":
				StkPos_SAT	= Pos;
				break;
			case "ABE":
				StkPos_ABE	= Pos;
				break;
			case "GEL":
				StkPos_GEL	= Pos;
				break;
			default :
				break;
			}
			if (StkList[Pos].funktion != "SON")
				lastPosStd	= Pos;
		}
		
		var delLine	= false;
		for (var i = 0; i < nLength; ++i)
        {
            if (m_wert.charAt(i) == "}")
            {
				// StLi-Pos des entsprechenden Bauteils bestimmen, um den Text richtig zu ersetzen
				var StkPos			= (-1);
				var strRepVal_R3	= toupper(right(strRepVal, 3));
				var strRepVal_L		= strRepVal;
				var isStandardPart	= false;
				
				// Achtung "LAW" luft unter Funktion "ABE" (Abhebesicherung)
				if (strRepVal_R3 == "LAW")
					strRepVal_R3 = "ABE";
				
				if (strRepVal_R3 == "LAG" || strRepVal_R3 == "KSY" ||
					strRepVal_R3 == "ROL" || strRepVal_R3 == "SAT" || 
					strRepVal_R3 == "ABE" || strRepVal_R3 == "GEL")
				{
					strRepVal_L = toupper(left(strRepVal, (strRepVal.length-4)));
					for (var j = 0; j < StkList.length; j++)
					{
						if (StkList[j].funktion == strRepVal_R3)
						{
							if (StkPos == (-1))
							{
								StkPos = j;
								//strRepVal_L = toupper(left(strRepVal, (strRepVal.length-4)));
							}
						}
					}
					isStandardPart	= true;
				}
				switch(strRepVal_L){
				
				case "TYP_BEZ":
					if (StkPos == (-1) && strLagerartGrundtyp == "FP" && strRepVal == "TYP_BEZ_KSY"){
						var TR_BREIT	= SessionObj.AuswahlStandard.dBeamWidth;
						if (TR_BREIT*1 < 140)
						TR_BREIT	= "140";
						strReplacement	= left(StkList[StkPos_LAG].produkt.oData.TYP_KS, 8) + TR_BREIT;
					}
					else if (StkPos == (-1) && lastPosStd != (-1)){
						if (StkList[lastPosStd].funktion == "KSY" && lastPosStd != 0)	// Klemmsystem nur als Typ bei einelnem KS und Sonderteil
							strReplacement = StkList[lastPosStd - 1].produkt.m_Ptyp;
						else if (isStandardPart)
							strReplacement = "";
						else
							strReplacement = StkList[lastPosStd].produkt.m_Ptyp;
					}
					else if (StkPos == (-1) && lastPosStd == (-1))
						strReplacement = StkList[Pos].produkt.m_Ptyp;
					else if (StkPos == (-1))	// drfte nie angesprochen werden
						strReplacement	= "";
					else
						strReplacement	= StkList[StkPos].produkt.m_Ptyp;
					break;
				
				//case "TYP_BEZ_KSY":	// bei Festlager
				//	var TR_BREIT	= SessionObj.AuswahlStandard.dBeamWidth;
				//	if (TR_BREIT*1 < 140)
				//		TR_BREIT	= "140";
				//	strReplacement	= left(StkList[StkPos_LAG].produkt.oData.TYP_KS, 8) + TR_BREIT;
				//	break;
				case "WERKSTOFF":
					if (StkPos == (-1) && strLagerartGrundtyp == "FP")
						strReplacement	= "S235JR";
					else if (StkPos == (-1))
						strReplacement	= "-";
					else
						strReplacement	= Werknamen[StkList[StkPos].produkt.m_Pwerkstoff];
					break;
				//case "WERKSTOFF_KSY":	// bei Festlager
				//	strReplacement	= "S235JR";
				//	break;
				case "WERKSTOFF_ROLLE":	// bei Rollenlagern
					strReplacement	= StkList[StkPos_ROL].produkt.oData.WERKSTOFF_ROLLE;
					break;
				case "OBFLSCHUTZ":
					if (StkPos == (-1) && strLagerartGrundtyp == "FP")
						strReplacement	= translate("FEUERVERZINKT");
					else if (StkPos == (-1))
						strReplacement	= "-";
					else
						strReplacement	= translate(OberflaechenschutzTransID[StkList[StkPos].produkt.m_Poberfl]);
					break;
				//case "OBFLSCHUTZ_KSY":	// bei Festlager
				//	strReplacement	= translate("FEUERVERZINKT");
				//	break;
				case "DN":
					strReplacement	= StkList[StkPos_LAG].produkt.oData.DN;
					break;
				case "H":
					strReplacement	= StkList[StkPos_LAG].produkt.oData.NH;
					break;
				case "PFORM":
					strReplacement	= translate(SessionObj.AuswahlStandard.strSelComboBeamArt);
					break;
				case "TRAEGBREIT":
					strReplacement	= SessionObj.AuswahlStandard.dBeamWidth;
					break;
				case "TRAEGHOCH":
					strReplacement	= SessionObj.AuswahlStandard.dBeamHeight;
					break;
				case "GTYP":
					strReplacement	= translate("ID_CA_ARTIKEL_" + strLagerartGrundtyp);
					break;
				case "MIT_OHNE":
					if (StkPos == (-1))
						strReplacement	= translate("ID_OHNE");
					else
						strReplacement	= translate("ID_MIT");
					break;
				case "WX":
					strReplacement	= StkList[StkPos_ROL].produkt.oData.W_QUER_NENN;
					break;
				case "POS":
					strReplacement	= getstring("POS", "DLGDATA");
					break;
				default :
					strReplacement	= "";
				}
				
			// Ersetze den Wert in Kopie des bergebenen Params (damit wir mit i nicht durcheinander kommen!)
                strResult = replace(strResult, "{"+strRepVal+"}", strReplacement);
                strRepVal = "";
                nDepth--;
			if (strReplacement == "" || strReplacement == "-")
				delLine	= true;
			}
            if (nDepth > 0)
                strRepVal = strRepVal + m_wert.charAt(i);
            if (m_wert.charAt(i) == "{")
            {
                nDepth++;
                if (nDepth > 1)
                    alert("Fehler 2 in Stuecklistendaten: geschachtelte Klammern");
            }
		}
		return (delLine ? "" : strResult);
    },
	
	// Hier nur aus Kompatibilittsgrnden zu den anderen Topologien: 
	getCurrentHaenger : function(){
        return(null);
    },
    
	getDlgLagerSession : function(){
		if ((this.oDlgLagerSession == null) ||
			(this.oDlgLagerSession == {})) {
			this.oDlgLagerSession = new LagerObject();
			
			if (getstring("TMP.SAVE_CASCADE_INPUTS.USELAGERROHRDATA", "") == "true") {
				setstring("TMP.SAVE_CASCADE_INPUTS.USELAGERROHRDATA", "", "false");
				this.oDlgLagerSession.SollwerteRohrUmTeil = Object.fromStorage( "TMP.SAVE_CASCADE_INPUTS.LAGER2DATA.SollwerteRohrUmTeil" );
			}
			// noch kein Lager gewhlt, aber schon eine Lastkette mit Schelle
			// -> einzelne Datenbernahme
			else if ((typeof(Object.fromStorage( "TMP.SAVE_CASCADE_INPUTS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL" )) == 'object')
						&& (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) != 'object'))
			{
				var SollwertRH	= Object.fromStorage( "TMP.SAVE_CASCADE_INPUTS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL" );
				if (SollwertRH.IDC_AUSSENDURCHMESSER != "undefined" && SollwertRH.IDC_AUSSENDURCHMESSER_SONDER_CHECK == "")
				{	
					this.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo = SollwertRH.IDC_AUSSENDURCHMESSER*1;
					this.oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo = SollwertRH.IDC_NENNWEITE_DN*1;
					this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = 0;
				}
				else if (SollwertRH.IDC_AUSSENDURCHMESSER != "undefined" && SollwertRH.IDC_AUSSENDURCHMESSER_SONDER_CHECK != "")
				{
					this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = SollwertRH.IDC_AUSSENDURCHMESSER_SONDER*1;
					this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = 1;
				}
				if (SollwertRH.IDC_TEMPERATUR_MEDIUM != "undefined")
					this.oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium = SollwertRH.IDC_TEMPERATUR_MEDIUM*1;
				if (SollwertRH.IDC_DAEMMDICKE != "undefined")
					this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke = SollwertRH.IDC_DAEMMDICKE*1;
			}
		//}
			if (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) == 'object')
				//this.oDlgLagerSession.SollwerteRohrUmTeil = Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil" );
				Base.applyValues(this.oDlgLagerSession.SollwerteRohrUmTeil,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil" ));
		}
		return this.oDlgLagerSession;
	},
	
	/**
	 * getIsolierung Type
	 * @return {String} (ID_UNGEDAEMMT / ID_WAERMEGEDAEMMT / ID_VORISOLIERT)
	 */
	getIsolierung: function(){
		if(this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == 'STD' && this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke == 0 && !this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
			return 'ID_UNGEDAEMMT';
		else if(this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == 'STD' && this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke > 0)
			return 'ID_WAERMEGEDAEMMT';
		else if(this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !== 'STD' || this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
			return 'ID_VORISOLIERT';
	},
   
    getLager : function(){
		if ( this.Lager )
			return( this.Lager );
		return null;
    },
    
	getAbhebesicherung : function(){
		if(this.Abhebesicherung)
			return(this.Abhebesicherung);
		return null;	
	},
	
	getGleitelement: function(){
		if ( this.Gleitelement )
			return( this.Gleitelement );
		return null;
	},
	
	getRollenlager: function(){
		if ( this.Rollenlager )
			return( this.Rollenlager );
		return null;
	},
	
	getSattel: function(){
		if ( this.Sattel )
			return( this.Sattel );
		return null;
	},
	
	getKlemmsystem : function(){
        if (this.Klemmsystem)
            return this.Klemmsystem;
            
        return null;
    },
	   
    getEinzelprodukt : function() 
    {
        // Objekte:
        if ( this.Lager )
            return this.Lager;
		if ( this.Klemmsystem )
			return this.Klemmsystem;
		if ( this.Gleitelement )
			return this.Gleitelement;
		if ( this.Abhebesicherung )
			return this.Abhebesicherung;	
		if ( this.Rollenlager )
			return this.Rollenlager;		
		if ( this.Sattel )
			return this.Sattel;			
		
        return null;    // noch nichts gewhlt
    },
	
	getDrehDir : function(stkList, Drehung) 
	{
		var Rohrrichtung	= caMainController.dataAccess.getLastketteRohrrichtung();
		var Achsinfo		= caMainController.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var KoordVar		= right(getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"),1)*1;
		var STKListLength	= stkList.length;
		
		//if ((Achsinfo[0] != Rohrrichtung) && stkList.length < 1){
		if (Achsinfo[0] != Rohrrichtung){
			switch (Achsinfo[0]){
			case 'Z':
				if ((Rohrrichtung == 'X' && (KoordVar == 2 || KoordVar == 4)) ||
						(Rohrrichtung == 'Y' && (KoordVar == 1 || KoordVar == 3)))
				Drehung	+= 90;
				break;
			case 'Y':
				//if ((Rohrrichtung == 'Z' && (KoordVar == 2) || (KoordVar == 4)) ||
						//(Rohrrichtung == 'Y' && (KoordVar == 1) || (KoordVar == 3)))
				if ((Rohrrichtung == 'Z' && (KoordVar == 1 || KoordVar == 3)) ||
						(Rohrrichtung == 'X' && (KoordVar == 2 || KoordVar == 4)))
				Drehung	+= 90;
				break;
			case 'X':
				if ((Rohrrichtung == 'Y' && (KoordVar == 2 || KoordVar == 4)) ||
						(Rohrrichtung == 'Z' && (KoordVar == 1 || KoordVar == 3)))
				Drehung	+= 90;
				break;
			}
		}
		//else if (stkList.length >= 1)	// Fall LK doppelt hngend
			//Drehung	+= 90;
			//Drehung	= 0;	// wir ber CAD-Params gesteuert
		
		return Drehung;
	},
	
	/**
	 * Erstelle Stckliste fr Lastkette
	 */
	getStueckliste : function(stkList) 
	{
        var stkListPart;
        //var oHoehenmasse = this.dataAccess.getHoehenMasse(this.isDritteHLinie());
		var oHoehenmasse = caMainController.dataAccess.getHoehenMasse(this.isDritteHLinie());

        var dMiddle   	= 0;
		var strTypOf  	= typeof(oHoehenmasse);
		var dZ        	= (strTypOf != 'object') ? '' : atoi(oHoehenmasse.H1);
		var LKLastabtr	= caMainController.dataAccess.getLastketteLastabtragung();
		if (LKLastabtr == "HAENGEND_DOPPEL"){
			dZ        	= (strTypOf != 'object') ? '' : atoi(oHoehenmasse.H3);
			dMiddle		= caMainController.dataAccess.getSpannweite(1) / 2;
		}
        
		var DrehDir	= getDrehDir(stkList, this.Drehung, this.Lager.getTopoPic);
		
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        
        if ( this.Lager )
        {
			// fr LKx 10 muss der Name und der Preis "manipuliert" werden -> sofern noch nicht geschehen
			// Hintergrund: Pseudo-Klemmsystem wird nicht in StLi aufgefhrt
			if (this.Klemmsystem && left(this.Lager.strBaureihe, 2) == "LK" && this.Lager.strBauF*1 == 10)
				//&& rfind(this.Lager.m_Ptyp, "-T") == -1 && rfind(this.Lager.m_Ptyp, "-U") == -1 && rfind(this.Lager.m_Ptyp, "-L") == -1)
			{
				var NameKSYTeil	= this.Klemmsystem.m_Ptyp.split("-");
				//var NameLAGTeil	= this.Lager.m_Ptyp.split("-");
				var NameLAGTeil	= this.Lager.oData.TYP.split("-");
				var NamenNeu	= "";
				for (var i=0; i<NameLAGTeil.length; i++){
					NamenNeu	+= NameLAGTeil[i] + "-";
					if (i+1 == NameLAGTeil.length-1)
						NamenNeu	+= NameKSYTeil[1] + "-";
				}
				// Name
				this.Lager.m_Ptyp	= trimright(NamenNeu, '-');
				// Preis
				if (this.Klemmsystem.m_Ppreis * 1 != 0 && this.Lager.m_Ppreis * 1 != 0){
					var ObflFakt				= Base.getOberflaechenFaktor(Oberflaechenschutz[this.Lager.m_Poberfl]) * 1;
					this.Lager.m_Ppreis			= this.Klemmsystem.m_Ppreis * 1 + this.Lager.oData.PREIS_0 * 1 + this.Lager.oData.GEW * 1 * ObflFakt;
					this.Lager.oData.PREIS		= this.Lager.m_Ppreis;
					this.Lager.oData.PREIS_Tab	= this.Lager.m_Ppreis;
				}
				else{
					this.Lager.m_Ppreis			= 0;
					this.Lager.oData.PREIS		= "";
					this.Lager.oData.PREIS_Tab	= "";
				}
			}
			// neue Funktion in der Lastkette: LAG fr Lager
			// --> das muss noch weiterverarbeitet werden
			//stkListPart = { anz: (this.Lager.m_qty ? this.Lager.m_qty : 1), funktion : "LAG", position : "O", 
			stkListPart = { anz: (this.Lager.m_qty ? this.Lager.m_qty : 1), funktion : "LAG", position : "U",
                            produkt : this.Lager,
                            //threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
							threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehDir}]  };
            stkList.push( stkListPart );
			dZ -= stkListPart.produkt.m_Pemass;
        }
		
		// @@@ LGE Test
		// Klemmsystem nach Gleitelement
		/*
		if ( this.Klemmsystem && this.Klemmsystem.strBaureihe != "KSY" )	// die Pseudo-Klemmsysteme nicht anzeigen (LKx 10)
        {
			// neue Funktion in der Lastkette: KSY fr Klemmsystem
			var dStueck	= (this.Klemmsystem.m_qty ? this.Klemmsystem.m_qty : 1);
			stkListPart = { anz: dStueck, funktion : "KSY", position : "O", 
                            produkt : this.Klemmsystem,
                            //threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
							threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehDir}]  };
            stkList.push( stkListPart );
			dZ -= stkListPart.produkt.m_Pemass;
        }
		*/
		
		if ( this.Abhebesicherung )
        {
			// neue Funktion in der Lastkette: 
			// --> das muss noch weiterverarbeitet werden
			var oTest = this.Abhebesicherung,
            stkListPart = { anz: this.Abhebesicherung.m_qty, funktion : "ABE", position : "O", 
                            produkt : this.Abhebesicherung,
                            //threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
							threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehDir}]  };
            stkList.push( stkListPart );
			dZ -= stkListPart.produkt.m_Pemass;
        }
		
		if ( this.Gleitelement )
        {
			//@@@ LGE Test
			var NamenNeu	= "";
			if (this.Klemmsystem && this.Gleitelement.m_Ptypid == "LGE"){
				var NameKSYTeil	= this.Klemmsystem.m_Ptyp.split("-");
				var NameLGETeil	= this.Gleitelement.m_Ptyp.split("-");
				for (var i=0; i<NameLGETeil.length; i++){
					if (i != 1)
						NamenNeu	+= NameLGETeil[i];
					else
						NamenNeu	+= NameKSYTeil[1];
					if (i+1 != NameLGETeil.length)
						NamenNeu	+= "-";
				}
				this.Gleitelement.m_Ptyp	= NamenNeu;
			}
			/*
			if (this.Lager && this.Gleitelement.m_Ptypid == "LGE"){
				var RepPTFE	= ".0";
				if (this.Lager.m_Pwerkstoff	!= "W_RST")
					RepPTFE	= ".1";
				this.Gleitelement.m_Ptyp	= this.Gleitelement.m_Ptyp.replace(".x", RepPTFE);
			}
			*/
			// neue Funktion in der Lastkette: 
			// --> das muss noch weiterverarbeitet werden
			var myQty = 1;
			if ( this.Lager ) {
				if ( this.Lager.anzGleitelemente && (this.Lager.anzGleitelemente > 0) && (this.Gleitelement.m_Ptypid != "LGE") )
					myQty = this.Lager.anzGleitelemente;
			}			
			
            stkListPart = { anz: myQty, funktion : "GEL", position : "O", 
                            produkt : this.Gleitelement,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
            stkList.push( stkListPart );
			dZ -= stkListPart.produkt.m_Pemass;
        }
		
		//@@@ LGE Test
		if ( this.Klemmsystem && this.Klemmsystem.strBaureihe != "KSY" )	// die Pseudo-Klemmsysteme nicht anzeigen (LKx 10)
        {
			// neue Funktion in der Lastkette: KSY fr Klemmsystem
			var dStueck	= (this.Klemmsystem.m_qty ? this.Klemmsystem.m_qty : 1);
			stkListPart = { anz: dStueck, funktion : "KSY", position : "O", 
                            produkt : this.Klemmsystem,
                            //threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
							threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : DrehDir}]  };
            stkList.push( stkListPart );
			dZ -= stkListPart.produkt.m_Pemass;
        }
        
		if ( this.Rollenlager )
        {
			// neue Funktion in der Lastkette: 
			// --> das muss noch weiterverarbeitet werden
            stkListPart = { anz: 1, funktion : "ROL", position : "O", 
                            produkt : this.Rollenlager,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
            stkList.push( stkListPart );
        }
		
		if ( this.Sattel )
        {
			// neue Funktion in der Lastkette: 
			// --> das muss noch weiterverarbeitet werden
            stkListPart = { anz: 1, funktion : "SAT", position : "O", 
                            produkt : this.Sattel,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
            stkList.push( stkListPart );
        }
		
        // Jetzt ber die Liste iterieren und die Anzahl der Muttern bestimmen, 
        // sowie Gesamtgewicht und Gesamtpreis...
        this.bestimmeMutternPreiseGewichte(stkList, 1);     // ohne Muttern

        return;
    },

	/**
     *  hole den Filenamen fr das Kopfmodell fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-DXF fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-INI fr die 3D CAD Darstellung der Lastkette
	 *
	 * @params -
	 * @returns	string Filenamen des Kopfmodells (ohne Pfadangaben)
     */
    getCadInfos : function(bQuick2D, bHaengerMitFussplatte, bLageplanVorhanden)
	{
        var oRet = { headModel		: 'AW_LKtyp_neu.cc3',
                     rahmenDxf		: 'Rahmen-wit_LG_RL',
					 rahmenIni		: 'Rahmen-wit_LG_RL.ini',
                     lagerEinzel	: 0,
                     lagerFuss		: 0,
					 lagerFussTyp	: 'empty'
                     };
		
		// alle Rollenlagerkomponenten haben anderes Kopfmodell
		if( this.Rollenlager || this.Sattel || (this.Abhebesicherung && this.Abhebesicherung.strBaureihe != "LAW") )
		{
			oRet.headModel	= "Auswahl_RL_Sattel.cca";
		}
        
		if ( this.Lager )
        {
            oRet.lagerEinzel = 1;
            //oRet.rahmenDxf = "Rahmen-wit_LG";
            //oRet.rahmenIni = "Rahmen-wit_LG.ini";
            
            if ((left(this.Lager.m_Ptyp, 3) == "FSN") ||
                (left(this.Lager.m_Ptyp, 3) == "FSD")){
				oRet.lagerFuss = 1;
				oRet.lagerFussTyp = 'FS';	// FSN / FSD / FHS / FSS / FSP
			}
        }
        else if (this.Klemmsystem && this.bKlemmsystem)
        {
            oRet.lagerEinzel = 1;
            oRet.rahmenDxf = "Rahmen-wit_KSY";
            oRet.rahmenIni = "Rahmen-wit_KSY.ini";        
        }
		if (this.Gleitelement.m_Ptypid == "LGV"){
			oRet.lagerFuss = 1;
			if (this.Gleitelement.oData.ANZ_BOHR*1 <= 2)
				oRet.lagerFussTyp = 'LGV1';	// LGV mit PTFE rund
			else
				oRet.lagerFussTyp = 'LGV2';	// LGV mit PTFE eckig
		}
		
		return( oRet );
	},
			
    getCADDaten : function()
    {
        // Allgemeine Einstellungen zur Darstellung:
        var aParams = this.getGlobalCADParameters();
		// Parameter des Modells
		if( this.Rollenlager || this.Sattel ||
			(this.Abhebesicherung && this.Abhebesicherung.m_Ptypid != "LAW"))
		{
			// Rollenlager
			if (this.Rollenlager){
				aParams.push( [ "Rollenlager", this.Rollenlager.strBaureihe ] );
				aParams.push( [ "Groesse", "0" + right(this.Rollenlager.strBauF, 2) ] );
				aParams.push( [ "Nennlast", this.Rollenlager.oData.F_AUFL ] );
				aParams.push( [ "Verschiebung", this.Rollenlager.oData.W_QUER_NENN ] );
				if (!this.Sattel && !this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager)
					aParams.push( [ "Rohraussendurchmesser",this.oDlgLagerSession.AuswahlRollenlager.dSupportDiameter ] );
				else if (!this.Sattel){
					var DAufl	= (this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager.DA_MAX*1+
									this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager.DA_MIN*1)/2
					aParams.push( [ "Rohraussendurchmesser",DAufl ] );
				}
			}
			else
				aParams.push( [ "Rollenlager", 0 ] );
			// Klemmsystem
			if (this.Klemmsystem){
				aParams.push( [ "Klemmsystem", this.Klemmsystem.oData.PROFILFORM ] );
				aParams.push( [ "Traegerbreite", this.oDlgLagerSession.AuswahlStandard.dBeamWidth ] );
				aParams.push( [ "Traegerhoehe", this.oDlgLagerSession.AuswahlStandard.dBeamHeight ] );
				aParams.push( [ "Flanschdicke", this.oDlgLagerSession.AuswahlStandard.dBeamThickness ] );
			}
			else
				aParams.push( [ "Klemmsystem", 0 ] );
			//Sattel
			if(this.Sattel){
				aParams.push( [ "Sattel", this.Sattel.strBaureihe ] );
				if (this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "STD" &&
					!this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
				// Manteldurchmesser aus Pulldownmenue - Standardwert
					aParams.push( [ "Rohraussendurchmesser",this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo ] );
				else if (this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "STD" &&
					this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
				// Manteldurchmesser Sondereingabe
					aParams.push( [ "Rohraussendurchmesser",this.oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder ] );
				else if (!this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
				// Standardrohraussendurchmesser
					aParams.push( [ "Rohraussendurchmesser",this.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo ] );
				else
				// Sonderrohraussendurchmesser
					aParams.push( [ "Rohraussendurchmesser",this.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder ] );
				
				//aParams.push( [ "Rohraussendurchmesser", this.Sattel.oData.DM ? this.Sattel.oData.DM : this.Sattel.oData.D ] );
				//aParams.push( [ "Daemmdicke", this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke ] );
				aParams.push( [ "Daemmdicke", this.Sattel.oData.J_MAX ] );
				if (this.oDlgLagerSession.AuswahlSattel.bSonderLength)
					aParams.push( [ "Sattellaenge", this.oDlgLagerSession.AuswahlSattel.dSonderLength ] );
				else
					aParams.push( [ "Sattellaenge", this.oDlgLagerSession.AuswahlSattel.strSelComboLength ] );
				aParams.push( [ "Werkstoff", this.Sattel.oData.WERKSTOFF ] );
				if (this.Sattel.strBaureihe == "ITB")
					aParams.push( [ "Sattelfuss", "T" + this.Sattel.oData.A ] );
				else if (this.Sattel.strBaureihe == "SMR")
					aParams.push( [ "SMR Form", "Form " + this.Sattel.oData.FORM ] );
			}
			else
				aParams.push( [ "Sattel", 0 ] );
			// Abhebesicherung
			if(this.Abhebesicherung){
				aParams.push( [ "Abhebesicherung", this.Abhebesicherung.strBaureihe ] );
				aParams.push( [ "Auflagedurchmesser", this.Sattel ? this.Sattel.oData.DA : this.oDlgLagerSession.AuswahlRollenlager.dSupportDiameter ] );
				if (toupper(right(this.Abhebesicherung.strBaureihe, 1)) == "M"){
					var TypSplit	= splitVarDelimiter(this.Abhebesicherung.m_Ptyp, " ..-.");
					aParams.push( [ "Aufl_DMR", TypSplit[2]*1 ] );
				}
			}
			else
				aParams.push( [ "Abhebesicherung", 0 ] );
		}
		else		// Lastketten (Hnger, Schellen, Gleitlager, Festpunkte)
			aParams		= this.getCADParameters(aParams);
		
		return( aParams );
    },
	/**
	 * Erstelle Tabelle mit fr GUI Anzeige "Bisherige Eingaben"
	 */
	getDescription: function(strDialogId){
		var aHistory = this.oDlgLagerSession.DialogHistoryIDs;
		var data = {
			values : [
            ]
        };
		
		var _getTraegerArray = function(oDlg){
			var strSql = "SELECT * FROM PROFILART WHERE ID = '"+oDlg.strSelComboBeamArt+"'";
			var dbName				= 'LAGER2';
			var dbNameTable 		= "PROFILART";
			var strText				= '';
			var dTableDatenLength 	= dbselect( dbName, strSql, dbNameTable );
			if ( dbselect( dbName, strSql, dbNameTable ) > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					strText = dbgetstring(dbNameTable,"PROFILART");
					dbskip( dbNameTable );
				}
			}
			
			data.values[(data.values.length-1)].rows.push([translate("IDC_PROFILART_RH_LABEL"),strText,'','&nbsp;']);
			data.values[(data.values.length-1)].rows.push([translate("IDC_TRAEGERGROESSE_LABEL"),oDlg.strSelComboBeamSize,'','&nbsp;']);
			
			data.values[(data.values.length-1)].rows.push([translate("TRAEGERHOEHE"),oDlg.dBeamHeight,'','&nbsp;']);
			data.values[(data.values.length-1)].rows.push([translate("TRAEGERBREITE"),oDlg.dBeamWidth,'','&nbsp;']);
			data.values[(data.values.length-1)].rows.push([translate("IDC_FLANSCHDICKE_LABEL"),oDlg.dBeamThickness,'','&nbsp;']);
		}
		if (getstring("OPEN_MODE_CASCADE", "") == "MODIFY")
				data.values.push({
					title: '',
					rows: [
						[ translate('IDD_START')+' '+translate('POS'),getstring("POS", "DLGDATA"),'&nbsp;']
					]
				});
		for(var a=0;a<aHistory.length;a++){
			if(aHistory[a] == strDialogId)
				break;
			switch(aHistory[a]){
				case "lager.systemcharakteristik" :
						data.values.push({
							title: translate('LAGER_SYSTEMCHARAKTERISTIK'),
							rows: [
								[ translate('IDC_LAGER_LABEL'),translate(this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager),'','&nbsp;']
							]
						});
					break;
				case "lager.sollwerte_halterungspunkt" :
						data.values.push({
							title: translate('SOLLWERTE_HALTERUNGSPUNKT'),
							rows: [
								[
									"",
									" "+translate("ID_HEADER_AXIAL")+ " | "+translate("ID_HEADER_QUER")+" | "+translate("ID_HEADER_LASTRICHT"),
									'',
									'&nbsp;'
								],
								[
									translate("LAST")+" + ",
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief,
									'kN',
									'&nbsp;'
								],
								[
									translate("LAST")+" - ",
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief,
									'kN',
									'&nbsp;'
								],
								//Zusatzlast
								[
									translate("ZUSATZLAST_GESCHAETZT"),
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.zusatzlast.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.zusatzlast.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.zusatzlast.schief,
									'kN',
									'&nbsp;'
								],
								//berlast
								[
									translate("UEBERLAST"),
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.ueberlast.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.ueberlast.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.ueberlast.schief,
									'kN',
									'&nbsp;'
								],
								//Bewegung +
								[
									translate("BEWEGUNG")+" + ",
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief,
									'mm',
									'&nbsp;'
								],								
								//Bewegung -
								[
									translate("BEWEGUNG")+" - ",
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief,
									'mm',
									'&nbsp;'
								],
								//Einfgepunkt Rohrmitte
								[
									translate("EINFUEGEPUNKT_ROHRMITTE"),
									this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.axial+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.quer+" | "+this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.schief,
									'mm',
									'&nbsp;'
								]
							]
						});
					break;	
				case "lager.sollwerte_rohrumschliessendesteil" :
						data.values.push({
							title: translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL'),
							rows: [
								[translate('IDC_TEMPERATUR_LABEL'),this.oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium,translate("WS_UNIT_GRAD_CELSIUS"),'&nbsp;'],
								[translate('IDC_NENNWEITE_DN_LABEL'),this.oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']
							]
						});
						
						if(this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
							data.values[(data.values.length-1)].rows.push([translate('AUSSENDURCHMESSER'),this.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
						else
							data.values[(data.values.length-1)].rows.push([translate('AUSSENDURCHMESSER'),this.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
					
						if(this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
							data.values[(data.values.length-1)].rows.push([translate('IDC_MANTELDURCH_LABEL'),this.oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
						else if(this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !== 'STD')
							data.values[(data.values.length-1)].rows.push([translate('IDC_MANTELDURCH_LABEL'),this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
						else if(this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke > 0)
							data.values[(data.values.length-1)].rows.push([translate('DAEMMDICKE'),this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
						
						if(this.oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage>0)
							data.values[(data.values.length-1)].rows.push([translate('SCHELLENEINLAGE'),this.oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage,translate("IDC_BERECHNETE_LAENGE_EINHEIT"),'&nbsp;']);
						
						data.values[(data.values.length-1)].rows.push([translate('PRINT_MB_WERKSTOFF'),Produkt.getWerkstoffeAnzeigename(this.oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff.replace("LAGER_","")),'','&nbsp;']);
						
					break;
				case "lager.auswahl_standard" :
						data.values.push({
							title: '',
							rows: [
							]
						});
						
						var aTypData = [
							translate("IDC_LAGER_LABEL")+" "+translate("IDS_TYP"),
							(this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.TYP_CALCULATION : this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.TYP),
							'',
							'&nbsp;'
						];
						data.values[(data.values.length-1)].rows.push(aTypData);
						
						if(this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung){
							var aTypData = [
								translate("IDC_ABHEBESICHERUNG_LABEL")+" "+translate("IDS_TYP"),
								(this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung.TYP_CALCULATION : this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung.TYP),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aTypData);
						}
						
						if(this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement){
							var aTypData = [
								translate("GLEITELEMENT")+" "+translate("IDS_TYP"),
								(this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement.TYP_CALCULATION : this.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement.TYP),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aTypData);
						}
						
						// NUN noch der Rest
						if(caMainController.getLagerTopologieklasse().isGleitlager()){
							data.values[(data.values.length-1)].title = translate('LAGER_AUSWAHL_LAGERSCHLITTEN');
							//Function
							var aLagerart = [
								translate("LAGER_FUER_LAGERART")+" "+translate("IDS_TYP"),
								translate("LAGER_"+this.oDlgLagerSession.AuswahlStandard.strSelRadioFunction),
								'',
								'&nbsp;'
							];	
							data.values[(data.values.length-1)].rows.push(aLagerart);
						}
						
						
						if(this.oDlgLagerSession.AuswahlStandard.bHoehenverstellbar){
							var aHoehenverstellbar = [
								translate("IDC_HOEHENVERSTELLBAR_LABEL"),
								'',
								'',
								'&nbsp;'
							];	
							data.values[(data.values.length-1)].rows.push(aHoehenverstellbar);
						}
						
						if(this.oDlgLagerSession.AuswahlStandard.bGaT){
							var aGaT = [
								translate("IDC_GLEITUNTERLAGE_LABEL"),
								'',
								'',
								'&nbsp;'
							];	
							data.values[(data.values.length-1)].rows.push(aGaT);
						}
						
						if(this.oDlgLagerSession.AuswahlStandard.strSelComboAccessory != '-'){
							var aAnschlussteil = [
								translate("IDC_ANSCHLUSSTEILE_LABEL"),
								translate("LAGER_"+this.oDlgLagerSession.AuswahlStandard.strSelComboAccessory),
								'',
								'&nbsp;'
							];	
							data.values[(data.values.length-1)].rows.push(aAnschlussteil);
						}
						
						if(this.oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart != '-'){
							var aGleitelement = [
								translate("IDC_GLEITELEMENT_LABEL"),
								translate(this.oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart),
								'',
								'&nbsp;'
							];	
							data.values[(data.values.length-1)].rows.push(aGleitelement);
						}
						
						var aOberflaechenschutz = [
							translate("IDC_OBFL_RAHMEN_TEXT"),
							Base.getLanguageTextOberflaeche(this.oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel).strText,
							'',
							'&nbsp;'
						];
						data.values[(data.values.length-1)].rows.push(aOberflaechenschutz);
						
						
						if(caMainController.getLagerTopologieklasse().isFestlager()){
							data.values[(data.values.length-1)].title = translate("LAGER_AUSWAHL");
							//Befestigung
							if(this.oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "KLEMMBAR"){
								var aKlemmbar = [
									translate("LAGER_BEFESTIGUNG_BAUWERK_LABEL"),
									translate("IDC_KLEMMBAR_LABEL"),
									'',
									'&nbsp;'
								];
								data.values[(data.values.length-1)].rows.push(aKlemmbar);
								//Trgerdaten
								_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);
							}
							else{
								var aSchraubbar = [
									translate("LAGER_BEFESTIGUNG_BAUWERK_LABEL"),
									translate("IDC_SCHRAUBBAR_LABEL")+" "+translate("IDC_"+this.oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn+"_LABEL"),
									'',
									'&nbsp;'
								];
								data.values[(data.values.length-1)].rows.push(aSchraubbar);
							}
							//Trgerdaten
							//_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);
						}	
						
					break;
				case "lager.auswahl_rollenlager_direkt" :
							data.values.push({
								title: translate("LAGER_AUSWAHL_ROLLENLAGER_DIREKT"),
								rows: [
								]
							});
							
							if(this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult){
								var aTypData = [
									translate("IDS_TYP"),
									(this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager.TYP_CALCULATION : this.oDlgLagerSession.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager.TYP),
									'',
									'&nbsp;'
								];
								data.values[(data.values.length-1)].rows.push(aTypData);
							}
							
							var aLagerart = [
								translate("LAGER_FUER_LAGERART"),
								translate("LAGER_ROLLENLAGER_DIREKT_"+this.oDlgLagerSession.AuswahlRollenlagerDirekt.strRadio),
								'',
								'&nbsp;'
							];
							
							if(this.oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck)
								_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);
								
							data.values[(data.values.length-1)].rows.push(aLagerart);
					break;
				case "lager.auswahl_rollenlager" :
						data.values.push({
							title: '',
							rows: [
							]
						});
						
						if(this.oDlgLagerSession.AuswahlRollenlager.oSearchResult){
							var aTypData = [
								translate("IDS_TYP"),
								(this.oDlgLagerSession.AuswahlRollenlager.oSearchResult.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlRollenlager.oSearchResult.TYP_CALCULATION : this.oDlgLagerSession.AuswahlRollenlager.oSearchResult.TYP),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aTypData);
						}
						
						if(this.oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint){
							var aAbhebesicherung = [
								translate("IDC_ABHEBESICHERUNG_LABEL"),
								'',
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aAbhebesicherung);
						}
						
						var _lagerart = function(strSelComboTyp){
							var aLagerart = [
								translate("LAGER_FUER_LAGERART"),
								translate("LAGERART_"+strSelComboTyp),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aLagerart);
						}
						
						switch(this.oDlgLagerSession.AuswahlRollenlager.strDialogId){
							case "ROLLENLAGER_S" 	:
							case "ROLLENLAGER_P"	:
									data.values[(data.values.length-1)].title = (this.oDlgLagerSession.AuswahlRollenlager.strDialogId == "ROLLENLAGER_S" ? translate("LAGER_AUSWAHL_ROLLENLAGER") : translate("LAGER_AUSWAHL_ROLLENLAGER_UEBER_PARAMETER"));
									//LagerArt
									_lagerart(this.oDlgLagerSession.AuswahlRollenlager.strSelComboTyp);
									
									if(this.oDlgLagerSession.AuswahlRollenlager.strDialogId == "ROLLENLAGER_P"){
										//Auflagedurchmesser
										if(this.oDlgLagerSession.AuswahlRollenlager.dSupportDiameter){
											var aAuflagedurchmesser = [
												translate("LAGER_AUFLAGEDURCHMESSER"),
												this.oDlgLagerSession.AuswahlRollenlager.dSupportDiameter,
												'mm',
												'&nbsp;'
											];
											data.values[(data.values.length-1)].rows.push(aAuflagedurchmesser);									
										}
										//Fussbreite
										if(this.oDlgLagerSession.AuswahlRollenlager.dFeetWide){
											var aFussbreite = [
												translate("LAGER_ROLLEN_FUSSBREITE"),
												this.oDlgLagerSession.AuswahlRollenlager.dFeetWide,
												'mm',
												'&nbsp;'
											];
											data.values[(data.values.length-1)].rows.push(aFussbreite);									
										}
									}
									//Function
									var aFunction = [
										translate("LAGER_FUNCTION_LABEL"),
										translate("LAGER_"+this.oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing),
										'',
										'&nbsp;'
									];
									data.values[(data.values.length-1)].rows.push(aFunction);
									//Befestigung
									var aBefestigung = [
										translate("LAGER_BEFESTIGUNG_BAUWERK_LABEL"),
										translate("IDC_"+this.oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction+"_LABEL"),
										'',
										'&nbsp;'
									];
									data.values[(data.values.length-1)].rows.push(aBefestigung);
									
									//Trger
									if(this.oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction == 'KLEMMBAR')
										_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);
								break;
							case "ROLLENLAGER_K" :
									data.values[(data.values.length-1)].title = translate("LAGER_AUSWAHL_ROLLENLAGER_KLEMMSYSTEM");
									//Trger
									if(this.oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction == 'KLEMMBAR')
										_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);
								break;
							case "ROLLENLAGER_U_SATTEL" :
									//LagerArt
									_lagerart(this.oDlgLagerSession.AuswahlRollenlager.strSelComboTyp);
									//Sattel
									
									data.values[(data.values.length-1)].title = translate("LAGER_AUSWAHL_ROLLENLAGER_UND_SATTEL");
								break;
						}
					break;
				case "lager.auswahl_sattel" :
						data.values.push({
							title: translate("LAGER_AUSWAHL_SATTEL"),
							rows: [
							]
						});
						
						if(this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel){
							var aTypData = [
								translate("LAGER_SATTEL_LABEL")+" "+translate("IDS_TYP"),
								(this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.TYP_CALCULATION : this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.TYP),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aTypData);
						}
						
						if(this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung){
							var aTypData = [
								translate("IDC_ABHEBESICHERUNG_LABEL")+" "+translate("IDS_TYP"),
								(this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung.TYP_CALCULATION ? this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung.TYP_CALCULATION : this.oDlgLagerSession.AuswahlSattel.oSearchResult.oResultAbhebesicherung.TYP),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aTypData);
						}
						
						if(this.oDlgLagerSession.AuswahlSattel.bActuator){
							var aZylinderrollenlager = [
								translate("LAGER_ZYLINDER_ROLLENLAGER"),
								'',
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aZylinderrollenlager);
						}
						
						if(this.oDlgLagerSession.AuswahlSattel.bUpliftRestraint){
							var aAbhebesicherung = [
								translate("IDC_ABHEBESICHERUNG_LABEL"),
								'',
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aAbhebesicherung);
						}
						
						if(this.oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart){
							var aRohrumschluss = [
								translate("LAGER_ROHRUMSCHLUSS"),
								translate("LAGER_"+this.oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aRohrumschluss);
						}
						
						if(this.oDlgLagerSession.AuswahlSattel.bRadioWeldEnd){
							var aZumAnschweissen = [
								translate("LAGER_ZUM_ANSCHWEISSEN"),
								translate("LAGER_"+this.oDlgLagerSession.AuswahlSattel.strRadioWeldEnd),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aZumAnschweissen);
						}
						
						var aSattellaenge = [
							translate("LAGER_SATTELLAENGE"),
							this.oDlgLagerSession.AuswahlSattel.strSelComboLength,
							'mm',
							'&nbsp;'
						];
						data.values[(data.values.length-1)].rows.push(aSattellaenge);
						
						var aOberflaechenschutz = [
							translate("IDC_OBFL_RAHMEN_TEXT"),
							Base.getLanguageTextOberflaeche(this.oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel).strText,
							'',
							'&nbsp;'
						];
						data.values[(data.values.length-1)].rows.push(aOberflaechenschutz);						
					break;
				case "lager.auswahl_klemmsystem" :
						data.values.push({
							title: (this.oDlgLagerSession.Klemmsystem.strDialogId == "LAGERSYSTEM" ? translate("IDC_AUSWAHL_KLEMMSYS_LABEL") : translate("LAGER_AUSWAHL_LAGERSYSTEM")),
							rows: [
							]
						});
						
						if(this.oDlgLagerSession.Klemmsystem.strDialogId == "LAGERSYSTEM"){
							//Abhebesicherung
							var aAbhebesicherung = [
								translate("IDC_ABHEBESICHERUNG_LABEL"),
								translate("ID_"+this.oDlgLagerSession.Klemmsystem.strSelRadioFixed),
								'',
								'&nbsp;'
							];
							data.values[(data.values.length-1)].rows.push(aAbhebesicherung);							
						}
						else{ //Zubehoer
							
						}
						
						_getTraegerArray(this.oDlgLagerSession.AuswahlStandard);						
					break;
				case "lager.auswahl_zubehoer_ptfe" :
						data.values.push({
							title: translate("LAGER_AUSWAHL_ZUBEHOER_PTFE"),
							rows: [
							]
						});						
					break;
				case "lager.auswahl_standard_sonder" :
						data.values.push({
							title: translate("LAGER_SONDER"),
							rows: [
							]
						});
					break;
			}		
		}
		return data;
	},
    
	/**
     * ! Diese Funktion wird in der neuen Lagerauswahl nicht mehr benutzt ! 
	 * es gibt fr jedes Produkt eine Default berechnung
	 * - die Produkte: Lager, Klemmsystem, ... werden setEmptyProduct alle gelscht:
	 *		1. Dialog Systemcharakteristik 		-> "Initialisierung"
	 *  	2. Dialog Auswahl Lagerschlitten 	-> "Suchen"
	 *		3. Dialog Auswahl Sattel			-> "Suchen"
	 * Basis-Navigationsfunktion -> wird fr die neue Lagerasuwahl nicht mehr benutzt
	 *  statt dessen: Controller.Lager.Common.getNextClientPanel
     */
	getNextPanel : function(activePanel) 
    {
		var nextPanel       = {};

        // Hier immer ein CleanUp fr alles ab einschlielich dem next Panel
        // durchfhren (wichtig, auch fr bersprungene Dialoge):
        this.cleanUp(nextPanel.id);
        
        // Ausnahmsweise: Initialisierung eines Dialogs hier
        if (nextPanel.id == 'uebersicht_lastkette')    
            this.berechneSystemmassInitial();
            
        return nextPanel.toJSON();
	},
	/**
     * ! Diese Funktion wird in der neuen Lagerauswahl nicht mehr benutzt ! 
	 */
	cleanUp : function(nextPanel) 
	{
        switch(nextPanel) 
        {
            default:
                break;
        }
    },
	
	/**
     * @@@@@@@@@  Generelle Frage: Brauchen wir Systemmae bei der Lagerauswahl ?
	 * Dann muss das hier gegebenenfalls angepasst werden auf die Konstellation Lager + Klemmsystem,
	 * bzw. Rollenlager
	 */
    berechneSystemmassInitial : function()
    {
        // --> Aufruf wenn nextPanel = Schlusspanel
        var dLevelRMT = (this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt ? this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.schief : 0);
        var Ema       = 0;

        if (this.Lager)
            Ema += this.Lager.m_Pemass;
        if (this.Klemmsystem)
            Ema += this.Klemmsystem.m_Pemass;
		if (this.Abhebesicherung)
			Ema += this.Abhebesicherung.m_Pemass;
		if (this.Gleitelement)
			Ema += this.Gleitelement.m_Pemass;
		// E = 0,532*DA + Y
		if (this.Rollenlager)
			Ema += this.Rollenlager.m_Pemass;
		if (this.Sattel)
			Ema += this.Sattel.m_Pemass;
			
        // Bei Lagern ist oben der Einfgepunkt (Rohrmitte), unten wird errechnet
		var dLevelOben = dLevelRMT + Ema;
		var dLevelMitte  = dLevelRMT;
        var dLevelUnten = dLevelRMT - Ema;
		
		// Prfung ob 2 oder 3 Level ntig sind
		// Hhenlevel speichern
		if (this.Lager.strBaureihe == "FSD" || 
			(right(this.Lager.strBaureihe, 1) == "F" && 
			(left(this.Lager.strBauF, 1) == "2" || left(this.Lager.strBauF, 1) == "4"))){
				setstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOben);
				setstring("MITTE",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelMitte);
				setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUnten);
		}
        else{
			setstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelMitte);
			setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUnten);
		}
		
    },
    
	/**
     * @@@@@@@@@  Generelle Frage: Brauchen wir Systemmae bei der Lagerauswahl ?
	 * Wenn der Anwender ein Systemma verschiebt, muss das jeweils andere angepasst werden.
	 */
    berechneFlexibleTeileAusSystemmass : function(woVerschoben)
    {
        // Hier gehts eigentlich nur darum, zu verschieben:
        var strMessage = "";

        var dLevelOben	= inputStringToDouble(getstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
		if (getstring("MITTE",   "DLGDATA.CA.FORMS.HOEHENLEVEL") == "")
			var dLevelMitte	= getstring("MITTE",   "DLGDATA.CA.FORMS.HOEHENLEVEL");
		else
			var dLevelMitte	= inputStringToDouble(getstring("MITTE",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
		var dLevelUnten	= inputStringToDouble(getstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL"));

        var Ema    = 0;
        //var hdiff  = dLevelOben - dLevelUnten;

        if (this.Lager)
            Ema	+= this.Lager.m_Pemass;
        if (this.Klemmsystem)
            Ema	+= this.Klemmsystem.m_Pemass;
		if (this.Gleitelement)
			Ema	+= this.Gleitelement.m_Pemass;
		if (this.Rollenlager && !this.Sattel)
			Ema	+= this.Rollenlager.m_Pemass;
		if (this.Sattel && !this.Rollenlager)
			Ema	+= this.Sattel.m_Pemass;
		if (this.Sattel && this.Sattel.strBaureihe != "ITB" && this.Rollenlager)	// Fall nicht ITB
			Ema	+= fround(0.532 * this.Sattel.oData.DA + this.Rollenlager.m_Pemass , 0);
		else if (this.Sattel && this.Rollenlager)	// fall ITB
			Ema	+= this.Sattel.m_Pemass && this.Rollenlager.m_Pemass;
		
		// dieses Vorgehen setzt symmetrischen Aufbau vorraus!!!
        //if (hdiff != Ema)
        //{
			if (woVerschoben == "MITTE"){
				dLevelOben	= dLevelMitte + Ema;
				dLevelUnten	= dLevelMitte - Ema;
			}
			else if (woVerschoben == "OBEN" && dLevelMitte == "")	// Mitte gibt es nicht
				dLevelUnten = dLevelOben - Ema;
			else if (woVerschoben == "OBEN" && dLevelMitte != ""){	// Mitte gibt es
				dLevelMitte	= dLevelOben - Ema;
				dLevelUnten	= dLevelOben - (2 * Ema);
			}
			else if (woVerschoben == "UNTEN" && dLevelMitte == "")	// Mitte gibt es nicht
				dLevelOben	= dLevelUnten + Ema;
			else {
				dLevelMitte = dLevelUnten + Ema;
				dLevelOben	= dLevelUnten + (2 * Ema);
			}
        //}
        
        // Hhenlevel zurckspeichern:
        this.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelOben); 
        
        setstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOben);
		setstring("MITTE",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelMitte);
        setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUnten);

        return strMessage;
    },
	
	/**
	 * Berechnung der Zusatzlast aus den Eigengewichten der Bauteile einer Lastkette
	 * Fr einzelne Lager nicht relevant, deshalb hier auf 0.
	 */
    calculateZusatzlast : function(){
        var zusatzLast = 0;
        
        return zusatzLast;
    },  
    
    getTopologie : function(strDlg)
    {
       // Erluterungen hierzu siehe TopoHaengendEinfach ...
		var rows	= { topoTyp: "1", Pictures: [] };
        var strPic	= "";
		var index	= 1;
        // Unterscheidung ob Einzelbilder oder Kombi-Bild
		var Bildtyp	= "EINZEL";
		var SysChar	= this.oDlgLagerSession.Systemcharakteristik.strSelRadioLager;
		var StkList		= [];
		this.getStueckliste(StkList);
		if ((rfind(SysChar,"ROLL") > 0 && StkList.length > 1) ||	// hier noch weitere Flle ergnzen
			(SysChar == "LAGER_ZUBEHOER" && this.Abhebesicherung))
			Bildtyp	= "KOMBI";
		
		if (Bildtyp == "EINZEL"){
		if ( this.Lager ) {
            strPic = this.Lager.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				if (this.Klemmsystem && this.Klemmsystem.m_Ptypid == "KSY" && this.Klemmsystem.oData.PROFILFORM != "T")		// Pseudo-Klemmsysteme U/L
					strPic	= strPic.replace("_UD", "_UD_" + this.Klemmsystem.oData.PROFILFORM);
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		if ( this.Klemmsystem /* && ( strDlg == 'uebersicht_lastkette' ) */ ) {
			strPic = this.Klemmsystem.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		if ( this.Sattel ) {
            strPic = this.Sattel.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		if ( this.Rollenlager ) {
            strPic = this.Rollenlager.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		if ( this.Gleitelement ) {
            strPic = this.Gleitelement.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		if ( this.Abhebesicherung ) {
            strPic = this.Abhebesicherung.getTopoPic( this.Drehung, true );
			if (strPic != '') {
				rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
				index ++;
			}
		}
		}
		else{
			strPic	= "B_";
			if (this.Rollenlager)
				strPic	+= this.Rollenlager.strBaureihe;
			if (this.Sattel){
				strPic	+= "_" + this.Sattel.strBaureihe;
				
				// Sonderfall SMR hier gibt es zustzlich Bauform "1" und "2"
				if (this.Sattel.strBaureihe == "SMR")
					strPic	+= this.Sattel.oData.FORM;
				}
			if (this.Abhebesicherung && StkList.length == 1)
				strPic	+= this.Abhebesicherung.strBaureihe;
			else if (this.Abhebesicherung)
				strPic	+= "_" + this.Abhebesicherung.strBaureihe;
			if (this.Klemmsystem)
				strPic	+= "_" + this.Klemmsystem.strBaureihe;
			
			if ( strPic == "B_" )
				strPic = "catalog/client/custom/img/panels/TEMPTY.png";
			else
				strPic = "catalog/client/custom/img/WITgifs/RH/" + strPic + ".jpg";
			
			rows.Pictures.push( { id : "topology-img"+index , src : strPic } );
		}
        return rows;
    },
	
	/**
	 * setze Produkte zurck
	 */
	setEmptyProduct : function(){
		this.Lager			 = null;
		this.Klemmsystem     = null;
		this.Abhebesicherung = null;  // sowohl fr Gleitlager als auch Rollenlager
		this.Gleitelement    = null;
		
		this.Rollenlager	 = null;
		this.Sattel	 		 = null;
	},
    
	/**
	 * Soll in allen topologien vorhanden sein, hier nicht relevant, deshalb leer
	 */
	setHaenger : function(myHaenger)
    {
    },
	
	/**
	 * Setzte Drehwinkel fr Bilddarstellung im unteren Bereich.
	 * Aktuell ist das fr Lager nicht relevant, aber vielleicht knftig.
	 */
	setDrehung : function(strDrehteil){
        this.Drehung += 90;
        if (this.Drehung >= 360) this.Drehung = 0;
    },
	
	/**
	 * Funktion fr Gleit und Festlager
	 * Selektierte Werte in die Lastenkette bertragen
	 */
    setGleitFestLager : function( oDlgLager ) 
    {       
		var dObjectLength = oDlgLager.AuswahlStandard.oSearchResult.length;
		for(var a=0;a<dObjectLength;a++){			
			if(a==0){				
				this.Lager = new Lager2();
				this.Lager.init(oDlgLager,oDlgLager.AuswahlStandard.oSearchResult.oResultLager);
			}
			else{ //DIESE VARIANTEN GIBT ES AUCH - DARF NICHT VERGESSEN WERDEN				
				if(oDlgLager.AuswahlStandard.oSearchResult.oResultAbhebesicherung){
					this.Abhebesicherung  = new Abhebesicherung2();					
					if(oDlgLager.AuswahlStandard.strSelComboAccessory == 'ABHEBESICHERUNG_4')
						this.Abhebesicherung.init(oDlgLager,oDlgLager.AuswahlStandard.oSearchResult.oResultAbhebesicherung,4);					
					else
						this.Abhebesicherung.init(oDlgLager,oDlgLager.AuswahlStandard.oSearchResult.oResultAbhebesicherung,2);
				}
				else if(oDlgLager.AuswahlStandard.oSearchResult.oResultGleitelement){
					this.Gleitelement  = new Gleitelement2();
					this.Gleitelement.init(oDlgLager,oDlgLager.AuswahlStandard.oSearchResult.oResultGleitelement);					
				}
				else{
					alert("GleitFestLager oSearchResult ist > 1 und es existiert ein Object ungleich Abhebesicherung und Gleitelement");
				}
			}			
		}
    },
	
	/**
	 * Funktion fr Rollenlager
	 * Selektierte Werte in die Lastenkette bertragen
	 */
	setRollenLager: function(oDlgLager,strMode){
		var dObjectLength;
		if(strMode == "DIREKT")
			dObjectLength = oDlgLager.AuswahlRollenlagerDirekt.oSearchResult.length;
		else
			dObjectLength = oDlgLager.AuswahlRollenlager.oSearchResult.length;
		
		for(var a=0;a<dObjectLength;a++){
			if(a==0){
				if(strMode == "ABHEBSICHERUNG"){ //kommt nur bei Zubehr : Abhebesicherung fr Rollenlager und Sattel cor
					this.Abhebesicherung  = new Abhebesicherung2();
					this.Abhebesicherung.init(oDlgLager,oDlgLager.AuswahlRollenlager.oSearchResult.oResultRollenlager);
				}
				else if(oDlgLager.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_K'){
					this.Klemmsystem = new Klemmsystem2();
					this.Klemmsystem.init(oDlgLager,oDlgLager.AuswahlRollenlager.oSearchResult.oResultRollenlager);
				}
				else{
					var oRollelager;
					if(strMode == "DIREKT"){
						oRollelager = oDlgLager.AuswahlRollenlagerDirekt.oSearchResult.oResultRollenlager;
						if(oDlgLager.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem){
							this.Klemmsystem = new Klemmsystem2();
							this.Klemmsystem.init(oDlgLager,oDlgLager.AuswahlRollenlagerDirekt.oSearchResult.oResultKlemmsystem);
						}
						else
							this.Klemmsystem = null;
					}
					else{
						if(oDlgLager.AuswahlRollenlager.oSearchResult.oResultAbhebesicherung){
							this.Abhebesicherung  = new Abhebesicherung2();
							this.Abhebesicherung.init(oDlgLager,oDlgLager.AuswahlRollenlager.oSearchResult.oResultAbhebesicherung);
						}
						else
							this.Abhebesicherung  = null;
						
						if(oDlgLager.AuswahlRollenlager.oSearchResult.oResultKlemmsystem){
							this.Klemmsystem = new Klemmsystem2();
							this.Klemmsystem.init(oDlgLager,oDlgLager.AuswahlRollenlager.oSearchResult.oResultKlemmsystem);
						}
						else
							this.Klemmsystem = null;
						
						oRollelager = oDlgLager.AuswahlRollenlager.oSearchResult.oResultRollenlager;
					}
					this.Rollenlager = new Rollenlager2();
					this.Rollenlager.init(oDlgLager,oRollelager,strMode);
				}
			}			
		}
	},
	
	/**
	 * Funktion fr Sattel
	 * Selektierte Werte in die Lastenkette bertragen
	 */
	setSattel: function(oDlgLager){
		var dObjectLength = oDlgLager.AuswahlSattel.oSearchResult.length;
		
		for(var a=0;a<dObjectLength;a++){
			if(a==0){				
				this.Sattel = new Sattel2();
				this.Sattel.init(oDlgLager,oDlgLager.AuswahlSattel.oSearchResult.oResultSattel);
			}
			else{ //DIESE VARIANTEN GIBT ES AUCH - DARF NICHT VERGESSEN WERDEN				
				if(oDlgLager.AuswahlSattel.oSearchResult.oResultAbhebesicherung){
					this.Abhebesicherung  = new Abhebesicherung2();
					this.Abhebesicherung .init(oDlgLager,oDlgLager.AuswahlSattel.oSearchResult.oResultAbhebesicherung);
				}
				else{//Im jetzigen Ablaufplan sollte dieses nicht vorkommen
					alert("Sattel oSearchResult ist > 1 und enthaelt ein Object ungleich Abhebesicherung");
				}
			}	
		}
	},    
	
	/**
	 * Funktion fr Klemmsysteme
	 * Selektierte Werte in die Lastenkette bertragen
	 */
    setKlemmsystem : function( oDlgLager ){
        var dObjectLength = oDlgLager.Klemmsystem.oSearchResult.length;
		for(var a=0;a<dObjectLength;a++){
			if(a==0){				
				this.Klemmsystem = new Klemmsystem2();
				if(oDlgLager.AuswahlStandard.strSelComboFunction == "FUEHRUNG_2W+" &&
					oDlgLager.AuswahlStandard.strSelRadioFunction == "GEFUEHRT_MEHRFACH")
					this.Klemmsystem.init(oDlgLager,oDlgLager.Klemmsystem.oSearchResult.oResultKlemmsystem, 2);
				else
					this.Klemmsystem.init(oDlgLager,oDlgLager.Klemmsystem.oSearchResult.oResultKlemmsystem, 1);
			}
			else{//Im jetzigen Ablaufplan sollte dieses nicht vorkommen
				alert("Klemmsystem oSearchResult ist > 1");
			}
		}
    },
	
	/**
	 * Funktion fr ZubehoerPTFE
	 * Selektierte Werte in die Lastenkette bertragen
	 */
	setZubehoerPTFE: function(oDlgLager){
		if(this.oDlgLagerSession.ZubehoerPTFE.bFieldSetCheckBox){
			this.Abhebesicherung  = new Abhebesicherung2();
			this.Abhebesicherung .init(oDlgLager,oDlgLager.ZubehoerPTFE.oSearchResult);
			this.Gleitelement  = null;
		}
		else{
			this.Gleitelement  = new Gleitelement2();
			this.Gleitelement.init(oDlgLager,oDlgLager.ZubehoerPTFE.oSearchResult);					
			this.Abhebesicherung  = null;
		}
	}
});

