/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoHaengendEinfach = function(pdataAccess, ppresets)
{
	CaTopoHaengendEinfach.superclass.constructor.call(this, pdataAccess, ppresets);
	    
    // Die Infos zur den Bauteilen der Lastkette:
    this.SegmentStrang  = null;     // bei einer einfachen LK gibt es nur einen Strang
    this.Schelle        = null;
    this.Lasche         = null;

    this.Traverse       = null; 
	// this.Lager 			= null;   -mw- 9.5.2012 auskommentiert
	this.bLager 		= false;

	this.TopoLager2 	= null;		// -mw- 9.5.2012 neu - fr das Lager auf dem Trger - alternativ zur Schelle
    
	this.DrehungOL      = 0;
    //this.DrehungOR      = 0;
	this.DrehungOR      = 180;
	var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
	if (AchsDirInfo[9]	!= "LG_Var1")
		this.DrehungU       = 0;
	else
		this.DrehungU       = 90;
};

EasyKat.extend(CaTopoHaengendEinfach, CaTopo, {

    serializeIn : function(strPath) 
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) != "CaTopoHaengendEinfach")
        {   
            // ist noch nichts da
            // Den einen Strang aberschon mal anlegen, als Container fr das
            // was noch kommt...
            this.SegmentStrang = new CaTopoSegmentStrang(this.dataAccess);
            return 0;     
        }

        // Oberklasse hier auch aufrufen
        CaTopo.prototype.serializeIn.call(this, strPath);       
        
        // Objekte einlesen:
        this.SegmentStrang = serializeInObject(strPath, "SegmentStrang");
        this.SegmentStrang.dataAccess = this.dataAccess;    // das wird nicht serialisiert
        
		// ACHTUNG --gl--
		// serializeIn ist eine Methode
		// serializeInObject ist eine globale Funktion
        this.Schelle    = serializeInObject(strPath, "Schelle");
        this.Lasche     = serializeInObject(strPath, "Lasche");
        this.Traverse   = serializeInObject(strPath, "Traverse");
        // this.Lager	    = serializeInObject(strPath, "Lager");
		this.TopoLager2 = serializeInObject(strPath, "TopoLager2");

        this.DrehungOL	= getdouble("DrehungOL",strPath);
        this.DrehungOR	= getdouble("DrehungOR",strPath);
		
		//this.DrehungU	=	this.dataAccess.getRotUTeile();		// -Schu- 120618 auskommentiert
		this.DrehungU	=	getdouble("DrehungU",strPath);
		
		this.bLager = getbool( 'bLager', strPath );

        return 1;
    },

    serializeOut : function(strPath) 
	{
        // Erstmal vorherige Daten wegputzen ...
        delete(strPath, "");
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoHaengendEinfach");

        CaTopo.prototype.serializeOut.call(this, strPath);
        
        // Objekte:
        if (this.SegmentStrang)
            this.SegmentStrang.serializeOut(strPath + ".SegmentStrang");
        if (this.Schelle)
            this.Schelle.serializeOut(strPath + ".Schelle");
        if (this.Lasche)
            this.Lasche.serializeOut(strPath + ".Lasche");
        if (this.Traverse)
            this.Traverse.serializeOut(strPath + ".Traverse");
		if ( this.TopoLager2 )
			this.TopoLager2.serializeOut( strPath + ".TopoLager2" );

        setdouble("DrehungOL",        strPath, this.DrehungOL);
        setdouble("DrehungOR",        strPath, this.DrehungOR);
        //setdouble("DrehungU",         strPath, this.DrehungU);
		
		var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
		if (AchsDirInfo[9]	!= "LG_Var1")
			setdouble("DrehungU", strPath, 0);
		else
			setdouble("DrehungU", strPath, 90);
		
		setbool( "bLager", strPath, this.bLager );
    },
    
    getLastkettenIdent : function(theMainController)
    {
        var bFHaenger = 0;
        if (this.SegmentStrang.Haenger && this.SegmentStrang.Haenger.isFHaenger())
            bFHaenger = 1;
        return this.getLastkettenIdentGeneric(theMainController, bFHaenger);
    },
    
    getCurrentHaenger : function()
    {
        // Bei doppelter LK wird hier auf den richtigen Strang verzweigt
        return(this.SegmentStrang.Haenger);
    },
    
    setHaenger : function(myHaenger)
    {
        this.SegmentStrang.Haenger = myHaenger;

        // Fall Starr ohne Spannschloss:
        if (myHaenger.m_Ptypid == "ZRM")
            this.SegmentStrang.minGewindestangenLaengeUnten = myHaenger.m_Pemass;
    },
    
    initHaenger : function(strSelectedHaenger, nSpannweite)
    {
        var ret = 1;
        if (this.SegmentStrang.Haenger)
            ret = this.SegmentStrang.Haenger.Selected(strSelectedHaenger, nSpannweite, /*bErstmals*/ 1);
        return ret;
    },
    
    getKlemmlasche : function()
    {
        if (this.SegmentStrang.ObererAnschluss && (left(this.SegmentStrang.ObererAnschluss.m_Ptypid, 2) == "ZK"))
            return this.SegmentStrang.ObererAnschluss;
            
        return null;
    },
    
    setOberenAnschluss : function(strSelectedTeil)
    {
        this.SegmentStrang.setOberenAnschluss(strSelectedTeil);
    },

    setObereVerbindendeTeile : function(strSelectedTeil, lgv)
    {
        this.SegmentStrang.setObereVerbindendeTeile(strSelectedTeil, lgv);
    },

    getEinzelprodukt : function() 
    {
        return null;    // kommt hier nicht vor, immer Lastkette
    },
        
    getLager : function() 
    {
        return( this.Lager );			// @@@ -mw- 9.5.2012 TODO: umbiegen
    },
    
    setLager : function( oLager ) 
    {
        this.Lager = oLager;			// @@@ -mw- 9.5.2012 TODO: umbiegen
    },
    
	/**
     *  Basis-Navigationsfunktion
     *  Teile hiervon auf die Straenge bertragen? 
     *  Problem: hier gehts rein und raus aus dem Strang
     */
	getNextPanel : function(activePanel) {
		var nextPanel       = {};
		var lkTyp           = this.dataAccess.getLastketteTyp();
		var bSchelle        = this.dataAccess.getLastketteMitSchelle();
		var bStopLoop       = 1;

		var bIsFDT = 0;
		if (getstring("IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "FDT")
			bIsFDT = 1;
		var bIsStarrZRM = 0;
		if (getstring("IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "ZRM")
			bIsStarrZRM = 1;
		
		var bHaengerStehend = 0, bisHaengerObenFlexibel = 0;
		if (this.SegmentStrang.Haenger)
		{
			bHaengerStehend         = this.SegmentStrang.Haenger.isHaengerStehend();
			if (this.SegmentStrang.Haenger.isHaengerObenFlexibel() || 
				this.SegmentStrang.Haenger.isZRMHaenger() ||
				bIsFDT)
				bisHaengerObenFlexibel  = 1;
		}

		var isKlemmlascheVorhanden = 0;
		if (this.SegmentStrang.ObererAnschluss && (left(this.SegmentStrang.ObererAnschluss.m_Ptypid, 2) == "ZK"))
			isKlemmlascheVorhanden = 1;
			
		// Lager in dieser Topologie nur bei beweglich, horizontal, hngend doppelt
		var bLager = this.dataAccess.isLastketteMitLagerMoeglich();
		
		this.bLager = false;
		for (;;)
		{
			switch(activePanel) 
			{
				case 'systemcharakteristik':
					nextPanel = CaPanels.sollwerte_halterungspunkt;
					break;
				case 'sollwerte_halterungspunkt':
					if (lkTyp == "STARR")
						nextPanel = CaPanels.auswahl_haengertyp;
					else
						nextPanel = CaPanels.auswahl_haengergroesse;
					break;
				case 'auswahl_haengergroesse':
					// nextPanel = CaPanels.konfiguration_haenger;	// -Sch 100216- Haengerkonfig nur ueber CascadePresets gesteuert
					// - Sch 100216 - sontst kommen die Info-Texte nicht (wurde sonst im KofigurationHaengerController festgelegt)
					if (getstring ("ACT_SELECTED_HANGERTYPE","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE") == "F")
					{
						var strBeschichtung = getstring("TERROSON_FH","PROJECT.SETTINGS.CASCADE");
						if (strBeschichtung == "true")
							strBeschichtung = "TERROSON";
						else
							strBeschichtung = "";
							
						var strBlockierung  = getstring("FH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
						if (strBlockierung == "IDC_FH_BLOCKMITTIG_RADIOBUTTON")
							strBlockierung = "BLOCK_MITTIG";
						else if (strBlockierung == "IDC_FH_BLOCKNEIN_RADIOBUTTON")
							strBlockierung = "BLOCK_NEIN";
						else
							strBlockierung = "BLOCK_JA";
					}
					else
					{
						var strBeschichtung = getstring("TERROSON_KH","PROJECT.SETTINGS.CASCADE");
						if (strBeschichtung == "true")
							strBeschichtung = "TERROSON";
						else
							strBeschichtung = "";
							
						var strBlockierung  = getstring("KH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
						if (strBlockierung == "IDC_KH_BLOCKMITTIG_RADIOBUTTON")
							strBlockierung = "BLOCK_MITTIG";
						else if (strBlockierung == "IDC_KH_BLOCKNEIN_RADIOBUTTON")
							strBlockierung = "BLOCK_NEIN";
						else
							strBlockierung = "BLOCK_JA";
					}
					caMainController.setHaengerOptions(strBeschichtung, strBlockierung, "FROM_DIALOG");
					nextPanel = CaPanels.auswahl_haengertyp;
					break;
					
				//case 'konfiguration_haenger':						// -Sch 100216- Haengerkonfig nur ueber CascadePresets gesteuert
					//nextPanel = CaPanels.auswahl_haengertyp;
					//break;
					
				case 'auswahl_haengertyp':
					if (bLager && !bSchelle && !bIsFDT)   // Lager, aber kein RuT: Fragen ob mit Traverse oder ohne
						nextPanel = CaPanels.auswahl_traverse_ohne_rut;
					else if (bIsFDT || bLager)   // Lager bei Hngend impliziert Doppelte LK
						nextPanel = CaPanels.sollwerte_spannweite;
					else if (!bSchelle && this.bVertikal)   // keine Schelle vertikal: Spannweite soll trotzdem erfragt werden
						nextPanel = CaPanels.sollwerte_spannweite;
					else if (bSchelle)
						nextPanel = CaPanels.sollwerte_rohrumschliessendes_teil;
					else if (bIsStarrZRM)
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					else
						nextPanel = CaPanels.auswahl_untere_teile;
					break;
				case 'auswahl_traverse_ohne_rut':
					nextPanel = CaPanels.sollwerte_spannweite;
					break;
				case 'sollwerte_spannweite':
					if (bSchelle)   // das ist dann immer ein Lager oder vertikal ohne RuT!
					{
						this.bLager = true;
						//-- 16. Mai 2012 Umlenken der Dialoge
						// vor dem Wechsel zum Lagerdialog werden die Werte vorbelegt
						// this.dataAccess.LagerDaten.setzeStartwerteFuerBetriebsbedingungen();
						// if (!this.TopoLager2)
							this.TopoLager2 = new CaTopoLager2 ( this.dataAccess, this.presets );
						nextPanel = {
							'id': 'lager.sollwerte_rohrumschliessendesteil',
							'title': translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL')
						};		
						/////////////////////////////////////////////////////////////////////////////////
						//setze Default Werte fr DialogObject
						var oForms				= Base.Store.getForms();
						var oFormsSystemchar	= oForms.SYSTEMCHARAKTERISTIK;
						var oFormsSollwertHal	= oForms.SOLLWERTE_HALTERUNGSPUNKT;
						var oFormsHaengertyp	= oForms.AUSWAHL_HAENGERTYP;
						var oDlgSessionLager 	= this.TopoLager2.getDlgLagerSession();
						oDlgSessionLager.bLastKettePathSelection = true;
						var oUpdateSystemchar 	= oDlgSessionLager.Systemcharakteristik;
						var oUpdateSollwertHal	= oDlgSessionLager.SollwerteHalterungspunkt.oTable;
						
						oUpdateSystemchar.strSelRadioRohrichtung 	= 'LAGER_'+oFormsSystemchar.IDC_ROHRRICHTUNG;
						oUpdateSystemchar.strSelRadioRohrverlauf 	= 'LAGER_'+oFormsSystemchar.IDC_ROHRVERLAUF;
						oUpdateSystemchar.dAlpha					= oFormsSystemchar.SCHRAEG_ALPHA ? oFormsSystemchar.SCHRAEG_ALPHA : 0;
						oUpdateSystemchar.dBeta						= oFormsSystemchar.SCHRAEG_BETA ? oFormsSystemchar.SCHRAEG_BETA: 0;
						
						if((oFormsSystemchar.IDC_LASTABTRAGUNG == 'HAENGEND_DOPPEL') || (oFormsSystemchar.IDC_LASTABTRAGUNG == 'STUETZEND_EINFACH')){
							if(oFormsHaengertyp.IDC_IMAGE_ID == 'FSP')
								oUpdateSystemchar.strSelRadioLager = 'LAGER_EPG';
							else
								oUpdateSystemchar.strSelRadioLager = 'LAGER_SSG';
						}
						else
							alert("Das sollte nicht vorkommen: "+oFormsSystemchar.IDC_LASTABTRAGUNG);
						
						//Tabelle update
						var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
						oUpdateSollwertHal = {
							'last_plus' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.last_plus[AchsDirInfo[6]]
							},
							'zusatzlast' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.zusatzlast[AchsDirInfo[6]]
							},
							'last_minus' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.last_minus[AchsDirInfo[6]]
							},
							'ueberlast' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.ueberlast[AchsDirInfo[6]]
							},
							'bewegung_plus' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.bewegung_plus[AchsDirInfo[6]]
							},
							'bewegung_minus' : {
								'axial' 	: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[7]],
								'quer'		: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[8]],
								'schief' 	: oFormsSollwertHal.IDC_TABLE.bewegung_minus[AchsDirInfo[6]]
							}
						}
						
						oDlgSessionLager.SollwerteHalterungspunkt.oTable = oUpdateSollwertHal;
					}
					else if (!bSchelle && !bIsFDT /* && this.bVertikal */)   // keine Schelle vertikal oder kein Lager, d.h. Traverse oder gar nichts: Untere Teile whlen
					{
						nextPanel = CaPanels.auswahl_untere_teile;
					}
					else
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					break;
				case 'sollwerte_rohrumschliessendes_teil':
					nextPanel = CaPanels.auswahl_schelle;
					break;
				case 'auswahl_schelle':
					/* -mw- 3.8.2008: Die Auto-Auswahl muss hier laufen, darf aber keine Gewindestange erzeugen
					if (bIsStarrZRM)
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					else
					*/
						nextPanel = CaPanels.auswahl_untere_teile;
					break;
				case 'lager_betriebsbedingungen':
					this.bLager = true;
					nextPanel = CaPanels.lager_auswahl;  
					break;
				case 'lager_auswahl':
					this.bLager = true;
					if ( this.Lager && this.Lager.isHoehenverstellbar() )
						nextPanel = CaPanels.lager_hoeheneingaben;  
					else if ( this.Lager && this.Lager.isConfigurable() )
						nextPanel = CaPanels.lager_konfiguration;  
					else if ( bIsFDT )
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					else 
						nextPanel = CaPanels.auswahl_untere_teile;  
					break;
				case 'lager_hoeheneingaben':
					this.bLager = true;
					if ( this.Lager && this.Lager.isConfigurable() )
						nextPanel = CaPanels.lager_konfiguration;  
					else if ( bIsFDT )
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					else nextPanel = CaPanels.auswahl_untere_teile;  
					break;
				case 'lager_konfiguration':
				case 'neue_lagerauswahl_fertig':
					this.bLager = true;
					if (bIsFDT)
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					else 
						nextPanel = CaPanels.auswahl_untere_teile;  
					break;
				case 'auswahl_untere_teile':
					if (bHaengerStehend)
						nextPanel = CaPanels.uebersicht_lastkette;
					else
						nextPanel = CaPanels.auswahl_oberer_bauanschluss;
					break;
				case 'auswahl_oberer_bauanschluss':
					if (isKlemmlascheVorhanden)
					{
						nextPanel = CaPanels.definition_stahlbau;
					}
					else
					{
						if (bisHaengerObenFlexibel)
							nextPanel = CaPanels.auswahl_obere_teile;
						else
							nextPanel = CaPanels.uebersicht_lastkette;
					}
					break;
				case 'definition_stahlbau':
					if (bisHaengerObenFlexibel)
						nextPanel = CaPanels.auswahl_obere_teile;
					else
						nextPanel = CaPanels.uebersicht_lastkette;
					break;
				case 'auswahl_obere_teile':
					nextPanel = CaPanels.uebersicht_lastkette;
					break;
				default:
					nextPanel = {};
					break;
			}

			// Hier immer ein CleanUp fr alles ab einschlielich dem next Panel
			// durchfhren (wichtig, auch fr bersprungene Dialoge):
			this.cleanUp(nextPanel.id);
			
			bStopLoop = 1;
			if (nextPanel.id == 'auswahl_untere_teile')
				if (this.SegmentStrang.autoAuswahlUntereTeile(this.Schelle, this.Lasche, this.Traverse, this.a_lgv))
					bStopLoop = 0;  // wir berspringen einen Dialog, deshalb nochmal oben den nchsten bestimmen

			if (nextPanel.id == 'auswahl_obere_teile')
				if (this.SegmentStrang.autoAuswahlObereTeile(this.a_lgv))
					bStopLoop = 0;  // wir berspringen einen Dialog, deshalb nochmal oben den nchsten bestimmen
			
			// Ausnahmsweise: Initialisierung eines Dialogs hier
			if (nextPanel.id == 'uebersicht_lastkette')    
				this.berechneSystemmassInitial();
			
			if (bStopLoop)
				break;
			else
				activePanel = nextPanel.id;     
		}
		
        return nextPanel.toJSON();
	},
	
	cleanUp : function(nextPanel) 
	{
        // (Achtung: funktioniert nicht, wenn man auf den Reiter OBT clickt
        // und von dort direkt zur Stckliste kommt ...)
        // --> sollte jetzt immer gehen!

        var bIsStarrZRM = 0;
        if (getstring("IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "ZRM")
            bIsStarrZRM = 1;
        
        // Auf die Straenge bertragen? Problem: hier gehts auch rein und raus aus dem Strang
        // --> Das hier keine breaks drin sind ist korrekt;
        //     je weiter man zurckgeht, desto mehr wird gelscht.
        switch(nextPanel) 
        {
            case 'systemcharakteristik':
            case 'sollwerte_halterungspunkt':
            case 'auswahl_haengergroesse':  // Hnger wird bereits hier angelegt und spter nur noch spezialisiert
                this.SegmentStrang.Haenger  = null;
				this.TopoLager2 = null;
            case 'auswahl_haengertyp':
            case 'sollwerte_spannweite':
                this.Traverse = null;
            case 'sollwerte_rohrumschliessendes_teil':
            case 'lager_betriebsbedingungen':
            case 'auswahl_schelle':
            case 'auswahl_traverse_ohne_rut':
                this.Schelle  = null;
                this.Lasche   = null;
				this.Lager = null;
            case 'auswahl_untere_teile':
                this.SegmentStrang.UnteresVerbindendesTeil1 = null;
                this.SegmentStrang.UntereVerbindendeTeile.length = 0;    
                if (! bIsStarrZRM)
                    this.SegmentStrang.minGewindestangenLaengeUnten = 0;
            case 'auswahl_oberer_bauanschluss':
                this.SegmentStrang.ObererAnschluss = null;
            case 'definition_stahlbau':
            case 'auswahl_obere_teile':
                this.SegmentStrang.OberesVerbindendesTeil1 = null;
                this.SegmentStrang.ObereVerbindendeTeile.length = 0;
                this.SegmentStrang.minGewindestangenLaengeOben  = 0;
                this.Mutter = null;
                //this.DrehungOL      = 0;
				//this.DrehungOR      = 180;
                //this.DrehungU       = 0;
            default:
                break;
        }
    },

    berechneSystemmassInitial : function()
    {
        // --> Aufruf wenn nextPanel = Schlusspanel
        var AchsDirInfo			= this.dataAccess.getAchsKSInfo();
		var stkList             = [];
        var dLevelRMT           = this.dataAccess.getSollwerteEinfuegepunkt("vertikal", AchsDirInfo[6]);
        var bDritteHlinie       = this.isDritteHLinie();
        var summeEma            = 0;
        var summeEmaOben        = 0;
        var summeEmaUnten       = 0;
        var emaAusserhalbOben   = 0;
        var emaAusserhalbUnten  = 0;
        var hdiff = 0, hdiff1 = 0, hdiff2 = 0;

        this.getStueckliste(stkList);

        for (var i = 0; i < stkList.length; i++)
        {
            if (stkList[i].produkt.isAusserhalbSystemMass() || stkList[i].produkt.isLager())
            {
                if (stkList[i].position == "U")
                    emaAusserhalbUnten += stkList[i].produkt.m_Pemass;
                else
                    emaAusserhalbOben  += stkList[i].produkt.m_Pemass;
            }
            else
            {
                // Gewindestangen hier mit zhlen
                // Sonderteile mit emass unterscheiden nach Funktion .... (Feld RHTyp)
                if (stkList[i].funktion != "SON")
                {
                    if ((stkList[i].funktion == "OBT") ||
                        (stkList[i].funktion == "OVT"))
                        summeEmaOben += stkList[i].produkt.m_Pemass;
                    else
                        summeEmaUnten += stkList[i].produkt.m_Pemass;
                }
            }
        }
        summeEma = summeEmaOben + summeEmaUnten;
        
        if (bDritteHlinie)
        {
            hdiff1 = summeEmaOben - emaAusserhalbOben;
            hdiff2 = summeEmaUnten - emaAusserhalbUnten;
            var dLevelHAENG = dLevelRMT + hdiff2;
            var dLevelOBA   = dLevelHAENG + hdiff1;
        }
        else
        {
            hdiff = summeEma - (emaAusserhalbUnten + emaAusserhalbOben);
            var dLevelOBA = dLevelRMT + hdiff;
        }

        // Initiale Hhenlevel speichern:
        setstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOBA);
        setstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelHAENG);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
        
        // Check ob eine Vorgabe fr Hhenlevel da (bei Import STK)
        var h1 = getstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        var h2 = getstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        var h3 = getstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        if (((h1 != "") && (h1 != "0")) || ((h3 != "") && (h3 != "0")))     // h2 knnte leer sein
        {
			if ((h1 != "") && (h1 != "0"))
				setstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h1);
            setstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL", h2);
			if ((h3 != "") && (h3 != "0"))
				setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
            this.berechneFlexibleTeileAusSystemmass("UNTEN");
			/* -mw- 7.7.2010 -> Vorgaben sollen bei zurck und vor wieder eingestellt werden
            setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
            setstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
            setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
			*/
        }
    },

    berechneFlexibleTeileAusSystemmass : function(woVerschoben)
    {
        // Normalerweise muss man einfach alle Emasse aufaddieren.
        // Es gibt jedoch Teile, die das Systemmass oben wieder nach unten schieben
        // (FHS, KVS, ZPK) bzw. unten wieder nach oben schieben (VBK, alle Lager).
        // Diese werden in der Zeichnung in dem Kettenmass abgetragen,
        // in dem auch die Hhenma-Differenzen drin stehen und nicht in
        // dem, in dem die normalen Emasse stehen.
        // Unsere Strategie hier ist also folgende:
        // (1) Berechne die Summe Sum(ema) aller Emasse ohne Gewindestangen / Spannschlsser
        //     und ohne oben erwhnte atypische Teile.
        // (2) Sei Hdiff der Abstand zwischen den beiden eingegebenen Hhenmassen
        //     (wenn es drei oder mehr gibt, analog):
        //     Hlk = Hdiff + Emass atypische Teile oben / unten (falls vorhanden)
        // (3) Sum(ema) = Hlk muss gelten.
        //     --> die Differenz Hlk - Sum(ema) ist genau die neu erforderliche Lnge
        //     der Gewindestangen inkl. Hlsen
        // (4) Prfe, ob da nicht die Mindestgewindestangenlngen unterschritten werden
        //     bzw. ob die Differenz nicht zu gross ist.
        //     In dem Fall muss eines der beiden Systemmasse gendert werden oder
        //     wir lehnen die Eingabe komplett ab (-> Meldung)
        // (5) Prfe, ob wir mit einer Gewindestange auskommen (max 3 meter)
        //     Lege eventuell mehrere Gewindestangen an
        //     --> Abfrage der Lngen erforderlich
        // (6) Bestimmung der absoluten vertikalen Koordinaten der Bauteile (oberes Emass)?
        //     --> dies wre fr die STK-Schnittstelle sehr hilfreich ...


        var stkList = [];
        var stkListPart;

        var bDritteHlinie = this.isDritteHLinie();

        var dLevelOBA   = inputStringToDouble(getstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
        var dLevelHAENG = inputStringToDouble(getstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL"));
        var dLevelRMT   = inputStringToDouble(getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));

        var summeEma            = 0;
        var summeEmaOben        = 0;
        var summeEmaUnten       = 0;
        var emaAusserhalbOben   = 0;
        var emaAusserhalbUnten  = 0;
        var hdiff = 0, hdiff1 = 0, hdiff2 = 0;

        var strMessage = "";

        if (bDritteHlinie)
        {
            hdiff1 = dLevelOBA - dLevelHAENG;
            hdiff2 = dLevelHAENG - dLevelRMT;
        }
        else
            hdiff = dLevelOBA - dLevelRMT;

        this.getStueckliste(stkList);
        
        var bFlexiblesTeil = 0;

        for (var i = 0; i < stkList.length; i++)
        {
            if (stkList[i].produkt.isAusserhalbSystemMass()  || stkList[i].produkt.isLager())
            {
                if (stkList[i].position == "U")
                    emaAusserhalbUnten += stkList[i].produkt.m_Pemass;
                else
                    emaAusserhalbOben  += stkList[i].produkt.m_Pemass;
            }
            else
            {
                // Gewindestangen separat zhlen denn die sind ja u.U.
                // bereits verlngert (verbunden sind sie brigens durch
                // Kupplungshlsen ZHM mit Emass 0)
                // Muttern haben ebenfalls Emass 0
                if (stkList[i].produkt.m_Ptypid != "ZRM")
                {
                    if (stkList[i].funktion != "SON")
                    {
                        if ((stkList[i].funktion == "OBT") ||
                            (stkList[i].funktion == "OVT"))
                            summeEmaOben += stkList[i].produkt.m_Pemass;
                        else
                            summeEmaUnten += stkList[i].produkt.m_Pemass;
                    }
                }
                else
                {
                    bFlexiblesTeil = 1;
                }
            }
        }
        summeEma = summeEmaOben + summeEmaUnten;

        if (! bFlexiblesTeil)
        {
            dLevelRMT = dLevelOBA - summeEma;
            // Hhenlevel zurckspeichern und raus:
            caMainController.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelRMT); 
            setstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOBA);
            setstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelHAENG);
            setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
            return;
        }

        var gewStangenLaenge1 = 0;
        var gewStangenLaenge2 = 0;
        var maxGewStangenLaenge = 15000;
		/*
		var minGewindestangenLaengeUnten	= this.SegmentStrang.minGewindestangenLaengeUnten;
		var minGewindestangenLaengeOben		= this.SegmentStrang.minGewindestangenLaengeOben;
		*/
        if (bDritteHlinie)
        {
            gewStangenLaenge1 = (hdiff1 + emaAusserhalbOben) - summeEmaOben;
            gewStangenLaenge2 = (hdiff2 + emaAusserhalbUnten) - summeEmaUnten;

            // Test auf Mindestlnge: Systemmass-Differenzen drfen nicht zu klein werden
            if (gewStangenLaenge2 < this.SegmentStrang.minGewindestangenLaengeUnten)
            {
                // Hoehenmasse mssen auch angepasst werden:
                // Wir hngen den Hnger hher:
                dLevelHAENG += this.SegmentStrang.minGewindestangenLaengeUnten - gewStangenLaenge2;
                // Dadurch wird oben die Stange krzer:
                gewStangenLaenge1 -= this.SegmentStrang.minGewindestangenLaengeUnten - gewStangenLaenge2;
                gewStangenLaenge2 = this.SegmentStrang.minGewindestangenLaengeUnten;

                strMessage = translate("IDP_WARNING_MINGEWSTLAENGE");   // "Gewindestangenlnge kleiner als "+this.minGewindestangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", this.SegmentStrang.minGewindestangenLaengeUnten);
            }
            else if (gewStangenLaenge2 > maxGewStangenLaenge) // Test auf Maxlnge
            {
                // Wir hngen den Hnger tiefer:
                dLevelHAENG -= gewStangenLaenge2 - maxGewStangenLaenge;
                // Dadurch wird oben die Stange lnger:
                gewStangenLaenge1 += gewStangenLaenge2 - maxGewStangenLaenge;
                gewStangenLaenge2 = maxGewStangenLaenge;

                strMessage = translate("IDP_WARNING_MAXGEWSTLAENGE");   // "Gewindestangenlnge grer als "+maxGewStangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", maxGewStangenLaenge);
            }
            if (gewStangenLaenge1 < this.SegmentStrang.minGewindestangenLaengeOben)
            {
                // Wir mssen das obere Sysmass hher setzen:
                dLevelOBA += this.SegmentStrang.minGewindestangenLaengeOben - gewStangenLaenge1;
                gewStangenLaenge1 = this.SegmentStrang.minGewindestangenLaengeOben;

                strMessage = translate("IDP_WARNING_MINGEWSTLAENGE");   // "Gewindestangenlnge kleiner als "+this.minGewindestangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", this.SegmentStrang.minGewindestangenLaengeOben);
            }
            else if (gewStangenLaenge1 > 15000) // Test auf Maxlnge
            {
                // Wir mssen das obere Sysmass tiefer setzen:
                dLevelOBA -= gewStangenLaenge1 - 15000;
                gewStangenLaenge1 = 15000;            

                strMessage = translate("IDP_WARNING_MAXGEWSTLAENGE");   // "Gewindestangenlnge grer als "+maxGewStangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", "15000");
            }
            
            var vorschlagGewindestangen1 = [];
            var vorschlagGewindestangen2 = [];
            
            this.berechneGewindestangenVerteilung(vorschlagGewindestangen1, gewStangenLaenge1, this.SegmentStrang.minGewindestangenLaengeOben, maxGewStangenLaenge);
            this.berechneGewindestangenVerteilung(vorschlagGewindestangen2, gewStangenLaenge2, this.SegmentStrang.minGewindestangenLaengeUnten, maxGewStangenLaenge);
            
            this.SegmentStrang.passeGewindestangenAn("OBEN", vorschlagGewindestangen1, a_lgv);
            this.SegmentStrang.passeGewindestangenAn("UNTEN", vorschlagGewindestangen2, a_lgv);
        }
        else
        {
            var gewStangenLaenge = (hdiff + emaAusserhalbUnten + emaAusserhalbOben) - summeEma;
            
            // Sonderflle: 
            // Starr mit Spannschloss -> unklar ob oben oder unten die ZRM's sind
            // Starr ohne Spannschloss -> es darf nur ein ZRM geben, und das sitzt am Hnger
            //                            in setHaenger wurde die minGewindestangenLaengeUnten eingetragen
            var strAnpassOrt = "UNTEN", strHaengerPartId = "";
            var minGewstangenLaenge = this.SegmentStrang.minGewindestangenLaengeUnten;

            if (this.SegmentStrang.Haenger)
            {
                if (this.SegmentStrang.Haenger.m_Ptypid == "ZRM")
                {
					strAnpassOrt = "MITTE";
                    //maxGewStangenLaenge = 3000;
                }
                if (this.SegmentStrang.Haenger.m_Ptypid == "FDT")
                {
                    strAnpassOrt = "OBEN";
                    minGewstangenLaenge = this.SegmentStrang.minGewindestangenLaengeOben;
                }
                strHaengerPartId = this.SegmentStrang.Haenger.m_Pcpartid; 
            }
            
            if (strHaengerPartId == "IDL_C_ZSM_1")  // unten ZLM, oben ZRM
            {
                strAnpassOrt = "OBEN";
                minGewstangenLaenge = this.SegmentStrang.minGewindestangenLaengeOben;
            }
                
            if (gewStangenLaenge < minGewstangenLaenge)
            {
                // Wir mssen das obere Sysmass hher setzen:
                dLevelOBA += minGewstangenLaenge - gewStangenLaenge;
                gewStangenLaenge = minGewstangenLaenge;

                strMessage = translate("IDP_WARNING_MINGEWSTLAENGE");   // "Gewindestangenlnge kleiner als "+this.minGewindestangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", minGewstangenLaenge);
            }
            else if (gewStangenLaenge > maxGewStangenLaenge) // Test auf Maxlnge
            {
                // Wir mssen das obere Sysmass tiefer setzen:
                dLevelOBA -= gewStangenLaenge - maxGewStangenLaenge;
                gewStangenLaenge = maxGewStangenLaenge;            

                strMessage = translate("IDP_WARNING_MAXGEWSTLAENGE");   // "Gewindestangenlnge grer als "+maxGewStangenLaenge+" mm ist nicht mglich!";  
                strMessage = replace(strMessage, "XXX", maxGewStangenLaenge);
            }
            
            var vorschlagGewindestangen = [];
            this.berechneGewindestangenVerteilung(vorschlagGewindestangen, gewStangenLaenge, minGewstangenLaenge, maxGewStangenLaenge);
            this.SegmentStrang.passeGewindestangenAn(strAnpassOrt, vorschlagGewindestangen, a_lgv);
        }
        

        // Hhenlevel zurckspeichern:
        caMainController.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelRMT); 
        setstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOBA);
        setstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelHAENG);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);

		// -mw- 7.7.2010 -> Einmal gemachte Vorgaben sollen bei zurck und vor wieder eingestellt werden
		setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOBA);
		setstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelHAENG);
		setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
    
        return strMessage;
    },

    calculateZusatzlast : function()	
    {
        var zusgew = 0;

        var stkList = [];
        this.getStueckliste(stkList);

        for (var i = 0; i < stkList.length; i++)
        {
            if ((stkList[i].funktion == "SCH") ||
                (stkList[i].funktion == "LAG") ||
                (stkList[i].funktion == "UVT"))
            {
                zusgew = zusgew + (stkList[i].anz * stkList[i].produkt.m_Pgewicht);
            }
            if ((stkList[i].funktion == "HNG") && (stkList[i].produkt.m_Ptypid == "FDT"))
                //zusgew = zusgew + stkList[i].produkt.aktgew;
				// aktgew ... aktives Gewicht beider Hnger
				// m_FDT_TGewicht ... Gewicht der Traverse
				zusgew = zusgew + stkList[i].produkt.aktgew + stkList[i].produkt.m_FDT_TGewicht;
        }
        
        var zusatzLast = fround(zusgew / 100, 2);  // Umrechnung kg zu kN
        
        return zusatzLast;
    },

	/**
     *  Berechne die Schraege der Lastkette aufgrund axialer / lateraler Verschiebung des Rohrs
	 *  Nichtzu verwechseln mit Schraegzug (unglckliche Benennung), der eigentlich einen schrgen Rohrleitungsverlauf meint
     *  und eingegeben wird.
	 * @params -
	 * @returns	double Winkel
     */
    getLKWinkel : function()
	{
        var oRet = { a_Schraegzug : 0,
                     a_Schraegzug_100 : 0,
                     a_Schraegzug_Axial : 0,
                     a_Schraegzug_Lateral : 0,
                     Grenzwert : 0,
					 strVorspannung_ax : "0%",
					 strVorspannung_lat : "0%",
                     dSystemEmass : 0,
                     bErlaubt : true,
					 bMoeglich : true};
		
        var dSystemEmass = this.getLKSystemEmass();
        var myHaenger = this.getCurrentHaenger();

        // diverse Teile dazurechnen, damit wir die fr die Gewindestangen relevante Lnge bekommen ...
        //if ((myHaenger.m_Ptypid == "FHS") || (myHaenger.m_Ptypid == "KVS") || (myHaenger.m_Ptypid == "KHS"))
		if ((myHaenger.m_Ptypid == "FHS") || (myHaenger.m_Ptypid == "KVS"))
            dSystemEmass += myHaenger.m_Pemass;
        if (this.TopoLager2.Lager)
            dSystemEmass += this.TopoLager2.Lager.m_Pemass;
        /*
		if (this.Traverse)
            dSystemEmass += this.Lager.m_Pemass;
		*/
		
        oRet.dSystemEmass = dSystemEmass;
        
        var AchsDirInfo				= this.dataAccess.getAchsKSInfo();
		var b_beweg_axial_plus		= this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[7]);
		var b_beweg_axial_minus		= this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[7]);
        var b_beweg_lateral_plus	= this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[8]);
		var b_beweg_lateral_minus	= this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[8]);
        
		var b_beweg_axial	= max(abs(b_beweg_axial_plus), abs(b_beweg_axial_minus));
		var b_beweg_lateral	= max(abs(b_beweg_lateral_plus), abs(b_beweg_lateral_minus));
		if (b_beweg_axial == 0 && b_beweg_lateral == 0)   
            return oRet;
		
		var ax_fact		= 1.0;	// 1: 0% oder 100%; 2: 50%
		var lat_fact	= 1.0;	// 1: 0% oder 100%; 2: 50%
		
		if (getstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MEDIUM_AX")
		{
			oRet.strVorspannung_ax = "50%";
			ax_fact = 2.0;
		}
		else if (getstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MAXIMAL_AX")
			oRet.strVorspannung_ax = "100%";
		
		if (getstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MEDIUM_LAT")
		{
			oRet.strVorspannung_lat = "50%";
			lat_fact = 2.0;
		}
		else if (getstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MAXIMAL_LAT")
			oRet.strVorspannung_lat = "100%";
		
		var h			= sqrt(pow(b_beweg_axial / ax_fact, 2) + pow(b_beweg_lateral / lat_fact, 2));
		var h_moeglich	= sqrt(pow(b_beweg_axial / 2, 2) + pow(b_beweg_lateral / 2, 2));
		
		oRet.a_Schraegzug = oRet.a_Schraegzug_100 = fround((180 / 3.141592654) * atan(h / dSystemEmass), 1);
		oRet.a_Schraegzug_Axial = fround((180 / 3.141592654) * atan((b_beweg_axial / ax_fact) / dSystemEmass), 1);
		oRet.a_Schraegzug_Lateral = fround((180 / 3.141592654) * atan((b_beweg_lateral / lat_fact) / dSystemEmass), 1);
		
        if (oRet.a_Schraegzug > atod(this.presets.m_maxSchraegLK, 2))
            oRet.bErlaubt = false;
		if (fround((180 / 3.141592654) * atan(h_moeglich / dSystemEmass), 1) > atod(this.presets.m_maxSchraegLK, 2))
			oRet.bMoeglich = false;
		
        oRet.Grenzwert = this.presets.m_maxSchraegLK;
        
        return oRet;
    },
    

    setDrehung : function(strDrehteil)
    {
        /*if (strDrehteil == "OL")
            this.DrehungOL += 90;
        if (strDrehteil == "OR")
            this.DrehungOR += 90;
		*/
		// momentan ist die Drehung direkt abhngig
		/*
		if ((strDrehteil == "OL") || (strDrehteil == "OR")){
            this.DrehungOL += 90;
			this.DrehungOR += 90;
		}
		*/
		if ((strDrehteil == "OL")){
            this.DrehungOL += 90;
			this.DrehungOR -= 90;
		}
		if ((strDrehteil == "OR")){
            this.DrehungOL -= 90;
			this.DrehungOR += 90;
		}
        if ((strDrehteil == "U") && (! this.bDoppelt))  // wenn man eine doppelte LK unten dreht, kann man nichts mehr sehen
            this.DrehungU += 90;
		/*
        if (this.DrehungOL >= 360)	this.DrehungOL = 0;
        if (this.DrehungOL < 0)		this.DrehungOL = 90;
        if (this.DrehungOR >= 360)	this.DrehungOR = 0;
        if (this.DrehungOR < 0)		this.DrehungOR = 90;
		*/
		if (this.DrehungOL >= 360)	this.DrehungOL -= 360;
        if (this.DrehungOL < 0)		this.DrehungOL += 360;
        if (this.DrehungOR >= 360)	this.DrehungOR -= 360;
        if (this.DrehungOR < 0)		this.DrehungOR += 360;
		
        if (this.DrehungU  >= 360) this.DrehungU  = 0;

    },
    
    getTopologie : function(strDlg, DrehButtonClicked)
    {
        // Generell: 
        // Fr nicht ausgewhlte Teile kommt das Tafelbild, ansonsten ein neues
        // Konstruktionsbild, das es in den Drehrichtungen gibt.
        // Letztere sollten nicht hher als ntig sein, aber alle gleiche Breite haben
        // (ausser Traverse, VSchelle)
        // Zusammengesetzte Tafelbilder werden dabei durch Bilder der Einzelteile
        // aufgelst (Gabel/se - Gewindestange, Schelle + Lasche ... auch mehrere
        // Gewindestangen mit Hlsen.
        // Die Bilder sollten die Produktobjekte liefern.
        //    --> wir geben ihnen auch die Drehung mit!!
        //        diese brauchen wir aber ohnehin fr das 3D-CAD
        //          --> beim Initialisieren des Schluss-Screens alle Drehungen auf 0 setzen
        //              (sowie wenn man einige Schritte zurck geht !?!? 
        //              --> dann hier generell Drehungen auf 0 wenn Dlg != Schluss-Dlg!!!
        //          --> Drehen-Knopf dreht direkt in den Produkten
        //          Vereinbarung: doppelte LK komplett drehen wird verboten ... man sieht nichts mehr und kann das auch im 3D spter machen
        //          Das sollten wir generell nicht erlauben, dann haben wir auch bei den 3D-Koords weniger Probleme
        // Problem Vorausschau bei den Tafelbildern ... z.B. kann der obere Bauanschluss
        //     wegfallen, wenn stehender Hnger gewhlt
        //     --> Check ob Bauteil existiert, wenn ja nimm Konstruktionsbild, wenn
        //         nein - Tafelbild oder leer lassen -> das hngt nur vom Hnger ab
        //         bzw. von Syschar.-Auswahl ob ohne Schelle
        // @@@ Problem Layout bei doppelter (asymmetrischer!) LK
        //     --> es muss evtl. ein komplexerer Datentyp zurckgeliefert werden oder
        //         wir bauen das HTML hier !?!?
        //     --> geschachtelte Tabelle, wobei linker und rechter Strang jeweils eine
        //         Zelle ist, die weiter unterteilt wird, Alignment nach unten?
        //         wie richten wir dann die Bilder des Strangs vertikal zum Anschluss der
        //         Schelle / Traverse aus?
        //         Lsung z.B. jeder Strang ist 80 breit, Zelle in der Mitte mit leerem
        //         Dummy-Bild auch 80 breit, Anschlsse V-Schelle / Traverse bei
        //         40 und 200
        //         --> Darstellung Traverse mit Lager???? Lager im Dummy-Bild unten?

        // Zuerst mal ein Dummy-Pic hinterlegen, nachher schauen, ob es ein echtes gibt.
        var strBottomPic = "";
		var strLagerPic = "";
        var DrehU	= this.DrehungU + (DrehButtonClicked == "U" ? 90 : 0);
		// OL und OR derzeit direkt abhngig
		var DrehOL	= this.DrehungOL;
		var DrehOR	= this.DrehungOR;
		
		if (DrehButtonClicked == "OL"){
			var DrehOL	= this.DrehungOL + 90;
			var DrehOR	= this.DrehungOR - 90;
		}
		else if(DrehButtonClicked == "OR"){
			var DrehOR	= this.DrehungOR + 90;
			var DrehOL	= this.DrehungOL - 90;
		}
		//var DrehOL	= this.DrehungOL + ((DrehButtonClicked == "OL" || DrehButtonClicked == "OR") ? 90 : 0);
		//var DrehOR	= this.DrehungOR + ((DrehButtonClicked == "OL" || DrehButtonClicked == "OR") ? 90 : 0);
		DrehU	= (DrehU >= 360 ? DrehU - 360 : DrehU);
		
		DrehOL	= (DrehOL >= 360	? DrehOL - 360 : DrehOL);
		DrehOL	= (DrehOL < 0		? DrehOL + 360 : DrehOL);
		DrehOR	= (DrehOR >= 360	? DrehOR - 360 : DrehOR);
		DrehOR	= (DrehOR < 0		? DrehOR + 360 : DrehOR);
		
		if (this.bDoppelt)
        {
            if (this.bVertikal)
            {
                strBottomPic = "catalog/client/custom/img/prinzip/VS.gif";
                // Entweder von Anfang an keine Schelle da, oder OHNE gewhlt
                if (! this.dataAccess.getLastketteMitSchelle()  ||
                    (strDlg == 'uebersicht_lastkette'))
                    strBottomPic = ""; 
                if (this.Schelle && (this.Schelle.m_Ptypid != "ZLN") && (this.Schelle.m_Ptypid != "ZLV") && (this.Schelle.m_Ptypid != "ZLB"))
                    strBottomPic = this.Schelle.getTopoPic(this.DrehungU);
            }
            else
            {
                if (! this.dataAccess.getLastketteMitSchelle())
                    strBottomPic = "catalog/client/custom/img/panels/TZTN.png";
                else
                    strBottomPic = "catalog/client/custom/img/prinzip/TR.gif";
                
                if (this.Traverse)
                    strBottomPic = this.Traverse.getTopoPic(this.DrehungU);
                else if ((strDlg == 'auswahl_untere_teile') ||
                         (strDlg == 'auswahl_oberer_bauanschluss') ||
                         (strDlg == 'definition_stahlbau') ||
                         (strDlg == 'uebersicht_lastkette'))
                    strBottomPic = ""; // Hier Prfung, ob "OHNE Traverse" gewhlt ... eine grer/kleiner Relation auf die Dialoge wre hilfreich

                // Sonderfall: Doppelhnger mit Traverse wird als Traverse dargestellt:
                var myHanger = this.getCurrentHaenger();
                if (myHanger  && (myHanger.m_Ptypid == "FDT"))
                    strBottomPic = myHanger.getTopoPic(DrehungU);
                    
                //if ( this.Lager )
                //    strLagerPic = this.Lager.getTopoPic( this.DrehungU, false );
                //else 
				if ( this.TopoLager2 && this.Traverse && this.dataAccess.getLastketteMitSchelle() )
					strLagerPic = this.TopoLager2.Lager.getTopoPic(DrehungU,false);
            }
        }
        else
        {
            strBottomPic = "catalog/client/custom/img/prinzip/HS.gif";
            // Entweder von Anfang an keine Schelle da, oder OHNE gewhlt
            if (! this.dataAccess.getLastketteMitSchelle()  ||
                (strDlg == 'uebersicht_lastkette'))
                strBottomPic = ""; 
            var test = this.Schelle.m_Ptypid;
			if (this.Schelle && ((this.Schelle.m_Ptypid != "ZLN") || (this.Schelle.m_Ptypid != "ZLV") || (this.Schelle.m_Ptypid != "ZLB")))
                strBottomPic = this.Schelle.getTopoPic(this.DrehungU);
        }
        
        var rows;
        if (this.bDoppelt)
        {
			rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
			var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehU + "_" + DrehOL + "_" + DrehOR;
				else {
					LKParts		+= DrehU + "_";
					if (DrehOL*1 == 0 || DrehOL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
					if (DrehOR*1 == 0 || DrehOR*1 == 180)
						LKParts	+= "_0";
					else
						LKParts	+= "_90";
				}
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\doppel\\" + LKParts + ".png")){
					rows.PictureBottom = "catalog/client/custom/img/LK/doppel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					DoStd	= false;
				}
			}
			if (DoStd){
				this.SegmentStrang.getTopologie(strDlg, rows.PicturesLeft, DrehOL, DrehU);
				this.SegmentStrang.getTopologie(strDlg, rows.PicturesRight, DrehOR, DrehU);
				if ((this.Schelle.m_Ptypid == "ZLN") || (this.Schelle.m_Ptypid == "ZLV") || (this.Schelle.m_Ptypid == "ZLB"))
				{
					rows.PicturesLeft.push(  { id : "topology-img101" , src : this.Schelle.getTopoPic(DrehOL) } );
					rows.PicturesRight.push( { id : "topology-img102" , src : this.Schelle.getTopoPic(DrehOR) } );
				}
				
				// PicturesMiddle: im Moment leer, spter kommt da das Lager hin
				if ( strLagerPic != '' )
					rows.PicturesMiddle.push( { id : "topology-img49" , src : strLagerPic } );
				if (strBottomPic != "")
					rows.PictureBottom = strBottomPic;
				else
					rows.PictureBottom = "catalog/client/custom/img/prinzip/Empty.gif"; // weil hier der Algorithmus ein Bild braucht ...
			}
		}
        else
        {
            rows = { topoTyp: "1", Pictures: [] };
			var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehU + "_" + DrehOL;
				else {
					LKParts		+= DrehU + "_";
					if (DrehOL*1 == 0 || DrehOL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
				}
				// prfen, ob die Datei existiert -> falls nicht bisherige Darstellung verwenden
				//var strPrgPath  = getstddirectory("PROGRAM");
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\einzel\\" + LKParts + ".png")){
					//rows.Pictures.push( { id : "topology-img1" , src : "catalog/client/custom/img/LK/LK_" + LKParts + ".png" } );
					
					rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
					rows.PictureBottom = "catalog/client/custom/img/LK/einzel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					
					DoStd	= false;
				}
			}
			if (DoStd){
				this.SegmentStrang.getTopologie(strDlg, rows.Pictures, DrehOL, DrehU);
				if (this.Lasche)
					rows.Pictures.push( { id : "topology-img50" , src : this.Lasche.getTopoPic(DrehU) } );
				if (strBottomPic != "")
					rows.Pictures.push( { id : "topology-img51" , src : strBottomPic } );
			}
        }
        return rows;
    },
    
	getStueckliste : function(stkList) 
	{
        var stkListPart;
        
        // Wir merken uns zu jedem Teil der Stckliste:
        // - Produktobjekt
        // - Anzahl
        // - Funktion in der LK:
        //      -> HNG Hnger
        //      -> SCH Schelle, Schellzus, Traverse, unteres verbindendes Teil 1
        //      -> OBT Oberer Bauanschluss inkl. etw. oberes verbindendes Teil 1
        //      -> OVT Obere verbindende Teile
        //      -> UVT Untere verbindende Teile
        //      -> ACC nicht sichtbares Zubehr (Muttern, unbekannte Sonderteile)
        //      ... erweiterbar fr atypische LK's; Sttzen benutzen HNG, SCH, eventuell neuen Typ ZWI ?
        // - Position in der LK: in welchem Strang sitzt das Teil (links, rechts, ...)
        //   (z.B. fr Drehung relevant)
        //      -> OL   Oben links (Default auch fr Einzelhngung)
        //      -> OR   Oben rechts
        //      -> U    Unten
        //      -> IRR  Irrelevant
        //      ... erweiterbar fr atypische LK's, ID sollte dem Knopf entsprechen, mit dem gedreht wird

        var oHoehenmasse = this.dataAccess.getHoehenMasse(this.isDritteHLinie());
        var dSpannweite  = this.getSpannweite();
        var dLeft     = 0;
        var dMiddle   = 0;
        var dRight    = 0;
        var strangPos = "OL";   // Default bei einfach hngend
        var strangQty = 1;      // bei einfach hngend und asymmetrisch doppel
        if (this.bDoppelt)
        {
            strangQty = 2;
            dLeft   = 0;
            dMiddle = dSpannweite / 2;
            dRight  = dSpannweite;
        }
        
        var dZ = this.SegmentStrang.getStueckliste(stkList, strangPos, strangQty, oHoehenmasse.H1, dLeft, dMiddle, dRight, this.DrehungOL, this.DrehungOR, this.DrehungU, this.Traverse, this.Schelle, this.Lasche ); 
        
        if (this.Lasche)    // gibts nur bei hngend einfach, Zweilochschelle
        {
            stkListPart = {anz: 1, funktion : "SCH", position : "U", 
                           produkt : this.Lasche,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungU}] };
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        if (this.Traverse)
        {
            // Z-Pos: Traverse hat anscheinend den Einfgepunkt mittig, aber am unteren Emass
            // d.h. hier vorher schon Mass abziehen, danach dann nicht mehr !?!?
            dZ = dZ - Traverse.m_Pemass;
            stkListPart = {anz: 1, funktion : "SCH", position : "U", 
                           produkt : this.Traverse,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungU}] };
            stkList.push(stkListPart);
        }
        if (this.Schelle)   // Schelle immer nur einmal, ausser bei ZLN / ZLV / ZLB
        {
            // Achtung: x-Verschiebung von H-Schellen: Mass m_dXMass
            // Achtung: bei doppelter LK und Lasche als "Schelle" ist die Stckzahl = 2
            var nSchelAnz = 1;
            if (this.bDoppelt && ((this.Schelle.m_Ptypid == "ZLN") || (this.Schelle.m_Ptypid == "ZLV") || (this.Schelle.m_Ptypid == "ZLB")))
                nSchelAnz = 2;
            if (this.Schelle.isAusserhalbSystemMass())
                dZ = dZ + atoi(this.Schelle.m_Pemass);

			var threeDInfo;	// [{zpos : dZ, ypos : dMiddle, xpos : this.Schelle.m_dXMass, rotation : this.DrehungU}]
            if (nSchelAnz == 1)
                threeDInfo = [{zpos : dZ, ypos : dMiddle, xpos : this.Schelle.m_dXMass, rotation : this.DrehungU}];
            else
                threeDInfo = [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : (this.DrehungU + 180)},
                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungU}];

            stkListPart = {anz: nSchelAnz, funktion : "SCH", position : "U", 
                           produkt : this.Schelle,
                           threeD  : threeDInfo };
            stkList.push(stkListPart);
            dZ = dZ - stkListPart.produkt.m_Pemass;
        }
        
		if ( this.Lager )
        {
            // Achtung: bei Lager hier eventuell nach oben rechnen ..
            dZ = dZ + atoi(this.Lager.m_Pemass);
            stkListPart = { anz: 1, funktion : "LAG", position : "U", 
                            produkt : this.Lager,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungU}]  };
            stkList.push( stkListPart );
        }
        
		if( this.TopoLager2){
			this.TopoLager2.getStueckliste(stkList)
		}
		
        // Jetzt ber die Liste iterieren und die Anzahl der Muttern bestimmen, sowie Gesamtgewicht und Gesamtpreis...
        this.bestimmeMutternPreiseGewichte(stkList, 0);     // mit Muttern

        return;
    },


    getCADDaten : function()
    {
		// Allgemeine Einstellungen zur Darstellung:
        var aParams = this.getGlobalCADParameters();
		// Parameter des Modells
		aParams		= this.getCADParameters(aParams);
		
		return( aParams );
    }
});

