/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoGelenk = function(pdataAccess, ppresets)
{
	CaTopoGelenk.superclass.constructor.call(this, pdataAccess, ppresets);
	    
    // Die Infos zur den Bauteilen der Lastkette:
    this.Haenger        = null;     // das Gelenk, also FSG (Gelenksttze) oder SSG (Gelenkstrebe) oder SSB (Stossbremse)
    this.Schelle        = null;     // MSN oder MSL
    this.Bock1          = null;     // MBS/MBW zur Schelle hin
    this.Bock2          = null;     // MBS/MBW auf der anderen Seite
	this.Verlaengerung	= null;		// Verlngerung fr Stobremsen

    var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
	if (AchsDirInfo[9]	!= "LG_Var1"){
		this.DrehungS   = 0; // Schelle
		this.DrehungH	= 0; // Hnger + beide MBS
	}
	else{
		this.DrehungS	= 90; // Schelle
		this.DrehungH	= 90; // Hnger + beide MBS
	}
    
    // Just as convenience, not to be serialized
    var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
    var lkTyp = this.dataAccess.getLastketteTyp();
    this.bFSG = 0;
    this.bSSG = 0;
    this.bHaengend = 0;
    if (lkTyp == "GELENKSTUETZE")
        this.bFSG = 1;
    if (lkTyp == "GELENKSTREBE")
        this.bSSG = 1;
	if (lkTyp == "STOSSBREMSE")
        this.bSSB = 1;
    if ((lkLastabtragung == "HAENGEND_EINFACH") || (lkLastabtragung == "HAENGEND_DOPPEL"))
        this.bHaengend = 1;
    
};

EasyKat.extend(CaTopoGelenk, CaTopo, {

    serializeIn : function(strPath) 
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) != "CaTopoGelenk")
        {   
            // ist noch nichts da
            return 0;     
        }

        // Oberklasse hier auch aufrufen
        CaTopo.prototype.serializeIn.call(this, strPath);       
        
        // Objekte einlesen:
		// serializeIn ist eine Methode
		// serializeInObject ist eine globale Funktion
        this.Haenger        = serializeInObject(strPath, "Haenger");
        this.Schelle        = serializeInObject(strPath, "Schelle");
        this.Bock1          = serializeInObject(strPath, "Bock1");
        this.Bock2          = serializeInObject(strPath, "Bock2");
		this.Verlaengerung	= serializeInObject(strPath, "Verlaengerung");
		
		this.DrehungS	= getdouble("DrehungS",strPath);
		this.DrehungH	= getdouble("DrehungH",strPath);
		
        return 1;
    },

    serializeOut : function(strPath) 
	{
        // Erstmal vorherige Daten wegputzen ...
        delete(strPath, "");
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoGelenk");

        CaTopo.prototype.serializeOut.call(this, strPath);
        
        // Objekte:
        if (this.Haenger)
            this.Haenger.serializeOut(strPath + ".Haenger");
        if (this.Schelle)
            this.Schelle.serializeOut(strPath + ".Schelle");
        if (this.Bock1)
            this.Bock1.serializeOut(strPath + ".Bock1");
        if (this.Bock2)
            this.Bock2.serializeOut(strPath + ".Bock2");
		if (this.Verlaengerung)
			this.Verlaengerung.serializeOut (strPath + ".Verlaengerung");

        //setdouble("DrehungH",        strPath, this.DrehungH);
        //setdouble("DrehungS",        strPath, this.DrehungS);
		var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
		if (AchsDirInfo[9]	!= "LG_Var1"){
			setdouble("DrehungS", strPath, 0); // Schelle
			setdouble("DrehungH", strPath, 0); // Hnger + beide MBS
		}
		else{
			setdouble("DrehungS", strPath, 90); // Schelle
			setdouble("DrehungH", strPath, 90); // Hnger + beide MBS
		}
    },
    
    getLastkettenIdent : function(theMainController)
    {
        var bFHaenger = 0;
        if (this.Haenger && this.Haenger.isFHaenger())
            bFHaenger = 1;
        return this.getLastkettenIdentGeneric(theMainController, bFHaenger);
    },
    
    getCurrentHaenger : function()
    {
        return(this.Haenger);
    },
    
    setHaenger : function(myHaenger)
    {
        this.Haenger = myHaenger;
    },
	
	setVerlaengerung : function(myVerlaengerung)
	{
		this.Verlaengerung = myVerlaengerung;
	},
    
    initHaenger : function(strSelectedHaenger, nSpannweite)
    {
        if (this.Haenger)
            this.Haenger.Selected(strSelectedHaenger, nSpannweite, /*bErstmals*/ 1);
        return (1);
    },
    
    setOberenAnschluss : function(strSelectedTeil)
    {
        return;
    },
    
    getEinzelprodukt : function() 
    {
        return null;    // kommt hier nicht vor, immer Lastkette
    },
    
    // Speziel nur in dieser Klasse:
    setSchelle : function(schelle, bPartIdBelegen)
    {
        this.Schelle = schelle;
        if (bPartIdBelegen)
        {
            if (this.bHaengend)
                this.Schelle.m_Pcpartid = "IDL_C_" + schelle.m_Ptypid + "_U";
            else
                this.Schelle.m_Pcpartid = "IDL_C_" + schelle.m_Ptypid + "_O";
        }
        
		if (schelle.m_Ptypid != "MSL")
			this.setBockSchelle("SET");
		else
			//this.Bock1	= null;
			this.setBockSchelle("NULL");
    },

    setBock : function(TODO)
    {
        if (TODO == "SET"){
			this.Bock2 = new Zubehoer();
			if ((toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" && this.Haenger.m_Ptypid != "SSB")
					|| this.Haenger.m_Ptypid == "FSG")
			{
				if (this.bHaengend)
					this.Bock2.InitMBS("MBS", "", this.getLGG(), 0, "IDL_C_MBS_O");
				else
					this.Bock2.InitMBS("MBS", "", this.getLGG(), 0, "IDL_C_MBS_U");
			}
			else{
				if (this.bHaengend)
					this.Bock2.InitMBW("MBW", "", this.getLGG(), 0, "IDL_C_MBS_O");
				else
					this.Bock2.InitMBW("MBW", "", this.getLGG(), 0, "IDL_C_MBS_U");
			}
		}
		else
			this.Bock2 = null;
    },

    setBockSchelle : function(TODO)
    {
        if (TODO == "SET"){
			this.Bock1   = new Zubehoer();
			if ((toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" && this.Haenger.m_Ptypid != "SSB")
					|| this.Haenger.m_Ptypid == "FSG")
			{
				if (this.bHaengend)
					this.Bock1.InitMBS("MBS", "", this.getLGG(), 0, "IDL_C_MBS_U");
				else
					this.Bock1.InitMBS("MBS", "", this.getLGG(), 0, "IDL_C_MBS_O");
			}
			else{
				var isSchelle	= (this.Schelle != null ? true : false); // wenn Schelle, dann Bock "roh"
				if (this.bHaengend)
					//this.Bock1.InitMBW("MBW", "", this.getLGG(), 0, "IDL_C_MBS_U");
					this.Bock1.InitMBW("MBW", "", this.getLGG(), isSchelle, "IDL_C_MBS_U");
				else
					//this.Bock1.InitMBW("MBW", "", this.getLGG(), 0, "IDL_C_MBS_O");
					this.Bock1.InitMBW("MBW", "", this.getLGG(), isSchelle, "IDL_C_MBS_O");
			}
		}
		else
			this.Bock1 = null;
    },
    
	/**
     *  Basis-Navigationsfunktion
     */

	getNextPanel : function(activePanel) 
    {
		var nextPanel       = {};
        var lkTyp           = this.dataAccess.getLastketteTyp();
        var bSchelle        = this.dataAccess.getLastketteMitSchelle();
        
        switch(activePanel) 
        {
            case 'systemcharakteristik':
                nextPanel = CaPanels.sollwerte_halterungspunkt;
                break;
            case 'sollwerte_halterungspunkt':
                if (this.bSSG || this.bSSB)
                {
                    if (bSchelle)
                        nextPanel = CaPanels.sollwerte_rohrumschliessendes_teil
                    else
                        nextPanel = CaPanels.auswahl_bock2;
                }
                else
                    nextPanel = CaPanels.auswahl_haengergroesse;
                break;
            case 'auswahl_haengergroesse':
                if (bSchelle)
                    nextPanel = CaPanels.sollwerte_rohrumschliessendes_teil
                else
                    nextPanel = CaPanels.auswahl_bock2;
                break;
            case 'sollwerte_rohrumschliessendes_teil':
                nextPanel = CaPanels.auswahl_schelle;
                break;
            case 'auswahl_schelle':
                nextPanel = CaPanels.auswahl_bock2;
                break;
            case 'auswahl_bock2':
                nextPanel = CaPanels.uebersicht_lastkette;
                break;
            default:
                nextPanel = {};
                break;
        }

        // Hier immer ein CleanUp fr alles ab einschlielich dem next Panel
        // durchfhren (wichtig, auch fr bersprungene Dialoge):
        this.cleanUp(nextPanel.id);
        
        // Ausnahmsweise: Initialisierung eines Dialogs hier
        if (nextPanel.id == 'uebersicht_lastkette')    
            this.berechneSystemmassInitial();
            
        return nextPanel.toJSON();
	},
	
	cleanUp : function(nextPanel) 
	{
        switch(nextPanel) 
        {
            case 'systemcharakteristik':
            case 'sollwerte_halterungspunkt':
            case 'auswahl_haengergroesse':  // Hnger wird bereits hier angelegt und spter nur noch spezialisiert
                this.Haenger		= null;
				this.Verlaengerung	= null;
            case 'auswahl_haengertyp':
            case 'sollwerte_rohrumschliessendes_teil':
                this.Schelle  = null;
                this.Bock1    = null;
                this.Mutter   = null;
            case 'auswahl_schelle':
            case 'auswahl_bock2':
                this.Bock2    = null;
            default:
                break;
        }
    },

    berechneSystemmassInitial : function()
    {
        // --> Aufruf wenn nextPanel = Schlusspanel
		var AchsDirInfo			= this.dataAccess.getAchsKSInfo();
		var dLevelRMT           = this.dataAccess.getSollwerteEinfuegepunkt("vertikal", AchsDirInfo[6]);
        var summeEma            = 0;

        if (this.Haenger)
            summeEma += this.Haenger.m_Pemass;
        if (this.Schelle)
            summeEma += this.Schelle.m_Pemass;
        if (this.Bock1)
            summeEma += this.Bock1.m_Pemass;
        if (this.Bock2)
            summeEma += this.Bock2.m_Pemass;
                    
        var dLevelBA;
        if (this.bHaengend)
            dLevelBA = dLevelRMT + summeEma;
        else
            dLevelBA = dLevelRMT - summeEma;

        // Initiale Hhenlevel speichern:
        setstring("BA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);

        // Check ob eine Vorgabe fr Hhenlevel da (bei Import STK)
        var h1 = getstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        var h3 = getstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        if (((h1 != "") && (h1 != "0")) || ((h3 != "") && (h3 != "0")))     // h2 knnte leer sein
        {
            if (this.bHaengend)
            {
				if ((h1 != "") && (h1 != "0"))
					setstring("BA",    "DLGDATA.CA.FORMS.HOEHENLEVEL", h1);
				if ((h3 != "") && (h3 != "0"))
					setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
            }
            else
            {
				/*
				if ((h3 != "") && (h3 != "0"))
					setstring("BA",    "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
				if ((h1 != "") && (h1 != "0"))
					setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h1);
				*/
				if ((h3 != ""))
					setstring("BA",    "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
				if ((h1 != ""))
					setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h1);
            }
            this.berechneFlexibleTeileAusSystemmass("UNTEN");
			/*
            setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
            setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
			*/
        }
		else{
			if (this.bHaengend){
				setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
				setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
			}
			else{
				setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
				setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
			}
		}
    },
    
    berechneFlexibleTeileAusSystemmass : function(woVerschoben)
    {
        // Hier gehts eigentlichnur darum, die Lnge der SSG bzw. der SBV zu bestimmen
        // bzw. die Wegreserven der SSB zu nutzen
		var strMessage = "";

        var dLevelBA	= inputStringToDouble(getstring("BA",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
        var dLevelRMT   = inputStringToDouble(getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));

        var summeEma    = 0;
        var hdiff       = 0;
        if (this.bHaengend)
            hdiff       = dLevelBA - dLevelRMT;
        else
            hdiff       = dLevelRMT - dLevelBA;

//        if (this.Haenger)
//            summeEma += this.Haenger.m_Pemass;
        if (this.Schelle)
            summeEma += this.Schelle.m_Pemass;
        if (this.Bock1)
            summeEma += this.Bock1.m_Pemass;
        if (this.Bock2)
            summeEma += this.Bock2.m_Pemass;

        var sollHaengerLaenge = hdiff - summeEma;	// ggf. inkl. Verlngerung

        
        if (this.Haenger)
        {
            var oldEma = this.Haenger.m_Pemass;
            // Einstellreserve des Hngers nutzen 
            if (this.bSSG)
            {
                if (! this.Haenger.SSGSetLaenge(sollHaengerLaenge))
                {
                    this.Haenger.SSGSetLaenge(oldEma);
                    dLevelBA = dLevelRMT + summeEma + oldEma;
					strMessage =  translate("IDP_SYSMASS_EINSTELLRESERVE");	// 
                }
            }
			else if (this.bSSB){
				if (this.Verlaengerung){ // wir brauchen L4 der SSB
					var TEST_SBV_Ema		= this.Verlaengerung.InitSBV(this.Haenger.m_dNennlast, sollHaengerLaenge - oldEma, "SBV",  true);
					this.Haenger.m_Pemass	+= TEST_SBV_Ema.SSB_L4;
					this.Haenger.e_mass		= this.Haenger.m_Pemass
					oldEma					+= TEST_SBV_Ema.SSB_L4;
					this.Haenger.makeTyp();
				}
				
				if (this.Haenger.res_oben*1 != this.Haenger.res_unten*1){ // ggf. symmetrische Reserven wiederherstellen
					var res_diff			= this.Haenger.res_oben*1 - this.Haenger.res_unten*1;
					this.Haenger.m_Pemass	+= atoi(res_diff/2);
					this.Haenger.e_mass		= this.Haenger.m_Pemass;
					this.Haenger.res_unten	+= atoi(res_diff/2);
					//this.Haenger.res_oben	-= atoi(res_diff/2);
					this.Haenger.res_oben	= this.Haenger.res_unten;	// sicherstellen der Gleichheit (Rundung!?)
					oldEma					= this.Haenger.m_Pemass;
					this.Haenger.makeTyp();
				}
				
				this.Verlaengerung		= null;		// SSB-Lnge bzw. Verlngerung neu auslegen
				
				var TEST_SSB_Ema	= this.Haenger.SSBSetLaenge(sollHaengerLaenge);
				if (!TEST_SSB_Ema || (!TEST_SSB_Ema.bOK && !TEST_SSB_Ema.bVerlPruef)){
					this.Haenger.SSBSetLaenge(oldEma);
					dLevelBA = dLevelRMT + summeEma + oldEma;
					strMessage =  translate("IDP_SYSMASS_EINSTELLRESERVE");
				}
				else if (TEST_SSB_Ema.bVerlPruef){
					this.Verlaengerung	= new Zubehoer();
					var TEST_SBV_Ema	= this.Verlaengerung.InitSBV(this.Haenger.m_dNennlast, sollHaengerLaenge - oldEma, "SBV",  false);
					if (TEST_SBV_Ema.bAuslegungErfolgreich){
						this.Haenger.m_Pemass	-=	TEST_SBV_Ema.SSB_L4;
						this.Haenger.e_mass		=	this.Haenger.m_Pemass;
						this.Haenger.notSSBVerl	=	false;
						this.Haenger.makeTyp();
					}
					else if (TEST_SBV_Ema.bNeuerVersuch){		// -Schu- das muss noch getestet werden !!!
						this.Verlaengerung	= null;
						var strError		= right(TEST_SBV_Ema.strError, 3);	// "MIN" oder "MAX"
						var Lsoll_SBV		= sollHaengerLaenge - oldEma + TEST_SBV_Ema.SSB_L4;
						if (strError == "MIN"){	// SSB muss krzer werden
							var Ldiff_SBV	= TEST_SBV_Ema.L_NeuerVersuch - Lsoll_SBV;
							TEST_SSB_Ema	= this.Haenger.SSBSetLaenge(oldEma - Ldiff_SBV);
						}
						else{
							var Ldiff_SBV	= Lsoll_SBV - TEST_SBV_Ema.L_NeuerVersuch;
							TEST_SSB_Ema	= this.Haenger.SSBSetLaenge(oldEma + Ldiff_SBV);
						}
						if (TEST_SSB_Ema.bOK){	// die ColdPosition kann verschoben werden
							this.Verlaengerung	= null;
							this.Verlaengerung	= new Zubehoer();
							var TEST_SBV_Ema	= this.Verlaengerung.InitSBV(this.Haenger.m_dNennlast, sollHaengerLaenge - this.Haenger.m_Pemass, "SBV",  false);
							// hier sollte eigentlich alles klar gehen
							if (!TEST_SBV_Ema.bAuslegungErfolgreich){
								this.Verlaengerung	= null;
								this.Haenger.SSBSetLaenge(oldEma);
							}
							this.Haenger.m_Pemass	-=	TEST_SBV_Ema.SSB_L4;
							this.Haenger.e_mass		=	this.Haenger.m_Pemass;
							this.Haenger.notSSBVerl	=	false;
							this.Haenger.makeTyp();
						}
						else{
							this.Verlaengerung		= null;
							this.Haenger.notSSBVerl	= true;
							this.Haenger.SSBSetLaenge(oldEma);
							dLevelBA = dLevelRMT + summeEma + oldEma;
							strMessage =  translate("IDP_SYSMASS_EINSTELLRESERVE");
						}
					}
					if (TEST_SBV_Ema.bAuslegungErfolgreich){
						var stkMasse = [];
						var tmpPath = "TMP.FH_ADDITIONAL_DATA";
						this.Haenger.getAdditionalDataToStore(tmpPath);
						stkMasse		= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E_IST", "notSSBVerl"];
						stkMasseNamen	= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E", "AUGE"];
						this.Haenger.setMassString(stkMasse, tmpPath, stkMasseNamen);
					}
				}
				else{	// just to be sure
					this.Verlaengerung		= null;
					this.Haenger.SSBVerl	= false;
				}
			}
            else
            {
                this.Haenger.Selected("FSG", sollHaengerLaenge, 0);
				var dLevelBAOld = dLevelBA;
                if(this.bHaengend)
					dLevelBA = dLevelRMT + (summeEma + this.Haenger.m_Pemass);
				else
					dLevelBA = dLevelRMT - (summeEma + this.Haenger.m_Pemass);
				if (dLevelBAOld != dLevelBA)
					strMessage =  translate("IDP_SYSMASS_EINSTELLRESERVE");	//
            }
        }
        
        // Hhenlevel zurckspeichern:
        caMainController.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelRMT); 
        setstring("BA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
        setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
		/*
		setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
		setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
		*/
		if (this.bHaengend){
			setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
			setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
		}
		else{
			setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelRMT);
			setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelBA);
		}
		
        return strMessage;
    },
    
    setDrehung : function(strDrehteil)
    {
        if (this.bHaengend) // Schelle unten
        {
            if (strDrehteil == "O")
                this.DrehungH += 90;
            if ((strDrehteil == "U"))  
                this.DrehungS += 90;
        }
        else
        {
            if (strDrehteil == "O")
                this.DrehungS += 90;
            if ((strDrehteil == "U"))  
                this.DrehungH += 90;
        }
        
        if (this.DrehungH >= 360) this.DrehungH = 0;
        if (this.DrehungS >= 360) this.DrehungS = 0;
    },

    calculateZusatzlast : function()	
    {
        var zusgew = 0;
        var faktor = 1;
        if (this.bDoppelt)
            faktor = 2;

        if (this.Schelle)   // Schelle gibts nur einmal
            zusgew = zusgew + (this.Schelle.m_Pgewicht);

        if (this.Bock1)     // MBS zur Schelle hin
            zusgew = zusgew + (faktor * this.Bock1.m_Pgewicht);
        
        var zusatzLast = fround(zusgew / 100, 2);  // Umrechnung kg zu kN

        return zusatzLast;
    },

	/**
     *  Berechne die Schraege der Lastkette aufgrund axialer / lateraler Verschiebung des Rohrs
	 *  Nichtzu verwechseln mit Schraegzug (unglckliche Benennung), der eigentlich einen schrgen Rohrleitungsverlauf meint
     *  und eingegeben wird.
	 * @params -
	 * @returns	double Winkel
     */
    getLKWinkel : function()
	{
        var oRet = { a_Schraegzug : 0, 
                     a_Schraegzug_100 : 0,
					 a_Schraegzug_Axial : 0,
                     a_Schraegzug_Lateral : 0,
                     Grenzwert : 0,
                     strVorspannung_ax : "0%",
					 strVorspannung_lat : "0%",
                     dSystemEmass : 0,
                     bErlaubt : true,
					 bMoeglich : true};
		
        var dSystemEmass = this.getLKSystemEmass();
		
        oRet.dSystemEmass = dSystemEmass;
        
		var AchsDirInfo				= this.dataAccess.getAchsKSInfo();
		var b_beweg_axial_plus		= this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[7]);
		var b_beweg_axial_minus		= this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[7]);
        var b_beweg_lateral_plus	= this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[8]);
		var b_beweg_lateral_minus	= this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[8]);
        
		var b_beweg_axial	= max(abs(b_beweg_axial_plus), abs(b_beweg_axial_minus));
		var b_beweg_lateral	= max(abs(b_beweg_lateral_plus), abs(b_beweg_lateral_minus));
        if (b_beweg_axial == 0 && b_beweg_lateral == 0)   
            return oRet;
		
		var ax_fact		= 1.0;	// 1: 0% oder 100%; 2: 50%
		var lat_fact	= 1.0;	// 1: 0% oder 100%; 2: 50%
		
		if (getstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MEDIUM_AX")
		{
			oRet.strVorspannung_ax = "50%";
			ax_fact = 2.0;
		}
		else if (getstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MAXIMAL_AX")
			oRet.strVorspannung_ax = "100%";
		
		if (getstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MEDIUM_LAT")
		{
			oRet.strVorspannung_lat = "50%";
			lat_fact = 2.0;
		}
		else if (getstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE") == "IDC_RADIO_VORSPANNUNG_MAXIMAL_LAT")
			oRet.strVorspannung_lat = "100%";
		
        var h = sqrt(pow(b_beweg_axial / ax_fact, 2) + pow(b_beweg_lateral / lat_fact, 2));
		var h_moeglich	= sqrt(pow(b_beweg_axial / 2, 2) + pow(b_beweg_lateral / 2, 2));
		
		oRet.a_Schraegzug = oRet.a_Schraegzug_100 = fround((180 / 3.141592654) * atan(h / dSystemEmass), 1);
		oRet.a_Schraegzug_Axial = fround((180 / 3.141592654) * atan((b_beweg_axial / ax_fact) / dSystemEmass), 1);
		oRet.a_Schraegzug_Lateral = fround((180 / 3.141592654) * atan((b_beweg_lateral / lat_fact) / dSystemEmass), 1);
		
        if (oRet.a_Schraegzug > atod(this.presets.m_maxSchraegLK, 2))
            oRet.bErlaubt = false;
		if (fround((180 / 3.141592654) * atan(h_moeglich / dSystemEmass), 1) > atod(this.presets.m_maxSchraegLK, 2))
			oRet.bMoeglich = false;
		
        oRet.Grenzwert = this.presets.m_maxSchraegLK;
        
        return oRet;
    },
         
    getTopologie : function(strDlg)
    {
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        // Zuerst mal ein Dummy-Pic hinterlegen, nachher schauen, ob es ein echtes gibt.
        var strSchellentypPic = "catalog/client/custom/img/prinzip/HS.gif";
        if (this.bDoppelt)
            strSchellentypPic = "catalog/client/custom/img/prinzip/VS.gif";
        if (! this.dataAccess.getLastketteMitSchelle() ||
            (strDlg == 'uebersicht_lastkette'))
            strSchellentypPic = "catalog/client/custom/img/prinzip/Empty.gif";

        if (this.Schelle)
            strSchellentypPic = this.Schelle.getTopoPic(this.DrehungS);

        var strHaengertypPic = "catalog/client/custom/img/prinzip/H.png";
        if (this.Haenger)
            strHaengertypPic = this.Haenger.getTopoPic(this.DrehungH, this.dataAccess.getLastketteTyp(), this.dataAccess.getLastketteLastabtragung());

        var strBock1Pic = "";
        /* Bock1 ist schon im Schellenbild enthalten ... aber nicht bei Vertikal */
        if (this.Bock1 && (! this.Schelle || this.bDoppelt))
            strBock1Pic = this.Bock1.getTopoPic(this.DrehungH); // Bock muss selbst wissen, ob er oben oder unten ist
        
        
        var strBock2Pic = "";
        if (this.Bock2)
            strBock2Pic = this.Bock2.getTopoPic(this.DrehungH); // Bock muss selbst wissen, ob er oben oder unten ist
            
        var rows;
        if (this.bDoppelt)
        {
            var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehU + "_" + DrehOL + "_" + DrehOR;
				else {
					LKParts		+= DrehU + "_";
					if (DrehOL*1 == 0 || DrehOL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
					if (DrehOR*1 == 0 || DrehOR*1 == 180)
						LKParts	+= "_0";
					else
						LKParts	+= "_90";
				}
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\doppel\\" + LKParts + ".png")){
					rows.PictureBottom = "catalog/client/custom/img/LK/doppel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					DoStd	= false;
				}
			}
			if (DoStd){
				if (this.bHaengend) // Schelle unten
				{
					rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
					rows.PictureBottom = strSchellentypPic;
					
					if (strBock2Pic != "")
						rows.PicturesLeft.push( { id : "topology-img1" , src : strBock2Pic } );
					rows.PicturesLeft.push( { id : "topology-img2" , src : strHaengertypPic } );
					if (strBock1Pic != "")
						rows.PicturesLeft.push( { id : "topology-img3" , src : strBock1Pic } );            
					if (strBock2Pic != "")
						rows.PicturesRight.push( { id : "topology-img1" , src : strBock2Pic } );
					rows.PicturesRight.push( { id : "topology-img2" , src : strHaengertypPic } );
					if (strBock1Pic != "")
						rows.PicturesRight.push( { id : "topology-img3" , src : strBock1Pic } );            
				}
				else
				{
					rows = { topoTyp: "3", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureTop: '' };
					rows.PictureTop = strSchellentypPic;
					
					if (strBock1Pic != "")
						rows.PicturesLeft.push( { id : "topology-img3" , src : strBock1Pic } );            
					rows.PicturesLeft.push( { id : "topology-img2" , src : strHaengertypPic } );
					if (strBock2Pic != "")
						rows.PicturesLeft.push( { id : "topology-img1" , src : strBock2Pic } );
					if (strBock1Pic != "")
						rows.PicturesRight.push( { id : "topology-img9" , src : strBock1Pic } );            
					rows.PicturesRight.push( { id : "topology-img8" , src : strHaengertypPic } );
					if (strBock2Pic != "")
						rows.PicturesRight.push( { id : "topology-img7" , src : strBock2Pic } );
				}
			}
        }
        else
        {
            rows = { topoTyp: "1", Pictures: [] };
			var DoStd	= true;
			if (strDlg ==  "uebersicht_lastkette"){
				var stkList	= [];
				this.getStueckliste(stkList);
				var LKInfo	= this.dataAccess.getLKParts(stkList);
				var LKParts	= LKInfo.strParts;
				if (LKInfo.RichtRel)
					LKParts		+= DrehU + "_" + DrehOL;
				else {
					LKParts		+= DrehU + "_";
					if (DrehOL*1 == 0 || DrehOL*1 == 180)
						LKParts	+= "0";
					else
						LKParts	+= "90";
				}
				// prfen, ob die Datei existiert -> falls nicht bisherige Darstellung verwenden
				//var strPrgPath  = getstddirectory("PROGRAM");
				if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\einzel\\" + LKParts + ".png")){
					//rows.Pictures.push( { id : "topology-img1" , src : "catalog/client/custom/img/LK/LK_" + LKParts + ".png" } );
					
					rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
					rows.PictureBottom = "catalog/client/custom/img/LK/einzel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
					
					DoStd	= false;
				}
			}
			if (DoStd){
				if (this.bHaengend) // Schelle unten
				{
					if (strBock2Pic != "")
						rows.Pictures.push( { id : "topology-img1" , src : strBock2Pic } );
					rows.Pictures.push( { id : "topology-img2" , src : strHaengertypPic } );
					if (strBock1Pic != "")
						rows.Pictures.push( { id : "topology-img3" , src : strBock1Pic } );            
					rows.Pictures.push( { id : "topology-img4" , src : strSchellentypPic } );
				}
				else
				{
					rows.Pictures.push( { id : "topology-img4" , src : strSchellentypPic } );
					if (strBock1Pic != "")
						rows.Pictures.push( { id : "topology-img3" , src : strBock1Pic } );            
					rows.Pictures.push( { id : "topology-img2" , src : strHaengertypPic } );
					if (strBock2Pic != "")
						rows.Pictures.push( { id : "topology-img1" , src : strBock2Pic } );
				}
			}
        }
        return rows;
    },
    
	getStueckliste : function(stkList) 
	{
        var stkListPart;
        var oHoehenmasse = this.dataAccess.getHoehenMasse(this.isDritteHLinie());
        var dSpannweite  = this.getSpannweite();
        var dLeft     = 0;
        var dMiddle   = 0;
        var dRight    = 0;
        var dZ        = atoi(oHoehenmasse.H1);
        
        var posSchelle = "O";
        var posHaeng   = "U";
        if (this.bHaengend) // Schelle unten
        {
            posSchelle = "U";
            posHaeng   = "O";
        }

        var strangQty = 1;      // bei einfach hngend und asymmetrisch doppel
        if (this.bDoppelt)
        {
            strangQty = 2;
            var dLeft   = 0;
            var dMiddle = dSpannweite / 2;
            var dRight  = dSpannweite;
        }
        
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        if (this.bHaengend) // Schelle unten
        {
            if (this.Bock2)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock2,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock2,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
            if (this.Verlaengerung)
			{
				if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Verlaengerung,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Verlaengerung,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
			}
			if (this.Haenger)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Haenger,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Haenger,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
            if (this.Bock1)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock1,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock1,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
            if (this.Schelle)   
            {
                stkListPart = {anz: 1, funktion : "SCH", position : posSchelle, 
                               produkt : this.Schelle,
                               threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungS}] };
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
        }
        else
        {
            if (this.Schelle)   
            {
                stkListPart = {anz: 1, funktion : "SCH", position : posSchelle, 
                               produkt : this.Schelle,
                               threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungS}] };
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
            if (this.Bock1)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock1,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock1,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
            if (this.Haenger)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Haenger,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Haenger,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
			if (this.Verlaengerung)
			{
				if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Verlaengerung,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "HNG", position : posHaeng, 
                                   produkt : this.Verlaengerung,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
			}
            if (this.Bock2)    
            {
                if (this.bDoppelt)
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock2,
                                   threeD  : [{zpos : dZ, ypos : dLeft, xpos : 0, rotation : this.DrehungH},
                                              {zpos : dZ, ypos : dRight, xpos : 0, rotation : this.DrehungH}] };
                }
                else
                {
                    stkListPart = {anz: strangQty, funktion : "ACC", position : posHaeng, 
                                   produkt : this.Bock2,
                                   threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.DrehungH}] };
                }
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.m_Pemass;
            }
        }
        // Jetzt ber die Liste iterieren und die Anzahl der Muttern bestimmen, sowie Gesamtgewicht und Gesamtpreis...
        this.bestimmeMutternPreiseGewichte(stkList, 0);     // mit Muttern

        return;
    },


    getCADDaten : function()
    {
		// Allgemeine Einstellungen zur Darstellung:
        var aParams = this.getGlobalCADParameters();
		// Parameter des Modells
		aParams		= this.getCADParameters(aParams);
		
		return( aParams );
    }

});

