/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaTopoEinzel = function(pdataAccess, ppresets)
{
	CaTopoEinzel.superclass.constructor.call(this, pdataAccess, ppresets);

    // Die Infos zur den Bauteilen der Lastkette:
    // Eigentlich bruchten wir ja nur einen Container, aber so ist es
    // einheitlicher mit den anderen Topologien und dadurch z.Tl. einfacher
    this.Haenger        = null;
    this.Schelle        = null;
    this.Zubehoer       = null;
	this.Lager			= null;
	this.Klemmsystem    = null;
    this.HaengerZubehoer = null;

    this.minGewindestangenLaenge  = 0;  // nur bei ZRM

    //this.Drehung        = 0;
	var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
	if (AchsDirInfo[9]	!= "LG_Var1")
		this.Drehung       = 0;
	else
		this.Drehung       = 90;
    
    // Wird nicht serialisiert sondern immer neu bestimmt:
    var lkTyp           = this.dataAccess.getLastketteTyp();
    var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
    var lkRohrverlauf   = this.dataAccess.getLastketteRohrverlauf();

    // Convenience bei spteren Abfragen:
    this.bHaenger      = 0;
    this.bSchelle      = 0;
    this.bZubehoer     = 0;
    this.bLager		   = 0;
	this.bKlemmsystem  = 0;
    if ( lkTyp == "EINZEL_HAENGER" )  
		this.bHaenger = 1;
    else if ( lkTyp == "EINZEL_SCHELLE" )  
		this.bSchelle = 1;
    else if ( lkTyp == "EINZEL_ZUBEHOER" ) 
		this.bZubehoer = 1;
    else if ( lkTyp == "EINZEL_LAGER" ) 
		this.bLager = 1;
    else if ( lkTyp == "EINZEL_KLEMMSYSTEM" ) 
		this.bKlemmsystem = 1;
};

EasyKat.extend(CaTopoEinzel, CaTopo, {

    serializeIn : function(strPath) 
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) != "CaTopoEinzel")
        {   
            // ist noch nichts da
            return 0;     
        }

        // Oberklasse hier auch aufrufen
        CaTopo.prototype.serializeIn.call(this, strPath);       
        
        // Objekte einlesen:
		// serializeIn ist eine Methode
		// serializeInObject ist eine globale Funktion
        this.Haenger = serializeInObject( strPath, "Haenger" );
        this.Schelle = serializeInObject( strPath, "Schelle" );
        this.Zubehoer = serializeInObject( strPath, "Zubehoer" );
        this.Lager = serializeInObject( strPath, "Lager" );
        this.Klemmsystem = serializeInObject( strPath, "Klemmsystem" );
        this.HaengerZubehoer = serializeInObject( strPath, "HaengerZubehoer" );
        
        this.minGewindestangenLaenge = getdouble("minGewindestangenLaenge",strPath);
        /*
		var RVektor = (getstring('pipeorient', 'DLGDATA.CA.FINDATA.FINOBJECT.pipe')).split(' ');
        if (abs(RVektor[1]) == 1)
			this.Drehung	= 90;
		else
			this.Drehung	= getdouble("Drehung",strPath);
		*/
		this.Drehung	= getdouble("Drehung",strPath);

        return 1;
    },

    serializeOut : function(strPath) 
	{
        // Erstmal vorherige Daten wegputzen ...
        delete(strPath, "");
        
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "CaTopoEinzel");

        CaTopo.prototype.serializeOut.call(this, strPath);
        
        // Objekte:
        if ( this.Haenger )
            this.Haenger.serializeOut( strPath + ".Haenger" );
        if ( this.Schelle )
            this.Schelle.serializeOut( strPath + ".Schelle" );
        if ( this.Zubehoer )
            this.Zubehoer.serializeOut( strPath + ".Zubehoer" );
        if ( this.Lager )
            this.Lager.serializeOut( strPath + ".Lager" );
        if ( this.Klemmsystem )
            this.Klemmsystem.serializeOut( strPath + ".Klemmsystem" );
        if ( this.HaengerZubehoer )
            this.HaengerZubehoer.serializeOut( strPath + ".HaengerZubehoer" );

        setdouble("minGewindestangenLaenge",strPath, this.minGewindestangenLaenge);
        //setdouble("Drehung",        strPath, this.Drehung);
		var AchsDirInfo		= this.dataAccess.getAchsKSInfo();
		if (AchsDirInfo[9]	!= "LG_Var1")
			setdouble("Drehung", strPath, 0);
		else
			setdouble("Drehung", strPath, 90);
    },
    
    getLastkettenIdent : function(theMainController)
    {
        var bFHaenger = 0;
        if (this.Haenger && this.Haenger.isFHaenger())
            bFHaenger = 1;
        return this.getLastkettenIdentGeneric(theMainController, bFHaenger);
    },
    
    getCurrentHaenger : function()
    {
        return(this.Haenger);
    },
    
    setHaenger : function(myHaenger)
    {
        this.Haenger = myHaenger;
    },
    
    getLager : function() 
    {
        return( this.Lager );
    },
    
    setLager : function( oLager ) 
    {
        this.Lager = oLager;
		this.bLager = ( oLager != null );
    },
    
    getKlemmsystem : function()
    {
        if (this.Klemmsystem)
            return this.Klemmsystem;
            
        return null;
    },

    setKlemmsystem : function( oKlemmsystem ) 
    {
        this.Klemmsystem = oKlemmsystem;
		this.bKlemmsystem = ( oKlemmsystem != null );
    },
    
    initHaenger : function(strSelectedHaenger, nSpannweite)
    {
        var ret = 1;
        if (this.Haenger)
        {
            ret = this.Haenger.Selected(strSelectedHaenger, nSpannweite, /*bErstmals*/ 1);
            if (ret < 0)
                return ret;
            if ((strSelectedHaenger == "FHD") || (strSelectedHaenger == "KHD") ||
                (strSelectedHaenger == "KVD"))
            {
                // In diesen Fllen automatisch passende Lasche ergnzen:
                var myZubehoer = new Zubehoer();    
                var strLogicId = "IDL_C_ZLN_O_1";
                var strSelectedTeil = "ZLN";
                if ((strSelectedHaenger == "KHD") || (strSelectedHaenger == "KVD"))
                {
                    strLogicId = "IDL_C_ZLK_1";
                    strSelectedTeil = "ZLK";
                }
                    
                if (myZubehoer.Init( strSelectedTeil, this.a_lgv, strLogicId) >= 0)
                    this.HaengerZubehoer = myZubehoer;
            }
            else
                this.HaengerZubehoer = null;
        }
        return ret;
    },
    
    getKlemmlasche : function()
    {
        if (this.Zubehoer && (left(this.Zubehoer.m_Ptypid, 2) == "ZK"))
            return this.Zubehoer;
            
        return null;
    },
    
    setZubehoer : function(strSelectedTeil)
    {
        var myZubehoer = new Zubehoer();    

        var strLogicId = "";

        switch (strSelectedTeil)
        {	case "ZLN":
                strLogicId = "IDL_C_ZLN_O_1";
                break;
            case "ZLK":
                strLogicId = "IDL_C_ZLK_1";
                break;
            case "ZPK":
                strLogicId = "IDL_C_ZPK_O";
                break;
            case "ZKN":
                strLogicId = "IDL_C_ZKN";
                break;
            case "ZKK":
                strLogicId = "IDL_C_ZKK";
                break;
            case "ZOM":
                strLogicId = "IDL_C_ZOM_U";
                break;
            case "ZGM":
                strLogicId = "IDL_C_ZGM_U";
                break;
            case "ZTN":
                strLogicId = "";
                break;
            case "ZSM":
                strLogicId = "IDL_C_ZSM_1";
                break;
            case "ZHM":
                strLogicId = "IDL_C_ZHM";
                break;
            case "ZLM":
                strLogicId = "IDL_C_ZRM_U_1";
                break;
        }
        if (left(strSelectedTeil, 2) == "ZK")
        {
            // hier nur den Typ initialisieren ... Auslegung erst spter wenn Stahlbau klar
            myZubehoer.m_Ptypid = strSelectedTeil;
            myZubehoer.m_Pcpartid = strLogicId;  // aufpassen, dass die nicht spter wieder berpinnt wird ....
            this.Zubehoer = myZubehoer;
        }   
        else if (left(strSelectedTeil, 2) == "ZT")
        {
            // hier nur den Typ initialisieren ... Auslegung erst spter wenn Spanweite klar
            myZubehoer.m_Ptypid = strSelectedTeil;
            myZubehoer.m_Pcpartid = strLogicId;  // aufpassen, dass die nicht spter wieder berpinnt wird ....
            this.Zubehoer = myZubehoer;
        }   
        else if (strSelectedTeil == "ZRM")
        {
            // Mindestgewindestangenlnge initialisieren
            if (myZubehoer.Init( strSelectedTeil, this.a_lgv, strLogicId) >= 0)
            {
                myZubehoer.InitZRM("", null);  // kein Nachbar,kein Hnger -> Feld "minzomu" wird per default genommen
                this.minGewindestangenLaenge = myZubehoer.m_Pemass;
                this.Zubehoer = myZubehoer;
            }
        }   
        else if (myZubehoer.Init( strSelectedTeil, this.a_lgv, strLogicId) >= 0)
                this.Zubehoer = myZubehoer;
			
		else
		{
			if (strSelectedTeil == "OHNE")
				this.Zubehoer = null;
		}
    },

    getEinzelprodukt : function() 
    {
        // Objekte:
        if ( this.Haenger )
            return this.Haenger;
        if ( this.Schelle )
            return this.Schelle;
        if ( this.Zubehoer )
            return this.Zubehoer;
        if ( this.Lager )
            return this.Lager;
		if ( this.Klemmsystem )
			return this.Klemmsystem;

        return null;    // noch nichts gewhlt
    },
        
    
	/**
     *  Basis-Navigationsfunktion
     */

	getNextPanel : function(activePanel) 
    {
		var nextPanel       = {};
        
        var isKlemmlascheVorhanden = 0;
        if (this.Zubehoer && (left(this.Zubehoer.m_Ptypid, 2) == "ZK"))
            isKlemmlascheVorhanden = 1;

        var isZTNVorhanden = 0;
        if (this.Zubehoer && (left(this.Zubehoer.m_Ptypid, 2) == "ZT"))
            isZTNVorhanden = 1;

        var isFDTVorhanden = 0;
        if (this.Haenger && (left(this.Haenger.m_Ptypid, 2) == "FD"))
            isFDTVorhanden = 1;
        
        switch(activePanel) 
        {
            case 'systemcharakteristik2':
                if ( this.bLager )
                    nextPanel = CaPanels.lager_betriebsbedingungen;
				if ( this.bKlemmsystem )
                    nextPanel = CaPanels.klemmsystem_auswahl;
                // Ausnahmsweise hier bereits alles aufrumen, was von vorherigen Auslegungen eventuell
                // brig war ...
                this.Haenger  = null;
                this.Schelle  = null;
                this.Zubehoer = null;
                this.Mutter   = null;
				this.Lager	  = null;
				this.Klemmsystem = null;
                break;
				
            case 'systemcharakteristik':
                if (this.bHaenger)
                    nextPanel = CaPanels.sollwerte_halterungspunkt;
                if (this.bSchelle)  // Panel angepasst fr Einzelwahl Schelle
                    nextPanel = CaPanels.sollwerte_halterungspunkt;
                if (this.bZubehoer) // hier spezielles Panel mit Auswahl Last und LGV
                    nextPanel = CaPanels.sollwerte_zubehoer_einzel;
                if ( this.bLager )
                    nextPanel = CaPanels.lager_betriebsbedingungen;
                
                // Ausnahmsweise hier bereits alles aufrumen, was von vorherigen Auslegungen eventuell
                // brig war ...
                this.Haenger  = null;
                this.Schelle  = null;
                this.Zubehoer = null;
                this.Mutter   = null;
				this.Lager	  = null;
				this.Klemmsystem = null;
                break;
				
			case 'klemmsystem_auswahl':
				nextPanel = CaPanels.uebersicht_lastkette;  
				break;
			case 'lager_betriebsbedingungen':
                nextPanel = CaPanels.lager_auswahl;  
				break;
			case 'lager_auswahl':
				if ( this.Lager && this.Lager.isHoehenverstellbar() )
					nextPanel = CaPanels.lager_hoeheneingaben;  
				else if ( this.Lager && this.Lager.isConfigurable() )
					nextPanel = CaPanels.lager_konfiguration;  
				else nextPanel = CaPanels.uebersicht_lastkette;  
				break;
			case 'lager_hoeheneingaben':
				if ( this.Lager && this.Lager.isConfigurable() )
					nextPanel = CaPanels.lager_konfiguration;  
				else nextPanel = CaPanels.uebersicht_lastkette;  
				break;
			case 'lager_konfiguration':
				nextPanel = CaPanels.uebersicht_lastkette;  
				break;
            case 'sollwerte_zubehoer_einzel':
                nextPanel = CaPanels.auswahl_zubehoer_einzel;  
                break;
            case 'sollwerte_halterungspunkt':
                if (this.bHaenger)
                    nextPanel = CaPanels.auswahl_haengergroesse;
                else if (this.bSchelle)
                    nextPanel = CaPanels.sollwerte_rohrumschliessendes_teil;
                break;
            case 'auswahl_haengergroesse':
            //    nextPanel = CaPanels.konfiguration_haenger;	// -Sch- Haengerkonfig nur ueber CascadePresets gesteuert
			// - Sch 100329 - sontst kommen die Info-Texte nicht (wurde sonst im KofigurationHaengerController festgelegt)
				if (getstring ("ACT_SELECTED_HANGERTYPE","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE") == "F")
				{
					var strBeschichtung = getstring("TERROSON_FH","PROJECT.SETTINGS.CASCADE");
					if (strBeschichtung == "true")
						strBeschichtung = "TERROSON";
					else
						strBeschichtung = "";
						
					var strBlockierung  = getstring("FH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
					if (strBlockierung == "IDC_FH_BLOCKMITTIG_RADIOBUTTON")
						strBlockierung = "BLOCK_MITTIG";
					else if (strBlockierung == "IDC_FH_BLOCKNEIN_RADIOBUTTON")
						strBlockierung = "BLOCK_NEIN";
					else
						strBlockierung = "BLOCK_JA";
				}
				else
				{
					var strBeschichtung = getstring("TERROSON_KH","PROJECT.SETTINGS.CASCADE");
					if (strBeschichtung == "true")
						strBeschichtung = "TERROSON";
					else
						strBeschichtung = "";
						
					var strBlockierung  = getstring("KH_BLOCKIERUNG","PROJECT.SETTINGS.CASCADE");
					if (strBlockierung == "IDC_KH_BLOCKMITTIG_RADIOBUTTON")
						strBlockierung = "BLOCK_MITTIG";
					else if (strBlockierung == "IDC_KH_BLOCKNEIN_RADIOBUTTON")
						strBlockierung = "BLOCK_NEIN";
					else
						strBlockierung = "BLOCK_JA";
				}
				caMainController.setHaengerOptions(strBeschichtung, strBlockierung, "FROM_DIALOG");
				nextPanel = CaPanels.auswahl_haengertyp;
                break;
            case 'konfiguration_haenger':
                nextPanel = CaPanels.auswahl_haengertyp;
                break;
            case 'auswahl_haengertyp':
                if (isFDTVorhanden)
                    nextPanel = CaPanels.sollwerte_spannweite;
                else
                    nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'sollwerte_rohrumschliessendes_teil':
                nextPanel = CaPanels.auswahl_schelle;
                break;
            case 'auswahl_schelle':
                nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'auswahl_zubehoer_einzel':
                if (isKlemmlascheVorhanden)
                    nextPanel = CaPanels.definition_stahlbau;
                else if (isZTNVorhanden)
                    nextPanel = CaPanels.sollwerte_spannweite;
                else
                    nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'sollwerte_spannweite':
                nextPanel = CaPanels.uebersicht_lastkette;
                break;
            case 'definition_stahlbau':
                nextPanel = CaPanels.uebersicht_lastkette;
                break;
            default:
                nextPanel = {};
                break;
        }

        // Hier immer ein CleanUp fr alles ab einschlielich dem next Panel
        // durchfhren (wichtig, auch fr bersprungene Dialoge):
        this.cleanUp(nextPanel.id);
        
        // Ausnahmsweise: Initialisierung eines Dialogs hier
        if (nextPanel.id == 'uebersicht_lastkette')    
            this.berechneSystemmassInitial();
            
        return nextPanel.toJSON();
	},
	
	cleanUp : function(nextPanel) 
	{
        switch(nextPanel) 
        {
            case 'systemcharakteristik':
            case 'systemcharakteristik2':
            case 'sollwerte_halterungspunkt':
            case 'sollwerte_zubehoer_einzel':
            case 'auswahl_haengergroesse':  // Hnger wird bereits hier angelegt und spter nur noch spezialisiert
                this.Haenger  = null;
            case 'auswahl_haengertyp':
                this.HaengerZubehoer = null;
            case 'sollwerte_rohrumschliessendes_teil':
            case 'auswahl_schelle':
            case 'auswahl_zubehoer_einzel':
            case 'lager_betriebsbedingungen':
            case 'klemmsystem_auswahl':
                this.Schelle  = null;
                this.Zubehoer = null;
                this.Mutter   = null;
				this.Lager	  = null;
				this.Klemmsystem  = null;
                this.Drehung  = 0;
            default:
                break;
        }
    },

    berechneSystemmassInitial : function()
    {
        // --> Aufruf wenn nextPanel = Schlusspanel
		var AchsDirInfo			= this.dataAccess.getAchsKSInfo();
		if (this.Lager)
        {
            var lagerDaten = this.dataAccess.LagerDaten.holeBetriebsbedingungen();
            this.dataAccess.setSollwerteEinfuegepunkt("lateral", lagerDaten.rmx); 
            this.dataAccess.setSollwerteEinfuegepunkt("axial", lagerDaten.rmy); 
            this.dataAccess.setSollwerteEinfuegepunkt("vertikal", lagerDaten.rmz); 
        }
		var dLevelRMT = this.dataAccess.getSollwerteEinfuegepunkt("vertikal", AchsDirInfo[6]);
        var Ema       = 0;

        if (this.Haenger)
        {
            Ema = this.Haenger.m_Pemass;
            if (this.HaengerZubehoer)
                Ema += this.HaengerZubehoer.m_Pemass;
        }
        if (this.Schelle)
            Ema = this.Schelle.m_Pemass;
        if (this.Lager)
            Ema = this.Lager.m_Pemass;
        if (this.Zubehoer)
            Ema = this.Zubehoer.m_Pemass;
        if (this.Klemmsystem)
            Ema = this.Klemmsystem.m_Pemass;
			
        // Bei Hnger, Zubehr, Schellen soll unten der Einfgepunkt sein, oben errechnet
        // Bei Lagern ist oben der Einfgepunkt (Rohrmitte), unten wird errechnet
        var dLevelOben  = dLevelRMT + Ema;
        var dLevelUnten = dLevelRMT;
        
        if ((this.Schelle && this.Schelle.isLager()) || this.Lager)
        {
            dLevelOben  = dLevelRMT;
            dLevelUnten = dLevelRMT - Ema;
        }
        
        // Initiale Hhenlevel speichern:
        setstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOben);
        setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUnten);

        // Check ob eine Vorgabe fr Hhenlevel da (bei Import STK)
        var h1 = getstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        var h3 = getstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        if (((h1 != "") && (h1 != "0")) || ((h3 != "") && (h3 != "0")))     // h2 knnte leer sein
        {
			if ((h1 != "") && (h1 != "0"))
				setstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL",  h1);
			if ((h3 != "") && (h3 != "0"))
				setstring("UNTEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL", h3);
            this.berechneFlexibleTeileAusSystemmass("UNTEN");
            setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
            setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
        }
    },
    
    berechneFlexibleTeileAusSystemmass : function(woVerschoben)
    {
        // Hier gehts eigentlich nur darum, zu verschieben, ausser
        // bei Gewindestangen ...
        var strMessage = "";

        var dLevelOben   = inputStringToDouble(getstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL"));
        var dLevelUnten  = inputStringToDouble(getstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL"));

        var Ema    = 0;
        var hdiff  = dLevelOben - dLevelUnten;

        if (this.Haenger)
        {
            Ema = this.Haenger.m_Pemass;
            if (this.HaengerZubehoer)
                Ema += this.HaengerZubehoer.m_Pemass;
			
			this.Haenger.AnpassungEmass = 0;
        }
        if (this.Schelle)
            Ema = this.Schelle.m_Pemass;
        if (this.Lager)
            Ema = this.Lager.m_Pemass;
        if (this.Klemmsystem)
            Ema = this.Klemmsystem.m_Pemass;
        if (this.Zubehoer)
            Ema = this.Zubehoer.m_Pemass;

        if (hdiff != Ema)
        {
            // this.minGewindestangenLaenge nach Auswahl ZRM in Topo initialisiert
            if (this.Zubehoer && (this.Zubehoer.m_Ptypid == "ZRM"))
            {
                if (hdiff > 3000)
                {   
                    // mehr als 3000mm nicht erlaubt, Meldung an User 
                    strMessage = translate("IDP_WARNING_GEWSTLAENGE_3000"); // "Gewindestangenlnge grer 3000 mm ist nicht mglich!";  
                    hdiff = 3000;
                    dLevelUnten = dLevelOben - 3000;
                }
                if (hdiff < this.minGewindestangenLaenge)
                {   
                    // weniger als XXX mm nicht erlaubt, Meldung an User 
                    strMessage = translate("IDP_WARNING_MINGEWSTLAENGE");   // "Gewindestangenlnge kleiner als "+this.minGewindestangenLaenge+" mm ist nicht mglich!";  
                    strMessage = replace(strMessage, "XXX", this.minGewindestangenLaenge);
                    hdiff = this.minGewindestangenLaenge;
                    dLevelUnten = dLevelOben - this.minGewindestangenLaenge;
                }
                this.Zubehoer.AnpassZRM(hdiff);
            }
			else if (this.Haenger && (this.Haenger.isKHaenger() || this.Haenger.isFHaenger()))
			{
				// Einstellreserve des Hngers nutzen
				var oZulaessigeAnpassung = this.Haenger.getZulaessigeAnpassungEmass();
				var sollZwischenstueckLaenge = hdiff - Ema;
				if ((sollZwischenstueckLaenge > 0) && (sollZwischenstueckLaenge <= oZulaessigeAnpassung.dEoben))
				{
					this.Haenger.AnpassungEmass = sollZwischenstueckLaenge;
					sollZwischenstueckLaenge = 0;
				}
				else if (sollZwischenstueckLaenge > 0)
				{
					this.Haenger.AnpassungEmass = oZulaessigeAnpassung.dEoben;
					sollZwischenstueckLaenge = sollZwischenstueckLaenge - oZulaessigeAnpassung.dEoben;
				}
				else if ((sollZwischenstueckLaenge < 0) && (sollZwischenstueckLaenge >= oZulaessigeAnpassung.dEunten))
				{
					this.Haenger.AnpassungEmass = sollZwischenstueckLaenge;
					sollZwischenstueckLaenge = 0;
				}
				else if (sollZwischenstueckLaenge < 0)
				{
					this.Haenger.AnpassungEmass = oZulaessigeAnpassung.dEunten;
					sollZwischenstueckLaenge = sollZwischenstueckLaenge + oZulaessigeAnpassung.dEunten;
				}
				if (sollZwischenstueckLaenge != 0)
				{
					if (woVerschoben == "OBEN")
						dLevelUnten = dLevelOben - (Ema + this.Haenger.AnpassungEmass);
					else
						dLevelOben  = dLevelUnten + (Ema + this.Haenger.AnpassungEmass);
					strMessage =  translate("IDP_SYSMASS_HAENGER");	
				}
			}
            else
            {
                if (woVerschoben == "OBEN")
                    dLevelUnten = dLevelOben - Ema;
                else
                    dLevelOben  = dLevelUnten + Ema;
            }
        }
        
        // Hhenlevel zurckspeichern:
        if ((this.Schelle && this.Schelle.isLager()) || this.Lager)
            this.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelOben); 
        else
            this.dataAccess.setSollwerteEinfuegepunkt("vertikal", dLevelUnten); 
        
        setstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelOben);
        setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", dLevelUnten);

        return strMessage;
    },

    calculateZusatzlast : function()	
    {
        var zusatzLast = 0;
        
        return zusatzLast;
    },
    
    setDrehung : function(strDrehteil)
    {
        this.Drehung += 90;
        if (this.Drehung >= 360) this.Drehung = 0;
    },
    
    getTopologie : function(strDlg)
    {
		var DoStd	= true;
		if (strDlg ==  "uebersicht_lastkette"){
			var stkList	= [];
			this.getStueckliste(stkList);
			var LKInfo	= this.dataAccess.getLKParts(stkList);
			var LKParts	= LKInfo.strParts;
			// Sonderfall "ZHM" -> wird in der Funktion ignoriert -> einzeln gibt es das aber
			if (LKParts == "" && stkList.length > 0)
				LKParts	= stkList[0].produkt.m_Ptypid + "_";
			else if (stkList.length == 0)
				LKParts	= "FLEXPERTE_";
				/*
				// Test animated GIF -> das geht auch
				{
				var rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
				rows.PictureBottom = "catalog/client/custom/img/LK/test.gif";	// hier ist kein Rahmen um dem Bild :-)
				DoStd	= false;
				}
				*/
			//
			if (LKInfo.RichtRel)
				LKParts		+= this.Drehung;
			else {
				if (this.Drehung*1 == 0 || this.Drehung*1 == 180)
					LKParts	+= "0";
				else
					LKParts	+= "90";
			}
			if (FileName.fileExists(getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\LK\\prodeinzel\\" + LKParts + ".png")){
				var rows = { topoTyp: "2", PicturesLeft: [], PicturesMiddle: [], PicturesRight: [], PictureBottom: '' };
				rows.PictureBottom = "catalog/client/custom/img/LK/prodeinzel/" + LKParts + ".png";	// hier ist kein Rahmen um dem Bild :-)
				DoStd	= false;
			}
		}
		
		if(DoStd){
			// Erluterungen hierzu siehe TopoHaengendEinfach ...
			
			var rows = { topoTyp: "1", Pictures: [] };
			
			// Zuerst mal ein Dummy-Pic hinterlegen, nachher schauen, ob es ein echtes gibt.
			var strPic = "";
			if ( this.Haenger )
				strPic = this.Haenger.getTopoPic( this.Drehung );
			if ( this.Schelle )
				strPic = this.Schelle.getTopoPic( this.Drehung);
			if ( this.Zubehoer )
				strPic = this.Zubehoer.getTopoPic( this.Drehung );
			if ( this.Lager )
			{
				if (this.Lager.m_Ptypid == "LSW")	// Sonderfall derzeit nur "_2"; bedeutet 2 AHS
					strPic = "catalog/client/custom/img/WITgifs/RH/" + left(this.Lager.strBild, 4) + "_2_" + this.Lager.strBauform + ".jpg";
				else
					strPic = "catalog/client/custom/img/WITgifs/RH/" + this.Lager.strBild + ".jpg";
			}
			if ( this.Klemmsystem && ( strDlg == 'uebersicht_lastkette' ) )
				strPic = this.Klemmsystem.getTopoPic( this.Drehung, true );
			if (strPic == "")
			{
				if ( this.bHaenger )
					strPic = "catalog/client/custom/img/prinzip/H.png";
				else if ( this.bSchelle )
				{
					if ( this.bVertikal )
						strPic = "catalog/client/custom/img/prinzip/VS.gif";
					else strPic = "catalog/client/custom/img/prinzip/HS.gif";
				}
				else if ( !this.bLager && !this.bKlemmsystem )
					strPic = "catalog/client/custom/img/prinzip/Empty.gif";
				//else if (this.bLager && strDlg == "lager_betriebsbedingungen" )
				//	strPic = "catalog/client/custom/img/panels/THAN.png";
				//else if ( this.bKlemmsystem )
				//	strPic = "catalog/client/custom/img/panels/TDEFAULT.png";
				//else strPic = "catalog/client/custom/img/prinzip/Empty.gif";
					// if (this.bZubehoer)  ... gibts keinen Dummy
			}
			
			if ( strPic )
				rows.Pictures.push( { id : "topology-img1" , src : strPic } );
			}
        return rows;
    },
    
	getStueckliste : function(stkList) 
	{
        var stkListPart;
        var oHoehenmasse = this.dataAccess.getHoehenMasse(this.isDritteHLinie());
        var dSpannweite  = this.getSpannweite();

        var dMiddle   = 0;
		// if (this.Haenger && (this.Haenger.m_Ptypid == "FDT"))
		//	dMiddle = - dSpannweite;
		var dZ        = atoi(oHoehenmasse.H1);
        
        // Erluterungen hierzu siehe TopoHaengendEinfach ...
        
        if (this.Haenger)    
        {
            if (this.HaengerZubehoer)
            {
                stkListPart = {anz: 1, funktion : "ACC", position : "O", 
                               produkt : this.HaengerZubehoer,
                               threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}] };
                stkList.push(stkListPart);
                dZ = dZ - stkListPart.produkt.getEmass();
            }
            stkListPart = {anz: 1, funktion : "HNG", position : "O", 
                           produkt : this.Haenger,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}] };
            stkList.push(stkListPart);
        }
        if (this.Schelle)   
        {
            stkListPart = {anz: 1, funktion : "SCH", position : "O", 
                           produkt : this.Schelle,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}] };
            stkList.push(stkListPart);
        }
        if (this.Zubehoer)
        {
            stkListPart = {anz: 1, funktion : "ACC", position : "O", 
                           produkt : this.Zubehoer,
                           threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}] };
            stkList.push(stkListPart);
        }
        if ( this.Lager )
        {
			// neue Funktion in der Lastkette: LAG fr Lager
			// --> das muss noch weiterverarbeitet werden
            stkListPart = { anz: 1, funktion : "LAG", position : "O", 
                            produkt : this.Lager,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
            stkList.push( stkListPart );
        }
        if ( this.Klemmsystem )
        {
			// neue Funktion in der Lastkette: KSY fr Klemmsystem
			// --> das muss noch weiterverarbeitet werden
            stkListPart = { anz: 1, funktion : "KSY", position : "O", 
                            produkt : this.Klemmsystem,
                            threeD  : [{zpos : dZ, ypos : dMiddle, xpos : 0, rotation : this.Drehung}]  };
            stkList.push( stkListPart );
        }
        
        // Jetzt ber die Liste iterieren und die Anzahl der Muttern bestimmen, 
        // sowie Gesamtgewicht und Gesamtpreis...
        this.bestimmeMutternPreiseGewichte(stkList, 1);     // ohne Muttern

        return;
    },

	/**
     *  hole den Filenamen fr das Kopfmodell fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-DXF fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-INI fr die 3D CAD Darstellung der Lastkette
	 *
	 * @params -
	 * @returns	string Filenamen des Kopfmodells (ohne Pfadangaben)
     */
    getCadInfos : function(bQuick2D, bHaengerMitFussplatte, bLageplanVorhanden)
	{
		// -Schu- 22.04.2009
		var ini = "";
		var rahmen = "";
		if ((this.Zubehoer.m_Ptypid == "ZTN" || this.Zubehoer.m_Ptypid == "ZKN" || this.Zubehoer.m_Ptypid == "ZKB" 
			|| this.Zubehoer.m_Ptypid == "ZKK" || this.Zubehoer.m_Ptypid == "ZZF" || this.Zubehoer.m_Ptypid == "ZZK" 
			|| this.Haenger.m_Ptypid == "FDT" || this.Haenger.m_Ptypid == "KHD"
			|| this.Haenger.m_Ptypid == "KHS" || this.Schelle.m_Ptypid == "VKK" || this.Schelle.m_Ptypid == "VKR"
			|| this.Schelle.m_Ptypid == "VBK" || this.Schelle.m_Ptypid == "VSR" || this.Schelle.m_Ptypid == "VGR"
			|| this.Schelle.m_Ptypid == "VPR") && bLageplanVorhanden == 0)
		{
			ini = "Rahmen-wit_LK2_3D_oLP.ini";
		}
		else if ((this.Zubehoer.m_Ptypid == "ZTN" || this.Zubehoer.m_Ptypid == "ZKN" || this.Zubehoer.m_Ptypid == "ZKB" 
			|| this.Zubehoer.m_Ptypid == "ZKK"|| this.Haenger.m_Ptypid == "FDT" || this.Haenger.m_Ptypid == "KHD"
			|| this.Haenger.m_Ptypid == "KHS"
			|| this.Schelle.m_Ptypid == "VKK" || this.Schelle.m_Ptypid == "VKR" || this.Schelle.m_Ptypid == "VBK"
			|| this.Schelle.m_Ptypid == "VSR" || this.Schelle.m_Ptypid == "VGR"
			|| this.Schelle.m_Ptypid == "VPR") && bLageplanVorhanden == 1)
		{
			ini = "Rahmen-wit_LK2.ini";
		}
		else if (bLageplanVorhanden == 1)
		{
			ini = "Rahmen-wit_LK1.ini";
		}
		else
		{
			ini = "Rahmen-wit_LK1_3D_oLP.ini";
		}
		
		if (this.Haenger.m_Ptypid == "FDT" || this.Schelle.m_Ptypid == "VKK" || this.Schelle.m_Ptypid == "VKR"
			|| this.Schelle.m_Ptypid == "VBK" || this.Schelle.m_Ptypid == "VSR" || this.Schelle.m_Ptypid == "VGR"
			|| this.Schelle.m_Ptypid == "VPR")
		{
			rahmen = "Rahmen-wit_LK2";
		}
		else
		{
			rahmen = "Rahmen-wit_LK1";
		}
		
        var oRet = { //headModel : "Auswahl_LKtyp.cc3",
                     headModel : "AW_LKtyp_neu.cc3",
					 rahmenDxf : rahmen,
					 rahmenIni : ini,
                     lagerEinzel : 0,
                     lagerFuss : 0,
					 lagerFussTyp	: 'empty'
                     };
		
		/* --> das wird nicht mehr gebraucht -Schu 111208-
		
		// einzelne Lager haben ein anderes Kopfmodell
        if ( this.Lager && this.bLager )
        {
            oRet.lagerEinzel = 1;
            if (left(this.Lager.m_Ptypid, 2) == "FS")
                oRet.headModel = "Auswahl_FP.cc3";
            else if ((this.Lager.m_Ptypid == "LKF") || (this.Lager.m_Ptypid == "LSF"))
                oRet.headModel = "Auswahl_LxF.cc3";
            else
                oRet.headModel = "Auswahl_LG.cc3";
            oRet.rahmenDxf = "Rahmen-wit_LG";
            oRet.rahmenIni = "Rahmen-wit_LG.ini";
            
            if ((left(this.Lager.m_Ptyp, 6) == "FSN 01") ||
                (left(this.Lager.m_Ptyp, 6) == "FSN 02") ||
                (left(this.Lager.m_Ptyp, 6) == "FSD 01") ||
				(left(this.Lager.m_Ptyp, 6) == "FSD 02") ||
                (left(this.Lager.m_Ptyp, 3) == "LXV"))
                oRet.lagerFuss = 1;
        }
        else if (this.Klemmsystem && this.bKlemmsystem)
        {
            oRet.lagerEinzel = 1;
            oRet.headModel = "Auswahl_KS.cc3";
            oRet.rahmenDxf = "Rahmen-wit_KSY";
            oRet.rahmenIni = "Rahmen-wit_KSY.ini";        
        }
		*/
		if ( this.Lager && this.bLager )
        {
			oRet.rahmenDxf = "Rahmen-wit_LG";
            oRet.rahmenIni = "Rahmen-wit_LG.ini";
            
            if ((left(this.Lager.m_Ptyp, 6) == "FSN 01") ||
                (left(this.Lager.m_Ptyp, 6) == "FSN 02") ||
                (left(this.Lager.m_Ptyp, 6) == "FSD 01") ||
				(left(this.Lager.m_Ptyp, 6) == "FSD 02") ||
                (left(this.Lager.m_Ptyp, 3) == "LXV"))
                oRet.lagerFuss = 1;
		}
		else if (this.Klemmsystem && this.bKlemmsystem)
        {
			oRet.lagerEinzel = 1;
			oRet.rahmenDxf = "Rahmen-wit_KSY";
            oRet.rahmenIni = "Rahmen-wit_KSY.ini";
		}
		
		var Strang	= (this.SegmentStrang ? true : false);
		
		switch (Strang ? this.SegmentStrang.Haenger.m_Ptypid : this.Haenger.m_Ptypid){
			case 'FHS' :
			case 'FSS' :
			case 'FSP' :
				oRet.lagerFuss		= 1;
				if ((Strang && this.SegmentStrang.Haenger.groesse*1 < 12) || (!Strang && this.Haenger.groesse*1 < 12))
					oRet.lagerFussTyp	= 'FS';
				else
					oRet.lagerFussTyp	= 'FS_12';
				break;
			case 'KSR' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KSR';
				break;
			case 'KSP' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KSP';
				break;
			case 'KVS' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KVS';
				break;
			case 'KHS' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KHS';
				break;
			default :
				break;
		}
		
		return( oRet );
	},
			
    getCADDaten : function()
    {
        // Allgemeine Einstellungen zur Darstellung:
        var aParams = this.getGlobalCADParameters();
		// Parameter des Modells
		aParams		= this.getCADParameters(aParams);
		
		return( aParams );
    }

});

