/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */

CaTopo = function(pdataAccess, ppresets)
{
	/**
     * dataAccess ... Verweis auf Objekt, das im Controller angelegt wurde
     * @var dataAccess
     */
	this.dataAccess = pdataAccess;
    this.presets    = ppresets;

    this.Mutter     = null;
    this.Sonderteile = [];

	/**
     * weitere berechnete Lastkettenparameter ....
     * @var ...
     */
    this.a_lgv      = "";

    this.gesamtGewicht = 0;
    this.gesamtPreis = 0;

    // Wird nicht serialisiert sondern immer neu bestimmt:
    this.bDoppelt       = 0;
    this.bVertikal      = 0;
	if (this.dataAccess)  {
		var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
		var lkRohrverlauf   = this.dataAccess.getLastketteRohrverlauf();
		if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
			this.bDoppelt   = 1;
		if (lkRohrverlauf == "VERTIKAL")
			this.bVertikal  = 1;
	}

    this.preisStatus = "UNDEF";
    this.matStatus   = "UNDEF";
};


CaTopo.prototype =
{
    serializeIn : function(strPath)
	{
        var  i;

        // Einfache Variablen einlesen, je nach Typ
        this.a_lgv      = getstring("a_lgv",strPath);

        this.gesamtGewicht  = getdouble("gesamtGewicht",strPath);
        this.gesamtPreis    = getdouble("gesamtPreis",strPath);

        this.preisStatus = getstring("preisStatus",strPath);
        this.matStatus   = getstring("matStatus",strPath);

        this.Mutter     = serializeInObject(strPath, "Mutter");
	
		var part_anz  = getdouble("SONDERTEILE.PART_ANZ", strPath); // original
		//var part_anz = getdouble("STEEL_COUNT", "DLGDATA.CA.FINDATA.SECONDARY_STEEL");
        for(i = 0; i < part_anz; i++)
            this.Sonderteile.push(serializeInObject(strPath, "SONDERTEILE.PARTS["+i+"].PART"));
		var halt;
    },

    serializeOut : function(strPath)
	{
        var  i;

        // Einfache Variablen
        setstring("a_lgv",     strPath, this.a_lgv);

        setdouble("gesamtGewicht", strPath, this.gesamtGewicht);
        setdouble("gesamtPreis",   strPath, this.gesamtPreis);

        setstring("preisStatus",strPath, this.preisStatus);
        setstring("matStatus",strPath, this.matStatus);

        if (this.Mutter)
            this.Mutter.serializeOut(strPath + ".Mutter");

        setdouble("SONDERTEILE.PART_ANZ", strPath, this.Sonderteile.length); //original
		//setdouble("SONDERTEILE.PART_ANZ", strPath, getdouble("STEEL_COUNT", "DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
        for(i = 0; i < this.Sonderteile.length; i++)
		//for(i = 0; i < getdouble("STEEL_COUNT", "DLGDATA.CA.FINDATA.SECONDARY_STEEL"); i++)
            this.Sonderteile[i].serializeOut(strPath + ".SONDERTEILE.PARTS["+i+"].PART");

    },

	/**
     *  Basis-Navigationsfunktion
     */
    getNextPanel : function(activePanel)
	{
        return "";
    },

	cleanUp : function(nextPanel)
	{
    },

    getTopologie : function(strDlg)
    {
		var rows = { colAnz: 1, Pictures: [] };

        return rows;
    },

	getStueckliste : function()
	{
        var stkList = [];

        return { rows : stkList };
    },

    getEinzelprodukt : function()
    {
        return null;
    },

    getLager : function()
    {
        return null;
    },

    setLager : function( oLager )
    {
    },

	getSpecialLagerInfo : function()
	{
		var retObj = {
			bIsLagerAuswahl : false,
			bIsEinzelprodukt : false,
			bIsLagerMitKlemmsystem : false
		};
		return retObj;
	},
	
    isFDTAuswahl : function()
    {
        var myHanger = this.getCurrentHaenger();
        if (myHanger.m_Ptypid == "FDT")
            return 1;
        return 0;
    },

    getSpannweite : function()
    {

        return this.dataAccess.getSpannweite(1);     // Aufpassen bei ZTN, FDT, SSG, FSG einzel ...
    },

    isDritteHLinie : function()
    {
        // Spannschloss induziert kein drittes Hhenmass
        var LGDoppel	= false;
		if (this.Lager.strBaureihe == "FSD" || 
			(right(this.Lager.strBaureihe, 1) == "F" && 
			(left(this.Lager.strBauF, 1) == "2" || left(this.Lager.strBauF, 1) == "4")))
			LGDoppel	= true;
		myHaenger = this.getCurrentHaenger();
        if ((myHaenger && myHaenger.m_Ptypid == "FHG") || LGDoppel)
            return (1);
        return (0);
    },

    getRlSysDaten : function()
	{
		var retObj = {Gewicht_Ahs: '',
					  Typ_Ahs: '',
					  Nenngroesse: '',
					  Ahs_Sattel: 'N'	// soll immer kommen - ist nur dann "J" wenn "Sattel" UND "AHS"
					  };
		if (this.Rollenlager){
			retObj.Nenngroesse	= this.Rollenlager.strBauF * 1;
		}
		if (this.Abhebesicherung){
			retObj.Typ_Ahs		= this.Abhebesicherung.strBaureihe;
			retObj.Gewicht_Ahs	= this.Abhebesicherung.m_Pgewicht;
			retObj.Nenngroesse	= this.Abhebesicherung.strBauF * 1;
			retObj.Ahs_Sattel	= (this.Sattel ? "J" : retObj.Ahs_Sattel);
		}
		return retObj;
	},
	
	getSchelleDaten : function()
    {
        var retObj = {nennweite: '',
                      spannweite: '',
                      aussendurch: '',
                      emass: '',
                      groesse: '',
                      typ: '',
                      typ_sap: 'OHNE',
                      bohrung: '',
                      obflschutz: '',
                      werkstoff_sapid: '',
                      gewicht: '',
                      Betriebslast: '',
                      Daemmdicke: '',			
                      MediumTemperatur: '',
                      UmgebungsTemperatur: '',
                      ReferenzTemperatur: '',
                      Nennlast: '',
                      LagerTyp: '',
					  Nennhoehe: '',
					  Manteldurchm: '',
					  Auflagedurchmesser: '',
					  Baulaenge: '',
					  Laenge: '',
					  Gewicht_Oberfl: '',
					  Fussbreite: ''
                      };

        if (this.Schelle)       // evtl. das Schellenobjekt doch mal hochziehen hier her, sollte in allen Topos so drin sein ...
        {
            retObj.nennweite        = this.Schelle.nennweite;
            if (this.Schelle.spannweite)
                retObj.spannweite   = this.Schelle.spannweite;
            retObj.aussendurch      = this.Schelle.m_dSonderNennweite;  // @@@ Check ob das immer der Aussendurch ist
            retObj.emass            = this.Schelle.getEmass();
            if (this.Schelle.isVschelle())
                retObj.groesse      = this.Schelle.groesse;

            // Achtung: Dieses Merkmal wird als SAP-Klasse 300-Wert bergeben
            // Derzeit nur fr H-Schellen, sonst Default = "OHNE", das ist korrekt
			// 20191106 auch Vertikalschellen
            if (this.Schelle.isHschelle() || this.Schelle.isVschelle())
                retObj.typ_sap = this.Schelle.m_Ptypid;

            retObj.typ = this.Schelle.m_Ptypid;

            if (left(this.Schelle.m_Ptypid, 2) == "HD")
                retObj.bohrung = this.Schelle.m_bohrung;   // wird nur aus FL bergeben, wenn TYP_Schelle =HDX und  Durchm. > Durchm. vorgebohrt
            retObj.obflschutz          = Oberflaechenschutz[this.Schelle.m_Poberfl];
            retObj.werkstoff_sapid     = WerkstoffeSAPid[this.Schelle.m_Pwerkstoff];
            retObj.gewicht             = this.Schelle.m_Pgewicht;
            retObj.Betriebslast        = this.Schelle.Betriebslast;
            retObj.Daemmdicke          = this.Schelle.Daemmdicke;
            retObj.MediumTemperatur    = this.Schelle.MediumTemperatur;
            //retObj.UmgebungsTemperatur = this.Schelle.UmgebungsTemperatur;
            //retObj.ReferenzTemperatur  = this.Schelle.ReferenzTemperatur;
			retObj.UmgebungsTemperatur	= "-10|+80";
            retObj.ReferenzTemperatur	= retObj.MediumTemperatur;
			if (retObj.MediumTemperatur*1 <= 350 && retObj.MediumTemperatur*1 >=40)
				retObj.ReferenzTemperatur	-= 20;
            retObj.Nennlast            = this.Schelle.m_dNennlast;
        }
        /*
		if (this.Klemmsystem)
        {
            retObj.LagerTyp             = this.Klemmsystem.strBaureihe + ' ' + this.Klemmsystem.strBauF;
        }
		*/
        if (this.Lager)
        {
            // -Schu- 13.12.2012
			// einem Sonderaussendurchmesser muss eine Nennweite zugeordnet werden (sonst streikt SAP)
			// Festlegung DN <= dA
			
			if ((toupper(typeof(this.Lager.m_bSonderNennweite)) == "STRING" && this.Lager.m_bSonderNennweite == "false")
				||
				(toupper(typeof(this.Lager.m_bSonderNennweite)) != "STRING" && !atoi(this.Lager.m_bSonderNennweite)))
				retObj.nennweite            = this.Lager.oData.DN;
			else{
				var strSQLStatement	= "select * from NENNWEITEN where abs(DN) <= "+this.Lager.oData.D+" ";
				var numRet			= dbselect("LAGER2", strSQLStatement, "NENNWEITEN")
				// gibt alle kleineren/gleichen zurck -> wir brauchen den "grten kleinen"
				var NW	= 0;
				while (dbiseof("NENNWEITEN") == 0){
					var NW_Temp = dbgetdouble("NENNWEITEN", "DN");
					if ( NW_Temp > NW )
						NW	= NW_Temp;
					dbskip("NENNWEITEN");
				}
				retObj.nennweite	= NW;
			}
            retObj.aussendurch          = this.Lager.oData.D;
            retObj.emass                = this.Lager.getEmass();
            retObj.typ                  = this.Lager.m_Ptypid;
            retObj.obflschutz           = Oberflaechenschutz[this.Lager.m_Poberfl];
            retObj.werkstoff_sapid      = WerkstoffeSAPid[this.Lager.m_Pwerkstoff];
            retObj.gewicht              = this.Lager.m_Pgewicht;

            //retObj.Betriebslast         = this.Lager.strNennlast;
            retObj.Betriebslast			= this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief;
			retObj.Nennlast				= this.Lager.oData.F_AUFL_CALCULATION;
			//retObj.Daemmdicke           = (! abs(this.Lager.daemmdicke) ? "-" : this.Lager.daemmdicke);	// fuer den Ausdruck
			retObj.Daemmdicke			= this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
            //retObj.MediumTemperatur     = this.Lager.temperatur;
			retObj.MediumTemperatur		= this.oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium;
            retObj.UmgebungsTemperatur	= "-10|+80";
            retObj.ReferenzTemperatur	= retObj.MediumTemperatur;
			if (retObj.MediumTemperatur*1 <= 350 && retObj.MediumTemperatur*1 >=40)
				retObj.ReferenzTemperatur	-= 20;
            // retObj.Nennlast            = this.Lager.m_dNennlast;

            retObj.LagerTyp 		= this.Lager.strBaureihe + ' ' + this.Lager.strBauF;

            retObj.Nennhoehe 		= this.Lager.oData.NH;
            retObj.Manteldurchm 	= this.Lager.oData.DM;
        }
		if (this.Sattel)
		{
			/*
			retObj.nennweite			= (this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? '' :
											this.oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo);
            */
			if (!this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder && !this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
				retObj.nennweite            = this.Sattel.oData.DN;
			else{
				var strSQLStatement	= "select * from NENNWEITEN where abs(DN) <= "+this.Sattel.oData.D+" ";
				var numRet			= dbselect("LAGER2", strSQLStatement, "NENNWEITEN")
				// gibt alle kleineren/gleichen zurck -> wir brauchen den "grten kleinen"
				var NW	= 0;
				while (dbiseof("NENNWEITEN") == 0){
					var NW_Temp = dbgetdouble("NENNWEITEN", "DN");
					if ( NW_Temp > NW )
						NW	= NW_Temp;
					dbskip("NENNWEITEN");
				}
				retObj.nennweite	= NW;
			}
			retObj.aussendurch			= (this.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? this.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder :
											this.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
            retObj.LagerTyp				= this.Sattel.strBaureihe;
            retObj.obflschutz			= Oberflaechenschutz[this.Sattel.m_Poberfl];
            retObj.werkstoff_sapid		= WerkstoffeSAPid[this.Sattel.m_Pwerkstoff];
            retObj.gewicht				= this.Sattel.m_Pgewicht;
            //retObj.Daemmdicke			= this.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
			retObj.Daemmdicke			= this.Sattel.oData.J_MAX;
            retObj.MediumTemperatur		= this.oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium;
			if (retObj.LagerTyp == "SMR")
				retObj.Manteldurchm		= (this.oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder ? this.oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder :
											this.oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo);
			retObj.Auflagedurchmesser	= this.Sattel.oData.DA;
			retObj.Baulaenge			= this.Sattel.strSattellaenge;
			retObj.Laenge				= this.Sattel.strSattellaenge;
			retObj.Gewicht_Oberfl		= this.Sattel.m_Pgewicht + (this.Abhebesicherung ? this.Abhebesicherung.m_Pgewicht : 0);
			retObj.Fussbreite			= (retObj.LagerTyp == "ITB" ? this.Sattel.oData.A : '')
		}
		if (this.TopoLager2)
		{
			retObj.nennweite			= (this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? '' :
											this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo);
			retObj.aussendurch			= (this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder :
											this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
			retObj.Daemmdicke			= this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
			retObj.MediumTemperatur		= this.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium;
			retObj.UmgebungsTemperatur	= "-10|+80";
            retObj.ReferenzTemperatur	= retObj.MediumTemperatur;
			if (retObj.MediumTemperatur*1 <= 350 && retObj.MediumTemperatur*1 >=40)
				retObj.ReferenzTemperatur	-= 20;
			var Haenger		= this.getCurrentHaenger();
			if (Haenger instanceof Federhaenger)
				retObj.Betriebslast		= (right(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 7) == "EINFACH" ? 1 : 2) * Haenger.warmlast;
			else if (Haenger instanceof Konstanthaenger)
				retObj.Betriebslast		= (right(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 7) == "EINFACH" ? 1 : 2) * Haenger.sollast;
			else
				retObj.Betriebslast		= this.TopoLager2.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief;
			retObj.Nennlast				= this.TopoLager2.Lager.oData.F_AUFL_CALCULATION;
		}
        return retObj;
    },

    getLGG : function()
    {
        var myHaenger = this.getCurrentHaenger();
        var ret = "";
        if (myHaenger && myHaenger.isFHaenger()){
            if ((myHaenger.m_Ptypid == "SSG") && (myHaenger.m_dNennlast*1 == 5))
				ret	= "0008";
			else  if ((myHaenger.m_Ptypid == "SSG") && (myHaenger.m_dNennlast*1 == 303))
				ret	= "0380";
			else if (myHaenger.m_Ptypid == "SSB"){	// die Nennlast der Bcke ist zum Teil anders als die der SSB
				switch (myHaenger.m_dNennlast * 1){
					case 3 :
					case 5 :
						ret	= "0008";
						break;
					case 121 :
						ret = "0130";
						break;
					case 202 :
						ret = "0234";
						break;
					case 303 :
						ret = "0380";
						break;
					case 590 :
						ret = "0600";
						break;
					case 835 :
						ret = "0900";
						break;
					case 1730 :
						ret = "1750";
						break;
					default :
						ret = myHaenger.m_strLGG;
						break;
				}
			}
			else
				ret = myHaenger.m_strLGG;
		}
        return ret;
    },

    getLKSystemEmass : function()
    {
        var lkTyp = this.dataAccess.getLastketteTyp();
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
        var MassOben = 0, MassUnten = 0;

        if ((lkTyp == "EINZEL_HAENGER")		|| (lkTyp == "EINZEL_SCHELLE")	||
            (lkTyp == "EINZEL_ZUBEHOER")	|| (lkTyp == "EINZEL_LAGER")	||
			(left(lkTyp, 5) == "LAGER"))
        {
            MassOben = getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            MassUnten = getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        }
        else if ((lkTyp == "GELENKSTREBE")  || (lkTyp == "GELENKSTUETZE") ||
				 (lkTyp == "STOSSBREMSE"))
        {
            if (topologieKlasse.bHaengend)
            {
                MassOben = getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL");
                MassUnten = getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
            else
            {
                MassOben = getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                MassUnten = getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
        }
        else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                 (lkLastabtragung == "STUETZEND_DOPPEL"))
        {
            MassOben = getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            MassUnten = getstring("UBA", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        }
        else
        {
            MassOben = getstring("OBA",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            MassUnten = getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        }
		//nMassOben = parseFloat(MassOben);
		//nMassUnten = parseFloat(MassUnten);

        return (abs(atod(MassOben, 4) - atod(MassUnten, 4)));
    },

    getHaengerDaten : function(thePresets)
    {
        var retObj = {leistungsgroesse: '',     // bei Konstant
                      lastgroesse: '',          // bei Feder
                      typ_traeger: '',
                      laenge_vteil: '',
                      anz_haenger: 0,
                      lastweg_diag: 'I',
                      warmlast: '-',
                      kaltlast: '-',
                      lastaenderung: '-',
                      lastjustierung: '-',
                      federrate: '-',
                      nennweg: '',
                      wegreserve_oben: '-',
                      wegreserve_unten: '-',
                      verstellreserve_oben: '-',
                      verstellreserve_unten: '-',
                      Sollweg: '-',
                      RichtungBewegung: '-',
                      Lasteinstellung: '-',
                      SollastHpkt:  '-',
                      ZuslastHpkt: '-',
                      Haengertyp: 'S',       // Default S = Starr
                      Beschichtung: '',
                      Blockierung: '',
                      HaengertypCode: '',
                      obflschutz: '',
                      gewicht: '',
                      obflschutz_fsg: '',
                      gewicht_fsg: ''
                      };
		
        var haenger		= this.getCurrentHaenger();
		
        var AchsDirInfo	= this.dataAccess.getAchsKSInfo();
		
		if (haenger)
            retObj.HaengertypCode = haenger.m_Ptyp;
        
		if (haenger && haenger.isHaenger())
        {
            retObj.SollastHpkt  = haenger.SollastHpkt;
            retObj.ZuslastHpkt  = haenger.Zusatzlast;
            retObj.nennweg      = haenger.nennweg;
            retObj.obflschutz   = Oberflaechenschutz[haenger.m_Poberfl];
            retObj.gewicht      = haenger.m_Pgewicht;

            if (haenger.m_Ptypid == "FSG")
            {
                retObj.obflschutz_fsg   = Oberflaechenschutz[haenger.m_Poberfl];
                retObj.gewicht_fsg      = haenger.m_FDT_TGewicht;   
                // GEWICHT_FSG ist nur das Gewicht der Verlngerung
                // GEWICHT_FSG = GEW_PLATT +  (E - Emin) x delGewicht / 1000
            }
            
            if (haenger.m_Ptypid != "SSG")
            {
				//var strRichtungBewegung = translate("IDC_LABEL_RICHTUNG_"+this.dataAccess.getSollwerteRichtungBewegung()); // AUF, AB
				var sollweg_ab	= abs(getstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_minus["+AchsDirInfo[6]+"]")*1);
				var sollweg_auf	= abs(getstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_plus["+AchsDirInfo[6]+"]")*1);
				
				var strRichtungBewegung = translate("IDC_LABEL_RICHTUNG_AUF");
				if (haenger.sollweg * 1 < 0)
					var strRichtungBewegung = translate("IDC_LABEL_RICHTUNG_AB");
				//if (haenger.m_Pblock == "BLOCK_MITTIG")
				if (haenger.m_Pblock == "BLOCK_MITTIG")	// || (sollweg_ab != 0 && sollweg_auf != 0))
					strRichtungBewegung = translate("IDC_LABEL_RICHTUNG_AUF") + "/" + translate("IDC_LABEL_RICHTUNG_AB");
					//strRichtungBewegung = translate("IDC_LABEL_RICHTUNG_AB") + "/" + translate("IDC_LABEL_RICHTUNG_AUF");
                retObj.RichtungBewegung = strRichtungBewegung;
            }
			
            if (haenger.isKHaenger())
            {
				retObj.leistungsgroesse = haenger.groesse;
                retObj.Haengertyp = "K";
                retObj.Beschichtung = haenger.m_Pbeschicht;
                retObj.Blockierung = haenger.m_Pblock;
            }

            if (haenger.isFHaenger())
            {
                retObj.lastgroesse = haenger.groesse;
                retObj.Haengertyp = "F";
                retObj.Beschichtung = haenger.m_Pbeschicht;
                retObj.Blockierung = haenger.m_Pblock;
                
                retObj.Lasteinstellung = translate("IDC_LABEL_" + this.dataAccess.getSollwerteArtSollast() + "LAST" );    // Lasteinstellung: kalt / warm
            }

            if (this.bDoppelt && (haenger.m_Ptypid != "FDT"))
                retObj.anz_haenger = 2;
            else
                retObj.anz_haenger = 1;

            if (haenger.m_Ptypid == "FDT")
            {
                retObj.laenge_vteil = haenger.m_FDT_FSG_LaengeVteil;  // Lnge Traverse bei FDT = L - 2*c_ ... Feld LAENGE_VTEIL
                retObj.typ_traeger = haenger.m_FDT_Traegertyp;   // Trgertyp Traverse Feld TRAEGER_TYP

                retObj.gewicht     = haenger.m_FDT_GehGew + haenger.m_FDT_TGewicht;   // "gehgew" aus ** FDT; T_gewicht aus  ** FDT_TRAV
            }
            if (haenger.m_Ptypid == "FSG")
            {
                retObj.laenge_vteil = haenger.m_FDT_FSG_LaengeVteil;  // Lnge Verlngerungsrohr bei FSG = E - LX
            }

            if (thePresets && (tolower(thePresets.LASTWEG_PROT_FH) == "true"))
                if ( haenger.isFHaenger() && (haenger.m_Ptypid != "SSG"))
                    retObj.lastweg_diag = "K";
            if (thePresets && (tolower(thePresets.LASTWEG_PROT_KH) == "true"))
                if ( haenger.isKHaenger() )
                    retObj.lastweg_diag = "K";

            if ( haenger.isFHaenger() )
            {
                retObj.warmlast         = "" + haenger.warmlast;
				/*	Vorerst auskommentiert da das EXCEL-Makro (Prfmaschine) das nicht vertrgt
				if ((haenger.warmlast2) && (haenger.warmlast2 > 0)){
					if (haenger.warmlast2*1 >= haenger.warmlast*1) 
						retObj.warmlast = haenger.warmlast2 + "/" + haenger.warmlast;
					else
						retObj.warmlast = haenger.warmlast + "/" + haenger.warmlast2;
				}
                */
				retObj.kaltlast         = haenger.kaltlast;
                retObj.lastaenderung    = haenger.lastabw;
                retObj.federrate        = haenger.federrate;
                if (haenger.m_Ptypid == "SSG")
                {
                    retObj.verstellreserve_oben  = haenger.res_oben;
                    retObj.verstellreserve_unten = haenger.res_unten;
                    retObj.lastaenderung    = "-";
                    retObj.federrate        = "-";
                }
				else
                {
                    retObj.wegreserve_oben  = haenger.res_oben;
                    retObj.wegreserve_unten = haenger.res_unten;
					if (haenger.m_Ptypid == "SSB"){
						retObj.lastaenderung    = "-";
						retObj.federrate        = "-";
						if (this.Verlaengerung){
							var VerstellSplit				= (this.Verlaengerung.subtyp).split("_");	// [0]..."plus" ; [1]..."minus"
							retObj.verstellreserve_oben		= VerstellSplit[0];
							retObj.verstellreserve_unten	= VerstellSplit[1];
						}
					}
					else if(haenger.m_Ptypid == "FSG"){
						retObj.verstellreserve_oben  = "+30";
						retObj.verstellreserve_unten = "-";
					}
                }
                if ((haenger.m_Ptypid == "FSS") || (haenger.m_Ptypid == "FSP"))
                {
                    // zustzlich!:
                    retObj.verstellreserve_oben  = "+" + (30 - haenger.AnpassungEmass);
                    retObj.verstellreserve_unten = ((haenger.AnpassungEmass > 0) ? "" : "-") + (0  - haenger.AnpassungEmass);
                }
                /*	Vorerst auskommentiert da das EXCEL-Makro (Prfmaschine) das nicht vertrgt
				if (sollweg_ab != 0 && sollweg_auf != 0)
					retObj.Sollweg	= "-" + sollweg_ab + "/" + sollweg_auf;
				else
				*/
					retObj.Sollweg	= haenger.sollweg;
				if (haenger.m_Pblock == "BLOCK_MITTIG")
					retObj.Sollweg = "+-" + fround(haenger.sollweg / 2, 0);
            }
            else if ( haenger.isKHaenger() )
            {
                retObj.warmlast              = haenger.sollast;
				
				//if (haenger.sollast * retObj.anz_haenger > haenger.SollastHpkt)		// Hnger nicht Recalct
				//	retObj.warmlast		= fround(haenger.sollast, 2);
				//else
				//	retObj.warmlast		= fround((haenger.SollastHpkt /*+ retObj.ZuslastHpkt*/) / retObj.anz_haenger, 2);
				
				retObj.kaltlast              = retObj.warmlast;
                // retObj.kaltlast              = haenger.sollast;  -scm- 5.4.08
                retObj.lastjustierung        = haenger.getFormatierteLastjustierung();
                retObj.wegreserve_oben       = haenger.weg_res;
                retObj.wegreserve_unten      = haenger.weg_res;
                /*		Vorerst auskommentiert da das EXCEL-Makro (Prfmaschine) das nicht vertrgt
				if (abs(haenger.sollweg_ab * 1) > 0 && abs(haenger.sollweg_auf * 1) > 0)
					retObj.Sollweg			 = "-" + haenger.sollweg_ab + "/" + haenger.sollweg_auf;
				else
				*/
					retObj.Sollweg           = haenger.sollweg;
				if (haenger.m_Pblock == "BLOCK_MITTIG")
					retObj.Sollweg = "+-" + atoi(haenger.sollweg / 2);
                if ((haenger.m_Ptypid == "KSR") || (haenger.m_Ptypid == "KSP"))
                {
                    // zustzlich!:
					var nAnpassOben = (haenger.AnpassungEmass > 0) ?  abs(haenger.AnpassungEmass) : 0;
					var nAnpassUnten = (haenger.AnpassungEmass < 0) ?  abs(haenger.AnpassungEmass) : 0;
                    retObj.verstellreserve_oben  = "+" + (20 - nAnpassOben + nAnpassUnten);
                    retObj.verstellreserve_unten = "-" + (20 - nAnpassUnten + nAnpassOben);
                }
            }
        }
        else    // Starr:
        {
            // positive Vertikale zeigt nach oben
			var LastDir	= "-";	// default
			if (left(getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"), 2) == "AB")
				LastDir	= "+";
			// Setzt voraus, dass die LK im Dlgbereich ist:
            var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
            var Fsoll             = this.dataAccess.getSollwerteLast(LastDir, 1, AchsDirInfo[6]);
            var a_ZusLast         = this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
            var a_ZusLast_EG	  = this.dataAccess.getSollwerteZusatzLastEG();
			var dTestload         = this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
            var a_Fsoll = 0;
            if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
                a_Fsoll = (Math.abs(Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2;
            else
                a_Fsoll = Math.abs(Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG);

            retObj.warmlast              = a_Fsoll;
            retObj.kaltlast              = a_Fsoll;

            retObj.SollastHpkt = Math.abs(Fsoll);
            retObj.ZuslastHpkt = Math.abs(a_ZusLast);
        }
        return retObj;
    },

    getKlemmlaschenDaten : function()
    {
        var retObj = {btr: '',
                      fl: '',
                      obflschutz: '',
                      gewicht: ''
                      };

        var klasche = this.getKlemmlasche();
        if (klasche)
        {
            retObj.btr = klasche.m_strMassBTR;
            retObj.fl  = klasche.m_strMassTG;
            retObj.obflschutz  = Oberflaechenschutz[klasche.m_Poberfl];
            retObj.gewicht     = klasche.m_Pgewicht;
        }
		else
		{
			var kSystem = this.getKlemmsystem();
			var Lager	= this.getLager();
			if (kSystem)
			{
				//retObj.btr = kSystem.strDBTraegerbreite;
				//retObj.btr = kSystem.oData.TRAEGERBREITE;
				retObj.btr = this.oDlgLagerSession.AuswahlStandard.dBeamWidth;
				// retObj.fl  = kSystem.;	?? unbekannt
				retObj.fl = this.oDlgLagerSession.AuswahlStandard.dBeamThickness;
				retObj.obflschutz  = Oberflaechenschutz[kSystem.m_Poberfl];
				retObj.gewicht     = kSystem.m_Pgewicht;
			}
			else if (Lager && (left(Lager.m_Ptypid, 2) == "FL" || left(Lager.m_Ptypid, 2) == "FV")){
				// 27.03.14 Wunsch -Wh- bei kleineren Trgerbreiten "140" rausschreiben
				retObj.btr = (this.oDlgLagerSession.AuswahlStandard.dBeamWidth*1 > 140 ? this.oDlgLagerSession.AuswahlStandard.dBeamWidth : 140);
			}
		
		}

        return retObj;
    },

    getKlemmlasche : function()
    {
        return null;
    },

    getKlemmsystem : function()
    {
        return null;
    },

    getSonderteilDaten : function()
    {
        var retObj = {OBERFL_STAHLB: '',
					  OBERFL_CODE: '',
                      GEWICHT_STAHLB: '',
                      STAHLBAU: {}
                      };
		
		var i = 0;
		var sonderteil = null;
		var gewicht = 0;
        for(i = 0; i < caMainController.topologieKlasse.Sonderteile.length; i++)
        {
			sonderteil = caMainController.topologieKlasse.Sonderteile[i];
			if ((sonderteil.RMLaenge > 0) || (sonderteil.RMBreite > 0))
			{
				// Den Code bergeben, egal ob vom ersten oder letzten, da alle gleich sein mssen:
				if (sonderteil.bOberflaechenschutzFrei > 0)
				{
					retObj.OBERFL_STAHLB = Oberflaechenschutz[sonderteil.m_Poberfl];
					retObj.OBERFL_CODE = sonderteil.m_Poberfl;
				}	
				if (sonderteil.strFertigungsverfahren != "")
					retObj.STAHLBAU[sonderteil.strFertigungsverfahren] = 1;
				gewicht += sonderteil.m_Pgewicht;
			}
        }
		retObj.GEWICHT_STAHLB = gewicht;
		
        return retObj;
    },

    getSonstigeDaten : function()
    {
        var retObj = {OBERFL_ZZF: '',
                      OBERFL_ZTN: '',
                      TYP_ZZF: '',
                      LASTGR_ZZF: '',
                      LEISTUNGSGR_ZZF: '',
                      DICKE: '',
                      GEWICHT_ZTN: '',
                      GEWICHT_ZZF: '',
					  TYP_KSY: ''
                      };

        var stkList = [];
        this.getStueckliste(stkList);

        for (var i = 0; i < stkList.length; i++)
        {
            if ((stkList[i].produkt.m_Ptypid == "ZZF") ||
                (stkList[i].produkt.m_Ptypid == "ZZK"))
            {
                var groesseFuerSap = stkList[i].produkt.groesse;
                if (left(groesseFuerSap, 1) == "0")
                    groesseFuerSap = right(groesseFuerSap, 1);

                if (stkList[i].produkt.m_Ptypid == "ZZF")
                {
                    retObj.OBERFL_ZZF = Oberflaechenschutz[stkList[i].produkt.m_Poberfl];
                    retObj.TYP_ZZF = "ZZF";
                    retObj.LASTGR_ZZF = groesseFuerSap;
                    retObj.GEWICHT_ZZF = stkList[i].produkt.m_Pgewicht;
                }
                if (stkList[i].produkt.m_Ptypid == "ZZK")
                {
                    retObj.OBERFL_ZZF = Oberflaechenschutz[stkList[i].produkt.m_Poberfl];
                    retObj.TYP_ZZF = "ZZK";
                    retObj.LEISTUNGSGR_ZZF = groesseFuerSap;
                    retObj.GEWICHT_ZZF = stkList[i].produkt.m_Pgewicht;
                }
            }
            if (stkList[i].produkt.m_Ptypid == "ZTN")
            {
                retObj.OBERFL_ZTN = Oberflaechenschutz[stkList[i].produkt.m_Poberfl];
                retObj.GEWICHT_ZTN = stkList[i].produkt.m_Pgewicht;
            }

			// 6.3.09: Hier soll jetzt auch bei HZx das Mass s der Schelle kommen, (ZVX: Dicke der Verbindungslasche: = s1) wird entfernt, soll spter eigenes Merkmal werden
            if (	// (left(stkList[i].produkt.m_Ptypid, 2) == "ZV") ||
				(left(stkList[i].produkt.m_Ptypid, 2) == "HZ") ||
                (left(stkList[i].produkt.m_Ptypid, 2) == "HD"))
            {
                var massPath = "TMP.ZB_ADDITIONAL_DATA";
                stkList[i].produkt.getAdditionalDataToStore(massPath);
				/*
                if (left(stkList[i].produkt.m_Ptypid, 2) == "ZV")
                {
                    retObj.DICKE = getstring("S1", massPath);
                }
				*/
                if (left(stkList[i].produkt.m_Ptypid, 2) == "HZ")
                {
                    retObj.DICKE = getstring("S", massPath);
                }
                if (left(stkList[i].produkt.m_Ptypid, 2) == "HD")
                {
                    retObj.DICKE = getstring("S", massPath);
                }
            }
			
			// Merkmal TYP_KSY
			if (stkList[i].funktion == "KSY")
				retObj.TYP_KSY	= stkList[i].produkt.strBaureihe + " " + stkList[i].produkt.strBauF;
        }

        return retObj;
    },
	
	getDynamicDaten : function()
	{
		var retObj =	{LaengeDynamic: ''
						};
		if (this.Haenger.m_Ptypid == "SSG")
			retObj.LaengeDynamic	= this.Haenger.m_Pemass;
		else if (this.Verlaengerung)
			retObj.LaengeDynamic	= this.Verlaengerung.m_Pemass;
		
		return retObj;
	},

    getAnzGewstangen : function()
    {
        var stkList = [];
        var anzGewSt = 0;
        this.getStueckliste(stkList);

        for (var i = 0; i < stkList.length; i++)
        {
            if (stkList[i].produkt.m_Ptypid == "ZRM")
                anzGewSt = anzGewSt + stkList[i].anz;
        }
        return anzGewSt;
    },

    getLagerAuswahlKontext : function()
    {
        var lkTyp             = this.dataAccess.getLastketteTyp();
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
        var Haenger           = this.getCurrentHaenger();
        var strAuswahlKontext = "";
        if (lkTyp == "EINZEL_LAGER")
            strAuswahlKontext = "EINZEL_LAGER";
        else if (lkLastabtragung == "STUETZEND_EINFACH")
        {
            if (Haenger && ((Haenger.m_Ptypid == "KSR") || (Haenger.m_Ptypid == "FSS")))
                strAuswahlKontext = "STUETZE_STD";
            else
                strAuswahlKontext = "STUETZE_PTFE";
        }
        else
            strAuswahlKontext = "TRAVERSE";
        return strAuswahlKontext;
    },

    getLastkettenIdentGeneric : function(theMainController, bFHaenger)
    {
        var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
        var lkTyp           = this.dataAccess.getLastketteTyp();
        var lkRohrverlauf   = this.dataAccess.getLastketteRohrverlauf();
        var lkSonderfall    = this.dataAccess.getLastketteSonderfall();
        var bLKmitSchelle   = this.dataAccess.getLastketteMitSchelle();
        var bLKnurSchelle   = this.dataAccess.getLastketteNurSchelle();
        var bLKasymmetrisch = this.dataAccess.getLastketteAsymmetrisch();

        // Sonderfall: bei Produktauslegung Einzel soll hier die Matnr
        // des Einzelprodukts zurckgeliefert werden, nicht die der Lastkette
        // 04/2008: Ausser bei Hngern, die werden immer als Lastkette gefhrt
        // 09/2008: Regel gilt nicht fr FSG / SSG
        // 10/2008: Und nicht, wenn noch Sonderteile dabei sind

        var einzelProdukt = this.getEinzelprodukt();
        if (einzelProdukt &&
            (this.Sonderteile.length <= 0) &&
			((lkTyp == "EINZEL_SCHELLE") || (lkTyp == "EINZEL_ZUBEHOER") || 
             (lkTyp == "EINZEL_LAGER")   || (lkTyp == "EINZEL_KLEMMSYSTEM") ||
			 ((lkTyp == "EINZEL_HAENGER") && (einzelProdukt.m_Ptypid == "FSG")) ||
			 ((lkTyp == "EINZEL_HAENGER") && (einzelProdukt.m_Ptypid == "SSG")) ) )
        {
            var astlDaten = einzelProdukt.getASTLDaten(theMainController);
            var retObj = {matnr : astlDaten.matnr,
						  aTexte : astlDaten.aTexte,
						  mat_kurz_txt : "",
						  klasse: einzelProdukt.getSAPKlassenName(),
						  typ: einzelProdukt.getSAPTyp()
						};
            return retObj;
        }

        var strLKTyp = "", strBaseInfo1 = "", strBaseInfo2 = "", strBaseInfo3 = "";
        var strTypFuerArtikeltext = "LK";
        
        // Einzelprodukt-Auswahl mit Sonderteil --> eigener LK-Typ:
        if ((einzelProdukt &&
            (this.Sonderteile.length > 0) &&
			((lkTyp == "EINZEL_SCHELLE") || (lkTyp == "EINZEL_ZUBEHOER") || 
             (lkTyp == "EINZEL_LAGER")   || (lkTyp == "EINZEL_KLEMMSYSTEM") ||
			 ((lkTyp == "EINZEL_HAENGER") && (einzelProdukt.m_Ptypid == "FSG")) ||
			 ((lkTyp == "EINZEL_HAENGER") && (einzelProdukt.m_Ptypid == "SSG")) ) )||
			 (einzelProdukt == null && lkTyp == "EINZEL_ZUBEHOER" && this.Sonderteile.length > 0))
        {
            strLKTyp = "LK1_RH_SO";
            strBaseInfo1 = "SPZ"
            strTypFuerArtikeltext = einzelProdukt.m_Ptyp;
        }
        else
        {
            if (lkTyp == "EINZEL_HAENGER")
            {
                if (lkLastabtragung == "HAENGEND_DOPPEL")   // Fall FDT
                    strBaseInfo1 = "LK2";
                else
                    strBaseInfo1 = "LK1";
            }
            else if ((lkLastabtragung == "WECHSELLAST") || (lkLastabtragung == "UNKNOWN"))
                strBaseInfo1 = "RH_SO";
            else if (lkLastabtragung == "HAENGEND_VERZWEIGT")
                strBaseInfo1 = "LK3";
            else if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
                strBaseInfo1 = "LK2";
            else
                strBaseInfo1 = "LK1";

            if (lkTyp == "STARR")
                strBaseInfo2 = "ST";
            else if ((lkTyp == "BEWEGLICH") || (lkTyp == "EINZEL_HAENGER"))
            {
                if ((lkLastabtragung == "STUETZEND_EINFACH") || (lkLastabtragung == "STUETZEND_DOPPEL"))
                {
                    if (bFHaenger)
                        strBaseInfo2 = "FS";
                    else
                        strBaseInfo2 = "KS";
                }
                else
                {
                    if (bFHaenger)
                        strBaseInfo2 = "FH";
                    else
                        strBaseInfo2 = "KH";
                }
            }
            else if (lkTyp == "GELENKSTUETZE")
                strBaseInfo2 = "FG";
            else if (lkTyp == "GELENKSTREBE")
                strBaseInfo2 = "SG";
			else if (lkTyp == "STOSSBREMSE")
				strBaseInfo2 = "SB";

            if (bLKmitSchelle && (this.Schelle || this.Lager || this.TopoLager2))  // Anwender kann auch "ohne" bei der Schellenauswahl whlen ...
                strBaseInfo3 = "SH";
            else if ((lkTyp == "EINZEL_HAENGER") && (lkLastabtragung != "HAENGEND_DOPPEL") &&
                     (strBaseInfo2 != "FH") && (strBaseInfo2 != "FS"))     // Sonderfall FDT auch hier, auf Wunsch schm 26.5.08
                strBaseInfo3 = "O";

            if (strBaseInfo1 == "RH_SO")
                strLKTyp = strBaseInfo1;
            else if (strBaseInfo3 == "")
                strLKTyp = strBaseInfo1 + "_" + strBaseInfo2;
            else
                strLKTyp = strBaseInfo1 + "_" + strBaseInfo2 + "_" + strBaseInfo3;
        }
        
        // Dummy-Produkt anlegen, weil die Suche nach Matnr und Texten fr die
        // Lastkette genauso luft wie beim Einzelprodukt
        var tempProduct = new Produkt();
        tempProduct.m_Ptypid = strLKTyp;
        tempProduct.m_Ptyp   = strTypFuerArtikeltext;

        // Welche Merkmale sind relevant fr Suche in Tabelle MATERIAL?
        var searchObj = { TYP: strLKTyp };
        // An welchen Spalten-Positionen stehen diese Merkmale bei dieser Klasse?
        var aMerkmale = tempProduct.getMerkmaleArray(strBaseInfo1, searchObj);
        // Jetzt such ...
        var retObj    = tempProduct.getMatInfo(theMainController, strBaseInfo1, aMerkmale, "", 1);  // strBaseInfo1 == strKlasse

        // retObj.matnr, mat_kurz_txt schon drin
        retObj.klasse = strBaseInfo1;
        retObj.typ    = strLKTyp;

        return retObj;
    },

    berechneGewindestangenVerteilung : function(vorschlagGewindestangen, gewStangenLaenge, minGewstangenLaenge, maxGewStangenLaenge)
    {
        var nMaxLaenge = 3000;

        if ((gewStangenLaenge < 6000) &&
            (maxGewStangenLaenge > 3000) &&
            (caMainController.presets.m_nGewindestangenStandardLaenge == "GEW_STDLEN_2000"))
            nMaxLaenge = 2000;      // (im Notfall immer lngere Stangen nehmen)

        if (gewStangenLaenge <= 2000)
        {
            // wir brauchen keine Belegungsvorgabe
            vorschlagGewindestangen.push(gewStangenLaenge);
        }
        else
        {
            var len, restlen = gewStangenLaenge;
            for (var i = 0; i < 5; i++)
            {
                len = min(restlen, nMaxLaenge);
                // Achtung Spezialfall: Wenn das nchste Stck dann kleiner als die
                // minGewstangenLaenge wird, mssen wir dieses etwas krzer machen!
                if ((len > 0) &&
                    (restlen >= nMaxLaenge) &&
                    ((restlen - len) < minGewstangenLaenge) &&
                    ((restlen - len) > 0))
                    len = restlen - minGewstangenLaenge;

                if (len > 0)
                    vorschlagGewindestangen.push(len);
                else
                    break;
                restlen = restlen - len;
            }
            // die "kurze" Stange ist hier immer im letzten Array-Element.
            // in der Praxis ist gewnscht, dass diese nahe beim Spannschloss ist.
            // d.h. bei OBEN mssen wir das Array von 0 ... Ende durchlaufen,
            // bei UNTEN von Ende ... 0
        }
    },

	bestimmeMutternPreiseGewichte : function(stkList, bOhneMuttern)
	{
        var muttAnz = 0, i = 0, CheckMatStatus = false;
        for (i = 0; i < stkList.length; i++)
        {
            muttAnz += stkList[i].anz * stkList[i].produkt.getAnzMuttern();
        }
        if (bOhneMuttern)
            muttAnz = 0;

        if (muttAnz == 0)
            this.Mutter = null;
        else
        {
            // das Mutter-Objekt wird "gecacht"
            // --> !!! lschen, wenn man neu in die Schlussmaske kommt, weil sich die LGV ndern kann
            if (! this.Mutter)
            {
                this.Mutter = new Zubehoer();
                this.Mutter.Init("ZMM", this.a_lgv, "IDL_C_DEFAULT");
            }

            // Mutter der Stckliste hinzufgen:
            stkListPart = {anz: muttAnz, funktion : "ACC", position : "IRR", produkt : this.Mutter};
            stkList.push(stkListPart);
        }

        // -----
        for(i = 0; i < this.Sonderteile.length; i++)
        {
            if (stkList.length == 0 && trimright(trimleft(this.matStatus, " "), " ") == ""){	// nur Sonderteile enthalten und Status nicht gesetzt
				CheckMatStatus = true;
				this.matStatus = "OK";
			}
			// !!! hier wird zustzlicher Member ins Objekt eingefgt: sTeilIndex = Index + 1
            stkListPart = {anz: this.Sonderteile[i].nAnzahl, funktion : "SON", position : "IRR", produkt : this.Sonderteile[i], sTeilIndex : (i+1)};
            stkList.push(stkListPart);
			
			if ((CheckMatStatus) && (trimright(trimleft(Sonderteile[i].WIMatnr, " "), " ") == "")){
				CheckMatStatus = false;
				this.matStatus = "ERROR";
			}
        }


        // Jetzt knnen wir Gesamtgewicht und Gesamtpreis der LK berechnen:
		var oOptions = {};
		if (this.presets)
			oOptions = this.presets.getPreisOptions();
        var gesGewicht = 0, gesPreis = 0, einzelPreis = 0;
        var bPreisFehlt = false;
        for (i = 0; i < stkList.length; i++)
        {
            einzelPreis = stkList[i].produkt.getPreis(oOptions);
            if (einzelPreis <= 0){
                bPreisFehlt	= true;
				einzelPreis	= 0;
			}
            gesGewicht += (stkList[i].anz * stkList[i].produkt.m_Pgewicht);
            gesPreis   += (stkList[i].anz * einzelPreis);  // berechneter oder Vorgabe
        }
        this.gesamtGewicht  = gesGewicht;
        this.gesamtPreis    = gesPreis;
        if (bPreisFehlt)
            this.preisStatus    = "ERROR";
        else
            this.preisStatus    = "OK";
    },

	getStuecklisteForDisplay : function(oOptions, myMainController)
	{
        var stkList = [];
        var stkListForDisplay = [];
        var stkListPart;
        var strVorgabePreis, strBemerk;
        var oberflaechenschutzData;
        var nObFlGruppe;
        var oMatInfo;
        var gesgewicht = 0, gespreis = 0;
        var bMatnrFehlt = false;
        var strWerkname = "";
        var strPreisAnzeige = "";
        var bMitPreis = (getstring("PCODE", "CATALOG.SETTINGS") == "630927");
		var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
		if (dCurrencyFactor <= 0.01)
			dCurrencyFactor = 1;

        this.getStueckliste(stkList);

        for (var i = 0; i < stkList.length; i++)
        {
            if (stkList[i].produkt.m_dKundenPreis > 0)
                strVorgabePreis = stkList[i].produkt.m_dKundenPreis;
            else
                strVorgabePreis = "";
			
			//var Einzelpreis = (dCurrencyFactor * stkList[i].produkt.getPreis(oOptions)).toFixed( 2 );
			var Einzelpreis = fround(dCurrencyFactor * stkList[i].produkt.getPreis(oOptions), 2);

            gesgewicht += (stkList[i].anz * stkList[i].produkt.m_Pgewicht);
            gespreis   += (stkList[i].anz * Einzelpreis);

            oberflaechenschutzData = [];
			if(myMainController.topologieKlassenName !="CaTopoLager2"){
				if (stkList[i].produkt.m_Ptypid == "SON")
				{
					oberflaechenschutzData.push([stkList[i].produkt.m_Poberfl,
												 translate(OberflaechenschutzTransID[stkList[i].produkt.m_Poberfl])]);
				}
				else
				{
					nObFlGruppe = stkList[i].produkt.getOberFlaechenSchutzGruppe();
					//var Test	= typeof nObFlGruppe;
					if (typeof nObFlGruppe == 'object'){
						for (var j = 0; j < nObFlGruppe.length; j++)
						{
							oberflaechenschutzData.push([nObFlGruppe[j],
														 translate(OberflaechenschutzTransID[nObFlGruppe[j]])]);
						}
					}
					else{
						for (var j = 0; j < MoeglicherOberflaechenschutz[nObFlGruppe].length; j++)
						{
							oberflaechenschutzData.push([MoeglicherOberflaechenschutz[nObFlGruppe][j],
														 translate(OberflaechenschutzTransID[MoeglicherOberflaechenschutz[nObFlGruppe][j]])]);
						}
					}
				}
			}
			else{
				oberflaechenschutzData.push([stkList[i].produkt.m_Poberfl,
												 translate(OberflaechenschutzTransID[stkList[i].produkt.m_Poberfl])]);
			}

            if (stkList[i].produkt.m_Pwerkstoff == "W_SONST")
                strWerkname = stkList[i].produkt.m_Pwerkname;
			else if (Werknamen[stkList[i].produkt.m_Pwerkstoff] == '')
				strWerkname = '';
            else 
                strWerkname = (Werknamen[stkList[i].produkt.m_Pwerkstoff] ? Werknamen[stkList[i].produkt.m_Pwerkstoff] : stkList[i].produkt.m_Pwerkstoff);
			
			
            if (stkList[i].produkt.m_Pzeichnr != "")
                strBemerk = translate(stkList[i].produkt.m_Pzeichnr);
            else
                strBemerk = "";

            // 2008-03-12 Neu: Bestimme auch die Materialnummern der Produkte
            oMatInfo = stkList[i].produkt.getASTLDaten(myMainController);
            if (oMatInfo.matnr == "")
                bMatnrFehlt = true;
                
            if (bMitPreis)
                strPreisAnzeige = sprintf("%.2f", Einzelpreis);
            else
                strPreisAnzeige = "-";

            stkListPart = {
				id: i + 1,
				text: stkList[i].produkt.m_Ptyp,

                stck: stkList[i].anz,
				gewicht: sprintf("%.2f", stkList[i].produkt.m_Pgewicht),
				preis: strPreisAnzeige,
				preis_vorgabe: ,
				werkstoff: strWerkname,     // s.auch  m_Pwerkname, m_Pwerkalt
				werkstoff_sonder: false,
				oberflaechenschutz: (OberflaechenschutzTransID[stkList[i].produkt.m_Poberfl] ? translate(OberflaechenschutzTransID[stkList[i].produkt.m_Poberfl]) : ''),

				// Das ist eine Aufklappliste:
				oberflaechenschutz_data: oberflaechenschutzData,
                matnr: oMatInfo.matnr,
				bemerkungen: strBemerk,     // pro Teil der Stkliste Cascade-generierte Bemerkungen ergnzen
				// Ich setze das hier einfach mal so
				sonderteil: ((stkList[i].sTeilIndex) ? stkList[i].sTeilIndex : 0)  
			};
            stkListForDisplay.push(stkListPart);
        }

        if (oOptions.ZUSATZLEISTUNG_KOSTEN != 0)
            gespreis   += oOptions.ZUSATZLEISTUNG_KOSTEN;

        if (bMitPreis)
            strPreisAnzeige = sprintf("%.2f", oOptions.ZUSATZLEISTUNG_KOSTEN);
        else
            strPreisAnzeige = "-";

        if ((oOptions.ZUSATZLEISTUNG_KOSTEN != 0) ||
            (oOptions.ZUSATZLEISTUNG_TEXT != ""))
        {
            stkListPart = {
                id: 'Z',
                text: oOptions.ZUSATZLEISTUNG_TEXT,
                stck: ' ',
                gewicht: '',
                preis:   strPreisAnzeige,
                preis_vorgabe: '',
                werkstoff:  '',
                werkstoff_sonder: false,
                oberflaechenschutz: '',
                oberflaechenschutz_data: [],
                matnr: '',
                bemerkungen: '',
				sonderteil: false
            };
            stkListForDisplay.push(stkListPart);
        }

        // Hnger kommen als LK, daher hier auch die Summeninfo wichtig
        // if (stkList.length > 1)
        //{
            var  LKMatInfo = this.getLastkettenIdent(myMainController);

            if (bMitPreis)
                strPreisAnzeige = sprintf("%.2f", gespreis);
            else
                strPreisAnzeige = "-";

            stkListPart = {
                id: ' ',
                text: translate("IDC_LABEL_WI_SUMME_LK"),
                stck: ' ',
                gewicht: sprintf("%.2f", gesgewicht),
                preis:   strPreisAnzeige,
                preis_vorgabe: '',
                werkstoff:  '',
                werkstoff_sonder: false,
                oberflaechenschutz: '',
                oberflaechenschutz_data: [],
                matnr: LKMatInfo.matnr,
                bemerkungen: translate("IDC_LABEL_WI_MATNR_LK"),
				sonderteil: false
            };
            stkListForDisplay.push(stkListPart);
        //}

        if (bMatnrFehlt)
            this.matStatus    = "ERROR";
        else
            this.matStatus    = "OK";

        return { rows : stkListForDisplay };
    },

    deleteStklistItem : function(indexSonderteil)
    {
        // Uergebener Index ist +1 dem Array-Index; wir lschen ein Element
        this.Sonderteile.splice((indexSonderteil-1), 1);
        var hallo = 0;
    },

	setStuecklistenDatenFromDisplay : function(table)
	{
        var stkList = [];
        var nObFlGruppe, strObflFromObfl;
        this.getStueckliste(stkList);

        for (i = 0; i < stkList.length; i++)
        {
            if (table[i].preis_vorgabe > 0)
            {
                stkList[i].produkt.m_dKundenPreis = table[i].preis_vorgabe;
                stkList[i].produkt.m_bPreisVorgabe = 1;
            }
            else
            {
                if (stkList[i].funktion != "SON")
                {
                    stkList[i].produkt.m_dKundenPreis = 0;
                    stkList[i].produkt.m_bPreisVorgabe = 0;
                }
            }

            /* @@@ berschreiben des Werkstoffs genauer regeln ...
            if (Werknamen[stkList[i].produkt.m_Pwerkstoff] != table[i].werkstoff)
            {
                stkList[i].produkt.m_Pwerkalt = stkList[i].produkt.m_Pwerkstoff;

            }
            */

            nObFlGruppe = stkList[i].produkt.getOberFlaechenSchutzGruppe();
            for (var j = 0; j < MoeglicherOberflaechenschutz[nObFlGruppe].length; j++)
            {
                strObflFromObfl = translate(OberflaechenschutzTransID[MoeglicherOberflaechenschutz[nObFlGruppe][j]]);
                if (strObflFromObfl == table[i].oberflaechenschutz)
                    stkList[i].produkt.m_Poberfl = MoeglicherOberflaechenschutz[nObFlGruppe][j];
            }
            stkList[i].produkt.makeTyp();
        }
    },

	/**
     *  Berechne die Schraege der Lastkette aufgrund axialer / lateraler Verschiebung des Rohrs
	 *  Nichtzu verwechseln mit Schraegzug (unglckliche Benennung), der eigentlich einen schrgen Rohrleitungsverlauf meint
     *  und eingegeben wird.
	 * @params -
	 * @returns	double Winkel
     */
    getLKWinkel : function()
	{
        // Nur bei hngender Topologie relevant!
        var oRet = { a_Schraegzug : 0,
                     a_Schraegzug_100 : 0,
                     a_Schraegzug_50 : 0,
                     a_Schraegzug_Axial : 0,
                     a_Schraegzug_Lateral : 0,
                     Grenzwert : 0,
                     strVorspannung_ax : "-",
					 strVorspannung_lat : "-",
                     dSystemEmass : 0,
                     bErlaubt : true,
					 bMoeglich : true};

        var dSystemEmass = this.getLKSystemEmass();
        oRet.dSystemEmass = dSystemEmass;

        return oRet;
    },

	/**
     *  hole den Filenamen fr das Kopfmodell fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-DXF fr die 3D CAD Darstellung der Lastkette
     *  hole den Filenamen fr das Rahmen-INI fr die 3D CAD Darstellung der Lastkette
	 *
	 *	hole Infos zur Darstellung des Fusses
	 *
	 * @params -
	 * @returns	string Filenamen des Kopfmodells (ohne Pfadangaben) und Fussinfos
     */
    getCadInfos : function(bQuick2D, bHaengerMitFussplatte, bLageplanVorhanden)
	{
        var oRet = { //headModel : "Auswahl_LKtyp.cc3",
                     headModel		: "AW_LKtyp_neu.cc3",
					 rahmenDxf		: "",
                     rahmenIni		: "",
                     lagerEinzel	: 0,
                     lagerFuss		: 0,
					 lagerFussTyp	: 'empty'
                     };
        /* Bei schnellem 2D-CAD:
        - Rahmen-wit_LK1_2D_oFP.ini  =>  einfache LK ohne separate Fussplattendarstellung in schneller 2D-Darstellung
        - fr einfache LK mit Fussplattendarstellung die bisherige Rahmenaufteilung verwenden (Rahmen-wit_LK1.ini)
        - Rahmen-wit_LK2_2D.ini          => doppelte LK in schneller 2D-Darstellung
        */

		if (bLageplanVorhanden)
		{
			if (this.bDoppelt)
			{
				oRet.rahmenDxf = "Rahmen-wit_LK2";
				if (bQuick2D)
					oRet.rahmenIni = "Rahmen-wit_LK2_2D.ini";
				else
					oRet.rahmenIni = "Rahmen-wit_LK2.ini";
			}
			else
			{
				oRet.rahmenDxf = "Rahmen-wit_LK1";
				if (bQuick2D && (!bHaengerMitFussplatte))
					oRet.rahmenIni = "Rahmen-wit_LK1_2D_oFP.ini";
				else
					oRet.rahmenIni = "Rahmen-wit_LK1.ini";
			}
		}
		else
		{
			if (this.bDoppelt)
			{
				oRet.rahmenDxf = "Rahmen-wit_LK2";
				if (bQuick2D)
					oRet.rahmenIni = "Rahmen-wit_LK2_2D_oLP.ini";
				else
					oRet.rahmenIni = "Rahmen-wit_LK2_3D_oLP.ini";
			}
			else
			{
				oRet.rahmenDxf = "Rahmen-wit_LK1";
				if (bQuick2D && (!bHaengerMitFussplatte))
					oRet.rahmenIni = "Rahmen-wit_LK1_2D_oLP.ini";
				else
					oRet.rahmenIni = "Rahmen-wit_LK1_3D_oLP.ini";
			}
		}
		
		var Strang	= (this.SegmentStrang ? true : false);
		
		switch (Strang ? this.SegmentStrang.Haenger.m_Ptypid : this.Haenger.m_Ptypid){
			case 'FHS' :
			case 'FSS' :
			case 'FSP' :
				oRet.lagerFuss		= 1;
				if ((Strang && this.SegmentStrang.Haenger.groesse*1 < 12) || (!Strang && this.Haenger.groesse*1 < 12))
					oRet.lagerFussTyp	= 'FS';
				else
					oRet.lagerFussTyp	= 'FS_12';
				break;
			case 'KSR' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KSR';
				break;
			case 'KSP' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KSP';
				break;
			case 'KVS' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KVS';
				break;
			case 'KHS' :
				oRet.lagerFuss		= 1;
				oRet.lagerFussTyp	= 'KHS';
				break;
			default :
				break;
		}
		
		return( oRet );
	},

    getGlobalCADParameters : function()
    {
		var aParams = new Array();
		var strPath = "DLGDATA.CA.FORMS.THREEDCADOPTIONS";

		// get params from store and convert them (can also be handled via conversion dictionary)
		var strStangenGekuerzt = getstring( "IDC_STANGEN_GEKUERZT", strPath );
		if ( strStangenGekuerzt == "true" )
			strStangenGekuerzt = "1";
		else strStangenGekuerzt = "0";
		var strDetails = getstring( "IDC_DETAILS", strPath );
		/*
		if ( strDetails == "DREI" )
			strDetails = "3"
		else if ( strDetails == "ZWEI" )
			strDetails = "2"
		else strDetails = "1"	// "EINS" or default
		*/
		var strDimensions = getstring( "IDC_BEMASSUNG", strPath );
		if ( strDimensions == "true" )
			strDimensions = "1";
		else strDimensions = "0";
		var strPosNr = getstring( "IDC_POSNR", strPath );
		if ( strPosNr == "true" )
			strPosNr = "1";
		else strPosNr = "0";
		var strRohr = getstring( "IDC_ROHR", strPath );
		var keinRUT	= 0;
		if (this.oDlgLagerSession)
			keinRUT	= this.oDlgLagerSession.Systemcharakteristik.bSel_krT*1;
		if ( strRohr == "true" && !keinRUT )
			strRohr = "1"
		else strRohr = "0"
		var strDaemmung = getstring( "IDC_DAEMMUNG", strPath );
		if ( strDaemmung == "true" )
			strDaemmung = "1"
		else strDaemmung = "0"

		var strTraeger = getstring( "IDC_TRAEGER", strPath );
		if ( strTraeger == "true" )
			strTraeger = "1"
		else strTraeger = "0"

		var strRohrWinkel = this.dataAccess.getSollwerteSchraegzug(1);
        if (abs(atod(strRohrWinkel.Beta)) < 4)
            strRohrWinkel.Beta = "0";

		// collect params in array
        aParams.push( [ "StangenGekuerzt", strStangenGekuerzt ] );	// 0, 1
		aParams.push( [ "kurz", strStangenGekuerzt ] );	// 0, 1
        //aParams.push( [ "Details", strDetails ] );					// 1, 2, 3
        aParams.push( [ "Dimensions", strDimensions ] );			// 0, 1 - alte Variante und Rollenlager
		aParams.push( [ "dim", strDimensions ] );					// 0, 1 - neue Variante Lastketten und Gleitlager
        aParams.push( [ "PosNr", strPosNr ] );						// 0, 1 - alte Variante
        aParams.push( [ "Rohr", strRohr ] );						// 0, 1 - alte Variante und Rollenlager
		aParams.push( [ "rohr", strRohr ] );						// 0, 1 - neue Variante Lastketten und Gleitlager
        aParams.push( [ "Daemmung", strDaemmung ] );				// 0, 1 - alte Variante und Rollenlager
        aParams.push( [ "traeger", strTraeger ] );				    // 0, 1 - neue Variante Lastketten und Gleitlager
        //aParams.push( [ "Rohrwinkel", strRohrWinkel.Beta ] );		// schrger Rohrleitungsverlauf in Grad
		aParams.push( [ "schrA", strRohrWinkel.Alpha ] );			// Drehung d. Rohrleitung um Senkrechte bei schrgem Rohrleitungsverlauf in Grad
		aParams.push( [ "schrB", strRohrWinkel.Beta ] );			// schrger Rohrleitungsverlauf in Grad

		return( aParams );
    },
	
	getCADParameters : function (aParams)
	{
		// StLi
		var stkList			= [];
		this.getStueckliste(stkList);
		var dy_LAW_LGx		= 0;
		var isEinzel_LAW	= 0;
		var lSN_oben		= 0;
		var lSN_unten		= 0;
		var rSN_oben		= 0;
		var rSN_unten		= 0;
		var lastPosNS		= 0;	// letzte Position die kein Sonderteil ist und keine Mutter ist
		// hier werden die Dbelplatten fr die Dynamikteile "verbastelt"
		for (var DUP = 0; DUP < stkList.length; DUP++){
			if (stkList[DUP].funktion == "SON" && left(toupper(stkList[DUP].produkt.m_Ptyp), 4) == "DUP "
				&& toupper(stkList[DUP].produkt.m_Pwerkname) == "S355J2"
				&& rfind(stkList[DUP].produkt.Artikeltext[1], "E-Pl=")){	// wir haben was gefunden
				// Prfen, ob das E-Ma der Platte korrekt hinterlegt ist
				var E_Platte	= stkList[DUP].produkt.Artikeltext[1].replace("E-Pl=", "");
				if (trimright(trimleft(E_Platte, " "), " ") == ""){
					DUP = stkList.length;
					break;
				}
				var TypGelBo	= "MBW";
				var TypDUP		= stkList[DUP].produkt.m_Ptyp;
				var FN_DUP		= TypDUP.split(" ");
				if (left(FN_DUP[1], 4)*1 == 46 || left(FN_DUP[1], 4)*1 == 100){
					TypGelBo	= "MBS"
					TypDUP		= FN_DUP[0] + " " + right(FN_DUP[1], FN_DUP[1].length - 1);
				}
				var NewStkList	= [];
				if ((stkList[DUP].anz*1 == 2 && !this.bDoppelt) || (stkList[DUP].anz*1 == 4 && this.bDoppelt)){	// Platte oben und unten
					// HLevel Korrektur
					var BA		= getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL")*1;
					var BAadd	= (BA < 0 ? (-2) : 2) * stkList[DUP].produkt.m_Pemass;
					setstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA + BAadd);
					// die Platte oben
					NewStkList[0]			= {};
					NewStkList[0].funktion	= "DUP";
					NewStkList[0].anz		= (stkList[DUP].anz / 2);
					NewStkList[0].produkt	= {};
					NewStkList[0].produkt.m_Ptyp	= stkList[DUP].produkt.m_Ptyp;
					NewStkList[0].produkt.m_Pemass	= (E_Platte * 1);
					// der Gelenkbock oben
					NewStkList[1]			= {};
					NewStkList[1].funktion	= "ZUB";
					NewStkList[1].anz		= (stkList[DUP].anz / 2);
					NewStkList[1].produkt	= {};
					NewStkList[1].produkt.m_Ptyp	= TypDUP.replace("DUP", TypGelBo);
					NewStkList[1].produkt.m_Pemass	= (stkList[DUP].produkt.m_Pemass * 1) - (E_Platte * 1);
					// alle Standardbauteile und sonstige Sonderteile (nicht "DUP")
					var DoSParts	= true;
					for (var Std = 0; Std < stkList.length; Std++){
						if (typeof(stkList[Std].sTeilIndex) == "undefined"
							|| (!DoSParts && Std != DUP))
							NewStkList.push(stkList[Std]);
						else if (DoSParts){	// vor die ggf. weiteren Sondrteile mssen die "neuen Teile"
							NewStkList[NewStkList.length]	= {};
							NewStkList[NewStkList.length-1].funktion	= "ZUB";
							NewStkList[NewStkList.length-1].anz		= (stkList[DUP].anz / 2);
							NewStkList[NewStkList.length-1].produkt	= {};
							NewStkList[NewStkList.length-1].produkt.m_Ptyp		= TypDUP.replace("DUP", TypGelBo);
							NewStkList[NewStkList.length-1].produkt.m_Pemass	= (stkList[DUP].produkt.m_Pemass * 1) - (E_Platte * 1);
							NewStkList[NewStkList.length]			= {};
							NewStkList[NewStkList.length-1].funktion	= "DUP";
							NewStkList[NewStkList.length-1].anz		= (stkList[DUP].anz / 2);
							NewStkList[NewStkList.length-1].produkt	= {};
							NewStkList[NewStkList.length-1].produkt.m_Ptyp		= stkList[DUP].produkt.m_Ptyp;
							NewStkList[NewStkList.length-1].produkt.m_Pemass	= (E_Platte * 1);
							if (Std != DUP)
								NewStkList.push(stkList[Std]);
							DoSParts	= false;
						}
					}
					DUP		= stkList.length;
				}
				else if ((stkList[DUP].anz*1 == 1 && !this.bDoppelt) || (stkList[DUP].anz*1 == 2 && this.bDoppelt)){	// Platte oben oder unten
					// HLevel Korrektur
					var BA		= getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL")*1;
					var BAadd	= stkList[DUP].produkt.m_Pemass * (BA < 0 ? (-1) : 1);
					setstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA + BAadd);
					// zuerst prfen, ob die Platte oben oder unten ist
					var isOben	= false;
					if (left(caMainController.dataAccess.getLastketteLastabtragung(), 8) == "HAENGEND")
						isOben	= true;
					if (isOben){
						NewStkList[0]			= {};
						NewStkList[0].funktion	= "DUP";
						NewStkList[0].anz		= (stkList[DUP].anz / 2);
						NewStkList[0].produkt	= {};
						NewStkList[0].produkt.m_Ptyp	= stkList[DUP].produkt.m_Ptyp;
						NewStkList[0].produkt.m_Pemass	= (E_Platte * 1);
						// der Gelenkbock oben
						NewStkList[1]			= {};
						NewStkList[1].funktion	= "ZUB";
						NewStkList[1].anz		= (stkList[DUP].anz / 2);
						NewStkList[1].produkt	= {};
						NewStkList[1].produkt.m_Ptyp	= TypDUP.replace("DUP", TypGelBo);
						NewStkList[1].produkt.m_Pemass	= (stkList[DUP].produkt.m_Pemass * 1) - (E_Platte * 1);
						// alle Standardbauteile und sonstige Sonderteile (nicht "DUP")
						for (var Std = 0; Std < stkList.length; Std++){
							if (typeof(stkList[Std].sTeilIndex) == "undefined" && Std != DUP)
								NewStkList.push(stkList[Std]);
						}
					}
					else{
						var DoSParts	= true;
						for (var Std = 0; Std < stkList.length; Std++){
							if (typeof(stkList[Std].sTeilIndex) == "undefined"
								|| (!DoSParts && Std != DUP))
								NewStkList.push(stkList[Std]);
							else if (DoSParts){
								NewStkList[NewStkList.length]	= {};
								NewStkList[NewStkList.length-1].funktion	= "ZUB";
								NewStkList[NewStkList.length-1].anz		= (stkList[DUP].anz / 2);
								NewStkList[NewStkList.length-1].produkt	= {};
								NewStkList[NewStkList.length-1].produkt.m_Ptyp		= TypDUP.replace("DUP", TypGelBo);
								NewStkList[NewStkList.length-1].produkt.m_Pemass	= (stkList[DUP].produkt.m_Pemass * 1) - (E_Platte * 1);
								NewStkList[NewStkList.length]			= {};
								NewStkList[NewStkList.length-1].funktion	= "DUP";
								NewStkList[NewStkList.length-1].anz		= (stkList[DUP].anz / 2);
								NewStkList[NewStkList.length-1].produkt	= {};
								NewStkList[NewStkList.length-1].produkt.m_Ptyp		= stkList[DUP].produkt.m_Ptyp;
								NewStkList[NewStkList.length-1].produkt.m_Pemass	= (E_Platte * 1);
								if (Std != DUP)
									NewStkList.push(stkList[Std]);
								DoSParts	= false;
							}
						}
					}
				}
			}
		}
		// jetz die StLi ggf. neu setzen
		if (typeof(NewStkList) != "undefined")
			stkList	= NewStkList;
		//
		for (var i = 1; i <= stkList.length; i++)
		{
			if (stkList[i-1].funktion != "SON"){
				if (stkList[i-1].produkt.m_Ptypid == "FHS" || stkList[i-1].produkt.m_Ptypid == "ZPK" ||
					stkList[i-1].produkt.m_Ptypid == "KVS" || stkList[i-1].produkt.m_Ptypid == "VBK" ||
					(stkList[i-1].produkt.m_Ptypid == "ZMM" && stkList[i-1].produkt.m_Pemass * 1 != 0))
					aParams.push( [ "lE" + i , (-1)*stkList[i-1].produkt.m_Pemass ] );
				else if (left(stkList[i-1].produkt.m_Ptypid, 2) == "FS" || left(stkList[i-1].produkt.m_Ptypid, 2) == "KS")
					aParams.push( [ "lE" + i , stkList[i-1].produkt.m_Pemass + (this.Haenger ? this.Haenger.AnpassungEmass : 0) ] );
				else
					aParams.push( [ "lE" + i , stkList[i-1].produkt.m_Pemass ] );
				if (stkList[i-1].funktion == "ABE" && stkList[i-1].anz*1 > 2 && stkList[i-1].produkt.strBaureihe == "LAW")
					dy_LAW_LGx	= (i > 1 ? stkList[i-2].produkt.oData.L/5 : 50);
				//else if (i != 1 && stkList[i-1].funktion == "GEL" && stkList[i-1].anz*1 > 2 && left(stkList[i-2].produkt.strBauF, 1)*1 / stkList[i-1].anz*1 != 1 )
				else if (i != 1 && stkList[i-1].funktion == "GEL" && stkList[i-2].produkt.anzGleitelemente*1 > 1){
					if (stkList[i-2].produkt.strBaureihe == "LXL")
						dy_LAW_LGx	= 25;
					else if (stkList[i-2].produkt.strBauF*1 == 64 && stkList[i-2].produkt.anzGleitelemente*1 > 2)
						dy_LAW_LGx	= 25;
					else if (left(stkList[i-2].produkt.strBauF, 1)*1 / stkList[i-1].anz*1 != 1)
						dy_LAW_LGx	= 25;
				}
				if (stkList[i-1].produkt.m_Ptypid == "ZMM" && stkList[i-1].produkt.m_Pemass * 1 != 0)
					aParams.push( [ "lPos" + i , "2X_MUTTER" ] );	// 2 Muttern
				else
					aParams.push( [ "lPos" + i , stkList[i-1].produkt.m_Ptyp ] );
				if (stkList[i].produkt.m_Ptypid == "ZTN")	// Gabel vor der Traverse darf nicht gedreht werden
					aParams.push( [ "lDreh" + i , 0 ] );
				else if (stkList[i-1].produkt.m_Ptypid == "ZTN")	// Traversendrehung durch "rotZ"
					aParams.push( [ "lDreh" + i , 0 ] );
				else
					aParams.push( [ "lDreh" + i , stkList[i-1].threeD[0].rotation ] );
			}
			else if (stkList[i-1].funktion == "SON" && i == 1){
				if (toupper(left(stkList[i-1].produkt.m_Ptyp, 3)) == "ZRM"){
					aParams.push( [ "lPos" + i , left(stkList[i-1].produkt.m_Ptyp, 13) ]);
					aParams.push( [ "lE" + i , stkList[i-1].produkt.RMLaenge ]);
				}
				else {
					aParams.push( [ "lE" + i , 120 ] );
					aParams.push( [ "lPos" + i , "SONDERTEIL" ] );
				}
			}
			if (i==1 && stkList[i-1].funktion != "LAG"){	// erstes Bauteil der LK nicht Lager
				if (left(stkList[i-1].produkt.m_Ptypid, 2) != "MB")	// MBS und MBW
					var strSQLStatement = "select * from SchwNaht where abs(LGV) = "+stkList[i-1].produkt.lgv+" and TYP = '"+stkList[i-1].produkt.m_Ptypid+"' ";
				else
					var strSQLStatement = "select * from SchwNaht where abs(LGG) = "+(stkList[i-1].produkt.m_strLGG)*1+" and TYP = '"+stkList[i-1].produkt.m_Ptypid+"' ";
				var numRet = dbselect("CASCADE", strSQLStatement, "SchwNaht");
				if (numRet > 0)
					lSN_oben = dbgetstring("SchwNaht", "SN");
			}
			if (stkList[i-1].produkt.m_Ptypid == "ZTN" && stkList[i].funktion == "LAG"){	// nach Traverse kommt das Lager (wenn vorhanden)
				lSN_unten	= stkList[i].produkt.oData.SN;
				aParams.push( [ "bLager", stkList[i].produkt.oData.A ] );	// fr diesen Fall auch die Fussbreite ausgeben
				}
			if (stkList[i-1].funktion != "SON" && stkList[i-1].produkt.m_Ptypid != "ZMM")
				lastPosNS	= i;
			
		}
		
		// Sonderfall LAW als Einzelteil
		if (stkList[0].produkt.m_Ptypid == "LAW")	// wenn nicht EINZEL ist LAW nie erstes Teil in StLi
			isEinzel_LAW	= 1;
		aParams.push( [ "isEinzel_LAW",	isEinzel_LAW ] );
		
		var lkTyp             = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung   = caMainController.dataAccess.getLastketteLastabtragung();
		
		if (lSN_unten == 0){
			if (left(stkList[lastPosNS-1].produkt.m_Ptypid, 2) != "MB"){	// nicht MBS und MBW
				if (left(lkTyp, 5) == "LAGER")
					var strSQLStatement = "select * from SchwNaht where LGV = 'LG' and TYP = '"+stkList[lastPosNS-1].produkt.m_Ptypid+"' ";
				else
					var strSQLStatement = "select * from SchwNaht where abs(LGV) = "+stkList[lastPosNS-1].produkt.lgv+" and TYP = '"+stkList[lastPosNS-1].produkt.m_Ptypid+"' ";
			}
			else
				var strSQLStatement = "select * from SchwNaht where abs(LGG) = "+(stkList[lastPosNS-1].produkt.m_strLGG)*1+" and TYP = '"+stkList[lastPosNS-1].produkt.m_Ptypid+"' ";
			var numRet = dbselect("CASCADE", strSQLStatement, "SchwNaht");
			if (numRet > 0)
				lSN_unten = dbgetstring("SchwNaht", "SN");
		}
		
		// Schweinhte (Montage)
				
		aParams.push( [ "lSN_oben", lSN_oben ] );
		aParams.push( [ "lSN_unten", lSN_unten ] );
		aParams.push( [ "rSN_oben", rSN_oben ] );
		aParams.push( [ "rSN_unten", rSN_unten ] );
		
		// Hhenlevel
		// einzelne Komponenten
		if ((lkTyp == "EINZEL_HAENGER") || (lkTyp == "EINZEL_SCHELLE") ||
            (lkTyp == "EINZEL_ZUBEHOER")  || (lkTyp == "EINZEL_LAGER") ||
			(left(lkTyp, 5) == "LAGER"))
        {
			var strLevelOBEN	= getstring("OBEN",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelMITTE	= getstring("MITTE",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelUNTEN	= getstring("UNTEN",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		// Gelenkstrebe, Stossbremse oder Gelenkfedersttze -> hngend
		else if (((lkTyp == "GELENKSTUETZE") || (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE")) && left(lkLastabtragung, 8) == "HAENGEND")
        {
			var strLevelOBEN	= getstring("BA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelUNTEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			aParams.push( [ "isSSBHaengend", 1 ] );
			// jetzt noch BA zurcksetzen - sonst wird die Strebe immer lnger
			if (typeof(NewStkList) != "undefined")
				setstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA);
		}
		// Gelenkstrebe oder Gelenkfedersttze -> sttzend
		else if ((lkTyp == "GELENKSTUETZE") || (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE"))
        {
			var strLevelOBEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelUNTEN	= getstring("BA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			aParams.push( [ "isSSBHaengend", 0 ] );
			// jetzt noch BA zurcksetzen - sonst wird die Strebe immer lnger
			if (typeof(NewStkList) != "undefined")
				setstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA);
		}
		// FS oder KS
		else if ((lkLastabtragung == "STUETZEND_EINFACH") || (lkLastabtragung == "STUETZEND_DOPPEL"))
        {
			var strLevelOBEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelUNTEN	= getstring("UBA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		// alle anderen
		else
        {
			var strLevelOBEN	= getstring("OBA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelMITTE	= getstring("HAENG",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelUNTEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		
		/*
		if (left(this.Haenger.m_Ptypid, 2) != 'FS' && left(this.Haenger.m_Ptypid, 2) != 'KS'){	// alles was nicht Sttzend ist
			if (getstring("OBEN", "DLGDATA.CA.FORMS.HOEHENLEVEL") != "")
				var strLevelOBEN	= getstring("OBEN",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			else if (getstring("OBA", "DLGDATA.CA.FORMS.HOEHENLEVEL") != "")
				var strLevelOBEN	= getstring("OBA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			else
				var strLevelOBEN	= getstring("BA",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			
			if (getstring("MITTE", "DLGDATA.CA.FORMS.HOEHENLEVEL") != "")
				var strLevelMITTE	= getstring("MITTE",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
			else
				var strLevelMITTE	= getstring("HAENG",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
			
			if (getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL") != "")
				var strLevelUNTEN	= getstring("UNTEN",	"DLGDATA.CA.FORMS.HOEHENLEVEL");
			else
				var strLevelUNTEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			// Achtung "OBEN" und "OBA" bzw. "UNTEN" und "RMT" knnen gleichzeitig vorhanden sein!!!
			// erst einzelner Hnger ausgelegt und dann zu LK gendert
			
		}
		else{
			var strLevelOBEN	= getstring("RMT",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			if (strLevelOBEN == "")
				strLevelOBEN	= getstring("OBEN",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
			var strLevelMITTE	= "";
			var strLevelUNTEN	= (getstring("UBA","DLGDATA.CA.FORMS.HOEHENLEVEL") == "" ? getstring("BA","DLGDATA.CA.FORMS.HOEHENLEVEL") : getstring("UBA","DLGDATA.CA.FORMS.HOEHENLEVEL"));
			if (strLevelUNTEN == "")
				strLevelUNTEN	= getstring("UNTEN",		"DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		*/
		
		aParams.push( [ "LGV",			"" + this.a_lgv ] );
		
		if ((this.oDlgLagerSession.AuswahlStandard.strSelRadioFunction == "GEFUEHRT_MEHRFACH" &&
				(right(this.oDlgLagerSession.AuswahlStandard.strSelComboFunction, 2) == "2W" ||
				right(this.oDlgLagerSession.AuswahlStandard.strSelComboFunction, 3) == "2W+" ||
				right(this.oDlgLagerSession.AuswahlStandard.strSelComboFunction, 2) == "4W"))
				||
				(this.oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR" &&
				this.oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn == "DOPPELT")){
				// Achtung: Bei FIN-Import kann hier etwas vorbelegt sein, was dann nicht so gewhlt wurde
				// z.B. wurde nur ein Klemmsystem gewhlt obwohl das FIN etwas 2W sagt
				// Hack
				if ((stkList.length == 1 && stkList[0].funktion == "KSY") || (stkList.length > 1 && stkList[0].funktion == "KSY" && stkList[1].funktion == "SON"))
					aParams.push( [ "is_2_4_W",	0 ] );
				else
					aParams.push( [ "is_2_4_W",	1 ] );
		}
		else
				aParams.push( [ "is_2_4_W",	0 ] );
		
		if (strLevelOBEN == "" && strLevelUNTEN == "" &&	// damit es weitergeht -> sollte eigentlich nicht vorkommen
				(left(this.Haenger.m_Ptypid, 2) != 'FS' && left(this.Haenger.m_Ptypid, 2) != 'KS') &&
				(lastPosNS > 0)){
			strLevelOBEN	= atoi(this.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.schief);
			strLevelUNTEN	= strLevelOBEN;
			for (var i = 0; i < stkList.length; i++){
			strLevelUNTEN	-= stkList[i].produkt.m_Pemass;
			}
		}
		
		aParams.push( [ "HLevel_ol",	strLevelOBEN ] );
		aParams.push( [ "HLevel_ml",	strLevelMITTE ] );
		aParams.push( [ "HLevel_ul",	strLevelUNTEN ] );
		
		var SonderdA	= 0;	// Kenner fr Sonderaussendurchmesser
		var dAReal		= 0;	// realer Aussendurchmesser
		if (this.Schelle){
			SonderdA	= this.Schelle.m_bSonderNennweite;
			dAReal		= this.Schelle.m_dSonderNennweite;
		}
		else if (this.Lager){
			SonderdA	= 0;
			if (this.Lager.m_bSonderNennweite == "true" ||  this.Lager.m_bSonderNennweite*1 == 1)
				SonderdA	= 1;
			dAReal		= (SonderdA ? this.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder : this.oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
		}
		else if (this.TopoLager2){
			if (this.TopoLager2.Lager.m_bSonderNennweite.length > 1)
				SonderdA	= (this.TopoLager2.Lager.m_bSonderNennweite == 'true' ? 1 : 0);
			else
				SonderdA	= this.TopoLager2.Lager.m_bSonderNennweite*1;
			dAReal		= this.TopoLager2.Lager.m_dSonderNennweite;
		}
		
		aParams.push( [ "isSonderdA", SonderdA ] );
		aParams.push( [ "dA", dAReal ] );
		
		if (this.bDoppelt)
			aParams.push( [ "Spannweite", "" + this.dataAccess.getSpannweite(1) ] );
		else aParams.push( [ "Spannweite", "" ] );
		
		if (this.Schelle.m_Ptypid == "VBK")
			aParams.push( [ "VBK_Groesse", this.Schelle.groesse ] );
		else
			aParams.push( [ "VBK_Groesse", "" ] );
		
		if (this.Lager)
		{
			aParams.push( [ "Btr", this.oDlgLagerSession.AuswahlStandard.dBeamWidth*1 ] );
			if (this.Gleitelement && this.Gleitelement.m_Ptypid == "LGE")
				aParams.push( [ "bLager", this.Gleitelement.oData.B*1 - 5 ] );
			else
				aParams.push( [ "bLager", this.Lager.oData.A*1 ] );
			aParams.push( [ "tG", this.oDlgLagerSession.AuswahlStandard.dBeamThickness*1 ] );
			if (dy_LAW_LGx > 0)
				aParams.push( [ "dy_LAW_LGx", dy_LAW_LGx ] );
		}
		else if (this.bZubehoer){
			aParams.push( [ "Btr", this.Zubehoer.m_strMassBTR*1 ] );
			aParams.push( [ "tG", this.Zubehoer.m_strMassTG*1 ] );
		}
		else
		{
			aParams.push( [ "Btr", this.SegmentStrang.ObererAnschluss.m_strMassBTR*1 ] );
			aParams.push( [ "tG", this.SegmentStrang.ObererAnschluss.m_strMassTG*1 ] );
		}
		
		if (toupper(left(this.SegmentStrang.Haenger.m_Ptypid, 1)) == "K"){
			aParams.push( [ "KH_Betr_o", this.SegmentStrang.Haenger.weg_res ] );
			aParams.push( [ "KH_Betr_u", this.SegmentStrang.Haenger.nennweg - this.SegmentStrang.Haenger.weg_res ] );
		}
		else if (toupper(left(this.Haenger.m_Ptypid, 1)) == "K"){
			aParams.push( [ "KH_Betr_o", this.Haenger.weg_res ] );
			aParams.push( [ "KH_Betr_u", this.Haenger.nennweg - this.Haenger.weg_res ] );
		}
		
		aParams.push( [ "sVOR", (this.Haenger.vorspann ? this.Haenger.vorspann : (this.Haenger.estern - (this.Haenger.m_Pemass - this.Haenger.AnpassungEmass))) ] );
		aParams.push( [ "lVerstellung", this.Haenger.AnpassungEmass ] );
		aParams.push( [ "lSSG_dL", "0" ] );									// TODO
		
		// Lager auf Traverse
		var AchsDirInfo	= this.dataAccess.getAchsKSInfo();
		aParams.push( [ "rotZ", atoi(right(AchsDirInfo[9],1)) == 2 ? 90 : 0 ] );
		
		return( aParams );
	}
};

