//#############################################################################
//
// Author:		H.M. Bauer / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################

#include "CascadeUtilityFunctions.es"

//*****************************************************************************
// TCA Importdatei Parser
//*****************************************************************************

class TCAimport
{
	var m_pfad = "";
	var m_drawingNumber = "";
	var m_attachmentName = "";
	var orientation = 0;
	var yDistance = "";
	var xDistance = "";
	var ewAxis2 = "";
	var ewAxis1 = "";
	var nsAxis2 = "";
	var nsAxis1 = "";
	var insulation = 0;
	var projectTemperature = 0;
	var designTemperature = 0;
	var outsideDiameter = 0.0;
	var nominalBore = 0;
	var hangerTyp = "";
	var schraegzug = 0;
	var movementZ = 0;
	var movementY = 0;
	var movementX = 0;
	var forcesX = 0;
	var forcesZ = 0.0;
	var flowDirection = 0;
	var SysLevel = 0;
	var alpha = 0.0;
	var Testload = 0.0;
	var CalcNumber = "";
	var name = "";
	var pipeName = "";
	var projectName = "";

	var fileBuffer = "";
	var keyBuffer = [];
	var fileLen = 0;
	var filePos = 0;
/*
	char	main;
	double	angle;
	char	plus;
	char	minus;
*/
	// Speichert den Index des vorigen Aufrufes, um ein Ende der Datei zu erkennen
	var indexObsolete = -1;

	var abb2degree = [
			{ m: 'N', angle: 90, plus: 'W', minus: 'E' },
			{ m: 'W', angle: 180, plus: 'S', minus: 'N' },
			{ m: 'S', angle: 270, plus: 'E', minus: 'W' },
			{ m: 'E', angle: 0, plus: 'N', minus: 'S' }
		];
	var anOrd = {
			HOR: 0,
			VERUP: 1,
			VERDOWN: 2
		};
	var keywordsStrings = [
			{ k: "Attachment Attributes", i: "EATTACHMENTATTRIBUTES" },
			{ k: "Attachment Name", i: "EATTACHMENTNAME" },
			{ k: "Drawing Number", i: "EDRAWINGNUMBER" },
			{ k: "Project Directory", i: "EPROJECTDIRECTORY" },
			{ k: "Project Name", i: "EPROJECTNAME" },
			{ k: "Pipe Name", i: "EPIPENAME" },
			{ k: "Name", i: "ENAME" },
			{ k: "Position", i: "EPOSITION" },
			{ k: "Flow Direction", i: "EFLOWDIRECTION" },
			{ k: "Alpha", i: "EALPHA" },
			{ k: "Forces (Fx,Fy,Fz)", i: "EFORCES" },
			{ k: "Testload (Fz)", i: "ETESTLOAD" },
			{ k: "Movement (x,y,z)", i: "EMOVEMENT" },
			{ k: "Hangertyp", i: "EHANGERTYP" },
			{ k: "Calculation Number", i: "ECALCNUMBER" },
			{ k: "Pipe Attributes", i: "EPIPEATTRIBUTES" },
			{ k: "Nominal Bore", i: "ENOMINALBORE" },
			{ k: "Outside Diameter", i: "EOUTSIDEDIAMETER" },
			{ k: "Design Temperature", i: "EDESIGNTEMPERATURE" },
			{ k: "Project Temperature", i: "EPROJECTTEMPERATURE" },
			{ k: "Insulation", i: "EINSULATION" },
			{ k: "Location Attributes", i: "ELOCATIONATTR" },
			{ k: "N-S Axis 1", i: "EEWAXIS1" },
			{ k: "N-S Axis 2", i: "EEWAXIS2" },
			{ k: "E-W Axis 1", i: "ENSAXIS1" },
			{ k: "E-W Axis 2", i: "ENSAXIS2" },
			{ k: "N Axis", i: "EEWAXIS1" },         // -mw- 2008-10-12: Anscheinend haben sich die Bezeichnungen der Achsen irgendwann mal gendert
			{ k: "S Axis", i: "EEWAXIS2" },
			{ k: "W Axis", i: "ENSAXIS1" },
			{ k: "E Axis", i: "ENSAXIS2" },
			{ k: "X-Distance", i: "EXDISTANCE" },
			{ k: "Y-Distance", i: "EYDISTANCE" },
			{ k: "X1-Distance", i: "EX1DISTANCE" },
			{ k: "X2-Distance", i: "EX2DISTANCE" },
			{ k: "Y1-Distance", i: "EY1DISTANCE" },
			{ k: "Y2-Distance", i: "EY2DISTANCE" },
			{ k: "X-Coordinate", i: "EXCOORDINATE" },
			{ k: "Y-Coordinate", i: "EYCOORDINATE" },
			{ k: "Elevation", i: "ESYSLEVEL" },
			{ k: "Level", i: "ESYSLEVEL" },
			{ k: "EOF", i: "EEOF" },
			{ k: "NOVALID", i: "ENOVALIDATTRIB" }
		];

	function isNewline( ch )
	{
		if (ch == '\r' || ch == '\n')
			return true;
		return false;
	}

	function isDigit( ch )
	{
		if ( (ch >= '0') && (ch <= '9') )
			return true;
		return false;
	}

	function isAlpha( ch )
	{
		if ( ((ch >= 'a') && (ch <= 'z')) || ((ch >= 'A') && (ch <= 'Z')) )
			return true;
		return false;
	}

	function isAlnum( ch )
	{
		if ( isAlpha( ch ) || isDigit( ch ) )
			return true;
		return false;
	}

	function firstAlpha(quelle, index, fileLen)
	{
		while((fileLen > index) && (this.isAlpha(mid(quelle, index, 1)) == false))
			index++;
		if(fileLen > index)
			return true;
		return false;
	}

	function getKeyTCA(quelle)
	{
		var index = 0;
		var len = strlen(quelle);
		if(len == 0)
			return "";
		while(this.isNewline(quelle[index]) == true)
			index++;

		quelle = mid(quelle, index+1, len);
		len = strlen(quelle);
		index = 1;
		while(index <= len && quelle[index] != ":")
			index++;
		if(index > len)
			index = len;
		return left(quelle, index);
	}

	function getValTCA(quelle)
	{
		var strKey = this.getKeyTCA(quelle);
		if(strKey == "")
			return "";

		var len = strlen(quelle);
		var index = strlen(strKey) + 1;
		while(index <= len && find(" \t", quelle[index]) != -1)
			index++;
		if(index > len)
			return "";
		return mid(quelle, index+1, strlen(quelle));
	}

	function getKeyKeyTCA(pos)
	{
		var strKey = this.keyBuffer[pos].w;
		this.keyBuffer[pos].k = "ENOVALIDATTRIB";

		var len = keywordsStrings.length;
		var index;
		for(index = 0; index < len; index++)
		{
			if(strKey == keywordsStrings[index].k)
			{
				this.keyBuffer[pos].k = keywordsStrings[index].i;
				break;
			}
		}
	}

	function getStringPos(nextContent, stelle)
	{
		var	countStelle = 1;							// zhlt die durchlaufenden Zahlen
		var	nextContentIx = 0;							// Laufindex durch den String nextContent
		var	nextContentLen=strlen(nextContent);			// Lnge des Strings

		while(nextContentIx < nextContentLen && countStelle < stelle)
		{
			nextContentIx++;
			if(nextContent[nextContentIx] == ' ')
				countStelle++;
		}
		nextContent = right(nextContent, nextContentLen - nextContentIx);
		return nextContent;
	}

	function skipWS(quelle, index, fileLen)
	{
		while(fileLen > index && find(" \t", mid(quelle, index, 1)) != -1)
			index++;
		if(fileLen > index)
			return 1;
		return 0;
	}

	function searchCR()
	{
		while(this.filePos <= this.fileLen && this.isNewline(this.fileBuffer[this.filePos]) == true)
			this.filePos++;
		while(this.filePos <= this.fileLen && this.isNewline(this.fileBuffer[this.filePos]) == false)
			this.filePos++;
		if(this.filePos > fileLen)
			this.filePos = this.fileLen;
	}

	function readImportFile(fileName)
	{
		var oldPos = 0;
		var s = "", ss = "", sss = "", aktKeyword = "";

		// einlesen
		this.fileBuffer = readfile(fileName);

		// in Zeilen aufspalten und Key/Value trennen (Trennzeichen ist :)
		this.filePos = 0;
		this.fileLen = strlen(this.fileBuffer);
		while(this.filePos < this.fileLen)
		{
			// CRLF berlesen
			while(this.isNewline(this.fileBuffer[this.filePos]) == true)
				oldPos++;

			this.searchCR();

			aktKeyword = mid(this.fileBuffer, oldPos+1, this.filePos - oldPos);
			this.keyBuffer[ this.keyBuffer.length ] = {
					k: "",
					w: this.getKeyTCA(aktKeyword),
					v: this.getValTCA(aktKeyword) };

			// CRLF berlesen
			this.filePos++;
			while(this.isNewline(this.fileBuffer[this.filePos]))
				this.filePos++;
			// Anfang nchste Zeile
			oldPos = this.filePos;
		}
		// aufrumen
		this.fileBuffer = "";
		this.filePos = 0;
		this.fileLen = 0;

		// Key aus Key
		for(oldPos = 0; oldPos < this.keyBuffer.length; oldPos++)
		{
			this.getKeyKeyTCA(oldPos);
		}
        return true;
	}

	function analyseImport()
	{
		var pos = 0;
		var keyword = "";
		var nextContent = "";					// Rckgabe des Wertes

		var len = this.keyBuffer.length;
		for(pos=0; pos <= len; pos++)
		{
			keyword = this.keyBuffer[pos].k;
			nextContent = this.keyBuffer[pos].v;
			switch(keyword)
			{
			case "EATTACHMENTATTRIBUTES":
				break;
			case "EATTACHMENTNAME":
				this.m_attachmentName=nextContent;
				break;
			case "EDRAWINGNUMBER":
				this.m_drawingNumber=nextContent;
				break;
			case "EPROJECTDIRECTORY":
				this.m_pfad = nextContent;
				break;
			case "EPROJECTNAME":
				this.projectName=nextContent;
				break;
			case "EPIPENAME":
				this.pipeName=nextContent;			// Dateiname des Projektes
				break;
			case "ENAME":
				this.name=nextContent;
				break;
			case "EPOSITION":
				break;
			case "EFLOWDIRECTION":
				this.flowDirection=this.abbZuGrad(nextContent);
				switch(this.flowDirection)
				{
				case -1:
					this.flowDirection=0;						// Fehlerfall: Winkel unleserlich
					this.orientation=this.anOrd.HOR;
					break;
				case -2:
					this.flowDirection=0;						// Steigleitung
					this.orientation=this.anOrd.VERUP;
					break;
				case -3:
					this.flowDirection=0;						// Fallleitung
					this.orientation=this.anOrd.VERDOWN;
					break;
				default:
					this.orientation=this.anOrd.HOR;	// Normalfall
				}
				break;
			case "EFORCES":
				this.forcesX=atoi(nextContent);
				nextContent = this.getStringPos(nextContent, 3);
				this.forcesZ=atod(nextContent);
				break;
			case "EMOVEMENT":
				this.movementX=atoi(nextContent);
				nextContent = this.getStringPos(nextContent, 2);
				this.movementY=atoi(nextContent);
				nextContent = this.getStringPos(nextContent, 2);
				this.movementZ=atoi(nextContent);
				break;
			case "EHANGERTYP":
				this.hangerTyp=nextContent;
				break;
			case "ENOMINALBORE":
				this.nominalBore=atoi(nextContent);
				break;
			case "EOUTSIDEDIAMETER":
				this.outsideDiameter=atod(nextContent);
				break;
			case "EDESIGNTEMPERATURE":
				this.designTemperature=atoi(nextContent);
				break;
			case "EPROJECTTEMPERATURE":
				this.projectTemperature=atoi(nextContent);
				break;
			case "EINSULATION":
				this.insulation=atoi(nextContent);
				break;
			case "ENSAXIS1":
				if (nextContent == "")
					this.nsAxis1=" ";
				else
					this.nsAxis1=nextContent;
				break;
			case "ENSAXIS2":
				if (nextContent == "")
					this.nsAxis2=" ";
				else
					this.nsAxis2=nextContent;
				break;
			case "EEWAXIS1":
				if (nextContent == "")
					this.ewAxis1=" ";
				else
					this.ewAxis1=nextContent;
				break;
			case "EEWAXIS2":
				if (nextContent == "")
					this.ewAxis2=" ";
				else
					this.ewAxis2=nextContent;
				break;
			case "EX1DISTANCE":
				this.xDistance=nextContent;
				break;
			case "EY1DISTANCE":
				this.yDistance=nextContent;
				break;
			case "EX2DISTANCE":		// ??? what to do?
				// this.xDistance=nextContent;
				break;
			case "EY2DISTANCE":		// ??? what to do?
				// this.yDistance=nextContent;
				break;
			case "EXCOORDINATE":		// ??? what to do?
				// this.xDistance=nextContent;
				break;
			case "EYCOORDINATE":		// ??? what to do?
				// this.yDistance=nextContent;
				break;
			case "ESYSLEVEL":
				// hier kommt Zeug wie ... -0.122070EX-03 an !!! runden auf ganze Millimeter !!
				this.SysLevel=atoi(nextContent);
				break;
			case "EALPHA":
				this.alpha=atod(nextContent);
				break;
			case "ETESTLOAD":
				this.Testload=atod(nextContent);
				break;
			case "ECALCNUMBER":
				this.CalcNumber=nextContent;
				break;
			case "EEOF":
				return TRUE;
				break;
			case "ENOVALIDATTRIB":
			default:
			default:
				break;
			}
		}
		return true;
	}

	function abbZuGrad(abbWinkel)
	{
		var abb2degreeIx = 0;		// Index in das Feld zur Winkelumrechnung
		var retAngel = 0.0;			// Rckgabe des Winkelwertes
		var back = "";				// Universeller Rckgabewert

		abbWinkel=toupper(abbWinkel);

		if(left(abbWinkel,1)=="U")	// UP = wir sind fertig
			return -2;

		if(left(abbWinkel,1)=="D")	// DOWN = wir sind fertig
			return -3;

		if(find("NWSE",left(abbWinkel,1))==-1) // Eines aus NWSE muss vorkommen!
			return -1;

		switch(left(abbWinkel,1))
		{
			case 'N':
				abb2degreeIx=0;
				retAngel=abb2degree[abb2degreeIx].angle;
				break;
			case 'W':
				abb2degreeIx=1;
				retAngel=abb2degree[abb2degreeIx].angle;
				break;
			case 'S':
				abb2degreeIx=2;
				retAngel=abb2degree[abb2degreeIx].angle;
				break;
			case 'E':
				abb2degreeIx=3;
				retAngel=abb2degree[abb2degreeIx].angle;
				break;
			default:
				return -1;
		}

		if(strlen(abbWinkel) > 2)
		{
			var plusMinus = 0;			// Angabe ob der auxAngel addiert oder subtrahiert wird
			var auxAngel = 0.0;			// Korrekturwert des letzten Winkels

			var correctAngel = abbWinkel.right(strlen(abbWinkel)-1);
			// greife den String nach der Angabe der Generalrichtung
			auxAngel = parseFloat(correctAngel);

			if(auxAngel<0 || auxAngel>45 || isNaN(auxAngel))
				return -1;

			if(auxAngel==0)
				auxAngel=45;

			if(right(correctAngel,1)==abb2degree[abb2degreeIx].plus)
			{
				retAngel+=auxAngel;
			}
			else if(right(correctAngel,1)==abb2degree[abb2degreeIx].minus)
			{
				retAngel-=auxAngel;
			}
			else
			{
				return -1;
			}
		}
		return retAngel;
	}

}

