//#############################################################################
//
// Author:		H.M. Bauer / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################

#include "CascadeUtilityFunctions.es"

//*****************************************************************************
// STK Importdatei Parser
//*****************************************************************************

// class STKimport
STKimport = function()
{
    this.info = "";
	
	this.STKDATA = { general: {},
					 project: {},
					 assembly: {},
					 loc_plan: {},
					 required: {},
					 pipe: {},
					 steel: {},
					 sec_steel: {},
					 // Ergnzung fr eFIN
					 restrain: {},
					 partslist: {},
					 caddata: {},
					 // Excelimport - Zusatzinfos
					 addinfo: {}
					};
    
	this.fileBuffer = "";
	this.keyBuffer = [];
	this.fileLen = 0;
	this.filePos = 0;
};

STKimport.prototype =
{
	isNewline : function( ch )
	{
		if (ch == '\r' || ch == '\n')
			return true;
		return false;
	},

	 isDigit : function( ch )
	{
		if ( (ch >= '0') && (ch <= '9') )
			return true;
		return false;
	},

	 isAlpha : function( ch )
	{
		if ( ((ch >= 'a') && (ch <= 'z')) || ((ch >= 'A') && (ch <= 'Z')) )
			return true;
		return false;
	},

	 isAlnum : function( ch )
	{
		if ( isAlpha( ch ) || isDigit( ch ) )
			return true;
		return false;
	},

	 isWhite : function( ch )
	{
		if ( (ch == ' ') || (ch == '\t') )
			return true;
		return false;
	},

	 firstAlpha : function(quelle, index, fileLen)
	{
		while(fileLen > index && (this.isAlpha(mid(quelle, index, 1)) == false))
			index++;
		if(fileLen > index)
			return true;
		return false;
	},

	 getKeyValSTK : function(quelle)
	{
        var oRet = {key : '',
                    val : '' };
		var index = 0;
		
		if (quelle.length == 0)
			return oRet;
            
		while ((! (this.isAlpha(quelle[index]) == true)) && (quelle.length > index))
			index++;

		quelle = right(quelle, quelle.length - index);

        index = 0;
		while ((this.isWhite(quelle[index]) == false) && (index < quelle.length))
        {
            oRet.key += quelle[index];
			index++;
		}

		while ((this.isWhite(quelle[index]) == true) && (index < quelle.length))
			index++;
        
        if (index < quelle.length)
            oRet.val = right(quelle, quelle.length - index);
        
		return oRet;
	},

	 getStringPos : function(nextContent, stelle)
	{
		var	countStelle = 1;							// zhlt die durchlaufenden Zahlen
		var	nextContentIx = 0;							// Laufindex durch den String nextContent
		var	nextContentLen=strlen(nextContent);			// Lnge des Strings

		while(nextContentIx < nextContentLen && countStelle < stelle)
		{
			nextContentIx++;
			if(nextContent[nextContentIx] == ' ')
				countStelle++;
		}
		nextContent = right(nextContent, nextContentLen - nextContentIx);
		return nextContent;
	},

	 searchCR : function()
	{
		while(this.filePos <= this.fileLen && this.isNewline(this.fileBuffer[this.filePos]) == true)
			this.filePos++;
		while(this.filePos <= this.fileLen && this.isNewline(this.fileBuffer[this.filePos]) == false)
			this.filePos++;
		if(this.filePos > fileLen)
			this.filePos = this.fileLen;
	},

	readImportFile : function(fileName, fileContent)
	{
		var oldPos = 0;
		var aktKeyword = "";

		// einlesen
		if (toupper(FileName.getExt(fileName)) != "L3D")
			this.fileBuffer = readfile(fileName);
		else
			this.fileBuffer = fileContent;

		// in Zeilen aufspalten und Key/Value trennen (Trennzeichen ist :)
		this.filePos = 0;
		this.fileLen = strlen(this.fileBuffer);
		while(this.filePos < this.fileLen)
		{
			// CRLF berlesen
			while(this.isNewline(this.fileBuffer[this.filePos]) == true)
				this.filePos++;

			this.searchCR();

			aktKeyword = mid(this.fileBuffer, oldPos+1, this.filePos - oldPos);
            var oRet = this.getKeyValSTK(aktKeyword);
            
			this.keyBuffer[ this.keyBuffer.length ] = {
					k: oRet.key,
					v: oRet.val 
			};
                        
			// CRLF berlesen
			this.filePos++;
			while(this.isNewline(this.fileBuffer[this.filePos]))
				this.filePos++;
			// Anfang nchste Zeile
			oldPos = this.filePos;
		}
		// aufrumen
		this.fileBuffer = "";
		this.filePos = 0;
		this.fileLen = 0;

        return true;
	},

	 analyseImport : function()
	{
		var pos = 0;
		var keyword = "";
		var nextContent = "";					// Rckgabe des Wertes
		var currentSection = 'general';
		var len = this.keyBuffer.length;
		var aSteeldata = [];
		var aPartsdata = [];					// eFIN
		var aCaddata = [];						// eFIN
		var aData = [];
		
		for(pos=0; pos <= len; pos++)
		{
			keyword = this.keyBuffer[pos].k;
			nextContent = this.keyBuffer[pos].v;

			if (keyword && (keyword != '')) {
				if (keyword == 'BEGIN')  {
					if (nextContent == 'GENERAL')
						currentSection = 'general';
					else if (nextContent == 'PROJECT-DATA')
						currentSection = 'project';
					else if (nextContent == 'ASSEMBLY-DATA')
						currentSection = 'assembly';
					else if (nextContent == 'LOC-PLAN')
						currentSection = 'loc_plan';
					else if ((nextContent == 'LOAD-DATA') || (nextContent == 'REQUIRED-DATA'))
						currentSection = 'required';
					else if (nextContent == 'PIPE-DATA')
						currentSection = 'pipe';
					else if (nextContent == 'STEEL-DATA')
						currentSection = 'steel';
					else if (nextContent == 'SECONDARY_STEEL-DATA')
						currentSection = 'sec_steel';
					// Ergnzung fr eFIN
					else if (nextContent == 'REST-DATA')
						currentSection = 'restrain';
					else if (nextContent == 'PARTS-LIST')
						currentSection = 'partslist';
					else if (nextContent == 'CAD-OBJECTS-LIST')
						currentSection = 'caddata';
					// im STK gibt es eine weitere Section --> ignorieren!!!
					else if (nextContent == 'CAD-DATA-LIST')
						currentSection = 'caddata_STK';
					// Excelimport - Zusatzinfos
					else if (nextContent == 'ADD_INFO-DATA')
						currentSection = 'addinfo';
				}
				else if (keyword != 'END') {
					keyword = replace(keyword, '-', '_');
					keyword = tolower(keyword);
					if (currentSection == 'sec_steel')  {
						if (keyword == 'steel_count') {
							for (var i = 0; i < (nextContent - 0); ++i) {
								aSteeldata.push({
												 steel_art   : '',
												 steel_klass : '',
												 steel_typ  : '',
												 steel_mass : ''
											    });
							}
						}
						else {
							/* Beispiel:
							 STEEL_ART   1 ; SCTN
							 STEEL_KLASS 1 ; BEAM
							 STEEL_TYP   1 ; /DIN-SPEC/HE200A
							 STEEL_MASS  1 ; 1694 ... hier knnen mit ; getrennt weitere Mae kommen
							*/
							//keyword = left(keyword, keyword.length - 1);
							nextContent = replace(nextContent, ' ', '');
							aData = nextContent.split(';');
							var indexSteelpart = aData[0]-1;
							aData.shift();  // die Index-Spalte (ganz links) entfernen
							if (keyword == 'steel_mass')
								aSteeldata[indexSteelpart][keyword] = aData;
							else
								aSteeldata[indexSteelpart][keyword] = (aData[0] == undefined) ? '' : aData[0];
						}
					}
					// Erweiterung fr eFIN
					else if(currentSection == 'partslist'){	// hier sind die Muttern enthalten
						if (keyword == 'count'){
							for (var i = 0; i < (nextContent - 0); ++i) {
								aPartsdata.push({
												 posnr : '',
												 anz : '',
												 typ : '',
												 matnr : ''
												})
							}
						}
						else{
							var intQuelle	= getstring("quelle", "DLGDATA.CA.FINDATA.FINOBJECT.project") * 1;
							if (intQuelle != 9){	// 9 = eFIN FreiePosition
								nextContent = replace(nextContent, ' ', '');
								aData = nextContent.split(';');
							}
							else {
								nextContent = replace(nextContent, ' ', '|@');
								aData = nextContent.split(';');
								for (var tmp = 0; tmp < aData.length; tmp++){
									aData[tmp]	= trimright(trimleft(aData[tmp], '|@'), '|@');
									aData[tmp]	= replace(aData[tmp], '|@', ' ');
								}
							}
							aPartsdata[aData[0]-1]['posnr']	= (aData[0] == undefined) ? '' : aData[0];
							aPartsdata[aData[0]-1]['anz']	= (aData[1] == undefined) ? '' : aData[1];
							aPartsdata[aData[0]-1]['typ']	= (aData[2] == undefined) ? '' : aData[2];
							if (aData.length > 4){	// wir lesen ein STK ein
								aPartsdata[aData[0]-1]['matnr']	= (aData[11] == undefined) ? '' : aData[11];
								if (aData[aData.length-1] == "SONDER")	// zur spteren Unterscheidung
									aPartsdata[aData[0]-1]['matnr']	+= " - " + aData[aData.length-1];
							}
							else	// wir lesen ein eFIN ein
								aPartsdata[aData[0]-1]['matnr']	= (aData[3] == undefined) ? '' : aData[3];
						}
					}
					else if(currentSection == 'caddata'){	// hier sind die Muttern nicht aufgefhrt
						if (keyword == 'count'){
							for (var i = 0; i < (nextContent - 0); ++i) {
								aCaddata.push({
												objnr : '',
												posstrang : '',
												hlevel : '',
												emass : ''
											})
							}
						}
						else if (aData.length > 4){		// wir lesen ein STK ein
							nextContent = replace(nextContent, ' ', '');
							aData = nextContent.split(';');
							aCaddata[aData[0]-1]['objnr']		= (aData[0] == undefined) ? '' : aData[0];
							aCaddata[aData[0]-1]['posstrang']	= (aData[2] == undefined) ? '' : aData[2];
							aCaddata[aData[0]-1]['hlevel']		= (aData[6] == undefined) ? '' : aData[6];
							aCaddata[aData[0]-1]['emass']		= (aData[7] == undefined) ? '' : aData[7];
						}
						else{	// wir lesen ein eFIN ein
							nextContent = replace(nextContent, ' ', '');
							aData = nextContent.split(';');
							aCaddata[aData[0]-1]['objnr']		= (aData[0] == undefined) ? '' : aData[0];
							aCaddata[aData[0]-1]['posstrang']	= (aData[1] == undefined) ? '' : aData[1];
							aCaddata[aData[0]-1]['hlevel']		= (aData[2] == undefined) ? '' : aData[2];
							aCaddata[aData[0]-1]['emass']		= (aData[3] == undefined) ? '' : aData[3];
						}
					}
					
					else {
						//logtraceln("getFinDataValue(finData, '"+currentSection+"', '"+keyword+"')");
						this.STKDATA[currentSection][keyword] = nextContent;
					}
				}
			}
			switch(toupper(keyword))
			{
			case "PART":
                // @@@ Bug in EasySkript: find benutzt neuerdings strstr, und
                // da wird der zweite String im ersten gesucht; frher wars umgekehrt!
                if ((find("Sonderteil", nextContent) != -1) ||
                    (find(nextContent, "Sonderteil") != -1))
                    this.info += "Achtung: Sonderteil(e)!<br>";
                if ((find("Stauff-Schelle", nextContent) != -1) ||
                    (find(nextContent, "Stauff-Schelle") != -1))
                    this.info += "Achtung: Stauff-Schelle!<br>";
				break;
			default:
				break;
			}
		}
        this.STKDATA.sec_steel['aSteeldata']	= aSteeldata;
		// Erweiterung eFIN
		this.STKDATA.partslist['aPartslist']	= aPartsdata;
		this.STKDATA.caddata['aCaddata']		= aCaddata;
		return true;
	}
}

