/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */

#include "CascadeUtilityFunctions.es"

 /**
 * Zubehoer
 */
Zubehoer = function() {

	Zubehoer.superclass.constructor.call(this);

	/**
     *
     * @var
     */
	this.ipb_von        = 0;
	this.ipb_bis        = 0;
	this.metergew       = 0.0;
	this.lgv            = "";
	this.m_strLGG       = "";
	this.zrm_nachbar    = "IDL_T_ZRM_ZOM_U";
	this.breite         = 0;
	this.nennweite      = 0;
	this.spannweite     = 0;
	this.m_dNennlast    = 0;
	this.m_bSonderSpannweite = 0;
	this.m_dSonderSpannweite = 0;

	this.m_nTraegerTyp       = "HEB";
	this.m_bSonderZubehoer   = 0;
    
    this.m_strSonderGewinde  = "";

	this.m_strMassBTR		 = "";
	this.m_strMassBTRMax	 = "";  // -mw- Neu 06/2008
	this.m_strMassTG		 = "";
    this.m_strMassHoehe      = "";
	this.m_strGroesseTraeger = "";

    // Fr Zwischenstcke, diese wurden frher als Sonderteile behandelt
	this.groesse = "";
	this.m_strGroesseHaenger = "";
    this.form = "";                 // dies auch fr ZKx
    this.subtyp = "";               // dies nur fr ZKx

};


EasyKat.extend(Zubehoer, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);       // Horizontalschelle

        // Einfache Variablen einlesen, je nach Typ
        this.ipb_von                = getdouble("ipb_von",strPath);
        this.ipb_bis                = getdouble("ipb_bis",strPath);
        this.metergew               = getdouble("metergew",strPath);
        this.breite                 = getdouble("breite",strPath);
        this.nennweite              = getdouble("nennweite",strPath);
        this.spannweite             = getdouble("spannweite",strPath);
        this.m_dNennlast            = getdouble("m_dNennlast",strPath);
        this.m_bSonderSpannweite    = getdouble("m_bSonderSpannweite",strPath);
        this.m_dSonderSpannweite    = getdouble("m_dSonderSpannweite",strPath);
        this.m_nTraegerTyp          = getdouble("m_nTraegerTyp",strPath);
        this.m_bSonderZubehoer      = getdouble("m_bSonderZubehoer",strPath);

        this.lgv            = getstring("lgv",strPath);
        this.m_strLGG       = getstring("m_strLGG",strPath);
        this.zrm_nachbar    = getstring("zrm_nachbar",strPath);

        this.m_strSonderGewinde = getstring("m_strSonderGewinde",strPath);

        this.m_strMassBTR		 = getstring("m_strMassBTR",strPath);
        this.m_strMassBTRMax     = getstring("m_strMassBTRMax",strPath);
        this.m_strMassTG		 = getstring("m_strMassTG",strPath);
        this.m_strMassHoehe      = getstring("m_strMassHoehe",strPath);
        this.m_strGroesseTraeger = getstring("m_strGroesseTraeger",strPath);

        this.m_strGroesseHaenger = getstring("m_strGroesseHaenger",strPath);
        this.groesse             = getstring("groesse",strPath);
        this.form                = getstring("form",strPath);
        this.subtyp              = getstring("subtyp",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Zubehoer");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen
        setdouble("ipb_von",                strPath, this.ipb_von);
        setdouble("ipb_bis",                strPath, this.ipb_bis);
        setdouble("metergew",               strPath, this.metergew);
        setdouble("breite",                 strPath, this.breite);
        setdouble("nennweite",              strPath, this.nennweite);
        setdouble("spannweite",             strPath, this.spannweite);
        setdouble("m_dNennlast",            strPath, this.m_dNennlast);
        setdouble("m_bSonderSpannweite",    strPath, this.m_bSonderSpannweite);
        setdouble("m_dSonderSpannweite",    strPath, this.m_dSonderSpannweite);
        setdouble("m_nTraegerTyp",          strPath, this.m_nTraegerTyp);
        setdouble("m_bSonderZubehoer",      strPath, this.m_bSonderZubehoer);

        setstring("lgv",                strPath, this.lgv);
        setstring("m_strLGG",           strPath, this.m_strLGG);
        setstring("zrm_nachbar",        strPath, this.zrm_nachbar);

        setstring("m_strSonderGewinde", strPath, this.m_strSonderGewinde);


        setstring("m_strMassBTR",       strPath, this.m_strMassBTR);
        setstring("m_strMassBTRMax",    strPath, this.m_strMassBTRMax);
        setstring("m_strMassTG",        strPath, this.m_strMassTG);
        setstring("m_strMassHoehe",     strPath, this.m_strMassHoehe);
        setstring("m_strGroesseTraeger",strPath, this.m_strGroesseTraeger);
        setstring("m_strGroesseHaenger",strPath, this.m_strGroesseHaenger);
        setstring("groesse",            strPath, this.groesse);
        setstring("form",               strPath, this.form);
        setstring("subtyp",             strPath, this.subtyp);
    },

    Init : function(/*string*/ nTypID, /* string */ plgv , /*string*/ cpartid)
    {
        var ret = -1;
        var strTableName = this.GetProduktTabelle(nTypID, 1);

        switch (nTypID)
        {	case "ZLN":
            case "ZLK":
            case "ZRM":
            case "ZLM":
                this.m_Pwerkstoff = "W_RST";
                break;
            case "ZHM":
                this.m_Pwerkstoff = "W_RST";
                break;
            case "ZMM":
                this.m_Pwerkstoff = "W_MUTTER8";
                break;
			case "ZGW":
                this.m_Pwerkstoff = "W_RST52";
				this.m_Pzusinfo = "3.1B";
                break;
        }
        if (nTypID == "ZGM" || nTypID == "ZOM" ||nTypID == "ZSM")
        {  if (parseInt(plgv) <= 48)
           {   this.m_Pwerkstoff = "W_C45";
           }
           else
           {   this.m_Pwerkstoff = "W_RST52";
           }
        }
        this.m_Pwerkalt = this.m_Pwerkstoff;
        if (nTypID != "ZMM" && nTypID != "ZGW")
            this.m_Pzusinfo = "2.2";

        // bestimme die Grunddaten f. alle Zubehoerteile auer Traverse,
        // Klemmlasche und Verbindungslasche (special cases).
        // bei Muttern, Kupplungshlsen und ZRM-gew.stangen gibt es kein E-Ma;
        // bei ZRM ist Gewicht in kg/m.
        var strSQLStatement = "select * from " + strTableName;    // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "ZUBEHOER");
        if (numRet <= 0)
            return ret;

        var lgvIst = "";
        var fnIst  = 0.0;
        while (dbiseof("ZUBEHOER") == 0)
        {
            lgvIst = dbgetstring("ZUBEHOER", "LGV");

            if ( parseInt(lgvIst) == parseInt(plgv))
                break;

            dbskip("ZUBEHOER");
        }
        if (dbiseof("ZUBEHOER") > 0)
            return ret;

        // jetzt knnen wir uns die Daten holen:
        this.m_Ptypid   = nTypID;
        this.m_Pcpartid = cpartid;
        this.lgv = plgv;
        this.m_Poberfl = this.getOberFlaechenSchutzDefault();
        if (nTypID == "ZMM")	// -mw- 02/2007: nderung des Defaults speziell fr Muttern
        {
            if (parseInt(plgv) <= 48)
                this.m_Poberfl = "OB_FEUER";
            else
                this.m_Poberfl = "OB_GALV";
        }

        if ( (nTypID != "ZMM") && (nTypID != "ZHM") && (nTypID != "ZRM") )
        {
            this.m_Pemass   	= dbgetdouble("ZUBEHOER", "E");
        }
		else if ( (nTypID == "ZMM") && ((cpartid == "IDL_C_ZMM_U") || (cpartid == "IDL_C_ZMM_O")) )
		{
			// Die Doppelmutter ist kein normales ZMM sondern hat eigenes E-Mass:
			var Mass_m 		= dbgetdouble("ZUBEHOER", "M");
			var EMass_ZSM   = 0;
			if (dbselect("CASCADE", "select * from ZSM where LGV = '"+plgv+"' ", "NEBENSELECT") > 0)
			{
				EMass_ZSM   = dbgetdouble("NEBENSELECT", "E");;
			}
			if (atoi(plgv) > 30)
				this.m_Pemass   = fround(1.8 * Mass_m + EMass_ZSM, 0);
			else
				this.m_Pemass   = fround(1.2 * Mass_m + EMass_ZSM, 0);
		}
		
        if (nTypID == "ZRM")
        {
            this.metergew    = dbgetdouble("ZUBEHOER", "gewicht");
            this.m_Pgewicht  = 0;
        }
        else
        {
            this.m_Pgewicht  = dbgetdouble("ZUBEHOER", "gewicht");
        }
        if (nTypID == "ZGM" || nTypID == "ZHM" || nTypID == "ZSM" || nTypID == "ZMM" ||
            nTypID == "ZLN" || nTypID == "ZLK" || nTypID == "ZPK" || nTypID == "ZLM" || 
			nTypID == "ZGW" || nTypID == "ZOM")
        {
            var stkMasse = [], stkMasseNamen = [];
            var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
            this.getAdditionalDataToStore(tmpPath);
            if (nTypID == "ZGM")
            {
                stkMasse      = ["LGV","E","A","B","F","L","b_","c","d_","D","h1","h2","h3","h4","gewicht"];
                stkMasseNamen = ["LGV","E","A","B","F","L","b", "c","d", "D","h1","h2","h3","h4","gewicht"];
            }
            else if (nTypID == "ZGW")
            {
                stkMasse      = ["LGV","E","B","B_","L","C","D_","M","N","S","SCH_V","SCH_A","gewicht"];
                stkMasseNamen = ["LGV","E","B","b","L","C","d","m","n","s","SCH_V","SCH_A","gewicht"];
            }
			else if (nTypID == "ZHM")
            {
                stkMasse      = ["LGV","A","H","d_","f","gewicht","a_","D","h_","b"];
                stkMasseNamen = ["LGV","A","H","d", "f","gewicht","a", "D","h", "b"];
            }
            else if (nTypID == "ZSM")
            {
				var strOben = "0";
				if (this.m_Pcpartid  == "IDL_C_ZSM_1")
					strOben = "1";
		        this.setMass(tmpPath, "oben",    strOben);

                stkMasse      = ["LGV","E","A","H","d","f","SW","gewicht","oben"];
                stkMasseNamen = ["LGV","E","A","H","d","f","SW","gewicht","oben"];
            }
            else if (nTypID == "ZLN")
            {
                stkMasse      = ["LGV","E","A","f","r","s","SCH_V","SCH_A","k","gewicht"];
                stkMasseNamen = ["LGV","E","A","f","r","s","SCH_V","SCH_A","k","gewicht"];
            }
            else if (nTypID == "ZLK")
            {
                stkMasse      = ["LGV","E","A","B","f","g","s","t","z","SCH_V","SCH_A","k","gewicht"];
                stkMasseNamen = ["LGV","E","A","B","f","g","s","t","z","SCH_V","SCH_A","k","gewicht"];
            }
            else if (nTypID == "ZPK")
            {
                stkMasse      = ["LGV","E","A","H","d_","s","D","SCH_V","SCH_A","gewicht"];
                stkMasseNamen = ["LGV","E","A","H","d", "s","D","SCH_V","SCH_A","gewicht"];
            }
            else if (nTypID == "ZLM")
            {
                stkMasse      = ["LGV", "E", "l", "r", "d", "gewicht" ];
                stkMasseNamen = ["LGV", "E", "l", "r", "d", "gewicht" ];
            }
            else if (nTypID == "ZMM")
            {
                stkMasse      = ["LGV", "d" ];
                stkMasseNamen = ["LGV", "d" ];
            }
			else if (nTypID == "ZOM")
			{
				stkMasse 	  = ["LGV","E","A","H","c","d","s","gewicht","b","d1","t"];
				stkMasseNamen = ["LGV","E","A","H","c","d","s","gewicht","b","d1","t"];
			}
			
            this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
        }

        this.makeTyp();
        return(1);
    },

    InitZKX : function(/*string*/ nTypID, /* string */ plgv , /*string*/ cpartid)
    {
        var response = {
            success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
            validate: {
                message: ''
            }
        };

        var strTableName = this.GetProduktTabelle(nTypID, 1);

        this.m_Pwerkstoff = "W_RST";
        this.m_Pwerkalt = this.m_Pwerkstoff;
        this.m_Pzusinfo = "2.2";
        this.m_Ptypid   = nTypID;
        this.m_Pcpartid = cpartid;
        this.lgv        = plgv;
        this.m_Poberfl  = this.getOberFlaechenSchutzDefault();

        // wir mssen erst anhand ZKN_MAS den Subtyp bestimmen und knnen dann anhand
        // ZKN_LGV und den anderen Tabellen die restlichen Daten bestimmen.
        // Fr die Erstinitialisierung brauchen wir aber NUR ZKN_MAS, hier stehen alle rel. Daten!
        // Bei ZKK gibt es derzeit noch keine Subtypen ...

        var TraegerObj = caMainController.dataAccess.getTraegerdaten();
        this.m_nTraegerTyp       = TraegerObj.traegertyp;
        this.m_strMassBTR		 = TraegerObj.traegerbreite;
        this.m_strMassTG		 = TraegerObj.flanschdicke;
        this.m_strMassHoehe      = TraegerObj.traegerhoehe;
        this.m_strGroesseTraeger = TraegerObj.traegergroesse;

        var strTableName = this.GetProduktTabelle(nTypID, 2);
        var strSQLStatement = "select * from " + strTableName + " where LGV='"+plgv+"' and abs(Bt1)<="+this.m_strMassBTR+" and abs(Bt2)>="+this.m_strMassBTR+" and abs(max_tG)>="+this.m_strMassTG+" ";
        if (this.m_Ptypid == "ZKN")
            strSQLStatement = strSQLStatement + " order by SUBTYP ";    // Subtypen aktuell nur bei ZKN

        var numRet = dbselect("CASCADE", strSQLStatement, "ZUBEHOER_ZK");
        if (numRet <= 0)
        {
            response.validate.message = translate( "IDP_KEINE_LASCHE_FUER_TRAEGER" );
            return response;
        }
        // Bei ZKK haben wir jetzt alles;
        // Bei ZKN mssen wir noch den richtigen SUBTYP finden ...

        var strSubtyp = "";
        if (this.m_Ptypid == "ZKN")
        {
            var delB = 0;
			while (dbiseof("ZUBEHOER_ZK") == 0)
            {
                strSubtyp = dbgetstring("ZUBEHOER_ZK", "SUBTYP");
                delB      = dbgetdouble("ZUBEHOER_ZK", "DelB");
                if (delB <= 0)
                    break;      // wir haben einen passenden
                else
                {
                    // prfen, ob die vorgegebene Trgerbreite glatt durch delB teilbar ist
                    var test = this.m_strMassBTR / delB;
                    if ( (test - floor(test)) < 0.01 )  // kleine Rundungsfehler tolerieren, wir haben hier mm als Einheit
                        break;
                }

                dbskip("ZUBEHOER_ZK");
            }
            if (dbiseof("ZUBEHOER_ZK"))
            {
                response.validate.message = translate( "IDP_KEINE_LASCHE_FUER_TRAEGER" );
                return response;
            }
        }

        // Soweit alles klar, Abschluss:
        this.m_Pemass   = dbgetdouble("ZUBEHOER_ZK", "E");
        this.m_Pgewicht = dbgetdouble("ZUBEHOER_ZK", "gewicht");
        this.form       = dbgetdouble("ZUBEHOER_ZK", "FORM");
        this.m_strMassBTRMax = dbgetdouble("ZUBEHOER_ZK", "BT2");
        this.subtyp     = strSubtyp;    // damit wir spter die richtigen Daten direkt finden
        // Trgermasse in Bemerk:
        this.m_Pzeichnr = this.m_nTraegerTyp + "/Htr:" + this.m_strMassHoehe + " Btr:" + this.m_strMassBTR + " Tg:" + this.m_strMassTG;

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        var nTrTyp = 0;
        if (this.m_nTraegerTyp == "INP")
            nTrTyp = 0;
        else if (this.m_nTraegerTyp == "IPE")
            nTrTyp = 1;
        else if (this.m_nTraegerTyp == "HEA")
            nTrTyp = 2;
        else if (this.m_nTraegerTyp == "HEB")
            nTrTyp = 3;
        else if (this.m_nTraegerTyp == "HEM")
            nTrTyp = 4;
        else if (this.m_nTraegerTyp == "HP")
            nTrTyp = 5;
        else if (this.m_nTraegerTyp == "M")
            nTrTyp = 6;
        else if (this.m_nTraegerTyp == "W")
            nTrTyp = 7;
        else
            nTrTyp = 9;
            
        this.setMass(tmpPath, "TrT", nTrTyp);
        
        if (this.m_Ptypid == "ZKN")
        {
			var strZKNtyp = this.subtyp;
			if (strZKNtyp == "ZKB")
			{
				stkMasse      = ["LGV", "Bt1", "TrT","TrH","Btr","Tg10"];
				stkMasseNamen = ["LGV", "Bt1", "TrT","TrH","Btr","Tg10"];
			}
			else
			{
				stkMasse      = ["LGV","m_","l1","s2","e2","f","SW","l2","b2","A","a_","M","h1","b","b3","h2","c","k","R","h3","h4","tx","LGV","Bt1","s1","E","g","TrT","TrH","Btr","Tg10"];
				stkMasseNamen = ["LGV","m", "l1","s2","e2","f","SW","l2","b2","A","a", "M","h1","b","b3","h2","c","k","R","h3","h4","tx","LGV","Bt1","s1","E","g","TrT","TrH","Btr","Tg10"];
			}
        }
        else	// Ab hier ZKK
        {
            stkMasse      = ["LGV","m_","l1","s2","e2","f","g","t","z","SW","l2","b2","A","a_","M","h1","b","b3","h2","c","k","R","h3","h4","tx","LGV","Bt1","s1","E","g","TrT","TrH","Btr","Tg10"];
            stkMasseNamen = ["LGV","m", "l1","s2","e2","f","g","t","z","SW","l2","b2","A","a", "M","h1","b","b3","h2","c","k","R","h3","h4","tx","LGV","Bt1","s1","E","g","TrT","TrH","Btr","Tg10"];
        }
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();
        return response;
    },

    InitZOM : function(/*string*/ nTypID, /*string*/ plgv, /*string*/ cpartid, /*int*/ ncMass)
    {
        var strTableName = this.GetProduktTabelle(nTypID, 1);

        if (parseInt(plgv) <= 48)
        {
            m_Pwerkstoff = "W_C45";
        }
        else
        {   m_Pwerkstoff = "W_RST52";
        }
        m_Pwerkalt = m_Pwerkstoff;
        m_Pzusinfo = "2.2";

        var strSQLStatement = "select * from " + strTableName    // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "ZUBEHOER")
        if (numRet <= 0)
            return -1;

        var lgvIst = "";
        while (dbiseof("ZUBEHOER") == 0)
        {
            lgvIst = dbgetstring("ZUBEHOER", "LGV");

            // Bedingung 1:
            if ((parseInt(lgvIst) == parseInt(plgv)) && (ncMass <= 0))
                break;

            // oder Bedingung 2:
            if ( (parseInt(lgvIst) >= parseInt(plgv)) && (ncMass > 0) &&
                 (dbgetdouble("ZUBEHOER", "c") >= ncMass) )
                break;

            dbskip("ZUBEHOER");
        }
        if (dbiseof("ZUBEHOER") > 0)
            return -1;

        // jetzt knnen wir uns die Daten holen:

        this.m_Ptypid   = nTypID;
        this.m_Pcpartid = cpartid;

        if ((ncMass > 0) && (parseInt(lgvIst) > parseInt(plgv)))
        {
            this.m_bSonderZubehoer  = 1;
            this.m_strSonderGewinde = plgv;
            this.lgv = lgvIst;
            /***
            // @@@@@@@ TODO: Meldung bringen: "IDP_SCHRAUBE_ZU_GROSS_FUER_OESE"
            CString strMessage = pDBStringTable->GetString( "IDP_SCHRAUBE_ZU_GROSS_FUER_OESE" );
            CTextTable::ConvertDBString(strMessage);
            AfxMessageBox(strMessage);
            *****/
            // Bemerkungsfeld belegen:
            // this.m_Pzeichnr = translate( "IDS_PROD_SON" );   --> den Text gibts nicht
        }
        else
        {
            this.lgv = plgv;
        }
        this.m_Poberfl = this.getOberFlaechenSchutzDefault();

        this.m_Pemass   = dbgetdouble("ZUBEHOER", "E");
        this.m_Pgewicht = dbgetdouble("ZUBEHOER", "gewicht");

        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse 	  = ["LGV","E","A","H","c","d","s","gewicht","b","d1","t"];
		stkMasseNamen = ["LGV","E","A","H","c","d","s","gewicht","b","d1","t"];
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();

        return(1);
    },


    InitMBS : function(/*string*/ nTypID, /*string*/ plgv, /*string*/ strLGG,
					  /*double*/ dSchelBetrLast, /*string*/ cpartid)
    {
        this.m_Pwerkstoff = "W_RST";
        this.m_Ptypid     = nTypID;
        this.m_Pcpartid   = cpartid;
        this.lgv          = plgv;
        this.m_strLGG	  = strLGG;
        this.m_Poberfl    = this.getOberFlaechenSchutzDefault();

        var strTableName = this.GetProduktTabelle(nTypID, 1);
        var strSQLStatement = "select * from " + strTableName    // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "ZUBEHOER")
        if (numRet <= 0)
            return 0;

        var nRet = 0;

        while (dbiseof("ZUBEHOER") == 0)
        {
            // FRAGE AN SCHMIDSBERGER: Wir legen MBS jetzt nicht mehr nach der
            // Temperatur-abgeminderten Last aus, sondern stur nach Hnger.
            // Drfen wir das?
            // if (ztable->GetDouble(ztable->GetFieldNr("fn")) >= dSchelBetrLast)

            if (strLGG == "")  // auslegung nur nach Last, Bestimmung der LGG (fr Einzelauswahl)
            {
                if (dbgetdouble("ZUBEHOER", "fn") >= dSchelBetrLast)
                {
                    this.m_Pemass    = RoundDoubleToInt(dbgetdouble("ZUBEHOER", "E"));
                    this.m_Pgewicht  = dbgetdouble("ZUBEHOER", "gewicht");
                    this.m_dNennlast = dbgetdouble("ZUBEHOER", "fn");
                    nRet = 1;
                    this.m_strLGG    = sprintf("%.3d",this.m_dNennlast);
                    break;
                }
            }
            else
            {
                if (compareInt(dbgetdouble("ZUBEHOER", "fn"), atoi(this.m_strLGG)))
                {
                    this.m_Pemass    = RoundDoubleToInt(dbgetdouble("ZUBEHOER", "E"));
                    this.m_Pgewicht  = dbgetdouble("ZUBEHOER", "gewicht");
                    this.m_dNennlast = dbgetdouble("ZUBEHOER", "fn");
                    nRet = 1;
                    break;
                }
            }
            dbskip("ZUBEHOER");
        }
        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse      = ["fn","E","A","B","L","b_","c","f","s","SCH_V","SCH_A","gewicht","LGRmin","LGRmax"];
		stkMasseNamen = ["fn","E","A","B","L","b", "c","f","s","SCH_V","SCH_A","gewicht","LGRmin","LGRmax"];
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();
        return nRet;
    },
	
	InitMBW : function(/*string*/ nTypID, /*string*/ plgv, /*string*/ strLGG,
					  /*double*/ dSchelBetrLast, /*string*/ cpartid)			// dSchelBetrLast -> verwendet fr isSchelle (true/false)
    {
        //this.m_Pwerkstoff = "W_RST";
		this.m_Pwerkstoff	= "W_RST52";
        this.m_Ptypid		= nTypID;
        this.m_Pcpartid		= cpartid;
        this.lgv			= plgv;
        this.m_strLGG		= strLGG;
        if (dSchelBetrLast)
			this.m_Poberfl	= "OB_ROH";
		else
			this.m_Poberfl	= this.getOberFlaechenSchutzDefault();

        var strTableName = this.GetProduktTabelle(nTypID, 1);
        var strSQLStatement = "select * from " + strTableName    // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "ZUBEHOER")
        if (numRet <= 0)
            return 0;

        var nRet = 0;

        while (dbiseof("ZUBEHOER") == 0)
        {
            // FRAGE AN SCHMIDSBERGER: Wir legen MBS jetzt nicht mehr nach der
            // Temperatur-abgeminderten Last aus, sondern stur nach Hnger.
            // Drfen wir das?
            // if (ztable->GetDouble(ztable->GetFieldNr("fn")) >= dSchelBetrLast)

            if (strLGG == "")  // auslegung nur nach Last, Bestimmung der LGG (fr Einzelauswahl)
            {
                if (dbgetdouble("ZUBEHOER", "fn") >= dSchelBetrLast)
                {
                    this.m_Pemass    = RoundDoubleToInt(dbgetdouble("ZUBEHOER", "E"));
                    this.m_Pgewicht  = dbgetdouble("ZUBEHOER", "gewicht");
                    this.m_dNennlast = dbgetdouble("ZUBEHOER", "fn");
                    nRet = 1;
                    this.m_strLGG    = sprintf("%.4d",this.m_dNennlast);
                    break;
                }
            }
            else
            {
                //if (compareInt(dbgetdouble("ZUBEHOER", "fn"), atoi(this.m_strLGG)))
				if (dbgetdouble("ZUBEHOER", "fn") >= atoi(this.m_strLGG))
                {
                    this.m_Pemass    = RoundDoubleToInt(dbgetdouble("ZUBEHOER", "E"));
                    this.m_Pgewicht  = dbgetdouble("ZUBEHOER", "m");
                    this.m_dNennlast = dbgetdouble("ZUBEHOER", "fn");
                    nRet = 1;
                    break;
                }
            }
            dbskip("ZUBEHOER");
        }
        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse		= ["FN","E","E1","A","A1","R","B","S","S1","S2","S3","S4","L","D","D1","M"];
		stkMasseNamen	= ["FN","E","E1","A","A1","R","B","S","S1","S2","S3","S4","L","D","D1","M"];
        
		this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();
        return nRet;
    },

    InitZRM : function(/*int*/ nachbar, /*Produkt **/ haenger)
    {
        var zrmlen = 0;

        var nHaengerTypid = ""; // die ersten drei Buchstaben
        if (haenger != null)
            nHaengerTypid = haenger.m_Ptypid;

        //----- Berechne die Mindestgewindestangenlnge:
        this.zrm_nachbar = nachbar;	// merken, um ggfalls Neuinitialisierung durchfhren zu knnen
                                // geht jedoch flten, wenn nderung der Systemmae durch Anwender!
        // Fall unten: ZGM/ZOM mit ZSM
        var feld = "minzomu";
        if (nHaengerTypid == "FHS" || nHaengerTypid == "KVS")
        {	if (nachbar == "IDL_T_ZRM_ZGM_U")	feld = "minzgmufhs";
            if (nachbar == "IDL_T_ZRM_ZOM_U")   feld = "minzomufhs";
        }
        else
        {	if (nachbar == "IDL_T_ZRM_ZGM_U")	feld = "minzgmu";
            if (nachbar == "IDL_T_ZRM_ZOM_U")   feld = "minzomu";
        }
        // Fall oben: ZGM/ZOM/ZPK mit FHG
        if (nachbar == "IDL_T_ZRM_ZGM_O")	    feld = "minzgmo";
        if (nachbar == "IDL_T_ZRM_ZOM_O")       feld = "minzomo";
        if (nachbar == "IDL_T_ZPK")	            feld = "minzpno";
        if (nachbar == "IDL_T_ZMM")	            feld = "minzrmzmm";
		
        // bei FHS (KVS nicht!) mu noch das E-Mass des Hngers aufaddiert werden
        // kann jedoch erst nach Hngerwahl erfolgen, deshalb mu bei aktiven Lasten
        // die Auswahl der verbindenden Teile nach der endgltigen Hngerwahl erfolgen
        // -mw- 20.9.95: Wir erhhenauch f. KVS die Mindestgewindestangenlnge

        var strSQLStatement = "select * from MIN_GEW "  // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "MIN_GEW")
        if (numRet <= 0)
        {
            return -1;
        }
        var lgvIst = "";
        while (dbiseof("MIN_GEW") == 0)
        {
            lgvIst = dbgetstring("MIN_GEW", "LGV");

            if (parseInt(lgvIst) == parseInt(lgv))
                break;

            dbskip("MIN_GEW");
        }
        if (dbiseof("MIN_GEW") > 0)
            return -1;

        // jetzt knnen wir uns die Daten holen:
        zrmlen = dbgetdouble("MIN_GEW", feld);
        if (nHaengerTypid == "FHS")
        {	// Einstellwert:
            zrmlen += haenger.m_Pemass*1;

            // ggfalls bewegt sich die Stange noch nach oben:
            if ( haenger.sollweg > 0)
                zrmlen += haenger.sollweg*1;
        }
        if (nHaengerTypid == "KVS")
        {
            // Maximalwert:
            zrmlen += haenger.estern*1;
        }

        this.AnpassZRM(zrmlen);

        return(1);
    },

    AnpassZRM : function(/*int*/ ema)
    {
        if (m_Ptypid != "ZRM") return;

        this.m_Pemass    = ema;
        this.m_Pgewicht  = fround((this.metergew * this.m_Pemass) / 1000, 2);

        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse = ["LGV", "d", "r", "gewicht" ];
        this.setMassString(stkMasse, tmpPath);    // this.m_strMasse wird belegt

        this.makeTyp();
    },

    InitZTN : function(/*char **/plgv, /* int */ nSpannweite)
    {
        var i, j, ret = -1;

        this.lgv = plgv;

        var nSpannweiteFuerSuche = nSpannweite;

        var strSQLStatement = "select * from ZTN_TYP order by abs(spann) ASC, abs(LGV) ASC "
        var numRet = dbselect("CASCADE", strSQLStatement, "ZTNTABLE")
        if (numRet <= 0)
            return -1;

        // Erst mal prfen, ob unsere Spannweite in einem zulssigen Intervall liegt
        var nSpannweiteMin = 0;
        var nSpannweiteMax = 32000;
        var bExactMatch = 0;

        var nIstSpannweite;
        while (dbiseof("ZTNTABLE") == 0)
        {
            nIstSpannweite = dbgetdouble("ZTNTABLE", "spann");
            if ((nIstSpannweite <= nSpannweite) && (nIstSpannweite > nSpannweiteMin))
                nSpannweiteMin = nIstSpannweite;
            if ((nIstSpannweite >= nSpannweite) && (nIstSpannweite < nSpannweiteMax))
                nSpannweiteMax = nIstSpannweite;
            if (nIstSpannweite == nSpannweite)
            {
                bExactMatch = 1;
                break;
            }
            dbskip("ZTNTABLE");
        }
        if (! bExactMatch)
        {
            // 10.11.2009: Auch Minimum soll geprft werden
            if (nSpannweiteMin == 0)
                return -2;
            nSpannweiteFuerSuche = nSpannweiteMax;	// wir suchen den kleinsten, der grer ist
            this.m_bSonderSpannweite  = 1;
            this.m_dSonderSpannweite  = nSpannweite;
        }
        else
        {
            this.m_bSonderSpannweite  = 0;
            this.m_dSonderSpannweite  = 0;
        }

        dbgotop("ZTNTABLE");
        while (dbiseof("ZTNTABLE") == 0)
        {
            if ((dbgetdouble("ZTNTABLE", "LGV") == parseInt(plgv)) &&
                (dbgetdouble("ZTNTABLE", "spann") == nSpannweiteFuerSuche))
            {	break;
            }
            dbskip("ZTNTABLE");
        }
        if (dbiseof("ZTNTABLE") > 0)
            return -1;

        this.spannweite = nSpannweiteFuerSuche;

        this.m_Ptypid     = "ZTN";
        this.m_Pcpartid   = "IDL_C_ZTN";
        this.m_Pgewicht   = dbgetdouble("ZTNTABLE", "gewicht");
        this.m_Pwerkstoff = "W_RST";
        this.m_Poberfl	  = this.getOberFlaechenSchutzDefault();
        this.m_Pwerkalt   = this.m_Pwerkstoff;

        this.makeTyp();

        strSQLStatement = "select * from ZTN_MAS "
        numRet = dbselect("CASCADE", strSQLStatement, "ZTNMASTABLE")
        if (numRet <= 0)
            return -1;

        while (dbiseof("ZTNMASTABLE") == 0)
        {
            if (dbgetdouble("ZTNMASTABLE", "LGV") == parseInt(plgv))
            {
                this.m_Pemass = dbgetdouble("ZTNMASTABLE", "E");
                break;
            }
            dbskip("ZTNMASTABLE");
        }
        if (dbiseof("ZTNMASTABLE") > 0)
            return -1;

        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        this.setMass(tmpPath, "sonderspannweite", this.m_dSonderSpannweite );
        stkMasse = ["LGV","E","f","s","z","C","U","sonderspannweite","spann","gewicht","LGV"];
        this.setMassString(stkMasse, tmpPath);    // this.m_strMasse wird belegt

        return 1;
    },
	
	InitZV : function(/*string*/ ptypid, /* string*/ plgv, /*int*/ pwerk, /*int*/ pnennw,
					 /*int*/ pema, /*double*/ pgewicht)
    {
        this.m_Ptypid   = ptypid;
        this.m_Pgewicht = pgewicht;
        this.m_Pwerkstoff = pwerk;
        this.m_Pemass   = pema;
        this.m_Pcpartid = "";
        this.nennweite  = pnennw;
        this.lgv        = plgv;
        this.breite = 0;
        this.m_Pwerkalt = this.m_Pwerkstoff;
        if (this.m_Pwerkstoff == "W_RST")  this.m_Pzusinfo = "2.2";
        if (this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")  this.m_Pzusinfo = "3.1B";

        this.m_Poberfl = this.getOberFlaechenSchutzDefault();

        var strSQLStatement = "select * from " + ptypid + "_MAS order by abs(LGV_BIS) ASC "
        var numRet = dbselect("CASCADE", strSQLStatement, "ZVNTABLE")
        if (numRet <= 0)
        {
            return -1;
        }
        var dn_ab, dn_bis, lgv_bis;
        while (dbiseof("ZVNTABLE") == 0)
        {
            dn_ab   = dbgetdouble("ZVNTABLE", "DN_AB");
            dn_bis  = dbgetdouble("ZVNTABLE", "DN_BIS");

            lgv_bis = dbgetdouble("ZVNTABLE", "LGV_BIS");

            if ((dn_ab <= parseInt(pnennw)) &&
                (dn_bis >= parseInt(pnennw)) &&
                (lgv_bis >= parseInt(plgv)))
            	break;

            dbskip("ZVNTABLE");
        }
        if (dbiseof("ZVNTABLE") > 0)
            return -1;

        // Zusatzmae: B, f, s1, z1	abholen (aus Cascade 3.4)
        this.breite = dbgetdouble("ZVNTABLE", "B");

        var stkMasse = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse 	  = ["dn_ab","dn_bis","lgv_bis","B","f","s2","z2","dn_ab","dn_bis","E","fn","werk","gewicht","J","g","s1","z1"];
		stkMasseNamen = ["dn-ab","dn-bis","lgv-bis","B","f","s2","z2","dn-ab","dn-bis","E","fn","werk","gewicht","J","g","s1","z1"];
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();

        return(1);
    },

    InitZZX : function(strTyp, nHaengergroesse, nVorgabeEmass, strXMass, Haenger, oZulaessigeAnpassung)
    {
        this.m_Ptypid = strTyp;

        var db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // ZZx
        var strSQLStatement1 = "select * from "+db1+"  "
        var numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
            return -1;

        var strSearchField = "LGR_FST";
        if (this.m_Ptypid == "ZZK")
            strSearchField = "LGR_KST";

        var EZ_BER = 0;     // Berechnetes Emass Zwischenstck
        
        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, strSearchField), nHaengergroesse ) )
            {
                if (strTyp == "ZZF")
                {
                    this.groesse = dbgetstring(db1, "LGR_ZZF");

                    if (nVorgabeEmass > (dbgetdouble(db1, "E2max") + oZulaessigeAnpassung.dEoben))
                    {
                        Haenger.AnpassungEmass = oZulaessigeAnpassung.dEoben;
                        this.form = 2;
                        EZ_BER = dbgetdouble(db1, "E2max");
                    }
                    else if (nVorgabeEmass > dbgetdouble(db1, "E2max"))
                    {
                        Haenger.AnpassungEmass = (nVorgabeEmass - dbgetdouble(db1, "E2max"));
                        this.form = 2;
                        EZ_BER = dbgetdouble(db1, "E2max");
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E2min"))
                    {
                        Haenger.AnpassungEmass = 0;
                        this.form = 2;
                        EZ_BER = nVorgabeEmass;
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E1min"))
                    {
                        Haenger.AnpassungEmass = 0;
                        this.form = 1;
                        EZ_BER = nVorgabeEmass;
                    }
                    else if (nVorgabeEmass > dbgetdouble(db1, "E0max"))
                    {
                        Haenger.AnpassungEmass = (nVorgabeEmass - dbgetdouble(db1, "E0max"));
                        this.form = 0;
                        EZ_BER = dbgetdouble(db1, "E0max");
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E0min"))
                    {
                        this.form = 0;
                        EZ_BER = floor(nVorgabeEmass / 10) * 10;    // Zwischenstck nur in 10er-mm-Schritten
                        Haenger.AnpassungEmass = (nVorgabeEmass - EZ_BER);  // Rest durch Anpassung Hnger
                    }
                    // Flle nVorgabeEmass < 10 mm und < 0 schon in aufrufender Funktion erledigt
                    
                    this.m_Pemass   = EZ_BER;
                    if (this.form == 0)
                        this.m_Pgewicht = dbgetdouble(db1, "Platt") * this.m_Pemass / (2 * dbgetdouble(db1, "s") ) ;
                    else
                        this.m_Pgewicht = dbgetdouble(db1, "Platt") + ( this.m_Pemass - 2 * dbgetdouble(db1, "s")) /
                                          ( dbgetdouble(db1, "E2max") - 2 * dbgetdouble(db1, "s") ) * dbgetdouble(db1, "Rohr2");
                    this.m_Pgewicht = fround(this.m_Pgewicht, 1);
                }
                else
                {
                    this.groesse = dbgetstring(db1, "LGR_ZZK");

                    if (nVorgabeEmass > (dbgetdouble(db1, "E2MAX") + oZulaessigeAnpassung.dEoben))
                    {
                        Haenger.AnpassungEmass = oZulaessigeAnpassung.dEoben;
                        this.form = 2;
                        EZ_BER = dbgetdouble(db1, "E2MAX");
                    }
                    else if (nVorgabeEmass > dbgetdouble(db1, "E2MAX"))
                    {
                        Haenger.AnpassungEmass = (nVorgabeEmass - dbgetdouble(db1, "E2max"));
                        this.form = 2;
                        EZ_BER = dbgetdouble(db1, "E2MAX");
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E2MIN"))
                    {
                        Haenger.AnpassungEmass = 0;
                        this.form = 2;
                        EZ_BER = nVorgabeEmass;
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E1min"))
                    {
                        Haenger.AnpassungEmass = 0;
                        this.form = 1;
                        EZ_BER = nVorgabeEmass;
                    }
                    else if (nVorgabeEmass > dbgetdouble(db1, "E0max"))
                    {
                        Haenger.AnpassungEmass = (nVorgabeEmass - dbgetdouble(db1, "E0max"));
                        this.form = 0;
                        EZ_BER = dbgetdouble(db1, "E0max");
                    }
                    else if (nVorgabeEmass >= dbgetdouble(db1, "E0min"))
                    {
                        this.form = 0;
                        EZ_BER = floor(nVorgabeEmass / 10) * 10;    // Zwischenstck nur in 10er-mm-Schritten
                        Haenger.AnpassungEmass = (nVorgabeEmass - EZ_BER);  // Rest durch Anpassung Hnger
                    }
                    // Flle nVorgabeEmass < 10 mm und < 0 schon in aufrufender Funktion erledigt

                    var dPlatt = dbgetdouble(db1, "Platt");
                    if (this.form == 0)
                        dPlatt = dbgetdouble(db1, "Platt0");
                    else if (this.form == 1)
                        dPlatt = dbgetdouble(db1, "Platt1");
                    this.m_Pemass   = EZ_BER;
                    this.m_Pgewicht = dPlatt + ( this.m_Pemass - 2 * dbgetdouble(db1, "s")) /
                                     ( dbgetdouble(db1, "E2max") - 2 * dbgetdouble(db1, "s") ) * dbgetdouble(db1, "Rohr");
                    this.m_Pgewicht = fround(this.m_Pgewicht, 1);
                }
                break;
            }
            dbskip(db1);
        }

        this.m_strGroesseHaenger = nHaengergroesse;
       	this.m_Poberfl      = "OB_FEUER";
        this.m_Pwerkstoff   = "W_RST";
        this.m_Pwerkalt     = this.m_Pwerkstoff;

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
		this.setMass(tmpPath, "X", strXMass);
		
		if (this.m_Ptypid == "ZZF")
        {
			stkMasse      = ["E","m","s","D","k","E","LGR_FST","LGR_ZZF","d_","t","p","E1min","E1max","E2min","E2max","Platt","Rohr2"];
			stkMasseNamen = ["E","m","s","D","k","E","LGR_FST","LGR_ZZF","d", "t","p","E1min","E1max","E2min","E2max","Platt","Rohr2"];
		}
		else if (this.m_Ptypid == "ZZK")
        {
			stkMasse      = ["E", "Lp", "n01", "n11", "n21", "n12", "s", "D", "E", "LGR_KST", "LGR_ZZK", "d_", "k", "t", "t1", "u", "E0min", "E0max", "E1min", "E1max", "E2min", "E2max", "Platt", "Rohr", "X"];
			stkMasseNamen = ["E", "L", "n01", "n11", "n21", "n12", "s", "D", "E", "LGR_KST", "LGR_ZZK", "d", "k", "t", "t1", "u", "E0min", "E0max", "E1min", "E1max", "E2min", "E2max", "Platt", "Rohr", "X"];
		}

        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();
    },
	
	InitSBV : function(FN, l_soll, TypID, bVerl_vorh)
	{
		this.m_Ptypid	= TypID;
		var SBVInfo		= this.SBVInfo(FN);
		var oRet		= {	bAuslegungErfolgreich	: false,
							bNeuerVersuch			: false,
							L_NeuerVersuch			: 0,
							strError				: "",
							SSB_L4					: 0,
							};
		
        if (!SBVInfo.bOK){		// das sollte nicht passieren
			oRet.strError	= "ERROR_FN";
			return (oRet);
		}
		
		if (!bVerl_vorh)
			l_soll	+= SBVInfo.SSB_L4;		// die Stobremse wird um dieses Ma krzer
		
		var SBV_TYP	= "";
		
		if (l_soll < SBVInfo.SBV_Lmin_S){
			oRet.strError		= "ERROR_MIN";
			oRet.bNeuerVersuch	= true;
			oRet.L_NeuerVersuch	= SBVInfo.SBV_Lmin_S;
			oRet.SSB_L4			= SBVInfo.SSB_L4;
			return (oRet);			// Versuch die ColdPosition zu verschieben und neue SBV auszulegen
		}
		else if (l_soll > SBVInfo.SBV_Lmax_W){
			oRet.strError		= "ERROR_MAX";
			oRet.bNeuerVersuch	= true;
			oRet.L_NeuerVersuch	= SBVInfo.SBV_Lmax_W;
			oRet.SSB_L4			= SBVInfo.SSB_L4;
			return (oRet);			// Versuch die ColdPosition zu verschieben und neue SBV auszulegen
		}
		// ab hier gibt es einen Treffer
		else if (l_soll <= SBVInfo.SBV_Lmax_S){
			this.m_Pgewicht	= fround(SBVInfo.SBV_Gew_S_Lmin + ((l_soll - SBVInfo.SBV_Lmin_S) / 100 * SBVInfo.SBV_Gew_S_100), 1);
			this.subtyp		= SBVInfo.SBV_V_S_plus + "_" + SBVInfo.SBV_V_S_minus;
			SBV_TYP						= "S";
		}
		else if (l_soll <= SBVInfo.SBV_Lmax_C){
			this.m_Pgewicht	= fround(SBVInfo.SBV_Gew_C_Lmin + ((l_soll - SBVInfo.SBV_Lmin_C) / 100 * SBVInfo.SBV_Gew_C_100), 1);
			this.subtyp		= SBVInfo.SBV_V_C_plus + "_" + SBVInfo.SBV_V_C_minus;
			SBV_TYP						= "C";
		}
		else if (l_soll <= SBVInfo.SBV_Lmax_W){
			this.m_Pgewicht	= fround(SBVInfo.SBV_Gew_W_Lmin + ((l_soll - SBVInfo.SBV_Lmin_W) / 100 * SBVInfo.SBV_Gew_W_100), 1);
			if (l_soll < 1000)
				this.subtyp		= SBVInfo.SBV_V_W_plus_999 + "_" + SBVInfo.SBV_V_W_minus_999;
			else
				this.subtyp		= SBVInfo.SBV_V_W_plus_1000 + "_" + SBVInfo.SBV_V_W_minus_1000;
			SBV_TYP						= "W";
		}
		
		oRet.bAuslegungErfolgreich	= true;
		oRet.SSB_L4					= SBVInfo.SSB_L4;
		this.m_dNennlast			= FN;
		this.m_Pemass				= l_soll;
		this.m_Psubtyp				= SBV_TYP;
		this.m_Poberfl				= this.getOberFlaechenSchutzDefault();
		this.makeTyp();
		
		var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
		
		stkMasse		= ["FN","L4","E_IST"];
		stkMasseNamen	= ["FN","L4","E"];
		
		this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
		
		return (oRet);
	},
	
	SBVInfo : function (FN)
	{
		var strSQLStatement1 = "select * from SBV where FN = " + FN + " ";
        var numRet1 = dbselect("CASCADE", strSQLStatement1, "SBV");
		
		var oRet	= {	SBV_Lmin_S			: 0 ,
						SBV_Lmax_S			: 0 ,
						SBV_Lmin_C			: 0 ,
						SBV_Lmax_C			: 0 ,
						SBV_Lmin_W			: 0 ,
						SBV_Lmax_W			: 0 ,
						SSB_L4				: 0 ,
						SBV_GEW_S_Lmin		: 0 ,
						SBV_GEW_S_100		: 0 ,
						SBV_GEW_C_Lmin		: 0 ,
						SBV_GEW_C_100		: 0 ,
						SBV_GEW_W_Lmin		: 0 ,
						SBV_GEW_W_100		: 0 ,
						SBV_V_S_minus		: 0 ,
						SBV_V_S_plus		: 0 ,
						SBV_V_C_minus		: 0 ,
						SBV_V_C_plus		: 0 ,
						SBV_V_W_minus_999	: 0 ,
						SBV_V_W_plus_999	: 0 ,
						SBV_V_W_minus_1000	: 0 ,
						SBV_V_W_plus_1000	: 0 ,
						bOK					: false
						};
		if (numRet1 > 0){
			oRet.SBV_Lmin_S			= dbgetdouble("SBV", "TYP_S_LMIN");
			oRet.SBV_Lmax_S			= dbgetdouble("SBV", "TYP_S_LMAX");
			oRet.SBV_Lmin_C			= dbgetdouble("SBV", "TYP_C_LMIN");
			oRet.SBV_Lmax_C			= dbgetdouble("SBV", "TYP_C_LMAX");
			oRet.SBV_Lmin_W			= dbgetdouble("SBV", "TYP_W_LMIN");
			oRet.SBV_Lmax_W			= dbgetdouble("SBV", "TYP_W_LMAX");
			oRet.SSB_L4				= dbgetdouble("SBV", "L4");
			oRet.SBV_Gew_S_Lmin		= dbgetdouble("SBV", "GEW_S_LMIN");
			oRet.SBV_Gew_S_100		= dbgetdouble("SBV", "GEW_S_100");
			oRet.SBV_Gew_C_Lmin		= dbgetdouble("SBV", "GEW_C_LMIN");
			oRet.SBV_Gew_C_100		= dbgetdouble("SBV", "GEW_C_100");
			oRet.SBV_Gew_W_Lmin		= dbgetdouble("SBV", "GEW_W_LMIN");
			oRet.SBV_Gew_W_100		= dbgetdouble("SBV", "GEW_W_100");
			oRet.SBV_V_S_minus		= dbgetdouble("SBV", "V_S_MINUS");
			oRet.SBV_V_S_plus		= dbgetdouble("SBV", "V_S_PLUS");
			oRet.SBV_V_C_minus		= dbgetdouble("SBV", "V_C_MINUS");
			oRet.SBV_V_C_plus		= dbgetdouble("SBV", "V_C_PLUS");
			oRet.SBV_V_W_minus_999	= dbgetdouble("SBV", "V_W_MINUS_999");
			oRet.SBV_V_W_plus_999	= dbgetdouble("SBV", "V_W_PLUS_999");
			oRet.SBV_V_W_minus_1000	= dbgetdouble("SBV", "V_W_MINUS_1000");
			oRet.SBV_V_W_plus_1000	= dbgetdouble("SBV", "V_W_PLUS_1000");
			oRet.bOK				= true;
		}
		
		return (oRet);
	},
	
    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert

        delete(storepath,"");

        // Unterschiedliche Flle aufteilen ...
        switch (this.m_Ptypid)
        {
            case 'MBS':
			case 'MBW':
			case 'SBV':
                return(this.getAdditionalDataToStoreDYN(storepath));
                break;
            case 'ZGM':
            case 'ZHM':
            case 'ZLK':
            case 'ZLN':
            case 'ZLM':
            case 'ZMM':
            case 'ZOM':
            case 'ZPK':
            case 'ZSM':
			case 'ZGW':
                return(this.getAdditionalDataToStoreZUB(storepath));
                break;
            case 'ZKN':
            case 'ZKK':
			case 'ZKB':
                return(this.getAdditionalDataToStoreZKX(storepath));
                break;
            case 'ZRM':
                return(this.getAdditionalDataToStoreZRM(storepath));
                break;
            case 'ZTN':
                return(this.getAdditionalDataToStoreZTN(storepath));
                break;
            case 'ZVN':
            case 'ZVV':
            case 'ZVS':
                return(this.getAdditionalDataToStoreZVX(storepath));
                break;
            case 'ZZF':
            case 'ZZK':
                return(this.getAdditionalDataToStoreZZX(storepath));
                break;
        }
    },

    getAdditionalDataToStoreDYN : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "fn"), this.m_dNennlast ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        if (this.m_Ptypid == "SBV")
			setstring("E_IST", storepath, this.m_Pemass);
		
		return 1;
    },

    getAdditionalDataToStoreZUB : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "LGV"), this.lgv ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreZKX : function(storepath)
    {
        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // ZKN_LGV:  LGV
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // ZKN_MAS:  LGV + Breite Trger

        strSQLStatement1 = "select * from "+db1+" where LGV='"+this.lgv+"'  ";
        // strSQLStatement2 = "select * from "+db2+" order by abs(LGV) ASC, abs(Bt1) ASC "
        strSQLStatement2 = "select * from "+db2+" where LGV='"+this.lgv+"' and abs(Bt1)<="+this.m_strMassBTR+" and abs(Bt2)>="+this.m_strMassBTR+" ";
        if (this.m_Ptypid == "ZKN" || this.m_Ptypid == "ZKB")
        {
            strSQLStatement1 = strSQLStatement1 + " and SUBTYP='"+this.subtyp+"' ";    // Subtypen aktuell nur bei ZKN
            strSQLStatement2 = strSQLStatement2 + " and SUBTYP='"+this.subtyp+"' ";    // Subtypen aktuell nur bei ZKN
        }
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1);
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2);

        // ZKX_DISTANZ  --> sG -> P1 / P2
        // ZKX_SCHRAUBE --> sG + Gewinde M -> LSCHR

        if ((numRet1 <= 0) || (numRet2 <= 0))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }

        dbcopy(db1, storepath);
        dbcopy(db2, storepath);

		// 17.07.08 mb Wert M aus DB statt this.lgv
		var strM = getstring("M", storepath);

        var strSQLStatement = "select * from ZKX_DISTANZ where abs(bis_sG)>="+this.m_strMassTG+" and M_TEIL='"+strM+"' order by abs(bis_sG) ASC ";
        var numRet = dbselect("CASCADE", strSQLStatement, "ZKX_DISTANZ");
        if (numRet > 0)
            dbcopy("ZKX_DISTANZ", storepath);

        var strSQLStatement = "select * from ZKX_SCHRAUBE where abs(bis_sG)>="+this.m_strMassTG+" and M_TEIL='"+strM+"'  order by abs(bis_sG) ASC ";
        var numRet = dbselect("CASCADE", strSQLStatement, "ZKX_SCHRAUBE");
        if (numRet > 0)
            dbcopy("ZKX_SCHRAUBE", storepath);

        // Weitere Masse dazuschreiben:
        setstring("TrT", storepath, this.m_nTraegerTyp);
        setstring("TrH", storepath, this.m_strMassHoehe);
        setstring("Btr", storepath, this.m_strMassBTR);
        setstring("Tg10", storepath, this.m_strMassTG);

        /* muss entfallen, da sonst zu viele Params:
        if (TrageGroe == 0) strTraegGroe = "0";
        else strTraegGroe = itoa(TraegGroe);
        */

        return 1;
    },

    getAdditionalDataToStoreZRM : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        var LaengenKey = "1000";
        if (this.m_Pemass > 2000)
            LaengenKey = "3000";
        else if (this.m_Pemass > 1000)
            LaengenKey = "2000";

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+" where L_bis='"+LaengenKey+"' "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "LGV"), this.lgv ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreZTN : function(storepath)
    {
        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // ZTN_TYP:  Spannweite (spann), LGV
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // ZTN_MAS:  LGV

        strSQLStatement1 = "select * from "+db1+"  "
        strSQLStatement2 = "select * from "+db2+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2)

        if ((numRet1 <= 0) || (numRet2 <= 0))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "spann"), this.spannweite ) &&
                 compareInt(dbgetdouble(db1, "LGV"),   this.lgv ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        while (dbiseof(db2) == 0)
        {
            if ( compareInt(dbgetdouble(db2, "LGV"),   this.lgv ) )
            {
                dbcopy(db2, storepath);
                break;
            }
            dbskip(db2);
        }

        if (dbiseof(db1) || dbiseof(db2))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreZVX : function(storepath)
    {
        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // ZVX:      E, (DN_AB, DN_BIS)
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // ZVX-MAS:  B, LGV_BIS   ---> DN_AB, DN_BIS

        strSQLStatement1 = "select * from "+db1+"  "
        strSQLStatement2 = "select * from "+db2+" order by abs(LGV_BIS) ASC "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2)

        if ((numRet1 <= 0) || (numRet2 <= 0))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
			if ( compareInt(dbgetdouble(db1, "E"), this.m_Pemass ) &&
                 (dbgetdouble(db1, "DN_AB") <= this.nennweite)     &&
                 (dbgetdouble(db1, "DN_BIS") >= this.nennweite)		&&
				 ((this.m_Pwerkstoff == WerkstoffeZahlZuId[dbgetdouble(db1, "WERK")]) ||
				 (Werkstoffe[this.m_Pwerkstoff]*1 == 10 || Werkstoffe[this.m_Pwerkstoff]*1 > 37)))	// alles ab 10CrMo9-10
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        while (dbiseof(db2) == 0)
        {
            if ( (dbgetdouble(db2, "LGV_BIS") >= atoi(this.lgv)) &&
                 (dbgetdouble(db2, "DN_AB")   <= this.nennweite) &&
                 (dbgetdouble(db2, "DN_BIS")  >= this.nennweite) )
            {
                dbcopy(db2, storepath);
                break;
            }
            dbskip(db2);
        }

        if (dbiseof(db1) || dbiseof(db2))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreZZX : function(storepath)
    {
        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // ZZx
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // ZZx_P

        strSQLStatement1 = "select * from "+db1+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        // Groesse in DB ohne fhrende Null:
        var groesseFuerSuche = parseInt(this.groesse);
        strSQLStatement2 = "select * from "+db2+" where abs(groesse)="+groesseFuerSuche+" and abs(l_bis) >="+this.m_Pemass+" order by l_bis ASC "
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2)

        if ((numRet1 <= 0) || (numRet2 <= 0))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }

        var strSearchField = "LGR_FST";
        if (this.m_Ptypid == "ZZK")
            strSearchField = "LGR_KST";

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, strSearchField), this.m_strGroesseHaenger ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        // Das Emass "vorne dran hngen":
        setstring("E", storepath, this.m_Pemass);

        // In der zweiten DB stehen wir aufgrund des Selects schon auf dem richtigen Satz
        // Scheitern des Selects wird bereits oben abgefangen.
        dbcopy(db2, storepath);

        if (dbiseof(db1))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

	makeTyp : function()
	{
        var buf = "";

        var strTyp  =  this.m_Ptypid;
        if (this.m_bSonderZubehoer || this.m_bSonderSpannweite)
            strTyp += "-S";

        var dTG = 0;

        switch (this.m_Ptypid)
        {	case "ZLN":
            case "ZLK":
            case "ZPK":
            case "ZGM":
            case "ZSM":
            case "ZHM":
            case "ZMM":
            case "ZLM":
			case "ZGW":
                buf = sprintf("%s %s-%d", strTyp, this.lgv, Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "ZOM":
                if (this.m_bSonderZubehoer)
                    buf = sprintf("%s %s/%s-%d", strTyp, this.lgv, this.m_strSonderGewinde, Oberflaechenschutz[this.m_Poberfl]);
                else
                    buf = sprintf("%s %s-%d", strTyp, this.lgv, Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "ZKN":
                // dTG = 10 * inputStringToDouble(this.m_strMassTG);
                dTG = ceil(inputStringToDouble(this.m_strMassTG));
                if (dTG < 10)
                    dTG = "0" + dTG;
                var strZKNtyp = this.subtyp;
                strZKNtyp = replace(strZKNtyp, "_", " ");

                if (strZKNtyp.length > 3)   // Fall "ZKN 1" oder "ZKN 2"  ZKN 1.12.200....
                {
                    if ((this.m_strMassBTRMax > 0) && (strZKNtyp == "ZKN 1"))
                        buf = sprintf("%s.%s.%s-%d", strZKNtyp, this.lgv, this.m_strMassBTRMax, Oberflaechenschutz[this.m_Poberfl]);
                    else
                        buf = sprintf("%s.%s.%s.%.2d-%d", strZKNtyp, this.lgv, this.m_strMassBTR, dTG, Oberflaechenschutz[this.m_Poberfl]);
                }
                else
                {
                    if (this.m_strMassBTRMax > 0)
                        buf = sprintf("%s %s.%s-%d", strZKNtyp, this.lgv, this.m_strMassBTRMax, Oberflaechenschutz[this.m_Poberfl]);
                    else
                        buf = sprintf("%s %s.%s.%.2d-%d", strZKNtyp, this.lgv, this.m_strMassBTR, dTG, Oberflaechenschutz[this.m_Poberfl]);
                }
                break;
            case "ZKB":	// nur aus eFIN verwendet sonst luft "ZKB" als "ZKN" mit Subtyp "ZKB"
				buf = sprintf("%s %s.%s-%d", this.subtyp, this.lgv, this.m_strMassBTR, Oberflaechenschutz[this.m_Poberfl]);
				break;
			case "ZKK":
                // dTG = 10 * inputStringToDouble(this.m_strMassTG);
                dTG = ceil(inputStringToDouble(this.m_strMassTG));
                if (dTG < 10)
                    dTG = "0" + dTG;
                buf = sprintf("%s %s.%s.%.2d-%d", strTyp, this.lgv, this.m_strMassBTR, dTG, Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "ZRM":
                {
                    var nGewindestangenPassMin  = caMainController.presets.m_nGewindestangenPassMin;  // pMyDoc->m_Voreinstellungen.m_CascadeAuslegungsVorgaben.m_nGewindestangenPassMin;
                    var nGewindestangenPassRund = caMainController.presets.m_nGewindestangenPassRund; // pMyDoc->m_Voreinstellungen.m_CascadeAuslegungsVorgaben.m_nGewindestangenPassRund;
                    var nEmassFuerTyp;
                    if (parseInt(this.lgv) > 48)
                        nEmassFuerTyp = this.m_Pemass;
                    else if (nGewindestangenPassRund <= 0)
                        nEmassFuerTyp = (this.m_Pemass + nGewindestangenPassMin);
                    else
                        nEmassFuerTyp = (this.m_Pemass + nGewindestangenPassMin) + (nGewindestangenPassRund - ((this.m_Pemass + nGewindestangenPassMin) % nGewindestangenPassRund));
                    buf = sprintf("%s %s.%.4d-%d", strTyp, this.lgv, nEmassFuerTyp, Oberflaechenschutz[this.m_Poberfl]);
                }
                break;
            case "ZTN":
                {
                    var nSpannweiteFuerTyp = this.spannweite;
                    if (this.m_bSonderSpannweite)
                        nSpannweiteFuerTyp = this.m_dSonderSpannweite;
                    buf = sprintf("%s %s.%.4d-%s.%d", strTyp, this.lgv, nSpannweiteFuerTyp, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
                }
                break;
            case "ZVN":
            case "ZVV":
            case "ZVS":
                buf = sprintf("%s %.3d.%.3d.%s-%s.%d", strTyp, this.breite, this.m_Pemass, this.lgv, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "MBS":
                buf = sprintf("%s %.3d-%d", strTyp, this.m_dNennlast, Oberflaechenschutz[this.m_Poberfl]);
                break;
			case "MBW":
                //buf = sprintf("%s %.4d-%d", strTyp, this.m_dNennlast, Oberflaechenschutz[this.m_Poberfl]);
				buf = sprintf("%s %.4d-%d", strTyp, this.m_strLGG, Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "ZZF":
                //buf = sprintf("%s %s.%.4d.%d-37.2", strTyp, this.groesse, this.m_Pemass, this.form);
				buf = sprintf("%s %s.%.4d.%d-37.%d", strTyp, this.groesse, this.m_Pemass, this.form, Oberflaechenschutz[this.m_Poberfl]);
                break;
            case "ZZK":
                //buf = sprintf("%s %s.%.4d.%d-37.2", strTyp, this.groesse, this.m_Pemass, this.form);
				buf = sprintf("%s %s.%.4d.%d-37.%d", strTyp, this.groesse, this.m_Pemass, this.form, Oberflaechenschutz[this.m_Poberfl]);
                break;
			//case "ZLV":
				//buf = sprintf("%s %.2d.%.3d-%.2d.%d", this.m_Ptypid, this.lgv, this.m_Pemass, Werkstoff[this.m_Pwekstoff], Oberflaechenschutz[this.m_Poberfl]);
            case "SBV":
				buf	= sprintf("%s %.4d.%.4d.%s", strTyp, this.m_dNennlast, this.m_Pemass, this.m_Psubtyp);
				break;
			default:
                buf = "";
        }

        this.m_Ptyp = buf;

        if (m_Ptypid == "ZGM" || m_Ptypid == "ZSM" || m_Ptypid == "ZOM" || m_Ptypid == "ZHM" || m_Ptypid == "ZMM" ||
            m_Ptypid == "ZLM" || m_Ptypid == "ZRM")
        {
            // if (this.m_Pgewinde == "GEWINDE_ZOLL")
            //    this.m_Ptyp.SetAt(2,'I');           // @@@ TODO: setAt in BasicFunctions ... bei Inch-Zubehr die Typbezeichnung auf I umsetzen
        }
        this.getPreis();
        return(this.m_Ptyp);
	},

	/**
		nPosition: Optional Parameter which indicates whether the part is being used in the top or bottom part of the assembly
	*/
	fromTyp : function(strTyp, nPosition)
	{
		var strTypNr = [];
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.m_bSonderZubehoer = false;
		this.m_bSonderSpannweite = false;
		// NEU: bei eFIN werden Sonderteile zugelassen
		/*
		if(substr(strTyp, 4, 5) == "-S")
		{
			this.m_bSonderZubehoer = true;
			this.m_bSonderSpannweite = true;
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			return "Keine Sonderteile moeglich !";
		}
		*/
		
		// Prfen ob es sich um ein Sonderteil handelt
		// mglich sind ZTN-S -> Sonderspannweite
		// ZOM-S -> groe se mit kleinem Gewinde -> TODO
		var bSonder	= false;
		if (find(strTyp, "-S") > 0)
			bSonder	= true;
		
		// -mw- 11.5.2015: New, we have to determine the logicid in order to get the topo picture for Loading eFin-Files
		// @@@ Hier muss mglichrweise noch ergnzt werden !
        switch (this.m_Ptypid)
        {	case "ZLN":
			case "ZLV":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_ZLN_O_1';
				else
					this.m_Pcpartid = 'IDL_C_ZLN_U';
				break;
			case "ZLK":
				this.m_Pcpartid = 'IDL_C_ZLK_1';
				break;
			case "ZGM":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_ZGM_O';
				else
					this.m_Pcpartid = 'IDL_C_ZGM_U';
				break;
			case "ZOM":
				if (nPosition == 0)
					this.m_Pcpartid = 'IDL_C_ZOM_O';
				else
					this.m_Pcpartid = 'IDL_C_ZOM_U';
				break;
			case "ZKN":
			case "ZKB":
				this.m_Pcpartid = 'IDL_C_ZKN';
				break;
			case "ZKK":
				this.m_Pcpartid = 'IDL_C_ZKK';
				break;
			case "ZPK":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_ZPK_O';
				else
					this.m_Pcpartid = 'IDL_C_ZPK_U';
				break;
			case "ZSM":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_ZSM_U_1';
				else
					this.m_Pcpartid = 'IDL_C_ZSM_1';
				break;
			case "MBS":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_MBS_O';
				else
					this.m_Pcpartid = 'IDL_C_MBS_U';
				break;
			case "MBW":
				if (nPosition == 0) 
					this.m_Pcpartid = 'IDL_C_MBW_O';
				else
					this.m_Pcpartid = 'IDL_C_MBW_U';
				break;
		}

        switch (this.m_Ptypid)
        {	case "ZLN":
            case "ZLK":
            case "ZPK":
            case "ZGM":
            case "ZSM":
            case "ZHM":
            case "ZMM":
            case "ZLM":
			case "ZGW":
				strTypNr = splitVarDelimiter(strTyp, " -");
				if (strTypNr.length == 2){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					// Achtung das sind unterschiedliche Felder
					if (left(this.m_Ptypid, 2) == "ZL" || this.m_Ptypid == "ZPK" || this.m_Ptypid == "ZGW")
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_LASCHEN", "PROJECT.SETTINGS.CASCADE")]);
					else
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_VERBTEILE", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "-" + strTypNr[2];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 3 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv = getVarDelimited(strTypNr, 1);
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)];
				// jetzt noch den Werkstoff
				if (this.m_Ptypid	!= "ZPK"){		// bleibt leer
					this.m_Pwerkstoff	= "W_RST";	// ZLN, ZLK, ZHM, ZLM
					if (this.m_Ptypid == "ZGW")
						this.m_Pwerkstoff	= "W_RST52";	// ZGW
					else if (this.m_Ptypid == "ZMM")
						this.m_Pwerkstoff	= "W_MUTTER8";	// ZMM
					else if ((this.m_Ptypid == "ZGM" || this.m_Ptypid == "ZSM") && this.lgv*1 < 56)
						this.m_Pwerkstoff	= "W_C45";	// ZGM, ZSM mit LGV < 56
					else if ((this.m_Ptypid == "ZGM" || this.m_Ptypid == "ZSM") && this.lgv*1 >= 56)
						this.m_Pwerkstoff	= "W_RST52";	// ZGM, ZSM mit LGV >= 56
				}
                break;
			case "ZLV":
				strTypNr = splitVarDelimiter(strTyp, " .-.");
				if(strTypNr.length < 5 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv			= getVarDelimited(strTypNr, 1);
				this.m_Poberfl		= OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)];
				this.m_Pwerkstoff	= this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 3));
				break;
			case "ZOM":
                if (this.m_bSonderZubehoer)
				{
					strTypNr = splitVarDelimiter(strTyp, " /-");
					if(strTypNr.length < 4 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)]) == "undefined")
					{
						bOK = false;
						break;
					}
					this.lgv = getVarDelimited(strTypNr, 1);
					this.m_strSonderGewinde = getVarDelimited(strTypNr, 2);
					this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)];
                }
				else
				{
					strTypNr = splitVarDelimiter(strTyp, " -");
					if (strTypNr.length == 2){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_VERBTEILE", "PROJECT.SETTINGS.CASCADE")]);
						strTyp		+= "-" + strTypNr[2];
						this.m_Ptyp	= strTyp;
					}
					if(strTypNr.length < 3 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)]) == "undefined")
					{
						bOK = false;
						break;
					}
					this.lgv = getVarDelimited(strTypNr, 1);
					this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)];
				}
				this.m_Pwerkstoff	= (this.lgv*1 < 56 ? "W_C45" : "W_RST52");
                break;
            case "ZKN":
				// PDMS liefert fr den Subtyp "ZKN_1"	: ZKN 1.16.160-2	-> Angabe fr tG fehlt generell -> wir liefern min(Btr/10 , 36)
				// PDMS liefert fr den Subtyp "ZKN_2"	: ZKN 36.200-2		-> korrekt wre	: ZKN 2.36.200.15-2
				strTypNr = splitVarDelimiter(strTyp, " ..-");
				if (strTypNr.length < 3){	// hier ist was faul
					bOK = false;
					break;
				}
				if (strTypNr.length < 4)	// Subtyp 2
					strTyp	= strTypNr[0] + " 2." + strTypNr[1] + "." + strTypNr[2];
				
				strTypNr = splitVarDelimiter(strTyp, " ..-");
				
				if (strTypNr.length < 5 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv			= getVarDelimited(strTypNr, 2);
				this.m_strMassBTR	= getVarDelimited(strTypNr, 3);
				this.m_strMassTG	= min(getVarDelimited(strTypNr, 3) / 10 , 36);
				this.m_Poberfl		= OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)];
				this.m_Pwerkstoff	= "W_RST";
				this.subtyp			= getVarDelimited(strTypNr, 0) + "_" + getVarDelimited(strTypNr, 1);
                break;
            case "ZKK":
				// PDMS liefert fr "ZKK"	: ZKK 16.200-2		-> korrekt wre	: ZKK 16.200.15-2
				strTypNr = splitVarDelimiter(strTyp, " ..-");
				if (strTypNr.length < 3){	// hier ist was faul
					bOK = false;
					break;
				}
				if (strTypNr.length < 4 && find(strTypNr[strTypNr.length-1],"-") > 0){
					strTypNr = splitVarDelimiter(strTyp, " .-");
					strTyp	 = strTypNr[0] + " " + strTypNr[1] + "." + strTypNr[2] + "." + min(strTypNr[2] / 10 , 36) + "-" + strTypNr[3];
					this.m_Ptyp	= strTyp;
				}
					
				strTypNr = splitVarDelimiter(strTyp, " ..-");
				if(strTypNr.length < 5 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv = getVarDelimited(strTypNr, 1);
				this.m_strMassBTR = getVarDelimited(strTypNr, 2);
				this.m_strMassTG = getVarDelimited(strTypNr, 3);
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)];
				this.m_Pwerkstoff	= "W_RST";
				this.m_Pwerkname	= "1.0038";
                break;
            case "ZKB":
				strTypNr = splitVarDelimiter(strTyp, " .-");
				if(strTypNr.length < 4 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv			= 12;
				this.m_strMassBTR	= getVarDelimited(strTypNr, 2);
				this.m_strMassTG	= 21;
				this.m_Poberfl		= OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)];
				this.m_Pwerkstoff	= "W_RST";
				//this.m_Ptypid		= "ZKN";
				this.subtyp			= "ZKB";
				break;
			case "ZRM":
				strTypNr = splitVarDelimiter(strTyp, " .-");
				if (strTypNr.length == 3){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					strTypNr.push(Oberflaechenschutz[getstring("OBFL_VERBTEILE", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "-" + strTypNr[3];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 4 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv = getVarDelimited(strTypNr, 1);
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				if(this.m_Pemass > 3000)
				{
					bOK = false;
					break;
				}
				this.m_Poberfl		= OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)];
				this.m_Pwerkstoff	= "W_RST";
                break;
            case "ZTN":
				strTypNr = splitVarDelimiter(strTyp, " .-.");
				if (strTypNr.length == 4){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					strTypNr.push(Oberflaechenschutz[getstring("OBFL_TRAVERSEN", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "." + strTypNr[4];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 5 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.lgv = getVarDelimited(strTypNr, 1);
				this.m_dSonderSpannweite = atoi(getVarDelimited(strTypNr, 2));
				if (!bSonder)
					this.spannweite = this.m_dSonderSpannweite;
				else{
					this.m_bSonderSpannweite	= 1;
					var strSQLStatement = "select * from ZTN_TYP where abs(SPANN) >= " + abs(this.m_dSonderSpannweite) + " and LGV = " + this.lgv + " order by abs(GEWICHT) ";
					var numRet = dbselect("CASCADE", strSQLStatement, "ZTN_TYP");
					if (numRet < 1){
						bOK	= false;
						break;
					}
					this.spannweite				= dbgetdouble("ZTN_TYP", "SPANN"); // die nchst grere Standardspannweite
				}
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 3));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)];
                break;
            case "ZVN":
            case "ZVV":
            case "ZVS":
				strTypNr = splitVarDelimiter(strTyp, " ..-.");
				if (strTypNr.length == 5){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					if (strTypNr[4]*1 >= 41 && strTypNr[4]*1 <= 80)	// Austenit
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);
					else if (strTypNr[4]*1 < 37 || strTypNr[4]*1 > 80)	// Warmfest
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")]);
					else	// RSt
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "." + strTypNr[5];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 6 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.breite			= atoi(getVarDelimited(strTypNr, 1));
				this.m_Pemass		= atoi(getVarDelimited(strTypNr, 2));
				this.lgv			= getVarDelimited(strTypNr, 3);
				this.m_Pwerkstoff	= this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4));
				this.m_Poberfl		= OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)];
				// Nennweite der Schelle stezen
				this.nennweite		= getint("IDC_NENNWEITE_DN","DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
                break;
            case "MBS":
			case "MBW":
				strTypNr = splitVarDelimiter(strTyp, " -");
				if(strTypNr.length < 3 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.m_dNennlast = atoi(getVarDelimited(strTypNr, 1));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 2)];
				this.m_strLGG = sprintf("%.3d", this.m_dNennlast);
                break;
            case "ZZF":
				strTypNr = splitVarDelimiter(strTyp, " ..-.");
				if (strTypNr.length == 5){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert der Sttze
					strTypNr.push(Oberflaechenschutz[getstring("OBFL_HAENGER", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "-" + strTypNr[5];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 6)
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.m_strGroesseHaenger = getVarDelimited(strTypNr, 1);
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				this.form = getVarDelimited(strTypNr, 3);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)];
                break;
            case "ZZK":
				strTypNr = splitVarDelimiter(strTyp, " ..-.");
				if(strTypNr.length < 4)
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.m_strGroesseHaenger = getVarDelimited(strTypNr, 1);
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				this.form = getVarDelimited(strTypNr, 3);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)];
                break;
            default:
                buf = "";
        }

		this.m_Pwerkalt = this.m_Pwerkstoff;

        this.getPreis();

	// 20.08.08 mb weitere Daten setzen
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
		var bSuccess = this.getAdditionalDataToStore(tmpPath);
		if(bSuccess == -1)
			return "ERR";

		//this.lgv = getstring("LGV", tmpPath);		// -Schu- wird oben schon gesetzt
		this.a_lgv = getstring("LGV", tmpPath);
		if(this.m_Pgewicht<=0)
		{
			if(this.m_Ptypid == "MBW")
				this.m_Pgewicht = getdouble("M", tmpPath);
			else
				this.m_Pgewicht = getdouble("GEWICHT", tmpPath);
			// Meterpreis
			if(this.m_Ptypid == "ZRM") this.m_Pgewicht = fround(this.m_Pemass / 1000.0 * this.m_Pgewicht, 2);
		}
		// -Schu- weitere Daten
		if(this.m_Ptypid != "ZRM") this.m_Pemass	= atoi(getdouble("E", tmpPath));

        return(bOK ? "" : "ERR");
	},

    getTopoPic : function(Drehung)
    {
        var strPic = "";

        if (this.m_Ptypid == "ZSM")
        {
            if (this.m_Pcpartid  == "IDL_C_ZSM_1")
                strPic = "ZSMU";
            else
                strPic = "ZSMO";
        }
        else if (this.m_Ptypid == "ZRM")
            strPic = "ZRMU";
		else if (this.m_Pcpartid == "IDL_C_ZGW_U")
            strPic = "ZGWU";
		else if (this.m_Pcpartid == "IDL_C_ZGW_O")
            strPic = "ZGWO";
        else if ((this.m_Pcpartid == "IDL_C_ZLN_O_1") || (this.m_Pcpartid == "IDL_C_ZLN_O_2"))
            strPic = "ZLNO";
        else if (this.m_Pcpartid == "IDL_C_ZLN_U")
            strPic = "ZLNU";
        else if (this.m_Pcpartid == "IDL_C_ZGM_O")
            strPic = "ZGMO";
        else if (this.m_Pcpartid == "IDL_C_ZOM_O")
            strPic = "ZOMO";
        else if (this.m_Pcpartid == "IDL_C_ZOM_U")
            strPic = "ZOMU";
        else if (this.m_Pcpartid == "IDL_C_ZGM_U")
            strPic = "ZGMU";
        else if (this.m_Pcpartid == "IDL_C_MBS_U" || this.m_Pcpartid == "IDL_C_MBW_U")
            strPic = "MBSU";
        else if (this.m_Pcpartid == "IDL_C_MBS_O" || this.m_Pcpartid == "IDL_C_MBW_O")
            strPic = "MBSO";
        else if (left(this.m_Ptypid, 2) == "ZV")         // Hack, weil wir nur fr die N-Version Bilder haben
            strPic = "ZVN";
        else if ((this.m_Ptypid == "ZKN") && (this.subtyp == "ZKB"))
            strPic = "ZKB";
        else if (this.m_Pcpartid == "IDL_C_ZPK_O")
            strPic = "ZPK";
        else if (this.m_Pcpartid == "IDL_C_ZPK_U")
            strPic = "ZPKU";
        else if (this.m_Pcpartid == "IDL_C_ZMM_O")
            strPic = "ZRM_MMO";
        else if (this.m_Pcpartid == "IDL_C_ZMM_U")
            strPic = "ZRM_MMU";
        else
            strPic = this.m_Ptypid;

        if ((this.m_Ptypid != "ZRM") && (this.m_Ptypid != "ZMM") && (this.m_Ptypid != "ZPK") &&
            ((Drehung == 90) || (Drehung == 270)))
            strPic = strPic + "_S";

        return ("catalog/client/custom/img/panels/T"+strPic+".png");
    },


	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        // wir mssen nochmal in die Grunddaten rein, weil sich bei manchen Produkten
        // durch nderung Werkstoff oder Oberflchenschutz der Preis ndern kann:
        var tmpPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        /*
            Pi_j: bei Zubehr mit Gewinde
            ZRM, ZLM, ZMM, ZOM, ZGM, ZSM, ZHM
            i = 1 metrisches Gewinde, i = 2 Zollgewinde
            j = Oberflchenschutz

            Pi: bei Zubehr ohne Gewinde
            ZPK, ZLN, ZLK, ZKN, ZKK, ZTN, ZZF, ZZK
            i = Oberflchenschutz
        */
        this.m_Ppreis = 0.0;

        var nGewindeCode = 1;
        if (this.m_Pgewinde != "GEWINDE_DIN")
            nGewindeCode = 2;

        var strPraefix = "P";
        if ((this.m_Ptypid == "ZOM") && this.m_bSonderZubehoer)
            strPraefix = "PS";

        var strFieldname = strPraefix + Oberflaechenschutz[this.m_Poberfl];
        if (this.isGewTeil())
            strFieldname = strPraefix + nGewindeCode + "_" + Oberflaechenschutz[this.m_Poberfl];
        else if (left(this.m_Ptypid, 2) == "ZV")
            strFieldname = strPraefix + Werkstoffe[this.m_Pwerkstoff] + "_" + Oberflaechenschutz[this.m_Poberfl];
		else if (this.m_Ptypid == "SBV"){
			if (this.m_Psubtyp == "W")
				strFieldname = strPraefix + Oberflaechenschutz[this.m_Poberfl] + "_" + this.m_Psubtyp + "_" + (this.m_Pemass*1 < 1000 ? "999" : "1000");
			else
				strFieldname = strPraefix + Oberflaechenschutz[this.m_Poberfl] + "_" + this.m_Psubtyp;
		}

        var strPreis = getstring(strFieldname, tmpPath);

        if (strPreis != "")
        {
            this.m_Ppreis = fround(strPreis, 2);
            // Sonderflle:
            if (this.m_Ptypid == "ZRM")
            {
                // ZRM: Preis nach ganzen Metern (aufgerundet)
                // Umrechnung auskommentiert, weil Preis in der DB immer fr ganze Meter gilt
                // this.m_Ppreis = ((this.m_Pemass / 1000) + 1) * this.m_Ppreis;
            }
            if (this.m_Ptypid == "ZTN")
            {
                /* -mw- 04/2008: nur fr Schellen und Lager
                if (oOptions.SONDERANSTRICH_KOSTEN > 0)
                    this.m_Ppreis += (oOptions.SONDERANSTRICH_KOSTEN * this.m_Pgewicht);
                */
            }
        }

        if (this.m_bSonderSpannweite)
        {
            var dZuschlag = this.getPreiszuschlagSonder(this.getSAPKlassenName(), this.getSAPTyp(), "");
            this.m_Ppreis = fround(this.m_Ppreis * dZuschlag, 0);
        }

        if (left(this.m_Ptypid, 2) == "ZV")
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_SCHELLEN");
        else if (left(this.m_Ptypid, 2) == "ZK")
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_ZKX");
        else if (this.m_Ptypid == "ZTN")
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_TRAV");
        else if (this.m_Ptypid == "MBS" || this.m_Ptypid == "MBW")
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_MBS");
        else    // auch fr ZZF / ZZK
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_VTEILE");


        return (this.m_Ppreis);
	},

    isSAPKonfigurierbar : function()
    {
        if ((left(this.m_Ptypid, 2) == "ZZ") ||
            (this.m_Ptypid == "ZTN"))
            return 1;

        if (left(this.m_Ptypid, 2) == "ZK")
        {
            if ((this.subtyp == "ZKN_2") ||
                (this.m_Ptypid == "ZKK"))
                return 1;
        }
        return 0;
    },

    getSAPTyp : function()
    {
        if (this.m_Ptypid == "ZKN")
        {
            var strRes = replace(this.subtyp, "_", " ");
            return strRes;  // 'ZKN 1', 'ZKN 2' oder 'ZKB'
        }
        else if ((this.m_Ptypid == "ZOM") && this.m_bSonderZubehoer)
        {
            return "ZOM-S";
        }

        return this.m_Ptypid;
    },

    getSAPKlassenName : function()
    {
        var strKlasse = "ZUB";  // Default, nicht this.m_Ptypid

        if (left(this.m_Ptypid, 2) == "ZV")
            strKlasse = "ZVN";
        else if (left(this.m_Ptypid, 2) == "ZZ")
            strKlasse = "ZZF";
        else if (this.m_Ptypid == "ZRM")
            strKlasse = "PRG";
        else if (this.m_Ptypid == "ZMM")
            strKlasse = "SUM";
        else if (this.m_Ptypid == "ZKK")
            strKlasse = "ZKK";
        else if (this.m_Ptypid == "ZTN")
            strKlasse = "ZTN";
        else if (left(this.m_Ptypid, 2) == "MB")
            strKlasse = "SSG";
		else if (this.m_Ptypid == "SBV")
			strKlasse = "SBW";
			
        else if (this.m_Ptypid == "ZKN")
        {
            if (this.subtyp == "ZKN_2")
                strKlasse = "ZKK";
            else
                strKlasse = "ZKN";  // gilt fr ZKB und ZKN 1
        }
			
		else if (this.m_Ptypid == "ZKB")
			strKlasse	= "ZKN";
		
        return strKlasse;
    },

	getSubtyp : function()
	{
        if (left(this.m_Ptypid, 2) == "ZZ")
			return (this.form);
			
		return "";
	},

    getASTLDaten : function(theMainController)
    {
        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        retObj.loeseauf = this.isSAPKonfigurierbar();

        var strKlasse = this.getSAPKlassenName();
        var searchObj;
        var sapWerkstoffBez = WerkstoffeSAPid[this.m_Pwerkstoff];
        var sapOberflaechenschutz = Oberflaechenschutz[this.m_Poberfl];

        var massPath = "TMP.ZB_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(massPath);

        var strLGGFuerSuche = atoi(this.m_strLGG);


        if (this.m_Ptypid == "ZRM")
        {
            retObj.postyp        = "R";     // (R=Rohmass oder L=nicht)
            retObj.rm_einheit    = "MM";
            retObj.formelzeichen = "L1";
            retObj.rm1           = this.m_Pemass;
            searchObj = { LASTGRUPPE: this.lgv,
                          GEWINDEDURCHMESSER: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP: this.getSAPTyp() };
        }
        else if (this.m_Ptypid == "ZTN")
        {
            retObj.postyp        = "L";     // (R=Rohmass oder L=nicht)
            /* -scm- 4.3.2008 ZTN keine Rohmassposition
            retObj.rm_einheit    = "MM";
            retObj.formelzeichen = "L1";
            retObj.rm1           = this.spannweite;
            */
            searchObj = { LASTGRUPPE: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP: this.getSAPTyp() };
        }
        else if ((this.m_Ptypid == "ZKN") || (this.m_Ptypid == "ZKK") || (this.m_Ptypid == "ZKB"))
        {
            var btrFuerSuche = this.m_strMassBTR;
            if (this.subtyp == "ZKB")
            {
                if (btrFuerSuche <= 200)
                    btrFuerSuche = "200";
                else
                    btrFuerSuche = "300";
            }
            else if (this.subtyp == "ZKN_1")
            {
                if (this.lgv == "16")
                    btrFuerSuche = "160";
                else if (this.lgv == "20")
                    btrFuerSuche = "180";
                else if (this.lgv == "24")
                    btrFuerSuche = "200";
            }
            searchObj = { LASTGRUPPE: this.lgv,
                          TRAEGERBREITE: btrFuerSuche,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP: this.getSAPTyp() };
        }
        else if (left(this.m_Ptypid, 2) == "ZV")
        {
            var Variante	= getstring("VAR", massPath);
			
			searchObj = { LASTGRUPPE: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          //TYP: this.getSAPTyp(),
                          TYP: this.getSAPTyp() + (getstring("VAR", massPath) == "-" ? "" : "-" + getstring("VAR", massPath)),
                          BREITE: getstring("B", massPath),
                          EINBAUMASS: this.m_Pemass};
        }
        else if (left(this.m_Ptypid, 2) == "ZZ")
        {
            var groesseFuerSuche = this.groesse;
            if (left(groesseFuerSuche, 1) == "0")
                groesseFuerSuche = right(groesseFuerSuche, 1);
            var strLastgroesse = "";
            var strLeistungsgroesse = "";
            if (this.m_Ptypid == "ZZF")
                strLastgroesse = groesseFuerSuche;
            else
                strLeistungsgroesse = groesseFuerSuche;

            // Achtung: Benennung der ersten 2 Merkmale ist hier missverstndlich, gesucht wird
            // die Grsse des ZZ, nicht des zug. Hngers
            searchObj = { LASTGROESSE: strLastgroesse,                  // nur bei FH
                          LEISTUNGSGROESSE: strLeistungsgroesse,        // nur bei KH
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP: this.getSAPTyp() };
        }
        else if (this.m_Ptypid == "ZMM")
        {
            searchObj = { LASTGRUPPE: this.lgv,
                          GEWINDEDURCHMESSER: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          NORM: "DIN EN ISO 4032",
                          WERKST_FESTIGK: "8",
                          TYP: this.getSAPTyp() };
        }
        else if (this.m_Ptypid == "MBS")
        {
            searchObj = { LASTGRUPPE: strLGGFuerSuche,
                          LAENGE: this.m_Pemass,
                          TYP: this.getSAPTyp(),
						  OBERFLAECHENSCHUTZ: Oberflaechenschutz[this.m_Poberfl]};
        }
		else if (this.m_Ptypid == "MBW")
        {
            if (strLGGFuerSuche*1 == 8){
				strLGGFuerSuche	+= (theMainController.topologieKlasse.bSSG ? "_12" : "_10");	// SSG hat Bolzen 12mm und SSB hat Bolzen 10mm
			}
			searchObj = { LASTGRUPPE: strLGGFuerSuche,
                          LAENGE: this.m_Pemass,
                          TYP: this.getSAPTyp(),
						  OBERFLAECHENSCHUTZ: Oberflaechenschutz[this.m_Poberfl]};
        }
		else if (m_Ptypid == "SBV")
		{
			searchObj = { WERKSTOFF:	'',
                          NORM:			'',
                          //TYP:			left(this.m_Ptyp, 9) + "xxxx" + right(this.m_Ptyp, 2) };
						  TYP:			left(this.m_Ptyp, 9) + "xxxx" };
		}
		else
        {
            searchObj = { LASTGRUPPE: this.lgv,
                          GEWINDEDURCHMESSER: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP: this.getSAPTyp() };
        }

        var aMerkmale = this.getMerkmaleArray(strKlasse, searchObj);
        var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte; // nicht so toll ...
        if (this.isSAPKonfigurierbar() || this.isRohmassPosition() ||
            ((this.m_Ptypid == "ZOM") && this.m_bSonderZubehoer))
            retObj.postext1 = this.m_Ptyp;

        return (retObj);
	},

    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
		var aParams = new Array();
		var typForCAD = this.m_Ptypid;
        if (typForCAD == "ZKN")
            typForCAD = replace(this.subtyp, "_", " ");
        if ((typForCAD == "ZOM") && this.m_bSonderZubehoer)
        {
            typForCAD = "ZOMS";
            aParams.push( [ "LGV" + nStartPos, "" + this.lgv ] );   // this.m_strSonderGewinde enthlt die LGV der Lastkette
        }
        
        if (nTyp == "E")
        {
            aParams.push( [ "Typ", "" + typForCAD ] );
			if (this.m_dSonderSpannweite > 0)
				aParams.push( [ "Spannweite", "" + this.m_dSonderSpannweite ] );
        }
        else
            aParams.push( [ "Position" + nStartPos, "" + typForCAD ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

        if ((this.m_Ptypid == "ZRM") || (this.m_Ptypid == "ZLM"))
        {
            aParams.push( [ "Laenge" + nStartPos, "" + this.m_Pemass ] );  // Achtung: mit / ohne fhrende Null
        }
        else if ((left(this.m_Ptypid, 2) == "ZV") || (left(this.m_Ptypid, 2) == "ZZ"))
        {
            aParams.push( [ "E-Mass" + nStartPos, "" + this.m_Pemass ] );  // Achtung: mit / ohne fhrende Null
        }
        else if (left(this.m_Ptypid, 2) == "ZK")
        {
            var strBtrForCad = this.m_strMassBTR;
            if (left(strBtrForCad, 1) == '0')
                strBtrForCad = right(strBtrForCad, strBtrForCad.length - 1);
            aParams.push( [ "Traegerbreite" + nStartPos,  strBtrForCad ] );
            aParams.push( [ "Flanschdicke" + nStartPos, this.m_strMassTG ] );
        }
        else if (this.m_Ptypid == "MBS")
        {
            var strLGGFuerCAD = atoi(this.m_strLGG);
            aParams.push( [ "Typ" + nStartPos, strLGGFuerCAD ] );
        }

        return( [ aParams, nPosNr + 1 ] );
    }

});