/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Vertikalschelle
 */
Vertikalschelle = function() {

	Vertikalschelle.superclass.constructor.call(this);

	/**
     *
     * @var
     */

	this.nennlast   = 0;
	this.traglast   = 0;
	this.groesse    = 0;
	this.spannweite = 0;
	this.nennweite  = 0;
	this.lgv        = "";
    this.m_strLGG   = "";
	this.vtyp       = 1;	// Kasten oder Joch, bzw. FORM 1, 2, 3 bei VBK, ...

	this.m_bSonderNennweite = 0;
	this.m_dSonderNennweite = 0;
	this.m_bSonderSpannweite = 0;
	this.m_dSonderSpannweite = 0;


    this.Betriebslast        = 0;
    this.Daemmdicke          = 0;
    this.MediumTemperatur    = 0;
    this.UmgebungsTemperatur = 0;
    this.ReferenzTemperatur  = 0;

};


EasyKat.extend(Vertikalschelle, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);       // Horizontalschelle

        // Einfache Variablen einlesen, je nach Typ
        this.nennlast       = getdouble("nennlast",strPath);
        this.traglast       = getdouble("traglast",strPath);
        this.lgv            = getstring("lgv",strPath);
        this.m_strLGG       = getstring("m_strLGG",strPath);
        this.groesse        = getdouble("groesse",strPath);
        this.spannweite     = getdouble("spannweite",strPath);
        this.nennweite      = getdouble("nennweite",strPath);
        this.vtyp           = getdouble("vtyp",strPath);

        this.m_bSonderNennweite  = getdouble("m_bSonderNennweite",strPath);
        this.m_dSonderNennweite  = getdouble("m_dSonderNennweite",strPath);
        this.m_bSonderSpannweite = getdouble("m_bSonderSpannweite",strPath);
        this.m_dSonderSpannweite = getdouble("m_dSonderSpannweite",strPath);

        this.Betriebslast        = getdouble("Betriebslast",strPath);
        this.Daemmdicke          = getdouble("Daemmdicke",strPath);
        this.MediumTemperatur    = getdouble("MediumTemperatur",strPath);
        this.UmgebungsTemperatur = getdouble("UmgebungsTemperatur",strPath);
        this.ReferenzTemperatur  = getdouble("ReferenzTemperatur",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Vertikalschelle");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen
        setdouble("nennlast",           strPath, this.nennlast);
        setdouble("traglast",           strPath, this.traglast);
        setstring("lgv",                strPath, this.lgv);
        setstring("m_strLGG",           strPath, this.m_strLGG);

        setdouble("groesse",            strPath, this.groesse);
        setdouble("spannweite",         strPath, this.spannweite);
        setdouble("nennweite",          strPath, this.nennweite);
        setdouble("vtyp",               strPath, this.vtyp);

        setdouble("m_bSonderNennweite", strPath, this.m_bSonderNennweite);
        setdouble("m_dSonderNennweite", strPath, this.m_dSonderNennweite);
        setdouble("m_bSonderSpannweite", strPath, this.m_bSonderSpannweite);
        setdouble("m_dSonderSpannweite", strPath, this.m_dSonderSpannweite);

        setdouble("Betriebslast",       strPath, this.Betriebslast);
        setdouble("Daemmdicke",         strPath, this.Daemmdicke);
        setdouble("MediumTemperatur",   strPath, this.MediumTemperatur);
        setdouble("UmgebungsTemperatur",strPath, this.UmgebungsTemperatur);
        setdouble("ReferenzTemperatur", strPath, this.ReferenzTemperatur);
    },

    Init : function(/*int*/ ptypid, /*int*/ pnennw, /*int*/ pspannw, /*int*/ pnennl, /*int*/ pgroe,
                    /*char **/plgv,	/*int*/ pwerk, /*int*/ ptyp, /*int*/ pema, /*double*/ pgewicht,
                    /*double*/ ptraglast, /*BOOL*/ bSonderRAD, /*double*/ dSonderAussendurch,
                    /*BOOL*/ bSonderSpann, /*int*/ nSonderspannweite, /*CString*/ strLGG,
                    schelBetriebsLast, MediumTemperatur, UmgebungsTemperatur, ReferenzTemperatur,
                    Daemmdicke)
    {
        this.m_Ptypid   = ptypid;
        this.m_Pgewicht = pgewicht;
        this.m_Pwerkstoff = pwerk;
        this.traglast   = ptraglast;
        this.nennlast   = pnennl;
        this.groesse     = pgroe;
        this.spannweite  = pspannw;
        this.nennweite  = pnennw;
        this.lgv        = plgv;
        this.m_Pwerkalt = this.m_Pwerkstoff;

        this.m_bSonderNennweite  = bSonderRAD;
        this.m_dSonderNennweite  = dSonderAussendurch;
	    this.m_bSonderSpannweite = bSonderSpann;
	    this.m_dSonderSpannweite = nSonderspannweite;

        this.Betriebslast        = schelBetriebsLast;
        this.Daemmdicke          = Daemmdicke;
        this.MediumTemperatur    = MediumTemperatur;
        this.UmgebungsTemperatur = UmgebungsTemperatur;
        this.ReferenzTemperatur  = ReferenzTemperatur;

        this.m_strLGG   = strLGG;

        this.m_Poberfl = this.getOberFlaechenSchutzDefault();
		
		this.m_Pzeichnr	= " *) ";

        var dNormAussendurch = this.GetRADfromNennweite(nennweite);

        if (ptypid == "VBK")
        {
            var strSQLStatement = "select * from VBK_MAS";   // order by ...
            var numRet = dbselect("CASCADE", strSQLStatement, "SCHEL_PRODUKT_SELECT");

            if (numRet > 0)
            {
                var nIstGroesse, nIstLGVbis;
				// --gl-- NaN aufpassen
                var nLGV = parseInt(plgv);
                while (dbiseof("SCHEL_PRODUKT_SELECT") == 0)
                {
                    nIstLGVbis  = dbgetdouble("SCHEL_PRODUKT_SELECT", "LGV_BIS");
                    nIstGroesse = dbgetdouble("SCHEL_PRODUKT_SELECT", "groesse");

                    if ((nIstGroesse == pgroe) &&
                        (nIstLGVbis >= nLGV))
                    {
                        this.m_Pemass = dbgetdouble("SCHEL_PRODUKT_SELECT", "E");
                        this.vtyp = dbgetdouble("SCHEL_PRODUKT_SELECT", "FORM");    // "ausfuehr" 2008-067-01 auf Wunsch -schm-
                        break;
                    }
                    dbskip("SCHEL_PRODUKT_SELECT");
                }
            }
        }
        else
        {
            this.vtyp     = ptyp;
            this.m_Pemass = pema;
        }


        var strDMR = sprintf("%8.1f", this.m_dSonderNennweite);
        strDMR = trimleft(strDMR, " ");
        var strL = sprintf("%8.0f", this.m_dSonderSpannweite);
        strL = trimleft(strL, " ");

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.VS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        this.setMass(tmpPath, "DMR",  strDMR);
        this.setMass(tmpPath, "L",    strL);
        this.setMass(tmpPath, "LGV",  this.lgv);

        if (ptypid == "VKK")
        {
            if (this.m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dPBnenn = this.getMass(tmpPath, "PB");
                var dPLnenn = this.getMass(tmpPath, "PL");
                var dAnenn = this.getMass(tmpPath, "A");

                // nun die neuen Masse berechnen:
                var dA   = dAnenn  - (dNormAussendurch - this.m_dSonderNennweite);
                var dPB  = dPBnenn - (dNormAussendurch - this.m_dSonderNennweite);
                var dPL  = dPLnenn - (dNormAussendurch - this.m_dSonderNennweite);

                this.setMass(tmpPath, "PB", dPB);
                this.setMass(tmpPath, "PL", dPL);
                this.setMass(tmpPath, "A",  dA);
                this.setMass(tmpPath, "L",  strL);
            }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
            stkMasse      = ["nennweite", "L", "E", "A", "hm", "sTp", "ha", "z", "DMR", "LGV", "f", "sT", "PL", "PB", "spann", "Lab", "ga", "dab", "eab", "k", "sSt", "r", "dd", "ad", "hd", "aN", "hN", "zd", "lTr", "Bab", "b1ab", "tab", "gh" ];
            stkMasseNamen = ["nennweite", "L", "E", "A", "hm", "sTp", "ha", "z", "DMR", "LGV", "f", "s", "PL", "PB", "spann", "Lab", "ga", "dab", "eab", "k", "sSt", "r", "dd", "ad", "hd", "aN", "hN", "zd", "lTr", "Bab", "b1ab", "tab", "gh" ];

        }

        if (ptypid == "VKR")
        {
            if (this.m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dAnenn = this.getMass(tmpPath, "A");

                // nun die neuen Masse berechnen:
                var dA   = dAnenn  - (dNormAussendurch - this.m_dSonderNennweite);

                this.setMass(tmpPath, "A",  dA);
                this.setMass(tmpPath, "L",   strL);
            }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
            stkMasse      = ["nennweite", "L", "E", "A", "H", "d_", "ha", "z", "DMR", "LGV", "f", "sT", "spann", "e", "k", "sSt", "r", "dd", "ad", "hd", "aN", "hN", "zd", "lTr" ];
            stkMasseNamen = ["nennweite", "L", "E", "A", "H", "d",  "ha", "z", "DMR", "LGV", "f", "s", "spann", "e", "k", "sSt", "r", "dd", "ad", "hd", "aN", "hN", "zd", "lTr" ];
        }
        if (ptypid == "VSR" || ptypid == "VGR" || ptypid == "VPR")
        {
            if (this.m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dWnenn = this.getMass(tmpPath, "W");
                var dAnenn = this.getMass(tmpPath, "A");

                // nun die neuen Masse berechnen:
                var dA  = dAnenn  - (dNormAussendurch - this.m_dSonderNennweite);
                var dW = 0;
                if (dWnenn > 0)
                    dW = dWnenn - (dNormAussendurch - this.m_dSonderNennweite);
                else
                    dW = 0;

                this.setMass(tmpPath, "A",  dA);
                this.setMass(tmpPath, "W",  dW);
                this.setMass(tmpPath, "L",   strL);
            }
			
			if (this.m_bSonderSpannweite)
			{
				// bestimme "W"
				var Wreal	= this.m_dSonderNennweite + (this.getMass(tmpPath, "DS")+5) + 2*this.getMass(tmpPath, "ST") + 2*50;
				if ((nSonderspannweite - Wreal) < 300)
					this.vtyp	= 1;
				else
					this.vtyp	= 2;
			}
			
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
            stkMasse      = ["nennweite", "L", "g", "A", "ha", "d_", "E", "z", "W", "H", "sT", "sSt", "f", "m", "hW", "DMR", "spann", "k", "sP", "e1", "ad", "dS", "V", "e2" ];
            stkMasseNamen = ["nennweite", "L", "g", "A", "ha", "d",  "E", "z", "W", "H", "sT", "sSt", "f", "m", "hW", "DMR", "spann", "k", "sP", "e1", "ad", "dS", "V", "e2" ];
			
			if (ptypid == "VGR"){
				stkMasse.push("FNBO");
				stkMasseNamen.push("FNBO");
			}
        }

        if (ptypid == "VBK")
        {
            if (this.m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var danenn = this.getMass(tmpPath, "a");

                // nun die neuen Masse berechnen:
                var dr1 = fround (1.01 * (this.m_dSonderNennweite / 2.0), 0) + 1.0;
                var da  = 0.9 * this.getMass(tmpPath, "di") + (this.getMass(tmpPath, "s") / 2.0) +
                                sqrt( pow( dr1 + 2.5 * this.getMass(tmpPath, "s"), 2) -
                                      pow( (this.getMass(tmpPath, "b") / 2.0) + 2.5 * this.getMass(tmpPath, "s"), 2) );

                var nTemp = RoundDoubleToInt(da);

                da = nTemp * 2.0;

                this.setMass(tmpPath, "a",  da);
                this.setMass(tmpPath, "L",   strL);
            }
            stkMasse      = ["nennweite", "L", "E", "H", "b", "c", "s", "z", "DMR", "LGV", "a", "spann", "groesse", "LGV_BIS", "di", "e2", "ausfuehr" ];
            stkMasseNamen = ["nennweite", "L", "E", "H", "b", "c", "s", "z", "DMR", "LGV", "a", "spann", "groesse", "LGV-bis", "di", "e2", "ausfuehr" ];
        }

        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();

        return(1);
    },

    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert
        delete(storepath,"");

        var    db1, db2, db3;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // VXX:  Nennweite, fn, Spannweite (spann)
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // VXX_Mas:  LGV (LGV_BIS, groesse)
        db3 = this.GetProduktTabelle(this.m_Ptypid, 3);    // VXX_GR:   groesse

        var strSQLStatement1 = "select * from "+db1+" ";
        var numRet1 = dbselect("CASCADE", strSQLStatement1, db1);
        var strSQLStatement2 = "select * from "+db2+" ";
        var numRet2 = dbselect("CASCADE", strSQLStatement2, db2);
        var strSQLStatement3 = "select * from "+db3+" ";
        var numRet3;
        if (db3 != "")
            numRet3 = dbselect("CASCADE", strSQLStatement3, db3);

        if ((numRet1 <= 0) || (numRet2 <= 0) || ((db3 != "") && (numRet3 <= 0)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            logtrace("    >>> "+strSQLStatement3+"\n\r");
            return -1;
        }

        // logtrace(">>>>>>>> Basisdaten neue Schelle: "+this.m_Ptypid+"\n ");
        // logtrace("Base    spannweite: '"+this.spannweite+"' fn: '"+this.nennlast+"' nennweite: '"+this.nennweite+"'\n ");
        while (dbiseof(db1) == 0)
        {
            // !!! Bei VBK Nennlast eigentlich 6.3 mglich !!!
            if (compareInt(dbgetdouble(db1, "spann"),     this.spannweite) &&
                compareInt(dbgetdouble(db1, "fn"),        this.nennlast) &&
                compareInt(dbgetdouble(db1, "nennweite"), this.nennweite))
            {
                dbcopy(db1, storepath);
                // logtrace("Schelle erfolgreich gefunden \n");
				// mb wg. TypnrSuche
				if(this.groesse <= 0)
					this.groesse = dbgetdouble(db1, "GROESSE_SH");
                if (db1 == "VGR"){
					var FNDynTeil	= atoi(getstring("FN", "TMP.FH_ADDITIONAL_DATA"));	// ergibt NULL fr FSG
					setstring ("FNBO", storepath, getstring((!FNDynTeil ? "LGG" : "FN_BOCK"), "TMP.FH_ADDITIONAL_DATA"));
				}
				break;
            }
            else
            {
                // logtrace("Compare spannweite: '"+dbgetdouble(db1, "spann")+"' fn: '"+dbgetdouble(db1, "fn")+"' nennweite: '"+dbgetdouble(db1, "nennweite")+"'\n ");
            }
            dbskip(db1);
        }

        var nGroesseDB;
        while (dbiseof(db2) == 0)
        {
            nGroesseDB = dbgetdouble(db2, "groesse");   // @@@ Felder in DB sind bei VKK / VKR unterschiedlich benannt!!
            if (nGroesseDB <= 0)
                nGroesseDB = dbgetdouble(db2, "GROESSE_SH");

            if (this.m_Ptypid == "VBK")
            {
                if (compareInt(nGroesseDB, this.groesse) &&
                    (dbgetdouble(db2, "LGV_BIS") >= atoi(this.lgv)))
                {
                    dbcopy(db2, storepath);
                    break;
                }
            }
            else
            {
                if (compareInt(nGroesseDB, this.groesse) &&
                    (compareInt(dbgetdouble(db2, "LGV"), atoi(this.lgv)) ||
                     (this.m_Ptypid == "VGR") || (this.m_Ptypid == "VPR") || (this.m_Ptypid == "VSR")))
                {
                    dbcopy(db2, storepath);
                    break;
                }
            }

            dbskip(db2);
        }

        // die dritte: (derzeit nur bei VKK und VKR):
        if (db3 != "")
        {
            while (dbiseof(db3) == 0)
            {
                nGroesseDB = dbgetdouble(db3, "groesse");   // @@@ Felder in DB sind bei VKK / VKR unterschiedlich benannt!!
                if (nGroesseDB <= 0)
                    nGroesseDB = dbgetdouble(db3, "GROESSE_SH");
                if (compareInt(nGroesseDB, this.groesse))
                {
                    dbcopy(db3, storepath);
                    break;
                }
                dbskip(db3);
            }
        }

        if (dbiseof(db1) || dbiseof(db2) || ((db3 != "") && dbiseof(db3)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            if (db3 != "")
                logtrace("    >>> eof Select 3: "+dbiseof(db3)+"\n\r");
            return -1;
        }

        return 1;
    },

	makeTyp : function()
	{
        var strTyp  =  this.m_Ptypid;
        var buf = "";

        if (this.m_bSonderNennweite || this.m_bSonderSpannweite)
        {
            if (this.m_Ptypid == "VBK")
            {
                if (this.vtyp == 1)
                    strTyp += "-S1";
                else
                    strTyp += "-S2";
            }
            else if ( (this.m_Ptypid == "VGR") || (this.m_Ptypid == "VPR") || (this.m_Ptypid == "VSR") )
            {
                // @@@@ TODO: if (atoi(GetProduktMass(m_strMasse, "W")) == 0)
                if (1)
                    strTyp += "-S1";
                else
                    strTyp += "-S2";
            }
            else
                strTyp += "-S";
        }

        var nNennweiteFuerTyp = this.nennweite;
        if (this.m_bSonderNennweite)
            nNennweiteFuerTyp = this.m_dSonderNennweite;

        var nSpannweiteFuerTyp = this.spannweite;
        if (m_bSonderSpannweite)
            nSpannweiteFuerTyp = this.m_dSonderSpannweite;

        if (this.m_Ptypid == "VGR")
        {
            buf = sprintf("%s %.4d.%.4d.%.4d.%s-%s.%d", strTyp, nNennweiteFuerTyp, this.nennlast, nSpannweiteFuerTyp, this.m_strLGG, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
        }
        else if (this.m_Ptypid == "VSK" || this.m_Ptypid == "VSR" || this.m_Ptypid == "VPK" || this.m_Ptypid == "VPR")
        {
            buf = sprintf("%s %.4d.%.4d.%.4d.00-%s.%d", strTyp, nNennweiteFuerTyp, this.nennlast, nSpannweiteFuerTyp, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
        }
        else
        {
            buf = sprintf("%s %.4d.%.4d.%.4d.%s-%s.%d", strTyp, nNennweiteFuerTyp, this.nennlast, nSpannweiteFuerTyp, this.lgv, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
        }
        this.m_Ptyp = buf;

        if (this.m_Pwerkstoff == "W_RST")
            this.m_Pzusinfo = "2.2";
        else
        {   if (this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")
                this.m_Pzusinfo = "3.1B";
            else
                this.m_Pzusinfo = "";
        }

        this.getPreis();
        return this.m_Ptyp;
	},

	fromTyp : function(strTyp)
	{
		var strTypNr = [];
        var strSonder = "";
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.m_bSonderNennweite		= false;
		this.m_bSonderSpannweite	= false;
		
		//if(substr(strTyp, 4, 6) == "-S ")
		if(substr(strTyp, 4, 5) == "-S")
		// ACHTUNG bei Vertikalschellen kann das auch die Spannweite sein!!!
		{
			if (toupper(getstring("IDC_AUSSENDURCHMESSER_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")) == "TRUE")
				this.m_bSonderNennweite		= true;
			if (toupper(getstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")) == "TRUE")
				this.m_bSonderSpannweite	= true;
			strSonder = substr(strTyp, 4, 6);
			
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			//return "Keine Sonderteile moeglich !";
		}
		/*
		if(substr(strTyp, 4, 6) == "-S1" || substr(strTyp, 4, 6) == "-S2")
		// ACHTUNG bei Vertikalschellen kann das auch die Spannweite sein!!!
		{
			this.m_bSonderNennweite = true;
			strSonder = substr(strTyp, 4, 6);
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			//return "Keine Sonderteile moeglich !";
		}
		*/
		// Check Oberflchenschutz
		strTypNr = splitVarDelimiter(strTyp, " ...-.");
		if (strTypNr.length == 6){	// der Oberflchenschutz fehlt - Defaultwerte nutzen
			if (strTypNr[5]*1 >= 41 && strTypNr[5]*1 <= 80)	// Austenit
				strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);
			else if (strTypNr[5]*1 < 37 || strTypNr[5]*1 > 80)	// Warmfest
				strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")]);
			else	// RSt
				strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE")]);
		}
		
        switch (this.m_Ptypid)
        {
			case "VGR":
				//strTypNr = splitVarDelimiter(strTyp, " ...-.");
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.nennweite = atoi(getVarDelimited(strTypNr, 1));
				this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
				this.nennlast = atoi(getVarDelimited(strTypNr, 2));
				
				if (this.m_bSonderSpannweite){
					this.m_dSonderSpannweite	= atoi(getVarDelimited(strTypNr, 3));
					this.spannweite				= getstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
				}
				else{
					this.spannweite = atoi(getVarDelimited(strTypNr, 3));
					this.m_dSonderSpannweite = this.spannweite;
				}
				
				this.m_strLGG = getVarDelimited(strTypNr, 4);
				this.lgv = getVarDelimited(strTypNr, 4);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 5));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
			case "VSK":
			case "VSR":
			case "VPK":
			case "VPR":
				//strTypNr = splitVarDelimiter(strTyp, " ...-.");
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				if (this.m_bSonderNennweite){
					var InfoObj	= GetNextNennweiteFromRAD(atoi(getVarDelimited(strTypNr, 1)));
					this.nennweite = InfoObj.DN;
					this.m_dSonderNennweite = atoi(getVarDelimited(strTypNr, 1));
				}
				else{
					this.nennweite 			= atoi(getVarDelimited(strTypNr, 1));
					this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
				}
				this.nennlast = atoi(getVarDelimited(strTypNr, 2));
				if (this.m_bSonderSpannweite){
					this.m_dSonderSpannweite	= atoi(getVarDelimited(strTypNr, 3));
					this.spannweite				= getstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
				}
				else{
					this.spannweite = atoi(getVarDelimited(strTypNr, 3));
					this.m_dSonderSpannweite = this.spannweite;
				}
				this.lgv = getVarDelimited(strTypNr, 4);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 5));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
				break;
			default:
				//strTypNr = splitVarDelimiter(strTyp, " ...-.");
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				if (toupper(getstring("IDC_AUSSENDURCHMESSER_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")) == "TRUE"){
					var InfoObj				= GetNextNennweiteFromRAD(atoi(getVarDelimited(strTypNr, 1)));
					this.nennweite			= InfoObj.DN;
					this.m_dSonderNennweite	= atoi(getVarDelimited(strTypNr, 1));
				}
				else{
					this.nennweite			= atoi(getVarDelimited(strTypNr, 1));
					this.m_dSonderNennweite	= GetRADfromNennweite(this.nennweite);
				}
				if (toupper(getstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")) == "TRUE"){
					this.m_dSonderSpannweite	= atoi(getVarDelimited(strTypNr, 3));
					this.m_bSonderSpannweite	= 1;
					this.spannweite				= getstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
				}
				else{
					this.spannweite = atoi(getVarDelimited(strTypNr, 3));
				}
				this.nennlast = atoi(getVarDelimited(strTypNr, 2));
				//this.spannweite = atoi(getVarDelimited(strTypNr, 3));
				//this.m_dSonderSpannweite = this.spannweite;
				this.lgv = getVarDelimited(strTypNr, 4);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 5));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
		}

		this.m_Pwerkalt = this.m_Pwerkstoff;

		// passt -S/-S1/-S2 dazu
        if((this.m_bSonderNennweite || this.m_bSonderSpannweite) && bOK)
        {
            if((this.m_Ptypid == "VBK" || this.m_Ptypid == "VGR" || this.m_Ptypid == "VPR" || this.m_Ptypid == "VSR") && strSonder == "-S ")
            {
                bOK = false;
            }
            else if(strSonder != "-S " && this.m_Ptypid != "VBK" && this.m_Ptypid != "VGR" && this.m_Ptypid != "VPR" && this.m_Ptypid != "VSR")
            {
                bOK = false;
            }
			if(! bOK)
				return "Markierung fuer Sonderteile falsch !";
		}

		this.m_Pzusinfo = "";
		if(this.m_Pwerkstoff == "W_RST")
            this.m_Pzusinfo = "2.2";
        else if(this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")
			this.m_Pzusinfo = "3.1B";

        this.getPreis();

	// 26.08.08 mb Produkt korrekt ?
        var tmpPath = "TMP.VS_ADDITIONAL_DATA";
		var bSuccess = this.getAdditionalDataToStore(tmpPath);
		if(bSuccess == -1)
			return "ERR";

		var lgvDS = getstring("LGV", tmpPath);
		if(getstring("LGV", tmpPath) != "" && atod(this.lgv) != atod(lgvDS))
			return "ERR";

	// 12.08.08 mb weitere Daten setzen
		if(this.lgv=="") this.lgv = lgvDS;
		if(this.a_lgv=="") this.a_lgv = lgvDS;
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWICHT", tmpPath);
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWS", tmpPath);
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWG", tmpPath);
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWP", tmpPath);
		if(this.spannweite<=0) this.spannweite = getdouble("SPANN", tmpPath);
		if(this.nennweite<=0) this.nennweite = getdouble("NENNWEITE", tmpPath);
	// -Schu- noch E-Mass setzen
		if(this.m_Pemass<=0)			this.m_Pemass				= getdouble("E", tmpPath);
		if(this.MediumTemperatur<=0)	this.MediumTemperatur		= getint("IDC_TEMPERATUR_MEDIUM", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.UmgebungsTemperatur<=0)	this.UmgebungsTemperatur	= getint("IDC_TEMPERATUR_UMGEBUNG", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.ReferenzTemperatur<=0)	this.ReferenzTemperatur		= getint("IDC_TEMPERATUR_REFERENZ", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.Daemmdicke<=0)			this.Daemmdicke				= getint("IDC_DAEMMDICKE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		
        this.vtyp = getdouble("FORM", tmpPath); 
		
		this.makeTyp();

        return(bOK ? "" : "ERR");
	},

	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        // wir mssen nochmal in die Grunddaten rein, weil sich bei manchen Produkten
        // durch nderung Werkstoff oder Oberflchenschutz der Preis ndern kann:
        var tmpPath = "TMP.VS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        var strFieldname = "P" + Werkstoffe[this.m_Pwerkstoff] + "_" + Oberflaechenschutz[this.m_Poberfl];

        this.m_Ppreis = 0.0;

        if (getstring(strFieldname, tmpPath) != "")
        {
            this.m_Ppreis = inputStringToDouble(getstring(strFieldname, tmpPath));
            if (oOptions.SONDERANSTRICH_KOSTEN > 0)
                this.m_Ppreis += (oOptions.SONDERANSTRICH_KOSTEN * this.m_Pgewicht);
        }
        if (this.m_bSonderNennweite || this.m_bSonderSpannweite)
        {
            var dZuschlag = this.getPreiszuschlagSonder(this.getSAPKlassenName(), this.getSAPTyp(), "");
            this.m_Ppreis = fround(this.m_Ppreis * dZuschlag, 0);
        }

        this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_SCHELLEN");

        return (this.m_Ppreis);
	},

    getTopoPic : function(Drehung)
    {
        // Drehung hier nicht bercksichtigen, es macht von der Darstellung
        // her keinen sinn

        return ("catalog/client/custom/img/panels/T"+this.m_Ptypid+".png");
    },

    isSAPKonfigurierbar : function()
    {
        return 1;
    },

    getSAPKlassenName : function()
    {
        var strKlasse = "VBK";  // immer VBK ... this.m_Ptypid;

        return strKlasse;
    },

    getSAPTyp : function()
    {
        return this.m_Ptypid;
    },

    getASTLDaten : function(theMainController)
    {

        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        retObj.loeseauf = this.isSAPKonfigurierbar();

        var strKlasse = this.getSAPKlassenName();
        var searchObj;
        var sapWerkstoffBez = WerkstoffeSAPid[this.m_Pwerkstoff];
        var sapOberflaechenschutz = Oberflaechenschutz[this.m_Poberfl];

        // GROESSE_SH, WERKSTOFFS,  TYP
        searchObj = { GROESSE_SH:  this.groesse,
                      WERKSTOFFS:  WerkstoffeSAPid[this.m_Pwerkstoff],
                      TYP:         this.getSAPTyp() };

        var aMerkmale = this.getMerkmaleArray(strKlasse, searchObj);
        var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte; // nicht so toll ...
        if (this.isSAPKonfigurierbar() || this.isRohmassPosition())
            retObj.postext1 = this.m_Ptyp;

        return (retObj);
	},

    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
        var strDaemmdicke  = this.Daemmdicke;
        if (!strDaemmdicke)
            strDaemmdicke = "0";
        var strAussendurch = this.m_dSonderNennweite;
        var aParams = new Array();

        if (nTyp == "E")
        {
            aParams.push( [ "Typ", "" + this.m_Ptypid ] );
            aParams.push( [ "Spannweite", "" + this.m_dSonderSpannweite ] );
        }
        else
            aParams.push( [ "Position" + nStartPos, "" + this.m_Ptypid ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

        // Wird nur bei manchen Schellen gebraucht, schadet aber nicht:
        aParams.push( [ "E-Mass" + nStartPos, "" + this.m_Pemass ] );

        // ACHTUNG: die nachfolgenden Parameter tragen nicht die Posnr:
        aParams.push( [ "Groesse", "" + this.groesse ] );
        aParams.push( [ "Oberflaeche", "" + Oberflaechenschutz[this.m_Poberfl] ] );
        aParams.push( [ "Daemmdicke", strDaemmdicke ] );
        aParams.push( [ "Rohraussendurchmesser", strAussendurch ] );
        aParams.push( [ "Werkstoff", "" + Werkstoffe[this.m_Pwerkstoff] ] );

        return( [ aParams, nPosNr + 1 ] );
    }

});