/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Sonderteil
 */
Sonderteil = function() {

	Sonderteil.superclass.constructor.call(this);

	/**
     *
     * @var
     */
	this.RHTyp = "";
	this.bAssistent = 0;    // 0 oder 1
    this.nAnzahl = 1;
    this.Artikeltext = [];  // Array von Strings ...
	this.WIMatnr = "";
    
    // Preis = m_dKundenPreis in Klasse Produkt; m_bPreisVorgabe und m_Ppreis in Klasse Produkt entsprechend setzen ...
    // Einbaumass = m_Pemass in Klasse Produkt
    // Gewicht = m_Pgewicht in Klasse Produkt
    // Werkstoff = m_Pwerkname in Klasse Produkt, dort dann m_Pwerkstoff auf W_SONST setzen...
    // Zeichnungsnummer derzeit nicht in Maske, in Klasse Produkt: m_Pzeichnr

    // ---- Assistent
	this.Produktgruppe = "";
	this.Typ = "";
	this.Art = "";
	this.Select1 = "";
	this.Select2 = "";    
	this.Select3 = "";
	this.Select4 = "";
	this.Select5 = "";
    this.RMLaenge = 0;
    this.RMBreite = 0;

	this.bOberflaechenschutzFrei = 0;	// wird aus DB gesetzt, wenn Teil mit Rohmass und keine Gewindestange
	this.strFertigungsverfahren  = "";	// wird aus DB gelesen
    this.RMMaxLaenge = 0;
    this.RMMaxBreite = 0;

};


EasyKat.extend(Sonderteil, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);

        // Einfache Variablen einlesen, je nach Typ
        this.RHTyp          = getstring("RHTyp",strPath);
        this.bAssistent     = getdouble("bAssistent",strPath);
        this.nAnzahl        = getdouble("nAnzahl",strPath);

        var row_anz = getdouble("ARTTXT.ROW_ANZ", strPath);
        for(i = 0; i < row_anz; i++)
            this.Artikeltext.push(getstring("ARTTXT.TEXTS.ROW["+i+"].TEXT", strPath));

        this.WIMatnr        = getstring("WIMatnr",strPath);
        this.Produktgruppe  = getstring("Produktgruppe",strPath);
        this.Typ            = getstring("Typ",strPath);
        this.Art            = getstring("Art",strPath);
        this.Select1        = getstring("Select1",strPath);
        this.Select2        = getstring("Select2",strPath);
        this.Select3        = getstring("Select3",strPath);
        this.Select4        = getstring("Select4",strPath);
        this.Select5        = getstring("Select5",strPath);
        this.RMLaenge       = getdouble("RMLaenge",strPath);
        this.RMBreite       = getdouble("RMBreite",strPath);

		this.bOberflaechenschutzFrei = getdouble("bOberflaechenschutzFrei",strPath);	
		this.strFertigungsverfahren  = getstring("strFertigungsverfahren",strPath);
		this.RMMaxLaenge = getdouble("RMMaxLaenge",strPath);
		this.RMMaxBreite = getdouble("RMMaxBreite",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Sonderteil");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen

        setstring("RHTyp",          strPath, this.RHTyp);
        setdouble("bAssistent",     strPath, this.bAssistent);
        setdouble("nAnzahl",        strPath, this.nAnzahl);
        
        setdouble("ARTTXT.ROW_ANZ", strPath, this.Artikeltext.length);
        for(i = 0; i < this.Artikeltext.length; i++)
            setstring("ARTTXT.TEXTS.ROW["+i+"].TEXT", strPath, this.Artikeltext[i]);

        setstring("WIMatnr",        strPath, this.WIMatnr);
        setstring("Produktgruppe",  strPath, this.Produktgruppe);
        setstring("Typ",            strPath, this.Typ);
        setstring("Art",            strPath, this.Art);
        setstring("Select1",        strPath, this.Select1);
        setstring("Select2",        strPath, this.Select2);
        setstring("Select3",        strPath, this.Select3);
        setstring("Select4",        strPath, this.Select4);
        setstring("Select5",        strPath, this.Select5);
        setdouble("RMLaenge",       strPath, this.RMLaenge);
        setdouble("RMBreite",       strPath, this.RMBreite);

        setdouble("bOberflaechenschutzFrei",       strPath, this.bOberflaechenschutzFrei);
        setstring("strFertigungsverfahren",        strPath, this.strFertigungsverfahren);
        setdouble("RMMaxLaenge",       strPath, this.RMMaxLaenge);
        setdouble("RMMaxBreite",       strPath, this.RMMaxBreite);
    },

    Init : function( )
    {
        // this.groesse        = groe;


        return(1);
    },

    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert
        delete(storepath,"");


        return 1;
    },

	makeTyp : function()
	{

        return this.m_Ptyp;

	},

	fromTyp : function(strTyp)
	{
        var bOK = false;

        return(bOK ? "" : "ERR");
	},

	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        // TODO: Vorgabepreis oder Preis aus Matnr ...
        // this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_KH1");

        return this.m_Ppreis;
	},

    getTopoPic : function(Drehung)
    {
        // TODO: Topopictures fr die LK-Teil-Surrogate ...
        var strPic = "catalog/client/custom/img/prinzip/H.png";
        /*
        if (this.m_Ptypid != "")
        {
            var strTeilPic = this.m_Ptypid;
            if (Drehung == 90)
                strTeilPic = strTeilPic + "_S1";
            else if (Drehung == 180)
                strTeilPic = strTeilPic + "_S2";
            else if (Drehung == 270)
                strTeilPic = strTeilPic + "_S3";

            strPic = "catalog/client/custom/img/panels/T"+strTeilPic+".png";
        }
        */
        return strPic;
    },

    isSAPKonfigurierbar : function()
    {
        return 0;
    },

    getSAPKlassenName : function()
    {
        // TODO: Wird das berhaupt gebraucht bei fester Matnr?
        var strKlasse = "";  // Default

        return strKlasse;
    },

    getSAPTyp : function()
    {
        // TODO: Wird das berhaupt gebraucht bei fester Matnr?
        return "";  // this.m_Ptypid;
    },

    getASTLDaten : function(theMainController)
    {
        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        // Sonderteil ist nie konfigurierbar
        // retObj.loeseauf = this.isSAPKonfigurierbar();

        // TODO: Infos belegen anhand Eingabe, insbes auch aTexte ...
        // var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        
        retObj.matnr  = this.WIMatnr;
        retObj.aTexte = this.Artikeltext;

        retObj.postext1 = utf8toansi(this.m_Ptyp);
		
		// -Schu- es gab einen Fehler bei nderung Rohmass-"Assi"-Teil zu "Freier Eingabe"
		// hier blieben die Rohmasse erhalten -> ist gendert, muss aber fr bereits ausgelegte
		// Projekte hier noch abgefangen werden
		if (atoi(this.bAssistent)){
			if (this.RMLaenge > 0)
			{
				retObj.rm1 = this.RMLaenge;
				//retObj.formelzeichen = "L1";
				retObj.formelzeichen = "LB";
			}
			if (this.RMBreite > 0)
			{
				retObj.rm2 = this.RMBreite;
				//retObj.formelzeichen = "L1";
				retObj.formelzeichen = "LB";
			}
			if ((this.RMLaenge > 0) && (this.RMBreite > 0))
				//retObj.formelzeichen = "F1";
				retObj.formelzeichen = "FE";
				
			if ((this.RMLaenge > 0) || (this.RMBreite > 0))
			{
				retObj.rm_einheit = "MM";
				retObj.postyp = "R";
			}
        }
		
        return retObj;
	},

    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
        // TODO: CADInfos fr die LK-Teil-Surrogate ...

		var aParams = new Array();

        if (nTyp == "E")
            aParams.push( [ "Typ", "" + this.m_Ptypid ] );
        else aParams.push( [ "Position" + nStartPos, "" + this.m_Ptypid ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );


        return( [ aParams, nPosNr + 1 ] );
    }

});
