/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2011 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Lager constructor
 */
Rollenlager2 = function( ) {

	Rollenlager2.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	this.oData = null;
};


EasyKat.extend( Rollenlager2, Produkt, {

	init :  function( oDlgLager, oData,strMode )
	{
		this.oData 		= oData;		
		this.strMode 	= strMode;
		
		// korrigiere Variablen der Oberklasse
		this.m_Ptyp 			= this.oData.TYP_CALCULATION ? this.oData.TYP_CALCULATION :this.oData.TYP;
		this.m_Ptypid 			= left( this.oData.TYP, 3 );
		//this.m_Ppreis 			= (getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927") ? 0 : this.oData.PREIS;
		this.m_Ppreis 			= this.oData.PREIS_Tab;
		this.m_PIdentNr		 	= this.oData.IDENT;
		this.m_Pgewicht 		= this.oData.GEW;
		this.m_Pwerkstoff 		= Base.getLanguageTextWerkstoff(this.oData.WERKSTOFF).strTextID;
		if (this.oData.OBFL == "")
			this.m_Poberfl 		= this.getOberFlaechenSchutzDefault();
		else
			this.m_Poberfl 		= Base.getLanguageTextOberflaeche(this.oData.OBFL).strTextID;
		this.strBaureihe 		= this.m_Ptypid;						// etwas sprechender
		this.strBauF	 		= this.oData.BAU_F;
		this.m_Pemass 			= RoundDoubleToInt( this.oData.Y );   	// -mw- wird auch gebraucht
	},
	
	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da

        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );

		// Variablen dieser Klasse
		this.oData = Object.fromStorage( strPath+ ".LAGERDATA" );

		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strBauF	 = getstring( "strBauF", strPath );
		this.strMode	 = getstring("strMode",strPath);
		
        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Rollenlager2" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen dieser Klasse
		this.oData.toStorage(strPath+ ".LAGERDATA", false);   // kein merge

		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strBauF", strPath, this.strBauF );
		setstring( "strMode",strPath,this.strMode);
    },


	/**
     * berechne die Defaultwert fr den Oberflchenschutz des Lagers (mgliche Schutzarten: siehe CascadeProdukt.es, globales Objekt 'MoeglicherOberflaechenschutz')
	 *
	 * @params -
	 * @returns	integer index der Oberflchenschutzgruppe
	 */
	getOberFlaechenSchutzGruppe : function()
	{
		var nGruppe = 0; // default: '-'

		// dieses %$&$"& DataAccessObject steht manchmal noch nicht zur Verfgung, wenn die Klasse durch Serialisierung erzeugt wird
		// deswegen mu hier der Store direkt abgefragt werden
		var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

		// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
		var expert_mode = getint ("EXPERT_MODE", "RIGHTS");
		
		if ( dTemperatur <= 300 )
		{
			if ( left( this.strTyp, 3 ) == 'LUR' || expert_mode == 1)	// alter Loslagertyp 'LUR' hat mehr Varianten / -Schu- fuer alle Varianten im Expert Mode
				nGruppe = 11;		// roh, feuerverzinkt und grundiert
			else nGruppe = 8;		// nur feuerverzinkt
		}
		else if ( dTemperatur <= 450 )
		{
			nGruppe = 3;		// roh und grundiert
			// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
			if ( substr( this.strTyp, 1, 1 ) == "I" )
				nGruppe = 8;	// nur feuerverzinkt
		}
		else if ( dTemperatur > 450 )
			nGruppe = 3;		// roh und grundiert

		return( nGruppe );
	},

	/**
     * berechne die Oberflchenschutzgruppe fr das Lager (mgliche Gruppen: siehe CascadeProdukt.es, globales Objekt 'Oberflaechenschutz')
	 *
	 * @params -
	 * @returns	string Oberflchenschutz
	 */
	getOberFlaechenSchutzDefault : function()
	{
		var strSchutz = 'OB_SONST'; // default: 'sonstiger'

		if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' hat den Oberflchentyp schon in der Typbezeichnung
		{
			var strID = right( this.strTyp, 1 );
			if ( strID == '0' )
				strSchutz = 'OB_ROH';
			else if ( strID == '1' )
				strSchutz = 'OB_GALV';
			else if ( strID == '2' )
				strSchutz = 'OB_FEUER';
			else if ( strID == '3' )
				strSchutz = 'OB_GRUND';
			else if ( strID == '4' )
				strSchutz = 'OB_SONST';
			//else strSchutz = 'OB_SONST'; ist default
		}
		else
		{
			// dieses %$&$"& DataAccessObject steht manchmal noch nicht zur Verfgung, wenn die Klasse durch Serialisierung erzeugt wird
			// deswegen mu hier der Store direkt abgefragt werden
			var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

			// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
			if ( dTemperatur <= 300 )
				strSchutz = 'OB_FEUER';			// nur feuerverzinkt mglich
			else if ( dTemperatur <= 450 )
			{
				strSchutz = 'OB_ROH';		// roh
				// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
				if ( substr( this.strTyp, 1, 1 ) == "I" )
					strSchutz = 'OB_FEUER';		// nur feuerverzinkt mglich
			}
			else if ( dTemperatur > 450 )
				strSchutz = 'OB_ROH';		// roh
		}

		return( strSchutz );
	},
	/**
     * bestimme die Typbezeichnung des Lagers und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Lagers
	 */
	makeTyp : function()
	{

		// Mass-String fr STK-Export:
		this.m_strMasse  = " TrT " + this.strTraegertyp + " Brt " + this.strTraegerbreite + " TrH " + this.strTraegerhoehe + " Tg10 " + this.strFlanschdicke;
		this.m_strMasse += " BAU_F " + this.strBauF + " DN " + this.strDN + " D " + this.strD + " DM " + this.strDM + " H " + this.strH + " H_REAL " + this.strH_REAL;
		this.m_strMasse += " L " + this.strL + " B_AF " + this.strB_AF +  " GL_U " + this.strGL_U + " S_L " + this.strS_L + " WX " + this.strWX + " WY " + this.strWY + " GEW " + this.strGEW + " WERK_ " + this.strWerk;
		this.m_strMasse += " E " + this.strE + " A " + this.strA + " B " + this.strB + " C " + this.strC + " TF " + this.strTF + " SCH_V " + this.strSCH_V + " SCH_A " + this.strSCH_A; 
		this.m_strMasse += " B_PL " + this.strB_PL + " ANZ_PL " + this.strAnz_PL + " ANZ_GEWST " + this.strAnz_Gewst + " L_PL " + this.strL_PL + " LAB " + this.strLAB;
		this.m_strMasse += " CS " + this.strCS + " AS " + this.strAS + " BS " + this.strBS + " SS " + this.strSS + " DS " + this.strDS + " FS " + this.strFS + " D2 " + this.strD2 + " S2 " + this.strS2;
		this.m_strMasse += " ANZ_LG " + this.strANZ_LG + " ABST_LG " + this.strABST_LG + " E_LG " + this.strE_LG + " A_LG " + this.strA_LG + " B_LG " + this.strB_LG + " L_LG " + this.strL_LG;
		this.m_strMasse += " L1L " + this.strL1L + " L1R " + this.strL1R + " L2L " + this.strL2L + " L2R " + this.strL2R + " L3L " + this.strL3L;
		this.m_strMasse += " L3R " + this.strL3R + " L4L " + this.strL4L + " L4R " + this.strL4R + " H1L " + this.strH1L + " H1R " + this.strH1R;
		this.m_strMasse += " H2L " + this.strH2L + " H2R " + this.strH2R + " H3L " + this.strH3L + " H3R " + this.strH3R + " BKL " + this.strBKL + " BKR " + this.strBKR;

        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function(strTyp)
	{
		var strTypNr = [];
		var strDim = [];
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.strBaureihe = this.m_Ptypid;
		this.m_Poberfl = "";

        this.temperatur = "20";
        this.daemmdicke = "-";

		this.wx = "-";
		this.wy = "-";
		this.m_fz = "-";
		this.fz = "-";
		this.m_fx = "-";
		this.fx = "-";
		this.fy = "-";

	// Suche in DBs

		strTypNr = splitVarDelimiter(strTyp, " ..-..");
		var lenNr = strTypNr.length;

		var strWhere1 = "", strWhere2 = "";
		var strProfil = "", strProfilSave = "", strB = "", strH = "", strD = "";
		var strWerkstoff = "", strOberfl = "", strKlemm = "";
		var strTypSuchNr = this.m_Ptypid + " " +
			getVarDelimited(strTypNr, 1) + "." +
			getVarDelimited(strTypNr, 2) + "." +
			getVarDelimited(strTypNr, 3);

		if(lenNr > 4)
		{
			strKlemm = getVarDelimited(strTypNr, 4);
			strProfil = left(strKlemm, 1);
			if(find("TUL", strProfil) == -1)
			{
				strProfil = "";
				strKlemm = "";
			}
			strProfilSave = strProfil;

			// b x h x d aufsplitten
			if(find(getVarDelimited(strTypNr, 4), "x") > -1)
				strDim = splitVarDelimiter(strKlemm, "xx");

			if(strProfil != "")
				strTypSuchNr += "-" + strProfil + "XXX";
			else if(strKlemm!="")
				strTypSuchNr += "-" + strKlemm;

			if(find(strKlemm, "x") > -1)
				strTypSuchNr += "xXXX";
		}

		// Werkst+OberflSch als 2.Mglichkeit in Suche einbeziehen
		if(lenNr > 6)
		{
			// alles eingegeben
			strWerkstoff = getVarDelimited(strTypNr, 5);
			strOberfl = "." + getVarDelimited(strTypNr, 6);
		}
		else if(lenNr > 5 && strProfil == "")
		{
			// Profilart fehlt
			strWerkstoff = getVarDelimited(strTypNr, 4);
			strOberfl = "." + getVarDelimited(strTypNr, 5);
		}
		else if(lenNr > 5)
		{
			// Oberflchenschutz fehlt
			strWerkstoff = getVarDelimited(strTypNr, 5);
			// Default 2
			strOberfl = ".2";
		}
		else
		{
			// Default 37.2
			strWerkstoff = "37";
			strOberfl = ".2";
		}

		strWhere1 = "TYP = '" + strTypSuchNr + "'";
		if(strWerkstoff + strOberfl != "")
			strWhere2 = " OR TYP = '" + strTypSuchNr + "-" + strWerkstoff + strOberfl + "'";

	// Profil Default
		if(strProfil == "")
		{
			strProfilSave = "T";
			strKlemm = "T140";
		}

	// alle mglichen VAR_KLEMM suchen
		if(strProfilSave != "")
		{
			var aTrae = [ "T_PROFIL", "HEA", "HEB", "INP", "IPE", "L_PROFIL_G", "L_PROFIL_U", "U_PROFIL" ];
			var strSelectTrae = "";
			var i;
			for(i = 0; i < aTrae.length; i++)
			{
				strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] +
					" WHERE VAR_KLEMM='" + strKlemm + "'";
				if(i < aTrae.length-1)
					strSelectTrae += " UNION ";
			}
			strSelectTrae += " order by VAR_KLEMM";		//TAB,

			if(dbselect("LAGER", strSelectTrae, "TYPSUCHE_TRAE") == 0)
				return "Falscher Wert: "+strKlemm;
		}

		var strSelect = "SELECT * FROM " + this.m_Ptypid + " WHERE " + strWhere1 + strWhere2;
		if ( this.m_Ptypid == 'LUR' )
		{
			// andere Systematik fr alte Loslager: Typschlssel ist auch Typ in der Datenbank,
			// andere Mglichkeiten bei Oberflchenschutz und Werkstoff werden dadurch gleich mitbehandelt
			strSelect = "SELECT * FROM LSL WHERE " + strWhere1 + strWhere2;
		}
		if(dbselect("LAGER", strSelect, "TYPSUCHE_LAGER"))
		{
			// -mw- 12.5.2015: Den nachfolgenden Aufruf auskommentiert, weil die Funktion in Lager2 NICHT IMPLEMENTIERT ist. Es gibt die Funktion in Klasse Lager
			// this._leseDatenAusDB("TYPSUCHE_LAGER");
			this.strBasistyp = dbgetstring("TYPSUCHE_LAGER", "TYP");
			this.strBaureihe = left( this.strBasistyp, 3 );
            this.strHoeheAct = this.strH;
		}
		else
			return "Kein Produkt gefunden !";

	// Daten aus Typnummer
		this.m_Poberfl = 0;
		if(lenNr > 6 || (strProfil == "" && lenNr > 5))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-2));
			this.strWerkstoffOberfl = this.strWerk + "." + getVarDelimited(strTypNr, (lenNr-1));
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, (lenNr-1))];
		}
		else if(lenNr > 5 || (strProfil == "" && lenNr > 4))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-1));
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}
	//Defaults
		else
		{
			this.strWerk = "37";
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}

	// evtl. auch mit Defaults berechnet
		if(strProfilSave != "")
		{
			this.strProfilart = dbgetstring("TYPSUCHE_TRAE", "TAB");
			this.strTraegergroesse = dbgetstring("TYPSUCHE_TRAE", "TRAE_GR");
			this.strTraegerbreite = dbgetstring("TYPSUCHE_TRAE", "B");
			this.strTraegerhoehe = dbgetstring("TYPSUCHE_TRAE", "H");
			this.strFlanschdicke = dbgetstring("TYPSUCHE_TRAE", "TG");
		}

		//this.m_Pemass = RoundDoubleToInt(this.strE);   // -mw- wird auch gebraucht

		//this._korrigiereWerkstoffOberflaeche();
		//var oDaten = Cascade.Lagerkonfiguration.holeTraegerdaten( this.strProfilart, this.strTraegergroesse, this );

        this.getPreis();

        return( bOK ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Lagers, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 *         bool bIsEinzel - Einzelprodukt (true) oder Lastkette (false)
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung, bIsEinzel )
    {
		if ( bIsEinzel )
		{
			var strFile = '';
			if ( this.oData.BAUFO )
				strFile = "catalog/client/custom/img/WITgifs/RH/" + this.oData.BAUFO + ".jpg";
			else 
				strFile += 'catalog/client/custom/img/panels/TEMPTY.png';
			
			return( strFile );
		}

        if ( ( Drehung == 90 ) || ( Drehung == 270 ) )
			return ( "catalog/client/custom/img/panels/THAN_S.png" );
		return ( "catalog/client/custom/img/panels/THAN.png" );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Lagers sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Lagers delegieren
		this.serializeOut( strPath );

        return 1;
    },

	/**
     * bestimme den Preis des Lagers und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	double: Preis des Lagers
	 */
	getPreis : function(oOptions)
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );
		
		// Schu 20211105	- Preise IMMER aus Grunddaten berechnen
		//					- bei Anpassungen wird sonst immer der "alte" Preis behalten!!!
		
		var strSQLStatement = 'select * from "' + this.m_Ptypid + '" where "TYP" = "' + this.oData.TYP + '" ';
		var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS_RL");
		this.oData.PREIS	= (numRet == 1 ? dbgetdouble("PREIS_RL", "PREIS") : 0);
		
		this.m_Ppreis	= this.oData.PREIS;
		var dPreis		= this.m_Ppreis;
        
		if (oOptions.SONDERANSTRICH_KOSTEN > 0)
            dPreis = inputStringToDouble(this.m_Ppreis) + (oOptions.SONDERANSTRICH_KOSTEN * inputStringToDouble(this.m_Pgewicht));
			
		dPreis = Base.getPrice(dPreis, "RABATT_TYP_LAGER");
		
        return( dPreis );
	},

	/**
     * prft, ob das Lager in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function(oProfil)
    {
		// Lager ist dann in SAP konfigurierbar, wenn Profilart und Trgergre whlbar sind
		// @@@@@@@@@@@@@@@ var bIsConfigurable = this.isConfigurable();
		var bIsConfigurable = false;

		// nderungen daran hier einfgen
		if (bIsConfigurable && (oProfil.strProfilform == "T") && (oProfil.strTraegerbreite == "140"))
            bIsConfigurable = false;
        if ((this.m_Ptypid == "LSW") || (this.m_Ptypid == "LXA") || (this.m_Ptypid == "LXV"))
            bIsConfigurable = true;
        
        return( bIsConfigurable ? 1 : 0 );
    },

	/**
     * holt den SAP-Klassennamen des Lagers
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
		var strKlasse = '';

		// unterschiedlicher SAPKlassenname je nach Lagerbaureihe
		// ACHTUNG: PA und ST haben verschiedene Klassen!!!
		if (toupper(this.oData.WERKSTOFF_ROLLE) == 'ST')
		{
			if ( this.strBaureihe == 'RDF' )
				strKlasse = 'DZN';
			else if ( this.strBaureihe == 'RDL' )
				strKlasse = 'DZV';
			else if ( this.strBaureihe == 'RZG' )
				strKlasse = 'ZRA';
			else if ( this.strBaureihe == 'RZL' )
				strKlasse = 'ZRN';
			else if ( this.strBaureihe == 'RKF' )
				strKlasse = 'DKN';
			else if ( this.strBaureihe == 'RKL' )
				strKlasse = 'DKV';
			else alert( 'Baureihe ' + this.strBaureihe + ' hat keine SAP-Klasse' );
		}
		else
		{
			if ( this.strBaureihe == 'RDF' )
				strKlasse = 'DPN';
			else if ( this.strBaureihe == 'RDL' )
				strKlasse = 'DPV';
			else if ( this.strBaureihe == 'RZG' )
				strKlasse = 'ZPA';
			else if ( this.strBaureihe == 'RZL' )
				strKlasse = 'ZPN';
			else if ( this.strBaureihe == 'RKF' )
				strKlasse = 'KPN';
			else if ( this.strBaureihe == 'RKL' )
				strKlasse = 'KPV';
			else alert( 'Baureihe ' + this.strBaureihe + ' hat keine SAP-Klasse' );
		}

        return( strKlasse );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Lagertyp in SAP
	 */
    getSAPTyp : function()
    {
        return( this.strBaureihe );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];
// @@@@		var oProfil = Cascade.Lagerkonfiguration.holeProfilformUndTraegerbreiteFuerDB( this );		// @@@@@@@@@@@@@@@@@
		var oProfil = {
			strTraegerbreite : '',
			strProfilform : ''
		}
		var strSAPTyp = this.strBaureihe + ' ' + this.strBauF;

        retObj.loeseauf = this.isSAPKonfigurierbar(oProfil);

        var oOptions = theMainController.presets.getPreisOptions();
        if (oOptions.SONDERANSTRICH_TEXT != "")
            sapOberflaechenschutz = "0";

		if ( ( strKlasse == 'ZRN' ) || ( strKlasse == 'ZPN' ) || ( strKlasse == 'ZRA' ) || ( strKlasse == 'ZPA' ) )
		{
			// NENNGROESSE, NENNLAST, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
			searchObj = {
				NENNGROESSE: right(this.oData.BAU_F, 2)*1,
				NENNLAST: this.oData.F_NENN,
				OBERFLAECHENSCHUTZ: this.oData.OBFL,
				WERKSTOFF: toupper(this.oData.WERKSTOFF_ROLLE),
				TYP: strBaureihe
			};
		}
		else if ( ( strKlasse == 'KPV' ) || ( strKlasse == 'DKV' ) || ( strKlasse == 'DPV' ) || ( strKlasse == 'DZV' ) )
		{
			// NENNGROESSE, NENNLAST, AUFL_DMR_MIN, AUFL_DMR_MAX, WEGGROESSE, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
			searchObj = {
				NENNGROESSE: right(this.oData.BAU_F, 2)*1,
				NENNLAST: this.oData.F_NENN,
				AUFL_DMR_MIN: this.oData.DA_MIN,
				AUFL_DMR_MAX: this.oData.DA_MAX,
				WEGGROESSE: this.oData.W_QUER_NENN,
				OBERFLAECHENSCHUTZ: this.oData.OBFL,
				WERKSTOFF: toupper(this.oData.WERKSTOFF_ROLLE),
				TYP: strBaureihe
			};
		}
		else if ( ( strKlasse == 'KPN' ) || ( strKlasse == 'DKN' ) || ( strKlasse == 'DPN' ) || ( strKlasse == 'DZN' ) )
		{
			// NENNGROESSE, NENNLAST, AUFL_DMR_MIN, AUFL_DMR_MAX, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
			searchObj = {
				NENNGROESSE: right(this.oData.BAU_F, 2)*1,
				NENNLAST: this.oData.F_NENN,
				AUFL_DMR_MIN: this.oData.DA_MIN,
				AUFL_DMR_MAX: this.oData.DA_MAX,
				OBERFLAECHENSCHUTZ: this.oData.OBFL,
				WERKSTOFF: toupper(this.oData.WERKSTOFF_ROLLE),
				TYP: strBaureihe
			};
		}
		
        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;

        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if ( this.isSAPKonfigurierbar(oProfil) )
            retObj.postext1 = this.m_Ptyp;

        return( retObj );
	},

	/**
     *  hole Subtyp des Lagers (Baureihe + erste Ziffer der Nennhhe + optional Trgerform)
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		// derzeit nich notwendig
		var strSubtyp	= 'RL';
		return( strSubtyp );
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Lagers
	 *
	 * @params integer nStartPos - startposition des Lagers in der Lastkette
	 *         integer nPosNr - Position des Lagers in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Lagers beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = this.strBaureihe + this.strBauF;
        if (this.m_Ptypid == "LUR")
            strTypForCAD = "LUR";
        
        /* Daemmung wird ber Men geregelt:
		var strDaemmungForCAD = '0';
		if ( this.strDaem.indexOf( 'w' ) > -1 )	// vorisoliert und wrmegedmmt
			strDaemmungForCAD = '1';
        */
		var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';

		var strHMass = this.strH_REAL
		if (strHMass == "")		// 02/2009: weil dieser Wert erst spter dazu kam ... Kompatibilitt zu lteren Versionen
			strHMass = this.strH;

		var strEMass = this.strE;

		// Hhenbereiche fr hhenverstellbare Lager
		var strHoehenbereich = 'H1';
		var data = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER_AUSWAHL" );
		if ( data.IDC_HOEHENVERSTELLUNG )
		{
			// Zuordnung zu den Hhenbereichen gemaess Vorgabe -schm- 16.4.2008
			if ( atoi(this.strH) <= 100 )
				strHoehenbereich = 'H1';
			else if ( atoi(this.strH) <= 150 )
				strHoehenbereich = 'H2';
			else strHoehenbereich = 'H3';
			
			strHMass = this.strHoeheAct;
			strEMass = RoundDoubleToInt (int(strHMass) + this.strD / 2);
			this.m_Pemass = RoundDoubleToInt( strEMass );   // -mw- wird auch gebraucht
		}
		

		// setze CAD-Parameter
        if (nTyp == "E")
            aParams.push( [ "Typ", "" + strTypForCAD ] );
        else aParams.push( [ "Position" + nStartPos, "" + strTypForCAD ] );
        // aParams.push( [ "Typ", strTypForCAD ] );
        // aParams.push( [ "Daemmung", strDaemmungForCAD ] );
        aParams.push( [ "Rohraussendurchmesser", this.strD ] );
        aParams.push( [ "DM", this.strDM ] );
        aParams.push( [ "E-Mass", this.strE ] );
        aParams.push( [ "E-Mass1", this.strE ] );
        aParams.push( [ "E-Mass2", this.strE ] );
        aParams.push( [ "E-Mass3", this.strE ] );
        aParams.push( [ "E-Mass4", this.strE ] );
        aParams.push( [ "H-Mass",  strHMass ] );
        aParams.push( [ "H-Mass1", strHMass ] );
        aParams.push( [ "H-Mass2", strHMass ] );
        aParams.push( [ "H-Mass3", strHMass ] );
        aParams.push( [ "H-Mass4", strHMass ] );
        aParams.push( [ "Daemmdicke", this.daemmdicke ] );  // this.strJ - hier soll die gewnschte, nicht die maximale Dmmung ausgegeben werden
        aParams.push( [ "Hoehenbereich", strHoehenbereich ] );
        /*
		if ( this.strS_L == '0' )
			aParams.push( [ "Schellenwinkel", "0" ] );		// Schelle horizontal
		else aParams.push( [ "Schellenwinkel", "45" ] );	// Schelle 30-45 gedreht
        */
        // -mw- 04/2008: Neue Vorgabe -schm-
        if ((this.m_Ptypid == "LKF") || (this.m_Ptypid == "LSF"))
			aParams.push( [ "Schellenwinkel", "45" ] );		// Schelle 30-45 gedreht
		else aParams.push( [ "Schellenwinkel", "0" ] );	    // Schelle horizontal
        aParams.push( [ "Werkstoff", this.strWerk ] );
        aParams.push( [ "Tr-Typ", strTraegerID ] );
        aParams.push( [ "Tr-Typ1", strTraegerID ] );
        aParams.push( [ "Tr-Typ2", strTraegerID ] );
        aParams.push( [ "Tr-Typ3", strTraegerID ] );
        aParams.push( [ "Tr-Typ4", strTraegerID ] );
        aParams.push( [ "Btr", this.strTraegerbreite ] );
        aParams.push( [ "Btr1", this.strTraegerbreite ] );
        aParams.push( [ "Btr2", this.strTraegerbreite ] );
        aParams.push( [ "Btr3", this.strTraegerbreite ] );
        aParams.push( [ "Btr4", this.strTraegerbreite ] );
        aParams.push( [ "Htr", this.strTraegerhoehe ] );
        aParams.push( [ "Htr1", this.strTraegerhoehe ] );
        aParams.push( [ "Htr2", this.strTraegerhoehe ] );
        aParams.push( [ "Htr3", this.strTraegerhoehe ] );
        aParams.push( [ "Htr4", this.strTraegerhoehe ] );
        aParams.push( [ "tG", this.strFlanschdicke ] );		// ist das identisch zur Gurtdicke? Ja.
        aParams.push( [ "tG1", this.strFlanschdicke ] );
        aParams.push( [ "tG2", this.strFlanschdicke ] );
        aParams.push( [ "tG3", this.strFlanschdicke ] );
        aParams.push( [ "tG4", this.strFlanschdicke ] );

        aParams.push( [ "LAB", this.strLAB ] );

        aParams.push( [ "ANZ_LG", this.strANZ_LG ] );
        aParams.push( [ "ABST_LG", this.strABST_LG ] );
        aParams.push( [ "E_LG", this.strE_LG ] );
        aParams.push( [ "A_LG", this.strA_LG ] );
        aParams.push( [ "B_LG", this.strB_LG ] );
        aParams.push( [ "L_LG", this.strL_LG ] );

        return( [ aParams, nPosNr + 1 ] );
    }
	
	
});
