/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2011 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Lager constructor
 */
Lager2 = function( ) {

	Lager2.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	this.oData = null;
};


EasyKat.extend( Lager2, Produkt, {

	init :  function( oDlgLager, oData )
	{
		this.oData = oData ? oData : oDlgLager.AuswahlStandard.oSearchResult.oResultLager;
		
		// wichtig: das zuerst, da Funktionen unten auf diese Daten zugreifen!
		this.dTemperaturMedium  = oDlgLager.SollwerteRohrumTeil.dTemperaturMedium;
		this.bHoehenverstellbar = oDlgLager.AuswahlStandard.bHoehenverstellbar;
		this.bSonderAbMessung   = oDlgLager.AuswahlStandard.bSonderAbMessung;

		// korrigiere Variablen der Oberklasse
		this.m_Ptyp 		= this.oData.TYP_CALCULATION ? this.oData.TYP_CALCULATION :this.oData.TYP;
		this.m_Ptypid 		= left( this.oData.TYP, 3 );
		this.m_Ppreis 		= this.oData.PREIS_Tab;
		
		this.m_PIdentNr 	= this.oData.IDENT;
		this.m_Pgewicht 	= this.oData.GEW;
		this.m_Pwerkstoff 	= Base.getLanguageTextWerkstoff(this.oData.WERKSTOFF).strTextID;
		
		if (this.m_Pwerkstoff == "W_RST")
			this.m_Pzusinfo = "2.2";
        else
			this.m_Pzusinfo = "3.1B";
		
		if ((this.oData.OBFL == "") || (! this.oData.OBFL)) {
			if (oDlgLager.AuswahlStandard.strSelComboGroundLevel)
				this.m_Poberfl = Base.getLanguageTextOberflaeche(oDlgLager.AuswahlStandard.strSelComboGroundLevel).strTextID;
			else
				this.m_Poberfl = Base.getOberFlaechenSchutzDefault(this);
		}
		else
			this.m_Poberfl = Base.getLanguageTextOberflaeche(this.oData.OBFL).strTextID;
		
		this.strBaureihe	= this.m_Ptypid;	// etwas sprechender
		this.strBauF	 	= this.oData.BAU_F;
		this.m_Pemass 		= RoundDoubleToInt( this.oData.E );   // -mw- wird auch gebraucht
		
		this.anzGleitelemente = 0;
		if(this.oData.ANZ_LGX)
			this.anzGleitelemente = (this.oData.ANZ_LGX - 0);
			// this.m_qty = this.oData.ANZ_LGX;
		
		// Generell: Bei Los- und Fhrungslagern wird das Klemmsystem nun separat erfasst.
		// Bei Festlagern sind die Klemmungen nachwievor im Lager integriert. Hier gibt es auch
		// nur Klemmungen fr T-Trger.
	
	},
	
	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da
		
        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );
		
		// Variablen dieser Klasse
		this.oData = Object.fromStorage( strPath+ ".LAGERDATA" );
		
		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strBauF	 = getstring( "strBauF", strPath );
		
		this.dTemperaturMedium = getdouble( "dTemperaturMedium", strPath );
		
		this.m_bSonderNennweite	= getstring("bAussenDuMesserSonder", "DLGDATA.CA.FORMS.LAGER2DATA.SollwerteRohrUmTeil");
		
		this.anzGleitelemente  = getdouble( "anzGleitelemente", strPath );
		
        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Lager2" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen dieser Klasse
		this.oData.toStorage(strPath+ ".LAGERDATA", false);   // kein merge

		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strBauF", strPath, this.strBauF );

		setdouble( "dTemperaturMedium", strPath, this.dTemperaturMedium );
		
		setdouble( "anzGleitelemente", strPath, this.anzGleitelemente );

    },

	/**
	 * --KOMMT HIER WIEDER RAUS - FUNKTION IST IN Base.getLanguageTextOberflaeche zu finden ---
     * berechnet den Oberflaechenschutz fr das Lager
	 *
	 * @params -
	 * @returns	string berechneter Oberflaechenschutz
	 */
	_berechneOberflaechenschutz : function(strObfl)
	{
		var strOberflaechenschutz = 'OB_SONST';
		
		// Oberflchenschutz sollte in DB spezifiziert sein, wenn nicht
		// wird er mit einem Default belegt ....
		if (strObfl == "")
			strOberflaechenschutz = this.getOberFlaechenSchutzDefault();
		else
		{
			if ( strObfl == '0' )
				strOberflaechenschutz = 'OB_ROH';
			else if ( strObfl == '1' )
				strOberflaechenschutz = 'OB_GALV';
			else if ( strObfl == '2' )
				strOberflaechenschutz = 'OB_FEUER';
			else if ( strObfl == '3' )
				strOberflaechenschutz = 'OB_GRUND';
			else if ( strObfl == '4' )
				strOberflaechenschutz = 'OB_SONST';
		}

		return( strOberflaechenschutz );
	},


	/**
	 * ???? WOFR und wo wird diese aufgerufen ???
     * berechne die Defaultwert fr den Oberflchenschutz des Lagers (mgliche Schutzarten: siehe CascadeProdukt.es, globales Objekt 'MoeglicherOberflaechenschutz')
	 *
	 * @params -
	 * @returns	integer index der Oberflchenschutzgruppe
	 */
	getOberFlaechenSchutzGruppe : function()
	{
		// -Schu- Oberflchenschutz ist abhngig vom Werkstoff und in DB definiert
		/*
		var nGruppe = 0; // default: '-'
		
		var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

		// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
		var expert_mode = getint ("EXPERT_MODE", "RIGHTS");
		
		if ( this.dTemperaturMedium <= 300 )
		{
			if ( left( this.strTyp, 3 ) == 'LUR' || expert_mode == 1)	// alter Loslagertyp 'LUR' hat mehr Varianten / -Schu- fuer alle Varianten im Expert Mode
				nGruppe = 11;		// roh, feuerverzinkt und grundiert
			else nGruppe = 8;		// nur feuerverzinkt
		}
		else if ( this.dTemperaturMedium <= 450 )
		{
			nGruppe = 3;		// roh und grundiert
			// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
			if ( substr( this.strTyp, 1, 1 ) == "I" )
				nGruppe = 8;	// nur feuerverzinkt
		}
		else if ( this.dTemperaturMedium > 450 )
			nGruppe = 3;		// roh und grundiert
		*/
		var Oberfl			= [];
		var strSQLStatement = "select * from Werkst_Obfl_Zuordnung where TYP = '"+this.strBaureihe+"' and abs(Werkstoff) = "+this.oData.WERKSTOFF+" ";
		var numRet			= dbselect("LAGER2", strSQLStatement, "OBERFL");
		if (!numRet){	// in der DB ist das Produkt nicht definiert
			Oberfl[0]	= this.m_Poberfl;
		}
		else{
			var actObfl			= dbgetdouble("OBERFL", "OBFL");
			Oberfl.push(OberflaechenschutzRevers["Ob" + dbgetdouble("OBERFL", "OBFL")]);
			for (var i=1; i<numRet; i++){
				strSQLStatement = "select * from Werkst_Obfl_Zuordnung where TYP = '"+this.strBaureihe+"' and abs(Werkstoff) = "+this.oData.WERKSTOFF+" and abs(OBFL) > "+actObfl+" ";
				dbselect("LAGER2", strSQLStatement, "OBERFL");
				Oberfl.push(OberflaechenschutzRevers["Ob" + dbgetdouble("OBERFL", "OBFL")]);
				actObfl			= dbgetdouble("OBERFL", "OBFL");
			}
		}
		Oberfl.push("OB_SONST");
		//return( nGruppe );
		return (Oberfl);
	},

	/**
	 * ------- WIRD IN BASE VERSCHOBEN - EINE FUNKTION FR ALLE PRODUKTE ------------ 
     * berechne die Oberflchenschutzgruppe fr das Lager (mgliche Gruppen: siehe CascadeProdukt.es, globales Objekt 'Oberflaechenschutz')
	 *
	 * @params -
	 * @returns	string Oberflchenschutz
	 */
	getOberFlaechenSchutzDefault : function()
	{
		var strSchutz = 'OB_SONST'; // default: 'sonstiger'

		if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' hat den Oberflchentyp schon in der Typbezeichnung
		{
			var strID = right( this.strTyp, 1 );
			if ( strID == '0' )
				strSchutz = 'OB_ROH';
			else if ( strID == '1' )
				strSchutz = 'OB_GALV';
			else if ( strID == '2' )
				strSchutz = 'OB_FEUER';
			else if ( strID == '3' )
				strSchutz = 'OB_GRUND';
			else if ( strID == '4' )
				strSchutz = 'OB_SONST';
			//else strSchutz = 'OB_SONST'; ist default
		}
		else
		{
			// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
			if ( this.dTemperaturMedium <= 300 )
				strSchutz = 'OB_FEUER';			// nur feuerverzinkt mglich
			else if ( this.dTemperaturMedium <= 450 )
			{
				strSchutz = 'OB_ROH';		// roh
				// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
				if ( substr( this.strTyp, 1, 1 ) == "I" )
					strSchutz = 'OB_FEUER';		// nur feuerverzinkt mglich
			}
			else if ( this.dTemperaturMedium > 450 )
				strSchutz = 'OB_ROH';		// roh
		}

		return( strSchutz );
	},

	/**
	 * --KOMMT HIER WIEDER RAUS - FUNKTION IST IN Base.getLanguageTextWerkstoff zu finden ---
     * berechnet den Werkstoff fr das Lager
	 *
	 * @params -
	 * @returns	string berechneter Werkstoff
	 */
	_berechneWerkstoff : function(strWerk)
	{
		var strWerkstoff = 'W_SONST';
        
        // -mw- 09/2007: Wenn Werkstoff in DB gewesen, dann diesen benutzen, sonst Default:
        if (strWerk == "37")
            strWerkstoff = "W_RST";
        else if (strWerk == "16")
            strWerkstoff = "W_15MO3";
        else if (strWerk == "13")
            strWerkstoff = "W_13CRMO";
        else if (strWerk == "10")
            strWerkstoff = "W_10CRMO";
        else if (strWerk == "41")
            strWerkstoff = "W_4541";
        else if (strWerk == "43")
            strWerkstoff = "W_4301";
        else if (strWerk == "71")
            strWerkstoff = "W_4571";
        else if (strWerk == "80")
            strWerkstoff = "W_INCOLOY";
        else if (strWerk == "91")
            strWerkstoff = "W_P91";

		return( strWerkstoff );
	},

	/**
     * bestimme die Typbezeichnung des Lagers und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Lagers
	 */
	makeTyp : function()
	{

		// Mass-String fr STK-Export:
		this.m_strMasse  = " TrT " + this.oData.strTraegertyp + " Brt " + this.oData.strTraegerbreite + " TrH " + this.oData.strTraegerhoehe + " Tg10 " + this.oData.strFlanschdicke;
		this.m_strMasse += " BAU_F " + this.oData.Bau_F + " DN " + this.oData.DN + " D " + this.oData.D + " DM " + this.oData.DM + " H " + this.oData.H;
		this.m_strMasse += " L " + this.oData.L + " B_AF " + this.oData.B_AF +  " GL_U " + this.oData.GL_U + " S_L " + this.oData.S_L + " WX " + this.oData.W_QUER + " WY " + this.oData.W_AXIAL + " GEW " + this.oData.GEW + " WERK_ " + this.oData.WERKSTOFF;
		this.m_strMasse += " E " + this.oData.E + " A " + this.oData.A + " B " + this.oData.B + " C " + this.oData.C + " TF " + this.oData.TF + " SCH_V " + this.oData.SCH_V + " SCH_A " + this.oData.SCH_A; 
		this.m_strMasse += " B_PL " + this.oData.B_PL + " ANZ_PL " + this.oData.Anz_PL + " ANZ_GEWST " + this.oData.Anz_Gewst + " L_PL " + this.oData.L_PL + " LAB " + this.oData.LAB;
		this.m_strMasse += " CS " + this.oData.CS + " AS " + this.oData.AS + " BS " + this.oData.BS + " SS " + this.oData.SS + " DS " + this.oData.DS + " FS " + this.oData.FS + " D2 " + this.oData.D2 + " S2 " + this.oData.S2;
		this.m_strMasse += " ANZ_LG " + this.oData.ANZ_LG + " ABST_LG " + this.oData.ABST_LG + " E_LG " + this.oData.E_LG + " A_LG " + this.oData.A_LG + " B_LG " + this.oData.B_LG + " L_LG " + this.oData.L_LG;
		this.m_strMasse += " L1L " + this.oData.L1L + " L1R " + this.oData.L1R + " L2L " + this.oData.L2L + " L2R " + this.oData.L2R + " L3L " + this.oData.L3L;
		this.m_strMasse += " L3R " + this.oData.L3R + " L4L " + this.oData.L4L + " L4R " + this.oData.L4R + " H1L " + this.oData.H1L + " H1R " + this.oData.H1R;
		this.m_strMasse += " H2L " + this.oData.H2L + " H2R " + this.oData.H2R + " H3L " + this.oData.H3L + " H3R " + this.oData.H3R + " BKL " + this.oData.BKL + " BKR " + this.oData.BKR;
		
		this.m_strMasse	= replace(this.m_strMasse, "undefined", "");
		this.m_strMasse	= replace(this.m_strMasse, "-", "");
		
        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function(strTyp)
	{
		// -Schu- Lagerauswahl "ALT" -> Flexperte 4
		/*
		var strTypNr = [];
		var strDim = [];
        var bOK = true;

        this.m_Ptyp = strTyp;		// -Schu- Typ ist hier noch nicht vollstndig
        this.m_Ptypid = left(strTyp, 3);

		this.strBaureihe = this.m_Ptypid;
		this.m_Poberfl = "";

        this.temperatur = "20";
        this.daemmdicke = "-";

		this.wx = "-";
		this.wy = "-";
		this.m_fz = "-";
		this.fz = "-";
		this.m_fx = "-";
		this.fx = "-";
		this.fy = "-";
		
		this.strBauF = "";

	// Suche in DBs
		strTypNr = splitVarDelimiter(strTyp, " ..-..");
		var lenNr = strTypNr.length;

		var strWhere1 = "", strWhere2 = "";
		var strProfil = "", strProfilSave = "", strB = "", strH = "", strD = "";
		var strWerkstoff = "", strOberfl = "", strKlemm = "";
		var strTypSuchNr = this.m_Ptypid + " " +
			getVarDelimited(strTypNr, 1) + "." +
			getVarDelimited(strTypNr, 2) + "." +
			getVarDelimited(strTypNr, 3);

		if(lenNr > 4)
		{
			strKlemm = getVarDelimited(strTypNr, 4);
			strProfil = left(strKlemm, 1);
			if(find("TUL", strProfil) == -1)
			{
				strProfil = "";
				strKlemm = "";
			}
			strProfilSave = strProfil;

			// b x h x d aufsplitten
			if(find(getVarDelimited(strTypNr, 4), "x") > -1)
				strDim = splitVarDelimiter(strKlemm, "xx");

			if(strProfil != "")
				strTypSuchNr += "-" + strProfil + "XXX";
			else if(strKlemm!="")
				strTypSuchNr += "-" + strKlemm;

			if(find(strKlemm, "x") > -1)
				strTypSuchNr += "xXXX";
		}

		// Werkst+OberflSch als 2.Mglichkeit in Suche einbeziehen
		if(lenNr > 6)
		{
			// alles eingegeben
			strWerkstoff = getVarDelimited(strTypNr, 5);
			strOberfl = "." + getVarDelimited(strTypNr, 6);
		}
		else if(lenNr > 5 && strProfil == "")
		{
			// Profilart fehlt
			strWerkstoff = getVarDelimited(strTypNr, 4);
			strOberfl = "." + getVarDelimited(strTypNr, 5);
		}
		else if(lenNr > 5)
		{
			// Oberflchenschutz fehlt
			strWerkstoff = getVarDelimited(strTypNr, 5);
			// Default 2
			strOberfl = ".2";
		}
		else
		{
			// Default 37.2
			strWerkstoff = "37";
			strOberfl = ".2";
		}

		strWhere1 = "TYP = '" + strTypSuchNr + "'";
		if(strWerkstoff + strOberfl != "")
			strWhere2 = " OR TYP = '" + strTypSuchNr + "-" + strWerkstoff + strOberfl + "'";

	// Profil Default
		if(strProfil == "")
		{
			strProfilSave = "T";
			strKlemm = "T140";
		}

	// alle mglichen VAR_KLEMM suchen
		if(strProfilSave != "")
		{
			var aTrae = [ "T_PROFIL", "HEA", "HEB", "INP", "IPE", "L_PROFIL_G", "L_PROFIL_U", "U_PROFIL" ];
			var strSelectTrae = "";
			var i;
			for(i = 0; i < aTrae.length; i++)
			{
				strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] +
					" WHERE VAR_KLEMM='" + strKlemm + "'";
				if(i < aTrae.length-1)
					strSelectTrae += " UNION ";
			}
			strSelectTrae += " order by VAR_KLEMM";		//TAB,

			if(dbselect("LAGER", strSelectTrae, "TYPSUCHE_TRAE") == 0)
				return "Falscher Wert: "+strKlemm;
		}

		var strSelect = "SELECT * FROM " + this.m_Ptypid + " WHERE " + strWhere1 + strWhere2;
		if ( this.m_Ptypid == 'LUR' )
		{
			// andere Systematik fr alte Loslager: Typschlssel ist auch Typ in der Datenbank,
			// andere Mglichkeiten bei Oberflchenschutz und Werkstoff werden dadurch gleich mitbehandelt
			strSelect = "SELECT * FROM LSL WHERE " + strWhere1 + strWhere2;
		}
		if(dbselect("LAGER", strSelect, "TYPSUCHE_LAGER"))
		{
			// -mw- 12.5.2015: Den nachfolgenden Aufruf auskommentiert, weil die Funktion in Lager2 NICHT IMPLEMENTIERT ist. Es gibt die Funktion in Klasse Lager
			// !!!!!!!!!!! Hr. Schubert bitte prfen !!!!!!!!!!!!   Das gleiche gibt es auch bei CascadeProduktKlemmsystem2, CascadeProduktRollenlager2, CascadeProduktSattel2
			// this._leseDatenAusDB("TYPSUCHE_LAGER");
			this.strBasistyp = dbgetstring("TYPSUCHE_LAGER", "TYP");
			this.strBaureihe = left( this.strBasistyp, 3 );
            this.strHoeheAct = this.strH;
		}
		else
			return "Kein Produkt gefunden !";

	// Daten aus Typnummer
		this.m_Poberfl = 0;
		if(lenNr > 6 || (strProfil == "" && lenNr > 5))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-2));
			this.strWerkstoffOberfl = this.strWerk + "." + getVarDelimited(strTypNr, (lenNr-1));
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, (lenNr-1))];
		}
		else if(lenNr > 5 || (strProfil == "" && lenNr > 4))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-1));
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}
	//Defaults
		else
		{
			this.strWerk = "37";
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}

	// evtl. auch mit Defaults berechnet
		if(strProfilSave != "")
		{
			this.strProfilart = dbgetstring("TYPSUCHE_TRAE", "TAB");
			this.strTraegergroesse = dbgetstring("TYPSUCHE_TRAE", "TRAE_GR");
			this.strTraegerbreite = dbgetstring("TYPSUCHE_TRAE", "B");
			this.strTraegerhoehe = dbgetstring("TYPSUCHE_TRAE", "H");
			this.strFlanschdicke = dbgetstring("TYPSUCHE_TRAE", "TG");
		}

		//this.m_Pemass = RoundDoubleToInt(this.strE);   // -mw- wird auch gebraucht

		//this._korrigiereWerkstoffOberflaeche();
		//var oDaten = Cascade.Lagerkonfiguration.holeTraegerdaten( this.strProfilart, this.strTraegergroesse, this );
		*/
        
		// -Schu- Auswahl "NEU" Flexperte 5
		// 1. Typanalyse / -vervollstndigung
		var strTypNr		= [];
		var bOk				= true;
		this.strBaureihe	= left(strTyp, 3);
		var strSAPKlasse	= this.getSAPKlassenName();
		// Defaultwerte fr Oberflchenschutz aus RH-Voreinstellungen
		var Obfl_RSt	= getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE");
		var Obfl_VA		= getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE");
		var Obfl_Warm	= getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE");
		// -Schu- Was ist vorhanden
		// unterteilen in klemmbare Festlager und den Rest
		if (left(strSAPKlasse, 2) == "CP" && strSAPKlasse != "CPS" ||
			(strSAPKlasse == "CFG" && left(strTyp, 3) == "LKG")){	// wir brauchen einen Trger
			strTypNr	= splitVarDelimiter(strTyp, " ..--.");
			var lenNr	= strTypNr.length;
			
			if (lenNr < 4){
				strTypNr.push("ERROR_TYPBEZ");
				bOk	= false;
			}
			else {
				if (lenNr < 5){
					strTypNr.push("T140");
					strTypNr.push("37");
					strTyp	+= "-" + strTypNr[strTypNr.length - 2] + "-" + strTypNr[strTypNr.length - 1];
					lenNr	= strTypNr.length;
				}
				if (lenNr < 6){	// hier kann der Trger ODER der Werkstoff vorhanden sein
					if (strTypNr[lenNr - 1].length == 2){	// wir haben den Werkstoff
						strTypNr.push(strTypNr[lenNr-1]);
						strTypNr[lenNr-1]	= "T140";
						strTyp	= strTypNr[0] + " " + strTypNr[1] + "." + strTypNr[2] + "." + strTypNr[3] + "-" + strTypNr[4] + "-" + strTypNr[5];
					}
					else{	// wir haben den Trger
						strTypNr.push("37");
					}
					lenNr	= strTypNr.length;
				}
				if (lenNr < 7){
					switch (strTypNr[lenNr-1]){
					case '37':
						strTypNr.push(Oberflaechenschutz[Obfl_RSt]);
						break;
					case '16':
					case '13':
					case '10':
					case '91':
						strTypNr.push(Oberflaechenschutz[Obfl_Warm]);
						break;
					case '41':
					case '43':		// LKG 10 -> Bgel 1.4301
					case '71':
					case '78':
					case '80':
						strTypNr.push(Oberflaechenschutz[Obfl_VA]);
						break;
					default:
						strTypNr.push("ERROR_WERKSTOFF");
						bOk	= false;
						break;
					}
					strTyp	+= "." + strTypNr[strTypNr.length - 1];
					lenNr	= strTypNr.length;
				}
			}
		}
		else{
			strTypNr	= splitVarDelimiter(strTyp, " ..-.");
			var lenNr	= strTypNr.length;
			
			if (lenNr < 4){
				strTypNr.push("ERROR_TYPBEZ");
				bOk	= false;
			}
			else {
				if (lenNr < 5){	// Werkstoff und Oberflchenschutz fehlt --> Typ 10 GL bekommen noch die Trgerbreite
					if (strTypNr[1]*1 == 10)
						strTypNr.push("T140");
					strTypNr.push("37");
					strTypNr.push(Oberflaechenschutz[Obfl_RSt]);
					if (strTypNr[1]*1 == 10)
						strTyp	+= "-" + strTypNr[strTypNr.length - 3] + "-" + strTypNr[strTypNr.length - 2] + "." + strTypNr[strTypNr.length - 1];
					else
						strTyp	+= "-" + strTypNr[strTypNr.length - 2] + "." + strTypNr[strTypNr.length - 1];
					lenNr	= strTypNr.length;
					
				}
				if (lenNr < 6){
					switch (strTypNr[lenNr-1]){
						case '37':
							strTypNr.push(Oberflaechenschutz[Obfl_RSt]);
							break;
						case '16':
						case '13':
						case '10':
						case '91':
							strTypNr.push(Oberflaechenschutz[Obfl_Warm]);
							break;
						case '41':
						case '43':		// LKG 10 -> Bgel 1.4301
						case '71':
						case '78':
						case '80':
							strTypNr.push(Oberflaechenschutz[Obfl_VA]);
							break;
						default:
							strTypNr.push("ERROR_WERKSTOFF");
							bOk	= false;
							break;
					}
					strTyp	+= "." + strTypNr[strTypNr.length - 1];
					lenNr	= strTypNr.length;
				}
				else{	// wir haben schon eine Oberflche - holen aber den Defaultwert
					switch (strTypNr[lenNr-2]){
						case '37':
							strTypNr[lenNr-1]	= (Oberflaechenschutz[Obfl_RSt]);
							break;
						case '16':
						case '13':
						case '10':
						case '91':
							strTypNr[lenNr-1]	= (Oberflaechenschutz[Obfl_Warm]);
							break;
						case '41':
						case '43':		// LKG 10 -> Bgel 1.4301
						case '71':
						case '78':
						case '80':
							strTypNr[lenNr-1]	= (Oberflaechenschutz[Obfl_VA]);
							break;
						default:
							strTypNr.push("ERROR_WERKSTOFF");
							bOk	= false;
							break;
					}
					strTyp	= left(strTyp, strTyp.length-1) + strTypNr[lenNr-1];
				}
			}
		}
		
		this.m_Poberfl		= OberflaechenschutzZahlZuID[strTypNr[strTypNr.length - 1]];
		this.m_Ptyp			= strTyp;
		this.m_Ptypid		= strBaureihe;
		this.m_Pwerkname	= WerkstoffeNrZuNamen[strTypNr[strTypNr.length - 2]];
		this.m_Pwerkstoff	= WerknamenDB[this.m_Pwerkname];
		this.strBauF		= strTypNr[1];
		
		// Sonderflle
		// LKL 10 und LKG 10 sind LSL zugeordnet
		var TabName		= this.strBaureihe;
		var strSql_ext	= "";
		if (this.strBauF*1 == 10 && left(TabName, 2) == "LK"){
			TabName		= "LSL";
			strSql_ext	= "and F_AB = " + (this.strBaureihe == "LKG" ? "1" : "-");
		}
		// LSL 23 mit Nennhhe 107 mm gibt es 2x
		if (this.strBauF*1 == 23 && strTypNr[3] *1 == 107)
			strSql_ext	= "and ST_ST = 'x'";
		
		var strSql			= "select * from " + TabName + " where BAU_F = '" + this.strBauF + 
								"' and DN = " + (strTypNr[2] * 1) + " and NH = " + (strTypNr[3] * 1) + 
								" and Werkstoff = " + (Werkstoffe[this.m_Pwerkstoff] * 1) + " " + strSql_ext + " ";
		var DBData  		= Lager.Search.getSearchResultData('LAGER2',strSql);
		if (DBData.length != 1){	// -Schu- nichts oder zu viel gefunden -> irgendetwas stimmt nicht!
			bOk	= false;
		}
		else{
			DBData[0].PREIS		= 0;
			this.oData			= DBData[0];
			this.getPreis();
			this.m_Pgewicht		= this.oData.GEW * 1;
			this.m_Pemass		= this.oData.E * 1;
			if (toupper(getstring("bAussenDuMesserSonder", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil")) == "TRUE"){
				var oUpdateData		= Base.updateTableSearchData(Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" ),DBData[0],"");
				Base.applyValues(this.oData, oUpdateData);
				// Preise in oUpdateData passen nicht zur Vorgehensweise der "normalen" Auslegung
				//this.oData.PREIS_0	= DBData[0].PREIS_0	* (Base.getSonderAussenDuMesserFaktor());
				//this.oData.PREIS	= DBData[0].PREIS	* (Base.getSonderAussenDuMesserFaktor());
				this.m_Ppreis		= this.oData.PREIS;
				this.oData.TYP		= left(this.oData.TYP, this.oData.TYP.length - 1) + right(this.m_Ptyp, 1);
				this.m_Ptyp			= this.oData.TYP;
				this.m_Pgewicht		= this.oData.GEW;
				this.m_Pemass		= this.oData.E;
			}
		}
        return( bOk ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Lagers, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 *         bool bIsEinzel - Einzelprodukt (true) oder Lastkette (false)
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung, bIsEinzel )
    {
		// Auswahl aus der Lastkette: wir nehmen die alten Bilder, die da auch reinpassen ...
		if ( ! bIsEinzel ){
			if ( ( Drehung == 90 ) || ( Drehung == 270 ) )
				return ( "catalog/client/custom/img/panels/THAN_S.png" );
			return ( "catalog/client/custom/img/panels/THAN.png" );
		}
		
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		if (rfind(AchsDirInfo[9], "RV") > 0)
		{
			switch (Drehung)
			{
				case '0':
				case 0:
					AchsDirInfo[9] = "RV11";
					break;
				case '90':
				case 90:
					AchsDirInfo[9] = "RV12";
					break;
				case '180':
				case 180:
					AchsDirInfo[9] = "RV21";
					break;
				case '270':
				case 270:
					AchsDirInfo[9] = "RV22";
					break;
				default:
					AchsDirInfo[9] = "RV11";
					break;
			}
        }
		else
			AchsDirInfo[9]	= right(AchsDirInfo[9], 4);
		
		var strPic = "catalog/client/custom/img/WITgifs/RH/" + AchsDirInfo[9] + '_' + this.oData.BAUFO + ".jpg";
		
		return( strPic );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Lagers sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Lagers delegieren
		this.serializeOut( strPath );
		
		// !!! Da die Datenbank-Daten des Produkts jetzt im Unterpfad LAGERDATA stehen,
		// mssen sie nochmal hochkopiert werden ....
		this.oData.toStorage(strPath, true);   // merge !

        return 1;
    },

	/**
     * bestimme den Preis des Lagers und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	double: Preis des Lagers
	 */
	getPreis : function(oOptions)
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );

		// hier mssen wir den Preis neu berechnen, da er sich durch nderung des Oberflchenschutzes in
		// der Stckliste ebenfalls gendert haben knnte (die Bestellnummer wird in getASTLDaten neu berechnet)
		// @@@@@@@@@@ -> keine nderung des Oberflchenschutzes mehr zulassen !?!?!?
		// this.strPreis = Cascade.Lagerkonfiguration.holePreis( this );
		// this.m_Ppreis = this.strPreis;
		/*
		if ( this.AKT_Preis*1 != 0 )
			this.m_Ppreis	= this.AKT_Preis;
		var dPreis		= this.m_Ppreis;
		*/
		// Achtung "oData.PREIS" wird z.T. nicht gesetzt -> Fehler (korrigiert ab SVN "384")
		// wenn "oData.PREIS" leer/Null muss der Preis neu berechnet werden
		// erst prfen ob "PREIS_0" vorhanden bzw. neu vorhanden ist
		/*
		if (this.oData.PREIS_0 * 1 == 0 || this.oData.PREIS_0 == ""){
			var strSQLStatement = "select * from " +this.strBaureihe+ " where abs(BAU_F) = " +this.strBauF+ 
			" AND abs(DN) = " +this.oData.DN+ " AND abs(NH) = " +this.oData.NH+ 
			" AND abs(WERKSTOFF) = " +this.oData.WERKSTOFF+ " ";
			var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS_ROH");
			this.oData.PREIS_0	= (numRet == 1 ? dbgetdouble("PREIS_ROH", "PREIS_0") : 0);
		}
		*/
		// Schu 20190730	- Preise IMMER aus Grunddaten berechnen
		//					- bei Anpassungen wird sonst immer der "alte" Preis behalten!!!
		//	- unterschiedlicher Select fr Standard und Nicht-Standard Teile (derzeit nur Sonderaussendurchmesser)
		var bSoDuMe	= false;
		if (this.m_bSonderNennweite * 1 == 1 || toupper(this.m_bSonderNennweite) == "TRUE"){
			bSoDuMe				= true;
			var strSQLStatement = "select * from " +this.strBaureihe+ " where abs(BAU_F) = " +this.strBauF+ 
									" AND abs(DN) = " +this.oData.oOriginalData.DN+ " AND abs(NH) = " +this.oData.oOriginalData.NH+ 
									" AND abs(WERKSTOFF) = " +this.oData.oOriginalData.WERKSTOFF+ " ";
			var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS_ROH");
			this.oData.PREIS_0	= (numRet == 1 ? dbgetdouble("PREIS_ROH", "PREIS_0") : 0);
			if (this.oData.PREIS_0*1 > 0)
				var FaktSoDuMe		= Base.getSonderAussenDuMesserFaktor();
		}
		else{
			var strSQLStatement = "select * from " +this.strBaureihe+ " where abs(BAU_F) = " +this.strBauF+ 
									" AND abs(DN) = " +this.oData.DN+ " AND abs(NH) = " +this.oData.NH+ 
									" AND abs(WERKSTOFF) = " +this.oData.WERKSTOFF+ " ";
			var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS_ROH");
			this.oData.PREIS_0	= (numRet == 1 ? dbgetdouble("PREIS_ROH", "PREIS_0") : 0);
		}
		// Preis bestimmen - sofern Preis_0 vorhanden ist
		if (this.oData.PREIS_0*1 > 0){
			//	- Oberflaechenfaktor
			var ObFl	= Oberflaechenschutz[this.m_Poberfl];
			if (ObFl * 1 != 4){	// Sonderoberflche
				var FaktOBFL	 = Base.getOberflaechenFaktor(ObFl);
				if (bSoDuMe)
					this.oData.PREIS	= (numRet == 1 ? this.oData.PREIS_0 * 1 + (this.oData.oOriginalData.GEW * FaktOBFL) : 0) * FaktSoDuMe;
				else
					this.oData.PREIS	= (numRet == 1 ? this.oData.PREIS_0 * 1 + (this.oData.GEW * FaktOBFL) : 0);
			}
			else
				this.oData.PREIS	= 0;
		}
		else{
			this.oData.PREIS	= 0;
		}
		
		this.m_Ppreis	= this.oData.PREIS;
		var dPreis	= this.m_Ppreis;
		
        if (oOptions.SONDERANSTRICH_KOSTEN > 0)
            dPreis = inputStringToDouble(this.m_Ppreis) + (oOptions.SONDERANSTRICH_KOSTEN * inputStringToDouble(this.m_Pgewicht));

		// in den Tabellen stehen momentan nur Preise fr die Defaultversion des Oberflchenschutzes
        // dPreis = this.getNettoPreis(dPreis, "RABATT_TYP_LAGER");
		dPreis = Base.getPrice(dPreis, "RABATT_TYP_LAGER");

        return( dPreis );
	},

	/**
     * prft, ob das Lager in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function(strKlasse, oProfil)
    {
		/* Hr. Schubert, 21.11,2011:
		Die Lager der Klassen
		- CPG (klemmbare Festlager),
		- CPV (klemmbare Festlager hhenverstellbar),
		- CPS (schraubbare Festlager),
		- CLH (Loslager hhenverstellbar)
		werden nun generell aufgelst.
		Weiterhin wird immer dann das Klemmsystem aufgelst, wenn
		- der Trgertyp "T" und die Trgerbreite >140mm ist
		- der Tgertyp nicht "T" ist.
		Das Klemmsystem wird aber separat als einzelnes Produkt behandelt
		(nur bei Festlagern nicht, da ist das Klemmsystem "drin")
		*/
		
		var bIsConfigurable = false;
		// 05/2023 ab Baukasten LG_2023 werden Lager generell NICHT konfiguriert -Schu-
		/*
		if ((strKlasse == 'CPG') || (strKlasse == 'CPH') ||
			(strKlasse == 'CPV') || (strKlasse == 'CLH') ||
			(strKlasse == 'CPS') ||
			((strKlasse == 'CLG' || strKlasse == 'CFG') && atoi(this.strBauF) == 10))
				bIsConfigurable = true;
		
		// Achtung bei LKx 10 und T140 nicht konfigurieren
		if ((strKlasse == 'CLG' || strKlasse == 'CFG') && atoi(this.strBauF) == 10 &&
			oProfil.strProfilform == "T" && oProfil.strTraegerbreite == "140")
				bIsConfigurable = false;
        */
		
        return( bIsConfigurable ? 1 : 0 );
    },

	/**
     * holt den SAP-Klassennamen des Lagers
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
		var strKlasse = '';
		
		// Baureihen, die es inzwischen nicht mehr gibt sind:
		// IKG, LKG, LSG, LVG, LSW, LXA, LXV
		// -> CFV, CFH

		// unterschiedlicher SAPKlassenname je nach Lagerbaureihe
		if ( ( this.strBaureihe == 'LKF' ) || ( this.strBaureihe == 'LSF' ) || ( this.strBaureihe == 'LXF' ) || ( this.strBaureihe == 'LKG' ) )
			strKlasse = 'CFG';
		else if ( ( this.strBaureihe == 'LKL' ) || ( this.strBaureihe == 'LSL' ) || 
		          ( this.strBaureihe == 'LXL' ) )
			strKlasse = 'CLG';
		else if ( this.strBaureihe == 'LUR' )
			strKlasse = 'GUR'
		else if ( ( this.strBaureihe == 'LVL' ) || ( this.strBaureihe == 'LVS' ))
			strKlasse = 'CLH';
		else if ( this.strBaureihe == 'IKL' )
			strKlasse = 'CLV';
		else if ( this.strBaureihe == 'FLN' )
			strKlasse = 'CPG';
		else if ( this.strBaureihe == 'FVN' )
			strKlasse = 'CPH';
		else if ( ( this.strBaureihe == 'FSN' ) || ( this.strBaureihe == 'FSD' ) )
			strKlasse = 'CPS';
		else if ( this.strBaureihe == 'FLV' )
			strKlasse = 'CPV';
		else if ( this.strBaureihe == 'LPR' )
			strKlasse = 'GUR';
		else alert( 'Baureihe ' + this.strBaureihe + ' hat keine SAP-Klasse' );

        return( strKlasse );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Lagertyp in SAP
	 */
    getSAPTyp : function()
    {
        return( this.strBaureihe );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];

		// Nur noch fr Festlager und LKL 10 und LKG 10 relevant,
		// bei denen das Klemmsystem enthalten ist:
		var strProfilform		= left(getstring("strSelComboBeamArt", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"), 1);
		if (left(strProfilform, 1) != "U" && left(strProfilform, 1) != "L")
			strProfilform	= "T";
		var strTraegerbreite	= getstring("strSelComboBeamSize", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard");
		
		// ab Baukasten 2023 alle KSY feste Nummern und damit eindeutige Trgerbreiten (-bereiche)
		var LG_2023_exists	= false;
		if(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE") != ""){	// Feld existiert - Suche in neuer Tabelle
			LG_2023_exists	= true;
			var TrBrIST		= strProfilform == "T" ? strTraegerbreite : "";
			var TrBrSTD		= TrBrIST != "" ? theMainController.getTrBereich(TrBrIST) : "";
		}
		
		if (LG_2023_exists)
			strTraegerbreite	= TrBrSTD;
		else{
			if (atoi(strTraegerbreite) > 140)
				strTraegerbreite	= "";
			else
				strTraegerbreite	= "140";
		}
		
		var oProfil = {
			strTraegerbreite	: strTraegerbreite,
			//strProfilform : 'T'
			strProfilform		: strProfilform
		}
		var strSAPTyp = this.strBaureihe + ' ' + this.strBauF;
		
		retObj.loeseauf = this.isSAPKonfigurierbar(strKlasse, oProfil);

        var strSAPAussendurchmesser = this.oData.D;	
        /* 3.4.2008: Datenbank jetzt bereinigt
		var strSAPAussendurchmesser = replace( this.strD, '.', ',' );
		if ( strSAPAussendurchmesser.indexOf( ',' ) < 0 )	// in der Tabelle mit SAP-Merkmalen ist z.B. 475 als '475,0' angegeben
			strSAPAussendurchmesser += ',0';
        */

        var oOptions = theMainController.presets.getPreisOptions();
        if (oOptions.SONDERANSTRICH_TEXT != "")
            sapOberflaechenschutz = "0";

		if ( ( strKlasse == 'CFG' ) || ( strKlasse == 'CFH' ) || ( strKlasse == 'CLG' ) || ( strKlasse == 'CLH' ) )
		{
			// NENNWEITE, NENNHOEHE, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILHOEHE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				NENNHOEHE: this.oData.NH,
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				//TRAEGERBREITE: oProfil.strTraegerbreite,
				TRAEGERBREITE: (atoi(this.strBauF) == 10 && oProfil.strProfilform == "T") ? oProfil.strTraegerbreite : '',
				PROFILHOEHE: '',						// ist nicht suchrelevant
				//PROFILFORM: oProfil.strProfilform,
				PROFILFORM: atoi(this.strBauF) == 10 ? oProfil.strProfilform : '',
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CFV' )
		{
			// NENNWEITE, AUSSENDURCHMESSER, TRAEGERBREITE, MANTELDURCHMESSER, PROFILHOEHE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				MANTELDURCHMESSER: this.oData.DM,
				PROFILHOEHE: '',						// ist nicht suchrelevant
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CLV' )
		{
			// NENNWEITE, AUSSENDURCHMESSER, MANTELDURCHMESSER, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				MANTELDURCHMESSER: this.oData.DM,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( ( strKlasse == 'CPG' ) || ( strKlasse == 'CPH' ) )
		{
			// NENNWEITE, NENNHOEHE, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				NENNHOEHE: this.oData.NH,
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CPS' )
		{
			// NENNWEITE, KURZBEZ, AUSSENDURCHMESSER, NENNHOEHE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				KURZBEZ: strSAPTyp,						// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.oData.NH,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CPV' )
		{
			// NENNWEITE, MANTELDURCHMESSER, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				MANTELDURCHMESSER: this.oData.DM,		
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'GUR' )
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.oData.NH,
				EINBAUMASS: this.oData.E,
				LAENGE: this.oData.L,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'SPZ' )
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.oData.NH,
				EINBAUMASS: this.oData.E,
				LAENGE: this.oData.L,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'LK1' )	// Lagertypen mit Abhebesicherung
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.oData.DN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.oData.NH,
				EINBAUMASS: this.oData.E,
				LAENGE: this.oData.L,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		//else alert( 'kein Datenobjekt fr SAP-Klasse ' + strKlasse );

        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;

        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if ( this.isSAPKonfigurierbar(strKlasse, oProfil) )
            retObj.postext1 = this.m_Ptyp;

        return( retObj );
	},

	/**
     *  Bestimme Subtyp des Lagers (Baureihe + erste Ziffer der Nennhhe + optional Trgerform)
	 *  Der Subtyp wird als Schlssel bentigt in:
	 *		- Auftragsstckliste, Tabelle STUECKLISTE
	 *		- Texte, Tabelle TEXT_KONFIG_ID
	 *
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		// Lager werden nicht mehr konfiguriert
		// nur wenige Unterscheidungen
		var strSubtyp	= "";
		if (this.strBaureihe == "LKF" || this.strBaureihe == "LSF" || this.strBaureihe == "LXF"
			|| (this.strBaureihe == "FLN" && atoi(this.strBauF) <= 11))
			strSubtyp	= this.strBaureihe + left(this.strBauF, 1);
		else if (atoi(this.strBauF) == 10)
			strSubtyp	= this.strBaureihe + this.strBauF;
		
		return strSubtyp;
		/*
		var BauF	= this.strBauF;
		var DN		= (this.oData.DN == "-" ? this.oData.oOriginalData.DN : this.oData.DN)*1;
		// fr FLN TYP 20/21/22 ist BauF "XX"
		if ((this.strBaureihe == "FLN" && atoi(BauF) < 23 && atoi(BauF) >= 20)
				|| this.strBaureihe == "IKL")
			BauF		= "XX";
		
		var strSubtyp	= BauF + '_' + Werkstoffe[this.m_Pwerkstoff] + '_';
		
		// strSuffix fr Unterscheidung der Sonderflle
		var strSuffix = 'XX';
		// Sonderfall RSt und DN 15 / DN 20 in Standarddurchmesser
		if ((Werkstoffe[this.m_Pwerkstoff] == '37') &&
			(DN <= 20) &&
			(m_bSonderNennweite*1 != 1) &&
			(atoi(BauF) != 10)) {
			strSuffix = '15';
		}
		// Sonderfall RSt und FLN Bauform 23 mit DN > 600 --> HZL-Schelle mit Schrauben 8.8
		if ((this.strBaureihe == 'FLN') &&
			(Werkstoffe[this.m_Pwerkstoff] == '37') &&
			(DN > 600) &&
			(atoi(BauF) == 23)) {
			strSuffix	= 'HZL';
		}
		// LKG 10 Unterscheidung der Bauform
		if (this.strBaureihe == "LKG" && atoi(BauF) == 10){
			if (DN <= 80)
				strSuffix	= 'KL';		// kleine Bauform
			else
				strSuffix	= 'GR';		// groe Bauform
		}
		// Sonderfall FLV 23 DN125 / DM200 --> keine Stege
		if (this.strBaureihe == "FLV" && atoi(BauF) == 23){
			if (DN == 125 && (this.oData.DM * 1) == 200 && (Werkstoffe[this.m_Pwerkstoff] == '37'))
				strSuffix	= 'OS';
		}
		// Festlager Nennhhe 60
		if ((this.oData.NH)*1 <= 60) {
			strSuffix += '_60';
		}
		//Festlager Typ 10/11
		if (this.strBaureihe == "FLN" && atoi(BauF) == 10){
			if (DN <= 50)
				strSuffix	+= '_50';
			else
				strSuffix	+= '_300';
		}
		if (this.strBaureihe == "FLN" && atoi(BauF) == 11){
			if (DN <= 40)
				strSuffix	+= '_40';
			else if (DN <= 80)
				strSuffix	+= '_80';
			else
				strSuffix	+= '_300';
		}
			
		strSubtyp += strSuffix;
		
		// Trger-ID ist die Profilform; 
		// also U, L oder bei T-Trgern entweder T140 oder TXXX
		if (left(this.strBaureihe, 2) == "LK" && atoi(this.strBauF) == 10){
			var strTraegerID	= toupper(left(getstring("strSelComboBeamArt", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"), 1));
			if (strTraegerID != "U" && strTraegerID != "L")
				strTraegerID	= "T";
		}
		else
			var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';
		if ( strTraegerID == 'T' ) {
			//if ( this.strTraegerbreite <= 140 )
			//if(atoi(getstring("strSelComboBeamSize", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard")) <= 140)
			// gleich die Traegerinfos merken
			var bTr	= atoi(getstring("dBeamWidth",		"DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"));
			var hTr	= atoi(getstring("dBeamHeight",		"DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"));
			var tG	= atoi(getstring("dBeamThickness",	"DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"));
			if(bTr <= 140)
				strTraegerID += '140';
			else strTraegerID += 'XXX';
		}

		if (( this.strBaureihe == 'FLN' ) || ( this.strBaureihe == 'FVN' ) ||
			( this.strBaureihe == 'FLV' )) {
			strSubtyp += '_' + strTraegerID;
			// weiter Infos fr Trger mit tG > 19
			if (tG > 42)
				strSubtyp	+= "NICHT_ZULAESSIG";
			else if (tG > 36)
				strSubtyp	+= "_TG42";
			else if (tG > 25)
				strSubtyp	+= "_TG36";
			else if (tG > 19)
				strSubtyp	+= "_TG25";
		}
		else if ((( this.strBaureihe == 'LKL' ) || ( this.strBaureihe == 'LKG' )) &&
				 ( this.strBauF == '10' )) {
			strSubtyp += '_' + strTraegerID;		
		}
		
		if ((this.strBaureihe == 'FVN' || this.strBaureihe == 'LVL' || this.strBaureihe == 'LVS') &&
				(this.m_bSonderNennweite * 1 == 1 || toupper(this.m_bSonderNennweite) == "TRUE"))
			{
			if (this.oData.D * 1 < this.oData.oOriginalData.DN * 1)
				strSubtyp += '_S1_KL';	// Basis ist die vorherige (nchst kleinere) NW
			else
				strSubtyp += '_S1_GR';	// Basis ist die nchste (nchst grere) NW
			}
			
		return( strSubtyp );
		*/
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Lagers
	 *
	 * @params integer nStartPos - startposition des Lagers in der Lastkette
	 *         integer nPosNr - Position des Lagers in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Lagers beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = this.strBaureihe + this.strBauF;
        if (this.m_Ptypid == "LUR")
            strTypForCAD = "LUR";

		// Achtung: Trgerdaten gibt es normalerweise nicht mehr am Lager:
		var strTraegerID = '';
		var strHMass = this.oData.H;	// @@@ Achtung, gibt es nicht bei hhenverstellbaren
		var strEMass = this.m_Pemass;

		// Hhenbereiche fr hhenverstellbare Lager
		/*
		var strHoehenbereich = 'H1';
		var data = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER_AUSWAHL" );
		if ( data.IDC_HOEHENVERSTELLUNG )
		{
			// Zuordnung zu den Hhenbereichen gemaess Vorgabe -schm- 16.4.2008
			if ( atoi(this.strH) <= 100 )
				strHoehenbereich = 'H1';
			else if ( atoi(this.strH) <= 150 )
				strHoehenbereich = 'H2';
			else strHoehenbereich = 'H3';
			
			strHMass = this.strHoeheAct;
			strEMass = RoundDoubleToInt (int(strHMass) + this.strD / 2);
			this.m_Pemass = RoundDoubleToInt( strEMass );   // -mw- wird auch gebraucht
		}
		*/

		// setze CAD-Parameter
        if (nTyp == "E")
            aParams.push( [ "Typ", "" + strTypForCAD ] );
        else aParams.push( [ "Position" + nStartPos, "" + strTypForCAD ] );

        aParams.push( [ "Rohraussendurchmesser", this.oData.D ] );
        aParams.push( [ "DM", this.oData.DM ] );
        aParams.push( [ "E-Mass",  strEMass ] );
        aParams.push( [ "E-Mass1", strEMass ] );
        aParams.push( [ "E-Mass2", strEMass ] );
        aParams.push( [ "E-Mass3", strEMass ] );
        aParams.push( [ "E-Mass4", strEMass ] );
        aParams.push( [ "H-Mass",  strHMass ] );
        aParams.push( [ "H-Mass1", strHMass ] );
        aParams.push( [ "H-Mass2", strHMass ] );
        aParams.push( [ "H-Mass3", strHMass ] );
        aParams.push( [ "H-Mass4", strHMass ] );
        aParams.push( [ "Daemmdicke", this.daemmdicke ] );  // this.strJ - hier soll die gewnschte, nicht die maximale Dmmung ausgegeben werden
        aParams.push( [ "Hoehenbereich", strHoehenbereich ] );

        if ((this.m_Ptypid == "LKF") || (this.m_Ptypid == "LSF"))
			aParams.push( [ "Schellenwinkel", "45" ] );		// Schelle 30-45 gedreht
		else aParams.push( [ "Schellenwinkel", "0" ] );	    // Schelle horizontal

        aParams.push( [ "Werkstoff", this.strWerk ] );
        aParams.push( [ "Tr-Typ", strTraegerID ] );
        aParams.push( [ "Tr-Typ1", strTraegerID ] );
        aParams.push( [ "Tr-Typ2", strTraegerID ] );
        aParams.push( [ "Tr-Typ3", strTraegerID ] );
        aParams.push( [ "Tr-Typ4", strTraegerID ] );
        aParams.push( [ "Btr", this.strTraegerbreite ] );
        aParams.push( [ "Btr1", this.strTraegerbreite ] );
        aParams.push( [ "Btr2", this.strTraegerbreite ] );
        aParams.push( [ "Btr3", this.strTraegerbreite ] );
        aParams.push( [ "Btr4", this.strTraegerbreite ] );
        aParams.push( [ "Htr", this.strTraegerhoehe ] );
        aParams.push( [ "Htr1", this.strTraegerhoehe ] );
        aParams.push( [ "Htr2", this.strTraegerhoehe ] );
        aParams.push( [ "Htr3", this.strTraegerhoehe ] );
        aParams.push( [ "Htr4", this.strTraegerhoehe ] );
        aParams.push( [ "tG", this.strFlanschdicke ] );		// ist das identisch zur Gurtdicke? Ja.
        aParams.push( [ "tG1", this.strFlanschdicke ] );
        aParams.push( [ "tG2", this.strFlanschdicke ] );
        aParams.push( [ "tG3", this.strFlanschdicke ] );
        aParams.push( [ "tG4", this.strFlanschdicke ] );

        aParams.push( [ "LAB", this.strLAB ] );

        aParams.push( [ "ANZ_LG", this.strANZ_LG ] );
        aParams.push( [ "ABST_LG", this.strABST_LG ] );
        aParams.push( [ "E_LG", this.strE_LG ] );
        aParams.push( [ "A_LG", this.strA_LG ] );
        aParams.push( [ "B_LG", this.strB_LG ] );
        aParams.push( [ "L_LG", this.strL_LG ] );

        return( [ aParams, nPosNr + 1 ] );
    }
	
	
});
