/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Lager constructor
 */
Lager = function( strDBRecordCache, oBetriebsbedingungen ) {

	Lager.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	// Zusatzdaten fr hhenverstellbare Lager
	this.strHoeheMin = '0';
	this.strHoeheAct = '0';
	this.strHoeheMax = '0';
	
	// hole Variablen aus der Datenbankzeile
	this._leseDatenAusDB( strDBRecordCache );
	this.strHoeheAct = this.strH;

	// Variablen fr Berechnungen
	this.strNennlast = "";
	this.strNennlastName = "";
	this.strHoeheMinMax = "";
	this.strBasistyp = "";															// der Basistyp darf durch die Konfiguration nicht verndert werden
	this.strBaureihe = "";															// die Baureihe darf durch die Konfiguration nicht verndert werden

	// Variablen aus Konfiguration
	this.strProfilart = "HEB";
	this.strTraegertyp = "10";				//neu scb 22.06.09
	this.strTraegergroesse = "100 - 140";
	this.strTraegerhoehe = "140";
	this.strTraegerbreite = "140";
	this.strFlanschdicke = "12";

    // Betriebsbedingungen im Produkt merken
    if (oBetriebsbedingungen)
    {
        this.temperatur = oBetriebsbedingungen.temperatur;
        this.daemmdicke = oBetriebsbedingungen.daemmdicke;
        this.wx = oBetriebsbedingungen.wx;
        this.wy = oBetriebsbedingungen.wy;
        this.m_fz = oBetriebsbedingungen.m_fz;
        this.fz = oBetriebsbedingungen.fz;
        this.m_fx = oBetriebsbedingungen.m_fx;
        this.fx = oBetriebsbedingungen.fx;
        this.fy = oBetriebsbedingungen.fy;
    }
};


EasyKat.extend( Lager, Produkt, {

	/**
     * lese interne Daten aus einem Record einer Datenbanktabelle
	 *
	 * @params string strDBRecordCache - Name des internen Recordcaches
	 * @returns	-
     */
	_leseDatenAusDB : function( strDBRecordCache )
	{
		this.strTyp = dbgetstring( strDBRecordCache, "TYP" );
		this.strProfilform = dbgetstring( strDBRecordCache, "PROFILFORM" );
		this.strTraegertyp = dbgetstring( strDBRecordCache, "TrT" );				//neu scb 22.06.09
		this.strDBTraegerbreite = dbgetstring( strDBRecordCache, "TRAEGERBREITE" );
		this.strBauF = dbgetstring( strDBRecordCache, "BAU_F" );
		this.strDN = dbgetstring( strDBRecordCache, "DN" );
		this.strD = dbgetstring( strDBRecordCache, "D" );
		this.strDM = dbgetstring( strDBRecordCache, "DM" );
		this.strH = dbgetstring( strDBRecordCache, "H" );
		this.strH_REAL = dbgetstring( strDBRecordCache, "H_REAL" );
		this.strJ = dbgetstring( strDBRecordCache, "J" );
		this.strFX = dbgetstring( strDBRecordCache, "FX" );
		this.strFY = dbgetstring( strDBRecordCache, "FY" );
		this.strFZ = dbgetstring( strDBRecordCache, "FZ" );
		this.strL = dbgetstring( strDBRecordCache, "L" );
		this.strB_AF = dbgetstring( strDBRecordCache, "B_AF" );
		this.strGL_U = dbgetstring( strDBRecordCache, "GL_U" );
		this.strS_L = dbgetstring( strDBRecordCache, "S_L" );
		this.strWX = dbgetstring( strDBRecordCache, "WX" );
		this.strWY = dbgetstring( strDBRecordCache, "WY" );
		this.strGEW = dbgetstring( strDBRecordCache, "GEW" );
		this.strWerk = dbgetstring( strDBRecordCache, "WERK_" );
		this.strObfl = dbgetstring( strDBRecordCache, "OBFL" );
		this.strIdent = dbgetstring( strDBRecordCache, "IDENT" );
		this.strPreis = ( dbgetstring( strDBRecordCache, "PREIS" ) - 0 ).toFixed( 2 );
		//this.strBild = dbgetstring( strDBRecordCache, "BILD" );
		this.strBauform = dbgetstring( strDBRecordCache, "BAUFO" );
		this.strEMinMax = dbgetstring( strDBRecordCache, "E_MIN_MAX" );
		this.strE = dbgetstring( strDBRecordCache, "E" );
		this.strA = dbgetstring( strDBRecordCache, "A" );
		this.strB = dbgetstring( strDBRecordCache, "B" );
		this.strC = dbgetstring( strDBRecordCache, "C" );
		this.strTF = dbgetstring( strDBRecordCache, "tF" );		// -Schu- 090525
		//this.strT = dbgetstring( strDBRecordCache, "T" );
		
		// -Schu- 100511 Ausgabe der Schweissnhte nur bei Hngend doppelt
		var Lastabtr_LK = getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var Lastabtr_LG = getstring("IDC_LASTKETTE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		if ((Lastabtr_LK == "HAENGEND_DOPPEL") || (left(this.strTyp, 3) == "LSW") || (left(this.strTyp, 3) == "LXA"))
			{
			this.strSCH_V = dbgetstring( strDBRecordCache, "SCH_V" );
			this.strSCH_A = dbgetstring( strDBRecordCache, "SCH_A" );
			}
		else
			{
			this.strSCH_V = "";
			this.strSCH_A = "";
			}
		
		this.strDaem = dbgetstring( strDBRecordCache, "DAEM" );
		this.strE_SH = dbgetstring( strDBRecordCache, "E_SH" );
		this.strFX_K = dbgetstring( strDBRecordCache, "FX_K" );
		this.strFAB = dbgetstring( strDBRecordCache, "FAB" );
		this.strFAB_K = dbgetstring( strDBRecordCache, "FAB_K" );
		this.strTypBASF = dbgetstring( strDBRecordCache, "TYP_BASF" );
		this.strBASF_Nr = dbgetstring( strDBRecordCache, "BASF_NR" );
		this.strB_PL = dbgetstring( strDBRecordCache, "B_PL" );
		this.strAnz_PL = dbgetstring( strDBRecordCache, "ANZ_PL" );
        // -mw- 05/2008 neu:
		this.strAnz_Gewst = dbgetstring( strDBRecordCache, "ANZ_GEWST" );

		this.strL_PL = dbgetstring( strDBRecordCache, "L_PL" );
        
        // -mw- 12/2008 nur fr LSW:
		this.strIdentLSL = dbgetstring( strDBRecordCache, "IDENT_LSL" );
		this.strIdentLAW = dbgetstring( strDBRecordCache, "IDENT_LAW" );
		this.strLAB		 = dbgetstring( strDBRecordCache, "LAB" );

        // -mw- 3/2009 fr STK-Ausgabedateien (Masse):
		this.strCS		 = dbgetstring( strDBRecordCache, "CS" );
		this.strAS		 = dbgetstring( strDBRecordCache, "AS" );
		this.strBS		 = dbgetstring( strDBRecordCache, "BS" );
		this.strSS		 = dbgetstring( strDBRecordCache, "SS" );
		this.strDS		 = dbgetstring( strDBRecordCache, "DS" );
		this.strFS		 = dbgetstring( strDBRecordCache, "FS" );
		
		// fr FSN und FSD
		this.strD2		 = dbgetstring( strDBRecordCache, "D2" );
		this.strS2		 = dbgetstring( strDBRecordCache, "S2" );
		
		// -mw- 4/2009 fr LX...
		this.strANZ_LG		 = dbgetstring( strDBRecordCache, "ANZ_LG" );
		this.strABST_LG		 = dbgetstring( strDBRecordCache, "ABST_LG" );
		this.strE_LG		 = dbgetstring( strDBRecordCache, "E_LG" );
		this.strA_LG		 = dbgetstring( strDBRecordCache, "A_LG" );
		this.strB_LG		 = dbgetstring( strDBRecordCache, "B_LG" );
		this.strL_LG		 = dbgetstring( strDBRecordCache, "L_LG" );
		
		// neu scb 22.06.09, fr Klemmsystem
		this.strL1L = dbgetstring( strDBRecordCache, "L1L" );
		this.strL1R = dbgetstring( strDBRecordCache, "L1R" );
		this.strL2L = dbgetstring( strDBRecordCache, "L2L" );
		this.strL2R = dbgetstring( strDBRecordCache, "L2R" );
		this.strL3L = dbgetstring( strDBRecordCache, "L3L" );
		this.strL3R = dbgetstring( strDBRecordCache, "L3R" );
		this.strL4L = dbgetstring( strDBRecordCache, "L4L" );
		this.strL4R = dbgetstring( strDBRecordCache, "L4R" );
		this.strH1L = dbgetstring( strDBRecordCache, "H1L" );
		this.strH1R = dbgetstring( strDBRecordCache, "H1R" );
		this.strH2L = dbgetstring( strDBRecordCache, "H2L" );
		this.strH2R = dbgetstring( strDBRecordCache, "H2R" );
		this.strH3L = dbgetstring( strDBRecordCache, "H3L" );
		this.strH3R = dbgetstring( strDBRecordCache, "H3R" );
		this.strBKL = dbgetstring( strDBRecordCache, "BKL" );
		this.strBKR = dbgetstring( strDBRecordCache, "BKR" );
		
		this._korrigiereVariablen();
		this._korrigiereWerkstoffOberflaeche();
	},

	/**
     * korrigiere Variablen der Oberklasse und eigene Variablen nach Einlesen der internen Daten aus der Datenbank
	 *
	 * @params string strDBRecordCache - Name des internen Recordcaches
	 * @returns	-
     */
	_korrigiereVariablen : function()
	{
		// korrigiere Variablen der Oberklasse
		this.m_Ptyp = this.strTyp;
        this.m_Ptypid = left( this.strTyp, 3 );
		this.m_Ppreis = this.strPreis;
		this.m_PIdentNr = this.strIdent;
		this.m_Pgewicht = this.strGEW;
		this.m_Pwerkstoff = this._berechneWerkstoff(this.strWerk);
        // -mw- 21.8.2008: Wenn Oberflchenschutz in DB spezifiziert ist, sollte er hier nicht
        // mit einem Default berschrieben werden ....
        if (this.strObfl == "")
            this.m_Poberfl = this.getOberFlaechenSchutzDefault();
        else
        {
            if ( this.strObfl == '0' )
                this.m_Poberfl = 'OB_ROH';
            else if ( this.strObfl == '1' )
                this.m_Poberfl = 'OB_GALV';
            else if ( this.strObfl == '2' )
                this.m_Poberfl = 'OB_FEUER';
            else if ( this.strObfl == '3' )
                this.m_Poberfl = 'OB_GRUND';
            else if ( this.strObfl == '4' )
                this.m_Poberfl = 'OB_SONST';
        }
        var data = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER_AUSWAHL" );
		if ( data.IDC_HOEHENVERSTELLUNG )
            this.m_Pemass = RoundDoubleToInt (int(this.strHoeheAct) + this.strD / 2);   // -mw- wird auch gebraucht
        else
            this.m_Pemass = RoundDoubleToInt( this.strE );   // -mw- wird auch gebraucht

	},

	/**
     * berechnet den Werkstoff fr das Lager
	 *
	 * @params -
	 * @returns	string berechneter Werkstoff
	 */
	_berechneWerkstoff : function(strWerk)
	{
		var strWerkstoff = 'W_SONST';
        
        // -mw- 09/2007: Wenn Werkstoff in DB gewesen, dann diesen benutzen, sonst Default:
        if (strWerk == "37")
            strWerkstoff = "W_RST";
        else if (strWerk == "16")
            strWerkstoff = "W_15MO3";
        else if (strWerk == "13")
            strWerkstoff = "W_13CRMO";
        else if (strWerk == "10")
            strWerkstoff = "W_10CRMO";
        else if (strWerk == "41")
            strWerkstoff = "W_4541";
        else if (strWerk == "43")
            strWerkstoff = "W_4301";
        else if (strWerk == "71")
            strWerkstoff = "W_4571";
        else if (strWerk == "80")
            strWerkstoff = "W_INCOLOY";
        else if (strWerk == "91")
            strWerkstoff = "W_P91";
        else 
        {
            // dieses %$&$"& DataAccessObject steht manchmal noch nicht zur Verfgung, wenn die Klasse durch Serialisierung erzeugt wird
            // deswegen mu hier der Store direkt abgefragt werden
            var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

            // mgliche Werkstoffe sind temperaturabhngig, allerdings ist z.Zt. nur ein Werkstoff pro Temperaturintervall mglich
            // (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
            if ( dTemperatur <= 300 )
                strWerkstoff = "W_RST"; 		//'S235JRG2'
            else if ( dTemperatur <= 450 )
            {
                strWerkstoff = 'W_15MO3';		//'16Mo3'
                // vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
                if ( substr( this.strTyp, 1, 1 ) == "I" )
                    strWerkstoff = 'W_RST';		//'S235JRG2'
            }
            else if ( dTemperatur > 450 )
            {
                var len = this.strTyp.length();
                var strWerkstoffBezeicnung = substr( this.strTyp, len - 3, len - 2 );
                if ( strWerkstoffBezeicnung == "16" )
                        strWerkstoff = 'W_15MO3';		//'16Mo3'
                    else if ( strWerkstoffBezeicnung == "13" )
                        strWerkstoff = 'W_13CRMO';		//'13CrMo4-5'
                    else if ( strWerkstoffBezeicnung == "10" )
                        strWerkstoff = 'W_10CRMO';		// '10CrMo9-10'
					else if ( strWerkstoffBezeicnung == "91" )
                        strWerkstoff = 'W_P91';		// 'X10CrMoVNb9-1'
                    // else sollte nicht passieren - in diesem Fall bleibt der Werkstoff halt undefiniert
            }
        }
		return( strWerkstoff );
	},

	/**
     * korrigiere Variablen der Oberklasse und eigene Variablen nach Einlesen der internen Daten aus der Datenbank
	 *
	 * @params -
	 * @returns	-
     */
	_korrigiereWerkstoffOberflaeche : function()
	{
		if ( this.m_Poberfl )
		{
			var strID = Oberflaechenschutz[ this.m_Poberfl ];
			this.strWerkstoffOberfl = this.strWerk + "." + strID;
		}
		else
		{
			if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' hat den Oberflchentyp schon in der Typbezeichnung
			{
				this.strWerkstoffOberfl = right( this.strTyp, 4 );
				var strID = right( this.strTyp, 1 );
				if ( strID == '0' )
					this.m_Poberfl = 'OB_ROH';
				else if ( strID == '1' )
					this.m_Poberfl = 'OB_GALV';
				else if ( strID == '2' )
					this.m_Poberfl = 'OB_FEUER';
				else if ( strID == '3' )
					this.m_Poberfl = 'OB_GRUND';
				else if ( strID == '4' )
					this.m_Poberfl = 'OB_SONST';
				else this.m_Poberfl = 'OB_SONST';
			}
			else
			{
				// Defaultwerte
				this.strWerkstoffOberfl = "37.2";
				if ( this.strWerk == "16" )
					this.strWerkstoffOberfl = "16.0";
				else if ( this.strWerk == "13" )
					this.strWerkstoffOberfl = "13.0";
				else if ( this.strWerk == "10" )
					this.strWerkstoffOberfl = "10.0";
			}
		}
	},

	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da

        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );

		// Variablen aus der Datenbank
		this.strTyp = getstring( "TYP", strPath );
		this.strProfilform = getstring( "PROFILFORM", strPath );
		this.strTraegertyp = getstring( "TrT", strPath );					// neu scb 22.06.09
		this.strDBTraegerbreite = getstring( "TRAEGERBREITE", strPath );
		this.strBauF = getstring( "BAU_F", strPath );
		this.strDN = getstring( "DN", strPath );
		this.strD = getstring( "D", strPath );
		this.strDM = getstring( "DM", strPath );
		this.strH = getstring( "H", strPath );
		this.strH_REAL = getstring( "H_REAL", strPath );
		this.strJ = getstring( "J", strPath );
		this.strFX = getstring( "FX", strPath );
		this.strFY = getstring( "FY", strPath );
		this.strFZ = getstring( "FZ", strPath );
		this.strL = getstring( "L", strPath );
		this.strB_AF = getstring( "B_AF", strPath );
		this.strGL_U = getstring( "GL_U", strPath );
		this.strS_L = getstring( "S_L", strPath );
		this.strWX = getstring( "WX", strPath );
		this.strWY = getstring( "WY", strPath );
		this.strGEW = getstring( "GEW", strPath );
		this.strWerk = getstring( "WERK_", strPath );
		this.strObfl = getstring( "OBFL", strPath );
		this.strIdent = getstring( "IDENT", strPath );
		this.strPreis = getstring( "PREIS", strPath );
		this.strBild = getstring( "BILD", strPath );
		this.strBauform = getstring( "BAUFO", strPath );
		this.strEMinMax = getstring( "E_MIN_MAX", strPath );
		this.strE = getstring( "E", strPath );
		this.strA = getstring( "A", strPath );
		this.strB = getstring( "B", strPath );
		this.strC = getstring( "C", strPath );
		//this.strT = getstring( "T", strPath );
		this.strSCH_V = getstring( "SCH_V", strPath );
		this.strSCH_A = getstring( "SCH_A", strPath );
		this.strTF = getstring( "TF", strPath );			//-Schu- 090525
		this.strDaem = getstring( "DAEM", strPath );
		this.strE_SH = getstring( "E_SH", strPath );
		this.strFX_K = getstring( "FX_K", strPath );
		this.strFAB = getstring( "FAB", strPath );
		this.strFAB_K = getstring( "FAB_K", strPath );
		this.strTypBASF = getstring( "TYP_BASF", strPath );
		this.strBASF_Nr = getstring( "BASF_NR", strPath );
		this.strB_PL = getstring( "B_PL", strPath );
		this.strAnz_PL = getstring( "ANZ_PL", strPath );
		this.strL_PL = getstring( "L_PL", strPath );

		this.strAnz_Gewst = getstring( "ANZ_GEWST", strPath );
		
		// neu scb 22.06.09, fr Klemmsystem
		this.strL1L = getstring( "L1L", strPath );
		this.strL1R = getstring( "L1R", strPath );
		this.strL2L = getstring( "L2L", strPath );
		this.strL2R = getstring( "L2R", strPath );
		this.strL3L = getstring( "L3L", strPath );
		this.strL3R = getstring( "L3R", strPath );
		this.strL4L = getstring( "L4L", strPath );
		this.strL4R = getstring( "L4R", strPath );
		this.strH1L = getstring( "H1L", strPath );
		this.strH1R = getstring( "H1R", strPath );
		this.strH2L = getstring( "H2L", strPath );
		this.strH2R = getstring( "H2R", strPath );
		this.strH3L = getstring( "H3L", strPath );
		this.strH3R = getstring( "H3R", strPath );
		this.strBKL = getstring( "BKL", strPath );
		this.strBKR = getstring( "BKR", strPath );
		
		// Variablen fr Berechnungen
		this.strNennlast = getstring( "strNennlast", strPath );
		this.strNennlastName = getstring( "strNennlastName", strPath );
		this.strHoeheMinMax = getstring( "strHoeheMinMax", strPath );
		this.strBasistyp = getstring( "strBasistyp", strPath );
		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strWerkstoffOberfl = getstring( "strWerkstoffOberfl", strPath );
		// Variablen aus Konfiguration
		this.strProfilart = getstring( "strProfilart", strPath );
		this.strTraegergroesse = getstring( "strTraegergroesse", strPath );
		this.strTraegerhoehe = getstring( "strTraegerhoehe", strPath );
		this.strTraegerbreite = getstring( "strTraegerbreite", strPath );
		this.strFlanschdicke = getstring( "strFlanschdicke", strPath );

        // Betriebsbedngungen:
        this.temperatur = getstring( "temperatur", strPath );
        this.daemmdicke = getstring( "daemmdicke", strPath );
        this.wx         = getstring( "wx", strPath );
        this.wy         = getstring( "wy", strPath );
        this.m_fz       = getstring( "m_fz", strPath );
        this.fz         = getstring( "fz", strPath );
        this.m_fx       = getstring( "m_fx", strPath );
        this.fx         = getstring( "fx", strPath );
        this.fy         = getstring( "fy", strPath );

		this.strIdentLSL = getstring( "IDENT_LSL", strPath );
		this.strIdentLAW = getstring( "IDENT_LAW", strPath );
		this.strLAB 	 = getstring( "LAB", strPath );

		// Zusatzdaten fr hhenverstellbare Lager
		this.strHoeheMin = getstring( 'HOEHE_MIN', strPath );
		this.strHoeheAct = getstring( 'HOEHE_ACT', strPath );
		this.strHoeheMax = getstring( 'HOEHE_MAX', strPath );

		// Masse:
		this.strCS 	 = getstring( "CS", strPath );
		this.strAS 	 = getstring( "AS", strPath );
		this.strBS 	 = getstring( "BS", strPath );
		this.strSS 	 = getstring( "SS", strPath );
		this.strDS 	 = getstring( "DS", strPath );
		this.strFS 	 = getstring( "FS", strPath );
		this.strD2 	 = getstring( "D2", strPath );
		this.strS2 	 = getstring( "S2", strPath );

		// -mw- 4/2009 fr LX...
		this.strANZ_LG		 = getstring( "ANZ_LG", strPath );
		this.strABST_LG		 = getstring( "ABST_LG", strPath );
		this.strE_LG		 = getstring( "E_LG", strPath );
		this.strA_LG		 = getstring( "A_LG", strPath );
		this.strB_LG		 = getstring( "B_LG", strPath );
		this.strL_LG		 = getstring( "L_LG", strPath );

        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Lager" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen aus der Datenbank
		setstring( "TYP", strPath, this.strTyp );
		setstring( "PROFILFORM", strPath, this.strProfilform );
		setstring( "TrT", strPath, this.strTraegertyp );				// neu scb 22.06.09
		setstring( "TRAEGERBREITE", strPath, this.strDBTraegerbreite );
		setstring( "BAU_F", strPath, this.strBauF );
		setstring( "DN", strPath, this.strDN );
		setstring( "D", strPath, this.strD );
		setstring( "DM", strPath, this.strDM );
		setstring( "H", strPath, this.strH );
		setstring( "H_REAL", strPath, this.strH_REAL );
		setstring( "J", strPath, this.strJ );
		setstring( "FX", strPath, this.strFX );
		setstring( "FY", strPath, this.strFY );
		setstring( "FZ", strPath, this.strFZ );
		setstring( "L", strPath, this.strL );
		setstring( "B_AF", strPath, this.strB_AF );
		setstring( "GL_U", strPath, this.strGL_U );
		setstring( "S_L", strPath, this.strS_L );
		setstring( "WX", strPath, this.strWX );
		setstring( "WY", strPath, this.strWY );
		setstring( "GEW", strPath, this.strGEW );
		setstring( "WERK_", strPath, this.strWerk );
		setstring( "OBFL", strPath, this.strObfl );
		setstring( "IDENT", strPath, this.strIdent );
		setstring( "PREIS", strPath, this.strPreis );
		setstring( "BILD", strPath, this.strBild );
		setstring( "BAUFO", strPath, this.strBauform );
		setstring( "E_MIN_MAX", strPath, this.strEMinMax );
		setstring( "E", strPath, this.strE );
		setstring( "A", strPath, this.strA );
		setstring( "B", strPath, this.strB );
		setstring( "C", strPath, this.strC );
		setstring( "TF", strPath, this.strTF );
		setstring( "SCH_V", strPath, this.strSCH_V );
		setstring( "SCH_A", strPath, this.strSCH_A );
		setstring( "DAEM", strPath, this.strDaem );
		setstring( "E_SH", strPath, this.strE_SH );
		setstring( "FX_K", strPath, this.strFX_K );
		setstring( "FAB", strPath, this.strFAB );
		setstring( "FAB_K", strPath, this.strFAB_K );
		setstring( "TYP_BASF", strPath, this.strTypBASF );
		setstring( "BASF_NR", strPath, this.strBASF_Nr );
		setstring( "B_PL", strPath, this.strB_PL );
		setstring( "ANZ_PL", strPath, this.strAnz_PL );
		setstring( "L_PL", strPath, this.strL_PL );

		setstring( "ANZ_GEWST", strPath, this.strAnz_Gewst );
		
		// neu scb 22.06.09, fr Klemmsystem
		setstring( "L1L", strPath, this.strL1L );	
		setstring( "L1R", strPath, this.strL1R );
		setstring( "L2L", strPath, this.strL2L );	
		setstring( "L2R", strPath, this.strL2R );
		setstring( "L3L", strPath, this.strL3L );	
		setstring( "L3R", strPath, this.strL3R );
		setstring( "L4L", strPath, this.strL4L );	
		setstring( "L4R", strPath, this.strL4R );
		setstring( "H1L", strPath, this.strH1L );	
		setstring( "H1R", strPath, this.strH1R );
		setstring( "H2L", strPath, this.strH2L );	
		setstring( "H2R", strPath, this.strH2R );
		setstring( "H3L", strPath, this.strH3L );	
		setstring( "H3R", strPath, this.strH3R );
		setstring( "BKL", strPath, this.strBKL );	
		setstring( "BKR", strPath, this.strBKR );
		

		// Variablen fr Berechnungen
		setstring( "strNennlast", strPath, this.strNennlast );
		setstring( "strNennlastName", strPath, this.strNennlastName );
		setstring( "strHoeheMinMax", strPath, this.strHoeheMinMax );
		setstring( "strBasistyp", strPath, this.strBasistyp );
		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strTyp", strPath, this.strTyp );
		setstring( "strWerkstoffOberfl", strPath, this.strWerkstoffOberfl );
		// Variablen aus Konfiguration
		setstring( "strProfilart", strPath, this.strProfilart );
		setstring( "strTraegergroesse", strPath, this.strTraegergroesse );
		setstring( "strTraegerhoehe", strPath, this.strTraegerhoehe );
		setstring( "strTraegerbreite", strPath, this.strTraegerbreite );
		setstring( "strFlanschdicke", strPath, this.strFlanschdicke );

        // Betriebsbedngungen:
        setstring( "temperatur", strPath, this.temperatur );
        setstring( "daemmdicke", strPath, this.daemmdicke );
        setstring( "wx",         strPath, this.wx );
        setstring( "wy",         strPath, this.wy );
        setstring( "m_fz",       strPath, this.m_fz );
        setstring( "fz",         strPath, this.fz );
        setstring( "m_fx",       strPath, this.m_fx );
        setstring( "fx",         strPath, this.fx );
        setstring( "fy",         strPath, this.fy );

        setstring( "IDENT_LSL",   strPath, this.strIdentLSL );
        setstring( "IDENT_LAW",   strPath, this.strIdentLAW );
        setstring( "LAB",         strPath, this.strLAB );

		// Zusatzdaten fr hhenverstellbare Lager
		setstring( 'HOEHE_MIN', strPath, this.strHoeheMin );
		setstring( 'HOEHE_ACT', strPath, this.strHoeheAct );
		setstring( 'HOEHE_MAX', strPath, this.strHoeheMax );

		// Masse:
        setstring( "CS",         strPath, this.strCS );
        setstring( "AS",         strPath, this.strAS );
        setstring( "BS",         strPath, this.strBS );
        setstring( "SS",         strPath, this.strSS );
        setstring( "DS",         strPath, this.strDS );
        setstring( "FS",         strPath, this.strFS );
		setstring( "D2",         strPath, this.strD2 );
        setstring( "S2",         strPath, this.strS2 );

		// -mw- 4/2009 fr LX...
        setstring( "ANZ_LG",         strPath, this.strANZ_LG );
        setstring( "ABST_LG",         strPath, this.strABST_LG );
        setstring( "E_LG",         strPath, this.strE_LG );
        setstring( "A_LG",         strPath, this.strA_LG );
        setstring( "B_LG",         strPath, this.strB_LG );
        setstring( "L_LG",         strPath, this.strL_LG );

    },

	/**
     *  hole die Daten des Lagers, die in der Liste fr gefundene Lager angezeigt werden
	 *
	 * @params boolean bMitPreis - Preis mitliefern?
	 * @returns	object >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
	 */
    holeDisplayDaten : function( bMitPreis, dCurrencyFactor )
    {
		var data = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER_AUSWAHL" );
        var displayE = this.strE;
		if ( data.IDC_HOEHENVERSTELLUNG )
            displayE = this.strEMinMax;

		// Preis nach gewhlter Whrung korrigieren:
		var strDisplayPreis = (this.strPreis * dCurrencyFactor).toFixed( 2 );

        var daten =
		{
			typ: this.strTyp,
			nennweite: this.strDN,
			nennhoehe: this.strH,
            emass: displayE,
			max_daemmdicke: this.strJ,
			auflagelast_minus_fz: this.strFZ,
			axiallast_fy: this.strFY,
			querlast_fx: this.strFX,
			abhebelast_fz: this.strFAB,
			gewicht: this.strGEW,
			// preis: ( bMitPreis ? this.strPreis : '-' )
			preis: ( bMitPreis ? strDisplayPreis : '-' )
		};

		return( daten );
	},

	/**
     * prft, ob das Lager hhenverstellbar ist
	 *
	 * @params -
	 * @returns	boolean: true - Lager ist hhenverstellbar
	 *                   false - Lager ist nicht hhenverstellbar
	 */
	isHoehenverstellbar : function()
	{
		var zusatzbedingungen = caMainController.dataAccess.LagerDaten.holeZusatzbedingungen();
		return( zusatzbedingungen.bHoehenverstellung );
	},
	
	/**
     * prft, ob das Lager konfigurierbar ist
	 *
	 * @params -
	 * @returns	boolean: true - Lager ist konfigurierbar
	 *                   false - Lager ist nicht konfigurierbar
	 */
	isConfigurable : function()
	{
		var bIsConfigurable = true;

		// bei bestimmten Basistypen fr Fhrungslager ist keine Konfiguration ntig
		if ( ( this.strBaureihe == "FSN" ) || ( this.strBaureihe == "FSD" ) )
			bIsConfigurable = false;
		else
		{
			var strLagerart = caMainController.dataAccess.LagerDaten.holeLagerart();
			var zusatzbedingungen = caMainController.dataAccess.LagerDaten.holeZusatzbedingungen();

			// bei Loslagern ohne Gleitunterlage ist keine Konfiguration ntig
			if ( ( strLagerart == "ID_LOSLAGER" ) && !zusatzbedingungen.bGleitunterlage )
				bIsConfigurable = false;
			// bei speziellen Fhrungen ist ebenfals keine Konfiguration ntig
			else if ( ( strLagerart == "ID_FUEHRUNG_W2_180" ) || ( strLagerart  == "ID_FUEHRUNG_W2_090" ) ||
	  	              ( strLagerart  == "ID_FUEHRUNG_W3" ) || ( strLagerart  == "ID_FUEHRUNG_W4" ) ||
                      ( strLagerart  == "ID_FUEHRUNGSLAGER_W" ) )
				bIsConfigurable = false;
			else if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' ist nicht konfigurierbar
				bIsConfigurable = false;
		}

		return( bIsConfigurable );
	},

	/**
     * setze gewhlte Profilart, Trgergre und alle abgeleiteten Werte in aktuell gewhltes Lager und korrigiere alle anderen Werte
	 * des Lagers (Typ, Preis etc.) entsprechend
	 *
	 * @params string strProfilart - ID der aktuell gewhlten Profilart
	 *         string strTraegergroesse - aktuell gewhlte Trgergre
	 * @returns	-
     */
	konfiguriere : function( strProfilart, strTraegergroesse )
	{
		// setze Profilart und Trgergre
		this.strProfilart = strProfilart;
		this.strTraegergroesse = strTraegergroesse;

		// berechne und setze Trgerhhe, -breite und Flanschdicke
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( strProfilart, strTraegergroesse, this );
		this.strTraegerhoehe = oTraegerdaten.strTraegerhoehe;
		this.strTraegerbreite = oTraegerdaten.strTraegerbreite;
		this.strFlanschdicke = oTraegerdaten.strFlanschdicke;

		// korrigiere interne Daten , die aus der Datenbank gelesen wurden
		var strProfilform = "T";
		if ( strProfilart == "U_PROFIL" )
			strProfilform = "U";
		else if ( ( strProfilart == "L_PROFIL_G" ) || ( strProfilart == "L_PROFIL_U" ) )
			strProfilform = "L";

		// Daten in der Datentabelle fr die Lagerbaureihe suchen (Werk ndert sich nicht bei der Konfiguration!)
		var strSelect = "SELECT * FROM " + this.strBaureihe + " WHERE TYP = '" + oTraegerdaten.strTyp +
		                "' AND ( PROFILFORM = '" + strProfilform + "' OR PROFILFORM = '' ) AND WERK_ = '" + this.strWerk + "' ";
		var strDBCache = "RH_DATEN";
		if ( dbselect( "LAGER", strSelect, strDBCache ) )
			this._leseDatenAusDB( strDBCache );		// nur neukonfigurieren, wenn was gefunden
		else
		{
			// dann ist die Bezeichnung des konfigurierten Lagers aus Basistyp und Klemmtrger mit/ohne Werkstoff Oberflche --> neue Suche mit neuem Select
			strSelect = "SELECT * FROM " + this.strBaureihe + " WHERE TYP like '" + this.strBasistyp +
		                "%' AND ( PROFILFORM = '" + strProfilform + "' OR PROFILFORM = '' ) AND WERK_ = '" + this.strWerk + "' ";
			if ( dbselect( "LAGER", strSelect, strDBCache ) )
				this._leseDatenAusDB( strDBCache );		// nur neuknofigurieren, wenn was gefunden
		}
		if ( this.strProfilform )
			this.strProfilform = strProfilform;
		this.strTyp = oTraegerdaten.strTyp;
		this.m_Ptyp = this.strTyp;
	},


	/**
     * berechne die Defaultwert fr den Oberflchenschutz des Lagers (mgliche Schutzarten: siehe CascadeProdukt.es, globales Objekt 'MoeglicherOberflaechenschutz')
	 *
	 * @params -
	 * @returns	integer index der Oberflchenschutzgruppe
	 */
	getOberFlaechenSchutzGruppe : function()
	{
		var nGruppe = 0; // default: '-'

		// dieses %$&$"& DataAccessObject steht manchmal noch nicht zur Verfgung, wenn die Klasse durch Serialisierung erzeugt wird
		// deswegen mu hier der Store direkt abgefragt werden
		var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

		// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
		var expert_mode = getint ("EXPERT_MODE", "RIGHTS");
		
		if ( dTemperatur <= 300 )
		{
			if ( left( this.strTyp, 3 ) == 'LUR' || expert_mode == 1)	// alter Loslagertyp 'LUR' hat mehr Varianten / -Schu- fuer alle Varianten im Expert Mode
				nGruppe = 11;		// roh, feuerverzinkt und grundiert
			else nGruppe = 8;		// nur feuerverzinkt
		}
		else if ( dTemperatur <= 450 )
		{
			nGruppe = 3;		// roh und grundiert
			// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
			if ( substr( this.strTyp, 1, 1 ) == "I" )
				nGruppe = 8;	// nur feuerverzinkt
		}
		else if ( dTemperatur > 450 )
			nGruppe = 3;		// roh und grundiert

		return( nGruppe );
	},

	/**
     * berechne die Oberflchenschutzgruppe fr das Lager (mgliche Gruppen: siehe CascadeProdukt.es, globales Objekt 'Oberflaechenschutz')
	 *
	 * @params -
	 * @returns	string Oberflchenschutz
	 */
	getOberFlaechenSchutzDefault : function()
	{
		var strSchutz = 'OB_SONST'; // default: 'sonstiger'

		if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' hat den Oberflchentyp schon in der Typbezeichnung
		{
			var strID = right( this.strTyp, 1 );
			if ( strID == '0' )
				strSchutz = 'OB_ROH';
			else if ( strID == '1' )
				strSchutz = 'OB_GALV';
			else if ( strID == '2' )
				strSchutz = 'OB_FEUER';
			else if ( strID == '3' )
				strSchutz = 'OB_GRUND';
			else if ( strID == '4' )
				strSchutz = 'OB_SONST';
			//else strSchutz = 'OB_SONST'; ist default
		}
		else
		{
			// dieses %$&$"& DataAccessObject steht manchmal noch nicht zur Verfgung, wenn die Klasse durch Serialisierung erzeugt wird
			// deswegen mu hier der Store direkt abgefragt werden
			var dTemperatur = ( getdouble( "IDC_TEMPERATUR_TS", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN" ) || 20 );

			// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
			if ( dTemperatur <= 300 )
				strSchutz = 'OB_FEUER';			// nur feuerverzinkt mglich
			else if ( dTemperatur <= 450 )
			{
				strSchutz = 'OB_ROH';		// roh
				// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
				if ( substr( this.strTyp, 1, 1 ) == "I" )
					strSchutz = 'OB_FEUER';		// nur feuerverzinkt mglich
			}
			else if ( dTemperatur > 450 )
				strSchutz = 'OB_ROH';		// roh
		}

		return( strSchutz );
	},

	/**
     * bestimme die Typbezeichnung des Lagers und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Lagers
	 */
	makeTyp : function()
	{

		// Mass-String fr STK-Export:
		this.m_strMasse  = " TrT " + this.strTraegertyp + " Brt " + this.strTraegerbreite + " TrH " + this.strTraegerhoehe + " Tg10 " + this.strFlanschdicke;
		this.m_strMasse += " BAU_F " + this.strBauF + " DN " + this.strDN + " D " + this.strD + " DM " + this.strDM + " H " + this.strH + " H_REAL " + this.strH_REAL;
		this.m_strMasse += " L " + this.strL + " B_AF " + this.strB_AF +  " GL_U " + this.strGL_U + " S_L " + this.strS_L + " WX " + this.strWX + " WY " + this.strWY + " GEW " + this.strGEW + " WERK_ " + this.strWerk;
		this.m_strMasse += " E " + this.strE + " A " + this.strA + " B " + this.strB + " C " + this.strC + " TF " + this.strTF + " SCH_V " + this.strSCH_V + " SCH_A " + this.strSCH_A; 
		this.m_strMasse += " B_PL " + this.strB_PL + " ANZ_PL " + this.strAnz_PL + " ANZ_GEWST " + this.strAnz_Gewst + " L_PL " + this.strL_PL + " LAB " + this.strLAB;
		this.m_strMasse += " CS " + this.strCS + " AS " + this.strAS + " BS " + this.strBS + " SS " + this.strSS + " DS " + this.strDS + " FS " + this.strFS + " D2 " + this.strD2 + " S2 " + this.strS2;
		this.m_strMasse += " ANZ_LG " + this.strANZ_LG + " ABST_LG " + this.strABST_LG + " E_LG " + this.strE_LG + " A_LG " + this.strA_LG + " B_LG " + this.strB_LG + " L_LG " + this.strL_LG;
		this.m_strMasse += " L1L " + this.strL1L + " L1R " + this.strL1R + " L2L " + this.strL2L + " L2R " + this.strL2R + " L3L " + this.strL3L;
		this.m_strMasse += " L3R " + this.strL3R + " L4L " + this.strL4L + " L4R " + this.strL4R + " H1L " + this.strH1L + " H1R " + this.strH1R;
		this.m_strMasse += " H2L " + this.strH2L + " H2R " + this.strH2R + " H3L " + this.strH3L + " H3R " + this.strH3R + " BKL " + this.strBKL + " BKR " + this.strBKR;


		// lese gewhlten Oberflchenschutz aus und korrigiere den Oberflchenkenner des Typs
		this._korrigiereWerkstoffOberflaeche();
		var oDaten = Cascade.Lagerkonfiguration.holeTraegerdaten( this.strProfilart, this.strTraegergroesse, this );
		if ( oDaten.strTyp )
			this.strTyp = oDaten.strTyp;

		this.m_Ptyp = this.strTyp;
        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function(strTyp)
	{
		var strTypNr = [];
		var strDim = [];
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.strBaureihe = this.m_Ptypid;
		this.m_Poberfl = "";

        this.temperatur = "20";
        this.daemmdicke = "-";

		this.wx = "-";
		this.wy = "-";
		this.m_fz = "-";
		this.fz = "-";
		this.m_fx = "-";
		this.fx = "-";
		this.fy = "-";

	// Suche in DBs

		strTypNr = splitVarDelimiter(strTyp, " ..-..");
		var lenNr = strTypNr.length;

		var strWhere1 = "", strWhere2 = "";
		var strProfil = "", strProfilSave = "", strB = "", strH = "", strD = "";
		var strWerkstoff = "", strOberfl = "", strKlemm = "";
		var strTypSuchNr = this.m_Ptypid + " " +
			getVarDelimited(strTypNr, 1) + "." +
			getVarDelimited(strTypNr, 2) + "." +
			getVarDelimited(strTypNr, 3);

		if(lenNr > 4)
		{
			strKlemm = getVarDelimited(strTypNr, 4);
			strProfil = left(strKlemm, 1);
			if(find("TUL", strProfil) == -1)
			{
				strProfil = "";
				strKlemm = "";
			}
			strProfilSave = strProfil;

			// b x h x d aufsplitten
			if(find(getVarDelimited(strTypNr, 4), "x") > -1)
				strDim = splitVarDelimiter(strKlemm, "xx");

			if(strProfil != "")
				strTypSuchNr += "-" + strProfil + "XXX";
			else if(strKlemm!="")
				strTypSuchNr += "-" + strKlemm;

			if(find(strKlemm, "x") > -1)
				strTypSuchNr += "xXXX";
		}

		// Werkst+OberflSch als 2.Mglichkeit in Suche einbeziehen
		if(lenNr > 6)
		{
			// alles eingegeben
			strWerkstoff = getVarDelimited(strTypNr, 5);
			strOberfl = "." + getVarDelimited(strTypNr, 6);
		}
		else if(lenNr > 5 && strProfil == "")
		{
			// Profilart fehlt
			strWerkstoff = getVarDelimited(strTypNr, 4);
			strOberfl = "." + getVarDelimited(strTypNr, 5);
		}
		else if(lenNr > 5)
		{
			// Oberflchenschutz fehlt
			strWerkstoff = getVarDelimited(strTypNr, 5);
			// Default 2
			strOberfl = ".2";
		}
		else
		{
			// Default 37.2
			strWerkstoff = "37";
			strOberfl = ".2";
		}

		strWhere1 = "TYP = '" + strTypSuchNr + "'";
		if(strWerkstoff + strOberfl != "")
			strWhere2 = " OR TYP = '" + strTypSuchNr + "-" + strWerkstoff + strOberfl + "'";

	// Profil Default
		if(strProfil == "")
		{
			strProfilSave = "T";
			strKlemm = "T140";
		}

	// alle mglichen VAR_KLEMM suchen
		if(strProfilSave != "")
		{
			var aTrae = [ "T_PROFIL", "HEA", "HEB", "INP", "IPE", "L_PROFIL_G", "L_PROFIL_U", "U_PROFIL" ];
			var strSelectTrae = "";
			var i;
			for(i = 0; i < aTrae.length; i++)
			{
				strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] +
					" WHERE VAR_KLEMM='" + strKlemm + "'";
				if(i < aTrae.length-1)
					strSelectTrae += " UNION ";
			}
			strSelectTrae += " order by VAR_KLEMM";		//TAB,

			if(dbselect("LAGER", strSelectTrae, "TYPSUCHE_TRAE") == 0)
				return "Falscher Wert: "+strKlemm;
		}

		var strSelect = "SELECT * FROM " + this.m_Ptypid + " WHERE " + strWhere1 + strWhere2;
		if ( this.m_Ptypid == 'LUR' )
		{
			// andere Systematik fr alte Loslager: Typschlssel ist auch Typ in der Datenbank,
			// andere Mglichkeiten bei Oberflchenschutz und Werkstoff werden dadurch gleich mitbehandelt
			strSelect = "SELECT * FROM LSL WHERE " + strWhere1 + strWhere2;
		}
		if(dbselect("LAGER", strSelect, "TYPSUCHE_LAGER"))
		{
			this._leseDatenAusDB("TYPSUCHE_LAGER");
			this.strBasistyp = dbgetstring("TYPSUCHE_LAGER", "TYP");
			this.strBaureihe = left( this.strBasistyp, 3 );
            this.strHoeheAct = this.strH;
		}
		else
			return "Kein Produkt gefunden !";

	// Daten aus Typnummer
		this.m_Poberfl = 0;
		if(lenNr > 6 || (strProfil == "" && lenNr > 5))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-2));
			this.strWerkstoffOberfl = this.strWerk + "." + getVarDelimited(strTypNr, (lenNr-1));
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, (lenNr-1))];
		}
		else if(lenNr > 5 || (strProfil == "" && lenNr > 4))
		{
			this.strWerk = getVarDelimited(strTypNr, (lenNr-1));
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}
	//Defaults
		else
		{
			this.strWerk = "37";
			this.strWerkstoffOberfl = this.strWerk + ".2";
			this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(this.strWerk);
			this.m_Poberfl = OberflaechenschutzRevers["Ob2"];
		}

	// evtl. auch mit Defaults berechnet
		if(strProfilSave != "")
		{
			this.strProfilart = dbgetstring("TYPSUCHE_TRAE", "TAB");
			this.strTraegergroesse = dbgetstring("TYPSUCHE_TRAE", "TRAE_GR");
			this.strTraegerbreite = dbgetstring("TYPSUCHE_TRAE", "B");
			this.strTraegerhoehe = dbgetstring("TYPSUCHE_TRAE", "H");
			this.strFlanschdicke = dbgetstring("TYPSUCHE_TRAE", "TG");
		}

		//this.m_Pemass = RoundDoubleToInt(this.strE);   // -mw- wird auch gebraucht

		this._korrigiereWerkstoffOberflaeche();
		//var oDaten = Cascade.Lagerkonfiguration.holeTraegerdaten( this.strProfilart, this.strTraegergroesse, this );

        this.getPreis();

        return( bOK ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Lagers, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 *         bool bIsEinzel - Einzelprodukt (true) oder Lastkette (false)
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung, bIsEinzel )
    {
		if ( bIsEinzel )
		{
			var strFile = '';
			if ( this.strBauform )
				strFile = "catalog/client/custom/img/WITgifs/RH/" + this.strBauform + ".jpg";
			else 
				strFile += 'catalog/client/custom/img/panels/empty.gif';
			
			return( strFile );
		}

        if ( ( Drehung == 90 ) || ( Drehung == 270 ) )
			return ( "catalog/client/custom/img/panels/THAN_S.png" );
		return ( "catalog/client/custom/img/panels/THAN.png" );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Lagers sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Lagers delegieren
		this.serializeOut( strPath );

        return 1;
    },

	/**
     * bestimme den Preis des Lagers und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	double: Preis des Lagers
	 */
	getPreis : function(oOptions)
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );

		// hier mssen wir den Preis neu berechnen, da er sich durch nderung des Oberflchenschutzes in
		// der Stckliste ebenfalls gendert haben knnte (die Bestellnummer wird in getASTLDaten neu berechnet)
		this.strPreis = Cascade.Lagerkonfiguration.holePreis( this );
		this.m_Ppreis = this.strPreis;

        if (oOptions.SONDERANSTRICH_KOSTEN > 0)
            this.m_Ppreis = inputStringToDouble(this.m_Ppreis) + (oOptions.SONDERANSTRICH_KOSTEN * inputStringToDouble(this.m_Pgewicht));

		// in den Tabellen stehen momentan nur Preise fr die Defaultversion des Oberflchenschutzes
        this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_SCHELLEN");

        return( this.m_Ppreis );
	},

	/**
     * prft, ob das Lager in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function(oProfil)
    {
		// Lager ist dann in SAP konfigurierbar, wenn Profilart und Trgergre whlbar sind
		var bIsConfigurable = this.isConfigurable();

		// nderungen daran hier einfgen
		if (bIsConfigurable && (oProfil.strProfilform == "T") && (oProfil.strTraegerbreite == "140"))
            bIsConfigurable = false;
        if ((this.m_Ptypid == "LSW") || (this.m_Ptypid == "LXA") || (this.m_Ptypid == "LXV"))
            bIsConfigurable = true;
        
        return( bIsConfigurable ? 1 : 0 );
    },

	/**
     * holt den SAP-Klassennamen des Lagers
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
        var strBaureihe = left( this.strTyp, 3 );
		var strKlasse = '';

		// unterschiedlicher SAPKlassenname je nach Lagerbaureihe
		if ( ( strBaureihe == 'LKG' ) || ( strBaureihe == 'LSG' ) || ( strBaureihe == 'LKF' ) || ( strBaureihe == 'LSF' ) )
			strKlasse = 'CFG';
		else if ( strBaureihe == 'LVG' )
			strKlasse = 'CFH';
		else if ( strBaureihe == 'IKG' )
			strKlasse = 'CFV';
		else if ( ( strBaureihe == 'LKL' ) || ( strBaureihe == 'LSL' ) || ( strBaureihe == 'LXL' ) )
			strKlasse = 'CLG';
		else if ( strBaureihe == 'LUR' )
			strKlasse = 'GUR'
		else if ( strBaureihe == 'LVL' )
			strKlasse = 'CLH';
		else if ( strBaureihe == 'IKL' )
			strKlasse = 'CLV';
		else if ( strBaureihe == 'FLN' )
			strKlasse = 'CPG';
		else if ( strBaureihe == 'FVN' )
			strKlasse = 'CPH';
		else if ( ( strBaureihe == 'FSN' ) || ( strBaureihe == 'FSD' ) )
			strKlasse = 'CPS';
		else if ( strBaureihe == 'FLV' )
			strKlasse = 'CPV';
		else if ( ( strBaureihe == 'LSW' ) || ( strBaureihe == 'LXA' ) || ( strBaureihe == 'LXV' ) )
			strKlasse = 'LK1';
		else alert( 'Baureihe ' + strBaureihe + ' hat keine SAP-Klasse' );

        return( strKlasse );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Lagertyp in SAP
	 */
    getSAPTyp : function()
    {
        return( this.strBaureihe );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];
		var oProfil = Cascade.Lagerkonfiguration.holeProfilformUndTraegerbreiteFuerDB( this );
		var strSAPTyp = this.strBaureihe + ' ' + this.strBauF;

        retObj.loeseauf = this.isSAPKonfigurierbar(oProfil);

        var strSAPAussendurchmesser = this.strD;
        /* 3.4.2008: Datenbank jetzt bereinigt
		var strSAPAussendurchmesser = replace( this.strD, '.', ',' );
		if ( strSAPAussendurchmesser.indexOf( ',' ) < 0 )	// in der Tabelle mit SAP-Merkmalen ist z.B. 475 als '475,0' angegeben
			strSAPAussendurchmesser += ',0';
        */

        var oOptions = theMainController.presets.getPreisOptions();
        if (oOptions.SONDERANSTRICH_TEXT != "")
            sapOberflaechenschutz = "0";

		if ( ( strKlasse == 'CFG' ) || ( strKlasse == 'CFH' ) || ( strKlasse == 'CLG' ) || ( strKlasse == 'CLH' ) )
		{
			// NENNWEITE, NENNHOEHE, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILHOEHE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				NENNHOEHE: this.strH,
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				PROFILHOEHE: '',						// ist nicht suchrelevant
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CFV' )
		{
			// NENNWEITE, AUSSENDURCHMESSER, TRAEGERBREITE, MANTELDURCHMESSER, PROFILHOEHE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				MANTELDURCHMESSER: this.strDM,
				PROFILHOEHE: '',						// ist nicht suchrelevant
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CLV' )
		{
			// NENNWEITE, AUSSENDURCHMESSER, MANTELDURCHMESSER, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				MANTELDURCHMESSER: this.strDM,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( ( strKlasse == 'CPG' ) || ( strKlasse == 'CPH' ) )
		{
			// NENNWEITE, NENNHOEHE, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				NENNHOEHE: this.strH,
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CPS' )
		{
			// NENNWEITE, KURZBEZ, AUSSENDURCHMESSER, NENNHOEHE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				KURZBEZ: strSAPTyp,						// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.strH,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'CPV' )
		{
			// NENNWEITE, MANTELDURCHMESSER, AUSSENDURCHMESSER, TRAEGERBREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				MANTELDURCHMESSER: this.strDM,
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				TRAEGERBREITE: oProfil.strTraegerbreite,
				PROFILFORM: oProfil.strProfilform,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'GUR' )
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.strH,
				EINBAUMASS: this.strE,
				LAENGE: this.strL,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'SPZ' )
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.strH,
				EINBAUMASS: this.strE,
				LAENGE: this.strL,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		else if ( strKlasse == 'LK1' )	// Lagertypen mit Abhebesicherung
		{
			strSAPTyp = left( this.strTyp, 3 );
			// NENNWEITE, AUSSENDURCHMESSER, NENNHOEHE, EINBAUMASS, LAENGE, OBERFLAECHENSCHUTZ, WERKSTOFFS, TYP
			searchObj = {
				NENNWEITE: this.strDN,					// ist nicht suchrelevant, in der DB trotzdem gefllt
				AUSSENDURCHMESSER: strSAPAussendurchmesser,
				NENNHOEHE: this.strH,
				EINBAUMASS: this.strE,
				LAENGE: this.strL,
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFFS: sapWerkstoffBez,
				TYP: strSAPTyp
			};
		}
		//else alert( 'kein Datenobjekt fr SAP-Klasse ' + strKlasse );

        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;

        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if ( this.isSAPKonfigurierbar(oProfil) )
            retObj.postext1 = this.m_Ptyp;

        return( retObj );
	},

	/**
     *  hole Subtyp des Lagers (Baureihe + erste Ziffer der Nennhhe + optional Trgerform)
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		var strHoehe = left( this.strBauF, 1 );
		var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';
		if ( strTraegerID == 'T' )
		{
			if ( this.strTraegerbreite <= 140 )
				strTraegerID += '140';
			else strTraegerID += 'XXX';
		}

		// subtyp: Baureihe + erste Ziffer der Nennhhe + optional Trgerform
		var strSubtyp = '';

		// leicht unterschiedliche Bildungsvorschriften fr den Subtyp, je nach Baureihe (siehe Exceldatei 'SAP_M_Daten_aktuell.xls', Sheet 'SUB_Typ_Legende')
		// --> Ausnahmen zu obiger Regel
		if ( ( this.strBaureihe == 'LSL' ) || ( this.strBaureihe == 'LXL' )|| ( this.strBaureihe == 'FSN' ) || ( this.strBaureihe == 'FSD' )
			|| ( this.strBaureihe == 'LSW' ) || ( this.strBaureihe == 'LXA' ) || ( this.strBaureihe == 'LXV' ) )
		    strSubtyp = ''; //this.strBaureihe;
		else if (( this.strBaureihe == 'FLN' ) || ( this.strBaureihe == 'FVN' ))
        {
            if ((this.strBauF == "20") || (this.strBauF == "21"))
                strSubtyp = this.strBaureihe + '22_' + strTraegerID;
            else
                strSubtyp = this.strBaureihe + this.strBauF + '_' + strTraegerID;
        }
		else if ( this.strBaureihe == 'FLV' )
			strSubtyp = this.strBaureihe + this.strBauF + '_' + strTraegerID;
			
		else if ( ( strHoehe == '4' ) && ( this.strBaureihe == 'LVL' )  )
        {
            if ((this.strBauF == "40") || (this.strBauF == "41") || (this.strBauF == "42"))
                strSubtyp = this.strBaureihe + '42_' + strTraegerID;
            else
                strSubtyp = this.strBaureihe + '43_' + strTraegerID;
        }
		else if ( ( strHoehe == '2' ) &&
		          ( ( this.strBaureihe == 'LKF' ) || ( this.strBaureihe == 'LSF' ) || ( this.strBaureihe == 'LKL' ) || ( this.strBaureihe == 'LVL' ) ||
			        ( this.strBaureihe == 'IKL' ) ) )
			strSubtyp = this.strBaureihe + strHoehe;
		else if ( (( strHoehe == '3' ) || ( strHoehe == '4' ) || ( strHoehe == '6' ))  &&
		          ( ( this.strBaureihe == 'LKF' ) || ( this.strBaureihe == 'LSF' ) ) )
			strSubtyp = this.strBaureihe + "2";
		else if ( ( strHoehe == '4' ) && ( this.strBaureihe == 'LVG' )  )
        {
            if ((this.strBauF == "40") || (this.strBauF == "41") || (this.strBauF == "42"))
                strSubtyp = this.strBaureihe + '42_' + strTraegerID;
            else
                strSubtyp = this.strBaureihe + '43_' + strTraegerID;
        }
		else if ( this.strBaureihe == 'LSG' )
            strSubtyp = this.strBaureihe + '_' + strTraegerID;
        else
            strSubtyp = this.strBaureihe + strHoehe + '_' + strTraegerID;

		return( strSubtyp );
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Lagers
	 *
	 * @params integer nStartPos - startposition des Lagers in der Lastkette
	 *         integer nPosNr - Position des Lagers in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Lagers beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = this.strBaureihe + this.strBauF;
        if (this.m_Ptypid == "LUR")
            strTypForCAD = "LUR";
        
        /* Daemmung wird ber Men geregelt:
		var strDaemmungForCAD = '0';
		if ( this.strDaem.indexOf( 'w' ) > -1 )	// vorisoliert und wrmegedmmt
			strDaemmungForCAD = '1';
        */
		var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';

		var strHMass = this.strH_REAL
		if (strHMass == "")		// 02/2009: weil dieser Wert erst spter dazu kam ... Kompatibilitt zu lteren Versionen
			strHMass = this.strH;

		var strEMass = this.strE;

		// Hhenbereiche fr hhenverstellbare Lager
		var strHoehenbereich = 'H1';
		var data = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER_AUSWAHL" );
		if ( data.IDC_HOEHENVERSTELLUNG )
		{
			// Zuordnung zu den Hhenbereichen gemaess Vorgabe -schm- 16.4.2008
			if ( atoi(this.strH) <= 100 )
				strHoehenbereich = 'H1';
			else if ( atoi(this.strH) <= 150 )
				strHoehenbereich = 'H2';
			else strHoehenbereich = 'H3';
			
			strHMass = this.strHoeheAct;
			strEMass = RoundDoubleToInt (int(strHMass) + this.strD / 2);
			this.m_Pemass = RoundDoubleToInt( strEMass );   // -mw- wird auch gebraucht
		}
		

		// setze CAD-Parameter
        if (nTyp == "E")
            aParams.push( [ "Typ", "" + strTypForCAD ] );
        else aParams.push( [ "Position" + nStartPos, "" + strTypForCAD ] );
        // aParams.push( [ "Typ", strTypForCAD ] );
        // aParams.push( [ "Daemmung", strDaemmungForCAD ] );
        aParams.push( [ "Rohraussendurchmesser", this.strD ] );
        aParams.push( [ "DM", this.strDM ] );
        aParams.push( [ "E-Mass", this.strE ] );
        aParams.push( [ "E-Mass1", this.strE ] );
        aParams.push( [ "E-Mass2", this.strE ] );
        aParams.push( [ "E-Mass3", this.strE ] );
        aParams.push( [ "E-Mass4", this.strE ] );
        aParams.push( [ "H-Mass",  strHMass ] );
        aParams.push( [ "H-Mass1", strHMass ] );
        aParams.push( [ "H-Mass2", strHMass ] );
        aParams.push( [ "H-Mass3", strHMass ] );
        aParams.push( [ "H-Mass4", strHMass ] );
        aParams.push( [ "Daemmdicke", this.daemmdicke ] );  // this.strJ - hier soll die gewnschte, nicht die maximale Dmmung ausgegeben werden
        aParams.push( [ "Hoehenbereich", strHoehenbereich ] );
        /*
		if ( this.strS_L == '0' )
			aParams.push( [ "Schellenwinkel", "0" ] );		// Schelle horizontal
		else aParams.push( [ "Schellenwinkel", "45" ] );	// Schelle 30-45 gedreht
        */
        // -mw- 04/2008: Neue Vorgabe -schm-
        if ((this.m_Ptypid == "LKF") || (this.m_Ptypid == "LSF"))
			aParams.push( [ "Schellenwinkel", "45" ] );		// Schelle 30-45 gedreht
		else aParams.push( [ "Schellenwinkel", "0" ] );	    // Schelle horizontal
        aParams.push( [ "Werkstoff", this.strWerk ] );
        aParams.push( [ "Tr-Typ", strTraegerID ] );
        aParams.push( [ "Tr-Typ1", strTraegerID ] );
        aParams.push( [ "Tr-Typ2", strTraegerID ] );
        aParams.push( [ "Tr-Typ3", strTraegerID ] );
        aParams.push( [ "Tr-Typ4", strTraegerID ] );
        aParams.push( [ "Btr", this.strTraegerbreite ] );
        aParams.push( [ "Btr1", this.strTraegerbreite ] );
        aParams.push( [ "Btr2", this.strTraegerbreite ] );
        aParams.push( [ "Btr3", this.strTraegerbreite ] );
        aParams.push( [ "Btr4", this.strTraegerbreite ] );
        aParams.push( [ "Htr", this.strTraegerhoehe ] );
        aParams.push( [ "Htr1", this.strTraegerhoehe ] );
        aParams.push( [ "Htr2", this.strTraegerhoehe ] );
        aParams.push( [ "Htr3", this.strTraegerhoehe ] );
        aParams.push( [ "Htr4", this.strTraegerhoehe ] );
        aParams.push( [ "tG", this.strFlanschdicke ] );		// ist das identisch zur Gurtdicke? Ja.
        aParams.push( [ "tG1", this.strFlanschdicke ] );
        aParams.push( [ "tG2", this.strFlanschdicke ] );
        aParams.push( [ "tG3", this.strFlanschdicke ] );
        aParams.push( [ "tG4", this.strFlanschdicke ] );

        aParams.push( [ "LAB", this.strLAB ] );

        aParams.push( [ "ANZ_LG", this.strANZ_LG ] );
        aParams.push( [ "ABST_LG", this.strABST_LG ] );
        aParams.push( [ "E_LG", this.strE_LG ] );
        aParams.push( [ "A_LG", this.strA_LG ] );
        aParams.push( [ "B_LG", this.strB_LG ] );
        aParams.push( [ "L_LG", this.strL_LG ] );

        return( [ aParams, nPosNr + 1 ] );
    },

	/**
     * setze Hhendaten fr hhenverstellbare Lager
	 *
	 * @params -
	 * @returns	object aDaten - zustzliche Hhendaten
     */
	holeHoehendaten : function()
	{
		this.m_Pemass = RoundDoubleToInt (int(this.strHoeheAct) + this.strD / 2);   // -mw- wird auch gebraucht
		return( {
			strMin: this.strHoeheMin,
			strAct: this.strHoeheAct,
			strMax: this.strHoeheMax,
			strMinMax: this.strHoeheMinMax,
            strEMinMax: this.strEMinMax,
            m_Pemass: this.m_Pemass
		} );
	},
	
	/**
     * setze Hhendaten fr hhenverstellbare Lager
	 *
	 * @params string strValue - aktuelle Hhe
	 * @returns	-
     */
	setzeHoehendaten : function( strValue )
	{
		this.strHoeheAct = strValue;
		this.m_Pemass = RoundDoubleToInt (int(this.strHoeheAct) + this.strD / 2);   // -mw- wird auch gebraucht
	}	
	
});
