/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Konstanthaenger
 */
Konstanthaenger = function() {

	Konstanthaenger.superclass.constructor.call(this);

	/**
     *
     * @var
     */
	this.groesse		= "";
	this.nennweg		= 0;
	this.sollweg		= 0;	// +- je nach richtung (wichtig f. Gew.st.lngenanpassung!)
	this.sollweg_auf	= 0;
	this.sollweg_ab		= 0;
	this.sollast		= 0;
	this.weg_res		= 0;
	this.res_min		= 0;		// pro Endlage!
	this.justplus		= 0;
	this.justminus		= 0;  // zw. 0 und 15 %

	this.lgv			= "";
	this.estern			= 0;
	this.lastjust_konst	= 0;

	this.X		= 0;
	this.F		= 0;
	this.L		= 0;
	this.B		= 0;
	this.G		= 0;
	this.H		= 0;
	this.kl_e	= 0;

    this.SollastHpkt = 0;
    this.Zusatzlast  = 0;

    this.AnpassungEmass  = 0;		// Emass kann angepasst werden
};


EasyKat.extend(Konstanthaenger, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);

        // Einfache Variablen einlesen, je nach Typ
        this.groesse   = getstring("groesse",strPath);
        this.nennweg   = getdouble("nennweg",strPath);
        this.sollweg   = getdouble("sollweg",strPath);
		this.sollweg_auf	= getdouble("sollweg_auf",strPath);
		this.sollweg_ab		= getdouble("sollweg_ab",strPath);
        this.sollast   = getdouble("sollast",strPath);
        this.weg_res   = getdouble("weg_res",strPath);
        this.res_min   = getdouble("res_min",strPath);
        this.justplus  = getdouble("justplus",strPath);
        this.justminus = getdouble("justminus",strPath);

        this.lgv 	   = getstring("lgv",strPath);
        this.estern    = getdouble("estern",strPath);
        this.lastjust_konst   = getdouble("lastjust_konst",strPath);

        this.X      = getdouble("X",strPath);
        this.F      = getdouble("F",strPath);
        this.L      = getdouble("L",strPath);
        this.B      = getdouble("B",strPath);
        this.G      = getdouble("G",strPath);
        this.H      = getdouble("H",strPath);
        this.kl_e   = getdouble("kl_e",strPath);

        this.SollastHpkt = getdouble("SollastHpkt",strPath);
        this.Zusatzlast  = getdouble("Zusatzlast",strPath);

		this.AnpassungEmass = getdouble("AnpassungEmass",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Konstanthaenger");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen

        setstring("groesse",         strPath, this.groesse);
        setdouble("nennweg",         strPath, this.nennweg);
        setdouble("sollweg",         strPath, this.sollweg);
		setdouble("sollweg_auf",     strPath, this.sollweg_auf);
		setdouble("sollweg_ab",      strPath, this.sollweg_ab);
        setdouble("sollast",         strPath, this.sollast);
        setdouble("weg_res",         strPath, this.weg_res);
        setdouble("res_min",         strPath, this.res_min);
        setdouble("justplus",        strPath, this.justplus);
        setdouble("justminus",       strPath, this.justminus);

        setstring("lgv",             strPath, this.lgv);
        setdouble("estern",          strPath, this.estern);
        setdouble("lastjust_konst",  strPath, this.lastjust_konst);

        setdouble("X",         strPath, this.X);
        setdouble("F",         strPath, this.F);
        setdouble("L",         strPath, this.L);
        setdouble("B",         strPath, this.B);
        setdouble("G",         strPath, this.G);
        setdouble("H",         strPath, this.H);
        setdouble("kl_e",      strPath, this.kl_e);

        setdouble("SollastHpkt",strPath, this.SollastHpkt);
        setdouble("Zusatzlast",strPath, this.Zusatzlast);

        setdouble("AnpassungEmass",strPath, this.AnpassungEmass);
    },

    Init : function(/*const char **/groe, /*int*/ nennw, /*int*/ sollw, /*int*/ sollw_auf, /*int*/ sollw_ab,
                    /*double*/ fsoll, /*double*/ wegres, /*double*/ resmin,
                    /*double*/ justpl, /*double*/ justmin, /*const char**/ plgv,
                    /*int*/ plastjust_konst, SollastHpkt, ZuslastHpkt)
    {
        this.groesse        = groe;
        this.lgv            = plgv;
        this.nennweg        = nennw;
        this.sollweg        = sollw;
		this.sollweg_auf    = sollw_auf;
		this.sollweg_ab     = sollw_ab;
        this.sollast        = fsoll;
        this.weg_res        = wegres;		// pro Endlage!
        this.res_min        = resmin;		// pro Endlage!
        this.justplus       = RoundDoubleToInt(justpl * 100);
        this.justminus      = RoundDoubleToInt(justmin * 100);
        this.lastjust_konst = plastjust_konst;

        m_Pblock = caMainController.presets.m_nKhBlock;
        if (!m_Pblock)
            m_Pblock = "BLOCK_JA";

        this.SollastHpkt = SollastHpkt;
        this.Zusatzlast  = ZuslastHpkt;

        return(1);
    },

    getZulaessigeAnpassungEmass : function()
    {
        return {dEoben: 20, dEunten: -20};
    },

	getEmass : function()
	{
		// Wird fr Konstant- und Federhnger berlagert
        return this.m_Pemass + this.AnpassungEmass;
	},

    getFormatierteLastjustierung : function()
    {
        var strJustierung = "";
        if (this.justplus == this.justminus)
            strJustierung = "+-"+this.justplus;
        else
            strJustierung = "+"+this.justplus+", -"+this.justminus;
        return strJustierung;
    },

    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert
        delete(storepath,"");

        var    db1, db2, db3;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    // EMA
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    // KMA
        db3 = this.GetProduktTabelle(this.m_Ptypid, 3);    // LGV  / BMA

        var strSQLStatement1 = "select * from "+db1+" order by abs(LGR) ASC, abs(SN) ASC ";
        var numRet1 = dbselect("CASCADE", strSQLStatement1, db1);
        var strSQLStatement2 = "select * from "+db2+" " ;
        var numRet2 = dbselect("CASCADE", strSQLStatement2, db2);
        var strSQLStatement3 = "select * from "+db3+" " ;
        var numRet3 = dbselect("CASCADE", strSQLStatement3, db3);

        if ((numRet1 <= 0) || (numRet2 <= 0) || ((numRet3 <= 0) && (db3 != "")))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            logtrace("    >>> "+strSQLStatement3+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if (compareInt(dbgetdouble(db1, "SN"), this.nennweg) &&
                (dbgetdouble(db1, "LGR") >= this.groesse))
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        while (dbiseof(db2) == 0)
        {
            if (compareInt(dbgetdouble(db2, "LGR"), this.groesse))
            {
                dbcopy(db2, storepath);
                break;
            }
            dbskip(db2);
        }

        if (this.m_Ptypid != "KSP" && this.m_Ptypid != "KSR")
        {
            while (dbiseof(db3) == 0)
            {
                if (compareInt(dbgetdouble(db3, "LGV"), this.lgv))
                {
                    dbcopy(db3, storepath);
                    break;
                }
                dbskip(db3);
            }
        }
        else
        {
            while (dbiseof(db3) == 0)
            {
                if (compareInt(dbgetdouble(db3, "LGR"), this.groesse))
                {
                    dbcopy(db3, storepath);
                    break;
                }
                dbskip(db3);
            }
        }

        if (dbiseof(db1) || dbiseof(db2) || dbiseof(db3))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            logtrace("    >>> eof Select 3: "+dbiseof(db3)+"\n\r");
            return -1;
        }

        return 1;
    },

    Selected : function(/* string*/ nButton, nSpannweite /* nur bei FH relevant */)
    {
        this.m_Ptypid  = nButton;
        this.m_Poberfl = this.getOberFlaechenSchutzDefault();

        var tmpPath = "TMP.KH_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        this.makeTyp();

		// Hier aufpassen mit NaN --> nicht mehr 0 --gl--
        this.estern = parseInt(getstring("E", tmpPath));
        this.X      = inputStringToDouble(getstring("X", tmpPath));

        // Konstanthnger selected: Hier wird L aus einer anderen Tabellen bestimmt
        // je nach Typ ... ist aber unproblematisch, es gibt keine berschneidungen
        if ((this.m_Ptypid != "KSP") && (this.m_Ptypid != "KSR"))
        	this.L = inputStringToDouble(getstring("L", tmpPath));

        if (this.m_Pblock == "BLOCK_MITTIG")
        {
            if ((this.m_Ptypid == "KSP") || (this.m_Ptypid == "KSR") || (this.m_Ptypid == "KVS"))
                this.m_Pemass = this.estern - RoundDoubleToInt(0.5 * this.nennweg);
            else
                this.m_Pemass = this.estern + RoundDoubleToInt(0.5 * this.nennweg);
        }
        else
        {
            /*
			if ((this.m_Ptypid == "KSP") || (this.m_Ptypid == "KSR") || (this.m_Ptypid == "KVS"))
                this.m_Pemass = this.estern - RoundDoubleToInt(0.5 * (this.nennweg + this.sollweg));
            else
                this.m_Pemass = this.estern + RoundDoubleToInt(0.5 * (this.nennweg + this.sollweg));
			
			// jetzt noch die 2. Bewegungsrichtung beruecksichtigen und die Blockierstellung korrigieren
			if (this.sollweg <= 0)
				this.m_Pemass	+= Math.abs(this.sollweg_auf);
			else
				this.m_Pemass	-= Math.abs(this.sollweg_ab);
			*/
			if ((this.m_Ptypid == "KSP") || (this.m_Ptypid == "KSR") || (this.m_Ptypid == "KVS"))
                this.m_Pemass = this.estern - RoundDoubleToInt(0.5 * (this.nennweg - abs(this.sollweg)) + this.sollweg_auf);
			else
				this.m_Pemass = this.estern + RoundDoubleToInt(0.5 * (this.nennweg - abs(this.sollweg)) + this.sollweg_auf);
        }
        
        this.m_Pgewicht = inputStringToDouble(getstring("GEWICHT", tmpPath)); // kma->GetDouble(kma->GetFieldNr("gewicht"));
        this.F = inputStringToDouble(getstring("F", tmpPath));
        this.B = inputStringToDouble(getstring("B", tmpPath));
        this.G = inputStringToDouble(getstring("G", tmpPath));
        if (m_Ptypid == "KVD")
        	this.H = inputStringToDouble(getstring("H", tmpPath));	// bei anderen steckt H u.U. in Ema-DB

        // Konstanthnger selected: Mae, diesich nur in klein/grossschreibung unterscheidung kommen
        // hier nicht durch ... es gibt nur noch Grossbuchstaben ... Auch ber mehrere Tabellen!
        // Mae aus -LGV-DB mssen noch geholt werden
        if (this.m_Ptypid == "KVD")
            this.kl_e = inputStringToDouble(getstring("e_", tmpPath));	// bei anderen steckt e u.U. in KMA-DB

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.KH_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
		
        if (this.m_Ptypid == "KHD")
        {
        stkMasse      = ["SN", "LGR", "E", "X", "L", "LGR", "A", "B", "C", "F", "G", "H", "SW", "gewicht", "gs", "gwi", "gbx", "gby", "gdb", "LGV", "d", "a_", "b_", "c1", "c2", "e_", "t", "z", "al", "c1z" ];
        stkMasseNamen = ["SN", "LGR", "E", "X", "L", "LGR", "A", "B", "C", "F", "G", "H", "SW", "gewicht", "gs", "gwi", "gbx", "gby", "gdb", "LGV", "d", "a",  "b",  "c1", "c2", "e",  "t", "z", "al", "c1z" ];
		}
        else if (this.m_Ptypid == "KVD")
        {
        stkMasse      = ["SN", "LGR", "E", "X", "L", "LGR", "A", "B", "C", "F", "G", "H", "SW", "gewicht", "gs", "gwi", "gbx", "gpx", "gby", "gdb", "gdx", "LGV", "d", "a_", "b_", "c1", "c2", "e_", "t", "z", "al", "c1z" ];
        stkMasseNamen = ["SN", "LGR", "E", "X", "L", "LGR", "A", "B", "C", "F", "G", "H", "SW", "gewicht", "gs", "gwi", "gbx", "gpx", "gby", "gdb", "gdx", "LGV", "d", "a",  "b",  "c1", "c2", "e",  "t", "z", "al", "c1z" ];
		}
        else if (this.m_Ptypid == "KHS")
        {
        stkMasse      = ["SN", "LGR", "E", "X", "L", "H", "t", "hg", "p", "LGR", "A", "B", "C", "F", "G", "e_", "k", "n", "o", "s", "u", "SW", "gewicht", "gs", "gwi", "gbx", "gby", "gdb", "LGV", "d" ];
        stkMasseNamen = ["SN", "LGR", "E", "X", "L", "H", "t", "hg", "p", "LGR", "A", "B", "C", "F", "G", "e", "k", "n", "o", "s", "u", "SW", "gewicht", "gs", "gwi", "gbx", "gby", "gdb", "LGV", "d" ];
		}
        else if (this.m_Ptypid == "KVS")
        {
        stkMasse      = ["SN", "LGR", "E", "X", "L", "e", "m", "t", "BR", "p", "p*", "LGR", "A", "B", "C", "F", "G", "H", "k", "n", "o", "s", "u", "SW", "e1", "e2", "gewicht", "gbx", "gby", "gdb", "hg", "gdx", "gs", "gpx", "LGV", "d" ];
        stkMasseNamen = ["SN", "LGR", "E", "X", "L", "e", "m", "t", "BR", "p", "p*", "LGR", "A", "B", "C", "F", "G", "H", "k", "n", "o", "s", "u", "SW", "e1", "e2", "gewicht", "gbx", "gby", "gdb", "hg", "gdx", "gs", "gpx", "LGV", "d" ];
		}
        else if ((this.m_Ptypid == "KSP") || (this.m_Ptypid == "KSR"))
        {
        stkMasse      = ["SN", "LGR", "E", "X", "LGR", "A", "B", "C", "F", "G", "H", "L", "d", "e_", "k", "l_", "n", "p", "s", "t", "u", "SW", "gewicht", "gs", "gbx", "gby", "gdb", "hdx", "hdy", "hgb", "ms", "hsr", "asr", "bsr", "hsp" ];
        stkMasseNamen = ["SN", "LGR", "E", "X", "LGR", "A", "B", "C", "F", "G", "H", "L", "d", "e", "k", "l", "n", "p", "s", "t", "u", "SW", "gewicht", "gs", "gbx", "gby", "gdb", "hdx", "hdy", "hgb", "ms", "hsr", "asr", "bsr", "hsp" ];
		}
	
		this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

    },

	makeTyp : function()
	{
        var block, gewin;
        var buf = "";
        var strTyp = this.m_Ptypid;

        if ((this.m_Pblock == "BLOCK_JA") || (this.m_Pblock == "BLOCK_MITTIG"))
            block = 1;
        else
            block = 0;

        if (this.m_Pgewinde == "GEWINDE_DIN")
            gewin = 1;
        else
            gewin = 0;

        if (this.m_Ptypid == "KSP" || this.m_Ptypid == "KSR")
            buf = sprintf("%s %s.%.3d.00-%d.%d.%d", strTyp, this.groesse, this.nennweg, block, gewin, Oberflaechenschutz[this.m_Poberfl]);
        else
            buf = sprintf("%s %s.%.3d.%s-%d.%d.%d", strTyp, this.groesse, this.nennweg, this.lgv, block, gewin, Oberflaechenschutz[this.m_Poberfl]);

        this.m_Ptyp = buf;

        this.getPreis();

        return this.m_Ptyp;

	},

	fromTyp : function(strTyp)
	{
		var strTypNr = [];
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

        switch (this.m_Ptypid)
        {
			case "KSP":
            case "KSR":
				strTypNr = splitVarDelimiter(strTyp, " ..-..");
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				//getVarDelimited(strTypNr, 3) = "00"
                // 10/2008: nur mittig blockiert zulassen:
                // this.m_Pblock = 'BLOCK_MITTIG';
				// this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pblock = "BLOCK_JA";
				this.m_Pgewinde = (getVarDelimited(strTypNr, 5) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
			default:
				strTypNr = splitVarDelimiter(strTyp, " ..-..");
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				this.lgv = getVarDelimited(strTypNr, 3);
                // 10/2008: nur mittig blockiert zulassen:
                // this.m_Pblock = 'BLOCK_MITTIG';
				// this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pblock = "BLOCK_JA";
				this.m_Pgewinde = (getVarDelimited(strTypNr, 5) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
		}

        // Da bei Typsuche immer mittig blockiert und zul. Last passend ausgesucht wird:
        this.justplus       = 15;
        this.justminus      = 15;
		this.lastjust_konst	= 15;

        // 10/2008: nur mittig blockiert zulassen:
        // 01/2009: Oberflchenschutz nur feuerverz., galv. verz. und sonder zulassen
        if ((getVarDelimited(strTypNr, 4) != "1") ||
            ((getVarDelimited(strTypNr, 6) != 1) &&
             (getVarDelimited(strTypNr, 6) != 2) &&
             (getVarDelimited(strTypNr, 6) != 4)))
            return "ERR";

        this.getPreis();

		var tmpPath = "TMP.KH_ADDITIONAL_DATA";
		var bSuccess = this.getAdditionalDataToStore(tmpPath);
		if(bSuccess == -1)
			return "ERR";
		// weitere Werte
		var VertiAchse	= toupper(right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"), 1));
		var VertiDir	= toupper(right(getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"), 2));
		switch (VertiAchse)
		{
			case "X":
				var BewAUF	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_plus[0000]");
				var BewAB	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_minus[0000]");
				if (VertiDir == "AB")
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[0000]");
				else
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus[0000]");
				break;
			case "Y":
				var BewAUF	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_plus[0001]");
				var BewAB	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_minus[0001]");
				if (VertiDir == "AB")
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[0001]");
				else
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus[0001]");
				break;
			default:	// Fall "Z"
				var BewAUF	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_plus[0002]");
				var BewAB	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_minus[0002]");
				if (VertiDir == "AB")
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[0002]");
				else
					var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus[0002]");
				break;
		}
		if (VertiDir == "AB"){	// falls die positive vertikale Achsrichtung nach unten zeigt
			var TEMP	= BewAUF;
			BewAUF		= BewAB;
			BewAB		= TEMP;
		}
		this.sollweg_ab		= BewAB;
		this.sollweg_auf	= BewAUF;
		this.sollweg		= (abs(BewAB) > abs(BewAUF) ? (-1) * abs(BewAB) : abs(BewAUF));
		this.SollastHpkt	= F_HP;
		this.weg_res		= fround((this.nennweg - (abs(BewAUF) + abs(BewAB)))/2, 1);
		this.res_min		= fround(max(getdouble("KH_MINDESTWEGRESERVE_ABS", "PROJECT.SETTINGS.CASCADE"), this.nennweg * getdouble("KH_MINDESTWEGRESERVE_ABS", "PROJECT.SETTINGS.CASCADE") / 100), 0);
		this.estern			= getint("E", "TMP.KH_ADDITIONAL_DATA");
		if (left(this.m_Ptypid, 2) == "KS" || this.m_Ptypid == "KVS")
			this.m_Pemass	= fround(this.estern - this.weg_res - BewAUF , 0);
		else
			this.m_Pemass	= fround(this.estern + this.weg_res + BewAUF , 0);
		this.kl_e			= getint("E_", "TMP.KH_ADDITIONAL_DATA");
		this.X				= getint("X", "TMP.KH_ADDITIONAL_DATA");
		this.m_Pgewicht		= getint("GEWICHT", "TMP.KH_ADDITIONAL_DATA");
		this.L				= getint("L", "TMP.KH_ADDITIONAL_DATA");
		this.H				= getint("H", "TMP.KH_ADDITIONAL_DATA");
		this.F				= getint("F", "TMP.KH_ADDITIONAL_DATA");
		this.G				= getint("G", "TMP.KH_ADDITIONAL_DATA");
		this.B				= getint("B", "TMP.KH_ADDITIONAL_DATA");
		
        return(bOK ? "" : "ERR");
	},

	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        this.m_Ppreis = 0.0;

        var nGewindeCode = 1;
        if (this.m_Pgewinde != "GEWINDE_DIN")
            nGewindeCode = 2;

        var block = 0;
        if ((this.m_Pblock == "BLOCK_JA") || (this.m_Pblock == "BLOCK_MITTIG"))
            block = 1;            

        if (this.isStuetze())
        {
            var tmpPath = "TMP.FH_ADDITIONAL_DATA";
            this.getAdditionalDataToStore(tmpPath);

            var strFieldname = "KSR_P" + block + "_" + Oberflaechenschutz[this.m_Poberfl];
            var strPreis = getstring(strFieldname, tmpPath);
            var strAufPreis = getstring("PTERRO", tmpPath);

            if (strPreis != "")
            {
                this.m_Ppreis = fround(strPreis, 2);
                // if (oOptions && oOptions.TERROSON_KH && (strAufPreis != ""))
                if ((this.m_Pbeschicht == "TERROSON") && (strAufPreis != ""))
                    this.m_Ppreis += fround(strAufPreis, 2);
            }
        }
        else
        {
            var strFieldname = this.m_Ptypid + "_P" + block + "_" + Oberflaechenschutz[this.m_Poberfl];

            var strSQLStatement = "select * from KH_PREIS where abs(groesse)="+this.groesse+" and lgv='"+this.lgv+"' " ;
            var numRet = dbselect("CASCADE", strSQLStatement, "KH_PREIS");
            if (numRet > 0)
            {
                // es sollte eigentlich nur ein Datensatz rauskommen:
                var strPreis    = dbgetstring("KH_PREIS", strFieldname);
                var strAufPreis = dbgetstring("KH_PREIS", "PTERRO");

                if (strPreis != "")
                {
                    this.m_Ppreis = fround(strPreis, 2);
                    // if (oOptions && oOptions.TERROSON_KH && (strAufPreis != ""))
                    if ((this.m_Pbeschicht == "TERROSON") && (strAufPreis != ""))
                        this.m_Ppreis += fround(strAufPreis, 2);
                }
            }
        }

        if (atoi(this.groesse) <= 12)
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_KH1");
        else
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_KH2");

        return this.m_Ppreis;
	},

    getTopoPic : function(Drehung)
    {
        // Weil der Hnger in zwei Schritten ausgewhlt wird ...
        var strPic = "catalog/client/custom/img/prinzip/H.png";
        if (this.m_Ptypid != "")
        {
            var strTeilPic = this.m_Ptypid;
            if (Drehung == 90)
                strTeilPic = strTeilPic + "_S3";
            else if (Drehung == 0)
                strTeilPic = strTeilPic + "_S2";
            else if (Drehung == 270)
                strTeilPic = strTeilPic + "_S1";

            strPic = "catalog/client/custom/img/panels/T"+strTeilPic+".png";
        }

        return strPic;
    },

    isSAPKonfigurierbar : function()
    {
        return 0;
    },

    getSAPKlassenName : function()
    {
        var strKlasse = this.m_Ptypid;  // Default
        if ((m_Ptypid == "KSR") || (m_Ptypid == "KSP"))
            strKlasse = "KST";

        return strKlasse;
    },

    getSAPTyp : function()
    {
        return this.m_Ptypid;
    },

    getASTLDaten : function(theMainController)
    {

        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        retObj.loeseauf = this.isSAPKonfigurierbar();

        var strKlasse = this.getSAPKlassenName();
        var searchObj;
        var sapOberflaechenschutz = Oberflaechenschutz[this.m_Poberfl];
        var groesseFuerSuche = parseInt(this.groesse);  // die fhrende Null muss weg

        searchObj = { LEISTUNGSGROESSE:  groesseFuerSuche,
                      NENNWEG:           this.nennweg,
                      LASTGRUPPE:        this.lgv,
                      OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                      TYP:               this.getSAPTyp() };

        var aMerkmale = this.getMerkmaleArray(strKlasse, searchObj);
        var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte; // nicht so toll ...
        if (this.isSAPKonfigurierbar() || this.isRohmassPosition())
            retObj.postext1 = this.m_Ptyp;

        return retObj;
	},

    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
        var strGroesse = this.groesse;
        if (left(strGroesse, 1) == "0")
            strGroesse = right(strGroesse, 1);
		var aParams = new Array();

        if (nTyp == "E")
            aParams.push( [ "Typ", "" + this.m_Ptypid ] );
        else aParams.push( [ "Position" + nStartPos, "" + this.m_Ptypid ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

        // ACHTUNG: die nachfolgenden Parameter tragen nicht die Posnr:
        aParams.push( [ "Lastgroesse" + nStartPos, strGroesse ] );  // Achtung: mit / ohne fhrende Null
        aParams.push( [ "sN" + nStartPos, "" + this.nennweg ] );

        // a_Ssoll ist negativ, falls Richtung des Wegs == AB
        var nReserveOben  = RoundDoubleToInt((this.nennweg - abs(this.sollweg)) / 2);
        var nReserveUnten = RoundDoubleToInt((this.nennweg - abs(this.sollweg)) / 2);

        var nRest = (this.nennweg - abs(this.sollweg)) - (nReserveOben + nReserveUnten);
        if (nRest != 0)
            nReserveUnten += nRest;

        var nBlockierstellung	= 0;
        var nBetriebsstellung_1	= 0;
		var nBetriebsstellung_2	= 0;
        // a_Ssoll ist negativ, falls Richtung des Wegs == AB
        if (this.m_Pblock == 'BLOCK_MITTIG')
        { 
            nBlockierstellung = this.nennweg / 2; 
            if (this.sollweg > 0)    // AUF
			{
				//nBetriebsstellung_1 = nReserveOben; 
				nBetriebsstellung_1 = this.weg_res;
				nBetriebsstellung_2	= this.nennweg/2 + this.sollweg_ab;
            }
			else
                //nBetriebsstellung_1 = this.nennweg - nReserveUnten; 
				nBetriebsstellung_1 = this.nennweg - this.weg_res; 
				nBetriebsstellung_2	= this.nennweg/2 - this.sollweg_auf;
        } 
        else
        {
            if (this.sollweg > 0)    // AUF
            {
                //nBlockierstellung = this.nennweg - nReserveUnten - this.sollweg_ab;
				nBlockierstellung	= this.nennweg - this.weg_res - this.sollweg_ab;
                //nBetriebsstellung_1	= nReserveOben;
				nBetriebsstellung_1	= this.weg_res;
				nBetriebsstellung_2	= this.nennweg - this.weg_res;
            }
            else    // AB
            {
                //nBlockierstellung = nReserveOben + this.sollweg_auf;
				nBlockierstellung	= this.weg_res + this.sollweg_auf;
                //nBetriebsstellung_1	= this.nennweg - nReserveUnten;
				nBetriebsstellung_1	= this.nennweg - this.weg_res;
				nBetriebsstellung_2	= this.weg_res;
            }
        }
        
        // CAD-bergabe Konstanthnger: Blockierstellung, Betriebsstellung, Einheit richtig bergeben
        // (Die Werte werden immer in mm bergeben, Umrechnung erfolgt im CAD)
        aParams.push( [ "Einheit" + nStartPos, "Prozent" ] );	    //  TODO: Prozent / Millimeter
        aParams.push( [ "Blockierstellung" + nStartPos, "" + nBlockierstellung ] );
        aParams.push( [ "Betriebsstellung" + nStartPos, "" + nBetriebsstellung_1 ] );
		aParams.push( [ "BetriebsstellungB" + nStartPos, "" + nBetriebsstellung_2 ] );

		var dEoben = 0;
		var dEunten = 0;
		if (this.AnpassungEmass > 0)
			dEoben = this.AnpassungEmass;
		if (this.AnpassungEmass < 0)
			dEunten = abs(this.AnpassungEmass);
        aParams.push( [ "dEoben" + nStartPos, "" + dEoben ] );
        aParams.push( [ "dEunten" + nStartPos, "" + dEunten ] );

        return( [ aParams, nPosNr + 1 ] );
    }

});
