/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2011 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Klemmsystem2 constructor
 */
Klemmsystem2 = function( ) {

	Klemmsystem2.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	this.oData = null;
};


EasyKat.extend( Klemmsystem2, Produkt, {
	init :  function( oDlgLager, oData, dStueck )
	{
		if(!dStueck)
			dStueck = 1;
		
		this.oData = oData ? oData : oDlgLager.Klemmsystem.oSearchResult.oResultKlemmsystem;
		
		var strWerkstoff = Base.getLanguageTextWerkstoff(this.oData.WERKSTOFF).strTextID;
		// korrigiere Variablen der Oberklasse
		this.m_Ptyp 		= this.oData.TYP_CALCULATION ? this.oData.TYP_CALCULATION : this.oData.TYP;
		this.m_Ptypid 		= left( this.oData.TYP, 3 );
		this.m_Ppreis 		= (getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927") ? 0 : this.oData.PREIS;
		this.m_PIdentNr 	= this.oData.IDENT;
		
		// Achtung die KSY fr TG > 19 sind deutlich schwerer
		var SubTyp	= this.getSubtyp();
		var KSYFaktor	= (rfind(SubTyp, "TG") > 0 ? 2 : 1);
		
		this.m_Pgewicht 	= this.oData.GEW * KSYFaktor;
		
		this.m_Pwerkstoff 	= strWerkstoff ? strWerkstoff : '';
		
		if (this.oData.OBFL == "")
			this.m_Poberfl = this.getOberFlaechenSchutzDefault();
		else
			this.m_Poberfl = Base.getLanguageTextOberflaeche(this.oData.OBFL).strTextID;
		
		this.strBaureihe 	= this.m_Ptypid;	// etwas sprechender
		this.strBauF	 	= this.oData.BAU_F;
		this.m_Pemass 		= RoundDoubleToInt( this.oData.E );   // -mw- wird auch gebraucht
		
		this.m_qty  = dStueck;
		
		// this.oData.TRAEGERBREITE = oDlgLager.
	},
	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da

        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );

		// Variablen dieser Klasse
		this.oData = Object.fromStorage( strPath+ ".LAGERDATA" );

		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strBauF	 = getstring( "strBauF", strPath );
		this.strMode	 = getstring("strMode",strPath);
		
        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Klemmsystemdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Klemmsystem2" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen dieser Klasse
		this.oData.toStorage(strPath+ ".LAGERDATA", false);   // kein merge

		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strBauF", strPath, this.strBauF );
		setstring( "strMode",strPath,this.strMode);
    },

	/**
     * bestimme die Typbezeichnung des Klemmsystems und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Lagers
	 */
	makeTyp : function()
	{
		// Mass-String fr STK-Export:
		this.m_strMasse  = " TrT " + this.oData.TRT + " Brt " + this.oData.TRAEGERBREITE + " TrH " + this.oData.strTraegerhoehe + " Tg10 " + this.oData.TG;
		this.m_strMasse += " BAU_F " + this.oData.Bau_F +  " H " + this.oData.H +  " GL_U " + this.oData.strGL_U + " WX " + this.oData.W_QUER  + " GEW " + this.oData.GEW + " WERK_ " + this.oData.WERKSTOFF;
		this.m_strMasse += " C " + this.oData.C + " TF " + this.oData.TF + " BREITE " + this.oData.BREITE + " L_PL " + this.oData.L_PL; 
		this.m_strMasse += " L1L " + this.oData.L1L + " L1R " + this.oData.L1R + " L2L " + this.oData.L2L + " L2R " + this.oData.L2R + " L3L " + this.oData.L3L;
		this.m_strMasse += " L3R " + this.oData.L3R + " L4L " + this.oData.L4L + " L4R " + this.oData.L4R + " H1L " + this.oData.H1L + " H1R " + this.oData.H1R;
		this.m_strMasse += " H2L " + this.oData.H2L + " H2R " + this.oData.H2R + " H3L " + this.oData.H3L + " H3R " + this.oData.H3R + " BKL " + this.oData.BKL + " BKR " + this.oData.BKR;
		
		this.m_strMasse	= replace(this.m_strMasse, "undefined", "");
		this.m_strMasse	= replace(this.m_strMasse, "-", "");
		
        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function(strTyp)
	{
		var aTypNr = [];
        var bOK = true;

		// Basiswerte
        this.m_Ptyp = strTyp;
        this.m_Ptypid = left( strTyp, 3 );

		// baue Typenschlssel fr Suche in der Lagerdatenbank
		aTypNr = splitVarDelimiter( strTyp, " .-.." );
		//
		if (aTypNr.length < 3 && (find(aTypNr[aTypNr.length - 1], "-") < 0)){
			aTypNr[aTypNr.length - 1]	+= "-T140";
			strTyp						+= "-T140";
			this.m_Ptyp					= strTyp;
		}
		//
		var bUseShortFormat = ( find( getVarDelimited( aTypNr, 1 ), '-' ) > -1 );
		if ( bUseShortFormat )
			aTypNr = splitVarDelimiter( strTyp, " -.." );

		var strTypSuchNr = this.m_Ptypid + " " + getVarDelimited( aTypNr, 1 );
		var strVarDelimited = getVarDelimited( aTypNr, 2 );
		if ( strVarDelimited && !bUseShortFormat )
			strTypSuchNr += "." + strVarDelimited;

		// Spezialprofil in Typenschlssel angegeben
		var strProfil = "", strB = "", strH = "", strD = "";
		if( ( !bUseShortFormat && ( aTypNr.length > 3 ) ) ||
		    ( bUseShortFormat && ( aTypNr.length > 2 ) ) )
		{
			if ( !bUseShortFormat )
				strVarDelimited = getVarDelimited( aTypNr, 3 );
			else strVarDelimited = getVarDelimited( aTypNr, 2 );
			strProfil = left( strVarDelimited, 1 );
			if( find( "TUL", strProfil ) == -1 ) 
				strProfil = "";

			// eine Datenbankzeile fr alle Spezialprofile einer Profilart (Trgerbreite und -hhe werden im Suchtypenschlssel auf XXX gesetzt)
			if( strProfil != "" )
				strTypSuchNr += "-" + strProfil + "XXX";
			else strTypSuchNr += "-" + strVarDelimited;
			if( find( strVarDelimited, "x" ) > -1 )
				strTypSuchNr += "xXXX";
		}

		// alle mglichen Varianten fr das Klemmsystem suchen (auch als Test gegen die aktuelle Datenbank: wir verarbeiten keine lteren, 
		// nicht mehr untersttzten Profile mehr)
		if( strProfil != "" )
		{
			// es kann auch T-/Doppel-T-Profil mit BTr<140 kommen -> z.B. "T100" - hier muss auch nach "T140" gesucht werden
			var strVarDelimited_Search = strVarDelimited;
			if (strProfil == "T" && right(strVarDelimited, strVarDelimited.length - find(strVarDelimited, "T"))*1 < 140)
				strVarDelimited_Search = "T140"
			var aTrae = [ "HEA", "HEB", "INP", "IPE", "L_PROFIL_G", "L_PROFIL_U", "T_PROFIL", "U_PROFIL" ];
			var strSelectTrae = "";
			var i = 0;
			for( i = 0; i < aTrae.length; i++ )
			{
				//strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] + " WHERE VAR_KLEMM='" + strVarDelimited + "'";
				strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] + " WHERE VAR_KLEMM='" + strVarDelimited_Search + "'";
				if( i < aTrae.length-1 )
					strSelectTrae += " UNION ";
			}
			strSelectTrae += " order by TAB, VAR_KLEMM";

			if( dbselect( "LAGER", strSelectTrae, "TYPSUCHE_TRAE" ) == 0 )
				return "Falscher Wert: " + strVarDelimited;
		}

		var strSelect = "SELECT * FROM KXX WHERE TYP = '" + strTypSuchNr + "'";
		if( dbselect( "LAGER", strSelect, "TYPSUCHE_KLEMMSYSTEM" ) )
		{
			// gotcha - lese Daten fr das Produkt aus der Datenbank
			// -mw- 12.5.2015: Den nachfolgenden Aufruf auskommentiert, weil die Funktion in Lager2 NICHT IMPLEMENTIERT ist. Es gibt die Funktion in Klasse Lager
			// this._leseDatenAusDB( "TYPSUCHE_KLEMMSYSTEM" );
			this.strBasistyp = strTypSuchNr;
			this.strBaureihe = left( strTypSuchNr, 3 );
			if ( strProfil != "" )
			{
				this.strProfilart = dbgetstring( "TYPSUCHE_TRAE", "TAB" );
				this.strTraegergroesse = dbgetstring( "TYPSUCHE_TRAE", "TRAE_GR" );
				this.strTraegerbreite = dbgetstring( "TYPSUCHE_TRAE", "B" );
				this.strTraegerhoehe = dbgetstring( "TYPSUCHE_TRAE", "H" );
				this.strFlanschdicke = dbgetstring( "TYPSUCHE_TRAE", "TG" );
			}
		}
		else return "Kein Produkt gefunden !";
		
		if (strProfil != "L" && strProfil != "U")
			strSelect			+= " AND TRAEGERBREITE = " + (this.strTraegerbreite * 1 > 140 ? "'-'" : "'140'") + " ";
		var DBData  		= Klemmsystem.Search.getSearchResultData('LAGER2', strSelect);
		if (DBData.length != 1){	// -Schu- nichts oder zu viel gefunden -> irgendetwas stimmt nicht!
			bOk	= false;
		}
		else{
			this.oData  				= DBData[0];
			this.oData.TRAEGERBREITE	= (this.strTraegerbreite*1 < 140 ? '140' : this.strTraegerbreite);
			this.m_Pgewicht				= this.oData.GEW * 1;
			this.m_Pemass				= this.oData.E * 1;
			this.m_Poberfl				= OberflaechenschutzZahlZuID[this.oData.OBFL + ''];
			this.m_Pwerkname			= WerkstoffeNrZuNamen[this.oData.WERKSTOFF + ''];
			this.m_Pwerkstoff			= WerknamenDB[this.m_Pwerkname];
			this.strBauF				= this.oData.BAU_F;
			this.getPreis();
		}
		
        return( bOK ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Klemmsystems, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 *         bool bIsEinzel - Einzelprodukt (true) oder Lastkette (false)
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung, bIsEinzel )
    {
		if ( !bIsEinzel ){
			if ( ( Drehung == 90 ) || ( Drehung == 270 ) )
				return ( "catalog/client/custom/img/panels/THAN_S.png" );
			return ( "catalog/client/custom/img/panels/THAN.png" );
		}
		
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		if (rfind(AchsDirInfo[9], "RV") > 0)
		{
			switch (Drehung)
			{
				case '0':
				case 0:
					AchsDirInfo[9] = "RV11";
					break;
				case '90':
				case 90:
					AchsDirInfo[9] = "RV12";
					break;
				case '180':
				case 180:
					AchsDirInfo[9] = "RV21";
					break;
				case '270':
				case 270:
					AchsDirInfo[9] = "RV22";
					break;
				default:
					AchsDirInfo[9] = "RV11";
					break;
			}
        }
		else
			AchsDirInfo[9]	= right(AchsDirInfo[9], 4);
		
		if (this.m_Ptypid == "KSY")	// die Pseudo-Klemmsysteme nicht zeigen
			var strPic = "catalog/client/custom/img/WITgifs/RH/" + AchsDirInfo[9] + "_blank.gif";
		else
			var strPic = "catalog/client/custom/img/WITgifs/RH/" + AchsDirInfo[9] + '_' + this.oData.BAUFO + ".jpg";
		
		return( strPic );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Klemmsystems sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Klemmsystems delegieren
		this.serializeOut( strPath );

		// !!! Da die Datenbank-Daten des Produkts jetzt im Unterpfad LAGERDATA stehen,
		// mssen sie nochmal hochkopiert werden ....
		this.oData.toStorage(strPath, true);   // merge !

        return 1;
    },

	/**
     * bestimme den Preis des Klemmsystems und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	double: Preis des Klemmsystems
	 */
	getPreis : function(oOptions)
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );
		
		// Achtung die KSY fr TG > 19 sind deutlich teurer
		var SubTyp	= this.getSubtyp();
		var KSYFaktor	= (rfind(SubTyp, "TG") > 0 ? 6 : 1);
		
		// hier mssen wir den Preis neu berechnen, da er sich durch nderung des Oberflchenschutzes in
		// der Stckliste ebenfalls gendert haben knnte (die Bestellnummer wird in getASTLDaten neu berechnet)
		var strBTr			= this.oData.TRAEGERBREITE*1 > 140 ? "-" : this.oData.TRAEGERBREITE;
		// Achtung: this.oData.TYP ist bei RL-KSY direkt angepasst - finden dafr keine Preise
		var TypeKSY	= this.oData.TYP;
		if (rfind(this.m_Ptyp, "RL") >= 0){
			TypeKSY	= left(TypeKSY, TypeKSY.length-3) + "XXX";
		}
		if (find(TypeKSY, "x") > -1)
			var strSQLStatement = "select * from KXX where TYP = '" +TypeKSY+ "'";
		else
			var strSQLStatement = "select * from KXX where TYP = '" +TypeKSY+ "' and TRAEGERBREITE = '" + strBTr + "' ";
		var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS");
		this.oData.PREIS	= (numRet == 1 ? dbgetdouble("PREIS", "PREIS") : 0);
		this.m_Ppreis	= this.oData.PREIS * KSYFaktor;
		var dPreis		= this.m_Ppreis;
        if (oOptions.SONDERANSTRICH_KOSTEN > 0)
            dPreis = inputStringToDouble(this.m_Ppreis) + (oOptions.SONDERANSTRICH_KOSTEN * inputStringToDouble(this.m_Pgewicht));

		// in den Tabellen stehen momentan nur Preise fr die Defaultversion des Oberflchenschutzes
        // dPreis = this.getNettoPreis(dPreis, "RABATT_TYP_SCHELLEN");
		dPreis = Base.getPrice(dPreis, "RABATT_TYP_LAGER");

        return( dPreis );
	},

	/**
     * prft, ob das Klemmsystem in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function()
    {
		// ab Baukasten 2023 sind Klemmsysteme nicht konfigurierbar
		var LG_2023_exists	= false;
		var bIsConfigurable	= false;
		if(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE") != "")	// Feld existiert - Suche in neuer Tabelle
			LG_2023_exists	= true;
		
		if (!LG_2023_exists){	// bisherige Logik
			// Klemmsystem ist dann in SAP konfigurierbar, wenn Profilart und Trgergre whlbar sind
			bIsConfigurable = true;
			
			// nderungen daran hier einfgen
			
			var strProfilform = this.oData.PROFILFORM || 'T';
			var strTraegerbreite = this.oData.TRAEGERBREITE || '140';
			if (((rfind(this.m_Ptyp,"RL") <= 0) && (strProfilform == "T") && (strTraegerbreite == "140"))
				|| ((rfind(this.m_Ptyp,"RL") > 0) && (strProfilform == "T") && (strTraegerbreite*1 <= 140) && (strTraegerbreite != "-")))
				bIsConfigurable = false;
        }
		
        return( bIsConfigurable ? 1 : 0 );
    },

	/**
     * holt den SAP-Klassennamen des Klemmsystems
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
		// nur eine SAP-Klasse fr alle Klemmsysteme
        return( "KSY" );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Lagertyp in SAP
	 */
    getSAPTyp : function()
    {
        return( this.strBaureihe );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: "", StueLiPosNr: "890"};
        retObj.loeseauf = this.isSAPKonfigurierbar();
		
        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];
		
		var SubTyp	= this.getSubtyp();
		if (rfind(SubTyp, "TG") > 0)
			var strSAPTyp = this.getSAPTyp() + '-S ' + this.strBauF + '-' + right(SubTyp, 4);
		else
			var strSAPTyp = this.getSAPTyp() + ' ' + this.strBauF;
		var strFussbreite = this.oData.BREITE || '';
		if (strFussbreite * 1 <= 0)
			strFussbreite = '';
		
		// ab Baukasten 2023 alle KSY feste Nummern und damit eindeutige Trgerbreiten (-bereiche)
		var LG_2023_exists	= false;
		if(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE") != ""){	// Feld existiert - Suche in neuer Tabelle
			LG_2023_exists	= true;
			var TrBrIST		= this.oData.PROFILFORM == "T" ? right(this.m_Ptyp,3) : "";
			//var TrBrSTD		= TrBrIST != "" ? this.getTrBereich(TrBrIST) : "";
			var TrBrSTD		= TrBrIST != "" ? theMainController.getTrBereich(TrBrIST) : "";
		}
		
		// searchObj fr Klemmung an RL ist anders als bei dem Rest
		/*if (theMainController.getLagerTopologieklasse().isRollenlager() ||
			theMainController.getLagerTopologieklasse().isSattel() ||
			theMainController.getLagerTopologieklasse().isKlemmsys_RL())
		*/
		if (rfind(this.m_Ptyp, "RL") > 0)
		{
			var strTraegerbreite = '120';
			if ((atoi(right(this.m_Ptyp,3)) >= 120 && atoi(right(this.m_Ptyp,3)) <= 140) && this.strBauF != "09")
				strTraegerbreite = '140';
			else if (atoi(right(this.m_Ptyp,3)) > 140)
				if (LG_2023_exists)
					strTraegerbreite	= TrBrSTD;
				else
					strTraegerbreite	= '';
			// TRAEGERBREITE, BREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
			searchObj = {
				TRAEGERBREITE: 		strTraegerbreite,
				BREITE: 			strFussbreite,
				PROFILFORM: 		( this.oData.PROFILFORM || 'T' ),
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFF: 			sapWerkstoffBez,
				TYP: 				strSAPTyp + '-RL'
			};
		}
		else
		{
			var strTraegerbreite;
			if (!LG_2023_exists){
				strTraegerbreite = '140';
				if (atoi(this.oData.TRAEGERBREITE)>140 || this.oData.PROFILFORM == "U" || this.oData.PROFILFORM == "L")
					strTraegerbreite = '';
			}
			else {
				if (this.oData.PROFILFORM == "U" || this.oData.PROFILFORM == "L")	// TODO U- / L-Trger eindeutig machen
					strTraegerbreite	= '';
				else
					strTraegerbreite	= TrBrSTD;
			}
			// TRAEGERBREITE, BREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
			searchObj = {
				TRAEGERBREITE: 		strTraegerbreite,
				BREITE: 			strFussbreite,
				PROFILFORM: 		( this.oData.PROFILFORM || 'T' ),
				OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
				WERKSTOFF: 			sapWerkstoffBez,
				TYP: 				strSAPTyp
			};
		}
		
        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;
		
        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if ( this.isSAPKonfigurierbar() )
            retObj.postext1 = this.m_Ptyp + (rfind(SubTyp, "TG") > 0 ? ('-' + right(SubTyp, 4)) : '');
		
        return( retObj );
	},

	/**
     *  hole Subtyp des Klemmsystems (Baureihe + erste Ziffer der Nennhhe + optional Trgerform)
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		var strTraegerID = this.oData.PROFILFORM;
		if ( !strTraegerID )
			strTraegerID = 'T';
		if ( strTraegerID == 'T' )
		{
			if ( this.oData.TRAEGERBREITE <= 140 && this.oData.TRAEGERBREITE != "-" )
				strTraegerID += '140';
			else 
				strTraegerID += 'XXX';
		}
		
		var strBaureihe = this.m_Ptypid;
		var strSubtyp = '';

		// leicht unterschiedliche Bildungsvorschriften fr den Subtyp, je nach Baureihe (siehe Exceldatei 'SAP_V_Daten_aktuell.xls', Sheet 'SUB_Typ_Legende')
		if ( ( strBaureihe == 'KOU' ) || ( strBaureihe == 'KOL' ) || ( strBaureihe == 'KZU' ) || ( strBaureihe == 'KZL' ) || 
		     ( strBaureihe == 'KLU' ) || ( strBaureihe == 'KLL' ) )
			strSubtyp = strBaureihe + ' ' + this.strBauF;
		else if ( ( strBaureihe == 'KOT' ) || 
				  ( ( this.strBauF == '40' ) && ( ( strBaureihe == 'KZT' ) || ( strBaureihe == 'KAT' ) || ( strBaureihe == 'KLT' ) ) ) )
		{
			var strHoehe = left( this.strBauF, 1 );
			// Unterscheidung KOT fr RL
			var isKSY_RL	= (rfind(this.m_Ptyp, "RL") < 0 ? false : true);
			strSubtyp = strBaureihe + strHoehe + '_' + (isKSY_RL ? "RL_" : "") + strTraegerID;
		}
		else strSubtyp = strBaureihe + this.strBauF + '_' + strTraegerID;
		
		// ggf. Zusatzinfos zur Gurtdicke
		var tG	= atoi(getstring("dBeamThickness",	"DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard"));
		if (tG > 42)
			strSubtyp	+= "NICHT_ZULAESSIG";
		else if (tG > 36)
			strSubtyp	+= "_TG42";
		else if (tG > 25)
			strSubtyp	+= "_TG36";
		else if (tG > 19)
			strSubtyp	+= "_TG25";
		
		return( strSubtyp );
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Klemmsystems
	 *
	 * @params integer nStartPos - startposition des Klemmsystems in der Lastkette
	 *         integer nPosNr - Position des Klemmsystems in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Klemmsystems beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = left( this.strTyp, 3 ) + this.strBauF;

		var strTraegerID = this.oData.PROFILFORM;
		if ( !strTraegerID )
			strTraegerID = 'T';		
		
		// setze CAD-Parameter
        aParams.push( [ "Typ", "" + strTypForCAD ] );   // Klemmsysteme nur einzeln
        // Klemmsysteme gibt's nur ungedmmt

        aParams.push( [ "BL", this.strBreite ] );   // Lagerfussbreite

        aParams.push( [ "Tr-Typ", strTraegerID ] );
        aParams.push( [ "Btr", this.strTraegerbreite ] );
        aParams.push( [ "Htr", this.strTraegerhoehe ] );
        aParams.push( [ "tG", this.strFlanschdicke ] );		// Gurtdicke

        return( [ aParams, nPosNr + 1 ] );
    }
	
	
});
