/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Klemmsystem constructor
 */
Klemmsystem = function( strDBRecordCache ) {

	Klemmsystem.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	// hole Variablen aus der Datenbankzeile
	this._leseDatenAusDB( strDBRecordCache );

	// Variablen fr Berechnungen
	this.strBasistyp = "";
	this.strBaureihe = "";

	// Variablen aus Konfiguration
	this.strProfilart = "HEB";
	this.strTraegergroesse = "100 - 140";
	this.strTraegerhoehe = "140";
	this.strTraegerbreite = "140";
	this.strFlanschdicke = "12";
};


EasyKat.extend( Klemmsystem, Produkt, {

	/**
     * lese interne Daten aus einem Record einer Datenbanktabelle
	 *
	 * @params string strDBRecordCache - Name des internen Recordcaches
	 * @returns	-
     */
	_leseDatenAusDB : function( strDBRecordCache )
	{
		this.strTyp = dbgetstring( strDBRecordCache, "TYP" );
		this.strProfilform = dbgetstring( strDBRecordCache, "PROFILFORM" );
		this.strTraegertyp = dbgetstring( strDBRecordCache, "TrT" );				//neu scb 22.06.09
		this.strDBTraegerbreite = dbgetstring( strDBRecordCache, "TRAEGERBREITE" );
		this.strBreite = dbgetstring( strDBRecordCache, "BREITE" );
		this.strBauF = dbgetstring( strDBRecordCache, "BAU_F" );
		this.strH = dbgetstring( strDBRecordCache, "H" );
		this.strFZ = dbgetstring( strDBRecordCache, "FZ" );
		this.strFX = dbgetstring( strDBRecordCache, "FX" );
		this.strGL_U = dbgetstring( strDBRecordCache, "GL_U" );
		this.strS_L = dbgetstring( strDBRecordCache, "S_L" );
		this.strWX = dbgetstring( strDBRecordCache, "WX" );
		this.strGEW = dbgetstring( strDBRecordCache, "GEW" );
		this.strWerk = dbgetstring( strDBRecordCache, "WERK_" );
		this.strObfl = dbgetstring( strDBRecordCache, "OBFL" );
		this.strIdent = dbgetstring( strDBRecordCache, "IDENT" );
		this.strPreis = ( dbgetstring( strDBRecordCache, "PREIS" ) - 0 ).toFixed( 2 );
		this.strBild = dbgetstring( strDBRecordCache, "BILD" );
		this.strBauform = dbgetstring( strDBRecordCache, "BAUFO" );
		this.strE = dbgetstring( strDBRecordCache, "E" );
		this.strC = dbgetstring( strDBRecordCache, "C" );
		this.strTF = dbgetstring( strDBRecordCache, "TF" );
		this.strL_PL = dbgetstring( strDBRecordCache, "L_PL" );
		// neu scb 22.06.09
		this.strL1L = dbgetstring( strDBRecordCache, "L1L" );
		this.strL1R = dbgetstring( strDBRecordCache, "L1R" );
		this.strL2L = dbgetstring( strDBRecordCache, "L2L" );
		this.strL2R = dbgetstring( strDBRecordCache, "L2R" );
		this.strL3L = dbgetstring( strDBRecordCache, "L3L" );
		this.strL3R = dbgetstring( strDBRecordCache, "L3R" );
		this.strL4L = dbgetstring( strDBRecordCache, "L4L" );
		this.strL4R = dbgetstring( strDBRecordCache, "L4R" );
		this.strH1L = dbgetstring( strDBRecordCache, "H1L" );
		this.strH1R = dbgetstring( strDBRecordCache, "H1R" );
		this.strH2L = dbgetstring( strDBRecordCache, "H2L" );
		this.strH2R = dbgetstring( strDBRecordCache, "H2R" );
		this.strH3L = dbgetstring( strDBRecordCache, "H3L" );
		this.strH3R = dbgetstring( strDBRecordCache, "H3R" );
		this.strBKL = dbgetstring( strDBRecordCache, "BKL" );
		this.strBKR = dbgetstring( strDBRecordCache, "BKR" );

		this._korrigiereVariablen();
		this._korrigiereWerkstoffOberflaeche();
	},

	/**
     * korrigiere Variablen der Oberklasse und eigene Variablen nach Einlesen der internen Daten aus der Datenbank
	 *
	 * @params string strDBRecordCache - Name des internen Recordcaches
	 * @returns	-
     */
	_korrigiereVariablen : function()
	{
		// korrigiere Variablen der Oberklasse
		this.m_Ptyp = this.strTyp;
        this.m_Ptypid = left(this.strTyp, 3);
		this.m_Ppreis = this.strPreis;
		this.m_PIdentNr = this.strIdent;
		this.m_Pgewicht = this.strGEW;
		this.m_Pwerkstoff = this._berechneWerkstoff();
		this.m_Poberfl = this.getOberFlaechenSchutzDefault();
        this.m_Pemass = RoundDoubleToInt( this.strE );   // -mw- wird auch gebraucht
	},

	/**
     * berechnet den Werkstoff fr das Klemmsystem
	 *
	 * @params -
	 * @returns	string berechneter Werkstoff
	 */
	_berechneWerkstoff : function()
	{
		var strWerkstoff = 'W_SONST';

		// Werkstoffe fr Klemmsysteme gibt es anscheinend temperaturunabhngig nur in 37 (== 'S235JRG2')
		if ( this.strWerk == 37 )
			strWerkstoff = "W_RST"; 		//'S235JRG2'
		// falls spter mal andere auftauchen
		else if ( this.strWerk == "16" )
			strWerkstoff = 'W_15MO3';		//'16Mo3'
		else if ( this.strWerk == "13" )
			strWerkstoff = 'W_13CRMO';		//'13CrMo4-5'
		else if ( this.strWerk == "10" )
			strWerkstoff = 'W_10CRMO';		// '10CrMo9-10'
		// else sollte nicht passieren - in diesem Fall bleibt der Werkstoff halt undefiniert
		
		return( strWerkstoff );
	},

	/**
     * korrigiere Variablen der Oberklasse und eigene Variablen nach Einlesen der internen Daten aus der Datenbank
	 *
	 * @params -
	 * @returns	-
     */
	_korrigiereWerkstoffOberflaeche : function()
	{
		if ( this.m_Poberfl )
		{
			var strID = Oberflaechenschutz[ this.m_Poberfl ];
			this.strWerkstoffOberfl = this.strWerk + "." + strID;
		}
		else
		{
			// Defaultwerte
			this.strWerkstoffOberfl = "37.2";
			if ( this.strWerk == "16" )
				this.strWerkstoffOberfl = "16.0";
			else if ( this.strWerk == "13" )
				this.strWerkstoffOberfl = "13.0";
			else if ( this.strWerk == "10" )
				this.strWerkstoffOberfl = "10.0";
		}
	},

	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Klemmsystemdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da

        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );

		// Variablen aus der Datenbank
		this.strTyp = getstring( "TYP", strPath );
		this.strProfilform = getstring( "PROFILFORM", strPath );
		this.strTraegertyp = getstring( "TrT", strPath );					// neu scb 22.06.09
		this.strDBTraegerbreite = getstring( "TRAEGERBREITE", strPath );
		this.strBreite = getstring( "BREITE", strPath );
		this.strBauF = getstring( "BAU_F", strPath );
		this.strH = getstring( "H", strPath );
		this.strFZ = getstring( "FZ", strPath );
		this.strFX = getstring( "FX", strPath );
		this.strGL_U = getstring( "GL_U", strPath );
		this.strS_L = getstring( "S_L", strPath );
		this.strWX = getstring( "WX", strPath );
		this.strGEW = getstring( "GEW", strPath );
		this.strWerk = getstring( "WERK_", strPath );
		this.strObfl = getstring( "OBFL", strPath );
		this.strIdent = getstring( "IDENT", strPath );
		this.strPreis = getstring( "PREIS", strPath );
		this.strBild = getstring( "BILD", strPath );
		this.strBauform = getstring( "BAUFO", strPath );
		this.strE = getstring( "E", strPath );
		this.strC = getstring( "C", strPath );
		this.strTF = getstring( "TF", strPath );
		this.strL_PL = getstring( "L_PL", strPath );
		// neu scb 22.06.09
		this.strL1L = getstring( "L1L", strPath );
		this.strL1R = getstring( "L1R", strPath );
		this.strL2L = getstring( "L2L", strPath );
		this.strL2R = getstring( "L2R", strPath );
		this.strL3L = getstring( "L3L", strPath );
		this.strL3R = getstring( "L3R", strPath );
		this.strL4L = getstring( "L4L", strPath );
		this.strL4R = getstring( "L4R", strPath );
		this.strH1L = getstring( "H1L", strPath );
		this.strH1R = getstring( "H1R", strPath );
		this.strH2L = getstring( "H2L", strPath );
		this.strH2R = getstring( "H2R", strPath );
		this.strH3L = getstring( "H3L", strPath );
		this.strH3R = getstring( "H3R", strPath );
		this.strBKL = getstring( "BKL", strPath );
		this.strBKR = getstring( "BKR", strPath );
		
		// Variablen fr Berechnungen
		this.strBasistyp = getstring( "strBasistyp", strPath );
		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strWerkstoffOberfl = getstring( "strWerkstoffOberfl", strPath );
		// Variablen aus Konfiguration
		this.strProfilart = getstring( "strProfilart", strPath );
		this.strTraegergroesse = getstring( "strTraegergroesse", strPath );
		this.strTraegerhoehe = getstring( "strTraegerhoehe", strPath );
		this.strTraegerbreite = getstring( "strTraegerbreite", strPath );
		this.strFlanschdicke = getstring( "strFlanschdicke", strPath );

        // -mw- ich glaube, das wird hier auch gebraucht:
		this._korrigiereVariablen();
		this._korrigiereWerkstoffOberflaeche();

        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Klemmsystemdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Klemmsystem" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen aus der Datenbank
		setstring( "TYP", strPath, this.strTyp );
		setstring( "PROFILFORM", strPath, this.strProfilform );
		setstring( "TrT", strPath, this.strTraegertyp );				// neu scb 22.06.09
		setstring( "TRAEGERBREITE", strPath, this.strDBTraegerbreite );
		setstring( "BREITE", strPath, this.strBreite );
		setstring( "BAU_F", strPath, this.strBauF );
		setstring( "H", strPath, this.strH );
		setstring( "FZ", strPath, this.strFZ );
		setstring( "FX", strPath, this.strFX );
		setstring( "GL_U", strPath, this.strGL_U );
		setstring( "S_L", strPath, this.strS_L );
		setstring( "WX", strPath, this.strWX );
		setstring( "GEW", strPath, this.strGEW );
		setstring( "WERK_", strPath, this.strWerk );
		setstring( "OBFL", strPath, this.strObfl );
		setstring( "IDENT", strPath, this.strIdent );
		setstring( "PREIS", strPath, this.strPreis );
		setstring( "BILD", strPath, this.strBild );
		setstring( "BAUFO", strPath, this.strBauform );
		setstring( "E", strPath, this.strE );
		setstring( "C", strPath, this.strC );
		setstring( "L_PL", strPath, this.strL_PL );
		// neu scb 22.06.09
		setstring( "L1L", strPath, this.strL1L );	
		setstring( "L1R", strPath, this.strL1R );
		setstring( "L2L", strPath, this.strL2L );	
		setstring( "L2R", strPath, this.strL2R );
		setstring( "L3L", strPath, this.strL3L );	
		setstring( "L3R", strPath, this.strL3R );
		setstring( "L4L", strPath, this.strL4L );	
		setstring( "L4R", strPath, this.strL4R );
		setstring( "H1L", strPath, this.strH1L );	
		setstring( "H1R", strPath, this.strH1R );
		setstring( "H2L", strPath, this.strH2L );	
		setstring( "H2R", strPath, this.strH2R );
		setstring( "H3L", strPath, this.strH3L );	
		setstring( "H3R", strPath, this.strH3R );
		setstring( "BKL", strPath, this.strBKL );	
		setstring( "BKR", strPath, this.strBKR );
		
		// Variablen fr Berechnungen
		setstring( "strBasistyp", strPath, this.strBasistyp );
		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strTyp", strPath, this.strTyp );
		setstring( "strWerkstoffOberfl", strPath, this.strWerkstoffOberfl );
		setstring( "strProfilart", strPath, this.strProfilart );
		setstring( "strTraegergroesse", strPath, this.strTraegergroesse );
		setstring( "strTraegerhoehe", strPath, this.strTraegerhoehe );
		setstring( "strTraegerbreite", strPath, this.strTraegerbreite );
		setstring( "strFlanschdicke", strPath, this.strFlanschdicke );
    },

	/**
     *  hole die Daten des Klemmsystems, die in der Liste fr gefundene Klemmsystem angezeigt werden
	 *
	 * @params boolean bMitPreis - Preis mitliefern?
	 * @returns	object >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
	 */
    holeDisplayDaten : function( bMitPreis, dCurrencyFactor )
    {

		// Preis nach gewhlter Whrung korrigieren:
		var strDisplayPreis = (this.strPreis * dCurrencyFactor).toFixed( 2 );

        var daten =
		{
			typ: this.strTyp,
			abhebelast_fz: this.strFZ,
			querlast_fx: this.strFX,
			klemmspalt_t: this.strTF,
			gewicht: this.strGEW,
			preis: ( bMitPreis ? strDisplayPreis : '-' )
		};

		return( daten );
	},

	/**
     * berechne die Defaultwert fr den Oberflchenschutz des Klemmsystems (mgliche Schutzarten: siehe CascadeProdukt.es, globales Objekt 'MoeglicherOberflaechenschutz')
	 *
	 * @params -
	 * @returns	integer index der Oberflchenschutzgruppe
	 */
	getOberFlaechenSchutzGruppe : function()
	{
		// mglicher Oberflchenschutz fr Klemmsysteme ist anscheinend nicht temperaturabhngig, gibts wohl nur in feuerverzinkt
		return( 8 );
	},

	/**
     * berechne die Oberflchenschutzgruppe fr das Klemmsystem (mgliche Gruppen: siehe CascadeProdukt.es, globales Objekt 'Oberflaechenschutz')
	 *
	 * @params -
	 * @returns	string Oberflchenschutz
	 */
	getOberFlaechenSchutzDefault : function()
	{
		// mglicher Oberflchenschutz fr Klemmsysteme ist anscheinend nicht temperaturabhngig, gibts nur in feuerverzinkt
		return( 'OB_FEUER' );
	},

	/**
     * bestimme die Typbezeichnung des Klemmsystems und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Klemmsystems
	 */
	makeTyp : function()
	{
		// Mass-String fr STK-Export:
		this.m_strMasse  = " TrT " + this.strTraegertyp + " Brt " + this.strTraegerbreite + " TrH " + this.strTraegerhoehe + " Tg10 " + this.strFlanschdicke;
		this.m_strMasse += " BAU_F " + this.strBauF +  " H " + this.strH +  " GL_U " + this.strGL_U + " WX " + this.strWX  + " GEW " + this.strGEW + " WERK_ " + this.strWerk;
		this.m_strMasse += " C " + this.strC + " TF " + this.strTF + " BREITE " + this.strBreite + " L_PL " + this.strL_PL; 
		this.m_strMasse += " L1L " + this.strL1L + " L1R " + this.strL1R + " L2L " + this.strL2L + " L2R " + this.strL2R + " L3L " + this.strL3L;
		this.m_strMasse += " L3R " + this.strL3R + " L4L " + this.strL4L + " L4R " + this.strL4R + " H1L " + this.strH1L + " H1R " + this.strH1R;
		this.m_strMasse += " H2L " + this.strH2L + " H2R " + this.strH2R + " H3L " + this.strH3L + " H3R " + this.strH3R + " BKL " + this.strBKL + " BKR " + this.strBKR;

	
		// lese gewhlten Oberflchenschutz aus und korrigiere den Oberflchenkenner des Typs
		this._korrigiereWerkstoffOberflaeche();
		var oDaten = Cascade.Lagerkonfiguration.holeTraegerdaten( this.strProfilart, this.strTraegergroesse, null );
		if ( oDaten.strTyp )
			this.strTyp = oDaten.strTyp;

		this.m_Ptyp = this.strTyp;
		
        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function( strTyp )
	{
		var aTypNr = [];
        var bOK = true;

		// Basiswerte
        this.m_Ptyp = strTyp;
        this.m_Ptypid = left( strTyp, 3 );

		// baue Typenschlssel fr Suche in der Lagerdatenbank
		aTypNr = splitVarDelimiter( strTyp, " .-.." );
		var bUseShortFormat = ( find( getVarDelimited( aTypNr, 1 ), '-' ) > -1 );
		if ( bUseShortFormat )
			aTypNr = splitVarDelimiter( strTyp, " -.." );

		var strTypSuchNr = this.m_Ptypid + " " + getVarDelimited( aTypNr, 1 );
		var strVarDelimited = getVarDelimited( aTypNr, 2 );
		if ( strVarDelimited && !bUseShortFormat )
			strTypSuchNr += "." + strVarDelimited;

		// Spezialprofil in Typenschlssel angegeben
		var strProfil = "", strB = "", strH = "", strD = "";
		if( ( !bUseShortFormat && ( aTypNr.length > 3 ) ) ||
		    ( bUseShortFormat && ( aTypNr.length > 2 ) ) )
		{
			if ( !bUseShortFormat )
				strVarDelimited = getVarDelimited( aTypNr, 3 );
			else strVarDelimited = getVarDelimited( aTypNr, 2 );
			strProfil = left( strVarDelimited, 1 );
			if( find( "TUL", strProfil ) == -1 ) 
				strProfil = "";

			// eine Datenbankzeile fr alle Spezialprofile einer Profilart (Trgerbreite und -hhe werden im Suchtypenschlssel auf XXX gesetzt)
			if( strProfil != "" )
				strTypSuchNr += "-" + strProfil + "XXX";
			else strTypSuchNr += "-" + strVarDelimited;
			if( find( strVarDelimited, "x" ) > -1 )
				strTypSuchNr += "xXXX";
		}

		// alle mglichen Varianten fr das Klemmsystem suchen (auch als Test gegen die aktuelle Datenbank: wir verarbeiten keine lteren, 
		// nicht mehr untersttzten Profile mehr)
		if( strProfil != "" )
		{
			var aTrae = [ "HEA", "HEB", "INP", "IPE", "L_PROFIL_G", "L_PROFIL_U", "T_PROFIL", "U_PROFIL" ];
			var strSelectTrae = "";
			var i = 0;
			for( i = 0; i < aTrae.length; i++ )
			{
				strSelectTrae += "SELECT '" + aTrae[i] +"' as TAB, TRAE_GR, H,B, TG, VAR_KLEMM FROM " + aTrae[i] + " WHERE VAR_KLEMM='" + strVarDelimited + "'";
				if( i < aTrae.length-1 )
					strSelectTrae += " UNION ";
			}
			strSelectTrae += " order by TAB, VAR_KLEMM";

			if( dbselect( "LAGER", strSelectTrae, "TYPSUCHE_TRAE" ) == 0 )
				return "Falscher Wert: " + strVarDelimited;
		}

		var strSelect = "SELECT * FROM KXX WHERE TYP = '" + strTypSuchNr + "'";
		if( dbselect( "LAGER", strSelect, "TYPSUCHE_KLEMMSYSTEM" ) )
		{
			// gotcha - lese Daten fr das Produkt aus der Datenbank
			this._leseDatenAusDB( "TYPSUCHE_KLEMMSYSTEM" );
			this.strBasistyp = strTypSuchNr;
			this.strBaureihe = left( strTypSuchNr, 3 );
			if ( strProfil != "" )
			{
				this.strProfilart = dbgetstring( "TYPSUCHE_TRAE", "TAB" );
				this.strTraegergroesse = dbgetstring( "TYPSUCHE_TRAE", "TRAE_GR" );
				this.strTraegerbreite = dbgetstring( "TYPSUCHE_TRAE", "B" );
				this.strTraegerhoehe = dbgetstring( "TYPSUCHE_TRAE", "H" );
				this.strFlanschdicke = dbgetstring( "TYPSUCHE_TRAE", "TG" );
			}
		}
		else return "Kein Produkt gefunden !";

		//this.m_Pemass = RoundDoubleToInt(this.strE);   // -mw- wird auch gebraucht
		this._korrigiereWerkstoffOberflaeche();
        this.getPreis();
		
        return( bOK ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Klemmsystems, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 *         bool bIsEinzel - Einzelprodukt (true) oder Lastkette (false)
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung, bIsEinzel )
    {
		if ( bIsEinzel )
		{
			var strFile = '';
			if ( this.strBauform )
				strFile = "catalog/client/custom/img/WITgifs/RH/" + this.strBauform + ".jpg";
			else strFile += 'catalog/client/custom/img/panels/empty.gif';
			
			return( strFile );
		}
		
        if ( ( Drehung == 90 ) || ( Drehung == 270 ) )
			return ( "catalog/client/custom/img/panels/THAN_S.png" );
		return ( "catalog/client/custom/img/panels/THAN.png" );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Klemmsystemdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Klemmsystems sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Klemmsystems delegieren
		this.serializeOut( strPath );

        return 1;
    },

	/**
     * bestimme den Preis des Klemmsystems und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params object oOptions - Sonderoptionen fr Preise
	 * @returns	double: Preis des Klemmsystems
	 */
	getPreis : function( oOptions )
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );

		// hier mssen wir den Preis neu berechnen, da er sich durch nderung des Oberflchenschutzes in
		// der Stckliste ebenfalls gendert haben knnte (die Bestellnummer wird in getASTLDaten neu berechnet)
		this.strPreis = Cascade.Klemmsystem.holePreis( this );
		this.m_Ppreis = this.strPreis;

        if ( oOptions.SONDERANSTRICH_KOSTEN > 0 )
            this.m_Ppreis += ( oOptions.SONDERANSTRICH_KOSTEN * this.m_Pgewicht );
		// in der Tabelle stehen momentan nur Preise fr die Defaultversion des Oberflchenschutzes

        return( this.m_Ppreis );
	},

	/**
     * prft, ob das Klemmsystem in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function()
    {
		// Klemmsystem ist dann in SAP konfigurierbar, wenn Profilart und Trgergre whlbar sind
		var bIsConfigurable = this.isConfigurable();

		var strTraegerID = this.strProfilform;
        var strBreite = this.strTraegerbreite;
        
		if ( !strTraegerID )
			strTraegerID = 'T';		
		if ( strTraegerID == 'T' )
		{
			if (strBreite <= 140 )
				strBreite = '140';
		}

		// nderungen daran hier einfgen
		if (bIsConfigurable && (strTraegerID == "T") && (strBreite == "140"))
            bIsConfigurable = false;
            
        return( bIsConfigurable ? 1 : 0 );
    },

	isConfigurable : function()
	{
        return true;
    },
    
	/**
     * holt den SAP-Klassennamen des Klemmsystems
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
		// nur eine SAP-Klasse fr alle Klemmsysteme
        return( "KSY" );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Klemmsystemtyp in SAP
	 */
    getSAPTyp : function()
    {
        return( left( this.strTyp, 3 ) );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};
        retObj.loeseauf = this.isSAPKonfigurierbar();

        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];
		var strSAPTyp = this.getSAPTyp() + ' ' + this.strBauF;

		// TRAEGERBREITE, BREITE, PROFILFORM, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
		searchObj = {
			TRAEGERBREITE: this.strDBTraegerbreite,
			BREITE: this.strBreite,
			PROFILFORM: ( this.strProfilform || 'T' ),
			OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
			WERKSTOFF: sapWerkstoffBez,
			TYP: strSAPTyp
		};

        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;

        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if ( this.isSAPKonfigurierbar() )
            retObj.postext1 = this.m_Ptyp;

        return( retObj );
	},

	/**
     *  hole Subtyp des Klemmsystems 
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';
		if ( strTraegerID == 'T' )
		{
			if ( this.strTraegerbreite <= 140 )
				strTraegerID += '140';
			else strTraegerID += 'XXX';
		}
		
		var strBaureihe = left( this.strTyp, 3 );
		var strSubtyp = '';

		// leicht unterschiedliche Bildungsvorschriften fr den Subtyp, je nach Baureihe (siehe Exceldatei 'SAP_V_Daten_aktuell.xls', Sheet 'SUB_Typ_Legende')
		if ( ( strBaureihe == 'KOU' ) || ( strBaureihe == 'KOL' ) || ( strBaureihe == 'KZU' ) || ( strBaureihe == 'KZL' ) || 
		     ( strBaureihe == 'KLU' ) || ( strBaureihe == 'KLL' ) )
			strSubtyp = strBaureihe + ' ' + this.strBauF;
		else if ( ( strBaureihe == 'KOT' ) || 
				  ( ( this.strBauF == '40' ) && ( ( strBaureihe == 'KZT' ) || ( strBaureihe == 'KAT' ) || ( strBaureihe == 'KLT' ) ) ) )
		{
			var strHoehe = left( this.strBauF, 1 );
			strSubtyp = strBaureihe + strHoehe + '_' + strTraegerID;
		}
		else strSubtyp = strBaureihe + this.strBauF + '_' + strTraegerID;
				  
		return( strSubtyp );
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Klemmsystems
	 *
	 * @params integer nStartPos - startposition des Klemmsystems in der Lastkette
	 *         integer nPosNr - Position des Klemmsystems in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Klemmsystems beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = left( this.strTyp, 3 ) + this.strBauF;

		var strTraegerID = this.strProfilform;
		if ( !strTraegerID )
			strTraegerID = 'T';		
		
		// setze CAD-Parameter
        aParams.push( [ "Typ", "" + strTypForCAD ] );   // Klemmsysteme nur einzeln
        // Klemmsysteme gibt's nur ungedmmt

        aParams.push( [ "BL", this.strBreite ] );   // Lagerfussbreite

        aParams.push( [ "Tr-Typ", strTraegerID ] );
        aParams.push( [ "Btr", this.strTraegerbreite ] );
        aParams.push( [ "Htr", this.strTraegerhoehe ] );
        aParams.push( [ "tG", this.strFlanschdicke ] );		// Gurtdicke

        return( [ aParams, nPosNr + 1 ] );
    }
});
