/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Horizontalschelle
 */
Horizontalschelle = function() {

	Horizontalschelle.superclass.constructor.call(this);

	/**
     *
     * @var
     */

    this.max_daemm      = 0;
	this.nennweite      = 0;
	this.lgv            = "";
	this.hoehe          = 0;
	this.traglast       = 0;
	this.m_dNennlast    = 0;

	this.m_bSonderNennweite = 0;
	this.m_dSonderNennweite = 0;

	this.m_nLMass           = 0;
	this.m_dXMass           = 0;
	this.m_strLGG           = "";
	this.m_dRohrSchraege    = 0;
    this.m_bohrung          = 0;

    this.Betriebslast        = 0;
    this.Daemmdicke          = 0;
    this.MediumTemperatur    = 0;
    this.UmgebungsTemperatur = 0;
    this.ReferenzTemperatur  = 0;

    // 1.6.08:
    this.NormEmass  = 0;
};


EasyKat.extend(Horizontalschelle, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);       // Horizontalschelle

        // Einfache Variablen einlesen, je nach Typ
        this.max_daemm      = getdouble("max_daemm",strPath);
        this.nennweite      = getdouble("nennweite",strPath);
        this.lgv            = getstring("lgv",strPath);
        this.hoehe          = getdouble("hoehe",strPath);
        this.traglast       = getdouble("traglast",strPath);
        this.m_dNennlast    = getdouble("m_dNennlast",strPath);

        this.m_bSonderNennweite = getdouble("m_bSonderNennweite",strPath);
        this.m_dSonderNennweite = getdouble("m_dSonderNennweite",strPath);

        this.m_nLMass           = getdouble("m_nLMass",strPath);
        this.m_dXMass           = getdouble("m_dXMass",strPath);
        this.m_strLGG           = getstring("m_strLGG",strPath);
        this.m_dRohrSchraege    = getdouble("m_dRohrSchraege",strPath);
        this.m_bohrung          = getdouble("m_bohrung",strPath);

        this.Betriebslast        = getdouble("Betriebslast",strPath);
        this.Daemmdicke          = getdouble("Daemmdicke",strPath);
        this.MediumTemperatur    = getdouble("MediumTemperatur",strPath);
        this.UmgebungsTemperatur = getdouble("UmgebungsTemperatur",strPath);
        this.ReferenzTemperatur  = getdouble("ReferenzTemperatur",strPath);

        this.NormEmass  = getdouble("NormEmass",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Horizontalschelle");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen
        setdouble("max_daemm",          strPath, this.max_daemm);
        setdouble("nennweite",          strPath, this.nennweite);
        setstring("lgv",                strPath, this.lgv);
        setdouble("hoehe",              strPath, this.hoehe);
        setdouble("traglast",           strPath, this.traglast);
        setdouble("m_dNennlast",        strPath, this.m_dNennlast);
        setdouble("m_bSonderNennweite", strPath, this.m_bSonderNennweite);
        setdouble("m_dSonderNennweite", strPath, this.m_dSonderNennweite);
        setdouble("m_nLMass",           strPath, this.m_nLMass);
        setdouble("m_dXMass",           strPath, this.m_dXMass);
        setstring("m_strLGG",           strPath, this.m_strLGG);
        setdouble("m_dRohrSchraege",    strPath, this.m_dRohrSchraege);
        setdouble("m_bohrung",          strPath, this.m_bohrung);
        setdouble("Betriebslast",       strPath, this.Betriebslast);
        setdouble("Daemmdicke",         strPath, this.Daemmdicke);
        setdouble("MediumTemperatur",   strPath, this.MediumTemperatur);
        setdouble("UmgebungsTemperatur",strPath, this.UmgebungsTemperatur);
        setdouble("ReferenzTemperatur", strPath, this.ReferenzTemperatur);
        setdouble("NormEmass",          strPath, this.NormEmass);

    },

    Init : function(/*int*/ ptypid, /*int*/ pnennw, /*char **/plgv, /*int*/ pwerk, /*int*/ pdaemm, /*int*/ pema,
					/*double*/ pgewicht, /*double*/ ptraglast, /*double*/ dNennlast,
					/*BOOL*/ bSonderRAD, /*double*/ dSonderAussendurch, /*int*/ nLMass,
					/*double*/ dRohrSchraege, schelBetriebsLast, b_daemmdicke,
                    MediumTemperatur, UmgebungsTemperatur, ReferenzTemperatur)
    {
        this.m_Ptypid   = ptypid;
        this.m_Pgewicht = pgewicht;
        this.m_Pwerkstoff = pwerk;
        this.m_dRohrSchraege = dRohrSchraege;

        this.Betriebslast        = schelBetriebsLast;
        this.Daemmdicke          = b_daemmdicke;
        this.MediumTemperatur    = MediumTemperatur;
        this.UmgebungsTemperatur = UmgebungsTemperatur;
        this.ReferenzTemperatur  = ReferenzTemperatur;

        this.NormEmass  = pema;

        if (this.m_Ptypid == "HZN" || this.m_Ptypid == "HZV" || this.m_Ptypid == "HZS")	// zur Zeit verkraften nur die es
        {
            this.m_Pemass = RoundDoubleToInt(pema * CosDeg(dRohrSchraege));
            this.m_dXMass = RoundDoubleToInt(- pema * SinDeg(dRohrSchraege));	// hier nicht gebraucht, spter als STK-Mass bergeben
        }
        else
        {
            this.m_Pemass = pema;
            this.m_dXMass = 0;
        }

        this.traglast   = ptraglast;
        this.m_dNennlast= dNennlast;
        this.nennweite  = pnennw;
        this.max_daemm  = pdaemm;
        this.lgv        = plgv;
        this.m_Pwerkalt = this.m_Pwerkstoff;

        this.m_bSonderNennweite  = bSonderRAD;
        this.m_dSonderNennweite  = dSonderAussendurch;

        this.m_nLMass = nLMass;

        this.m_Poberfl = this.getOberFlaechenSchutzDefault();

        // Zustzliche Masse abholen, m_strMasse belegen:

        /* m_dSonderNennweite ist halt immer der Rohrauendurchmesser,
           egal, ob Sonder oder nicht
        */
        var strDMR = sprintf("%8.1f", this.m_dSonderNennweite);
        strDMR = trimleft(strDMR, " ");

        var dNormAussendurch = this.GetRADfromNennweite(nennweite);

        // TODO:
        // wir fhren 2 Subobjekte mit ...
        // das eine enthlt alle Mae der Standard-Produktgre, die zur Berechnung benutzt wurde
        // das andere ist eine Kopie des ersten, wobei genderte Mae berschrieben werden
        // Dazu Promass.cpp portieren ... die Funktionen knnen wir ans Produkt hngen.
        // Fr ein Produkt alle Daten aus allen Tabellen sammeln und in ein Objekt stecken,
        // dort als Properties ...
        // Zugriff: wahlweise mit Zahlumwandlung und als String??
        //          dann sollten die beiden Subobjekte von einer Klasse erzeugt werden.

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.HS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        this.setMass(tmpPath, "DMR", strDMR);

        if (ptypid == "HDN" || ptypid == "HDV" || ptypid == "HDS")
            this.m_bohrung = this.getMass(tmpPath, "BOHRUNG");

        if (ptypid == "HBN" || ptypid == "HBV" || ptypid == "HBS")
        {
            if (m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dEnenn = this.getMass(tmpPath, "E");
                var dAnenn = this.getMass(tmpPath, "A");
                var dFnenn = this.getMass(tmpPath, "F");
                var dGnenn = this.getMass(tmpPath, "G");
                var dhJMnenn = this.getMass(tmpPath, "hJM");
                var dktLnenn = this.getMass(tmpPath, "ktL");

                // nun die neuen Masse berechnen:
                var dE   = dEnenn - RoundDoubleToInt((dNormAussendurch - this.m_dSonderNennweite) / 2.0 );
                var dDR1 = this.m_dSonderNennweite * 1.011;
                var dA   = RoundDoubleToInt( dDR1 + 3.0 * this.getMass(tmpPath, "sG") + 2.0 * this.getMass(tmpPath, "sJ") );
                var dhJM = RoundDoubleToInt( this.getMass(tmpPath, "H") - ( (dDR1 / 2.0) + 2.0 * this.getMass(tmpPath, "t")) * (1.0 - CosDeg(15)) );
                var dktL = RoundDoubleToInt((dhJM - this.getMass(tmpPath, "tL") - 4.0) / 2.0 );
                var dF   = RoundDoubleToInt( sqrt( pow( dDR1 / 2.0 + this.getMass(tmpPath, "sG"),2) +
                                 pow( (dDR1 / 2.0 + 2.0 * this.getMass(tmpPath, "t")) * CosDeg(15) +
                                       this.getMass(tmpPath, "hJE") +
                                       this.getMass(tmpPath, "tG") -
                                       this.getMass(tmpPath, "t"), 2) ) - (dDR1 / 2.0) );
                var dG   = RoundDoubleToInt( sqrt( pow( (dDR1 / 2.0 + 2.0 * this.getMass(tmpPath, "t")) * CosDeg(15) + this.getMass(tmpPath, "H"), 2) +
                                    pow( this.getMass(tmpPath, "m") / 2.0, 2 ) ) - (dDR1 / 2.0) );
                // CosDeg(15) = 0.96592582629100
// Vorgabe -schm-:
//                E = E - (Do - DR)/2
//                DR1 = DR*1,011
//                A = DR1 + 3*sG + 2*sJ
//                hJM = H - (DR1 + 2*t)*(1 - cos(15))
//                ktL = (hJM - tL - 4)/2
//                F = wurzel ((DR1/2+sG)^2 + ((DR1/2+2*t)*cos(15)+hJE +tG-t)^2)-DR1/2
//                G = wurzel ((DR1/2+2*t)*cos(15)+H)^2+(m/2)^2)-DR1/2


                this.m_Pemass = dE;

				// Schon mal darber nachgedacht ?? --gl--
				// tmpPath als Eigenschaft zu setzten, wrde ne Menge Schreibkram
				// sparen,oder ?

                this.setMass(tmpPath, "E", dE);
                this.setMass(tmpPath, "A", dA);
                this.setMass(tmpPath, "F", dF);
                this.setMass(tmpPath, "G", dG);
                this.setMass(tmpPath, "hJM", dhJM);
                this.setMass(tmpPath, "ktL", dktL);

                this.setMass(tmpPath, "DMR", strDMR);
                this.setMass(tmpPath, "LGV", this.lgv);

            }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
			stkMasse      = ["nennweite", "E", "A", "B", "F", "G", "b_", "c", "z", "DMR", "LGV", "hJM", "ktL", "H", "I", "m", "sG", "sJ", "hJE", "bG", "tG", "tL", "t", "dsp", "werk" ];
            stkMasseNamen = ["nennweite", "E", "A", "B", "F", "G", "b",  "c", "z", "DMR", "LGV", "hJM", "ktL", "H", "I", "m", "sG", "sJ", "hJE", "bG", "tG", "tL", "t", "dsp", "werk" ];
        }

        if (ptypid == "HZN" || ptypid == "HZV" || ptypid == "HZS")
        {
            if (m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dEnenn = this.getMass(tmpPath, "E");
                var dAnenn = this.getMass(tmpPath, "A");

                var dE   = RoundDoubleToInt( 0.9 * this.getMass(tmpPath, "c") + (this.getMass(tmpPath, "s") / 2.0) +
                                sqrt( pow( (this.m_dSonderNennweite / 2.0) + 2.5 * this.getMass(tmpPath, "s"), 2) -
                                      pow( (this.getMass(tmpPath, "b_") / 2.0) + 2.5 * this.getMass(tmpPath, "s"), 2) ) );
                var dA   = 2.0 * (dE + this.getMass(tmpPath, "z"));

                // this.m_Pemass = RoundDoubleToInt(dE);
				// this.m_Pemass = RoundDoubleToInt(dE / CosDeg(dRohrSchraege));
				this.m_Pemass = RoundDoubleToInt(dE * CosDeg(dRohrSchraege));

                this.setMass(tmpPath, "E", dE);
                this.setMass(tmpPath, "A", dA);
                this.setMass(tmpPath, "DMR", strDMR);
            }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
			stkMasse      = ["nennweite", "E", "A", "B", "b_", "c", "s", "z", "DMR" ];
            stkMasseNamen = ["nennweite", "E", "A", "B", "b",  "c", "s", "z", "DMR" ];
        }

        if (ptypid == "HDN" || ptypid == "HDV" || ptypid == "HDS")
        {
            if (m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dEnenn = this.getMass(tmpPath, "E");
                var dAnenn = this.getMass(tmpPath, "A");

                var dE   =  RoundDoubleToInt( this.getMass(tmpPath, "ds") +
                                0.9 * this.getMass(tmpPath, "di") + (this.getMass(tmpPath, "s") / 2.0) +
                                Math.sqrt( Math.pow( (this.m_dSonderNennweite / 2.0) + 2.5 * this.getMass(tmpPath, "s"), 2) -
                                      Math.pow( (this.getMass(tmpPath, "b_") / 2.0) + 2.5 * this.getMass(tmpPath, "s"), 2) ) );
                var dA   = 2.0 * (dE + this.getMass(tmpPath, "z")) -
                                this.getMass(tmpPath, "ds");

                this.m_Pemass = RoundDoubleToInt(dE);

                this.setMass(tmpPath, "E", dE);
                this.setMass(tmpPath, "A", dA);
                this.setMass(tmpPath, "DMR", strDMR);
            }

            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
			stkMasse      = ["nennweite", "ds", "A", "B", "b_", "c", "s", "z", "DMR", "E", "LGV", "di", "DN_min", "DN_max" ];
            stkMasseNamen = ["nennweite", "ds", "A", "B", "b",  "c", "s", "z", "DMR", "E", "LGV", "di", "DN-min", "DN-max" ];
        }
		
        if (ptypid == "HGN" || ptypid == "HGV")
        {
            if (m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dEnenn = this.getMass(tmpPath, "E");
                var dFnenn = this.getMass(tmpPath, "F");
                var dG1nenn = this.getMass(tmpPath, "G1");
                var dG2nenn = this.getMass(tmpPath, "G2");
                var dgnenn = this.getMass(tmpPath, "g");
                var dh1nenn = this.getMass(tmpPath, "h1");
                var dhnenn = this.getMass(tmpPath, "h");

                // nun die neuen Masse berechnen:
                // Hilfsmasse:
                var dLo = (this.m_dSonderNennweite + this.getMass(tmpPath, "d_")) / 2.0 / TanDeg(this.getMass(tmpPath, "ao")) +
                             this.getMass(tmpPath, "s_") / 2.0 / SinDeg(this.getMass(tmpPath, "ao")) +
                             this.getMass(tmpPath, "l") - this.getMass(tmpPath, "a") / 2.0 / TanDeg(this.getMass(tmpPath, "ao")) +
                             3.0 * this.getMass(tmpPath, "d_");

                var dDel = this.getMass(tmpPath, "r") / 4.0;

                var dh1 = (this.m_dSonderNennweite + this.getMass(tmpPath, "d_")) / (2.0 * SinDeg(this.getMass(tmpPath, "au")))
                              - (this.m_dSonderNennweite / 2.0);

                var dh  = RoundDoubleToInt( dh1 + (this.getMass(tmpPath, "b1") / 2.0 + dDel) /
                              SinDeg(this.getMass(tmpPath, "au")) + this.getMass(tmpPath, "r") );
							  
				var dh1 = RoundDoubleToInt( dh1 );

                var dlg = (dh - dh1 + this.getMass(tmpPath, "r") * (1.0 / CosDeg(this.getMass(tmpPath, "au")) - 1.0)) *
                              CosDeg(this.getMass(tmpPath, "au")) - (this.getMass(tmpPath, "s1") / 2.0);

                var dLu = (this.m_dSonderNennweite + this.getMass(tmpPath, "d_")) / 2.0 / TanDeg(this.getMass(tmpPath, "au")) +
                             dlg + this.getMass(tmpPath, "s1") + 3.0 * this.getMass(tmpPath, "d_");

                var dKON = (1.0 / (this.m_dSonderNennweite / 2.0 + this.getMass(tmpPath, "r2"))) *
                              ((dh1 + (this.getMass(tmpPath, "b1") / 2.0 + dDel) / SinDeg(this.getMass(tmpPath, "au")) ) +
                                this.getMass(tmpPath, "r") / CosDeg(this.getMass(tmpPath, "au")) -
                                this.getMass(tmpPath, "r2") *
                                   ( SinDeg(this.getMass(tmpPath, "au")) * TanDeg(this.getMass(tmpPath, "au")) + CosDeg(this.getMass(tmpPath, "au")) )  +
                                    this.m_dSonderNennweite / 2.0);

                var dQQ  = (dKON * dKON - 1.0) / (1.0 + TanDeg(this.getMass(tmpPath, "au")) * TanDeg(this.getMass(tmpPath, "au")));

                var dPP  = (-2.0) * dKON * TanDeg(this.getMass(tmpPath, "au")) /
                                 (1.0 + TanDeg(this.getMass(tmpPath, "au")) * TanDeg(this.getMass(tmpPath, "au")));

                var dBeta = (180.0 / 3.1416) * (180.0 / 3.1416) * ArcSinDeg(-1.0 * dPP / 2.0 -  sqrt( (dPP / 2.0)*(dPP / 2.0) - dQQ ));


                // Nun die wichtigen:
                var dE   = RoundDoubleToInt( dEnenn - (dNormAussendurch - this.m_dSonderNennweite) / 2.0 );
                var dF   = RoundDoubleToInt((this.m_dSonderNennweite / 2 + this.getMass(tmpPath, "d_")) * SinDeg(this.getMass(tmpPath, "ao")) +
                              dLo * CosDeg(this.getMass(tmpPath, "ao")));
                var dG2  = RoundDoubleToInt((this.m_dSonderNennweite / 2.0) + dh );
                var dG1  = RoundDoubleToInt(((this.m_dSonderNennweite / 2.0) + this.getMass(tmpPath, "d_")) * SinDeg(this.getMass(tmpPath, "au")) +
                              dLu * CosDeg(this.getMass(tmpPath, "au")));
                var dg   = RoundDoubleToInt( 2.0 * (this.getMass(tmpPath, "r2") + (this.m_dSonderNennweite / 2.0 + this.getMass(tmpPath, "r2")) * SinDeg(dBeta)));

//               Vorgabe:
//                    E = E + (DR - D)/2    D = Du oder Do
//                    F = (DR/2+d_)*sin(ao) + Lo*cos(ao)
//                         Lo=(DR+d_)/2/tan(ao) + s_ / 2 / sin(ao) + l - a/2/tan(ao) + 3*d
//
//                    del = r/4
//                    h1 = (DR+d_)/2/sin(au) - DR/2
//                    h = h1 + (b1/2 + del)/sin(au) + r
//                    lg = (h-h1+r*(1/cos(au)-1))*cos(au)-s1/2
//                    G2 = DR/2 + h
//
//                    G1 =  (DR+d_)*sin(au) + Lu*cos(au)
//                         Lu=(DR+d_)/2/tan(au) + lg + s1 + 3*d_
//
//                    g = 2*(r2 + (DR/2 + r2)*sin(beta))
//                         beta = arcsin((-1)*pp/2 - wurzel((pp/2)*(pp/2) - qq)
//                            pp  = (-2)*KON*tan(au)/(1 + tan(au)*tan(au))
//                            qq  = (KON*KON - 1)/(1 + tan(au)*tan(au))
//                            KON = (1/(DR/2 + r2))*((h1 + (b1/2+del)/sin(au))+r/cos(au) - r2*(sin(au)*tan(au) + cos(au))+ DR/2)
//

                this.m_Pemass = dE;
				
//				this.setMass(tmpPath, "BETA", dBeta);
//				this.setMass(tmpPath, "KON", dKON);
//				this.setMass(tmpPath, "QQ", dQQ);
//				this.setMass(tmpPath, "PP", dPP);
                this.setMass(tmpPath, "E", dE);
                this.setMass(tmpPath, "F", dF);
                this.setMass(tmpPath, "G1", dG1);
                this.setMass(tmpPath, "G2", dG2);
                this.setMass(tmpPath, "g", dg);
                this.setMass(tmpPath, "h", dh);
                this.setMass(tmpPath, "h1", dh1);
                this.setMass(tmpPath, "DMR", strDMR);
            }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
            stkMasse      = ["nennweite", "E", "B", "F", "G2", "d_", "f_", "s", "c", "DMR", "LGV", "g", "G1", "h1", "h", "ao", "au", "s_", "DN", "b1", "s1", "r", "r2", "lg", "l", "a", "e1", "e2", "sT", "q" ];
            stkMasseNamen = ["nennweite", "E", "B", "F", "G2", "d",  "f",  "s", "c", "DMR", "LGV", "g", "G1", "h1", "h", "ao", "au", "s*", "DN", "b1", "s1", "r", "r2", "lg", "l", "a", "e1", "e2", "sT", "q" ];
        }
        if (ptypid == "MSN")
        {
            if (m_bSonderNennweite)
            {
                // als Erstes die Masse rausholen, die bei Sondernennweite berechnet werden mssen:
                var dEnenn = this.getMass(tmpPath, "E");
                var dAnenn = this.getMass(tmpPath, "A");
                var dDmnenn = this.getMass(tmpPath, "Dm");
                var dhnenn = this.getMass(tmpPath, "h");

                // nun die neuen Masse berechnen:
                var dE   = dEnenn - RoundDoubleToInt((dNormAussendurch - this.m_dSonderNennweite) / 2.0 );
                var dDm   = RoundDoubleToInt(this.m_dSonderNennweite * 1.01 + this.getMass(tmpPath, "d_") + 4 );
                var dA   = dDm + 2.0 * this.getMass(tmpPath, "d_") + 5;
                var dh   = RoundDoubleToInt(dE - 1.01 * (this.m_dSonderNennweite / 2.0) * 0.7071 - this.getMass(tmpPath, "t") );

                this.m_Pemass = dE;

                this.setMass(tmpPath, "E", dE);
                this.setMass(tmpPath, "A", dA);
                this.setMass(tmpPath, "Dm", dDm);
                this.setMass(tmpPath, "h", dh);
                this.setMass(tmpPath, "DMR", strDMR);
           }
            // Dies wird nur gebraucht um einen Mass-String fr das STK-File zu erzeugen:
            stkMasse      = ["nennweite", "DMR", "Dm", "B", "d_", "E", "t", "b_", "h", "A", "f", "g_", "h3", "h1", "G", "p", "C", "k", "fn", "FNBO" ];
            stkMasseNamen = ["nennweite", "DMR", "Dm", "B", "d",  "E", "t", "b",  "h", "A", "f", "g",  "h3", "h1", "G", "p", "C", "k", "fn", "FNBO" ];
        }

        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();

        return(1);
    },
	
	InitSL : function(/*string*/ ptypid, /* string*/ plgv, /*int*/ pwerk, /*int*/ pema, /*double*/ pgewicht, /*double*/ dA, /*int*/ DN, /*double*/ pdaemmdicke, /*double*/ pmedientemp)
	{
		var stkMasse = [], stkMasseNamen = [];
		var tmpPath = "TMP.HS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
		
		this.m_Ptypid   		= ptypid;
        this.m_Pgewicht 		= pgewicht;
        this.m_Pwerkstoff 		= pwerk;
        this.m_Pemass   		= pema;
        this.m_Pcpartid			= "";
		this.lgv        		= plgv;
		this.m_Pwerkalt 		= this.m_Pwerkstoff;
		if (this.m_Pwerkstoff == "W_RST")
				this.m_Pzusinfo = "2.2";
        if (this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")
				this.m_Pzusinfo = "3.1B";
		this.m_Poberfl = this.getOberFlaechenSchutzDefault();
		this.nennweite 				= DN;
		this.m_dSonderNennweite		= dA;
		this.Daemmdicke				= pdaemmdicke;
		this.MediumTemperatur		= pmedientemp;
		
		this.makeTyp();
		
		stkMasse      = ["LGV", "DN", "E", "A", "f", "r", "s", "h", "k", "beta",	"J", "SCH_V", "SCH_A", "gewicht", "werk" ];
        stkMasseNamen = ["LGV", "DN", "E", "A", "f", "r", "s", "h", "k", "beta",	"J", "SCH_V", "SCH_A", "gewicht", "werk" ];
		
		this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
		
		return (1);
	},
	
	InitMSL : function(/*string*/ ptypid, /* string*/ pLGG, /*int*/ pwerk, /*int*/ pema, /*double*/ pgewicht, /*double*/ dA, /*int*/ DN, /*double*/ pdaemmdicke, /*double*/ pmedientemp)
	{
		var stkMasse = [], stkMasseNamen = [];
		var tmpPath = "TMP.HS_ADDITIONAL_DATA";
        //this.getAdditionalDataToStore(tmpPath);
		
		this.m_Ptypid   		= ptypid;
        this.m_Pgewicht 		= pgewicht;
        this.m_Pwerkstoff 		= pwerk;
        this.m_Pemass   		= pema;
        this.m_Pcpartid			= "";
		this.m_strLGG      		= pLGG;
		this.m_Pwerkalt 		= this.m_Pwerkstoff;
		if (this.m_Pwerkstoff == "W_RST52")
				this.m_Pzusinfo = "2.2";
        //if (this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")
		else
				this.m_Pzusinfo = "3.1B";
		this.m_Poberfl			= this.getOberFlaechenSchutzDefault();
		this.nennweite 			= DN;
		this.m_dSonderNennweite	= dA;
		this.Daemmdicke			= pdaemmdicke;
		this.MediumTemperatur	= pmedientemp;
		
		this.m_dNennlast		= pLGG*1;
		
		this.getAdditionalDataToStore(tmpPath);
		//this.makeTyp();
		
		stkMasse      = ["DN", "E_MIN", "E_MAX", "MAX_ISO", "A", "B", "F", "C", "X", "S", "Z" ];
		stkMasseNamen = ["nennweite", "E_MIN", "E_MAX", "J_MAX", "A", "B", "F", "C", "X", "S", "Z" ];
		
		this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
		this.m_strMasse	+= "E " + pema;
		
		return (1);
	},

    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert

        delete(storepath,"");

        // Unterschiedliche Flle aufteilen ...
        if (this.m_Ptypid == "MSN")
            return this.getAdditionalDataToStoreMSN(storepath);
		else if (this.m_Ptypid == "MSL")
			return this.getAdditionalDataToStoreMSL(storepath);
        else if (left(this.m_Ptypid, 2) == "HZ")
            return this.getAdditionalDataToStoreHZ(storepath);
		else if (left(this.m_Ptypid, 2) == "ZL")
			return this.getAdditionalDataToStoreZL(storepath);
        else
            return this.getAdditionalDataToStoreHDG(storepath);
    },

    getAdditionalDataToStoreHZ : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+"  ";
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1);

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "nennweite"), this.nennweite ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreMSN : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }
        var nEmassFuerSuche = this.m_Pemass;
        if (m_bSonderNennweite)
            nEmassFuerSuche = this.NormEmass

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "NENNWEITE"),  this.nennweite ) &&
                 compareInt(dbgetdouble(db1, "E"),          nEmassFuerSuche ) &&
                 compareInt(dbgetdouble(db1, "FN"),         this.m_dNennlast ) )
            {
                dbcopy(db1, storepath);
				
				// Manipulation von FORM zur Unterscheidung mit/ohne Zusatzrippen
				// nur wenn wir PSS ("MBW") auslegen -> die LISEGA Bcke (MBS) sind klein
				// SSG bzw. SSB ist hier bereits ausgelegt
				var FNDynTeil	= atoi(getstring("FN", "TMP.FH_ADDITIONAL_DATA"));	// ergibt NULL fr FSG
				if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "FALSE" && FNDynTeil != 0){
					// Anpassung von "g" (DB: "G_") wenn wir den Bock kennen
					var Gsoll	= dbgetdouble(db1, "G_");
					if (typeof(Object.fromStorage("TMP.ZB_ADDITIONAL_DATA")) == 'object'){
						Gsoll	= max((2*dbgetdouble(db1, "T") + atoi(getstring("A", "TMP.ZB_ADDITIONAL_DATA"))), (dbgetdouble(db1, "G") + 15));
						if (Gsoll > dbgetdouble(db1, "G_"))	// just to be sure
							setstring ("G_", storepath, Gsoll);
					}
					var ZRippeAb	= atoi(dbgetdouble(db1, "ZRIPP_AB"));
					if (FNDynTeil >= ZRippeAb){
						setstring ("FORM", storepath, "" + dbgetstring(db1, "FORM") + "S");
						setstring ("ZRIPP_B", storepath, (Gsoll - dbgetdouble(db1, "G")) / 2 - 5);
						setstring ("ZRIPP_H", storepath, floor(dbgetdouble(db1, "E") - dbgetdouble(db1, "D")/2 - 4*dbgetdouble(db1, "K")));
					}
				}
				setstring ("FNBO", storepath, getstring((!FNDynTeil ? "LGG" : "FN_BOCK"), "TMP.FH_ADDITIONAL_DATA"));
				
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
			// Schon mal ber throw nachgedacht ?? --gl--
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

	getAdditionalDataToStoreMSL : function(storepath)
    {
        var db1 = "";
        var strSQLStatement1 = "";
        var numRet1 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //

        strSQLStatement1 = "select * from "+db1+"  "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }
        var nEmassFuerSuche = this.m_Pemass;
        if (m_bSonderNennweite)
            nEmassFuerSuche = this.NormEmass

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "MATERIAL") ,	Werkstoffe[this.m_Pwerkstoff]) &&
				 compareInt(dbgetdouble(db1, "DN")		 ,	this.nennweite ) &&
                 compareInt(dbgetdouble(db1, "F_DYN")	 ,	(this.m_strLGG*1) ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (dbiseof(db1))
        {
			// Schon mal ber throw nachgedacht ?? --gl--
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            return -1;
        }

        return 1;
    },

    getAdditionalDataToStoreHDG : function(storepath)
    {
        var db1 = "", db2 = "", db3 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "", strSQLStatement3 = "";
        var numRet1 = 0, numRet2 = 0, numRet3 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    //
        db3 = this.GetProduktTabelle(this.m_Ptypid, 3);    //

        strSQLStatement1 = "select * from "+db1+" "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
        strSQLStatement2 = "select * from "+db2+" "
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2)
        if (db3 != "")
        {
            strSQLStatement3 = "select * from "+db3+" "
            numRet3 = dbselect("CASCADE", strSQLStatement3, db3)
        }

        if ((numRet1 <= 0) || ((db3 != "") && (numRet2 <= 0)) || ((db3 != "") && (numRet3 <= 0)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            if (db3 != "")
                logtrace("    >>> "+strSQLStatement3+"\n\r");
            return -1;
        }
        var nEmassFuerSuche = this.m_Pemass;
        if (m_bSonderNennweite)
            nEmassFuerSuche = this.NormEmass

        while (dbiseof(db1) == 0)
        {
            if (compareInt(dbgetdouble(db1, "nennweite"), this.nennweite) &&
                compareInt(dbgetdouble(db1, "E"), nEmassFuerSuche))
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (db2 != "")
        {
			while (dbiseof(db2) == 0)
			{
				if (this.m_Ptypid == "HDN" || this.m_Ptypid == "HDV" || this.m_Ptypid == "HDS")
				{
					if (compareInt(dbgetdouble(db2, "lgv"), this.lgv) &&
						(dbgetdouble(db2, "DN_MIN") <= this.nennweite) &&
						(dbgetdouble(db2, "DN_MAX") >= this.nennweite) )
					{
						dbcopy(db2, storepath);
						break;
					}
				}
				else
				{
					if (compareInt(dbgetdouble(db2, "lgv"), this.lgv))
					{
						dbcopy(db2, storepath);
						break;
					}
				}
				dbskip(db2);
			}
		}

        // bei HD.. gibts die dritte Tabelle nicht
        if (db3 != "")
        {
            while (dbiseof(db3) == 0)
            {
                if (left(this.m_Ptypid, 2) == "HB")
                {
                    if (compareInt(dbgetdouble(db3, "lgv"), this.lgv) &&
                        (dbgetdouble(db3, "DN_MIN") <= this.nennweite) &&
                        (dbgetdouble(db3, "DN_MAX") >= this.nennweite))
                    {
                        dbcopy(db3, storepath);
                        break;
                    }
                }
                else
                {
                    if (compareInt(dbgetdouble(db3, "DN"), this.nennweite))
                    {
                        dbcopy(db3, storepath);
                        break;
                    }
                }
                dbskip(db3);
            }
        }

        if (dbiseof(db1) || dbiseof(db2) || ((db3 != "") && dbiseof(db3)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            if (db3 != "")
                logtrace("    >>> eof Select 3: "+dbiseof(db3)+"\n\r");
            return -1;
        }

        return 1;
    },
	
	getAdditionalDataToStoreZL : function(storepath)
    {
        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;
		
        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);
		
        strSQLStatement1 = "select * from "+db1+" "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
        if (db2 != "")
        {
		strSQLStatement2 = "select * from "+db2+" "
        numRet2 = dbselect("CASCADE", strSQLStatement2, db2)
        }
		if ((numRet1 <= 0) || ((db2 != "") && (numRet2 <= 0)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            if (db2 != "")
                logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }
		var nEmassFuerSuche = this.m_Pemass;
		while (dbiseof(db1) == 0)
		{
			if (((compareInt(dbgetdouble(db1, "DN"), this.nennweite) &&
					compareInt(dbgetdouble(db1, "E"), nEmassFuerSuche))) || 
					(compareInt(dbgetdouble(db1, "LGV"), this.lgv)) && 
					(compareInt(dbgetdouble(db1, "E"), nEmassFuerSuche)))
			{
				dbcopy(db1, storepath);
				break;
			}
			dbskip(db1);
		}
		if (db2 != "")
		{
			while (dbiseof(db2) == 0)
			{
				if (compareInt(dbgetdouble(db2, "LGV"), this.lgv))
				{
					dbcopy(db2, storepath);
					break;
				}
				dbskip(db2);
			}
		}
		
		if (dbiseof(db1) || ((db2 != "") && dbiseof(db2)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            if (db2 != "")
                logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            return -1;
        }
		
        return 1;
	},

	makeTyp : function()
	{
        var buf = "";

        var strTyp  = this.m_Ptypid;

        if (this.m_Ptypid == "STF")	// Stauff-Schelle
            return this.m_Ptyp; // hier nicht neu bestimmen, weil wir den Typ gleich bei Erzeugung festlegen

        var nNennweiteFuerTyp = this.nennweite;

        if (this.m_bSonderNennweite)
        {
            if (this.m_Ptypid == "MSN")
            {
                if (this.m_dSonderNennweite > 50)
                    strTyp += "-S2";
                else
                    strTyp += "-S1";
            }
            else if (this.m_Ptypid == "LUS")
            {
                if (this.m_dSonderNennweite >= 799)
                    strTyp += "-S2";
                else
                    strTyp += "-S1";
            }
            else if (this.m_Ptypid == "HAN")
            {
                // @@@ TODO Lager HAN / LUS entfernen
                // if (atoi(GetProduktMass(m_strMasse, "B")) == 0)
                if (1)
                    strTyp += "-S1";
                else
                    strTyp += "-S2";
            }
            else
            {
                strTyp += "-S";
            }
            nNennweiteFuerTyp = RoundDoubleToInt(this.m_dSonderNennweite);
        }
		
		if (this.m_Ptypid == "HZN" || this.m_Ptypid == "HZV" || this.m_Ptypid == "HZS")
        {
			buf = sprintf("%s %.4d-%s.%d", strTyp, nNennweiteFuerTyp, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
        }
        else if (this.m_Ptypid == "LTD")
		{
			buf = sprintf("%s %.4d.%.3d-%s.%d", strTyp, nNennweiteFuerTyp, this.hoehe, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
		}
		
		else if (this.m_Ptypid == "LUS" || this.m_Ptypid == "HAN" || this.m_Ptypid == "HAP")
		{
			buf = sprintf("%s %.4d.%.3d.%.3d-%s.%d", strTyp, nNennweiteFuerTyp, this.hoehe, this.m_nLMass, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
        }
		else if (this.m_Ptypid == "MSN")
		{
			buf = sprintf("%s %.4d.%.3d.%.3d.%s-%s.%d", strTyp, nNennweiteFuerTyp, this.m_dNennlast, this.m_Pemass, this.m_strLGG, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
		}
		else if (this.m_Ptypid == "MSL")
		{
			buf = sprintf("%s %.4d.%.3d.%.4d-%s.%d", strTyp, nNennweiteFuerTyp, this.m_strLGG, this.m_Pemass, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
		}
        else if (this.m_Ptypid == "ZLV")
		{
			buf = sprintf("%s %.2d.%.3d-%.2d.%d", this.m_Ptypid, this.lgv, this.m_Pemass, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
		}
        else	// alle anderen
        {
			buf = sprintf("%s %.4d.%.3d.%s-%s.%d", strTyp, nNennweiteFuerTyp, this.m_Pemass, this.lgv, Werkstoffe[this.m_Pwerkstoff], Oberflaechenschutz[this.m_Poberfl]);
		}
        
		this.m_Ptyp = buf;

        if (this.m_Pwerkstoff == "W_RST" || this.m_Pwerkstoff == "W_RST52")
            this.m_Pzusinfo = "2.2";
        else
        {   if ((this.m_Pwerkstoff == "W_15MO3") || (this.m_Pwerkstoff == "W_13CRMO"))
                this.m_Pzusinfo = "3.1B";
            else
                this.m_Pzusinfo = "";
        }

        this.getPreis();

        return this.m_Ptyp;
	},

	fromTyp : function(strTyp)
	{
		var strTypNr = [];
        var strSonder = "";
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.m_bSonderNennweite = false;
		if(substr(strTyp, 4, 6) == "-S ")
		{
			this.m_bSonderNennweite = true;
			strSonder = substr(strTyp, 4, 6);
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			//if (this.m_Ptypid != "MSN")	// wir lassen die MSN durch - TEST!!!!
			//	return "Keine Sonderteile moeglich !";
		}
		if(substr(strTyp, 4, 6) == "-S1" || substr(strTyp, 4, 6) == "-S2")
		{
			this.m_bSonderNennweite = true;
			strSonder = substr(strTyp, 4, 6);
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			//return "Keine Sonderteile moeglich !";
		}

        switch (this.m_Ptypid)
        {
			case "HZN":
			case "HZV":
			case "HZS":
				strTypNr = splitVarDelimiter(strTyp, " -.");
				if (strTypNr.length == 3){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					if (strTypNr[2]*1 >= 41 && strTypNr[2]*1 <= 80)	// Austenit
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);
					else if (strTypNr[2]*1 < 37 || strTypNr[2]*1 > 80)	// Warmfest
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")]);
					else	// RSt
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "." + strTypNr[3];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 4 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.nennweite = atoi(getVarDelimited(strTypNr, 1));
				this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 2));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)];
                break;
			case "ZLV":
				strTypNr = splitVarDelimiter(strTyp, " .-.");
				if (strTypNr.length == 4){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					strTypNr.push(Oberflaechenschutz[getstring("OBFL_LASCHEN", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "." + strTypNr[4];
					this.m_Ptyp	= strTyp;
				}
				if(strTypNr.length < 5 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)]) == "undefined")
				{
					bOK = false;
					break;
				}
				//this.nennweite = atoi(getVarDelimited(strTypNr, 2));
				this.nennweite		= getint("IDC_NENNWEITE_DN","DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
				this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
                //this.hoehe = getVarDelimited(strTypNr, 2);
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				this.lgv = getVarDelimited(strTypNr, 1);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 3));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 4)];
				break;
			case "LUS":
			case "HAN":
				strTypNr = splitVarDelimiter(strTyp, " ..-.");
				if(strTypNr.length < 6 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.nennweite = atoi(getVarDelimited(strTypNr, 1));
				this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
                this.hoehe = getVarDelimited(strTypNr, 2);
				this.m_nLMass = getVarDelimited(strTypNr, 3);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)];
				break;
            case "MSN":
				/*
				if (this.m_bSonderNennweite){
					var SplitTyp	= strTyp.split(" ");
					strTyp			= "";
					for (var a=0; a<SplitTyp.length; a++){
						strTyp		+= SplitTyp[a];
					}
					SplitTyp		= strTyp.split("-S2");
					strTyp			= "";
					for (a=0; a<SplitTyp.length; a++){
						strTyp		+= SplitTyp[a] + "-S ";
					}
					strTyp			= trimright(strTyp, "-S ");
				}
				*/
				strTypNr = splitVarDelimiter(strTyp, " ...-.");
				if (strTypNr.length == 6){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					if (strTypNr[4]*1 >= 41 && strTypNr[4]*1 <= 80)	// Austenit
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);
					else if (strTypNr[4]*1 < 37 || strTypNr[4]*1 > 80)	// Warmfest
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")]);
					else	// Wechsellastschelle in RSt
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL2", "PROJECT.SETTINGS.CASCADE")]);
				}
				if(strTypNr.length < 7 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				if (!this.m_bSonderNennweite){
					this.nennweite			= atoi(getVarDelimited(strTypNr, 1));
					this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
				}
				else{
					this.m_dSonderNennweite	= atoi(getVarDelimited(strTypNr, 1));
					var dAInfo				= GetNextNennweiteFromRAD(this.m_dSonderNennweite);
					this.nennweite			= dAInfo.DN;
					// NormEmass suchen und setzen
					var WstNr			= WerkstoffeIdZuZahl[this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 5))];
					var SQLNormEmass	= "select * from " + this.m_Ptypid + " where abs(nennweite)=" + dAInfo.DN*1 +
											" and abs(FN)=" + atoi(getVarDelimited(strTypNr, 2)) +
											" and abs(E)>=" + atoi(getVarDelimited(strTypNr, 3)) +
											" and abs(werk)<=" + WstNr + " order by abs(werk) ";
					dbselect("CASCADE", SQLNormEmass, this.m_Ptypid);
					//while (dbiseof (this.m_Ptypid) == 0){
						this.NormEmass	= dbgetdouble(this.m_Ptypid, "E");	// wir nehmen das oberste
					//	dbskip (this.m_Ptypid);
					//}
				}
				this.m_dNennlast = atoi(getVarDelimited(strTypNr, 2));
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 3));
				this.m_strLGG = getVarDelimited(strTypNr, 4);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 5));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
				break;
			default:
				strTypNr = splitVarDelimiter(strTyp, " ..-.");
				if (strTypNr.length == 5 && left(strTypNr[0], 3) != "ZLB"){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					if (strTypNr[4]*1 >= 41 && strTypNr[4]*1 <= 80)	// Austenit
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);
					else if (strTypNr[4]*1 < 37 || strTypNr[4]*1 > 80)	// Warmfest
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")]);
					else if (left(strTypNr[0], 2) == "HG" || left(strTypNr[0], 2) == "MS")	// Grip- oder Wechsellastschelle in RSt
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL2", "PROJECT.SETTINGS.CASCADE")]);
					else	// alle anderen in RSt
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE")]);
					strTyp		+= "." + strTypNr[5];
					this.m_Ptyp	= strTyp;
				}
				else if (strTypNr.length == 5 && left(strTypNr[0], 3) == "ZLB"){	// der Oberflchenschutz fehlt -> wir nehmen den Default-Wert
					// Austenit ist zuknftig auch denkbar
					if (strTypNr[4]*1 >= 41 && strTypNr[4]*1 <= 80)	// Austenit
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")]);	// Default der Schellen
					else
						strTypNr.push(Oberflaechenschutz[getstring("OBFL_LASCHEN", "PROJECT.SETTINGS.CASCADE")]);	// Default der Laschen
					strTyp		+= "." + strTypNr[5];
					this.m_Ptyp	= strTyp;
				}
				if (strTypNr.length < 6 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)]) == "undefined")
				{
					bOK = false;
					break;
				}
				if (!this.m_bSonderNennweite){
					this.nennweite = atoi(getVarDelimited(strTypNr, 1));
					this.m_dSonderNennweite = GetRADfromNennweite(this.nennweite);
				}
				else{
					this.m_dSonderNennweite	= atoi(getVarDelimited(strTypNr, 1));
					var dAInfo				= GetNextNennweiteFromRAD(this.m_dSonderNennweite);
					this.nennweite			= dAInfo.DN;
					// NormEmass suchen und setzen
					var WstNr			= WerkstoffeIdZuZahl[this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4))];
					var SQLNormEmass	= "select * from " + this.m_Ptypid + " where abs(nennweite)=" + dAInfo.DN*1 +
											" and abs(E)>=" + atoi(getVarDelimited(strTypNr, 2)) +
											" and abs(werk)<=" + WstNr + " order by abs(werk) ";
					dbselect("CASCADE", SQLNormEmass, this.m_Ptypid);
					while (dbiseof (this.m_Ptypid) == 0){
						this.NormEmass	= dbgetdouble(this.m_Ptypid, "E");
						dbskip (this.m_Ptypid);
					}
				}
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				this.lgv = getVarDelimited(strTypNr, 3);
				this.m_Pwerkstoff = this.getWerkstoffeZahlZuId(getVarDelimited(strTypNr, 4));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 5)];
                break;
		}

		this.m_Pwerkalt = this.m_Pwerkstoff;

		// passt -S/-S1/-S2 dazu
        if(this.m_bSonderNennweite && bOK)
        {
            if((this.m_Ptypid == "MSN" || this.m_Ptypid == "LUS" || this.m_Ptypid == "HAN") && strSonder == "-S ")
            {
                bOK = false;
            }
            else if(strSonder != "-S " && this.m_Ptypid != "MSN" && this.m_Ptypid != "LUS" && this.m_Ptypid != "HAN")
            {
                bOK = false;
            }
			if(! bOK)
				return "Markierung fuer Sonderteile falsch !";
		}

		this.m_Pzusinfo = "";
        if(this.m_Pwerkstoff == "W_RST" || this.m_Pwerkstoff == "W_RST52")
            this.m_Pzusinfo = "2.2";
        else //if(this.m_Pwerkstoff == "W_15MO3" || this.m_Pwerkstoff == "W_13CRMO")
			this.m_Pzusinfo = "3.1B";

        this.getPreis();

	// 26.08.08 mb Produkt korrekt ?
        var tmpPath = "TMP.HS_ADDITIONAL_DATA";
		var bSuccess = this.getAdditionalDataToStore(tmpPath);
		if(bSuccess == -1)
			return "ERR";

		var lgvDS = getstring("LGV", tmpPath);
		if(getstring("LGV", tmpPath) != "" && atod(this.lgv) != atod(lgvDS))
			return "ERR";

	// 20.08.08 mb weitere Daten setzen
		if(this.lgv=="") this.lgv = lgvDS;
		if(this.a_lgv=="") this.a_lgv = lgvDS;
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWICHT", tmpPath);
		
		if(this.m_Pemass<=0) this.m_Pemass = getdouble("E", tmpPath);
		if(this.MediumTemperatur<=0)	this.MediumTemperatur		= getint("IDC_TEMPERATUR_MEDIUM", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.UmgebungsTemperatur<=0)	this.UmgebungsTemperatur	= getint("IDC_TEMPERATUR_UMGEBUNG", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.ReferenzTemperatur<=0)	this.ReferenzTemperatur		= getint("IDC_TEMPERATUR_REFERENZ", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if(this.Daemmdicke<=0)			this.Daemmdicke				= getint("IDC_DAEMMDICKE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		
        return(bOK ? "" : "ERR");
	},

	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        // wir mssen nochmal in die Grunddaten rein, weil sich bei manchen Produkten
        // durch nderung Werkstoff oder Oberflchenschutz der Preis ndern kann:
        var tmpPath = "TMP.HS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        if (this.m_Ptypid == "MSL")
			var strFieldname = "P" + Oberflaechenschutz[this.m_Poberfl];
		else
			var strFieldname = "P" + Werkstoffe[this.m_Pwerkstoff] + "_" + Oberflaechenschutz[this.m_Poberfl];

        this.m_Ppreis = 0.0;
        if (getstring(strFieldname, tmpPath) != "")
        {
            this.m_Ppreis = inputStringToDouble(getstring(strFieldname, tmpPath));
            if (oOptions.SONDERANSTRICH_KOSTEN > 0)
                this.m_Ppreis += (oOptions.SONDERANSTRICH_KOSTEN * this.m_Pgewicht);
        }
        if (this.m_bSonderNennweite)
        {
            var dZuschlag = this.getPreiszuschlagSonder(this.getSAPKlassenName(), this.getSAPTyp(), "");
            this.m_Ppreis = fround(this.m_Ppreis * dZuschlag, 0);
        }

        this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_SCHELLEN");

        return this.m_Ppreis;
	},

    getTopoPic : function(Drehung)
    {
        // Hack, weil wir nur fr die N-Version Bilder haben
       
		if ((this.m_Ptypid != "ZLV") && (this.m_Ptypid != "ZLB") && (this.m_Ptypid != "MSL"))
		{
			var strTeilPic = left(this.m_Ptypid, 2) + "N";
			if (((Drehung >= 45) && (Drehung <= 135)) || ((Drehung >= 225) && (Drehung <= 315)))
				strTeilPic = strTeilPic + "_S";
		}
		else if ((this.m_Ptypid == "ZLV") || (this.m_Ptypid == "MSL"))
		{
			var strTeilPic = this.m_Ptypid;
			if (((Drehung >= 45) && (Drehung <= 135)) || ((Drehung >= 225) && (Drehung <= 315)))
				strTeilPic = strTeilPic + "_S";
		}
		else if (this.m_Ptypid == "ZLB")
        {
            var strTeilPic = this.m_Ptypid;
            if ((Drehung >= 45) && (Drehung <= 135))
                strTeilPic = strTeilPic + "_S1";
            else if ((Drehung > 135) && (Drehung < 225))
                strTeilPic = strTeilPic + "_S2";
            else if ((Drehung >= 225) && (Drehung <= 315))
                strTeilPic = strTeilPic + "_S3";
		}
		
		var strPic = "catalog/client/custom/img/panels/T"+strTeilPic+".png";
		
        // MSN / MSL kann "oben" oder "unten" sein -> Drehung merken!!!
		strTeilPic	= (right(strTeilPic, 2) == "_S" ? right(strTeilPic, 2) : "");
		if (this.m_Pcpartid == "IDL_C_MSN_O")
            strPic = "catalog/client/custom/img/panels/TMSNO"+strTeilPic+".png";
        else if (this.m_Pcpartid == "IDL_C_MSN_U")
            strPic = "catalog/client/custom/img/panels/TMSNU"+strTeilPic+".png";
		else if (this.m_Pcpartid == "IDL_C_MSL_O")
            strPic = "catalog/client/custom/img/panels/TMSLO"+strTeilPic+".png";
        else if (this.m_Pcpartid == "IDL_C_MSL_U")
            strPic = "catalog/client/custom/img/panels/TMSLU"+strTeilPic+".png";
		
        return strPic;
    },

    isSAPKonfigurierbar : function()
    {
        if ((left(m_Ptypid, 2) == "HD") ||
            (left(m_Ptypid, 2) == "HG") ||
            (left(m_Ptypid, 2) == "HB") ||
            (left(m_Ptypid, 2) == "MS") ||	// die MSL ist konfigurierbar darf nicht aufgelst werden - Kaufteil
											// Korrektur von "loeseauf" vornehmen
			(m_Ptypid == "ZLB"))
            return 1;

        // Achtung: 03/2009: Sonder-HZ/HD haben jetzt Stcklisten
		if ((this.m_bSonderNennweite) && 
			((left(this.m_Ptypid, 2) == "HZ") || (left(this.m_Ptypid, 2) == "HD")))
            return 1;

        return 0;
    },

    getSAPKlassenName : function()
    {
        var strKlasse = this.m_Ptypid;  // Default
        if ((m_Ptypid == "HZN") || (m_Ptypid == "HZV"))
            strKlasse = "HZN";
        // HZS ist HZS !
        if (left(m_Ptypid, 2) == "HB")
            strKlasse = "HBN";
        if (left(m_Ptypid, 2) == "ZZ")
            strKlasse = "ZZF";
		if (m_Ptypid == "ZLV")
			strKlasse = "ZVN";
		if (m_Ptypid == "ZLB")
			strKlasse = "HDN";
        return strKlasse;
    },

    getSAPTyp : function()
    {
        return this.m_Ptypid;
    },

	getSubtyp : function()
	{
		var Subtyp				= "";
		var isExpertMode		= getstring("EXPERT_MODE", "RIGHTS");
		var specialScrews		= false;
		var strSQLStatement		= "select * from AUSLTEMPMAX where EXPERT = " + isExpertMode + " ";
		var numret				= dbselect("CASCADE", strSQLStatement, "TEMPMAX");
		if (numret){
			var ScrewMaxTemp	= dbgetdouble("TEMPMAX", "MAXTEMPSCHRAUB");
			if (ScrewMaxTemp <= refTemp)
				specialScrews	= true;
		}
		
		if ((this.m_bSonderNennweite) && 
			((left(this.m_Ptypid, 2) == "HZ") || (left(this.m_Ptypid, 2) == "HD")))
			//return (this.m_Ptypid + "-S");
			Subtyp	+= (this.m_Ptypid + "-S");
		//else if (left(this.m_Ptypid, 2) == "HB" && this.ReferenzTemperatur*1 > 650)
		if (specialScrews)
			//return (this.m_Ptypid + "_650");
			Subtyp	+= (this.m_Ptypid + "_650");
			
		//return "";
		return Subtyp;
	},
	
    getASTLDaten : function(theMainController)
    {

        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        retObj.loeseauf = this.isSAPKonfigurierbar();
		// -Schu- Sonderfall "MSL" : diese ist konfigurierbar darf aber nicht aufgelst werden - Kaufteil
		if (this.m_Ptypid == "MSL")
			retObj.loeseauf = 0;
		
        var strKlasse = this.getSAPKlassenName();
        var searchObj;
        var sapWerkstoffBez = WerkstoffeSAPid[this.m_Pwerkstoff];
        var sapOberflaechenschutz = Oberflaechenschutz[this.m_Poberfl];

        var oOptions = theMainController.presets.getPreisOptions();
        if (oOptions.SONDERANSTRICH_TEXT != "")
            sapOberflaechenschutz = "0";

        var nEmassFuerSuche = this.m_Pemass;
        if (this.m_bSonderNennweite)
            nEmassFuerSuche = this.NormEmass

        var nNormAussendurch = GetRADfromNennweite(this.nennweite);

        var massPath = "TMP.HS_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(massPath);

        if ((m_Ptypid == "HZN") || (m_Ptypid == "HZV") || (m_Ptypid == "HZS"))
        {
            if (this.m_bSonderNennweite)
            {
                searchObj = { AUSSENDURCHMESSER: '',
                              OBERFLAECHENSCHUTZ: '',
                              WERKSTOFFS: '',
                              TYP_SCHELLE: m_Ptypid + "-S" };
                // retObj.loeseauf = 0;
            }
            else
            {
                // NENNWEITE, AUSSENDURCHMESSER, BREITE, DICKE, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP
                searchObj = { AUSSENDURCHMESSER: this.m_dSonderNennweite,  // hier soll Matnr NICHT gefunden werden bei Sonderdurchmesser
                              OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                              WERKSTOFFS: sapWerkstoffBez,
                              TYP_SCHELLE: this.getSAPTyp() };
            }
        }
        else if ((m_Ptypid == "HDN") || (m_Ptypid == "HDV") || (m_Ptypid == "HDS"))
        {
            if (this.m_bSonderNennweite)
            {
                searchObj = { AUSSENDURCHMESSER: "",
                              EINBAUMASS: "",
                              OBERFLAECHENSCHUTZ: "",
                              WERKSTOFFS: "",
                              TYP_SCHELLE: m_Ptypid + "-S" };
                // retObj.loeseauf = 0;
            }
            else
            {
                // NENNWEITE, AUSSENDURCHMESSER, EINBAUMASS, OBERFLAECHENSCHUTZ, WERKSTOFF, TYP, BREITE, DICKE
                searchObj = { AUSSENDURCHMESSER: nNormAussendurch,      // hier soll Matnr gefunden werden bei Sonderdurchmesser
                              EINBAUMASS: nEmassFuerSuche,
                              OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                              WERKSTOFFS: sapWerkstoffBez,
                              TYP_SCHELLE: this.getSAPTyp() };
            }
        }
        else if ((m_Ptypid == "HGN") || (m_Ptypid == "HGV") || (m_Ptypid == "HGS"))
        {
            searchObj = { PROFILDURCHMESSER: getstring("D_", massPath),
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP_SCHELLE: this.getSAPTyp() };
        }
        else if (m_Ptypid == "MSN")
        {
            searchObj = { PROFILDURCHMESSER: getstring("D_", massPath),
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP_SCHELLE: this.getSAPTyp(),
                          NENNLAST: this.m_dNennlast};
        }
		else if (m_Ptypid == "ZLV")
		{
			searchObj = { LASTGRUPPE: this.lgv,
						  OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
						  WERKSTOFFS: sapWerkstoffBez,
						  TYP: this.getSAPTyp() };
		}
		else if (m_Ptypid == "ZLB")
		{
			searchObj = { AUSSENDURCHMESSER: this.m_dSonderNennweite,
						  OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
						  WERKSTOFFS: sapWerkstoffBez,
						  TYP_SCHELLE: this.getSAPTyp() };
		}
		else    // HB...
        {
            searchObj = { LASTGRUPPE: this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          WERKSTOFFS: sapWerkstoffBez,
                          TYP_SCHELLE: this.getSAPTyp() };
        }

        var aMerkmale = this.getMerkmaleArray(strKlasse, searchObj);
        var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte; // nicht so toll ...

        /*
        In der Hauptstckliste der LK knnten wir das Feld MAT_KURZ_TXT aus Tabelle Material benutzen.
        Da SAP hier aber automatisch diesen Text ergnzt, lassen wir hier Feld Positionstext 1, 2 komplett leer.
        Ausser: Bei Rohmasspositionen (z.B. ZRM) und konfigurierbaren Materialien schreiben wir
        in Feld Positionstext 1 den Typencode rein. Positionstext 2 bleibt dann auch leer.
        */
        // retObj.postext2 = matInfo.mat_kurz_txt;
        if (this.isSAPKonfigurierbar() || this.isRohmassPosition())
            retObj.postext1 = this.m_Ptyp;

        return retObj;
	},


    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
        var strDaemmdicke  = this.Daemmdicke;
        if (!strDaemmdicke)
            strDaemmdicke = "0";
        var strAussendurch = this.m_dSonderNennweite;       // m_dSonderNennweite enthlt immer den IST-Aussendurchmesser caMainController.dataAccess.getRohrAussendurchmesser(0);
        var aParams = new Array();

        if (nTyp == "E")
            aParams.push( [ "Typ", "" + this.m_Ptypid ] );
        else aParams.push( [ "Position" + nStartPos, "" + this.m_Ptypid ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

        // Wird nur bei manchen Schellen gebraucht, schadet aber nicht:
        aParams.push( [ "E-Mass" + nStartPos, "" + this.m_Pemass ] );
        aParams.push( [ "E-Mass", "" + this.m_Pemass ] );   // mal mit (HDN) mal ohne (MSN) Posnr ;-(

        // ACHTUNG: die nachfolgenden Parameter tragen nicht die Posnr:
        aParams.push( [ "Oberflaeche", "" + Oberflaechenschutz[this.m_Poberfl] ] );
        aParams.push( [ "Daemmdicke", "" + strDaemmdicke ] );
        aParams.push( [ "Rohraussendurchmesser", strAussendurch ] );
        aParams.push( [ "Werkstoff", "" + Werkstoffe[this.m_Pwerkstoff] ] );
        aParams.push( [ "FN", "" + this.m_dNennlast ] );

        return( [ aParams, nPosNr + 1 ] );
    }


});