/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2011 Plan Software GmbH
 *
 * @category Products
 * @package
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Lager constructor
 */
Gleitelement2 = function( ) {

	Gleitelement2.superclass.constructor.call( this );

	/**
     *
     * @var
     */
	this.oData = null;
};


EasyKat.extend( Gleitelement2, Produkt, {

	init :  function( oDlgLager, oData )
	{
		this.oData = oData ? oData : oDlgLager.AuswahlStandard.oSearchResult.oResultGleitelement;
		
		// korrigiere Variablen der Oberklasse
		this.m_Ptyp 		= this.oData.TYP_CALCULATION ? this.oData.TYP_CALCULATION :this.oData.TYP;
		this.m_Ptypid 		= left( this.oData.TYP, 3 );
		this.m_Ppreis 		= (getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927") ? 0 : this.oData.PREIS;
		this.m_PIdentNr 	= this.oData.IDENT;
		this.m_Pgewicht 	= this.oData.GEW;
		this.m_Pwerkstoff 	= Base.getLanguageTextWerkstoff(this.oData.WERKSTOFF).strTextID;
		if ((this.oData.OBFL) && (this.oData.OBFL != "") && (this.m_Ptypid != "LGE"))
			this.m_Poberfl = Base.getLanguageTextOberflaeche(this.oData.OBFL).strTextID;
		if (this.m_Ptypid == "LGE")
			this.m_Poberfl = "OB_FEUER";
		this.strBaureihe 	= this.m_Ptypid;	// etwas sprechender
		this.strBauF	 	= this.oData.BAU_F;
		//this.m_Pemass 		= RoundDoubleToInt( this.oData.H );   // -mw- wird auch gebraucht
		// @@@ LGE Test
		this.m_Pemass 		= this.oData.H ? RoundDoubleToInt( this.oData.H ) : RoundDoubleToInt( this.oData.E );
	},
	
	/**
     * Einlesen des internen Zustands aus dem Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    serializeIn : function( strPath )
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if ( getstring( "__CLASSNAME__", strPath ) == "" )
            return( -1 );     // ist noch nichts da

        // Oberklasse einserialisieren
        Produkt.prototype.serializeIn.call( this, strPath );

		// Variablen dieser Klasse
		this.oData = Object.fromStorage( strPath+ ".LAGERDATA" );

		this.strBaureihe = getstring( "strBaureihe", strPath );
		this.strBauF	 = getstring( "strBauF", strPath );

        return 1;
    },

	/**
     *  Speichern des internen Zustands im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	-
     */
    serializeOut : function( strPath )
	{
        // Klasseninfo
        setstring( "__CLASSNAME__", strPath, "Gleitelement2" );

        // Oberklasse rausserialisieren
        Produkt.prototype.serializeOut.call( this, strPath );

		// Variablen dieser Klasse
		this.oData.toStorage(strPath+ ".LAGERDATA", false);   // kein merge

		setstring( "strBaureihe", strPath, this.strBaureihe );
		setstring( "strBauF", strPath, this.strBauF );
    },


	/**
     * bestimme die Typbezeichnung des Lagers und setzt die interne Variable fr diese Typbezeichnung
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	string: Typbezeichnung des Lagers
	 */
	makeTyp : function()
	{
		// Mass-String fr STK-Export:   @@@ TODO
		this.m_strMasse  = " TrT " + this.strTraegertyp + " Brt " + this.strTraegerbreite + " TrH " + this.strTraegerhoehe + " Tg10 " + this.strFlanschdicke;

        return this.m_Ptyp;
	},

	/**
     * aus Typnummer das Produkt bestimmen
	 *
	 * @params -
	 * @returns	bool: true/false
	 */
	fromTyp : function(strTyp)
	{
        var bOK = true;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.strBaureihe = this.m_Ptypid;
		this.m_Poberfl = "";

        return( bOK ? "" : "ERR" );
	},

	/**
     * bestimmt den Dateinamen fr das Bild des aktuellen Lagers, abhngig von der Typbezeichnung usw.
	 *
	 * @params double Drehung - Drehung des Bildes
	 * @returns	string: Dateinamen des Bildes
	 */
    getTopoPic : function( Drehung )
    {
		var strFile = '';
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		if (rfind(AchsDirInfo[9], "RV") > 0)
		{
			switch (Drehung)	// wir gehen auf die Horizonzalen Bilder
			{
				case '0':
				case '180':
					AchsDirInfo[9] = "Var1";
					break;
				case '90':
				case '270':
					AchsDirInfo[9] = "Var2";
					break;
				default:
					AchsDirInfo[9] = "Var1";
					break;
			}
        }
		else
			AchsDirInfo[9]	= right(AchsDirInfo[9], 4);
		if ( this.oData.BAUFO )
			strFile = "catalog/client/custom/img/WITgifs/RH/" + AchsDirInfo[9] + "_" + this.oData.BAUFO + ".jpg";
		else 
			strFile += 'catalog/client/custom/img/panels/TEMPTY.png';
		
		return( strFile );
    },

	/**
     *  lese zustzliche Daten des Produktes aus den Datenbanken und speichere sie im Store
	 *
	 * @params String strPath - Pfad im Store fr Lagerdaten
	 * @returns	integer >= 1: Funktion erfolgreich
	 *                  < 1: Fehler bei der Ausfhrung
     */
    getAdditionalDataToStore : function( strPath )
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc. ausgelesen und in einen Storepfad gespeichert
        delete( strPath, "" );

		// da alle technischen Daten Member des Lagers sind und im Konstruktor eingelesen werden, kann man hier ebensogut an die
		// serializeOut-Funktion des Lagers delegieren
		this.serializeOut( strPath );

		// !!! Da die Datenbank-Daten des Produkts jetzt im Unterpfad LAGERDATA stehen,
		// mssen sie nochmal hochkopiert werden ....
		this.oData.toStorage(strPath, true);   // merge !

        return 1;
    },

	/**
     * bestimme den Preis des Lagers und setzt die interne Variable fr diesen Preis
	 * auf das Resultat der Berechnung
	 *
	 * @params -
	 * @returns	double: Preis des Lagers
	 */
	getPreis : function(oOptions)
    {
        if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
            return( 0 );
		
		var strSQLStatement = "select * from LGA_LGV where TYP = '" +this.oData.TYP+ "' ";
		var numRet			= dbselect("LAGER2", strSQLStatement, "PREIS");
		this.oData.PREIS	= (numRet == 1 ? dbgetdouble("PREIS", "PREIS") : 0);
		
		this.m_Ppreis	= this.oData.PREIS;
		var dPreis		= this.m_Ppreis;
        if (oOptions.SONDERANSTRICH_KOSTEN > 0)
            dPreis = inputStringToDouble(this.m_Ppreis) + (oOptions.SONDERANSTRICH_KOSTEN * inputStringToDouble(this.m_Pgewicht));

		// in den Tabellen stehen momentan nur Preise fr die Defaultversion des Oberflchenschutzes
        // dPreis = this.getNettoPreis(dPreis, "RABATT_TYP_SCHELLEN");
		// dPreis = this.getNettoPreis(dPreis, "RABATT_TYP_LAGER");
		dPreis = Base.getPrice(dPreis, "RABATT_TYP_LAGER");

        return( dPreis );
	},

	/**
     * prft, ob das Lager in SAP konfigurierbar ist
	 *
	 * @params -
	 * @returns	integer: 1 - in SAP konfigurierbar
	 *                   0 - nicht in SAP konfigurierbar
	 */
    isSAPKonfigurierbar : function(oProfil)
    {
		var bIsConfigurable = false;
        
        return( bIsConfigurable ? 1 : 0 );
    },

	/**
     * holt den SAP-Klassennamen des Gleitelements
	 *
	 * @params -
	 * @returns	string: Klassenname in SAP
	 */
    getSAPKlassenName : function()
    {
		var strKlasse = 'GGA';	
		if (this.m_Ptypid != 'LGA')
			strKlasse = 'GGV';

        return( strKlasse );
    },

	/**
     * holt den SAP-Typ
	 *
	 * @params -
	 * @returns	string: Lagertyp in SAP
	 */
    getSAPTyp : function()
    {
        return( this.strBaureihe );
    },

	/**
     *  hole Zusatzdaten fr die Stckliste
	 *
	 * @params Object(CaController) theMainController - Hauptcontroller fr Cascade
	 * @returns	Object
     */
    getASTLDaten : function( theMainController )
    {
		// Defaultbelegung
        var retObj = { loeseauf: 0, postyp: "L", matnr: '', postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        var strKlasse = this.getSAPKlassenName();
        var searchObj = {};
        var sapWerkstoffBez = WerkstoffeSAPid[ this.m_Pwerkstoff ];
        var sapOberflaechenschutz = Oberflaechenschutz[ this.m_Poberfl ];

		var strSAPTyp = this.strBaureihe;

        retObj.loeseauf = this.isSAPKonfigurierbar();

        var oOptions = theMainController.presets.getPreisOptions();
        if (oOptions.SONDERANSTRICH_TEXT != "")
            sapOberflaechenschutz = "0";

		// LAENGE	BREITE	DICKE	OBERFLAECHENSCHUTZ	WERKSTOFF	TYP
		searchObj = {
			LAENGE: 			this.oData.L,
			BREITE: 			this.oData.B,
			DICKE: 				this.oData.H,
			OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
			//WERKSTOFF: 			this.oData.WERKSTOFF,
			WERKSTOFF: 			this.oData.WERKSTOFF + (strSAPTyp == "LGE" ? right(left(this.m_Ptyp, 15), 1) : ""),
			TYP: 				strSAPTyp
		};

        var aMerkmale = this.getMerkmaleArray( strKlasse, searchObj );
        var matInfo   = this.getMatInfo( theMainController, strKlasse, aMerkmale, "", 1 );
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte;

        if ( this.isSAPKonfigurierbar() )
            retObj.postext1 = this.m_Ptyp;

        return( retObj );
	},

	/**
     *  hole Subtyp des Lagers (Baureihe + erste Ziffer der Nennhhe + optional Trgerform)
	 *
	 * @params -
	 * @returns	string Subtyp
     */
	getSubtyp : function()
	{
		return( 'GE' );
	},

	/**
     *  hole Daten fr 3D CAD-Darstellung des Lagers
	 *
	 * @params integer nStartPos - startposition des Lagers in der Lastkette
	 *         integer nPosNr - Position des Lagers in der Lastkette (1-basiert)
	 *         double Drehung - Drehung des Lagers beim Zeichnen
	 *         string nTyp - ???
	 * @returns	Array - index 0: array mit Parametern (key-value-Paare)
	 *                  index 1: Position des nchsten Produktes in der Lastkette (normalerweise nPosNr + 1)
     */
    getCADDaten : function( nStartPos, nPosNr, Drehung, nTyp )
    {
		var aParams = new Array();

		// Defaultwerte
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

		// berechne Werte fr Parameter
		var strTypForCAD = this.strBaureihe + this.strBauF;

		// setze CAD-Parameter
        if (nTyp == "E")
            aParams.push( [ "Typ", "" + strTypForCAD ] );
        else aParams.push( [ "Position" + nStartPos, "" + strTypForCAD ] );

        return( [ aParams, nPosNr + 1 ] );
    }
	
	
});
