/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */


 /**
 * Federhaenger
 */
Federhaenger = function() {

	Federhaenger.superclass.constructor.call(this);

	/**
     *
     * @var
     */
	this.groesse = "";
	this.nennweg		= 0;
	this.sollweg		= 0;	// +- je nach richtung (wichtig f. Gew.st.lngenanpassung!)
	this.strSollwege	= "";
	this.spannweite		= 0;	// fr FDT, FSG
	this.warmlast		= 0;
	this.warmlast2		= 0;   // 22.1.2009: neu - Fr den Fall mittig blockiert
	this.kaltlast		= 0;
	this.lastabw		= 0;
	this.res_oben		= 0;
	this.res_unten		= 0;
	this.res_min		= 0;
	this.federrate		= 0;
	this.lgv			= "";
	this.m_strLGG		= "";

	this.estern			= 0;
	this.vorspann		= 0;
	this.e_mass			= 0;		// klein e !	(wird aber vermutlich z.Zt. nicht gebraucht)
	this.aktgew			= 0;		// aktives Gewicht bei FDT (= Akt. Gewicht der Hnger + Gew. d. Traverse)
    this.D				= 0;

	this.nEminAbsolut		= 0;
	this.nDeltaE			= 0;
	this.nBmass				= 0;
	this.m_dNennlast		= 0;
	this.m_nNennLaengeFSG	= 0;

	this.m_FDT_Traegertyp		= "";
	this.m_FDT_FSG_LaengeVteil	= 0;
	this.m_FDT_GehGew			= 0;
	this.m_FDT_TGewicht			= 0;

	this.m_bSonderSpannweite	= 0;
	this.m_dSonderSpannweite	= 0;

    this.SollastHpkt	= 0;
    this.Zusatzlast 	= 0;

    this.AnpassungEmass	= 0;		// Emass kann angepasst werden
	this.Blockpos		= 0;		// Blockierposition
	
	this.notSSBVerl		= 1;		// 1 ... keine Verlngerung
};


EasyKat.extend(Federhaenger, Produkt, {

    serializeIn : function(strPath)
	{
        // Prfung, ob berhaupt schon was da ist zum Reinserialisieren
        if (getstring("__CLASSNAME__",strPath) == "")
            return -1;     // ist noch nichts da

        // Oberklasse hier auch aufrufen
        Produkt.prototype.serializeIn.call(this, strPath);       // Horizontalschelle

        // Einfache Variablen einlesen, je nach Typ
        this.groesse   = getstring("groesse",strPath);
        this.nennweg   = getdouble("nennweg",strPath);
        this.sollweg   = getdouble("sollweg",strPath);
		this.strSollwege	= getstring("strSollwege", strPath);
        this.spannweite = getdouble("spannweite",strPath);
        this.warmlast  = getdouble("warmlast",strPath);
        this.warmlast2 = getdouble("warmlast2",strPath);
        this.kaltlast  = getdouble("kaltlast",strPath);
        this.lastabw   = getdouble("lastabw",strPath);
        this.res_oben  = getdouble("res_oben",strPath);
        this.res_unten = getdouble("res_unten",strPath);
        this.res_min   = getdouble("res_min",strPath);
        this.federrate = getdouble("federrate",strPath);
        this.lgv 	   = getstring("lgv",strPath);
        this.m_strLGG  = getstring("m_strLGG",strPath);

        this.estern   = getdouble("estern",strPath);
        this.vorspann = getdouble("vorspann",strPath);
        this.e_mass   = getdouble("e_mass",strPath);
        this.aktgew   = getdouble("aktgew",strPath);
        this.D        = getdouble("D",strPath);

        this.nEminAbsolut       = getdouble("nEminAbsolut",strPath);
        this.nDeltaE            = getdouble("nDeltaE",strPath);
        this.nBmass             = getdouble("nBmass",strPath);
        this.m_dNennlast        = getdouble("m_dNennlast",strPath);
        this.m_nNennLaengeFSG   = getdouble("m_nNennLaengeFSG",strPath);

        this.m_FDT_Traegertyp   = getstring("m_FDT_Traegertyp",strPath);
        this.m_FDT_FSG_LaengeVteil = getdouble("m_FDT_FSG_LaengeVteil",strPath);
        this.m_FDT_GehGew = getdouble("m_FDT_GehGew",strPath);
        this.m_FDT_TGewicht = getdouble("m_FDT_TGewicht",strPath);

        this.m_bSonderSpannweite = getdouble("m_bSonderSpannweite",strPath);
        this.m_dSonderSpannweite = getdouble("m_dSonderSpannweite",strPath);

        this.SollastHpkt = getdouble("SollastHpkt",strPath);
        this.Zusatzlast  = getdouble("Zusatzlast",strPath);
		
		this.AnpassungEmass = getdouble("AnpassungEmass",strPath);
		this.Blockpos		= getdouble("Blockpos",strPath);

        return 1;
    },

    serializeOut : function(strPath)
	{
        // Klasseninfo
        setstring("__CLASSNAME__",strPath, "Federhaenger");

        Produkt.prototype.serializeOut.call(this, strPath);

        // Einfache Variablen
        setdouble("nennweg",         strPath, this.nennweg);
        setdouble("sollweg",         strPath, this.sollweg);
		setstring("strSollwege",	 strPath, this.strSollwege);
        setdouble("spannweite",      strPath, this.spannweite);
        setdouble("warmlast",        strPath, this.warmlast);
        setdouble("warmlast2",       strPath, this.warmlast2);
        setdouble("kaltlast",        strPath, this.kaltlast);
        setdouble("lastabw",         strPath, this.lastabw);
        setdouble("res_oben",        strPath, this.res_oben);
        setdouble("res_unten",       strPath, this.res_unten);
        setdouble("res_min",         strPath, this.res_min);
        setdouble("federrate",       strPath, this.federrate);
        setdouble("estern",          strPath, this.estern);
        setdouble("vorspann",        strPath, this.vorspann);
        setdouble("e_mass",          strPath, this.e_mass);
        setdouble("aktgew",          strPath, this.aktgew);
        setdouble("D",               strPath, this.D);
        setdouble("nEminAbsolut",    strPath, this.nEminAbsolut);
        setdouble("nDeltaE",         strPath, this.nDeltaE);
        setdouble("nBmass",          strPath, this.nBmass);
        setdouble("m_dNennlast",     strPath, this.m_dNennlast);
        setdouble("m_nNennLaengeFSG",strPath, this.m_nNennLaengeFSG);

        setstring("m_FDT_Traegertyp",strPath, this.m_FDT_Traegertyp);
        setdouble("m_FDT_FSG_LaengeVteil",strPath, this.m_FDT_FSG_LaengeVteil);
        setdouble("m_FDT_GehGew",strPath, this.m_FDT_GehGew);
        setdouble("m_FDT_TGewicht",strPath, this.m_FDT_TGewicht);

        setstring("groesse",        strPath, this.groesse);
        setstring("lgv",            strPath, this.lgv);
        setstring("m_strLGG",       strPath, this.m_strLGG);

        setdouble("m_bSonderSpannweite",strPath, this.m_bSonderSpannweite);
        setdouble("m_dSonderSpannweite",strPath, this.m_dSonderSpannweite);

        setdouble("SollastHpkt",	strPath, this.SollastHpkt);
        setdouble("Zusatzlast",		strPath, this.Zusatzlast);

        setdouble("AnpassungEmass",	strPath, this.AnpassungEmass);
		setdouble("Blockpos",		strPath, this.Blockpos);
    },

    Init : function(/*const char **/groe, /*int*/ nenn, /*int*/ soll,
                    /*double*/ warm, /*double*/ warm2, /*double*/ kalt,
                    /*double*/ lastab, /*int*/ reso, /*int*/ resu, /*int*/ resmin,
                    /*double*/ frate, /*const char**/ lg,
                    SollastHpkt, ZuslastHpkt, Blockpos, s_minus, s_plus)
    {
        this.groesse = groe;
        this.nennweg = nenn;
        this.sollweg = soll;
        this.warmlast = warm;
        // this.warmlast2 = 0;  hier nicht setzen ... ist mit 0 initialisiert und wird nur bei Blockierung mittig gesetzt
        this.warmlast2 = warm2;	// auch fr 2. Bewegungsrichtung verwendet - falls nicht relevant kommt hier eine "0"
		this.kaltlast = kalt;
        this.lastabw = lastab;
        this.res_oben = reso;
        this.res_unten = resu;
        this.res_min = resmin;
        this.federrate = frate;
        this.lgv = lg;
        this.e_mass = 0;
        this.aktgew = 0;
        
		this.strSollwege	= (s_minus*1 != 0 ? "-" + s_minus : "");
		if (this.strSollwege != "" && s_plus*1 != 0)
			this.strSollwege	+= "/";
		this.strSollwege	+= (s_plus*1 != 0 ? "+" + s_plus : "");
		
		/*if (this.sollweg < 0)	// Abwrts
            this.vorspann = this.res_oben;
        else				// Aufwrts
            this.vorspann = this.nennweg - this.res_unten;
		*/
		this.vorspann = Blockpos;
        m_Pblock = caMainController.presets.m_nFhBlock;
        if (!m_Pblock)
            m_Pblock = "BLOCK_JA";

        this.SollastHpkt = SollastHpkt;
        this.Zusatzlast  = ZuslastHpkt;

        return 1;
    },
	
	InitSSB : function(/*double*/ a_Fsoll, a_Fsoll_HZ, a_Fsoll_HS, /*double*/ dTestload, a_ZusLast, S_ein, S_aus)
    {
        this.groesse    = "";
        this.nennweg    = 0;
        this.sollweg    = 0;
        this.warmlast   = a_Fsoll;
        this.kaltlast   = a_Fsoll;
        this.lastabw    = 0;
        this.res_oben   = 0;
        this.res_unten  = 0;
        this.res_min    = 0;
        this.federrate  = 0;
        this.lgv        = "";
		
        this.e_mass     = 0;
        this.aktgew     = 0;
        this.vorspann   = 0;
		
        this.SollastHpkt = a_Fsoll;
        this.Zusatzlast  = a_ZusLast;
		
		this.m_Ptypid   = "SSB";
        this.m_Poberfl  = this.getOberFlaechenSchutzDefault();
		
        m_Pblock = caMainController.presets.m_nFhBlock;
        if (!m_Pblock)
            m_Pblock = "BLOCK_JA";
		
		var strNorm				= getstring("GRENZ_TEMP", "PROJECT.SETTINGS.CASCADE");
		var NormSplit			= strNorm.split("_");
		strNorm					= NormSplit[NormSplit.length - 1];
        var strTableName1		= this.GetProduktTabelle(this.m_Ptypid + "_PSS", 1);
		var strTableName2		= this.GetProduktTabelle(this.m_Ptypid + "_PSS", 2);
        var strSQLStatement1	= "select * from " + strTableName1;
		var strSQLStatement2	= "select * from " + strTableName2 + " where NORM='" + strNorm + "' ";
        var numRet1 = dbselect("CASCADE", strSQLStatement1, "SSB");
		var numRet2 = dbselect("CASCADE", strSQLStatement2, "SSB_NORM");
        if (numRet1 <= 0 || numRet2 <= 0)
            return 0;
		
        this.res_min	= dbgetdouble("SSB_NORM", "WEG_RES");
		var bRet		= 0;
        while (dbiseof("SSB") == 0)
        {
            if ((dbgetdouble("SSB", "FN") >= a_Fsoll &&
				(dbgetdouble("SSB", "FN_HZ") >= a_Fsoll_HZ) &&
				(dbgetdouble("SSB", "FN_HS") >= a_Fsoll_HS) &&
				((dbgetdouble("SSB", "FN") * 2.5) >= dTestload)) &&
				((S_ein + S_aus + 2 * this.res_min) <= dbgetdouble("SSB", "HUB")))
			{
                this.m_Pgewicht		= dbgetdouble("SSB", "GEW");
                this.m_dNennlast	= dbgetdouble("SSB", "FN");
                this.nennweg		= dbgetdouble("SSB", "HUB");
				this.m_Ptyp			= dbgetstring("SSB", "TYP_PSS");
				this.res_unten		= floor((this.nennweg - S_ein - S_aus)/2);
				this.res_oben		= this.res_unten;
				this.m_Pemass		= fround(dbgetdouble("SSB", "L1_MIN") + this.res_unten + S_ein, 0);	// E-Mass bei symmetr. Reserve
                this.e_mass     	= this.m_Pemass;
                this.m_strLGG		= sprintf("%.4d", this.m_dNennlast);
				this.strSollwege	= S_ein + "/" + S_aus;
				this.Blockpos		= fround(dbgetdouble("SSB", "Z") + this.res_unten + S_ein, 0);		// ColdPosition
				
				bRet = 1;
				break;
            }
            dbskip("SSB");
        }
        var stkMasse = [];
        var tmpPath = "TMP.FH_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);
        stkMasse		= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E_IST"];
		stkMasseNamen	= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E"];
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        this.makeTyp();
        return bRet;
    },
    
	InitSSG : function(/*double*/ a_Fsoll, a_Fsoll_HZ, a_Fsoll_HS, /*double*/ dTestload, a_ZusLast)
    {
        var Form_PSS	= "0";
		
		this.groesse    = "";
        this.nennweg    = 0;
        this.sollweg    = 0;
        this.warmlast   = a_Fsoll;
        this.kaltlast   = a_Fsoll;
        this.lastabw    = 0;
        this.res_oben   = 0;
        this.res_unten  = 0;
        this.res_min    = 0;
        this.federrate  = 0;
        this.lgv        = "";
		
        this.e_mass     = 0;
        this.aktgew     = 0;
        this.vorspann   = 0;
		
        this.SollastHpkt = a_Fsoll;
        this.Zusatzlast  = a_ZusLast;
		
        this.m_Ptypid   = "SSG";
        this.m_Poberfl  = this.getOberFlaechenSchutzDefault();
		
        m_Pblock = caMainController.presets.m_nFhBlock;
        if (!m_Pblock)
            m_Pblock = "BLOCK_JA";
		
		var isLISEGA_SSG	= (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" ? 1 : 0);
		var bRet			= 0;
		
        if (isLISEGA_SSG){
			var strTableName = this.GetProduktTabelle(this.m_Ptypid, 2);
			var strSQLStatement = "select * from " + strTableName    // order by ....
			var numRet = dbselect("CASCADE", strSQLStatement, "SSG")
			if (numRet <= 0)
				return 0;

			//var bRet = 0;
			while (dbiseof("SSG") == 0)
			{
				if ((dbgetdouble("SSG", "FN") >= a_Fsoll) &&
					(dbgetdouble("SSG", "FN_HZ") >= a_Fsoll_HZ) &&
					(dbgetdouble("SSG", "FN_HS") >= a_Fsoll_HS) &&
					((dbgetdouble("SSG", "FN") * 2.5) >= dTestload))
				{
					this.m_Pemass    = RoundDoubleToInt(dbgetdouble("SSG", "E"));
					this.m_Pgewicht  = dbgetdouble("SSG", "GEWICHT");
					this.m_dNennlast = dbgetdouble("SSG", "FN");

					this.spannweite = this.m_Pemass;
					this.e_mass     = this.m_Pemass;

					var nVerstellReserve = RoundDoubleToInt(dbgetdouble("SSG", "DELE"));
					//-Sch- 100317
					//this.res_oben  = nVerstellReserve / 2;
					//this.res_unten = nVerstellReserve / 2;
					//this.res_min   = nVerstellReserve / 2;
					this.res_oben  = nVerstellReserve;
					this.res_unten = -nVerstellReserve;
					this.res_min   = nVerstellReserve;

					this.m_strLGG = sprintf("%.3d", this.m_dNennlast);

					bRet = 1;
					break;
				}
				dbskip("SSG");
			}	
			var stkMasse	= [];
			var tmpPath		= "TMP.FH_ADDITIONAL_DATA";
			
			this.getAdditionalDataToStore(tmpPath);
			
			stkMasse      = ["fn","d_","B","A","D","SWR","SWM","Emin","Emax","M","mL","mR","D1","b_","H","g","f","E","fn","delE","gewicht","L"];
			stkMasseNamen = ["fn","d", "B","A","D","SWR","SWM","Emin","Emax","M","mL","mR","D1","b", "H","g","f","E","fn","delE","gewicht","L"];
        }
		else{
			var strTableName = this.GetProduktTabelle(this.m_Ptypid + '_PSS', 1);
			var strSQLStatement = "select * from " + strTableName    // order by ....
			var numRet = dbselect("CASCADE", strSQLStatement, "SSG")
			if (numRet <= 0)
				return 0;
			while (dbiseof("SSG") == 0)
			{
				if ((dbgetdouble("SSG", "FN") >= a_Fsoll) &&
						(dbgetdouble("SSG", "FN_HZ") >= a_Fsoll_HZ) &&
						(dbgetdouble("SSG", "FN_HS") >= a_Fsoll_HS) &&
						((dbgetdouble("SSG", "FN") * 2.5) >= dTestload))
				{
					// bestimme Form
					var Form_PSS	= "1";
					if (dbgetdouble("SSG", "FN") > 600)
						var Form_PSS	= "2K";		// default kurze Variante der Form 2
					this.m_Pemass    = RoundDoubleToInt(dbgetdouble("SSG", "EMIN_F" + Form_PSS));
					this.m_Pgewicht  = dbgetdouble("SSG", "M_FIX_F" + Form_PSS + "_Lmin");
					this.m_dNennlast = dbgetdouble("SSG", "FN");
					this.spannweite = this.m_Pemass;
					// this.e_mass     = this.m_Pemass;
					// this.e_mass     = dbgetdouble("SSG", "Emax_F" + (Form_PSS == "1" ? Form_PSS : "2l")); // setzen der max Lnge der jew. Form
					this.e_mass     = "";
					var nVerstellReserve = RoundDoubleToInt(dbgetdouble("SSG", "V_F" + Form_PSS));
					this.res_oben  = nVerstellReserve;
					this.res_unten = -nVerstellReserve;
					this.res_min   = nVerstellReserve;
					this.m_strLGG = sprintf("%.4d", this.m_dNennlast);
					bRet = 1;
					break;
				}
			dbskip("SSG");
			}
			
			var stkMasse	= [];
			var tmpPath		= "TMP.FH_ADDITIONAL_DATA";
			
			this.getAdditionalDataToStore(tmpPath);
			
			stkMasse		= ["FN","FN_HZ","FN_HS","FN_BOCK","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L","SUBTYP","E_IST"];
			stkMasseNamen	= ["FN","FN_HZ","FN_HS","FN_BOCK","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L","SUBTYP","E"];
		}
		
		this.m_Psubtyp	= left(Form_PSS, 1);
		
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
		//this.m_strMasse	+= "SUBTYP " + this.m_Psubtyp;
		//this.m_strMasse	+= "E " + this.m_Pemass;
		
        this.makeTyp();
        return bRet;
    },

    SSGSetLaenge : function(/*int*/ nNeueLaengeStuetze)
    {
        var Form_PSS	= "0";
		
		if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE"){
			var strTableName = this.GetProduktTabelle(this.m_Ptypid, 2);
			var strSQLStatement = "select * from " + strTableName;    // order by ....
			var numRet = dbselect("CASCADE", strSQLStatement, "SSG");
			if (numRet <= 0)
				return 0;

			var bRet = 0;
			while (dbiseof("SSG") == 0)
			{
				var nEmin = RoundDoubleToInt(dbgetdouble("SSG", "E")) - RoundDoubleToInt(dbgetdouble("SSG", "DELE"));
				var nEmax = RoundDoubleToInt(dbgetdouble("SSG", "E")) + RoundDoubleToInt(dbgetdouble("SSG", "DELE"));

				// -mw- 11.9.99: Hier nur == zulassen, weil LGG auch fr
				// Schelle / Bock gelten mu! -> Vergleich besser als INT?
				if ((RoundDoubleToInt(dbgetdouble("SSG", "FN")) == this.m_dNennlast) &&
					(nEmin <= nNeueLaengeStuetze) &&
					(nEmax >= nNeueLaengeStuetze))
				{
					this.m_Pemass    = nNeueLaengeStuetze;
					this.m_Pgewicht  = dbgetdouble("SSG", "GEWICHT");
					this.m_dNennlast = dbgetdouble("SSG", "FN");

					this.spannweite = this.m_Pemass;
					this.e_mass     = RoundDoubleToInt(dbgetdouble("SSG", "E"));	// f. Typbezeichnung

					this.res_oben   = nEmax - nNeueLaengeStuetze;
					this.res_unten  = (nNeueLaengeStuetze - nEmin)*(-1);
					this.res_min    = min(this.res_oben, (this.res_unten)*(-1));

					// -mw- neu, um Mindestverstellreserve zu bercksichtigen:
					if (this.res_min < caMainController.presets.m_nSSGMindestverstellreserve)
						continue;

					bRet = 1;
					break;
				}
				dbskip("SSG");
			}
			var stkMasse	= [];
			var tmpPath		= "TMP.FH_ADDITIONAL_DATA";
			
			this.getAdditionalDataToStore(tmpPath);
			
			stkMasse      = ["fn","d_","B","A","D","SWR","SWM","Emin","Emax","M","mL","mR","D1","b_","H","g","f","E","fn","delE","gewicht","L"];
			stkMasseNamen = ["fn","d", "B","A","D","SWR","SWM","Emin","Emax","M","mL","mR","D1","b", "H","g","f","E","fn","delE","gewicht","L"];
		}
		else{
			var strTableName = this.GetProduktTabelle(this.m_Ptypid + "_PSS", 1);
			var strSQLStatement = "select * from " + strTableName + " order by abs(FN) ASC";    // order by ....
			var numRet = dbselect("CASCADE", strSQLStatement, "SSG");
			if (numRet <= 0)
				return 0;
				
			var bRet = 0;
			while (dbiseof("SSG") == 0)
			{
				// bestimme die Form anhand E-Ma
				var nEmin_F1	= RoundDoubleToInt(dbgetdouble("SSG", "EMIN_F1")); // - RoundDoubleToInt(dbgetdouble("SSG", "V_F1"));
				var nEmax_F1	= RoundDoubleToInt(dbgetdouble("SSG", "EMAX_F1"));
				var nEmin_F2k	= RoundDoubleToInt(dbgetdouble("SSG", "EMIN_F2K"));
				var nEmax_F2k	= RoundDoubleToInt(dbgetdouble("SSG", "EMAX_F2K"));
				var nEmin_F2l	= RoundDoubleToInt(dbgetdouble("SSG", "EMIN_F2L"));
				var nEmax_F2l	= RoundDoubleToInt(dbgetdouble("SSG", "EMAX_F2L")); // + RoundDoubleToInt(dbgetdouble("SSG", "V_F2L"));
				
				if (nNeueLaengeStuetze >= nEmin_F1 && nNeueLaengeStuetze <= nEmax_F1)
					Form_PSS	= "1";
				else if (nNeueLaengeStuetze >= nEmin_F2k && nNeueLaengeStuetze <= nEmax_F2k)
					Form_PSS	= "2K";
				else if (nNeueLaengeStuetze >= nEmin_F2l && nNeueLaengeStuetze <= nEmax_F2l)
					Form_PSS	= "2L";
				
				if (RoundDoubleToInt(dbgetdouble("SSG", "FN")) == this.m_dNennlast && Form_PSS != 0){
					this.m_Pemass		= nNeueLaengeStuetze;
					var delE			= abs(dbgetdouble("SSG", "EMIN_F" + Form_PSS) - nNeueLaengeStuetze);
					this.m_Pgewicht		= fround(dbgetdouble("SSG", "M_FIX_F" + Form_PSS + "_Lmin") + (delE/10)*dbgetdouble("SSG", "M_ADD_F" + Form_PSS + "_E10"), 1);
					//this.m_dNennlast	= dbgetdouble("SSG", "FN");

					this.spannweite = this.m_Pemass;
					// this.e_mass     = this.m_Pemass;	// f. Typbezeichnung
					// this.e_mass     = dbgetdouble("SSG", "Emax_F" + (Form_PSS == "1" ? Form_PSS : "2l"));
					this.e_mass     = "";
					
					this.m_Psubtyp	= left(Form_PSS, 1);

					this.res_oben   = dbgetdouble("SSG", "V_F" + Form_PSS);
					this.res_unten  = this.res_oben * (-1);
					this.res_min    = min(this.res_oben, (this.res_unten)*(-1));

					// -mw- neu, um Mindestverstellreserve zu bercksichtigen:
					if (this.res_min < caMainController.presets.m_nSSGMindestverstellreserve)
						continue;

					bRet = 1;
					break;
				}
				dbskip("SSG");
			}
			
			var stkMasse	= [];
			var tmpPath		= "TMP.FH_ADDITIONAL_DATA";
			
			this.getAdditionalDataToStore(tmpPath);
			
			stkMasse		= ["FN","FN_HZ","FN_HS","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L","SUBTYP","E_IST"];
			stkMasseNamen	= ["FN","FN_HZ","FN_HS","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L","SUBTYP","E"];
			
			if(dbiseof("SSG"))
				return bRet;	// Strebe zu lang oder zu kurz
			
			this.m_Psubtyp	= left(Form_PSS, 1);
			
			this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt
			
			//this.m_strMasse	+= "SUBTYP " + this.m_Psubtyp;
			//this.m_strMasse	+= "E " + this.m_Pemass;
		}

        this.makeTyp();
        return bRet;
    },
	
	SSBSetLaenge : function(/*int*/ nNeueLaengeStuetze)
    {
		var oRet	= {	bOK			: false,
						bVerlPruef	: false
						}
		// erster Versuch -> ColdPosition verschieben
		var ArbWegGes		= this.nennweg - this.res_unten - this.res_oben;
		var SollwegeSplit	= (this.strSollwege).split("/");
		var S_ein			= SollwegeSplit[0];
		var S_aus			= SollwegeSplit[1];
		// Grenzen von E-Mass unter Bercksichtigung der Wege
		//var E_max			= this.m_Pemass*1 + this.res_oben*1 - this.res_min*1 - S_aus*1;
		var E_max			= this.m_Pemass*1 + (this.res_oben*1 - this.res_min*1);
		//var E_min			= this.m_Pemass*1 - this.res_unten*1 + this.res_min*1 + S_ein*1;
		var E_min			= this.m_Pemass*1 - (this.res_unten*1 - this.res_min*1);
		
		if (nNeueLaengeStuetze < E_min){	// das geht nicht
			return oRet.bOK;
		}
		else if ((nNeueLaengeStuetze <= E_max) &&
			(nNeueLaengeStuetze >= E_min))	// jetzt kann die ColdPosition verschoben werden
		{
			this.Blockpos	+= (nNeueLaengeStuetze - this.m_Pemass);
			this.res_unten	+= (nNeueLaengeStuetze - this.m_Pemass);
			this.res_oben	-= (nNeueLaengeStuetze - this.m_Pemass);
			this.m_Pemass	= nNeueLaengeStuetze;
			this.makeTyp();
			oRet.bOK		= true;
		}
		else{	// Prfen ob eine Verlngerung einsetzbar ist
			oRet.bVerlPruef	= true;
			/*
			var sollLaengeVerlaengerung	= nNeueLaengeStuetze - this.m_Pemass;
			var myVerlaengerung			= new Zubehoer();    
            var SBV_Info				= myVerlaengerung.InitSBV(this.m_dNennlast, sollLaengeVerlaengerung, "SBV");
			if (SBV_Info.bOK){
				this.e_mass				= this.m_Pemass - SBV_Info.SSB_L4;
				this.m_Pemass			= this.e_mass;
				this.makeTyp();
				//return oRet.bOK;	// just for test
				oRet.bOK				= true;
				oRet.oVerl				= myVerlaengerung;
			}
			*/
		}
		
		if (oRet.bOK){
			var stkMasse = [];
			var tmpPath = "TMP.FH_ADDITIONAL_DATA";
			this.getAdditionalDataToStore(tmpPath);
			stkMasse		= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E_IST", "notSSBVerl"];
			stkMasseNamen	= ["FN", "FN_BOCK", "HUB", "L4", "Z", "E", "AUGE"];
			this.setMassString(stkMasse, tmpPath, stkMasseNamen);
		}
		
		return oRet;
	},

    getZulaessigeAnpassungEmass : function()
    {
        return {dEoben: 30, dEunten: 0};
    },

	getEmass : function()
	{
		// Wird fr Konstant- und Federhnger berlagert
        return this.m_Pemass + this.AnpassungEmass;
	},

    getAdditionalDataToStore : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert

        delete(storepath,"");

        // Sonderfall SSG: hier ist alles anders ...
        if (this.m_Ptypid == "SSG")
            return this.getAdditionalDataToStoreSSG(storepath);
		// Sonderfall SSB: hier ist alles anders ...
		else if (this.m_Ptypid == "SSB")
            return this.getAdditionalDataToStoreSSB(storepath);

        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;

        db1 = this.GetProduktTabelle(this.m_Ptypid, 1);    //
        db2 = this.GetProduktTabelle(this.m_Ptypid, 2);    //

        strSQLStatement1 = "select * from "+db1+" order by abs(lastgr) ASC, abs(nennw) ASC "
        numRet1 = dbselect("CASCADE", strSQLStatement1, db1)

        if (db2 != "")
        {
            strSQLStatement2 = "select * from "+db2+" "
            numRet2 = dbselect("CASCADE", strSQLStatement2, db2)
        }
        if ((numRet1 <= 0) || ((db2 != "") && (numRet2 <= 0)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            logtrace("    >>> "+strSQLStatement2+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "lastgr"), this.groesse ) &&
                 compareInt(dbgetdouble(db1, "nennw"), this.nennweg ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }

        if (this.m_Ptypid == "FSG")
        {
            while (dbiseof(db2) == 0)
            {   // Prfe, ob Spannweite vorhanden
                if (compareInt(dbgetdouble(db2, "LASTGR"), this.groesse) &&
                    (dbgetdouble(db2, "EMIN") <= this.spannweite) &&
                    (dbgetdouble(db2, "EMAX") >= this.spannweite) )
                {
                    dbcopy(db2, storepath);
                    break;
                }
                dbskip(db2);
            }
        }
        if (this.m_Ptypid == "FDT")
        {
            while (dbiseof(db2) == 0)
            {   // Prfe, ob Spannweite vorhanden
                if (compareInt(dbgetdouble(db2, "LASTGR"), this.groesse) &&
                    compareInt(dbgetdouble(db2, "SPANN"), this.spannweite))
                {
                    dbcopy(db2, storepath);
                    break;
                }
                dbskip(db2);
            }
        }

        if (dbiseof(db1) || ((db2 != "") && dbiseof(db2)))
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
            if (db2 != "")
                logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
            return -1;
        }

        return 1;
    },

	getAdditionalDataToStoreSSB : function(storepath)
	{
		var db1					= "";
        var strSQLStatement1	= "";
        var numRet1				= 0;
		
        db1	= this.GetProduktTabelle(this.m_Ptypid + "_PSS", 1);    //
		
        strSQLStatement1	= "select * from "+db1+" ";
        numRet1				= dbselect("CASCADE", strSQLStatement1, db1);
		
        if (numRet1 <= 0)
        {
            logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
            logtrace("    >>> "+strSQLStatement1+"\n\r");
            return -1;
        }

        while (dbiseof(db1) == 0)
        {
            if ( compareInt(dbgetdouble(db1, "FN"), this.m_dNennlast ) &&
                 compareInt(dbgetdouble(db1, "HUB"), this.nennweg ) )
            {
                dbcopy(db1, storepath);
                break;
            }
            dbskip(db1);
        }
		
		setstring("E_IST", storepath, this.m_Pemass);
		setstring("notSSBVerl", storepath, this.notSSBVerl);
		
		return 1;
	},

    getAdditionalDataToStoreSSG : function(storepath)
    {
        // Hier werden alle Daten des Produkts, inkl. von Maen etc.
        // ausgelesen und in einen Storepfad gespeichert

        var db1 = "", db2 = "";
        var strSQLStatement1 = "", strSQLStatement2 = "";
        var numRet1 = 0, numRet2 = 0;
		
		var isLisegaPart	= (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" ? 1 : 0);
        if (isLisegaPart){
			db1 = this.GetProduktTabelle(this.m_Ptypid, 1);
			db2 = this.GetProduktTabelle(this.m_Ptypid, 2);
			
			strSQLStatement1 = "select * from "+db1+" order by abs(fn) ASC "
			numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
			
			strSQLStatement2 = "select * from "+db2+" order by abs(fn) ASC, abs(E) ASC ";
			numRet2 = dbselect("CASCADE", strSQLStatement2, db2)
			
			if ((numRet1 <= 0) || (numRet2 <= 0))
			{
				logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"!!!\n\r");
				logtrace("    >>> "+strSQLStatement1+"\n\r");
				logtrace("    >>> "+strSQLStatement2+"\n\r");
				return -1;
			}
			while (dbiseof(db1) == 0)
			{
				if ( compareInt(dbgetdouble(db1, "FN"), this.m_dNennlast ) )
				{
					dbcopy(db1, storepath);
					break;
				}
				dbskip(db1);
			}
			
			var nEmin = 0, nEmax = 0;
			
			while (dbiseof(db2) == 0)
			{
				// Prfe, ob Spannweite vorhanden
				nEmin = dbgetdouble(db2, "E") - dbgetdouble(db2, "DELE");
				nEmax = dbgetdouble(db2, "E") + dbgetdouble(db2, "DELE");
				if ((dbgetdouble(db2, "FN") >= this.m_dNennlast) &&
					(nEmin <= this.m_Pemass) &&
					(nEmax >= this.m_Pemass))
				{
					dbcopy(db2, storepath);
					break;
				}
				dbskip(db2);
			}
			
			if (dbiseof(db1) || dbiseof(db2))
			{
				logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
				logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
				logtrace("    >>> eof Select 2: "+dbiseof(db2)+"\n\r");
				return -1;
			}
			
			return 1;
		}
		else{
			db1				= this.GetProduktTabelle(this.m_Ptypid + "_PSS", 1);
			
			var Form_PSS	= "1";
			if (this.m_strLGG*1 > 600)
				Form_PSS	= "2K";
			
			var nEmin		= 0;
			var nEmax		= 0;
			
			for (var i = 0; i < 3; i++){
				strSQLStatement1 = "select * from "+db1+" order by abs(fn) ASC "
				numRet1 = dbselect("CASCADE", strSQLStatement1, db1)
				
				if (numRet1 <= 0)
				{
					logtrace("!!! FEHLER bei getAdditionalDataToStore: Select failed for "+this.m_Ptypid+"_PSS!!!\n\r");
					logtrace("    >>> "+strSQLStatement1+"\n\r");
					return -1;
				}
				
				while (dbiseof(db1) == 0)
				{
					// Prfe, ob Spannweite vorhanden
					nEmin = dbgetdouble(db1, "Emin_F" + Form_PSS); // - dbgetdouble(db1, "V_F" + Form_PSS);
					nEmax = dbgetdouble(db1, "Emax_F" + Form_PSS); // + dbgetdouble(db1, "V_F" + Form_PSS);
					var FN	= dbgetdouble(db1, "FN");
					if ((dbgetdouble(db1, "FN") == this.m_dNennlast) &&
						(nEmin <= this.m_Pemass) &&
						(nEmax >= this.m_Pemass))
					{
						dbcopy(db1, storepath);
						break;
					}
					dbskip(db1);
				}
				if (dbiseof(db1) && Form_PSS == "1")	// Versuch Form 2 kurz
					Form_PSS = "2K";
				else if (dbiseof(db1))	// Versuch Form 2 lang
					Form_PSS = "2L";
				else
					i = 3;
			}
			
			if (dbiseof(db1))
			{
				logtrace("!!! FEHLER bei getAdditionalDataToStore: Find data failed for "+this.m_Ptypid+"!!!\n\r");
				logtrace("    >>> eof Select 1: "+dbiseof(db1)+"\n\r");
				return -1;
			}
			
			// SUBTYP und E_IST ergaenzen
			// -Schu- Auswertung in S3D:
			// 1	-> Subtyp 1
			// 2k	-> Subtyp 2
			// 2l	-> Subtyp 3
			if (Form_PSS != "2L")
				setstring("SUBTYP", storepath, left(Form_PSS, 1));
			else
				setstring("SUBTYP", storepath, "3");
			setstring("E_IST", storepath, this.m_Pemass);
			
			return 1;
		}
    },

    Selected : function(/* string*/ nButton, /*int*/ nGegebeneSpannweite, /*BOOL*/ bErstmals)
    {
        var i, j, ret = 0;

        // derzeit keine weiteren Initialisierungen ntig, Typ schon in InitSSG belegt
        if (this.m_Ptypid == "SSG" || this.m_Ptypid == "SSB") return(0);

        // Membervariablen!
        this.m_Pgewicht = 0;
        this.aktgew     = 0;
        this.m_Ptypid   = nButton;
        this.m_Poberfl  = this.getOberFlaechenSchutzDefault();

        var strTableName2 = this.GetProduktTabelle(m_Ptypid, 2);

        // -mw- 25.5.99:  >>>>>>>>>>
        // Bei FSG gibt es jetzt mehrere Spannweiten-Intervalle, dazwischen kann
        // frei gewhlt werden. Die Spannweite soll auch nachtrglich (indirekt
        // ber Systemmasse noch angepasst werden knnen).
        // Darber hinaus hat der Anwender noch so etwas wie eine "Verstellreserve"
        this.spannweite = 0;
        if (this.m_Ptypid == "FSG")	// eigene Logik fr FSG:
        {
            // Bestimme Mindestspannweite, bzw. prfe, ob bergebene Spannweite korrekt ist;
            // falls nicht, weise wieder Mindestspannweite zu
            var strSQLStatement2 = "select * from "+strTableName2+" order by abs(LASTGR) ASC, abs(EMIN) ASC "
            var db2 = "FSG_SPA";
            var numRet2 = dbselect("CASCADE", strSQLStatement2, db2)
            if (numRet2 <= 0)
                return(-1);

            var bSuccess    = 0;
            var bFirstMatch = 1;

            while (dbiseof(db2) == 0)
            {   // Prfe, ob Spannweite vorhanden;
                // Wir mssen die gesamte Tabelle durchlaufen, weil wir mehrere
                // Stze pro Lastgre haben.
                // Auerdem mssen wir uns aus dem ersten Satz mit passender Lastgre
                // die "absolute" Mindestlnge holen (u.a. fr die Gewichtsberechnung)
                if (compareInt(dbgetdouble(db2, "LASTGR"), this.groesse) &&
                    bFirstMatch)
                {
                    this.nEminAbsolut    = dbgetdouble(db2, "EMIN");
                    this.nDeltaE	     = dbgetdouble(db2, "DELE");
                    this.nBmass	         = dbgetdouble(db2, "B");
                    this.m_nNennLaengeFSG = dbgetdouble(db2, "NENN");
                    this.m_FDT_FSG_LaengeVteil = this.nEminAbsolut - dbgetdouble(db2, "LX"); // Lnge Verlngerungsrohr bei FSG = E - LX

                    if (bErstmals)
                        break;
                    else
                        bFirstMatch  = 0;
                }
                if (compareInt(dbgetdouble(db2, "LASTGR"), atoi(this.groesse)) &&
                    (dbgetdouble(db2, "EMIN") <= nGegebeneSpannweite) &&
                    (dbgetdouble(db2, "EMAX") >= nGegebeneSpannweite) )
                {
                    bSuccess	 = 1;
                    this.spannweite      = nGegebeneSpannweite;
                    this.nDeltaE	     = dbgetdouble(db2, "DELE");
                    this.nBmass	         = dbgetdouble(db2, "B");
                    this.m_nNennLaengeFSG = dbgetdouble(db2, "NENN");
                    this.m_FDT_FSG_LaengeVteil = this.spannweite - dbgetdouble(db2, "LX"); // Lnge Verlngerungsrohr bei FSG = E - LX
                    break;
                }
                dbskip(db2);
            }
            if (!bSuccess)
                this.spannweite = this.nEminAbsolut;
                // FSG selected Verbesserungsidee V3.4: andere Vars auch zuweisen
                // Auerdem besser auf Max mglich gehen!

            if (atoi(this.groesse) < 5)
                this.m_strLGG = "008";
            else if (atoi(this.groesse) < 9)
                this.m_strLGG = "046";
            else
                this.m_strLGG = "100";

        }

        if (this.m_Ptypid == "FDT")	// Dialog bei Hngerwahl kommt jetzt nur noch bei FDT
        {
            /**** FDT Selektion: hier soll/muss bei Auswahl Hngertyp bereits die Spannweite erfragt werden
            // CA alt: Erfrage die Spannweite, falls erstmaliger Aufruf oder wenn gegebene Spannweite nicht vorhanden ist
            // CA 2008: bErstmals wird nicht mehr gebraucht, Spannweite wird ber Dialogsteuerung abgefragt.
            // Wenn nach einer Neuberechnung des Hngers aufgrund von Zusatzlasten eine andere Gre rauskommt,
            // dann muss die Auswahl Spannweite halt wieder durchlaufen werden.
            ****/
            var strSQLStatement2 = "select * from "+strTableName2+"  "
            var numRet2 = dbselect("CASCADE", strSQLStatement2, "SPANNWEITE")
            if (numRet2 <= 0)
                return(-1);

            // Erst mal prfen, ob unsere Spannweite in einem zulssigen Intervall liegt
            var nSpannweiteFuerSuche = nGegebeneSpannweite;
            var nSpannweiteMin = 0;
            var nSpannweiteMax = 32000;
            var bExactMatch = 0;

            var nIstSpannweite;
            while (dbiseof("SPANNWEITE") == 0)
            {
                nIstSpannweite = dbgetdouble("SPANNWEITE", "spann");
                if ((nIstSpannweite <= nGegebeneSpannweite) && (nIstSpannweite > nSpannweiteMin))
                    nSpannweiteMin = nIstSpannweite;
                if ((nIstSpannweite >= nGegebeneSpannweite) && (nIstSpannweite < nSpannweiteMax))
                    nSpannweiteMax = nIstSpannweite;
                if (nIstSpannweite == nGegebeneSpannweite)
                {
                    bExactMatch = 1;
                    break;
                }
                dbskip("SPANNWEITE");
            }
            if (! bExactMatch)
            {
                // Spannweite ausserhalb zulssiger Bereich: Fehler
                if (nSpannweiteMax == 32000)
                    return -2;
                // 10.11.2009: Auch Minimum soll geprft werden
                if (nSpannweiteMin == 0)
                    return -2;
                nSpannweiteFuerSuche = nSpannweiteMax;	// wir suchen den kleinsten, der grer ist
                this.m_bSonderSpannweite  = 1;
                this.m_dSonderSpannweite  = nGegebeneSpannweite;
            }
            else
            {
                this.m_bSonderSpannweite  = 0;
                this.m_dSonderSpannweite  = 0;
            }

            dbgotop("SPANNWEITE");
            while (dbiseof("SPANNWEITE") == 0)
            {
                if (compareInt(dbgetdouble("SPANNWEITE", "LASTGR"), this.groesse) &&
                    compareInt(dbgetdouble("SPANNWEITE", "SPANN"), nSpannweiteFuerSuche))
                {
                    this.m_Pgewicht = dbgetdouble("SPANNWEITE", "T_GEWICHT");
                    this.aktgew = this.m_Pgewicht;	// (= Aktives Gewicht der Hnger + Gew. d. Traverse)
                    this.m_FDT_Traegertyp   = dbgetstring("SPANNWEITE", "TRAEGER_TYP");

                    this.m_FDT_FSG_LaengeVteil = nGegebeneSpannweite - 2 * dbgetdouble("SPANNWEITE", "C_");
                    // this.m_FDT_FSG_LaengeVteil = dbgetdouble("SPANNWEITE", "LAENGE_VTEIL"); // Lnge Traverse bei FDT = L - 2*c_ ... Feld LAENGE_VTEIL

                    this.m_FDT_TGewicht = dbgetdouble("SPANNWEITE", "T_GEWICHT");

                    break;
                }
                dbskip("SPANNWEITE");
            }
            this.spannweite  = nSpannweiteFuerSuche;
        }

        ret = this.BestimmeMassUndGewicht();

        var stkMasse = [], stkMasseNamen = [];
        var tmpPath = "TMP.FH_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

		this.setMass(tmpPath, "sonderspannweite", this.m_dSonderSpannweite);

        if (this.m_Ptypid == "FDT")
        {
            stkMasse      = ["d_", "sonderspannweite", "E", "B", "D", "H", "e_", "C", "U", "spann", "lastgr", "nennw" ];
            stkMasseNamen = ["d", "sonderspannweite", "E", "B", "D", "H", "e", "C", "U", "spann", "lastgr", "nennw" ];
        }
        else if (this.m_Ptypid == "FHD")
        {
            stkMasse      = ["lastgr", "nennw", "E", "gewicht", "A", "H", "B", "D", "a_", "b_", "c", "d_", "r", "DM", "v", "M", "K" ];
            stkMasseNamen = ["lastgr", "nennw", "E", "gewicht", "A", "H", "B", "D", "a", "b", "c", "d", "r", "DM", "v", "M", "K" ];
        }
		else if (this.m_Ptypid == "FHG")
        {
            stkMasse      = ["lastgr", "nennw", "E", "gewicht", "A", "H", "B", "D", "d_", "E_MASS", "v", "D1" ];
            stkMasseNamen = ["lastgr", "nennw", "E", "gewicht", "A", "H", "B", "D", "d", "e-mass", "v", "D1" ];
        }
		else if (this.m_Ptypid == "FHS")
        {
            stkMasse      = ["lastgr", "nennw", "E", "gewicht", "A", "B", "D", "m_", "d_", "t", "k", "v", "D1", "s" ];
            stkMasseNamen = ["lastgr", "nennw", "E", "gewicht", "A", "B", "D", "m", "d", "t", "k", "v", "D1", "s" ];
        }
		else if ( (this.m_Ptypid == "FSS") || (this.m_Ptypid == "FSP") )
        {
            stkMasse      = ["lastgr", "nennw", "E", "gewicht", "A", "D", "m", "t", "k", "v", "s", "p", "w", "Mg", "D1", "SW", "d2" ];
            stkMasseNamen = ["lastgr", "nennw", "E", "gewicht", "A", "D", "m", "t", "k", "v", "s", "p", "w", "Mg", "D1", "SW", "d2" ];
        }
		else if  (this.m_Ptypid == "FSG")
        {
            stkMasse      = ["lastgr", "nennw", "lgg", "L", "D", "A", "M", "t", "SW", "h", "f", "r", "g", "dR", "s", "ds", "Dp", "sP", "k", "d2", "lastgr", "Emin", "Emax", "delE", "B", "NENN" ];
            stkMasseNamen = ["lastgr", "nennw", "lgg", "L", "D", "A", "M", "t", "SW", "h", "f", "r", "g", "dR", "s", "ds", "Dp", "sP", "k", "d2", "lastgr", "Emin", "Emax", "delE", "B", "NENN" ];
        }
		else if  (this.m_Ptypid == "SSG")
        {
            if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE"){
				stkMasse      = ["fn", "d_", "B", "A", "D", "SWR", "SWM", "Emin", "Emax", "M", "mL", "mR", "D1", "b_", "H", "g", "f", "E", "delE", "gewicht", "L" ];
				stkMasseNamen = ["fn", "d", "B", "A", "D", "SWR", "SWM", "Emin", "Emax", "M", "mL", "mR", "D1", "b", "H", "g", "f", "E", "delE", "gewicht", "L" ];
			}
			else{
				stkMasse		= ["FN","FN_HZ","FN_HS","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L"];
				stkMasseNamen	= ["FN","FN_HZ","FN_HS","D_F1","D_F2","E_MIN_F1","EMAX_F1","EMIN_F2K","EMAX_F2K","EMIN_F2L","EMAX_F2L","V_F1","V_F2K","V_F2L"];
			}
		}
		else if  (this.m_Ptypid == "SSB")
        {
            stkMasse		= ["FN", "FN_BOCK", "HUB", "L4", "Z"];
            stkMasseNamen	= ["FN", "FN_BOCK", "HUB", "L4", "Z"];
        }
		
        this.setMassString(stkMasse, tmpPath, stkMasseNamen);    // this.m_strMasse wird belegt

        return (ret);
    },

    BestimmeMassUndGewicht : function()
    {
        var i, ret = 0;

        var strTableName  = this.GetProduktTabelle(m_Ptypid, 1);

        var strSQLStatement = "select * from " + strTableName    // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "FH_ZUSATZDATEN")
        if (numRet <= 0)
        {
            return -1;
        }
        var lastgr = 0.0;
        var fnIst  = 0.0;
        while (dbiseof("FH_ZUSATZDATEN") == 0)
        {
            lastgr = dbgetdouble("FH_ZUSATZDATEN", "lastgr");
            nennw = dbgetdouble("FH_ZUSATZDATEN", "nennw");
			// --gl-- Hier aufpassen mit NaN !!!
            if ( ( lastgr == parseInt(this.groesse) ) &&
                 ( nennw  == parseInt(this.nennweg) ) )
                break;

            dbskip("FH_ZUSATZDATEN");
        }
        if (dbiseof("FH_ZUSATZDATEN") > 0)
            return -1;

        this.makeTyp();

        if (this.m_Ptypid == "FDT")
        {
            this.aktgew += dbgetdouble("FH_ZUSATZDATEN", "aktgew");
            this.m_FDT_GehGew = dbgetdouble("FH_ZUSATZDATEN", "GEHGEW");
        }

        if (this.m_Ptypid == "FSG")
        {
            this.estern = this.spannweite;	// nEminAbsolut; // spannweite;	-mw- 03/2007 Cascade 3.4 ;
            this.m_Pgewicht = dbgetdouble("FH_ZUSATZDATEN", "MINGEWICHT") +
                         ((this.estern - this.nEminAbsolut) *
                          dbgetdouble("FH_ZUSATZDATEN", "DELGEWICHT") *
                          0.001);
            this.m_Pgewicht = fround(this.m_Pgewicht, 0);
            // Variable hier missbraucht, wird fr den Arbeitsplan in SAP gebraucht
            this.m_FDT_TGewicht = fround(dbgetdouble("FH_ZUSATZDATEN", "GEW_PLATT") + (this.m_FDT_FSG_LaengeVteil * dbgetdouble("FH_ZUSATZDATEN", "DELGEWICHT") * 0.001), 2);
        }
        else
        {
            this.estern = dbgetdouble("FH_ZUSATZDATEN", "E");
            this.m_Pgewicht += dbgetdouble("FH_ZUSATZDATEN", "gewicht");
        }

        if (m_Ptypid == "FSG" || m_Ptypid == "FSS" || m_Ptypid == "FSP" || m_Ptypid == "FHS")
        {
            // -mw- Cascade 3.4:
            // Die Einbauhhe E ist unabhngig von der Blockierlast (Vorspannung), d.h. die Sttzen werden immer mit dem E-Ma aus den Grunddaten verbaut.
            // (Werksseitig werden die Sttzen entsprechend der Vorspannung auf das feste E-Ma eingestellt.)
            // An die 2D-Makros FSS, FSP und FSG wird anstelle "ema" die Variable "vorsp" bergeben.
            // Wert der Vorspannung: vorsp = (Fk - Fmin) / R
            if (this.m_Ptypid == "FSG" || this.m_Ptypid == "FSS" || this.m_Ptypid == "FSP")
                this.m_Pemass = this.estern;
            else
                this.m_Pemass = this.estern - this.vorspann;
            if (this.m_Ptypid == "FSG")
            {
                // fr die Fertigung:
                var strTmp = sprintf("L*=%d",this.estern);
                this.m_Pzeichnr = strTmp;
            }
        }
        else
        {
            this.m_Pemass = this.estern + this.vorspann;
        }

        if (this.m_Ptypid == "FHG")    // brauchen wir u.U. gar nicht mehr
        {
            this.e_mass = dbgetdouble("FH_ZUSATZDATEN", "E_MASS");
        }

        this.D = dbgetdouble("FH_ZUSATZDATEN", "D");

        return ret;
    },

	makeTyp : function()
	{
        var block, gewin;
        var strTyp  =  this.m_Ptypid;
        var buf = "";

        if ((this.m_Pblock == "BLOCK_JA") || (this.m_Pblock == "BLOCK_MITTIG"))
            block = 1;
        else					         
            block = 0;
        if (this.m_Pgewinde == "GEWINDE_DIN") 
            gewin = 1;
        else						          
            gewin = 0;

        if (this.m_Ptypid == "FSG")																	// hier "Nennlnge" (fiktiv) anstatt spannweite!, LGG statt LGV (3stellig)
            buf = sprintf("%s %s.%.3d.%.4d.%s-%d.%d.%d", strTyp, this.groesse, this.nennweg, this.m_nNennLaengeFSG, this.m_strLGG, block, gewin, Oberflaechenschutz[this.m_Poberfl]);
        else if (this.m_Ptypid == "FDT")
        {
            var nSpannweiteFuerTyp = this.spannweite;
            if (this.m_bSonderSpannweite)
            {
                nSpannweiteFuerTyp = this.m_dSonderSpannweite;
                strTyp += "-S";
            }
            buf = sprintf("%s %s.%.3d.%.4d.%s-%d.%d.%d", strTyp, this.groesse, this.nennweg, nSpannweiteFuerTyp, this.lgv, block, gewin, Oberflaechenschutz[this.m_Poberfl]);
        }
        else if (this.m_Ptypid == "FSS" || this.m_Ptypid == "FSP")
            buf = sprintf("%s %s.%.3d.00-%d.%d.%d", strTyp, this.groesse, this.nennweg, block, gewin, Oberflaechenschutz[this.m_Poberfl]);
        else if (this.m_Ptypid == "SSG"){														// bei SSG ist Gewinde nicht whlbar
			if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE")
				buf = sprintf("%s %.3d.%.4d-%d", strTyp, this.m_dNennlast, this.e_mass, Oberflaechenschutz[this.m_Poberfl]);
			else
				//buf = sprintf("%s %.4d.%.4d-%d", strTyp, this.m_dNennlast, this.e_mass, Oberflaechenschutz[this.m_Poberfl]);
				buf = sprintf("%s %.4d.%.4d-%d", strTyp, this.m_dNennlast, this.m_Pemass, Oberflaechenschutz[this.m_Poberfl]);
		}
		else if (this.m_Ptypid == "SSB")
			buf	= sprintf("%s %.4d.%.2d.%.4d.%s", strTyp, this.m_dNennlast, atoi(this.nennweg / 25.4), this.m_Pemass, right(this.m_Ptyp, 1));
		else
            buf = sprintf("%s %s.%.3d.%s-%d.%d.%d", strTyp, this.groesse, this.nennweg, this.lgv, block, gewin, Oberflaechenschutz[this.m_Poberfl]);

        this.m_Ptyp = buf;

        this.getPreis();
        return this.m_Ptyp;
	},

	fromTyp : function(strTyp)
	{
		var strTypNr = [];
        var bOK = true;
		//var bDBCheckLGG = false;

        this.m_Ptyp = strTyp;
        this.m_Ptypid = left(strTyp, 3);

		this.m_bSonderSpannweite = false;
		if(substr(strTyp, 4, 5) == "-S")
		{
			this.m_bSonderSpannweite = true;
			//strTyp = left(strTyp, 3) + substr(strTyp, 6, 99);
			return "Keine Sonderteile moeglich !";
		}

        switch(this.m_Ptypid)
        {
			case "FSG":
				strTypNr = splitVarDelimiter(strTyp, " ...-..");
				if(strTypNr.length < 8 || this.m_bSonderSpannweite || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 7)]) == "undefined")
				{
					bOK = false;
					break;
				}
				//bDBCheckLGG = true;
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				this.m_nNennLaengeFSG = atoi(getVarDelimited(strTypNr, 3));
				// spannweite ist notwendig
				this.spannweite = this.m_nNennLaengeFSG;
				this.m_strLGG = getVarDelimited(strTypNr, 4);
				//this.m_Pblock = (getVarDelimited(strTypNr, 5) == "1" ? "BLOCK_MITTIG" : "BLOCK_NEIN");
				this.m_Pblock = (getVarDelimited(strTypNr, 5) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pgewinde = (getVarDelimited(strTypNr, 6) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 7)];
                break;
            case "FDT":
				strTypNr = splitVarDelimiter(strTyp, " ...-..");
				if(strTypNr.length < 8 || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 7)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				this.spannweite = atof(getVarDelimited(strTypNr, 3));
				this.m_dSonderSpannweite = this.spannweite;
				this.lgv = getVarDelimited(strTypNr, 4);
				//this.m_Pblock = (getVarDelimited(strTypNr, 5) == "1" ? "BLOCK_MITTIG" : "BLOCK_NEIN");
				this.m_Pblock = (getVarDelimited(strTypNr, 5) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pgewinde = (getVarDelimited(strTypNr, 6) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 7)];
                break;
            case "FSS":
            case "FSP":
				strTypNr = splitVarDelimiter(strTyp, " ..-..");
				if(strTypNr.length < 7 || this.m_bSonderSpannweite || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				//getVarDelimited(strTypNr, 3) = "00"
				//this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_MITTIG" : "BLOCK_NEIN");
				this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pgewinde = (getVarDelimited(strTypNr, 5) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
            case "SSG":
				strTypNr = splitVarDelimiter(strTyp, " .-");
				if(strTypNr.length < 4 || this.m_bSonderSpannweite || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)]) == "undefined")
				{
					bOK = false;
					break;
				}
				//bDBCheckLGG = true;
				this.m_dNennlast = atoi(getVarDelimited(strTypNr, 1));
				this.m_Pemass = atoi(getVarDelimited(strTypNr, 2));
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 3)];
				// aus InitSSG
                this.spannweite = this.m_Pemass;
				this.m_dSonderSpannweite = this.spannweite;
                this.e_mass = this.m_Pemass;
				//if (this.m_Ptypid == "SSG"){
				if (getstring("SALESVERSION", "RIGHTS") != "true"){
					switch (this.m_dNennlast){
						case 8		:
						case 18		:
						case 46		:
						case 100	:
						case 200	:
						case 350	:
							setstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE", "TRUE")
							this.m_strLGG = sprintf("%.3d", this.m_dNennlast);
							break;
						default		:
							setstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE", "FALSE")
							this.m_strLGG = sprintf("%.4d", this.m_dNennlast);
							break;
					}
				}
				else{
					this.m_strLGG = sprintf("%.4d", this.m_dNennlast);
				}
                break;
			case "SSB":
				strTypNr = splitVarDelimiter(strTyp, " ...");
				if(strTypNr.length < 5)
				{
					bOK = false;
					break;
				}
				this.m_dNennlast			= atoi(getVarDelimited(strTypNr, 1));
				this.m_strLGG				= sprintf("%.4d", this.m_dNennlast);
				this.nennweg				= atoi(getVarDelimited(strTypNr, 2)) * 25.4;	// Zoll zu Millimeter
				this.m_Pemass				= atoi(getVarDelimited(strTypNr, 3));
				this.m_Poberfl				= OberflaechenschutzRevers["Ob1"];
				 this.spannweite			= this.m_Pemass;
				this.m_dSonderSpannweite	= this.spannweite;
                this.e_mass					= this.m_Pemass;
				break;
            default:
				strTypNr = splitVarDelimiter(strTyp, " ..-..");
				if(strTypNr.length < 7 || this.m_bSonderSpannweite || typeof (OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)]) == "undefined")
				{
					bOK = false;
					break;
				}
				this.groesse = getVarDelimited(strTypNr, 1);
				this.nennweg = atoi(getVarDelimited(strTypNr, 2));
				this.lgv = getVarDelimited(strTypNr, 3);
				//this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_MITTIG" : "BLOCK_NEIN");
				this.m_Pblock = (getVarDelimited(strTypNr, 4) == "1" ? "BLOCK_JA" : "BLOCK_NEIN");
				this.m_Pgewinde = (getVarDelimited(strTypNr, 5) == "1" ? "GEWINDE_DIN" : "");		//"GEWINDE_ZOLL"
				this.m_Poberfl = OberflaechenschutzRevers["Ob"+getVarDelimited(strTypNr, 6)];
                break;
		}

        this.getPreis();

	// 20.08.08 mb weitere Daten setzen
        var tmpPath = "TMP.FH_ADDITIONAL_DATA";
		var bSuccess = this.getAdditionalDataToStore(tmpPath);
		if(bSuccess == -1)
			return "ERR";
		/*
		if(bDBCheckLGG)
		{
			if(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE" == "TRUE")){
				var db1 = this.GetProduktTabelle(this.m_Ptypid, 1);
				var strSQLStatement1 = "";
				if (this.m_Ptypid == "SSG")
					strSQLStatement1 = "select * from "+db1+" where abs(EMIN) <= "+int(this.spannweite)+
					" and abs(EMAX) >= "+int(this.spannweite)+
					" and abs(FN)="+int(this.m_strLGG)+" ";
				else
					strSQLStatement1 = "select * from "+db1+" where lastgr='"+int(this.groesse)+
					"' and nennw='"+int(this.nennweg)+
					"' and LGG='"+int(this.m_strLGG)+"'";
			}
			else{
				var db1 = this.GetProduktTabelle(this.m_Ptypid + "_PSS", 1);
				var strSQLStatement1 = "";
				if (this.m_Ptypid == "SSG")
					strSQLStatement1 = "select * from "+db1+" where abs(EMAX_F2L) >= "+int(this.spannweite)+
					" and abs(FN)="+int(this.m_strLGG)+" ";
				else
					strSQLStatement1 = "select * from "+db1+" where abs(FN)='"+int(this.groesse)+
					"' and nennw='"+int(this.nennweg)+
					"' and LGG='"+int(this.m_strLGG)+"'";
			}
			if (dbselect("CASCADE", strSQLStatement1, db1) <= 0)
				return "LGG";
		}
		*/
		if(this.lgv!="")	// lgv noch prfen
		{
			var strSQLStatement = "select * from HYDRAFED where LASTGROESSE = '"+this.groesse+"' and LGV = '"+this.lgv+"' ";
            if (dbselect("CASCADE", strSQLStatement, "HYDRAFED") <= 0)
				return "ERR";
		}

		// this.getAdditionalDataToStore(tmpPath) bereits in getPreis() aufgerufen !
		if(this.lgv=="") this.lgv = getstring("LGV", tmpPath);
		if(this.a_lgv=="") this.a_lgv = getstring("LGV", tmpPath);
		if(this.nennweite<=0) this.nennweite = getdouble("NENNW", tmpPath);
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEWICHT", tmpPath);	// bei SSB ist das "GEW"
		if(this.m_Pgewicht<=0) this.m_Pgewicht = getdouble("GEW", tmpPath);
		// -Schu- fr eFIN/STK-Import noch weitere setzen
		var FINObject	= Object.fromStorage("DLGDATA.CA.FINDATA.FINOBJECT");
		if(typeof(FINObject) == "object" && this.m_Ptypid != "SSG" && this.m_Ptypid != "SSB"){
			strSQLStatement = "select * from HYDRAFED where LASTGROESSE = '"+this.groesse+"' and NENNWEG = '"+this.nennweg+"' ";
			dbselect("CASCADE", strSQLStatement, "HYDRAFED");
			this.federrate	= dbgetdouble("HYDRAFED", "FEDERRATE");
			this.estern		= (this.m_Ptypid != "FSG" ? getdouble("E", tmpPath) : getdouble("EMIN", tmpPath));
			// Achtung -> "restrain" ist nur bei eFIN gefllt
			// das ist ein STK oder ein FIN welches mit Defaults eingelesen weren soll
			if (FINObject.restrain.dtemp * 1 + "" == "NaN" || FINObject.restrain.dtemp * 1 + "" == "undefined"){
				if (!FINObject.required.blockpos){
					// do nothing -> FIN with Defaults
					var FHOptions	= Object.fromStorage("TMP.CASELECTIONS.FHAENGER");
					if (typeof(FHOptions) == 'object' && FHOptions.VARIANTEN.length > 0){
						// var SucheWeiter	= true;
						for (var Variante = 0; Variante < FHOptions.VARIANTEN.length; Variante++){
							if (FHOptions.VARIANTEN[Variante].HAENGER.groesse*1 == strTypNr[1] &&
								FHOptions.VARIANTEN[Variante].HAENGER.nennweg*1 == strTypNr[2]){
									this.res_min		= FHOptions.VARIANTEN[Variante].HAENGER.res_min;
									this.res_oben		= FHOptions.VARIANTEN[Variante].HAENGER.res_oben;
									this.res_unten		= FHOptions.VARIANTEN[Variante].HAENGER.res_unten;
									this.SollastHpkt	= FHOptions.VARIANTEN[Variante].HAENGER.SollastHpkt;
									this.sollweg		= FHOptions.VARIANTEN[Variante].HAENGER.sollweg;
									this.spannweite		= FHOptions.VARIANTEN[Variante].HAENGER.spannweite;
									this.strSollwege	= FHOptions.VARIANTEN[Variante].HAENGER.strSollwege;
									this.Blockpos		= FHOptions.VARIANTEN[Variante].HAENGER.vorspann;
									this.warmlast		= FHOptions.VARIANTEN[Variante].HAENGER.warmlast;
									this.warmlast2		= FHOptions.VARIANTEN[Variante].HAENGER.warmlast2;
									this.Zusatzlast		= FHOptions.VARIANTEN[Variante].HAENGER.Zusatzlast;
									this.kaltlast		= FHOptions.VARIANTEN[Variante].HAENGER.kaltlast;
									Variante			= FHOptions.VARIANTEN.length;
							}
						}
					}
				}
				else{	// STK
					this.Blockpos	= FINObject.required.blockpos;
					this.kaltlast	= FINObject.required.cold;
					this.sollweg	= FINObject.required.mov_hanger;
				}
			}
			// das ist ein eFIN
			else{
				this.Blockpos	= getint("blockpos", "DLGDATA.CA.FINDATA.FINOBJECT.restrain");
				this.kaltlast	= getdouble("statload", "DLGDATA.CA.FINDATA.FINOBJECT.restrain");
				this.sollweg	= getdouble("maxtravel", "DLGDATA.CA.FINDATA.FINOBJECT.restrain");
			}
			this.vorspann	= this.Blockpos;
			if (left(this.m_Ptypid, 2) != "FS"){
				this.e_mass		= this.estern + ((this.m_Ptypid == "FHS" ? -1 : 1) * this.Blockpos);
			}
			else{
				this.e_mass		= this.estern;
			}
			this.m_Pemass	= this.e_mass;
		}
		else if (typeof(FINObject) == "object" && this.m_Ptypid == "SSB"){
			var halt;
		}
        return(bOK ? "" : "ERR");
	},

	getPreis : function(oOptions)
    {
        if (getstring("PCODE", "CATALOG.SETTINGS") != "630927")
            return 0;

        // wir mssen nochmal in die Grunddaten rein, weil sich bei manchen Produkten
        // durch nderung Werkstoff oder Oberflchenschutz der Preis ndern kann:
        var tmpPath = "TMP.FH_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(tmpPath);

        // ---------- Vorbergehend, um aeltere Projekte zu reparieren!
        if (this.m_Ptypid == "FDT")
        {
            var nSpannw = this.spannweite;
            if (this.m_bSonderSpannweite)
                nSpannw = this.m_dSonderSpannweite;
			
            this.m_FDT_Traegertyp   = getstring("TRAEGER_TYP", tmpPath);
            this.m_FDT_FSG_LaengeVteil = nSpannw - 2 * getdouble("C_", tmpPath);
			
            this.m_FDT_GehGew = getdouble("GEHGEW", tmpPath);
            this.m_FDT_TGewicht = getdouble("T_GEWICHT", tmpPath);
			
			this.aktgew			= getdouble("AKTGEW", tmpPath);
        }
        if (this.m_Ptypid == "FSG")
        {
            this.m_FDT_FSG_LaengeVteil = this.spannweite - getdouble("LX", tmpPath); // Lnge Verlngerungsrohr bei FSG = E - LX
        }
        // ----------

        this.m_Ppreis = 0.0;

        var nGewindeCode = 1;
        if (this.m_Pgewinde != "GEWINDE_DIN")
            nGewindeCode = 2;

        var block = 0;
        if ((this.m_Pblock == "BLOCK_JA") || (this.m_Pblock == "BLOCK_MITTIG"))
            block = 1;            

        var strFieldname = "P" + block + "_" + Oberflaechenschutz[this.m_Poberfl];
        if ((this.m_Ptypid == "FSS") || (this.m_Ptypid == "FSP"))
            strFieldname = "P_" + this.m_Ptypid + "_" + block + "_" + Oberflaechenschutz[this.m_Poberfl];
        if ((this.m_Ptypid == "SSG") && (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) != "TRUE")){
            // Zur Preisbestimmung E-Ma auf nchste volle "500" runden
			var E_Preis		= "";
			if (this.m_Pemass*1 <= 500)
				E_Preis		= "500";
			else if (this.m_Pemass*1 <= 1000)
				E_Preis		= "1000";
			else if (this.m_Pemass*1 <= 1500)
				E_Preis		= "1500";
			else if (this.m_Pemass*1 <= 2000)
				E_Preis		= "2000";
			else if (this.m_Pemass*1 <= 2500)
				E_Preis		= "2500";
			else if (this.m_Pemass*1 <= 3000)
				E_Preis		= "3000";
			else if (this.m_Pemass*1 <= 3500)
				E_Preis		= "3500";
			else if (this.m_Pemass*1 <= 4000)
				E_Preis		= "4000";
			else if (this.m_Pemass*1 <= 4500)
				E_Preis		= "4500";
			else if (this.m_Pemass*1 <= 5000)
				E_Preis		= "5000";
			strFieldname	= "P" + Oberflaechenschutz[this.m_Poberfl] + "_" + E_Preis;
		}
		else if ((this.m_Ptypid == "SSB") || (this.m_Ptypid == "SSG")){
			strFieldname	= "P" + Oberflaechenschutz[this.m_Poberfl];
		}
		
        var strZusatzPreis = "";
        if (this.m_Ptypid == "FDT")
        {
            strZusatzPreis = getstring("T" + strFieldname, tmpPath);
        }

        var strPreis = getstring(strFieldname, tmpPath);
        var strAufPreis = getstring("PTERRO", tmpPath);

        if (strPreis != "")
        {
            this.m_Ppreis = fround(strPreis, 2);
            if (strZusatzPreis != "")
                this.m_Ppreis += fround(strZusatzPreis, 2);
            // -mw- 04/2008: Terroson wird jetzt auf Positionsebene gehandelt:
            // if (oOptions && oOptions.TERROSON_FH && (strAufPreis != ""))
            if ((this.m_Pbeschicht == "TERROSON") && (strAufPreis != ""))
                this.m_Ppreis += fround(strAufPreis, 2);
        }

        if (this.m_bSonderSpannweite)
        {
            var dZuschlag = this.getPreiszuschlagSonder(this.getSAPKlassenName(), this.getSAPTyp(), "");
            this.m_Ppreis = fround(this.m_Ppreis * dZuschlag, 0);
        }

        //if (this.m_Ptypid == "SSG")
		if (left(this.m_Ptypid, 2) == "SS")
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_SSG");
        else if (atoi(this.groesse) <= 11)
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_FH1");
        else
            this.m_Ppreis = this.getNettoPreis(this.m_Ppreis, "RABATT_TYP_FH2");

        return this.m_Ppreis;
	},

    getTopoPic : function(Drehung, lkTyp, Lastabtragung)
    {
		// Weil der Hnger in zwei Schritten ausgewhlt wird ...
        var strPic	= "catalog/client/custom/img/prinzip/H.png";
        if (this.m_Ptypid != "")
        {
			var strTeilPic = this.m_Ptypid;
			if (lkTyp == "STOSSBREMSE"){
				if (left(Lastabtragung, 8) == "HAENGEND")
					strTeilPic	+= "U";
				else
					strTeilPic	+= "O";
			}
            if ((Drehung == 90) || (Drehung == 270))
                strTeilPic = strTeilPic + "_S";
			
            strPic = "catalog/client/custom/img/panels/T"+strTeilPic+".png";
        }
        return strPic;
    },

    isSAPKonfigurierbar : function()
    {
        if ((m_Ptypid == "FDT") || (m_Ptypid == "FSG")
			|| (m_Ptypid == "SSG" && toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "FALSE"))
			{
				return 1;
			}
		
        return 0;
    },

    getSAPKlassenName : function()
    {
        var strKlasse = this.m_Ptypid;  // Default
        if (m_Ptypid == "FHS")
            strKlasse = "FHZ";
        if ((m_Ptypid == "FSS") || (m_Ptypid == "FSP"))
            strKlasse = "FST";
        if (m_Ptypid == "FDT")
            strKlasse = "FHV";
        if (m_Ptypid == "FSG")
            strKlasse = "GFS";
		if (m_Ptypid == "SSB")
            strKlasse = "SBW";

        return strKlasse;
    },

    getSAPTyp : function()
    {
        return this.m_Ptypid;
    },

    getASTLDaten : function(theMainController)
    {

        var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "",
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};

        retObj.loeseauf = this.isSAPKonfigurierbar();
        // Sonderfall: diese drei Typen ("FDT" / "FSG" / "SSG" [PSS]) sind zwar in SAP konfigurierbar,
        // Flexperte soll aber keine Stckliste bringen:
        if ((m_Ptypid == "FDT") || (m_Ptypid == "FSG") || (m_Ptypid == "SSG"))
            retObj.loeseauf = 0;

        var strKlasse = this.getSAPKlassenName();
        var searchObj;
        var sapOberflaechenschutz = Oberflaechenschutz[this.m_Poberfl];

        var groesseFuerSuche = parseInt(this.groesse);  // die fhrende Null muss weg
        var strLGGFuerSuche = atoi(this.m_strLGG);

        if (m_Ptypid == "SSG")
        {
            searchObj = { LASTGRUPPE: strLGGFuerSuche,     // oder this.lgv ??
                          LAENGE: (this.e_mass != "" ? this.e_mass : 0),             // this.m_Pemass,
                          //LAENGE: this.e_mass,             // this.m_Pemass,
                          TYP: this.getSAPTyp(),
						  OBERFLAECHENSCHUTZ: Oberflaechenschutz[this.m_Poberfl]};
        }
        else if (m_Ptypid == "SSB")
		{
			searchObj = { WERKSTOFF:	'',
                          NORM:			'',
                          TYP:			left(this.m_Ptyp, 12) + "xxxx" + right(this.m_Ptyp, 2) };
		}
		else
        {
            // LASTGROESSE, BLOCKIERUNG, NENNWEG, LASTGRUPPE, OBERFLAECHENSCHUTZ, (WERKSTOFF), TYP
            searchObj = { LASTGROESSE:  groesseFuerSuche,
                          BLOCKIERUNG:  'B',             // hier nicht (!) die gewhlte Blockierung bergeben; Matnr gilt immer fr die blockierte Variante, unblockiert kommt dann als Fertigungshinweis
                          NENNWEG:      this.nennweg,
                          LASTGRUPPE:   this.lgv,
                          OBERFLAECHENSCHUTZ: sapOberflaechenschutz,
                          TYP:          this.getSAPTyp() };
        }

        var aMerkmale = this.getMerkmaleArray(strKlasse, searchObj);
        var matInfo   = this.getMatInfo(theMainController, strKlasse, aMerkmale, "", 1);
        retObj.matnr  = matInfo.matnr;
        retObj.aTexte = matInfo.aTexte; // nicht so toll ...
        if (this.isSAPKonfigurierbar() || this.isRohmassPosition())
            retObj.postext1 = this.m_Ptyp;

        return retObj;
	},

    getCADDaten : function(nStartPos, nPosNr, Drehung, nTyp)
    {
        var strGroesse = this.groesse;
        if (left(strGroesse, 1) == "0")
            strGroesse = right(strGroesse, 1);

        var nVorspannweg = RoundDoubleToInt(this.vorspann);
		var aParams = new Array();

        if (nTyp == "E")
            aParams.push( [ "Typ", "" + this.m_Ptypid ] );
        else aParams.push( [ "Position" + nStartPos, "" + this.m_Ptypid ] );
        aParams.push( [ "Drehung" + nStartPos, "" + Drehung ] );
        aParams.push( [ "PosNr" + nStartPos, "" + nPosNr ] );

        aParams.push( [ "Lastgroesse" + nStartPos, strGroesse ] );  // Achtung: mit / ohne fhrende Null
        aParams.push( [ "Weg" + nStartPos, "" + this.nennweg ] );
        // CAD-bergabe Federhnger: Vorspannweg richtig bergeben
        aParams.push( [ "Vorspannweg" + nStartPos, "" + nVorspannweg ] );

        if (this.m_Ptypid == "SSG")
        {
            var strLGGFuerCAD = atoi(this.m_strLGG);
            aParams.push( [ "Typ" + nStartPos, strLGGFuerCAD ] );
        }

        if ((this.m_Ptypid == "SSG") || (this.m_Ptypid == "FSG"))
            aParams.push( [ "E-Mass" + nStartPos, "" + this.m_Pemass ] );

		var dEoben = 0;
		var dEunten = 0;
		if (this.AnpassungEmass > 0)
			dEoben = this.AnpassungEmass;
		if (this.AnpassungEmass < 0)
			dEunten = abs(this.AnpassungEmass);
        aParams.push( [ "dEoben" + nStartPos, "" + dEoben ] );
        aParams.push( [ "dEunten" + nStartPos, "" + dEunten ] );

        return( [ aParams, nPosNr + 1 ] );
    }


});