/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */

//*****************************************************************************
// Werkstoffe
//*****************************************************************************
/**
 * Dir ist schon klar, dass die hier global rumhngen ?
 * Besser wre es sie spter innerhalb eines Cascade Namespaces zu kapseln
 * Cascade.Werkstoffe.Werknamen = {
 *
 * }
 * Damit vermeidet man spter Probleme
 *
 */
// Neue Bezeichnungen nach DIN EN
// Die Property entspricht der alten enum:
var Werknamen = {
	W_RST       : "S235JRG2",
	W_15MO3     : "16Mo3",
	W_13CRMO    : "13CrMo4-5",
	W_10CRMO    : "10CrMo9-10",
	W_4301		: "X5CrNi18-10",
	W_4541      : "X6CrNiTi18-10",
	W_4571      : "X6CrNiMoTi17-12-2",
	W_P91       : "X10CrMoVNb9-1",
	W_INCOLOY   : "X5CrAlTi31-20",
	W_4878		: "X8CrNiTi18-10",
    W_C228N     : "C22.8 N",
	W_SONST     : "sonst.",
    W_C45       : "C45",
    W_RST52     : "S355J2G3",
    W_MUTTER8   : "8",
	W_UNDEF     : ""
};

var WerknamenDB = {
	'S235JRG2' 			: "W_RST",
	'16Mo3' 			: "W_15MO3", 
	'13CrMo4-5' 		: "W_13CRMO",
	'10CrMo9-10' 		: "W_10CRMO",
	'X5CrNi18-10'		: "W_4301",
	'X6CrNiTi18-10' 	: "W_4541",
	'X6CrNiMoTi17-12-2' : "W_4571", 
	'X10CrMoVNb9-1' 	: "W_P91",
	'X5CrAlTi31-20' 	: "W_INCOLOY",
	'X8CrNiTi18-10'		: "W_4878",
	'S355J2G3'			: "W_RST52"
};

var Werkstoffe = {
	W_RST       : "37",
	W_15MO3     : "16",
	W_13CRMO    : "13",
	W_10CRMO    : "10",
	W_4301		: "43",
	W_4541      : "41",
	W_4571      : "71",
	W_P91       : "91",
	W_INCOLOY   : "80",
	W_4878		: "78",
    W_C228N     : "0",      // ???
	W_SONST     : "0",
    W_C45       : "45",
    W_RST52     : "52",
    W_MUTTER8   : "08",
	W_UNDEF     : ""
};

var WerkstoffeNrZuNamen = {
	'37' : "S235JRG2",
	'16' : "16Mo3",
	'13' : "13CrMo4-5",
	'10' : "10CrMo9-10",
	'43' : "X5CrNi18-10",
	'41' : "X6CrNiTi18-10",
	'71' : "X6CrNiMoTi17-12-2",
	'91' : "X10CrMoVNb9-1",
	'80' : "X5CrAlTi31-20",
	'78' : "X8CrNiTi18-10",
	'52' : "S355J2G3"
};



var WerkstoffeSAPid = {
	W_RST       : "1.0038",
	W_15MO3     : "1.5415",
	W_13CRMO    : "1.7335",
	W_10CRMO    : "1.7380",
	W_4301		: "1.4301",
	W_4541      : "1.4541",
	W_4571      : "1.4571",
	W_P91       : "1.4903",
	W_INCOLOY   : "1.4958",
	W_4878		: "1.4878",
    W_C228N     : "??????",
	W_SONST     : "0",
    W_C45       : "1.0503",
    W_RST52     : "1.0577",
    W_MUTTER8   : "8",
	W_UNDEF     : ""
};


var WerkstoffeZahlZuId = [
	"W_RST",
	"W_15MO3",
	"W_13CRMO",
	"W_10CRMO",
	"W_4541",
	"W_4571",
	"W_P91",
	"W_INCOLOY",
	"W_4878",
	"W_4301",
	"W_SONST",
    "W_C45",
    "W_RST52",
    "W_MUTTER8",
	"W_UNDEF"
];

var WerkstoffeIdZuZahl = {
	"W_RST"		: 0,
	"W_15MO3"	: 1,
	"W_13CRMO"	: 2,
	"W_10CRMO"	: 3,
	"W_4541"	: 4,
	"W_4571"	: 5,
	"W_P91"		: 6,
	"W_INCOLOY"	: 7,
	"W_4878"	: 8,
	"W_4301"	: 9
};

var Oberflaechenschutz = {
	OB_ROH    : "0",
	OB_GALV   : "1",
	OB_FEUER  : "2",
	OB_GRUND  : "3",
	OB_SONST  : "4",
	OB_LEER   : "99",    
};

var OberflaechenschutzZahlZuID = {
	'0'		: "OB_ROH",
	'1'		: "OB_GALV",
	'2'		: "OB_FEUER",
	'3'		: "OB_GRUND",
	'4'		: "OB_SONST",
	'99'	: "OB_LEER"
};

var OberflaechenschutzRevers = {
	Ob0	: "OB_ROH",
	Ob1	: "OB_GALV",
	Ob2	: "OB_FEUER",
	Ob3	: "OB_GRUND",
	Ob4	: "OB_SONST",
	Ob99 : "OB_LEER"
};

var OberflaechenschutzTransID = {
	OB_ROH    : "IDS_OBERFL_ROH",
	OB_GALV   : "IDS_OBERFL_GALVAN",
	OB_FEUER  : "IDS_OBERFL_FEUER",
	OB_GRUND  : "IDS_OBERFL_GRUND",
	OB_SONST  : "IDS_OBERFL_SONST",
	OB_LEER   : ""
};


var MoeglicherOberflaechenschutz = [
    [ "-" ],
    [ "OB_ROH",	"OB_FEUER", "OB_GRUND", "OB_SONST" ],
    [ "OB_ROH",	"OB_GALV", "OB_SONST" ],
    [ "OB_ROH",	"OB_GRUND", "OB_SONST" ],
    [ "OB_ROH", "OB_SONST" ],
    [ "OB_GALV", "OB_FEUER", "OB_SONST" ],
    [ "OB_GRUND", "OB_SONST" ],
    [ "OB_GALV", "OB_FEUER", "OB_SONST" ],
    [ "OB_FEUER", "OB_SONST" ],
    [ "OB_GRUND", "OB_SONST" ],
    [ "OB_FEUER", "OB_SONST" ],
    [ "OB_ROH",	"OB_FEUER", "OB_GRUND", "OB_SONST" ]
];


Produkt = function()
{
	/**
     *
     * @var
     */
    // @@@ Umbenennung der Variablen erwgen, wenn erstmal der ganze
    // alte Cascade-Code portiert ist

	this.m_Pcpartid     = 0;  // war logische ID des Teils in der Konstruktion
	this.m_Pemass       = 0;
	// this.m_Panz	    = 1;    // Anzahl wird jetzt Attribut einer Stcklistenstruktur
	this.m_Ptyp         = "";   // die komplette Typbezeichnung
	this.m_Pzusinfo     = "";	// Prfzeugnis
	this.m_Pzeichnr     = "";
	this.m_Pblock 	    = "BLOCK_JA";   // Eigenschaft des Hngers
	this.m_Pbeschicht 	= "OHNE";       // Eigenschaft des Hngers
	this.m_Poberfl      = "OB_ROH";
	this.m_PoberflFrei  = "";			// 03/2009: neu, fr freie Beschreibung des Oberflchenschutzes; nur bei OB_SONST
	this.m_Pwerkstoff   = "W_UNDEF";
    // Hier wird der berechnete Standard-Werkstoff gespeichert:
    // Whlt der ANwender spter einen Sonderwerkstoff und schaltet danach wieder auf Standard um,
    // kann damit der berechnete Standard-Werkstoff  wiederhergestellt werden
	this.m_Pwerkalt     = "W_UNDEF";
	this.m_Pwerkname    = "";
	this.m_Ptypid       = "";	// die ersten 3 Stellen der Typbezeichnung, vormals integer
	this.m_Psubtyp      = "";   // nur bei Sonderteil: m_Ptypid des Teils, das Sonder sein soll (Lager, Lasche, ...)
	this.m_Ppreis       = 0.0;
	// Preis fr Aktualisierung
	this.AKT_Preis		= 0;
	
	this.m_Pgewicht     = 0.0;
	this.m_PIdentNr     = "";	        // @@@ in Zukunft als Cache fr die Matnr benutzen? dann aber auch Zeile 1 des Artikeltexts speichern? -> ist aber sprachabh., besser in sep. Fkt. auslesen

    this.m_strMasse     = "";

	this.m_dKundenPreis = 0;
	this.m_bPreisVorgabe = 0;

	this.m_Pgewinde 	= caMainController.presets.m_nGewinde;      // "GEWINDE_DIN"

};

Produkt.prototype =
{
    serializeIn : function(strPath)
	{
        // In Oberklasse keine Prfung, ob berhaupt schon was da ist zum Reinserialisieren

        // Einfache Variablen einlesen, je nach Typ
        this.m_Pcpartid     = getstring("m_Pcpartid",strPath);
        this.m_Pemass       = getdouble("m_Pemass",strPath);
        // this.m_Panz	        = getdouble("m_Panz",strPath);
        this.m_Ptyp         = getstring("m_Ptyp",strPath);
        this.m_Pzusinfo     = getstring("m_Pzusinfo",strPath);
        this.m_Pzeichnr     = getstring("m_Pzeichnr",strPath);
        this.m_Pblock 	    = getstring("m_Pblock",strPath);
        this.m_Pbeschicht   = getstring("m_Pbeschicht",strPath);
        this.m_Poberfl      = getstring("m_Poberfl",strPath);
		this.m_PoberflFrei	= getstring("m_PoberflFrei",strPath);
        this.m_Pwerkstoff   = getstring("m_Pwerkstoff",strPath);
        this.m_Pwerkalt     = getstring("m_Pwerkalt",strPath);
        this.m_Pwerkname    = getstring("m_Pwerkname",strPath);
        this.m_Ptypid       = getstring("m_Ptypid",strPath);
        this.m_Psubtyp      = getstring("m_Psubtyp",strPath);
        this.m_Ppreis       = getdouble("m_Ppreis",strPath);
		this.AKT_Preis		= getdouble("AKT_Preis",strPath);
        this.m_Pgewicht     = getdouble("m_Pgewicht",strPath);
        this.m_PIdentNr     = getstring("m_PIdentNr",strPath);

        this.m_strMasse     = getstring("m_strMasse",strPath);

        this.m_dKundenPreis = getdouble("m_dKundenPreis",strPath);
        this.m_bPreisVorgabe = getdouble("m_bPreisVorgabe",strPath);
        this.m_Pgewinde 	= getstring("m_Pgewinde",strPath);
		this.m_qty			= getstring("m_qty",strPath);
    },

    serializeOut : function(strPath)
	{
        // Einfache Variablen
        setstring("m_Pcpartid",strPath,this.m_Pcpartid);
        setdouble("m_Pemass",strPath,this.m_Pemass);
        // setdouble("m_Panz",strPath,this.m_Panz);
        setstring("m_Ptyp",strPath,this.m_Ptyp);
        setstring("m_Pzusinfo",strPath,this.m_Pzusinfo);
        setstring("m_Pzeichnr",strPath,this.m_Pzeichnr);
        setstring("m_Pblock",strPath,this.m_Pblock);
        setstring("m_Pbeschicht",strPath,this.m_Pbeschicht);
        setstring("m_Poberfl",strPath,this.m_Poberfl);
		setstring("m_PoberflFrei",strPath,this.m_PoberflFrei);
        setstring("m_Pwerkstoff",strPath,this.m_Pwerkstoff);
        setstring("m_Pwerkalt",strPath,this.m_Pwerkalt);
        setstring("m_Pwerkname",strPath,this.m_Pwerkname);
        setstring("m_Ptypid",strPath,this.m_Ptypid);
        setstring("m_Psubtyp",strPath,this.m_Psubtyp);
        setdouble("m_Ppreis",strPath,this.m_Ppreis);
		setdouble("AKT_Preis",strPath,this.AKT_Preis);
        setdouble("m_Pgewicht",strPath,this.m_Pgewicht);
        setstring("m_PIdentNr",strPath,this.m_PIdentNr);
        setstring("m_strMasse",strPath, this.m_strMasse);
        setdouble("m_dKundenPreis",strPath,this.m_dKundenPreis);
        setdouble("m_bPreisVorgabe",strPath,this.m_bPreisVorgabe);
        setstring("m_Pgewinde",strPath,this.m_Pgewinde);
		setstring("m_qty",strPath,(this.m_qty ? this.m_qty  : 1));
    },
	getWerstoffeDBNumber : function(strId){
		var strDBClientId 	= '';
		var strNumber		= '';
		
		if(strId){
			var strDBClientId = WerknamenDB[strId] ? WerknamenDB[strId] : Werknamen[strId];
			var strNumber     = this.getWerkstoffeNumber(strDBClientId);
		}
		return ({'strSelId' : strNumber, 'strSelWerkstoff' : strDBClientId});
	},
	
	getWerkstoffeNumber  : function(strId){
		return (Werkstoffe[strId]);
	},
	
	getWerkstoffeAnzeigename  : function(strId){
		return (Werknamen[strId]);
	},
	
	makeTyp : function()
	{
		return m_Ptyp;
	},

	getPrintName : function()
	{
        // Wir benutzen inzwischen dafr Zeile 1 des Artikeltexts.
        // Dieser wird immer neu (sprachabhngig) ausgelesen aus TEXT_KONFIG
		return "Funktion getPrintName() noch zu definieren!";
	},

	getMassdaten : function()
	{
		return this.m_strMasse;
	},

    // ACHTUNG: "m_bAltesPreisschema" wird in in Cascade 3.x  angewendet fr die Preissuche
    //          Der neue Zweig wird in Cascade 3.x nur noch fr Identnummern benutzt.
    //          Dies ist bei SAP jedoch nicht mehr erforderlich (ersetzt durch neues Konzept)
	getPreis : function(oOptions)
	{
        if (m_bPreisVorgabe)
            return this.m_dKundenPreis;
        else
            return this.m_Ppreis;
	},

	getEmass : function()
	{
		// Wird fr Konstant- und Federhnger berlagert
		var Lager = Object.fromStorage("DLGDATA.CA.SELECTION.TOPOCLASS.Lager");
		var isKlemmsystem	= false;
		if(left(this.m_Ptypid,1) == "K" && right(left(this.m_Ptypid,2),1) != "H" && right(left(this.m_Ptypid,2),1) != "V"
			&& right(left(this.m_Ptypid,2),1) != "S")
				isKlemmsystem = true;
		if (isKlemmsystem && typeof(Lager) == 'object')
			return Lager.LAGERDATA.A;
		else if (isKlemmsystem && typeof(Lager) != 'object')
			return this.LAGERDATA.BREITE;
		else
			return this.m_Pemass;
	},
	getOberflaechenSchutzId : function(strSelComboId){
		return (Oberflaechenschutz[strSelComboId])
	},
	getOberFlaechenSchutzGruppe : function()
	{
        if (this.isHaenger() && (this.m_Ptypid != "SSG") && (this.m_Ptypid != "SSB"))
        {
            return(5);
        }
        else if (this.isHschelle() || this.isVschelle() || this.isLager() ||
                 this.m_Ptypid == "ZVN" || this.m_Ptypid == "ZVV" || this.m_Ptypid == "ZVS" )
        {
            //if (this.m_Pwerkstoff == "W_RST")
			if (left(this.m_Pwerkstoff, 5) == "W_RST")
            {
                if ( /* this.m_Ptypid == "HBN" || this.m_Ptypid == "HBV" || this.m_Ptypid == "HBS" || */
                    this.m_Ptypid == "HGN" || this.m_Ptypid == "HGV" ||
                    this.m_Ptypid == "MSN")
                {
                    return 2;
                }
                else
                {
                    return 1;
                }
            }
            else if ((this.m_Pwerkstoff == "W_15MO3") ||
                     (this.m_Pwerkstoff == "W_13CRMO") ||
                     (this.m_Pwerkstoff == "W_10CRMO") ||
					 (this.m_Pwerkstoff == "W_P91"))
            {
                return 3;
            }
            else
            {
                return 4;
            }
        }
        else
        {
            switch (this.m_Ptypid)
            {
                case "ZKN":
                case "ZKK":
                    return 8;
                case "ZTN":
					return 10;
                case "ZLN":
				case "ZLV":
				case "ZLB":
                case "ZLK":
                case "ZPK":
				case "ZGW":
                    return 9;
                case "SSG":
					if (getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE") == "false")
						return 7;
					else
						return 3;
                case "MBS":
				case "MBW":
                    return 6;
				case "ZZF":
					{
						if (atoi(getstring("EXPERT_MODE", "RIGHTS")))
							return 1;
						else
							return 7;
					}
                case "SON":	// nichts tun
                    return 0;
                default:
                    return 7;
            }
        }
        return 0;
	},


	getOberFlaechenSchutzDefault : function()
	{
        var nGruppe = this.getOberFlaechenSchutzGruppe();
        var nRet = "OB_ROH";

        switch (nGruppe) {
            case 1:
                nRet = caMainController.presets.OBFL_SCHEL1;  // m_CascadeProduktParameterVorgaben.m_nObflSchel1;
                break;
            case 2:
                nRet = caMainController.presets.OBFL_SCHEL2;   // m_CascadeProduktParameterVorgaben.m_nObflSchel2;
                break;
            case 3:
                nRet = caMainController.presets.OBFL_SCHEL3;    // m_CascadeProduktParameterVorgaben.m_nObflSchel3;
                break;
            case 4:
                nRet = caMainController.presets.OBFL_SCHEL4;    // m_CascadeProduktParameterVorgaben.m_nObflSchel4;
                break;
            case 5:
                nRet = caMainController.presets.OBFL_HAENGER;  // m_CascadeProduktParameterVorgaben.m_nObflHaenger;
                break;
            case 6:
                nRet = caMainController.presets.OBFL_STREBEN;  // m_CascadeProduktParameterVorgaben.m_nObflStreben;
                break;
            case 7:
                nRet = caMainController.presets.OBFL_VERBTEILE;   // m_CascadeProduktParameterVorgaben.m_nObflVerbteile;
                break;
            case 8:
                nRet = caMainController.presets.OBFL_ZKX;  // m_CascadeProduktParameterVorgaben.m_nObflZKX;
                break;
            case 9:
                nRet = caMainController.presets.OBFL_LASCHEN;  // m_CascadeProduktParameterVorgaben.m_nObflLaschen;
                break;
            case 10:
                nRet = caMainController.presets.OBFL_TRAVERSEN;  // m_CascadeProduktParameterVorgaben.m_nObflTraversen;
                break;
            case 0:	// nichts tun
            default:
                nRet = "OB_ROH";
                break;
        }

        return (nRet);
	},

	getMaterial : function()
	{
        var strRet = "";
        if (this.m_Pwerkstoff == "W_SONST")
        {	strRet = m_Pwerkname;
        }
        else
        {	strRet = Werknamen[this.m_Pwerkstoff];
        }
        return strRet;
	},

	getWerkname : function(/* string */ id)
	{
        var strWerkname = "";
        if (id == "W_SONST")
            strWerkname = this.m_Pwerkname;
        else
            strWerkname = Werknamen[id];
            
        if (strWerkname == "")
            strWerkname = Werknamen["W_SONST"];
            
		return strWerkname;
	},

	getWerkstoffeZahlZuId : function(/* string */ werkstoffId)
	{
		for(var i=0; i < WerkstoffeZahlZuId.length; i++)
		{
			if(Werkstoffe[ WerkstoffeZahlZuId[i] ] == werkstoffId)
				return WerkstoffeZahlZuId[i];
		}
		return "W_UNDEF";
	},

	isHaenger : function()
	{
        if (this.isFHaenger() || this.isKHaenger())
        {	return 1;
        }
        return 0;
	},

	isFHaenger : function()
	{
        if (this.m_Ptypid == "FHG" || this.m_Ptypid == "FHD" || this.m_Ptypid == "FHS" || this.m_Ptypid == "FSS" ||
            this.m_Ptypid == "FSG" || this.m_Ptypid == "FSP" || this.m_Ptypid == "FDT" || this.m_Ptypid == "SSG" ||
			this.m_Ptypid == "SSB")
        {	return 1;
        }
        return 0;
	},

	isKHaenger : function()
	{
        if (this.m_Ptypid == "KHD" || this.m_Ptypid == "KVD" || this.m_Ptypid == "KHS" ||
            this.m_Ptypid == "KVS" || this.m_Ptypid == "KSR" || this.m_Ptypid == "KSP")
        {	return 1;
        }
        return 0;
	},

    // Wenn der Hnger eine Gewindestange ist
	isZRMHaenger : function()
	{
        if (this.m_Ptypid == "ZRM")
        {	return 1;
        }
        return 0;
	},

	isHaengerStehend : function()
	{
        if (this.isHaenger() && (this.m_Ptypid == "KHS" || this.m_Ptypid == "KVS" ||
                            this.m_Ptypid == "FHS" || this.m_Ptypid == "FSS"))
        {	return 1;
        }
        return 0;
	},

    // wenn der "Hnger" auch nach oben ein Element variabler Lnge hat (Gewindestange)
	isHaengerObenFlexibel : function()
	{
        if (this.m_Ptypid == "FHG" || this.m_Ptypid == "ZSM" )
        {	return 1;
        }
        return 0;
	},

	isStuetze : function()
	{
        if (this.m_Ptypid == "FSS" || this.m_Ptypid == "FSG" || this.m_Ptypid == "FSP" ||
            this.m_Ptypid == "KSR" || this.m_Ptypid == "KSP")
        {	return 1;
        }
        return 0;
	},

	isGewTeil : function()
	{
        // ZRM, ZLM, ZMM, ZOM, ZGM, ZSM, ZHM
        if (this.isHaenger() || this.m_Ptypid == "ZGM" || this.m_Ptypid == "ZSM" || this.m_Ptypid == "ZOM" || this.m_Ptypid == "ZHM" ||
                           this.m_Ptypid == "ZRM" || this.m_Ptypid == "ZLM" || this.m_Ptypid == "ZMM")
        {	return 1;
        }
        return 0;
	},

    isSchelle : function()
    {
        if (this.isVschelle() || this.isHschelle())
        {	return 1;
        }
        return 0;
    },

    isSchelleLager : function()
    {
        if (this.isVschelle() || this.isHschelle() || this.isLager())
        {	return 1;
        }
        return 0;
    },

	isVschelle : function()
	{
        if (this.m_Ptypid == "VBK" ||
            this.m_Ptypid == "VKK" || this.m_Ptypid == "VJK" || this.m_Ptypid == "VJR" || this.m_Ptypid == "VKR" ||
            this.m_Ptypid == "VGR" || this.m_Ptypid == "VSK" || this.m_Ptypid == "VSR" || this.m_Ptypid == "VPK" || m_Ptypid == "VPR")
        {	return 1;
        }
        return 0;
	},

	isHschelle : function()
	{
        if (this.m_Ptypid == "HZN" || this.m_Ptypid == "HZV" || this.m_Ptypid == "HZS" ||
            this.m_Ptypid == "HDN" || this.m_Ptypid == "HDV" || this.m_Ptypid == "HDS" ||
            this.m_Ptypid == "HBN" || this.m_Ptypid == "HBV" || this.m_Ptypid == "HBS" ||
            this.m_Ptypid == "HGN" || this.m_Ptypid == "HGV" || this.m_Ptypid == "MSN" ||
			this.m_Ptypid == "MSL" ||
            this.isLager())
        {	return 1;
        }
        return 0;
	},

	isTraverse : function()
	{
        if (this.m_Ptypid == "ZTN")
        {	return 1;
        }
        return 0;
	},

	isLager : function()
	{
        // -Schu- "ALT" Lagersystematik FLEXPERTE 4
		/*
		if (this.m_Ptypid == "LKG" || this.m_Ptypid == "LSG" || this.m_Ptypid == "LKF" ||
            this.m_Ptypid == "LSF" || this.m_Ptypid == "LVG" || this.m_Ptypid == "IKG" ||
            this.m_Ptypid == "LKL" || this.m_Ptypid == "LSL" || this.m_Ptypid == "LXL" || 
            this.m_Ptypid == "LVL" || this.m_Ptypid == "LUR" || 
            this.m_Ptypid == "IKL" || this.m_Ptypid == "FLN" || this.m_Ptypid == "FVN" ||
            this.m_Ptypid == "FSN" || this.m_Ptypid == "FSD" || this.m_Ptypid == "FLV" ||
			this.m_Ptypid == "LXA" || this.m_Ptypid == "LXV")
        {	
			return 1;
        }
		*/
		//  -Schu- "NEU" Lagersystematik FLEXPERTE 5
		if (this.m_Ptypid == "LKL" || this.m_Ptypid == "LSL" || this.m_Ptypid == "LXL" ||
            this.m_Ptypid == "IKL" || this.m_Ptypid == "LVL" || this.m_Ptypid == "LVS" ||
            this.m_Ptypid == "LKF" || this.m_Ptypid == "LSF" || this.m_Ptypid == "LXF" || 
            this.m_Ptypid == "FLN" || this.m_Ptypid == "FVN" || this.m_Ptypid == "FLV" ||
            this.m_Ptypid == "FSN" || this.m_Ptypid == "FSD" ||
			(this.m_Ptypid == "LKG" && this.strBauF == "10"))	// Fhrungslager Typ 10
        {	
			return 1;
        }
		
        return 0;
	},

	isKlemmsystem : function()
	{
        if (this.m_Ptypid == "KOT" || this.m_Ptypid == "KZT" || this.m_Ptypid == "KAT" ||
            this.m_Ptypid == "KOU" || this.m_Ptypid == "KZU" || this.m_Ptypid == "KOL" ||
            this.m_Ptypid == "KZL" || this.m_Ptypid == "KLT" || this.m_Ptypid == "KLU" || 
            this.m_Ptypid == "KLL")
        {	return 1;
        }
        return 0;
	},

    getAnzMuttern : function()
    {
        if (this.m_Ptypid == "FHS" || this.m_Ptypid == "FHG" ||
            this.m_Ptypid == "ZPK" || this.m_Ptypid == "ZHM" ||
            this.m_Ptypid == "FDT")
        {	return 2;
        }
        if (this.m_Ptypid == "ZGM" || this.m_Ptypid == "ZOM" ||
            this.m_Ptypid == "ZSM" || this.m_Ptypid == "FHD" || 
            this.m_Ptypid == "KHD" || this.m_Ptypid == "KVD" ||
            this.m_Ptypid == "KHS" || this.m_Ptypid == "KVS")
        {	return 1;
        }
        return 0;
    },

    isAusserhalbSystemMass : function()
    {
        // Hier mssten auch alle Lager rein, sofern sie auf
        // einer Traverse stehen, nicht bei sttzend; deshalb das in der Topologie regeln ...
        if (this.m_Ptypid == "FHS" || this.m_Ptypid == "KVS" ||
            this.m_Ptypid == "ZPK" || this.m_Ptypid == "ZMM" || this.m_Ptypid == "VBK")
        {	return 1;
        }
        return 0;
    },

    isRohmassPosition : function()
    {
        if ((this.m_Ptypid == "ZRM") || (this.m_Ptypid == "ZTN") || (this.m_Ptypid == "ZLB"))
        {	return 1;
        }
        return 0;
    },

    getAdditionalDataToStore : function(massPath, theMainController)
    {
        // Hier speziell fr die Lastkette
        if ((this.m_Ptyp == "LK")  || (this.m_Ptypid == "LK1_RH_SO"))
        {
            strPos = getstring("POS","DLGDATA");
            setstring("POS", massPath, strPos);

            // unschn, hier mssen wir wieder hintenrum an die Topologie ran ...
            myHaenger = theMainController.topologieKlasse.getCurrentHaenger();
            if (myHaenger)
            {
                //if (myHaenger.m_Ptypid == "SSG")
				if (left(myHaenger.m_Ptypid, 2) == "SS")		// SSG und SSB verwenden diese Variable
                    setstring("TYP_BEZ_STREB", massPath, myHaenger.m_Ptyp);
                else if (myHaenger.m_Ptypid == "FSG")
                    setstring("TYP_BEZ_G_STUETZE", massPath, myHaenger.m_Ptyp);
                else
                    setstring("TYP_BEZ_HAE", massPath, myHaenger.m_Ptyp);
            }
            if (theMainController.topologieKlasse.Schelle)
            {
                setstring("TYP_BEZ_SH", massPath, theMainController.topologieKlasse.Schelle.m_Ptyp);
            }
            if (theMainController.topologieKlasse.Lager)
            {
                setstring("TYP_BEZ_SH", massPath, theMainController.topologieKlasse.Lager.m_Ptyp);
            }
			if (theMainController.topologieKlasse.TopoLager2.Lager)
            {
                setstring("TYP_BEZ_SH", massPath, theMainController.topologieKlasse.TopoLager2.Lager.m_Ptyp);
            }

        }

    },

    getSAPTyp : function()
    {
        return this.m_Ptypid;
    },

    getSonderTexte : function(strSprache)
    {
        var sonTexte = [];
        var strKlasse = this.getSAPKlassenName();
        if (this.m_bSonderNennweite || this.m_bSonderSpannweite || this.m_bSonderZubehoer)
        {
            // -mw- 2008-08-28 Achtung: Umgestellt auf neues System mit Dictionary:
            // var strSQLStatement = "select * from TEXT_SON where KLASSE='"+strKlasse+"' and TYP='"+this.getSAPTyp()+"' and SPRACHE='"+strSprache+"' order by abs(ZEILEN_NR) ";
            var strAktuelleSprache = getlanguage();
            setlanguage(strSprache);
            var strSQLStatement = "select * from TEXT_SONDER_ID where KLASSE='"+strKlasse+"' and TYP='"+this.getSAPTyp()+"' order by abs(ZEILEN_NR) ";
            var numRet = dbselect("SAP_V", strSQLStatement, "TEXTE_SON");
            if (numRet > 0)
            {
                while (dbiseof("TEXTE_SON") == 0)
                {
                    // strText = dbgetstring("TEXTE_SON", "V_TEXT");
                    strText = dbgetstring("TEXTE_SON", "ID");
                    if (strText != "")
                    {
                        strText = translate(strText);
                        sonTexte.push(strText);
                    }
                    dbskip("TEXTE_SON");
                }
            }
            setlanguage(strAktuelleSprache);
        }
        return sonTexte;
    },
    
	getMatInfo : function(theMainController, strKlasse, aMerkmale, strSprache, bTexteSuchen)
	{
        var retObj = {matnr : "", mat_kurz_txt : "", aTexte : []};

        if (!strSprache || (strSprache == ""))
            strSprache = getlanguage();
        if (((strSprache != "DE") && (strSprache != "EN")) ||
            (strSprache == ""))
            strSprache = "EN";

        var strSQLStatement = "select * from MATERIAL where KLASSE='"+strKlasse+"' ";
        var strMerkmName, strMerkmWert;

        for (var i = 0; i < aMerkmale.length; i++)
        {
            if (aMerkmale[i] && (aMerkmale[i] != ""))
            {
                strMerkmName = "MERKM_"+(i+1);
                strMerkmWert = aMerkmale[i];
                if (strMerkmWert == "$EMPTY$")  // --> auf Anforderung schm vom 31.3.2008
                    strMerkmWert = "";
                // -schm- 03/2008: Die Suchmerkmale mssen exakt passen und komplett in der Datenbank ausgefllt sein.
                // strSQLStatement = strSQLStatement + "AND ("+strMerkmName+"='' OR "+strMerkmName+ "='"+aMerkmale[i]+"') "
                strSQLStatement = strSQLStatement + "AND "+strMerkmName+ "='"+strMerkmWert+"' ";
            }
        }

        logtrace("Klasse: "+strKlasse+" SQL="+strSQLStatement+"\n");

        var numRet = dbselect("SAP_M", strSQLStatement, "MAT_SELECT");
        if (numRet > 0)
        {
            retObj.matnr        = dbgetstring("MAT_SELECT", "MAT_NR");
            retObj.mat_kurz_txt = dbgetstring("MAT_SELECT", "MAT_KURZ_TXT_" + strSprache);
            // normieren auf 7 Stellen mit fhrender Null:
            if (retObj.matnr.length == 6)
                retObj.matnr = "0" + retObj.matnr;
			else if (retObj.matnr.length == 5)
                retObj.matnr = "00" + retObj.matnr;
			else if (retObj.matnr.length == 4)
                retObj.matnr = "000" + retObj.matnr;

            logtrace("--> Matnr="+retObj.matnr+" Mat-Txt="+retObj.mat_kurz_txt+"\n");

            if (numRet > 1)
            {
                // alert(utf8toansi("Hinweis: Fr Klasse "+strKlasse+" wurde mehr als ein Material gefunden ... \nBitte Hr. Schmidsberger kontaktieren und ihm die Datei logfile.txt mailen.\n" + strSQLStatement));
                logtrace("!!!!!!!!!!!! ACHTUNG: mehr als eine Materialnummer fr diese Klasse gefunden !!!!!!!!!!!\n");
            }
        }
        else
            logtrace("--> Keine Matnr gefunden!\n");

        // da jetzt alle Texte konfigurierbar sind, knnen wir auch suchen, wenn keine Matnr vorhanden || (numRet <= 0))
        if (! bTexteSuchen)
            return retObj;

        var strText;
        logtrace(">>> Texte fr Produkt: "+this.m_Ptypid+"\n");
        // -mw-, -schm-, 26.2.2008: Es werden jetzt alle Texte als
        // konfigurierbare Texte in TEXT_KONFIG untergebracht
        // if (this.isSAPKonfigurierbar() || this.isRohmassPosition() || (this.m_Ptyp == "LK"))
        if (1)
        {
            var strSubtyp = "";
            if (this.getSubtyp)
                strSubtyp = this.getSubtyp();
            // if (strSubtyp == "")
            // -mw- 2008-08-28 Achtung: Umgestellt auf neues System mit Dictionary:
            // strSQLStatement = "select * from TEXT_KONFIG where KLASSE='"+strKlasse+"' and TYP='"+this.getSAPTyp()+"' and SPRACHE='"+strSprache+"' and SUB_TYP='"+strSubtyp+"' order by abs(ZEILEN_NR) ";
            var strAktuelleSprache = getlanguage();
            // setlanguage(strSprache);  ... hier nicht ntig, wir bersetzen Artikeltexte aus dem Dictionary
			strSQLStatement = "select * from TEXT_KONFIG_ID where KLASSE='"+strKlasse+"' and TYP='"+this.getSAPTyp()+"' and SUB_TYP='"+strSubtyp+"' order by abs(ZEILEN_NR) ";
            numRet = dbselect("SAP_V", strSQLStatement, "TEXTE_KONFIG");
            logtrace(" SQL="+strSQLStatement+" --> " + numret + " records found\n");

            if (numRet > 0)
            {
                var massPath = "TMP.MAT_ADDITIONAL_DATA";
                if ((this.m_Ptyp == "LK") || (this.m_Ptypid == "LK1_RH_SO"))
                    this.getAdditionalDataToStore(massPath, theMainController);  // Aufruf der Methode hier
                else
                    this.getAdditionalDataToStore(massPath);    // Aufruf am jeweiligen Produkt
                while (dbiseof("TEXTE_KONFIG") == 0)
                {
                    // strText = dbgetstring("TEXTE_KONFIG", "V_TEXT");
                    strText = dbgetstring("TEXTE_KONFIG", "ID");
                    if (strText != "")
                        strText = translate(strText);
                    strText = this.replaceMasse(strText, massPath, theMainController);
                    logtrace(">>> "+strText+"\n");
                    if (strText != "")
                        retObj.aTexte.push(strText);
                    dbskip("TEXTE_KONFIG");
                }
            }
            // setlanguage(strAktuelleSprache);
        }
        else
        {
            strSQLStatement = "select * from TEXTE_EINDEUTIG where MAT_NR='"+retObj.matnr+"' and SPRACHE='"+strSprache+"' order by abs(ZEILEN_NR) ";
            numRet = dbselect("SAP_M", strSQLStatement, "TEXTE_EINDEUTIG");
            if (numRet > 0)
            {
                var massPath = "TMP.MAT_ADDITIONAL_DATA";
                this.getAdditionalDataToStore(massPath);
                while (dbiseof("TEXTE_EINDEUTIG") == 0)
                {
                    strText = dbgetstring("TEXTE_EINDEUTIG", "V_TEXT");
                    strText = this.replaceMasse(strText, massPath, theMainController);     // kommt jetzt auch bei eindeutigen Produkten
                    retObj.aTexte.push(strText);
                    logtrace(">>> "+strText+"\n");
                    dbskip("TEXTE_EINDEUTIG");
                }
            }
        }

        return retObj;
	},

    getMerkmaleArray : function(strKlasse, searchObj)
    {

        // @@@ Feld SUCHRELEVANT in KLASSE_MERKMALE_001 --> gibts das dann auch in SAP?
        // Hier keine weiteren Kriterien einfgen weil die Reihenfolge relevant ist
        // fr das Auffllen des Arrays unten @@@ eventuell spter mal besser machen anhand se_number?
        var strSQLStatement = "select * from KLASSE_MERKMALE_001 where KLASSE='"+strKlasse+"'  ORDER BY SORT ASC "

		// So etwas ginge eigentlich viel schner
		// ret = Object.fromDatabase( "CASCADE", strSQLStatement ); --gl--
		// for (var i=0; i < ret.length; i++ ) {
		//		var mm = ret.MERKMAL;
		//		var so = searchObj[mm];
		// 		if ( typeof so != "undefined" && so != "" ) {
		//			retArr.push(so)
		//		}
		//	}

        var strMerkmal, strSuchrel;
        var retArr = [];
        var numRet = dbselect("SAP_M", strSQLStatement, "KLASSE_SELECT")
        if (numRet > 0)
        {
            while (dbiseof("KLASSE_SELECT") == 0)
            {
                strMerkmal = dbgetstring("KLASSE_SELECT", "MERKMAL");
                strSuchrel = dbgetstring("KLASSE_SELECT", "SUCHRELEVANT");
                // ist das Merkmal leer ("") wird das als 0 interpretiert
				if (searchObj[strMerkmal])	// nur in "Text" umwandeln wenn vorhanden sonst "undefined"
					searchObj[strMerkmal]	+= "";
				if ((searchObj[strMerkmal] == "0") &&
                    (toupper(strSuchrel) == "X"))
                {
                    retArr.push(searchObj[strMerkmal]);
                }
                else if (searchObj[strMerkmal] &&
                    (searchObj[strMerkmal] != "") &&
                    (toupper(strSuchrel) == "X"))
                {
                    retArr.push(searchObj[strMerkmal]);
                }
                else if ((searchObj[strMerkmal] == "") &&
                    (toupper(strSuchrel) == "X"))
                {
                    retArr.push("$EMPTY$");
                }
                else
                {
                    retArr.push("");
                }

                dbskip("KLASSE_SELECT");
            }
        }
        return retArr;
    },

    setSpecialASTLSubDaten : function(theMainController, strOutFile, strAngebNr, strPosNr, strMatnr, strKlasse)
    {
        var strMessage = "";
        var strStPos, strPostyp, strMenge, strMengeEinheit, strPosTxt1, strPosTxt2;
        var rm1, rm_einheit, rm2, rm3, aufloesungsstrg, formelzeichen, stkMatNr;

        strStPos          = "01";
        strPostyp         = "L";
        stkMatNr          = this.strIdentLSL;
        strMenge          = "1";
        strMengeEinheit   = "ST";
        strPosTxt1        = "";
        strPosTxt2        = "";
        rm1               = "";
        rm_einheit        = "";
        rm2               = "";
        rm3               = "";
        aufloesungsstrg   = "";
        formelzeichen     = "";

        writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strMatnr+";"+strStPos+";"+strStPos+";"+strPostyp+";"+stkMatNr+";"+strMenge+";"+strMengeEinheit+";;"+strPosTxt1+";"+strPosTxt2+";"+rm1+";"+rm_einheit+";"+rm2+";"+rm3+";"+formelzeichen+";"+aufloesungsstrg+" \r\n", "a");	// append

        strStPos          = "02";
        strPostyp         = "L";
        stkMatNr          = this.strIdentLAW;
        strMenge          = this.strANZ_LG;
        strMengeEinheit   = "ST";
        strPosTxt1        = "";
        strPosTxt2        = "";
        rm1               = "";
        rm_einheit        = "";
        rm2               = "";
        rm3               = "";
        aufloesungsstrg   = "";
        formelzeichen     = "";

        writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strMatnr+";"+strStPos+";"+strStPos+";"+strPostyp+";"+stkMatNr+";"+strMenge+";"+strMengeEinheit+";;"+strPosTxt1+";"+strPosTxt2+";"+rm1+";"+rm_einheit+";"+rm2+";"+rm3+";"+formelzeichen+";"+aufloesungsstrg+" \r\n", "a");	// append

        return strMessage;
    },

    setASTLSubDaten : function(theMainController, strOutFile, strAngebNr, strPosNr, strMatnr)
    {
        var strKlasse = this.getSAPKlassenName();
        var i = 0;
        var strMessage = "";

        logtrace("\n\nGenerate ASTL-Subdaten for: "+this.m_Ptypid + "\n");

        if ((this.m_Ptypid == "LSW") || (this.m_Ptypid == "LXA") || (this.m_Ptypid == "LXV"))
            return this.setSpecialASTLSubDaten(theMainController, strOutFile, strAngebNr, strPosNr, strMatnr, strKlasse);

        // Aufgabe: Aus Tabelle Stueckliste die richtigen Stuecklisten-Datensaetze ausfiltern:
        var strSQLStatement = "select * from STUECKLISTE where SELEKT_KLASSE='"+strKlasse+"' AND SELEKT_TYP='"+this.m_Ptypid+"' ORDER BY St_Pos ASC "

        var strSelektMerkmal1, strSelektMerkmal2, strSelektWert1, strSelektWert2;
        var strStPos, strPostyp, strMenge, strMengeEinheit, strPosTxt1, strPosTxt2, strKlassePart;
        var rm1, rm_einheit, rm2, rm3, aufloesungsstrg, formelzeichen, stkMatNr;
        var m_name, m_wert, result_wert;

        var massPath = "TMP.PR_ADDITIONAL_DATA";
        this.getAdditionalDataToStore(massPath);

        var SelektObj = {FORM: '',
                         SUBTYP: '',
                         BAU_F: '',
                         WERKSTOFFS: WerkstoffeSAPid[this.m_Pwerkstoff] };

        if (this.isVschelle())
            SelektObj.FORM = this.vtyp;
        else if ((left(this.m_Ptypid, 2) == "HG") ||
                 (this.m_Ptypid == "MSN") ||
                 (left(this.m_Ptypid, 2) == "ZK"))
            SelektObj.FORM = getstring("FORM", massPath);

        if (left(this.m_Ptypid, 2) == "ZK")
            SelektObj.SUBTYP = this.subtyp;
		else if (this.getSubtyp)
        {
            SelektObj.SUB_TYP = this.getSubtyp();
            SelektObj.SUBTYP = this.getSubtyp();
        }
        
        if (this.isLager() && this.strBauF)
            SelektObj.BAU_F = this.strBauF;

        var numRet = dbselect("SAP_V", strSQLStatement, "STUECKLISTE_SELECT")
        if (numRet > 0)
        {
            while (dbiseof("STUECKLISTE_SELECT") == 0)
            {
                // Diese Selektion flexibler machen ...
                // Namen wie bei Matnr-Select ... keine Variablen hier auch noch unterbringen!
                // Hier gibts im Mometn zwei Variablen: WERKSTOFFS und FORM (bei HGx, MSN, VGR, VPR, VSR und ZKN)
                var bOK = 1;
                strSelektMerkmal1 = dbgetstring("STUECKLISTE_SELECT", "SELEKT_NAME_1");
                strSelektMerkmal2 = dbgetstring("STUECKLISTE_SELECT", "SELEKT_NAME_2");
                strSelektWert1    = dbgetstring("STUECKLISTE_SELECT", "SELEKT_WERT_1");
                strSelektWert2    = dbgetstring("STUECKLISTE_SELECT", "SELEKT_WERT_2");
                if ((strSelektMerkmal1 != "") && (strSelektWert1 != ""))
                    if (SelektObj[strSelektMerkmal1] != strSelektWert1)
                        bOK = 0;
                if ((strSelektMerkmal2 != "") && (strSelektWert2 != ""))
                    if (SelektObj[strSelektMerkmal2] != strSelektWert2)
                        bOK = 0;
				// Damit bei HDx-S die Stckliste nicht doppelt gezogen wird, einmal fr Subtyp HDx-S, einmal die
				// normale ohne Subtyp
				if (SelektObj.SUB_TYP && 
                        (strSelektMerkmal1 != "SUB_TYP") && (strSelektMerkmal2 != "SUB_TYP") &&
                        (strSelektMerkmal1 != "SUBTYP") && (strSelektMerkmal2 != "SUBTYP"))
                        bOK = 0;

                if (bOK)
                {
                    // Pro Zeile eine Auftragssubstcklistenposition anlegen ...
                    // Dazu erstmal die Mat-Nr des Substcklistenteils ermitteln
                    strStPos        = dbgetstring("STUECKLISTE_SELECT", "St_Pos");
                    logtrace("\nStueckliste Pos: "+strStPos + "\n");
                    strPostyp       = dbgetstring("STUECKLISTE_SELECT", "Pos_Typ");
                    strMenge        = dbgetstring("STUECKLISTE_SELECT", "MENGE");
                    strMenge        = this.myEval(this.replaceMasse(strMenge, massPath, theMainController));      // aufpassen, da knnen auch einfach echte Zahlen drin stehen

                    strMengeEinheit = dbgetstring("STUECKLISTE_SELECT", "M_EINHEIT");
                    // Fr Sub-Stcklisten (also ZKX, VXX, ) gilt:
                    // Positionstext 1 und 2 aus Tabelle STUECKLISTE benutzen, wenn leer,
                    // dann leer bergeben (kommt dann aus dem Material).
                    // strPosTxt1      = this.m_Ptyp;
                    strPosTxt1      = dbgetstring("STUECKLISTE_SELECT", "Pos_TXT1");
                    strPosTxt2      = dbgetstring("STUECKLISTE_SELECT", "Pos_TXT2");
                    if (strPosTxt1 != "")
                        strPosTxt1  = this.replaceMasse(strPosTxt1, massPath, theMainController);
                    if (strPosTxt2 != "")
                        strPosTxt2  = this.replaceMasse(strPosTxt2, massPath, theMainController);
					strPosTxt1  = ansi2utf8(strPosTxt1);
					strPosTxt2  = ansi2utf8(strPosTxt2);
                    strKlassePart   = dbgetstring("STUECKLISTE_SELECT", "KLASSE");

                    /*
                    var ALPH=acos((20+5*25)/(168.3+1+5*25));
                    var res=800+2*35+RUNDEN((168.3+1+5*25)*(ALPH-sin(ALPH)));
                    */

                    rm1             = dbgetstring("STUECKLISTE_SELECT", "ROHMASS_M_1");
                    rm1             = this.myEval(this.replaceMasse(rm1, massPath, theMainController));
                    rm_einheit      = dbgetstring("STUECKLISTE_SELECT", "R_EINHEIT");
                    rm2             = dbgetstring("STUECKLISTE_SELECT", "ROHMASS_M_2");
                    rm2             = this.myEval(this.replaceMasse(rm2, massPath, theMainController));
                    rm3             = dbgetstring("STUECKLISTE_SELECT", "ROHMASS_M_3");
                    rm3             = this.myEval(this.replaceMasse(rm3, massPath, theMainController));
                    aufloesungsstrg = dbgetstring("STUECKLISTE_SELECT", "AUFL_ST");
                    formelzeichen   = dbgetstring("STUECKLISTE_SELECT", "FORMEL_SCH");

                    // M_NAME_1...9  /  M_WERT_1...9  --> Selektoren fr Material-Nr. des Stcklistenteils
                    var searchObj = {};     // hier immer neu initialisieren ...
                    for (i = 1; i <= 9; ++i)
                    {
                        m_name = dbgetstring("STUECKLISTE_SELECT", "M_NAME_"+i);
                        m_wert = dbgetstring("STUECKLISTE_SELECT", "M_WERT_"+i);

                        // Assoziatives Array der verfgbaren Merkmale und ihrer Werte
                        // if ((toupper(m_wert) != "X") && (m_wert != ""))
                        // -mw- 3.4.2008: Auf Wunsch -schm- auch leere Felder ins Select mit einbeziehen
                        if (toupper(m_wert) != "X")
                        {
                            if (m_wert != "")
                                result_wert = this.myEval(this.replaceMasse(m_wert, massPath, theMainController));
                            else
                                result_wert = "";
                            searchObj[m_name] = result_wert;
                        }
                        // String hat selbst eine mctigere replace Funktion, dieser sollte
                        // auf jeden Fall der Vorzug vor dem alten globalen Ungetm gegeben werden.
                        // m_wert = m_wert.replace(/\{c\}/, "24");
                    }
                    // Daraus ein richtig geordnetes Array der relevanten Suchkriterien bilden:
                    var aMerkmale = this.getMerkmaleArray(strKlassePart, searchObj);
                    // Damit die MatInfo suchen ...
                    var matInfo   = this.getMatInfo(theMainController, strKlassePart, aMerkmale, "", 0);
                    stkMatNr      = matInfo.matnr;

                    if (atoi(strMenge) != 0)
                    {
                        writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strMatnr+";"+strStPos+";"+strStPos+";"+strPostyp+";"+stkMatNr+";"+strMenge+";"+strMengeEinheit+";;"+strPosTxt1+";"+strPosTxt2+";"+rm1+";"+rm_einheit+";"+rm2+";"+rm3+";"+formelzeichen+";"+aufloesungsstrg+" \r\n", "a");	// append
                        if (stkMatNr == "")
                            strMessage += "Pos "+strPosNr+", Matnr "+strMatnr+", EinzelStuecklistenpos "+strStPos+": Stuecklisten-Materialnummer fehlt!\\n";
                    }
                }
                dbskip("STUECKLISTE_SELECT");
            }
        }
        return strMessage;
    },

    myEval : function(strFormel)
    {
        var result_wert;

        // Damit wir richtig rechnen ...
        strFormel = replace(strFormel, ",", ".");

        if ((strFormel.indexOf("res=") >= 0) || (strFormel.indexOf("res =") >= 0) ||
            ((strFormel.indexOf("=") >= 0) && (strFormel.indexOf("*") >= 0)))
        {
            result_wert = eval(strFormel);
            if ((strFormel.indexOf("res=") >= 0) || (strFormel.indexOf("res =") >= 0))
                result_wert = res;      // hier enthlt variable res das ergebnis, Achtung: Evaluierung des Statements res = blabla; ergibt 0!
        }
        else
            result_wert = strFormel;
        logtrace("EVAL REPLACE RESULT: "+result_wert + "\n");
        logtraceflush();
        return result_wert;
    },

    replaceMasse : function(m_wert, massPath, theMainController)
    {
        var nDepth = 0;
        var strRepVal = "", strReplacement = "";
        var strResult = m_wert;
        var nLength = m_wert.length;

        for (var i = 0; i < nLength; ++i)
        {
            if (m_wert.charAt(i) == "}")
            {
                if (nDepth == 0)
                    alert("Fehler 1 in Stuecklistendaten: mehr schlieende Klammern als ffnende");

                // Suche nach Ersatz fr Eintrag in {}
                strReplacement = getstring(strRepVal, massPath);
                if (strReplacement == "")
                    strReplacement = getstring(toupper(strRepVal), massPath);
                //if (strReplacement == "")
                if ((strReplacement == "") || (strReplacement == "-"))
                {
                    if (right(strRepVal,4) == "_AHS"){
						//var Test = getDialogObjectSession("LAGER");
						var AHS = (!getDialogObjectSession("LAGER").AuswahlRollenlager.oSearchResult.oResultAbhebesicherung ?
									this.oData : getDialogObjectSession("LAGER").AuswahlRollenlager.oSearchResult.oResultAbhebesicherung);
						var strRepVal_left = left(strRepVal,(strRepVal.length - 4));
						switch (strRepVal_left){
							case "ANZ_RD"		:	strReplacement = AHS.ANZ_RD;
													break;
							case "D_STANGE"		:	strReplacement = AHS.D_STANGE;
													break;
							case "L_STANGE"		:	strReplacement = AHS.L_STANGE_ZUS*1 + (!this.strSattellaenge ?
													right(left(AHS.TYP,10),3)*1 : this.strSattellaenge*1);
													break;
							case "S"			:	strReplacement = AHS.S;
													break;
							case "H"			:	strReplacement = AHS.H;
													break;
							case "A"			:	strReplacement = AHS.A;
													break;
							case "D_SPL"		:	strReplacement = AHS.D_SPL;
													break;
							case "L_SPL"		:	strReplacement = AHS.L_SPL;
													break;
							case "WERKST_NR"	:	strReplacement = WerkstoffeSAPid[ this.m_Pwerkstoff ];
													break;
							default				:	break;
						}
					}
					
					// IST-Masse von Schellen, FDT, ZTN ... (entweder das Norm-Mass bei Normteilen oder eingegebenes Sondermass
                    if ((this.isHschelle() || this.isVschelle()) &&
                        (toupper(strRepVal) == "DN_IST"))
                    {
                        if (this.m_bSonderNennweite)
                            strReplacement = "-";   
                        else
                            strReplacement = this.nennweite;   
                    }
					else if (toupper(strRepVal) == "DN_IST" && this.oData.DN == "-")
						strReplacement = this.oData.oOriginalData.DN;
					else if (toupper(strRepVal) == "DN_IST")
						strReplacement = this.oData.DN;
					
                    if (toupper(strRepVal) == "D")
                        strReplacement = this.m_dSonderNennweite;   
                    if (toupper(strRepVal) == "EIST")
                        strReplacement = this.getEmass();   
                    if (toupper(strRepVal) == "L")
                    {
                        if (this.m_bSonderSpannweite)
                            strReplacement = this.m_dSonderSpannweite;   
                        else
                            strReplacement = this.spannweite;   
                    }    
                        
                    if ((toupper(strRepVal) == "TYP_BEZ") || (toupper(strRepVal) == "TYP_BEZ_LAW")){
						strReplacement = this.m_Ptyp;
						if (!strReplacement && theMainController.topologieKlasse.Sonderteile.length > 0)
							strReplacement = theMainController.topologieKlasse.Sonderteile[0].m_Ptyp;
						else if (!strReplacement)
							strReplacement = "";
					}
                    if ((toupper(strRepVal) == "OBFLSCHUTZ") || (toupper(strRepVal) == "OBFLSCHUTZ_SAT")
						|| (toupper(strRepVal) == "OBFLSCHUTZ_ABE"))
                    {
                        strReplacement = translate(OberflaechenschutzTransID[this.m_Poberfl]);
                        if (this.isSchelleLager())
                        {
                            var oOptions = theMainController.presets.getPreisOptions();
                            if (oOptions.SONDERANSTRICH_TEXT != "")
                                strReplacement = translate(OberflaechenschutzTransID["OB_ROH"]);
                        }
                    }
                    if (toupper(strRepVal) == "OBFLSCHUTZ_TYPID")
                        strReplacement = translate(Oberflaechenschutz[this.m_Poberfl]);
                    if ((toupper(strRepVal) == "WERKSTOFF") || (toupper(strRepVal) == "WERKSTOFF_SAT")
						|| (toupper(strRepVal) == "WERKSTOFF_ABE"))
                        strReplacement = Werknamen[this.m_Pwerkstoff];
                    if (toupper(strRepVal) == "WERKSTOFF_SAPID")
                        strReplacement = WerkstoffeSAPid[this.m_Pwerkstoff];
                    if (toupper(strRepVal) == "WERKSTOFF_TYPID")
                        strReplacement = Werkstoffe[this.m_Pwerkstoff];
                    if (toupper(strRepVal) == "WERKSTOFF_ROLLE")
                        strReplacement = this.oData.WERKSTOFF_ROLLE;
					
					if (toupper(strRepVal) == "LAENGE")
                        strReplacement = this.getEmass();
					
					if (toupper(strRepVal) == "FN")
                        strReplacement = this.oData.F_AUFL + " kN";
					
					if (toupper(strRepVal) == "D_AUFL")
                        strReplacement = this.oData.DA;
					
					if (toupper(strRepVal) == "L_SAT")
                        strReplacement = this.strSattellaenge;
					
                    if (this.isHaenger())
                    {
                        if (toupper(strRepVal) == "BLOCKIERUNG")
                        {
                            if (this.m_Pblock == "BLOCK_JA")
                                strReplacement = translate("BLOCKIERUNG_STANDARD");
                            else if (this.m_Pblock == "BLOCK_NEIN")
                                strReplacement = translate("BLOCKIERUNG_OHNE");
                            else if (this.m_Pblock == "BLOCK_MITTIG")
                                strReplacement = translate("BLOCKIERUNG_MITTIG");
                            else
                                strReplacement = "";
                        }
                        if ((toupper(strRepVal) == "TERROSON") || (toupper(strRepVal) == "TERRASON"))
                        {
                            if (this.m_Pbeschicht == "TERROSON")
                                strReplacement = translate("FEDER_TERROSONBESCHICHTET");
                            else
                                strReplacement = "";
                        }
                    }

                    // FW, FK, SN, RICHTUNG
                    if (this.isFHaenger())
                    {
                        if (toupper(strRepVal) == "FW")
                            strReplacement = this.warmlast;
                        if (toupper(strRepVal) == "FK")
                            strReplacement = this.kaltlast;
						if (toupper(strRepVal) == "SSOLL")
                            strReplacement = abs(this.sollweg);
                        if (toupper(strRepVal) == "RICHTUNG")
                        {
                            if (this.sollweg > 0)
                                strReplacement = translate("IDC_LABEL_RICHTUNG_AUF");
                            else
                                strReplacement = translate("IDC_LABEL_RICHTUNG_AB");
                        }
                    }
                    if (this.isHschelle())
                    {
                        if (toupper(strRepVal) == "BSONDERDURCH")
                            strReplacement = this.m_bSonderNennweite;
                    }
                    if (this.isVschelle())
                    {
                        if (toupper(strRepVal) == "BSONDERDURCH")
                            strReplacement = this.m_bSonderNennweite;
                        if (toupper(strRepVal) == "BSONDERSPANN")
                            strReplacement = this.m_bSonderSpannweite;
                    }
                    if (this.isLager())
                    {
                        if (toupper(strRepVal) == "TRAEGBREIT"){
							if (this.strTraegerbreite)
								strReplacement = this.strTraegerbreite;
							else
								strReplacement = theMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamWidth;
						}
                        if (toupper(strRepVal) == "TRAEGHOCH"){
                            if (this.strTraegerhoehe)
								strReplacement = this.strTraegerhoehe;
							else
								strReplacement = theMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamHeight;
						}
						if (toupper(strRepVal) == "DN" && this.strBaureihe == "IKL"){	// vorisolierte Lager haben keine NW in DB
							if (!theMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
								strReplacement = theMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
							else
								strReplacement = translate("SONDER") + "(" + theMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder + ")";
						}
						else if (toupper(strRepVal) == "DN" && rfind(m_wert, "res=") > (-1)){
							strReplacement	= this.oData.oOriginalData.DN;
						}
						if (toupper(strRepVal) == "PFORM")
							strReplacement = translate(theMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamArt);
						if (toupper(strRepVal) == "POS")
							strReplacement	= getstring("POS", "DLGDATA");
						if (toupper(strRepVal) == "TYP_BEZ_LAG"){
							if (this.oData.TYP_CALCULATION)
								strReplacement	= this.oData.TYP_CALCULATION;
							else
								strReplacement	= this.oData.TYP;
						}
						if (toupper(strRepVal) == "WERKSTOFF_LAG")
							strReplacement	= WerkstoffeNrZuNamen[this.oData.WERKSTOFF];
						if (toupper(strRepVal) == "OBFLSCHUTZ_LAG")
							strReplacement	= translate(OberflaechenschutzTransID[this.m_Poberfl]);
                    }
                    if (this.isKlemmsystem())
                    {
                        if (toupper(strRepVal) == "TRAEGBREIT"){
							if (this.strTraegerbreite)
								strReplacement = this.strTraegerbreite;
							else if (this.oData.PROFILFORM == "U" || this.oData.PROFILFORM == "L")
								strReplacement = this.oData.TRAEGERBREITE;
							else
								strReplacement = right(this.m_Ptyp,3);
						}
                        if (toupper(strRepVal) == "TRAEGHOCH")
                            strReplacement = this.strTraegerhoehe;
                        if (toupper(strRepVal) == "BREIT")
                            strReplacement = (!this.strBreite ? this.oData.BREITE : this.strBreite);
                    }
                    if (this.isKHaenger())
                    {
                        if (toupper(strRepVal) == "FK")
                            strReplacement = this.sollast;
                        if (toupper(strRepVal) == "SSOLL")
                            strReplacement = abs(this.sollweg);
                        if (toupper(strRepVal) == "RICHTUNG")
                        {
                            if (this.sollweg > 0)
                                strReplacement = translate("IDC_LABEL_RICHTUNG_AUF");
                            else
                                strReplacement = translate("IDC_LABEL_RICHTUNG_AB");
                        }
                    }
                    if (this.lgv)
                    {
                        if (toupper(strRepVal) == "LGV")
                            strReplacement = this.lgv;
                    }
                    if (left(this.m_Ptypid, 2) == "ZZ")
                    {
                        if (toupper(strRepVal) == "LGR")
                            strReplacement = this.groesse;
                        if (toupper(strRepVal) == "FORM")
                            strReplacement = this.form;
                    }
                    
                    if (((this.m_Ptyp == "LK") || (this.m_Ptypid == "LK1_RH_SO"))
                         && theMainController)
                    {
                        // An der Lastkette sollen auch Werte des Hngers ersetzt werden ....
                        var myHanger = theMainController.topologieKlasse.getCurrentHaenger();
                        if (myHanger && myHanger.isKHaenger())
                        {
                            if (toupper(strRepVal) == "FK")
                                strReplacement = myHanger.sollast;
                            if (toupper(strRepVal) == "SSOLL")
                            {
                                if (myHanger.m_Pblock == "BLOCK_MITTIG")
                                    strReplacement = "+-" + (abs(myHanger.sollweg) / 2);
                                else{
                                    //strReplacement = abs(myHanger.sollweg);
                                    strReplacement = (myHanger.sollweg_ab*1 != 0 ? "-" + myHanger.sollweg_ab : "");
									if (strReplacement != "" && myHanger.sollweg_auf*1 != 0)
										strReplacement	+= "/";
									strReplacement	+= (myHanger.sollweg_auf*1 != 0 ? "+" + myHanger.sollweg_auf : "");
								}
                            }
                            if (toupper(strRepVal) == "RICHTUNG")
                            {
                                if (myHanger.m_Pblock == "BLOCK_MITTIG" || rfind(strResult, "/") > (-1))
                                    strReplacement = "";
                                else if (myHanger.sollweg > 0)
                                    strReplacement = translate("IDC_LABEL_RICHTUNG_AUF");
                                else
                                    strReplacement = translate("IDC_LABEL_RICHTUNG_AB");
                            }
                        }
                        if (myHanger && myHanger.isFHaenger())
                        {
                            if (toupper(strRepVal) == "FW")
							{
								if ((myHanger.warmlast2) && (myHanger.warmlast2 > 0)){
									if (myHanger.warmlast2*1 >= myHanger.warmlast*1)
										strReplacement = myHanger.warmlast2 + "/" + myHanger.warmlast;
									else
										strReplacement = myHanger.warmlast + "/" + myHanger.warmlast2;
								}
								else
									strReplacement = myHanger.warmlast;
							}
                            if (toupper(strRepVal) == "FK")
                                strReplacement = myHanger.kaltlast;
                            if (toupper(strRepVal) == "SSOLL")
                            {
                                if (myHanger.m_Pblock == "BLOCK_MITTIG")
                                    strReplacement = "+-" + (abs(myHanger.sollweg) / 2);
                                else if (myHanger.strSollwege == "")
                                    strReplacement = abs(myHanger.sollweg);
								else
									strReplacement = myHanger.strSollwege;
                            }
                            if (toupper(strRepVal) == "RICHTUNG")
                            {
								if (myHanger.m_Pblock == "BLOCK_MITTIG" || rfind(myHanger.strSollwege, "/") > (-1))
                                    strReplacement = "";
                                else if (myHanger.sollweg > 0)
                                    strReplacement = translate("IDC_LABEL_RICHTUNG_AUF");
                                else
                                    strReplacement = translate("IDC_LABEL_RICHTUNG_AB");
                            }
                        }
                        if (myHanger && myHanger.isHaenger())
                        {
                            if (toupper(strRepVal) == "BLOCKIERUNG")
                            {
                                if (myHanger.m_Pblock == "BLOCK_JA")
                                    strReplacement = translate("BLOCKIERUNG_STANDARD");
                                else if (myHanger.m_Pblock == "BLOCK_NEIN")
                                    strReplacement = translate("BLOCKIERUNG_OHNE");
                                else if (myHanger.m_Pblock == "BLOCK_MITTIG")
                                    strReplacement = translate("BLOCKIERUNG_MITTIG");
                                else
                                    strReplacement = "";
                            }
                            if ((toupper(strRepVal) == "TERROSON") || (toupper(strRepVal) == "TERRASON"))
                            {
                                if (myHanger.m_Pbeschicht == "TERROSON")
                                    strReplacement = translate("FEDER_TERROSONBESCHICHTET");
                                else
                                    strReplacement = "";
                            }
                        }
                        if (myHanger && (! myHanger.isHaenger()))
                        {
                            if (toupper(strRepVal) == "FK"){
                                var AchsDirInfo		= theMainController.dataAccess.getAchsKSInfo();
								strReplacement = theMainController.dataAccess.getSollwerteLast("vertikal-", 0, AchsDirInfo[6]);
							}
						}
                    }
					if (toupper(strRepVal) == "GKP"){
						if (left(getstring("TYP", "TMP.ZB_ADDITIONAL_DATA"), 3) == "MBW"){
							strReplacement = max((getstring("T", massPath)*2) + (getstring("A", "TMP.ZB_ADDITIONAL_DATA")*1),
													(getstring("G", massPath)*1) + 15);
						}
						else{
							strReplacement = getstring("G_", massPath);
						}
					}

                }

                // Korrektur "WERKSTOFF" bei Lagern (Zahlen zu Texten)
				if (strRepVal == "WERKSTOFF" && atoi(strReplacement))
					strReplacement = WerkstoffeNrZuNamen[strReplacement];
				
				// Ersetze den Wert in Kopie des bergebenen Params (damit wir mit i nicht durcheinander kommen!)
                strResult = replace(strResult, "{"+strRepVal+"}", strReplacement);

                strRepVal = "";
                nDepth--;
            }

            if (nDepth > 0)
                strRepVal = strRepVal + m_wert.charAt(i);

            if (m_wert.charAt(i) == "{")
            {
                nDepth++;
                if (nDepth > 1)
                    alert("Fehler 2 in Stuecklistendaten: geschachtelte Klammern");
            }
        }
        // acos statt arcos ... soll das Grad oder Bogenmass sein?
        // var test = "var ALPH=acos((30+5*25)/(600+1+5*25)); var res=1140+(600+1+5*25)*(ALPH-sin(ALPH));"
        // var x = eval(test);


        logtrace("REPLACE '"+m_wert+"' -> '"+strResult+"'" + "\n");
        logtraceflush();
        return strResult;
    },

    getMass : function(tmpPath, strMassName)
    {
        var strValue = getstring(strMassName, tmpPath);

		// Warum benutzt Du immer noch die alten globalen Funktionen ??
		// strMassName.toUpperCase()

        if (! strValue)
            strValue = getstring(toupper(strMassName), tmpPath);

        return inputStringToDouble(strValue);
    },

    setMass : function(tmpPath, strMassName, dMassWert)
    {
        setdouble(strMassName, tmpPath, dMassWert);
    },

    setMassString : function(stkMasse, tmpPath, stkMasseNamen)
    {
        var strMassString = "", strMassName = "";
        for (var i = 0; i < stkMasse.length; ++i)
        {
            if (stkMasseNamen)
                strMassName = stkMasseNamen[i];
            else
                strMassName = stkMasse[i];
            strMassString = strMassString + strMassName + " " + this.getMass(tmpPath, stkMasse[i]) + " ";
        }
        this.m_strMasse = strMassString;
    },

    getPreiszuschlagSonder : function(strKlasse, strTyp, strBauf)
    {
        var dRet = 1;
        var strSQLStatement = "select * from PREISZUSCHL_SON where KLASSE='"+strKlasse+"' and TYP='"+strTyp+"' and BAUF='"+strBauf+"' ";
        var numRet = dbselect("SAP_V", strSQLStatement, "PREISZUSCHL_SON");
        if (numRet > 0)
        {
            dRet = dbgetdouble("PREISZUSCHL_SON", "SONDER_P");
        }
        return dRet;
    },
    
    getNettoPreis : function(dPreis, strRabattTyp)
    {
        var dRabattFaktor = 0;
        // damit wir nicht einen Verweis auf den Maincontroller durch alle Funktionen schleppen mssen ...
        // (Achtung: im Kontext Projektliste etc. kann es temporre MainController geben!)
        var presets = new CaPresets();
        if (!presets)
            return dPreis;

        switch (strRabattTyp) {
        case "RABATT_TYP_FH1":
            dRabattFaktor = presets.FH_BIS_11_RAB;
            break;
        case "RABATT_TYP_FH2":
            dRabattFaktor = presets.FH_AB_12_RAB;
            break;
        case "RABATT_TYP_SCHELLEN":
            dRabattFaktor = presets.SCHELLE_RAB;
            break;
        case "RABATT_TYP_LAGER":
            dRabattFaktor = presets.LAGER_RAB;
            break;
        case "RABATT_TYP_KH1":
            dRabattFaktor = presets.KH_BIS_12_RAB;
            break;
        case "RABATT_TYP_KH2":
            dRabattFaktor = presets.KH_AB_13_RAB;
            break;
        case "RABATT_TYP_ZKX":
            dRabattFaktor = presets.ZKX_RAB;
            break;
        case "RABATT_TYP_TRAV":
            dRabattFaktor = presets.TRAV_RAB;
            break;
        case "RABATT_TYP_SSG":
            dRabattFaktor = presets.SSG_RAB;
            break;
        /* Stobremse noch nicht implementiert
        case "RABATT_TYP_SSB":
            dRabattFaktor = presets.m_ssb;
            break;
        */
        case "RABATT_TYP_VTEILE":
            dRabattFaktor = presets.VERB_RAB;
            break;
        case "RABATT_TYP_MBS":
            dRabattFaktor = presets.MBS_RAB;
            break;
        default :
            dRabattFaktor = 0;
        }
        if (((getstring("REBATES_EDITABLE", "RIGHTS")*1) && (dRabattFaktor <= 99)) ||	// bei "RE1" auch neg. Werte zulassen
			((dRabattFaktor <= 99) && (dRabattFaktor >= 1)))	// alle anderen nur pos. Werte
		{
			var dNettoPreis = fround(dPreis * (1 - (dRabattFaktor / 100)), 2);
            return dNettoPreis;
		}
		else
			return dPreis;
		/*
		if ((dRabattFaktor > 99) || (dRabattFaktor < 1))
            return dPreis;
        else
        {
            var dNettoPreis = fround(dPreis * (1 - (dRabattFaktor / 100)), 2);
            return dNettoPreis;
        }
		*/
    }

}
