/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaPresets = function()
{
    var strSettingspath = "PROJECT.SETTINGS.CASCADE";

	/**
     * fhminproz ... Mindestwegreserve FH in Prozent des Sollwegs
     * @var fhminproz
     */
	this.fhminproz = getstring("FH_MINDESTWEGRESERVE_PROZ", strSettingspath);   // 20;
	/**
     * fhminweg ... Mindestwegreserve FH als absolute Untergrenze in mm
     * @var fhminweg
     */
	this.fhminweg  = getstring("FH_MINDESTWEGRESERVE_ABS", strSettingspath);    //  5;
	/**
     * lastabw ... Max. zulssige Lastabweichung FH in Prozent
     * @var lastabw
     */
    this.lastabw   = getstring("FH_PROZ_LASTAENDERUNG", strSettingspath);   // 25;
    
	/**
     * richtungSoll ... Richtung der Bewegung bei Hngerauslegung (warm / kalt) 
     * ... Ca 3.4 Variable "soll" ... Sollast ist Kaltlast oder Warmlast
     * @var richtungSoll
     */
    this.richtungSoll = "SOLL_KALT";    // SOLL_WARM 
    if (getstring("SOLLAST_IST", strSettingspath) == "IDC_RADIO_SOLLAST_WARM")
        this.richtungSoll = "SOLL_WARM";
        
	/**
     * m_nFhBlock ... Blocierung ja/nein bei FH
     * @var m_nFhBlock
     */
    this.m_nFhBlock = "BLOCK_JA";
    if (getstring("FH_BLOCKIERUNG", strSettingspath) == "IDC_FH_BLOCKNEIN_RADIOBUTTON")
        this.m_nFhBlock = "BLOCK_NEIN";
    else if (getstring("FH_BLOCKIERUNG", strSettingspath) == "IDC_FH_BLOCKMITTIG_RADIOBUTTON")
        this.m_nFhBlock = "BLOCK_MITTIG";
        
	/**
     * m_nKhBlock ... Blocierung ja/nein bei KH
     * @var m_nKhBlock
     */
    this.m_nKhBlock = "BLOCK_JA";
    if (getstring("KH_BLOCKIERUNG", strSettingspath) == "IDC_KH_BLOCKNEIN_RADIOBUTTON")
        this.m_nKhBlock = "BLOCK_NEIN";
    else if (getstring("KH_BLOCKIERUNG", strSettingspath) == "IDC_KH_BLOCKMITTIG_RADIOBUTTON")
		this.m_nKhBlock = "BLOCK_MITTIG";

	/**
     * TERROSON_ ... Federn mit / ohne Terrosonbeschichtung: Default = ohne
     * @var TERROSON_
     */
    if (toupper(getstring("TERROSON_KH", strSettingspath)) == "TRUE")
        this.TERROSON_KH    = true;
    else
        this.TERROSON_KH    = false;
    if (toupper(getstring("TERROSON_FH", strSettingspath)) == "TRUE")
        this.TERROSON_FH    = true;
    else
        this.TERROSON_FH    = false;
	
	// Auswahl Lager-NH ALT - bis 2022 NEU - ab 2023
	if (!getstring("IDC_RADIO_LG_ALT_NEU", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_RADIO_LG_ALT_NEU", "PROJECT.SETTINGS.CASCADE", "IDC_POS_LG_NEU_RADIOBUTTON");
	
	/**
     * Auslegung von LISEGA-Gelenkstreben
	 * Default("VS") = false // Default("VC") = true wg. fehlender bergabe von PSS PDMS-Bauteilen -> entfllt wenn Interface korrigiert
     * @var SSG_LI_PART
     */
    /*
	if (!getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")){
		// Datenbankabfrage weil wir die Recht noch nicht kennen
		var strSQLStatement	= 'select * from RIGHTS where "CODE" = "VS" ';
		var numRet			= dbselect("SYS", strSQLStatement, "SYS");
		if (numRet)
			setstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE", "false");
		else
			setstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE", "true");
	}
	*/
	// wird nicht aus INI gezogen - falls noch nicht vorhanden -> neu setzen
	if (getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE") == "")
		setstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE", "false");
	
	/**
     * Defaults fr FIN-Import mit Vorgabewerten
     * @var 
     */
	if (typeof(Object.fromStorage( "PROJECT.SETTINGS.FINDEFAULTS")) != 'object'){
		// Hnger und Sttzen
		//setstring("IDC_HANGER_BASETYP_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_RADIO_BASETYP_FH");
		setstring("IDC_LAGER_BASETYP_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_SPG_CHECK");
		//setstring("IDC_STUETZE_BASETYP_IST",			"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_RADIO_BASETYP_FS");
		setstring("IDC_HANGER_TYP_KH_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_KHD_CHECK");
		setstring("IDC_STUETZE_TYP_KS_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_KSP_CHECK");
		setstring("IDC_HANGER_TYP_FH_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_FHD_CHECK");
		setstring("IDC_STUETZE_TYP_FS_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_FSS_CHECK");
		setstring("IDC_HANGER_TYP_SH_IST",				"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_ZSM_CHECK");
		setstring("IDC_FDT_CHECK",						"PROJECT.SETTINGS.FINDEFAULTS",	"false");
		setstring("IDC_MIN_SYSTEMMASS_HAENGEND_EDIT",	"PROJECT.SETTINGS.FINDEFAULTS",	"2000");
		setstring("IDC_MIN_SYSTEMMASS_STUETZEND_EDIT",	"PROJECT.SETTINGS.FINDEFAULTS",	"800");
		setstring("IDC_MIN_SPANNWEITE_EDIT",			"PROJECT.SETTINGS.FINDEFAULTS",	"1000");
		setstring("IDC_TYP_TRAEGERANSCHLUSS_IST",		"PROJECT.SETTINGS.FINDEFAULTS",	"IDC_SCHWEISS_CHECK");
		
		var strSQL			= "select * from PROFILART order by abs(SEQ_ID) ";
		var TypComboSelect	= "";
		var TypComboValues	= "";
		var FirstValue		= 1;
		dbselect("CASCADE", strSQL, "PROFILART");
		while ( dbiseof("PROFILART") == 0){
			TypComboValues	+= dbgetstring("PROFILART", "ID") + "=" + dbgetstring("PROFILART", "PROFILART") + "|";
			if (FirstValue){
				TypComboSelect	= dbgetstring("PROFILART", "ID");
				FirstValue		= 0;
			}
			dbskip( "PROFILART" );
		}
		TypComboValues	= trimright(TypComboValues, "|");
		setstring("IDC_TYP_TRAEGER_COMBO",			"PROJECT.SETTINGS.FINDEFAULTS",	TypComboSelect);
		setstring("IDC_TYP_TRAEGER_VALUES",			"PROJECT.SETTINGS.FINDEFAULTS",	TypComboValues);
		
		var TypTraeger	= TypComboSelect.replace("PROFIL", "_A");
		strSQL	= "select * from TRAEGER_" + TypTraeger + " order by abs(KUERZEL) ";
		var SubtypComboSelect	= "";
		var SubtypComboValues	= "";
		FirstValue				= 1;
		dbselect("CASCADE", strSQL, "TR_KUERZEL");
		while ( dbiseof("TR_KUERZEL") == 0){
			SubtypComboValues	+= dbgetstring("TR_KUERZEL", "KUERZEL") + "=" + dbgetstring("TR_KUERZEL", "KUERZEL") + "|";
			if (FirstValue){
				SubtypComboSelect	= dbgetstring("TR_KUERZEL", "KUERZEL");
				FirstValue		= 0;
			}
			dbskip( "TR_KUERZEL" );
		}
		SubtypComboValues	= trimright(SubtypComboValues, "|");
		setstring("IDC_SUBTYP_TRAEGER_COMBO",			"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboSelect);
		setstring("IDC_SUBTYP_TRAEGER_VALUES",			"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboValues);
		// Lager
		setstring("IDC_NENNHOEHE_RST_SPG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_RST_SPG_150");
		setstring("IDC_NENNHOEHE_RST_SSG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_RST_SSG_150");
		setstring("IDC_NENNHOEHE_RST_EPG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_RST_EPG_143");
		setstring("IDC_NENNHOEHE_SON_SPG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_SON_SPG_NV");
		setstring("IDC_NENNHOEHE_SON_SSG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_SON_SSG_200");
		setstring("IDC_NENNHOEHE_SON_EPG_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	"NH_SON_EPG_193");
		setstring("IDC_TYP_TRAEGER_LAGER_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	TypComboSelect);
		setstring("IDC_TYP_TRAEGER_LAGER_VALUES",		"PROJECT.SETTINGS.FINDEFAULTS",	TypComboValues);
		
		strSQL			= "select * from PROFILART ";
		TypComboSelect	= "";
		TypComboValues	= "";
		FirstValue		= 1;
		dbselect("LAGER2", strSQL, "PROFILART");
		while ( dbiseof("PROFILART") == 0){
			TypComboValues	+= dbgetstring("PROFILART", "ID") + "=" + dbgetstring("PROFILART", "PROFILART") + "|";
			if (FirstValue){
				TypComboSelect	= dbgetstring("PROFILART", "ID");
				FirstValue		= 0;
			}
			dbskip( "PROFILART" );
		}
		TypComboValues	= trimright(TypComboValues, "|");
		setstring("IDC_TYP_TRAEGER_LAGER_COMBO",	"PROJECT.SETTINGS.FINDEFAULTS",	TypComboSelect);
		setstring("IDC_TYP_TRAEGER_LAGER_VALUES",	"PROJECT.SETTINGS.FINDEFAULTS",	TypComboValues);
		
		//TypTraeger	= TypComboSelect.replace("PROFIL", "_A");
		strSQL	= "select * from " + TypComboSelect + " order by abs(B) ";
		SubtypComboSelect	= "";
		SubtypComboValues	= "";
		FirstValue				= 1;
		dbselect("LAGER2", strSQL, "TR_KUERZEL");
		while ( dbiseof("TR_KUERZEL") == 0){
			SubtypComboValues	+= dbgetstring("TR_KUERZEL", "TRAE_GR") + "=" + dbgetstring("TR_KUERZEL", "TRAE_GR") + "|";
			if (FirstValue){
				SubtypComboSelect	= dbgetstring("TR_KUERZEL", "TRAE_GR");
				FirstValue		= 0;
			}
			dbskip( "TR_KUERZEL" );
		}
		SubtypComboValues	= trimright(SubtypComboValues, "|");
		setstring("IDC_SUBTYP_TRAEGER_LAGER_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboSelect);
		setstring("IDC_SUBTYP_TRAEGER_LAGER_VALUES",	"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboValues);
	}
	
	/**
     * khminproz ... Mindestwegreserve KH in Prozent des Sollwegs
     * @var khminproz
     */
    this.khminproz   = getstring("KH_MINDESTWEGRESERVE_PROZ", strSettingspath); // 10;
	/**
     * khminweg ... Mindestwegreserve KH als absolute Untergrenze in mm
     * @var khminweg
     */
    this.khminweg    = getstring("KH_MINDESTWEGRESERVE_ABS", strSettingspath);  // 10;
	/**
     * justkonst ... Min. Lastjustierbarkeit KH in Prozent
     * @var justkonst
     */
    this.justkonst   = getstring("KH_LASTJUSTIERBARKEIT", strSettingspath); // 15;

	/**
     * m_nSSGMindestverstellreserve ... f. Produkt SSG
     * @var m_nSSGMindestverstellreserve
     */
    this.m_nSSGMindestverstellreserve = getstring("GSTREBE_MINDESTVERSTELLRESERVE", strSettingspath);
    
	/**
     * m_nGewindestangenPassMin ... Gewindestangen Zugabe min
     * @var m_nGewindestangenPassMin
     */
    this.m_nGewindestangenPassMin = getstring("GEWSTANGPASSMIN", strSettingspath);
    
	/**
     * m_nGewindestangenPassRund ... Gewindestangen aufrunden auf ...
     * @var m_nGewindestangenPassRund
     */
    this.m_nGewindestangenPassRund = getstring("GEWSTANGPASSRUND", strSettingspath);

	/**
     * m_nGewindestangenStandardLaenge ... 2000 oder 3000 mm
     * @var m_nGewindestangenStandardLaenge
     */
    this.m_nGewindestangenStandardLaenge = "GEW_STDLEN_2000";
    if (getstring("GEWST_DEF_LEN", strSettingspath) == "IDC_RADIO_GEWST_DEF_LEN_3000")
        this.m_nGewindestangenStandardLaenge = "GEW_STDLEN_3000";
        
	/**
     * m_nGewinde ... Vorgabe fr Gewindeprodukte DIN oder Zoll
     * @var m_nGewinde
     */
    this.m_nGewinde = "GEWINDE_DIN";
    if (getstring("GEWINDE_ANSCHLUSS", strSettingspath) == "IDC_POS_GEWZOLL_RADIOBUTTON")
        this.m_nGewinde = "GEWINDE_ZOLL";
    
	/**
     * m_grenz ... Vorgabe welche Grenztemp. zur werkstofbezogenen Eignung benutzt werden
     * @var m_grenz
     */    
    this.m_grenz = "GRENZT_VGB";
    if (getstring("GRENZ_TEMP", strSettingspath) == "IDC_RADIO_GRENZ_TEMP_REGELWERKE")
        this.m_grenz = "GRENZT_WIT";
	// d.h. auch fuer ASME werden die VGB-Grenzen gesetzt

	/**
     * m_maxSchraegLK ... Max erlaubte Schregung der Lastkette (vertikal) - nicht Schrge des Rohrs!
     * @var m_maxSchraegLK
     */    
    this.m_maxSchraegLK = getstring("SCHRAEGZUG", strSettingspath);

	/**
     * m_VorspannungStrategie ... 
     * @var m_VorspannungStrategie
     */    
    /*
	this.m_VorspannungStrategie = "IDC_RADIO_VORSPANNUNG_OHNE";
    if (getstring("VORSPANNUNG", strSettingspath) == "IDC_RADIO_VORSPANNUNG_MAXIMAL")
        this.m_VorspannungStrategie = "IDC_RADIO_VORSPANNUNG_MAXIMAL";
    if (getstring("VORSPANNUNG", strSettingspath) == "IDC_RADIO_VORSPANNUNG_MEDIUM")
        this.m_VorspannungStrategie = "IDC_RADIO_VORSPANNUNG_MEDIUM";
	*/
	
	// Vorspannung axial und lateral
	
	if (!getstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_RADIO_VORSPANNUNG_AX", "PROJECT.SETTINGS.CASCADE", "IDC_RADIO_VORSPANNUNG_OHNE_AX");
	
	if (!getstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_RADIO_VORSPANNUNG_LAT", "PROJECT.SETTINGS.CASCADE", "IDC_RADIO_VORSPANNUNG_OHNE_LAT");
		
	// Koordinatensystem
	
	if (!getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE", "IDC_VERTIKALDIR_ACHS_DEF_Z");
	
	if (!getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE", "IDC_VERTIKALDIR_DEF_AUF");
	
	if (!getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"))
		setstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE", "RH_KOORD_VZ_Var1");
	
	// Vorspannungsrichtungen
	var VertiDir		= toupper(right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"),1));
		if (VertiDir == "Z")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "X");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Y");
			}
		else if (VertiDir == "Y")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "X");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Z");
			}
		else if (VertiDir == "X")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "Y");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Z");
			}
		else
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "");
			}
		
	/**
     * Vorgaben Defaultwerte Oberflchenschutz
     * @var ...
     */    
    this.OBFL_SCHEL1    = getstring("OBFL_SCHEL1", strSettingspath);
    this.OBFL_SCHEL2    = getstring("OBFL_SCHEL2", strSettingspath);
    this.OBFL_SCHEL3    = getstring("OBFL_SCHEL3", strSettingspath);
    this.OBFL_SCHEL4    = getstring("OBFL_SCHEL4", strSettingspath);
    this.OBFL_HAENGER   = getstring("OBFL_HAENGER", strSettingspath);
    this.OBFL_STREBEN   = getstring("OBFL_STREBEN", strSettingspath);
    this.OBFL_VERBTEILE = getstring("OBFL_VERBTEILE", strSettingspath);
    this.OBFL_ZKX       = getstring("OBFL_ZKX", strSettingspath);
    this.OBFL_LASCHEN   = getstring("OBFL_LASCHEN", strSettingspath);
    this.OBFL_TRAVERSEN = getstring("OBFL_TRAVERSEN", strSettingspath);

	/**
     * Vorgaben Prfung und Dokumentation
     * @var ...
     */    
    this.KENNZEICHNUNG_HAENG    = getstring("KENNZEICHNUNG_HAENG", strSettingspath);
    this.KENNZEICHNUNG_GSTREBEN = getstring("KENNZEICHNUNG_GSTREBEN", strSettingspath);
    this.KENNZEICHNUNG_ANDERE   = getstring("KENNZEICHNUNG_ANDERE", strSettingspath);
    this.KENNZEICHNUNG_POSITIONIERUNG = getstring("KENNZEICHNUNG_POSITIONIERUNG", strSettingspath);
    this.LASTWEG_PROT_FH        = getstring("LASTWEG_PROT_FH", strSettingspath);
    this.LASTWEG_PROT_KH        = getstring("LASTWEG_PROT_KH", strSettingspath);
    this.PRUEFBESCH_PROD_21     = getstring("PRUEFBESCH_PROD_21", strSettingspath);
    this.PRUEFBESCH_PROD_22     = getstring("PRUEFBESCH_PROD_22", strSettingspath);
    this.PRUEFBESCH_FEDERN      = getstring("PRUEFBESCH_FEDERN", strSettingspath);
    this.PRUEFBESCH_WARMFEST    = getstring("PRUEFBESCH_WARMFEST", strSettingspath);
    this.PRUEFBESCH_AUSTENIT    = getstring("PRUEFBESCH_AUSTENIT", strSettingspath);

	/**
     * Vorgaben Rabatte in Prozent
     * @var ...
     */    
    this.FH_BIS_11_RAB      = getstring("FH_BIS_11_RAB", strSettingspath);
    this.FH_AB_12_RAB       = getstring("FH_AB_12_RAB", strSettingspath);
    this.KH_BIS_12_RAB      = getstring("KH_BIS_12_RAB", strSettingspath);
    this.KH_AB_13_RAB       = getstring("KH_AB_13_RAB", strSettingspath);
    this.SCHELLE_RAB        = getstring("SCHELLE_RAB", strSettingspath);
    this.LAGER_RAB          = getstring("LAGER_RAB", strSettingspath);	// -mw- 10.7.2012 neu
    this.VERB_RAB           = getstring("VERB_RAB", strSettingspath);
    this.ZKX_RAB            = getstring("ZKX_RAB", strSettingspath);
    this.TRAV_RAB           = getstring("TRAV_RAB", strSettingspath);
    this.SSG_RAB            = getstring("SSG_RAB", strSettingspath);
    this.MBS_RAB            = getstring("MBS_RAB", strSettingspath);

    this.LASTWEG_RAB        = getstring("LASTWEG_RAB", strSettingspath);
    this.PRUEFBESCH_RAB     = getstring("PRUEFBESCH_RAB", strSettingspath);
    this.VORMONTAGE_RAB     = getstring("VORMONTAGE_RAB", strSettingspath);
    this.POSITIONIERUNG_RAB = getstring("POSITIONIERUNG_RAB", strSettingspath);

};


CaPresets.prototype = 
{
    getPreisOptions : function()
    {
        var retObj = { TERROSON_KH : 0, 
                       TERROSON_FH : 0,
                       ZUSATZLEISTUNG_TEXT : "",
                       ZUSATZLEISTUNG_KOSTEN : 0,
                       SONDERANSTRICH_TEXT : "",
                       SONDERANSTRICH_KOSTEN : 0
                       };

        if (this.TERROSON_KH)
            retObj.TERROSON_KH = 1;
        if (this.TERROSON_FH)
            retObj.TERROSON_FH = 1;
            
        var strZusatzleistung       = getstring("WI_ZUSATZLEISTUNG",        "PROJECT.SETTINGS");
        var strKostenZusatzleistung = getstring("WI_ZUSATZLEISTUNG_KOSTEN", "PROJECT.SETTINGS");
        var nKostenZusatzleistung   = fround(strKostenZusatzleistung, 2);
        if ((strZusatzleistung != "") || (nKostenZusatzleistung != 0))
        {
            retObj.ZUSATZLEISTUNG_TEXT = strZusatzleistung;
            retObj.ZUSATZLEISTUNG_KOSTEN = nKostenZusatzleistung;
        }
        var strSonderanstrich       = getstring("WI_SONDERANSTRICH",        "PROJECT.SETTINGS");
        var strKostenSonderanstrich = getstring("WI_SONDERANSTRICH_KOSTEN", "PROJECT.SETTINGS");
        var nKostenSonderanstrich   = fround(strKostenSonderanstrich, 2);
        if ((strSonderanstrich != "") || (nKostenSonderanstrich != 0))
        {
            retObj.SONDERANSTRICH_TEXT = strSonderanstrich;
            retObj.SONDERANSTRICH_KOSTEN = nKostenSonderanstrich;
        }

        return retObj;
    }

};

