/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */

var caOldLogicIds = {
	DEFAULT : "0",
	FHG : "1",
	FHD : "2",
	FHS : "3",
	FSS : "4",
	FSG : "5",
	FDT : "6",
	FSP : "7",
	KHD : "8",
	KVD : "9",
	KHS : "10",
	KVS : "11",
	KSR : "12",
	KSP : "13",
	LUR : "14",
	LRN : "15",
	HZN : "16",
	HZV : "17",
	HZS : "18",
	HDN : "19",
	HGN : "20",
	HGV : "21",
	TRG : "22",
	VBK : "23",
	VKK : "24",
	VJK : "25",
	VJR : "26",
	VKR : "27",
	ZGM : "28",
	ZHM : "29",
	// ZKN : "30",
	ZKK : "31",
	ZLK : "32",
	ZLN : "33",
	ZLM : "34",
	ZMM : "35",
	ZOM : "36",
	ZPK : "37",
	ZRM : "38",
	ZSM : "39",
	ZTN : "40",
	ZVN : "41",
	ZVV : "42",
	ZVS : "43",
	SON : "44",
	ZWI : "45",
	HDV : "46",
	HDS : "47",
	HBN : "48",
	HBV : "49",
	HBS : "50",
	SSG : "51",
	MSN : "52",
	MBS : "53",
	STF : "54",
	LTD : "55",
	LUS : "56",
	VGR : "57",
	VSK : "58",
	VSR : "59",
	VPK : "60",
	VPR : "61",
	ZZF : "62",
	ZZK : "63",
	ZKB : "65",
	ZKN_1 : "66",
	ZKN_2 : "30",
	LGA : "68",
	LGV : "69",
	ZLV : "67",
	ZLB : "70",
	LSL21 : "71",
	LSL22 : "72",
	LXL22 : "73",
	LXL21 : "74",
	LSL20 : "75",
	LKL20 : "76",
	LKL21 : "77",
	LKL22 : "78",
	LKL23 : "79",
	LSL23 : "80",
	LXL23 : "81",
	LXL24 : "82",
	LSL24 : "83",
	FLN21 : "84",
	FLN20 : "85",
	FLN22 : "86",
	FLN23 : "87",
	KOT : "88",
	KOU : "89",
	KOL : "90",
	KZT : "91",
	KZU : "92",
	KZL : "93",
	KAT : "94",
	KXT40 : "95",
	KXU40 : "96",
	KXL40 : "97",
	LKG20 : "98",
	LKG21 : "99",
	LKG22 : "100",
	LKG23 : "101",
	LKG40 : "102",
	LKG41 : "103",
	LKG42 : "104",
	LKG43 : "105",
	KPT12 : "106",
	KPT16 : "107",
	FSN01 : "108",
	FSN02 : "108",
	FSD01 : "109",
	FSD02 : "109",
    IKL21 : "110",
    IKL23 : "111",
    IKG21 : "112",
    IKG23 : "113",
    FLV22 : "114",
    FLV23 : "115",
    LVL20 : "116",
    LVL21 : "117",
    LVL22 : "118",
    LVL23 : "119",
    LVG20 : "120",
    LVG21 : "121",
    LVG22 : "122",
    LVG23 : "123",
    FVN20 : "124",
    FVN21 : "125",
    FVN22 : "126",
    FVN23 : "127",
	LVL40 : "128",
	LVL41 : "129",
	LVL42 : "130",
	LVL43 : "131",
	LVG40 : "132",
	LVG41 : "133",
	LVG42 : "134",
	LVG43 : "135",
	LKF21 : "136",
	LKF31 : "137",
	LKF41 : "138",
	LKF51 : "139",
	LKF61 : "140",
	LKF22 : "141",
	LKF32 : "142",
	LKF42 : "143",
	LKF52 : "144",
	LKF62 : "145",
	LKF23 : "146",
	LKF33 : "147",
	LKF43 : "148",
	LKF53 : "149",
	LKF63 : "150",
	LSF21 : "151",
	LSF31 : "152",
	LSF41 : "153",
	LSF51 : "154",
	LSF61 : "155",
	LSF22 : "156",
	LSF32 : "157",
	LSF42 : "158",
	LSF52 : "159",
	LSF62 : "160",
	LSF23 : "161",
	LSF33 : "162",
	LSF43 : "163",
	LSF53 : "164",
	LSF63 : "165",
	LSF24 : "166",
	LSF34 : "167",
	LSF44 : "168",
	LSF64 : "169",
	LXF24 : "170",
	LXF34 : "171",
	LXF44 : "172",
	LXF54 : "173",
	LXF64 : "174",
	LXF23 : "175",
	LXF33 : "176",
	LXF43 : "177",
	LXF53 : "178",
	LXF63 : "179",
	LXF22 : "180",
	LXF32 : "181",
	LXF42 : "182",
	LXF52 : "183",
	LXF62 : "184",
	LXF21 : "185",
	LXF31 : "186",
	LXF41 : "187",
	LXF51 : "188",
	LXF61 : "189",
	LKL40 : "190",
	LKL41 : "191",
	LKL42 : "192",
	LKL43 : "193",
	LKL10 : "194",
	LKG10 : "195",
	FLN10 : "196",
	FLN11 : "197",
	LXA21 : "198",
	LXA22 : "199",
	LXA23 : "200",
	LXA24 : "201",
	LXV21 : "202",
	LXV22 : "203",
	LXV23 : "204",
	LXV24 : "205",
	LSW20 : "206",
	LSW21 : "207",
	LSW22 : "208",
	LSW23 : "209",
	LSW24 : "210",
	ZGW	  : "211",
	LAW   : "212",
	LBN   : "213",
	MBW   : "214",
	SSB   : "215"
};

	// Typ der Auslegung
var caOldLastkettenTyp = {
	A_LASTKETTE : "0",
	A_HAENGER : "1",
	A_SCHELLE : "2",
	A_STAUFFSCHELLE : "3",
	A_ZUBEHOER : "4"
};

	// Lastkette
var caOldLastkette = {
	FEDER : "0",
	STARR : "1",
	KONSTANT : "2",
	GSTUETZE : "3",
	GSTREBE : "4",
	GSTAUFF : "5"
};
    // Rohrverlauf
var caOldRohrverlauf = {
	HORIZONTAL : "0",
	VERTIKAL : "1",
	KEIN_RUT : "2"
};
	// Lastabtragung
var caOldLastabtragung = {
	STUETZEND : "0",
	EINFACH : "1",
	DOPPELT : "2",
	STUETZEND_DOPPEL : "3"
};

 
CaPdmsManager = function(myMainController)
{
	/**
     * myMainController ... Verweis auf einen MainController
     * @var myMainController
     */
	this.myMainController = myMainController;

    
};


CaPdmsManager.prototype = 
{
    getPDMSLogicIDforProduct : function(produkt)
    {
		// Normalfall:
		var TypIdForSearch = produkt.m_Ptypid;
		
		// Ausnahme ZKN:
		if (produkt.m_Ptypid == "ZKN")
			TypIdForSearch = produkt.subtyp;	// ZKN_1, ZKN_2, ZKB
			
		// Bei Lagern Typ genau wie im 3D-CAD:
		if (produkt.isLager())		
			TypIdForSearch = produkt.strBaureihe + produkt.strBauF;
        if (produkt.m_Ptypid == "LUR")
            TypIdForSearch = "LUR";

		return caOldLogicIds[TypIdForSearch];
	},
	
	writeFINfromCAESAR : function(RESTRAINTS, VertiAchs, strMDBPath, strMDBFileName)
    {
		var FINPath	= strMDBPath + "FIN";
		if (!FileName.dirExists(FINPath))
			FileName.createDir(FINPath);
		if (FileName.dirExists(FINPath)){	// Schreibrechte vorhanden
			FINPath	+= "\\FIN_from_" + strMDBFileName + "MDB_" + getstring("DATE", "").replace(".", "") + "_" + getstring("TIME", "").replace(":", "");
			FileName.createDir(FINPath);
		}
		else{
			FINPath = dirdialog(translate("Select folder for importfiles created from MDB"), strMDBPath);
			var i	= -1;
		}
		
		if (FINPath != ""){
			for (var i = 0; i < RESTRAINTS.length; i++){
				var Datei = FINPath + "\\" + RESTRAINTS[i].NODE_NUM + ".fin";
				this.WriteDateiSection(Datei, "GENERAL", true);
					this.WriteDateiFormatZeile(Datei, "PROGRAM",	"FLEXPERTE");
					this.WriteDateiFormatZeile(Datei, "VERSION",	getstring("CATALOG.PROJECTFILEVERSION.MAJOR","ROOT"));
					this.WriteDateiFormatZeile(Datei, "RELEASE",	getstring("CATALOG.PROJECTFILEVERSION.MINOR","ROOT"));
					this.WriteDateiFormatZeile(Datei, "SVN",		getstring("CATALOG.PROJECTFILEVERSION.SVN","ROOT"));
					this.WriteDateiFormatZeile(Datei, "COPYRIGHT",	"HYDRA RH-Programm FLEXPERTE");
					this.WriteDateiFormatZeile(Datei, "LANGUAGE",	getlanguage());
				this.WriteDateiSection(Datei, "GENERAL", false);
				
				this.WriteDateiSection(Datei, "PROJECT-DATA", true);
					this.WriteDateiFormatZeile(Datei, "PROJNAME",		RESTRAINTS[i].JOBNAME);
					this.WriteDateiFormatZeile(Datei, "PROJDIRECTORY",	"");
					this.WriteDateiFormatZeile(Datei, "PIPENAME",		RESTRAINTS[i].PIPENAME);
					this.WriteDateiFormatZeile(Datei, "QUELLE",			"4");
				this.WriteDateiSection(Datei, "PROJECT-DATA", false);
				
				this.WriteDateiSection(Datei, "ASSEMBLY-DATA", true);
					this.WriteDateiFormatZeile(Datei, "NAME",		RESTRAINTS[i].NODE_NAME);
					this.WriteDateiFormatZeile(Datei, "DRAWING",	"");
					this.WriteDateiFormatZeile(Datei, "REMARKS",	"");
					this.WriteDateiFormatZeile(Datei, "CALCNR",		"");
					this.WriteDateiFormatZeile(Datei, "CALCREV",	"");
					this.WriteDateiFormatZeile(Datei, "NODENUMB",	RESTRAINTS[i].NODE_NUM);
					if (!RESTRAINTS[i].isHanger){
						this.WriteDateiFormatZeile(Datei, "LK_TYP",			"");
						this.WriteDateiFormatZeile(Datei, "LK_NUM",			"");
						this.WriteDateiFormatZeile(Datei, "DISTANCE",		"");
						this.WriteDateiFormatZeile(Datei, "SPRINGRATE_G",	"");
						this.WriteDateiFormatZeile(Datei, "FH_TYP",			"");
					}
					else{
						this.WriteDateiFormatZeile(Datei, "LK_TYP",			RESTRAINTS[i].isDoppelt ? "N21"	: "N1");
						this.WriteDateiFormatZeile(Datei, "LK_NUM",			RESTRAINTS[i].isDoppelt ? "2"	: "1");
						this.WriteDateiFormatZeile(Datei, "DISTANCE",		RESTRAINTS[i].Spannweite);
						this.WriteDateiFormatZeile(Datei, "SPRINGRATE_G",	RESTRAINTS[i].SRate);
						this.WriteDateiFormatZeile(Datei, "FH_TYP",			RESTRAINTS[i].Hanger_Gr);
					}
					this.WriteDateiFormatZeile(Datei, "RH_B_TYP",	RESTRAINTS[i].RHTyp);
					this.WriteDateiFormatZeile(Datei, "RH_TYP",		RESTRAINTS[i].RHTyp);
					this.WriteDateiFormatZeile(Datei, "LOAD-TYPE",	"");
				this.WriteDateiSection(Datei, "ASSEMBLY-DATA", false);
				
				this.WriteDateiSection(Datei, "LOC-PLAN", true);
					this.WriteDateiFormatZeile(Datei, "EXIST",		"0");
					this.WriteDateiFormatZeile(Datei, "X1",			"");
					this.WriteDateiFormatZeile(Datei, "X2",			"");
					this.WriteDateiFormatZeile(Datei, "Y1",			"");
					this.WriteDateiFormatZeile(Datei, "Y2",			"");
					this.WriteDateiFormatZeile(Datei, "X-DIST",		"");
					this.WriteDateiFormatZeile(Datei, "X2-DIST",	"");
					this.WriteDateiFormatZeile(Datei, "Y-DIST",		"");
					this.WriteDateiFormatZeile(Datei, "Y1-DIST",	"");
				this.WriteDateiSection(Datei, "LOC-PLAN", false);
				
				this.WriteDateiSection(Datei, "PIPE-DATA", true);
					this.WriteDateiFormatZeile(Datei, "DIA",			"");
					this.WriteDateiFormatZeile(Datei, "POD",			RESTRAINTS[i].DMR_Rohr);
					this.WriteDateiFormatZeile(Datei, "INSULAT",		RESTRAINTS[i].DaemmDick);
					this.WriteDateiFormatZeile(Datei, "MEDTEMP",		RESTRAINTS[i].MedTemp);
					this.WriteDateiFormatZeile(Datei, "SURRTEMP",		"");
					this.WriteDateiFormatZeile(Datei, "PIPECENTERX",	RESTRAINTS[i].COORDINATES.X);
					this.WriteDateiFormatZeile(Datei, "PIPECENTERY",	RESTRAINTS[i].COORDINATES.Y);
					this.WriteDateiFormatZeile(Datei, "PIPECENTERZ",	RESTRAINTS[i].COORDINATES.Z);
					this.WriteDateiFormatZeile(Datei, "FLOWDIRECTION",	"");
					this.WriteDateiFormatZeile(Datei, "PIPEANGLE_X",	(abs(RESTRAINTS[i].PipeDir.ALPHA) == 90 ? "0" : RESTRAINTS[i].PipeDir.ALPHA));
					this.WriteDateiFormatZeile(Datei, "PIPEANGLE_Y",	(abs(RESTRAINTS[i].PipeDir.BETA) == 90 ? "0" : RESTRAINTS[i].PipeDir.BETA));
					this.WriteDateiFormatZeile(Datei, "PIPEORIENT",		RESTRAINTS[i].PipeDir.X + " " + RESTRAINTS[i].PipeDir.Y + " " + RESTRAINTS[i].PipeDir.Z);
					this.WriteDateiFormatZeile(Datei, "VERTIKALDIR_UP",	VertiAchs);
				this.WriteDateiSection(Datei, "PIPE-DATA", false);
				
				this.WriteDateiSection(Datei, "REQUIRED-DATA", true);
					this.WriteDateiFormatZeile(Datei, "L_AXES",			"");
					this.WriteDateiFormatZeile(Datei, "X_FORCE",		"");
					this.WriteDateiFormatZeile(Datei, "Y_FORCE",		"");
					this.WriteDateiFormatZeile(Datei, "Z_FORCE",		"");
					this.WriteDateiFormatZeile(Datei, "FORCE_NORMAL",	RESTRAINTS[i].FORCES_NORMAL[6]);
					this.WriteDateiFormatZeile(Datei, "FORCE_ALL",		RESTRAINTS[i].FORCES_ALL[6]);
					this.WriteDateiFormatZeile(Datei, "Z_STATLOAD",		RESTRAINTS[i].isHanger ? RESTRAINTS[i].Instload : RESTRAINTS[i].FORCES_NORMAL[VertiAchs+2]);
					this.WriteDateiFormatZeile(Datei, "INSTLOAD",		RESTRAINTS[i].isHanger ? RESTRAINTS[i].Instload : "");
					this.WriteDateiFormatZeile(Datei, "X_FORCE_L",		"");
					this.WriteDateiFormatZeile(Datei, "Y_FORCE_L",		"");
					this.WriteDateiFormatZeile(Datei, "Z_FORCE_L",		"");
					this.WriteDateiFormatZeile(Datei, "DYNFORCE",		"");
					this.WriteDateiFormatZeile(Datei, "X_MOV",			"");
					this.WriteDateiFormatZeile(Datei, "X_MOV_HDW",		"");
					this.WriteDateiFormatZeile(Datei, "X_MOV_W",		"");
					this.WriteDateiFormatZeile(Datei, "Y_MOV",			"");
					this.WriteDateiFormatZeile(Datei, "Y_MOV_HDW",		"");
					this.WriteDateiFormatZeile(Datei, "Y_MOV_W",		"");
					this.WriteDateiFormatZeile(Datei, "Z_MOV",			"");
					this.WriteDateiFormatZeile(Datei, "Z_MOV_HDW",		"");
					this.WriteDateiFormatZeile(Datei, "Z_MOV_W",		"");
					this.WriteDateiFormatZeile(Datei, "MOV_NORMAL",		RESTRAINTS[i].MOVE_NORMAL[6]);
					this.WriteDateiFormatZeile(Datei, "MOV_HDW_OP",		"");
					this.WriteDateiFormatZeile(Datei, "MOV_W_OP",		"");
					this.WriteDateiFormatZeile(Datei, "MOV_ALL",		RESTRAINTS[i].MOVE_ALL[6]);
					this.WriteDateiFormatZeile(Datei, "MOV_HDW",		"");
					this.WriteDateiFormatZeile(Datei, "MOV_W",			"");
					this.WriteDateiFormatZeile(Datei, "X_MOV_L",		"");
					this.WriteDateiFormatZeile(Datei, "Y_MOV_L",		"");
					this.WriteDateiFormatZeile(Datei, "Z_MOV_L",		"");
					if (RESTRAINTS[i].isHanger && abs(RESTRAINTS[i].MoveHanger) > 0)
						this.WriteDateiFormatZeile(Datei, "MOV_HANGER",	RESTRAINTS[i].MoveHanger);
					else
						this.WriteDateiFormatZeile(Datei, "MOV_HANGER",	"");
					this.WriteDateiFormatZeile(Datei, "X_TEST_LOAD",	max(abs(RESTRAINTS[i].FORCES_HYDROTEST[0]), abs(RESTRAINTS[i].FORCES_HYDROTEST[3])));
					this.WriteDateiFormatZeile(Datei, "Y_TEST_LOAD",	max(abs(RESTRAINTS[i].FORCES_HYDROTEST[1]), abs(RESTRAINTS[i].FORCES_HYDROTEST[4])));
					this.WriteDateiFormatZeile(Datei, "Z_TEST_LOAD",	max(abs(RESTRAINTS[i].FORCES_HYDROTEST[2]), abs(RESTRAINTS[i].FORCES_HYDROTEST[5])));
				this.WriteDateiSection(Datei, "REQUIRED-DATA", false);
				
				this.WriteDateiSection(Datei, "STEEL-DATA", true);
					this.WriteDateiFormatZeile(Datei, "Ba1X",	VertiAchs*1 == 1 ? RESTRAINTS[i].COORDINATES.X + RESTRAINTS[i].Emass : "");
					this.WriteDateiFormatZeile(Datei, "Ba1Y",	VertiAchs*1 == 2 ? RESTRAINTS[i].COORDINATES.Y + RESTRAINTS[i].Emass : "");
					this.WriteDateiFormatZeile(Datei, "Ba1Z",	VertiAchs*1 == 3 ? RESTRAINTS[i].COORDINATES.Z + RESTRAINTS[i].Emass : "");
					this.WriteDateiFormatZeile(Datei, "BW1X",	"");
					this.WriteDateiFormatZeile(Datei, "BW1Y",	"");
					this.WriteDateiFormatZeile(Datei, "BS1",	"");
					this.WriteDateiFormatZeile(Datei, "BK1",	"");
					this.WriteDateiFormatZeile(Datei, "BA1",	"");
					this.WriteDateiFormatZeile(Datei, "BSP1",	"");
					if (RESTRAINTS[i].isHanger && RESTRAINTS[i].isDoppelt){
						this.WriteDateiFormatZeile(Datei, "Ba2X",	VertiAchs*1 == 1 ? RESTRAINTS[i].COORDINATES.X + RESTRAINTS[i].Emass : "");
						this.WriteDateiFormatZeile(Datei, "Ba2Y",	VertiAchs*1 == 2 ? RESTRAINTS[i].COORDINATES.Y + RESTRAINTS[i].Emass : "");
						this.WriteDateiFormatZeile(Datei, "Ba2Z",	VertiAchs*1 == 3 ? RESTRAINTS[i].COORDINATES.Z + RESTRAINTS[i].Emass : "");
					}
					else{
						this.WriteDateiFormatZeile(Datei, "Ba2X",	"");
						this.WriteDateiFormatZeile(Datei, "Ba2Y",	"");
						this.WriteDateiFormatZeile(Datei, "Ba2Z",	"");
					}
					this.WriteDateiFormatZeile(Datei, "BW2X",	"");
					this.WriteDateiFormatZeile(Datei, "BW2Y",	"");
					this.WriteDateiFormatZeile(Datei, "BS2",	"");
					this.WriteDateiFormatZeile(Datei, "BK2",	"");
					this.WriteDateiFormatZeile(Datei, "BA2",	"");
					this.WriteDateiFormatZeile(Datei, "BSP2",	"");
				this.WriteDateiSection(Datei, "STEEL-DATA", false);
				
				this.WriteDateiSection(Datei, "SECONDARY_STEEL-DATA", true);
					this.WriteDateiFormatZeile(Datei, "STEEL_COUNT",	"0");
				this.WriteDateiSection(Datei, "SECONDARY_STEEL-DATA", false);
			}
			setstring("IMPORT_STK_VERZEICHNIS", "", FINPath);
		}
		
		var Information	= i + " files ready for import";
		var bOK			= true;
		if (i == 0){
			Information	= "no import information could be created from MDB";
			bOK			= false;
		}
		else if (i == (-1)){
			Information	= "path selection aborted by user";
			bOK			= false;
		}
		
		return ( {message : Information, success : bOK} );
	},
	
    writeStkFromProjectlist : function(Datei)
    {
        var stkList = [];
        var i = 0;
        this.myMainController.topologieKlasse.getStueckliste(stkList);
        var AnzTeile = stkList.length;
        
        var oOptions = this.myMainController.presets.getPreisOptions();

		// In der PDS-Schnittstelle gibt es das Problem, das die Datei schon gelesen wird,
		// bevor sie fertig geschrieben ist. Darum ndern wir hier die Strategie:
		// Wir schreiben in eine temporre Datei und benennen diese erst am Schluss um.
		var oriDatei = Datei;
		Datei = Datei + ".tmp";

        var ProjectSettings = "PROJECT.SETTINGS";
		getdate('CURRENT_TIME','TEMP');
        
        var bIsDritteHLinie = this.myMainController.topologieKlasse.isDritteHLinie();
        var oWinkel = this.myMainController.topologieKlasse.getLKWinkel();
        
        var oLKinfo       = this.myMainController.dataAccess.getLKinfoDaten();
        var oHoehenmasse  = this.myMainController.dataAccess.getHoehenMasse(bIsDritteHLinie);
        var strLKTyp      = this.myMainController.dataAccess.getLastketteTyp();
        var strLKLastAbtr = this.myMainController.dataAccess.getLastketteLastabtragung();
        var strLKRohrverl = this.myMainController.dataAccess.getLastketteRohrverlauf();

        var myHaenger = this.myMainController.topologieKlasse.getCurrentHaenger();
        var strHaengertype = "0";
		var BewAuf = var BewAb = 0;
		if (myHaenger && (myHaenger.m_Ptypid == "SSG"))	// SSG
            strHaengertype = "3";
        else if (myHaenger && myHaenger.isFHaenger()){
            strHaengertype = "1";
			BewAuf	= getstring("IDC_SOLLWEG_VERTIKAL_AUF","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE")*1;
			BewAb	= getstring("IDC_SOLLWEG_VERTIKAL_AB","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE")*1;
		}
        else if (myHaenger && myHaenger.isKHaenger()){
            strHaengertype = "2";
			BewAuf	= getstring("IDC_SOLLWEG_KH_AUF","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE")*1;
			BewAb	= getstring("IDC_SOLLWEG_KH_AB","DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE")*1;
		}
        var strArtSollast       = this.myMainController.dataAccess.getSollwerteArtSollast();   // KALT, WARM
        var strRichtungBewegung = this.myMainController.dataAccess.getSollwerteRichtungBewegung(BewAuf,BewAb); // AUF, AB
        if (this.myMainController.topologieKlasse.calculateZusatzlast() == "0")
			var dZusatzlast		= "";
		else
			var dZusatzlast		= this.myMainController.topologieKlasse.calculateZusatzlast();
        
        var strAusltype = "";
        switch (left(strLKTyp, 5) == "LAGER" ? left(strLKTyp, 5) : strLKTyp)
        {
            case 'BEWEGLICH':
            case 'STARR':
            case 'GELENKSTUETZE':
            case 'GELENKSTREBE':
                strAusltype = '0';
                break;
            case 'EINZEL_HAENGER':
                strAusltype = '1';
                break;
            case 'EINZEL_SCHELLE':
                strAusltype = '2';
                break;
            case 'EINZEL_ZUBEHOER':
                strAusltype = '4';
                break;
            case 'EINZEL_LAGER':
                strAusltype = '2';
                break;
            default:
                strAusltype = '5';
                break;
        }
        
        var strTypePDMS = "0";
        if ((strLKTyp == "BEWEGLICH") || (strLKTyp == "STARR") || 
            (strLKTyp == "GELENKSTUETZE") || (strLKTyp == "GELENKSTREBE"))
        {
            switch (strLKLastAbtr)
            {
                case 'HAENGEND_EINFACH':
                    strTypePDMS = '2';
                    break;
                case 'STUETZEND_EINFACH':
                    strTypePDMS = '1';
                    break;
                case 'HAENGEND_DOPPEL':
                    strTypePDMS = '3';
                    break;
                case 'STUETZEND_DOPPEL':
                    strTypePDMS = '4';
                    break;
                default:
                    strTypePDMS = '5';
                    break;
            }
        }
        
        var strRohrverlPDMS = "0";
		if (strLKTyp == "EINZEL_ZUBEHOER")
			strRohrverlPDMS = '3';
		//else if (strLKTyp == "EINZEL_LAGER")
		//else if (left(strLKTyp, 5) == "LAGER")
		//	strRohrverlPDMS = '0';
		else
		{
			switch(strLKRohrverl) 
			{
				case 'HORIZONTAL':
					strRohrverlPDMS = '0';
					break;
				case 'VERTIKAL':
					strRohrverlPDMS = '1';
					break;
				case 'ROHRBOGEN':
					strRohrverlPDMS = '2';
					break;
				default:
					strRohrverlPDMS = '3';
					break;
			}
		}

        var LK_Typ = "";							// @@@ Achtung, Ergaenzungen sind moeglich
		var LK_Num = 0;
		var Springrate_ges = 0;
		if (right(strLKLastAbtr, 7) == "EINFACH")
		{
			LK_Typ = "N1";
			LK_Num = 1;
			Springrate_ges	=	myHaenger.federrate;
		}
		else if (right(strLKLastAbtr, 6) == "DOPPEL")
		{
			LK_Typ = "N21";
			LK_Num = 2;
			Springrate_ges	=	2*myHaenger.federrate;
		}
		
		var strRichtungLK = "0";
		if ((strLKTyp == "EINZEL_ZUBEHOER") ||
			//(strLKTyp == "EINZEL_LAGER") ||
			(left(strLKTyp, 5) == "LAGER") ||
			(strLKTyp == "EINZEL_SCHELLE") ||
			(strLKTyp == "EINZEL_HAENGER"))
			strRichtungLK = '0';
		else
			strRichtungLK = '1';

        var rh_typ    = getstring("RH_TYP", "DLGDATA.CA.FINDATA.ASSEMBLY");
        var rh_typ_fl = "";
        
        if (strLKTyp == "STARR")
            rh_typ_fl = "SH";
        else if (strLKTyp == "GELENKSTREBE")
            rh_typ_fl = "GS";
        else if (strLKTyp == "GELENKSTUETZE")
            rh_typ_fl = "FG";
        else if (strHaengertype == "1")  // Feder
        {
            if ((strLKLastAbtr == "HAENGEND_EINFACH") || (strLKLastAbtr == "HAENGEND_DOPPEL"))
                rh_typ_fl =  "FH";
            else if ((strLKLastAbtr == "STUETZEND_EINFACH") || (strLKLastAbtr == "STUETZEND_DOPPEL"))
                rh_typ_fl =  "FF";      // FF ... da haben wir keinen Hinweis ???
        }
        else if (strHaengertype == "2")  // Konstant
        {
            if ((strLKLastAbtr == "HAENGEND_EINFACH") || (strLKLastAbtr == "HAENGEND_DOPPEL"))
                rh_typ_fl =  "KH";
            else if ((strLKLastAbtr == "STUETZEND_EINFACH") || (strLKLastAbtr == "STUETZEND_DOPPEL"))
                rh_typ_fl =  "KF";      // KG, Konstantsttrze mit Gelenkanschlssen, nicht in FL definiert, KF ... da haben wir keinen Hinweis ???
        }
        else if (strLKTyp == "EINZEL_SCHELLE")
            rh_typ_fl = "AC";
        //else if (strLKTyp == "EINZEL_LAGER")
		else if (left(strLKTyp, 5) == "LAGER")
        {
            //var strLagertyp = getstring("LAGER_AUSWAHL.IDC_LAGERART", "DLGDATA.CA.FORMS");
            if (strLKTyp == "LAGER_FS")	//Festpunkt
				rh_typ_fl = "FP";
			else if (rfind("ROLL",strLKTyp) < 1){
				switch (this.myMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFunction){
					case "LOSE" :
						rh_typ_fl = "GL";
						break;
					case "GEFUEHRT" :
						rh_typ_fl = "FL";
						break;
					case "GEFUEHRT_MEHRFACH" :
						rh_typ_fl = "QS";
						break;
				}
			}
			// else{}	// fr Rollenlager ist derzeit fr den Export nichts vorgesehen
        }
        // @@@@  STAUFFSCHELLE ... 
		
		// Infos zu Achssystem
		var AchsInfo	= this.myMainController.dataAccess.getAchsKSInfo();
		var AchsInfo2	= this.myMainController.dataAccess.getInfoRRKSDefault(strLKRohrverl);
        
		// falls im FIN RH_TYP = leer oder Auswahl ohne einlesen ber FIN erfolgt, dann gilt:
        // RH_TYP = RH_TYP_FL
        if (rh_typ == "")
            rh_typ = rh_typ_fl;

		var strProjectPath = getstring("PROJECTPATH",  "PROJECT");
		var strProjectDir = "";
		if (strProjectPath != "")
			strProjectDir = FileName.getDir(strProjectPath);
		
        this.WriteDateiSection(Datei, "GENERAL", true);
            this.WriteDateiFormatZeile(Datei, "PROGRAM",	    "FLEXPERTE");    // alter Name, damit die anderen Anwendungennicht durcheinander kommen?
//            this.WriteDateiFormatZeile(Datei, "VERSION",	    getstring("MAJOR","CATALOG.PROJECTFILEVERSION"));
//            this.WriteDateiFormatZeile(Datei, "RELEASE",	    getstring("MINOR","CATALOG.PROJECTFILEVERSION"));
            this.WriteDateiFormatZeile(Datei, "VERSION",	    getstring("CATALOG.PROJECTFILEVERSION.MAJOR","ROOT"));
            this.WriteDateiFormatZeile(Datei, "RELEASE",	    getstring("CATALOG.PROJECTFILEVERSION.MINOR","ROOT"));
			this.WriteDateiFormatZeile(Datei, "SVN",		    getstring("CATALOG.PROJECTFILEVERSION.SVN","ROOT"));
            this.WriteDateiFormatZeile(Datei, "COPYRIGHT",   "HYDRA RH-Programm FLEXPERTE");
            this.WriteDateiFormatZeile(Datei, "LANGUAGE",    getlanguage());
        this.WriteDateiSection(Datei, "GENERAL", false);

        this.WriteDateiSection(Datei, "PROJECT-DATA", true);
            this.WriteDateiFormatZeile(Datei, "FILE",			strProjectPath);    
            this.WriteDateiFormatZeile(Datei, "PROJNAME",		getstring("PROJEKTNAME",  ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "PROJDIRECTORY",	strProjectDir);
			
			this.WriteDateiFormatZeile(Datei, "PIPENAME",		getstring("pipename",  "DLGDATA.CA.FINDATA.FINOBJECT.project"));
            this.WriteDateiFormatZeile(Datei, "QUELLE",			getstring("quelle",  "DLGDATA.CA.FINDATA.FINOBJECT.project"));
			
            this.WriteDateiFormatZeile(Datei, "QUOTAT",	    	getstring("WI_ANGEBOTSNR",  ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "COMPANY",	    "Witzenmann GmbH");
            this.WriteDateiFormatZeile(Datei, "CUSTOMER",    	getstring("FIRMENNAME_VON", ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "VAR-OF",	    	"");    // Variante gibts nicht mehr
            this.WriteDateiFormatZeile(Datei, "VAR-REM",		"");    // Variante gibts nicht mehr
            
            var RevisionTable = "PROJECT.REVISIONS.REVISION_TABELLE_ITEMS";
            var RevisionTableSize = getsize(RevisionTable, "");
            if (RevisionTableSize > 0)
            {            
                this.WriteDateiFormatZeile(Datei, "REV-NO",	    getstring("NR", arraypath(RevisionTable,0)));
                this.WriteDateiFormatZeile(Datei, "REV-REM",	getstring("TEXT", arraypath(RevisionTable,0)));
            }
            else
            {            
                this.WriteDateiFormatZeile(Datei, "REV-NO",	    "");    
                this.WriteDateiFormatZeile(Datei, "REV-REM",	"");    
            }
            this.WriteDateiFormatZeile(Datei, "PREP",		getstring("WI_BENUTZER",    ProjectSettings));  // @@@ Klren: wer ist das wenn ausserhalb Witzenmann
            this.WriteDateiFormatZeile(Datei, "DATE",	    getstring('TIME','TEMP.CURRENT_TIME'));
            this.WriteDateiFormatZeile(Datei, "UNIT-WEIGHT",     "kg");
            this.WriteDateiFormatZeile(Datei, "UNIT-LENGTH",     "mm");
            this.WriteDateiFormatZeile(Datei, "UNIT-FORCE",      "kN");
            this.WriteDateiFormatZeile(Datei, "UNIT-CURRENCY",   "EUR");
            this.WriteDateiFormatZeile(Datei, "UNIT-TEMP",       "C");
            this.WriteDateiFormatZeile(Datei, "UNIT-RATE",       "n/mm");
            this.WriteDateiFormatZeile(Datei, "UNIT-ANGLE",      "");
        this.WriteDateiSection(Datei, "PROJECT-DATA", false);

        this.WriteDateiSection(Datei, "ASSEMBLY-DATA", true);
            this.WriteDateiFormatZeile(Datei, "POS",		getstring("POS", "DLGDATA"));
            this.WriteDateiFormatZeile(Datei, "NAME",	oLKinfo.markierung);
            this.WriteDateiFormatZeile(Datei, "DRAWING",	oLKinfo.zeichnungsnr);
            this.WriteDateiFormatZeile(Datei, "REMARKS",	oLKinfo.bemerkung);
			
			this.WriteDateiFormatZeile(Datei, "CALCNR",		getstring("calcnr","DLGDATA.CA.FINDATA.FINOBJECT.assembly"));
			this.WriteDateiFormatZeile(Datei, "CALCREV",	getstring("calcrev","DLGDATA.CA.FINDATA.FINOBJECT.assembly"));
			this.WriteDateiFormatZeile(Datei, "NODENUMB",	getstring("nodenumb","DLGDATA.CA.FINDATA.FINOBJECT.assembly"));
			
			this.WriteDateiFormatZeile(Datei, "QTY",		getstring("QTY", "DLGDATA"));
			
            this.WriteDateiFormatZeile(Datei, "LK_TYP",		LK_Typ);
			this.WriteDateiFormatZeile(Datei, "LK_NUM",		LK_Num);
			this.WriteDateiFormatZeile(Datei, "RH_B_TYP",	rh_typ_fl);	// @@@ ich denke das ist hier identisch
			
            this.WriteDateiFormatZeile(Datei, "RH_TYP",	    rh_typ);	
            this.WriteDateiFormatZeile(Datei, "RH_TYP_FL",	rh_typ_fl);	
	

            this.WriteDateiFormatZeile(Datei, "TYPE",    strAusltype);
            this.WriteDateiFormatZeile(Datei, "SUBTYPE",	strTypePDMS);
            this.WriteDateiFormatZeile(Datei, "PIPE",	strRohrverlPDMS);
            this.WriteDateiFormatZeile(Datei, "HANGER",	strHaengertype);
            this.WriteDateiFormatZeile(Datei, "RICHTUNG_LK",	strRichtungLK);
            this.WriteDateiFormatZeile(Datei, "H1",	    oHoehenmasse.H1);
            this.WriteDateiFormatZeile(Datei, "H2",      oHoehenmasse.H2);
            this.WriteDateiFormatZeile(Datei, "H3",	    oHoehenmasse.H3);
            this.WriteDateiFormatZeile(Datei, "DISTANCE",	this.myMainController.dataAccess.getSpannweite(1));
			if (left(strLKTyp, 5) != "LAGER"){
				for (var i = 0; i < 3; i++){
					if (AchsInfo[i] == "X"){
						var MaxMov	= max(abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "+", 1, AchsInfo[i+6])),abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])));
						if (MaxMov == abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])))
							MaxMov	= (-1)*MaxMov_X;
						this.WriteDateiFormatZeile(Datei, "X-MOV",		MaxMov);
						var MaxLoad	= max(abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "+", 1, AchsInfo[i+6])),abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])));
						if (MaxLoad == abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])))
							MaxLoad	= (-1)*MaxLoad;
						this.WriteDateiFormatZeile(Datei, "X-LOAD",		MaxLoad);
					}
					else if (AchsInfo[i] == "Y"){
						var MaxMov	= max(abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "+", 1, AchsInfo[i+6])),abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])));
						if (MaxMov == abs(this.myMainController.dataAccess.getSollwerteBewegung(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])))
							MaxMov	= (-1)*MaxMov;
						this.WriteDateiFormatZeile(Datei, "Y-MOV",		MaxMov);
						var MaxLoad	= max(abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "+", 1, AchsInfo[i+6])),abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])));
						if (MaxLoad == abs(this.myMainController.dataAccess.getSollwerteLast(AchsInfo[i+3] + "-", 1, AchsInfo[i+6])))
							MaxLoad	= (-1)*MaxLoad;
						this.WriteDateiFormatZeile(Datei, "Y-LOAD",		MaxLoad);
					}
				}
			}
			else{	// LAGER2011
				var AXDir		= left(right(this.myMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung, 7) ,1);
				//var RDir		= this.myMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf;
				var MaxMovAx	= max(abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial),
									abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial));
				var MaxMovLat	= max(abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer),
									abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer));
				var MaxLoadAx	= max(abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial),
									abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial));
				var MaxLoadLat	= max(abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer),
									abs(this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer));
				if (AXDir == "X"){
					this.WriteDateiFormatZeile(Datei, "X-MOV",		MaxMovAx);
					this.WriteDateiFormatZeile(Datei, "X-LOAD",		MaxLoadAx);
					this.WriteDateiFormatZeile(Datei, "Y-MOV",		MaxMovLat);
					this.WriteDateiFormatZeile(Datei, "Y-LOAD",		MaxLoadLat);
				}
				else if (AXDir == "Y"){
					this.WriteDateiFormatZeile(Datei, "Y-MOV",		MaxMovAx);
					this.WriteDateiFormatZeile(Datei, "Y-LOAD",		MaxLoadAx);
					this.WriteDateiFormatZeile(Datei, "X-MOV",		MaxMovLat);
					this.WriteDateiFormatZeile(Datei, "X-LOAD",		MaxLoadLat);
				}
			}
            //if ((strLKTyp != "EINZEL_LAGER") && (strLKTyp != "EINZEL_KLEMMSYSTEM"))
			if (left(strLKTyp, 5) != "LAGER"){
				this.WriteDateiFormatZeile(Datei, "ANGLE",		oWinkel.a_Schraegzug);
				if (AchsInfo[1] == "X"){
					this.WriteDateiFormatZeile(Datei, "ANGLE_X",	oWinkel.a_Schraegzug_Axial);
					this.WriteDateiFormatZeile(Datei, "ANGLE_Y",	oWinkel.a_Schraegzug_Lateral);
				}
				else{
					this.WriteDateiFormatZeile(Datei, "ANGLE_X",	oWinkel.a_Schraegzug_Lateral);
					this.WriteDateiFormatZeile(Datei, "ANGLE_Y",	oWinkel.a_Schraegzug_Axial);
				}
            }
			else
			{
				this.WriteDateiFormatZeile(Datei, "ANGLE",		"");
				this.WriteDateiFormatZeile(Datei, "ANGLE_X",	"");
				this.WriteDateiFormatZeile(Datei, "ANGLE_Y",	"");
			}
			this.WriteDateiFormatZeile(Datei, "LGV",		this.myMainController.topologieKlasse.a_lgv);
            if (strArtSollast == "KALT")
                this.WriteDateiFormatZeile(Datei, "LOAD-TYPE", "1" );
            else
                // this.WriteDateiFormatZeile(Datei, "LOAD-TYPE", "0" );	// 02.12.2015 Bug Warm = 2 !!!
				this.WriteDateiFormatZeile(Datei, "LOAD-TYPE", "2" );
			if ((strLKTyp != "STARR") && //(strLKTyp != "EINZEL_LAGER")
				left(strLKTyp, 5) != "LAGER"
				&& rh_typ_fl != "KH" && rh_typ_fl != "KS" && rh_typ != "KH" && rh_typ != "KS")
			{
				//this.WriteDateiFormatZeile(Datei, "SPRINGRATE_G",	Springrate_ges + " 0");
				this.WriteDateiFormatZeile(Datei, "SPRINGRATE_G",	Springrate_ges);	// -Schu- 01.12.2010 nur noch 1-wertig
				this.WriteDateiFormatZeile(Datei, "FH_TYP", myHaenger.groesse + "." + myHaenger.nennweg + " - WITZENMANN");
			}
			else
			{
				this.WriteDateiFormatZeile(Datei, "SPRINGRATE_G", "");
				this.WriteDateiFormatZeile(Datei, "FH_TYP", "");
			}
			// fr S3D zustzlich
			if (getint("quelle",  "DLGDATA.CA.FINDATA.FINOBJECT.project") == 5)
				this.WriteDateiFormatZeile(Datei, "SUPPORTOBID", getstring("supportobid","DLGDATA.CA.FINDATA.FINOBJECT.assembly"))
			else
				this.WriteDateiFormatZeile(Datei, "SUPPORTOBID", "");
		this.WriteDateiSection(Datei, "ASSEMBLY-DATA", false);

        this.WriteDateiSection(Datei, "LOC-PLAN", true);   

            var bLageplanVorhanden = "0";
            if ((getstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                ((getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN") != "") &&
                 (getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN") != "0")) ||
                (getstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN") != ""))
                bLageplanVorhanden = "1";
    
            this.WriteDateiFormatZeile(Datei, "EXIST",	bLageplanVorhanden);
            this.WriteDateiFormatZeile(Datei, "X1",		getstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "X2",		getstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "Y1",		getstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "Y2",		getstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "X-DIST",	getstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "X2-DIST",getstring ("x2-dist", "DLGDATA.CA.FINDATA.FINOBJECT.loc_plan"));	// @@@ TODO da gibt es kein Eingabefeld
            this.WriteDateiFormatZeile(Datei, "Y-DIST",	getstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "Y2-DIST",getstring ("y2-dist", "DLGDATA.CA.FINDATA.FINOBJECT.loc_plan"));	// @@@ TODO da gibt es kein Eingabefeld
            this.WriteDateiFormatZeile(Datei, "ANGLE-X",getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN"));
            this.WriteDateiFormatZeile(Datei, "ANGLE-Y","0");
        this.WriteDateiSection(Datei, "LOC-PLAN", false);

        this.WriteDateiSection(Datei, "LOAD-DATA", true);
            if (AchsInfo2.PosDir == "AUF"){
				this.WriteDateiFormatZeile(Datei, "OPERAT",	this.myMainController.dataAccess.getSollwerteLast("vertikal-", 1, AchsInfo[6]));
				//this.WriteDateiFormatZeile(Datei, "ADDED_Z_CA",	this.myMainController.dataAccess.getSollwerteZusatzLast("vertikal-", 1, AchsInfo[6]));
				this.WriteDateiFormatZeile(Datei, "ADDED_Z_CA",	this.myMainController.dataAccess.getSollwerteZusatzLast(1, AchsInfo[6]));
			}
            else{
				this.WriteDateiFormatZeile(Datei, "OPERAT",	this.myMainController.dataAccess.getSollwerteLast("vertikal+", 1, AchsInfo[6]));
				//this.WriteDateiFormatZeile(Datei, "ADDED_Z_CA",	this.myMainController.dataAccess.getSollwerteZusatzLast("vertikal+", 1, AchsInfo[6]));
				this.WriteDateiFormatZeile(Datei, "ADDED_Z_CA",	this.myMainController.dataAccess.getSollwerteZusatzLast(1, AchsInfo[6]));
			}
			//this.WriteDateiFormatZeile(Datei, "ABHEBE",	getstring("FAB", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager"));
			this.WriteDateiFormatZeile(Datei, "ABHEBE",	getstring("fz", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager"));
            this.WriteDateiFormatZeile(Datei, "ADDED",	dZusatzlast);
			
            //this.WriteDateiFormatZeile(Datei, "X-TEST-LOAD",	this.myMainController.dataAccess.getSollwerteUeberLast("lateral", 1));
            //this.WriteDateiFormatZeile(Datei, "Y-TEST-LOAD",	this.myMainController.dataAccess.getSollwerteUeberLast("axial", 1));
            //this.WriteDateiFormatZeile(Datei, "Z_TEST_LOAD",	this.myMainController.dataAccess.getSollwerteUeberLast("vertikal", 1));
			
        if (myHaenger && myHaenger.isFHaenger())
        {
            //------------------
            // Federhnger:
            this.WriteDateiFormatZeile(Datei, "HOT",		myHaenger.warmlast);
            this.WriteDateiFormatZeile(Datei, "COLD",	myHaenger.kaltlast);
            this.WriteDateiFormatZeile(Datei, "TRAVEL",	max(abs(BewAb),abs(BewAuf)));
            if (strRichtungBewegung == "AUF")
                this.WriteDateiFormatZeile(Datei, "DIRECTION", "0");
            else
                this.WriteDateiFormatZeile(Datei, "DIRECTION", "1");
            this.WriteDateiFormatZeile(Datei, "DEVIATION",    myHaenger.lastabw);
            this.WriteDateiFormatZeile(Datei, "SPRINGRATE",   myHaenger.federrate);
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVUP", myHaenger.res_oben);
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVDN", myHaenger.res_unten);
			this.WriteDateiFormatZeile(Datei, "ADJUSTABLE",	  "");

            if (strRichtungBewegung == "AUF")
				this.WriteDateiFormatZeile(Datei, "BLOCKPOS", myHaenger.res_oben + max(abs(BewAb),abs(BewAuf)));
			else
				this.WriteDateiFormatZeile(Datei, "BLOCKPOS", myHaenger.res_oben);

            this.WriteDateiFormatZeile(Datei, "NENNWEG", myHaenger.nennweg);
        }
        else if (myHaenger && myHaenger.isKHaenger())
        {
            //------------------
            // Konstanthnger
            this.WriteDateiFormatZeile(Datei, "HOT",		    myHaenger.sollast);
            this.WriteDateiFormatZeile(Datei, "COLD",		myHaenger.sollast);
            this.WriteDateiFormatZeile(Datei, "TRAVEL",		abs(myHaenger.sollweg));
            if (strRichtungBewegung == "AUF")
                this.WriteDateiFormatZeile(Datei, "DIRECTION", "0");
            else
                this.WriteDateiFormatZeile(Datei, "DIRECTION",  "1");
			this.WriteDateiFormatZeile(Datei, "DEVIATION",  "0");
			this.WriteDateiFormatZeile(Datei, "SPRINGRATE", "");
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVUP",	myHaenger.weg_res);
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVDN",	myHaenger.weg_res);
            this.WriteDateiFormatZeile(Datei, "ADJUSTABLE",	    myHaenger.getFormatierteLastjustierung());

            if (strRichtungBewegung == "AUF")
				this.WriteDateiFormatZeile(Datei, "BLOCKPOS", myHaenger.weg_res + abs(myHaenger.sollweg_ab));
			else
				this.WriteDateiFormatZeile(Datei, "BLOCKPOS", myHaenger.weg_res + abs(myHaenger.sollweg_auf));

            this.WriteDateiFormatZeile(Datei, "NENNWEG", myHaenger.nennweg);
        }
        //else if (myHaenger)
		else
        {
            //------------------
            // Starre Lastkette, d.h. Spannschloss oder nur Gewindestange:
			// neu auch alle sonstigen Teile, da immer alle Werte ausgegeben werden sollen
			
            var gesamtLast = this.myMainController.dataAccess.getSollwerteLast("vertikal", 1) + dZusatzlast;
            this.WriteDateiFormatZeile(Datei, "HOT",			gesamtLast);
            this.WriteDateiFormatZeile(Datei, "COLD",			gesamtLast);
			this.WriteDateiFormatZeile(Datei, "TRAVEL",			"");
			this.WriteDateiFormatZeile(Datei, "DIRECTION",		"");
			this.WriteDateiFormatZeile(Datei, "DEVIATION",  	"");
			this.WriteDateiFormatZeile(Datei, "SPRINGRATE", 	"");
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVUP",	"");
            this.WriteDateiFormatZeile(Datei, "EXCESSTRAVDN",	"");
            this.WriteDateiFormatZeile(Datei, "ADJUSTABLE",		"");
			this.WriteDateiFormatZeile(Datei, "BLOCKPOS",		"");
			this.WriteDateiFormatZeile(Datei, "NENNWEG",		"");
        }
        this.WriteDateiSection(Datei, "LOAD-DATA", false);

        this.WriteDateiSection(Datei, "PIPE-DATA", true);
            this.WriteDateiFormatZeile(Datei, "DIA",		    this.myMainController.dataAccess.getNennweite(1));
            this.WriteDateiFormatZeile(Datei, "POD",		    this.myMainController.dataAccess.getRohrAussendurchmesser(1));
            this.WriteDateiFormatZeile(Datei, "INSULAT",	    this.myMainController.dataAccess.getDaemmdicke(1));
            this.WriteDateiFormatZeile(Datei, "MEDTEMP",	    this.myMainController.dataAccess.getMediumTemperatur(1));
            this.WriteDateiFormatZeile(Datei, "SURRTEMP",	    this.myMainController.dataAccess.getUmgebungsTemperatur(1));
            this.WriteDateiFormatZeile(Datei, "REFTEMP",	    this.myMainController.dataAccess.getReferenzTemperatur(1));
            if (left(strLKTyp, 5) != "LAGER"){
				this.WriteDateiFormatZeile(Datei, "PIPECENTERX",	this.myMainController.dataAccess.getSollwerteEinfuegepunkt(1, 0));
				this.WriteDateiFormatZeile(Datei, "PIPECENTERY",	this.myMainController.dataAccess.getSollwerteEinfuegepunkt(1, 1));
				this.WriteDateiFormatZeile(Datei, "PIPECENTERZ",	this.myMainController.dataAccess.getSollwerteEinfuegepunkt(1, 2));
            }
			else{
				this.WriteDateiFormatZeile(Datei, "PIPECENTERX",	this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.axial);
				this.WriteDateiFormatZeile(Datei, "PIPECENTERY",	this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.quer);
				this.WriteDateiFormatZeile(Datei, "PIPECENTERZ",	this.myMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt.oTable.einfuegepunkt.schief);
			}
			this.WriteDateiFormatZeile(Datei, "FLOWDIRECTION",  getstring("flowdirection", "DLGDATA.CA.FINDATA.FINOBJECT.pipe"));
			
			var PipeAngle	= this.myMainController.dataAccess.getSollwerteSchraegzug(1);
			this.WriteDateiFormatZeile(Datei, "PIPEANGLE-X",	PipeAngle.Alpha);
            this.WriteDateiFormatZeile(Datei, "PIPEANGLE-Y",	PipeAngle.Beta);
            
            // @@@@ Siehe CCaDoc::OnNeueAuslegung...  Richtungsvektor aus der IPS-Datei, fr PDMS nicht rel.
			// aber was ist in PDS
            //var m_dVX = "0", m_dVY = "0", m_dVZ = "0";
            var m_dV = new Array();
			m_dV = IndexController.makeRequiredPipeOrient(m_dV, AchsInfo, AchsInfo2);
			//this.WriteDateiFormatZeile(Datei, "PIPEORIENT_X",	m_dVX);
            //this.WriteDateiFormatZeile(Datei, "PIPEORIENT_Y",	m_dVY);
            //this.WriteDateiFormatZeile(Datei, "PIPEORIENT_Z",	m_dVZ);
			this.WriteDateiFormatZeile(Datei, "PIPEORIENT",	m_dV[0] + " " + m_dV[1] + " " + m_dV[2]);
			//var VertiDir	= toupper(right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"), 1));
			var VertiDir	= AchsInfo[0];
			if (VertiDir == "X")
				VertiDir	= 1;
			else if (VertiDir == "Y")
				VertiDir	= 2;
			else
				VertiDir	= 3;
			if (toupper(right(getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"), 2)) == "AB")
				VertiDir	= (-1)*VertiDir;
			this.WriteDateiFormatZeile(Datei, "VERTIKALDIR_UP", VertiDir);
        this.WriteDateiSection(Datei, "PIPE-DATA", false);

        this.WriteDateiSection(Datei, "STEEL-DATA", true);
			this.WriteDateiFormatZeile(Datei, "Ba1X",		    getstring("Ba1X", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "Ba1Y",		    getstring("Ba1Y", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "Ba1Z",		    getstring("Ba1Z", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BW1X",		    getstring("BW1X", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BW1Y",		    getstring("BW1Y", "DLGDATA.CA.FINDATA.STEEL"));
			
			this.WriteDateiFormatZeile(Datei, "BS1",		    getstring("BS1", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BK1",		    getstring("BK1", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BA1",		    getstring("BA1", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BSP1",		    getstring("BSP1", "DLGDATA.CA.FINDATA.STEEL"));
			
			this.WriteDateiFormatZeile(Datei, "Ba2X",		    getstring("Ba2X", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "Ba2Y",		    getstring("Ba2Y", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "Ba2Z",		    getstring("Ba2Z", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BW2X",		    getstring("BW2X", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BW2Y",		    getstring("BW2Y", "DLGDATA.CA.FINDATA.STEEL"));
			
			this.WriteDateiFormatZeile(Datei, "BS2",		    getstring("BS2", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BK2",		    getstring("BK2", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BA2",		    getstring("BA2", "DLGDATA.CA.FINDATA.STEEL"));
			this.WriteDateiFormatZeile(Datei, "BSP2",		    getstring("BSP2", "DLGDATA.CA.FINDATA.STEEL"));
			
        this.WriteDateiSection(Datei, "STEEL-DATA", false);
		
		for (var i = 0; i < 2; i++)
		{
			if (i == 0)
			{
				this.WriteDateiSection(Datei, "REQUIRED-DATA-ORIGIN", true);
			}
			else
			{
				this.WriteDateiSection(Datei, "REQUIRED-DATA", true);
			}
				this.WriteDateiFormatZeile(Datei, "L_AXES",		    getstring("L_AXES", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "X_FORCE",		getstring("X_FORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Y_FORCE",		getstring("Y_FORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Z_FORCE",		getstring("Z_FORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "FORCE_NORMAL",	getstring("FORCE_NORMAL", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "FORCE_ALL",		getstring("FORCE_ALL", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "Z_STATLOAD",		getstring("Z_STATLOAD", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "INSTLOAD",		getstring("INSTLOAD", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "X_FORCE_L",		getstring("X_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Y_FORCE_L",		getstring("Y_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Z_FORCE_L",		getstring("Z_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "DYNFORCE",		getstring("DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				//this.WriteDateiFormatZeile(Datei, "X_DYNFORCE",		getstring("X_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "Y_DYNFORCE",		getstring("Y_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "Z_DYNFORCE",		getstring("Z_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "X_DYNFORCE_L",	getstring("X_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "Y_DYNFORCE_L",	getstring("Y_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "Z_DYNFORCE_L",	getstring("Z_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "X_MOV",		    getstring("X_MOV", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "X_MOV_HDW",	    getstring("X_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "X_MOV_W",	    getstring("X_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "Y_MOV",		    getstring("Y_MOV", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "Y_MOV_HDW",	    getstring("Y_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Y_MOV_W",	    getstring("Y_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "Z_MOV",		    getstring("Z_MOV", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "Z_MOV_HDW",	    getstring("Z_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Z_MOV_W",	    getstring("Z_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "MOV_NORMAL",	    getstring("MOV_NORMAL", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_HDW_OP",	    getstring("MOV_HDW_OP", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_W_OP",	    getstring("MOV_W_OP", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_ALL",	    getstring("MOV_ALL", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_HDW",	    getstring("MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_W",		    getstring("MOV_W", "DLGDATA.CA.FINDATA.REQUIRED"));
				
				this.WriteDateiFormatZeile(Datei, "X_MOV_L",		getstring("X_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Y_MOV_L",		getstring("Y_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Z_MOV_L",		getstring("Z_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "MOV_HANGER",		getstring("MOV_HANGER", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "X_TEST_LOAD",	getstring("X_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED"));
				//this.WriteDateiFormatZeile(Datei, "Y_TEST_LOAD",	getstring("Y_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED"));
				this.WriteDateiFormatZeile(Datei, "Z_TEST_LOAD",	getstring("Z_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED"));
			if (i == 0)
			{
				this.WriteDateiSection(Datei, "REQUIRED-DATA-ORIGIN", false);
			}
			else
			{
				this.WriteDateiSection(Datei, "REQUIRED-DATA", false);
			}
			
			if (i < 1){
				IndexController.makeRequiredValues();
			}
		}
		
		this.WriteDateiSection(Datei, "SECONDARY_STEEL-DATA", true);
			this.WriteDateiFormatZeile(Datei, "STEEL_COUNT ",	getstring("PART_ANZ",	"DLGDATA.CA.SELECTION.TOPOCLASS.SONDERTEILE"));
			for (var i = 0; i < (getstring("PART_ANZ", "DLGDATA.CA.SELECTION.TOPOCLASS.SONDERTEILE")-0); i++)
			{
				var j = i+1;
				/*
				this.WriteDateiFormatZeile(Datei, "STEEL_ART " + j,		getstring("STEEL_ART " + i,		"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_KLASS " + j,	getstring("STEEL_KLASS " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_TYP " + j,		getstring("STEEL_TYP " + i,		"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_MASS " + j,	getstring("STEEL_MASS " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_WERK " + j,	getstring("STEEL_WERK " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				*/
				this.WriteDateiFormatZeile(Datei, "STEEL_ART " + j + " ; ",		getstring("STEEL_ART " + i,		"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_KLASS " + j + " ; ",	getstring("STEEL_KLASS " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_TYP " + j + " ; ",		getstring("STEEL_TYP " + i,		"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_MASS " + j + " ; ",	getstring("STEEL_MASS " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
				this.WriteDateiFormatZeile(Datei, "STEEL_WERK " + j + " ; ",	getstring("STEEL_WERK " + i,	"DLGDATA.CA.FINDATA.SECONDARY_STEEL"));
			}
		this.WriteDateiSection(Datei, "SECONDARY_STEEL-DATA", false);
		
        // Stckliste: enthlt alle Teile, auch die die keine 3D-Rep. haben,
        // aber mehrfach verbaute nur einmal (doppelte LK):
        var threeDpartAnz = 0; // hier schon mal mitzhlen
        var retObj, strProduktBez, strProduktMatnr;
        this.WriteDateiSection(Datei, "PARTS-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", AnzTeile);

            for (i = 0; i < stkList.length; i++)
            {
                // Um Bezeichnung und Materialnummer zu bekommen ....
                retObj = stkList[i].produkt.getASTLDaten(this.myMainController);
                if (retObj.aTexte.length > 0)
                    strProduktBez   = retObj.aTexte[0];
                else
                    strProduktBez   = "";
                strProduktMatnr = retObj.matnr;
                this.InsertInfoPart(Datei, stkList[i], i+1, strProduktBez, strProduktMatnr, oOptions);
                if (stkList[i].threeD)
                    threeDpartAnz = threeDpartAnz + stkList[i].threeD.length;
            }

        this.WriteDateiSection(Datei, "PARTS-LIST", false);

        // CAD-OBJECTS-LIST
        // Enthlt nur Teile mit 3D-Reprsentation, und zwar jedes sichtbare
        // Teil einzeln mit seiner Koordinate im Raum
        this.WriteDateiSection(Datei, "CAD-OBJECTS-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", threeDpartAnz);
            
        // wir mssen wissen, ob wir in der Mitte oder im linken / rechten Strang sind ...
        // PDMS richtet sich nmlich nicht nach unseren Einfgepunkten sondern nach der
        // Reihenfolge der Teile: 1. Strang, Trav/Schelle, 2. Strang
        var nObjectCount = 1, nObjectCountSave;
        for (var nStrang = 0; ; nStrang++)
        {
            nObjectCountSave = nObjectCount;
            
            for (i = 0; i < stkList.length; i++)
               nObjectCount = this.InsertInfoCadObject(Datei, stkList[i], nObjectCount, i+1, nStrang);
            
            // Wenn im aktuellen Strang nichts mehr ergnzt wurde: Ende
            if (nObjectCount <= nObjectCountSave)
                break;
        }        
        this.WriteDateiSection(Datei, "CAD-OBJECTS-LIST", false);

        // CAD-DATA-LIST
        // enthlt fr jedes Teil der Stckliste die Madaten
        this.WriteDateiSection(Datei, "CAD-DATA-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", AnzTeile);

            for (i = 0; i < stkList.length; i++)
                this.InsertInfoCadData(Datei, stkList[i], i+1);
                
        this.WriteDateiSection(Datei, "CAD-DATA-LIST", false);

		FileName.deleteFile(oriDatei);
		FileName.renameFile(Datei, oriDatei);
		
        return 1;
    },
	
	writeFreeStkFromProjectlist : function(Datei)
	{
		var buf = "";

        var strText = getstring("FP.FREI_TYP", "DLGDATA");
        delete("TEMP.TEXTANALYSE_WORK", "");
		var nAnzRows = stringtoarray(strText, "TEMP.TEXTANALYSE_WORK", "\n");
		var strProduktBez   = "";
		if (nAnzRows > 0)
			strProduktBez = getstring("VALUE", arraypath("TEMP.TEXTANALYSE_WORK",0));

		var strMasse = "", strLogicID = "", strEMass = "";
		if (getstring("FP.FP_ASSI_GROUP", "DLGDATA") == "IDC_FP_ASSI")
		{
			strMasse   = getstring("CA.FORMS.SONDERTEIL.DATA_MASSE", "DLGDATA")
			strEMass   = getstring("CA.FORMS.SONDERTEIL.DATA_EMASS", "DLGDATA")
			strLogicID = getstring("CA.FORMS.SONDERTEIL.DATA_LOGICID", "DLGDATA")
		}

        this.WriteDateiSection(Datei, "GENERAL", true);
            this.WriteDateiFormatZeile(Datei, "PROGRAM",	"FLEXPERTE");    // alter Name, damit die anderen Anwendungennicht durcheinander kommen
            //this.WriteDateiFormatZeile(Datei, "VERSION",	getstring("MAJOR","CATALOG.PROJECTFILEVERSION"));
            //this.WriteDateiFormatZeile(Datei, "RELEASE",	getstring("MINOR","CATALOG.PROJECTFILEVERSION"));
			this.WriteDateiFormatZeile(Datei, "VERSION",	getstring("CATALOG.PROJECTFILEVERSION.MAJOR","ROOT"));
            this.WriteDateiFormatZeile(Datei, "RELEASE",	getstring("CATALOG.PROJECTFILEVERSION.MINOR","ROOT"));
			this.WriteDateiFormatZeile(Datei, "SVN",		getstring("CATALOG.PROJECTFILEVERSION.SVN","ROOT"));
            this.WriteDateiFormatZeile(Datei, "COPYRIGHT",  "HYDRA RH-Programm FLEXPERTE");
            this.WriteDateiFormatZeile(Datei, "LANGUAGE",   getlanguage());
        this.WriteDateiSection(Datei, "GENERAL", false);

        this.WriteDateiSection(Datei, "PROJECT-DATA", true);
            this.WriteDateiFormatZeile(Datei, "FILE",		getstring("PROJECTPATH",  "PROJECT"));    
            this.WriteDateiFormatZeile(Datei, "PROJNAME",	getstring("PROJEKTNAME",  ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "QUOTAT",	    getstring("WI_ANGEBOTSNR",  ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "COMPANY",	    "Witzenmann GmbH");
            this.WriteDateiFormatZeile(Datei, "CUSTOMER",    getstring("FIRMENNAME_VON", ProjectSettings));
            this.WriteDateiFormatZeile(Datei, "VAR-OF",	    "");    // Variante gibts nicht mehr
            this.WriteDateiFormatZeile(Datei, "VAR-REM",	"");    // Variante gibts nicht mehr
            
            var RevisionTable = "PROJECT.REVISIONS.REVISION_TABELLE_ITEMS";
            var RevisionTableSize = getsize(RevisionTable, "");
            if (RevisionTableSize > 0)
            {            
                this.WriteDateiFormatZeile(Datei, "REV-NO",	    getstring("NR", arraypath(RevisionTable,0)));
                this.WriteDateiFormatZeile(Datei, "REV-REM",	getstring("TEXT", arraypath(RevisionTable,0)));
            }
            else
            {            
                this.WriteDateiFormatZeile(Datei, "REV-NO",	    "");    
                this.WriteDateiFormatZeile(Datei, "REV-REM",	"");    
            }
            this.WriteDateiFormatZeile(Datei, "PREP",		getstring("WI_BENUTZER",    ProjectSettings));  // @@@ Klren: wer ist das wenn ausserhalb Witzenmann
            this.WriteDateiFormatZeile(Datei, "DATE",	    getstring('TIME','TEMP.CURRENT_TIME'));
            this.WriteDateiFormatZeile(Datei, "UNIT-WEIGHT",     "kg");
            this.WriteDateiFormatZeile(Datei, "UNIT-LENGTH",     "mm");
            this.WriteDateiFormatZeile(Datei, "UNIT-FORCE",      "kN");
            this.WriteDateiFormatZeile(Datei, "UNIT-CURRENCY",   "EUR");
            this.WriteDateiFormatZeile(Datei, "UNIT-TEMP",       "C");
            this.WriteDateiFormatZeile(Datei, "UNIT-RATE",       "n/mm");
            this.WriteDateiFormatZeile(Datei, "UNIT-ANGLE",      "");
        this.WriteDateiSection(Datei, "PROJECT-DATA", false);

        this.WriteDateiSection(Datei, "ASSEMBLY-DATA", true);
            this.WriteDateiFormatZeile(Datei, "POS",		getstring("POS", "DLGDATA"));
            this.WriteDateiFormatZeile(Datei, "NAME",		getstring("FP.MARKIERUNG", "DLGDATA"));
            this.WriteDateiFormatZeile(Datei, "DRAWING",	getstring("FP.ZEICHNUNGSNR", "DLGDATA"));
            this.WriteDateiFormatZeile(Datei, "QTY",		getstring("QTY", "DLGDATA"));
            this.WriteDateiFormatZeile(Datei, "REMARKS",	"");

            this.WriteDateiFormatZeile(Datei, "TYPE",    	"7");
            this.WriteDateiFormatZeile(Datei, "SUBTYPE",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPE",		"0");
            this.WriteDateiFormatZeile(Datei, "HANGER",		"0");
            this.WriteDateiFormatZeile(Datei, "RICHTUNG_LK","0");
            this.WriteDateiFormatZeile(Datei, "H1",	    	strEMass);
            this.WriteDateiFormatZeile(Datei, "H2",      	"0");
            this.WriteDateiFormatZeile(Datei, "H3",	    	"0");
            this.WriteDateiFormatZeile(Datei, "DISTANCE",	"0");
            this.WriteDateiFormatZeile(Datei, "X-MOV",		"0");
            this.WriteDateiFormatZeile(Datei, "Y-MOV",		"0");
            this.WriteDateiFormatZeile(Datei, "ANGLE",		"0");
            this.WriteDateiFormatZeile(Datei, "ANGLE_X",	"0");	
            this.WriteDateiFormatZeile(Datei, "ANGLE_Y",	"0"); 
            this.WriteDateiFormatZeile(Datei, "LGV",		"0");
			this.WriteDateiFormatZeile(Datei, "LOAD-TYPE", 	"2");
			this.WriteDateiFormatZeile(Datei, "SUPPORTOBID", "");
        this.WriteDateiSection(Datei, "ASSEMBLY-DATA", false);

        this.WriteDateiSection(Datei, "LOC-PLAN", true);   
            this.WriteDateiFormatZeile(Datei, "EXIST",	"0");
            this.WriteDateiFormatZeile(Datei, "X1",		"0");
            this.WriteDateiFormatZeile(Datei, "X2",		"0");
            this.WriteDateiFormatZeile(Datei, "Y1",		"0");
            this.WriteDateiFormatZeile(Datei, "Y2",		"0");
            this.WriteDateiFormatZeile(Datei, "X-DIST",	"0");
            this.WriteDateiFormatZeile(Datei, "Y-DIST",	"0");
            this.WriteDateiFormatZeile(Datei, "ANGLE-X",	"0");
            this.WriteDateiFormatZeile(Datei, "ANGLE-Y",	"0");
        this.WriteDateiSection(Datei, "LOC-PLAN", false);

        this.WriteDateiSection(Datei, "LOAD-DATA", true);
            this.WriteDateiFormatZeile(Datei, "OPERAT",	"0");
            this.WriteDateiFormatZeile(Datei, "ADDED",	"0");
        this.WriteDateiSection(Datei, "LOAD-DATA", false);

        this.WriteDateiSection(Datei, "PIPE-DATA", true);
            this.WriteDateiFormatZeile(Datei, "DIA",		    "0");
            this.WriteDateiFormatZeile(Datei, "POD",		    "0");
            this.WriteDateiFormatZeile(Datei, "INSULAT",	    "0");
            this.WriteDateiFormatZeile(Datei, "MEDTEMP",	    "25");
            this.WriteDateiFormatZeile(Datei, "SURRTEMP",	    "25");
            this.WriteDateiFormatZeile(Datei, "REFTEMP",	    "25");
            this.WriteDateiFormatZeile(Datei, "PIPECENTERX",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPECENTERY",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPECENTERZ",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPEANGLE-X",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPEANGLE-Y",	"0");
            
            this.WriteDateiFormatZeile(Datei, "PIPEORIENT_X",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPEORIENT_Y",	"0");
            this.WriteDateiFormatZeile(Datei, "PIPEORIENT_Z",	"0");
        this.WriteDateiSection(Datei, "PIPE-DATA", false);

        // Stckliste
        this.WriteDateiSection(Datei, "PARTS-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", "1");

			if ((strLogicID != "") || (left(strText, 3) == "ZRM"))
				var PDMSrel = "PDMS";
			else
				var PDMSrel = "SONDER";
			
			var strProduktMatnr = getstring("IDENT", "DLGDATA");
			buf = sprintf("%2d ; %d ; %s ; %s ; %s ; %s ; %s ; %.1lf ; %.1lf ; %.2lf ; %.2lf ; %s ; %s ",
				1, 
				1, 
				strProduktBez,
				strProduktBez, 
				"",
				"", 
				"",
				getstring("FP.GEWICHT", "DLGDATA"), 
				getstring("FP.GEWICHT", "DLGDATA"),
				0,		// @@@ Einzelpreis ... wirklich ausgeben??? Wenn ja in welcher Whrung !? , z.B. getstring("FP.FREI_PREIS", "DLGDATA")
				0,		// Einzelpreis * Anzahl ... hier aber Anzahl immer 1 (Preis gilt pro LK ...)
				strProduktMatnr,
				PDMSrel
				);
			this.WriteDateiFormatZeile(Datei, "PART", buf);
        this.WriteDateiSection(Datei, "PARTS-LIST", false);

        // CAD-OBJECTS-LIST
        this.WriteDateiSection(Datei, "CAD-OBJECTS-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", "1");
            buf = sprintf("%2d ; %3d ; %2d ; %3d ; %8.1f ; %8.1f ; %8.0f ; %6.0f",
                            1,
                            strLogicID,		
                            1,
                            0,
                            0,       // axiale Verschiebung, anscheinend bei manchen H-Schellen?
                            0,       // lateral zur Flussrichtung, wichtig bei doppelten
                            0,       // Z-Koordinate (vertikal) !
                            strEMass);		// 
            this.WriteDateiFormatZeile(Datei, "OBJECT", buf);
            
        this.WriteDateiSection(Datei, "CAD-OBJECTS-LIST", false);

        // CAD-DATA-LIST
        // enthlt fr jedes Teil der Stckliste die Madaten
        this.WriteDateiSection(Datei, "CAD-DATA-LIST", true);
            this.WriteDateiFormatZeile(Datei, "COUNT", "1");

			var ToDoBuf = sprintf(" DATA 1 ; %s", strMasse);
			this.writeGesplitteteZeile(Datei, ToDoBuf);
        this.WriteDateiSection(Datei, "CAD-DATA-LIST", false);


        return 1;
	},

    InsertInfoPart : function(Datei, stkListPart, partno, strProduktBez, strProduktMatnr, oOptions)
    {	
        if (!stkListPart || !stkListPart.produkt)	
			return 0;
		
        if (stkListPart.funktion != "SON")
			var PDMSrel = "PDMS";
		else
			var PDMSrel = "SONDER";
		
		// fr die Vertikalschellen wurde eine weitere NULL im Namen ergnzt (Vereinheitlichung fr 3D CAD)
		// diese muss hier wieder entfallen, da sonst der Typ in PDMS nicht gefunden wird
		var TypPDMS	= stkListPart.produkt.m_Ptyp;
		if (left(TypPDMS, 1) == 'V' && right(left(TypPDMS, 13), 4)*1 < 1000){
			TypPDMS	= left(TypPDMS, 9) + right(TypPDMS, (left(TypPDMS, 3) == "VGR" ? 17 : 16));	// die VGR hat eine Stelle mehr --> Nennlast des Dynamikteils
			// VBK's mit FN = 6,3kN sind im PDMS-Katalog mit "007" bezeichnet -> Korrektur
			if (toupper(left(TypPDMS, 3)) == "VBK" && right(left(TypPDMS, 12), 3)*1 == 6)
				TypPDMS	= TypPDMS.replace(".006.", ".007.");
		}
		
		var buf = sprintf("%2d ; %d ; %s ; %s ; %s ; %s ; %s ; %.1lf ; %.1lf ; %.2lf ; %.2lf; %s ; %s ",
			partno, 
			stkListPart.anz, 
			TypPDMS,
			strProduktBez, 
			stkListPart.produkt.getMaterial(),
			stkListPart.produkt.m_Pzusinfo, 
			translate(stkListPart.produkt.m_Pzeichnr),
			stkListPart.produkt.m_Pgewicht, 
			fround(stkListPart.anz * stkListPart.produkt.m_Pgewicht, 1),
			stkListPart.produkt.getPreis(oOptions), 
			stkListPart.anz * stkListPart.produkt.getPreis(oOptions),
			strProduktMatnr,
			PDMSrel
			);

        return this.WriteDateiFormatZeile(Datei, "PART", buf);
    },

    InsertInfoCadObject : function(Datei, stkListPart, nObjectCount, objidx, nStrang)
    {
        // -mw- 9.7.99: Zwischenstck mit Emass 0 und virtuelles Leerteil nicht ausgeben:
        // -mw- 5.9.99: Es gibt aber andere Teile mit ema = 0, die ausgegeben werden mssen, z.B. die Hlse!
        /***
        if ((m_pLkD->EMArr[objidx] == 0) &&
            ((m_pLkD->PartArr[objidx] == IDL_C_ZWI_F_A_1) ||
             (m_pLkD->PartArr[objidx] == IDL_C_ZWI_F_A_2) ||
             (m_pLkD->PartArr[objidx] == IDL_C_ZWI_F_B_1) ||
             (m_pLkD->PartArr[objidx] == IDL_C_ZWI_F_B_2) ||
             (m_pLkD->PartArr[objidx] == IDL_C_ZWI_K_1) ||
             (m_pLkD->PartArr[objidx] == IDL_C_ZWI_K_2) ||
             (m_pLkD->PartArr[objidx] == IDL_C_DOP_LEER))
            )
        {
            return(true);
        }

        double x, y;
        m_pLkD->GetInsPoint(objidx, x, y);

        // hack: finde Position in Stckliste
        int posidx = objidx;	// gilt fr linken und mittleren Strang
        if (m_pLkD->LocArr[objidx] == IDL_LOC_R) {
            // falls Teil im rechten Strang, finde Offset des Strangs
            for (int i = objidx; i > 0; i--) {
                if (m_pLkD->LocArr[i-1] != IDL_LOC_R)
                    break;
            }
            posidx -= i;	// subtrahiere Offset
            if (m_pLkD->m_bDoppelStuetze)  // warum, weiss ich auch nicht genau, aber es geht -mw-
                posidx++;
        }

        // Der absolute Oberhack, um zwei Probleme zu lsen:
        // - Bei gedrehten doppelten LK's ist x immer 0, die 3D-CAD's brauchen aber auch da Werte
        // - Bei Sonderspannweite kommt hier die Position gem der nchst greren Normspannweite an,
        //   weil wir Wild damit arbeiten lassen.
        double dYPos = x;

        if (m_pLkD->LocArr[objidx] == IDL_LOC_L)
            dYPos = 0;
        if (m_pLkD->LocArr[objidx] == IDL_LOC_M)
        {
            dYPos = b_spannweite / 2.0;
        }
        if (m_pLkD->LocArr[objidx] == IDL_LOC_R)
            dYPos = b_spannweite;

        // 25.4.2000: wir fgen eine neue Spalte an viertletzter Position ein: X-Koord
        // jetzt haben wir also:
        // X-Koord (in Flurichtung), derzeit immer 0
        // Y-Koord (quer zur Flurichtung), bei doppelten LK sinnvoll belegt (unabhngig von Stellung im 2D-CAD)
        // Z-Koord (die Aufhngepunkte)
        double dXPos = 0;
        if ( lk_grundteile[LK_SCHELLE] != NULL)
            if (lk_grundteile[LK_SCHELLE]->IsHschelle())
                dXPos = ((H_Schelle *) lk_grundteile[LK_SCHELLE])->m_dXMass;

        sprintf(buf, "%2d ; %3d ; %2d ; %3d ; %8.1f ; %8.1f ; %8.0f ; %6.0f",
            objidx+1,
            m_pLkD->TypId[objidx], 
            posidx+1,
            m_pLkD->DirArr[objidx] * 90,
            dXPos,      // axiale Verschiebung, anscheinend bei manchen H-Schellen?
            dYPos,      // lateral zur Flussrichtung, wichtig bei doppelten
            y,          // Z-Koordinate (vertikal) !
            (double) m_pLkD->EMArr[objidx]);

        *****/
        /*****
        ACHTUNG: Wert in TypId[] entspricht enum ...
        enum {
            DEFAULT,
            FHG,
            FHD,
            FHS,
            ...
        aus logicids.h ...
        // caOldLogicIds[]
       ********/

        if (!stkListPart.threeD)
            return nObjectCount;
        
        var buf;
        
        // for (var i = 0; i < stkListPart.threeD.length; i++)
        if ((stkListPart.threeD.length - 1) >= nStrang)
        {
            buf = sprintf("%2d ; %3d ; %2d ; %3d ; %8.1f ; %8.1f ; %8.0f ; %6.0f",
                            nObjectCount,
                            this.getPDMSLogicIDforProduct(stkListPart.produkt), 
                            objidx,
                            stkListPart.threeD[nStrang].rotation,
                            stkListPart.threeD[nStrang].xpos,       // axiale Verschiebung, anscheinend bei manchen H-Schellen?
                            stkListPart.threeD[nStrang].ypos,       // lateral zur Flussrichtung, wichtig bei doppelten
                            stkListPart.threeD[nStrang].zpos,       // Z-Koordinate (vertikal) !
                            stkListPart.produkt.getEmass());
            this.WriteDateiFormatZeile(Datei, "OBJECT", buf);
            nObjectCount++;
        }
        return nObjectCount;
    },

    InsertInfoCadData : function(Datei, stkListPart, posidx)
    {
        if (!stkListPart || !stkListPart.produkt)	return 0;
		
		var strMasse = stkListPart.produkt.getMassdaten();

        var ToDoBuf = sprintf(" DATA %2d ; %s", posidx, strMasse);

		this.writeGesplitteteZeile(Datei, ToDoBuf);
		
        return;
    },
	
	writeGesplitteteZeile : function(Datei, ToDoBuf)
	{
		var CurBuf = "";

		for (;;)
		{
			CurBuf = ToDoBuf.left(240);
			if (ToDoBuf.length <= 240)
				ToDoBuf = "";
			else
				ToDoBuf = ToDoBuf.right(ToDoBuf.length - 240);
			
			for (;;)
			{
				// Rechts soll eine Variable stehen, keine Zahl
				if (((CurBuf.right(1) == " ") && isNaN(ToDoBuf.left(1))) || 
					(CurBuf.length == 0) || (ToDoBuf.length == 0))
				{
					break;
				}
				else
				{
					ToDoBuf = CurBuf.right(1) + ToDoBuf;
					CurBuf = CurBuf.left(CurBuf.length - 1);
				}
			}
			CurBuf = " " + trimleft(trimright(CurBuf, " "), " ");
			this.WriteDateiZeile(Datei, CurBuf);
			
			if (ToDoBuf.length == 0)
				break;
		}
		return;
	},

    WriteDateiZeile : function(Datei, Zeile)
    {
        writefile( Datei, Zeile + "\r\n", "a" );
        return 1;
    },

    WriteDateiFormatZeile : function(Datei, attr, Wert)
    {
        var size = max(8, ((attr.length-1)/4 + 1) * 4);

        if (attr == "DATA") size = 4;	// wir mssen Platz sparen

        // var fmt = sprintf(" %%-%ds %%s", size);	// z.B. " %-15s  %s"
        var fmt = " %-" + size + "s %s";
        var zeile = sprintf(fmt, attr, Wert);

        return this.WriteDateiZeile(Datei, zeile);
    },

    WriteDateiSection : function(Datei, SectIndex, bBegin)
    {
        var Zeile = "END " + SectIndex;
        if (bBegin)
            Zeile = "BEGIN " + SectIndex; 

        return this.WriteDateiZeile(Datei, Zeile);
    }

};

