﻿/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 

CaController = function()
{
	/**
     * dataAccess ... Objekt das den Zugriff auf den Store für Dialogvariablen zentralisiert
     * zu prüfen: Auch für Zugriff auf Produkte, die dort abgelegt sind?
     * @var dataAccess
     */
	this.dataAccess = new CaDataAccess("1.0");  // Speicherversion, vorläufig auf 1.0 fst gesetzt

	/**
     * presets ... Objekt, in dem alle Voreinstellungen drinstehend (aus dem Projekt)
     * @var presets
     */
    this.presets = new CaPresets();
	
	/**
     * topologieKlassenName ... welches Objekt wird erzeugt, das die Abläufe steuert
     * @var topologieKlassenName
     */
     // hier gleich belegen ... Aufruf einer Methode der Klasse hier schon möglich.
    this.topologieKlassenName = this.bestimmeTopologieKlasse();
    
	/**
     * topologieKlasse ... Objekt, das die Abläufe steuert
     * @var topologieKlasse
     */

    var temp = this.topologieKlassenName;
    var topologieKlassenVariable = eval(temp);
    
    if ((typeof topologieKlassenVariable == "undefined") ||
        (! topologieKlassenVariable))
    {
        // throw new EasyKat.Controller.Dispatcher.Exception("Controller \"" + className + "\" is not an instance of EasyKat.Controller.Action.");
        // alert('Problem!');
        // return;
        // Beim ersten Aufruf (ohne dass vorher Systemcharakteristik durchlaufen wurde)
        // kann hier noch keine Topologieklasse erzeugt werden!
    }
    else
    {
        this.topologieKlasse = new topologieKlassenVariable(this.dataAccess, this.presets);
        if (! this.topologieKlasse.serializeIn("DLGDATA.CA.SELECTION.TOPOCLASS"))
        {
            // Bisher noch nichts da ... neu initialisieren:
            this.setzeTopologieKlassenParameter();
        }
    }
    
};

CaController.prototype = 
{
	/**
     *  Anhand der Systemcharakteristik bestimmen, welche Toplogieklasse hier zutrifft:
     * 
     */
    bestimmeTopologieKlasse : function() 
	{
        /* 
        CaTopoHaengendEinfach  --> bildet einfache und symmetrische doppelt hängende Lastketten ab
        CaTopoHaengendDoppelt  --> TODO BAUSTELLE bildet asymmetrische doppelt  hängende Lastketten ab     
        CaTopoStuetzend        --> bildet einfache und symmetrische doppelt stützende Lastketten ab
        CaTopoEinzel           --> bildet eine Einzelauswahl Schelle / Hänger / Lager / Zubehör ab
        CaTopoLager2           --> bildet eine Einzelauswahl Lager / Rollenlager ab
        CaTopoHaengendVerzweigt1 ... 5
        CaTopoWechesellast1 ... 4
        CaTopoGelenkstuetze
        CaTopoGelenkstrebe
        ... Stauff-Schelle?
        .. Lager ? -> Lager wird auch in der Einzelauswahl CaTopoEinzel abgebildet
        */

        var lkTyp             = this.dataAccess.getLastketteTyp();
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
        var bAsymmetrisch     = this.dataAccess.getLastketteAsymmetrisch();
        var strRet = "";
        
		if ((left(lkTyp, 6) == 'LAGER_') || ( lkTyp == "EINZEL_LAGER" ))
            strRet = "CaTopoLager2";        
        else if ( ( lkTyp == "EINZEL_HAENGER" ) || ( lkTyp == "EINZEL_SCHELLE" ) || ( lkTyp == "EINZEL_ZUBEHOER" ) || 
		     /*( lkTyp == "EINZEL_LAGER" ) ||*/ ( lkTyp == "EINZEL_KLEMMSYSTEM" ) )
            strRet = "CaTopoEinzel";        
        else if ( ( lkTyp == "GELENKSTUETZE" ) || ( lkTyp == "GELENKSTREBE" ) || ( lkTyp == "STOSSBREMSE" ) )
            strRet = "CaTopoGelenk";
        else if ((lkLastabtragung == "HAENGEND_EINFACH") ||
             ((lkLastabtragung == "HAENGEND_DOPPEL") && ! bAsymmetrisch))
            strRet = "CaTopoHaengendEinfach";
        else if (lkLastabtragung == "HAENGEND_DOPPEL")  // nur asymmetrisch
            strRet = "CaTopoHaengendDoppel";
        else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                 (lkLastabtragung == "STUETZEND_DOPPEL"))
            strRet = "CaTopoStuetzend";
		else
			strRet = "CaTopoLager2";     // Die Lagertopo brauchen schon direkt am Anfang!
            
		return strRet;
    },

    setzeTopologieKlassenParameter : function()
    {
        var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
        var lkTyp           = this.dataAccess.getLastketteTyp(); 
        var lkRohrverlauf   = this.dataAccess.getLastketteRohrverlauf();
        var bLKmitSchelle   = this.dataAccess.getLastketteMitSchelle();
        
        // fürs erste mal nichts setzen ... 
        // generell kann alles aus dem GUI gelesen werden, die Eingabedaten
        // zur Auslegung speichern wir ja auch nicht in der Topoklasse.
    },
	
	getLagerTopologieklasse : function()
	{
		var test = caMainController;
		if (caMainController.topologieKlasse.TopoLager2)	// Fall Lager in der lastkette
			return caMainController.topologieKlasse.TopoLager2;
		return caMainController.topologieKlasse;		
	},
	
	/**
     * holt den Trägerbreitenbereich
	 *
	 * @params string: tatsächliche Trägerbeite
	 * @returns	string: Standardträgerbreite
	 */
	getTrBereich : function(strTrBrIST)
	{
		var intTrBrIST	= atoi(strTrBrIST);
		if (intTrBrIST <= 140)
			strTrBrIST = '140';
		else if (intTrBrIST <= 180)
			strTrBrIST = '180';
		else if (intTrBrIST <= 220)
			strTrBrIST = '220';
		else if (intTrBrIST <= 260)
			strTrBrIST = '260';
		else if (intTrBrIST <= 300)
			strTrBrIST = '300';
		else
			strTrBrIST = '';
		return (strTrBrIST);
	},
    
    bestimmeAuslegungsgrundlage : function ()
	{
		var Auslegung	= getstring("IDC_RADIO_GRENZ_TEMP", "IDD_CASCADE_SETTINGS");
		return Auslegung;
	},
    legeStarrAus : function(strSelectedBild)
    {
        var lgv = this.GetLGVfromLast();

        if (lgv == "")
        {	
            // @@@ Message Rücktransport IDP_STARR_LAST_ZU_GROSS
            // translate("IDP_STARR_LAST_ZU_GROSS");
            // labort = TRUE;
            return(-1);
        }

        var zub = new Zubehoer();		// das Spannschloß
        if (strSelectedBild == "ZSMU")
        {
            zub.Init("ZSM", lgv, "IDL_C_ZSM_1");
        }
        else if (strSelectedBild == "ZSMO")
        {
            zub.Init("ZSM", lgv, "IDL_C_ZSM_2");
        }
        else
        {
            // reine Gewindestange
            zub.Init("ZRM", lgv, "IDL_C_ZRM_U_1");
            // Mindestlänge = sowas wie worst case !!! wir wissen erst später, was
            // wirklich eingebaut wird
            zub.InitZRM("IDL_T_ZRM_ZOM_U", null);	
            
        }
            
        this.topologieKlasse.setHaenger(zub);

        // Zuweisung der LGV an Lastkette bereits hier ...
        this.topologieKlasse.a_lgv = lgv;

        return(0);
    },

    GetLGVfromLast : function()
    {	
        var lkLastabtragung	= this.dataAccess.getLastketteLastabtragung();
        var AchsDirInfo		= this.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var VertiDir		= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		// Achtung: Positive Achsrichtung kann auch nach unten zeigen
		if (VertiDir == "AUF")
			var Fsoll           = this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]);
		else
			var Fsoll           = this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]);
        var a_ZusLast		= this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
		var a_ZusLast_EG	= this.dataAccess.getSollwerteZusatzLastEG();
		var dTestload		= this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
        var lgv				= "";

        var a_Fsoll = 0;
        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
            a_Fsoll = (Math.abs(Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2;
        else
            a_Fsoll = Math.abs(Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG);

        var strSQLStatement = "select * from LGV_LAST ";     // order by ....
        var numRet = dbselect("CASCADE", strSQLStatement, "LGVLAST");
        
        if (numRet <= 0)
            return lgv;   
		//if (this.bestimmeAuslegungsgrundlage() != "IDC_RADIO_ASME")
			var FN	= "fn";
		//else
		//	var FN	= "fn_ASME";

        var lgvIst = "";
        var fnIst  = 0.0;
        while (dbiseof("LGVLAST") == 0)
        {
            lgvIst = dbgetstring("LGVLAST", "LGV");
            fnIst  = dbgetdouble("LGVLAST", FN);

            if ( (a_Fsoll   <= fnIst) &&
                 (dTestload <= (fnIst * 2.5)))
            {	
                lgv = lgvIst;
                break;
            }
            dbskip("LGVLAST");
        }
        return(lgv);
    },

    sucheLGVzuLast : function(last)
    {
        var passendeLgv = { lgv: [], defaultLgv: '' };
		//if (this.bestimmeAuslegungsgrundlage() != "IDC_RADIO_ASME")
			var FN	= "fn";
		//else
		//	var FN	= "fn_ASME";
        var strSQLStatement = "select * from LGV_LAST "; 
        var numRet = dbselect("CASCADE", strSQLStatement, "LGV_LAST");
        if (numRet <= 0)
            return ret;   

        var lgvIst, fnIst;
        
        while (dbiseof("LGV_LAST") == 0)
        {
            lgvIst = dbgetstring("LGV_LAST", "LGV");
            fnIst  = dbgetdouble("LGV_LAST", FN);

            if (fnIst >= last)
            {
                passendeLgv.lgv.push( { value: lgvIst, text: lgvIst } );
                if (passendeLgv.defaultLgv == '')
                    passendeLgv.defaultLgv = lgvIst;
            }
            dbskip("LGV_LAST");
        }

        return passendeLgv;
    },

    sucheLastzuLGV : function(lgv)
    {
        var strSQLStatement = "select * from LGV_LAST where LGV='"+lgv+"' "; 
        var numRet = dbselect("CASCADE", strSQLStatement, "LGV_LAST");
        if (numRet <= 0)
            return 0;   

		//if (this.bestimmeAuslegungsgrundlage() != "IDC_RADIO_ASME")
			var FN	= "fn";
		//else
		//	var FN	= "fn_ASME";
		var fnIst  = dbgetdouble("LGV_LAST", FN);

        return fnIst;
    },

    suchePassendeSpannweiten : function()
    {
        var passendeSpannweiten = { spannweiten: [], defaultSpannweite: '' };
        
        // Je nachdem müssen wir hier entweder für die Traverse ZTN oder
        // den Doppelhänger FDT nach Spannweiten suchen.

        var lkLastabtragung = this.dataAccess.getLastketteLastabtragung();
        var lkTyp           = this.dataAccess.getLastketteTyp();        
        var lkRohrverlauf   = this.dataAccess.getLastketteRohrverlauf();
        var strLGV          = this.topologieKlasse.a_lgv;

		if (lkTyp == "EINZEL_ZUBEHOER" && this.topologieKlasse.Zubehoer)
		{
			// Bei ZTN Einzel muss hier die LGV neu bestimmt werden, wenn der Anwender eine Last eingegeben hat ...
			var strLast = getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
			if (abs(strLast) > 0)
			{
				var last = abs(strLast) / 2;
				var passendeLGV = this.sucheLGVzuLast(last);
				this.topologieKlasse.a_lgv = passendeLGV.defaultLgv;
			}
        }
        
        var strSQLStatement, suchTyp, suchKrit, suchKritFeld, suchWert;
        var curHaenger = this.topologieKlasse.getCurrentHaenger();
        
        // if (curHaenger && (curHaenger.m_Ptypid == "FDT"))
        if (this.topologieKlasse.isFDTAuswahl())
        {
            // Schlüsselfelder: lastgr des Hängers und spann
            strSQLStatement = "select * from FDT_TRAV ";
            suchTyp = "F";
            suchKrit = inputStringToDouble(curHaenger.groesse);
            suchKritFeld = "LASTGR";
        }
        else // if (lkTyp == "EINZEL_ZUBEHOER") --> auch bei Lastkette mit ztn
        {
            // Schlüsselfelder: LGV und spann
            strSQLStatement = "select * from ZTN_TYP ";         
            suchTyp = "Z";
            suchKrit = inputStringToDouble(this.topologieKlasse.a_lgv);
            suchKritFeld = "LGV";
       }
       //else
       //     return passendeSpannweiten;
		
        var numRet = dbselect("CASCADE", strSQLStatement, "SPANNWEITE");
        if (numRet <= 0)
            return ret;   

        while (dbiseof("SPANNWEITE") == 0)
        {
            suchWert    = dbgetdouble("SPANNWEITE", suchKritFeld);
            spannweite  = dbgetstring("SPANNWEITE", "SPANN");

            if (suchKrit == suchWert)
            {
                passendeSpannweiten.spannweiten.push( { value: spannweite, text: spannweite } );
                if (passendeSpannweiten.defaultSpannweite == '')
                    passendeSpannweiten.defaultSpannweite = spannweite;
            }
            dbskip("SPANNWEITE");
        }

        return passendeSpannweiten;
    },

    setSpannweite : function(spannweite, SonderSpannweite, bSonder)
    {
        // Je nachdem müssen wir hier entweder für die Traverse ZTN oder
        // den Doppelhänger FDT die Spannweite setzen

        var lkTyp             = this.dataAccess.getLastketteTyp();        
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
        var lkRohrverlauf     = this.dataAccess.getLastketteRohrverlauf();
        var ret = 1;
        
        var spannweiteFuerAuswahl = spannweite;
        if (bSonder)
            spannweiteFuerAuswahl = SonderSpannweite;

        setstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", spannweite);
        setstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", ((bSonder)?"on":"") );
        setstring("IDC_SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", SonderSpannweite);
                    
        if (this.topologieKlasse.isFDTAuswahl())
        {
            ret = topologieKlasse.initHaenger("FDT", spannweiteFuerAuswahl);
        }
        else if (lkTyp == "EINZEL_ZUBEHOER")
        {
            if (this.topologieKlasse.Zubehoer)
			{
				/** verlegt nach oben in suchePasendeSpannweiten()
				// Bei ZTN Einzel muss hier die LGV neu bestimmt werden, wenn der Anwender eine Last eingegeben hat ...
				var strLast = getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
				if (abs(strLast) > 0)
				{
					var last = abs(strLast) / 2;
					var passendeLGV = this.sucheLGVzuLast(last);
					this.topologieKlasse.a_lgv = passendeLGV.defaultLgv;
				}
				**/
                ret = this.topologieKlasse.Zubehoer.InitZTN(this.topologieKlasse.a_lgv, spannweiteFuerAuswahl);
			}
        }
        else if ((lkLastabtragung == "HAENGEND_DOPPEL") &&
                 (lkRohrverlauf == "HORIZONTAL"))     // nicht VERTIKAL
        {
            var bSchelle        = this.dataAccess.getLastketteMitSchelle();
       		var strSelectedTeil = getstring("IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_TRAVERSE_OHNE_RUT"); // = wie oben die ID!

            if (bSchelle || (strSelectedTeil == "ZTN"))
            {
                var myTraverse = new Zubehoer();    
                ret = myTraverse.InitZTN(this.topologieKlasse.a_lgv, spannweiteFuerAuswahl);
                this.topologieKlasse.Traverse = myTraverse;
            }
            else
                this.topologieKlasse.Traverse = null;
        }
		
        return ret;
    },
    
	/**
     */
    legeSSGAus : function() 
	{
        // Gelenkstrebe SSG getrennt abhandeln, sie ist ein Mittelding aus Starr und Hänger
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
        var AchsDirInfo		= this.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var VertiDir		= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		// Dynamikbauteil -> beide Lastrichtungen möglich -> Maximum betrachten
		var a_Fsoll			= max(Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
		var a_Fsoll_HZ		= max(Math.abs(this.dataAccess.getSollwerteLast("HZ-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("HZ+", 1, AchsDirInfo[6])));
		var a_Fsoll_HS		= max(Math.abs(this.dataAccess.getSollwerteLast("HS-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("HS+", 1, AchsDirInfo[6])));
		var a_ZusLast		= this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
        var a_ZusLast_EG	= this.dataAccess.getSollwerteZusatzLastEG();
		var m_dTestload		= this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);

        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL")){
            a_Fsoll		= fround((Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
			a_Fsoll_HZ	= fround((Math.abs(a_Fsoll_HZ) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
			a_Fsoll_HS	= fround((Math.abs(a_Fsoll_HS) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
        }
		else{
            a_Fsoll		= fround(Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
			a_Fsoll_HZ	= fround(Math.abs(a_Fsoll_HZ) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
			a_Fsoll_HS	= fround(Math.abs(a_Fsoll_HS) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
		}
        // Zuweisung der LGV an Lastkette bereits hier ...
        this.topologieKlasse.a_lgv = "";
        this.topologieKlasse.setHaenger(null);

        var fh = new Federhaenger();
        if (fh.InitSSG(a_Fsoll, a_Fsoll_HZ, a_Fsoll_HS, m_dTestload, a_ZusLast))
        {
            this.topologieKlasse.setHaenger(fh);
            // --> fh.m_strLGG ??
        }
        else
        {
            // @@@ MELDUNG
            // lk_grundteile[LK_HAENGER] = NULL;
            // AfxMessageBox(pDBStringTable->GetString( "ERR_SSG_NOT_POSSIBLE" ));
            // Auswahl abbrechen, keine Strebe vorhanden
        }
    },
	
	legeSSBAus	: function()
	{
		var lkLastabtragung	= this.dataAccess.getLastketteLastabtragung();
        var bHaengend		= (left(lkLastabtragung, 8) == "HAENGEND" ? true : false);
		var AchsDirInfo		= this.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var VertiDir		= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		// Dynamikbauteil -> beide Lastrichtungen möglich -> Maximum betrachten
		var a_Fsoll			= max(Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
		var a_Fsoll_HZ		= max(Math.abs(this.dataAccess.getSollwerteLast("HZ-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("HZ+", 1, AchsDirInfo[6])));
		var a_Fsoll_HS		= max(Math.abs(this.dataAccess.getSollwerteLast("HS-", 1, AchsDirInfo[6])), Math.abs(this.dataAccess.getSollwerteLast("HS+", 1, AchsDirInfo[6])));
		var a_ZusLast		= this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
        var a_ZusLast_EG	= this.dataAccess.getSollwerteZusatzLastEG();
		var m_dTestload		= this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
		
        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL")){
            a_Fsoll		= fround((Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
			a_Fsoll_HZ	= fround((Math.abs(a_Fsoll_HZ) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
			a_Fsoll_HS	= fround((Math.abs(a_Fsoll_HS) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2, 2);
		}
		else{
            a_Fsoll		= fround(Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
			a_Fsoll_HZ	= fround(Math.abs(a_Fsoll_HZ) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
			a_Fsoll_HS	= fround(Math.abs(a_Fsoll_HS) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG), 2);
		}
        // Bewegungen auswerten
		var a_Ssoll_plus		= Math.abs(this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]));
		var a_Ssoll_minus		= Math.abs(this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]));
		// ermitteln welcher Wert für Ausschub und Einschub relevant ist
		if (VertiDir == "AUF"){
			var S_ein	= (bHaengend ? a_Ssoll_plus : a_Ssoll_minus);
			var S_aus	= (bHaengend ? a_Ssoll_minus : a_Ssoll_plus);
		}
		else{
			var S_ein	= (bHaengend ? a_Ssoll_minus : a_Ssoll_plus);
			var S_aus	= (bHaengend ? a_Ssoll_plus : a_Ssoll_minus);
		}
		// Zuweisung der LGV an Lastkette bereits hier ...
        this.topologieKlasse.a_lgv = "";
        this.topologieKlasse.setHaenger(null);
		this.topologieKlasse.setVerlaengerung(null);

        var fh = new Federhaenger();
        if (fh.InitSSB(a_Fsoll, a_Fsoll_HZ, a_Fsoll_HS, m_dTestload, a_ZusLast, S_ein, S_aus))
        {
            this.topologieKlasse.setHaenger(fh);
        }
        else
        {
            // @@@ MELDUNG
            // lk_grundteile[LK_HAENGER] = NULL;
            // AfxMessageBox(pDBStringTable->GetString( "ERR_SSB_NOT_POSSIBLE" ));
            // Auswahl abbrechen, keine Strebe vorhanden
        }
	},
    
    legeFederhaengerAus : function(retobj) 
	{
        var AchsDirInfo			= this.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var lkTyp				= this.dataAccess.getLastketteTyp();
        var lkLastabtragung		= this.dataAccess.getLastketteLastabtragung();
		var VertiDir			= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
        // Weg nach beiden Richtungen auswerten und ueber Hauptrichtung (Auf/Ab) entscheiden
		var a_Ssoll_plus		= Math.abs(this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]));
		var a_Ssoll_minus		= Math.abs(this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]));
		var strRichtungBewegung	= this.dataAccess.getSollwerteRichtungBewegung(a_Ssoll_plus, a_Ssoll_minus); // AUF, AB
		
		if (strRichtungBewegung == "AB")
		{
			var a_Ssoll				= a_Ssoll_minus;
			var a_Ssoll_res			= Math.abs(a_Ssoll_plus);
		}
		else
		{
			var a_Ssoll				= a_Ssoll_plus;
			var a_Ssoll_res			= (-1) * Math.abs(a_Ssoll_minus);
		}
		
		// Achtung: Positive Achsrichtung kann auch nach unten zeigen
		if (VertiDir == "AUF")
			var a_Fsoll           = this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]);
		else
			var a_Fsoll           = this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]);
		
        var a_ZusLast         = this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
        var m_dTestload       = this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
		
		var a_ZusLast_EG	  = this.dataAccess.getSollwerteZusatzLastEG();	// -Schu 110329- ZusLast aus Eigengewicht
        
		var strArtSollast       = this.dataAccess.getSollwerteArtSollast();   // KALT, WARM

        var SollastHpkt = Math.abs(a_Fsoll);
        var ZuslastHpkt = Math.abs(a_ZusLast);
        
        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
		{
            a_Fsoll = (Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2;
			m_dTestload	= m_dTestload / 2;
        }
		else
		{
            a_Fsoll = Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG);
		}
		if (strRichtungBewegung == "AB")
			a_Ssoll = -1 * Math.abs(a_Ssoll);
		else
			a_Ssoll = Math.abs(a_Ssoll);
        
        if (Math.abs(a_Ssoll) > 140)
        {	
            retobj.ret = 1;
            retobj.msg = translate("IDP_FH_BEWEG_ZU_GROSS");
            return retobj;   // S_COMPUTE_KH
        }
        if (a_Fsoll < 0.16)
        {	
            retobj.ret = 1;
            retobj.msg = translate("IDP_FH_LAST_ZU_KLEIN");
            return retobj;   // S_COMPUTE_KH
        }
		// für "Sollast ist Warmlast" und 2 Bewegungen nur KH auslegen, da hier die Kaltlast nicht eindeutig zu bestimmen ist
		if (a_Ssoll_minus*1 != 0 && a_Ssoll_plus*1 != 0 && strArtSollast == "WARM"){
			retobj.ret = 1;
            retobj.msg = translate("IDP_FH_GEHT_NICHT") + "<br>" +
						 translate("SOLLLAST") + ": " + translate("WARMLAST") + " / " + translate("BEWEGUNG") +
						 ": -" + a_Ssoll_minus + "/+" + a_Ssoll_plus + " mm -> " + translate("KALTLAST") + " !?";
            return retobj;   // S_COMPUTE_KH
		}
        //if (this.bestimmeAuslegungsgrundlage() != "IDC_RADIO_ASME")
			var strSQLStatement = "select * from HYDRAFED ";     // order by abs(lastgroesse), (0 + nennweg) geht nicht?
		//else
		//	var strSQLStatement = "select * from HYDRAFED_ASME ";
        var numRet = dbselect("CASCADE", strSQLStatement, "HYDRAFED");
        
        if (numRet <= 0)
        {	
            retobj.ret = -1;
            retobj.msg = translate("IDP_FH_NICHTS_GEFUNDEN");
            return retobj;   
        }

        var fhminproz = this.presets.fhminproz;
        var fhminweg  = this.presets.fhminweg;      

        var Sr     = max(fhminweg, abs(a_Ssoll) * (fhminproz / 100) );
        var SrNorm = Sr;    // Grenze für Mindestwegreserve
        var Df 	   = this.presets.lastabw;    

        var srInput = getstring("IDC_MINWEGRESERVE", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE");
        if (srInput != "")
            Sr = inputStringToDouble(srInput);   //Achtung: bei "xxx" + 0 oder 0 + "xxx" kommt ein String raus
        //if ((getstring("EXPERT_MODE", "RIGHTS") != "1") && (Sr < 5))
		if ((getstring("EXPERT_MODE", "RIGHTS") != "1") && (Sr < SrNorm))
            //Sr = 5;
			Sr = SrNorm;

        for(;;)
        {	
            this.ComputeFhfs(lkTyp, lkLastabtragung, a_Ssoll, a_Ssoll_plus, a_Ssoll_minus, a_Fsoll, m_dTestload, strArtSollast, retobj, "HYDRAFED", Sr, Df, SollastHpkt, ZuslastHpkt, a_Ssoll_res);

            if (retobj.fherg.length <= 0)
            {	
                // nichts geht, möglicherweise können wir noch die Wegreserve verringern:
                if (Sr > SrNorm) // 0;
                {	
                    Sr = SrNorm; // 0;  -mw- 05/2008 auf Wunsch -schm- Nur Expert darf noch 0
                }
                else
                {	
                    retobj.msg = translate("IDP_FH_GEHT_NICHT");
                    if (lkTyp == "GELENKSTUETZE")
                        return 2;   // Nichts geht mehr
                    else
                        return 1;   // S_COMPUTE_KH
                }
            }
            else
            {	
				if (Sr < SrNorm)
				{
					if (lkTyp == "GELENKSTUETZE")
						retobj.msg = translate("IDP_FSG_WEGRES_KLEINER_NORM");
					else
						retobj.msg = translate("IDP_FH_WEGRES_KLEINER_NORM");
				}
				if (!retobj.ret)
				{
					if (retobj.msg != "")
						retobj.msg = retobj.msg + "<br>";

					if (lkTyp == "GELENKSTUETZE")
						retobj.msg = retobj.msg + translate("IDP_FSG_LASTABW_GROESSER_NORM");
					else
						retobj.msg = retobj.msg + translate("IDP_FH_LASTABW_GROESSER_NORM");
				}
                break;
            }
        }

		// @@@@@@@@ MINDESTWEGRESERVE in alle ergebnisse setzen, das macht es auf dem Client noch einfacher
		// Das geht aber bestimmt noch schöner.
		for ( var i=0; i < retobj.fherg.length; i++ ) {
			retobj.fherg[i].IDC_MINDESTWEGRESERVE = Sr;
		}
        
        return retobj;   // alles OK
    },

    ComputeFhfs : function(lkTyp, lkLastabtragung, a_Ssoll, a_Ssoll_plus, a_Ssoll_minus, a_Fsoll, m_dTestload, strArtSollast, retobj, /*CTextTable **/ hydrafed, /*int*/ Sr, /*int*/ Df, SollastHpkt, ZuslastHpkt, a_Ssoll_res)
    {	
        var fh, fhProduct;
        var Fw, Fk, F1, F2, lastab, Frate, lastgroesse, nennweg, minlast, maxlast, lgv, Blockpos;
        var Fw2	= 0;
		var ret = 0;    // 1, wenn ein Hänger gefunden, dessen Lastabweichung in den Grenzen liegt

        var wegres_unten = 0, wegres_oben = 0;
        var anz_treffer = 0;

        dbgotop(hydrafed);
        while (dbiseof(hydrafed) == 0)
        {
            lastgroesse = dbgetstring(hydrafed, "lastgroesse");
            nennweg     = dbgetstring(hydrafed, "nennweg");
            minlast     = dbgetdouble(hydrafed, "minlast");
            maxlast     = dbgetdouble(hydrafed, "maxlast");
            Frate       = dbgetdouble(hydrafed, "federrate") / 1000;
            lgv         = dbgetstring(hydrafed, "lgv");

            // a_Ssoll ist negativ, falls Richtung des Wegs == AB
            // Richtung ist immer von Kalt zu Warm zu verstehen, egal was als Sollast eingegeben wird
            if (strArtSollast == "WARM")    // Sollast ist Warmlast
            {   Fk		= a_Fsoll + a_Ssoll * Frate;
                Fw		= a_Fsoll;
				if (a_Ssoll_minus != 0 && a_Ssoll_plus != 0)
					Fw2		= a_Fsoll + a_Ssoll * Frate - (a_Ssoll > 0 ? (1) : (-1)) * ((Math.abs(a_Ssoll) == a_Ssoll_plus ? a_Ssoll_minus : a_Ssoll_plus) * Frate);
            }
            else                                // Sollast ist Kaltlast
            {   Fw		= a_Fsoll - a_Ssoll * Frate;
                if (a_Ssoll_minus != 0 && a_Ssoll_plus != 0)
					Fw2		= a_Fsoll + (a_Ssoll > 0 ? (1) : (-1)) * ((Math.abs(a_Ssoll) == a_Ssoll_plus ? a_Ssoll_minus : a_Ssoll_plus) * Frate);
				Fk		= a_Fsoll;
            }
            F1 = min(Fw, Fk);
            F2 = max(Fw, Fk);

            // Feld 2: Minlast, Feld 3: Maxlast;
            // tatsächliche Lasten inkl. Wegreserve müssen innerhalb der grenzen des Hängers liegen
            if ((minlast <= F1 - Sr * Frate) &&
                (maxlast >= F2 + Sr * Frate) &&
                (m_dTestload <= (maxlast * 2.5)))
            {	
                // Laständerung in % der Warmlast:
                lastab = fround((abs(a_Ssoll) * Frate * 100) / Fw, 1);

                if (((lkLastabtragung == "STUETZEND_EINFACH") || (lkLastabtragung == "STUETZEND_DOPPEL") || (lkTyp == "GELENKSTUETZE")) &&
                    ( ((nennweg == 100) && (a_Ssoll < -45)) ||
                      ((nennweg ==  50) && (a_Ssoll < -35)) ||
                      ((nennweg == 200) && (a_Ssoll < -75)) ))
                {
                    // Do nothing; Restriktion bei Federstützen
                    // 03/2207 Cascade 3.4
                    
                }
                else if  ((lkTyp == "GELENKSTUETZE") &&
                          ((atoi(nennweg) != 100) ||
                           (atoi(lastgroesse) > 11)))
                {
                    // Do nothing; Gelenkstützen wird es nämlich
                    // im weiteren Verlauf nur mit Nennweg 100 und Größe <= 11 geben
                }
                else
                {
                    // Korrektur der Wegreserve
					var a_Fres			= a_Ssoll_res * Frate;
					var a_Fres_oben		= 0;
					var a_Fres_unten	= 0;
					if (a_Ssoll_res >= 0)
						a_Fres_oben		= Math.abs(a_Fres);
					else
						a_Fres_unten	= Math.abs(a_Fres);
					
					//wegres_oben  = RoundDoubleToInt( (F1 - minlast)/Frate );
                    //wegres_unten = RoundDoubleToInt( (maxlast - F2)/Frate );
					
					wegres_oben		= RoundDoubleToInt( ((F1 - a_Fres_oben) - minlast)/Frate );
                    wegres_unten	= RoundDoubleToInt( (maxlast - (F2 + a_Fres_unten))/Frate );
                    
					// Teste verbleibende Wegreserve für 2. Wegrichtung inkl. Prüfung auf Mind.Wegres. Sr
					var OK = false;
					//if ((a_Ssoll_res <= 0) && ((Math.abs(a_Ssoll_res) + Sr) <= wegres_unten))
					if ((a_Ssoll_res <= 0) && (Sr <= wegres_unten))
					{
						OK = true;
					}
					//else if ((a_Ssoll_res > 0) && ((Math.abs(a_Ssoll_res) + Sr) <= wegres_oben))
					else if ((a_Ssoll_res > 0) && (Sr <= wegres_oben))
					{
						OK = true;
                    }
					
					Blockpos	= RoundDoubleToInt( (Fk - minlast)/Frate );
					
					// -mw- 11/2007: neuer Test ... Hänger (in der ersten grossen Schleife) nur nehmen,
                    // wenn er auch die geforderte Mindestwegreserve hat
                    if (((wegres_oben + wegres_unten) >= Sr) && OK)
                    {
                        fhProduct = new Federhaenger();
                        // grösse, nennweg, sollweg, warmlast, kaltlast, lastabw., wegres, oben, unten, minimal, federrate, lgv
                        fhProduct.Init(lastgroesse, nennweg, a_Ssoll, ground(Fw,3), ground(Fw2,3), ground(Fk,3),
                                 lastab, wegres_oben, wegres_unten,
                                 Sr, (Frate * 1000), lgv, SollastHpkt, ZuslastHpkt, Blockpos, a_Ssoll_minus, a_Ssoll_plus);
                        // fhProduct in den Store, zur späteren Verwendung:
                        fhProduct.serializeOut("TMP.CASELECTIONS.FHAENGER.VARIANTEN[" + anz_treffer + "].HAENGER");

                        // Dies ist für die Maske der Grössenauswahl:
                        fh = {IDC_LASTGROESSE: lastgroesse, 
                              IDC_NENNWEG : nennweg, 
                              IDC_SOLLWEG_VERTIKAL_AUF : a_Ssoll_plus, 
							  IDC_SOLLWEG_VERTIKAL_AB : a_Ssoll_minus, 
                              IDC_WARMLAST : ground(Fw,3), 
                              IDC_KALTLAST : ground(Fk,3),
                              IDC_LASTAENDERUNG : lastab, 
                              IDC_WEGRESERVE_OBEN :  wegres_oben,
                              IDC_WEGRESERVE_UNTEN : wegres_unten, 
                              wegreserve_minimal : Sr, 
                              IDC_FEDERRATE : (Frate * 1000), 
                              lgv : lgv,
                              IDC_GRUNDTYP : "F.. " + lastgroesse + "." + nennweg + "." + lgv,
                              IDC_COMBOTYP : lastgroesse + "-" + nennweg + " " + lastab + "% (" + wegres_oben + "mm " + translate("ID_OBEN") + ", " + wegres_unten + "mm " + translate("ID_UNTEN") + ")",
							  IDC_ZUS_LAST_EG_FH : this.dataAccess.getSollwerteZusatzLastEG()
                              };
                        
                        retobj.fherg.push(fh); // push (add gibts nicht) fügt hinten an ... pop, slice, shift gibts da übrigens auch
                        anz_treffer++;

                        if ((lastab <= Df) && (ret == 0))
                            ret = anz_treffer;
                    }
                }
            }
            dbskip(hydrafed);
        }
        
        // --> in der Ausklappliste soll der erste selektiert
        // sein, dessen Lastabweichung kleiner als die Norm ist
        retobj.ret      = ret;
        // Analyse der Infos aus dem FIN-File (falls vorhanden)
		var FIN	= false;
		if (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) == 'object' && getstring("FH_TYP","DLGDATA.CA.FINDATA.ASSEMBLY") != ""){
			var FINHaenger		= left(getstring("FH_TYP","DLGDATA.CA.FINDATA.ASSEMBLY"), 6);
			var	FINHaengerGr	= left(FINHaenger, 2);
			var FINHaengerWeg	= right(FINHaenger, 3)*1;
			if (toupper(right(getstring("FH_TYP","DLGDATA.CA.FINDATA.ASSEMBLY"), 10)) == "WITZENMANN")	// WI FH
				for (var i = 0; i < retobj.fherg.length; i++){
					if (retobj.fherg[i].IDC_LASTGROESSE == FINHaengerGr && 
						retobj.fherg[i].IDC_NENNWEG == FINHaengerWeg){
						FIN = true;
						retobj.selected = i;
						break;
					}
				}
			else{	// nicht WI FH
				var MerkPos			= -1;
				var SpringRateDiff	= 10000;
				var FINSpringRate	= getstring("SPRINGRATE_G","DLGDATA.CA.FINDATA.ASSEMBLY")*1;	// Achtung Gesamtfederrate!!!
				if (rfind(lkLastabtragung, "DOPPEL") > 0)
					FINSpringRate	= FINSpringRate / 2;
				for (var i = 0; i < retobj.fherg.length; i++){
					if (FINSpringRate > 0 && abs(retobj.fherg[i].IDC_FEDERRATE - FINSpringRate) < SpringRateDiff){
						SpringRateDiff	= abs(retobj.fherg[i].IDC_FEDERRATE - FINSpringRate);
						MerkPos			= i;
					}
				}
				if (MerkPos > -1){
					FIN	= true;
					retobj.selected = MerkPos;
				}
			}
		}
		if (!FIN)
			retobj.selected = (ret == 0) ? 0 : (ret - 1);
        return retobj;
    },

	legeKonstanthaengerAus : function(retobj) 
	{
        var AchsDirInfo			= this.dataAccess.getAchsKSInfo();	// [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexHori, indexVerti, indexLat]
		var lkTyp               = this.dataAccess.getLastketteTyp();
        var lkLastabtragung     = this.dataAccess.getLastketteLastabtragung();
		var VertiDir		  	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
        
		// Weg nach beiden Richtungen auswerten und ueber Hauptrichtung (Auf/Ab) entscheiden
		var a_Ssoll_plus		= this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]);
		var a_Ssoll_minus		= this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]);
		var strRichtungBewegung = this.dataAccess.getSollwerteRichtungBewegung(a_Ssoll_plus, a_Ssoll_minus); // AUF, AB
		
		var a_Ssoll			  = Math.abs(a_Ssoll_minus) + Math.abs(a_Ssoll_plus);
		
		// Achtung: Positive Achsrichtung kann auch nach unten zeigen
		if (VertiDir == "AUF")
			var a_Fsoll           = this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]);
		else
			var a_Fsoll           = this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]);
        
		var a_ZusLast           = this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
		var a_ZusLast_EG	  	= this.dataAccess.getSollwerteZusatzLastEG();	// -Schu 110329- ZusLast aus Eigengewicht
        var m_dTestload         = this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);

        var strArtSollast       = this.dataAccess.getSollwerteArtSollast();   // KALT, WARM

        var strAlleVarianten = getstring("IDC_KH_ALLE_VARIANTEN_ZEIGEN", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE");
        var bAlleVarianten = 0;
        if ((toupper(strAlleVarianten) == "TRUE") ||
            (toupper(strAlleVarianten) == "ON"))
            bAlleVarianten = 1;

        var SollastHpkt = Math.abs(a_Fsoll);
        var ZuslastHpkt = Math.abs(a_ZusLast);
            
        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL")){
            a_Fsoll		= (Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG)) / 2;
			m_dTestload	= m_dTestload / 2;
		}
        else
            a_Fsoll = Math.abs(a_Fsoll) + Math.abs(a_ZusLast) + Math.abs(a_ZusLast_EG);

		if (strRichtungBewegung == "AB")
			a_Ssoll = -1 * Math.abs(a_Ssoll);
		else
			a_Ssoll = Math.abs(a_Ssoll);

        if (abs(a_Ssoll) >= 500)
        {
            retobj.ret_kh = -1;
            retobj.msg_kh = translate("IDP_KH_BEWEG_ZU_GROSS");
            return retobj;   // Gar nichts geht
        }
        if (a_Fsoll < 0.048)
        {
            retobj.ret_kh = -1;
            retobj.msg_kh = translate("IDP_KH_LAST_ZU_KLEIN");
            return retobj;   // Gar nichts geht
        }
        if (a_Fsoll > 500)
        {
            retobj.ret_kh = -1;
            retobj.msg_kh = translate("IDP_KH_LAST_ZU_GROSS");
            return retobj;   // Gar nichts geht
        }

        //if (this.bestimmeAuslegungsgrundlage() != "IDC_RADIO_ASME")
		//{
			var strSQLStatement1 = "select * from HYDRAKON order by abs(LGR) ";
			var strSQLStatement2 = "select * from KH_LGV order by abs(SN) ";
		//}
		//else
		//{
		//	var strSQLStatement1 = "select * from HYDRAKON_ASME order by abs(LGR) ";
		//	var strSQLStatement2 = "select * from KH_LGV_ASME order by abs(SN) ";
        //}
		var numRet1 = dbselect("CASCADE", strSQLStatement1, "HYDRAKON")
        var numRet2 = dbselect("CASCADE", strSQLStatement2, "KH_LGV")
        
        if ((numRet1 <= 0) || (numRet2 <= 0))
        {	
            retobj.ret_kh = -1;
            retobj.msg_kh = translate("IDP_KH_NICHTS_GEFUNDEN");
            return retobj;   
        }

        // der erste Hänger, dessen Justierbarkeit in den gegebenen Grenzen liegt, soll voreingestellt sein:
        var justkonst = this.presets.justkonst;
        // Reserve pro Endlage!
        var khminweg  = this.presets.khminweg;
        var khminproz = this.presets.khminproz;
        var Sr     = Math.max(khminweg, RoundDoubleToInt(Math.abs(a_Ssoll) * (khminproz / 100.0)));  // Reserve pro Endlage!
        var SrNorm = Sr;

        var srInput = getstring("IDC_MINWEGRESERVE_KH", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE");
        if (srInput != "")
            Sr = inputStringToDouble(srInput);   //Achtung: bei "xxx" + 0 oder 0 + "xxx" kommt ein String raus

        for(;;)     // Schleife hier eigentlich überflüssig, wurde gebraucht f. automatische Reduktion von Sr
        {	
            this.ComputeKhks(lkLastabtragung, bAlleVarianten, retobj, "HYDRAKON", "KH_LGV", justkonst, Sr, a_Ssoll,
								a_Ssoll_plus, a_Ssoll_minus, a_Fsoll, m_dTestload, SollastHpkt, ZuslastHpkt, a_ZusLast_EG);	// berechne alle KH
            
            if (retobj.kherg.length < 0)
            {	// nichts geht, möglicherweise können wir noch die Wegreserve verringern:
                // -mw- 8/2000: Auf Wunsch von -schm- nicht mehr automatisch:
                //if (Sr > 0)
                //	Sr = 0;
                retobj.ret_kh = -1;
                retobj.msg_kh = translate("IDP_KH_GEHT_NICHT");
                break;
            }
            else
            {
                if (Sr < SrNorm)
                    retobj.msg_kh = translate("IDP_KH_WEGRES_KLEINER_NORM");
 
                /*  Nach Auswahl der Hängergröße Prüfung auf Lastjustierbarkeit:
                    -mw- 8/2000: Warnung wenn Lastjustierung kleiner als Norm:
                    if ((RoundDoubleToInt(((Konstanthaenger *)lk_grundteile[LK_HAENGER])->justplus)  < m_pMyDoc->m_Voreinstellungen.m_CascadeAuslegungsVorgaben.lastjust) ||
                        (RoundDoubleToInt(((Konstanthaenger *)lk_grundteile[LK_HAENGER])->justminus) < m_pMyDoc->m_Voreinstellungen.m_CascadeAuslegungsVorgaben.lastjust))
                        AfxMessageBox(pDBStringTable->GetString( "IDS_LASTJUSTIERUNG_KLEINER_NORM" ));
                */
                break;
            }
        }

		// MINDESTWEGRESERVE in alle Ergebnisse setzen, das macht es auf dem Client noch einfacher
		// Das geht aber bestimmt noch schöner.
		for ( var i=0; i < retobj.kherg.length; i++ ) {
			retobj.kherg[i].IDC_MINDESTWEGRESERVE_KH = Sr;
		}

        return(retobj);
	},

    NennUp : function(/*int*/ weg)
    {	
        var res = 0;

        if (weg < 200)
        {	// auf nächste 10er-Stelle
            res = parseInt( ceil(weg / 10) * 10);
        }
        else
        {	// auf nächste 25er-Stelle
            res = parseInt( ceil(weg / 25) * 25);
        }
        return res ;
    },

    ComputeKhks : function(lkLastabtragung, bAlleVarianten, retobj, /*CTextTable **/hydrakon, /*CTextTable **/lgvlast, /*double */ justkonst, /*double */ Sr,
					/*double */ a_Ssoll, a_Ssoll_plus, a_Ssoll_minus, /*double */ a_Fsoll, /*double */ m_dTestload, SollastHpkt, ZuslastHpkt, a_ZusLast_EG)
    {
        var kh, khProduct;
        var anz_treffer = 0, ret = 0;
        var i = 0, Smini = 0, Smaxi = 0, Sn = 0, Sx = 0;
        var Fmaxi = 0.0, FSmaxi = 0.0, FSmini = 0.0, justplus = 0.0, justminus = 0.0;
        var jPlusProz = 0, jMinusProz = 0;
        var strJustierung = "";
        var lgv = "";
		var LGR = "", LGRfirstTreffer = "";
        var fertig = 0;

        Sn = this.NennUp( Math.max(50, Math.abs(a_Ssoll) + (2 * Sr)) );

        dbgotop(hydrakon);
        while (dbiseof(hydrakon) == 0)  // für die 20 Leistungsgrößen
        {   
            if ((lkLastabtragung == "STUETZEND_EINFACH") || 
                (lkLastabtragung == "STUETZEND_DOPPEL"))
            {	
                Smini = dbgetdouble(hydrakon, "stsmin");
                Smaxi = dbgetdouble(hydrakon, "stsmax");
            }
            else
            {	
                Smini = dbgetdouble(hydrakon, "smin");
                Smaxi = dbgetdouble(hydrakon, "smax");
            }
            Fmaxi = dbgetdouble(hydrakon, "fmax");
            LGR   = dbgetstring(hydrakon, "LGR");

            for (Sx = Math.max(Sn, Smini); Sx <= Smaxi; )  // Hochzählen am Ende der Schleife
            {		 
                // Korrektur -schm- 1.12.2008:
                FSmaxi = (Fmaxi * 200 / Sx) * 1.15;		 		 // Runden auf 3 Stellen???
                FSmini = (Fmaxi * 200 / Sx) * 0.58 * 0.85;	     // i == LGR-1 !
                if (i == 10 && Sx ==  70) FSmaxi =  61 * 1.15;	 // * 1.15 ergänzt (scb)
                if (i == 16 && Sx == 150) FSmaxi = 261 * 1.15;	 // * 1.15 ergänzt (scb)		  		 
                if (i == 17 && Sx == 160) FSmaxi = 348 * 1.15;	 // * 1.15 ergänzt (scb), entfällt, da sxmin jetzt 170
                if (i == 18 && Sx == 180) FSmaxi = 435 * 1.15;	 // * 1.15 ergänzt (scb), entfällt, da sxmin jetzt 190
                if (i == 19 && Sx == 250) FSmaxi = 435 * 1.15;	 // * 1.15 ergänzt (scb)

                if ((FSmini <= a_Fsoll) && (FSmaxi >= a_Fsoll) &&
                    (m_dTestload <= FSmaxi * 2.5))
                {	
                    // KH mit Größe i+1, Nennweg Sx gefunden;
                    // LGV und Lastjust. muß noch berechnet werden
                    // neue Tabelle zur Bestimmung der LGV!!
                    // Wunsch von -schm- 11/00: zur LGV-Bestimmung FSmaxi auf 0 Stellen runden:
                    lgv = "";
                    var strKey = sprintf("LGR%d",i+1);
                    dbgotop(lgvlast);
                    while (dbiseof(lgvlast) == 0)  
                    {	
                        if (RoundDoubleToInt(Sx) == RoundDoubleToInt(dbgetdouble(lgvlast, "SN")))
                        {	
                            lgv = dbgetstring(lgvlast, strKey);
                            break;
                        }
                        dbskip(lgvlast);
                    }

                    var ljust = justkonst / 100;
                    justplus  = min( (FSmaxi / a_Fsoll) - 1, ljust);
                    justminus = min( 1 - (FSmini / a_Fsoll), ljust);
                    /*
					if (RoundDoubleToInt(justplus * 100)  >= justkonst &&
                        RoundDoubleToInt(justminus * 100) >= justkonst)
					*/
                    if (fround(justplus * 100, 1)  >= justkonst &&
                        fround(justminus * 100, 1) >= justkonst)
					{	
                        if (!bAlleVarianten)
							fertig = 1;
						if (LGRfirstTreffer == "")
							LGRfirstTreffer = LGR;
						// 22.1.09: Wir merken uns nicht mehr den Index des ersten passenden in der
						// kleinsten Größe, sondern den Index des letzten passenden in der kleinsten Größe
                        // if (ret == 0)   // Index des ersten passenden merken
                        //    ret = anz_treffer + 1;
						if (LGRfirstTreffer == LGR)
							ret = anz_treffer + 1;
                    }
                    
                    if (bAlleVarianten ||
						((RoundDoubleToInt(justplus * 100) >= min(justkonst, 13)) &&
						(RoundDoubleToInt(justminus * 100) >= min(justkonst, 13))))		// min(justkonst, 13) wg. Lastjustierung < 13% als Vorgabe
                    {
                        
                        khProduct = new Konstanthaenger();
                        khProduct.Init( LGR, Sx, a_Ssoll, a_Ssoll_plus, a_Ssoll_minus, a_Fsoll, 
                                        (Sx-abs(a_Ssoll))/2, Sr, justplus, justminus, 
                                        lgv, justkonst, SollastHpkt, ZuslastHpkt);

                        // khProduct in den Store, zur späteren Verwendung:
                        khProduct.serializeOut("TMP.CASELECTIONS.KHAENGER.VARIANTEN[" + anz_treffer + "].HAENGER");

                        strJustierung = khProduct.getFormatierteLastjustierung();
						
                        // Dies ist für die Maske der Grössenauswahl:
                        kh = {IDC_LASTGROESSE_KH:    LGR, 
                              IDC_NENNWEG_KH :       Sx, 
                              IDC_SOLLWEG_KH_AUF :       a_Ssoll_plus, 
							  IDC_SOLLWEG_KH_AB :       a_Ssoll_minus, 
                              IDC_SOLLLAST_KH :      ground(a_Fsoll,3), 
                              IDC_LASTJUSTIERUNG_KH : strJustierung, 
                              IDC_WEGRESERVE_KH :    (Sx-Math.abs(a_Ssoll))/2,  
                              wegreserve_minimal :   Sr, 
                              lgv :                  lgv,
                              IDC_GRUNDTYP_KH : "K.. " + LGR + "." + Sx + "." + lgv,
                              IDC_COMBOTYP_KH : LGR + "-" + Sx + " (" + strJustierung + " " + translate("IDC_LASTJUSTIERBARKEIT") + ", LGV " + lgv + ")",
							  IDC_ZUS_LAST_EG_KH : this.dataAccess.getSollwerteZusatzLastEG()
                              };
                        
                        retobj.kherg.push(kh); // push (add gibts nicht) fügt hinten an ... pop, slice, shift gibts da übrigens auch
                        anz_treffer++;
                    }
                    
                    if (fertig && (RoundDoubleToInt(justplus * 100)  < justkonst ||
                                   RoundDoubleToInt(justminus * 100) < justkonst))
                    {	
                        break;	// nur den ersten "unpassenden" übernehmen, wenn überhaupt
                    }
                }
                if (a_Fsoll > FSmaxi) 
                    break;	// gleich zur nächsten Leist.größe

                if (Sx < 200)	Sx += 10;
                else			Sx += 25;
            }

            if ((a_Fsoll < FSmini) && (Sx >= Smaxi)) 
                break;  // jetzt kann keiner mehr kommen

            if (fertig && (! bAlleVarianten))
                break;	// keine LGR, die größer als die erste passende ist

            dbskip(hydrakon);
            i++;
        }
        // --> in der Ausklappliste soll der kleinste selektiert, sein, dessen Lastjustierung besser als die Norm ist
		// 22.1.2009:  Zukünftig Hänger /Stütze mit der kleinsten Größe und dem größte Nennweg (Lastjustierung +-15%) zur Anzeige bringen.
        retobj.ret_kh = ret;		// 0, wenn keiner "passt", ansonsten (Index des Vorzugstreffers + 1)
        if (ret > 0){
			// retobj.selected_kh = ret - 1;	--> hier muss am Ende wg. der ZusLast zu häufig nachgerechnet werden
			if (retobj.ret_kh*1 > 1 && a_ZusLast_EG*1 == 0)	// ZusLast aus Eigengewicht ist nur bei Nachrechnung != 0 --> hier größt mögl. Weg 
				retobj.selected_kh = ret - 2;
			else
				retobj.selected_kh = ret - 1;
		}
		
        return retobj;
    },

    //----------------------------------------------------------------------------------
    // Berechne den Hänger neu, wenn sich Zusatzlasten ändern
	// Es soll keine komplette Suche stattfinden, wir müssen nur prüfen ob der gewählte Hänger
	// immer noch passt.
	// Wenn ja, müssen seine Daten angepasst werden, danach dann gegebenenfalls Anpassung der Gewindestangen etc
	// Wenn nein, liefern wir false zurück und der Anwender muss zurück in die Hängerauswahl
    //----------------------------------------------------------------------------------
	recalcHaenger : function(a_Fsoll, a_ZusLast, strWoher)
	{
        if (!strWoher)
			strWoher	= "STANDARD";
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		var lkTyp               = this.dataAccess.getLastketteTyp();
        var lkLastabtragung     = this.dataAccess.getLastketteLastabtragung();
        //var a_Ssoll             = RoundDoubleToInt(this.dataAccess.getSollwerteBewegung("vertikal", 1));
		var a_Ssoll             = RoundDoubleToInt(this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]) + abs(this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6])));
        var a_Ssoll_plus        = RoundDoubleToInt(this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]));
		var a_Ssoll_minus       = RoundDoubleToInt(this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]));
		var strRichtungBewegung = this.dataAccess.getSollwerteRichtungBewegung(a_Ssoll_plus, a_Ssoll_minus); // AUF, AB
        var strArtSollast       = this.dataAccess.getSollwerteArtSollast();   // KALT, WARM

        var SollastHpkt = Math.abs(a_Fsoll);
        var ZuslastHpkt = Math.abs(a_ZusLast);
		
		var fact_doppel	= 1;
            
        if ((lkLastabtragung == "HAENGEND_DOPPEL") || (lkLastabtragung == "STUETZEND_DOPPEL"))
		{
            a_Fsoll = (Math.abs(a_Fsoll) + Math.abs(a_ZusLast)) / 2;
			fact_doppel = 2;
        }
		else
            a_Fsoll = Math.abs(a_Fsoll) + Math.abs(a_ZusLast);

		if (strRichtungBewegung == "AB")
			a_Ssoll = -1 * Math.abs(a_Ssoll);
		else
			a_Ssoll = Math.abs(a_Ssoll);

		var curHaenger = this.topologieKlasse.getCurrentHaenger();
        
        //if (curHaenger && (curHaenger instanceof Federhaenger) && curHaenger.m_Ptypid != "SSG")
        if (curHaenger && (curHaenger instanceof Federhaenger) && left(curHaenger.m_Ptypid, 2) != "SS")	// keine Gelenkstrebe bzw. Stossbremse
        {
			var fhminproz = this.presets.fhminproz;
			var fhminweg  = this.presets.fhminweg;      

			var Sr     = max(fhminweg, max(abs(a_Ssoll_plus), abs(a_Ssoll_minus)) * (fhminproz / 100) );
			var SrNorm = Sr;    // Grenze für Mindestwegreserve
			var Df 	   = this.presets.lastabw;
			
			var srInput = getstring("IDC_MINWEGRESERVE", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE");
			if (srInput != "")
				Sr = inputStringToDouble(srInput);   //Achtung: bei "xxx" + 0 oder 0 + "xxx" kommt ein String raus
			if ((getstring("EXPERT_MODE", "RIGHTS") != "1") && (Sr < SrNorm))
				Sr = SrNorm;

			var strBlockierung = curHaenger.m_Pblock;
            var strSQLStatement = "select * from HYDRAFED where abs(LASTGROESSE) = "+curHaenger.groesse+" and abs(NENNWEG) = "+curHaenger.nennweg+" ";
            var numRet = dbselect("CASCADE", strSQLStatement, "HAENGER");
            var fMin = 0, fMax = 0, Frate = 0;
            if (numRet >= 0)
            {
                fMin  = dbgetdouble("HAENGER", "MINLAST");
                fMax  = dbgetdouble("HAENGER", "MAXLAST");
                Frate = dbgetdouble("HAENGER", "FEDERRATE") / 1000;
            }
			
			var E_Kat = 0;	// E-Mass ungespannt (Katalog)
			var strSQLStatement = "select * from " +curHaenger.m_Ptypid+ " where abs(LASTGR) = "+abs(curHaenger.groesse)+" and abs(NENNW) = "+abs(curHaenger.nennweg)+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, curHaenger.m_Ptypid);
			if numRet > 0;
			{
				E_Kat = dbgetdouble(curHaenger.m_Ptypid, "E");
			}
			
			// @@@ Fall SSG ?  FSG ?
			
			if (strBlockierung == "BLOCK_JA")
            {
				var Fk = 0, Fw = 0;
				for (i = 0; i < 2; i++){
					// 1. Lauf der NICHT-Default-Fall --> 2. Lauf der Default-Fall
					strRichtungBewegung	= (strRichtungBewegung == "AUF" ? "AB" : "AUF");
					if (strArtSollast == "WARM")    // Sollast ist Warmlast
					{   
						Fw = fround(a_Fsoll, 2);
						if (strRichtungBewegung == "AUF"){
							Fk = fround(a_Fsoll + a_Ssoll_plus * Frate, 2);
							var lastab_auf = fround((abs(a_Ssoll_plus) * Frate * 100) / Fw, 1);
						}
						else{
							Fk = fround(a_Fsoll - a_Ssoll_minus * Frate, 2);
							var lastab_ab = fround((abs(a_Ssoll_minus) * Frate * 100) / Fw, 1);
						}
					}
					else                                // Sollast ist Kaltlast
					{   
						if (strRichtungBewegung == "AUF"){
							Fw = fround(a_Fsoll - a_Ssoll_plus * Frate, 2);
							var lastab_auf = fround((abs(a_Ssoll_plus) * Frate * 100) / Fw, 1);
						}
						else{
							Fw = fround(a_Fsoll + a_Ssoll_minus * Frate, 2);
							var lastab_ab = fround((abs(a_Ssoll_minus) * Frate * 100) / Fw, 1);
						}
						Fk = fround(a_Fsoll, 2);
					}
					
					if (!i){
						var Fw0	= Fw;
						var Fk0	= Fk;
					}
					else{
						var Fw1	= Fw;
						var Fk1	= Fk;
					}
				}
				var F1		= min(Fw0, Fw1, Fk0, Fk1);
				var F2		= max(Fw0, Fw1, Fk0, Fk1);
				// Laständerung in % der Warmlast:
				var lastab	= max(lastab_ab, lastab_auf);
				
				// Achtung bei Auslegung "WARM" ist a_Fsoll die Warmlast
				if (strArtSollast == "WARM"){
					if (abs(a_Ssoll_minus) > abs(a_Ssoll_plus))
						var vorspann = fround((min(Fk0, Fk1) - fMin)/Frate, 0);
					else
						var vorspann = fround((max(Fk0, Fk1) - fMin)/Frate, 0);
				}
				else
					//var vorspann = fround((a_Fsoll - fMin)/Frate, 0);
					var vorspann = fround((fround(a_Fsoll, 2) - fMin)/Frate, 0);
				
				// tatsächliche Lasten inkl. Wegreserve müssen innerhalb der grenzen des Hängers liegen
				// runden, um minimale Abweichungen von Sr zu ignorieren
				var RFactor	= (abs(curHaenger.groesse) < 8 ? 2 : 1);
				if ((fMin > fround(F1 - Sr * Frate, RFactor)) ||
					(fMax < fround(F2 + Sr * Frate, RFactor)) ||
					((lastab > Df) && strWoher != "eFIN"))	// Lastabweichung > Df für eFIN zulassen der Hänger ist ja schon gewählt
					return false;							// Hänger geht nicht mehr
				
				if (strArtSollast == "WARM"){
					var wegres_oben  = vorspann - abs(a_Ssoll_plus);
					var wegres_unten = curHaenger.nennweg*1 - (vorspann + abs(a_Ssoll_minus));
				}
				else{
					var wegres_oben  = RoundDoubleToInt( (F1 - fMin)/Frate );
					var wegres_unten = RoundDoubleToInt( (fMax - F2)/Frate );
				}
				
				curHaenger.lastabw		= lastab;
				curHaenger.res_oben		= wegres_oben;
				curHaenger.res_unten	= wegres_unten;
				curHaenger.vorspann		= vorspann;
				if (left(curHaenger.m_Ptypid, 2) != "FS")
				{
					if (curHaenger.m_Ptypid == "FHS")
						curHaenger.m_Pemass = E_Kat - vorspann;
					else
						curHaenger.m_Pemass	= E_Kat + vorspann;
				}
				if (strArtSollast == "WARM"){
					if (abs(a_Ssoll_minus) > abs(a_Ssoll_plus)){
						curHaenger.kaltlast		= min(Fk0, Fk1);
						if (a_Ssoll_minus != 0 && a_Ssoll_plus != 0)
							curHaenger.warmlast2	= fround(curHaenger.kaltlast - abs(a_Ssoll_plus) * Frate, 2);
					}
					else{
						curHaenger.kaltlast		= max(Fk0, Fk1);
						if (a_Ssoll_minus != 0 && a_Ssoll_plus != 0)
							curHaenger.warmlast2	= fround(curHaenger.kaltlast + abs(a_Ssoll_plus) * Frate, 2);
					}
					curHaenger.warmlast		= Fw1;
				}
				else{
					curHaenger.kaltlast		= Fk;
					curHaenger.warmlast		= Fw1;
					if (a_Ssoll_minus != 0 && a_Ssoll_plus != 0)
						curHaenger.warmlast2	= Fw0;
				}
				//var FHrecalc = Object.fromStorage("DLGDATA.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger");
				this.topologieKlasse.setHaenger(curHaenger);
				this.topologieKlasse.berechneSystemmassInitial();
				
				if ((wegres_oben + wegres_unten) < Sr)
					return false;				// Hänger geht nicht mehr
			}
            else //if (strBlockierung == "BLOCK_MITTIG")
            {
                if (a_Fsoll > fMax)
					return false;
			}
			/*	var fMittel = (fMin + fMax) / 2;
				
				// curHaenger.sollweg = 0;   // z.B. bei 20 mm: Ausdruck +- 10
				curHaenger.res_oben = (curHaenger.nennweg - curHaenger.sollweg) / 2;
				curHaenger.res_unten = (curHaenger.nennweg - curHaenger.sollweg) / 2;
				curHaenger.vorspann = curHaenger.nennweg / 2;
				curHaenger.kaltlast = fMittel;
				var calcWarmlast1 = fround(curHaenger.kaltlast + Frate * curHaenger.sollweg / 2, 1);
				var calcWarmlast2 = fround(curHaenger.kaltlast - Frate * curHaenger.sollweg / 2, 1);
				curHaenger.warmlast = calcWarmlast1;	// die größere in das Standard-Feld, wg. u.a. der Schellenauslegung
				curHaenger.warmlast2 = calcWarmlast2;	
				curHaenger.lastabw  = fround((Frate * curHaenger.sollweg / 2) / calcWarmlast2 * 100, 2);

				// curHaenger.SollastHpkt = fMittel;
				curHaenger.Zusatzlast  = 0;
            }
            else if (strBlockierung == "BLOCK_NEIN")
            {
                if (a_Fsoll > fMax)
					return false;
				
				curHaenger.sollweg = 0;
                curHaenger.res_oben = 0;
                curHaenger.res_unten = curHaenger.nennweg;
                curHaenger.vorspann = 0;
                curHaenger.warmlast = fMin;
                curHaenger.kaltlast = fMin;

                curHaenger.SollastHpkt = 0;
                curHaenger.Zusatzlast  = 0;
                
                this.dataAccess.setSollwerteRichtungBewegung("AB");
            }
			*/
        }
        else if (curHaenger && (curHaenger instanceof Konstanthaenger))
        {
			var strBlockierung = curHaenger.m_Pblock;
			// Speziell für Konstanthänger:
			var justkonst = this.presets.justkonst;
			// Reserve pro Endlage!
			var khminweg  = this.presets.khminweg;
			var khminproz = this.presets.khminproz;
			var Sr = Math.max(khminweg, RoundDoubleToInt(Math.abs(a_Ssoll) * (khminproz / 100.0)));  // Reserve pro Endlage!
			//var Sn = this.NennUp( Math.max(50, Math.abs(a_Ssoll) + (2 * Sr)) );
			var Sn = curHaenger.nennweg;	// sonst kommt hier ein falscher Nennweg

			var strSQLStatement = "select * from HYDRAKON where abs(LGR) = "+curHaenger.groesse+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HAENGER")
			var fMax = 0, Smini = 0, Smaxi = 0;
			
			if (numRet >= 0)
			{
				fMax  = dbgetdouble("HAENGER", "FMAX");
				if ((lkLastabtragung == "STUETZEND_EINFACH") || 
					(lkLastabtragung == "STUETZEND_DOPPEL"))
				{	
					Smini = dbgetdouble("HAENGER", "stsmin");
					Smaxi = dbgetdouble("HAENGER", "stsmax");
				}
				else
				{	
					Smini = dbgetdouble("HAENGER", "smin");
					Smaxi = dbgetdouble("HAENGER", "smax");
				}
			}                
			
            if (strBlockierung == "BLOCK_JA")
            {
				var Sx = Math.max(Sn, Smini); 
				var i = curHaenger.groesse - 1;
				
				// Korrektur -schm- 01.12.2008:
				//var FSmaxi = (Fmaxi * 200 / Sx) * 1.15;		 	 // Runden auf 3 Stellen???
				//var FSmini = (Fmaxi * 200 / Sx) * 0.58 * 0.85;	 // i == LGR-1 !
				
				// Korrektur -Schu- 02.11.2012 zur Nachrechnung entfallen die 15%, da diese erhaltenbleiben sollen
				// bis zu 2% der 15% dürfen genutzt werden (analog Auslegung)
				/*
				var FSmaxi = (fMax * 200 / Sx) * 1.15;		 	 // Runden auf 3 Stellen???
				var FSmini = (fMax * 200 / Sx) * 0.58 * 0.85;	 // i == LGR-1 !
				if (i == 10 && Sx ==  70) FSmaxi =  61 * 1.15;	 // * 1.15 ergänzt (scb)
				if (i == 16 && Sx == 150) FSmaxi = 261 * 1.15;	 // * 1.15 ergänzt (scb)		  		 
				if (i == 17 && Sx == 160) FSmaxi = 348 * 1.15;	 // * 1.15 ergänzt (scb), entfällt, da sxmin jetzt 170
				if (i == 18 && Sx == 180) FSmaxi = 435 * 1.15;	 // * 1.15 ergänzt (scb), entfällt, da sxmin jetzt 190
				if (i == 19 && Sx == 250) FSmaxi = 435 * 1.15;	 // * 1.15 ergänzt (scb)
				*/
				var Fakt_just_plus	= (curHaenger.justplus*1 == curHaenger.lastjust_konst*1 ? 1 : 1 + (curHaenger.lastjust_konst*1 - curHaenger.justplus*1) / 100);
				var Fakt_just_minus	= (curHaenger.justminus*1 == curHaenger.lastjust_konst*1 ? 1 : 1 - (curHaenger.lastjust_konst*1 - curHaenger.justminus*1) / 100);
				var FSmaxi = (fMax * 200 / Sx) * Fakt_just_plus;
				var FSmini = (fMax * 200 / Sx) * 0.58 * Fakt_just_minus;
				if (i == 10 && Sx ==  70) FSmaxi =  61 * Fakt_just_plus;
				if (i == 16 && Sx == 150) FSmaxi = 261 * Fakt_just_plus;
				if (i == 17 && Sx == 160) FSmaxi = 348 * Fakt_just_plus;	 // entfällt, da sxmin jetzt 170
				if (i == 18 && Sx == 180) FSmaxi = 435 * Fakt_just_plus;	 // entfällt, da sxmin jetzt 190
				if (i == 19 && Sx == 250) FSmaxi = 435 * Fakt_just_plus;
				
				if ((FSmini > a_Fsoll) || (FSmaxi < a_Fsoll))
					return false;				// Hänger geht nicht mehr
				
				// ggf. korr. der Verstellreserven
				if ((FSmaxi / Fakt_just_plus) < (a_Fsoll))
					curHaenger.justplus = curHaenger.lastjust_konst*1 - fround(((a_Fsoll / (FSmaxi / Fakt_just_plus)) - 1) * 100, 0);
				if ((FSmini / Fakt_just_minus) > (a_Fsoll))
					curHaenger.justminus = curHaenger.lastjust_konst*1 - fround((1 - (a_Fsoll / (FSmini / Fakt_just_minus))) * 100, 0);
				
				curHaenger.sollast		= a_Fsoll;
				//curHaenger.SollastHpkt	= a_Fsoll * fact_doppel;
				this.topologieKlasse.setHaenger(curHaenger);
				this.topologieKlasse.berechneSystemmassInitial();	// hier nochmal berechnen -> FIN with Defaults braucht das für die korr. ZRM-Längen
			}
            else //if (strBlockierung == "BLOCK_MITTIG")
            {
                /*curHaenger.weg_res   = (curHaenger.nennweg - curHaenger.sollweg) /2;
                curHaenger.res_min   = curHaenger.weg_res;		// pro Endlage!

				var fMittel = fround(0.8 * fMax * 200 / curHaenger.nennweg, 2);
				
				curHaenger.SollastHpkt = fMittel;
				curHaenger.sollast = fMittel;
				*/
				if (a_Fsoll > fMax)
					return false;
            }
            // else if (strBlockierung == "BLOCK_NEIN") // das ist derzeit nicht zulässig:                
        }
        //else if (curHaenger.m_Ptypid == "SSG")	// Gelenkstrebe
        else if (left(curHaenger.m_Ptypid, 2) == "SS")	// Gelenkstrebe bzw. Stossbremse
		{
			if (curHaenger.m_dNennlast*1 < a_Fsoll)
				return false;						// komplette Neuberechnung nötig
			else{
				//curHaenger.SollastHpkt	= a_Fsoll;
				curHaenger.kaltlast	= a_Fsoll;
				curHaenger.warmlast	= a_Fsoll;
				this.topologieKlasse.berechneSystemmassInitial();
			}
			
		}
		else if (curHaenger)	// Starre Lastkette
		{
			var lgv = this.GetLGVfromLast();

			//if (this.topologieKlasse.a_lgv != lgv)
			if (this.topologieKlasse.a_lgv < lgv)
				return false;						// komplette Neuberechnung nötig
			
			this.topologieKlasse.berechneSystemmassInitial();	// hier nochmal berechnen -> FIN with Defaults braucht das für die korr. ZRM-Längen
		}
		return true;
	},

    //----------------------------------------------------------------------------------
    // Berechne die für die Schellenauslegung relevante Warmlast
    //----------------------------------------------------------------------------------
    GetSchelBetrLast : function()
    {   
        var AchsDirInfo	= caMainController.dataAccess.getAchsKSInfo();
		var VertiDir	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		// Achtung: Positive Achsrichtung kann auch nach unten zeigen
		if (VertiDir == "AUF")
			var Fw = Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]));
		else	
			var Fw = Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]));
		
        // Was ist mit Zusatzlast bei Konstanthänger / Starr?
        // Wurde im alten Cascade auch nicht berücksichtigt, Berechnung war auf
        // eingegebene Sollast bezogen.
		/*
		// -Schu- Wir berücksichtigen alle Zusatzlasten
		*/
		
		Fw	+= this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
		Fw	+= this.dataAccess.getSollwerteZusatzLastEG();
        
        var myHaenger = this.topologieKlasse.getCurrentHaenger();
        if (myHaenger && myHaenger.isFHaenger()) 
        {      
            // Achtung bei 2 Bewegungsrichtungen gibt es 2 Warmlasten
			Fw = max(myHaenger.warmlast*1, myHaenger.warmlast2);
            if (this.topologieKlasse.bDoppelt)
                Fw = Fw * 2;
            /*
			// -Schu- die muss zwingend drin bleiben
			// Zusatzlast abziehen:
            Fw = Fw - this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
			*/
        }
        return Fw;
    },

    //----------------------------------------------------------------------------------
    // Berechne die für die Schellenauslegung relevante Kaltlast
    //----------------------------------------------------------------------------------
    GetSchelKaltLast : function()
    {   
        var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		var VertiDir	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		// Achtung: Positive Achsrichtung kann auch nach unten zeigen
		if (VertiDir == "AUF")
			var Fk = Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]));
		else
			var Fk = Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]));
        
		Fk	+= this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
		Fk	+= this.dataAccess.getSollwerteZusatzLastEG();
		
		var myHaenger = this.topologieKlasse.getCurrentHaenger();
        if (myHaenger && myHaenger.isFHaenger())     
        {   
            Fk = myHaenger.kaltlast;
            if (this.topologieKlasse.bDoppelt)
                Fk = Fk * 2;
        }
        return Fk;
    },

    //----------------------------------------------------------------------------------
    // Bestimme passende Werkstoffe und einen Default für gegebene Temperaturen
    //----------------------------------------------------------------------------------
    getPassendeWerkstoffe : function(strMedienTemp, strRefTemp, actWerkstoff)
    {
        var retObj  = {aDisabled : [], aEnabled : [], strRecommended : ''};

        /*
            Hier gibt’s nach wie vor die beiden Varianten VGB und WIT.
            
            Vorgehensweise altes CASCADE:
                Wenn der Anwender eine Temperatur ändert, wird die Medientemperatur 
                als Ausgangsbasis für die Vorbelegung eines Werkstoffs genommen, 
                wenn er den Werkstoff ändert, nehmen wir die Referenztemperatur. 
                Effekt: In Grenzbereichen wird ein höherer Werkstoff empfohlen, 
                er kann aber auch noch manuell eins tiefer gehen.

                Basis ist die DB-Tabelle GRENZTEMP.
                Schlüsselfelder: mat (Werkstoffbez), DinEN (z.B. 1.7335), nr (wird im alten Cascade benutzt).

                Die Temperaturgrenzen der Werkstoffe stehen in uvgb, ovgb, uwit und owit.

                Zunächst wird geprüft, ob der aktuell selektierte Werkstoff in zulässigen Grenzen liegt. Wenn ja, passiert nichts weiter. Wenn nein, wird geprüft, welche Grenze verletzt wurde:
                •	Ist der aktuell selektierte Werkstoff nicht gut genug für die gewählte Temperatur (Temperatur > obere Grenze), gehen wir solange nach oben, bis ein passender kommt.
                •	Ist der aktuell selektierte Werkstoff zu gut für die gewählte Temperatur (Temperatur < untere Grenze), gehen wir solange nach unten, bis ein passender kommt.
            Neues Schema:
                wir disablen die Werkstoffe die gar nicht gehen (auf Basis Reftemp), dadurch wird
                unser Handler bei Click auf Werkstoffe gar nicht mehr aufgerufen.
                Bei Änderung Reftemp werden wir aufgerufen und belegen gleichzeitig eine Empfehlung vor
                auf Basis Mediumtemp.
        */
        
        var strFeldUGrenz = "uwit";
        var strFeldOGrenz = "owit";
        if (this.presets.m_grenz == "GRENZT_VGB")	// ASME bringt auch "GRENZT_VGB"
        {
            strFeldUGrenz = "uvgb";
            strFeldOGrenz = "ovgb";
        }
        var dMedienTemp = inputStringToDouble(strMedienTemp);
        var dRefTemp    = inputStringToDouble(strRefTemp);
        
        var strSQLStatement = "select * from GRENZTEMP order by abs(nr) ";
        var numRet = dbselect("CASCADE", strSQLStatement, "GRENZTEMP")
        if (numRet <= 0)
            return retObj;		// damit es weitergeht

        var nActWerkstoff = this.dataAccess.getZahlFromWerkstoff(actWerkstoff);
        var isPossible = true;      // Können wir den aktuellen Werkstoff noch benutzen?
        
        while (dbiseof("GRENZTEMP") == 0)
        {
            var nWS       = dbgetdouble("GRENZTEMP", "nr");
            var dDBugrenz = dbgetdouble("GRENZTEMP", strFeldUGrenz);
            var dDBogrenz = dbgetdouble("GRENZTEMP", strFeldOGrenz);
            
            if ((dRefTemp < dDBugrenz) || (dRefTemp > dDBogrenz))
            {
                retObj.aDisabled.push(this.dataAccess.getWerkstoffFromZahl(nWS));
                if (nActWerkstoff == nWS)
                    isPossible = false;
            }
			else{
				retObj.aEnabled.push(this.dataAccess.getWerkstoffFromZahl(nWS));
			}
            if ((dMedienTemp >= dDBugrenz) && (dMedienTemp <= dDBogrenz) &&
                (dRefTemp >= dDBugrenz) && (dRefTemp <= dDBogrenz) &&
                (retObj.strRecommended == ""))
                retObj.strRecommended = this.dataAccess.getWerkstoffFromZahl(nWS);
            
            dbskip("GRENZTEMP");
        }
        if (isPossible)
            retObj.strRecommended = this.dataAccess.getWerkstoffFromZahl(nActWerkstoff);
            
        if (dbiseof("GRENZTEMP") != 0)
         	return retObj;

    },

    CompTempKorr : function(/*int*/ N0, /*int*/ werk)
    {	
        var reihe;  // int
        var akttemp = 0, lasttemp = 0;
        var aktkorr = 0.0, lastkorr = 0.0, tmpkorr = 0.0, Kn = 0.0;

        // Kn = Ko - ((To - N0) / (To - Tu)) * (Ko -Ku)
        // Dazu müssen wir zunächst obere und untere Temp und KorrFakt für den
        // Werkstoff finden:

        // -mw- 30.3.95: bei Temperaturen unter 20°C werden (intern) die Kennwerte für 20°C benutzt.
        // Dadurch können wir auch Temperaturen unter 0°C erschlagen.
        var RefTemp = N0;       // die RefTemp die der Anwender sieht, kann auch < 20 sein (bis zu -10)
        if  (RefTemp < 20) RefTemp = 20;

        var wkorr = "WKORR";
        var strSQLStatement = "select * from WKORR "     // order by temp wär gut ;-)
        var numRet = dbselect("CASCADE", strSQLStatement, wkorr)
        if (numRet <= 0)
            return 0.001;		// damit es weitergeht

        // Werkstoff als Zahl ... wir haben eine Übersetzungsfunktion dafür
        reihe = werk + 1;		

        lasttemp = dbgetdouble(wkorr, "temp");
        lastkorr = dbgetdouble(wkorr, dbgetfieldname(wkorr, reihe));
        akttemp = lasttemp;
        aktkorr = lastkorr;
        while (dbiseof(wkorr) == 0)
        {	
            tmpkorr = dbgetdouble(wkorr, dbgetfieldname(wkorr, reihe));
            if (tmpkorr != 0.0)
            {	
                akttemp = dbgetdouble(wkorr, "temp");
                aktkorr = tmpkorr;
                if (akttemp >= RefTemp)
                {	break;
                }
                else
                {	lasttemp = akttemp;
                    lastkorr = aktkorr;
                }
            }
            dbskip(wkorr);
        }
        // @@@@@@ Achtung: Vergleiche jetzt auf double ...
        if (akttemp == RefTemp) 	// genau getroffen
        {	
            Kn = aktkorr;
        }
        else				// interpolieren
        {   
            if (akttemp == lasttemp)
            {	Kn = aktkorr;
            }
            else
            {	Kn = aktkorr - ((akttemp - RefTemp) / (akttemp - lasttemp)) * (aktkorr - lastkorr);
            }
        }

        if (Kn <= 0) return 0.001;		// um ggfalls Division durch 0 zu verhindern
        return Kn;
    },

    //----------------------------------------------------------------------------------
    // H-Schellen-Auslegung
    //----------------------------------------------------------------------------------
    //CompShowMSN : function(strLGG)
	CompShowDYN : function(strLGG)
    {
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		var N0					= this.dataAccess.getReferenzTemperatur(1);
        var Kn					= this.CompTempKorr(N0, this.dataAccess.getSchellenWerkstoffVorgabeAsInteger());
        var myHaenger			= this.topologieKlasse.getCurrentHaenger();
        if (myHaenger.m_Ptypid != "FSG"){
			var schelBetriebsLastH	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));		//"H"
			var schelBetriebsLastHZ	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("HZ-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("HZ+", 1, AchsDirInfo[6])));		//"HZ"
			var schelBetriebsLastHS	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("HS-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("HS+", 1, AchsDirInfo[6])));		//"HS"
			var schelBetriebsLast	= fround(Math.max(schelBetriebsLastH, schelBetriebsLastHZ / 1.5, schelBetriebsLastHS / 1.7), 2);
			if (schelBetriebsLastH*1 == 0){
				//setstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[" + AchsDirInfo[6] + "]", schelBetriebsLast);
				//setstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[" + AchsDirInfo[6] + "]", schelBetriebsLast);
				myHaenger.warmlast = schelBetriebsLast;
				myHaenger.kaltlast = schelBetriebsLast;
				this.topologieKlasse.setHaenger(myHaenger);
			}
			var schelKaltLast		= schelBetriebsLast;
		}
		else{
			var schelBetriebsLast	= this.GetSchelBetrLast();
			var schelKaltLast		= this.GetSchelKaltLast();
        }
		var m_dTestload			= this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
        var Fausl				= schelBetriebsLast / Kn;
		
        var b_nennweite     = this.dataAccess.getNennweite(1);
        var b_daemmdicke    = this.dataAccess.getDaemmdicke(1);
        var b_medientemp    = this.dataAccess.getMediumTemperatur(1);
        var alpha           = abs(this.dataAccess.getSollwerteSchraegzug(1).Alpha);
		var beta			= abs(this.dataAccess.getSollwerteSchraegzug(1).Beta);	//Achtung: dieser Wert entspricht dem "alten" Alpha
        var schelVorgabeWS  = this.dataAccess.getSchellenWerkstoffVorgabeAsInteger();
		
        // Return-Objekt für die H-Schellensuche:
        var retObjSuche = {success : 1, message : "", msn : null, msl : null};
        
        if (beta > 4)		// hier nicht zulässig
        {
            retObjSuche.message = translate("IDP_ALPHA_NICHT_ZULAESSIG"); 
			retObjSuche.success = 0;
            return retObjSuche;
        }
		/*
		if (schelVorgabeWS >= 6)
		{
			retObjSuche.message = translate("IDP_KEINE_SCHELLE_WS");
			retObjSuche.success = 0;
			return retObjSuche;
		}
        */
        // Jetzt müssen wir nach einer jeweils passenden Schelle suchen.
		// 1. MSN
		var ErrorDaemmMSN	= false;
		if (schelVorgabeWS < 6) {	// MSN gibt es nur bis 1.4571
			var resobj = this.SeekHschel(b_nennweite, Fausl, "MSN", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
			if (resobj.nw_exists && resobj.f_exists && !resobj.success)
				ErrorDaemmMSN	= true;
			if (resobj.success)
			{
				retObjSuche.msn = resobj.schelle;
				// Nur diese Schelle braucht noch die LGG:
				// (deshalb tun wir diese Info nicht in die allgemeine Init-Funktion hinein)
				retObjSuche.msn.m_strLGG = strLGG;  
				retObjSuche.msn.makeTyp();
			}
		}
        // 2. MSL -> hier ist alles anders
		var resobj = this.SeekDYNschel(schelBetriebsLast, "MSL", b_nennweite, strLGG, schelVorgabeWS, N0, b_daemmdicke);
		var ErrorDaemmMSL	= false;
		if (resobj.nw_exists && resobj.f_exists && !resobj.success){
			ErrorDaemmMSL	= true;
			if (schelVorgabeWS >= 6)
				ErrorDaemmMSN	= true;
		}
		if (resobj.success)
        {
            retObjSuche.msl = resobj.schelle;
			//retObjSuche.msl.m_strLGG = strLGG;  
            retObjSuche.msl.makeTyp();
        }
        if ( ErrorDaemmMSN && ErrorDaemmMSL )
		{
			retObjSuche.message = translate("IDP_MSNSCHELLE_DAEMMDICKE_ZU_GROSS");
			retObjSuche.success = 0;
		}
		if ( !retObjSuche.msn && !retObjSuche.msl ){
			retObjSuche.message += "\n" + translate("IDP_KEINE_SCHELLE_WS");
			retObjSuche.success = 0;
		}
		
        return retObjSuche;
    },

	legeHSchellenAus : function(lkTyp) 
	{
        // zur Prüfung, woran eine Auswahl gescheitert ist 
        // n = Nennweite, f = Last
        var znexist = 0, zfexist = 0, dnexist = 0, dfexist = 0, bnexist = 0, bfexist = 0, gnexist = 0, gfexist = 0;

        // Bei Mediumtemperatur unter 0: Korrekturfaktor = 1!
        // Zuerst berechnen wir die erforderliche Referenz-Temperatur N0:
        var N0 = this.dataAccess.getReferenzTemperatur(1);

        // dann den Temperatur-Korrekturfaktor Kn für den gewählten Werkstoff:
        var Kn = this.CompTempKorr(N0, this.dataAccess.getSchellenWerkstoffVorgabeAsInteger());

        // Achsinformationen
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
	
		// Jetzt haben wir N0 und Kn
        // Die Nennlast der Schelle muß größer als Fsoll / Kn sein:
        var schelBetriebsLast = this.GetSchelBetrLast();
        var schelKaltLast     = this.GetSchelKaltLast();
        var m_dTestload       = this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);

        var Fausl = schelBetriebsLast / Kn;

        // Jetzt müssen wir für die drei Schellentypen und die Ausführungen
        // nach einer jeweils passenden Schelle suchen.
 
        // Achtung: bei Sonder-Durchmesser muss der Standard-Durchmesser so gesetzt
        // sein, dass er der kleinste ist, der größer ist als der Sonder-Durchmesser
        var b_nennweite     = this.dataAccess.getNennweite(1);
        var b_daemmdicke    = this.dataAccess.getDaemmdicke(1);
        var b_medientemp    = this.dataAccess.getMediumTemperatur(1);
		var alpha           = abs(this.dataAccess.getSollwerteSchraegzug(1).Alpha);
		var beta			= abs(this.dataAccess.getSollwerteSchraegzug(1).Beta);
        var schelVorgabeWS  = this.dataAccess.getSchellenWerkstoffVorgabeAsInteger();
		
		if (getstring("IDC_LASTKETTE","DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "EINZEL_SCHELLE")
			this.topologieKlasse.a_lgv	=     sucheLGVzuLast(schelBetriebsLast).defaultLgv;
		var lgv			=	this.topologieKlasse.a_lgv;
        
        var lasche		=	null;
        var zwei		=	null;
        var drei		=	null;
        var bgel		=	null;
        var grip		=	null;
		var s_lasche_v	=	null;	// ZLV
		var s_lasche_b	=	null;	// ZLB
        
        var laschtyp;
        var resobj;
        
        // Zuerst die 2LochSchelle        
        
        // Zunächstmal 2Loch und 3Lochschellen nicht für Sondernennweiten ...
//        if (! this.dataAccess.getVorgabeSonderRAD())
//        {
            laschtyp = "ZVN";
            resobj = this.SeekHschel(b_nennweite, Fausl, "HZN", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
            if (resobj.nw_exists) znexist = 1;
            if (resobj.f_exists) zfexist = 1;
            if (resobj.success)
                zwei = resobj.schelle;
            else
            {   
                laschtyp = "ZVV";
                resobj = this.SeekHschel(b_nennweite, Fausl, "HZV", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                if (resobj.nw_exists) znexist = 1;
                if (resobj.f_exists) zfexist = 1;
                if (resobj.success)
                    zwei = resobj.schelle;
                else
                {
                    laschtyp = "ZVS";
                    resobj = this.SeekHschel(b_nennweite, Fausl, "HZS", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                    if (resobj.nw_exists) znexist = 1;
                    if (resobj.f_exists) zfexist = 1;
                    if (resobj.success)
                        zwei = resobj.schelle;
                }
            }
			
			// ZLV
			resobj = this.SeekSlascheV(b_daemmdicke, lgv, schelVorgabeWS, b_nennweite, b_medientemp)
			if (resobj.success == 1)
				s_lasche_v = resobj.lasche_v;
			else
				s_lasche_v = null;
			
			// ZLB
			resobj = this.SeekSlascheB(b_daemmdicke, lgv, schelVorgabeWS, b_nennweite, b_medientemp)
			if (resobj.success == 1)
				s_lasche_b = resobj.lasche_b;
			else
				s_lasche_b = null;
//        }
        
         // bei Rohrschräge > 4° nur noch 2Lochschellen!
        if (beta <= 4)
        {
//            if (! this.dataAccess.getVorgabeSonderRAD())
//            {
                resobj = this.SeekHschel(b_nennweite, Fausl, "HDN", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                if (resobj.nw_exists) dnexist = 1;
                if (resobj.f_exists) dfexist = 1;
                if (resobj.success)
                    drei = resobj.schelle;
                else
                {	resobj = this.SeekHschel(b_nennweite, Fausl, "HDV", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                    if (resobj.nw_exists) dnexist = 1;
                    if (resobj.f_exists) dfexist = 1;
                    if (resobj.success)
                        drei = resobj.schelle;
                    else
                    {	resobj = this.SeekHschel(b_nennweite, Fausl, "HDS", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                        if (resobj.nw_exists) dnexist = 1;
                        if (resobj.f_exists) dfexist = 1;
                        if (resobj.success)
                            drei = resobj.schelle;
                    }
                }
//            }
            
            resobj = this.SeekHschel(b_nennweite, Fausl, "HBN", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
            if (resobj.nw_exists) bnexist = 1;
            if (resobj.f_exists) bfexist = 1;
            if (resobj.success)
                bgel = resobj.schelle;
            else
            {	resobj = this.SeekHschel(b_nennweite, Fausl, "HBV", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                if (resobj.nw_exists) bnexist = 1;
                if (resobj.f_exists) bfexist = 1;
                if (resobj.success)
                    bgel = resobj.schelle;
                else
                {	resobj = this.SeekHschel(b_nennweite, Fausl, "HBS", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWS);
                    if (resobj.nw_exists) bnexist = 1;
                    if (resobj.f_exists) bfexist = 1;
                    if (resobj.success)
                        bgel = resobj.schelle;
                }
            }
				// Gripschellen nur für diese Werkstoffe suchen:
				// if (grip->m_Pwerkstoff == W_RST || grip->m_Pwerkstoff == W_13CRMO || grip->m_Pwerkstoff == W_4541)
				// also: 0, 2, 4 sind erlaubt, Nachtrag 05/2008 schm: 5 (W_4571) ist jetzt auch erlaubt
				// Nachtrag 29.5.08: ist für die Temperatur 16Mo3 (1) ausgewählt, muss FL für die
				// Gripschelle mit W_13CRMO (2) suchen.
				if ((schelVorgabeWS == 0) || (schelVorgabeWS == 1) || (schelVorgabeWS == 2) || (schelVorgabeWS == 4) || (schelVorgabeWS == 5))  
				{
					var schelVorgabeWSGrip = schelVorgabeWS;
					if (schelVorgabeWS == 1)
						schelVorgabeWSGrip = 2;
					resobj = this.SeekHschel(b_nennweite, Fausl, "HGN", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWSGrip);
					if (resobj.nw_exists) gnexist = 1;
					if (resobj.f_exists) gfexist = 1;
					if (resobj.success)
						grip = resobj.schelle;
					else
					{	resobj = this.SeekHschel(b_nennweite, Fausl, "HGV", Kn, beta, schelKaltLast, schelBetriebsLast, m_dTestload, b_daemmdicke, schelVorgabeWSGrip);
						if (resobj.nw_exists) gnexist = 1;
						if (resobj.f_exists) gfexist = 1;
						if (resobj.success)
							grip = resobj.schelle;
					}
				}
        }

        // Dämmdicke für 2LochSchelle abchecken, evtl. auch ob das gewünschte Material f.d.
        // Schellen geht, Lasche f. Zweilochschelle.
        if ((zwei != null) && (lkTyp != "EINZEL_SCHELLE") && 
			(b_daemmdicke > 0 || b_medientemp >= 100 || beta > 4))   // brauchen Lasche
        {
            // -Schu- Laschen sind auch für die kleinen NW definiert (nur Katalog ab DN 250)
			// nur Prüfung "beta" notwendig -> mit in "Eingangsprüfung"
			/*
			// Laschen nur für NW >= 250 oder aber bei großer Rohrschräge:
            if (((zwei.m_Ptypid == "HZN") && ((beta > 4) || (b_nennweite >= 250))) ||
                ((zwei.m_Ptypid == "HZV") && ((beta > 4) || (b_nennweite >= 100))) ||
                ((zwei.m_Ptypid == "HZS") && ((beta > 4) || (b_nennweite >= 150))))
            
			{
			*/
				resobj = this.SeekLasche(laschtyp, b_nennweite, b_daemmdicke, schelVorgabeWS);
                // Achtung bei kleinen NW und Rohrschräge stoßen die Laschen ans Rohr
				// zulassen im ExpertMode -> Lasche anschrägen
				var ExpertMode	= getstring("EXPERT_MODE","RIGHTS")*1;
				if (beta > 4 && b_nennweite < 100 && !ExpertMode)
					resobj.success	= 0;
				
				if (resobj.success)
                {
                    lasche = resobj.lasche;
                    zwei.max_daemm = resobj.dMaxDaemmdickeLasche;
                }
                else
                    zwei = null;
            /*
			}
            else
                zwei = null;
			*/
        }

        // Falls gar nichts gefunden, aber mindestens bei einer gabs Nennweite und Last: Dämmdicke zu hoch
        var strMessage = "";
        var success = 1;
        if (((zwei == null) && (drei == null) && (bgel == null) && (grip == null)) &&
				(s_lasche_v == null) && (s_lasche_b == null) &&
				((znexist && zfexist) || (dnexist && dfexist) ||
				(bnexist && bfexist) || (gnexist && gfexist)) )
        {
            strMessage = translate( "IDP_HSCHELLE_DAEMMDICKE_ZU_GROSS" );
            success = 0;
        }

        // Ergebnisse in Store zur späteren Verwendung
		if (!this.topologieKlasse.bDoppelt)
			delete ("TMP.CASELECTIONS.SCHELLE", "");
        if (lasche != null)
            lasche.serializeOut("TMP.CASELECTIONS.SCHELLE.LASCHE");
        if (zwei != null)
            zwei.serializeOut("TMP.CASELECTIONS.SCHELLE.ZWEILOCHSCHELLE");
        if (drei != null)
            drei.serializeOut("TMP.CASELECTIONS.SCHELLE.DREILOCHSCHELLE");
        if (bgel != null)
            bgel.serializeOut("TMP.CASELECTIONS.SCHELLE.BUEGELSCHELLE");
        if (grip != null)
            grip.serializeOut("TMP.CASELECTIONS.SCHELLE.GRIPSCHELLE");
		if (s_lasche_v != null)
            s_lasche_v.serializeOut("TMP.CASELECTIONS.SCHELLE.S_Lasche_V");
		if (s_lasche_b != null)
            s_lasche_b.serializeOut("TMP.CASELECTIONS.SCHELLE.S_Lasche_B");
 
        // Return-Objekt für die H-Schellensuche:
        var retObjSuche = {success : success, message : strMessage, zwei : zwei, drei : drei, bgel : bgel, grip : grip, s_lasche_v :s_lasche_v, s_lasche_b :s_lasche_b};
        
        return retObjSuche;
	},

	SeekLasche : function(/*string*/ laschtyp, b_nennweite, b_daemmdicke, b_werkstoff) 
	{
        var retObj = {success : 0, lasche : {}};
        
        var strSQLStatement = "select * from " + laschtyp    // order by ...
        var numRet = dbselect("CASCADE", strSQLStatement, "LASCHE_SELECT")
        
        if (numRet <= 0)
            return retObj;

        var dNabLasche           = 0.0;
        var dNbisLasche          = 0.0;
        var dMaxDaemmdickeLasche = 0.0;
        var dWerkstoffLasche     = 0.0;
        var dEmassLasche         = 0.0;
        var dGewichtLasche       = 0.0;

        while (dbiseof("LASCHE_SELECT") == 0)
        {
            dNabLasche           = dbgetdouble("LASCHE_SELECT", "DN_AB");
            dNbisLasche          = dbgetdouble("LASCHE_SELECT", "DN_BIS");
            dMaxDaemmdickeLasche = dbgetdouble("LASCHE_SELECT", "J");
            dWerkstoffLasche     = dbgetdouble("LASCHE_SELECT", "werk");
            dEmassLasche         = dbgetdouble("LASCHE_SELECT", "E");
            dGewichtLasche       = dbgetdouble("LASCHE_SELECT", "gewicht");

            if (dNabLasche  <= b_nennweite &&
                dNbisLasche >= b_nennweite &&
                dMaxDaemmdickeLasche >= b_daemmdicke)
            {	
                // jetzt kommts noch auf das Material an
                if (dWerkstoffLasche >= b_werkstoff)
                {	// u.U. müssen wir einen besseren Werkstoff nehmen, um die erforderliche
                    // Dämmdicke zu erreichen
                    break;
                }
                if (b_werkstoff > 2 && dWerkstoffLasche == 2)
                {   // für bessere Werkstoffe als 13CrMo haben wir keine Daten;
                    // Wir nehmen die Daten der 13CrMo-Lasche und den gewünschten (besseren) Werkstoff
                    dWerkstoffLasche = b_werkstoff;
                    break;
                }
            }
             dbskip("LASCHE_SELECT");
        }
        if (dbiseof("LASCHE_SELECT") != 0)
         	return retObj;

        retObj.success = 1;
        
        retObj.lasche = new Zubehoer();
        retObj.lasche.InitZV(laschtyp, 
                             this.topologieKlasse.a_lgv, 
                             WerkstoffeZahlZuId[dWerkstoffLasche], 
                             b_nennweite,
                             dEmassLasche,
                             dGewichtLasche);
        retObj.dMaxDaemmdickeLasche = dMaxDaemmdickeLasche;
        // retObj.lasche = {typ : typ, nennw : nennw, dMaxDaemmdickeLasche : dMaxDaemmdickeLasche};

        /*
        lasch->InitZV(laschtyp, a_lgv, mat, b_nennweite, laschdb->GetInt(laschdb->GetFieldNr("E")),
                     laschdb->GetDouble(laschdb->GetFieldNr("gewicht")), m_pMyDoc);
        */
        return retObj;
    },
	
	SeekSlascheV : function(b_daemmdicke, lgv, schelVorgabeWS, b_nennweite, b_medientemp)
	{
	
		var retObj = {success : 0, s_lasche_v : {}};
		var numRet = 0;
		
		while ((schelVorgabeWS <= 3) && (numRet <=0))
		{
			var strSQLStatement = "select * from ZLV where LGV="+lgv+" and abs(J)>="+b_daemmdicke+" and werk="+schelVorgabeWS+" ";
			numRet = dbselect("CASCADE", strSQLStatement, "ZLV");
			if (numRet == 1)
			{
				var lasche_v		=	"ZLV";
				var Emass			=	dbgetdouble("ZLV", "E");
				var masse			=	dbgetdouble("ZLV", "gewicht");
				var JmaxSLascheV	=	dbgetdouble("ZLV", "J");
				
				var strSQLStatement = "select * from ROHRD where abs(NENNWEITE) = " + (b_nennweite*1) +" ";
				numRet	= dbselect("CASCADE", strSQLStatement, "ROHRD");
				var dA				=	dbgetdouble("ROHRD", "D");
				
				retObj.success = 1;
				
				retObj.lasche_v = new Horizontalschelle();
				retObj.lasche_v.InitSL(lasche_v,
									   lgv,
									   WerkstoffeZahlZuId[schelVorgabeWS],
									   Emass,
									   masse,
									   dA,
									   b_nennweite,
									   b_daemmdicke,
									   b_medientemp);
					
				retObj.JmaxSLascheV = JmaxSLascheV;
			}
			schelVorgabeWS = schelVorgabeWS + 1;
		}
		
		return retObj;
	},
	
	SeekSlascheB : function(b_daemmdicke, lgv, schelVorgabeWS, b_nennweite, b_medientemp)
	{
		var retObj = {success : 0, s_lasche_b : {}};
		var numRet = 0;
		
		while (((schelVorgabeWS <= 3) || (schelVorgabeWS >= 4 && schelVorgabeWS <= 5)) && (numRet <=0))
		{
			var strSQLStatement = "select * from ZLB where DN="+b_nennweite+" and abs(maxLGV)>="+lgv+" and abs(J)>="+b_daemmdicke+" and werk="+schelVorgabeWS+" ";
			numRet = dbselect("CASCADE", strSQLStatement, "ZLB");
			if (numRet == 1)
			{
				var lasche_b		=	"ZLB";
				var Emass			=	dbgetdouble("ZLB", "E");
				var masse			=	dbgetdouble("ZLB", "gewicht");
				var JmaxSLascheV	=	dbgetdouble("ZLB", "J");
				var strSQLStatement = "select * from ROHRD where abs(NENNWEITE) = " + (b_nennweite*1) +" ";
				numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
				var dA				=	dbgetdouble("ROHRD", "D");
				
				retObj.success = 1;
				
				retObj.lasche_b = new Horizontalschelle();
				retObj.lasche_b.InitSL(lasche_b,
									   lgv,
									   WerkstoffeZahlZuId[schelVorgabeWS],
									   Emass,
									   masse,
									   dA,
									   b_nennweite,
									   b_daemmdicke,
									   b_medientemp);
					
				retObj.JmaxSLascheB = JmaxSLascheB;
				}
			schelVorgabeWS = schelVorgabeWS + 1;
		}
		
		return retObj;
	},
	
	SeekDYNschel : function(schelBetriebsLast, typ, b_nennweite, strLGG, schelVorgabeWS, N0, b_daemmdicke)
	{
		// Korrekturen
		// die Nennlast stimmt erst ab 13kN
		strLGG		= (strLGG*1 < 13 ? "0005" : strLGG);
		// bei St37 wird die Schelle aus St52 gewählt, weil es diese aus St37 nicht gibt
			if (schelVorgabeWS*1 == 0)
				//schelVorgabeWS	= 11;
				schelVorgabeWS	= 12;
		var retObj	= {success : 0, schelle : null, nw_exists : 0, f_exists : 0};
		var numRet	= 0;
		var strSQLStatement	= "select * from " + typ + " where abs(F_DYN) = abs(" + strLGG*1 + ") and abs(DN) = abs(" + b_nennweite + ")";
		numRet		= dbselect("CASCADE", strSQLStatement, "MSL");
		//if (numRet < 1)
		//var isSonderDA	= getbool("IDC_AUSSENDURCHMESSER_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		var isSonderDA	= getstring("IDC_AUSSENDURCHMESSER_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		if (toupper(isSonderDA) == "ON" || toupper(isSonderDA) == "TRUE")
			isSonderDA	= true;
		if (numRet < 1 || isSonderDA)
			return retObj;
		var material_soll	= WerkstoffeZahlZuId[schelVorgabeWS];
		
		for (var i = 0; i < numRet; i++)
        {
			var material_DB		= WerknamenDB[WerkstoffeNrZuNamen[dbgetstring("MSL", "MATERIAL")]];
			if (material_DB == material_soll && N0 >= dbgetdouble("MSL", "T_MIN") && N0 <= dbgetdouble("MSL", "T_MAX") && b_daemmdicke*1 <= dbgetdouble("MSL", "MAX_ISO")){
				if (!dbgetdouble("MSL", "ABM_AB") || N0 <= dbgetdouble("MSL", "ABM_AB")){
					// Schelle geht
					retObj.success	= 1;
				}
				else{
					// Last prüfen
					var GrenzTemp	= dbgetdouble("MSL", "ABM_AB");
					var FN_max		= dbgetdouble("MSL", "F_T" + GrenzTemp);
					var MaxTemp		= dbgetdouble("MSL", "T_MAX");
					var FN_min		= dbgetdouble("MSL", "F_T" + MaxTemp);
					var RefTempU	= Math.floor(N0/10) * 10;
					var RefTempO	= Math.ceil(N0/10) * 10;
					// Bestimmung der beiden Lasten zwischen denen interpoliert werden soll
					var serchF_U	= true;
					var serchF_O	= true;
					var RefLoadO	= 0;
					var RefLoadU	= 0;
					while((RefTempU >= GrenzTemp || RefTempO <= MaxTemp) && (serchF_O || serchF_U)){
						if (serchF_O){
							RefLoadO	= dbgetdouble("MSL", "F_T" + RefTempO);
							if (RefLoadO != 0)
								serchF_O	= false;
							else
								RefTempO	+= 10;
						}
						if (serchF_U){
							RefLoadU	= dbgetdouble("MSL", "F_T" + RefTempU);
							if (RefLoadU != 0)
								serchF_U	= false;
							else
								RefTempU	-= 10;
						}
					}
					var Fzul_N0	= RefLoadO;
					if (RefTempO != RefTempU)
						Fzul_N0	= fround(RefLoadO + ((RefLoadU-RefLoadO)/(RefTempO-RefTempU)*(RefTempO-N0)), 1);
					if (Fzul_N0 >= schelBetriebsLast){
						retObj.success	= 1;
					}
				}
				
				if (retObj.success){
					i = numRet;	// wir brauchen nicht weitersuchen
					var Emass		= dbgetdouble("MSL", "E_MIN");
					var Emass_max	= dbgetdouble("MSL", "E_MAX");
					var E_del		= dbgetdouble("MSL", "E_DEL");
					var d_Bol		= dbgetdouble("MSL", "C");
					var masse		= dbgetdouble("MSL", "WEIGHT_E_MIN");
					var masse_del	= dbgetdouble("MSL", "WEIGHT_E_DEL");
					var dA			= dbgetdouble("MSL", "D");
					var E_OK		= false;
					var Qty_E_del	= 0;
					while (!E_OK && E_mass <= Emass_max){
						var J_kann		= Emass - (dA / 2) - (3.67 * d_Bol);
						if (J_kann >= b_daemmdicke){
							E_OK	= true;
							masse	+= (Qty_E_del * masse_del);
						}
						else{
							Emass	+= E_del;
							Qty_E_del++;
						}
					}
					
					retObj.nw_exists	= 1;
					retObj.f_exists		= 1;
					retObj.schelle		= new Horizontalschelle();
					retObj.schelle.InitMSL( typ,
											strLGG,
											WerkstoffeZahlZuId[schelVorgabeWS],
											Emass,
											masse,
											dA,
											b_nennweite,
											b_daemmdicke,
											N0);
				}
			}
			dbskip("MSL");
        }
		return retObj;
	},

	SeekHschel : function(/*int*/ nennw, /*double*/ last, /*int*/ typ, 
                          /*double*/ Kn, beta, schelKaltLast, schelBetriebsLast, 
                          m_dTestload, b_daemmdicke, schelVorgabeWS) 
	{
        var i = 0;
        var traglast = 0.0;
        var retObj = {nw_exists : 0, f_exists : 0, success : 0, schelle : {}};
        var strSQLStatement = "select * from " + this.GetProduktTabelle(typ, 1);  // order by ...
        var numRet = dbselect("CASCADE", strSQLStatement, "SCHEL_SELECT");
        
        if (numRet <= 0)
            return retObj;
        
        var dNennweiteSchelle        = 0.0;
        var dNennLastSchelle         = 0.0;
        var dNennLastSchelleVertikal = 0.0;
        var dMaxDaemmdickeSchelle    = 0.0;
        var dWerkstoffSchelle        = 0;
        var bLastOK = 0;

        while (dbiseof("SCHEL_SELECT") == 0)
        {	
            // = dbgetstring(hydrafed, "nennweg");
            dNennweiteSchelle = dbgetdouble("SCHEL_SELECT", "nennweite");
 
            if (compareInt(dNennweiteSchelle, nennw))
            {	
                retObj.nw_exists = 1;

                bLastOK = 0;
                dNennLastSchelle = dbgetdouble("SCHEL_SELECT", "fn");

                if (abs(beta) <= 4)
                {
                    if ((dNennLastSchelle >= last)  && 
                        (dNennLastSchelle >= schelKaltLast) &&
                        ((dNennLastSchelle * 2.5 / 1.1) >= m_dTestload)  // -mw- 8/2000 neu
                        )	// mehrfach gleiche Nennweite möglich
                        bLastOK = 1;
                }
                else
                {
                    // erweiterter Tragfähigkeitsnachweis
                    dNennLastSchelleVertikal = dbgetdouble("SCHEL_SELECT", "fv");
                    var FNvorh = schelBetriebsLast * CosDeg(beta);
                    var FVvorh = schelBetriebsLast * SinDeg(beta);
                    var FNTrag = dNennLastSchelle * Kn;
                    var FVTrag = dNennLastSchelleVertikal * Kn;
                    if ( (FNTrag >= FNvorh) &&
                         (FVTrag >= FVvorh) &&
                         (FNvorh / FNTrag + FVvorh / FVTrag <= 1 ) &&
                         ((dNennLastSchelle * 2.5 / 1.1) >= m_dTestload)  // -mw- 8/2000 neu
                         )
                        bLastOK = 1;
                }
                if (bLastOK)
                {	
                    retObj.f_exists = 1;
                    dMaxDaemmdickeSchelle = dbgetdouble("SCHEL_SELECT", "J");
                    dWerkstoffSchelle     = dbgetdouble("SCHEL_SELECT", "werk");

                    // Grip, Dreiloch, Bügel: teste Dämmdicke und Werkstoff:
                    //if ( ! (typ == "HZN" || typ == "HZV" || typ == "HZS"))		
					if (left(typ, 2) != "HZ")
                    {	
                        // -mw- Cascade alt: Wenn Vorgabe Werkstoff > 2 (d.h. besser als das, was wir in der
                        // DB haben, nimm die erste passende Schelle (nicht mehr nur die 2er):
                        // -mw- 05/2008: bei Dreilochschellen soll bei Werkstoffen > 2
                        // immer auf Werkstoff 2 gegangen werden, nicht auf schlechtere!
						
						// -Sch- pruefWS zur Festlegung des E-Masses für warmfeste WS
						if (left(typ, 2) == "HD" && nennw <= 40)
							var pruefWS = 3;	// 10CrMo9-10
						else
							var pruefWS = 2;	// 13CrMo4-5
						
						// -Sch- Edelstahl-E-Mass abhaengig von "J"
						//20181213 -Schu- "MS" hat hier noch gefehlt
						if ((left(typ, 2) == "HD") || ((left(typ, 2) == "HB" || left(typ, 2) == "HG" || left(typ, 2) == "MS") &&
							(schelVorgabeWS != 4 && schelVorgabeWS != 5)))
                        {
                            if ((b_daemmdicke <= dMaxDaemmdickeSchelle) &&
                                ((dWerkstoffSchelle == schelVorgabeWS)	// bewirkt, dass Werkstoff passen muss
                                 || ((schelVorgabeWS > pruefWS) && (dWerkstoffSchelle == pruefWS)) ) ) // oder aber wir suchen > 2 und haben 2, das geht auch
                            {	
                                break;
                            }
                        }
                        else
                        {
                            if (b_daemmdicke <= dMaxDaemmdickeSchelle &&
                                (dWerkstoffSchelle >= schelVorgabeWS	// bewirkt, dass auch bessere Schellen wg. Dämmdicke genommen werden können
                                 || (schelVorgabeWS > pruefWS) ) )
                            {	
                                break;
                            }
                        }
                    }
                    else
                    { 	break;
                    }
                }
            }
            dbskip("SCHEL_SELECT");
        }
        if (dbiseof("SCHEL_SELECT") != 0)
         	return retObj;
        
        traglast = dNennLastSchelle * Kn;

        // Schelle wird mit vorgegebenem Werkstoff belegt oder mit dem aus der
        // Datenbank, je nachdem, welcher "besser" ist. (gilt nicht für 2-Loch)
        var nWerkstoffSchelle  = schelVorgabeWS;

        if (! ((typ == HZN) || (typ == HZV) || (typ == HZS)))
        {
            if ((dWerkstoffSchelle > schelVorgabeWS))
                nWerkstoffSchelle = dWerkstoffSchelle;
        }

        retObj.success = 1;
        retObj.schelle = new Horizontalschelle();

        var dE       = dbgetdouble("SCHEL_SELECT", "E");
        var dGewicht = dbgetdouble("SCHEL_SELECT", "gewicht");

        // dSonderAussendurch ... enthält hier immer den Aussendurchm. egal ob Std oder Sonder        
        var dAussendurch = this.dataAccess.getRohrAussendurchmesser(1);

        retObj.schelle.Init(/*int*/     typ, 
                            /*int*/     nennw, 
                            /*char **/  this.topologieKlasse.a_lgv, 
                            /*int*/     WerkstoffeZahlZuId[nWerkstoffSchelle], 
                            /*int*/     dMaxDaemmdickeSchelle, 
                            /*int*/     dE, 
                            /*double*/  dGewicht, 
                            /*double*/  traglast, 
                            /*double*/  dNennLastSchelle,
                            /*BOOL*/    this.dataAccess.getVorgabeSonderRAD(), 
                            /*double*/  dAussendurch,    
                            /*int*/     0, 
                            /*double*/  beta,
                                        schelBetriebsLast,
                                        b_daemmdicke,
                                        this.dataAccess.getMediumTemperatur(1),
                                        this.dataAccess.getUmgebungsTemperatur(1),
                                        this.dataAccess.getReferenzTemperatur(1)); 

/**
        erg->Init(typ, nennw, a_lgv, nWerkstoffSchelle, dMaxDaemmdickeSchelle, 
              hschel->GetInt(hschel->GetFieldNr("E")),
              hschel->GetDouble(hschel->GetFieldNr("gewicht")), traglast,
              hschel->GetDouble(hschel->GetFieldNr("fn")), 
              m_bSonderRAD, b_aussendurch, 0, m_dAlpha, m_pMyDoc);
**/

        return retObj;
    },
    
	legeVSchellenAus : function(strLGG) 
	{
        var N1 = 0.0;
        var Kn = 0.0;
        
        // unsere Schellenkandidaten:
        var vbk = null;
        var vxk = null;
        var vxr = null;
        var vgr = null;
        var vsr = null;
        var vpr = null;

        var retObjSuche = {success : 0, message : "", vbk : vbk, vxk : vxk, vxr : vxr, vgr : vgr, vsr : vsr, vpr : vpr};
        
        var b_nennweite			= this.dataAccess.getNennweite(1);
		var b_aussendurchmesser	= this.dataAccess.getRohrAussendurchmesser(1);
        var b_daemmdicke		= this.dataAccess.getDaemmdicke(1);
        var b_spannweite		= this.dataAccess.getSpannweite(1);
        var b_medientemp		= this.dataAccess.getMediumTemperatur(1);
        var alpha				= abs(this.dataAccess.getSollwerteSchraegzug(1).Alpha);
        var beta				= abs(this.dataAccess.getSollwerteSchraegzug(1).Beta);	//Achtung: dieser Wert entspricht dem "alten" Alpha
		var schelVorgabeWS		= this.dataAccess.getSchellenWerkstoffVorgabeAsInteger();

        var strMessage = "";
		
        // Zuerst berechnen wir die erforderliche Referenz-Temperatur N0:
        var N1 = this.dataAccess.getReferenzTemperatur(1);

        // dann den Temperatur-Korrekturfaktor Kn für den gewählten Werkstoff:
        var Kn = this.CompTempKorr(N1, this.dataAccess.getSchellenWerkstoffVorgabeAsInteger());
        if (Kn < 0)
            return retObjSuche;

		// Achsinformationen
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		
		// Jetzt haben wir N0 und Kn
        // Die Nennlast der Schelle muß größer als Fsoll / Kn sein:
        var myHaenger			= this.topologieKlasse.getCurrentHaenger();
        if (left(myHaenger.m_Ptypid, 2) = "SS"){
			var schelBetriebsLastH	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));		//"H"
			var schelBetriebsLastHZ	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("HZ-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("HZ+", 1, AchsDirInfo[6])));		//"HZ"
			var schelBetriebsLastHS	= Math.max(Math.abs(this.dataAccess.getSollwerteLast("HS-", 1, AchsDirInfo[6])),
										Math.abs(this.dataAccess.getSollwerteLast("HS+", 1, AchsDirInfo[6])));		//"HS"
			var schelBetriebsLast	= fround(Math.max(schelBetriebsLastH, schelBetriebsLastHZ / 1.5, schelBetriebsLastHS / 1.7), 2);
			if (schelBetriebsLastH*1 == 0){
				//setstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[" + AchsDirInfo[6] + "]", schelBetriebsLast);
				//setstring("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[" + AchsDirInfo[6] + "]", schelBetriebsLast);
				myHaenger.warmlast = schelBetriebsLast;
				myHaenger.kaltlast = schelBetriebsLast;
				this.topologieKlasse.setHaenger(myHaenger);
			}
			var schelKaltLast		= schelBetriebsLast;
		}
		else{
			var schelBetriebsLast = this.GetSchelBetrLast();
			var schelKaltLast     = this.GetSchelKaltLast();
		}
        var m_dTestload       = this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]);
		
        var Fausl = schelBetriebsLast / Kn;
		
        var FauslLGG = Fausl / 2;
        
		if (strLGG == "")   // z.B. bei Einzelauswahl Schelle
        {
            var LastLGG = 0;
			if (getbool("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")){
				if (FauslLGG <= 8)
					LastLGG = 8;
				else if (FauslLGG <= 18)
					LastLGG = 18;
				else if (FauslLGG <= 46)
					LastLGG = 46;
				else if (FauslLGG <= 100)
					LastLGG = 100;
				else if (FauslLGG <= 200)
					LastLGG = 200;
				else if (FauslLGG <= 350)
					LastLGG = 350;
				else if (FauslLGG <= 550)
					LastLGG = 550;
				//strLGG = sprintf("%.3d", LastLGG);
			}
			else{
				if (FauslLGG <= 8)
					LastLGG = 8;
				else if (FauslLGG <= 13)
					LastLGG = 13;
				else if (FauslLGG <= 32)
					LastLGG = 32;
				else if (FauslLGG <= 45)
					LastLGG = 45;
				else if (FauslLGG <= 78)
					LastLGG = 78;
				else if (FauslLGG <= 130)
					LastLGG = 130;
				else if (FauslLGG <= 234)
					LastLGG = 234;
				else if (FauslLGG <= 380)
					LastLGG = 380;
				else if (FauslLGG <= 600)
					LastLGG = 600;
			}
			strLGG = sprintf("%.4d", LastLGG);
        }
		
		// Prüfen, ob die Spannweite ausreichend groß gewählt wurde
		var SPWTest	= TestSpannweite(b_aussendurchmesser, b_daemmdicke, b_spannweite, this.GetLGVfromLast(), this.topologieKlasse.getCurrentHaenger());
		
		if (SPWTest.ErrorSpw)
			strMessage	+= SPWTest.strMessage;
		
		// Prüfen der zulässigen Rohrschräge
		if ((beta != 0) && (beta < 86))
        {
            // Meldung:
            retObjSuche.message += (strMessage != "" ? strMessage + "\n" : "") + translate("IDP_ROHRSCHRAEG_VERTIKAL");
            return retObjSuche;
        }
        
        var retObj;

        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();

        // Wir legen hier mal alle möglichen V-Schellen aus ... in der - jetzt nicht mehr -Sch- 2010-01-27
        // Oberfläche wird später entschieden, welche zur Auswahl angeboten werden.
        var bSpannweiteExist = 0;
		// Expert-Mode
		var isExpert	= getstring("EXPERT_MODE", "RIGHTS")*1;
		
        if (lkLastabtragung != "STUETZEND_DOPPEL")		// -Sch- 2010-01-27
		{
			// Auslegung VBK:
			retObj = this.SeekVSchelle("VBK", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vbk = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
			strMessage += retObj.strMessage;
			
			// Auslegung VKK, VJK
			if (schelVorgabeWS < 6 || isExpert)
			{
				retObj = this.SeekVSchelle("VKK", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
				if (retObj.success)
				{
					vxk = retObj.schelle;
					bSpannweiteExist++;
				}
				else
					bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
				strMessage += retObj.strMessage;
			}
			
			// Auslegung VKR, VJR
			retObj = this.SeekVSchelle("VKR", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vxr = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
				strMessage += retObj.strMessage;
			
			retObj = this.SeekVSchelle("VGR", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vgr = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
			strMessage += retObj.strMessage;
		}
        if ((lkLastabtragung == "STUETZEND_DOPPEL") || ((lkLastabtragung != "STUETZEND_DOPPEL") && (this.topologieKlasse.bHaenger == "0")))	// -Sch- 2010-01-27
		{
			retObj = this.SeekVSchelle("VSR", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vsr = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
			strMessage += retObj.strMessage;
				
			retObj = this.SeekVSchelle("VPR", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vpr = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
			strMessage += retObj.strMessage;
			// hier fehlt noch die VGR für SSG
			retObj = this.SeekVSchelle("VGR", b_nennweite, b_spannweite, Fausl, this.GetSchelKaltLast(), m_dTestload, Kn, schelBetriebsLast, strLGG);
			if (retObj.success)
			{
				vgr = retObj.schelle;
				bSpannweiteExist++;
			}
			else
				bSpannweiteExist = bSpannweiteExist + retObj.bSpannweiteExist;
			strMessage += retObj.strMessage;
		}
		
        if (bSpannweiteExist <= 0 && !ErrorSpw)  // d.h. nichts gefunden, immer Spannweite nicht vorhanden und der Hinweis ist noch nicht da
            strMessage += translate("MSG_ERR_SPANNWEITE_AUSSERHALB_BEREICH") + "\n";   

        // Ergebnisse in Store zur späteren Verwendung
        delete ("TMP.CASELECTIONS.SCHELLE", "");
        if (vbk != null)
            vbk.serializeOut("TMP.CASELECTIONS.SCHELLE.VBK");
        if (vxk != null)
            vxk.serializeOut("TMP.CASELECTIONS.SCHELLE.VXK");
        if (vxr != null)
            vxr.serializeOut("TMP.CASELECTIONS.SCHELLE.VXR");
        if (vgr != null)
            vgr.serializeOut("TMP.CASELECTIONS.SCHELLE.VGR");
        if (vsr != null)
            vsr.serializeOut("TMP.CASELECTIONS.SCHELLE.VSR");
        if (vpr != null)
            vpr.serializeOut("TMP.CASELECTIONS.SCHELLE.VPR");

        // Return-Objekt für die V-Schellensuche:
        retObjSuche = {success : success, message : strMessage, vbk : vbk, vxk : vxk, vxr : vxr, vgr : vgr, vsr : vsr, vpr : vpr};

        return retObjSuche;        
	},

	SeekVSchelle : function(/*string*/ vtable, /*int*/ nNennweite, /*int*/ nSpannweite, 
					  /*double*/ dFausl, /*double*/ dKaltLast, /*double*/ dTestload, Kn, 
                      schelBetriebsLast, strLGG, schelVorgabeWS) 
	{
        if (!schelVorgabeWS)
			schelVorgabeWS	= false;
		
		var nSpannweiteFuerSuche = nSpannweite;

        // Erst mal prüfen, ob unsere Spannweite in einem zulässigen Intervall liegt
        var nSpannweiteMin = 0;
        var nSpannweiteMax = 32000;
        var bExactMatch = 0;

        var bNennweiteExist = 0;
        var bSpannweiteExist = 0;
        
        var retObj = {bNennweiteExist : 0, bSpannweiteExist : 0, strMessage : '', success : 0, schelle : {}};

        var strSQLStatement = "select * from " + vtable;    // order by ...
        var numRet = dbselect("CASCADE", strSQLStatement, "SCHEL_SELECT");
        
        if (numRet <= 0)
            return retObj;
        
        var nIstSpannweite = 0;
        var nIstNennweite = 0;
        var dFn = 0.0;

        while (dbiseof("SCHEL_SELECT") == 0)
        {	
            nIstSpannweite = dbgetdouble("SCHEL_SELECT", "spann");
            if ((nIstSpannweite <= nSpannweite) && (nIstSpannweite > nSpannweiteMin))
                nSpannweiteMin = nIstSpannweite;
            if ((nIstSpannweite >= nSpannweite) && (nIstSpannweite < nSpannweiteMax))
                nSpannweiteMax = nIstSpannweite;
            if (compareInt(nIstSpannweite, nSpannweite))
                bExactMatch = 1;
            dbskip("SCHEL_SELECT");
        }
        if (! bExactMatch)
        {
            nSpannweiteFuerSuche = nSpannweiteMax;	// wir suchen den kleinsten, der größer ist

            // 10.11.2009: Auch Minimum soll geprüft werden
            if (nSpannweiteMin == 0)
                return retObj;
        }
        
        dbgotop("SCHEL_SELECT");
        while (dbiseof("SCHEL_SELECT") == 0)
        {	
            nIstNennweite   = dbgetdouble("SCHEL_SELECT", "nennweite");
            nIstSpannweite  = dbgetdouble("SCHEL_SELECT", "spann");
            dFn             = dbgetdouble("SCHEL_SELECT", "fn");
            
            if (compareInt(nIstNennweite, nNennweite))
            {	
                bNennweiteExist = 1;
                if (compareInt(nIstSpannweite, nSpannweiteFuerSuche))
                {	
                    bSpannweiteExist = 1;
                    if ( (dFn >= dFausl) &&
                         (dFn >= dKaltLast) &&
                         ((dFn * 2.5 / 1.1) >= dTestload) ) // -mw- 8/2000 neu)
                    {	break;
                    }
                }
            }
            dbskip("SCHEL_SELECT");
        }

        if (dbiseof("SCHEL_SELECT") != 0)
         	return retObj;

        var groesse  = dbgetdouble("SCHEL_SELECT", "GROESSE_SH");
        var gewicht  = dbgetdouble("SCHEL_SELECT", "gewicht");
        var nennlast = dbgetdouble("SCHEL_SELECT", "fn");
        var traglast = nennlast * Kn;  

        var typid = vtable;
        var ek = 0.0, typ = 0;
        
        if (vtable == "VKK")
        {
            ek  = dbgetdouble("SCHEL_SELECT", "E");
            // typ = dbgetdouble("SCHEL_SELECT", "typ");
            // if (compareInt(typ, 1))  { typid = "VJK";}
            // else	                { typid = "VKK";}
            typid = "VKK";
        }
        else if (vtable == "VKR")
        {
            ek  = dbgetdouble("SCHEL_SELECT", "E");
            // typ = dbgetdouble("SCHEL_SELECT", "typ");
            // if (compareInt(typ, 1))  { typid = "VJR";}
            // else	                { typid = "VKR";}
            typid = "VKR";
        }
        else if (vtable == "VGR")
        {
            ek  = dbgetdouble("SCHEL_SELECT", "E");
            gewicht  = dbgetdouble("SCHEL_SELECT", "gewG"); // Achtung abweichender Feldname!!
            typ = dbgetdouble("SCHEL_SELECT", "FORM");
        }
        else if (vtable == "VSR")
        {
            ek  = dbgetdouble("SCHEL_SELECT", "E");
            gewicht  = dbgetdouble("SCHEL_SELECT", "gewS"); // Achtung abweichender Feldname!!
            typ = dbgetdouble("SCHEL_SELECT", "FORM");
        }
        else if (vtable == "VPR")
        {
            ek  = dbgetdouble("SCHEL_SELECT", "E");
            gewicht  = dbgetdouble("SCHEL_SELECT", "gewP"); // Achtung abweichender Feldname!!
            typ = dbgetdouble("SCHEL_SELECT", "FORM");
        }
		
		// Achtung, bei Sonderspannweite kann "typ" von "FORM" in der Tabelle abweichen!!!

        var mySchelle = new Vertikalschelle ();
        
		if (!schelVorgabeWS)
			schelVorgabeWS  = this.dataAccess.getSchellenWerkstoffVorgabeAsInteger();
		else
			schelVorgabeWS	= this.dataAccess.getZahlFromWerkstoff(schelVorgabeWS);
        
        mySchelle.Init( typid, 
                        nNennweite, 
                        nIstSpannweite, 
                        nennlast, 
                        groesse, 
                        this.topologieKlasse.a_lgv,
                        WerkstoffeZahlZuId[schelVorgabeWS], 
                        typ, 
                        ek, 
                        gewicht, 
                        traglast, 
                        this.dataAccess.getVorgabeSonderRAD(),
                        this.dataAccess.getRohrAussendurchmesser(1),
                        this.dataAccess.getVorgabeSonderSpann(), 
                        nSpannweite, 
                        strLGG,   
                        schelBetriebsLast,
                        this.dataAccess.getMediumTemperatur(1),
                        this.dataAccess.getUmgebungsTemperatur(1),
                        this.dataAccess.getReferenzTemperatur(1),
                        this.dataAccess.getDaemmdicke(1) );      

        // Bei stützend doppel noch die Verschiebungen prüfen ...
			if ((vtable == "VPR") || (vtable == "VSR"))
			{
				var dWX = Math.abs(this.dataAccess.getSollwerteBewegung("lateral", 1));
				var dWY = Math.abs(this.dataAccess.getSollwerteBewegung("axial", 1));
				var dg  = mySchelle.getMass("TMP.VS_ADDITIONAL_DATA", "g");  // @@@ setzt voraus, dass init unmittelbar vorher gelaufen ist!
				var df  = mySchelle.getMass("TMP.VS_ADDITIONAL_DATA", "f");
				var Haenger = caMainController.topologieKlasse.getCurrentHaenger();
				var tmpPath = "TMP.XX_ADDITIONAL_DATA";
				var dMassP = 0;
				if (Haenger && Haenger.getAdditionalDataToStore(tmpPath) != -1)
					dMassP = getdouble("P", tmpPath);
				var strMessage = "";
				if (vtable == "VPR")
				{
					// if ((((dg - 10) - dMassP) > 0) && (((dg - 10) - dMassP) < dWX))
					if (((dg - 10) - (dMassP - 20)) < dWX)
						strMessage = typid + " " + translate("IDP_VERSCHIEBUNG_VSCHELLE_WX") + "\n";
					// if ((((df - 10) - dMassP) > 0) && (((df - 10) - dMassP) < dWY)) 
					if (((df - 10) - (dMassP-20)) < dWY)
						strMessage = typid + " " + translate("IDP_VERSCHIEBUNG_VSCHELLE_WY") + "\n";
				}
				else
				{
					// if (((dg - dMassP) > 0) && ((dg - dMassP) < dWX))
					if (0.2*dg  < dWX)
						strMessage = typid + " " + translate("IDP_VERSCHIEBUNG_VSCHELLE_WX") + "\n";
					if (0.2*df < dWY)
						strMessage = typid + " " + translate("IDP_VERSCHIEBUNG_VSCHELLE_WY") + "\n";
				}
				if (strMessage != "")
				{
					retObj.strMessage = strMessage;
					retObj.bSpannweiteExist = bSpannweiteExist;		// -Sch- 2010-01-27
					return retObj;
				}
			}
        
        retObj.success = 1;
        retObj.bNennweiteExist = bNennweiteExist;
        retObj.bSpannweiteExist = bSpannweiteExist;
        retObj.schelle = mySchelle;

        return retObj;
    },
	
	TestSpannweite : function(b_aussendurchmesser, b_daemmdicke, b_spannweite, LGV, myHanger)
	{
		var ErrorSpw	= false;
		var strMessage	= "";
		if (b_aussendurchmesser *1 + 2 * b_daemmdicke >= b_spannweite - 2 * LGV){
			strMessage	+= translate("IDC_INFO") + "\n"
						+ translate("SPANNWEITE") + ": " + b_spannweite + "mm\n"
						+ translate("AUSSENDURCHMESSER") + " + 2x " + translate("IDC_DAEMMDICKE_LABEL") + ": " + fround(b_aussendurchmesser * 1 + 2 * b_daemmdicke, 0) + "mm\n"
						+ translate("MSG_ERR_SPANNWEITE_AUSSERHALB_BEREICH") + "\n";
			ErrorSpw	= true;
		}
		else {	// Abstand zwischen den Hängern Prüfen
			var CheckLen	= b_spannweite;
			if (myHanger && myHanger.isKHaenger()){
				if (myHanger.isStuetze() || myHanger.isHaengerStehend()){	// KSR / KSP / KHS / KVS
					if (myHanger.m_Ptypid != "KVS")
						//CheckLen	= b_spannweite -
						CheckLen	-=	max(getstring("L", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("X", "TMP.KH_ADDITIONAL_DATA")*1,
										getstring("N", "TMP.KH_ADDITIONAL_DATA")*1,
										getstring("B", "TMP.KH_ADDITIONAL_DATA")*1);
					else
						CheckLen	-=	max(getstring("KL_E", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("X", "TMP.KH_ADDITIONAL_DATA")*1 + (getstring("M", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("T", "TMP.KH_ADDITIONAL_DATA")*1)/2,
										getstring("N", "TMP.KH_ADDITIONAL_DATA")*1);
				}
				else{	// KHD / KVD
					if (myHanger.m_Ptypid == "KVD")
						CheckLen	-=	max(getstring("L", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("X", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("G", "TMP.KH_ADDITIONAL_DATA")*1,
										getstring("B", "TMP.KH_ADDITIONAL_DATA")*1);
					else
						CheckLen	-=	max(getstring("L", "TMP.KH_ADDITIONAL_DATA")*1 - getstring("X", "TMP.KH_ADDITIONAL_DATA")*1,
										getstring("B", "TMP.KH_ADDITIONAL_DATA")*1);
				}
			}
			else if (myHanger && myHanger.isFHaenger()){	// Achtung hier auch SSG und SSB
				if (myHanger.isStuetze() || myHanger.isHaengerStehend()){	// FSS / FSP / FHS / FSG
					CheckLen	-=	getstring("M", "TMP.FH_ADDITIONAL_DATA")*1;
				}
				else{
					if (left(myHanger.m_Ptypid, 2) != "SS")	// FHD / FHG
						CheckLen	-=	getstring("D", "TMP.FH_ADDITIONAL_DATA")*1;
					else{
						if (myHanger.m_Ptypid == "SSG"){
							CheckLen	-=	getstring("D_F2", "TMP.FH_ADDITIONAL_DATA")*1;
							if (CheckLen == b_spannweite)	// D_F2 exsistiert nicht -> LI
								CheckLen	-=	getstring("D", "TMP.FH_ADDITIONAL_DATA")*1;
						}
						if (myHanger.m_Ptypid == "SSB")
							CheckLen	-=	getstring("D1", "TMP.FH_ADDITIONAL_DATA")*1;
					}
				}
			}
			else if (myHanger){
				CheckLen	-=	(LGV*1 < 56 ? 3*LGV : 2*LGV);
			}
			if (b_aussendurchmesser * 1 + 2 * b_daemmdicke >= CheckLen){
				//var T1	= b_aussendurchmesser;
				//var T2	= 2 * b_daemmdicke;
				//var T3	= fround(b_aussendurchmesser * 1 + 2 * b_daemmdicke, 0);
				strMessage	+= translate("IDC_INFO") + "\n"
							+ translate("Haenger/Stuetze") + " <--> " + translate("Haenger/Stuetze") + ": " + fround(CheckLen, 0) + "mm\n"
							+ translate("AUSSENDURCHMESSER") + " + 2x " + translate("IDC_DAEMMDICKE_LABEL") + ": " + fround(b_aussendurchmesser * 1 + 2 * b_daemmdicke, 0) + "mm\n"
							//+ translate("MSG_ERR_SPANNWEITE_AUSSERHALB_BEREICH") + "\n";
							+ "\n";
				ErrorSpw	= true;
			}
		}
		var oRet={ErrorSpw : ErrorSpw, strMessage : strMessage};
		return oRet;
	},

    sucheTraeger : function(strTraegerTyp)
    {
        var passendeTraeger = { traeger: [] };
        
        var strTableName = "";
        switch (strTraegerTyp)	
        {
            case "INP":
                strTableName = "TRAEGER_INP";
                break;
            case "IPE":
                strTableName = "TRAEGER_IPE";
                break;
            case "HEA":
                strTableName = "TRAEGER_HEA";
                break;
            case "HEB":
                strTableName = "TRAEGER_HEB";
                break;
            case "HEM":
                strTableName = "TRAEGER_HEM";
                break;
            case "HP":
                strTableName = "TRAEGER_HP_A";
                break;
            case "M":
                strTableName = "TRAEGER_M_A";
                break;
            case "W":
                strTableName = "TRAEGER_W_A";
                break;
            case "SONDER":
                strTableName = "";
                break;
        }

        if (strTableName != "") // else: nothing todo, deliver empty Array
        {
            var strSQLStatement = "select * from " + strTableName    // order by ....
            var numRet = dbselect("CASCADE", strSQLStatement, "TRAEGER")
            if (numRet <= 0)
            {	
                return ret;   
            }
            var t1 = "", Btr = "", tG = "", Htr = "";
            var fnIst  = 0.0;
            while (dbiseof("TRAEGER") == 0)
            {
                t1  = dbgetstring("TRAEGER", "kuerzel");
                Btr = dbgetstring("TRAEGER", "Btr");
                tG  = dbgetstring("TRAEGER", "tG");
                Htr = dbgetstring("TRAEGER", "Htr");

                // if (strVorgabeGroesse == t1)
                //    nIndexVorgabeGroesse = i;

                passendeTraeger.traeger.push( { value: t1, text: t1, Btr: Btr, tG: tG, Htr: Htr } );
                
                dbskip("TRAEGER");
            }
        }
        return passendeTraeger;
    },

    setHaengerOptions : function(strBeschichtung, strBlockierung, strWoher)
    {
		// ---- -mw- 02/2009: Hängerobjekt komplett neu initialisieren, da wir sonst bei zurück und Wechsel auf
		// blockiert nicht mehr das Originalobjekt haben ... damit könnte Code in AuswahlHängergrößeController, setValuesAction entfallen.
		var pathDlg = "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE";
		var strSelectedHaenger = "";
		var curHaenger = null;
		if (strWoher != "FROM_TYPSUCHE") 
		{
			if (getstring("ACT_SELECTED_HANGERTYPE", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE") == "F") 
			{
				strSelectedHaenger = getstring("IDC_ALTERNATIVEN", pathDlg);
				curHaenger = new Federhaenger();
				curHaenger.serializeIn("TMP.CASELECTIONS.FHAENGER.VARIANTEN[" + strSelectedHaenger + "].HAENGER");
			}
			else
			{
				strSelectedHaenger = getstring("IDC_ALTERNATIVEN_KH", pathDlg);
				curHaenger = new Konstanthaenger();
				curHaenger.serializeIn("TMP.CASELECTIONS.KHAENGER.VARIANTEN[" + strSelectedHaenger + "].HAENGER");
			}
			
			this.topologieKlasse.setHaenger(curHaenger);
			// --- Ende Hänger-Objekt initialisieren
		}
		else
			curHaenger = this.topologieKlasse.getCurrentHaenger();
		
        // Diese Funktion wird nur für Feder- oder Konstanthänger aufgerufen
        curHaenger.m_Pblock = strBlockierung;
        curHaenger.m_Pbeschicht = strBeschichtung;
        
        if (curHaenger && (curHaenger instanceof Federhaenger))
        {
            var strSQLStatement = "select * from HYDRAFED where abs(LASTGROESSE) = "+curHaenger.groesse+" and abs(NENNWEG) = "+curHaenger.nennweg+" ";
            var numRet = dbselect("CASCADE", strSQLStatement, "HAENGER")
            var fMin = 0, fMax = 0, Frate = 0;
            if (numRet >= 0)
            {
                fMin  = dbgetdouble("HAENGER", "MINLAST");
                fMax  = dbgetdouble("HAENGER", "MAXLAST");
                Frate = dbgetdouble("HAENGER", "FEDERRATE") / 1000;
            }
        
            if (strBlockierung == "BLOCK_MITTIG")
            {
				/** Vorgabe 19.1.2009
				Bei FH mit Blpckierung "mittig" dient die eingegebene Last nur zur
				Bestimmung der Hängergröße.
				Für FK gilt immer: (Fmin + Fmax)/2  (unabhängig ob Sollast= Warmlast
				oder Kaltlast

				Eingabewert Bewegung sS = 20 mm
				sS immer positiv, egal ob Bewegung "Auf" oder "Ab"

				z-Bewegung = +- sS / 2  = +- 10 (Eingabewert wird jeweils zur Hälfte in
				Bewegung "Auf" und Bewegung "Ab" aufgeteilt
				Wegreserve oben = Wegreserve unten = (sN - sS) / 2  = 40
				Warmlast1 = FK  - R * sS / 2  = 4.65  - 0.47 = 4.18
				Warmlast2 = FK + R * sS / 2  = 4.65 + 0.47 = 5.12
				Laständerung = ( R * sS / 2 ) / Warmlast1 * 100 = 0.47 / 4.18 * 100 =
				11.2 %
				Natürlich sollten wir auch die beiden Warmlasten in den Massenauszug
				schreiben.
				***/
                var fMittel = (fMin + fMax) / 2;

                if (strWoher == "FROM_TYPSUCHE")
                {
                    curHaenger.sollweg = 0;   
                    curHaenger.res_oben = (curHaenger.nennweg / 2);
                    curHaenger.res_unten = (curHaenger.nennweg / 2);
                    if ((fMittel > 0) && (fMin > 0) && (Frate > 0))
                        curHaenger.vorspann = (fMittel - fMin) / Frate;  // in mm
                    else
                        curHaenger.vorspann = -1;
                    curHaenger.warmlast = fMittel;
                    curHaenger.kaltlast = fMittel;

                    curHaenger.SollastHpkt = fMittel;
                    curHaenger.Zusatzlast  = 0;
                }
                else
                {
                    // curHaenger.sollweg = 0;   // z.B. bei 20 mm: Ausdruck +- 10
                    curHaenger.res_oben = (curHaenger.nennweg - curHaenger.sollweg) / 2;
                    curHaenger.res_unten = (curHaenger.nennweg - curHaenger.sollweg) / 2;
                    curHaenger.vorspann = curHaenger.nennweg/2;	// sonst kommt ein falsches E-Mass raus
					curHaenger.kaltlast = fMittel;
                    var calcWarmlast1 = fround(curHaenger.kaltlast + Frate * curHaenger.sollweg / 2, 1);
                    var calcWarmlast2 = fround(curHaenger.kaltlast - Frate * curHaenger.sollweg / 2, 1);
                    curHaenger.warmlast = calcWarmlast1;	// die größere in das Standard-Feld, wg. u.a. der Schellenauslegung
                    curHaenger.warmlast2 = calcWarmlast2;	
                    curHaenger.lastabw  = fround((Frate * curHaenger.sollweg / 2) / calcWarmlast2 * 100, 2);
 
                    // curHaenger.SollastHpkt = fMittel;
                    curHaenger.Zusatzlast  = 0;
                }
                
                curHaenger.m_Pzeichnr = "BLOCKIERUNG_MITTIG";
            }
            else if (strBlockierung == "BLOCK_NEIN")
            {
                curHaenger.sollweg = 0;
                curHaenger.res_oben = 0;
                curHaenger.res_unten = curHaenger.nennweg;
                curHaenger.vorspann = 0;
                curHaenger.warmlast = fMin;
                curHaenger.kaltlast = fMin;

                curHaenger.SollastHpkt = 0;
                curHaenger.Zusatzlast  = 0;
                
                this.dataAccess.setSollwerteRichtungBewegung("AB");
                
                curHaenger.m_Pzeichnr = "IDC_FH_BLOCKNEIN";
            }
        
        }
        if (curHaenger && (curHaenger instanceof Konstanthaenger))
        {
            if (strBlockierung == "BLOCK_MITTIG")
            {
                curHaenger.weg_res   = (curHaenger.nennweg - curHaenger.sollweg) /2;
                curHaenger.res_min   = curHaenger.weg_res;		// pro Endlage!

                curHaenger.m_Pzeichnr = "BLOCKIERUNG_MITTIG";
                
                if (strWoher == "FROM_TYPSUCHE")
                {
                    var strSQLStatement = "select * from HYDRAKON where abs(LGR) = "+curHaenger.groesse+" ";
                    var numRet = dbselect("CASCADE", strSQLStatement, "HAENGER")
                    var fMax = 0;
                    if (numRet >= 0)
                    {
                        fMax  = dbgetdouble("HAENGER", "FMAX");
                        var fMittel = fround(0.8 * fMax * 200 / curHaenger.nennweg, 2);
                        
                        curHaenger.SollastHpkt = fMittel;
                        curHaenger.sollast = fMittel;
                    }                
                }
            }
            else if (strBlockierung == "BLOCK_NEIN") // das ist derzeit nicht zulässig:                
                curHaenger.m_Pzeichnr = "IDC_KH_BLOCKNEIN";
        }
    },
    
    getPruefungAbnahme : function(nAnzLK)
    {
        var retObj = {dKostenPruefungAbnahme: 0, 
                      dKostenDokumentation: 0, 
                      dKostenKennzeichnung: 0,
                      dKennzeichnungHaengerPreis: 0,
                      dKennzeichnungStrebenPreis: 0,
                      dVormontageZubehoerPreis: 0,
                      dPositionierungPreis: 0,
                      aTextDokumentation: [], 
                      aTextKennzeichnung: []
                      };
        
        var strSQLStatement = "select * from ZUS_LEIS_P ";
        var numRet = dbselect("CASCADE", strSQLStatement, "ZUS_LEIS_P");
        var preisDoku = {};
        while (dbiseof("ZUS_LEIS_P") == 0)
        {	
            preisDoku[dbgetstring("ZUS_LEIS_P", "ART")] = dbgetdouble("ZUS_LEIS_P", "P0");
            dbskip("ZUS_LEIS_P");
        }
        strSQLStatement = "select * from ZUS_LEIS_K ";
        numRet = dbselect("CASCADE", strSQLStatement, "ZUS_LEIS_K");
        var preisKennz = {};
        while (dbiseof("ZUS_LEIS_K") == 0)
        {	
            preisKennz[dbgetstring("ZUS_LEIS_K", "ART")] = dbgetdouble("ZUS_LEIS_K", "P0");
            dbskip("ZUS_LEIS_K");
        }
        
        var dDokumentationPreis = 0;
        var dKennzeichnungPreis = 0;
        
        var nMult = 1;
        /* -mw- 04/2008: vermutlich doch nicht pro Hänger ... oder doch? */
        if (this.topologieKlasse.bDoppelt)
            nMult = 2;
        
        var Haenger = this.topologieKlasse.getCurrentHaenger();
        var Schelle	= this.topologieKlasse.Schelle;
		
		if (typeof(this.topologieKlasse.Lager) != "undefined" && this.topologieKlasse.Lager != null){
			var Lager	= this.topologieKlasse.Lager;
		}
		else if (typeof(this.topologieKlasse.TopoLager2.Lager) != "undefined" && this.topologieKlasse.TopoLager2.Lager != null){
			var Lager	= this.topologieKlasse.TopoLager2.Lager;
		}
		else if (typeof(this.topologieKlasse.Sattel) != "undefined" && this.topologieKlasse.Sattel != null){
			var Lager	= this.topologieKlasse.Sattel;
		}
		else{
			var Lager	= this.topologieKlasse.TopoLager2.Sattel;
		}
		
        // Prüfung / Dokumentation:
		// 01;Last-Weg-Protokoll FH pro Stück;;;;;
		// 02;Last-Weg-Protokoll KH pro Stück;;;;;
		// 03;Werksbescheinigung 2.1 für Produkte pro Auftrag;;;;;
		// 04;Werkszeugnis 2.2 für Produkte pro Auftrag;;;;;
		// 05;Prüfbescheinigung 3.1B für Federn pro Halterungspunkt;;;;;
		// 06;Prüfbescheinigung 3.1B für warmfeste Werkstoffe pro Auftrag;;;;;
		// 07;Prüfbescheinigung 3.1B für austenitische Werkstoffe pro Auftrag;;;;;
        if (tolower(this.presets.LASTWEG_PROT_FH) == "true")
        {
            if ( Haenger && Haenger.isFHaenger() &&
                 (Haenger.m_Ptypid != "SSG"))
            {
                dDokumentationPreis += berechneNettoPreis(preisDoku['01'] * nMult * nAnzLK, this.presets.LASTWEG_RAB);
                retObj.aTextDokumentation.push(translate("IDC_LASTWEG_PROT_TEXT")+" "+translate("IDC_LASTWEG_PROT_FH"));
            }
        }
        if (tolower(this.presets.LASTWEG_PROT_KH) == "true")
        {
            if ( Haenger && Haenger.isKHaenger() )
            {
                dDokumentationPreis += berechneNettoPreis(preisDoku['02'] * nMult * nAnzLK, this.presets.LASTWEG_RAB);
                retObj.aTextDokumentation.push(translate("IDC_LASTWEG_PROT_TEXT")+" "+translate("IDC_LASTWEG_PROT_KH"));
            }
        }
        if (tolower(this.presets.PRUEFBESCH_FEDERN) == "true")
        {
            if ( (Haenger && Haenger.isHaenger()) && Haenger.m_Ptypid != "SSG" )
            {
                dDokumentationPreis += berechneNettoPreis(preisDoku['05'], this.presets.PRUEFBESCH_RAB);
                retObj.aTextDokumentation.push(translate("IDC_PRUEFBESCH_TEXT")+" "+translate("IDC_PRUEFBESCH_FEDERN"));
            }
        }
        if (tolower(this.presets.PRUEFBESCH_PROD_21) == "true")
        {
            dDokumentationPreis += berechneNettoPreis(preisDoku['03'], this.presets.PRUEFBESCH_RAB);
            retObj.aTextDokumentation.push(translate("IDC_PRUEFBESCH_TEXT")+" "+translate("IDC_PRUEFBESCH_PROD_21"));
        }
        if (tolower(this.presets.PRUEFBESCH_PROD_22) == "true")
        {
            dDokumentationPreis += berechneNettoPreis(preisDoku['04'], this.presets.PRUEFBESCH_RAB);
            retObj.aTextDokumentation.push(translate("IDC_PRUEFBESCH_TEXT")+" "+translate("IDC_PRUEFBESCH_PROD_22"));
        }
        // nur wenn entsprechende Schelle / Lager da ....
        if ((tolower(this.presets.PRUEFBESCH_WARMFEST) == "true") &&
            //((Schelle && (Schelle.getOberFlaechenSchutzGruppe() == 3)) ||
            ((Schelle &&
			((Schelle.getOberFlaechenSchutzGruppe() == 3) || (Schelle.getOberFlaechenSchutzGruppe() == 9 && left(Schelle.m_Ptypid, 2) == "ZL" && Schelle.m_Pwerkstoff != "W_RST"))) ||
			(Lager && (left(right (Lager.m_Ptyp,4),2) < 41 || left(right (Lager.m_Ptyp,4),2) > 80) && Lager.m_Pwerkstoff != "W_RST")))
        {
            dDokumentationPreis += berechneNettoPreis(preisDoku['06'], this.presets.PRUEFBESCH_RAB);
            retObj.aTextDokumentation.push(translate("IDC_PRUEFBESCH_TEXT")+" "+translate("IDC_PRUEFBESCH_WARMFEST"));
        }
        if ((tolower(this.presets.PRUEFBESCH_AUSTENIT) == "true") &&
            ((Schelle && (Schelle.getOberFlaechenSchutzGruppe() == 4)) ||
			(Schelle && left(right (Schelle.m_Ptyp,4),2) >= 41 && left(right (Schelle.m_Ptyp,4),2) <= 80 && Schelle.m_Pwerkstoff != "W_RST") ||
			(Lager && left(right (Lager.m_Ptyp,4),2) >= 41 && left(right (Lager.m_Ptyp,4),2) <= 80 && Lager.m_Pwerkstoff != "W_RST")))
        {
            dDokumentationPreis += berechneNettoPreis(preisDoku['07'], this.presets.PRUEFBESCH_RAB);
            retObj.aTextDokumentation.push(translate("IDC_PRUEFBESCH_TEXT")+" "+translate("IDC_PRUEFBESCH_AUSTENIT"));
        }
            
        // Kennzeichnung:
		// 01;Hänger/stützen mit Typenschild;;;;;
		// 02;Gelenkstreben mit Aufkleber;;;;;
		// 03;Vormomtage Zubehör einschl. Kennzeichnung nach Halterungspunkt;;;;;
		// 04;Positionierung einschl. Kennzeichnung der Teile nach Halterungspunkt;;;;;
        
        var dKennzeichnungHaengerPreis = 0;
        var dKennzeichnungStrebenPreis = 0;
        var dVormontageZubehoerPreis = 0;
        var dPositionierungPreis = 0;

        var bEchteLK = 1;
        if (this.topologieKlassenName == "CaTopoEinzel")
            bEchteLK = 0;
        
        /********  04/2008: Auf Wunsch Fr. Geiger entfernt.
        if (tolower(this.presets.KENNZEICHNUNG_HAENG) == "true")
        {
            if ( Haenger && Haenger.isHaenger()  &&
                 (Haenger.m_Ptypid != "SSG"))
            {
                dKennzeichnungHaengerPreis = preisKennz['01'] * nMult;
                dKennzeichnungPreis += preisKennz['01'] * nMult;
                retObj.aTextKennzeichnung.push(translate("IDC_KENNZEICHNUNG_HAENG"));
            }
        }
        if (tolower(this.presets.KENNZEICHNUNG_GSTREBEN) == "true")
        {
            if ( Haenger && (Haenger.m_Ptypid == "SSG"))
            {
                dKennzeichnungStrebenPreis = preisKennz['02'] * nMult;
                dKennzeichnungPreis += preisKennz['02'] * nMult;
                retObj.aTextKennzeichnung.push(translate("IDC_KENNZEICHNUNG_GSTREBEN"));
            }
        }
        ********/
        
		if ((tolower(this.presets.KENNZEICHNUNG_ANDERE) == "true") && bEchteLK)
		{
            dVormontageZubehoerPreis = berechneNettoPreis(preisKennz['03'], this.presets.VORMONTAGE_RAB);
            dKennzeichnungPreis += dVormontageZubehoerPreis;
            retObj.aTextKennzeichnung.push(translate("IDC_KENNZEICHNUNG_ANDERE"));
        }
		if ((tolower(this.presets.KENNZEICHNUNG_POSITIONIERUNG) == "true") && bEchteLK)
		{
            dPositionierungPreis = berechneNettoPreis(preisKennz['04'], this.presets.POSITIONIERUNG_RAB);
            dKennzeichnungPreis += dPositionierungPreis;
            retObj.aTextKennzeichnung.push(translate("IDC_KENNZEICHNUNG_POSITIONIERUNG"));
        }
            
        if (getstring("PCODE", "CATALOG.SETTINGS") == "630927")
        {
            retObj.dKennzeichnungHaengerPreis = dKennzeichnungHaengerPreis; 
            retObj.dKennzeichnungStrebenPreis = dKennzeichnungStrebenPreis; 
            retObj.dVormontageZubehoerPreis = dVormontageZubehoerPreis; 
            retObj.dPositionierungPreis = dPositionierungPreis; 
        
            retObj.dKostenDokumentation = dDokumentationPreis; 
            retObj.dKostenKennzeichnung = dKennzeichnungPreis;
            retObj.dKostenPruefungAbnahme = dDokumentationPreis + dKennzeichnungPreis;
        }
        return retObj;
    },
    
    // true, bei einem Nicht-konfigurierbaren Einzelprodukt
    getNichtKonfigurierbaresEinzelprodukt : function()
    {
        var Haenger		= this.topologieKlasse.getCurrentHaenger();
		var LagerInfo	= this.topologieKlasse.getSpecialLagerInfo();

        if (LagerInfo.bIsEinzelprodukt && !LagerInfo.bIsConfigurable)
			return 1;
		// 10/2008: Bei Einzelproduktauswahl können SOnderteile ergänzt werden, dann wird sie zur Lastkette
        var bEchteLK = 1;
        if ((this.topologieKlassenName == "CaTopoEinzel") &&
            (this.topologieKlasse.Sonderteile.length <= 0))
            bEchteLK = 0;
        
        // Echte oder Dummy-Lastkette (Hänger): KDE-Kenner auf Blank setzen
        if ((bEchteLK) || (Haenger && Haenger.isHaenger()))
            return 0;

        // Prüfen ob Einzelprodukt konfigurierbar ist:
        var stkList = [];
        this.topologieKlasse.getStueckliste(stkList);
        if (stkList.length > 0)
        {
            var stkPart = stkList[0].produkt;
            if (stkPart)
            {
                retObj  = stkPart.getASTLDaten(this);   
                // Konfigurierbares Einzelprodukt: KDE-Kenner auf Blank setzen
                if (retObj.loeseauf)
                    return 0;
            }
        }
        // Nicht-konfigurierbares Einzelprodukt:
        return 1;
    },
    
    getARKTX : function()
    {
        var strRet = "";
        if (this.topologieKlassenName != "CaTopoEinzel")
            return strRet;

        if (this.topologieKlasse.Haenger && this.topologieKlasse.Haenger.isSAPKonfigurierbar())
            return this.topologieKlasse.Haenger.m_Ptyp;
        if (this.topologieKlasse.Schelle && this.topologieKlasse.Schelle.isSAPKonfigurierbar())
            return this.topologieKlasse.Schelle.m_Ptyp;
        if (this.topologieKlasse.Zubehoer && this.topologieKlasse.Zubehoer.isSAPKonfigurierbar())
            return this.topologieKlasse.Zubehoer.m_Ptyp;
        // Sonderfall: ZRM gilt bei uns nicht als konfigurierbar, ist es aber in SAP:
        if (this.topologieKlasse.Zubehoer && this.topologieKlasse.Zubehoer.m_Ptypid == "ZRM")
            return this.topologieKlasse.Zubehoer.m_Ptyp;
        if (this.topologieKlasse.Lager)
        {
            var oProfil = Cascade.Lagerkonfiguration.holeProfilformUndTraegerbreiteFuerDB( this.topologieKlasse.Lager );
            if (this.topologieKlasse.Lager.isSAPKonfigurierbar(oProfil))
                return this.topologieKlasse.Lager.m_Ptyp;
        }
        if (this.topologieKlasse.Klemmsystem && this.topologieKlasse.Klemmsystem.isSAPKonfigurierbar())
            return this.topologieKlasse.Klemmsystem.m_Ptyp;
                    
        return strRet;
    },
    
    getKZKDE : function(bSonderProduktKDE)
    {
        var strRet = " ";
        var Haenger   = this.topologieKlasse.getCurrentHaenger();
        var Schelle   = this.topologieKlasse.Schelle;
        var Lager     = this.topologieKlasse.Lager;
        var Zubehoer  = this.topologieKlasse.Zubehoer;
        var Klemmsystem = this.topologieKlasse.Klemmsystem;
        var oLKinfo   = this.dataAccess.getLKinfoDaten();
        var oOptions  = this.presets.getPreisOptions();
        var bEchteLK = 1;
        // if (this.topologieKlassenName == "CaTopoEinzel")
		if (this.topologieKlassenName == "CaTopoEinzel" ||
			(this.topologieKlassenName == "CaTopoLager2" && this.topologieKlasse.isSingleProduct()))
            bEchteLK = 0;
        
        // wenn Lastkette oder konfigurierbares Einzelprodukt (aufgelöste Stückliste): ' ' zurückgeben
        if (! this.getNichtKonfigurierbaresEinzelprodukt())
            return strRet;

        // wenn Lastkette: ' ' zurückgeben
        if (bEchteLK)
            return strRet;

        /*
        if (Haenger && Haenger.isHaenger() && (Haenger.m_Pbeschicht == "TERROSON"))
            strRet = "X";
        */
        
        if (!bEchteLK && Schelle && ((Schelle.m_Poberfl == "OB_SONST") || (oOptions.SONDERANSTRICH_TEXT != "") || (oLKinfo.bemerkung != "")))
            strRet = "X";

        if (!bEchteLK && Lager && ((Lager.m_Poberfl == "OB_SONST") || (oOptions.SONDERANSTRICH_TEXT != "") || (oLKinfo.bemerkung != "")))
            strRet = "X";

        if (!bEchteLK && Zubehoer && ((Zubehoer.m_Poberfl == "OB_SONST") || (oOptions.SONDERANSTRICH_TEXT != "") || (oLKinfo.bemerkung != "")))
            strRet = "X";

        if (!bEchteLK && Klemmsystem && ((Klemmsystem.m_Poberfl == "OB_SONST") || (oOptions.SONDERANSTRICH_TEXT != "") || (oLKinfo.bemerkung != "")))
            strRet = "X";

// 28.9.2008: Entfällt gemäß Protokoll WI vom 16.9.2008, Punkt 2
//        if (!bEchteLK && (oLKinfo.markierung != ""))
//            strRet = "X";

        /*
        if (tolower(this.presets.PRUEFBESCH_FEDERN) == "true")
        {
            if ( Haenger && Haenger.isHaenger() )
                strRet = "X";
        }
        */
        if (tolower(this.presets.PRUEFBESCH_PROD_21) == "true")
            strRet = "X";

        if (tolower(this.presets.PRUEFBESCH_PROD_22) == "true")
            strRet = "X";

        // nur wenn entsprechende Schelle da ....
        if ((tolower(this.presets.PRUEFBESCH_WARMFEST) == "true") &&
            Schelle && (Schelle.getOberFlaechenSchutzGruppe() == 3))
            strRet = "X";

        if ((tolower(this.presets.PRUEFBESCH_AUSTENIT) == "true") &&
            Schelle && (Schelle.getOberFlaechenSchutzGruppe() == 4))
            strRet = "X";

        // @@@ TODO: Oberflächenschutzgruppen Lager sauber definieren, auch im Lager, auch oben für Prüfbesch.
        if ((tolower(this.presets.PRUEFBESCH_WARMFEST) == "true") &&
            Lager && (Lager.getOberFlaechenSchutzGruppe() == 3))
            strRet = "X";

        if ((tolower(this.presets.PRUEFBESCH_AUSTENIT) == "true") &&
            Lager && (Lager.getOberFlaechenSchutzGruppe() == 4))
            strRet = "X";

		/* Protokoll 9.2.09 mit Nachtrag Email vom 12.2.09:
		Für alle Typen der Klassen
			CFG
			CFH
			CFV
			CLA
			CLG
			CLH
			CLV
			CPG
			CPH
			CPS
			CPV
			übergibt Flexperte immer den KDE-Kenner an SAP, unabhängig ob eine Markierung eingetragen wurde oder nicht
			Sind Materialien dieser Klassen konfigurierbar, dann darf selbstverständlich kein KDE-Kenner übergeben werden, die sind ja KDE
			Diese Produkte können in LK's vorkommen.
			LK's sind ja KDE. hier ändert sich nichts (im Allgemeinen haben ja LK's eine Markierung).
			Fügt mann zur Einzelposition Lager (dieser genannten Klassen) neue Teile hinzu, dann haben wir ja eigentlich 
			eine LK (Mat.-Nr. 976064, konfigurierbar), hier übergeben wir bei leerer Markierungszeile die Typzeile des Lagers als Markierung.
		*/
		if (bSonderProduktKDE)
            strRet = "X";
		
        return strRet;
    },
	
	getSonderProduktKDE : function(strTyp)
	{
		var bRet = 0;
		if (dbselect("LAGER", "select * from KDE_TYPEN where TYP = '"+strTyp+"' ", "NEBENSELECT") > 0)
		{
			bRet = 1;
		}
		return bRet;
	},

    getDescription : function(dlgId)
    {
		var data = {
			values : [
            ]
        };
		
		if(this.topologieKlassenName == 'CaTopoLager2'){ //Neue Lager-Auswahl umleiten
			switch(dlgId){
				case 'lager.systemcharakteristik' : 
					setDeleteDialogObjectSession('LAGER'); 
					setDeleteDialogObjectSession('LAGERCACHE'); 
					var oDlgSession = getDialogObjectSession('LAGER'); 
				break;
			}
			
			data = caMainController.topologieKlasse.getDescription(dlgId);
			
			return data;
		}
	
        var pathSW_Schelle = "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL";
        var pathSW_Hpunkt  = "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT";
        
        // @@@ TODO's getDescription:
        // - Flexible Einheiten (Wert und Einheitensymbol)  
        // - Flexibles Koordinatensystem

        var lkTyp             = this.dataAccess.getLastketteTyp();
        var lkLastabtragung   = this.dataAccess.getLastketteLastabtragung();
		var lkRohrverlauf	  = this.dataAccess.getLastketteRohrverlauf();
        var oLKinfo           = this.dataAccess.getLKinfoDaten();
		
        var myHanger = this.topologieKlasse.getCurrentHaenger();
        
		
        var iUmfang = 0;

        var strPosnr = getstring("POS", "DLGDATA");
        if (strPosnr != "")
        {
            data.values.push(
            {
                title: translate("IDC_POSITION_LABEL"),
                rows: [
					[ 'Pos '+strPosnr, '', '' ],
					[ oLKinfo.markierung, '', '' ]
                ]
            } );
        }

		if ( lkTyp == "EINZEL_LAGER" )
		{
			// spezielle Werte für 'Einzelne Lager'
			switch( dlgId ) 
			{
				case 'systemcharakteristik':
					iUmfang = 0;
					break;
				case 'lager_betriebsbedingungen':
					iUmfang = 1;
					break;
				case 'lager_auswahl':
					iUmfang = 2;
					break;
				case 'lager_hoeheneingaben':
					iUmfang = 3;
					break;
				case 'lager_konfiguration':
					iUmfang = 4;
					break;
				case 'uebersicht_lastkette':
					if ( this.topologieKlasse.Lager && this.topologieKlasse.Lager.isConfigurable() )
						iUmfang = 4;
                    else if ( this.topologieKlasse.Lager && this.topologieKlasse.Lager.isHoehenverstellbar() )
						iUmfang = 3;
					else iUmfang = 2;
					break;
			}
			
			if ( iUmfang > 0 )
			{
				// Dialog 'Lager Betriebsbedingungen' -> setze alle serverseitig aktuellen Daten des Dialogs
				var bedingungen = this.dataAccess.LagerDaten.holeBetriebsbedingungen();
				data.values.push(
				{
					title: translate( 'LAGER_BETRIEBSBEDINGUNGEN' ),
					rows: [
						[ translate( 'IDC_TEMPERATUR_TS_LABEL' ), bedingungen.temperatur, '&deg;C' ],
						[ translate( 'IDC_DAEMMDICKE_LABEL' ), bedingungen.daemmdicke, 'mm' ],
						[ translate( 'IDC_VERSCH_WX_LABEL' ), bedingungen.wx, 'mm' ],
						[ translate( 'IDC_VERSCH_WY_LABEL' ), bedingungen.wy, 'mm' ],
						[ translate( 'IDC_VERSCH_WZ_LABEL' ), bedingungen.wz, 'mm' ],
						[ translate( 'IDC_VERSCH_WX_MINUS_LABEL' ), bedingungen.m_wx, 'mm' ],
						[ translate( 'IDC_VERSCH_WY_MINUS_LABEL' ), bedingungen.m_wy, 'mm' ],
						[ translate( 'IDC_VERSCH_WZ_MINUS_LABEL' ), bedingungen.m_wz, 'mm' ],
						[ translate( 'IDC_LAST_FX_LABEL' ), bedingungen.fx, 'kN' ],
						[ translate( 'IDC_MINUS_FX_LABEL' ), bedingungen.m_fx, 'kN' ],
						[ translate( 'IDC_LAST_FY_LABEL' ), bedingungen.fy, 'kN' ],
						[ translate( 'IDC_MINUS_FY_LABEL' ), bedingungen.m_fy, 'kN' ],
						[ translate( 'IDC_LAST_FAB_LABEL' ), bedingungen.fz, 'kN' ],
						[ translate( 'IDC_LAST_FZ_LABEL' ), bedingungen.m_fz, 'kN' ],
					]
				} );
			}
			if ( iUmfang > 1 )
			{
				// Dialog 'Lager Auswahl' -> setze Lagerart, Gleitart, Isolierung, Nennweite und Außendurchmesser
				var strLagerart = this.dataAccess.LagerDaten.holeLagerart();
				var strGleitart = this.dataAccess.LagerDaten.holeGleitart();
				var strGleitartLabel = translate( 'IDC_GLEIT_LABEL' );
				if ( ( strLagerart == 'ID_FESTLAGER' ) || ( strLagerart == 'ID_FESTLAGER_D' ) )
					strGleitartLabel = translate( 'ID_FESTLAGER' );
				else if ( strLagerart == 'ID_ROHRSTUETZE' )
					strGleitartLabel = translate( 'IDC_ROHRST_LABEL' );
				var strIsolierung = this.dataAccess.LagerDaten.holeIsolierung();
				strIsolierung = strIsolierung.replace( 'ID_', 'IDC_' );
				
				data.values.push(
				{
					title: translate( 'LAGER_AUSWAHL' ),
					rows: [
						[ translate( 'IDC_LAGERART_LABEL' ), '', translate( strLagerart ) ],
						[ strGleitartLabel, '', translate( strGleitart ) ],
						[ translate( 'IDC_ISOLIERUNG_LABEL' ), '', translate( strIsolierung ) ],
						[ translate( 'IDC_NENNWEITE_LABEL' ), '', 'DN ' + this.dataAccess.LagerDaten.holeNennweite() ],
						[ translate( 'IDC_AUSSENDURCH_LABEL' ), this.dataAccess.LagerDaten.holeAussendurchmesser(), 'mm' ]
					]
				} );
			}
			if ( ( iUmfang > 2 ) && this.topologieKlasse.Lager && this.topologieKlasse.Lager.isHoehenverstellbar() )
			{
				// Dialog 'Lager Höheneingaben
				var oHoehen = this.topologieKlasse.Lager.holeHoehendaten();
				data.values.push(
				{
					title: translate( 'LAGER_HOEHENEINGABEN' ),
					rows: [
						[ translate( 'IDC_HOEHEN_ACT_LABEL' ), oHoehen.strAct, 'mm' ],
						[ translate( 'IDC_HOEHEN_MINMAX_LABEL' ), '', oHoehen.strMinMax ]
					]
				} );
			}
			if ( iUmfang > 3 )
			{
				// Dialog 'Lager Konfiguration -> setze Trägerart und Trägergröße 
				var strTraegerart = Cascade.Lagerkonfiguration.holeProfilart( this.dataAccess.LagerDaten.holeTraegerart() );
				var strTraegergroesse = this.dataAccess.LagerDaten.holeTraegergroesse();

				data.values.push(
				{
					title: translate( 'LAGER_KONFIGURATION' ),
					rows: [
						[ translate( 'IDC_PROFILART_RH_LABEL' ), '', strTraegerart ],
						[ translate( 'IDC_TRAEGERGROESSE_LABEL' ), '', strTraegergroesse ]
					]
				} );
			}

			if ( dlgId == 'uebersicht_lastkette' )
			{
               data.values.push(
                    {
                        title: translate('KOORDINATEN_EINFUEGEPUNKT_ROHRMITTE_SCHELLE'),
                        rows: [
                            [ translate('X_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt("lateral", 1),'mm','&nbsp;'],
                            [ translate('Y_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt("axial", 1),'mm','&nbsp;'],
                            [ translate('Z_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt("vertikal", 1),'mm','&nbsp;']
                        ]
                    }
                );
               data.values.push(
                    {
                        title: translate('SYSTEMMASSE'),
                        rows: [
                            [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                            [ translate('IDC_LABEL_LEVEL_UNTERER_BAUANSCHLUSS'),getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                        ]
                    }
                );
            }
			return data;
		}
		else if ( lkTyp == "EINZEL_KLEMMSYSTEM" )
		{
			// spezielle Werte für 'Einzelnes Klemmsystem'
			switch( dlgId ) 
			{
				case 'systemcharakteristik2':
					iUmfang = 0;
					break;
				case 'klemmsystem_auswahl':
					iUmfang = 1;
					break;
				case 'uebersicht_lastkette':
					iUmfang = 2;
					break;
			}
			
			if ( iUmfang > 0 )
			{
				// Dialog 'Lager Auswahl' -> setze Lagerfunktion, Trägerart, Trägergröße
				var strTraegerart = Cascade.Lagerkonfiguration.holeProfilart( this.dataAccess.LagerDaten.holeTraegerart() );
				var strTraegergroesse = this.dataAccess.LagerDaten.holeTraegergroesse();
				var strLagerart = this.dataAccess.LagerDaten.holeLagerart();
				
				data.values.push(
				{
					title: translate( 'IDC_AUSWAHL_KLEMMSYS_LABEL' ),
					rows: [
						[ translate( 'IDC_LAGERART_LABEL' ), '', translate( strLagerart ) ],
						[ translate( 'IDC_PROFILART_RH_LABEL' ), '', strTraegerart ],
						[ translate( 'IDC_TRAEGERGROESSE_LABEL' ), '', strTraegergroesse ]
					]
				} );
			}
			
			return data;
		}
		else if ( lkTyp == "EINZEL_ZUBEHOER" )
		{
            var last = getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
            if (last == "")
                last = this.sucheLastzuLGV(this.topologieKlasse.a_lgv);
            data.values.push(
                {
                    title: translate('SOLLWERTE_HALTERUNGSPUNKT'),
                    rows: [
                        [ translate('SOLLLAST'),last,'kN', ""]
                    ]
                }
            )
			return data;
		}
		
        // sollwerte_spannweite, auswahl_zubehoer_einzel
		var bLager = this.dataAccess.isLastketteMitLagerMoeglich();
		var nLagerUmfang = 0;
		
        switch(dlgId) 
        {
            case 'systemcharakteristik':
                iUmfang = 0;
                break;
            case 'sollwerte_halterungspunkt':
            case 'sollwerte_zubehoer_einzel':
            case 'sollwerte_spannweite':
            case 'auswahl_traverse_ohne_rut':
            case 'auswahl_haengergroesse':  
            case 'auswahl_haengertyp':
            case 'konfiguration_haenger':
                iUmfang = 1;
                break;
            case 'sollwerte_rohrumschliessendes_teil':
			
			// Fall Lager in LK
			case 'lager.sollwerte_rohrumschliessendesteil':
			case 'lager.auswahl_standard':
			
            case 'auswahl_schelle':
            case 'auswahl_zubehoer_einzel':
			case 'auswahl_bock2':
                iUmfang = 2;
                break;
			case 'lager_betriebsbedingungen':
				//nLagerUmfang = 1;
				nLagerUmfang = 0;
                iUmfang = 2;
				break;
			case 'lager_auswahl':
				nLagerUmfang = 2;
                iUmfang = 2;
				break;
			case 'lager_hoeheneingaben':
				nLagerUmfang = 3;
                iUmfang = 2;
				break;
			case 'lager_konfiguration':
				nLagerUmfang = 4;
                iUmfang = 2;
				break;
            case 'auswahl_untere_teile':
            case 'auswahl_oberer_bauanschluss':
            case 'definition_stahlbau':
            case 'auswahl_obere_teile':
                iUmfang = 2;
				if ( bLager && this.topologieKlasse.getLager() && this.topologieKlasse.getLager().isConfigurable() )
					nLagerUmfang = 3;
				else if ( bLager && this.topologieKlasse.getLager())
                    nLagerUmfang = 2;				
                break;
            case 'uebersicht_lastkette':
                iUmfang = 3;
				if ( bLager && this.topologieKlasse.getLager() && this.topologieKlasse.getLager().isConfigurable() )
					nLagerUmfang = 3;
				else if ( bLager && this.topologieKlasse.getLager())
                    nLagerUmfang = 2;				
                break;
        }

        // pruefe positive vertikale Richtung
		var VertiDir		  	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var direction	= "-";
		if (VertiDir != "AUF")
			direction	= "+";
		var AchsDirInfo			= this.dataAccess.getAchsKSInfo();
		
		if (iUmfang > 0)
        {
            var strArtSollast       = translate("IDC_LABEL_"+this.dataAccess.getSollwerteArtSollast()+"LAST");   // KALT, WARM
            if ((lkTyp == "STARR") || (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE") || (lkTyp == "EINZEL_SCHELLE"))
            {
                strArtSollast       = "";
            }
            if (lkTyp != "EINZEL_SCHELLE" && lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
                data.values.push(
                    {
                        title: translate('SOLLWERTE_HALTERUNGSPUNKT'),
                        rows: [
                            [ translate('SOLLLAST') + ' ',this.dataAccess.getSollwerteLast(direction, 1, AchsDirInfo[6]),'kN', strArtSollast],   
                            [ translate('ZUSATZLAST_GESCHAETZT') + ' ',this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]),'kN','&nbsp;'],   
							[ translate('BEWEGUNG_'+AchsDirInfo[0]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]),'mm'],
							[ translate('BEWEGUNG_'+AchsDirInfo[0]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]),'mm'],
                            [ translate('BEWEGUNG_'+AchsDirInfo[1]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[7]),'mm','&nbsp;'],
							[ translate('BEWEGUNG_'+AchsDirInfo[1]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[7]),'mm','&nbsp;'],
                            [ translate('BEWEGUNG_'+AchsDirInfo[2]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[8]),'mm','&nbsp;'],
							[ translate('BEWEGUNG_'+AchsDirInfo[2]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[8]),'mm','&nbsp;'],
							[ translate('UEBERLAST_PRUEFLAST_BEI_25_C') + ' ',this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]),'kN','&nbsp;']
                        ]
                    }
                );
			else if (lkTyp != "EINZEL_SCHELLE")	// SSG und SSB
				data.values.push(
                    {
                        title: translate('SOLLWERTE_HALTERUNGSPUNKT'),
                        rows: [
                            [ translate('SOLLLAST') + ' ',max(abs(this.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])),abs(this.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]))),'kN', strArtSollast],   
                            [ translate('ZUSATZLAST_GESCHAETZT') + ' ',this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]),'kN','&nbsp;'],   
							[ translate('BEWEGUNG_'+AchsDirInfo[0]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[6]),'mm'],
							[ translate('BEWEGUNG_'+AchsDirInfo[0]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[6]),'mm'],
                            [ translate('BEWEGUNG_'+AchsDirInfo[1]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[7]),'mm','&nbsp;'],
							[ translate('BEWEGUNG_'+AchsDirInfo[1]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[7]),'mm','&nbsp;'],
                            [ translate('BEWEGUNG_'+AchsDirInfo[2]+'_RICHTUNG') + ' + ' + ' ',this.dataAccess.getSollwerteBewegung("+", 1, AchsDirInfo[8]),'mm','&nbsp;'],
							[ translate('BEWEGUNG_'+AchsDirInfo[2]+'_RICHTUNG') + ' - ' + ' ',this.dataAccess.getSollwerteBewegung("-", 1, AchsDirInfo[8]),'mm','&nbsp;'],
							[ translate('UEBERLAST_PRUEFLAST_BEI_25_C') + ' ',this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]),'kN','&nbsp;']
                        ]
                    }
                );
			else
				data.values.push(
                    {
                        title: translate('SOLLWERTE_HALTERUNGSPUNKT'),
                        rows: [
                            [ translate('SOLLLAST') + ' ',this.dataAccess.getSollwerteLast(direction, 1, AchsDirInfo[6]),'kN', strArtSollast],   
                            [ translate('ZUSATZLAST_GESCHAETZT') + ' ',this.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]),'kN','&nbsp;']
							//[ translate('UEBERLAST_PRUEFLAST_BEI_25_C') + ' ',this.dataAccess.getSollwerteUeberLast(1, AchsDirInfo[6]),'kN','&nbsp;']
                        ]
                    }
                );
			if ((getstring("SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") != "") ||
					(getstring("SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") != ""))
				data.values.push(
					{
						title: '',
						rows: [
							[ 'ALPHA', getstring("SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), '°' ],
							[ 'BETA', getstring("SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), '°' ]
						]
					}
				);
        }
        if (iUmfang > 1)
        {
            if (/* (lkTyp != "EINZEL_HAENGER") && -mw- 03/2009*/ (lkTyp != "EINZEL_ZUBEHOER"))
            {
                data.values.push(
                    {
                        title: translate('KOORDINATEN_EINFUEGEPUNKT_ROHRMITTE_SCHELLE'),
                        rows: [
                            [ translate('X_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt(1, 0),'mm','&nbsp;'],
                            [ translate('Y_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt(1, 1),'mm','&nbsp;'],
                            [ translate('Z_RICHTUNG'),this.dataAccess.getSollwerteEinfuegepunkt(1, 2),'mm','&nbsp;']
                        ]
                    }
                );

                if (iUmfang > 2)
                {
                    // -----------------------------------------------------------------------------------------
                    // Systemmasse
                    if ((lkTyp == "EINZEL_HAENGER") || (lkTyp == "EINZEL_SCHELLE") 
                        || (lkTyp == "EINZEL_ZUBEHOER") || (lkTyp == "EINZEL_LAGER"))
                    {
                        data.values.push(
                            {
                                title: translate('SYSTEMMASSE'),
                                rows: [
                                    [ translate('IDC_LABEL_LEVEL_OBEN'),getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                    [ translate('IDC_LABEL_LEVEL_UNTEN'),getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                ]
                            }
                        );
                    }
                    else if ((lkTyp == "GELENKSTREBE")  || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
                    {
                        if (topologieKlasse.bHaengend)
                        {
                            data.values.push(
                                {
                                    title: translate('SYSTEMMASSE'),
                                    rows: [
                                        [ translate('IDC_LABEL_LEVEL_OBERER_BAUANSCHLUSS'),getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                        [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                    ]
                                }
                            );
                        }
                        else
                        {
                            data.values.push(
                                {
                                    title: translate('SYSTEMMASSE'),
                                    rows: [
                                        [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                        [ translate('IDC_LABEL_LEVEL_UNTERER_BAUANSCHLUSS'),getstring("BA", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                    ]
                                }
                            );
                        }
                    }
                    else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                             (lkLastabtragung == "STUETZEND_DOPPEL"))
                    {
                        data.values.push(
                            {
                                title: translate('SYSTEMMASSE'),
                                rows: [
                                    [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                    [ translate('IDC_LABEL_LEVEL_UNTERER_BAUANSCHLUSS'),getstring("UBA", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                ]
                            }
                        );
                    }
                    else
                    {
                        if (this.topologieKlasse.isDritteHLinie())
                        {
                            data.values.push(
                                {
                                    title: translate('SYSTEMMASSE'),
                                    rows: [
                                        [ translate('IDC_LABEL_LEVEL_OBERER_BAUANSCHLUSS'),getstring("OBA",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                        [ translate('IDC_LABEL_LEVEL_HAENGER'),getstring("HAENG",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                        [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                    ]
                                }
                            );
                        }
                        else
                        {
                            data.values.push(
                                {
                                    title: translate('SYSTEMMASSE'),
                                    rows: [
                                        [ translate('IDC_LABEL_LEVEL_OBERER_BAUANSCHLUSS'),getstring("OBA",  "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;'],
                                        [ translate('IDC_LABEL_LEVEL_ROHRMITTE'),getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL"),'mm','&nbsp;']
                                    ]
                                }
                            );
                        }
                    }
                    // -----------------------------------------------------------------------------------------
                }
                
                if (this.dataAccess.getLastketteMitSchelle() && (nLagerUmfang == 0) && (lkTyp != "EINZEL_HAENGER"))
                {
                    if ((lkLastabtragung == "HAENGEND_DOPPEL" || lkLastabtragung == "STUETZEND_EINFACH") 
							&& lkRohrverlauf == "HORIZONTAL" && lkTyp != "GELENKSTUETZE" && lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE"){
						var oDlgLagerSession = getDialogObjectSession("LAGER");
						data.values.push(
								{
									title: translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL'),
									
									rows: [
										[ translate('MEDIUM_TEMPERATUR'),oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium,'&deg','&nbsp;'],
										[ translate('DAEMMDICKE'),oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke,'mm','&nbsp;'],
										[ translate('NENNWEITE_DN'),(!oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo : " - "),'','&nbsp;'],
										[ translate('AUSSENDURCHMESSER'),(!oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo : oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder),'mm','&nbsp;'],
										[ translate('SPANNWEITE'),this.dataAccess.getSpannweite(1),'mm','&nbsp;'],
										[ translate('IDS_WERKSTOFF'),this.dataAccess.getWerkstoffNrFromZahl(this.dataAccess.getZahlFromWerkstoff(Werknamen[right(oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff,oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff.length - 6)])),'','&nbsp;'],
										[ translate('OBERFLAECHE'),(oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel == "" ? "" : this.dataAccess.getOberflaecheFromZahl(oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel*1)),'','&nbsp;']
									]
								}
							);
					}
					else{
						if (right(lkLastabtragung, 7) != "EINFACH")
							data.values.push(
								{
									title: translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL'),
									
									rows: [
										[ translate('MEDIUM_TEMPERATUR'),this.dataAccess.getMediumTemperatur(1),'&deg','&nbsp;'],
										//[ translate('REFERENZTEMPERATUR'),this.dataAccess.getReferenzTemperatur(1),'&deg','&nbsp;'],
										[ translate('DAEMMDICKE'),this.dataAccess.getDaemmdicke(1),'mm','&nbsp;'],
										[ translate('NENNWEITE_DN'),this.dataAccess.getNennweite(1),'','&nbsp;'],
										[ translate('AUSSENDURCHMESSER'),this.dataAccess.getRohrAussendurchmesser(1),'mm','&nbsp;'],
										[ translate('SPANNWEITE'),this.dataAccess.getSpannweite(1),'mm','&nbsp;'],
										[ translate('WERKSTOFF_SCHELLE_LAGER'),this.dataAccess.getWerkstoffNrFromZahl(this.dataAccess.getZahlFromWerkstoff(this.dataAccess.getSchellenWerkstoffVorgabe())),'','&nbsp;']
									]
								}
							);
						else
							data.values.push(
								{
									title: translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL'),
									
									rows: [
										[ translate('MEDIUM_TEMPERATUR'),this.dataAccess.getMediumTemperatur(1),'&deg','&nbsp;'],
										//[ translate('REFERENZTEMPERATUR'),this.dataAccess.getReferenzTemperatur(1),'&deg','&nbsp;'],
										[ translate('DAEMMDICKE'),this.dataAccess.getDaemmdicke(1),'mm','&nbsp;'],
										[ translate('NENNWEITE_DN'),this.dataAccess.getNennweite(1),'','&nbsp;'],
										[ translate('AUSSENDURCHMESSER'),this.dataAccess.getRohrAussendurchmesser(1),'mm','&nbsp;'],
										[ translate('WERKSTOFF_SCHELLE_LAGER'),this.dataAccess.getWerkstoffNrFromZahl(this.dataAccess.getZahlFromWerkstoff(this.dataAccess.getSchellenWerkstoffVorgabe())),'','&nbsp;']
									]
								}
							);
					}
                }
            }
			if ( this.dataAccess.getLastketteMitSchelle() && bLager )
			{
				if ( nLagerUmfang > 0 )
				{
					// Dialog 'Lager Betriebsbedingungen' -> setze alle serverseitig aktuellen Daten des Dialogs
					var bedingungen = this.dataAccess.LagerDaten.holeBetriebsbedingungen();
					data.values.push(
					{
						title: translate( 'LAGER_BETRIEBSBEDINGUNGEN' ),
						rows: [
							[ translate( 'IDC_TEMPERATUR_TS_LABEL' ), bedingungen.temperatur, '&deg;C' ],
							[ translate( 'IDC_DAEMMDICKE_LABEL' ), bedingungen.daemmdicke, 'mm' ],
							[ translate( 'IDC_VERSCH_WX_LABEL' ), bedingungen.wx, 'mm' ],
							[ translate( 'IDC_VERSCH_WY_LABEL' ), bedingungen.wy, 'mm' ],
							[ translate( 'IDC_LAST_FZ_LABEL' ), bedingungen.m_fz, 'kN' ],
							[ translate( 'IDC_LAST_FAB_LABEL' ), bedingungen.fz, 'kN' ],
							[ translate( 'IDC_MINUS_FX_LABEL' ), bedingungen.m_fx, 'kN' ],
							[ translate( 'IDC_LAST_FX_LABEL' ), bedingungen.fx, 'kN' ],
							[ translate( 'IDC_LAST_FY_LABEL' ), bedingungen.fy, 'kN' ]
						]
					} );
				}
				if ( nLagerUmfang > 1 )
				{
					// Dialog 'Lager Auswahl' -> setze Lagerart, Gleitart, Isolierung, Nennweite und Außendurchmesser
					var strLagerart = this.dataAccess.LagerDaten.holeLagerart();
					var strGleitart = this.dataAccess.LagerDaten.holeGleitart();
					var strGleitartLabel = translate( 'IDC_GLEIT_LABEL' );
					if ( ( strLagerart == 'ID_FESTLAGER' ) || ( strLagerart == 'ID_FESTLAGER_D' ) )
						strGleitartLabel = translate( 'ID_FESTLAGER' );
					else if ( strLagerart == 'ID_ROHRSTUETZE' )
						strGleitartLabel = translate( 'IDC_ROHRST_LABEL' );
					var strIsolierung = this.dataAccess.LagerDaten.holeIsolierung();
					strIsolierung = strIsolierung.replace( 'ID_', 'IDC_' );
					
					data.values.push(
					{
						title: translate( 'LAGER_AUSWAHL' ),
						rows: [
							[ translate( 'IDC_LAGERART_LABEL' ), '', translate( strLagerart ) ],
							[ strGleitartLabel, '', translate( strGleitart ) ],
							[ translate( 'IDC_ISOLIERUNG_LABEL' ), '', translate( strIsolierung ) ],
							[ translate( 'IDC_NENNWEITE_LABEL' ), '', 'DN ' + this.dataAccess.LagerDaten.holeNennweite() ],
							[ translate( 'IDC_AUSSENDURCH_LABEL' ), this.dataAccess.LagerDaten.holeAussendurchmesser(), 'mm' ]
						]
					} );
				}
				if ( ( nLagerUmfang > 2 ) && this.topologieKlasse.Lager && this.topologieKlasse.Lager.isHoehenverstellbar() )
				{
					// Dialog 'Lager Höheneingaben
					var oHoehen = this.topologieKlasse.Lager.holeHoehendaten();
					data.values.push(
					{
						title: translate( 'LAGER_HOEHENEINGABEN' ),
						rows: [
							[ translate( 'IDC_HOEHEN_ACT_LABEL' ), oHoehen.strAct, 'mm' ],
							[ translate( 'IDC_HOEHEN_MINMAX_LABEL' ), '', oHoehen.strMinMax ]
						]
					} );
				}
				if ( nLagerUmfang > 3 )
				{
					// Dialog 'Lager Konfiguration -> setze Trägerart und Trägergröße 
					var strTraegerart = Cascade.Lagerkonfiguration.holeProfilart( this.dataAccess.LagerDaten.holeTraegerart() );
					var strTraegergroesse = this.dataAccess.LagerDaten.holeTraegergroesse();

					data.values.push(
					{
						title: translate( 'LAGER_KONFIGURATION' ),
						rows: [
							[ translate( 'IDC_PROFILART_RH_LABEL' ), '', strTraegerart ],
							[ translate( 'IDC_TRAEGERGROESSE_LABEL' ), '', strTraegergroesse ]
						]
					} );
				}
			}
        }
        if (iUmfang > 2)
        {
            var Zusatzlast = this.topologieKlasse.calculateZusatzlast();
            var oLKWinkel  = this.topologieKlasse.getLKWinkel();
            
            /*if ((Zusatzlast > 0) && (lkTyp != "EINZEL_HAENGER") && (lkTyp != "EINZEL_ZUBEHOER"))
            {
                data.values.push(
                    {
                        title: translate('ZUSATZLAST_AUS_EIGENGEWICHT'),
                        rows: [
                            [ translate('ZUSATZLAST_GESCHAETZT'),this.dataAccess.getSollwerteZusatzLast("vertikal", 1),'kN','&nbsp;'],   
                            [ translate('ZUSATZLAST_AUS_EIGENGEWICHT'), Zusatzlast,'kN','&nbsp;']
                        ]
                    }
                );
            }
            */

            if (oLKWinkel.a_Schraegzug > 0)
            {
                data.values.push(
                    {
                        title: translate( 'IDS_SCHRAEGZUG_AKTWERT' ),
                        rows: [
                            [ translate('ID_SCHR_ZUG'), oLKWinkel.a_Schraegzug,'°','&nbsp;'],
							[ translate('ID_SCHR_ZUG') + ' ' + AchsDirInfo[1], oLKWinkel.a_Schraegzug_Axial,'°','&nbsp;'],
							[ translate('ID_SCHR_ZUG') + ' ' + AchsDirInfo[2], oLKWinkel.a_Schraegzug_Lateral,'°','&nbsp;']
                        ]
                    }
                );
            }
        }   
        
        return data;
    },

    // So etwas ruft man besser mit einem anonymen Objekt auf
	// Das schont die Parameterliste und ist flexibler
	// addPositionToKundenauftrag( {
	// 	angebotNr: 12345,
	//  benutzer: 'Irgendwer'
	//  ...
	// })
	//
	// addPositionToKundenauftrag : function( obj ) { ... }
	
    addPositionToKundenauftrag : function(strOutFile,
                                            strAngebNr,
                                            strBenutzer,
                                            strKundenNr,
                                            strProjektNr,
                                            strASNr,
                                            strSprache,
                                            strKPoenale,
                                            strKRuestk,
                                            strKAkkred,
                                            strKEAbnahme,
                                            strPosNr,
                                            strQTY,
                                            strKDMAT,
                                            strPrice,
                                            strPrAbnE,
                                            strPrAbnI,
											strWaehrungskuerzel)
    {
        var lkTyp       = this.dataAccess.getLastketteTyp(); 
        var oLKinfo     = this.dataAccess.getLKinfoDaten();
        var LKMatInfo   = this.topologieKlasse.getLastkettenIdent(this);
        var strLKMatNr  = LKMatInfo.matnr;
        var strTYP      = LKMatInfo.typ;   // LK_2_FH_SH
        var strKlasse   = LKMatInfo.klasse;
        //var strWeight   = this.topologieKlasse.gesamtGewicht;
		// Frau Geiger: zur korrekten Verarbeitung in SAP muss das Gesamtgewicht aller (gleichen) LK übergeben werden
		var strWeight   = this.topologieKlasse.gesamtGewicht * strQTY;

        var lastgruppe		= this.topologieKlasse.a_lgv;
        var schelleDaten	= this.topologieKlasse.getSchelleDaten(); // Gewicht, Größe, Typ, Bohrung, Emass, Oberflächenschutz, Aussendurch, Nennweite?
        var spannweite		= this.topologieKlasse.getSpannweite();
        var anzGewstangen	= this.topologieKlasse.getAnzGewstangen();
        var klemmlDaten		= this.topologieKlasse.getKlemmlaschenDaten();	// auch für Klemmsysteme Lager nutzen
        var haengerDaten	= this.topologieKlasse.getHaengerDaten(this.presets);  // Anz, Leistungsgrösse, Länge V-Teil, Typ Träger
        var RlSysDaten		= this.topologieKlasse.getRlSysDaten();
		var sonderteilDaten	= this.topologieKlasse.getSonderteilDaten();
        var sonstigeDaten	= this.topologieKlasse.getSonstigeDaten();
		var dynamicDaten	= this.topologieKlasse.getDynamicDaten();

		var einzelProdukt = null;
        // if (this.topologieKlassenName == "CaTopoEinzel")
		if (this.topologieKlassenName == "CaTopoEinzel" || 
			(this.topologieKlassenName == "CaTopoLager2" && this.topologieKlasse.isSingleProduct()))
			einzelProdukt = this.topologieKlasse.getEinzelprodukt();

		var bSonderProduktKDE = 0;
		if (einzelProdukt && this.getSonderProduktKDE(einzelProdukt.m_Ptypid))
			bSonderProduktKDE = 1;

        var strKZKDE   = this.getKZKDE(bSonderProduktKDE);   // Blank oder X, wenn Sonderabwicklung!
        var strARKTX   = this.getARKTX();   				 // 2008-07-01 Positionstext:  für konfigurierbare Einzelprodukte die Typbez, sonst leer
        var strMarkierung  = stringToSAP(replaceSpecialChars(oLKinfo.markierung, {FuerCSV : 1, FuerDateiname : 0}));
        var strAbsagegrund = "  ";
		
		/* -SCHM- 13.2.2009:
		Wenn im Flexperte die Markierungszeile leer ist, wird automatisch die Typzeile als Markierung 
		übergeben. Das gilt nur für die genannten Klassen, bei denen der KDE-Kenner immer gesetzt wird.
		Bei nicht-leerer Markierung wird im Kundenauftrag derzeit der Kenner LPRIO auf "99" gesetzt. 
		Dies soll auch gelten, wenn die Typzeile als Markierung übergeben wird.
		*/
        if (this.topologieKlassenName == "CaTopoEinzel")
		{
			if ((strMarkierung == "") && einzelProdukt && bSonderProduktKDE)
				strMarkierung = einzelProdukt.m_Ptyp;
		}

        var strLPrio   = "  ";
        if (strMarkierung != "")
            strLPrio   = "99";

        // Kopfdatensatz AP für die Position:
        writefile(strOutFile, "AP;FL;"+strAngebNr+";"+strPosNr+";"+strLKMatNr+";"+strKDMAT+";"+strTYP+";ST;"+strQTY+";KG;"+strWeight+";"+strWaehrungskuerzel+";"+strPrice+";;;"+strPrAbnE+";"+strPrAbnI+";"+strKPoenale+";"+strKRuestk+";"+strKAkkred+";"+strKEAbnahme+";"+strKZKDE+";"+strARKTX+";"+strMarkierung+";"+strAbsagegrund+";"+strLPrio+" \r\n", "a");	// append
        
        // Anhand der Klasse wird bestimmt, welche Merkmale wirklich gefragt sind:        

		var MerkmalValueObj = {
            LASTGRUPPE 			: lastgruppe,                       // die LGV / die LGG
            LEISTUNGSGROESSE	: haengerDaten.leistungsgroesse,    // nur Konstanthänger
            NENNWEITE 			: schelleDaten.nennweite,
            AUSSENDURCHMESSER 	: schelleDaten.aussendurch,
            EINBAUMASS 			: schelleDaten.emass,               // der Schelle / des Lagers
            SPANNWEITE_NENNLAENGE : spannweite,                     // die Spannweite
            GROESSE_SH 			: schelleDaten.groesse,             // Groesse Schelle / Lager @@@ was soll das konkret sein?
            TYP_SCHELLE 		: schelleDaten.typ_sap,             // nur Horiz.Schellen, Typid (3 Zeichen) - 20191106 auch Vertikalschellen
            BOHRUNG 			: schelleDaten.bohrung,             // wird nur aus FL übergeben, wenn TYP_Schelle =HDX und  Durchm. > Durchm. vorgebohrt
            LAST_WEG_DIAGR 		: haengerDaten.lastweg_diag,        // N, I (intern), K (Kunde) --> Erweiterte Voreinstellungen?
            ANZ_GEW_STANGEN 	: anzGewstangen,                    // nur Anz ZRM
            OBERFLAECHENSCHUTZ 	: schelleDaten.obflschutz,          // Schelle / Lager: Ziffer aus Typenschlüssel
            GEWICHT_SH 			: schelleDaten.gewicht,             // Gew. Schelle / Lager
            TRAEGERBREITE 		: klemmlDaten.btr,                  // ZKN/ZKK; Klemmsystem; Festlager KS
            FLANSCHBLATTDICKE 	: klemmlDaten.fl,                   // nur ZKN/ZKK
            OBERFL_ZKK 			: klemmlDaten.obflschutz,           // nur ZKN/ZKK, Ziffer aus Typenschlüssel
            GEWICHT_ZKK 		: klemmlDaten.gewicht,              // nur ZKN/ZKK
            TYP_TRAEGER 		: haengerDaten.typ_traeger,         // FDT: Trägertyp Traverse bei FDT
            TRAEGER_TYP 		: haengerDaten.typ_traeger,         // FDT: Trägertyp Traverse bei FDT
            LAENGE_VTEIL 		: haengerDaten.laenge_vteil,        // FDT / FSG: Länge Verlängerungsrohr bei FSG = E - LX bzw. Länge Traverse bei FDT = L - 2*c_
            ANZ_HAENGER 		: haengerDaten.anz_haenger,
            WERKSTOFFS          : schelleDaten.werkstoff_sapid,    // Werkstoff Schelle/Lager: SAP-ID
            LASTGROESSE         : haengerDaten.lastgroesse,        // bei FH / FS und ZZF (dort: Lastgröße des Hängers/ Stütze)
            OBERFL_ZZF          : sonstigeDaten.OBERFL_ZZF,        // OBERFLAECHENSCHUTZ  ZZF oder ZZK                      // 
            OBERFL_ZTN          : sonstigeDaten.OBERFL_ZTN,
            NENNWEG             : haengerDaten.nennweg,            // Hänger / Stützen, aus Typenschlüssel
            NENNLAST_SH         : schelleDaten.Nennlast,           // bei MSN = {fn}
            TYP_ZZF             : sonstigeDaten.TYP_ZZF,           // bei LK mit FS: = "ZZF", bei LK mit KS: = "ZZK"
            LASTGR_ZZF          : sonstigeDaten.LASTGR_ZZF,        // wenn LK mit ZZF: = LGR_ZZF (Tabelle  ** ZZF)
            LEISTUNGSGR_ZZF     : sonstigeDaten.LEISTUNGSGR_ZZF,   // wenn LK mit ZZK: = LGR_ZZK (Tabelle  ** ZZK) 
            DICKE               : sonstigeDaten.DICKE,             // 6.3.09: Hier soll jetzt auch bei HZx das Mass s der Schelle kommen, (ZVX: Dicke der Verbindungslasche: = s1) wird entfernt, soll später eigenes Merkmal werden / HDX: Dicke des Schellenbandes: = s
            GEWICHT_ZTN         : sonstigeDaten.GEWICHT_ZTN,       // Gewicht Zwischenstück ZZF oder ZZK
            GEWICHT_ZZF         : sonstigeDaten.GEWICHT_ZZF,
            OBERFL_FHV          : haengerDaten.obflschutz,
            GEWICHT_FHV         : haengerDaten.gewicht,
            TYP                 : schelleDaten.LagerTyp,            // Lager ("LKL 21") / Sattel ("IDR")
			NENNHOEHE			: schelleDaten.Nennhoehe,
			MANTELDURCHMESSER   : schelleDaten.Manteldurchm,
			OBERFL_STAHLB		: sonderteilDaten.OBERFL_STAHLB,
			GEWICHT_STAHLB		: sonderteilDaten.GEWICHT_STAHLB,
            STAHLBAU			: sonderteilDaten.STAHLBAU,
            OBERFL_FSG          : haengerDaten.obflschutz_fsg,
            GEWICHT_FSG         : haengerDaten.gewicht_fsg,
			TYP_KSY				: sonstigeDaten.TYP_KSY,
			AUFLAGEDURCHMESSER	: schelleDaten.Auflagedurchmesser,
			BAULAENGE			: schelleDaten.Baulaenge,
			DAEMMDICKE			: schelleDaten.Daemmdicke,
			LAENGE				: schelleDaten.Laenge,
			NENNGROESSE			: RlSysDaten.Nenngroesse,
			GEWICHT_OBERFL		: schelleDaten.Gewicht_Oberfl,
			GEWICHT_AHS			: RlSysDaten.Gewicht_Ahs,
			TYP_AHS				: RlSysDaten.Typ_Ahs,
			AHS_SATTEL			: RlSysDaten.Ahs_Sattel,
			FUSSBREITE			: schelleDaten.Fussbreite,
			LAENGE_DYNAMIC		: dynamicDaten.LaengeDynamic
		}

		var MerkmalUnitObj = {
            LASTGRUPPE 			: '',
            LEISTUNGSGROESSE	: '',
            NENNWEITE 			: '',
            AUSSENDURCHMESSER 	: 'MM',
            EINBAUMASS 			: 'MM',
            SPANNWEITE_NENNLAENGE : 'MM',
            GROESSE_SH 			: '',
            TYP_SCHELLE 		: '',
            BOHRUNG 			: 'MM',
            LAST_WEG_DIAGR 		: '',
            ANZ_GEW_STANGEN 	: '',
            OBERFLAECHENSCHUTZ 	: '',
            GEWICHT_SH 			: 'KG',
            TRAEGERBREITE 		: 'MM',
            FLANSCHBLATTDICKE 	: 'MM',
            OBERFL_ZKK 			: '',
            GEWICHT_ZKK 		: 'KG',
            TYP_TRAEGER 		: '',
            LAENGE_VTEIL 		: 'MM',
            ANZ_HAENGER 		: '',
            WERKSTOFFS          : '',                              // Werkstoff Schelle/Lager: SAP-ID
            LASTGROESSE         : '',                              // bei FH / FS und ZZF
            OBERFL_ZZF          : '',                              // 
            OBERFL_ZTN          : '',
            NENNWEG             : '',              // Hänger/ Stützen
            NENNLAST_SH         : '',              // bei MSN = {fn}  29.4.08: Einheit entfernt weil nicht durch SAP durchläuft
            TYP_ZZF             : '',  
            LASTGR_ZZF          : '',  
            LEISTUNGSGR_ZZF     : '',  
            DICKE               : 'MM',
            GEWICHT_ZTN			: 'KG',
            GEWICHT_ZZF			: 'KG',
            OBERFL_FHV          : '',
            GEWICHT_FHV         : 'KG',
            TYP                 : '',
			NENNHOEHE			: '',
			MANTELDURCHMESSER   : 'MM',
			OBERFL_STAHLB		: '',
			GEWICHT_STAHLB		: 'KG',
            STAHLBAU			: '',
            OBERFL_FSG          : '',
            GEWICHT_FSG         : 'KG',
			TYP_KSY				: '',
			AUFLAGEDURCHMESSER	: 'MM',
			BAULAENGE			: 'MM',
			DAEMMDICKE			: 'MM',
			LAENGE				: 'MM',
			NENNGROESSE			: '',
			GEWICHT_OBERFL		: 'KG',
			GEWICHT_AHS			: 'KG',
			TYP_AHS				: '',
			AHS_SATTEL			: '',
			FUSSBREITE			: '',
			LAENGE_DYNAMIC		: 'MM'
		}
        
        var nRecAnz = 0;
        if (! this.getNichtKonfigurierbaresEinzelprodukt())
        {
            // Satzart VP für konfigurierbare Merkmale der Lastkette / eines Einzelprodukts:
            // Formate für Zahlenwerte: Punkt als Dezimaltrenner, ganze Zahlen ohne Nachkommastellen
            var strSQLStatement = "select * from KLASSE_MERKMALE_300 where KLASSE='"+strKlasse+"' ORDER BY SORT ASC "
            var strMerkmal, strCurMValue, strCurMUnit;
            var numRet = dbselect("SAP_M", strSQLStatement, "KLASSE_300_SELECT")
            if (numRet > 0)
            {
                while (dbiseof("KLASSE_300_SELECT") == 0)
                {
                    strMerkmal = dbgetstring("KLASSE_300_SELECT", "MERKMAL");
                    strCurMValue = MerkmalValueObj[strMerkmal];
                    strCurMUnit  = MerkmalUnitObj[strMerkmal];

                    // "undefined" abfangen ...
                    if (! strCurMValue)  strCurMValue = ""; 
                    if (! strCurMUnit)   strCurMUnit = "";
                    
                    // Leere Werte nicht schreiben (löst Problem, dass wir bei der LK Merkmale haben (z.B. für die
                    // Klemmlasche), die nicht immer kommen sollen, die aber in der Merkmalsliste der LK drin sind.
                    if (strCurMValue != "")
                    {
						// Wenn strCurMValue ein Objekt ist, dann die Properties als Werte rausschreiben, Numerierung hochzaehlen
						var nValueCount = 1;
						if (typeof strCurMValue == "object")
						{
							for (prop in strCurMValue)
							{
								if (strCurMValue[prop] == 1)	// als Wert wurde wahllos 1 vergeben, man hätte auch was anderes nehmen können
								{
									writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";"+strMerkmal+";"+nValueCount+";"+prop+";"+strCurMUnit+" \r\n", "a");	// append
									nRecAnz++;
									nValueCount++;
								}
							}
						}
						else
						{
							writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";"+strMerkmal+";"+nValueCount+";"+strCurMValue+";"+strCurMUnit+" \r\n", "a");	// append
							nRecAnz++;
						}
                    }
                    dbskip("KLASSE_300_SELECT");
                }
            }
        }
        if (nRecAnz <= 0)
        {
            // In dem Fall (kann z.B. bei Spannschloss passieren) wenigstens einen leeren Datensatz ausgeben,
            // sonst stürzt der RFC ab.
            writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+"; ;01; ;  \r\n", "a");	// append
        }
        /*
        Roland Decker 12/10/07 Änderung Z_KP_SD_RFC:
        1. Einträge in IT_VP mit ATNAM = initial werden überlesen
        2. Einträge in IT_VT mit TXTID = initial werden überlesen.
        */

        // Änderung 2008-03-05: Es sollen keine Texte 0006 mehr übergeben werden,
        // statt dessen aber die 0001er in DE und EN
		// Änderung 2009-02-02: Es sollen doch wieder Texte 0006 übergeben werden: Markierung und Terroson
        var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();

        setlanguage("DE");
        this.addTexteZuKundenauftrag("0001", strOutFile, strAngebNr, strPosNr, "DE");
        setlanguage("EN");
        this.addTexteZuKundenauftrag("0001", strOutFile, strAngebNr, strPosNr, "EN");
        if ((strSpracheKomm != "EN") && (strSpracheKomm != "DE"))
        {
            var strSapSprache = strSpracheKomm;
            if (strSpracheKomm == "CZ")
                strSapSprache = "CS";
            setlanguage(strSpracheKomm);
            this.addTexteZuKundenauftrag("0001", strOutFile, strAngebNr, strPosNr, strSapSprache);
        }
    },
    
    addTexteZuKundenauftrag : function(strTextTyp, strOutFile, strAngebNr, strPosNr, strSprache)
    {
        // Objekt neu laden, wegen der Texte (Sprache)
        var LKMatInfo		= this.topologieKlasse.getLastkettenIdent(this);
		var oLKinfo			= this.dataAccess.getLKinfoDaten();
        var oOptions		= this.presets.getPreisOptions();
		var haengerDaten	= this.topologieKlasse.getHaengerDaten(this.presets);
        var nZeilenNr		= 1;
        var nZeilenNrZ011	= 1;
        var nZeilenNr0006	= 1;
        var j;
		// SAP verträgt nur 70 Zeichen je Zeile -> wir gehen auf 68
		// var maxLine	= 68;
        // quasi als Debug für WI:
        if (LKMatInfo.aTexte.length <= 0)
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "SAP-Texte fehlen fuer "+LKMatInfo.klasse);
        for (j=0; j < LKMatInfo.aTexte.length; j++)
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(LKMatInfo.aTexte[j])); // -mw- 2008-08-18: Artikeltexte sind jetzt auch UTF-8
        }

        nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
		
		if ((strSprache == "DE") && (oLKinfo.bemerkung != "")){
			//nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("SONDER") + " "));
			nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP("AV "));
		}
		
		if (haengerDaten.Haengertyp == "K" && strSprache == "DE"){
			nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, "DE", stringToSAP(haengerDaten.HaengertypCode));
		}
		
		var strKdName    = getstring("FIRMENNAME_VON", "PROJECT.SETTINGS");
		var strKdName2   = getstring("FIRMENNAME_VON_2", "PROJECT.SETTINGS");
		if ((strSprache == "DE") && (strKdName != "" || strKdName2 != ""))
		{
			nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("IDC_CUSTOMER_ADRESS_TAB_LABEL") + ": "));
			if (strKdName != "")
				nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(strKdName));
			if (strKdName2 != "")
				nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(strKdName2));
        }
		
        var stkList = [], aSonderTexte = [];
        var stkPart;
        var retObj;
        this.topologieKlasse.getStueckliste(stkList);
        for (var i = 0; i < stkList.length; i++)
        {
            stkPart = stkList[i].produkt;

            aSonderTexte = stkPart.getSonderTexte(strSprache);
            for (var j = 0; j < aSonderTexte.length; j++)
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(aSonderTexte[j])); // -mw- 2008-08-18: Sondertexte sind jetzt auch UTF-8
            }
            
            // Text für die einzelnen Stücklistenelemente ... keine Ahnung ob gewünscht ;-)
            // aber nur wenn nicht Einzelauslegung ...
            if ((lkTyp != "EINZEL_HAENGER") && (lkTyp != "EINZEL_SCHELLE") && (lkTyp != "EINZEL_ZUBEHOER"))
            {
                /* -scm- 4.3.2008 nicht erwünscht
                retObj  = stkPart.getASTLDaten(this);   
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
                // quasi als Debug für WI:
                if (retObj.aTexte.length <= 0)
                    nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "SAP-Texte fehlen fuer "+stkPart.m_Ptypid);
                for (j=0; j < retObj.aTexte.length; j++)
                {
                    nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, retObj.aTexte[j]);
                }
                */
            }
            
            // Immer prüfen, ob Bemerkungstexte beim Produkt stehen bzw. Blockierung bei Hänger:
            if ((stkPart.m_Pzeichnr != "") && (stkList[i].funktion != "SON"))   // Sonderteile werden separat abgehandelt
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate(stkPart.m_Pzeichnr)));
            }
            /*** wird jetzt immer in die m_Pzeichnr reingeschrieben
            if (stkPart.isFHaenger() && (stkPart.m_Pblock == "BLOCK_NEIN"))
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("IDC_FH_BLOCKNEIN")));
            }
            if (stkPart.isKHaenger() && (stkPart.m_Pblock == "BLOCK_NEIN"))
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("IDC_KH_BLOCKNEIN")));
            }
            ***/

            if (stkPart.isFHaenger() && (stkPart.m_Pbeschicht == "TERROSON"))
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("FEDER_TERROSONBESCHICHTET")));
				if (strSprache == "DE")
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("FEDER_TERROSONBESCHICHTET")));
            }
            if (stkPart.isKHaenger() && (stkPart.m_Pbeschicht == "TERROSON"))
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("FEDER_TERROSONBESCHICHTET")));
				if (strSprache == "DE")
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stkPart.m_Ptyp + ": " + stringToSAP(translate("FEDER_TERROSONBESCHICHTET")));
            }

            if (stkList[i].funktion == "SON")   // Sonderteile 
            {
                
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("SONDERTEIL"))); 
                for (var j = 0; j < stkPart.Artikeltext.length; j++)
                {
                    nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(stkPart.Artikeltext[j])); 
                }            
            }
        }
        
		for (var MarkField = 1; MarkField <=2; MarkField++){
			//var TotalMark	= "";
			//var DoLine		= false;
			if (oLKinfo.extramarkierung != "" && MarkField == 2) {
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("EXTRAMARKIERUNG") + ": "));
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(trimleft(trimright(oLKinfo.extramarkierung, " "), " ")), {FuerCSV : 1, FuerDateiname : 0}));
				if (strSprache == "DE"){
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("EXTRAMARKIERUNG") + ": "));
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(trimleft(trimright(oLKinfo.extramarkierung, " "), " ")), {FuerCSV : 1, FuerDateiname : 0}));
				}
				/* SAP bricht nach 70 Zeichen je Zeile ab -> Zeilenaufteileung!!! */
				//TotalMark	= replaceSpecialChars(oLKinfo.extramarkierung, {FuerCSV : 1, FuerDateiname : 0});
				//DoLine		= true;
			}
			//else if (oLKinfo.markierung != "" && MarkField == 1) {
			else if ((oLKinfo.markierung != "" || oLKinfo.kundenzeichnnr != "") && MarkField == 1) {
				var NewLine1	= (oLKinfo.markierung != "" ? translate("ARTIKELBEZ") : "");
				var NewLine2	= (oLKinfo.markierung != "" ? trimleft(trimright(oLKinfo.markierung, " "), " ") : "");
				if (NewLine1 != "" && oLKinfo.kundenzeichnnr != ""){	// Markierung und Kundenmat.-Nr. vorhanden
					NewLine1	+= " / " + translate("TCH_CUSTOMER_CODE") + ": ";
					NewLine2	+= " / " + oLKinfo.kundenzeichnnr;
				}
				else if (NewLine1 != "" && oLKinfo.kundenzeichnnr == "")	// Markierung vorhanden und Kundenmat.-Nr. nicht vorhanden
					NewLine1	+= ": ";
				else if (NewLine1 == "" && oLKinfo.kundenzeichnnr != ""){	// Markierung nicht vorhanden und Kundenmat.-Nr. vorhanden
					NewLine1	+= translate("TCH_CUSTOMER_CODE") + ": ";
					NewLine2	+= oLKinfo.kundenzeichnnr;
				}
				/*
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ARTIKELBEZ") + ": "));
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(trimleft(trimright(oLKinfo.markierung, " "), " ")), {FuerCSV : 1, FuerDateiname : 0}));
				if (strSprache == "DE"){
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ARTIKELBEZ") + ": "));
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(trimleft(trimright(oLKinfo.markierung, " "), " ")), {FuerCSV : 1, FuerDateiname : 0}));
				}
				*/
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(NewLine1));
				nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(NewLine2), {FuerCSV : 1, FuerDateiname : 0}));
				if (strSprache == "DE"){
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(NewLine1));
					nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, replaceSpecialChars(stringToSAP(NewLine2), {FuerCSV : 1, FuerDateiname : 0}));
				}
				/* SAP bricht nach 70 Zeichen je Zeile ab -> Zeilenaufteileung!!! */
				//TotalMark	= replaceSpecialChars(oLKinfo.markierung, {FuerCSV : 1, FuerDateiname : 0});
				//DoLine		= true;
			}
			/*
			if (DoLine){
				// Achtung, hier können gewollte Zeilenumbrüche drin sein!!!
				var TotalMarkLine	= TotalMark.split("\n");
				TotalMark		= [];
				for (var a=0; a<TotalMarkLine.length; a++){
					if (TotalMarkLine[a].length <= maxLine)
						TotalMark.push(TotalMarkLine[a]);
					else{
						var Lines		= Math.floor(TotalMarkLine[a].length / maxLine) + 1;
						var FillUp		= Lines*maxLine - TotalMarkLine[a].length;
						for (var b=0; b<FillUp; b++){
							TotalMarkLine[a]	+= " ";
						}
						for (b=0; b<Lines; b++){
							TotalMark.push(right(left(TotalMarkLine[a], (b+1) * maxLine), maxLine));
						}
					}
				}
				for (a=0; a<TotalMark.length; a++){
					nZeilenNr	= this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(TotalMark[a], " "), " ")));
					if (strSprache == "DE")	// 2.2.2009: zusätzlich TXT-ID 006  analog zu TXT-ID 001
						nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(TotalMark[a], " "), " ")));
				}
			}
			*/
        }
		
		if ((oLKinfo.markierung != "" || oLKinfo.extramarkierung != "") && strSprache == "DE"){
		// Für Markierung zusätzlich Textart Z011 in DE anlegen ... zusätzlich Kenner Lieferprio = 99 
			// 2.2.2009: für TXT-ID Z011: nur noch fixen Text " Achtung Markierung!"
            //if (strSprache == "DE")
				nZeilenNrZ011 = this.addTextZeileZuKundenauftrag("Z011", nZeilenNrZ011, strOutFile, strAngebNr, strPosNr, "DE", stringToSAP("Achtung: Markierung!"));
            //    nZeilenNrZ011 = this.addTextZeileZuKundenauftrag("Z011", 1, strOutFile, strAngebNr, strPosNr, "DE", stringToSAP(translate("ARTIKELBEZ") + ": " + replaceSpecialChars(oLKinfo.markierung, {FuerCSV : 1, FuerDateiname : 0})));
		}
		
        if (oLKinfo.zeichnungsnr != "")
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ZEICHNUNGS_NR") + ": "));
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(replaceSpecialChars(oLKinfo.zeichnungsnr, {FuerCSV : 1, FuerDateiname : 0})));
        }
        if (oLKinfo.bemerkung != "")
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("BEMERKUNGEN") + ": "));
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(replaceSpecialChars(oLKinfo.bemerkung, {FuerCSV : 1, FuerDateiname : 0})));
        }
        
        var oPruefungAbnahme = this.getPruefungAbnahme(1);
        if (oPruefungAbnahme.aTextDokumentation.length > 0)
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("IDC_DOKUMENTATION_TEXT")));  
            for (j=0; j < oPruefungAbnahme.aTextDokumentation.length; j++)
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(oPruefungAbnahme.aTextDokumentation[j]));
            }            
        }
        if (oPruefungAbnahme.aTextKennzeichnung.length > 0)
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("IDC_KENNZEICHNUNG_TEXT")));  
            for (j=0; j < oPruefungAbnahme.aTextKennzeichnung.length; j++)
            {
                nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(oPruefungAbnahme.aTextKennzeichnung[j]));
            }            
        }
        
        if (oOptions.ZUSATZLEISTUNG_TEXT != "")
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("IDC_WI_ZUSATZLEISTUNG_LABEL")) + " " + stringToSAP(replaceSpecialChars(oOptions.ZUSATZLEISTUNG_TEXT,   {FuerCSV : 1, FuerDateiname : 0})));  
        }
        
        if (oOptions.SONDERANSTRICH_TEXT != "")
        {
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");
            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("IDC_WI_SONDERANSTRICH_LABEL")) + " " + stringToSAP(replaceSpecialChars(oOptions.SONDERANSTRICH_TEXT,   {FuerCSV : 1, FuerDateiname : 0})));  
        }

    },
	
	/*
    addTextZeileZuKundenauftrag : function(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, strText)
    {
        writefile(strOutFile, "VT;FL;"+strAngebNr+";"+strPosNr+";"+strTextTyp+";"+strSprache+";"+nZeilenNr+";"+strText+" \r\n", "a");	// append    
        return nZeilenNr + 1;
    },
	*/
	
	addTextZeileZuKundenauftrag : function(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, strText)
    {
		/* SAP bricht nach 70 Zeichen je Zeile ab -> Zeilenaufteileung!!! */
		// wir gehen auf 68 Zeichen
		var maxLineLength	= 68;
		// Achtung, hier können gewollte Zeilenumbrüche drin sein!!!
		var TotalText	= strText.split("\n");
		var TotalLines	= [];
		for (var a = 0; a < TotalText.length; a++){
			if (TotalText[a].length <= maxLineLength)
				TotalLines.push(TotalText[a]);
			else{	// die Zeile ist zu lang und muss aufgeteilt werden
				var Lines		= Math.floor(TotalText[a].length / maxLineLength) + 1;
				var FillUp		= Lines * maxLineLength - TotalText[a].length;
				for (var b = 0; b < FillUp; b++){
					TotalText[a]	+= " ";
				}
				for (b = 0; b < Lines; b++){
					TotalLines.push(right(left(TotalText[a], (b + 1) * maxLineLength), maxLineLength));
				}
			}
		}
		for (a = 0; a<TotalLines.length; a++){
			strText	= TotalLines[a];
			writefile(strOutFile, "VT;FL;"+strAngebNr+";"+strPosNr+";"+strTextTyp+";"+strSprache+";"+nZeilenNr+";"+strText+" \r\n", "a");	// append
			nZeilenNr++;
		}
		return nZeilenNr;
	},
    
    addPositionToAuftragsStkListe : function(strOutFile,
                                                strAngebNr,
                                                strPosNr,
                                                strQTY,
                                                strDateSAP
                                                )
    {
        var LKMatInfo  = this.topologieKlasse.getLastkettenIdent(this);   
        var strLKMatNr = LKMatInfo.matnr;
        var oRetObj = { transferCount: 1,
                        strMessage: "" };

        var stkList = [];
        this.topologieKlasse.getStueckliste(stkList);
        var bEinzelProdukt = 0;
        var lkTyp = this.dataAccess.getLastketteTyp();
		
		// -mw- 1.2.2012: 
		// Sonderfall für neue Lagerauswahl: Wenn das Lager in Kombination mit einem Klemmsystem
		// auftritt und das Lager aufgeloest wird, dann soll es direkt in die obere Ebene der
		// Stückliste aufgelöst werden.
		var specialLagerinfo = this.topologieKlasse.getSpecialLagerInfo();  // bIsLagerAuswahl, bIsEinzelprodukt, bIsLagerMitKlemmsystem, bIsConfigurable
		var loeseErstePosDirektAuf = false;
		/*
		if (specialLagerinfo.bIsLagerAuswahl && (specialLagerinfo.bIsLagerMitKlemmsystem || specialLagerinfo.bIsConfigurable)
				&& !specialLagerinfo.bIsRLAuswahl && !specialLagerinfo.bIsAuswahlKSeinzel)
		*/
		if (specialLagerinfo.bIsLagerAuswahl && (specialLagerinfo.bIsLagerMitKlemmsystem || specialLagerinfo.bIsConfigurable)
				&& !specialLagerinfo.bIsRLAuswahl && !specialLagerinfo.bIsAuswahlKSeinzel && !specialLagerinfo.bSonderteile)
			loeseErstePosDirektAuf = true;

		var bSimulierteEinzelstueckliste = false;
		if (( lkTyp == "EINZEL_ZUBEHOER" ) && (stkList.length == 1) && (stkList[0].produkt.m_Ptypid == "ZRM"))
			bSimulierteEinzelstueckliste = true;

        // 04/2008: Für nicht-konfigurierbare Einzelprodukte darf gar keine
        // Auftragsstückliste übergeben werden. Achtung: Kann dazu führen, dass
        // überhaupt kein Datensatz erzeugt wird und der RFC auch gar nicht gestartet
        // werden darf.
        if (this.getNichtKonfigurierbaresEinzelprodukt() && (! bSimulierteEinzelstueckliste))
			//|| (!(specialLagerinfo.bIsConfigurable) && specialLagerinfo.bIsEinzelprodukt))
        {
            oRetObj.transferCount = 0;
            return oRetObj;
        }
    
        // Kopfdatensatz ASTL-KOPF für die Position:
        // -mw- 6.6.2008 nach Info -schm-: Stückzahl hier immer 1, da es sich um die Bemessungsmenge der Stückliste handelt.
        writefile(strOutFile, "ASTL-KOPF;"+strAngebNr+";"+strPosNr+";FL;"+strLKMatNr+";"+strDateSAP+";1 \r\n", "a");	// append
        
        if (strLKMatNr == "")
            oRetObj.strMessage += "Pos "+strPosNr+": Kopf-Materialnummer fehlt!\\n";
        // Weitere Datensätze ASTL-POS für die Stücklistenpositionen
        // Dabei unterscheiden:
        //  - manche brauchen Rohmass-Daten (ZRM)
        //  - manche müssen selbst wieder in Stücklisten zerlegt werden

        // Bei Einzelprodukten, die keinen separaten LK-Ident haben und die weiter
        // aufgelöst werden, darf Sub-Kopf-Datensatz und erster Pos-Datensatz nicht 2 mal übergeben werden
        if  ((( lkTyp == "EINZEL_LAGER" ) || ( lkTyp == "EINZEL_SCHELLE" ) || 
             ( lkTyp == "EINZEL_ZUBEHOER" )|| ( lkTyp == "EINZEL_KLEMMSYSTEM" ) ||
			 ( specialLagerinfo.bIsEinzelprodukt )) &&
             (this.topologieKlasse.Sonderteile.length <= 0))
        {
            bEinzelProdukt = 1;
        }
        
        var stkPart;
        var retObj;
        var nKompAnz = 1;   // bei doppelten LK 2, Wert kommt generell aus der Stückliste!
        
        for (var i = 0; i < stkList.length; i++)
        {
            stkPart  = stkList[i].produkt;
            nKompAnz = stkList[i].anz;
            
            // Weitere Auflösung erforderlich
            // Postyp (R=Rohmass oder L=nicht), Mat-Nr Komponente, Postext1 und 2, 
            // falls erf.: Rohmassmenge1, Einheit, RM2, RM3, Formelzeichen und Auflösungssteuerung
            // Menge Komponente hier aus Stückliste
            retObj  = stkPart.getASTLDaten(this);   
            /*         var retObj = { loeseauf: 0, postyp: "L", matnr: "", postext1: "", postext2 : "", 
                       rm1: "", rm_einheit: "", rm2: "", rm3: "", formelzeichen: "",
                       aufloesungssteuerung: ""};
            */
			// 13.04.2016 neues Vorgehen bei Sonderteilen
			// wenn das Lager aufgelöst werden soll aber Sonderteile vorhanden sind,
			// dann braucht das Lager die Nummer der Lagerlastkette - diese steht in der ersten Ebene der Sückliste
			// das Lager wird dann in der zweiten Ebene aufgelöst
			// gilt nicht für Klemmsysteme - ODER???
			if (retObj.loeseauf && specialLagerinfo.bSonderteile && !specialLagerinfo.bIsAuswahlKSeinzel){
				if (LKMatInfo.matnr_lk_lg != "")	// es kann auch die SPZ-Nr. (976064) sein
					retObj.matnr	= LKMatInfo.matnr_lk_lg;
			}
			var StueLiPosNr	= i+1;
			if (retObj.StueLiPosNr)
				StueLiPosNr	= retObj.StueLiPosNr;
			// Bei einem Einzelprodukt, das aufgelöst wird, soll eine "Stufe" unterdrückt werden
			// -Schu- gilt auch für LK RL mit Sattel und AHS für die AHS (Teile der AHS werden im Sattel mit erzeugt)
            if (((! (bEinzelProdukt && retObj.loeseauf)) &&	(! (loeseErstePosDirektAuf && (i == 0) && retObj.loeseauf))) &&
					!(stkList[i].funktion == "ABE" && specialLagerinfo.bIsRLAuswahl))
                //writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strLKMatNr+";"+(i+1)+";"+(i+1)+";"+retObj.postyp+";"+retObj.matnr+";"+nKompAnz+";ST;;"+retObj.postext1+";"+retObj.postext2+";"+retObj.rm1+";"+retObj.rm_einheit+";"+retObj.rm2+";"+retObj.rm3+";"+retObj.formelzeichen+";"+retObj.aufloesungssteuerung+" \r\n", "a");	// append
				writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strLKMatNr+";"+StueLiPosNr+";"+StueLiPosNr+";"+retObj.postyp+";"+retObj.matnr+";"+nKompAnz+";ST;;"+retObj.postext1+";"+retObj.postext2+";"+retObj.rm1+";"+retObj.rm_einheit+";"+retObj.rm2+";"+retObj.rm3+";"+retObj.formelzeichen+";"+retObj.aufloesungssteuerung+" \r\n", "a");	// append
            if (retObj.matnr == "")
                oRetObj.strMessage += "Pos "+strPosNr+", Stuecklistenpos "+(i+1)+": Produkt-Materialnummer fehlt!\\n";
            
			// Achtung: Eingriff in die Auflösungssteuerung
			// AHS (f. Rollenlager) wird nur aufgelöst wenn diese EINZELN ausgewählt wird - sonst in Sattel!!!
			if (stkList[i].funktion == "ABE" && !specialLagerinfo.bIsAuswahlAHSeinzel)
				retObj.loeseauf	= false;
            
			if (retObj.loeseauf)
            {
                // weitere Stuecklistenauflösung in Submodulen ...
                
                // Kopfdatensatz ASTL-KOPF für das Teil:
                /* ACHTUNG: was ist denn hier die Basismenge?
                 >>> Rainer Bischoff 11.12.2007 09:41 >>>
                    die Stückliste bezieht sich immer auf ein Enderzeugnis bzw. auf eine
                    Baugruppe. Erst im Fertigungsauftrag wird mit der Auftragsmenge
                    ausmultipliziert.
                */
                if (((! (bEinzelProdukt && retObj.loeseauf)) &&	(! (loeseErstePosDirektAuf && (i == 0)))) &&
						!(stkList[i].funktion == "ABE" && specialLagerinfo.bIsRLAuswahl))
                    writefile(strOutFile, "ASTL-KOPF;"+strAngebNr+";"+strPosNr+";FL;"+retObj.matnr+";"+strDateSAP+";"+nKompAnz+" \r\n", "a");	// append
				
				if (loeseErstePosDirektAuf && (i == 0))
					oRetObj.strMessage += stkPart.setASTLSubDaten(this, strOutFile, strAngebNr, strPosNr, strLKMatNr);
				else
					oRetObj.strMessage += stkPart.setASTLSubDaten(this, strOutFile, strAngebNr, strPosNr, retObj.matnr);
            }
        }
        return oRetObj;
    },
    
	// --------------------- Das geht -------------------------
/*
	doMergeItems : function(StueLi, StueLiFP)
	{
		/*
		Besprechung 18.06.2014 (Ka, Ge, Schu)
		- Zusammengefasst werden folgende Positionen:
			1) ausgelegte Positionen
				-> Lager und starre Lastketten
				(-> für Hänger machbar - erhöhter Vergleichsaufwand - Lasten, Wege, ...)
				-> gleiche Stückliste (Achtung bei Sonderteilen v.A. aus ASSI)				@@@ ToDo
				-> gleicher Preis (Vorgabepreise beachten) - Vergl. anhand Preis/Pos
			2) freie Positionen
				-> gleiche Mat.Nr. (nicht leer)
				-> gleicher Text
				-> gleicher Preis (Vorgabepreise beachten) - Vergl. anhand Preis/Pos
		- Positionen mit Stückzahl "NULL" werden micht zusammengefasst (Markierung, Zeichnungsnummer, ...)
		- Positionen mit Stückzahl "NULL" werden gelöscht
		*/
		/*
		13.12.2016 - Schu - neues Feld "Anfrageposition"
		-> mit zusammenfassen und in Markierungsliste mit ausgeben
		*/
/*		var StueLi_Pos	= [];
		var b = 0;
		// Sortieren der Einzelprodukte zu den Positionen (z.B. Lager mit KSY als Führungslager)
		for (var a = 0; a < StueLi.length; a++){	// StueLi -> keine Freien Positionen
			if (!StueLi_Pos[b])
				StueLi_Pos[b] = [];
			StueLi_Pos[b].push(StueLi[a]);
			if ((a < StueLi.length-1) && (StueLi[a+1].posnr != StueLi_Pos[b][0].posnr))
				b++;
		}
		// Freie Positionen an StueLi anhängen
		b	= StueLi_Pos.length;
		for (var a = 0; a < StueLiFP.length; a++){
			StueLi_Pos[b] = [];
			StueLi_Pos[b].push(StueLiFP[a]);
			b++;
		}
		// Festlegung des Trennzeichens für die Markierung
		var strMarkSign	= getstring("WI_MARK_SIGN", "PROJECT.SETTINGS");
		if (strMarkSign == "")
			strMarkSign	= ",";
		
		// Beginn der Zusammenfassung
		var StueLi_Pos_ZSF	= [];	// Zusammengefasste Stückliste
		var DelItems		= [];	// zu löschende Positionen
		for (a = 0; a < StueLi_Pos.length; a++){
			if (!StueLi_Pos[a][0].qty)	//Positionen mit Stückzahl "NULL" werden nicht zusammengefasst und gelöscht
										//-> das läuft so nicht, da das die Anzahl der einzelnen Bauteile ist
				DelItems.push(StueLi_Pos[a][0].posnr*1);
			else if (!StueLi_Pos_ZSF.length){	// die erste Position bei der die Stückzahl nicht NULL ist direkt "zusammenfassen"
				var InformationsAdd	= 0;	// zusätzlich gepeicherte Infos
				StueLi_Pos_ZSF.push(StueLi_Pos[a]);
				StueLi_Pos_ZSF[0].isFP		= (toupper(left(StueLi_Pos_ZSF[0][0].fkt, 2)) == "FP" ? true : false);
				InformationsAdd++;
				StueLi_Pos_ZSF[0].totalQTY	= (StueLi_Pos_ZSF[0][0].qty) * 1;
				InformationsAdd++;
				StueLi_Pos_ZSF[0].totalMark	= trimleft(trimright(StueLi_Pos_ZSF[0][0].anlpos, " "), " ");
				InformationsAdd++;
				if (StueLi_Pos_ZSF[0].isFP)
					StueLi_Pos_ZSF[0].totalZnNr	= trimleft(trimright(StueLi_Pos_ZSF[0][0].znr, " "), " ");
				else
					StueLi_Pos_ZSF[0].totalZnNr	= trimleft(trimright(StueLi_Pos_ZSF[0][0].zgnr, " "), " ");
				InformationsAdd++;
				StueLi_Pos_ZSF[0].OriPos		= StueLi_Pos_ZSF[0][0].posnr;	// zur Kopie der Position
				InformationsAdd++;
				StueLi_Pos_ZSF[0].AnfrPos		= StueLi_Pos_ZSF[0][0].anfrpos;	// alle Originalanfragepositionen vor dem Zusammenfassen
				InformationsAdd++;
				StueLi_Pos_ZSF[0].totalOriPos	= StueLi_Pos_ZSF[0][0].posnr;	// alle Originalpositionen vor dem Zusammenfassen
				InformationsAdd++;
			}
			else{
				for (b = 0; b < StueLi_Pos_ZSF.length; b++){	// Vergleich der aktuellen Pos mit den zusammengefassten
					//if ((StueLi_Pos_ZSF[b].length - 5) == StueLi_Pos[a].length	// Anzahl der Teile gleich?
					if ((StueLi_Pos_ZSF[b].length - InformationsAdd) == StueLi_Pos[a].length	// Anzahl der Teile gleich?
						&& ((StueLi_Pos_ZSF[b].isFP && toupper(left(StueLi_Pos[a][0].fkt, 2)) == "FP")	// beide Freie Pos?
								|| (!StueLi_Pos_ZSF[b].isFP && toupper(left(StueLi_Pos[a][0].fkt, 2)) != "FP"))	// beide ausgelegte Pos?
						&& atod(StueLi_Pos_ZSF[b][0].posPreis)/atoi(StueLi_Pos_ZSF[b][0].qty) == atod(StueLi_Pos[a][0].posPreis)/atoi(StueLi_Pos[a][0].qty) // sind Preise identisch
						){
						var isSame	= true;	// jetzt können die Pos gleich sein
						for (var c = 0; c < StueLi_Pos[a].length; c++){	// Inhaltsvergleich der StüLi's
							if (StueLi_Pos[a][c].typ != StueLi_Pos_ZSF[b][c].typ	// ist Typ gleich?
								|| atoi(StueLi_Pos[a][c].ident) != atoi(StueLi_Pos_ZSF[b][c].ident)	// ist Mat.Nr. gleich? (zur Sicherheit)
								|| (StueLi_Pos[a][c].fkt == "HNG" && left(StueLi_Pos[a][c].typ, 3) != "ZSM") // ist es Lager oder starrer Hänger
								|| (StueLi_Pos_ZSF[b].isFP	// Freie Position mit ...
										&& (atoi(StueLi_Pos[a][c].ident) != atoi(StueLi_Pos_ZSF[b][c].ident)	// unterschiedl. Idents
											|| (atoi(StueLi_Pos[a][c].ident) == 0 && atoi(StueLi_Pos_ZSF[b][c].ident) == 0)	// beide Idents leer
											|| toupper(StueLi_Pos[a][c].text.replace(" ", "")) != toupper(StueLi_Pos_ZSF[b][c].text.replace(" ", "")))) // unterschiedl. Texten
								|| (!StueLi_Pos_ZSF[b].isFP	// Ausgelegte Pos mit ...
										&& toupper(StueLi_Pos[a][0].bem.replace(" ", "")) != toupper(StueLi_Pos_ZSF[b][0].bem.replace(" ", ""))) // unterschiedl. Bemerkungen
								){
								isSame	= false;
							}
						}
					if (isSame)	// wenn es hier gleich ist, nicht weiter suchen (das nächste könnte nicht passen)
						break;
					}
					else
						var isSame	= false;
				}
				
				// Löschen des Trennzeichens wenn Stückzahl "1" und Zeichen trotzdem da ist
				StueLi_Pos[a][0].anlpos	= (StueLi_Pos[a][0].qty*1 <= 1 ? StueLi_Pos[a][0].anlpos.replace(strMarkSign, "") : StueLi_Pos[a][0].anlpos);
				
				if (isSame){	// bei Gleichheit Stückzahl, Markierung, Zeichnungsnummern zusammenführen und aktuelle Pos. auf "löschen" setzen
					StueLi_Pos_ZSF[b].totalQTY += StueLi_Pos[a][0].qty*1;
					DelItems.push(StueLi_Pos[a][0].posnr*1);
					StueLi_Pos_ZSF[b].totalMark	+= (StueLi_Pos_ZSF[b].totalMark != "" ? strMarkSign + " " : "") + trimleft(trimright(StueLi_Pos[a][0].anlpos, " "), " ");
					if (StueLi_Pos_ZSF[b].isFP)
						StueLi_Pos_ZSF[b].totalZnNr	+= (StueLi_Pos_ZSF[b].totalZnNr != "" ? strMarkSign + " " : "") + trimleft(trimright(StueLi_Pos[a][0].znr, " "), " ");
					else
						StueLi_Pos_ZSF[b].totalZnNr	+= (StueLi_Pos_ZSF[b].totalZnNr != "" ? strMarkSign + " " : "") + trimleft(trimright(StueLi_Pos[a][0].zgnr, " "), " ");
					
					StueLi_Pos_ZSF[b].AnfrPos		+= (StueLi_Pos_ZSF[b].AnfrPos != "" ? strMarkSign + " " : "") + trimleft(trimright(StueLi_Pos[a][0].anfrpos, " "), " ");
					StueLi_Pos_ZSF[b].totalOriPos	+= (StueLi_Pos_ZSF[b].totalOriPos != "" ? strMarkSign + " " : "") + trimleft(trimright(StueLi_Pos[a][0].posnr, " "), " ");
				}
				else{	// neue Pos in Zusammenfassung
					StueLi_Pos_ZSF.push(StueLi_Pos[a]);
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].isFP		= (toupper(left(StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)][0].fkt, 2)) == "FP" ? true : false);
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].totalQTY	= (StueLi_Pos[a][0].qty) * 1;
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].totalMark	= trimleft(trimright(StueLi_Pos[a][0].anlpos, " "), " ");
					if (StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].isFP)
						StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].totalZnNr	= trimleft(trimright(StueLi_Pos[a][0].znr, " "), " ");
					else
						StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].totalZnNr	= trimleft(trimright(StueLi_Pos[a][0].zgnr, " "), " ");
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].OriPos		= StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)][0].posnr;
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].AnfrPos		= StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)][0].anfrpos;
					StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)].totalOriPos	= StueLi_Pos_ZSF[(StueLi_Pos_ZSF.length-1)][0].posnr;
				}
			}
		}
		var OriItems		= Object.fromStorage("PROJECT.POSITIONS");
		var OriTotalItems	= OriItems.PROJECTLIST_ITEMS.length;
		var NewItems		= [];
		var CopyThis;
		for (a = 0; a < OriTotalItems; a++){	// Suchen der Originaldaten
			CopyThis	= false;
			for (b = 0; b < StueLi_Pos_ZSF.length; b++){
				if (StueLi_Pos_ZSF[b].OriPos*1 == OriItems.PROJECTLIST_ITEMS[a].POS*1){
					CopyThis	= true;
					break;
				}
			}
			if (CopyThis){	// modifizieren der Originaldaten
				OriItems.PROJECTLIST_ITEMS[a].QTY				= StueLi_Pos_ZSF[b].totalQTY;
				OriItems.PROJECTLIST_ITEMS[a].MARKIERUNG		= StueLi_Pos_ZSF[b].totalMark;
				OriItems.PROJECTLIST_ITEMS[a].FORCEDUNITPRICE	= trimright(trimleft(OriItems.PROJECTLIST_ITEMS[a].FORCEDUNITPRICE, " "), " ");
				OriItems.PROJECTLIST_ITEMS[a].FORCEDUNITPRICE	= OriItems.PROJECTLIST_ITEMS[a].FORCEDUNITPRICE.replace(",", ".");
				if (!StueLi_Pos_ZSF[b].isFP){
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR	= StueLi_Pos_ZSF[b].totalMark;
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR	= StueLi_Pos_ZSF[b].totalZnNr;
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		= StueLi_Pos_ZSF[b].AnfrPos;
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ORIFLEXPOS		= StueLi_Pos_ZSF[b].totalOriPos;
				}
				else{
					var TestMark	= OriItems.PROJECTLIST_ITEMS[a].ORDERCODE.split("<br>");
					var WasMark		= (TestMark.length == 1 ? false : true);		// war bereits eine Markierung vorhanden?
					var NewOrderC	= (StueLi_Pos_ZSF[b].totalMark != "" ? StueLi_Pos_ZSF[b].totalMark + "<br>" : "");
					for (c = (WasMark ? 1 : 0); c < TestMark.length; c++){	// können eigentlich nur max. 2 Zeilen sein
						NewOrderC	+= TestMark[c];
					}
					OriItems.PROJECTLIST_ITEMS[a].ORDERCODE				= NewOrderC;
					OriItems.PROJECTLIST_ITEMS[a].ORDERCODE_PROJECTLIST	= NewOrderC;
					OriItems.PROJECTLIST_ITEMS[a].FP.MARKIERUNG			= StueLi_Pos_ZSF[b].totalMark;
					OriItems.PROJECTLIST_ITEMS[a].FP.ZEICHNUNGSNR		= StueLi_Pos_ZSF[b].totalZnNr;
					OriItems.PROJECTLIST_ITEMS[a].FP.IDC_ORIFLEXPOS		= StueLi_Pos_ZSF[b].totalOriPos;
				}
				NewItems.push(OriItems.PROJECTLIST_ITEMS[a]);	// setzen der "neuen" Position
			}
		}
		
		NewItems.toStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS', false);
		setstring("PROJECTLIST_SELECTED", "PROJECT.POSITIONS", "1");
		
		return (NewItems);
	},
*/
	// --------------------- besser -------------------------
	doMergeItems : function()
	{
		var OriItems	= Object.fromStorage("PROJECT.POSITIONS");	// Originale Pos.
		var QTYOriItems	= OriItems.PROJECTLIST_ITEMS.length;	// Anzahl der Pos.
		var NewItems	= [];	// zusammengefasste Positionen
		var NewItemsPos	= [];
		var NewItem		= false;
		var ItemsQTY0	= [];	// Pos. mit Stückzahl "0"
		var isSame		= false;
		var isFP		= false;
		var StueLiOri	= "";
		var StueLiVgl	= "";
		var StkListe	= [];
		var StkListeFP	= [];
		var TrennZeich	= getstring("WI_MARK_SIGN", "PROJECT.SETTINGS");	// Trennzeichenfür Markierung
		if (TrennZeich == "")
			TrennZeich	= ",";
		
		var dokManager = new CaDokManager(this);
		dokManager.prepareDatenStueckliste(1);
		StkListe	= dokManager.stueckListe;
		StkListeFP	= dokManager.stueckListeFP;
		
		var StueLi_Pos	= [];
		var b = 0;
		// Sortieren der Einzelprodukte zu den Positionen (z.B. Lager mit KSY als Führungslager)
		for (var a = 0; a < StkListe.length; a++){	// StueLi -> keine Freien Positionen
			if (!StueLi_Pos[b])
				StueLi_Pos[b] = [];
			StueLi_Pos[b].push(StkListe[a]);
			if ((a < StkListe.length-1) && (StkListe[a+1].posnr != StueLi_Pos[b][0].posnr))
				b++;
		}
		// Freie Positionen an StueLi anhängen
		b	= StueLi_Pos.length;
		for (a = 0; a < StkListeFP.length; a++){
			StueLi_Pos[b] = [];
			StueLi_Pos[b].push(StkListeFP[a]);
			b++;
		}
		
		for (a = 0; a < QTYOriItems; a++){
			
			if (OriItems.PROJECTLIST_ITEMS[a].QTY*1 == 0){		// Pos. mit Stückzahl "0"
				ItemsQTY0.push(OriItems.PROJECTLIST_ITEMS[a]);
				continue;
			}
			
			if ((NewItems.length == 0) ||	// das erste OriItem geht direkt nach NewItems und alles was nicht Lager ist auch
				//(typeof(OriItems.PROJECTLIST_ITEMS[a].FP) != 'object' && OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.__CLASSNAME__ != "CaTopoLager2")){
				(typeof(OriItems.PROJECTLIST_ITEMS[a].FP) != 'object' &&
					OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.__CLASSNAME__ != "CaTopoLager2" &&
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTKETTE != "EINZEL_SCHELLE" &&
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTKETTE != "EINZEL_ZUBEHOER")){
				// prüfen, ob eine StüLi für diese Pos. existiert
				var SucheWeiter	= true;
				b				= 0;
				while(SucheWeiter && b < StueLi_Pos.length){
					if (OriItems.PROJECTLIST_ITEMS[a].POS == StueLi_Pos[b][0].posnr){
						SucheWeiter	= false;
						NewItems.push(OriItems.PROJECTLIST_ITEMS[a]);
						NewItemsPos.push(b);
					}
					else
						b++;
				}
				continue;
			}
			
			// jetzt müssen wir vergleichen
			// StüLi / Preis
			
			// suchen der StueLi_Pos
			var PosOri		= -1;
			var PosVgl		= 0;
			var SucheWeiter	= true;
			b				= 0;
			while(SucheWeiter && b < StueLi_Pos.length){
				if (OriItems.PROJECTLIST_ITEMS[a].POS == StueLi_Pos[b][0].posnr){
					SucheWeiter	= false;
					PosOri		= b;
				}
				else
					b++;
			}
			// ggf. haben wir nichts gefunden - sollte nicht vorkommen
			if (SucheWeiter)
				continue;
			
			isSame		= false;
			b = 0;
			
			var OriPreis	= OriItems.PROJECTLIST_ITEMS[a].POSPRICE*1;
			if (OriPreis + "" == "NaN" || OriPreis + "" == "undefined")
				OriPreis	= 0;
			while(!isSame && b < NewItemsPos.length){	// Vergleich der jew. Teile in PosOri mit PosVgl
				var NewPreis	= NewItems[b].POSPRICE*1;
				if (NewPreis + "" == "NaN" || NewPreis + "" == "undefined")
					NewPreis	= 0;
				PosVgl	= NewItemsPos[b];
				
				if ((StueLi_Pos[PosOri].length == StueLi_Pos[PosVgl].length) &&	// Anzahl der Teile gleich und Preis gleich
					(fround(OriPreis / OriItems.PROJECTLIST_ITEMS[a].QTY, 2) == fround(NewPreis / NewItems[b].QTY, 2))){	//Preis gleich
					isSame	= true;
					var c	= 0;
					while(isSame && c < StueLi_Pos[PosOri].length){
						if (typeof(OriItems.PROJECTLIST_ITEMS[a].FP) == 'object'){
							if (StueLi_Pos[PosOri][c].text != StueLi_Pos[PosVgl][c].text)
								isSame	= false;
							}
						else{
							if (StueLi_Pos[PosOri][c].typ != StueLi_Pos[PosVgl][c].typ){
								// erweiterter Vergleich für Klemmsysteme --> ...-T100 ist gleich ...-T140
								if (StueLi_Pos[PosOri][c].fkt == StueLi_Pos[PosVgl][c].fkt && StueLi_Pos[PosVgl][c].fkt == "KSY"){
									var KSYOri	= StueLi_Pos[PosOri][c].typ.split("-");
									var KSYVgl	= StueLi_Pos[PosVgl][c].typ.split("-");
									var T1	= KSYOri.length;
									var T2	= KSYVgl.length;
									var T3	= KSYOri[0];
									var T4	= KSYVgl[0];
									if (KSYOri[0] == KSYVgl[0] && KSYOri.length > 1 && KSYVgl.length > 1){
										if ((toupper(left(KSYOri[KSYOri.length-1], 1)) == "T" && toupper(left(KSYVgl[KSYVgl.length-1], 1)) == "T")
											&& (right(KSYOri[KSYOri.length-1], 3)*1 <= 140 && right(KSYVgl[KSYVgl.length-1], 3)*1 <= 140)){
											isSame	= true;
										}
										else
											isSame	= false;
									}
									else
										isSame	= false;
								}
								else
									isSame	= false;
							}
						}
						c++;
					}
				}
				if (!isSame)
					b++;
			}
			if(isSame){		// Positionen zusammenfassen
				var isMarkInText	= false;
				if (NewItems[b].MARKIERUNG != "")
					isMarkInText	= true;
				
				// wenn die Position zusammengefasst wird, setzen wir die "Werte" (Markierung, Bemerkungen, ...)
				// jeweils in |...|
				var DoLKInfos	= false;
				if (typeof(NewItems[b].FP) == 'object' && left(NewItems[b].FP.MARKIERUNG, 1) != "|"){
					DoLKInfos	= true;
					NewItems[b].FP.MARKIERUNG	= "|" + NewItems[b].FP.MARKIERUNG + "|";
					NewItems[b].FP.ZEICHNUNGSNR	= "|" + NewItems[b].FP.ZEICHNUNGSNR + "|";
				}
				else if (left(NewItems[b].MARKIERUNG, 1) != "|"){
					DoLKInfos	= true;
					NewItems[b].MARKIERUNG		= "|" + NewItems[b].MARKIERUNG + "|";
				}
				if (DoLKInfos){
					NewItems[b].CUSTOMER_CODE	= "|" + NewItems[b].CUSTOMER_CODE + "|";
					if (typeof(NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS) == 'string')
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		= "|" + NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS + "|";
					else
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		= "||";
					if (typeof(NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR) == 'string')
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR	= "|" + NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR + "|";
					else
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR	= "||";
					if (typeof(NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN) == 'string')
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN		= "|" + NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN + "|";
					else
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN		= "||";
					if (typeof(NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR) == 'string')
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR		= "|" + NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + "|";
					else
						NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR		= "||";
				}
				
				// Markierung
				if (typeof(NewItems[b].FP) == 'object'){
					NewItems[b].FP.MARKIERUNG	+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].FP.MARKIERUNG + "|";
					NewItems[b].FP.ZEICHNUNGSNR	+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].FP.ZEICHNUNGSNR + "|";
				}
				else
					NewItems[b].MARKIERUNG		+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].MARKIERUNG + "|";
				// KundenMatNr
				NewItems[b].CUSTOMER_CODE	+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].CUSTOMER_CODE + "|";
				// AnfrageNr
				if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS) == 'string')
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS + "|";
				else
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		+= TrennZeich + " ||";
				// Markierung in Uebersicht LK
				if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR) == 'string')
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR	+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR + "|";
				else
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		+= TrennZeich + " ||";
				// Bemerkungen
				if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN) == 'string')
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN		+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN + "|";
				else
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		+= TrennZeich + " ||";
				// ZeichnugsNr
				if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR) == 'string')
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR		+= TrennZeich + " |" + OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + "|";
				else
					NewItems[b].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS		+= TrennZeich + " ||";
				// Stückzahl
				NewItems[b].QTY	= (NewItems[b].QTY*1) + (OriItems.PROJECTLIST_ITEMS[a].QTY*1);
				// Preise
				NewItems[b].POSPRICE	= (NewItems[b].POSPRICE*1) + (OriItems.PROJECTLIST_ITEMS[a].POSPRICE*1);
				// Texte
				var SplitText	= NewItems[b].ORDERCODE.split("<br>");
				NewItems[b].ORDERCODE	= (typeof(NewItems[b].FP) == 'object' ? NewItems[b].FP.MARKIERUNG : NewItems[b].MARKIERUNG);
				c	= (isMarkInText ? 1 : 0);
				for (c; c < SplitText.length; c++){
					NewItems[b].ORDERCODE	+= "<br>" + SplitText[c];
				}
				SplitText	= NewItems[b].ORDERCODE_PROJECTLIST.split("<br>");
				NewItems[b].ORDERCODE_PROJECTLIST	= (typeof(NewItems[b].FP) == 'object' ? NewItems[b].FP.MARKIERUNG : NewItems[b].MARKIERUNG);
				c	= (isMarkInText ? 1 : 0);
				for (c; c < SplitText.length; c++){
					NewItems[b].ORDERCODE_PROJECTLIST	+= "<br>" + SplitText[c];
				}
			}
			else{
				NewItems.push(OriItems.PROJECTLIST_ITEMS[a]);
				NewItemsPos.push(PosOri);
			}
		}
		
		var CheckEmpty	= "";
		for (a = 0; a < NewItems.length; a++){
			NewItems[a].IMPORT_CHECK	= "true";
			
			if (typeof(NewItems[a].FP) == 'object')
				CheckEmpty	= NewItems[a].FP.MARKIERUNG.replace("|", "");
			else
				CheckEmpty	= NewItems[a].MARKIERUNG.replace("|", "");
			CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
			CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
			if (CheckEmpty == ""){
				if (typeof(NewItems[a].FP) == 'object')
					NewItems[a].FP.MARKIERUNG	= CheckEmpty;
				else
					NewItems[a].MARKIERUNG	= CheckEmpty;
			}
			
			if (typeof(NewItems[a].CUSTOMER_CODE) == 'string'){
				CheckEmpty	= NewItems[a].CUSTOMER_CODE.replace("|", "");
				CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
				CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
				if (CheckEmpty == "")
					NewItems[a].CUSTOMER_CODE	= CheckEmpty;
			}
			
			if (typeof(NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS) == 'string'){
				CheckEmpty	= NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS.replace("|", "");
				CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
				CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
				if (CheckEmpty == "")
					NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS	= CheckEmpty;
			}
			
			if (typeof(NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR) == 'string'){
				CheckEmpty	= NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR.replace("|", "");
				CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
				CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
				if (CheckEmpty == "")
					NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR	= CheckEmpty;
			}
			
			if (typeof(NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN) == 'string'){
				CheckEmpty	= NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN.replace("|", "");
				CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
				CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
				if (CheckEmpty == "")
					NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN	= CheckEmpty;
			}
			
			if (typeof(NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR) == 'string'){
				CheckEmpty	= NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR.replace("|", "");
				CheckEmpty	= CheckEmpty.replace(TrennZeich, "");
				CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
				if (CheckEmpty == "")
					NewItems[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR	= CheckEmpty;
			}
			
			var SplitText	= NewItems[a].ORDERCODE.split("<br>");
			CheckEmpty	= SplitText[0].replace("|", "");
			CheckEmpty	= CheckEmpty.replace(",", "");
			CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
			if (CheckEmpty == ""){
				NewItems[a].ORDERCODE	= CheckEmpty;
				for (c = 1; c < SplitText.length; c++){
					NewItems[a].ORDERCODE	+= SplitText[c] + "<br>";
				}
				NewItems[a].ORDERCODE	= trimright(NewItems[a].ORDERCODE, "<br>");
			}
			
			SplitText	= NewItems[a].ORDERCODE_PROJECTLIST.split("<br>");
			CheckEmpty	= SplitText[0].replace("|", "");
			CheckEmpty	= CheckEmpty.replace(",", "");
			CheckEmpty	= trimright(trimleft(CheckEmpty, " "), " ");
			if (CheckEmpty == ""){
				NewItems[a].ORDERCODE_PROJECTLIST	= CheckEmpty;
				for (c = 1; c < SplitText.length; c++){
					NewItems[a].ORDERCODE_PROJECTLIST	+= SplitText[c] + "<br>";
				}
				NewItems[a].ORDERCODE_PROJECTLIST	= trimright(NewItems[a].ORDERCODE_PROJECTLIST, "<br>");
			}
		}
		NewItems.toStorage('TEMP.PROJECT.POSITIONS.PROJECTIMPORTLIST_ITEMS', false);
		NewItems	= [];
		NewItems.toStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS', false);
		setstring("MERGED_FLAG", "TEMP", true);
		setstring("PROJECTLIST_SELECTED", "PROJECT.POSITIONS", "");
		
		return;
	},
	
	ChangeSurface : function(ToStorage, ItemNo, ItemType, SubLen, ItemPath, HangerDone){
		var typManager		= new CaTypsucheManager(tmpCaMainController);
		var oParseResult	= null;
		var oReturn			= { msg			: '',
								oProduct	: null};
		oParseResult		= typManager.createProductFromTyp(left(ItemType, ItemType.length - SubLen), HangerDone);
		if (oParseResult.msg	== ''){	// alles gut
			if (ToStorage){
				oParseResult.oProduct.toStorage("PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath, true);
				oParseResult.oProduct.oData.toStorage("PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath + ".oData", true);
				oParseResult.oProduct.oData.toStorage("PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath + ".LAGERDATA", true);
			}
			else{
				setstring("m_Ptyp",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath,	oParseResult.oProduct.m_Ptyp);
				setstring("m_Poberfl",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath,	oParseResult.oProduct.m_Poberfl);
				setstring("m_Ppreis",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + ItemNo + "]." + ItemPath,	oParseResult.oProduct.m_Ppreis);
			}
			oReturn.oProduct	= oParseResult.oProduct;
		}
		else{
			oReturn.msg	= oParseResult.msg;
		}
		return oReturn;
	},
	
	doSetPresetsAction : function(){
		var OriItems		= Object.fromStorage("PROJECT.POSITIONS");
		var QTYOriItems		= OriItems.PROJECTLIST_ITEMS.length;
		//var typManager = new CaTypsucheManager(tmpCaMainController);
		var SAP_RFC			= new SapRfcController();
		var oParseResult 	= null;
		for (var a = 0; a < QTYOriItems; a++){
			var bFailed	= false;
			// Hängerschellen
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Schelle) == 'object' && !bFailed){
				// Achtung "ZLN" / "ZLV" / "ZLB" sind für FL auch Schellen
				if (left(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Schelle.m_Ptyp, 3) == "ZLV")	//Nennweite für addDataToStore
					setstring("IDC_NENNWEITE_DN","DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL",
									OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Schelle.nennweite);
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Schelle.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.Schelle", 1);
				if (oParseResult.msg	== ''){
				// wir prüfen gleich noch ob eine Verbindungslasche ZVx existiert - gleicher Obfl-Schutz wie Schelle HZx in oParseResult.oProduct
					if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Lasche) == 'object'){
						var HZx	= oParseResult.oProduct.m_Ptyp;
						// Lasche braucht die Nennweite der Schelle für addDataToStore
						setstring("IDC_NENNWEITE_DN","DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", oParseResult.oProduct.nennweite);
						oParseResult	= null;
						var ZVx			= left(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Lasche.m_Ptyp,
										OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Lasche.m_Ptyp.length - 1) + right(HZx, 1);
						oParseResult	= ChangeSurface(false, a, ZVx, 0, "CA.SELECTION.TOPOCLASS.Lasche", 1);
						if (oParseResult.msg	!= ''){
							// Meldung ausgeben
							bFailed	= true;
						}
					}
				}
				else{
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			//Lager in LK
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.TopoLager2.Lager) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(true, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.TopoLager2.Lager.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.TopoLager2.Lager", 1);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			//Lager einzel
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Lager) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(true, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Lager.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.Lager", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			//Hänger einzel oder in LK
			if ((typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Haenger) == 'object' ||
					typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger) == 'object') && !bFailed){
				var Segment	= typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger) == 'object' ? ".SegmentStrang" : "";
				var HType	= getstring("m_Ptyp", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "].CA.SELECTION.TOPOCLASS" + Segment + ".Haenger");
				HType		= left(HType, HType.length - 5);
				var F_K		= left(HType, 1) + "H";
				// Blockierung
				var Block	= rfind(getstring(F_K + "_BLOCKIERUNG", "PROJECT.SETTINGS.CASCADE"), "NEIN") > -1 ? "0." : "1.";
				// Gewindeanschluss
				var Thread	= rfind(getstring("GEWINDE_ANSCHLUSS", "PROJECT.SETTINGS.CASCADE"), "DIN") > -1 ? "1." : "2.";
				// Oberfläche
				var Surface	= Oberflaechenschutz[getstring("OBFL_HAENGER", "PROJECT.SETTINGS.CASCADE")];
				// Hängertyp gem. Defaults
				HType			= HType + Block + Thread + Surface;
				oParseResult	= ChangeSurface(false, a, HType, 0, "CA.SELECTION.TOPOCLASS" + Segment + ".Haenger", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// Zubehör bei einzelnen Hängern - ZLN oder ZLK
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.HaengerZubehoer) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.HaengerZubehoer.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.HaengerZubehoer", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// Zwischenstück - ZZx
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Zwischenstueck) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Zwischenstueck.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.Zwischenstueck", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// Traverse
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Traverse) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.Traverse.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.Traverse", 1);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// oberer Bauanschluss
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.ObererAnschluss) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.ObererAnschluss.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.SegmentStrang.ObererAnschluss", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// oberes verbindendes Teil
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.OberesVerbindendesTeil1) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.OberesVerbindendesTeil1.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.SegmentStrang.OberesVerbindendesTeil1", 0);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// obere verbindende Teile
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.OVT) == 'object' && !bFailed){
				var AnzOVT		= OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.OVT.PART_ANZ * 1;
				for (var PartNo = 0; PartNo < AnzOVT; PartNo++){
					oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.OVT.PARTS[PartNo].PART.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.SegmentStrang.OVT.PARTS[" + PartNo + "].PART", 0);
					if (oParseResult.msg	!= ''){
						// Meldung ausgeben
						bFailed	= true;
						// Schleife abbrechen
						PartNo	= AnzOVT;
					}
				}
				oParseResult	= null;
			}
			// unteres verbindendes Teil
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.UnteresVerbindendesTeil1) == 'object' && !bFailed){
				oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.UnteresVerbindendesTeil1.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.SegmentStrang.UnteresVerbindendesTeil1", 1);
				if (oParseResult.msg	!= ''){
					// Meldung ausgeben
					bFailed	= true;
				}
				oParseResult	= null;
			}
			// untere verbindende Teile
			if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.UVT) == 'object' && !bFailed){
				var AnzUVT		= OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.UVT.PART_ANZ * 1;
				for (var PartNo = 0; PartNo < AnzUVT; PartNo++){
					oParseResult	= ChangeSurface(false, a, OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SegmentStrang.UVT.PARTS[PartNo].PART.m_Ptyp, 2, "CA.SELECTION.TOPOCLASS.SegmentStrang.UVT.PARTS[" + PartNo + "].PART", 0);
					if (oParseResult.msg	!= ''){
						// Meldung ausgeben
						bFailed	= true;
						// Schleife abbrechen
						PartNo	= AnzUVT;
					}
				}
				oParseResult	= null;
			}
			
			// prüfen ob alles geklappt hat
			if (bFailed){
				// Original rücksetzen
				OriItems.PROJECTLIST_ITEMS[a].toStorage("PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "]", false);
			}
		}
		// jetzt ist alles geändert
		// Daten checken
		var CheckPrice	= toupper(trimWhite(SAP_RFC.checkCompleteBasisdaten()).replace(" ", "")).replace("POSITION", "POS");
		var CheckMatNo	= toupper(trimWhite(SAP_RFC.checkCompleteAuftragsstueckliste()).replace(" ", ""));
		// für alle Positionen den Status setzen
		for (a = 0; a < QTYOriItems; a++){
			if (rfind(CheckPrice, "POS" + OriItems.PROJECTLIST_ITEMS[a].POS) > -1){
				setstring("STATUS_PREIS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "]", "ERROR");
				setstring("preisStatus", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "].CA.SELECTION.TOPOCLASS", "ERROR");
			}
			else{
				setstring("STATUS_PREIS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "]", "OK");
				setstring("preisStatus", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "].CA.SELECTION.TOPOCLASS", "OK");
			}
			if (rfind(CheckMatNo, "POS" + OriItems.PROJECTLIST_ITEMS[a].POS) > -1){
				setstring("STATUS_MATNR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "]", "ERROR");
				setstring("matStatus", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "].CA.SELECTION.TOPOCLASS", "ERROR");
			}
			else{
				setstring("STATUS_MATNR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "]", "OK");
				setstring("matStatus", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + a + "].CA.SELECTION.TOPOCLASS", "OK");
			}
		}
		return;
	},
	
	AnalyseSpecialParts : function(StahlbauInEinePos, ZukaufInEinePos){
		var OriItems				= Object.fromStorage("PROJECT.POSITIONS");	// muss angepasst werden, da das später als Kopiervorlage dient
		var QTYOriItems				= OriItems.PROJECTLIST_ITEMS.length;
		var StueLi_Pos_Stahlbau		= [];
		var StueLi_Pos_Sonderteile	= [];
		var NewPosStahlbau			= false;
		var PosStahlbauForCopy;
		var NewPosSonderteile		= false;
		var PosSonderteileForCopy;
		var STeileAnz				= 0;
		var StueLiOri				= "";
		var StueLiNew				= "";
		
		for (var a = 0; a < QTYOriItems; a++){	// aus OriItems löschen
			if (OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PART_ANZ*1 > 0 &&
					typeof(OriItems.PROJECTLIST_ITEMS[a].FP) != 'object'){
				
				STeileAnz	= (OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PART_ANZ * 1);
				OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PART_ANZ	= 0;
				
				for (var b = 0; b < OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS.length; b++){
					if ((OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS[b].PART.RHTyp == "Stahlbau") ||
						(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS[b].PART.RHTyp == "FP_ST"))
					{
						if (!NewPosStahlbau){
							NewPosStahlbau				= true;
							PosStahlbauForCopy			= a;
							var STAHLBAU_MARKIERUNG_ORI = [];
						}
						StueLi_Pos_Stahlbau.push(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS[b].PART);
						StueLi_Pos_Stahlbau[StueLi_Pos_Stahlbau.length-1].nAnzahl	= StueLi_Pos_Stahlbau[StueLi_Pos_Stahlbau.length-1].nAnzahl * StueLi_Pos_Stahlbau[StueLi_Pos_Stahlbau.length-1].m_qty;
						StueLi_Pos_Stahlbau[StueLi_Pos_Stahlbau.length-1].m_qty		= 1;
						STAHLBAU_MARKIERUNG_ORI.push(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR + " (" + StueLi_Pos_Stahlbau[StueLi_Pos_Stahlbau.length-1].nAnzahl +"x)");
					}
					else
					{
						if (!NewPosSonderteile){
							NewPosSonderteile				= true;
							PosSonderteileForCopy			= a;
							var SONDERTEIL_MARKIERUNG_ORI	= [];
						}
						StueLi_Pos_Sonderteile.push(OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS[b].PART);
						StueLi_Pos_Sonderteile[StueLi_Pos_Sonderteile.length-1].nAnzahl	= StueLi_Pos_Sonderteile[StueLi_Pos_Sonderteile.length-1].nAnzahl * StueLi_Pos_Sonderteile[StueLi_Pos_Sonderteile.length-1].m_qty;
						StueLi_Pos_Sonderteile[StueLi_Pos_Sonderteile.length-1].m_qty	= 1;
						SONDERTEIL_MARKIERUNG_ORI.push(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR + " (" + StueLi_Pos_Sonderteile[StueLi_Pos_Sonderteile.length-1].nAnzahl + "x)");
					}
				}
				
				if (typeof(OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_STUECKLISTE) == 'string'){
					StueLiOri	= OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_STUECKLISTE.split("},{");
					StueLiNew	= "";
					for (b = 0; b < StueLiOri.length - STeileAnz - 1; b++){
						StueLiNew	+= StueLiOri[b] + "},{";
					}
					StueLiNew	+= (StueLiNew != "" ? StueLiOri[StueLiOri.length-1] : "");
					OriItems.PROJECTLIST_ITEMS[a].CA.FORMS.UEBERSICHT_LASTKETTE.IDC_STUECKLISTE	= StueLiNew;
				}
				OriItems.PROJECTLIST_ITEMS[a].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS	= [];
			}
		}
		OriItems.toStorage('PROJECT.POSITIONS', false);
		
		// zunächst noch das Stahlbau- bzw. Sonderteilobjekt zusammenfassen
		// wenn wir das nicht tun, haben wir zu viele Positionen
		var StueLi_Pos_Sonderteile_ZSF	= [];
		StueLi_Pos_Sonderteile_ZSF.push(StueLi_Pos_Sonderteile[0]);
		var StueLi_Pos_Stahlbau_ZSF		= [];
		StueLi_Pos_Stahlbau_ZSF.push(StueLi_Pos_Stahlbau[0]);
		var SONDERTEIL_MARKIERUNG_ZSF	=[];
		SONDERTEIL_MARKIERUNG_ZSF.push(SONDERTEIL_MARKIERUNG_ORI[0]);
		var STAHLBAU_MARKIERUNG_ZSF	=[];
		STAHLBAU_MARKIERUNG_ZSF.push(STAHLBAU_MARKIERUNG_ORI[0]);
		// die Sonderteile
		for (a = 1; a < StueLi_Pos_Sonderteile.length; a++){
			var isSame	= false;
			b = 0;
			while (!isSame && b < StueLi_Pos_Sonderteile_ZSF.length){
				if ((StueLi_Pos_Sonderteile_ZSF[b].m_Ptyp == StueLi_Pos_Sonderteile[a].m_Ptyp) &&	// gleicher Text -> das ist nur die erste Zeile
					(StueLi_Pos_Sonderteile_ZSF[b].ARTTXT.ROW_ANZ*1 == StueLi_Pos_Sonderteile[a].ARTTXT.ROW_ANZ*1) &&	// Anzahl der Zeilen
					(StueLi_Pos_Sonderteile_ZSF[b].m_Ppreis == StueLi_Pos_Sonderteile[a].m_Ppreis) &&	// gleicher Preis
					(StueLi_Pos_Sonderteile_ZSF[b].m_WIMatnr == StueLi_Pos_Sonderteile[a].m_WIMatnr)){	// gleiche Mat.-Nr.
						isSame = true;
						// wir müssen noch den kompletten Text ab Zeile 2 vergleichen
						for (var c = 1; c < StueLi_Pos_Sonderteile_ZSF[b].ARTTXT.ROW_ANZ*1; c++){
							if (StueLi_Pos_Sonderteile_ZSF[b].ARTTXT.TEXTS.ROW[c].TEXT != StueLi_Pos_Sonderteile[a].ARTTXT.TEXTS.ROW[c].TEXT)
								isSame	= false;
						}
						if (!isSame)
							b++;
				}
				else
						b++;
			}
			if (isSame){
				StueLi_Pos_Sonderteile_ZSF[b].nAnzahl	= (StueLi_Pos_Sonderteile_ZSF[b].nAnzahl) + (StueLi_Pos_Sonderteile[a].nAnzahl * StueLi_Pos_Sonderteile[a].m_qty);
				SONDERTEIL_MARKIERUNG_ZSF[b]		+= ", " + SONDERTEIL_MARKIERUNG_ORI[a];
			}
			else{
				StueLi_Pos_Sonderteile_ZSF.push(StueLi_Pos_Sonderteile[a]);
				SONDERTEIL_MARKIERUNG_ZSF.push(SONDERTEIL_MARKIERUNG_ORI[a]);
			}
		}
		// der Stahlbau
		for (a = 1; a < StueLi_Pos_Stahlbau.length; a++){
			var isSame	= false;
			b = 0;
			while (!isSame && b < StueLi_Pos_Stahlbau_ZSF.length){
				if ((StueLi_Pos_Stahlbau_ZSF[b].m_Ptyp == StueLi_Pos_Stahlbau[a].m_Ptyp) &&	// gleicher Text -> das ist nur die erste Zeile
					(StueLi_Pos_Stahlbau_ZSF[b].ARTTXT.ROW_ANZ*1 == StueLi_Pos_Stahlbau[a].ARTTXT.ROW_ANZ*1) &&	// Anzahl der Zeilen
					(StueLi_Pos_Stahlbau_ZSF[b].m_Ppreis == StueLi_Pos_Stahlbau[a].m_Ppreis) &&	// gleicher Preis
					(StueLi_Pos_Stahlbau_ZSF[b].m_WIMatnr == StueLi_Pos_Stahlbau[a].m_WIMatnr)){	// gleiche Mat.-Nr.
						isSame = true;
						// wir müssen noch den kompletten Text ab Zeile 2 vergleichen
						for (var c = 1; c < StueLi_Pos_Stahlbau_ZSF[b].ARTTXT.ROW_ANZ*1; c++){
							if (StueLi_Pos_Stahlbau_ZSF[b].ARTTXT.TEXTS.ROW[c].TEXT != StueLi_Pos_Stahlbau[a].ARTTXT.TEXTS.ROW[c].TEXT)
								isSame	= false;
						}
						if (!isSame)
							b++;
				}
				else
						b++;
			}
			if (isSame){
				StueLi_Pos_Stahlbau_ZSF[b].nAnzahl	= (StueLi_Pos_Stahlbau_ZSF[b].nAnzahl) + (StueLi_Pos_Stahlbau[a].nAnzahl * StueLi_Pos_Stahlbau[a].m_qty);
				STAHLBAU_MARKIERUNG_ZSF[b]		+= ", " + STAHLBAU_MARKIERUNG_ORI[a];
			}
			else{
				StueLi_Pos_Stahlbau_ZSF.push(StueLi_Pos_Stahlbau[a]);
				STAHLBAU_MARKIERUNG_ZSF.push(STAHLBAU_MARKIERUNG_ORI[a]);
			}
		}
		
		if (NewPosStahlbau){
			// Position kopieren
			copy("PROJECT.POSITIONS.PROJECTLIST_ITEMS["+PosStahlbauForCopy+"]", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]");
			// alle Standardbauteile Löschen
			delete("CA", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]");
			//neue leere Position aufbauen
			CreateEmptyPosition(QTYOriItems);
			// setzen der Positionsnummer
			setstring("POS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", getint("POS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+(QTYOriItems-1)+"]") + 10);
			// setzen der Sonderteile
			setstring("PART_ANZ", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].CA.SELECTION.TOPOCLASS.SONDERTEILE", StueLi_Pos_Stahlbau_ZSF.length);
			for (a = 0; a < StueLi_Pos_Stahlbau_ZSF.length; a++){
				StueLi_Pos_Stahlbau_ZSF[a].toStorage("PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS["+a+"].PART");
			}
			// Markierung der LK auf "leer" setzen
			setstring("IDC_ANLAGEN_POS_NR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].CA.FORMS.UEBERSICHT_LASTKETTE", "");
			setstring("IDC_STUECKLISTE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].CA.FORMS.UEBERSICHT_LASTKETTE", "ZSF_Stahlbaupos");
			// Array der originalen Markierungen speichern
			STAHLBAU_MARKIERUNG_ZSF.toStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS['+QTYOriItems+'].STAHLBAU_MARKIERUNG_ORI.TEIL', false);
			// Items erhöhen
			QTYOriItems++;
		}
		
		if (NewPosSonderteile){
			var Text	= "";
			for (a = 0; a < StueLi_Pos_Sonderteile_ZSF.length; a++){
				// Position kopieren
				copy("PROJECT.POSITIONS.PROJECTLIST_ITEMS["+PosSonderteileForCopy+"]", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]");
				// alle Standardbauteile Löschen
				delete("CA", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]");
				
				// setzen der Positions-Infos
				// PosNr
				setstring("POS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", getint("POS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+(QTYOriItems-1)+"]") + 10);
				// ProductArea
				setstring("MODIFY_ENTRY_SCREEN", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", "IDD_FREIE_POSITION");
				setstring("PRODUCT_AREA", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", "FP");
				// MatNr
				setstring("IDENT", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].WIMatnr);
				// Texte
				Text = (SONDERTEIL_MARKIERUNG_ZSF[a] != "" ? SONDERTEIL_MARKIERUNG_ZSF[a] + "<br>" : "");
				Text += StueLi_Pos_Sonderteile_ZSF[a].ARTTXT.TEXTS.ROW[0].TEXT;
				setstring("ORDERCODE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", Text);
				setstring("ORDERCODE_PROJECTLIST", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", Text);
				for (var b = 1; b < StueLi_Pos_Sonderteile_ZSF[a].ARTTXT.ROW_ANZ; b++){
					Text += "<br>" + StueLi_Pos_Sonderteile_ZSF[a].ARTTXT.TEXTS.ROW[b].TEXT;
				}
				setstring("ORDERCODE_SHORT", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", Text);
				setstring("SHORTTEXT", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", Text);
				// Anzahl
				setstring("QTY", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].nAnzahl);
				// Preise
				setstring("ACT_UNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("DUNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("UNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("UNITPRICE_ALL_INCLUDED", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("POSPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("POSPRICEMINUSADDED", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"]", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				
				// setzen der FP-Infos
				setstring("FP_ASSI_GROUP",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "IDC_FP_NO_ASSI");
				setstring("FREI_NUMMER",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", StueLi_Pos_Sonderteile_ZSF[a].WIMatnr);
				setstring("FREI_PREIS",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("FREI_PREIS_EURO","PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", StueLi_Pos_Sonderteile_ZSF[a].m_Ppreis);
				setstring("FREI_TYP",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", StueLi_Pos_Sonderteile_ZSF[a].m_Ptyp);
				setstring("GEWICHT",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", StueLi_Pos_Sonderteile_ZSF[a].m_Pgewicht);
				setstring("IDC_OBFLSCHUTZ_COMBO",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "OB_ROH");
				setstring("IDC_OBFLSCHUTZ_EDIT",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "");
				setstring("IDC_ROHMASSPOS",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "");
				setstring("MARKIERUNG",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", SONDERTEIL_MARKIERUNG_ZSF[a]);
				setstring("RH_TYP",			"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "FP_ZU");
				setstring("ZEICHNUNGSNR",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+QTYOriItems+"].FP", "");
				// Items erhöhen
				QTYOriItems++;
			}
		}
		
		return;
	},
	
	CreateEmptyPosition : function(Position){
		setstring("id",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[0]", "systemcharakteristik");
		setstring("titel",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[0]", "");
		setstring("id",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[1]", "sollwerte_zubehoer_einzel");
		setstring("titel",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[1]", "");
		setstring("id",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[2]", "auswahl_zubehoer_einzel");
		setstring("titel",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[2]", "");
		setstring("id",		"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[3]", "uebersicht_lastkette");
		setstring("titel",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.HIST.HISTORY[3]", "");
		setstring("__CLASSNAME__",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.SELECTION.TOPOCLASS", "CaTopoEinzel");
		setstring("LAGER2DATAEXISTS",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.FORMS", "");
		setstring("IDC_LASTKETTE",	"PROJECT.POSITIONS.PROJECTLIST_ITEMS["+Position+"].CA.FORMS.SYSTEMCHARAKTERISTIK", "EINZEL_ZUBEHOER");
	},
	
	LoadMoveHaSu : function(VERTIKALDIR_UP, dbNameTable, PipeDir){
		if (abs(VERTIKALDIR_UP) == 1){	// X-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadVertikalUp"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadHorizontal1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadHorizontal2plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadVertikalDown"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal2minus"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveVertikalUp"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHorizontal1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHorizontal2plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveVertikalDown"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal2minus"), 2));
			PipeDir	= (PipeDir == "V" ? "1 0 0" : "0 1 0");
		}
		else if (abs(VERTIKALDIR_UP) == 2){	// Y-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadHorizontal2plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadVertikalUp"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadHorizontal1plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal2minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadVertikalDown"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal1minus"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveHorizontal2plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveVertikalUp"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHorizontal1plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal2minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveVertikalDown"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal1minus"), 2));
			PipeDir	= (PipeDir == "V" ? "0 1 0" : "0 0 1");
		}
		else{	// Z-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadHorizontal1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadHorizontal2plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "LoadVertikalUp"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadHorizontal2minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadVertikalDown"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveHorizontal1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHorizontal2plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveVertikalUp"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHorizontal2minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveVertikalDown"), 2));
							//(-1)*abs(fround(dbgetdouble(dbNameTable, "MD"), 2));
			//var test	= dbgetstring(dbNameTable, "MD");
			//var test	= dbgetdouble(dbNameTable, "MD");
			PipeDir	= (PipeDir == "V" ? "0 0 1" : "1 0 0");
		}
		
		return ({ForceAll : ForceAll, MoveAll : MoveAll, PipeDir : PipeDir});
	},
	
	LoadMovePiSh : function(VERTIKALDIR_UP, dbNameTable, PipeDir){
		if (toupper(PipeDir) == "H"){
			if (abs(VERTIKALDIR_UP) == 1){	// X-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2));
				PipeDir	= "0 1 0";
			}
			else if (abs(VERTIKALDIR_UP) == 2){	// Y-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2));
				PipeDir	= "1 0 0";
			}
			else{	// Z-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2));
				PipeDir	= "1 0 0";
			}
		}
		else{
			if (abs(VERTIKALDIR_UP) == 1){	// X-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2));
				PipeDir	= "1 0 0";
			}
			else if (abs(VERTIKALDIR_UP) == 2){	// Y-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2));
				PipeDir	= "0 1 0";
			}
			else{	// Z-Achse senkrecht
				var ForceAll	= fround(dbgetdouble(dbNameTable, "LoadLiftOff"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadLateralPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "LoadAxialPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadPress"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadLateralMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "LoadAxialMinus"), 2));
				var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveLiftOffDir"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveLateralPlus"), 2) + " " +
								fround(dbgetdouble(dbNameTable, "MoveAxialPlus"), 2) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MovePressDir"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveLateralMinus"), 2)) + " " +
								(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveAxialMinus"), 2));
				PipeDir	= "0 0 1";
			}
		}
		
		return ({ForceAll : ForceAll, MoveAll : MoveAll, PipeDir : PipeDir});
	},
	
	LoadMoveDyna : function(VERTIKALDIR_UP, dbNameTable, PipeDir){
		if (abs(VERTIKALDIR_UP) == 1){	// X-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hplus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hminus"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveSuppDir_plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHori1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHori2plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveSuppDir_minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori2minus"), 2));
			PipeDir	= (PipeDir == "V" ? "1 0 0" : "0 1 0");
		}
		else if (abs(VERTIKALDIR_UP) == 2){	// Y-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hplus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hminus"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveHori1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveSuppDir_plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHori2plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveSuppDir_minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori2minus"), 2));
			PipeDir	= (PipeDir == "V" ? "0 1 0" : "1 0 0");
		}
		else{	// Z-Achse senkrecht
			var ForceAll	= fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hplus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hplus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori1_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadHori2_Hminus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hminus"), 2));
			var MoveAll		= fround(dbgetdouble(dbNameTable, "MoveHori1plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveHori2plus"), 2) + " " +
							fround(dbgetdouble(dbNameTable, "MoveSuppDir_plus"), 2) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori1minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveHori2minus"), 2)) + " " +
							(-1)*abs(fround(dbgetdouble(dbNameTable, "MoveSuppDir_minus"), 2));
			var DynForce	= max(abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hplus"), 2)), abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_Hminus"), 2)))
							+ " " +
							max(abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_HZplus"), 2)), abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_HZminus"), 2)))
							+ " " +
							max(abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_HSplus"), 2)), abs(fround(dbgetdouble(dbNameTable, "DynLoadSuppDir_HSminus"), 2)));
			PipeDir	= (PipeDir == "V" ? "0 0 1" : "1 0 0");
		}
		
		return ({ForceAll : ForceAll, MoveAll : MoveAll, PipeDir : PipeDir, DynForce : DynForce});
	},
	
	ImportExcel : function(strXLSXPath, strXLSXFile){
		var i	= 0;
		var FINPath	= strXLSXPath + "FIN";
		if (!FileName.dirExists(FINPath))
			FileName.createDir(FINPath);
		if (FileName.dirExists(FINPath)){	// Schreibrechte vorhanden
			FINPath	+= "\\FIN_from_EXCEL_" + getstring("DATE", "").replace(".", "") + "_" + getstring("TIME", "").replace(":", "");
			FileName.createDir(FINPath);
		}
		else{
			FINPath = dirdialog(translate("Select folder for importfiles created from EXCEL"), strMDBPath);
			if (FINPath != ""){
				FINPath	+= "\\FIN_from_EXCEL_" + getstring("DATE", "").replace(".", "") + "_" + getstring("TIME", "").replace(":", "");
				FileName.createDir(FINPath);
			}
			else
				i	= -1;
			if (!FileName.dirExists(FINPath))
				i	= -2;
		}
		//if (FINPath != ""){
		if (i == 0){
			// Projektbezogene Infos
			// Achsrichtung
			var sqlstring 	= "SELECT * FROM [GLOBAL_SETTINGS$] WHERE ImportRelevance='true' OR ImportRelevance='True' OR ImportRelevance='TRUE'";
			var dbName		= 'EXCEL';
			var dbNameTable = "VertiAchs";
			var numRet		= dbselect( dbName, sqlstring, dbNameTable );
			if ( numRet > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					var VERTIKALDIR_UP	= 2;	// default "Y" positiv nach oben
					var VertiAchs		= toupper(dbgetstring(dbNameTable,"VertikalAxis"));
					var VertiAchsDir	= toupper(dbgetstring(dbNameTable,"PositiveDirection"));
					if (VertiAchs != "Y")
						VERTIKALDIR_UP	= (VertiAchs == "X" ? 1 : 3);
					VERTIKALDIR_UP		= (VertiAchsDir == "DOWN" ? (-1)*VERTIKALDIR_UP : VERTIKALDIR_UP);
					dbskip( dbNameTable );
				}
			}
			
			//Positionsbezogene Infos Lastketten
			for (var Types=0; Types<3; Types++){
				var Section		= "HANGER_SUPPORT";
				if (Types == 1)
					Section		= "PIPE_SHOE";
				else if (Types == 2)
					Section		= "DYNAMIC_PART";
				var sqlstring 	= "SELECT * FROM [" + Section + "$] WHERE ImportRelevance='true' OR ImportRelevance='True' OR ImportRelevance='TRUE'";
				var dbName		= 'EXCEL';
				var dbNameTable = Section;
					numRet		= dbselect( dbName, sqlstring, dbNameTable );
				if ( numRet > 0 ){
					while ( dbiseof( dbNameTable) == 0 ){
						// falsch zusortierte Typen auslassen
						var RH_Typ	= toupper(dbgetstring(dbNameTable, "Type"));
						if (((toupper(left(RH_Typ, 1)) == "P" || toupper(left(RH_Typ, 2)) == "SB" || toupper(left(RH_Typ, 2)) == "RS") && Section == "HANGER_SUPPORT") ||
								(toupper(left(RH_Typ, 1)) != "P" && Section == "PIPE_SHOE") ||
								(toupper(RH_Typ) != "RS" && toupper(RH_Typ) != "SB" && Section == "DYNAMIC_PART")){
							dbskip( dbNameTable );
							continue;
						}
						// unser leeres Standard-FIN-File
						var FIN	= readfile(getstddirectory("PROGRAM") + "empty.fin");
						// für die zusätzlichen Infos brauchen wir noch einen Block
						FIN	+= (right(FIN, 2) == "\r\n" ? "" : "\r\n") + "BEGIN ADD_INFO-DATA\r\n RFQ_POS \r\n REMARK \r\n WIHANGTYPE \r\nEND ADD_INFO-DATA\r\n";
						// global
						FIN	= FIN.replace("VERTIKALDIR_UP ", "VERTIKALDIR_UP " + VERTIKALDIR_UP);
						FIN	= FIN.replace("QUELLE ", "QUELLE 7");
						// direkte Zuordnung
						FIN	= FIN.replace("QTY ", "QTY " + fround(dbgetdouble(dbNameTable, "Qty"), 0));
						FIN	= FIN.replace("DIA ", "DIA " + fround(dbgetdouble(dbNameTable, "NomDiameter"), 0));
						FIN	= FIN.replace("POD ", "POD " + fround(dbgetdouble(dbNameTable, "OuterDiameter"), 0));
						FIN	= FIN.replace("INSULAT ", "INSULAT " + fround(dbgetdouble(dbNameTable, "Insulation"), 0));
						FIN	= FIN.replace("MEDTEMP ", "MEDTEMP " + fround(dbgetdouble(dbNameTable, "MedTemp"), 0));
						var Markierung	= trimright(trimleft(dbgetstring(dbNameTable, "TagNo"), " "), " ");	// wird unten für Name gebraucht
						FIN	= FIN.replace("NAME ", "NAME " + Markierung);
						FIN	= FIN.replace("DRAWING ", "DRAWING " + dbgetstring(dbNameTable, "DrawNo"));
						// gibt es nur bei den Hängern/Stützen
						var LTransf			= "H";
						if (Section == "HANGER_SUPPORT"){
							var LoadType	= trimright(trimleft(dbgetstring(dbNameTable, "LoadType"), " "), " ");
							LoadType		= (LoadType == "" ? "C" : LoadType);
							FIN		= FIN.replace("LOAD-TYPE ", "LOAD-TYPE " + LoadType);
							FIN		= FIN.replace("FH_TYP ", "FH_TYP " + (trimright(trimleft(dbgetstring(dbNameTable, "WIHangSize")," "), " ") == "" ? "OTHER" : dbgetstring(dbNameTable, "WIHangSize") + " WITZENMANN"));
							FIN		= FIN.replace("SPRINGRATE_G ", "SPRINGRATE_G " + (fround(dbgetdouble(dbNameTable, "SpanWidth"), 0) > 0 ? 2 : 1) * fround(dbgetdouble(dbNameTable, "SpringRate"), 2));
							FIN		= FIN.replace("WIHANGTYPE ", "WIHANGTYPE " + dbgetstring(dbNameTable, "WIHangType"));
							LTransf	= toupper(dbgetstring(dbNameTable, "LoadTransfer"));
						}
						var PipeCenter	= fround(dbgetdouble(dbNameTable, "ElevPipeCenter"), 0);
						FIN	= FIN.replace("PIPECENTER" + VertiAchs + " ", "PIPECENTER" + VertiAchs + " " + PipeCenter);
						// zusätzliche Infos
						FIN	= FIN.replace("RFQ_POS ", "RFQ_POS " + dbgetstring(dbNameTable, "RFQPos"));
						FIN	= FIN.replace("REMARK ", "REMARK " + dbgetstring(dbNameTable, "Remark"));
						// Bauanschluss
						
						var ElDistance		= fround(dbgetdouble(dbNameTable, "ElevDistance"), 0);
						if (Section != "PIPE_SHOE"){
							var ElMaxDistance	= ElDistance;
							var ElSteelConnect1	= dbgetstring(dbNameTable, "ElevSteelConnect1");
							var ElSteelConnect2	= dbgetstring(dbNameTable, "ElevSteelConnect2");
							if (ElSteelConnect1 != "" || ElSteelConnect2 != ""){
								ElSteelConnect1	= fround(ElSteelConnect1 * 1, 0);
								ElSteelConnect2	= fround(ElSteelConnect2 * 1, 0);
								ElMaxDistance	= max(abs(abs(PipeCenter) - max(abs(ElSteelConnect1), abs(ElSteelConnect2))), abs(ElDistance));
							}
							var Distance		= fround(dbgetdouble(dbNameTable, "SpanWidth"), 0);
							FIN	= FIN.replace("DISTANCE ", "DISTANCE " + Distance);
						}
						else{
							var ElSteelConnect	= fround(dbgetdouble(dbNameTable, "ElevSteelConnect"), 0);
							var ElMaxDistance	= max(abs(abs(PipeCenter) - abs(ElSteelConnect)), abs(ElDistance));
							var Distance		= 0;
						}
						FIN	= FIN.replace("Ba1" + VertiAchs + " ", "Ba1" + VertiAchs + " " + (PipeCenter + (LTransf == "H" ? 1 : (-1)) * ElMaxDistance));
						if (Distance > 0)
							FIN	= FIN.replace("Ba2" + VertiAchs + " ", "Ba2" + VertiAchs + " " + (PipeCenter + (LTransf == "H" ? 1 : (-1)) * ElMaxDistance));
						// Kräfte / Bewegungen
						var PipeDir	= toupper(dbgetstring(dbNameTable, "PipeDir"));
						if (Section == "HANGER_SUPPORT")
							var LoadMove	= LoadMoveHaSu(VERTIKALDIR_UP, dbNameTable, PipeDir);
						else if (Section == "PIPE_SHOE")
							var LoadMove	= LoadMovePiSh(VERTIKALDIR_UP, dbNameTable, PipeDir);
						else{
							var LoadMove	= LoadMoveDyna(VERTIKALDIR_UP, dbNameTable, PipeDir);
							FIN	= FIN.replace("DYNFORCE ", "DYNFORCE " + LoadMove.DynForce);
						}
						FIN	= FIN.replace("PIPEORIENT ", "PIPEORIENT " + LoadMove.PipeDir);
						FIN	= FIN.replace("FORCE_NORMAL ", "FORCE_NORMAL " + LoadMove.ForceAll);
						FIN	= FIN.replace("MOV_NORMAL ", "MOV_NORMAL " + LoadMove.MoveAll);
						FIN	= FIN.replace("Z_TEST_LOAD ", "Z_TEST_LOAD " + fround(dbgetdouble(dbNameTable, "HydroTestLoad"), 1));
						// RH-Typ
						if (left(RH_Typ, 1) == "P"){	// Lager
							switch (RH_Typ){
								case "PSG" :
									RH_Typ	= "FL";
									break;
								case "PSF" :
									RH_Typ	= "FP";
									break;
								case "PS2" :
								case "PS3" :
								case "PS4" :
									RH_Typ	= right(RH_Typ, 1) + "W";
									break;
								case "PS6" :
									RH_Typ	= "2W_90";
									break;
								default		:
									RH_Typ	= "GL";
									break;
							}
						}
						else{	// LK
							switch (RH_Typ){
								case "AS" :
								case "AC" :
									RH_Typ	= "FGS" + "_" + LTransf;
									break;
								case "CS" :
									RH_Typ	= (LTransf == "H" ? "KH" : "KS");
									break;
								case "RH" :
									RH_Typ	= "SH";
									break;
								case "RS" :
									RH_Typ	= "GS";
									break;
								case "SB" :
									RH_Typ	= "DB";
									break;
								case "SC" :
									RH_Typ	= "AC";
									break;
								default   :
									RH_Typ	= (LTransf == "H" ? "FH" : "FS");
									break;
							}
						}
						FIN	= FIN.replace("RH_TYP ", "RH_TYP " + RH_Typ);
						i	+=1;
						Markierung	= Markierung.replace("\n", "_");
						Markierung	= replaceSpecialChars(Markierung, {FuerCSV : 0, FuerDateiname : 1});
						writefile(FINPath + "\\" + (i < 100 ? "0" : "") + (i < 10 ? "0" : "") + i*10 + (Markierung != "" ? "_" + Markierung : "") + ".fin", FIN, "wc");
						dbskip( dbNameTable );
					}
				}
			}
		}
		var Information	= i + " files ready for import";
		var bOK			= true;
		if (i == 0){
			Information	= "No import information could be created from Excel.";
			bOK			= false;
		}
		else if (i == (-1)){
			Information	= "Path selection aborted by user.";
			bOK			= false;
		}
		else if (i == (-2)){
			Information	= "Selected path not possible.";
			bOK			= false;
		}
		
		if (bOK)
			setstring("IMPORT_STK_VERZEICHNIS", "", FINPath + "\\");
		
		return ( {message : Information, success : bOK} );
	}
};

// Hier ist es eigentlich nett, ein Objekt des Controllers 
// gleich zu erzeugen, das dann jeder benutzen kann
// Achtung: darf erst nach den Definitionen der ganzen Topologiexperten erfolgen,
// da diese im Konstruktor des Controllers erzeugt werden!

// --gl-- Diesen Aufruf habe ich in preDispatch verlegt,
// Da die exe zu diesem Zeitpunkt in der ersten jemals angelegten Session rumhängt


//caMainController = new CaController();

// mit dieser Zeile in einem Skript kannst Du Dir den von EasyScript unterstützten Funktionsumfang
// ausgeben lassen.
// writefile("version.txt" , easyscriptversion(true) , "");


