/**
 * CascadeLagerkonfiguration.es: modul mit Utilityfunktionen fr die Konfiguration eines Lagers
 * Alle Utilityfunktionen liegen in einem Namespace 'Cascade.Lagerkonfiguration'
 *
 **/

// Namespace erzeugen
if ( typeof( Cascade ) == "undefined" )
	Cascade = {};	
if ( !Cascade.Lagerkonfiguration )
	Cascade.Lagerkonfiguration = {};
	

/**
 * hole alle gltigen Profilarten fr eine Lagerart
 *
 * @params string strLagerart - aktuelle Lagerart
 * @returns	object - daten: Array von Arrays mit je zwei Werten (Value und Text) fr jede Profilart
 *                   strProfilart: Defaultwert fr aktuelle Profilart
 */
Cascade.Lagerkonfiguration.holeProfilarten = function( strLagerart )
{
	// suche profilarten
	var aDaten = new Array();
	var strProfil = "";
	var strID = "";
		
	// baue select-statement
	var strSelect = "SELECT * FROM PROFILART";

	// hole Werte aus Tabelle
	var strDBCache = "RH_PROFIL";
	var bProfilBenutzen = true;
	if ( dbselect( "LAGER", strSelect, strDBCache ) )
	{
		while ( !dbiseof( strDBCache ) )
		{
			strID = dbgetstring( strDBCache, "ID" );
			// fr Festlager gibt es bestimmte Profile nicht
			bProfilBenutzen = true;
			if ( ( strLagerart == "ID_FESTLAGER" ) &&
			     ( ( strID == "U_PROFIL" ) || ( strID == "L_PROFIL_G" ) || ( strID == "L_PROFIL_U" ) ) )
				bProfilBenutzen = false;
				
			// Profilart und ID einfgen
			if ( bProfilBenutzen )
			{
				if ( strProfil == "" )
					strProfil = strID;			
				aDaten.push( [ strID, dbgetstring( strDBCache, "PROFILART" ) ] );
			}
			
			// nchster Record
			dbskip( strDBCache );
		}
	}
	
	// Rckgabe der gefundenen Werte
	return( 
	{ 
		daten: aDaten, 
		strProfilart: strProfil 
	} );
}


/**
 * hole aktuelle Profilart von ihrer Datenbankid
 *
 * @params string strID - ID der aktuellen Profilart
 * @returns	string strProfilart
 */
Cascade.Lagerkonfiguration.holeProfilart = function( strID )
{
	// suche profilarten
	var strProfil = "";
		
	// baue select-statement
	var strSelect = "SELECT PROFILART FROM PROFILART WHERE ID = '" + strID + "' ";

	// hole Werte aus Tabelle
	var strDBCache = "RH_PROFIL";
	if ( dbselect( "LAGER", strSelect, strDBCache ) )
	{
		// es sollte nur einen resultierenden Record geben; ist die Tabelle fehlerhaft und es gibt mehr, nehmen wir hier einfach den ersten
		strProfil = dbgetstring( strDBCache, "PROFILART" );
	}
	
	// Rckgabe der gefundenen Werte
	return( strProfil );
}


/**
 * hole gltige Trgergren fr eine Profilart
 *
 * @params string strProfilart - aktuelle Profilart
 * @returns	object - daten: Array von Arrays mit je zwei Werten (Value und Text) fr jede Trgergre
 *                   strTraegergroesse: Defaultwert fr aktuelle Trgergre
 */
Cascade.Lagerkonfiguration.holeTraegergroessen = function( strProfilart )
{
	var aDaten = new Array();
	var strTraeger = "";
	
	// baue select-statement
	var strSelect = "SELECT TRAE_GR FROM " + strProfilart;

	// hole Werte aus Tabelle
	var strDBCache = "RH_TRAEGER";
	if ( dbselect( "LAGER", strSelect, strDBCache ) )
	{
		var strDBTraeger = "";
		
		while ( !dbiseof( strDBCache ) )
		{
			// Profilart und ID einfgen
			strDBTraeger = dbgetstring( strDBCache, "TRAE_GR" );
			if ( strTraeger == "" )
				strTraeger = strDBTraeger;
			aDaten.push( [ strDBTraeger, strDBTraeger ] );

			// nchster Record
			dbskip( strDBCache );
		}
	}
	
	// Rckgabe der gefundenen Werte
	return( 
	{ 
		daten: aDaten, 
		strTraegergroesse: strTraeger 
	} );
}


/**
 * hole Trgerhhe, - breite, Flanschdicke, korrigierten Typenschlssel und Bildname fr eine Trgergre
 *
 * @params string strProfilart - aktuelle Profilart
 *         string strTraegergroesse - aktuelle Traegergroesse
 *         object Lager - aktuelles Lager
 * @returns	object - strTraegerhoehe - Trgerhhe
 *                   strTraegerbreite - Trgerbreite
 *                   strFlanschdicke - Flanschdicke
 *                   strTyp - korrigierter Typenschlssel des aktuellen Lagers
 *                   strBild - Filename des Bildes fr das konfigurierte Lager
 *                   strVarKlemm - Klemmsystemvariante
 */
Cascade.Lagerkonfiguration.holeTraegerdaten = function( strProfilart, strTraegergroesse, Lager )
{
	// bestimme zuerst Trgerhhe, -breite und Flaschdicke aus den Daten der Trgergre
	var strHoehe = "";
	var strBreite = "";
	var strDicke = "";
	var strVarKlemm = "T140";
	
	// baue select-statement
	var strSelect = "SELECT * FROM " + strProfilart + " WHERE TRAE_GR = '" + strTraegergroesse + "' ";
	// hole Werte aus Tabelle
	var strDBCache = "RH_TRAEGER";
	if ( dbselect( "LAGER", strSelect, strDBCache ) )
	{
		// es sollte nur einen resultierenden Record geben; ist die Tabelle fehlerhaft und es gibt mehr, nehmen wir hier einfach den ersten
		strHoehe = dbgetstring( strDBCache, "H" );
		strBreite = dbgetstring( strDBCache, "B" );
		strDicke = dbgetstring( strDBCache, "tg" );
		strVarKlemm = dbgetstring( strDBCache, "VAR_KLEMM" );	// wird fr Korrektur des Typenschlssels und Berechnung des Bildnamens gebraucht
	}
	
	var strLagertyp = "";
	var strFile = "blank.png";
	
	if ( Lager )
	{
		// bestimme nun den korrigierten Typenschlssel
		var strBasisTyp = Lager.strBasistyp + "1";
		if ( ( substr( strBasisTyp, 1, 3 ) == "LUR" ) || ( substr( strBasisTyp, 1, 3 ) == "FLV" ) || ( substr( strBasisTyp, 1, 2 ) == "IK" ) )
			strBasisTyp = substr( strBasisTyp, 1, 16 );
		else strBasisTyp = substr( strBasisTyp, 1, 15 );
		
		// bei Profilart HEB, HEA, IPE, INP und T_PROFIL ist VAR_KLEMM des ersten Eintrags immer T140. Anstatt nun abzufragen, ob 
		// die gewhlte Trgergre die erste in der Liste ist, kann man in diesem Zusammenhang auch abfragen, ob bei den Profilformen strVarKlemm == T140 ist
		if ( ( Lager.strWerkstoffOberfl == "37.2" ) &&
			 ( ( strProfilart == "HEB" ) || ( strProfilart == "HEA" ) || ( strProfilart == "IPE" ) || ( strProfilart == "INP" ) || ( strProfilart == "T_PROFIL" ) ) &&
			 ( strVarKlemm == "T140" ) )
			strLagertyp = strBasisTyp;  															// Standard
		else if ( ( Lager.strWerkstoffOberfl != "37.2" ) &&
				 ( ( strProfilart == "HEB" ) || ( strProfilart == "HEA" ) || ( strProfilart == "IPE" ) || ( strProfilart == "INP" ) || ( strProfilart == "T_PROFIL" ) ) &&
				 ( strVarKlemm == "T140" ) )
			strLagertyp = strBasisTyp + "-" + Lager.strWerkstoffOberfl;  							// Variante Werkstoff/Oberflche
		else if ( ( strVarKlemm != "T140" ) ||
				  ( strProfilart == "U_PROFIL" ) || ( strProfilart == "L_PROFIL_G" ) || ( strProfilart == "L_PROFIL_U" ) )
		{
			if ( Lager.strWerkstoffOberfl == "37.2" )
		  		strLagertyp = strBasisTyp + "-" + strVarKlemm;								  		// Variante Klemmtrger
			else strLagertyp = strBasisTyp + "-" + strVarKlemm + "." + Lager.strWerkstoffOberfl;  	// Variante Klemmtrger + Werkstoff/Oberflche
		}
		else strLagertyp = strBasisTyp + "-" + strVarKlemm + "." + Lager.strWerkstoffOberfl;		// wenn alles fehlschlgt: Variante Klemmtrger + Werkstoff/Oberflche

		if ( ( substr( strBasisTyp, 1, 3 ) == "FSN" ) || ( substr( strBasisTyp, 1, 3 ) == "FSD" ) )
		{
			if ( Lager.strWerkstoffOberfl == "37.2" )
				strLagertyp = strBasisTyp;															// Standard
			else strLagertyp = strBasisTyp + "-" + Lager.strWerkstoffOberfl;
		}
		else if ( substr( strBasisTyp, 1, 3 ) == "LUR" )
		{
			// andere Typenschlsselsystematik fr alte Loslager
			strLagertyp = strBasisTyp + "-" + Lager.strWerkstoffOberfl;
		}
		
		// bestimme nun den Filenamen des anzuzeigenden Bildes
		/*if ( ( strVarKlemm == "T140" ) && 
		     ( ( Lager.strProfilart == "HEB" ) || ( Lager.strProfilart == "HEA" ) || ( Lager.strProfilart == "IPE" ) || ( Lager.strProfilart == "INP" ) || ( Lager.strProfilart == "T_PROFIL" ) ) &&
		     ( ( strProfilart == "HEB" ) || ( strProfilart == "HEA" ) || ( strProfilart == "IPE" ) || ( strProfilart == "INP" ) || ( strProfilart == "T_PROFIL" ) ) )
		{*/
			//strFile = Lager.strBauform;		// standard - wir knnen das Standardbild aus den Lagerdaten nehmen
			var tempstrFile			= getstring("BILD", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager");
			var tempstrFileright	= right(tempstrFile, 1);
			if ((left(strVarKlemm, 1) == "T") && (tempstrFileright == "T" || tempstrFileright == "U" || tempstrFileright == "L"))
				strFile = left(tempstrFile, (tempstrFile.length - 2));
			else if ((left(strVarKlemm, 1) == "T") && (tempstrFileright != "T" || tempstrFileright != "U" || tempstrFileright != "L"))
				strFile = tempstrFile;
			else if ((left(strVarKlemm, 1) != "T") && (tempstrFileright == "T" || tempstrFileright == "U" || tempstrFileright == "L"))
				strFile = left(tempstrFile, (tempstrFile.length - 2)) + '_' + strProfilform;
			else
				strFile = tempstrFile + '_' + left(strVarKlemm, 1);
			setstring ("BILD", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager", strFile);
		/*}
		else
		{
			var strProfilform = "T";
			if ( strProfilart == "U_PROFIL" )
				strProfilform = "U";
			else if ( ( strProfilart == "L_PROFIL_G" ) || ( strProfilart == "L_PROFIL_U" ) )
				strProfilform = "L";
			
			// Bild in der Datentabelle fr die Lagerbaureihe suchen
			strSelect = "SELECT BAUFO FROM " + Lager.strBaureihe + " WHERE TYP like '" + left(Lager.strBasistyp,15) + 
		                "%' AND ( PROFILFORM = '" + strProfilform + "' OR PROFILFORM = '' ) AND WERK_ = '" + Lager.strWerk + "' ";
			strDBCache = "RH_BILD";
			if ( dbselect( "LAGER", strSelect, strDBCache ) )
			{
				//strFile = dbgetstring( strDBCache, "BAUFO" );
				if (left(strProfilform, 1) == "T")
					strFile = Lager.strBild;
				else
					strFile = Lager.strBild + '_' + strProfilform;
				setstring ("BILD", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager", strFile);
			}
			else
				//strFile = Lager.strBauform;		// besser das Standardbild als ein leeres!?			
				strFile = Lager.strBild;
		}*/
		strFile += '.jpg';
	}
	
	// Rckgabe der gefundenen Werte
	return( 
	{
		strTraegerhoehe: strHoehe,
		strTraegerbreite: strBreite,
		strFlanschdicke: strDicke,
		strTyp: strLagertyp,
		strBild: strFile,
		strVarKlemm: strVarKlemm
	} );
}

/**
 * berechne die Profilform und die Traegerbreite fuer Datenbankabfragen
 *
 * @params object Lager - Lager, fr das die Werte berechnet werden sollen
 * @returns	object strProfilform - Profilform
 *                 strTaegerbreite - Traegerbreite
 */
Cascade.Lagerkonfiguration.holeProfilformUndTraegerbreiteFuerDB = function( Lager )
{
	var strForm = 'T';
	if ( Lager.strProfilart == "U_PROFIL" )
		strForm = "U";
	else if ( ( Lager.strProfilart == "L_PROFIL_G" ) || ( Lager.strProfilart == "L_PROFIL_U" ) )
		strForm = "L";
	var strTraeger = '';
	// die Trgerbreiten der ersten Trgergren sind bei allen T-Profilen <= 140. Die erste Trgergre ist bei allen T-Profilen der Defaultwert ohne Aufpreis
	if ( ( strForm == 'T' ) && ( Lager.strDBTraegerbreite != '' ) && ( Lager.strTraegerbreite <= 140 ) )
		strTraeger = '140';
	if ( !Lager.isConfigurable() )
	{
        // -mw- ein Versuch ists wert: Form T fhrt bei nicht-konfigurierbaren Lagern
        // zu Problemen bei der Materialnummernsuche ...
        strForm = '';
        strTraeger = '';
    }
		
	// Rckgabe der gefundenen Werte
	return( 
	{
		strProfilform : strForm,
		strTraegerbreite: strTraeger
	} );
}			
			
/**
 * berechne den Preis fr ein Lager
 *
 * @params object Lager - Lager, fr das der Preis berechnet werden soll
 * @returns	string der Preis des Lagers
 */
Cascade.Lagerkonfiguration.holePreis = function( Lager )
{
	var strPreis = '';
	var oProfil = Cascade.Lagerkonfiguration.holeProfilformUndTraegerbreiteFuerDB( Lager );
	
	// baue select-statement
	var strSelect = '';
	if ( left( Lager.strTyp, 3 ) == 'LUR' )
	{
		// speziell fr LUR: der Oberflchentyp und der Werkstoff sind in der Typbezeichnung immer mit eincodiert; die aktuelle Typ ist immer 
		// identisch zu der Typbezeichnung in der Lagertabelle; Profilform und Trgerbreite spielen fr LUR-Lager keine Rolle
		strSelect = "SELECT PREIS FROM " + Lager.strBaureihe + " WHERE TYP = '" + Lager.strTyp + "' ";
	}
	else
	{
		// default fr Lager
		var strTyp = Lager.strBasistyp;
		var nPos = find( strTyp, '-' );
		// bei den neuen Lagertypen werden hinter dem ersten '-' als Trennzeichen noch Profilform, Trgerbreite, Werkstoff und Oberflchenschutz codiert; alles
		// Werte, die in durch Filter auf andere Spalten im Select bercksichtigt werden.
		// eine Nichtstandard-Trgerbreite wird bei den Lagertypen allerdings mit XXX oder YYxYY angegeben, nicht mit dem gltigen Wert
		if ( nPos > -1 )
			strTyp = left( strTyp, nPos -1 );
			
		strSelect = "SELECT PREIS FROM " + Lager.strBaureihe + " WHERE TYP like '" + strTyp + 
					"%' AND ( PROFILFORM = '" + oProfil.strProfilform + "' OR PROFILFORM = '' ) AND TRAEGERBREITE = '" + oProfil.strTraegerbreite + 
					"' AND WERK_ = '" + Lager.strWerk + "' AND OBFL = '" + Oberflaechenschutz[ Lager.m_Poberfl ] + "' ";
	}

	var strDBCache = "RH_PREIS";
	if ( dbselect( "LAGER", strSelect, strDBCache ) )
		strPreis = ( dbgetstring( strDBCache, "PREIS" ) - 0 ).toFixed( 2 );
		
	return( strPreis );
}
