/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Data 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
/**
 * @constructor
 */
CascadeLagerDataAccess = function( strVersion )
{
	/**
     * Programmversion ... falls sich Speicherstrukturen im Store ndern
     * @var _versionString
     */
	this._versionString = strVersion;	
    this._storeBasePath = "DLGDATA.CA.FORMS";
};


CascadeLagerDataAccess.prototype = 
{
	/**
     * hole die Daten des Dialoges 'Betriebsbedingungen'
	 *
	 * @params -
	 * @returns	object: temperatur - Betriebstemperatur
	 *                  daemmdicke - Dmmdicke
	 *					wx - Verschiebung in x-richtung
	 *					wy - Verschiebung in y-richtung
	 *					m_fz - Kraft in -z-richtung
	 *					fz - Kraft in z-richtung
	 *					m_fx - Kraft in -x-richtung
	 *					fx - Kraft in x-richtung
	 *					fy - Kraft in y-richtung
	 */
	holeBetriebsbedingungen : function()
	{
		// get data from store
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_BETRIEBSBEDINGUNGEN" );
		var	retObj = 
		{ 
			// wenn irgendein Wert im Store ungltig oder leer ist, wurden noch keine Werte des UI zum Server submitted. In diesem Fall
			// wird ein hardkodierter Defaultwert zurckgegeben
			temperatur: ( !data.IDC_TEMPERATUR_TS ? "20" : data.IDC_TEMPERATUR_TS ),
			daemmdicke: ( !data.IDC_DAEMMDICKE ? "0" : data.IDC_DAEMMDICKE ),
			wx: ( !data.IDC_WX_PLUS ? "0" : data.IDC_WX_PLUS ),
			wy: ( !data.IDC_WY_PLUS ? "0" : data.IDC_WY_PLUS ),
			wz: ( !data.IDC_WZ_PLUS ? "0" : data.IDC_WZ_PLUS ),
			m_wx: ( !data.IDC_WX_MINUS ? "0" : data.IDC_WX_MINUS ),
			m_wy: ( !data.IDC_WY_MINUS ? "0" : data.IDC_WY_MINUS ),
			m_wz: ( !data.IDC_WZ_MINUS ? "0" : data.IDC_WZ_MINUS ),
			m_fz: ( !data.IDC_MINUS_FZ ? "0" : data.IDC_MINUS_FZ ),
			fz: ( !data.IDC_FZ ? "0" : data.IDC_FZ ),
			m_fx: ( !data.IDC_MINUS_FX ? "0" : data.IDC_MINUS_FX ),
			fx: ( !data.IDC_FX ? "0" : data.IDC_FX ),
			m_fy: ( !data.IDC_MINUS_FY ? "0" : data.IDC_MINUS_FY ),
			fy: ( !data.IDC_FY ? "0" : data.IDC_FY ),
			rmx: ( !data.IDC_LAGER_ROHRM_X ? "0" : data.IDC_LAGER_ROHRM_X ),
			rmy: ( !data.IDC_LAGER_ROHRM_Y ? "0" : data.IDC_LAGER_ROHRM_Y ),
			rmz: ( !data.IDC_LAGER_ROHRM_Z ? "0" : data.IDC_LAGER_ROHRM_Z )
		};	
		
		return( retObj );
	},

	/**
     * setze die Anfangswerte fr den Dialog 'Betriebsbedingungen' auf die Werte aus den Dialogen 'Sollwerte Halterungspunkt'
	 * bzw. 'Sollwerte rohrumschlieendes Teil'
	 *
	 * @params -
	 * @returns	-
	 */
	setzeStartwerteFuerBetriebsbedingungen : function()
	{
		// Defaultwert fr Betriebstemperatur ist Umgebungstemperatur aus Dialog 'Sollwerte rohrumschlieendes Teil'
        // -mw- Dialog 'Sollwerte rohrumschlieendes Teil' wird jetzt bersprungen
		// var strTemperatur = getstring( "SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_UMGEBUNG", this._storeBasePath );
		// setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_TEMPERATUR_TS", this._storeBasePath, strTemperatur );
		
		// Defaultwert fr Dmmdicke ist Dmmdicke aus Dialog 'Sollwerte rohrumschlieendes Teil'
        // -mw- Dialog 'Sollwerte rohrumschlieendes Teil' wird jetzt bersprungen
		// var strDaemmdicke = getstring( "SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE", this._storeBasePath );
		// setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_DAEMMDICKE", this._storeBasePath, strDaemmdicke );
		
		// Defaultwerte fr Krfte sind Lastkrfte aus Dialog 'Sollwerte Halterungspunkt'
		var values = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT" );
		var strBewegungsrichtung = values.IDC_RICHTUNG_BEWEGUNG;
		var nDirectionX = 0;	// lateral
		var nDirectionY = 1;	// axial
		var nDirectionZ = 2;	// vertikal		
        // -mw- : Auf / Ab hat hier nichts mit den Richtungen der Bewegungen zu tun ...
		// if ( strBewegungsrichtung == 'Auf' )
		// {
			setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_FX", this._storeBasePath, "" + values.IDC_TABLE.last[ nDirectionX ] );
			setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_FY", this._storeBasePath, "" + values.IDC_TABLE.last[ nDirectionY ] );
			setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_MINUS_FZ", this._storeBasePath, "" + values.IDC_TABLE.last[ nDirectionZ ] );
		/*}
		else
		{
			setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_MINUS_FX", this._storeBasePath, "" + values.IDC_TABLE.last[ nDirectionX ] );
			setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_MINUS_FZ", this._storeBasePath, "" + values.IDC_TABLE.last[ nDirectionZ ] );
		}
        */
		
		// Defaultwerte fr Versatz sind die Werte fr Bewegung aus Dialog 'Sollwerte Halterungspunkt'
		setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_WX", this._storeBasePath, "" + values.IDC_TABLE.bewegung[ nDirectionX ] );
		setstring( "LAGER_BETRIEBSBEDINGUNGEN.IDC_WY", this._storeBasePath, "" + values.IDC_TABLE.bewegung[ nDirectionY ] );
	},
	
	/**
     * hole die ausgewhlte Lagerart des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID der Lagerart
	 */
	holeLagerart : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_LAGERART ? 'ID_LOSLAGER' : data.IDC_LAGERART );
	},
	
	/**
     * hole die ausgewhlte Gleitart des Dialoges 'Lagerauswahl'
	 * Achtung: in der Gleitart ist auch die Leitungsart bei Festlagern kodiert
	 *
	 * @params -
	 * @returns	string - ID der Gleitart
	 */
	holeGleitart : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_GLEITART ? 'ID_REIBUNGSARM' : data.IDC_GLEITART );
	},
	
	/**
     * hole das ausgewhlte Gleitelement des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID der Gleitart
	 */
	holeGleitelement : function()
	{
		var data = Object.fromStorage( this._storeBasePath + '.LAGER_AUSWAHL' );
		return( !data.IDC_GLEITELEMENT ? 'ID_OHNE' : data.IDC_GLEITELEMENT );
	},
	
	/**
     * hole die ausgewhlte Isolierung des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID der Isolierung
	 */
	holeIsolierung : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_ISOLIERUNG ? 'ID_WAERMEGEDAEMMT' : data.IDC_ISOLIERUNG );
	},
	
	/**
     * hole den ausgewhlten Werkstoff des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID des Werkstoffes
	 */
	holeWerkstoff : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_WERKSTOFF ? 'ID_FERRIT' : data.IDC_WERKSTOFF );
	},
	
	/**
     * hole die ausgewhlte Nennweite des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID der Nennweite (entspricht Wert der Nennweite)
	 */
	holeNennweite : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_NENNWEITE ? '150' : data.IDC_NENNWEITE );
	},
	
	/**
     * hole den ausgewhlten Auendurchmesser des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID des Auendurchmessers (entspricht Wert des Auendurchmessers)
	 */
	holeAussendurchmesser : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_AUSSENDURCHMESSER ? '168,3' : data.IDC_AUSSENDURCHMESSER );
	},
	
	/**
     * hole den ausgewhlten Manteldurchmesser des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	string - ID des Manteldurchmessers (entspricht Wert des Manteldurchmessers)
	 */
	holeManteldurchmesser : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		return( !data.IDC_MANTELDURCHMESSER ? '250' : data.IDC_MANTELDURCHMESSER );
	},
	
	/**
     * hole die Zusatzbedingungen des Dialoges 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	object: bAbhebesicherung - Abhebesicherung gewhlt?
	 *					bHoehenverstellung - Hhenverstellung gewhlt?
	 *					bGleitunterlage - Gleitunterlage gewhlt?
	 *					bKlemmbar - Klemmbar gewhlt?
	 *					bSchraubbar - schraubbar gewhlt?
	 *					bEinschellig - einschellig gewhlt?
	 *					bBuegelausfuehrung - Bgelausfhrung gewhlt?
	 */
	holeZusatzbedingungen : function()
	{
		var	retObj = 
		{ 
			bAbhebesicherung: false,
			bHoehenverstellung: false,
			bGleitunterlage: false,
			bKlemmbar: false,
			bSchraubbar: false,
			bEinschellig: false,
			bBuegelausfuehrung: false
		};	
		
		// anhand storewerte die Variablen der Zusatzbedingungen korrigieren
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		if ( data.IDC_ABHEBESICHERUNG && ( data.IDC_ABHEBESICHERUNG == 'true' ) )
			retObj.bAbhebesicherung = true;
		if ( data.IDC_HOEHENVERSTELLUNG && ( data.IDC_HOEHENVERSTELLUNG == 'true' ) )
			retObj.bHoehenverstellung = true;
		if ( data.IDC_GLEITUNTERLAGE && ( data.IDC_GLEITUNTERLAGE == 'true' ) )
			retObj.bGleitunterlage = true;
		if ( data.IDC_KLEMMBAR && ( data.IDC_KLEMMBAR == 'true' ) )
			retObj.bKlemmbar = true;
		if ( data.IDC_SCHRAUBBAR && ( data.IDC_SCHRAUBBAR == 'true' ) )
			retObj.bSchraubbar = true;
		if ( data.IDC_EINSCHELLIG && ( data.IDC_EINSCHELLIG == 'true' ) )
			retObj.bEinschellig = true;
		if ( data.IDC_BUEGELAUSFUEHRUNG && ( data.IDC_BUEGELAUSFUEHRUNG == 'true' ) )
			retObj.bBuegelausfuehrung = true;
			
		return( retObj );
	},
	
	/**
     * hole den Index des aktuell gewhlten Lagers aus dem Dialog 'Lagerauswahl'
	 *
	 * @params -
	 * @returns	object: bAbhebesicherung - Abhebesicherung gewhlt?
	 *					bHoehenverstellung - Hhenverstellung gewhlt?
	 *					bGleitunterlage - Gleitunterlage gewhlt?
	 *					bKlemmbar - Klemmbar gewhlt?
	 *					bSchraubbar - schraubbar gewhlt?
	 *					bEinschellig - einschellig gewhlt?
	 *					bBuegelausfuehrung - Bgelausfhrung gewhlt?
	 */
	holeIndexGewaehltesLager : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_AUSWAHL" );
		var nIndex = 0;
		if ( data.IDC_LAGER_TABLE_INDEX )
			nIndex = data.IDC_LAGER_TABLE_INDEX - 0;
		return( nIndex );
	},

	/**
     * hole die ausgewhlte Trgerart des Dialoges 'Lager Konfiguration'
	 *
	 * @params -
	 * @returns	string - ID der Trgerart
	 */
	holeTraegerart : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_KONFIGURATION" );
		return( data.IDC_PROFILART || 'HEB' );
	},
	
	/**
     * hole die ausgewhlte Trgergre des Dialoges 'Lager Konfiguration'
	 *
	 * @params -
	 * @returns	string - ID der Trgergre (entspricht Wert der Trgergre)
	 */
	holeTraegergroesse : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".LAGER_KONFIGURATION" );
		return( data.IDC_TRAEGERGROESSE || '100 - 140' );
	}	
};
