/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Data 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
/**
 * @constructor
 */
CascadeKlemmsystemDataAccess = function( strVersion )
{
	/**
     * Programmversion ... falls sich Speicherstrukturen im Store ndern
     * @var _versionString
     */
	this._versionString = strVersion;	
    this._storeBasePath = "DLGDATA.CA.FORMS";
};


CascadeKlemmsystemDataAccess.prototype = 
{
	/**
     * hole die ausgewhlte Lagerart des Dialoges 'Auswahl Klemmsystem'
	 *
	 * @params -
	 * @returns	string - ID der Lagerart
	 */
	holeLagerfunktion : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".KLEMMSYSTEM_AUSWAHL" );
		return( data.IDC_LAGERFUNKTION || 'ID_FUEHRUNGSLAGER'  );
	},
	
	/**
     * hole die Zusatzbedingungen des Dialoges 'Auswahl Klemmsystem'
	 *
	 * @params -
	 * @returns	object: bAbhebesicherung - Abhebesicherung gewhlt?
	 *					bAbhebesicherung4fach - Abhebesicherung 4-fach gewhlt?
	 *					bGleitunterlage - Gleitunterlage gewhlt?
	 *					strBreite - Breite des Lagerfusses
	 */
	holeZusatzfunktionen : function()
	{
		var	retObj = 
		{ 
			bAbhebesicherung: false,
			bAbhebesicherung4fach: false,
			bGleitunterlage: false,
			strBreite: 'ID_B080'
		};	
		
		// anhand storewerte die Variablen der Zusatzbedingungen korrigieren
		var data = Object.fromStorage( this._storeBasePath + ".KLEMMSYSTEM_AUSWAHL" );
		if ( data.IDC_ABHEBESICHERUNG_K && ( data.IDC_ABHEBESICHERUNG_K == 'true' ) )
			retObj.bAbhebesicherung = true;
		if ( data.IDC_ABHEBESICHERUNG4FACH && ( data.IDC_ABHEBESICHERUNG4FACH == 'true' ) )
			retObj.bAbhebesicherung4fach = true;
		if ( data.IDC_GLEITUNTERLAGE_K && ( data.IDC_GLEITUNTERLAGE_K == 'true' ) )
			retObj.bGleitunterlage = true;
		retObj.strBreite = data.IDC_LAGERFUSSBREITE || 'ID_B080';
			
		return( retObj );
	},
	
	/**
     * hole den Index des aktuell gewhlten Lagers aus dem Dialog 'Auswahl Klemmsystem'
	 *
	 * @params -
	 * @returns	nIndex: Index des gewhlten Klemmsystems
	 */
	holeIndexGewaehltesKlemmsystem : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".KLEMMSYSTEM_AUSWAHL" );
		var nIndex = 0;
		if ( data.IDC_KLEMMSYSTEM_TABLE_INDEX )
			nIndex = data.IDC_KLEMMSYSTEM_TABLE_INDEX - 0;
		return( nIndex );
	},

	/**
     * hole die ausgewhlte Trgerart des Dialoges 'Auswahl Klemmsystem'
	 *
	 * @params -
	 * @returns	string - ID der Trgerart
	 */
	holeTraegerart : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".KLEMMSYSTEM_AUSWAHL" );
		return( data.IDC_PROFILART || 'HEB' );
	},
	
	/**
     * hole die ausgewhlte Trgergre des Dialoges 'Auswahl Klemmsystem'
	 *
	 * @params -
	 * @returns	string - ID der Trgergre (entspricht Wert der Trgergre)
	 */
	holeTraegergroesse : function()
	{
		var data = Object.fromStorage( this._storeBasePath + ".KLEMMSYSTEM_AUSWAHL" );
		return( data.IDC_TRAEGERGROESSE || '100 - 140' );
	}	
};
