﻿
#include "importSTK.es"


/**
	12.5.2015 Status:
	Offene ToDo's sind:
		- Typenschlüsselanalyse Lager zu Ende programmieren (Schubert)
		- Lager in Topologie HaengendEinfach zu Ende programmieren / testen
		- Topologie Stützend einfach / doppelt
		- Topologie Gelenk (FSG (Gelenkstütze) oder SSG (Gelenkstrebe) oder SSB (Stossbremse))
		- Topologie CaTopoEinzel  -> Für alle Einzelprodukte ausser Lagern und Klemmsystemen  <<< das sollte ziemlich identisch mit der Typenschlüsselanalyse-Funktion sein, wird eventuell auch benötigt für Hänger mit Lasche?
		- Topologie CaTopoLager2  -> Für eine einzelne Lagerauswahl

		- Handling von Sonderteilen?	
		- Blockierung Hänger OK?
		
		Offene Probleme:
		- Beispiel 00MBA81BQ002_00HTCT332881-R+S.fin:   Enthält eine V-Schelle aber keine Spannweite, im eFIN kein Hinweis darauf dass doppelte LK vorliegt !
		- Beispiel 00MBH10BQ002_00HTCT332867-R+S.fin:   Es ist eine EInzel-Lagerauswahl, aber da getTypHL(rh_typ) in importSTK.es den Wert "FH" übergeben bekommt, wird am Ende eine einfach hängende LK erzeugt !!!
		- Beispiel 00MBH50BQ003_00HTCT332932-R+S.fin:   Es ist eine Starre Lastkette einfach, aber da getTypHL(rh_typ) in importSTK.es KEINEN Wert hat, wird am Ende eine einfach hängende LK mit Konstanthänger erzeugt !!!
		===> Generell müssen wir dafür sorgen, dass in setSTKdataToDlgAbsPath(posPath, "FIN"); alle Informationen so in den Store geschrieben werden, dass danach, beim Initialisieren eines MainControllers die richtige Topologie erzeugt wird
*/

CaEfinImportManager = function() {

    
};


CaEfinImportManager.prototype =  {

	/** 
	 * Einstiegsfunktion in die Analyse aller eFIN-Dateien eines Ordners im Filesystem 
	 *
	 * @param	 {Array}	 Parameter1 Array, in das pro analysierter Position ein Objekt geschrieben werden soll, das den Ergebnis-Status  enthält
	 * @return	 	 
	 */
	importAllEFINtoProjectlist : function(aResultLog, ImportFormat)
    {
		var basePath = "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS";
		var nLastPos = getsize(basePath, "") - 1;

		for (var i = 0; i <= nLastPos; i++) {
			var posPath = basePath + "[" + i + "]";
			
			
			var oResultLogItem = getNewResultLogItem(getstring("pos", posPath),
													 getstring("m_attachmentName", posPath),
													 getstring("info", posPath));
			var aHistory = [];
			
			// Seit neuestem stehen in diesem Feld auch Tabs und / oder Leerzeichen (-mw- 6.7.2015):
			var strTyp  = trimWhite(getstring("typ", posPath));
			
			// eFIN's werden bei "FIN mit Defaults" nicht mit eingelesenen
			if (strTyp == "eFIN" && ImportFormat == "FIN"){
				oResultLogItem.nResult = 0;
				oResultLogItem.strMessage = 'File is type eFIN! Use - read all eFIN - for import!';
				aResultLog.push(oResultLogItem);
				continue;
			}
			
			// für den Import von FIN's mit Default-Werten wird der strTyp hier manipuliert
			if ((strTyp == "FIN" || strTyp == "L3D") && ImportFormat == "FIN"){	// "FIN mit Defaults"
				// Auswertung der Defaut-Werte und weiteres befüllen des FINOBJECT's -> Bauteile
				var oInfo	= enhanceFinFile( posPath );
				// ggf. musste der Auslegungstyp geändert werden (z.B. FP mit Bewegungen)
				if (oInfo.bAgain){
					if (oInfo.isWarning){
						oResultLogItem.nResult = -1;
						oResultLogItem.strMessage = oInfo.Warning + "\n";
					}
					oInfo	= enhanceFinFile( posPath );
					
				}
				// jetzt haben wir ggf. Daten analog dem eFIN vorliegen
				if (oInfo.bOK){
					strTyp	= "eFIN";
					if (oInfo.isWarning){
						oResultLogItem.nResult = -1;
						oResultLogItem.strMessage += oInfo.Warning;
					}
					/*
					else
						oResultLogItem.strMessage = oInfo.Message;
					*/
				}
				else{
					oResultLogItem.nResult = 0;
					//oResultLogItem.strMessage = oInfo.Message;
					oResultLogItem.strMessage += oInfo.Warning;
					aResultLog.push(oResultLogItem);
					continue;
				}
			}
			
			if (strTyp != "eFIN" && strTyp != "STK") {
				oResultLogItem.nResult = 0;
				oResultLogItem.strMessage = 'File is not of type eFIN and therefore not analyzed';
				aResultLog.push(oResultLogItem);
				continue;
			}
			
			// ----------
			// if (i > 0) break;	// Just for debugging ...
			// ----------
			
			// Damit nie Reste von vorher stehen bleiben:
			delete("", "DLGDATA");
			// Nach Abarbeitung dieses Requests muss der Standard-Main-Controller nicht raus-serialisiert werden:
			setstring("KILL_CAMAINCONTROLLER", "", "true");

			// Im ersten Schritt setzen wir wie beim konventionellen Import alle Daten in den Dialogbereich, insbes. in die
			// Abteilungen, in denen die Eingabedaten für die Masken stehen
			
			// Funktion aus importSTK.es; verwendet Klasse aus "custom/controllers/classes/CascadeSTK.es", 
			// die bereits beim Einlesen aller Files in die Liste erzeugt und im Store abgelegt worden ist.
			// Die Methoden dieser Klasse sind nur zum Parsen relevant, deshalb reicht es später aus, die
			// Javascript-Klasse aus dem Store mit Object.fromStorage() auszulesen
			
			setSTKdataToDlgAbsPath(posPath, right(strTyp, 3));
			
			// Das Objekt mit allen Daten des eingelesenen FIN-Files können wir uns auch schon mal holen:
			var oFinData = Object.fromStorage( posPath+".FINOBJECT");
			
			
			// Nun in einem Zwischenschritt Infos in der Partslist im oFinData ergänzen und den 
			// Typenschlüssel reparieren falls nötig (er enthält in manchen Beispielen keine Blanks):
			this.enhanceFinData(oFinData, getstring("typ", posPath));
			
			
			var tmpCaMainController;
			
			// Anhand der Infos im FIN bzw. der jetzt schon gesetzten Dialogvariablen in der Systemcharakteristik
			// kann auch die Topologie bestimmt werden; dies passiert automatisch, wenn wir einen neuen Main-Controller
			// erzeugen:
			tmpCaMainController = new CaController();
			// tmpCaMainController.topologieKlassenName sollte den Namen der Topoklasse enthalten
			// Die Topologieklasse ist bereits im tmpCaMainController richtig angelegt worden,
			// wenn nicht, ist richtig was schief gelaufen ...
			if (!tmpCaMainController || (!tmpCaMainController.topologieKlasse && tmpCaMainController.topologieKlassenName != "FREIEPOSITION")) {					oResultLogItem.nResult = -2;
				oResultLogItem.strMessage = 'Main Controller or topology class could not be created!';
				aResultLog.push(oResultLogItem);
				continue;
			}
			
			// Jetzt müssen die einzelnen Produkte aus der Stückliste gelesen und erzeugt 
			// werden, über Typenschlüssel-Analyse; dazu müssen wir wissen, was für eine Topo wir
			// vorliegen haben, d.h. hier brauchen wir eine Fallunterscheidung. Da bei der typenschlüsselanalyse
			// der DLGDATA - Bereich überschrieben wird, müssen wir ihn hier sichern ...
			delete("DLGDATA", "TEMP");
			copy("DLGDATA", "TEMP.DLGDATA")				
			
			if (tmpCaMainController.topologieKlassenName == "CaTopoHaengendEinfach") {
				this.createTopoHaengend(tmpCaMainController, oFinData, oResultLogItem, aHistory);
			}
			else if (tmpCaMainController.topologieKlassenName == "CaTopoStuetzend") {
				this.createTopoStuetzend(tmpCaMainController, oFinData, oResultLogItem, aHistory);
				if (tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError
					&& tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError != ""){
					oResultLogItem.nResult = -2;
					oResultLogItem.strMessage = tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError;
				}
			}
			else if (tmpCaMainController.topologieKlassenName == "CaTopoGelenk") {
				this.createTopoGelenk(tmpCaMainController, oFinData, oResultLogItem, aHistory);
			}
			else if (tmpCaMainController.topologieKlassenName == "CaTopoEinzel") {
				this.createTopoEinzel(tmpCaMainController, oFinData, oResultLogItem, aHistory);
				/*
				if (!tmpCaMainController.topologieKlasse.bZubehoer) {
					oResultLogItem.nResult = 0;
					oResultLogItem.strMessage = 'Single systems cannot be analyzed and will be skipped!';
					aResultLog.push(oResultLogItem);
					continue;
				}
				else {	// Lastketten die nur aus Sonderteilen bestehen laufen über einzelnes Zubehör "ohne"
					var Sonderteil	= this.createSonderteil(tmpCaMainController, oFinData, oResultLogItem);
					tmpCaMainController.topologieKlasse.Sonderteile.push(Sonderteil);
					tmpCaMainController.topologieKlasse.Zubehoer	= new Zubehoer();
				}
				*/
				if (tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError
					&& tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError != ""){
					oResultLogItem.nResult = -2;
					oResultLogItem.strMessage = tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData.strError;
				}
			}
			else if (tmpCaMainController.topologieKlassenName == "CaTopoLager2" &&
					oFinData.restrain.hangtype != "FREITEXT" &&
					oFinData.restrain.hangtype != "STAUFF") {
				this.createTopoLager2(tmpCaMainController, oFinData, oResultLogItem, aHistory);
				if (tmpCaMainController.topologieKlasse.Lager.oData.strError != ""){
					oResultLogItem.nResult = -2;
					oResultLogItem.strMessage = tmpCaMainController.topologieKlasse.Lager.oData.strError;
				}
			}
			else if (tmpCaMainController.topologieKlassenName == "CaTopoLager2" &&
					(oFinData.restrain.hangtype == "FREITEXT" ||
					oFinData.restrain.hangtype == "STAUFF")) {
				var FreiePosition	= this.createFreiePosition(tmpCaMainController, oFinData, oResultLogItem);
			}
			else {
				oResultLogItem.nResult = -2;
				oResultLogItem.strMessage = 'Unknown topology!';
				aResultLog.push(oResultLogItem);
				continue;
			}
			
			if (oResultLogItem.nResult > 0 || oResultLogItem.nResult == -1){
				// Ermittelte Höhenlevel merken
				delete("TEMP.DLGDATA.CA.FORMS", "HOEHENLEVEL");
				copy("DLGDATA.CA.FORMS.HOEHENLEVEL", "TEMP.DLGDATA.CA.FORMS.HOEHENLEVEL");
			}
			
			// Original DLGDATA der eFIN wiederherstellen:
			delete("", "DLGDATA");
			copy("TEMP.DLGDATA", "DLGDATA")
			delete("DLGDATA", "TEMP");
			
			// Hanger nochmal nachrechnen - zur Sicherheit:
			// wenn keine LagerTopo und keine GelenkTopo (hier sind die Zusatzlasten nicht zu berücksichtigen)
			// Ausnahme - "FSG"
			// und Result bisher OK oder WARNING
			if ((oResultLogItem.nResult > 0 || oResultLogItem.nResult == -1) && tmpCaMainController.topologieKlassenName != "CaTopoLager2")
			{
				if ((tmpCaMainController.topologieKlassenName == "CaTopoGelenk" && tmpCaMainController.topologieKlasse.bFSG) ||
					tmpCaMainController.topologieKlassenName != "CaTopoGelenk")
				{
					tmpCaMainController.topologieKlasse.berechneSystemmassInitial();
					var AchsDirInfo			= tmpCaMainController.dataAccess.getAchsKSInfo();
					var sollast				= max(Math.abs(tmpCaMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(tmpCaMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
					var schaetzZusatzlast 	= tmpCaMainController.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
					var istZusatzlast 		= tmpCaMainController.topologieKlasse.calculateZusatzlast();
					var berZLast			= fround(atod(getstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT")),2); // fuer zweiten Durchlauf
					tmpCaMainController.dataAccess.setSollwerteZusatzLastEG(istZusatzlast);
					var bSuccess			= tmpCaMainController.recalcHaenger((sollast + schaetzZusatzlast), istZusatzlast, "eFIN");
					if (! bSuccess) {
						//oResultLogItem.strMessage = "Vorgegebener Hänger/Stütze ist nicht möglich!";
						oResultLogItem.strMessage += "Hanger/Support given in the " + getstring("BaseType", "DLGDATA.CA.FINDATA.eFIN_Message") + "-file not possible!\n";
						oResultLogItem.nResult = -2;
					}
				}
			}
			
			// Nun das Ganze als neue Position in die Projektliste übernehmen:
			if (oResultLogItem.nResult > 0 || oResultLogItem.nResult == -1) {	// Pos. mit Status "OK" und "Warnungen"
			
				// Einfügeposition und anzuzeigende Posnr in Projektliste bestimmen:
				var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
				var nPosEinfuegen = getsize(Projectlist, "");
				var nPos = 10;
				var Target = Projectlist + "[" + (nPosEinfuegen-1) + "]";
				if(nPosEinfuegen > 0) {
					nPos = (atoi(getstring("POS", Target)) / 10 + 1) * 10;
				}
				Target = Projectlist + "[" + (nPosEinfuegen) + "]";
				
				oResultLogItem.strFLPos	= nPos;
				
				// es können zu berücksichtigende Sonderteile enthalten sein
				if (oFinData.sec_steel && oFinData.sec_steel.aSteeldata &&
					(oFinData.sec_steel.aSteeldata.length > 0))  {
					for (var sp = 0; sp < oFinData.sec_steel.aSteeldata.length; ++sp) {
						var Sonderteil = SonderteilassiController.addStahlbauSonderteil(oFinData.sec_steel.aSteeldata[sp], true)
						tmpCaMainController.topologieKlasse.Sonderteile.push(Sonderteil);
					}
				}
				setstring("STEELPARTS", "DLGDATA.CA.FINDATA", "")
				
				// Unterscheidung in Lastketten / Lager und Freie Positionen
				// TODO: Sonderfall Freie Position mit Stahlbau !!! --> Regeln über "FREITEXT_MIT_STAHLBAU" bzw. "STAUFF_MIT_STAHLBAU"
				
				if (oFinData.restrain.hangtype != "FREITEXT" && oFinData.restrain.hangtype != "STAUFF"){
					// Beschreibungstext und Materialnummer zur Lastkette bestimmen:
					var LKMatInfo	= tmpCaMainController.topologieKlasse.getLastkettenIdent(tmpCaMainController);    
					var strDescr	= "", strDescrShort = "";
					var Markierung	= trimright(trimleft(getstring("IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE"), " "), " ");
					for (j=0; j < LKMatInfo.aTexte.length; j++)
					{
						if(LKMatInfo.aTexte[j] != "")
							strDescr += LKMatInfo.aTexte[j] + "<br>";
					}
					strDescrShort	= (Markierung != "" ? Markierung + "<br>" : "");
					strDescrShort	+= LKMatInfo.aTexte[0] + "<br>" + LKMatInfo.aTexte[1];
					
					var stkList = [];
					var oOptions = tmpCaMainController.presets.getPreisOptions();
					tmpCaMainController.topologieKlasse.getStueckliste(stkList);
					tmpCaMainController.topologieKlasse.bestimmeMutternPreiseGewichte(stkList, true);               // bestimmt Preis-Status
					tmpCaMainController.topologieKlasse.getStuecklisteForDisplay(oOptions, tmpCaMainController);    // bestimmt Matnr-Status
					tmpCaMainController.topologieKlasse.serializeOut("DLGDATA.CA.SELECTION.TOPOCLASS");
					
					// Dialoghistory rausschreiben ...		
					aHistory.toStorage("DLGDATA.CA.HIST.HISTORY", false);

					var calc_preis = tmpCaMainController.topologieKlasse.gesamtPreis;
					var strDlgdata = "DLGDATA";

					setstring("POS", 			 		  	strDlgdata, nPos + '');
					setstring("SHORTTEXT",					strDlgdata, strDescr);
					setstring("ORDERCODE",					strDlgdata, strDescr);
					setstring("ORDERCODE_PROJECTLIST", 		strDlgdata, strDescrShort);
					setstring("ORDERCODE_SHORT", 	  		strDlgdata, strDescrShort);
					setstring("IDENT",						strDlgdata, LKMatInfo.matnr);
					setstring("CUSTOMER_CODE",				strDlgdata, '');
					setstring("MARKIERUNG",					strDlgdata, Markierung);
					var QTY	= getstring("qty", posPath);
					if (QTY == "" || QTY*1 == 0)
						QTY = 1;
					else
						QTY = QTY*1;
					setstring("QTY",						strDlgdata, QTY);
					setstring("STATUS_PREIS",				strDlgdata, tmpCaMainController.topologieKlasse.preisStatus);
					setstring("STATUS_MATNR",				strDlgdata, tmpCaMainController.topologieKlasse.matStatus);
					setdouble("DUNITWEIGHT",				strDlgdata, tmpCaMainController.topologieKlasse.gesamtGewicht);
					if (tmpCaMainController.topologieKlasse.preisStatus == "ERROR")
						setdouble("DUNITPRICE",				strDlgdata, 0);
					else
						setdouble("DUNITPRICE",				strDlgdata, atof(calc_preis, 2));
					setstring("UNITPRICE",					strDlgdata, atof(calc_preis, 2));
					setstring("UNITPRICE_ALL_INCLUDED",		strDlgdata, atof(calc_preis, 2));
					setstring("FORCEDUNITPRICE",			strDlgdata, "");
					setstring("POSPRICE",					strDlgdata, atof(calc_preis, 2));
					setstring("POSPRICE_MINUSADDED",		strDlgdata, atof(calc_preis, 2));
					setstring("INT_ACCEPT_SET_PRICE",		strDlgdata, "");
					setstring("EXT_ACCEPT_SET_PRICE",		strDlgdata, "");
					setdouble("DADDEDPOSPRICE",				strDlgdata, atof(calc_preis, 2));
					setstring("CACHE_DRAWING_FILE_PDF",		strDlgdata, "");
					setstring("CACHE_DRAWING_FILE_PDF_SAP",	strDlgdata, "");
					setstring("CACHE_DRAWING_FILE_DXF",		strDlgdata, "");
					setstring("SAP_CHECK",					strDlgdata, "true");

					// Wichtig: den letzten Screen merken, der zu diesem Weg geführt hat:
					setstring("MODIFY_ENTRY_SCREEN", 		strDlgdata, "IDD_CASCADE");    
					// Sowie den Produktbereich (welcher "Experte" ist zuständig?)
					setstring("PRODUCT_AREA", 				strDlgdata, "CA")
					setstring("PRODUCT_AREA_SOURCE", 		strDlgdata, "")
				}
				else{
					var strDlgdata	= "DLGDATA";
					var FPData		= strDlgdata + ".FP";
					FreiePosition.toStorage(FPData, false);
					var strMarkierung	= trimright(trimleft(FreiePosition.MARKIERUNG, " "), " ");
					var strTyp			= "";
					if (strMarkierung != "")
						strTyp	= strMarkierung + "<br>";
					strTyp	+= left(FreiePosition.FREI_TYP, 30) + "...";
					
					setstring("POS", 			 		  	strDlgdata, nPos + '');
					setstring("SHORTTEXT",					strDlgdata, FreiePosition.FREI_TYP);
					setstring("ORDERCODE",					strDlgdata, strTyp);
					setstring("ORDERCODE_PROJECTLIST", 		strDlgdata, strTyp);
					setstring("ORDERCODE_SHORT", 	  		strDlgdata, FreiePosition.FREI_TYP);
					setstring("IDENT",						strDlgdata, FreiePosition.FREI_NUMMER);
					setdouble("DUNITWEIGHT",				strDlgdata, FreiePosition.GEWICHT);
					setdouble("DUNITPRICE",					strDlgdata, FreiePosition.FREI_PREIS_EURO);
					setstring("UNITPRICE",					strDlgdata, "" + FreiePosition.FREI_PREIS_EURO);
					setstring("FORCEDUNITPRICE",			strDlgdata, "");
					setdouble("DADDEDPOSPRICE",				strDlgdata, "");
					setstring("QTY",						strDlgdata, FreiePosition.QTY);
					setstring("SAP_CHECK",					strDlgdata, "true");

					// Wichtig: den letzten Screen merken, der zu diesem Weg geführt hat:
					setstring("MODIFY_ENTRY_SCREEN", 		strDlgdata, "IDD_FREIE_POSITION");    
					// Sowie den Produktbereich (welcher "Experte" ist zuständig?)
					setstring("PRODUCT_AREA", 				strDlgdata, "FP")
					//setstring("PRODUCT_AREA_SOURCE", 		strDlgdata, "")
					
				}
				
				delete("", Target);
				copy(strDlgdata, Target);
				setstring("PROJECT.SETTINGS.PROJ_MODIFIED_FLAG", "", "MODIFIED");
			}
			
			if (oResultLogItem.nResult > 0)
				setstring("status", posPath, "ANALYZED");	// OK ist im Dictionary auf >> gemapped ...
			else if (oResultLogItem.nResult == 0)
				setstring("status", posPath, "SKIPPED");
			else if (oResultLogItem.nResult == -1)
				setstring("status", posPath, "ANALYZED/WARNING");
			else if (oResultLogItem.nResult < -1)
				setstring("status", posPath, "FAILED");
			
			aResultLog.push(oResultLogItem);
		}
	},

	getNewResultLogItem : function(strPos, strMark, strFile) {
		// in eine Funktion gekapselt, damit hier auch immer dieselbe Struktur erzeugt wird
		var oResultLogItem = {
			strPos	   : strPos,
			strFLPos   : '',
			strMark	   : strMark,
			strFile    : strFile,
			nResult    : 1,			// 1 = Analyse erfolgreich, 0 = Analyse nicht relevant, -1 = Analyse mit Warnungen durchgeführt, -2 = Fehler bei Analyse, abgebrochen
			strMessage : ''
		};
		return oResultLogItem;
	},
	
	enhanceFinData : function(oFinData, FileType) {
		var len		= oFinData.partslist.aPartslist.length;
		var STeil	= 0;
		for (var j = 0; j < len; j++) {
			// Member von oPart: anz, matnr, posnr, typ = Typenschlüssel 
			var oPart	= oFinData.partslist.aPartslist[j];
			
			var numRet	= 0;
			var CorrLG	= 0;
			var CorrDYN	= 0;
			// Hier können FLEXPERTE 4 Lager enthalten sein, die es nicht mehr gibt
			// Umschlüsselungstabelle in "Lager2.db3" -> Tabelle "LAGER_ALT_NEU"
			// Prüfen, ob es so ein Bauteil ist
			if (left(oPart.typ, 1) == "L"){	// alle Lager beginnen mit "L"
				var strSQLStatement	= "select * from LAGER_ALT_NEU where LAGER_FL4 = '" + left(oPart.typ, 3) + "' and SUBTYP_FL4 = " + right(left(oPart.typ, 5),2)*1 + " ";
				numRet				= dbselect("LAGER2", strSQLStatement, "FL4_LAGER");
				CorrLG				= 1;
			}
			// wenn LI-SSG verplant sind und wir nicht LI auslegen, müssen diese umgeschlüsselt werden (auch die Anbauteile!!!)
			// 
			//if (getstring("SALESVERSION","RIGHTS") != "false" &&	// wenn die PSS-Teile in der Schnittstelle implementiert sind muss das entfallen
			if((!oPart.isPSS) &&			// wir setzen unten den Kenner damit wir hier in der 2. Runde nicht reinlaufen
				(toupper(left(oFinData.assembly.rh_typ, 3)) != "FGS") &&	// FSG wird derzeit noch mit MBS ausgelegt
				(left(oPart.typ, 1) == "M" || left(oPart.typ, 1) == "S" || left(oPart.typ, 2) == "VG")){
				var Basetype	= left(oPart.typ, 3);
				var strSQLStatement	= "select * from DYNAMIK_ALT_NEU where TYP = '";
				var SplitTyp		= "";
				if (Basetype == "VGR" || Basetype == "MSN"){
					SplitTyp	= splitVarDelimiter(oPart.typ, "...-.");
					SplitTyp	= SplitTyp[3];
				}
				else
					Basetype	= left(oPart.typ, 6);
				strSQLStatement	+= Basetype + SplitTyp + "' ";
				numRet			= dbselect("CASCADE", strSQLStatement, "DYNAMIK");
				if (numRet && right(Basetype, 3) == "000"){
					// entweder ein fehlerhaftes Lisega Bauteil
					// oder
					// eine PSS-SSG mit Nennlast < 13kN (die PSS-Böcke und Schellen mit PSS-Nennlast [4-stellig] liefern numRet=0
					if (right(left(oPart.typ, 7), 1) != ".")
						numRet	= 0;
				}
				//CorrDYN			= 1;
			}
			
			if (!numRet){	// alles ist gut
				// Achtung: In oPart.typ sind alle Blanks weg !! Hier muss nach dem 3-stelligen Blank ein Typ ergänzt werden
				// Sonderteile "...-S" hier kommt das Blank nach dem "-S" bzw. nach dem "-S1"/"-S2"
				// für FREITEXT und STAUFF keine Änderung
				if (oFinData.restrain.hangtype != "STAUFF" && oFinData.restrain.hangtype != "FREITEXT"){
					if (find(oPart.typ, "-S") > 0){
						var CheckType	= toupper(left(oPart.typ, 2));
						if (CheckType != "VB" && CheckType != "VG" && CheckType != "VS" && CheckType != "VP" && CheckType != "MS")	// "-S"
							oPart.typ = left(oPart.typ, 5) + ' ' + right(oPart.typ, oPart.typ.length - 5);
						else	// "-S1" bzw. "-S2"
							oPart.typ = left(oPart.typ, 6) + ' ' + right(oPart.typ, oPart.typ.length - 6);
					}
					else if (find(oPart.typ, " ") < 0)
						oPart.typ = left(oPart.typ, 3) + ' ' + right(oPart.typ, oPart.typ.length - 3);
				}
				// Convenience: Trage den Basistyp ein:
				if (oFinData.restrain.hangtype == "STAUFF")
					oPart.Basetype = "STF";
				else if (oFinData.restrain.hangtype == "FREITEXT")
					oPart.Basetype = "";
				else if (find(oPart.matnr, "SONDER") > 0){
					oPart.Basetype	= "SONDER";
					oPart.matnr		= left(oPart.matnr.replace(" ", ""), find(oPart.matnr.replace(" ", ""),"SONDER")-2);
					oPart.typ		= oPart.typ.replace(" ", "");
					// die STK's bringen hier auch die Sonderteile geschleppt
					if (FileType == "STK" && (STeil < oFinData.sec_steel.aSteeldata.length)){
						oFinData.sec_steel.aSteeldata[STeil].steel_typ		= oPart.typ;
						oFinData.sec_steel.aSteeldata[STeil].steel_anzahl	= oPart.anz;
						STeil++;
					}
				}
				else
					oPart.Basetype = left(oPart.typ, 3);
				
				// Bestimme die Klasse des Bauteils ... Mögliche Werte sind:
				// Federhaenger, Konstanthaenger, Horizontalschelle, Vertikalschelle, Zubehoer, Lager, Klemmsystem, <leer> bei Sonderteil, Träger, sonst ...
				oPart.Klasse = GetKlassenname(oPart.Basetype);
			}
			else if (CorrLG){	// wir müssen die Daten umbauen
				oFinData	= this.correct_FL4_data_LG(oFinData, strSQLStatement, j, len);
				// und jetzt neu in die Schleife
				len	= oFinData.partslist.aPartslist.length;
				j	= (-1);
			}
			else {	// CorrDYN
				oFinData	= this.correct_FL4_data_DYN(oFinData, strSQLStatement, j, len, FileType);
				// und jetzt neu in die Schleife
				len	= oFinData.partslist.aPartslist.length;
				//j	-= 1;
				j	= (-1);
			}
		}
	},
	
	correct_FL4_data_LG : function(oFinData, strSQLStatement, StueLiPos, StueLiLen) {
		// oFinData.partslist.aPartslist[0].typ	= "LSL23.0200.150";	// vorerst sonst landen wir in einer Endlosschleife
		// das Statement muss noch verfeinert werden
		var oPart_FL4	= oFinData.partslist.aPartslist[StueLiPos];
		// wir brauchen den Werkstoff (zumindest die Unterscheidung "37" oder "NOT_37")
		if (left(right(trimright(oPart_FL4.typ, " "), 3),1) == "-" && right(trimright(oPart_FL4.typ, " "), 2) != "37")
				var Werkstoff	= "NOT_37";
		else
				var Werkstoff	= "37";
		// wir brauchen den Rohraussendurchmesser
		var dA	= getdouble("strSelAussenDuMesserCombo", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil");
		
		// nun sollten wir genau einen Treffer erhalten
		strSQLStatement	+= "and WERKSTOFF_FL4 = '" + Werkstoff + "' and DA_AB_FL4 <= " + dA + " and DA_BIS_FL4 >= " + dA + " order by abs(SEQ_ID) ";
		var numRet		=  dbselect("LAGER2", strSQLStatement, "FL4_LAGER");
		
		if (!numRet){	// hier ist was schief gelaufen
			oFinData.partslist.aPartslist[StueLiPos].typ	= "unknown type FL4";
			return (oFinData);
		}
		
		var Lagertyp_FL5	= dbgetstring("FL4_LAGER", "LAGER_FL5");
		var Lagersubtyp_FL5	= dbgetstring("FL4_LAGER", "SUBTYP_FL5");
		var Anz_Zus_Teile	= atoi(dbgetdouble("FL4_LAGER", "ANZ_ZUS_TEILE"));
		
		oPart_FL4.matnr	= "";	// die wird später sowieso neu bestimmt
		oPart_FL4.typ	= Lagertyp_FL5 + Lagersubtyp_FL5 + right(oPart_FL4.typ, oPart_FL4.typ.length - 5);
		
		for (var zus = 1; zus <= Anz_Zus_Teile; zus++){
			var TypZusTeil	= dbgetstring("FL4_LAGER", "ZUS_TEIL" + zus);
			if (zus > 1 && TypZusTeil == addPart.typ){
				oFinData.partslist.aPartslist[oFinData.partslist.aPartslist.length - 1].anz	+= 1;
			}
			else {
				// das zusätzliche Teil ist nicht immer eindeutig definiert
				// weitere Analyse erforderlich
				if (rfind(TypZusTeil, "/") > 0){		// es gibt verschiedene Möglichkeiten -> derzeit immer ein Klemmsystem
					var TypSplit		= splitVarDelimiter(oPart_FL4.typ, "..-");	// im letzten Feld ist der Träger (soweit vorhanden)
					var TypZusTeilSplit	= TypZusTeil.split("/");	// Aufteilen --> immer KS-"T"/KS-"U"/KS-"L"
					TypZusTeil			= "";
					// wir machen uns auf die Suche nach dem Träger
					if (rfind(TypSplit[TypSplit.length - 1], "T") > 0){
						var TypTraeger	= "-" + left(TypSplit[TypSplit.length - 1], 4);
						TypZusTeil		= TypZusTeilSplit[0] + TypTraeger;
					}
					else if (rfind(TypSplit[TypSplit.length - 1], "U") > 0){
						var TypTraeger	= "-" + left(TypSplit[TypSplit.length - 1], 8);
						TypZusTeil		= TypZusTeilSplit[1] + TypTraeger;
					}
					else if (rfind(TypSplit[TypSplit.length - 1], "L") > 0){
						var TypTraeger	= "-" + left(TypSplit[TypSplit.length - 1], 8);
						TypZusTeil		= TypZusTeilSplit[2] + TypTraeger;
					}
					else{
						var TypTraeger	= "-T140";
						TypZusTeil		= TypZusTeilSplit[0] + TypTraeger;
					}
					// jetz noch den Typ korrigieren
					oPart_FL4.typ	= TypSplit[0] + "." + TypSplit[1] + "." + TypSplit[2];
					if (rfind(TypSplit[TypSplit.length - 1], "-") > 0){
						var TempSplit	= TypSplit[TypSplit.length - 1].split("-");
						oPart_FL4.typ	+= "-" + TempSplit[TempSplit.length - 1];
					}
				}
				var addPart		= {	anz 	: 1,
									matnr	: "",
									posnr	: oFinData.partslist.aPartslist[StueLiLen-1].posnr * 1 + 1,
									typ		: TypZusTeil
								  };
				oFinData.partslist.aPartslist.push(addPart);
			}
		}
		
		return (oFinData);
	},
	
	correct_FL4_data_DYN : function (oFinData, strSQLStatement, StueLiPos, StueLiLen, FileType) {
		var FN_MIN		= dbgetstring("DYNAMIK", "FN_PSS_MIN");
		var FN_MAX		= dbgetstring("DYNAMIK", "FN_PSS_MAX");
		var FN_LI_KLEIN	= dbgetstring("DYNAMIK", "FN_LI_KLEIN");
		//var FN_LI_GROSS	= dbgetstring("DYNAMIK", "FN_LI_GROSS");
		
		// wir korrigieren gleich die gesamte StüLi und starten die Schleife in "enhanceFinData" neu
		var FNsearch		= FN_MAX*1;
		var FNselected		= sprintf("%.4d", FNsearch);	// alle Bauteile außer SSG
		var FNselected_SSG	= sprintf("%.4d", FNsearch);	// Bauteil SSG
		// 1. suchen der Schelle - ggf. ist Nennlast kleiner FN_MIN bzw. kleine als eine Nennlast zw. FN_MIN und FN_MAX
		var PosSchelle	= -1;	// keine da
		for (var sSchelle = 0; sSchelle < StueLiLen; sSchelle++){
			if (left(oFinData.partslist.aPartslist[sSchelle].typ, 3) == "MSN" || left(oFinData.partslist.aPartslist[sSchelle].typ, 3) == "VGR"){
				PosSchelle	= sSchelle;
				break;
			}
		}
		if (PosSchelle >= 0){
			var TypSplit	= splitVarDelimiter(oFinData.partslist.aPartslist[PosSchelle].typ, "...-.");
			var TMPMain		= new CaController();
			var ZWst		= TMPMain.dataAccess.getZahlFromWerkstoff(WerkstoffeNrZuNamen[TypSplit[4]]);
			var Temperatur	= min(getstring("TemperaturPIPE", "DLGDATA.CA.FINDATA.eFIN_Message")*1, getstring("TemperaturPIPE", "DLGDATA.CA.FINDATA.eFIN_Message")*1);
			var KorrFakt	= TMPMain.CompTempKorr(Temperatur, ZWst);
			//FNsearch		= (TypSplit[1] * 1 * KorrFakt > FN_LI_KLEIN * 1 ? TypSplit[1] * 1 * KorrFakt : TypSplit[1] * 1);
			FNsearch		= min(FNsearch, (TypSplit[1] * 1 * KorrFakt > FN_LI_KLEIN * 1 ? TypSplit[1] * 1 * KorrFakt : TypSplit[1] * 1));
		}
		if (FileType == "STK"){
			// hier können die tatsächlichen Lasten leicht ausgewertet werden
			var FNTemp	= max(abs(oFinData.required.operat), abs(oFinData.assembly.x_load), abs(oFinData.assembly.y_load));
			if (FNTemp <= 5 || FNTemp > 8){
			// dazwischen Problem: Strebe 5kN und Bock 8kN / hier würden wir eine 13er Strebe mit 8er Bock bekommen!!!
				FNsearch	= FNTemp;
				// Achtung - Bei doppelten LK's steht hier die Gesamtlast drin
				if (left(oFinData.assembly.lk_typ, 2) == "N2" || oFinData.assembly.distance*1 > 0)
					FNsearch	= FNsearch / 2;
			}
		}
		
		// Achtung: Die Nennlast des Bockes unterscheidet sich z.T. von den Nennlast der Strebe!!!
		strSQLStatement	= "select * from MBW where abs(FN) >= " + FNsearch + " order by abs(FN)";
		var numRet		= dbselect("CASCADE", strSQLStatement, "FNsearch");
		if (numRet > 0)
			FNselected		= sprintf("%.4d", dbgetdouble("FNsearch", "FN"));	// wir nehmen den ersten Treffer - das ist der kleinste
		strSQLStatement	= "select * from SSG_PSS where abs(FN) >= " + FNsearch + " order by abs(FN)";
		var numRet		= dbselect("CASCADE", strSQLStatement, "FNsearch");
		if (numRet > 0)
			FNselected_SSG	= sprintf("%.4d", dbgetdouble("FNsearch", "FN"));	// wir nehmen den ersten Treffer - das ist der kleinste
		
		// 2. Auswerten der Lasten - TODO
		
		for (var Korr = 0; Korr < StueLiLen; Korr++){
			switch (left(oFinData.partslist.aPartslist[Korr].typ, 3)){
				case "MSN" :
				case "VGR" :
					var TypSplit	= splitVarDelimiter(oFinData.partslist.aPartslist[Korr].typ, "...-.");
					if (TypSplit.length == 6 && FN_MAX != "UNDEF"){
						TypSplit[3]	= FNselected;
						oFinData.partslist.aPartslist[Korr].typ	= "";
						for (var TypPart = 0; TypPart < TypSplit.length; TypPart++){
							oFinData.partslist.aPartslist[Korr].typ	+= TypSplit[TypPart] + (TypPart != 3 ? "." : "-");
						}
						oFinData.partslist.aPartslist[Korr].typ	= trimright(oFinData.partslist.aPartslist[Korr].typ, ".");
					}
					else
						oFinData.partslist.aPartslist[Korr].typ = "Rename of " + left(oFinData.partslist.aPartslist[Korr].typ, 3) + " not possible"
					oFinData.partslist.aPartslist[Korr].isPSS	= 1;
					break;
				case "MBS" :
					var TypSplit	= oFinData.partslist.aPartslist[Korr].typ.split("-");
					if (TypSplit.length == 2 && FN_MAX != "UNDEF"){
						TypSplit[0]	= left(TypSplit[0], 2) + "W" + FNselected;
						// Achtung: der Bock vor der Schelle (falls vorhanden) ist roh
						if (Korr < (StueLiLen - 1)){
							if (left(oFinData.partslist.aPartslist[Korr+1].typ, 2) != "SS")
								TypSplit[1]	= "0";
						}
						oFinData.partslist.aPartslist[Korr].typ		= TypSplit[0] + "-" + TypSplit[1];
						oFinData.partslist.aPartslist[Korr].matnr	= "";
					}
					else
						oFinData.partslist.aPartslist[Korr].typ = "Rename of " + left(oFinData.partslist.aPartslist[Korr].typ, 3) + " not possible"
					oFinData.partslist.aPartslist[Korr].isPSS	= 1;
					break;
				case "SSG" :
					var TypSplit	= splitVarDelimiter(oFinData.partslist.aPartslist[Korr].typ, ".-");
					if (TypSplit.length == 3 && FN_MAX != "UNDEF"){
						TypSplit[0]	= left(TypSplit[0], 3) + FNselected_SSG;
						TypSplit[2]	= "1";	// Standard galvanisch
						oFinData.partslist.aPartslist[Korr].typ		= TypSplit[0] + "." + TypSplit[1] + "-" + TypSplit[2];
						oFinData.partslist.aPartslist[Korr].matnr	= "";
					}
					else
						oFinData.partslist.aPartslist[Korr].typ = "Rename of " + left(oFinData.partslist.aPartslist[Korr].typ, 3) + " not possible"
					oFinData.partslist.aPartslist[Korr].isPSS	= 1;
					break;
				default :
					break;
			}
		}
		
		return (oFinData);
	},
	
	createTopoHaengend : function(tmpCaMainController, oFinData, oResultLogItem, aHistory) {
		
		/*  Wichtige bereits verfügbare Infos aus der Oberklasse sind hier:
				tmpCaMainController.topologieKlasse.bDoppelt	=> handelt es sich um eine doppelte LK (horizontal oder vertikal)?
				tmpCaMainController.topologieKlasse.bVertikal	=> Ist der Rohrverlauf vertikal?
		    Gefüllt werden müssen folgende Infos aus der Topologieklasse:
				this.SegmentStrang  = null;     // bei einer einfachen bzw. symmetrisch doppelten LK gibt es nur einen Strang
				this.Schelle        = null;		// V-Schelle oder H-Schelle
				this.Lasche         = null;		// optional, zur H-Schelle 
				this.Traverse       = null; 	// mit un dohne Lager
				this.bLager 		= false;
				this.TopoLager2 	= null;		// -mw- 9.5.2012 neu - für das Lager auf dem Träger - alternativ zur Schelle	
			sowie aus der Topo-Oberklasse:
				this.Mutter     = null;			// berechnet wo / wie ?
				this.Sonderteile = [];			// @@@ eventuell direkt aus der Partslist der eFIN-Datei
				this.a_lgv      = "";			// aus dem selektierten Hänger
				this.gesamtGewicht = 0;			// berechnet wo / wie ?
				this.gesamtPreis = 0;			// berechnet wo / wie ?

			Das hier muss im SegmentStrang drin sein:
				this.Haenger                    = null;
				this.ObererAnschluss            = null;
				this.Stahlbau                   = null;
				this.OberesVerbindendesTeil1    = null; 	// Gabel, Öse
				this.ObereVerbindendeTeile      = [];		// Array von Zubehör-Objekten
				this.UnteresVerbindendesTeil1   = null; 	// Gabel, Öse
				this.UntereVerbindendeTeile     = [];    	// Array von Zubehör-Objekten --> Gewindestangen, Hülsen
				
				this.minGewindestangenLaengeOben  = 0;
				this.minGewindestangenLaengeUnten = 0;
		*/

		// Als erstes legen wir mal das Objekt für das SegementStrang an, das brauchen wir hier immer:
		tmpCaMainController.topologieKlasse.SegmentStrang = new CaTopoSegmentStrang(tmpCaMainController.topologieKlasse.dataAccess);
		
		// Sonderinfos ...
		var bObereVerbindendeTeileVorhanden = false;    // nur bei FHG, FDT und Starr
		var bHaengerDurchlaufen = false;    			// Sind wir beim Durchlaufen der Liste schon am Hänger vorbeigekommen ?
		
		var len = oFinData.partslist.aPartslist.length;
		
		// -Schu- bei STARR ist der Hänger "ZSM" oder "ZRM"
		var LKTyp			= tmpCaMainController.dataAccess.getLastketteTyp();
		var bStarr			= false;
		var HaengerStarr	= "";
		if (LKTyp == "STARR"){
			bStarr			= true;
			HaengerStarr	= "ZRM";
			for (var j = 0; j < len; j++) {
				if (oFinData.partslist.aPartslist[j].Basetype == "ZSM"){
					HaengerStarr	= "ZSM";
					break;
				}
			}
		}
		
		for (var j = 0; j < len; j++) {
			var oPart	= oFinData.partslist.aPartslist[j];
			// ###########################################################################################################################
			// wenn in PDMS Teile verschoben werden, aber der Anschlußpunkt nicht mit geändert wird,
			// werden zusätzliche Gewindestangen erzeugt - ggf. mit negativem E-Mass
			if (oPart.Basetype == "ZRM"){
				if (oFinData.partslist.aPartslist[j+1].Basetype == "ZRM"){	// das ist nur so im o.g. Fall
					var PosNrDel = "";	// überflüssige Position
					var PosNrMod = "";	// zu modifizierende Position
					var PosPList;
					if (oFinData.partslist.aPartslist[j+1].matnr != "" && oPart.matnr == ""){	// i.d.R. ist die Mat.-Nr. bei der zusätzlichen (nicht vorhandenen) Gewindestange leer
						PosNrDel = oPart.posnr;
						PosNrMod = oFinData.partslist.aPartslist[j+1].posnr;
						PosPList = j;
					}
					else if (oFinData.partslist.aPartslist[j+1].matnr == "" && oPart.matnr != ""){
						PosNrDel = oFinData.partslist.aPartslist[j+1].posnr;
						PosNrMod = oPart.posnr;
						PosPList = j + 1;
					}
					if (PosNrDel != ""){
						var MerkeDle = [];
						var MerkeMod = [];
						for (var Search = 0; Search < oFinData.caddata.aCaddata.length; Search++){
							if (oFinData.caddata.aCaddata[Search].posstrang == PosNrDel)
								MerkeDle.push(Search);
							else if (oFinData.caddata.aCaddata[Search].posstrang == PosNrMod)
								MerkeMod.push(Search);
						}
						if (MerkeDle.length == MerkeMod.length || MerkeMod.length > 2){
							var bOk	= true;
							for (Search = 0; Search < MerkeDle.length; Search++){
								if (MerkeMod.length == 2 && Search == 0){	// doppelte LK -> Symmetrie prüfen
									bOk	= (fround(oFinData.caddata.aCaddata[MerkeDle[0]].emass, 0) == fround(oFinData.caddata.aCaddata[MerkeDle[1]].emass, 0) ? true : false);
								}
								if (bOk){
									oFinData.caddata.aCaddata[MerkeMod[Search]].emass	= oFinData.caddata.aCaddata[MerkeMod[Search]].emass*1 + oFinData.caddata.aCaddata[MerkeDle[Search]].emass*1;
									oFinData.caddata.aCaddata[MerkeMod[Search]].hlevel	= oFinData.caddata.aCaddata[MerkeMod[Search]].hlevel*1 + oFinData.caddata.aCaddata[MerkeDle[Search]].emass*1;
								}
							}
							if (bOk){	// das stimmt nur für symmetrische LK
								for (Search = 0; Search < oFinData.caddata.aCaddata.length; Search++){
									if (oFinData.caddata.aCaddata[Search].posstrang*1 < oFinData.caddata.aCaddata[MerkeDle[0]].posstrang*1)
										oFinData.caddata.aCaddata[Search].hlevel = oFinData.caddata.aCaddata[Search].hlevel*1 + oFinData.caddata.aCaddata[MerkeDle[0]].emass*1;
								}
								delete(oFinData.partslist.aPartslist[PosPList]);
								delete("aPartslist["+PosPList+"]", "DLGDATA.CA.FINDATA.FINOBJECT.partslist");
								for (Search = 0; Search < MerkeDle.length; Search++){
									delete(oFinData.caddata.aCaddata[MerkeDle[Search]]);
									delete("aCaddata["+MerkeDle[Search]+"]", "DLGDATA.CA.FINDATA.FINOBJECT.caddata");
								}
								
								oResultLogItem.nResult		= -1;
								oResultLogItem.strMessage	+= "Restraint was modifyed. Please check the system elevation!";
								
								if (PosPList == j){		// das Teil wurde gelöscht
									continue;
								}
								else if (PosPList == (j+1)){	// das nächste Teil überspringen, da wir das gerade gelöscht haben
									j += 1
								}
							}
						}
					}
				}
			}
			// ###########################################################################################################################
			
			// -------------------------------------------------------------------------------------------------------
			// Prüfen ob das rohrumschliessende Bauteil den Einsatzbedingungen entspricht
			// wenn nicht ändern und den User informieren
			if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle') || (oPart.Klasse == 'Lager2')){
				var CheckPart	= this.CheckPart(oPart, tmpCaMainController, oResultLogItem);
				oPart.typ		= CheckPart.oPart.typ;
				CheckPart.eFIN_Message.toStorage("TEMP.DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
			// -------------------------------------------------------------------------------------------------------
			
			// ACHTUNG: PDMS fasst ALLE Gleichteile zusammen
			// Problem: z.B. LK mit Gabeln "oben" und "unten" als ...VerbindendesTeil1
			// relevant für Verbindungsteile / Anschlußteile -> Muttern / Gewindestangen werden neu berechnet
			var bZusammgengefasst	= false;
			if ((tmpCaMainController.topologieKlasse.bDoppelt && oPart.anz * 1 > 2) ||
				(!tmpCaMainController.topologieKlasse.bDoppelt && oPart.anz * 1 >= 2))
				bZusammgengefasst	= true;
			
			if (oPart.Basetype == 'ZMM') {
				// die werden nachher automatisch angelegt
				// -Schu- was ist mit 2 Muttern als OBA -> noch prüfen ggf. berücksichtigen
				continue;	
			}
			
			// Der Typsuche-Manager löscht alles unter DLGDATA ... 
			var typManager = new CaTypsucheManager(tmpCaMainController);
			var oParseResult = null;
			if (HaengerStarr == "ZSM" && oPart.Basetype == HaengerStarr)
				oParseResult = typManager.createProductFromTyp(oPart.typ, (oFinData.partslist.aPartslist[j-1].Basetype != "ZLM") ? 1 : 0);	// der zweite Parameter wird beim Zubehör gebraucht, um das passende Bild zu bestimmen
			else
				oParseResult = typManager.createProductFromTyp(oPart.typ, (bHaengerDurchlaufen) ? 1 : 0);
			if (oParseResult.msg != '') {
				// Errormessage in oRes anlegen und oben auswerten:
				oResultLogItem.nResult = -2;
				oResultLogItem.strMessage += oParseResult.msg;
				return;
			}
			
			// -----------------------------------
			if (oPart.Klasse != "Lager2")
				oParseResult.oProduct.m_Poberfl	= oParseResult.oProduct.getOberFlaechenSchutzDefault();
			// -----------------------------------
			
			// oParseResult.oProduct enthält jetzt das erzeugte Produkt, das an die richtige Stelle der Topologie sortiert werden muss ...
			if (oPart.Klasse == 'Lager2') {
				// Sonderfall: Hier muss nochmal eine eigene Topo-Klasse erzeugt werden !!
				setstring("strSelRadioLager", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik", "LAGER_SSG");
				setstring("strSelRadioFunction", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", "LOSE");
				tmpCaMainController.topologieKlasse.TopoLager2 = new CaTopoLager2 ( tmpCaMainController.topologieKlasse.dataAccess, tmpCaMainController.topologieKlasse.presets );
				tmpCaMainController.topologieKlasse.TopoLager2.Lager = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession = new LagerObject();
				Base.applyValues(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil" ));
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.SollwerteHalterungspunkt = Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt" );
				Base.applyValues(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.Systemcharakteristik,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik" ));
				//tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession	= tmpCaMainController.topologieKlasse.TopoLager2.Lager.oDlgLagerSession;
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.bLastKettePathSelection = true;
				tmpCaMainController.topologieKlasse.bLager = true;
			}
			else if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle'))
				tmpCaMainController.topologieKlasse.Schelle = oParseResult.oProduct;		
			else if (((oPart.Klasse == 'Federhaenger') || (oPart.Klasse == 'Konstanthaenger')) ||
					 ((bStarr) && (oPart.Basetype == HaengerStarr))){
				tmpCaMainController.topologieKlasse.SegmentStrang.Haenger = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.a_lgv = oParseResult.oProduct.lgv;
				bHaengerDurchlaufen = true;
				if (oPart.Basetype == 'FHG' || oPart.Basetype == 'FDT' || bStarr)
					bObereVerbindendeTeileVorhanden = true;
			}
			else if (oPart.Klasse == 'Zubehoer') {
				if (oPart.Basetype == 'ZTN')
					tmpCaMainController.topologieKlasse.Traverse = oParseResult.oProduct;	
				if ((oPart.Basetype == 'ZGM') || (oPart.Basetype == 'ZOM')) {
					if (bZusammgengefasst){	// Teil ist oben und unten da
						tmpCaMainController.topologieKlasse.SegmentStrang.OberesVerbindendesTeil1	= oParseResult.oProduct;
						tmpCaMainController.topologieKlasse.SegmentStrang.UnteresVerbindendesTeil1	= oParseResult.oProduct;
					}
					else if (bHaengerDurchlaufen)
						tmpCaMainController.topologieKlasse.SegmentStrang.UnteresVerbindendesTeil1 = oParseResult.oProduct;
					else
						tmpCaMainController.topologieKlasse.SegmentStrang.OberesVerbindendesTeil1 = oParseResult.oProduct;
				}
				// @@@ Check ob Hänger durchlaufen, Check ob überhaupt ObererAnschluss vorhanden gemäß Hängertyp ...
				if ((oPart.Basetype == 'ZLN') || (oPart.Basetype == 'ZLK') || (oPart.Basetype == 'ZKN') ||
					(oPart.Basetype == 'ZKB') || (oPart.Basetype == 'ZKK') || (oPart.Basetype == 'ZPK') ||
					(oPart.Basetype == 'ZGW')) {
				// -Schu- ZLN / ZPK können auch unten sein
					if (bZusammgengefasst){
						tmpCaMainController.topologieKlasse.SegmentStrang.ObererAnschluss	= oParseResult.oProduct;
						tmpCaMainController.topologieKlasse.Schelle							= oParseResult.oProduct;
					}
					else if (!bHaengerDurchlaufen)
						tmpCaMainController.topologieKlasse.SegmentStrang.ObererAnschluss = oParseResult.oProduct;
					else
						tmpCaMainController.topologieKlasse.Schelle	= oParseResult.oProduct;
				}
				if (left(oPart.Basetype, 2) == 'ZV') {
					tmpCaMainController.topologieKlasse.Lasche = oParseResult.oProduct;
				}
				if ((oPart.Basetype == 'ZHM') || (oPart.Basetype == 'ZLM') || (oPart.Basetype == 'ZRM') || (oPart.Basetype == 'ZSM')) {
					if (bHaengerDurchlaufen)
						tmpCaMainController.topologieKlasse.SegmentStrang.UntereVerbindendeTeile.push(oParseResult.oProduct);
					else
						tmpCaMainController.topologieKlasse.SegmentStrang.ObereVerbindendeTeile.push(oParseResult.oProduct);
				}
			}
		}

		/* Dialoghistory aufbauen ...
			Flexperte verwaltet die Historie der durchlaufenen Dialogfenster bei einer RH-Auswahl auf dem Client. Wenn man in einem Dialog auf			
			"Next" clickt, dann gibt es serverseitig einen Experten, der rausfindet was das nächste Fenster sein muss. Bei "Back" ist es aber so, 
			dass einfach in der Historie geschaut wird.
			Wenn man in Übersicht Lastkette auf Übernehmen clickt, sendet der Client die History an den Server und der schreibt sie dann auch in den Store.
			Wenn man in der Projektliste auf Ändern clickt, dann wird das index2.htm – Fenster geladen, das Ext initialisiert, von dort werden dann 
			die einzelnen Panels initialisiert und bei dem History-Panel oben links fordert er die History an.
			Er zeigt sie aber nicht nur an, sondern initialisiert dann auch gleich alle darin vorkommenden Dialogfenster. 
			Und er öffnet sodann das letzte Dialogfenster der History. 
			D.h. ohne History läuft gar nichts (siehe cascade2.js, Zeile 1411 ff).
		*/
		var oClone   = null;
		var curPanel = { id: 'systemcharakteristik',
						 title: 'systemcharakteristik' };
		aHistory.push(curPanel);
		
		var irRet = JSON.parse('{"id":"lager.sollwerte_rohrumschliessendesteil","title":"Sollwerte rohrumschließendes Teil"}');

		for (var i=0;i < 10; ++i) {
			oClone = Base.deepClone(tmpCaMainController.topologieKlasse);
			// curPanel.id = replace(curPanel.id, 'lager.', '');
			var strCurPanel = oClone.getNextPanel(curPanel.id);
			
			// wir brauchen noch ein paar Infos vom Clone
			if (oClone.SegmentStrang.minGewindestangenLaengeOben*1 > 0)
				tmpCaMainController.topologieKlasse.SegmentStrang.minGewindestangenLaengeOben = oClone.SegmentStrang.minGewindestangenLaengeOben;
			if (oClone.SegmentStrang.minGewindestangenLaengeUnten*1 > 0)
				tmpCaMainController.topologieKlasse.SegmentStrang.minGewindestangenLaengeUnten = oClone.SegmentStrang.minGewindestangenLaengeUnten;
			
			if (strCurPanel == '{}')
				break;
			curPanel = JSON.parse(strCurPanel);
			if ((curPanel == '') || (curPanel == {}) || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
				break;
				
			aHistory.push(curPanel);

			// Bei einem Lager müssen wir eigentlich in Controller.Lager.Common.getNextClientPanel() verzweigen:
			if (curPanel.id == 'lager.sollwerte_rohrumschliessendesteil') {
			
				for (var j=0; j < 10; ++j) {
					curPanel = Controller.Lager.Common.getNextClientPanel(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession, curPanel.id, tmpCaMainController);
					//
					if (tmpCaMainController.topologieKlasse.SegmentStrang.ObererAnschluss == null)
						tmpCaMainController.topologieKlasse.SegmentStrang.ObererAnschluss = oClone.SegmentStrang.ObererAnschluss;
					if (tmpCaMainController.topologieKlasse.SegmentStrang.OberesVerbindendesTeil1 == null)
						tmpCaMainController.topologieKlasse.SegmentStrang.OberesVerbindendesTeil1 = oClone.SegmentStrang.OberesVerbindendesTeil1;
					//var TEST	= tmpCaMainController.topologieKlasse.SegmentStrang.ObereVerbindendeTeile.length;
					if (tmpCaMainController.topologieKlasse.SegmentStrang.ObereVerbindendeTeile.length < 1 &&
						(tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.m_Ptypid == "FDT" || tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.m_Ptypid == "ZSM"))
						tmpCaMainController.topologieKlasse.SegmentStrang.ObereVerbindendeTeile = oClone.SegmentStrang.ObereVerbindendeTeile;
					//
					if ((curPanel == '') || (curPanel == {}) || (curPanel == '{}') || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
						break;
					if (typeof curPanel === 'string')
						curPanel = JSON.parse(curPanel);
					if ((curPanel.id == 'lager.auswahl_standard') || (curPanel.id == 'uebersicht_lastkette'))
						aHistory.push(curPanel);
				}
				break;
			}
		}
		if (aHistory[aHistory.length-1].id != 'uebersicht_lastkette')
			aHistory.push({ id: 'uebersicht_lastkette',
							title: 'uebersicht_lastkette' });
		// ------------------
		
		return;
	},

	createTopoStuetzend : function(tmpCaMainController, oFinData, oResultLogItem, aHistory) {
		
		/*  Wichtige bereits verfügbare Infos aus der Oberklasse sind hier:
				tmpCaMainController.topologieKlasse.bDoppelt	=> handelt es sich um eine doppelte LK (horizontal oder vertikal)?
				tmpCaMainController.topologieKlasse.bVertikal	=> Ist der Rohrverlauf vertikal?
			Gefüllt werden müssen folgende Infos aus der Topologieklasse:
				this.Haenger        = null;
				this.Schelle        = null;     // Hier ist das Lager bei Einzel, die Schelle bei Doppelt belegt!
				this.Zwischenstueck = null;
				this.bLager 		= false;
				this.TopoLager2 	= null;		// Für das Lager auf der EINZELNEN Stütze 

		*/

		var len = oFinData.partslist.aPartslist.length;
		for (var j = 0; j < len; j++) {
			var oPart = oFinData.partslist.aPartslist[j];
			// -------------------------------------------------------------------------------------------------------
			// Prüfen ob das rohrumschliessende Bauteil den Einsatzbedingungen entspricht
			// wenn nicht ändern und den User informieren
			if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle') || (oPart.Klasse == 'Lager2')){
				var CheckPart	= this.CheckPart(oPart, tmpCaMainController, oResultLogItem);
				oPart.typ		= CheckPart.oPart.typ;
				CheckPart.eFIN_Message.toStorage("TEMP.DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
			// -------------------------------------------------------------------------------------------------------
			
			if (oPart.Basetype == 'ZMM')	// die werden nachher automatisch angelegt
				continue;	
			
			// Der Typsuche-Manager löscht alles unter DLGDATA ... 
			var typManager = new CaTypsucheManager(tmpCaMainController);
			var oParseResult = typManager.createProductFromTyp(oPart.typ);	
			if (oParseResult.msg != '') {
				oResultLogItem.nResult = -2;
				oResultLogItem.strMessage += oParseResult.msg;
				return;
			}
			// oParseResult.oProduct enthält jetzt das erzeugte Produkt, das an die richtige Stelle der Topologie sortiert werden muss ...
			if (oPart.Klasse == 'Lager2') {
				// Sonderfall: Hier muss nochmal eine eigene Topo-Klasse erzeugt werden !!
				setstring("strSelRadioLager", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik", (oParseResult.oProduct.m_Ptypid == "LSL" ? "LAGER_SSG" : "LAGER_EPG"));
				setstring("strSelRadioFunction", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", "LOSE");
				tmpCaMainController.topologieKlasse.TopoLager2 = new CaTopoLager2 ( tmpCaMainController.topologieKlasse.dataAccess, tmpCaMainController.topologieKlasse.presets );
				tmpCaMainController.topologieKlasse.TopoLager2.Lager = oParseResult.oProduct;		
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession = new LagerObject();
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.AuswahlStandard.strSelRadioFunction = "LOSE";
				Base.applyValues(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.SollwerteRohrUmTeil,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil" ));
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.SollwerteHalterungspunkt = Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt" );
				Base.applyValues(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.Systemcharakteristik,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik" ));
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.bLastKettePathSelection = true;
				tmpCaMainController.topologieKlasse.bLager = true;
				/*
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession	= tmpCaMainController.topologieKlasse.TopoLager2.Lager.oDlgLagerSession;
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.bLastKettePathSelection = true;
				tmpCaMainController.topologieKlasse.bLager = true;
				*/
				Lager.Search.TestAndModify_Gleitlager(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession,tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData, "eFIN");
				tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager = tmpCaMainController.topologieKlasse.TopoLager2.Lager.oData;
			}
			else if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle'))
				tmpCaMainController.topologieKlasse.Schelle = oParseResult.oProduct;		
			else if ((oPart.Klasse == 'Federhaenger') || (oPart.Klasse == 'Konstanthaenger')) {
				tmpCaMainController.topologieKlasse.Haenger = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.a_lgv = oParseResult.oProduct.lgv;
			}
			else if (oPart.Klasse == 'Zubehoer') {
				// Prüfen ob das hier wirklich ein Zwischenstück ist ...
				if ((oPart.Basetype == 'ZZF') || (oPart.Basetype == 'ZZK'))
					tmpCaMainController.topologieKlasse.Zwischenstueck = oParseResult.oProduct;	
			}
		}

		/* Dialoghistory aufbauen ...
		*/
		var oClone   = null;
		var curPanel = { id: 'systemcharakteristik',
						 title: 'systemcharakteristik' };
		aHistory.push(curPanel);

		for (var i=0;i < 10; ++i) {
			oClone = Base.deepClone(tmpCaMainController.topologieKlasse);
			// curPanel.id = replace(curPanel.id, 'lager.', '');
			var strCurPanel = oClone.getNextPanel(curPanel.id);
			if (strCurPanel == '{}')
				break;
			curPanel = JSON.parse(strCurPanel);
			if ((curPanel == '') || (curPanel == {}) || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
				break;
				
			aHistory.push(curPanel);

			// Bei einem Lager müssen wir in Controller.Lager.Common.getNextClientPanel() verzweigen:
			if (curPanel.id == 'lager.sollwerte_rohrumschliessendesteil') {
				for (var j=0; j < 10; ++j) {
					curPanel = Controller.Lager.Common.getNextClientPanel(tmpCaMainController.topologieKlasse.TopoLager2.oDlgLagerSession, curPanel.id, tmpCaMainController);
					if ((curPanel == '') || (curPanel == {}) || (curPanel == '{}') || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
						break;
					if (typeof curPanel === 'string')
						curPanel = JSON.parse(curPanel);
					if ((curPanel.id == 'lager.auswahl_standard') || (curPanel.id == 'uebersicht_lastkette'))
						aHistory.push(curPanel);
				}
				break;
			}
		}
		if (aHistory[aHistory.length-1].id != 'uebersicht_lastkette')
			aHistory.push({ id:		'uebersicht_lastkette',
							title:	'uebersicht_lastkette' });
		
		return;
	},

	createTopoGelenk : function(tmpCaMainController, oFinData, oResultLogItem, aHistory) {
		
		/*  Gefüllt werden müssen folgende Infos aus der Topologieklasse:
				this.Haenger        // das Gelenk, also FSG (Gelenkstütze) oder SSG (Gelenkstrebe) oder SSB (Stossbremse)
				this.Schelle        // MSN oder MSL
				this.Bock1          // MBS/MBW zur Schelle hin
				this.Bock2          // MBS/MBW auf der anderen Seite
				this.Verlaengerung	// Verlängerung für Stoßbremsen

		*/

		var len = oFinData.partslist.aPartslist.length;
		var bHaengerDurchlaufen	= false;
		for (var j = 0; j < len; j++) {
			var oPart = oFinData.partslist.aPartslist[j];
			// -------------------------------------------------------------------------------------------------------
			// Prüfen ob das rohrumschliessende Bauteil den Einsatzbedingungen entspricht
			// wenn nicht ändern und den User informieren
			if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle') || (oPart.Klasse == 'Lager2')){
				var CheckPart	= this.CheckPart(oPart, tmpCaMainController, oResultLogItem);
				oPart.typ		= CheckPart.oPart.typ;
				CheckPart.eFIN_Message.toStorage("TEMP.DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
			// -------------------------------------------------------------------------------------------------------
			
			//if (oPart.Basetype == 'ZMM')	// die werden nachher automatisch angelegt
			if (oPart.Basetype == 'ZMM' || oPart.Basetype == 'SONDER')
				continue;	

			var bZusammgengefasst	= false;
			if ((tmpCaMainController.topologieKlasse.bDoppelt && oPart.anz * 1 > 2) ||
				(!tmpCaMainController.topologieKlasse.bDoppelt && oPart.anz * 1 >= 2))
				bZusammgengefasst	= true;
			
			// Der Typsuche-Manager löscht alles unter DLGDATA ... 
			var typManager = new CaTypsucheManager(tmpCaMainController);
			var oParseResult = typManager.createProductFromTyp(oPart.typ, bHaengerDurchlaufen);	
			if (oParseResult.msg != '') {
				oResultLogItem.nResult = -2;
				oResultLogItem.strMessage += oParseResult.msg;
				return;
			}
			// oParseResult.oProduct enthält jetzt das erzeugte Produkt, das an die richtige Stelle der Topologie sortiert werden muss ...
			if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle')) {
				tmpCaMainController.topologieKlasse.Schelle = oParseResult.oProduct;		
				if (tmpCaMainController.topologieKlasse.bHaengend)
					tmpCaMainController.topologieKlasse.Schelle.m_Pcpartid = "IDL_C_" + tmpCaMainController.topologieKlasse.Schelle.m_Ptypid + "_U";
				else
					tmpCaMainController.topologieKlasse.Schelle.m_Pcpartid = "IDL_C_" + tmpCaMainController.topologieKlasse.Schelle.m_Ptypid + "_O";
			}
			else if ((oPart.Klasse == 'Federhaenger') || (oPart.Klasse == 'Konstanthaenger')) {
				bHaengerDurchlaufen	= true;
				tmpCaMainController.topologieKlasse.Haenger = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.a_lgv = oParseResult.oProduct.lgv;
			}
			else if (oPart.Klasse == 'Zubehoer') {
				if ((oPart.Basetype == 'MBS') || (oPart.Basetype == 'MBW')) {
					if (bZusammgengefasst){
						tmpCaMainController.topologieKlasse.Bock1 = oParseResult.oProduct;	
						//tmpCaMainController.topologieKlasse.Bock1.m_Pcpartid = "IDL_C_MBS_U";
						tmpCaMainController.topologieKlasse.Bock2 = oParseResult.oProduct;	
						//tmpCaMainController.topologieKlasse.Bock2.m_Pcpartid = "IDL_C_MBS_O";
					}
					else if (!bHaengerDurchlaufen)
						tmpCaMainController.topologieKlasse.Bock2 = oParseResult.oProduct;
					else
						tmpCaMainController.topologieKlasse.Bock1 = oParseResult.oProduct;
				}
				else {
					// @@@ TODO: prüfen ob das hier wirklich eine Verlängerung ist ... was für ein Typ ist denn die Verlängerung überhaupt ?????
					tmpCaMainController.topologieKlasse.Verlaengerung = oParseResult.oProduct;	
				}
			}
		}

		/* Dialoghistory aufbauen ...
		*/
		var oClone   = null;
		var curPanel = { id: 'systemcharakteristik',
						 title: 'systemcharakteristik' };
		aHistory.push(curPanel);

		for (var i=0;i < 10; ++i) {
			oClone = Base.deepClone(tmpCaMainController.topologieKlasse);
			// curPanel.id = replace(curPanel.id, 'lager.', '');
			var strCurPanel = oClone.getNextPanel(curPanel.id);
			// bei "Sprung" auf Übersicht LK wird das Systemmass berechnet -> Infos liegen aber auf dem CLONE
			if (curPanel.id == "auswahl_bock2"){
				if (!tmpCaMainController.topologieKlasse.bFSG){	// E-Mass wir bei Nachrechnung neu bestimmt
					tmpCaMainController.topologieKlasse.Haenger = oClone.Haenger;
					if (tmpCaMainController.topologieKlasse.bSSB)
						tmpCaMainController.topologieKlasse.Verlaengerung = oClone.Verlaengerung;
				}
			}
			if (strCurPanel == '{}')
				break;
			curPanel = JSON.parse(strCurPanel);
			if ((curPanel == '') || (curPanel == {}) || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
				break;
				
			aHistory.push(curPanel);
		}
		aHistory.push({ id: 'uebersicht_lastkette',
						title: 'uebersicht_lastkette' });
		// ------------------
		
		return;
	},

	createTopoLager2 : function(tmpCaMainController, oFinData, oResultLogItem, aHistory) {
		
		/*  Wichtige bereits verfügbare Infos aus der Oberklasse sind hier:
			this.Lager			 
			this.Klemmsystem     
			this.Abhebesicherung // sowohl für Gleitlager als auch Rollenlager
			this.Gleitelement    
			this.Rollenlager	 
			this.Sattel	 		 
		*/

		var len = oFinData.partslist.aPartslist.length;
		
		if (len > 0){
			tmpCaMainController.topologieKlasse.oDlgLagerSession = new LagerObject();
			Base.applyValues(tmpCaMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil" ));
			//Base.applyValues(tmpCaMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt" ));
			tmpCaMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt = Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt" );
			Base.applyValues(tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik,Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik" ));
		}
		
		for (var j = 0; j < len; j++) {
			var oPart = oFinData.partslist.aPartslist[j];
			
			// -------------------------------------------------------------------------------------------------------
			// Prüfen ob das rohrumschliessende Bauteil den Einsatzbedingungen entspricht
			// wenn nicht ändern und den User informieren
			if (oPart.Klasse == "Lager2"){
				var CheckPart	= this.CheckPart(oPart, tmpCaMainController, oResultLogItem);
				oPart.typ		= CheckPart.oPart.typ;
				CheckPart.eFIN_Message.toStorage("TEMP.DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
			// -------------------------------------------------------------------------------------------------------
			
			// Der Typsuche-Manager löscht alles unter DLGDATA ... 
			var typManager = new CaTypsucheManager(tmpCaMainController);
			var oParseResult = typManager.createProductFromTyp(oPart.typ);	
			
			if (oParseResult.msg != '') {
				oResultLogItem.nResult = -2;
				oResultLogItem.strMessage += oParseResult.msg;
				return;
			}
			
			// oParseResult.oProduct enthält jetzt das erzeugte Produkt, das an die richtige Stelle der Topologie sortiert werden muss ...
			// @@@@@@@ Wir wissen noch nicht genau, wo der ganze Krempel hier hinkommt ....
			tmpCaMainController.topologieKlasse.oDlgLagerSession.bLastKettePathSelection = false;
			if (oPart.Klasse == 'Lager2') {
				tmpCaMainController.topologieKlasse.Lager = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel = Oberflaechenschutz[oParseResult.oProduct.m_Poberfl];
				tmpCaMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff = WerknamenDB[WerkstoffeNrZuNamen[oParseResult.oProduct.oData.WERKSTOFF]];
				
				var LG_GrundTyp	= left(oParseResult.oProduct.oData.TYP, 3);
				switch (LG_GrundTyp){	// Festlager sind automatisch vorbelegt
					case "LKL"	:
					case "IKL"	:
					case "LVL"	:
					case "LKF"	:
					case "LKG"	:
						tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioLager = "LAGER_SPG";
						break;
					case "LSL"	:
					case "LVS"	:
					case "LSF"	:
						tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioLager = "LAGER_SSG";
						break;
					case "LXL"	:
					case "LXF"	:
						tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioLager = "LAGER_EPG";
						break;
					default		:
						break;
				}
				
				if (left(LG_GrundTyp, 2) == "LV")	// LVL oder LVS
					tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.bHoehenverstellbar = 1;
				
				// Festlager "KLEMMBAR"
				if ((tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && left(LG_GrundTyp, 2) != "FS") ||
					oParseResult.oProduct.strBauF * 1 == 10){
					// GL Typ 10
					if (oParseResult.oProduct.strBauF * 1 == 10 && oParseResult.oProduct.strBaureihe != "FLN")
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.bGaT = 1;
					var strTypNr		= splitVarDelimiter(oParseResult.oProduct.m_Ptyp, " ..--.");
					var strTypNr_UL		= splitVarDelimiter(right(strTypNr[4],strTypNr[4].length - 1), "x");
					var BeamBaseType	= left(strTypNr[4], 1);
					var ProfilZusatz	= "_PROFIL";
					if (BeamBaseType == "L")
						ProfilZusatz	+= (strTypNr_UL[0]*1 == strTypNr_UL[1] ? "_G" : "_U");
					if (BeamBaseType == "T" && right(strTypNr[4],strTypNr[4].length - 1) * 1 > 140){	// T-Profile nur bis Btr=140mm
						BeamBaseType	= "HEB";
						ProfilZusatz	= "";
					}
					tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = BeamBaseType + ProfilZusatz;
					if (BeamBaseType == "T" || BeamBaseType == "HEB"){
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strTypNr_UL[0];
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamHeight = strTypNr_UL[0];
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamWidth = strTypNr_UL[0];
					}
					else if (BeamBaseType == "U"){
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strTypNr_UL[1];
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamHeight = strTypNr_UL[1];
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamWidth = strTypNr_UL[0];
					}
					else{	// L-Profile
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strTypNr_UL[0]*1 + "x" + strTypNr_UL[1]*1 + "x" + ceil(strTypNr_UL[0]*1/10);
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamHeight = strTypNr_UL[1];
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamWidth = strTypNr_UL[0];
					}
				}
				
				if (tmpCaMainController.topologieKlasse.oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS"){ // Festlager sind automatisch vorbelegt
					
					if (left(LG_GrundTyp, 2) == "FS"){	// FSN oder FSD
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFixed = "SCHRAUBBAR";
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "-";
						if (LG_GrundTyp == "FSD")
							tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = "DOPPELT";
					}
					
					if (LG_GrundTyp == "FVN")	// FVN
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.bHoehenverstellbar = 1;
					
					Lager.Search.TestAndModify_Festlager(tmpCaMainController.topologieKlasse.oDlgLagerSession,tmpCaMainController.topologieKlasse.Lager.oData, "", "eFIN");
				}
				else{
					if (!tmpCaMainController.topologieKlasse.Klemmsystem && oParseResult.oProduct.strBauF * 1 != 10){
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "-";
						tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFunction = "LOSE";
					}
					
					Lager.Search.TestAndModify_Gleitlager(tmpCaMainController.topologieKlasse.oDlgLagerSession,tmpCaMainController.topologieKlasse.Lager.oData, "eFIN");
				}
				
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager = tmpCaMainController.topologieKlasse.Lager.oData;
			}
			else if (oPart.Klasse == 'Klemmsystem2') {
				tmpCaMainController.topologieKlasse.Klemmsystem = oParseResult.oProduct;
				if (oParseResult.oProduct.oData.BAU_F*1 == 40){	// Klemmsysteme der Baureihe 40
					tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.bGaT = 1;
					tmpCaMainController.topologieKlasse.oDlgLagerSession.Klemmsystem.bGaT = 1;
				}
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultKlemmsystem = tmpCaMainController.topologieKlasse.Klemmsystem.oData;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = oParseResult.oProduct.strProfilart;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = oParseResult.oProduct.strTraegerbreite;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamHeight = oParseResult.oProduct.strTraegerhoehe;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamThickness = oParseResult.oProduct.strFlanschdicke;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.dBeamWidth = oParseResult.oProduct.strTraegerbreite;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "KLEMMBAR";
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFunction = "GEFUEHRT";
				tmpCaMainController.topologieKlasse.oDlgLagerSession.Klemmsystem.oSearchResult.oResultKlemmsystem = tmpCaMainController.topologieKlasse.Klemmsystem.oData;
			}
			else if (oPart.Klasse == 'Abhebesicherung2') {
				tmpCaMainController.topologieKlasse.Abhebesicherung = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.Abhebesicherung.m_qty = oPart.anz * 2;	// die Stückzahl aus PDMS stimmt nicht
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "AHS";
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelRadioFunction = "GEFUEHRT";
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung = tmpCaMainController.topologieKlasse.Abhebesicherung.oData;
			}
			else if (oPart.Klasse == 'Gleitelement2') {
				tmpCaMainController.topologieKlasse.Gleitelement = oParseResult.oProduct;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement = tmpCaMainController.topologieKlasse.Gleitelement.oData;
				tmpCaMainController.topologieKlasse.oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "GLEITELEMENT";
			}
			/* ???
			Abhebesicherung
			Rollenlager
			Sattel	 
			*/
		}
			
		//tmpCaMainController.topologieKlasse.oDlgLagerSession	= tmpCaMainController.topologieKlasse.Lager.oDlgLagerSession;
		//Base.applyValues (tmpCaMainController.topologieKlasse.oDlgLagerSession, Object.fromStorage("DLGDATA.CA.FINDATA.oDlgLagerSession_FIN"));
		
		/* Dialoghistory aufbauen ...
		*/
		var oClone   = null;
		var curPanel = { id: 'lager.systemcharakteristik',
						 title: 'lager.systemcharakteristik' };
		aHistory.push(curPanel);
		
		oClone = Base.deepClone(tmpCaMainController);
		
		for (var j=0; j < 10; ++j) {
			//oClone = Base.deepClone(tmpCaMainController);
			//curPanel = Controller.Lager.Common.getNextClientPanel(tmpCaMainController.topologieKlasse.oDlgLagerSession, curPanel.id, tmpCaMainController);
			curPanel = Controller.Lager.Common.getNextClientPanel(oClone.topologieKlasse.oDlgLagerSession, curPanel.id, oClone);
			if ((curPanel == '') || (curPanel == {}) || (curPanel == '{}') || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
				break;
			if (typeof curPanel === 'string')
				curPanel = JSON.parse(curPanel);
			aHistory.push(curPanel);
		}
		
		aHistory.push({ id: 'uebersicht_lastkette',
							 title: 'uebersicht_lastkette' });
		
		for (var j=0; j < aHistory.length; j++) {
			tmpCaMainController.topologieKlasse.oDlgLagerSession.DialogHistoryIDs[j] = aHistory[j].id;
		}
		//tmpCaMainController.topologieKlasse	= oClone;
		return;
	},
	
	createTopoEinzel : function(tmpCaMainController, oFinData, oResultLogItem, aHistory) {
		// TODO wenn Änderungen an PDMS-Schnittstelle
		// Einzelprodukte (abgesehen von Lagern "createTopoLager2") sind derzeit nicht vorgesehen
		// derzeit landen wir nur hier bei Sondereinzelprodukt mit Stahlbau (z.B. STAUFF-Schelle mit Stahlbau)
		var bEinzelprodukt	= true;
		for (var i=0; i < oFinData.partslist.aPartslist.length; i++) {
		//if (oFinData.partslist.aPartslist.length > 1)
		//	bEinzelprodukt	= false;
		//else{
			var oPart = oFinData.partslist.aPartslist[i];
			// -------------------------------------------------------------------------------------------------------
			// Prüfen ob das rohrumschliessende Bauteil den Einsatzbedingungen entspricht
			// wenn nicht ändern und den User informieren
			if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle') || (oPart.Klasse == 'Lager2')){
				var CheckPart	= this.CheckPart(oPart, tmpCaMainController, oResultLogItem);
				oPart.typ		= CheckPart.oPart.typ;
				CheckPart.eFIN_Message.toStorage("TEMP.DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
			// -------------------------------------------------------------------------------------------------------
			
			// Der Typsuche-Manager löscht alles unter DLGDATA ... 
			var typManager = new CaTypsucheManager(tmpCaMainController);
			var oParseResult = typManager.createProductFromTyp(oPart.typ);
			
			// vorerst als "normales" Sonderteil behandeln
			if (oParseResult.msg == '') {	// Einzelprodukte -> WITZENMANN Standard
				if ((oPart.Klasse == 'Horizontalschelle') || (oPart.Klasse == 'Vertikalschelle') || (oPart.Klasse == 'Lager2'))
					tmpCaMainController.topologieKlasse.Schelle		= oParseResult.oProduct;
				else
					tmpCaMainController.topologieKlasse.Zubehoer	= oParseResult.oProduct;
				bEinzelprodukt	= false;	// das kann noch ergänzt werden
			}
		//}
		
			if (bEinzelprodukt) {
				// Lastketten die nur aus Sonderteilen bestehen laufen über einzelnes Zubehör "ohne"
				// tmpCaMainController.topologieKlasse.Zubehoer	= new Zubehoer();
				// neues Sonderteil für die LK
				var Sonderteil	= this.createSonderteil(tmpCaMainController, oFinData, oResultLogItem, i);
				// Sonderteil in die Lastkette -> das ist nicht der Stahlbau (der wird später hinzu gefügt)
				tmpCaMainController.topologieKlasse.Sonderteile.push(Sonderteil);
			}
		}
		// Dialoghistory aufbauen ...
		var oClone   = null;
		var curPanel = { id: 'systemcharakteristik',
						 title: 'systemcharakteristik' };
		aHistory.push(curPanel);

		for (var i=0;i < 10; ++i) {
			oClone = Base.deepClone(tmpCaMainController.topologieKlasse);
			var strCurPanel = oClone.getNextPanel(curPanel.id);
			if (strCurPanel == '{}')
				break;
			curPanel = JSON.parse(strCurPanel);
			if ((curPanel == '') || (curPanel == {}) || !curPanel || (curPanel.id == 'uebersicht_lastkette'))
				break;
				
			aHistory.push(curPanel);
		}
		aHistory.push({ id: 'uebersicht_lastkette',
						title: 'uebersicht_lastkette' });
		// ------------------
		/*
		}
		else {
			oResultLogItem.nResult = 0;
			oResultLogItem.strMessage = 'Single systems cannot be analyzed and will be skipped!';
			aResultLog.push(oResultLogItem);
		}
		*/
		return;
	},
	
	createFreiePosition : function(tmpCaMainController, oFinData, oResultLogItem) {
		//var FreiePosition	= new Sonderteil();
		var FP	= {	FP_ASSI_GROUP			: 'IDC_FP_NO_ASSI',
					FREI_NUMMER				: oFinData.partslist.aPartslist[0].matnr,
					//FREI_PREIS				: '',
					FREI_PREIS				: (!oFinData.addinfo.priceperpiece ? '' : oFinData.addinfo.priceperpiece),
					//FREI_PREIS_EURO			: '',
					FREI_PREIS_EURO			: (!oFinData.addinfo.priceperpiece ? '' : oFinData.addinfo.priceperpiece),
					FREI_TYP				: oFinData.partslist.aPartslist[0].typ,
					//GEWICHT					: '',
					GEWICHT					: (!oFinData.addinfo.weightperpiece ? '' : oFinData.addinfo.weightperpiece),
					IDC_OBFLSCHUTZ_COMBO	: 'OB_ROH',
					IDC_OBFLSCHUTZ_EDIT		: '',
					IDC_ROHMASSPOS			: '0',
					MARKIERUNG				: oFinData.assembly.name,
					RH_TYP					: 'FP_LS',
					ZEICHNUNGSNR			: oFinData.assembly.drawing,
					QTY						: (!oFinData.assembly.qty ? oFinData.partslist.aPartslist[0].anz : oFinData.assembly.qty)
				  };
		
		return (FP);
	},
	
	createSonderteil : function (tmpCaMainController, oFinData, oResultLogItem, Pos) {
		if (!Pos)
			Pos = 0;
		var Sonderteil			= new Sonderteil;
		Sonderteil.m_Pemass		= fround(abs(oFinData.caddata.aCaddata[Pos].emass), 0);
		Sonderteil.m_PIdentNr	= oFinData.partslist.aPartslist[Pos].matnr;
		Sonderteil.m_Ptyp		= oFinData.partslist.aPartslist[Pos].typ;
		//Sonderteil.m_Ptypid		= oFinData.partslist.aPartslist[Pos].Basetype;
		Sonderteil.m_Ptypid		= "SON";
		//Sonderteil.m_Pzeichnr	= oFinData.assembly.drawing;	// Spalte Bemerkung
		Sonderteil.m_Pzeichnr	= "SONDERTEIL";
		Sonderteil.nAnzahl		= oFinData.partslist.aPartslist[Pos].anz;
		Sonderteil.Typ			= oFinData.partslist.aPartslist[Pos].typ;
		Sonderteil.WIMatnr		= oFinData.partslist.aPartslist[Pos].matnr;
		// wenn der Text zu lang ist (und ohne Leerzeichen), landen wir bei der Zeichnungsgenerierung in eine Endlosschleife
		// wir fügen ein paar Leerzeichen ein um das zu verhindern
		var Text	= oFinData.partslist.aPartslist[Pos].typ;
		if (Text.length > 20){
			var X20			= ceil(Text.length / 20);
			var TextPart	= left(Text, 20);
			var TmpTxt		= '';
			for (var i=1; i<=X20; i++){
				TmpTxt		+= TextPart + (i != X20 ? Leer : "");
				TextPart	= right(Text, Text.length - i*20);
				TextPart	= (TextPart.length <= 20 ? TextPart : left(TextPart, 20));
			}
			Sonderteil.Artikeltext.push(TmpTxt);
		}
		else
			Sonderteil.Artikeltext.push(oFinData.partslist.aPartslist[Pos].typ);
		Sonderteil.RHTyp		= "FP_ZU";
		/*
			['FP_LS', '$Lager/Schelle$'],
			['FP_HS', '$Haenger/Stuetze$'],
			['FP_ZU', '$Zubehoer$'],
			['FP_ST', '$Stahlbau$']
		*/
		return (Sonderteil);
	},
	
	CheckPart : function (oPart, tmpCaMainController, oResultLogItem) {
		// -------------------------------------------------------------------------------------------------------
		// Prüfen ob das Bauteil den Einsatzbedingungen entspricht
		// wenn nicht ändern, neu suchen und den User informieren
		// wir suchen den Werkstoff den das Bauteil aussagt
		var message				= "";
		var TEMPtypManager		= new CaTypsucheManager(tmpCaMainController);
		var TEMPoParseResult	= TEMPtypManager.createProductFromTyp(oPart.typ);
		if (oPart.Klasse == "Lager2")
			var WerkstoffSoll		= TEMPoParseResult.oProduct.m_Pwerkname;
		else
			var WerkstoffSoll		= Werknamen[TEMPoParseResult.oProduct.m_Pwerkstoff];
		setstring("WerkstoffRuT", "DLGDATA.CA.FINDATA.eFIN_Message", WerkstoffSoll);
		var AuslegTemp		= max(atoi(getstring("TemperaturPIPE", "DLGDATA.CA.FINDATA.eFIN_Message")), atoi(getstring("TemperaturREST", "DLGDATA.CA.FINDATA.eFIN_Message")));
		var RefTemp			= AuslegTemp;
		if (AuslegTemp >= 40 && AuslegTemp <= 320)
			RefTemp	-= 20;
		//var AuslegWerk_LG	= Lager.RohrumschliessendesTeil.getBasicMaterial(AuslegTemp);
		var AuslegWerk	= tmpCaMainController.getPassendeWerkstoffe(AuslegTemp, RefTemp, WerkstoffSoll);
		var RenameTypeWst	= false;
		setstring("WerkstoffSelected", "DLGDATA.CA.FINDATA.eFIN_Message", WerkstoffSoll);
		setstring("Werkstoffvergleich", "DLGDATA.CA.FINDATA.eFIN_Message", "true");
		var SelMatNr	= Werkstoffe[WerknamenDB[WerkstoffSoll]];
		var RenameTypeDmr	= false;
		// Werkstoff prüfen
		for (var wst=0; wst<AuslegWerk.aDisabled.length; wst++){
			// Achtung - wenn die Temp. nicht gesetzt ist dürfen wir den Werkstoff NICHT ändern!!
			// Bsp.: RefTemp = 80 aber Lager 16Mo3 ... bedeutet die Infos aus PDMS nicht korrekt/passen nicht zusammen
			// wir nehmen den höherwertigen Werkstoff!
			if ((AuslegWerk.aDisabled[wst] == WerkstoffSoll) && (RefTemp >= 300)){
				setstring("WerkstoffSelected", "DLGDATA.CA.FINDATA.eFIN_Message", AuslegWerk.strRecommended);
				setstring("Werkstoffvergleich", "DLGDATA.CA.FINDATA.eFIN_Message", "false");
				SelMatNr	= Werkstoffe[WerknamenDB[AuslegWerk.strRecommended]];
				RenameTypeWst	= true;
			}
			else if ((AuslegWerk.aDisabled[wst] == WerkstoffSoll)){
				oResultLogItem.nResult		= -1;
				oResultLogItem.strMessage	+= "given temperature from pipe/clamp (" + RefTemp + ")\n"
												+ "don't fit to the specified clamp material " + WerkstoffSoll + "\n";
			}
		}
		// den Werkstoff setzen
		setstring("IDC_WERKSTOFF", "TEMP.DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", WerkstoffeNrZuNamen[SelMatNr]);
		setstring("strSelRadioWerkstoff", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil", "LAGER_" + WerknamenDB[WerkstoffeNrZuNamen[SelMatNr]]);
		//setstring("strSelRadioWerkstoff", "TEMP.DLGDATA.CA.LAGER2DATA.SollwerteRohrUmTeil", "LAGER_" + WerknamenDB[WerkstoffeNrZuNamen[SelMatNr]]);
		
		// Nennweite prüfen
		setstring("Aussendurchmesservergleich", "DLGDATA.CA.FINDATA.eFIN_Message", "true");
		var SelDmr	= getstring("AussendurchmesserPIPE", "DLGDATA.CA.FINDATA.eFIN_Message")*1;
		if (oPart.Klasse == "Lager2"){
			setstring("AussendurchmesserRuT", "DLGDATA.CA.FINDATA.eFIN_Message", TEMPoParseResult.oProduct.oData.D);
			if (SelDmr != TEMPoParseResult.oProduct.oData.D*1){	// das gilt nur für Lager
				//ParseAgainDmr	= true;
				RenameTypeDmr	= true;
				setstring("Aussendurchmesservergleich", "DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
		}
		else{
			setstring("AussendurchmesserRuT", "DLGDATA.CA.FINDATA.eFIN_Message", TEMPoParseResult.oProduct.m_dSonderNennweite);
			if (SelDmr != TEMPoParseResult.oProduct.m_dSonderNennweite){
				//ParseAgainDmr	= true;
				RenameTypeDmr	= true;
				setstring("Aussendurchmesservergleich", "DLGDATA.CA.FINDATA.eFIN_Message", "false");
			}
		}
		// noch prüfen ob die Temp. identisch war
		if ( getstring("Temperaturvergleich", "DLGDATA.CA.FINDATA.eFIN_Message") == "false"){
			// Setzen der Warnung
			oResultLogItem.nResult		= -1;
			TemperaturePipe				= getstring("TemperaturPIPE", "DLGDATA.CA.FINDATA.eFIN_Message")*1;
			TemperatureClamp			= getstring("TemperaturREST", "DLGDATA.CA.FINDATA.eFIN_Message")*1;
			TemperatureSelected			= max(TemperaturePipe, TemperatureClamp);
			oResultLogItem.strMessage	+= "temperature pipe: " + TemperaturePipe + "\n"
											+ "temperature clamp: " + TemperatureClamp + "\n"
											+ "design temperature: " + TemperatureSelected + "\n";
		}
		// ggf. neu suchen
		if (RenameTypeWst || RenameTypeDmr){
			// Setzen der Warnung
			oResultLogItem.nResult		= -1;
			oResultLogItem.strMessage	+= (RenameTypeWst ? "material eFIN: " + WerkstoffSoll + "\nmaterial selected: " + AuslegWerk.strRecommended + "\n" : "")
											+ (RenameTypeDmr ? "diameter clamp eFIN: " + getstring("AussendurchmesserRuT", "DLGDATA.CA.FINDATA.eFIN_Message") + "\ndiameter pipe (eFIN) selected: " + getstring("AussendurchmesserRuT", "DLGDATA.CA.FINDATA.eFIN_Message") + "\n" : "");
			// Typ manipulieren
			// Werkstoff neu setzen
			var TempTyp	= oPart.typ.split("-");
			oPart.typ	= "";
			if (TempTyp.length == 1)	// kein "-" da
				TempTyp[TempTyp.length-1]	+= "-" + SelMatNr;
			//else if (TempTyp.length == 2){
			else{
			// der letzte Teil ist entweder der Werkstoff mit oder ohne Oberfläche
			// oder "S 21.0040.140" von "LSL-S 21.0040.140"
				if (TempTyp[TempTyp.length-1].length <= 4){ // Fall Werkstoff oder "Txxx"
					if (rfind(TempTyp[TempTyp.length-1], ".") > (-1))
						TempTyp[TempTyp.length-1]	= SelMatNr + right(TempTyp[TempTyp.length-1], 2);
					else if (rfind(TempTyp[TempTyp.length-1], "T") > (-1))
						TempTyp[TempTyp.length-1]	+= "-" + SelMatNr;
					else
						TempTyp[TempTyp.length-1]	= SelMatNr;
				}
				else
					TempTyp[TempTyp.length-1]	+= "-" + SelMatNr;
			}
			/*
			else{	// der letzte Teil ist der Werkstoff
				TempTyp[TempTyp.length-1]	= SelMatNr;
			}
			*/
			for (var parse = 0; parse<TempTyp.length; parse++){
				oPart.typ	+= TempTyp[parse] + "-"
			}
			oPart.typ	= trimright(oPart.typ, "-");
			// Nennweite neu setzen
			TempTyp		= oPart.typ.split(" ");
			oPart.typ	= TempTyp[0] + " ";
			TempTyp		= TempTyp[1].split(".");
			var DNPos	= (oPart.Klasse == "Lager2" ? 1 : 0);
			if (getstring("isAussenDmrSonder", "DLGDATA.CA.FINDATA.eFIN_Message") == "true"){
				oPart.typ		= replace(Part1, " ", "-S ");
				TempTyp[DNPos]	= (SelDmr < 1000 ? "0" : "") + (SelDmr < 100 ? "0" : "") + fround(SelDmr, 0);
			}
			else{
				var NW			= getstring("NennweitePIPE", "DLGDATA.CA.FINDATA.eFIN_Message")*1;
				TempTyp[DNPos]	= (NW < 1000 ? "0" : "") + (NW < 100 ? "0" : "") + NW;
			}
			for (var parse = 0; parse<TempTyp.length; parse++){
				oPart.typ	+= TempTyp[parse] + "."
			}
			oPart.typ	= trimright(oPart.typ, ".");
		}
		// -------------------------------------------------------------------------------------------------------
			
		return ({oPart : oPart, message : message, eFIN_Message : Object.fromStorage("DLGDATA.CA.FINDATA.eFIN_Message")});
	}
	
}