﻿/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007-2008 Plan Software GmbH (http://www.plansoft.de)
 */

#include "CascadeTCA.es"

CaDokManager = function(myMainController)
{
	/**
     * myMainController ... Verweis auf einen MainController
     * @var myMainController
     */
	this.myMainController = myMainController;

    // -mw- neu: Objekt, das Optionen für die Preisbildung einzelner Produkte enthält:
    this.oOptions = this.myMainController.presets.getPreisOptions();

	// übersetzen
	this.transl = {
			OK:			translate("Aktion ausgeführt !"),
			ACTION:		translate("Fehler bei dieser Aktion!"),
			ERR_NODATA:	translate("Keine Daten zur Ausgabe gefunden!"),
			ERR_NOPOS:	translate("Keine Positionen vorhanden/angekreuzt !"),
			ERR_FDEL:	translate("Ausgabedatei kann nicht gelöscht werden!"),
			ERR_FTEMPL:	translate("Template nicht gefunden oder falsches Format")+": ",
			OK_FGEN:	translate("Ausgabedatei erzeugt!")+"\n",
			SHEET_AUSL:	translate("Übersicht Auslegungen"),
			SHEET_STK:	translate("Übersicht Stückliste"),
			SHEET_MASS:	translate("Übersicht Massenauszug"),
			SHEET_HS:	replace(translate("Übersicht Hänger-Stützen"), "/", "-"),
			SHEET_SL:	replace(translate("Übersicht Schelle-Lager"), "/", "-"),
			DATUM:		translate("IDS_DATUM"),
			PROJ:		replace(translate("IDC_PROJEKT_LABEL"), ":", ""),
			KUNDE:		replace(translate("IDC_KUNDE_LABEL"), ":", ""),
			WIANG:		translate("WI-Angebotsnummer"),
			NAME:		translate("IDS_NAME"),
			REVISION:	replace(translate("IDS_REVISION"), ":", ""),
			GESSUM:		translate("IDS_LIST_GESAMT"),
			ZWSUM:		translate("IDS_LIST_TEIL"),
			WIMAT:		translate("WI-Materialnummer"),
			POS:		replace(translate("POSITION"), ".", ""),
			ANZ_POS:	translate("Anzahl Pos"),
			SL_POS:		translate("Stücklisten Pos"),
			ZGNR:		translate("ZEICHNUNGS_NR"),
			MARK:		translate("Markierung"),
			MAT:		translate("IDS_MATERIAL"),
			TYP:		translate("IDS_TYP"),
			LGV:		translate("IDS_LGV"),
			EMASS:		translate("IDS_EINBAUMASS"),
			BEM:		translate("BEMERKUNGEN"),
			ANZ:		translate("IDS_ANZAHL"),
			ANZ_GES:	translate("Gesamtanzahl"),
			BEW_R:		translate("Bewegung Richtung"),
			LAST_WEG:	translate("Last-Weg-Diagramm"),
			BLOCK:	    translate("BLOCKIERUNG"),
			GEWLEN:		translate("Gewindestangen-Gesamtlängen"),
			//FP:			translate("Freie Positionen"), IDD_FREIE_POSITION
			FP:			translate("IDD_FREIE_POSITION"),
			U_GEW_STK:	transWithUnit("Gew je Stk", "kg"),
			U_GEW_GES:	transWithUnit("Gew ges", "kg"),
			U_PR_STK:	transWithUnit("Preis je Stk", "€"),
			U_PR_GES:	transWithUnit("Preis ges", "€"),
			U_SL_HPKT:	transWithUnit("Solllast Hpkt", "kN"),
			U_BEW:		transWithUnit("BEWEGUNG", "mm"),
			U_NW:		replace(transWithUnit("NENNWEITE", "DN"), ":", ""),
			U_MTEMP:	transWithUnit("Mediumtemp", "°C"),
			U_UTEMP:	transWithUnit("Umgebungstemp", "°C"),
			U_RTEMP:	transWithUnit("Referenztemp", "°C"),
			U_SPANNW:	transWithUnit("SPANNWEITE", "mm"),
			U_DD:		transWithUnit("DAEMMDICKE", "mm"),
			U_BL:		transWithUnit("Betriebslast", "kN"),
			U_TL:		transWithUnit("Traglast", "kN"),
			U_ZL:		transWithUnit("IDS_ZUSLAST_TITEL", "kN"),
			U_WL:		transWithUnit("WARMLAST", "kN"),
			U_BLL:		transWithUnit("Blockierlast", "kN"),
			U_EMASS:	transWithUnit("IDS_EINBAUMASS", "mm"),
			U_FR:		transWithUnit("FEDERRATE", "N/mm"),
			U_LAEND:	transWithUnit("LASTAENDERUNG", "%"),
			U_LJ:		transWithUnit("IDC_LASTJUSTIERBARKEIT", "%")
		};

	this.bError = false;
	this.msgOK = this.transl.OK;
	this.msgImportTcaFile = this.transl.ACTION;

	// Ausgabe über CSV Dateien
	this.bCsvExport = false;	//true;
	this.strCsvBuffer = "";

	// Verarbeitung XML Template
	this.strTemplateFile = "projdat.xml";
	this.strTemplateHeadBuffer = "";
	this.strTemplateTailBuffer = "";
	this.strTemplateWorksheet = "";

	// eigene Styles für Listen
	//	SLC	SCC	SRC	NLC	NCC	NRC	TBK	R45	R90

	this.styles = [];

	// auszugebende Liste - Index für columns
	this.listTyp = "";

	// Spaltenbreiten der einzelnen Listen
	// die letzen 5 (Anzahl, Gewicht, Preis) immer rechtsbündig, Spaltenbreite gem. AGP !!
	this.rowHeadHeight = "70";
	this.columnDefaultWidth = "30";
	this.columnSpecialWidth = "48";

    // Excel Spalte    A   B    C    D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S
	this.columns = {
			MASS : [ 120, 30,  50,  50, 80, 80, 80, 80, 50, 50, 50, 50, 50, 70, 70, 70, 70 ],
			HAEN : [  30, 40,  60,  80, 90, 30, 30, 30, 30, 30, 30, 30, 40, 30, 30, 30, 30, 30, 70, 50 ],
			SCHE : [  30, 60, 120,  30, 50, 50, 30, 30, 35, 30, 30, 30, 70, 70, 70, 70 ],
			AUSL : [  30, 60,  60, 100, 30, 30, 30, 30, 30, 30, 35, 30, 30, 30, 70, 50, 50, 50, 50 ],
			STUE : [  30, 60,  30, 120, 30, 50, 50, 80, 80, 80, 80, 50, 50, 50, 50, 50, 70, 70, 70, 70 ],
			AGP  : [  33, 33,  33,  38, 38, 38 ],
			HAEN_LIST : [  30, 60,  60, 110, 30, 30, 30, 30, 30, 30, 30, 30, 40, 30, 70, 50, 50, 50, 50 ]
		};

	// Styles der Spalten - Index in styles
    // Excel Spalte      A      B      C      D      E      F      G      H      I      J      K      L      M      N      O      P      Q      R      S      T
	this.columnStyles = {
			MASS : [ "SLC", "SRC", "SRC", "SRC", "SLC", "SLC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC" ],
			HAEN : [ "SLC", "SLC", "SLC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC" ],
			SCHE : [ "SLC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC" ],
			AUSL : [ "SLC", "SLC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SLC", "SLC", "SRC", "SRC", "SRC" ],
			STUE : [ "SLC", "SLC", "SRC", "SLC", "SRC", "SRC", "SRC", "SLC", "SLC", "SLC", "SLC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC", "SRC" ],
			MASS_U:[ "TBK", "TBK", "R90", "R90", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK" ],
			HAEN_U:[ "TBK", "TBK", "TBK", "TBK", "TBK", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "TBK", "TBK", "TBK" ],
			SCHE_U:[ "TBK", "TBK", "TBK", "TBK", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK" ],
			AUSL_U:[ "TBK", "TBK", "TBK", "TBK", "TBK", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "R90", "TBK", "TBK", "TBK", "TBK", "TBK" ],
			STUE_U:[ "TBK", "TBK", "R90", "TBK", "TBK", "R90", "R90", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK" ],
			GEW :  [ "SLC", "SLC", "SLC", "SLC", "SLC", "SLC", "SLC", "SRC", "S2C", "SLC", "SLC" ],
			GEW_U: [ "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBK", "TBR", "T2L", "TBK", "TBK" ]
		};

	this.stueckListe = [];
	this.stueckListeFP = [];

	this.outWorksheetsName = [];
	this.outWorksheets = [];

	this.strOutFile = "";
	this.strInFile = "";

	this.aData = [];

	this.strDate;
	this.strDateZ;
	getdate('CURRENT_TIME','TEMP');
	this.strDate = getstring('DAY','TEMP.CURRENT_TIME')+"."+
			getstring('MONTH','TEMP.CURRENT_TIME')+"."+
			getstring('YEAR','TEMP.CURRENT_TIME');
	this.strDateZ = getstring('YEAR','TEMP.CURRENT_TIME')+"-"+
			right("0"+getstring('MONTH','TEMP.CURRENT_TIME'),2)+"-"+
			right("0"+getstring('DAY','TEMP.CURRENT_TIME'),2)+"T"+
			right("0"+getstring('HOUR','TEMP.CURRENT_TIME'),2)+":"+
			right("0"+getstring('MINUTE','TEMP.CURRENT_TIME'),2)+":00Z";


};


CaDokManager.prototype =
{

    setModusCsv : function(bUseCsvFiles)
    {
		this.bCsvExport = bUseCsvFiles;
    },

    writeDokFromProjectlist : function(bShowExcelFile)
    {
		this.xmlPrepareTemplateFile();
		if(this.bError == true)
			return;

		/**
		this.prepareTemplateFile();
		if(this.bError == true)
			return;
		**/
		
		var nSheet = 0;
		this.strCsvBuffer = "";

		// Stückliste von allen Positionen
		this.prepareDatenStueckliste(0);
		if(this.bError == true)
			return;

		this.listTyp = "AUSL";
		this.prepareAuslegungen(0);
		if(this.bError == false)
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_AUSL;
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}

		this.aData = [];
		this.listTyp = "STUE";
		this.prepareStueckliste(0);
		if(this.bError == false)
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_STK;
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}

		this.aData = [];
		this.listTyp = "MASS";
		this.prepareMassenauszug(0);
		if(this.bError == false)
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_MASS;
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}

		this.aData = [];
		this.listTyp = "HAEN";
		this.prepareHaenger(0)
		if(this.bError == false);
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_HS;
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}

		this.aData = [];
		this.listTyp = "SCHE";
		this.prepareSchellen(0);
		if(this.bError == false);
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_SL;
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}
		
		// schreibe falls was gefunden wurde
		if(this.outWorksheets.length > 0)
			this.xmlWriteTemplateFile(bShowExcelFile);
    },
	
	// -Schu- soll EXCEL-Makro ersetzen
	writeHListFromProjectlist : function(bShowExcelFile)
    {
		this.xmlPrepareTemplateFile();
		this.prepareDatenStueckliste(0);
		if(this.bError == true)
			return;
		var nSheet = 0;
		this.strCsvBuffer = "";
		
		this.aData = [];
		this.listTyp = "HAEN_LIST";
		this.prepareHaengerList(0)
		if(this.bError == false);
		{
			this.outWorksheetsName[nSheet] = "HLIST";
			this.xmlDataToXml(nSheet);
			this.xmlDataToCsv(nSheet);
			nSheet++;
		}
		// schreibe falls was gefunden wurde
		if(this.outWorksheets.length > 0)
			this.xmlWriteTemplateFile(bShowExcelFile);
	},

	xmlSetFileOutput : function(datei)
	{
		this.bError = false;
		filecommand("unlink", datei);

		// Fehler falls Datei noch vorhanden !
		var fn = new FileName(datei);
		if(fn.fileExists())
		{
			this.msgError = this.transl.ERR_FDEL;
			this.bError = true;
			return false;
		}
		this.strOutFile = datei;
		return true;
	},

    xmlPrepareTemplateFile : function()
    {
		var strPrgPath  = getstddirectory("PROGRAM");
		this.strTemplateFile = strPrgPath + this.strTemplateFile;

		// Sprache Ausdruck ... Texte neu generieren !!!
		var ProjectSettings = "PROJECT.SETTINGS";
		var strSprache = getstring("WI_SPRACHEKOMM", ProjectSettings);
		var strAngebNr = getstring("WI_ANGEBOTSNR", ProjectSettings);
		var strSystem = getstring("WI_SYSTEM", ProjectSettings);
		var strKundenNr = getstring("WI_KDNR", ProjectSettings);
		var strKundenFirma = getstring("FIRMENNAME_VON", ProjectSettings);
		var strKundenName = getstring("ANSPRECHPARTNER_VON", ProjectSettings);
		var strProjektNr = getstring("WI_PROJEKTNAME", ProjectSettings);
		var strProjektName = getstring("PROJEKTNAME", ProjectSettings);
		var strASNr = getstring("WI_ASNR", ProjectSettings);
        var strBenutzer = getstring("WI_BENUTZER", ProjectSettings);
		var strRevision = "";	//getstring("REVISION", ProjectSettings);

		var buffer = "";
		buffer = readfile(this.strTemplateFile);

		var i = buffer.length;
		var posT = -1, posH = -1, posW = -1;

		// Header anpassen und intern speichern:	bis vor <Worksheet>
		// Tail intern speichern					ab <WorksheetOptions>
		// </Worksheet> und </Workbook> selbst anhängen
		posH = buffer.indexOf("<Worksheet");
		posT = buffer.indexOf("<WorksheetOptions");
		posW = buffer.indexOf("</Worksheet>");

		if(posH == -1 || posT == -1)
		{
			this.bError = true;
			this.msgError = this.transl.ERR_FTEMPL + this.strTemplateFile;		//replace(this.strTemplateFile, "\\", "\\\\");
			return;
		}
		this.strTemplateHeadBuffer = buffer.left(posH-1);
		this.strTemplateTailBuffer = buffer.substring(posT, posW);

		// setze CREATE Datum
		this.xmlWorkbookHeader();

		posH = buffer.indexOf("<Row");
		this.strTemplateWorksheet = buffer.substring(posH, posT);

		// Styles einfügen: vor </Styles>
		var nStyleBase = 100;
		// suche freie Nummer
		while(buffer.indexOf("ss:ID=\"s"+nStyleBase)>0)
			nStyleBase++;

		var nStyle = nStyleBase;

		this.styles = {
			SLC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			SCC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			SRC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			NLC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			NCC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			NRC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			TBK: "ss:StyleID=\"s"+(nStyle++)+"\"",
			TBR: "ss:StyleID=\"s"+(nStyle++)+"\"",
			R45: "ss:StyleID=\"s"+(nStyle++)+"\"",
			R90: "ss:StyleID=\"s"+(nStyle++)+"\"",
			T2L: "ss:MergeAcross=\"1\" ss:StyleID=\"m"+(nStyle++)+"\"",
			S2C: "ss:MergeAcross=\"1\" ss:StyleID=\"m"+(nStyle++)+"\"",
			EUR: "ss:StyleID=\"s"+(nStyle++)+"\""		// mal sehen ob das geht
		};

		// Vertikal Mitte und Zeilenumbruch
		var vert_wrap = " ss:Vertical=\"Center\" ss:WrapText=\"1\"";
		// Rahmen überall
		var border = "\r\n<Borders>" +
			"\r\n<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
			"\r\n<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
			"\r\n<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
			"\r\n<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
			"\r\n</Borders>";

		// schreiben
		nStyle = nStyleBase;
		this.strTemplateHeadBuffer = replace(this.strTemplateHeadBuffer, "</Styles>",
			"<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"n" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"n" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"#FFFF99\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"#FFFF99\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:Rotate=\"45\"/>" +
			"\r\n<Interior ss:Color=\"#FFFF99\" ss:Pattern=\"Solid\"/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:Rotate=\"90\" ss:WrapText=\"1\"/>" +
			"\r\n<Interior ss:Color=\"#FFFF99\" ss:Pattern=\"Solid\"/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"m" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"#FFFF99\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"m" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"#,##0.00\ &quot;€&quot;\"/>" +
			"\r\n</Style>" +
			"\r\n</Styles>"	)

		// Zeilen ab <DATA> löschen
		//"#DATA#"
		var buffer2 = "";
		buffer2 = this.strTemplateWorksheet;

		posT = buffer2.indexOf("#DATA#");
		posH = buffer2.lastIndexOf("<Row", posT);
		buffer2 = buffer2.left(posH);

		// Projektdaten setzen

		//buffer2 = this.strTemplateWorksheet;
		buffer2 = buffer2.replace("#TITLE#", "@TITLE@");	// später
		// Werte
		buffer2 = buffer2.replace("#TITLE_CASCADE#", translate("Lastkettenprogramm CASCADE"));
		buffer2 = buffer2.replace("#DATUM#", this.strDate);
		buffer2 = buffer2.replace("#PROJEKT#", strProjektName + " "+strSystem);
		buffer2 = buffer2.replace("#KUNDE#", strKundenFirma);
		buffer2 = buffer2.replace("#ANGEBOT#", strAngebNr);
		buffer2 = buffer2.replace("#NAME#", strBenutzer);
		buffer2 = buffer2.replace("#REVISION#", strRevision);

		// Texte
		buffer2 = buffer2.replace("#T_PROJEKT#", this.transl.PROJ);
		buffer2 = buffer2.replace("#T_KUNDE#", this.transl.KUNDE);
		buffer2 = buffer2.replace("#T_ANGEBOT#", this.transl.WIANG);
		buffer2 = buffer2.replace("#T_DATUM#", this.transl.DATUM);
		buffer2 = buffer2.replace("#T_NAME#", this.transl.NAME);
		buffer2 = buffer2.replace("#T_REVISION#", this.transl.REVISION);

		buffer2 = buffer2.replace("#", "");					// # nicht erlaubt
		this.strTemplateWorksheet = buffer2;
	},

    xmlWriteTemplateFile : function(bShowExcelFile)
    {
		var anzSheet = this.outWorksheets.length;
		if(anzSheet <= 0)
		{
			this.bError = true;
			this.msgOK = this.transl.ERR_NODATA;
			return;
		}
	// xml als xls
		writefile(this.strOutFile, this.strTemplateHeadBuffer, "wc");
		for(var i = 0; i < anzSheet; i++)
		{
			writefile(this.strOutFile, this.outWorksheets[i], "a");
			writefile(this.strOutFile, this.xmlWorksheetFooter(), "a");
			writefile(this.strOutFile, this.xmlWorksheetOptions(i), "a");
			writefile(this.strOutFile, "</Worksheet>\r\n", "a");
		}
		writefile(this.strOutFile, "</Workbook>\r\n", "a");
		// zusätzlich als xml schreiben (WIN11)
		FileName.copyFile(this.strOutFile, this.strOutFile.replace(".xls", ".xml"), true);
	// CSV zusätzlich
		var strCsvFile = this.strOutFile.replace(".xls", ".csv");
		this.strCsvBuffer = this.strCsvBuffer.replace(transWithUnit("Preis je Stk", "€"), transWithUnit("Preis je Stk", "Eur"));
		this.strCsvBuffer = this.strCsvBuffer.replace(transWithUnit("Preis ges", "€"), transWithUnit("Preis ges", "Eur"));
		this.strCsvBuffer = this.strCsvBuffer.replace("&#10;", " ");
		this.strCsvBuffer = utf8toansi(this.strCsvBuffer);
		// Datei überschreiben
		writefile(strCsvFile, this.strCsvBuffer, "wc");
	// reset
		this.strCsvBuffer = "";
		this.bError = false;
	// Meldung ausgeben
		this.msgOK = this.transl.OK_FGEN + this.strOutFile;
	// autom. öffnen ?
        if (bShowExcelFile){
			if (getstring("SALESVERSION" , "RIGHTS") != "true")
				shellexecuteex( this.strOutFile, "", "", 1 );    // show = 1
			else
				//xml öffnen (WIN11 - SalesVersion)
				shellexecuteex( this.strOutFile.replace(".xls", ".xml"), "", "", 1 );    // show = 1
		}
	},

	xmlWorkbookHeader : function()
	{
		var posT = -1, posH = -1;
		var buffer = this.strTemplateHeadBuffer;

		// Header anpassen und intern speichern:	bis vor <Worksheet>
		// Tail intern speichern					ab <WorksheetOptions>
		posH = buffer.indexOf("<Created");
		posT = buffer.indexOf("</Created>");
		// falls nicht vorhanden
		if(posH == -1 || posT == -1)
			return;

		this.strTemplateHeadBuffer = buffer.left(posH) + "<Created>" + this.strDateZ + buffer.substring(posT);
	},

	xmlWorkbookFooter : function()
	{
		return this.strTemplateTailBuffer;
	},

	xmlWorksheetHeader : function(name)
	{
		return "<Worksheet ss:Name=\"" + name + "\">" +
			"\r\n<Table x:FullColumns=\"1\" x:FullRows=\"1\" ss:DefaultColumnWidth=\"100\" ss:DefaultRowHeight=\"12\">\r\n";
	},

	xmlWorksheetFooter : function()
	{
		return "</Table>\r\n";
	},

	xmlWorksheetOptions : function(nSheet)
	{
		var title = this.outWorksheetsName[nSheet];

		var buffer = this.strTemplateTailBuffer;
		buffer = buffer.replace("#DATUM#", this.strDate);
		buffer = buffer.replace("#T_DATUM#", this.transl.DATUM);
		buffer = buffer.replace("BLATTNAME", title);

		return buffer;
	},

	xmlWorksheetColumnDefinition : function(coldef, colcount)
	{
		var buffer = "";
		var nAGP = 0;
		for(var i=0; i < colcount; i++)
		{
			if(i >= colcount-5)
			{
				buffer += "<Column ss:Width=\"" + this.columns.AGP[nAGP] + "\"/>\r\n";
				nAGP++;
			}
			else if(coldef[i] != null)
			{
				buffer += "<Column ss:Width=\"" + coldef[i] + "\"/>\r\n";
			}
			else
			{
				buffer += "<Column ss:Width=\"" + this.columnDefaultWidth + "\"/>\r\n";
			}
		}
		return buffer;
	},

    xmlDataToXml : function(nSheet)
    {
		// das leere Template kopieren und Titel ändern
		var i, j, buffer, style, styleU, styleC;
		var title = this.outWorksheetsName[nSheet];

		buffer = this.xmlWorksheetHeader(title) + "\r\n";
		buffer += this.xmlWorksheetColumnDefinition(this.columns[this.listTyp], this.aData[0].length-1);
		buffer += this.strTemplateWorksheet;
		buffer += "\r\n<!-- " + title + " -->\r\n\r\n";

		while(buffer.indexOf("BLATTNAME") > 0)
			buffer = buffer.replace("BLATTNAME", title);

		var idx = this.outWorksheets.length;
		this.outWorksheets[idx] = buffer;

		var dataLen, dataLenSub;
		dataLen = this.aData.length;

		buffer = "";
		for(i = 0; i < dataLen; ++i)
		{
			// Spezialfall Gewindestanden
			if(this.aData[i][0] == "U-GEW" || this.aData[i][0] == "U-FP")
				break;

			dataLenSub = this.aData[i].length;
			// Leerzeile
			if(this.aData[i][0] == "L")
			{
				this.outWorksheets[idx] += "\t<Row/>\r\n";
				continue;
			}

			// Zeilenhöhe bei Überschrift
			if(this.aData[i][0] == "U")
				buffer = "\t<Row ss:Height=\"" + this.rowHeadHeight + "\">\r\n";
			else
				buffer = "\t<Row>\r\n";

			j = 1;

			// Summenzeilen: Zeile mit Zellen ohne Rahmen
			if(this.aData[i][0] == "S")
			{
				for (; j < dataLenSub && this.aData[i][j] == ""; ++j)
					buffer += "\t\t<Cell/>\r\n";
			}

			// Daten ab Pos.1 ausgeben
			// die letzten 2 im Euroformat
			for (; j < dataLenSub; ++j)
			{
				if(this.aData[i][0] != "U")
				{
					//if(j < dataLenSub - 5)	// die letzten 5 im Standardformat
					if(j < dataLenSub - 2)
						style = this.columnStyles[ this.listTyp  ][j-1];
					else
						//style = "SRC";		// die letzten 5 im Standardformat
						style = "EUR";
				}
				else
				{
					if(j < dataLenSub - 5)
						style = this.columnStyles[ this.listTyp + "_U" ][j-1];
					else
						style = "TBR";
				}
				styleC = this.styles[ style ];

				if(styleC == null)
				{
					if(this.aData[i][0] != "U")
						styleC = this.styles.SLC;
					else
						styleC = this.styles.TBK;
				}
				
				/*	// ORIGINAL ZAHLEN sind TEXT
				if(this.aData[i][j] != null && this.aData[i][j] != "0" && this.aData[i][j] != "")
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
								this.aData[i][j] + "</Data></Cell>\r\n";
				else
					buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
				*/
				
				// ZAHLEN als ZAHLEN ausgeben
				var isNumberAsString	= (j == dataLenSub - 6 ? true : false);	// in der 6.-letzten Spalte stehen die Bemerkungen --> auch "2.2" oder "3.1" ist Text
				if((this.aData[i][j] == null || this.aData[i][j] == "") ||		// leere Zelle
						(j >= dataLenSub - 2 && !atoi(getstring("PRICES_ENABLED", "RIGHTS")) && i != 0))	// Preise sind disabled und wir sind nicht in der ersten Zeile
					buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
				else if((this.aData[i][j]*1 + "" == "NaN" || this.aData[i][j]*1 + "" == "undefined") ||		// wir haben Text oder ...
						isNumberAsString)		// wir sind in der Bemerkungsspalte
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
								this.aData[i][j] + "</Data></Cell>\r\n";
				else
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"Number\">" +	// alle Zahlen
								fround(this.aData[i][j]*1, 2) + "</Data></Cell>\r\n";
			}
			buffer += "\t</Row>\r\n";
			this.outWorksheets[idx] += buffer;
		}

		// kein Spezialfall oder keine Daten
		if(i >= dataLen )
			return;

	// Spezialfall Freie Positionen

		if(this.aData[i][0] == "U-FP")
		{
			buffer = "\t<Row>\r\n";
			buffer += "\t\t<Cell " +  this.styles.TBK + "><Data ss:Type=\"String\">" + this.transl.FP + "</Data></Cell>\r\n";
			buffer += "\t</Row>\r\n";
			this.outWorksheets[idx] += buffer;

			dataLenSub = this.aData[i].length;
			i++;

			// Daten (ab nächster Zeile (i++))
			for(; i < dataLen; ++i)
			{
                // Leerzeile
                if(this.aData[i][0] == "L")
                {
                    this.outWorksheets[idx] += "\t<Row/>\r\n";
                    i++;
                    break;
                }
				if (this.aData[i][0] != "FP")
					break;

				// Daten ab Pos.1 ausgeben
				buffer = "\t<Row>\r\n";
				for (j = 1; j < dataLenSub; ++j)
				{
					if(this.aData[i][0] != "U")
					{
						//if(j < dataLenSub - 5)
						if(j < dataLenSub - 2)
							style = this.columnStyles[ this.listTyp ][j-1];
						else
							//style = "SRC";
							style = "EUR";
					}
					else
					{
						if(j < dataLenSub - 5)
							style = this.columnStyles[ this.listTyp + "_U" ][j-1];
						else
							style = "TBR";
					}
					styleC = this.styles[ style ];

					if(styleC == null)
					{
						if(this.aData[i][0] != "U")
							styleC = this.styles.SLC;
						else
							styleC = this.styles.TBK;
					}
					// ORIGINAL ZAHLEN als TEXT
					/*
					if(this.aData[i][j] != null && this.aData[i][j] != "0" && this.aData[i][j] != "")
						buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
									this.aData[i][j] + "</Data></Cell>\r\n";
					else
						buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
					*/
					// ZAHLEN als ZAHLEN ausgeben
					var isNumberAsString	= (j == dataLenSub - 6 ? true : false);	// in der 6.-letzten Spalte stehen die Bemerkungen --> auch "2.2" oder "3.1" ist Text
					if((this.aData[i][j] == null || this.aData[i][j] == "") ||		// leere Zelle
							(j >= dataLenSub - 2 && !atoi(getstring("PRICES_ENABLED", "RIGHTS")) && i != 0))	// Preise sind disabled und wir sind nicht in der ersten Zeile
						buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
					else if((this.aData[i][j]*1 + "" == "NaN" || this.aData[i][j]*1 + "" == "undefined") ||		// wir haben Text oder ...
							isNumberAsString)		// wir sind in der Bemerkungsspalte
						buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
									this.aData[i][j] + "</Data></Cell>\r\n";
					else
						buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"Number\">" +	// alle Zahlen
									fround(this.aData[i][j]*1, 2) + "</Data></Cell>\r\n";
				}
				buffer += "\t</Row>\r\n";
				this.outWorksheets[idx] += buffer;
			}
		}

		// kein Spezialfall Gewindestanden oder keine Daten
		if(i >= dataLen )
			return;
		if(this.aData[i][0] != "U-GEW")
			return;

	// Spezialfall Gewindestanden

		buffer = "\t<Row>\r\n";
		buffer += "\t\t<Cell><Data ss:Type=\"String\">" + this.transl.GEWLEN + "</Data></Cell>\r\n";
		buffer += "\t</Row>\r\n";
		this.outWorksheets[idx] += buffer;

		dataLenSub = this.aData[i].length;
		buffer = "\t<Row>\r\n";
		for (j = 1; j < dataLenSub; ++j)
		{
			style = this.columnStyles[ "GEW_U" ][j-1];
			styleC = this.styles[ style ];
			if(styleC == null)
			{
				if(this.aData[i][0] != "GEW_U")
					styleC = this.styles.SLC;
				else
					styleC = this.styles.TBK;
			}
			if(this.aData[i][j] == null)
				this.aData[i][j] = "";
			
			buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
						this.aData[i][j] + "</Data></Cell>\r\n";
		}
		buffer += "\t</Row>\r\n";
		this.outWorksheets[idx] += buffer;

		// Daten (ab nächster Zeile (i++))
		for(i++; i < dataLen; ++i)
		{
			dataLenSub = this.aData[i].length;

			// Daten ab Pos.1 ausgeben
			buffer = "\t<Row>\r\n";
			for (j = 1; j < dataLenSub; ++j)
			{
				style = this.columnStyles[ "GEW" ][j-1];
				styleC = this.styles[ style ];
				if(styleC == null)
				{
					styleC = this.styles.SLC;
				}
				if(this.aData[i][j] == null)
					this.aData[i][j] = "";
				// ORIGINAL ZAHLEN als TEXT
				/*
				buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
							this.aData[i][j] + "</Data></Cell>\r\n";
				*/
				// ZAHLEN als ZAHLEN ausgeben
				var isNumberAsString	= (j == dataLenSub - 6 ? true : false);	// in der 6.-letzten Spalte stehen die Bemerkungen --> auch "2.2" oder "3.1" ist Text
				if((this.aData[i][j] == null || this.aData[i][j] == "") ||		// leere Zelle
						(j >= dataLenSub - 2 && !atoi(getstring("PRICES_ENABLED", "RIGHTS")) && i != 0))	// Preise sind disabled und wir sind nicht in der ersten Zeile
					buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
				else if((this.aData[i][j]*1 + "" == "NaN" || this.aData[i][j]*1 + "" == "undefined") ||		// wir haben Text oder ...
						isNumberAsString)		// wir sind in der Bemerkungsspalte
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
								this.aData[i][j] + "</Data></Cell>\r\n";
				else
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"Number\">" +	// alle Zahlen
								fround(this.aData[i][j]*1, 2) + "</Data></Cell>\r\n";
			}
			buffer += "\t</Row>\r\n";
			this.outWorksheets[idx] += buffer;
		}
	},

    xmlDataToCsv : function(nSheet)
    {
		// das leere Template kopieren und Titel ändern
		var i, j;
		var dataLenSub, buffer;

		var title = this.outWorksheetsName[nSheet];
		var dataLen = this.aData.length;

		buffer = title + "\r\n";
		for(i = 0; i < dataLen; ++i)
		{
			// Spezialfall Gewindestanden
			if(this.aData[i][0] == "U-GEW" || this.aData[i][0] == "U-FP")
				break;

			dataLenSub = this.aData[i].length;
			// Leerzeile
			if(this.aData[i][0] == "L")
			{
				buffer += "\r\n";
				continue;
			}

			j = 1;

			// Summenzeilen: Zeile mit Zellen ohne Rahmen
			if(this.aData[i][0] == "S")
			{
				for (; j < dataLenSub && this.aData[i][j] == ""; ++j)
					buffer += ";";
			}

			// Daten ab Pos.1 ausgeben
			// die letzten 5 im Standardformat
			for (; j < dataLenSub; ++j)
			{
				if(this.aData[i][j] != null && this.aData[i][j] != "0" && this.aData[i][j] != "")
					buffer += "\" " + this.aData[i][j] + "\";";
				else
					buffer += ";";
			}
			buffer += "\r\n";
		}
		this.strCsvBuffer += buffer;
		buffer = "";

		// kein Spezialfall oder keine Daten
		if(i >= dataLen )
			return;

	// Spezialfall Freie Positionen

		if(this.aData[i][0] == "U-FP")
		{
			buffer += "\r\n" + this.transl.FP + "\r\n";
			dataLenSub = this.aData[i].length;
			i++;

			// Daten (ab nächster Zeile (i++))
			for(; i < dataLen; ++i)
			{
				if(this.aData[i][0] != "FP")
					break;

				// Daten ab Pos.1 ausgeben
				buffer += "\r\n";
				for (j = 1; j < dataLenSub; ++j)
				{
					if(this.aData[i][j] != null && this.aData[i][j] != "0" && this.aData[i][j] != "")
						buffer += "\" " + this.aData[i][j] + "\";";
					else
						buffer += ";";
				}
				buffer += "\r\n";
			}
		}
		this.strCsvBuffer += buffer;
		buffer = "";

		// kein Spezialfall Gewindestanden oder keine Daten
		if(i >= dataLen )
			return;
		if(this.aData[i][0] != "U-GEW")
			return;

	// Spezialfall Gewindestanden

		dataLenSub = this.aData[i].length;

		buffer += "\r\n" + this.transl.GEWLEN + "\r\n" + "\r\n";
		for (j = 1; j < dataLenSub; ++j)
		{
			if(this.aData[i][j] == null)
				this.aData[i][j] = "";
			buffer += "\" " + this.aData[i][j] + "\";";
		}
		buffer += "\r\n";

		this.strCsvBuffer += buffer;
		buffer = "";

		// Daten (ab nächster Zeile (i++))
		for(i++; i < dataLen; ++i)
		{
			dataLenSub = this.aData[i].length;

			// Daten ab Pos.1 ausgeben
			for (j = 1; j < dataLenSub; ++j)
			{
				if(this.aData[i][j] == null)
					this.aData[i][j] = "";
				buffer += "\" " + this.aData[i][j] + "\";";
			}
			buffer += "\r\n";
		}
		this.strCsvBuffer += buffer;
		buffer = "";
	},

	prepareDatenStueckliste : function(bIdentnummern)
	{
		this.bError = false;

        var myPresets = new CaPresets();

		var tmpCaMainController;
		var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var Target = "DLGDATA";
		var Source;
		var i, j, k, nAnz, stkPart, sTyp;

		// alle Stücklisten hierhin kopieren
		var stkListeQty = [];
		// alle Freie Positionen hierhin kopieren
		var fpListeQty = [];

		var nLastPos = getsize(Projectlist, "");
		for (nPos = 0; nPos < nLastPos; ++nPos)
		{
			Source = Projectlist + "[" + nPos + "]";
			// NUR Cascade
			var strProductArea = getstring("PRODUCT_AREA", Source);
            var strSAPcheck = tolower(getstring("SAP_CHECK", Source));
			if ((strProductArea != "RH" && strProductArea != "CA") || strSAPcheck == "false")
				continue;
			
			// im Massenauszug wird der Preis in EURO ausgeben
			var nCURRENCY_FACTOR = getdouble("CURRENCY_FACTOR_CRM", "PROJECT.SETTINGS.WUR");	// kommt vom CRM
			if (!nCURRENCY_FACTOR)
				nCURRENCY_FACTOR = getdouble("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR");	// Vorgabe in Flexperte
			if (nCURRENCY_FACTOR < 0.01)	// da ist was nicht richtig
				nCURRENCY_FACTOR = 1;
			
			var nQTY = getint("QTY", Source);
			var nPosPreis	= fround(getdouble("POSPRICE", Source) / nCURRENCY_FACTOR, 2);
			var nLkPosPreis	= fround(getdouble("UNITPRICE_ALL_INCLUDED", Source) / nCURRENCY_FACTOR, 2);
			
			var nLkGew = getdouble("DUNITWEIGHT", Source);

			var strPosNr = getstring("POS", Source);
            var strKDMAT = getstring("CUSTOMER_CODE", Source);
            var strIdent = getstring("IDENT", Source);

			var anlPos	= getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", Source);
			var zgnr	= getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", Source);
			var bem		= getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN", Source);
			// Anfrageposition -> TODO für freie Positionen
			var anfrpos	= getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS", Source);	// in alten Projekten nicht vorhanden -> leer

			// altes löschen
			delete(Target, "");
			copy(Source, Target);

			tmpCaMainController = new CaController();

			var stkListe = [];
			tmpCaMainController.topologieKlasse.getStueckliste(stkListe);

			var schelle = [];
			schelle = tmpCaMainController.topologieKlasse.getSchelleDaten();
			var haenger = [];
			haenger = tmpCaMainController.topologieKlasse.getHaengerDaten(myPresets);
			var nEinbMass = tmpCaMainController.topologieKlasse.getLKSystemEmass();

			for(k = 0; k < stkListe.length; k++)
			{
				switch(stkListe[k].funktion)
				{
					case "HNG":
						sTyp = "HNG";
						break;
					case "SCH":
					case "LAG":
						if(stkListe[k].produkt.isSchelleLager())
						{
							sTyp = "SCH";
							break;
						}
					case "SON":
						if(left(stkListe[k].produkt.m_Ptypid, 1) == 'Z')
                            sTyp = "ACC";
                        else
                            sTyp = "SON";
						break;
					case "OBT":
					case "UVT":
					default:
						sTyp = "ACC";
						break;
				}

				stkListeQty[ stkListeQty.length ] = {
						qty :		nQTY,
						fkt :		stkListe[k].funktion,
						anz :		stkListe[k].anz,
						typ :		stkListe[k].produkt.m_Ptyp,
						prod :		stkListe[k].produkt,
						posnr :		strPosNr,
						kdmat :		strKDMAT,
						sap :		strSAPcheck,
						ident :		stkListe[k].produkt.getASTLDaten(tmpCaMainController).matnr,
						anlpos :	anlPos,
                        zgnr:       zgnr,
						bem :		bem,
						fktmod :	sTyp,
						posPreis:	nPosPreis,
						lkPreis:	nLkPosPreis,
						lkGew:		nLkGew,
						einbmass:	nEinbMass,
						haenger :	haenger,
						schelle :	schelle,
						tmpanz :	0,
						anfrpos :	anfrpos
					};
			}
		}

		for (nPos = 0; nPos < nLastPos; ++nPos)
		{
			Source = Projectlist + "[" + nPos + "]";
			SourceFP = Projectlist + "[" + nPos + "].FP";
			// NUR Cascade
			var strProductArea = getstring("PRODUCT_AREA", Source);
            var strSAPcheck = tolower(getstring("SAP_CHECK", Source));
			if (strProductArea != "FP" || strSAPcheck == "false")
				continue;

			var nQTY = getint("QTY", Source);
			var nPosPreis = getdouble("POSPRICE", Source);
			// var nLkPosPreis = getdouble("UNITPRICE_ALL_INCLUDED", Source);
			var nLkPosPreis = getdouble("DUNITPRICE", Source);
			var nLkGew = getdouble("DUNITWEIGHT", Source);

			var strPosNr = getstring("POS", Source);
            var strKDMAT = getstring("CUSTOMER_CODE", Source);
            var strIdent = getstring("IDENT", Source);

			// altes löschen
			delete(Target, "");
			copy(Source, Target);

			var fpRhTyp = getstring("RH_TYP", SourceFP);
			var fpWiMat = getstring("FREI_NUMMER", SourceFP);
			var fpText  = getstring("FREI_TYP", SourceFP);
			var fpMark  = getstring("MARKIERUNG", SourceFP);
			var fpZeich = getstring("ZEICHNUNGSNR", SourceFP);
			var fpGew   = getstring("GEWICHT", SourceFP);
			//var fpNum = strIdent;

			//FP_LS=Lager/Schelle|FP_HS=Haenger/Stuetze|FP_ZU=Zubehoer|FP_LA=Lastkette|FP_ST=Stahlbau
			switch(strTyp)
			{
				case "FP_LS":
					break;
				case "FP_HS":
					break;
				case "FP_ZU":
					break;
				case "FP_LA":
					break;
				case "FP_ST":
					break;
			}

			fpListeQty[ fpListeQty.length ] = {
					qty :		nQTY,
					fkt :		fpRhTyp,
					anz :		1,      // nQTY ... sonst wird alles quadriert ;-)
					typ :		"",
					fktmod :	fpRhTyp,
					posnr :		strPosNr,
					wimat :		fpWiMat,
					sap :		strSAPcheck,
					ident :		strIdent,
					anlpos :	fpMark,
					posPreis:	nPosPreis,
                    lkPreis:	nLkPosPreis,
					text :		fpText,
					znr :		fpZeich,
					lkGew:		fpGew,
					tmpanz :	0
				};
		}

		// speichern für spätere Verwendung (andere Ausdrucke)
		this.stueckListe = stkListeQty;
		this.stueckListeFP = fpListeQty;

		if(stkListeQty.length + fpListeQty.length == 0)
		{
			this.msgError = this.transl.ERR_NOPOS;
			this.bError = true;
		}
	},

	prepareMassenauszug : function(bIdentnummern)
	{
		this.bError = false;

		var tmpCaMainController, strProductArea;
		var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var i, j, k, nPos, nAnz, sTyp, strQTY;
		var leerZ = [ "L" ];
		var stkPart, strNr, strOberfl;
		var dSum, dGew, dGesSum, dGesGew;

		dSum = dGew = dGesSum = dGesGew = 0.0;

		var stkListeQty = [];
		stkListeQty = this.stueckListe;

		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;

		// nach Typ und Nummer sortieren
		stkListeQty.sort(strSort);
		fpListeQty.sort(strSort);

		// zusammenfassen
		for (i = 0; i < stkListeQty.length; i++)
		{
			if(stkListeQty[i].fkt == "***")
				continue;
			stkListeQty[i].tmpanz = stkListeQty[i].qty * stkListeQty[i].anz;
			for (j = i+1; j < stkListeQty.length
					&& stkListeQty[i].fktmod == stkListeQty[j].fktmod
					&& stkListeQty[i].typ == stkListeQty[j].typ;
				j++)
			{
				stkListeQty[i].tmpanz += (stkListeQty[j].qty * stkListeQty[j].anz);
				stkListeQty[j].tmpanz = 0;
				stkListeQty[j].fkt = "***";
			}
		}
/*
		for (i = 0; i < fpListeQty.length; i++)
		{
			if(fpListeQty[i].fkt == "***")
				continue;
			fpListeQty[i].tmpanz = fpListeQty[i].qty * fpListeQty[i].anz;
			for (j = i+1; j < fpListeQty.length && fpListeQty[i].fktmod == fpListeQty[j].fktmod;
				j++)
			{
				fpListeQty[i].tmpanz += (fpListeQty[j].qty * fpListeQty[j].anz);
				fpListeQty[j].tmpanz = 0;
				fpListeQty[j].fkt = "***";
			}
		}
*/
		// Header Zeile
		this.aData[ this.aData.length ] = [
				"U",	// Text
				this.transl.TYP,
				this.transl.LGV,
				this.transl.U_NW,
				this.transl.U_SPANNW,
				this.transl.MAT,
				this.transl.WIMAT,
				this.transl.BEM,
				this.transl.ANZ,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];

		for (j = 0; j < 4; j++)
		{
			nPos = 0;
            /* Rubriken:
                Hänger (HNG)
                Schellen / Lager (SCH), aber ohne Teile die Zubehör sind
                Zubehör (der Rest)
            */
			switch(j)
			{
				case 0: sTyp = "HNG"; break;
				case 1: sTyp = "SCH"; break;
				case 2: sTyp = "ACC"; break;
				case 3: sTyp = "SON"; break;
			}
			// Summe für eine Gruppe
			dSum = dGew = 0.0;

			for (i = 0; i < stkListeQty.length; i++)
			{
				stkPart = stkListeQty[i].prod;

				if(stkListeQty[i].fktmod != sTyp || stkListeQty[i].fkt == "***")
					continue;
				nAnz = stkListeQty[i].tmpanz;
				
				this.aData[ this.aData.length ] = [
						"D",	// Data
						stkPart.m_Ptyp,
						(stkPart.lgv ? stkPart.lgv : ""),
						numKomma("%.2f", (stkPart.oData ? stkPart.oData.DN : stkPart.nennweite)),
						numKomma("%.2f", stkPart.spannweite),
						stkPart.getWerkname(stkPart.m_Pwerkstoff),
						stkListeQty[i].ident,
						stkPart.m_Pzusinfo,
						nAnz,
						numKomma("%.2f", stkPart.m_Pgewicht),
						numKomma("%.2f", nAnz * stkPart.m_Pgewicht),
						numKomma("%.2f", stkPart.m_Ppreis),
						numKomma("%.2f", nAnz * stkPart.m_Ppreis)
					];
				dSum += nAnz * stkPart.m_Ppreis;
				dGew += nAnz * stkPart.m_Pgewicht;
				nPos++;
			}
			if(nPos > 0)
			{
				this.aData[ this.aData.length ] = leerZ;
				this.aData[ this.aData.length ] = [
						"S",	// Text
						"",
						"",
						"",
						"",
						"",
						"",
						this.transl.ZWSUM,
						"",
						"",
						numKomma("%.2f", dGew),
						"",
						numKomma("%.2f", dSum)
					];
				this.aData[ this.aData.length ] = leerZ;
				dGesSum += dSum;
				dGesGew += dGew;
			}
		}

		this.aData[ this.aData.length ] = [
				"S",	// Text
				"",
				"",
				"",
				"",
				"",
				"",
				this.transl.GESSUM,
				"",
				"",
				numKomma("%.2f", dGesGew),
				"",
				numKomma("%.2f", dGesSum)
			];

	// Freie Positionen

		// 1.Treffer
		for (i = 0; i < fpListeQty.length; i++)
		{
			if(fpListeQty[i].typ != "ZRM")
				break;
		}

		if (fpListeQty.length > 0)
		{
			// Header Zeile ausgeben
			this.aData[ this.aData.length ] = leerZ;
			this.aData[ this.aData.length ] = [
					"U-FP",	// Text
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					""
				];

			for (; i < fpListeQty.length; i++)
			{
				if(fpListeQty[i].fkt == "***")
					continue;
				nAnz = fpListeQty[i].qty * fpListeQty[i].anz;  // fpListeQty[i].tmpanz;
				this.aData[ this.aData.length ] = [
						"FP",	// Data
						fpListeQty[i].text,
						"",
						"",
						"",
						"",
						fpListeQty[i].ident,
						"",
						nAnz,
						numKomma("%.2f", fpListeQty[i].lkGew),
						numKomma("%.2f", nAnz * fpListeQty[i].lkGew),
						numKomma("%.2f", fpListeQty[i].lkPreis),
						numKomma("%.2f", fpListeQty[i].posPreis)
					];
				dSum += fpListeQty[i].posPreis;
				dGew += nAnz * stkPart.m_Pgewicht;
			}
		}

	// Gewindestangen

		// nach Typ und Nummer sortieren
		stkListeQty.sort(strSort_m_Ptyp);

		// 1.Treffer
		// Header Zeile ausgeben
		for (i = 0; i < stkListeQty.length; i++)
		{
			if(stkListeQty[i].prod.m_Ptypid == "ZRM")
			{
				this.aData[ this.aData.length ] = leerZ;
				this.aData[ this.aData.length ] = [
						"U-GEW",	// Text
						this.transl.TYP,
						"",
						"",
						"",
						"",
						this.transl.WIMAT,
						"",
						this.transl.ANZ,
						//transWithUnit("Gesamtlänge", "mm"),
						transWithUnit("PRINT_MB_GESAMTLAENGE", "mm"),
						"",
						""
					];

				break;
			}
		}

		for (; i < stkListeQty.length; i++)
		{
			if(stkListeQty[i].prod.m_Ptypid != "ZRM")
				continue;

			stkPart = stkListeQty[i].prod;
			strNr = left(stkListeQty[i].prod.m_Ptyp, 6);
			strOberfl = right(stkListeQty[i].prod.m_Ptyp, 1);
			sTyp = substr(stkPart.m_Ptyp, 8, 11);
			nAnz = stkListeQty[i].qty * stkListeQty[i].anz;
			dSum = stkListeQty[i].qty * stkListeQty[i].anz * sTyp;
			i++;

			while(left(stkListeQty[i].prod.m_Ptyp, 6) == strNr
				&& right(stkListeQty[i].prod.m_Ptyp, 1) == strOberfl )
			{
				// Anzahl bereits oben berechnet
				sTyp = substr(stkListeQty[i].prod.m_Ptyp, 8, 11);
				nAnz += stkListeQty[i].qty * stkListeQty[i].anz;
				dSum += stkListeQty[i].qty * stkListeQty[i].anz * sTyp;
				i++;
			}
			i--;

			this.aData[ this.aData.length ] = [
					"D",	// Data
					strNr + "...-" + strOberfl,
					"",
					"",
					"",
					"",
					stkListeQty[i].ident,
					"",
					nAnz,
					numKomma("%.2f", dSum),
					"",
					""
				];
		}
	},


	prepareStueckliste : function(bIdentnummern)
	{
		this.bError = false;

		var tmpCaMainController, strProductArea;
		var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var i, j, k, nPos, nAnz, sTyp, strQTY;
		var leerZ = [ "L" ];
		var stkPart;
		var dSum, dGew, dGesSum, dGesGew;

		var stkListeQty = [];
		stkListeQty = this.stueckListe;
		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;

		// Header Zeile
		this.aData[ this.aData.length ] = [
				"U",	// Text
				this.transl.POS,
				this.transl.MARK,
				this.transl.SL_POS,
				this.transl.TYP,
				this.transl.LGV,
				this.transl.U_NW,
				this.transl.U_SPANNW,
				this.transl.MAT,
				this.transl.WIMAT,
				this.transl.BEM,
				this.transl.ANZ,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];

		dSum = dGew = dGesSum = dGesGew = 0.0;

		var nLfdNr = 1;
		var nPos = 0;
		for (i = 0; i < stkListeQty.length; /*i++*/)
		{
			// Summe für eine Gruppe
			dSum = dGew = 0.0;

			// Schleife über gleiche PosNr
			nLfdNr = 1;
			stkPart = stkListeQty[i].prod;
			nPos = stkListeQty[i].posnr;

			while(stkListeQty[i].posnr == nPos && i < stkListeQty.length)
			{
				nAnz = stkListeQty[i].qty * stkListeQty[i].anz;
				this.aData[ this.aData.length ] = [
						"D",	// Data
						stkListeQty[i].posnr,
						stkListeQty[i].anlpos,
						nLfdNr,
						stkPart.m_Ptyp,
						(stkPart.lgv ? stkPart.lgv : ""),
						//numKomma("%.2f", stkPart.nennweite),
						numKomma("%.2f", (stkPart.oData ? stkPart.oData.DN : stkPart.nennweite)),
						numKomma("%.2f", stkPart.spannweite),
						stkPart.getWerkname(stkPart.m_Pwerkstoff),
						stkListeQty[i].ident,
						stkPart.m_Pzusinfo,
						nAnz,
						numKomma("%.2f", stkPart.m_Pgewicht),
						numKomma("%.2f", nAnz * stkPart.m_Pgewicht),
						numKomma("%.2f", stkPart.m_Ppreis),
						numKomma("%.2f", nAnz * stkPart.m_Ppreis)
					];
				dSum += nAnz * stkPart.m_Ppreis;
				dGew += nAnz * stkPart.m_Pgewicht;

				// nächster Eintrag
				i++;
				nLfdNr++;
				if(i < stkListeQty.length)
					stkPart = stkListeQty[i].prod;
			}

			this.aData[ this.aData.length ] = leerZ;
			this.aData[ this.aData.length ] = [
					"S",	// Text
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					this.transl.ZWSUM,
					"",
					"",
					numKomma("%.2f", dGew),
					"",
					numKomma("%.2f", dSum)
				];
			this.aData[ this.aData.length ] = leerZ;
			dGesSum += dSum;
			dGesGew += dGew;
		}

	// Freie Positionen

		for (i = 0; i < fpListeQty.length; /*i++*/)
		{
			// Summe für eine Gruppe
			dSum = dGew = 0.0;

			// Schleife über gleiche PosNr
			nLfdNr = 1;
			nPos = fpListeQty[i].posnr;

			while(fpListeQty[i].posnr == nPos && i < fpListeQty.length)
			{
				nAnz = fpListeQty[i].qty * fpListeQty[i].anz;
				this.aData[ this.aData.length ] = [
						"D",	// Data
						fpListeQty[i].posnr,
						fpListeQty[i].anlpos,
						nLfdNr,
						fpListeQty[i].text,
						"",
						"",
						"",
						"",
						fpListeQty[i].ident,
						this.transl.FP,
						nAnz,
						numKomma("%.2f", fpListeQty[i].lkGew),
						numKomma("%.2f", nAnz * fpListeQty[i].lkGew),
						numKomma("%.2f", fpListeQty[i].lkPreis),
						numKomma("%.2f", fpListeQty[i].posPreis)
					];
				dSum += fpListeQty[i].posPreis;
				dGew += nAnz * 0;

				// nächster Eintrag
				i++;
				nLfdNr++;
			}

			if(nLfdNr > 1)
			{
				this.aData[ this.aData.length ] = leerZ;
				this.aData[ this.aData.length ] = [
						"S",	// Text
						"",
						"",
						"",
						"",
						"",
						"",
						"",
						"",
						"",
						this.transl.ZWSUM,
						"",
						"",
						numKomma("%.2f", dGew),
						"",
						numKomma("%.2f", dSum)
					];
			}
			this.aData[ this.aData.length ] = leerZ;
			dGesSum += dSum;
			dGesGew += dGew;
		}

		this.aData[ this.aData.length ] = [
				"S",	// Text
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				this.transl.GESSUM,
				"",
				"",
				numKomma("%.2f", dGesGew),
				"",
				numKomma("%.2f", dGesSum)
			];
	},

	prepareHaengerList : function(bIdentnummern)
	{
		this.bError = false;
		
		var tmpCaMainController, strProductArea;
		var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var ProjectSettings = "PROJECT.SETTINGS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var i, j, k, nPos, strPosNr, strQTY;
        var strBlock;
		var leerZ = [ "L" ];
		var nAnz, stkPart, retObj;
		
		var stkListeQty = [];
		stkListeQty = this.stueckListe;
		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;
		
		this.aData[ this.aData.length ] = [
				"U",	// Text
				"POS.&#10;Nr.",
				"Anz.&#10;LK",
				"Stck&#10;pro&#10;LK",
                this.transl.ZGNR,
				this.transl.TYP,
				this.transl.LGV,
				this.transl.U_SL_HPKT,
				this.transl.U_BEW,
				this.transl.BEW_R,
				this.transl.U_ZL,
				this.transl.U_WL,
				this.transl.U_BLL,
				this.transl.U_EMASS,
				this.transl.U_FR,
				this.transl.U_LAEND,
				this.transl.U_LJ,
                this.transl.LAST_WEG,
                this.transl.BLOCK,
				this.transl.BEM,
				this.transl.ANZ_GES,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];
	},

	prepareHaenger : function(bIdentnummern)
	{
		this.bError = false;

		var tmpCaMainController, strProductArea;
		var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var ProjectSettings = "PROJECT.SETTINGS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var i, j, k, nPos, strPosNr, strQTY;
        var strBlock;
		var leerZ = [ "L" ];
		var nAnz, stkPart, retObj;
		var dSum, dGew, dGesSum, dGesGew;
		dSum = dGew = dGesSum = dGesGew = 0.0;

		var stkListeQty = [];
		stkListeQty = this.stueckListe;
		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;

		// Header Zeile
		this.aData[ this.aData.length ] = [
				"U",	// Text
				this.transl.POS,
				this.transl.ANZ_POS,
				this.transl.MARK,
                this.transl.ZGNR,
				this.transl.TYP,
				this.transl.LGV,
				this.transl.U_SL_HPKT,
				this.transl.U_BEW,
				this.transl.BEW_R,
				this.transl.U_ZL,
				this.transl.U_WL,
				this.transl.U_BLL,
				this.transl.U_EMASS,
				this.transl.U_FR,
				this.transl.U_LAEND,
				this.transl.U_LJ,
                this.transl.LAST_WEG,
                this.transl.BLOCK,
				this.transl.BEM,
				this.transl.ANZ_GES,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];

		// Summe für eine Gruppe
		dSum = dGew = 0.0;

		for (i = 0; i < stkListeQty.length; i++)
		{
			stkPart = stkListeQty[i].prod;
			if(stkListeQty[i].fktmod != "HNG" || stkPart.m_Ptypid == "SSG" || stkPart.m_Ptypid == "SSB" || (!stkPart.isHaenger()))
				continue;

			nAnz = stkListeQty[i].qty * stkListeQty[i].anz;

            strBlock = "U";
            if (stkPart.m_Pblock == "BLOCK_JA")
                strBlock = "B";
            else if (stkPart.m_Pblock == "BLOCK_MITTIG")
                strBlock = "M";

			/*
			var strWarmlast = numKomma("%.2f", stkListeQty[i].haenger.warmlast);
			if ((stkListeQty[i].haenger.warmlast2) && (stkListeQty[i].haenger.warmlast2 > 0))
				strWarmlast += "/" + numKomma("%.2f", stkListeQty[i].haenger.warmlast2);
			*/
			
			// Vorerst als Hinweis auf KH mit 2 Bewegungsrichtungen
			var Bemerkung	= stkPart.m_Pzeichnr;
			if (Bemerkung == "" && left(stkPart.m_Ptypid, 1) == "K" && stkPart.sollweg_ab != 0 && stkPart.sollweg_auf != 0)
				Bemerkung	= "Abw.BlockPos!!!";
			
            this.aData[ this.aData.length ] = [
                    "D",	// Data
                    stkListeQty[i].posnr,
                    stkListeQty[i].qty,
                    stkListeQty[i].anlpos,
                    stkListeQty[i].zgnr,
                    stkPart.m_Ptyp,
                    (stkPart.lgv ? stkPart.lgv : ""),
                    numKomma("%.1f", stkListeQty[i].haenger.SollastHpkt),
                    stkListeQty[i].haenger.Sollweg.replace(".", ","),
                    stkListeQty[i].haenger.RichtungBewegung,
                    numKomma("%.1f", stkListeQty[i].haenger.ZuslastHpkt),
                    stkListeQty[i].haenger.warmlast.replace(".", ","),
                    numKomma("%.2f", stkListeQty[i].haenger.kaltlast),
                    numKomma("%.0f", stkPart.getEmass()),
                    numKomma("%.2f", stkListeQty[i].haenger.federrate),
                    numKomma("%.1f", stkListeQty[i].haenger.lastaenderung),
                    stkListeQty[i].haenger.lastjustierung,
                    stkListeQty[i].haenger.lastweg_diag,
                    strBlock,
                    //translate(stkPart.m_Pzeichnr),
					Bemerkung,
                    nAnz,
                    numKomma("%.2f", stkPart.m_Pgewicht),
                    numKomma("%.2f", nAnz * stkPart.m_Pgewicht),
                    numKomma("%.2f", stkPart.m_Ppreis),
                    numKomma("%.2f", nAnz * stkPart.m_Ppreis)
                ];

			dSum += nAnz * stkPart.m_Ppreis;
			dGew += nAnz * stkPart.m_Pgewicht;
		}
		dGesSum += dSum;
		dGesGew += dGew;

	// Freie Positionen

		for (i = 0; i < fpListeQty.length; i++)
		{
			//FP_LS=Lager/Schelle|FP_HS=Haenger/Stuetze|FP_ZU=Zubehoer|FP_LA=Lastkette|FP_ST=Stahlbau
			if(fpListeQty[i].fkt != "FP_HS")
				continue;

			nAnz = fpListeQty[i].qty * fpListeQty[i].anz;
			this.aData[ this.aData.length ] = [
					"D",	// Data
					fpListeQty[i].posnr,
					fpListeQty[i].fpListeQty[i].qty,
					fpListeQty[i].anlpos,
					fpListeQty[i].znr,
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					this.transl.FP,
					nAnz,
					numKomma("%.2f", fpListeQty[i].lkGew),
					numKomma("%.2f", nAnz * fpListeQty[i].lkGew),
					numKomma("%.2f", fpListeQty[i].lkPreis),
					numKomma("%.2f", fpListeQty[i].posPreis)
				];

			dGesSum += fpListeQty[i].posPreis;
			dGesGew += nAnz * 0;
		}

		this.aData[ this.aData.length ] = leerZ;
		this.aData[ this.aData.length ] = [
				"S",	// Text
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				this.transl.GESSUM,
				"",
				"",
				numKomma("%.2f", dGesGew),
				"",
				numKomma("%.2f", dGesSum)
			];
	},
	
	prepareSchellen : function(bIdentnummern)
	{
		this.bError = false;

		var tmpCaMainController, strProductArea;
		var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var ProjectSettings = "PROJECT.SETTINGS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var i, j, k, nPos, strPosNr, strQTY;
		var leerZ = [ "L" ];
		var nAnz, stkPart, retObj;
		var dSum, dGew, dGesSum, dGesGew;
		dSum = dGew = dGesSum = dGesGew = 0.0;

		var stkListeQty = [];
		stkListeQty = this.stueckListe;
		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;

		// nach Pos sortieren
		// stkListeQty.sort(numSort);

		// Header Zeile
		this.aData[ this.aData.length ] = [
				"U",	// Text
				this.transl.POS,
				this.transl.MARK,
				this.transl.TYP,
				this.transl.LGV,
				this.transl.U_NW,
				this.transl.U_BL,
				this.transl.U_TL,
				this.transl.U_MTEMP,
				this.transl.U_UTEMP,
				this.transl.U_RTEMP,
				this.transl.U_SPANNW,
				this.transl.U_DD,
				this.transl.MAT,
				this.transl.BEM,
				this.transl.ANZ,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];

		// Summe für eine Gruppe
		dSum = dGew = 0.0;

		for (i = 0; i < stkListeQty.length; i++)
		{
			stkPart = stkListeQty[i].prod;
			if(! stkPart.isSchelleLager())
				continue;

			nAnz = stkListeQty[i].qty * stkListeQty[i].anz;
            if (stkPart.isLager())
            {
                this.aData[ this.aData.length ] = [
                        "D",	// Data
                        stkListeQty[i].posnr,
                        stkListeQty[i].anlpos,
                        stkPart.m_Ptyp,
                        (stkPart.lgv ? stkPart.lgv : ""),
                        numKomma("%.2f", stkListeQty[i].schelle.nennweite),
                        numKomma("%.1f", stkListeQty[i].schelle.Betriebslast),
                        numKomma("%.1f", stkListeQty[i].schelle.Nennlast),
                        numKomma("%.0f", stkListeQty[i].schelle.MediumTemperatur),
                        //numKomma("%.0f", stkListeQty[i].schelle.UmgebungsTemperatur),
                        stkListeQty[i].schelle.UmgebungsTemperatur,
						numKomma("%.0f", stkListeQty[i].schelle.ReferenzTemperatur),
                        "",
                        numKomma("%.2f", stkListeQty[i].schelle.Daemmdicke),
                        stkPart.getWerkname(stkPart.m_Pwerkstoff),
                        stkPart.m_Pzusinfo,
                        nAnz,
                        numKomma("%.2f", stkPart.m_Pgewicht),
                        numKomma("%.2f", nAnz * stkPart.m_Pgewicht),
                        numKomma("%.2f", stkPart.m_Ppreis),     // getPreis(this.oOptions) --> geht hier nicht weil Annahme dass caMainController auf diese Auswahl verweist!
                        numKomma("%.2f", nAnz * stkPart.m_Ppreis)
                    ];
            }
            else
            {
                this.aData[ this.aData.length ] = [
                        "D",	// Data
                        stkListeQty[i].posnr,
                        stkListeQty[i].anlpos,
                        stkPart.m_Ptyp,
                        (stkPart.lgv ? stkPart.lgv : ""),
                        numKomma("%.2f", stkPart.nennweite),
                        numKomma("%.1f", stkPart.Betriebslast),
                        numKomma("%.1f", stkPart.traglast),
                        numKomma("%.0f", stkListeQty[i].schelle.MediumTemperatur),
                        //numKomma("%.0f", stkListeQty[i].schelle.UmgebungsTemperatur),
						stkListeQty[i].schelle.UmgebungsTemperatur,
                        numKomma("%.0f", stkListeQty[i].schelle.ReferenzTemperatur),
                        numKomma("%.0f", stkPart.spannweite),
                        numKomma("%.2f", stkPart.Daemmdicke),
                        stkPart.getWerkname(stkPart.m_Pwerkstoff),
                        stkPart.m_Pzusinfo,
                        nAnz,
                        numKomma("%.2f", stkPart.m_Pgewicht),
                        numKomma("%.2f", nAnz * stkPart.m_Pgewicht),
                        numKomma("%.2f", stkPart.m_Ppreis),
                        numKomma("%.2f", nAnz * stkPart.m_Ppreis)
                    ];
            }
			dSum += nAnz * stkPart.m_Ppreis;
			dGew += nAnz * stkPart.m_Pgewicht;
		}
		dGesSum += dSum;
		dGesGew += dGew;

	// Freie Positionen

		for (i = 0; i < fpListeQty.length; i++)
		{
			//FP_LS=Lager/Schelle|FP_HS=Haenger/Stuetze|FP_ZU=Zubehoer|FP_LA=Lastkette|FP_ST=Stahlbau
			if(fpListeQty[i].fkt != "FP_LS")
				continue;

			nAnz = fpListeQty[i].qty * fpListeQty[i].anz;
			this.aData[ this.aData.length ] = [
					"D",	// Data
					fpListeQty[i].posnr,
					fpListeQty[i].anlpos,
					fpListeQty[i].text,
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					this.transl.FP,
					nAnz,
					numKomma("%.2f", fpListeQty[i].lkGew),
					numKomma("%.2f", nAnz * fpListeQty[i].lkGew),
					numKomma("%.2f", fpListeQty[i].lkPreis),
					numKomma("%.2f", fpListeQty[i].posPreis)
				];

			dGesSum += fpListeQty[i].posPreis;
			dGesGew += nAnz * 0;
		}

		this.aData[ this.aData.length ] = leerZ;
		this.aData[ this.aData.length ] = [
				"S",	// Text
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				this.transl.GESSUM,
				"",
				"",
				numKomma("%.2f", dGesGew),
				"",
				numKomma("%.2f", dGesSum)
			];
	},

	prepareAuslegungen : function(bIdentnummern)
	{
		this.bError = false;

		var tmpCaMainController, strProductArea;
		tmpCaMainController = new CaController();

		var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var ProjectSettings = "PROJECT.SETTINGS";
		// Iteriere über die Projektlistenpositionen
		var Source;
		var Target = "DLGDATA";
		var idxLK, idxOUT;
		var i, j, k;
		var idxFirstPos, idxLastPos, nPos, strPosNr, strQTY;
		var leerZ = [ "L" ];
		var nAnz = 0, stkPart;
		var dSum, dLkSum, dGew, dGesSum, dGesGew;
		dSum = dLkSum = dGew = dGesSum = dGesGew = 0.0;

		var stkListeQty = [];
		stkListeQty = this.stueckListe;
		var fpListeQty = [];
		fpListeQty = this.stueckListeFP;

		// Header Zeile
		this.aData[ this.aData.length ] = [
				"U",	// Text
				this.transl.POS,
				this.transl.MARK,
                this.transl.ZGNR,
				this.transl.TYP,
				this.transl.LGV,
				this.transl.EMASS,
				this.transl.U_SL_HPKT,
				this.transl.U_BEW,
				this.transl.U_NW,
				this.transl.U_MTEMP,
				this.transl.U_UTEMP,
				this.transl.U_RTEMP,
				this.transl.U_SPANNW,
				this.transl.U_DD,
				this.transl.BEM,
				this.transl.ANZ,
				this.transl.U_GEW_STK,
				this.transl.U_GEW_GES,
				this.transl.U_PR_STK,
				this.transl.U_PR_GES
			];

		var nLastPos = getsize(Projectlist, "");
		for (nPos = 0; nPos < nLastPos; ++nPos)
		{
			Source = Projectlist + "[" + nPos + "]";

			// NUR Cascade
			strProductArea = getstring("PRODUCT_AREA", Source);
            var strSAPcheck = tolower(getstring("SAP_CHECK", Source));
			if ((strProductArea != "RH" && strProductArea != "CA") || strSAPcheck == "false")
				continue;

			// altes löschen
			delete(Target, "");
			copy(Source, Target);

			strPosNr = getstring("POS", Source);

			// idxFirstPos - Anfang PosNr
			for(idxFirstPos = 0; idxFirstPos < stkListeQty.length && stkListeQty[idxFirstPos].posnr != strPosNr; idxFirstPos++)
				/*nothing*/;

			// PosNr nicht gefunden
			if(idxFirstPos == stkListeQty.length)
				continue;

			// idxLK - die LK
			// idxLastPos - Ende PosNr
			idxLK = -1;
			idxOUT = idxFirstPos;
			idxLastPos = idxFirstPos;
			for(idxLastPos = idxFirstPos; idxLastPos < stkListeQty.length && stkListeQty[idxLastPos].posnr == strPosNr; idxLastPos++)
			{
				if ((stkListeQty[idxLastPos].fktmod == "HNG") &&
					(left(stkListeQty[idxLastPos].typ, 2) != "ZZ"))
				{
					idxLK = idxLastPos;
					idxOUT = idxLK;
				}
			}
			if(idxLastPos == stkListeQty.length)
				idxLastPos--;

			// KEINE LK
			//if(idxLK == -1) continue;

			// Lastkette ausgeben
			stkPart = stkListeQty[idxOUT].prod;

			// zusammenfassen
			for(j = idxFirstPos; j <= idxLastPos; j++)
			{
				if(j == idxOUT)
					continue;

				// Anz LK * Anz Teil
				nAnz = stkListeQty[idxOUT].qty * stkListeQty[j].anz;
			}

			// Anzahl LKs
			//dSum = stkListeQty[idxOUT].qty * stkPart.m_Ppreis;
			//dGew = stkListeQty[idxOUT].qty * stkPart.m_Pgewicht;
			dSum = stkListeQty[idxOUT].posPreis;
			dLkSum = stkListeQty[idxOUT].lkPreis;
			dGew = stkListeQty[idxOUT].lkGew;

			dGesSum += dSum;
			dGesGew += stkListeQty[idxOUT].qty * dGew;

			// Anzahl Lastketten
			nAnz = stkListeQty[idxOUT].qty;
			this.aData[ this.aData.length ] = [
					"D",	// Data
					stkListeQty[idxOUT].posnr,
					stkListeQty[idxOUT].anlpos,
					stkListeQty[idxOUT].zgnr,
					stkPart.m_Ptyp,
					(stkPart.lgv ? stkPart.lgv : ""),
					numKomma("%.0f", stkListeQty[idxOUT].einbmass),
					numKomma("%.1f", stkListeQty[idxOUT].haenger.SollastHpkt),
					stkListeQty[idxOUT].haenger.Sollweg,
					numKomma("%.2f", stkListeQty[idxOUT].schelle.nennweite),
					numKomma("%.0f", stkListeQty[idxOUT].schelle.MediumTemperatur),
					//numKomma("%.0f", stkListeQty[idxOUT].schelle.UmgebungsTemperatur),
					stkListeQty[idxOUT].schelle.UmgebungsTemperatur,
					numKomma("%.0f", stkListeQty[idxOUT].schelle.ReferenzTemperatur),
					numKomma("%.2f", stkPart.spannweite),
					numKomma("%.0f", stkListeQty[idxOUT].schelle.Daemmdicke),
					stkListeQty[idxOUT].bem,
					nAnz,
					numKomma("%.2f", dGew),
					numKomma("%.2f", nAnz * dGew),
					numKomma("%.2f", dLkSum),
					numKomma("%.2f", dSum)
				];
		}

	// Freie Positionen

		for (i = 0; i < fpListeQty.length; i++)
		{
			//FP_LS=Lager/Schelle|FP_HS=Haenger/Stuetze|FP_ZU=Zubehoer|FP_LA=Lastkette|FP_ST=Stahlbau
			// 03/2009: Hr. Schm. will jetzt alles sehen
			//if(fpListeQty[i].fkt != "FP_LA")
			//	continue;

			nAnz = fpListeQty[i].qty * fpListeQty[i].anz;
			this.aData[ this.aData.length ] = [
					"D",	// Data
					fpListeQty[i].posnr,
					fpListeQty[i].anlpos,
					fpListeQty[i].znr,
					fpListeQty[i].text,
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					"",
					this.transl.FP,
					nAnz,
					numKomma("%.2f", fpListeQty[i].lkGew),
					numKomma("%.2f", nAnz * fpListeQty[i].lkGew),
					numKomma("%.2f", fpListeQty[i].lkPreis),
					//numKomma("%.2f", nAnz * fpListeQty[i].posPreis)
					numKomma("%.2f", nAnz * fpListeQty[i].lkPreis)
				];

			dGesSum += fpListeQty[i].posPreis;
			dGesGew += nAnz * 0;
		}

		this.aData[ this.aData.length ] = leerZ;
		this.aData[ this.aData.length ] = [
				"S",	// Text
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				"",
				this.transl.GESSUM,
				"",
				"",
				numKomma("%.2f", dGesGew),
				"",
				numKomma("%.2f", dGesSum)
			];
	}
};


function numSort(a,b) {
	return atoi(a.posnr) - atoi(b.posnr);
};

function strSort(a, b) {
	if(a.fktmod > b.fktmod) return 1;
	if(a.fktmod < b.fktmod) return -1;
	if(a.typ > b.typ) return 1;
	if(a.typ < b.typ) return -1;
	return 0;
};
function strSort_m_Ptyp(a, b) {
	if(a.prod.m_Ptyp > b.prod.m_Ptyp) return 1;
	if(a.prod.m_Ptyp < b.prod.m_Ptyp) return -1;
	return 0;
};

function numKomma(a, b) {
	if(b == 0.0 || a == null || b == null || b == "-")
		return "";
	var buffer = sprintf(a, b);
	return buffer.replace(".", ",");
};
