/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2007 Plan Software GmbH
 *
 * @category   
 * @package    
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 */
 
CaDataAccess = function( strVersion )
{
	/**
     * Programmversion ... falls sich Speicherstrukturen im Store ndern
     * @var _versionString
     */
	this._versionString = strVersion;
	
    this._storeBasePath = "DLGDATA.CA.FORMS";
	
	this.LagerDaten = new CascadeLagerDataAccess( strVersion );
	this.KlemmsystemDaten = new CascadeKlemmsystemDataAccess( strVersion );
	
	/**
	 * Schon mal darber nachgedacht ?? --gl--
	 * Spart die lstigen getstring Dinger die eh kein Mensch versteht.
	 *
	 * this.base = Object.fromStorage(this._storeBasePath);
	 *
	 * getLastketteTyp : function() {
	 *	var lkTyp = this.base.SYSTEMCHARAKTERISTIK.IDC_LASTKETTE;
	 * .
	 * .
	 * .
	 * }
	 *
	 */
};

// So darfs nur in der Basisklasse gemacht werden (Prototype wird komplett ersetzt ... 
// durch ein anonymes Objekt, das seinerseits natrlich "Object" als Prototype hat
// faktisch ist das hier freier Code, der beim Laden der es-Datei ausgefhrt wird ...
// der Konstruktor wird dann spter beim new ausgefhrt ... 
// Laden der Datei bewirkt ...
//      - Konstruktor-Definition wird geparst, Funktion ist definiert
//      - prototype-property der Konstruktor-Funktion wird gesetzt auf ein Objekt mit einer einzigen property:
//        "constructor" -> verweist zurck auf die Konstruktor-Funktion
//      (-) in diesem speziellen Fall: prototype - Objekt wird durch ein neues berpinnt
// ... hier wird doch auch der Verweis auf die Konstruktor-Funktion berpinnt ??? -> angeblich unschdlich
// new bewirkt ...
//      - neues, leeres Objekt wird angelegt
//      - prototype-property dieses Objekts wird auf den Wert der prototype-property der Konstruktor-Funktion gesetzt
//      - Konstruktor-Funktion wird ausgefhrt
// (Gedanke: definier ich die Membervariablen im Prototype, dann werden sie automatisch vererbt;
//  ansonsten muss ich sicherstellen, dass eine abgeleitete Klasse den Konstruktor der Basisklasse aufruft)

CaDataAccess.prototype = 
{
	/**
     */
    getLastketteTyp : function() 
	{
		var lkTyp = getstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", this._storeBasePath);
		var ret = lkTyp;

		/*
        switch( lkTyp ) 
        {
            case 'BEWEGLICH':
                ret = 'BEWEGLICH';
                break;
            case 'STARR':
                ret = 'STARR';
                break;
            case 'GELENKSTUETZE':
                ret = 'GELENKSTUETZE';
                break;
            case 'GELENKSTREBE':
                ret = 'GELENKSTREBE';
                break;
            case 'EINZEL_HAENGER':
                ret = 'EINZEL_HAENGER';
                break;
            case 'EINZEL_SCHELLE':
                ret = 'EINZEL_SCHELLE';
                break;
            case 'EINZEL_ZUBEHOER':
                ret = 'EINZEL_ZUBEHOER';
                break;
            case 'EINZEL_LAGER':
                ret = 'EINZEL_LAGER';
                break;
            case 'EINZEL_KLEMMSYSTEM':
                ret = 'EINZEL_KLEMMSYSTEM';
                break;
            default:
                ret = 'UNKNOWN';
                break;
        }
		*/
		// wozu braucht man das eigentlich noch ? - es reicht ja vllig aus, gleich den Storewert aus dem UI zu bergeben
		//
		// Falls die ganze Klasse mal gedacht war als Zwischenschicht zwischen Store und Produktlogik - das wird mittlerweile
		// an so vielen Stellen durchbrochen, da die Verteilung (mal Direktzugriff, mal ber die DataAccess-Klasse) mehr 
		// Verwirrung stiftet als nutzt.
		
        return ret;
    },
	
	getLastketteRohrverlauf : function() 
	{
		var lkRohrverlauf = getstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", this._storeBasePath);
		var ret = "";
		
        switch(lkRohrverlauf) 
        {
            case 'HORIZONTAL':
            case 'LAGER_HORIZONTAL':
                ret = 'HORIZONTAL';
                break;
            case 'VERTIKAL':
            case 'LAGER_VERTIKAL':
                ret = 'VERTIKAL';
                break;
            case 'ROHRBOGEN':
                ret = 'ROHRBOGEN';
                break;
            default:
                ret = 'UNKNOWN';
                break;
        }
        return ret;
	},
	
	getLastketteMitSchelle : function() 
	{
		var lkCheckbox = getstring("SYSTEMCHARAKTERISTIK.IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL", this._storeBasePath);
		var ret = 1;
		if (lkCheckbox != "")
            ret = 0;
        return ret;
	},

	getLastketteNurSchelle : function() 
	{
		var lkCheckbox = getstring("SYSTEMCHARAKTERISTIK.IDC_NUR_ROHRUMSCHLIESSENDES_TEIL", this._storeBasePath);
		var ret = 0;
		if (lkCheckbox != "")
            ret = 1;
        return ret;
	},

	getLastketteAsymmetrisch : function() 
	{
		var lkCheckbox = getstring("SYSTEMCHARAKTERISTIK.IDC_ASYMETRISCH", this._storeBasePath);
		var ret = 0;
		if (lkCheckbox != "")
            ret = 1;
        return ret;
	},

	getLastketteLastabtragung : function() 
	{
		var lkLastabtragung = getstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", this._storeBasePath);
		var lkCheckSymmetr  = getstring("SYSTEMCHARAKTERISTIK.IDC_ASYMETRISCH",   this._storeBasePath);
		var lkSonderfaelle  = getstring("SYSTEMCHARAKTERISTIK.IDC_SONDERFAELLE_COMBO", this._storeBasePath);
		var ret = "";
		
        var test = left(getstring("strSelRadioRohrverlauf", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik"), 5);
		//if (left(getstring("strSelRadioRohrverlauf", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.Systemcharakteristik"), 5) == "LAGER")
		//	ret = 'STUETZEND_EINFACH';
		//else{
			switch(lkLastabtragung) 
			{
				case 'HAENGEND_EINFACH':
					ret = 'HAENGEND_EINFACH';
					break;
				case 'STUETZEND_EINFACH':
					ret = 'STUETZEND_EINFACH';
					break;
				case 'HAENGEND_DOPPEL':
					ret = 'HAENGEND_DOPPEL';
					break;
				case 'STUETZEND_DOPPEL':
					ret = 'STUETZEND_DOPPEL';
					break;
				case 'HAENGEND_VERZWEIGT':
					ret = 'HAENGEND_VERZWEIGT';
					break;
				case 'SONDERFAELLE':
					ret = 'WECHSELLAST';
					break;
				default:
					ret = 'UNKNOWN';
					break;
			}
		//}
        return ret;
	},
	
	getLastketteRohrrichtung : function() // -Schu- 110118
	{
		var lkRohrrichtung	= getstring("SYSTEMCHARAKTERISTIK.IDC_ROHRRICHTUNG", this._storeBasePath);
		var ret				= "";
		
		switch(lkRohrrichtung) 
        {
            case 'X_ACHSE':
            case 'LAGER_X_ACHSE':
                ret = 'X';
                break;
			case 'Y_ACHSE':
            case 'LAGER_Y_ACHSE':
				ret = 'Y';
				break;
			case 'Z_ACHSE':
            case 'LAGER_Z_ACHSE':
                ret = 'Z';
                break;
			case 'SCHRAEG_ACHSE':
			case 'LAGER_SCHRAEG_ACHSE':
				ret = 'SCHRAEG';
				break;
			default:
                ret = 'UNKNOWN';
                break;
		}
		return ret;
	},
	
	getInfoRRKSDefault : function(strLKRohrv)
	{
		// -Schu- 120710 das Achssystem in den Voreistellungen sind fr gesamtes Projekt gltig!!!
		//if ((!Object.fromStorage( "DLGDATA.CA.FINDATA" ))&&(getstring("OPEN_MODE_CASCADE", "") != "MODIFY"))
		//if (getstring("OPEN_MODE_CASCADE", "") != "MODIFY")
		//{
			var VertiDir	= toupper(right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"), 1));
			var KoordImg	= getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE");
		/*}
		else
		{
			var VertiDir	= getstring("SENKR_ACHSE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
			var KoordImg	= getstring("KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		}*/
		var HoriDir1	= "X";		// Default
		var HoriDir2	= "Y";		// Default
		var PosDir		= "AUF";	// Default
		var temp		= "";
		
		if (left(VertiDir, 1) == "X")
		{
			HoriDir1	= HoriDir2;
			HoriDir2	= "Z";
		}
		else if (left(VertiDir, 1) == "Y")
		{
			HoriDir2	= "Z";
		}
		
		if (right(getstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE"), 3) != "AUF")
			PosDir = "AB";
		
		var strPipeDir		= this.getLastketteRohrrichtung();
		if (strPipeDir == "" || strPipeDir == "UNKNOWN")
		{
			if (strLKRohrv != "HORIZONTAL")
				strPipeDir = VertiDir;
			else
				strPipeDir = HoriDir1;
		}
		
		if (strPipeDir == "SCHRAEG")
		{
			var SCHRAEG_ALPHA	= getstring("SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
			var SCHRAEG_BETA	= getstring("SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		}
		else
		{
			var SCHRAEG_ALPHA	= "";
			var SCHRAEG_BETA	= "";
		}
		
		var KoordImgVar	= right(KoordImg, 4);
		
		var ret	= {VertiDir : VertiDir,
					HoriDir1 : HoriDir1,
					HoriDir2 : HoriDir2,
					PosDir : PosDir,
					strPipeDir : strPipeDir,
					SCHRAEG_ALPHA : SCHRAEG_ALPHA,
					SCHRAEG_BETA : SCHRAEG_BETA,
					KoordImg : KoordImg,
					KoordImgVar : KoordImgVar
					};
		
		return ret;
	},
	
	getAchsKSInfo : function()	// -Schu- 110331
	{
		var t1 = getstring("OPEN_MODE_CASCADE", "");
		var t2 = getstring("AKTUELLE_MASKE", "");
		var KSVari	= right(getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"),1) * 1;
		// -Schu- 120710 das Achssystem in den Voreistellungen sind fr gesamtes Projekt gltig!!!
		//if ((getstring("OPEN_MODE_CASCADE", "") != "MODIFY") && (getstring("AKTUELLE_MASKE", "") != "IDD_PROJECTLISTE"))
		//{
			var VertiDir	= toupper(right(getstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE"),1));
			var HoriDir		= this.getLastketteRohrrichtung();
			var ALPHA	= fround(atod(getstring("SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK")),1);
			var BETA	= fround(atod(getstring("SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK")),1);
			// Normieren - sonst ist der Ausdruck falsch
			if (HoriDir == "SCHRAEG"){
				switch (VertiDir){
					case "Z" :
						HoriDir		= (abs(ALPHA) <= 22.5 ? "X" : "Y");
						break;
					case "Y" :
						HoriDir		= (abs(ALPHA) <= 22.5 ? "Z" : "X");
						break;
					case "X" :
						HoriDir		= (abs(ALPHA) <= 22.5 ? "Y" : "Z");
						break;
					default :
						break;
				}
			}
			var RohrDir		= this.getLastketteRohrverlauf();
		/*}
		else
		{
			var VertiDir	= toupper(getstring("SENKR_ACHSE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"));
			var HoriDir		= this.getLastketteRohrrichtung();
			var RohrDir		= this.getLastketteRohrverlauf();
		}*/
		switch (VertiDir)
		{
			case 'Z':
				if (RohrDir == 'HORIZONTAL')
				{
					if (HoriDir == 'X')
					{
						var indexHori	= 0;
						var strHori		= 'horizontal';
						var LatDir		= 'Y';
						var indexLat	= 1;
						var strLat		= 'lateral';
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var2' : 'LG_Var1');
					}
					else
					{
						var indexHori	= 1;
						var strHori		= 'horizontal';
						var LatDir		= 'X';
						var indexLat	= 0;
						var strLat		= 'lateral';
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var1' : 'LG_Var2');
					}
				}
				else
				{
					HoriDir			= 'X';
					var indexHori	= 0;
					var strHori		= 'horizontal'
					var LatDir		= 'Y';
					var indexLat	= 1;
					var strLat		= 'lateral';
					var LGVari		= 'LG_RV21';
				}
				var strVerti	= 'vertikal';
				var indexVerti	= 2;
				break;
			case 'Y':
				if (RohrDir == 'HORIZONTAL')
				{
					if (HoriDir == 'X')
					{
						var indexHori	= 0;
						var strHori		= 'horizontal';
						var LatDir		= 'Z';
						var indexLat	= 2;
						var strLat		= 'lateral';
						//var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var1' : 'LG_Var2');
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var2' : 'LG_Var1');
					}
					else
					{
						var indexHori	= 2;
						var strHori		= 'horizontal';
						var LatDir		= 'X';
						var indexLat	= 0;
						var strLat		= 'lateral';
						//var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var2' : 'LG_Var1');
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var1' : 'LG_Var2');
					}
				}
				else
				{
					HoriDir			= 'X';
					var indexHori	= 0;
					var strHori		= 'horizontal';
					var LatDir		= 'Z';
					var indexLat	= 2;
					var strLat		= 'lateral';
					var LGVari		= 'LG_RV21';
				}
				var strVerti	= 'vertikal';
				var indexVerti	= 1;
				break;
			case 'X':
				if (RohrDir == 'HORIZONTAL')
				{
					if (HoriDir == 'Y')
					{
						var indexHori	= 1;
						var strHori		= 'horizontal';
						var LatDir		= 'Z';
						var indexLat	= 2;
						var strLat		= 'lateral';
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var2' : 'LG_Var1');
					}
					else
					{
						var indexHori	= 2;
						var strHori		= 'horizontal';
						var LatDir		= 'Y';
						var indexLat	= 1;
						var strLat		= 'lateral';
						var LGVari		= (KSVari == 1 || KSVari == 3 ? 'LG_Var1' : 'LG_Var2');
					}
				}
				else
				{
					HoriDir			= 'Y';
					var indexHori	= 1;
					var strHori		= 'horizontal';
					var LatDir		= 'Z';
					var indexLat	= 2;
					var strLat		= 'lateral';
					var LGVari		= 'LG_RV21';
				}
				var strVerti	= 'vertikal';
				var indexVerti	= 0;
				break;
		}
		var ret = [VertiDir, HoriDir, LatDir, strVerti, strHori, strLat, indexVerti, indexHori, indexLat, LGVari, ALPHA, BETA];
		return ret;
	},

	getLastketteSonderfall : function() 
	{
        // trifft zu sowohl fr "verzweigt" als auch fr "Sonderflle"
		var lkSonderfall = getstring("SYSTEMCHARAKTERISTIK.IDC_SONDERFAELLE_COMBO", this._storeBasePath);
        return lkSonderfall;
    },
    
    getIndexFromDirection : function(/* string */ direction)
    {
		if ((left(direction, 5) == "axial") || (left(direction, 10) == "horizontal"))
            return 1;
        else if (left(direction, 8) == "vertikal")
            return 2;
        else if (left(direction, 7) == "lateral")
            return 0;
            
        // alert('Fehler bei Koordinatensystem-Index!');
        return 2;
    },
    
	getSollwerteLast : function(/* string */ direction, /* int */ asDouble, index)
	{
        if (this.getLastketteTyp() == "EINZEL_ZUBEHOER")
        {
            if (direction == "vertikal")
                return getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
        }
        else
        {
            var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
			// Dynamische Lastflle "HZ" und "HS"
			if (right(direction, 3) == "HZ+")
				var strRet = form.IDC_TABLE.last_plus_HZ[index];
			else if (right(direction, 3) == "HS+")
				var strRet = form.IDC_TABLE.last_plus_HS[index];
			else if (right(direction, 3) == "HZ-")
				var strRet = form.IDC_TABLE.last_minus_HZ[index];
			else if (right(direction, 3) == "HS-")
				var strRet = form.IDC_TABLE.last_minus_HS[index];
			else if (right(direction, 1) == "+")
				//var strRet = form.IDC_TABLE.last_plus[this.getIndexFromDirection(direction)];
				var strRet = form.IDC_TABLE.last_plus[index];
			else
				//var strRet = form.IDC_TABLE.last_minus[this.getIndexFromDirection(direction)];
				var strRet = form.IDC_TABLE.last_minus[index];
            if (asDouble)
                return inputStringToDouble(strRet);
            if (strRet)
                return strRet;
        }
        return "";
	},

    // Ausnahme: dieser Wert wird auch mal berschrieben:
	setSollwerteLast : function(/* string */ direction, theValue) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
        form.IDC_TABLE.last[this.getIndexFromDirection(direction)] = theValue;
        form.toStorage(this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", false);
        
        return strRet;
	},

	getSollwerteUeberLast : function(/* int */ asDouble, index) 
	{
        if (this.getLastketteTyp() != "EINZEL_ZUBEHOER")
        {
            var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
            //var strRet = form.IDC_TABLE.ueberlast[this.getIndexFromDirection(direction)];
			var strRet = form.IDC_TABLE.ueberlast[index];
            if (asDouble)
                return inputStringToDouble(strRet);
            if (strRet)
                return strRet;
        }
        return "";
	},

    // Ausnahme: dieser Wert wird auch mal berschrieben:
	setSollwerteUeberLast : function(/* string */ direction, theValue) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
        form.IDC_TABLE.ueberlast[this.getIndexFromDirection(direction)] = theValue;
        form.toStorage(this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", false);
        
        return strRet;
	},

	getSollwerteZusatzLast : function(/* int */ asDouble, index) 
	{
        if (this.getLastketteTyp() != "EINZEL_ZUBEHOER")
        {
            var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
            //var strRet = form.IDC_TABLE.zusatzlast[this.getIndexFromDirection(direction)];
			var strRet = form.IDC_TABLE.zusatzlast[index];
            if (asDouble)
                return inputStringToDouble(strRet);
            if (strRet)
                return strRet;
        }
        return "";
	},
	
	getSollwerteZusatzLastEG : function() 
	{
        if (this.getLastketteTyp() != "EINZEL_ZUBEHOER")
        {
            var ret = inputStringToDouble(getstring("Z_LAST_EG", this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT"));
			return ret;
        }
        return "";
	},

    // Ausnahme: dieser Wert wird auch mal berschrieben:
	setSollwerteZusatzLast : function(/* string */ direction, theValue) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
		form.IDC_TABLE.zusatzlast[this.getIndexFromDirection(direction)] = theValue;
        form.toStorage(this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", false);
		
        return "";
	},
	
	setSollwerteZusatzLastEG : function(theValue) // -Schu 110329-
	{
		setstring("Z_LAST_EG", this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", theValue);
		
        return "";
	},

	getSollwerteBewegung : function(/* string */ direction, /* int */ asDouble, index) 
	{
        if (this.getLastketteTyp() != "EINZEL_ZUBEHOER")
        {
            var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
            if (right(direction, 1) == "+")
				//var strRet = form.IDC_TABLE.bewegung_plus[this.getIndexFromDirection(direction)];
				var strRet = form.IDC_TABLE.bewegung_plus[index];
			else
				//var strRet = form.IDC_TABLE.bewegung_minus[this.getIndexFromDirection(direction)];
				var strRet = form.IDC_TABLE.bewegung_minus[index];
            if (asDouble)
                return inputStringToDouble(strRet);
            if (strRet)
                return strRet;
        }
        return "";
	},

    // Ausnahme: dieser Wert wird auch mal berschrieben:
	setSollwerteBewegung : function(/* string */ direction, theValue) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
        form.IDC_TABLE.bewegung[this.getIndexFromDirection(direction)] = theValue;
        form.toStorage(this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", false);
        
        return strRet;
	},

	getSollwerteEinfuegepunkt : function(/* int */ asDouble, index) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
		//var strRet = form.IDC_TABLE.einfuegepunkt[this.getIndexFromDirection(direction)];
		var strRet = form.IDC_TABLE.einfuegepunkt[index];
        if (asDouble)
            return inputStringToDouble(strRet);
        if (strRet)
            return strRet;
        return "";
	},

    // Ausnahme: dieser Wert wird auch mal berschrieben:
	setSollwerteEinfuegepunkt : function(/* string */ direction, theValue) 
	{
		var form = Object.fromStorage( this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");
        if (! form)
        {
            var einfuegepunkte = ["", "", ""];
            form = { IDC_TABLE : { einfuegepunkt : einfuegepunkte } };
        }
        form.IDC_TABLE.einfuegepunkt[this.getIndexFromDirection(direction)] = theValue;
        form.toStorage(this._storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT", false);
        
        return strRet;
	},

    getKSImage : function()
	{
		var ret			= "";
		var AchsDirInfo	= this.getAchsKSInfo();
		//var SenkrRicht	= getstring("SENKR_RICHT","DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var SenkrRicht	= right(getstring("IDC_VERTIKALDIR_DEF","PROJECT.SETTINGS.CASCADE"), 3);
		//var KSVertikale	= right(left(getstring("KOORD_IMG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 11), 1);
		//var KSVariante	= getstring("KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var KSVariante	= right(getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"), 4);
		//var KSRohrachse	= left(getstring("IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 1);
		if (toupper(SenkrRicht) != "AUF")
			ret		= "empty";
	/*	else if(((KSVertikale == "Z" && (KSRohrachse =="X" || KSRohrachse == "S") && KSVariante == "Var3") ||
				(KSVertikale == "Y" && (KSRohrachse =="Z" || KSRohrachse == "S") && KSVariante == "Var3") ||
				(KSVertikale == "X" && (KSRohrachse =="Y" || KSRohrachse == "S") && KSVariante == "Var3")) ||
				((KSVertikale == "Z" && (KSRohrachse =="X" || KSRohrachse == "S") && KSVariante == "Var1") ||
				(KSVertikale == "Y" && (KSRohrachse =="Z" || KSRohrachse == "S") && KSVariante == "Var1") ||
				(KSVertikale == "X" && (KSRohrachse =="Y" || KSRohrachse == "S") && KSVariante == "Var1")))
				// vgl. getRotUTeile Bedingungen fuer Drehung 90 bzw. 270
		{
			if(right(KSVariante, 1)*1 < 4)
				KSVariante	= left(KSVariante, 3) + (right(KSVariante, 1)*1 + 1);
			else
				KSVariante	= left(KSVariante, 3) + (right(KSVariante, 1)*1 - 1);
			ret		= "P" + AchsDirInfo[0] + "_" + KSVariante;
		}
	*/
		else
			ret		= "P" + AchsDirInfo[0] + "_" + KSVariante;
		return ret;
	},
	
	getRotUTeile : function()	// die brauchen wir nicht mehr -Schu- 120618
	{
		var KSVariante	= getstring("KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var KSVertikale	= right(left(getstring("KOORD_IMG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 11), 1);
		var KSRohrachse	= left(getstring("IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 1);
		var KSrot		= 0;
		var Lastabtrag	= right(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 6);
		
		if ((KSVertikale == "Z" && (KSRohrachse =="X" || KSRohrachse == "S") && KSVariante == "Var3") ||
			(KSVertikale == "Y" && (KSRohrachse =="Z" || KSRohrachse == "S") && KSVariante == "Var3") ||
			(KSVertikale == "X" && (KSRohrachse =="Y" || KSRohrachse == "S") && KSVariante == "Var3"))
			KSrot	=	90;
		else if ((KSVertikale == "Z" && (KSRohrachse =="X" || KSRohrachse == "S") && KSVariante == "Var1") ||
			(KSVertikale == "Y" && (KSRohrachse =="Z" || KSRohrachse == "S") && KSVariante == "Var1") ||
			(KSVertikale == "X" && (KSRohrachse =="Y" || KSRohrachse == "S") && KSVariante == "Var1"))
			KSrot	=	270;
		
		var KSAlpha		= atoi(getstring("SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"));
		if (KSAlpha < 0)
			KSAlpha		= 360 + KSAlpha;
		else if (KSAlpha > 360)
			KSAlpha		= KSAlpha - 360;
		
		KSrot	+=	KSAlpha;
		if (KSrot > 360)
			KSrot	-= 360;
		
		if (Lastabtrag == "DOPPEL")		// sonst ist bei doppelten LK nichts auf dem Ausdruck zu sehen
			KSrot	= 0;
		
		return (KSrot);
	},
	
	// Das ist hier eigentlich nicht der Schrgzug der Lastkette (Abweichung von der Vertikalen Achse)
    // sondern ein schrger Rohrleitungsverlauf (Abweichung von der horizontalen Achse)
	getSollwerteSchraegzug : function(/* int */ asDouble) 
	{
        var rohrverlauf = this.getLastketteRohrverlauf();
		var Systemchar	= "SYSTEMCHARAKTERISTIK";
		var test		= getstring ("SCHRAEG_ALPHA",this._storeBasePath + ".SYSTEMCHARAKTERISTIK2");
		if (getstring ("SCHRAEG_ALPHA",this._storeBasePath + ".SYSTEMCHARAKTERISTIK2") != "")
			Systemchar	= Systemchar + "2";
		var strAlpha	= getstring("SCHRAEG_ALPHA",this._storeBasePath + "." + Systemchar);
		var strBeta		= getstring("SCHRAEG_BETA",this._storeBasePath + "." + Systemchar);
		if (asDouble)
		{
			strAlpha	= inputStringToDouble(strAlpha);
			strBeta		= inputStringToDouble(strBeta);
		}
		var ret			=	{Alpha:	strAlpha,
							Beta:	strBeta};
		return ret;
	},
    
	/*getSollwerteRichtungBewegung : function() 
	{
		var richtBew = getstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_RICHTUNG_BEWEGUNG", this._storeBasePath);
		var ret = "AUF";
		if ((richtBew == translate("IDC_LABEL_RICHTUNG_AB")) ||
            (toupper(richtBew) == "AB") ||
            (toupper(richtBew) == "DOWN"))
            ret = "AB";
        return ret;
	},*/
	
	getSollwerteRichtungBewegung : function(BewAuf, BewAb) 
	{
		var ret = "AB";
		if (Math.abs(BewAuf) >= Math.abs(BewAb))
            ret = "AUF";
        return ret;
	},

	setSollwerteRichtungBewegung : function(strVorgabe) 
	{
		setstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_RICHTUNG_BEWEGUNG", this._storeBasePath, strVorgabe);
        return;
	},

	getSollwerteArtSollast : function() 
	{
		var artSollast = getstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_SOLLAST_IST", this._storeBasePath);
		var ret = "KALT";
		if ((artSollast == translate("IDC_LABEL_WARMLAST")) ||
            (toupper(artSollast) == "WARM"))
            ret = "WARM";
        return ret;
	},

    getGenericValue : function(/* string */ strPath, /* int */ asDouble)
    {
		var strRet = getstring(strPath, this._storeBasePath);
        if (asDouble)
            return inputStringToDouble(strRet);
        return strRet;
    },
    
	getSchellenWerkstoffVorgabe : function() 
	{
        return getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_WERKSTOFF", this._storeBasePath);
	},

	setSchellenWerkstoffVorgabe : function(strVorgabe) 
	{
        setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_WERKSTOFF", this._storeBasePath, strVorgabe);
	},

	getSchellenWerkstoffVorgabeAsInteger : function() 
	{
        var strWerkstoff = getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_WERKSTOFF", this._storeBasePath);
        var intWS = this.getZahlFromWerkstoff(strWerkstoff);

        return intWS;
	},
	
	getZahlFromWerkstoff : function(strWerkstoff) 
	{
        var intWS = 0;
        if (strWerkstoff == "S235 JRG2")                intWS = 0;
        else if (strWerkstoff == "16Mo3")               intWS = 1;
        else if (strWerkstoff == "13CrMo4-5")           intWS = 2;
        else if (strWerkstoff == "10CrMo9-10")          intWS = 3;
        else if (strWerkstoff == "X6CrNiTi18-10")       intWS = 4;
        else if (strWerkstoff == "X6CrNiMoTi17-12-2")   intWS = 5;
        else if (strWerkstoff == "X10CrMoVNb9-1")       intWS = 6;
		else if (strWerkstoff == "X5CrAITi31-20")       intWS = 7;
		else if (strWerkstoff == "X8CrNiTi18-10")       intWS = 8;
		else if (strWerkstoff == "X5CrNi18-10")        intWS = 9;
		
        return intWS;
	},

	getWerkstoffFromZahl : function(intWS) 
	{
        var strWerkstoff = "";
        if      (intWS == 0) strWerkstoff = "S235 JRG2";
        else if (intWS == 1) strWerkstoff = "16Mo3";
        else if (intWS == 2) strWerkstoff = "13CrMo4-5";
        else if (intWS == 3) strWerkstoff = "10CrMo9-10";
        else if (intWS == 4) strWerkstoff = "X6CrNiTi18-10";
        else if (intWS == 5) strWerkstoff = "X6CrNiMoTi17-12-2";
        else if (intWS == 6) strWerkstoff = "X10CrMoVNb9-1";
		else if (intWS == 7) strWerkstoff = "X5CrAITi31-20";
		else if (intWS == 8) strWerkstoff = "X8CrNiTi18-10";
		else if (intWS == 9) strWerkstoff = "X5CrNi18-10";
		
        return strWerkstoff;
	},
	
	getWerkstoffNrFromZahl : function(intWS) 
	{
        var strWerkstoff = "";
        if      (intWS == 0) strWerkstoff = "1.0038";
        else if (intWS == 1) strWerkstoff = "1.5415";
        else if (intWS == 2) strWerkstoff = "1.7335";
        else if (intWS == 3) strWerkstoff = "1.7380";
        else if (intWS == 4) strWerkstoff = "1.4541";
        else if (intWS == 5) strWerkstoff = "1.4571";
        else if (intWS == 6) strWerkstoff = "1.4903";
		else if (intWS == 7) strWerkstoff = "1.4958";
		else if (intWS == 8) strWerkstoff = "1.4878";
		else if (intWS == 9) strWerkstoff = "1.4301";
		
        return strWerkstoff;
	},
	
	getOberflaecheFromZahl : function(intObfl)
	{
		var strOberflaeche	= "";
		if		(intObfl == 0)	strOberflaeche = translate("IDS_OBERFL_ROH");
		else if	(intObfl == 1)	strOberflaeche = translate("IDS_OBERFL_GALVAN");
		//else if	(intObfl == 2)	strOberflaeche = translate("IDS_OBERFL_FEUER");
		else if	(intObfl == 2)	strOberflaeche = translate("IDC_OBERFL_2_TXT");
		else if	(intObfl == 3)	strOberflaeche = translate("IDS_OBERFL_GRUND");
		else if	(intObfl == 4)	strOberflaeche = translate("IDS_OBERFL_SONST");
		
		return strOberflaeche;
	},

	getMediumTemperatur : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_MEDIUM", asDouble);
	},
    
	getUmgebungsTemperatur : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_UMGEBUNG", asDouble);
	},

	getReferenzTemperatur : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_REFERENZ", asDouble);
	},

	getNormRohrAussendurchmesser : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER", asDouble);
	},
    
	getRohrAussendurchmesser : function(/* int */ asDouble) 
	{
        var strSonder = getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER_CHECK", this._storeBasePath);
        if (strSonder != "")
            return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER", asDouble);
        
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER", asDouble);
	},
    
	getVorgabeSonderRAD : function() 
	{
        var nRet = 0;
        var strSonder = getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER_CHECK", this._storeBasePath);
        if (strSonder != "")
            nRet = 1;
        
        return nRet;
	},
    
	getSpannweite : function(/* int */ asDouble) 
	{
        var strSonder = getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE_SONDER_CHECK", this._storeBasePath);
        if (strSonder != "")
            return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE_SONDER", asDouble);
        
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", asDouble);
	},
	
	getNormSpannweite : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", asDouble);
	},
    
	getVorgabeSonderSpann : function() 
	{
        var nRet = 0;
        var strSonder = getstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE_SONDER", this._storeBasePath);
        if (strSonder != "")
            nRet = 1;
        
        return nRet;
	},
    
	getDaemmdicke : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE", asDouble);
	},
    
	getNennweite : function(/* int */ asDouble) 
	{
        return this.getGenericValue("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_NENNWEITE_DN", asDouble);
	},

    getHoehenMasse : function(bIsDritteHLinie)
    {
        var retObj = { H1 : "-", H2 : "-", H2 : "-" };

        var lkTyp           = this.getLastketteTyp();
        var lkLastabtragung = this.getLastketteLastabtragung();

        if (left(lkTyp, 5) == "LAGER" && !bIsDritteHLinie){
			retObj.H1 = getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            retObj.H3 = getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		else if (left(lkTyp, 5) == "LAGER" && bIsDritteHLinie){
			retObj.H1 = getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
			retObj.H2 = getstring("MITTE", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            retObj.H3 = getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL");
		}
		else if ((lkTyp == "EINZEL_HAENGER") || (lkTyp == "EINZEL_SCHELLE") || 
		    (lkTyp == "EINZEL_ZUBEHOER") || (lkTyp == "EINZEL_LAGER"))
        {
            retObj.H1 = getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            retObj.H3 = getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        }
        else if ((lkTyp == "GELENKSTUETZE") || 
                 (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE"))
        {
            if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                 (lkLastabtragung == "STUETZEND_DOPPEL"))
            {
                retObj.H3 = getstring("BA",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                retObj.H1 = getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
            else
            {
                retObj.H1 = getstring("BA",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                retObj.H3 = getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
        }
        else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                 (lkLastabtragung == "STUETZEND_DOPPEL"))
        {
            retObj.H1 = getstring("RMT",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            retObj.H3 = getstring("UBA", "DLGDATA.CA.FORMS.HOEHENLEVEL");
        }
        else
        {
            if (bIsDritteHLinie)
            {
                retObj.H1 = getstring("OBA",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                retObj.H2 = getstring("HAENG",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                retObj.H3 = getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
            else
            {
                retObj.H1 = getstring("OBA",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
                retObj.H3 = getstring("RMT", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            }
        }
        return retObj;
    },
    
    getTraegerdaten : function()
    {
		// Schon mal darber nachgedacht ?? --gl--
		// this.base ist im constructor definiert
		// var sto = this.base.DEFINITION_STAHLBAU
		// var retObj = { traegertyp: sto.IDC_TRAEGER, ... }
		// Also das fnd ich schner wie diesen getstring Kram.
        var retObj = {traegertyp:       getstring("DEFINITION_STAHLBAU.IDC_TRAEGER", this._storeBasePath),
                      traegergroesse:   getstring("DEFINITION_STAHLBAU.IDC_TRAEGER_GROESSE", this._storeBasePath),
                      traegerhoehe:     getstring("DEFINITION_STAHLBAU.IDC_TRAEGERHOEHE", this._storeBasePath),
                      traegerbreite:    getstring("DEFINITION_STAHLBAU.IDC_TRAEGERBREITE", this._storeBasePath),
                      flanschdicke:     getstring("DEFINITION_STAHLBAU.IDC_FLANSCHDICKE", this._storeBasePath)
                     };
        return retObj;
    },
    
    getLKinfoDaten : function()
    {
		var retObj = {	markierung		:	trimright(trimleft(getstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", this._storeBasePath), " "), " "),
						extramarkierung	:	trimright(trimleft(getstring("EXTRAMARKIERUNG.IDC_EXTRAMARKIERUNG", this._storeBasePath), " "), " "),
						zeichnungsnr	:	trimright(trimleft(getstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", this._storeBasePath), " "), " "),
						bemerkung		:	trimright(trimleft(getstring("UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN", this._storeBasePath), " "), " "),
						anfrageposition	:	trimright(trimleft(getstring("UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS", this._storeBasePath), " "), " "),
						kundenzeichnnr	:	trimright(trimleft(getstring("CUSTOMER_CODE", "DLGDATA"), " "), " ")
                     };
        return retObj;
    },
	
	getBildInfoLGRicht : function()
	{
		var strlkRohrverlauf	= caMainController.dataAccess.getLastketteRohrverlauf();
		var strlkRohrrichtung	= left(getstring("IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 1);
		var strKSVariante		= getstring("KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var strKSSenkrAchse		= getstring("SENKR_ACHSE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		var strBildVariante		= "Var";
		var strLGHauptRicht		= atoi(right(strKSVariante, 1));
		var AchsDirInfo			= this.getAchsKSInfo();
		
		if (strlkRohrverlauf == "HORIZONTAL")
		{
			switch (strKSSenkrAchse)
			{
				case 'X':
					{
						if (((strlkRohrrichtung == "Y") && (strLGHauptRicht % 2 != 0)) || ((strlkRohrrichtung == "Z") && (strLGHauptRicht % 2 == 0)))
							strLGHauptRicht	= "2";
						else
							strLGHauptRicht	= "1";
						break;
					}
				case 'Y':
					{
						if (((strlkRohrrichtung == "Z") && (strLGHauptRicht % 2 != 0)) || ((strlkRohrrichtung == "X") && (strLGHauptRicht % 2 == 0)))
							strLGHauptRicht	= "2";
						else
							strLGHauptRicht	= "1";
						break;
					}
				case 'Z':
					{
						if (((strlkRohrrichtung == "X") && (strLGHauptRicht % 2 != 0)) || ((strlkRohrrichtung == "Y") && (strLGHauptRicht % 2 == 0)))
							strLGHauptRicht	= "2";
						else
							strLGHauptRicht	= "1";
						break;
					}
			}
		}
		else
		{
			strBildVariante = "RV";
			switch (getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN"))
			{
				case ("PL_" + AchsDirInfo[1]):
					strLGHauptRicht = "11";
					break;
				case ("MI_" + AchsDirInfo[1]):
					strLGHauptRicht = "12";
					break;
				case ("PL_" + AchsDirInfo[2]):
					strLGHauptRicht = "21";
					break;
				case ("MI_" + AchsDirInfo[2]):
					strLGHauptRicht = "22";
					break;
				default:
					strLGHauptRicht = "11";
					break;
			}
        }
		
		 var retObj = {strBildVariante: strBildVariante,
						strLGHauptRicht: strLGHauptRicht}
		return retObj;
	},
	
	/**
     * testet, ob laut Systemcharakteristik ein Lager grundstzlich mglich ist
	 * Zur Zeit sind Lager nur mglich bei 
	 *
	 * @params -
	 * @returns	boolean true: Lager grundstzlich mglich/kann gewhlt werden
	 *                  false: Lager nicht mglich
     */
	isLastketteMitLagerMoeglich : function()
	{
		var lkTyp = getstring( "SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", this._storeBasePath );
		var lkRohrverlauf = getstring( "SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", this._storeBasePath );
		var lkLastabtragung = getstring( "SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", this._storeBasePath );
		
		var bLager = false;
		if ( lkTyp == "EINZEL_LAGER" )		// einzelnes Lager
			bLager = true;
		else if ( (( lkTyp == "BEWEGLICH" ) || ( lkTyp == "STARR" )) && ( lkRohrverlauf == "HORIZONTAL" ) )
		{
			// Lager mglich bei beweglich, horizontal, sttzend einfach oder hngend doppelt
			bLager = ( ( lkLastabtragung == "STUETZEND_EINFACH" ) || ( lkLastabtragung == "HAENGEND_DOPPEL" ) );
            /* Mglich ist es hier in jedem Fall, ob gewollt hngt von u.g. Auswahl ab:
			if ( bLager && ( lkLastabtragung == "HAENGEND_DOPPEL" ) )
			{
				// aus dem in Auswahl Schelle gewhlten Bild rausfinden, ob Lager gewhlt oder nicht
				var strSelectedImageID = getstring( "IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_SCHELLE" );
				bLager = ( strSelectedImageID == 'LAGER_DUMMY' );
			}
            */
		}
		
		return( bLager );
	},

    // Preis = m_dKundenPreis in Klasse Produkt; m_bPreisVorgabe und m_Ppreis in Klasse Produkt entsprechend setzen ...
    // Einbaumass = m_Pemass in Klasse Produkt
    // Gewicht = m_Pgewicht in Klasse Produkt
    // Werkstoff = m_Pwerkname in Klasse Produkt, dort dann m_Pwerkstoff auf W_SONST setzen...
    // Zeichnungsnummer derzeit nicht in Maske, in Klasse Produkt: m_Pzeichnr
    
    setSonderteilToDataObject : function(data, sonderteil)
    {
        data.STUECKZAHL         = sonderteil.nAnzahl;  // Zahl!
        if (sonderteil.bAssistent)
            data.IDC_EINGABEART_STKL = "AUSWAHLASSI";
        else
            data.IDC_EINGABEART_STKL = "FREIE_EINGABE";
        data.RH_TYP             = sonderteil.RHTyp;
        if (sonderteil.m_Pemass == 0)
            data.EINBAUMASS     = "";
        else
            data.EINBAUMASS     = "" + sonderteil.m_Pemass;          // Zahl!
        if (sonderteil.m_Pgewicht == 0)
            data.GEWICHT        = "";
        else
            data.GEWICHT        = "" + sonderteil.m_Pgewicht;        // Zahl!

        if ((sonderteil.m_dKundenPreis == 0) || (getstring("PRICES_ENABLED", "RIGHTS") != "1"))
            data.PREIS          = "";
        else
            data.PREIS          = "" + sonderteil.m_dKundenPreis;    // Zahl!
        data.WERKSTOFF          = sonderteil.m_Pwerkname;
        data.WI_MATNR           = sonderteil.WIMatnr;

        data.ZEICHNR_BEMERKUNG = "";
        for (var i = 0; i < sonderteil.Artikeltext.length; i++)
            data.ZEICHNR_BEMERKUNG  += sonderteil.Artikeltext[i] + "\n";
        
        data.ZEICHNR_BEMERKUNG = trimright(data.ZEICHNR_BEMERKUNG, "\n");

        data.LAENGE           = sonderteil.RMLaenge;
        data.BREITE           = sonderteil.RMBreite;
        
        data.OBFLSCHUTZ      = "";   
		data.OBFLSCHUTZ_FREI = "";
		if (sonderteil.bOberflaechenschutzFrei) // ((data.LAENGE > 0) || (data.BREITE > 0))
		{
			data.OBFLSCHUTZ = sonderteil.m_Poberfl;
			if (sonderteil.m_Poberfl == "OB_SONST")
				data.OBFLSCHUTZ_FREI = sonderteil.m_PoberflFrei;
		}

		if (sonderteil.bAssistent)
		{
			data.STAHLBAU     = sonderteil.strFertigungsverfahren;
			data.OBFL_ERLAUBT = "" + sonderteil.bOberflaechenschutzFrei;
			data.MAX_LAENGE	  = "" + sonderteil.RMMaxLaenge;
			data.MAX_BREITE   = "" + sonderteil.RMMaxBreite;

			data.DATA_MASSE   = "" + sonderteil.m_strMasse;
			data.DATA_EMASS   = "" + sonderteil.m_Pemass;
			data.DATA_LOGICID   = "" + sonderteil.m_Pcpartid;
		}
		else
		{
			data.STAHLBAU 	  = "";
			data.OBFL_ERLAUBT = "0";
			data.MAX_LAENGE	  = "0";
			data.MAX_BREITE   = "0";

			data.DATA_MASSE   = "";
			data.DATA_EMASS   = "";
			data.DATA_LOGICID   = "";
		}
        
    },

    setDataObjectToSonderteil : function(data, sonderteil)
    {
        sonderteil.nAnzahl          = atoi(data.STUECKZAHL);  
        if (data.IDC_EINGABEART_STKL == "AUSWAHLASSI")
            sonderteil.bAssistent = 1;
        else
            sonderteil.bAssistent = 0;
        sonderteil.RHTyp            = data.RH_TYP;
        sonderteil.m_Pemass         = atoi(data.EINBAUMASS);
        sonderteil.m_Pgewicht       = atod(data.GEWICHT, 2);
        
        if (getstring("PRICES_ENABLED", "RIGHTS") == "1")
        {
			// Fremdwaehrungen: Im Kundenpreis steht immer der eingegebene Preis in Fremdwhrung;
			// Im Standard-Feld m_Ppreis steht dann der umgerechnete Euro-preis, der auch zum Aufsummieren
			// in der LK benutzt wird (dort nur Euro).
			var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
			if (dCurrencyFactor < 0.01)
				dCurrencyFactor = 1.0;
            sonderteil.m_dKundenPreis   = atod(data.PREIS, 2);
            sonderteil.m_bPreisVorgabe  = 1;
            sonderteil.m_Ppreis         = sonderteil.m_dKundenPreis / dCurrencyFactor;
        }
        
        sonderteil.m_Pwerkname      = data.WERKSTOFF;
        sonderteil.m_Pwerkstoff     = "W_SONST";
        sonderteil.WIMatnr          = data.WI_MATNR;

        sonderteil.RMLaenge = atoi(data.LAENGE);
        sonderteil.RMBreite = atoi(data.BREITE);
		
		if (sonderteil.bAssistent)
		{
			sonderteil.strFertigungsverfahren = data.STAHLBAU;
			sonderteil.bOberflaechenschutzFrei = atoi(data.OBFL_ERLAUBT);
			sonderteil.RMMaxLaenge = atoi(data.MAX_LAENGE);
			sonderteil.RMMaxBreite = atoi(data.MAX_BREITE);

			sonderteil.m_strMasse = data.DATA_MASSE;
			// sonderteil.m_Pemass = data.DATA_EMASS; schon oben
			sonderteil.m_Pcpartid = data.DATA_LOGICID;
		}
		else
		{
			sonderteil.strFertigungsverfahren = "";
			sonderteil.bOberflaechenschutzFrei = 0;
			sonderteil.RMMaxLaenge = 0;
			sonderteil.RMMaxBreite = 0;

			sonderteil.m_strMasse = "";
			// sonderteil.m_Pemass = data.DATA_EMASS; schon oben
			sonderteil.m_Pcpartid = "";
		}
        
        sonderteil.Artikeltext = data.ZEICHNR_BEMERKUNG.split('\n');   // Std-Javascript-Funktion!

        // sonderteil.m_Poberfl        = "OB_SONST";           
        sonderteil.m_Poberfl        = "OB_LEER";   
		sonderteil.m_PoberflFrei 	= "";
		if (sonderteil.bOberflaechenschutzFrei)	// ((atoi(data.LAENGE) > 0) || (atoi(data.BREITE) > 0))  // nur bei Rohmassposition aus Assistent!
		{
			sonderteil.m_Poberfl = data.OBFLSCHUTZ;
			var AnzZ = sonderteil.Artikeltext.length;	// Anzahl der Zeilen
			//Text nur einfuegen, wenn er noch nicht da ist
			var analyseTyp = trimleft(translate("OBERFLAECHENSCHUTZ"), " ");
			var k = 0;
			while (k < analyseTyp.length)
			{
				if (analyseTyp[i] == " ")
					break;
				k++;
			}
			
			if (left(sonderteil.Artikeltext[AnzZ-1], k) != translate("OBERFLAECHENSCHUTZ"))
				sonderteil.Artikeltext[AnzZ] = translate("OBERFLAECHENSCHUTZ") + " " + translate(OberflaechenschutzTransID[sonderteil.m_Poberfl]);
			else
				sonderteil.Artikeltext[AnzZ-1] = translate("OBERFLAECHENSCHUTZ") + " " + translate(OberflaechenschutzTransID[sonderteil.m_Poberfl]);
			
			if (sonderteil.m_Poberfl == "OB_SONST")
			{
				sonderteil.m_PoberflFrei = data.OBFLSCHUTZ_FREI;
				
				if (left(sonderteil.Artikeltext[AnzZ-1], k) != translate("OBERFLAECHENSCHUTZ"))
					sonderteil.Artikeltext[AnzZ] = translate("OBERFLAECHENSCHUTZ") + " " + data.OBFLSCHUTZ_FREI;
				else
					sonderteil.Artikeltext[AnzZ-1] = translate("OBERFLAECHENSCHUTZ") + " " + data.OBFLSCHUTZ_FREI;
			}
		}
        
        sonderteil.m_Ptyp       = "";
        if (sonderteil.Artikeltext > 0)
            sonderteil.m_Ptyp       = sonderteil.Artikeltext[0];

        /*
        if ((sonderteil.RMLaenge > 0) && (sonderteil.RMBreite > 0))
            sonderteil.m_Ptyp       += " " +  sonderteil.RMLaenge + "x" + sonderteil.RMBreite + "mm";
        else if (sonderteil.RMLaenge > 0)
            sonderteil.m_Ptyp       += " L=" +  sonderteil.RMLaenge + "mm";
        else if (sonderteil.RMBreite > 0)
            sonderteil.m_Ptyp       += " L=" +  sonderteil.RMBreite + "mm";
        */
        
		var strSQLStatement = "select * from MATERIAL where MAT_NR="+sonderteil.WIMatnr+" ";
		var numRet = dbselect("SAP_M", strSQLStatement, "NUMMER");
		sonderteil.Typ = dbgetstring("NUMMER", "KLASSE");
		
        sonderteil.m_Ptypid = "SON";
        sonderteil.m_Pzeichnr = "SONDERTEIL";   // hier nur ID eintragen, spter dann bersetzen

    },
	
	CreatePath : function(PATH)
	{
		var TEMPPathSplit	= PATH.split("\\");
		var TEMPPath		= TEMPPathSplit[0] + "\\";
		var DirExists		= 0;
		for (var a=1; a<=TEMPPathSplit.length; a++){
			if (!FileName.dirExists(TEMPPath))
				FileName.createDir(TEMPPath);
			if (FileName.dirExists(TEMPPath)){
				if (a == TEMPPathSplit.length)
					DirExists = 1;
				else
					TEMPPath += TEMPPathSplit[a] + "\\";
			}
			else
				break;	// konnte nicht angelegt werden
		}
		return (DirExists);
	},
	
	getLKParts : function(stkList)
	{
		var strParts	= "";
		var bRichtRel	= false;
		for (var Part=0; Part < stkList.length; Part++){
			var doZMM	= false
			if (stkList[Part].produkt.m_Ptypid == "ZMM" && typeof(stkList[Part].threeD) != "undefined")
				doZMM	= true;
			var isLKPart	= true;
			if (stkList[Part].produkt.m_Ptypid == "ZHM" || stkList[Part].produkt.m_Ptypid == "SON")	// keine Kupplung und keine Sonderteile
				isLKPart	= false;
			else if (stkList[Part].produkt.m_Ptypid == "ZMM" && !doZMM)	// nur Muttern wenn OBA / UBA
				isLKPart	= false;
			else if (stkList[Part].produkt.m_Ptypid == "ZRM"){
				if (rfind(strParts, "ZRM") > -1 && rfind(strParts, "FHG") < 0)	// nur 1x "ZRM"
					isLKPart	= false;
				else if (rfind(strParts, "FHG") > -1 && right(strParts, 4) != "FHG_" && right(strParts, 6) != "FHGGR_")	// ggf. noch 1x "ZRM" nach dem FHG
					isLKPart	= false;
			}
			/*
			if ((stkList[Part].produkt.m_Ptypid != "ZHM"  &&		// keine Kupplung
				stkList[Part].produkt.m_Ptypid != "SON" &&		// keine Sonderteile
				stkList[Part].produkt.m_Ptypid != "ZMM" && !doZMM)
				||
				(stkList[Part].produkt.m_Ptypid == "ZRM" && rfind(strParts, "ZRM") < 0)
				||
				doZMM	// nur Muttern wenn UBA
				)
			*/
			if (isLKPart){
				// Schellen HZx/HBx/... und Verbindungslaschen ZVx
				if (toupper(left(stkList[Part].produkt.m_Ptypid, 1)) == "H" ||
					toupper(left(stkList[Part].produkt.m_Ptypid, 2)) == "ZV")
					strParts	+= left(stkList[Part].produkt.m_Ptypid, 2) + "x_";
				else{
					// FH/KH bzw. FS/KS "gross" bzw. "klein"
					if ((toupper(left(stkList[Part].produkt.m_Ptypid, 2)) == "FH"	||
						toupper(left(stkList[Part].produkt.m_Ptypid, 2)) == "FS")	&&
						stkList[Part].produkt.groesse*1 > 11)
							strParts	+= stkList[Part].produkt.m_Ptypid + "GR_";
					else if ((toupper(left(stkList[Part].produkt.m_Ptypid, 2))	== "KH"		||
							toupper(left(stkList[Part].produkt.m_Ptypid, 2))	== "KV"		||
							toupper(left(stkList[Part].produkt.m_Ptypid, 2))	== "KS")	&&
							stkList[Part].produkt.groesse*1 > 14)
							strParts	+= stkList[Part].produkt.m_Ptypid + "GR_";
					// Bestimme Lagerbilder
					else if (toupper(left(stkList[Part].produkt.m_Ptypid, 2))	== "LS"		||	// LSL / LSF
							toupper(left(stkList[Part].produkt.m_Ptypid, 2))	== "LX"){		// LXL / LXF
							// Typ 20 bis 22 - 31/32 - 61/62 Unterscheidung in RSt und NICHT RSt
							// Typ x1 und x2 bekommen die gleichen Bilder
							if (stkList[Part].produkt.strBauF*1 == 61 || stkList[Part].produkt.strBauF*1 == 62 ||
								stkList[Part].produkt.strBauF*1 == 31 || stkList[Part].produkt.strBauF*1 == 32 ||
								stkList[Part].produkt.strBauF*1 == 21 || stkList[Part].produkt.strBauF*1 == 22 ||
								stkList[Part].produkt.strBauF*1 == 20)
							{
								var WStKenner	= Werkstoffe[stkList[Part].produkt.m_Pwerkstoff];
								WStKenner		= (WStKenner*1 != 37 ? "XX" : WStKenner);
								var strBauF		= (stkList[Part].produkt.strBauF*1 == 20 ? "20" : left(stkList[Part].produkt.strBauF,1) + "x");
								strParts		+= stkList[Part].produkt.m_Ptypid + strBauF + WStKenner + "_";
							}
							else
								strParts		+= stkList[Part].produkt.m_Ptypid + stkList[Part].produkt.strBauF + "_";
					}
					// Unterscheidung "ZKN" und "ZKB"
					else if (toupper(left(stkList[Part].produkt.m_Ptypid, 3))	== "ZKN")
						strParts	+= toupper(left(stkList[Part].produkt.m_Ptyp, 3)) + "_";
					else
						strParts	+= stkList[Part].produkt.m_Ptypid + "_";
				}
			}
		}
		if (rfind(strParts, "KH") > (-1) || rfind(strParts, "KV") > (-1) || rfind(strParts, "KS") > (-1))
			bRichtRel	= true;
		//return strParts;
		return {strParts : strParts, RichtRel : bRichtRel};
	}

};
