﻿/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2007-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2007-2008 Plan Software GmbH (http://www.plansoft.de)
 */

CascadeCsvManager = function(strType)
{
    this.strType = strType;
    
	// übersetzen
	this.transl = {
			OK:			translate("Aktion ausgeführt !"),
			ACTION:		translate("Fehler bei dieser Aktion!"),
			ERR_NODATA:	translate("Keine Daten zur Ausgabe gefunden!"),
			ERR_FDEL:	translate("Ausgabedatei kann nicht gelöscht werden!"),
			ERR_FTEMPL:	translate("Template nicht gefunden oder falsches Format")+": "
		};

	this.bError = false;
	this.msgOK = this.transl.OK;
	this.msgError = this.transl.ACTION;

	// Verarbeitung XML Template
	if (this.strType == "HLIST")
		this.strTemplateFile = "hlistdat.xml";
	else if (this.strType == "DLIST")
		this.strTemplateFile = "dlistdat.xml";
	else
		this.strTemplateFile = "sapdat.xml";
	this.strTemplateHeadBuffer = "";
	this.strTemplateTailBuffer = "";
	this.strTemplateWorksheet = "";

	// eigene Styles für Listen
	//	SLC	SCC	SRC	NLC	NCC	NRC	TBK	R45	R90

	this.styles = [];

	// auszugebende Liste - Index für columns
	this.listTyp = "";

	// Spaltenbreiten der einzelnen Listen
	// die letzen 5 (Anzahl, Gewicht, Preis) immer rechtsbündig, Spaltenbreite gem. AGP !!
	this.rowHeadHeight = "70";
	this.columnDefaultWidth = "50";
	this.columnSpecialWidth = "38";
    
    if (this.strType == "KDAUFTRAG")
        this.columns = [ 30, 30, 50, 30, 130, 30, 60, 240, 30 ];
    else if (this.strType == "HLIST")
		this.columns = [ 34, 22, 25, 25, 19, 31, 33, 38, 40, 33, 48, 60, 30, 31, 28, 33, 95, 25, 68 ];
	else if (this.strType == "DLIST")
		this.columns = [ 112, 30, 30, 30, 30, 102, 102, 102, 102, 112 ];
	else
        this.columns = [ 60, 60, 30, 30, 50, 50, 30, 30, 50, 30, 30, 30, 150, 150, 40, 40, 40, 40, 40, 40 ];

	this.outWorksheetsName = [];
	this.outWorksheets = [];

	this.strOutFile = "";
	this.strInFile = "";

	this.aLines = [];
	this.aData = [];
	this.maxColumns = 0;
};


CascadeCsvManager.prototype =
{

    writeCsvAsXml : function(csvFilename)
    {
		var j;
		var CsvDaten, strZeile;

		var nAnzRows = stringtoarray(readfile(csvFilename), "TEMP.CSV_WORK", "\r\n");
		for(j = 0; j < nAnzRows; j++)
		{
			strZeile = getstring("VALUE", arraypath("TEMP.CSV_WORK", j));
			strZeile = trimleft(trimright(strZeile, " "), " ");
			if(strZeile != "" && left(strZeile, 2) != "//")
				this.aLines[ aLines.length ] = strZeile;
		}
		delete("CSV_WORK", "TEMP");

		// Stückliste von allen Positionen
		this.prepareCsv();
		if(this.bError == true)
			return;

        var strOutfile = replace(csvFilename, ".csv", ".xls");
		this.xmlSetFileOutput(strOutfile);
		if(this.bError == true)
			return;

		this.xmlPrepareTemplateFile();
		if(this.bError == true)
			return;

		/*
		this.prepareTemplateFile();
		if(this.bError == true)
			return;
		*/
		
		if(this.bError == false);
		{
			this.outWorksheetsName[nSheet] = this.transl.SHEET_SL;
			this.xmlDataToXml(nSheet);
			nSheet++;
		}

		/// schreibe falls was gefunden wurde
		if(this.outWorksheets.length > 0)
			this.xmlWriteTemplateFile();
    },

	xmlSetFileOutput : function(datei)
	{
		this.bError = false;
		filecommand("unlink", datei);

		// Fehler falls Datei noch vorhanden !
		var fn = new FileName(datei);
		if(fn.fileExists())
		{
			this.msgError = this.transl.ERR_FDEL;
			this.bError = true;
			return false;
		}
		this.strOutFile = datei;
		return true;
	},

    xmlPrepareTemplateFile : function()
    {
		var strPrgPath  = getstddirectory("PROGRAM");
		this.strTemplateFile = strPrgPath + this.strTemplateFile;

		var buffer = "";
		buffer = readfile(this.strTemplateFile);

		var i = buffer.length;
		var posT = -1, posH = -1, posW = -1;

		// Header anpassen und intern speichern:	bis vor <Worksheet>
		// Tail intern speichern					ab <WorksheetOptions>
		// </Worksheet> und </Workbook> selbst anhängen
		posH = buffer.indexOf("<Worksheet");
		posT = buffer.indexOf("<WorksheetOptions");
		posW = buffer.indexOf("</Worksheet>");

		if(posH == -1 || posT == -1)
		{
			this.bError = true;
			this.msgError = this.transl.ERR_FTEMPL + this.strTemplateFile;		//replace(this.strTemplateFile, "\\", "\\\\");
			return;
		}
		this.strTemplateHeadBuffer = buffer.left(posH-1);
		this.strTemplateTailBuffer = buffer.substring(posT, posW);

		// setze CREATE Datum
		this.xmlWorkbookHeader();

		posH = buffer.indexOf("<Row");
		this.strTemplateWorksheet = buffer.substring(posH, posT);

		// Styles einfügen: vor </Styles>
		var nStyleBase = 100;
		// suche freie Nummer
		while(buffer.indexOf("ss:ID=\"s"+nStyleBase)>0)
			nStyleBase++;

		var nStyle = nStyleBase;

		this.styles = {
			SLC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			SCC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			SRC: "ss:StyleID=\"s"+(nStyle++)+"\"",
			NLC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			NCC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			NRC: "ss:StyleID=\"n"+(nStyle++)+"\"",
			TBK: "ss:StyleID=\"s"+(nStyle++)+"\"",
			TBR: "ss:StyleID=\"s"+(nStyle++)+"\"",
			R45: "ss:StyleID=\"s"+(nStyle++)+"\"",
			R90: "ss:StyleID=\"s"+(nStyle++)+"\"",
			T2L: "ss:MergeAcross=\"1\" ss:StyleID=\"m"+(nStyle++)+"\"",
			S2C: "ss:MergeAcross=\"1\" ss:StyleID=\"m"+(nStyle++)+"\""
		};

		if (this.strType != "HLIST" && this.strType != "DLIST")
			// Vertikal Mitte und Zeilenumbruch
			var vert_wrap = " ss:Vertical=\"Center\" ss:WrapText=\"1\"";
		else
			var vert_wrap = " ss:Vertical=\"Center\" ss:WrapText=\"0\"";

		if (this.strType == "HLIST" || this.strType == "MLIST" || this.strType == "DLIST"){
			// Rahmen überall
			var border = "\r\n<Borders>" +
				"\r\n<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
				"\r\n<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
				"\r\n<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
				"\r\n<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"1\"/>" +
				"\r\n</Borders>";
		}
		else
			// KEIN Rahmen
			var border = "";

		// Farben
		var color = {
			Rot:			"#FF0000",
			Gruen:			"#00FF00",
			Blau:			"#0000FF",
			Hellgelb:		"#FFFF99",
			Helltuerkis:	"#CCFFFF"
		};

		// schreiben
		nStyle = nStyleBase;
		var clrBack = color.Helltuerkis;
		this.strTemplateHeadBuffer = replace(this.strTemplateHeadBuffer, "</Styles>",
			"<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"n" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"n" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\"" + vert_wrap + "/>" + border +
			"\r\n<NumberFormat ss:Format=\"Fixed\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"" + clrBack + "\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Right\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"" + clrBack + "\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:Rotate=\"45\"/>" +
			"\r\n<Interior ss:Color=\"" + clrBack + "\" ss:Pattern=\"Solid\"/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"s" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:Rotate=\"90\" ss:WrapText=\"1\"/>" +
			"\r\n<Interior ss:Color=\"" + clrBack + "\" ss:Pattern=\"Solid\"/>" + border +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"m" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Left\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/>" + border +
			"\r\n<Interior ss:Color=\"" + clrBack + "\" ss:Pattern=\"Solid\"/>" +
			"\r\n</Style>" +
			"\r\n<Style ss:ID=\"m" + (nStyle++) + "\">" +
			"\r\n<Alignment ss:Horizontal=\"Center\"" + vert_wrap + "/>" + border +
			"\r\n</Style>" +
			"\r\n</Styles>"	)

		// Zeilen ab <DATA> löschen
		//"#DATA#"
		var buffer2 = "";
		buffer2 = this.strTemplateWorksheet;

		posT = buffer2.indexOf("#DATA#");
		posH = buffer2.lastIndexOf("<Row", posT);
		buffer2 = buffer2.left(posH);
		
		if (this.strType == "HLIST" || this.strType == "DLIST"){
		// Projektdaten setzen
		// Werte
		buffer2 = buffer2.replace("#VERS#", getstring("VERSION_STRING", ""));
		buffer2 = buffer2.replace("#PROJEKT#", getstring("IDC_PROJEKTNAME_EDIT", "IDD_PROJECTLISTE"));
		buffer2 = buffer2.replace("#BESTNR#", "");
		buffer2 = buffer2.replace("#SAPNR#", getstring("IDC_WI_SAPNR_EDIT", "IDD_PROJECTLISTE")+" / "+getstring("IDC_WI_BENUTZER_EDIT", "IDD_PROJECTLISTE"));
		var strSprache	= getstring("IDC_WI_SPRACHEKOMM_COMBO", "IDD_PROJECTLISTE");
		if (strSprache != "DE" && strSprache != "EN")
			strSprache	= "EN";
		buffer2 = buffer2.replace("#LANG#", strSprache);
		buffer2 = buffer2.replace("#KUNDE#", getstring("IDC_FIRMENNAME_VON", "IDD_PROJECTLISTE"));
		buffer2 = buffer2.replace("#ANGEBOT#", getstring("IDC_WI_ANGEBOTSNR_EDIT", "IDD_PROJECTLISTE"));
		buffer2 = buffer2.replace("#DATUM#", getstring("DATE", ""));
		
		buffer2 = buffer2.replace("#", "");					// # nicht erlaubt
		}
		
		this.strTemplateWorksheet = buffer2;
	},

    xmlWriteTemplateFile : function()
    {
		var anzSheet = this.outWorksheets.length;
		if(anzSheet <= 0)
		{
			this.bError = true;
			this.msgError = this.transl.ERR_NODATA;
			return;
		}

		writefile(this.strOutFile, this.strTemplateHeadBuffer, "wc");

		for(var i = 0; i < anzSheet; i++)
		{
			writefile(this.strOutFile, this.outWorksheets[i], "a");
			writefile(this.strOutFile, this.xmlWorksheetFooter(), "a");
			writefile(this.strOutFile, this.xmlWorksheetOptions(i), "a");
			writefile(this.strOutFile, "</Worksheet>\r\n", "a");
		}

		writefile(this.strOutFile, "</Workbook>\r\n", "a");
		
		// zusätzlich als xml schreiben (WIN11)
		FileName.copyFile(this.strOutFile, this.strOutFile.replace(".xls", ".xml"), true);

		this.bError = false;
		this.msgOK = this.transl.OK_FGEN + this.strOutFile;		//replace(this.strOutFile, "\\", "\\\\");

        var strOutfileShort = FileName.getShortPath(this.strOutFile);

		//if (right(this.strType, 4) != "LIST")
		if (getstring("SALESVERSION" , "RIGHTS") != "true")
			shellexecuteex( strOutfileShort, "", "", 1 );    // show = 1
		else
			//xml öffnen (WIN11 - SalesVersion)
			shellexecuteex( this.strOutFile.replace(".xls", ".xml"), "", "", 1 );    // show = 1
	},

	xmlWorkbookHeader : function()
	{
		var posT = -1, posH = -1;
		var buffer = this.strTemplateHeadBuffer;

		// Header anpassen und intern speichern:	bis vor <Worksheet>
		// Tail intern speichern					ab <WorksheetOptions>
		posH = buffer.indexOf("<Created");
		posT = buffer.indexOf("</Created>");
		// falls nicht vorhanden
		if(posH == -1 || posT == -1)
			return;

		this.strTemplateHeadBuffer = buffer.left(posH) + "<Created>" + this.strDateZ + buffer.substring(posT);
	},

	xmlWorkbookFooter : function()
	{
		return this.strTemplateTailBuffer;
	},

	xmlWorksheetHeader : function(name)
	{
		return "<Worksheet ss:Name=\"" + name + "\">" +
			(this.strType == "HLIST" ? '\r\n<Names>\r\n<NamedRange ss:Name="Print_Titles" ss:RefersTo="='+name+'!R3:R6"/>\r\n</Names>' : "") +
			(this.strType == "DLIST" ? '\r\n<Names>\r\n<NamedRange ss:Name="Print_Titles" ss:RefersTo="='+name+'!R4:R6"/>\r\n</Names>' : "") +
			"\r\n<Table x:FullColumns=\"1\" x:FullRows=\"1\" ss:DefaultColumnWidth=\"100\" ss:DefaultRowHeight=\"12\">\r\n";
	},

	xmlWorksheetFooter : function()
	{
		return "</Table>\r\n";
	},

	xmlWorksheetOptions : function(nSheet)
	{
		var title = "Preview";		//this.outWorksheetsName[nSheet];

		var buffer = this.strTemplateTailBuffer;
		buffer = buffer.replace("BLATTNAME", title);

		return buffer;
	},

	xmlWorksheetColumnDefinition : function(colcount)
	{
		var i;
		var buffer = "";
		// definierte Breite der Spalten
		for(i=0; i < colcount && i < this.columns.length; i++)
			buffer += "<Column ss:Width=\"" + this.columns[ i ] + "\"/>\r\n";
		// nicht definiert -> Standardbreite
		for(; i < colcount; i++)
			buffer += "<Column ss:Width=\"" + this.columnDefaultWidth + "\"/>\r\n";
		return buffer;
	},

    xmlDataToXml : function(nSheet)
    {
		// das leere Template kopieren und Titel ändern
		var i, j, buffer, style, styleU, styleC;
		var title = "Preview";		//this.outWorksheetsName[nSheet];

		buffer = this.xmlWorksheetHeader(title) + "\r\n";
		buffer += this.xmlWorksheetColumnDefinition(this.maxColumns-1);
		buffer += this.strTemplateWorksheet;
		buffer += "\r\n<!-- " + title + " -->\r\n\r\n";

		while(buffer.indexOf("BLATTNAME") > 0)
			buffer = buffer.replace("BLATTNAME", title);

		var idx = this.outWorksheets.length;
		this.outWorksheets[idx] = buffer;

		var dataLen, dataLenSub;
		dataLen = this.aData.length;

		buffer = "";
		for(i = 0; i < dataLen; ++i)
		{
			dataLenSub = this.aData[i].length;

			// Marker in 1.Spalte
			j = 1;

			// Zeile beginnt
			buffer = "\t<Row>\r\n";

			// Daten ab Pos.1 ausgeben
			for (; j < dataLenSub; ++j)
			{
				if(this.aData[i][0] != "U")
					styleC = this.styles.SLC;
				else
					styleC = this.styles.TBK;
				// Formeln einbauen
				/*
				if (rfind(this.aData[i][j], "=") > 0)
					buffer += '\t\t<Cell ' + styleC + ' ss:Formula="' + this.aData[i][j] +
								'"><Data ss:Type=\"Number\">1</Data></Cell>\r\n';
				*/
				/*else*/ if(this.aData[i][j] != null && this.aData[i][j] != "")
					buffer += "\t\t<Cell " + styleC + "><Data ss:Type=\"String\">" +
								this.aData[i][j] + "</Data></Cell>\r\n";
				else
					buffer += "\t\t<Cell " + this.styles.SLC +"/>\r\n";
			}
			buffer += "\t</Row>\r\n";
			this.outWorksheets[idx] += buffer;
		}
	},

	prepareCsv : function()
	{
		var i, j, nCols;
		var strVal, strTyp;
		var nDataRow = 0;
		var strLastTyp = "~";
		var nRows = this.aLines.length;

		if(nRows == 0)
		{
			this.bError = true;
			this.msgError = this.transl.ERR_NODATA;
			return;
		}

		for(i = 0; i < nRows; i++)
		{
			nCols = stringtoarray(this.aLines[i], "TEMP.CSV_WORK", ";");
			strTyp = getstring("VALUE", arraypath("TEMP.CSV_WORK", 0));

			this.maxColumns = max(this.maxColumns, nCols);

			//if(strLastTyp != strTyp)
			if(strLastTyp != strTyp && this.strType != "HLIST" && this.strType != "MLIST" && this.strType != "DLIST")
			{
				this.aData[nDataRow] = [ 'U' ];
				// Überschrift über alle Spalten des Abschnitts
				for(j = 0; j < nCols; j++) this.aData[nDataRow][j+1] = ' ';
				nDataRow++;
				strLastTyp = strTyp;
			}
			// Marker in 1.Spalte
			this.aData[nDataRow] = [ '' ];
			for(j = 0; j < nCols; j++)
			{
				strVal = getstring("VALUE", arraypath("TEMP.CSV_WORK", j));
				this.aData[nDataRow][j+1] = ansi2utf8(strVal);
			}
			nDataRow++;
			delete("CSV_WORK", "TEMP");
		}
		delete("CSV_WORK", "TEMP");

	// Spaltenüberschriften
		nRows = this.aData.length;
		// fortl.Nummer
		nDataRow = 0;
		for(i = 0; i < nRows; i++)
		{
			if(this.aData[i][0] == 'U')
			{
                strVal = this.aData[i+1][1];
                
				switch(strVal)
				{
					case "AP":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'Herku';
						this.aData[i][3] = 'AngNr';
						this.aData[i][4] = 'Pos';
						this.aData[i][5] = 'Matnr';
						this.aData[i][6] = 'KdMat';
						this.aData[i][7] = 'KpTyp';
						this.aData[i][8] = 'VrkMe';
						this.aData[i][9] = 'Menge';
						this.aData[i][10] = 'GewEi';
						this.aData[i][11] = 'BrGew';
						this.aData[i][12] = 'WaerS';
						this.aData[i][13] = 'Preis';
						this.aData[i][14] = 'Verpa';
						this.aData[i][15] = 'Fracht';
						this.aData[i][16] = 'AbnaE';
						this.aData[i][17] = 'AbnaI';
						this.aData[i][18] = 'Poena';
						this.aData[i][19] = 'Ruest';
						this.aData[i][20] = 'Akkre';
						this.aData[i][21] = 'ExAbn';
						this.aData[i][22] = 'KDE';
						this.aData[i][23] = 'ARKTX';
						this.aData[i][24] = 'Markierung';
						this.aData[i][25] = 'ABGRU';
						this.aData[i][26] = 'LPRIO';
						break;
					case "VP":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'Herku';
						this.aData[i][3] = 'AngNr';
						this.aData[i][4] = 'Pos';
						this.aData[i][5] = 'AtNam';
						this.aData[i][6] = 'AtLfd';
						this.aData[i][7] = 'AtWrt';
						this.aData[i][8] = 'Einheit';
						break;
					case "VT":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'Herku';
						this.aData[i][3] = 'AngNr';
						this.aData[i][4] = 'Pos';
						this.aData[i][5] = 'TxtId';
						this.aData[i][6] = 'Lang';
						this.aData[i][7] = 'Zeile';
						this.aData[i][8] = 'Text';
						break;
					case "AK":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'Herku';
						this.aData[i][3] = 'AngNr';
						this.aData[i][4] = 'User';
						this.aData[i][5] = 'KuNr';
						this.aData[i][6] = 'ProNr';
						this.aData[i][7] = 'AusNr';
						this.aData[i][8] = 'Lang';
						break;
					case "ASTL-KOPF":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'AngNr';
						this.aData[i][3] = 'Pos';
						this.aData[i][4] = 'Herku';
						this.aData[i][5] = 'Matnr';
						this.aData[i][6] = 'Datum';
						this.aData[i][7] = 'BMeng';
						break;
					case "ASTL-POS":
						this.aData[i][1] = 'SaArt';
						this.aData[i][2] = 'AngNr';
						this.aData[i][3] = 'Pos';
						this.aData[i][4] = 'Herku';
						this.aData[i][5] = 'Matnr';
						this.aData[i][6] = 'SPOSN';
						this.aData[i][7] = 'LFDSP';
						this.aData[i][8] = 'Postyp';
						this.aData[i][9] = 'IdNrK';
						this.aData[i][10] = 'Menge';
						this.aData[i][11] = 'Einh.';
						this.aData[i][12] = 'FixMg';
						this.aData[i][13] = 'Postxt1';
						this.aData[i][14] = 'Postxt2';
						this.aData[i][15] = 'RohMs1';
						this.aData[i][16] = 'RohMeI';
						this.aData[i][17] = 'RohMs2';
						this.aData[i][18] = 'RohMs3';
						this.aData[i][19] = 'RFormat';
						this.aData[i][20] = 'DsPst';
						break;
				}
				nDataRow++;
			}
		}
	}

};





