/**
 * Cascade Hilfsfunktionen fr 2D CAD
 *
 * Copyright (c) 2007 Witzenmann GmbH: Plan Software GmbH
 *
 * @category
 * @package
 * @copyright Copyright (c) 2007 Witzenmann GmbH: Plan Software GmbH
 */

function cad_setval(varname, val)
{
	setstring(varname, "TMP.CAD_ADDITIONAL_DATA", val);
}

function cad_getstring(varname)
{
	return getstring(varname, "TMP.CAD_ADDITIONAL_DATA");
}

function cad_getint(varname)
{
	return atoi(getstring(varname, "TMP.CAD_ADDITIONAL_DATA"));
}

function cad_getdouble(varname)
{
	return getdouble(varname, "TMP.CAD_ADDITIONAL_DATA");
}
// NEW FUNCTION [WI]: getDouble fr diverse Parameter (z.B. Daemmdicke, Temperaturen etc)
function config_getdouble(varname)
{
	return getdouble(varname, "DLGDATA.CA.FORMS");
}

function selection_getdouble(varname)
{
	return getdouble(varname, "DLGDATA.CA.SELECTION");
}

TwoDCADGenerator = function(theHandleLayout, theOptions)
{
	/**
   *
   * @var
   */

	this.HandleLayout = 0;      // die Gesamtzeichnung
	this.Options = null;        // ein Objekt mit Optionen fr die Zeichnungsgenerierung

    if (theHandleLayout)
        this.HandleLayout = theHandleLayout;
    if (theOptions)
        this.Options = theOptions;
};

TwoDCADGenerator.prototype =
{

  /**
   * Haupt-Funktion zum Einsprung
   * Von hier aus werden unterschiedliche Funktionen fr die Produkte aufgerufen ...
   *
   * PARAMETER:
   * hndDrawing:    Handle fr das Zeichnungsobjekt, das erstellt wird
   * Typid:         Die ersten 3 Zeichen der Typbezeichnung
   * rotation:      Drehung: eine Zahl; mgliche Werte: 0, 90, 180, 270
   * Emass:         Das Einbaumass, das zur Darstellung benutzt werden soll (bei Gewindestangen relevant)
   * threeDparams:  Die Parameter, die auch ans 3D bergeben werden
  */ 
  insertProduct2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, cadMacroParamObject)
  {
    // -mw- 17.8.2008: Rckgabeobjekt speichert die Ausdehnung nach
    // links und rechts von der gedachten Mittellinie aus (relevant fr den
    // Anfang der Linie der Positionsnummer, sowie fr den Abstand der Bemaungen),
    // die gewnschte Y-Position der Linie der Positionsnummer relativ zum 0-Punkt
    // der Einzelzeichnung, sowie die gewnschte Lnge der Linie der Positionsnummer.
    var retObj = {  xMassTop:	  0,    // X-Abstand obere Bem.-Linie von Mittellinie
					xMassBottom:  0,    // X-Abstand untere Bem.-Linie von Mittellinie
					xWidthLeft:   0,    // Max. Ausdehnung Produkt links von Mittellinie
                    xWidthRight:  0,    // Max. Ausdehnung Produkt rechts von Mittellinie
					yWidthBottom: 0,	// Max. Ausdehnung Produkt unterhalb Masskettenende
                    xDist:		  0,    // X-Abstand Anfang Linie Pos-Nr von Mittellinie
					yDist:        0,    // y-Abstand Linie Pos-Nr vom y-Nullpunkt
                    L_PosNr:      0,    // gewnschte Lnge der Linie der Positionsnummer
                    index:        0,    // "Layer" auf den die Zeichnung gelegt wird (0 wird zuerst gemalt, danach aufsteigend bis 20)
					Naht:		  0,	// Info ber Schweissnaht
					B_Lager:	  0		// Lagerfussbreite
				 }
    // Zuweiseung z.B.:
    // retObj.xWidthLeft = 123;
    // retObj.xWidthRight = 123;
    // retObj.yDist = 123;
    // retObj.L_PosNr = 123;
  
    switch (Typid)
    {
        case   "FDT":
			this.insertFDT2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "FHD":
            this.insertFHD2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "FHG":
			this.insertFHG2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "FHS":
			this.insertFHS2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "FSG":
			this.insertFSG2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "FSP":
			this.insertFSx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "FSS":
			this.insertFSx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "HBN":
			this.insertHBx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HBS":
			this.insertHBx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HBV":
			this.insertHBx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
            break;
        case   "HDN":
			this.insertHDx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HDS":
			this.insertHDx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HDV":
			this.insertHDx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
            break;
        case   "HGN":
			this.insertHGx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HGV":
			this.insertHGx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "HZN":
			this.insertHZx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
			break;
        case   "HZS":
			this.insertHZx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
			break;
        case   "HZV":
			this.insertHZx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
            break;
        case   "KHD":
			this.insertKHD2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "KHS":
			this.insertKHS2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "KSP":
			this.insertKSx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
			break;
        case   "KSR":
			this.insertKSx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "KVD":
			this.insertKVD2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "KVS":
			this.insertKVS2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "LRN":
			break;
        case   "LSL":
			this.insertLSL2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
			break;
		case   "LUR":
			this.insertLUR2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
			break;
        case   "LUS":
            break;
		case   "LXL":
			this.insertLSL2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
			break;
        case   "MBS":
			this.insertMBS2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "MSN":
			this.insertMSN2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "SSG":
			this.insertSSG2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "VBK":
			this.insertVBK2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
            break;
        case   "VGR":
			this.insertVSR_VGR_2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
            break;
        case   "VJK":
			break;
        case   "VJR":
            break;
        case   "VKK":
			this.insertVKK2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "VKR":
			this.insertVKR2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
            break;
        case   "VPR":
			this.insertVPR2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
			break;
        case   "VSR":
			this.insertVSR_VGR_2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
            break;
        case   "ZGM":
			this.insertZGM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
		case   "ZGW":
			this.insertZGW2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
            break;
        case   "ZHM":
			this.insertZHM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "ZKK":
			this.insertZKx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "ZKN":
			this.insertZKx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "ZLK":
			this.insertZLK2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "ZLM":
			this.insertZxM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject);
            break;
        case   "ZLN":
			this.insertZLN2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
		case   "ZLV":
			this.insertZLV2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options);
            break;
		case   "ZLB":
			this.insertZLB2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject);
            break;
        case   "ZMM":
			this.insertZMM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "ZOM":
            this.insertZOM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
			break;
        case   "ZPK":
            this.insertZPK2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject);
			break;
        case   "ZRM":
            this.insertZxM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject);
            break;
        case   "ZSM":
			this.insertZSM2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject);
            break;
        case   "ZTN":
			this.insertZTN2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options);
            break;
        case   "ZVN":
			this.insertZVx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "ZVS":
			this.insertZVx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "ZVV":
			this.insertZVx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
        case   "ZZF":
			this.insertZZx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
			break;
        case   "ZZK":
			this.insertZZx2D(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj);
            break;
			
        default:
            break;
    }
    
	return retObj;
 },

insertZMM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// hier werden 2 Muttern erzeugt
{
	var LGV = cad_getdouble("LGV");			// LGV
	var PosNr = threeDparams["PosNr0"]; 	// PosNr
	
	if (PosNr == 1)
	{
		this.add_ZMM(hndDrawing, 0, 0.9*LGV, LGV);
		this.add_ZMM(hndDrawing, 0, 1.8*LGV, LGV);
		
		retObj.yDist = 0.5 * LGV;
	};
	
	if (PosNr != 1)
	{
		this.add_ZMM(hndDrawing, 0, 0, LGV);
		this.add_ZMM(hndDrawing, 0, -0.9*LGV, LGV);
		
		retObj.yDist = -0.5 * LGV;
	};
	
	retObj.xMassTop = LGV;
	retObj.xMassBottom = LGV;
	retObj.xWidthLeft = LGV;
	retObj.xWidthRight = LGV;
	retObj.xDist = LGV;
	retObj.L_PosNr = LGV;
	retObj.index = 2;
	
},


insertZKx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// Klemmlasche FH/starre LK und KH
{
	var Btr = double (threeDparams["Traegerbreite0"]);	// Traegerbreite
	var tG = double (threeDparams["Flanschdicke0"]);	// Gurtdicke
	var Typ = threeDparams["Typ"];		// Subtyp
	var M = cad_getdouble ("M");		// Gewindegroesse Schraube
	var a = cad_getdouble ("A_");		// Abstand Schraubenmitte Lindapterende
	var s1 = cad_getdouble ("S1");		// Traegerplattendicke
	var s2 = cad_getdouble ("S2");		// Dicke Aufnahmeplatte fuer Gabel
	var b2 = cad_getdouble ("B2");		// Hoehe Aufnahmeplatte fuer Gabel
	var b = cad_getdouble ("B");		// Breite Lindapter
	var h3 = cad_getdouble ("H3");		// Hoehe Lindapter (Hauptteil)
	var A = cad_getdouble ("A");		// Laenge Lindapter
	var k = cad_getdouble ("K");		// Breite Lindapterende
	var f = cad_getdouble ("F");		// Bohrungsdurchmesser fuer Gabel
	var l1 = cad_getdouble ("L1");		// Laenge Traegerplatte
	var l2 = cad_getdouble ("L2");		// Breite Aufnahmeplatte fuer Gabel
	var LGV = cad_getdouble ("LGV");	// Lastgruppe
	
	switch (Typ)
	{
		case "ZKN 1":
		case "ZKN 2":
			if ((Rotation == 0) || (Rotation == 180))
			{
				cad_add_rect (hndDrawing, (-Btr/2 - a - M), 0, (Btr/2 + a + M), -s1, 7);
				if ((Typ == "ZKN 1" && ((Btr==82 && LGV==12) || (Btr==160 && LGV==16) || (Btr==180 && LGV==20))) || Typ == "ZKN 2")
 				{
					cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 7);
					cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 254);
				}
				else
				{
					cad_add_rect (hndDrawing, -l2/2, -s1, l2/2, (-s1 - b2), 7);
					cad_add_rect (hndDrawing, -l2/2, -s1, l2/2, (-s1 - b2), 254);
					cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
				}
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 + A/2), tG);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 + A/2), (tG + h3));
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a), (tG + h3));
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a), 0);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a + k), 0);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a + k), tG);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -Btr/2, -s1, (-Btr/2 - M), (-s1 - 2*M/3), 7);
				cad_add_rect (hndDrawing, -Btr/2, 0, (-Btr/2 - M), tG, 7);
				cad_add_rect (hndDrawing, -Btr/2, (tG + h3), (-Btr/2 - M), (tG + h3 + M), 7);
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 - A/2), tG);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 - A/2), (tG + h3));
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a), (tG + h3));
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a), 0);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a - k), 0);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a - k), tG);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, Btr/2, -s1, (Btr/2 + M), (-s1 - 2*M/3), 7);
				cad_add_rect (hndDrawing, Btr/2, 0, (Btr/2 + M), tG, 7);
				cad_add_rect (hndDrawing, Btr/2, (tG + h3), (Btr/2 + M), (tG + h3 + M), 7);
				
				retObj.xMassTop = Btr/2;
				retObj.xMassBottom = s2/2;
				retObj.xWidthLeft = Btr/2;
				retObj.xWidthRight = Btr/2;
				retObj.xDist = (Btr/2 + a + M);
				retObj.yDist = 0;
				retObj.L_PosNr = A;
				if ((Typ == "ZKN 1" && ((Btr==82 && LGV==12) || (Btr==160 && LGV==16) || (Btr==180 && LGV==20))) || Typ == "ZKN 2")
				{
					retObj.index = 2;
				}
				else
				{
					retObj.index = 1;
				};
			}
			else
			{
				cad_add_rect (hndDrawing, -l1/2, 0, l1/2, -s1, 7);
				if (Typ == "ZKN 1" && ((Btr==82 && LGV==12) || (Btr==160 && LGV==16) || (Btr==180 && LGV==20)) || Typ == "ZKN 2")
				{
					cad_add_rect (hndDrawing, -l2/2, -s1, l2/2, (-s1 - b2), 7);
					cad_add_rect (hndDrawing, -l2/2, -s1, l2/2, (-s1 - b2), 254);
					cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
				}
				else
				{
					cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 7);
					cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 254);
				}
				
				cad_add_rect (hndDrawing, (-l1/2 + b/2), 0, (-l1/2 + 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (l1/2 - b/2), 0, (l1/2 - 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (-l1/2 + b - M/2), -s1, (-l1/2 + b + M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (l1/2 - b + M/2), -s1, (l1/2 - b - M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (-l1/2 + b - M/2), (tG + h3), (-l1/2 + b + M/2), (tG + h3 + 1.5*M), 7);
				cad_add_rect (hndDrawing, (l1/2 - b + M/2), (tG + h3), (l1/2 - b - M/2), (tG + h3 + 1.5*M), 7);
				
				retObj.xMassTop = l1/2;
				retObj.xMassBottom = f/2;
				retObj.xWidthLeft = l1/2;
				retObj.xWidthRight = l1/2;
				retObj.xDist = l1/2;
				retObj.yDist = 0;
				retObj.L_PosNr = A;
				retObj.index = 2;
			}
			break;
			
		case "ZKB":
			
			var M_Gew = 12;
			if (Btr <= 200)
			{
				var l_Gew = 350;
				var l_Tr = 260;
			}
			else
			{
				var l_Gew = 460;
				var l_Tr = 370;
			}
			
			if ((Rotation == 0) || (Rotation == 180))
			{
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (-Btr/2 + 20), 0);
					cad_add_vertex (hndDrawing, -Btr/2, 0);
					cad_add_vertex (hndDrawing, -Btr/2, tG);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10), tG);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10), 30);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10 - 50), 30);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10 - 70), 10);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10 - 70), -20);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10 - 70 + 40), -40);
					cad_add_vertex (hndDrawing, (-Btr/2 + 10 - 70 + 80), -20);
				cad_end_poly (hndDrawing);
				
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (Btr/2 - 20), 0);
					cad_add_vertex (hndDrawing, Btr/2, 0);
					cad_add_vertex (hndDrawing, Btr/2, tG);
					cad_add_vertex (hndDrawing, (Btr/2 - 10), tG);
					cad_add_vertex (hndDrawing, (Btr/2 - 10), 30);
					cad_add_vertex (hndDrawing, (Btr/2 - 10 + 50), 30);
					cad_add_vertex (hndDrawing, (Btr/2 - 10 + 70), 10);
					cad_add_vertex (hndDrawing, (Btr/2 - 10 + 70), -20);
					cad_add_vertex (hndDrawing, (Btr/2 - 10 + 70 - 40), -40);
					cad_add_vertex (hndDrawing, (Btr/2 - 10 + 70 - 80), -20);
				cad_end_poly (hndDrawing);
				
				cad_add_rect (hndDrawing, (-Btr/2 + 20), 0, (Btr/2 - 20), -M_Gew, 7);
				cad_add_rect (hndDrawing, -l_Gew/2, 0, (-Btr/2 + 20 - 80), -M_Gew, 7);
				cad_add_rect (hndDrawing, l_Gew/2, 0, (Btr/2 - 20 + 80), -M_Gew, 7);
				
				cad_add_circle (hndDrawing, 0, -Emass, 6, 7);
				cad_add_circle (hndDrawing, (-Btr/2 + 20 - 40), -25, 5, 7);
				cad_add_circle (hndDrawing, (Btr/2 - 20 + 40), -25, 5, 7);
				
				if ((l_Tr/2) >= (Btr/2 - 20 + 80))
				{
					cad_begin_poly (hndDrawing, 0, 7);
						cad_add_vertex (hndDrawing, -l_Tr/2, -M_Gew);
						cad_add_vertex (hndDrawing, -l_Tr/2, (-M_Gew - 30));
						cad_add_vertex (hndDrawing, (-l_Tr/2 + 30), (-M_Gew - 45));
						cad_add_vertex (hndDrawing, (l_Tr/2 -30), (-M_Gew - 45));
						cad_add_vertex (hndDrawing, l_Tr/2, (-M_Gew - 30));
						cad_add_vertex (hndDrawing, l_Tr/2, -M_Gew);
					cad_end_poly (hndDrawing);
				}
				else
				{
					var alpha = atandeg(20/40);
					var l1 = 40 - ((Btr/2 - 20 + 80) - l_Tr/2);
					var h1 = 20 - l1*tandeg(alpha);
					
					cad_begin_poly (hndDrawing, 0, 7);
						cad_add_vertex (hndDrawing, -l_Tr/2, (-M_Gew - h1 - 8));
						cad_add_vertex (hndDrawing, -l_Tr/2, (-M_Gew - 30));
						cad_add_vertex (hndDrawing, (-l_Tr/2 + 30), (-M_Gew - 45));
						cad_add_vertex (hndDrawing, (l_Tr/2 -30), (-M_Gew - 45));
						cad_add_vertex (hndDrawing, l_Tr/2, (-M_Gew - 30));
						cad_add_vertex (hndDrawing, l_Tr/2, (-M_Gew - h1 - 8));
					cad_end_poly (hndDrawing);
				}
				
				retObj.xMassTop = l_Gew/2;
				retObj.xMassBottom = 6;
				retObj.xWidthLeft = l_Gew/2;
				retObj.xWidthRight = l_Gew/2;
				retObj.xDist = l_Gew/2;
				retObj.yDist = 0;
				retObj.L_PosNr = 40;
				retObj.index = 0;
			}
			else
			{
				// Koerperkanten
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, 13, 30);
					cad_add_vertex (hndDrawing, 7, 30);
					cad_add_vertex (hndDrawing, 7, 10);
					cad_add_vertex (hndDrawing, -7, 10);
					cad_add_vertex (hndDrawing, -7, 30);
					cad_add_vertex (hndDrawing, -13, 30);
					cad_add_vertex (hndDrawing, -13, -50);
					cad_add_vertex (hndDrawing, -7, -50);
					cad_add_vertex (hndDrawing, -7, -30);
					cad_add_vertex (hndDrawing, 7, -30);
					cad_add_vertex (hndDrawing, 7, -50);
					cad_add_vertex (hndDrawing, 13, -50);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -4, -30, 4, (-30 - 45 + 12), 7);
				cad_add_line (hndDrawing, -13, -30, 13, -30, 7);
				cad_add_line (hndDrawing, -13, 10, 13, 10, 7);
				cad_add_circle (hndDrawing, 0, -6, 6, 7);
				
				// Ausbrennen
				cad_begin_poly (hndDrawing, 1, 254);
					cad_add_vertex (hndDrawing, 13, 30);
					cad_add_vertex (hndDrawing, 7, 30);
					cad_add_vertex (hndDrawing, 7, 10);
					cad_add_vertex (hndDrawing, -7, 10);
					cad_add_vertex (hndDrawing, -7, 30);
					cad_add_vertex (hndDrawing, -13, 30);
					cad_add_vertex (hndDrawing, -13, -50);
					cad_add_vertex (hndDrawing, -7, -50);
					cad_add_vertex (hndDrawing, -7, -30);
					cad_add_vertex (hndDrawing, 7, -30);
					cad_add_vertex (hndDrawing, 7, -50);
					cad_add_vertex (hndDrawing, 13, -50);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -4, -30, 4, (-30 - 45 + 12), 254);
				
				retObj.xMassTop = 13;
				retObj.xMassBottom = 4;
				retObj.xWidthLeft = 13;
				retObj.xWidthRight = 13;
				retObj.xDist = 13;
				retObj.yDist = 0;
				retObj.L_PosNr = 20;
				retObj.index = 2;
			}
			break;
			
		case "ZKK":
		{
			var t = cad_getdouble ("T");			// Abstand der Bohrungen
			var z = cad_getdouble ("Z");			// Abstand der Bohrunge von Aussenkante
			var g = cad_getdouble ("G");			// Dmr 2. Bohrung
			
			if ((Rotation == 90)||(Rotation == 270))
			{
				cad_add_rect (hndDrawing, (-Btr/2 - a - M), 0, (Btr/2 + a + M), -s1, 7);
				cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 7);
				cad_add_rect (hndDrawing, -s2/2, -s1, s2/2, (-s1 - b2), 254);
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 + A/2), tG);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 + A/2), (tG + h3));
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a), (tG + h3));
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a), 0);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a + k), 0);
					cad_add_vertex (hndDrawing, (-Btr/2 - M/2 - a + k), tG);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -Btr/2, -s1, (-Btr/2 - M), (-s1 - 2*M/3), 7);
				cad_add_rect (hndDrawing, -Btr/2, 0, (-Btr/2 - M), tG, 7);
				cad_add_rect (hndDrawing, -Btr/2, (tG + h3), (-Btr/2 - M), (tG + h3 + M), 7);
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 - A/2), tG);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 - A/2), (tG + h3));
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a), (tG + h3));
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a), 0);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a - k), 0);
					cad_add_vertex (hndDrawing, (Btr/2 + M/2 + a - k), tG);
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, Btr/2, -s1, (Btr/2 + M), (-s1 - 2*M/3), 7);
				cad_add_rect (hndDrawing, Btr/2, 0, (Btr/2 + M), tG, 7);
				cad_add_rect (hndDrawing, Btr/2, (tG + h3), (Btr/2 + M), (tG + h3 + M), 7);
				
				retObj.xMassTop = Btr/2;
				retObj.xMassBottom = s2/2;
				retObj.xWidthLeft = Btr/2;
				retObj.xWidthRight = Btr/2;
				retObj.xDist = (Btr/2 + a + M);
				retObj.yDist = 0;
				retObj.L_PosNr = A;
				retObj.index = 2;
			}
			if (Rotation == 0)
			{
				cad_add_rect (hndDrawing, t/2-l1/2, 0, t/2+l1/2, -s1, 7);
				cad_add_rect (hndDrawing, -z, -s1, t+z, (-s1 - b2), 7);
				cad_add_rect (hndDrawing, -z, -s1, t+z, (-s1 - b2), 254);
				cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
				cad_add_circle (hndDrawing, t, -Emass, g/2, 7);
				cad_add_rect (hndDrawing, (t/2-l1/2 + b/2), 0, (t/2-l1/2 + 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (t/2+l1/2 - b/2), 0, (t/2+l1/2 - 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (t/2-l1/2 + b - M/2), -s1, (t/2-l1/2 + b + M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (t/2+l1/2 - b + M/2), -s1, (t/2+l1/2 - b - M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (t/2-l1/2 + b - M/2), (tG + h3), (t/2-l1/2 + b + M/2), (tG + h3 + 1.5*M), 7);
				cad_add_rect (hndDrawing, (t/2+l1/2 - b + M/2), (tG + h3), (t/2+l1/2 - b - M/2), (tG + h3 + 1.5*M), 7);
				
				retObj.xMassTop = l1/2-t/2;
				retObj.xMassBottom = f/2;
				retObj.xWidthLeft = l1/2-t/2;
				retObj.xWidthRight = l1/2+t/2;
				retObj.xDist = l1/2+t/2;
				retObj.yDist = 0;
				retObj.L_PosNr = A;
				retObj.index = 0;
			}
			if (Rotation == 180)
			{
				cad_add_rect (hndDrawing, -t/2-l1/2, 0, -t/2+l1/2, -s1, 7);
				cad_add_rect (hndDrawing, -t-z, -s1, z, (-s1 - b2), 7);
				cad_add_rect (hndDrawing, -t-z, -s1, z, (-s1 - b2), 254);
				cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
				cad_add_circle (hndDrawing, -t, -Emass, g/2, 7);
				cad_add_rect (hndDrawing, (-t/2-l1/2 + b/2), 0, (-t/2-l1/2 + 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (-t/2+l1/2 - b/2), 0, (-t/2+l1/2 - 1.5*b), (tG + h3), 7);
				cad_add_rect (hndDrawing, (-t/2-l1/2 + b - M/2), -s1, (-t/2-l1/2 + b + M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (-t/2+l1/2 - b + M/2), -s1, (-t/2+l1/2 - b - M/2), (-s1 - 0.75*M), 7);
				cad_add_rect (hndDrawing, (-t/2-l1/2 + b - M/2), (tG + h3), (-t/2-l1/2 + b + M/2), (tG + h3 + 1.5*M), 7);
				cad_add_rect (hndDrawing, (-t/2+l1/2 - b + M/2), (tG + h3), (-t/2+l1/2 - b - M/2), (tG + h3 + 1.5*M), 7);
				
				retObj.xMassTop = l1/2+t/2;
				retObj.xMassBottom = t+g/2;
				retObj.xWidthLeft = l1/2+t/2;
				retObj.xWidthRight = l1/2-t/2;
				retObj.xDist = l1/2-t/2;
				retObj.yDist = 0;
				retObj.L_PosNr = A;
				retObj.index = 0;
			}
		}
			
		default:
			break;
	}
},

insertZLK2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Schweisslasche KH
{
	var A = cad_getdouble("A");		// Laschenbeite
	var B = cad_getdouble("B");		// Laschenhoehe
	var z = cad_getdouble("Z");		// Abstand Aussenkante Bohrung
	var f = cad_getdouble("F");		// Bohrung 1
	var g = cad_getdouble("G");		// Bohrung 2
	var t = cad_getdouble("T");		// Abstand Bohrungen
	var s = cad_getdouble("S");		// Laschendicke
	var a = cad_getdouble("SCH_A");	// Info SN
	
	if (a == 0)
	{
		a = 1;
	}
	
	var Rotation_Int = int (Rotation);
	
	switch (Rotation_Int)
	{
		case 0:
			cad_add_rect (hndDrawing, -z, 0, (-z + A), -B, 7);		// Koerperkanten
			cad_add_rect (hndDrawing, -z, 0, (-z + A), -B, 254);	// Ausbrennen
			cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
			cad_add_circle (hndDrawing, t, -Emass, g/2, 7);
			
			retObj.xMassTop = z;
			retObj.xMassBottom = f/2;
			retObj.xWidthLeft = z;
			retObj.xWidthRight = (-z + A);
			retObj.xDist = (-z + A);
			retObj.yDist = -Emass/10;
			retObj.L_PosNr = B;
			retObj.index = 0;
			retObj.Naht = a;
			
			break;
			
		case 180:
			cad_add_rect (hndDrawing, (z - A), 0, z, -B, 7);		// Koerperkanten
			cad_add_rect (hndDrawing, (z - A), 0, z, -B, 254);		// Ausbrennen
			cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
			cad_add_circle (hndDrawing, -t, -Emass, g/2, 7);
			
			retObj.xMassTop = (A - z);
			retObj.xMassBottom = t + g/2;
			retObj.xWidthLeft = (A - z);
			retObj.xWidthRight = z;
			retObj.xDist = z;
			retObj.yDist = -Emass/10;
			retObj.L_PosNr = B;
			retObj.index = 0;
			retObj.Naht = a;
			
			break;
			
		case 90:
		case 270:
			cad_add_rect (hndDrawing, -s/2, 0, s/2, -B, 7);		// Koerperkanten
			cad_add_rect (hndDrawing, -s/2, 0, s/2, -B, 254);	// Ausbrennen
			
			retObj.xMassTop = s/2;
			retObj.xMassBottom = s/2;
			retObj.xWidthLeft = s/2;
			retObj.xWidthRight = s/2;
			retObj.xDist = s/2;
			retObj.yDist = -Emass/10;
			retObj.L_PosNr = B;
			retObj.index = 2;
			retObj.Naht = a;
			
			break;
			
		default:
			break;
	}
},

insertLSL2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// Lager Typ LSL21
{
	var Typ = threeDparams["Typ"];						// Lagertyp
	var WSt = threeDparams["Werkstoff"];				// Werkstoff
	var dA = threeDparams["Rohraussendurchmesser"];		// Rohraussendurchmesser
	//var daemmDicke = double(threeDparams["Daemmdicke"]);// Daemmdicke
	var DN = cad_getdouble("DN");						// Nennweite
	var A = cad_getdouble ("A");						// Lagerfussbreite
	//var s1 = cad_getdouble ("T");						// Lagerfussdicke
	var s1 = cad_getdouble ("TF");						// Lagerfussdicke
	var H = cad_getdouble ("H");						// Nennhoehe
	var L = cad_getdouble ("L");						// Lagerfusslaenge
	var dx = 0;											// Versatz der Schelle in x-Richtung
	var dy = 0;											// Versatz der Schelle in y-Richtung
	var k = 10;											// Abstand Schelle von Lageraussenkante
	var GP_A = A-20;									// Gleitplatte fr LXL-Lager
	var GP_L = L - 20;
	var GP_s = 3;										// Hhe der GP
	
	var daemmDicke = config_getdouble("LAGER_BETRIEBSBEDINGUNGEN.IDC_DAEMMDICKE");
	
	var rohr = Options["IDC_ROHR"];
	var daemmung = Options["IDC_DAEMMUNG"];
	
	// Linientypen
	var colRohr = 5;		// Rohr: blau
	var colMLinie = 1;		// Mittellinien: rot
	var colDaemm = 5; 		// Daemmung: blau
	
	var a = 0;										// Info SN
		
		if (cadMacroParamObject.stkListPrevPart == "ZTN")
		{
			if (DN < 400)
			{
				a = 3;
			}
			else
			{
				a = 4;
			}
		}
	
	if (Typid == "LSL") {			// keine Edelstahl-Gleitplatte am Fu
		GP_s = 0;	
	}
	
	
	if (Typid == "LXL") {
		s1 = s1-3;
	}
	
	switch (Typ)
	{
		case "LSL20":
		
		{	var h1 = 0;		// T-Fuhhe
			var h3 = 0;		// Hhe Zwischenstck
			var b3 = 50;	// Breite Zwischenstck
			var s3 = 10; 	// Tiefe Zwischenstueck	
			var l1 = 50;	// NH 140 only	
			if (H != 190){
						b3 = B;
			}
						
			// Werkstoff == 37
			
			// Schellendaten (HZN-BASF)
				var strSQLStatement = "select * from BAS where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "BAS");
				var sS = dbgetdouble("BAS", "S");	// Dicke der Schelle
				var f = dbgetdouble("BAS", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("BAS", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("BAS", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("BAS", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("BAS", "B");	// Schellenbreite
				
				if ((Rotation == 0) || (Rotation == 180))
					{
						// Schelle
						this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
						this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
						cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
						cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
						cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
						cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
						cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
						cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
						
						// Mittellinien fr Schrauben
						cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
						cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
						
						var intH = int(H);		// typecast -> as needed vor switch
						
						switch (intH)
						{
							case 85:
								h1 = 80;
								h3 = 0;
								// Fuss
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -A/2, -Emass);
									cad_add_vertex (hndDrawing, -A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, -s1/2, -Emass + s1);
									// cad_add_vertex (hndDrawing, -s1/2, -Emass + h1+h3);		// reales Ma
									cad_add_vertex (hndDrawing, -s1/2, -dA/2-sS);			// angepasst
									// cad_add_vertex (hndDrawing, s1/2, -Emass + h1+h3);		// reales Ma
									cad_add_vertex (hndDrawing, s1/2, -dA/2-sS);			// angepasst
									cad_add_vertex (hndDrawing, s1/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass);
								cad_end_poly(hndDrawing);
								
								
								
								break;
							
							case 140:
								h1 = 136;
								h3 = 0;
								// Fuss
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -A/2, -Emass);
									cad_add_vertex (hndDrawing, -A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, -s1/2, -Emass + s1);
									// cad_add_vertex (hndDrawing, -s1/2, -Emass + h1+h3);		// reales Ma
									cad_add_vertex (hndDrawing, -s1/2, -dA/2-sS);			// angepasst
									// cad_add_vertex (hndDrawing, s1/2, -Emass + h1+h3);		// reales Ma
									cad_add_vertex (hndDrawing, s1/2, -dA/2-sS);			// angepasst
									cad_add_vertex (hndDrawing, s1/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass);
								cad_end_poly(hndDrawing);
								break;
								
							case 190:
								h1 = 80;
								h3 = 105;
								// Fuss
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -A/2, -Emass);
									cad_add_vertex (hndDrawing, -A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, -s1/2, -Emass + s1);
									cad_add_vertex (hndDrawing, -s1/2, -Emass + h1);			
									cad_add_vertex (hndDrawing, s1/2, -Emass + h1);			
									cad_add_vertex (hndDrawing, s1/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass + s1);
									cad_add_vertex (hndDrawing, A/2, -Emass);
								cad_end_poly(hndDrawing);
								// Zwischenstueck
								cad_add_rect (hndDrawing, -s3/2, -Emass + h1, s3/2, -dA/2-sS, 7);
								break;	
							
							default:
								break;
						}
						retObj.xMassTop = AS/2;
						retObj.xMassBottom = A/2;
						retObj.xWidthLeft = AS/2;
						retObj.xWidthRight = AS/2;
						retObj.xDist = s1/2;
						retObj.yDist = (-Emass + h1/2);
						retObj.L_PosNr = A/2;
						retObj.Naht = a;
						retObj.B_Lager = A/2;
				}
					
							
				if ((Rotation == 90) || (Rotation == 270))
				{
				
					// Schellen
					cad_add_rect (hndDrawing, -B/2, (-dA/2 - sS), B/2, -f/2, 7);
					cad_add_rect (hndDrawing, -B/2, (dA/2 + sS), B/2, f/2, 7);
					cad_add_line (hndDrawing, -B/2, (-f/2 - sS), B/2, (-f/2 - sS), 7);
					cad_add_line (hndDrawing, -B/2, (f/2 + sS), B/2, (f/2 + sS), 7);
					cad_add_rect (hndDrawing, -c/2, (-f/2 - 2.5*sS), c/2, (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, - c/2, -f/2, + c/2, f/2, 7);
					cad_add_rect (hndDrawing, - c/2, (f/2 + 2*sS), c/2, (f/2 + sS), 7);
					
					// Rohr
					cad_add_rect(hndDrawing, -2.5*B, -dA/2, 2.5*B, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -1.25*B, dA/2, 1.25*B, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -1.25*B, -dA/2, 1.25*B, -dA/2-daemmDicke, colDaemm);		
					// Mittellinien fr Schelle 
					cad_add_line(hndDrawing, -2.5*B-sS/2, dy, 2.5*B+sS/2, dy, colMLinie);
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx, dy-f/2-2.5*sS-sS/2, dx, dy+f/2+2*sS+sS/2, colMLinie);
					
					var intH = int(H);		// typecast -> as needed vor switch
					
					switch (intH)
						{
							case 85:
							
								h1 = 80;
								h3 = 0;
								// Fuss 
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -L/2, -Emass);
									cad_add_vertex (hndDrawing, -L/2, -Emass + 25);
									cad_add_vertex (hndDrawing, -L/2+((h1-25)/tandeg(45)), -dA/2 - sS);
									cad_add_vertex (hndDrawing, L/2 - ((h1-25)/tandeg(45)), -dA/2 - sS);
									cad_add_vertex (hndDrawing, L/2, -Emass + 25);
									cad_add_vertex (hndDrawing, L/2, -Emass);
								cad_end_poly(hndDrawing);
								cad_add_line (hndDrawing, -L/2, -Emass + s1, L/2, -Emass + s1, 7);
								break;
							
							case 140:
							
								h1 = 136;
								h3 = 0;
								// Fuss 
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -L/2, -Emass);
									cad_add_vertex (hndDrawing, -L/2, -Emass + 22);
									cad_add_vertex (hndDrawing, -l1/2, -dA/2 - sS);
									cad_add_vertex (hndDrawing, l1/2, -dA/2 - sS);
									cad_add_vertex (hndDrawing, L/2, -Emass + 22);
									cad_add_vertex (hndDrawing, L/2, -Emass);
								cad_end_poly(hndDrawing);
								cad_add_line (hndDrawing, -L/2, -Emass + s1, L/2, -Emass + s1, 7);
								
								break;
								
							case 190:
								
								h1 = 80;
								h3 = 105;
								// Fuss 
								cad_begin_poly (hndDrawing, 1, 7);			
									cad_add_vertex (hndDrawing, -L/2, -Emass);
									cad_add_vertex (hndDrawing, -L/2, -Emass + 25);
									cad_add_vertex (hndDrawing, -L/2+((h1-25)/tandeg(45)), -Emass + h1);
									cad_add_vertex (hndDrawing, L/2 - ((h1-25)/tandeg(45)), -Emass + h1);
									cad_add_vertex (hndDrawing, L/2, -Emass + 25);
									cad_add_vertex (hndDrawing, L/2, -Emass);
								cad_end_poly(hndDrawing);
								cad_add_line (hndDrawing, -L/2, -Emass + s1, L/2, -Emass + s1, 7);
								// Zwischenstueck
								cad_add_rect (hndDrawing, -b3/2, -Emass + h1, b3/2, -dA/2 - sS, 7);
								break;	
							
							default:
							
								break;
							
						}
					
					retObj.xMassTop = B/2;
					retObj.xMassBottom = L/2;
					retObj.xWidthLeft = 2.5*B;
					retObj.xWidthRight = 2.5*B;
					retObj.xDist = L/2;
					retObj.yDist = (-Emass + A/2);
					retObj.L_PosNr = A/3;
				}
				
			break;
		}
			
		case "LXL21":
		case "LSL21":
		{
			if (double (WSt) == 37)
			{
				var s3 = 10; 	// Tiefe Zwischenstueck	
				
				// Schellendaten (HZN-BASF)
				var strSQLStatement = "select * from BAS where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "BAS");
				var sS = dbgetdouble("BAS", "S");	// Dicke der Schelle
				var f = dbgetdouble("BAS", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("BAS", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("BAS", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("BAS", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("BAS", "B");	// Schellenbreite
				var bZ = 50;						// Breite Zwischenstueck
				
				if ((Rotation == 0) || (Rotation == 180))
				{
					
					// Schelle
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
					
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					if (H != "85" && H != "88")		// 85 bei LSL, 88 bei LXL 
					{
						
						// Fuss T80 bei NH 140/ 143 und 190/ 193
						cad_begin_poly (hndDrawing, 1, 7);									// GP_s = 3 || 0
							cad_add_vertex (hndDrawing, -A/2, -Emass + GP_s);
							cad_add_vertex (hndDrawing, -A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, -Emass + GP_s + A);
							cad_add_vertex (hndDrawing, s1/2, -Emass + GP_s + A);
							cad_add_vertex (hndDrawing, s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, -Emass + GP_s);
						cad_end_poly(hndDrawing);
						
						// Zwischenstueck
						cad_add_rect (hndDrawing, -s3/2, (-Emass + GP_s + A), s3/2, (-dA/2 - sS), 7);				// GP_s = 3 || 0
					}
					else {
						// Fuss T80 bei NH 85 bzw 88
						cad_begin_poly (hndDrawing, 1, 7);									// GP_s = 3 || 0
							cad_add_vertex (hndDrawing, -A/2, -Emass + GP_s);
							cad_add_vertex (hndDrawing, -A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, -dA/2-sS);
							cad_add_vertex (hndDrawing, s1/2, -dA/2-sS);
							cad_add_vertex (hndDrawing, s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, -Emass + GP_s);
						cad_end_poly(hndDrawing);
					}	
					
					// Gleitplatte bei LXL
					if (Typ == "LXL21") {
						cad_add_rect(hndDrawing, -GP_A/2, -Emass, GP_A/2, -Emass + GP_s, 7);					// GP_s = 3 || 0
					} // else (nothing)
					
					retObj.xMassTop = AS/2;
					
					if (GP_s == 0) {
						retObj.xMassBottom = A/2;
					}
					else {
						retObj.xMasssBottom = GP_A/2;
					}	
					retObj.xWidthLeft = AS/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = s1/2;
					retObj.yDist = (-Emass + A/2);
					retObj.L_PosNr = A/2;
					retObj.Naht = a;
					retObj.B_Lager = A/2;
					
				}
				if ((Rotation == 90) || (Rotation == 270))
				{
					// Fuss T80
					if (H == 85 || H == 88) {
						cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -dA/2 - sS, 7);
						cad_add_line (hndDrawing, -L/2, (-Emass + GP_s + s1), L/2, (-Emass + GP_s + s1), 7);
					}
					else { // LXL/ LSL21 mit H = 140/190 oder 143/193
						cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -Emass + GP_s + A, 7);
						cad_add_line (hndDrawing, -L/2, (-Emass + GP_s + s1), L/2, (-Emass + GP_s + s1), 7);
					}
					
					
					if (H == 85 || H == 88){
						bZ = B;
					}
						
					// Schellen
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2), (-dA/2 - sS), (-L/2 + k + (bZ - B)/2 + B), -f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2), (-dA/2 - sS), (L/2 - k - (bZ - B)/2 - B), -f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2), (dA/2 + sS), (-L/2 + k + (bZ - B)/2 + B), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2), (dA/2 + sS), (L/2 - k - (bZ - B)/2 - B), f/2, 7);
					cad_add_line (hndDrawing, (-L/2 + k + (bZ - B)/2), (-f/2 - sS), (-L/2 + k + (bZ - B)/2 + B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (-L/2 + k + (bZ - B)/2), (f/2 + sS), (-L/2 + k + (bZ - B)/2 + B), (f/2 + sS), 7);
					cad_add_line (hndDrawing, (L/2 - k - (bZ - B)/2), (-f/2 - sS), (L/2 - k - (bZ - B)/2 - B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (L/2 - k - (bZ - B)/2), (f/2 + sS), (L/2 - k - (bZ - B)/2 - B), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), (-f/2 - 2.5*sS), (-L/2 + k + (bZ - B)/2 + B/2 + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), -f/2, (-L/2 + k + (bZ - B)/2 + B/2 + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), (f/2 + 2*sS), (-L/2 + k + (bZ - B)/2 + B/2 + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), (-f/2 - 2.5*sS), (L/2 - k - (bZ - B)/2 - B/2 - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), -f/2, (L/2 - k - (bZ - B)/2 - B/2 - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), (f/2 + 2*sS), (L/2 - k - (bZ - B)/2 - B/2 - c/2), (f/2 + sS), 7);
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L, -dA/2, 0.8*L, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);		
					// Mittellinien fr Schelle 
					cad_add_line(hndDrawing, -0.8*L - sS/2, dy, 0.8*L + sS/2, dy, colMLinie);				
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -L/2 + k + ((bZ - B)/2) + B/2, dy-f/2-2.5*sS-sS/2, -L/2 + k + ((bZ - B)/2) + B/2, dy+f/2+2*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, L/2 - k - ((bZ - B)/2) - B/2, dy-f/2-2.5*sS-sS/2, L/2 - k - ((bZ - B)/2) - B/2, dy+f/2+2*sS+sS/2, colMLinie);
					
					// Zwischenstueck
					if (H != "85" && H != "88")		// 85 bei LSL, 88 bei LXL 
					{
						cad_add_rect (hndDrawing, (-L/2 + k), (-Emass + GP_s + A), (-L/2 + k + bZ), (-dA/2 - sS), 7);
						cad_add_rect (hndDrawing, (L/2 - k), (-Emass + GP_s + A), (L/2 - k - bZ), (-dA/2 - sS), 7);
					}
					
					// Gleitplatte bei LXL
					if (Typ == "LXL21") {
						cad_add_rect(hndDrawing, -GP_L/2, -Emass, GP_L/2, -Emass + GP_s, 7);
					} // else (nothing)
					
					retObj.xMassTop = (L/2 - k - (bZ - B)/2);
					if (GP_s == 0) {
						retObj.xMassBottom = L/2;
					}
					else {
						retObj.xMasssBottom = GP_L/2;
					}	
					retObj.xWidthLeft = 0.8*L;
					retObj.xWidthRight = 0.8*L;
					retObj.xDist = L/2;
					retObj.yDist = (-Emass + A/2);
					retObj.L_PosNr = A/3;
				}
			}
			else			// anderer Werkstoff
			{
				// Schellendaten (HZN)
				var strSQLStatement = "select * from HZN where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "HZN");
				var sS = dbgetdouble("HZN", "S");	// Dicke der Schelle
				var f = dbgetdouble("HZN", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("HZN", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("HZN", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("HZN", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("HZN", "B");	// Schellenbreite
				
				var s2 = (s1 - 2);					// Stegdicke
				
				if ((Rotation == 0) || (Rotation == 180))
				{
					// Fuss
					cad_begin_poly (hndDrawing, 1, 7);
						cad_add_vertex (hndDrawing, -A/2, -Emass);
						cad_add_vertex (hndDrawing, -A/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, -s2/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, -s2/2, (-dA/2 - sS));
						cad_add_vertex (hndDrawing, s2/2, (-dA/2 - sS));
						cad_add_vertex (hndDrawing, s2/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, A/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, A/2, -Emass);
					cad_end_poly (hndDrawing);
					// Schelle
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
					
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					
					retObj.xMassTop = AS/2;
					retObj.xMassBottom = A/2;
					retObj.xWidthLeft = AS/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = s2/2;
					retObj.yDist = -Emass/2;
					retObj.L_PosNr = A/3;
					retObj.Naht = a;
					retObj.B_Lager = A/2;
					
				}
				else
				{
					// Fuss
					cad_add_rect (hndDrawing, -L/2, -Emass, L/2, (-Emass + s1), 7);
					cad_add_rect (hndDrawing, (-L/2 + k), (-Emass + s1), (L/2 - k), (-dA/2 - sS), 7);
					// Schellen
					cad_add_rect (hndDrawing, (-L/2 + 2*k), (-dA/2 - sS), (-L/2 + 2*k + B), -f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k), (-dA/2 - sS), (L/2 - 2*k - B), -f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k), (dA/2 + sS), (-L/2 + 2*k + B), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k), (dA/2 + sS), (L/2 - 2*k - B), f/2, 7);
					cad_add_line (hndDrawing, (-L/2 + 2*k), (-f/2 - sS), (-L/2 + 2*k + B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (-L/2 + 2*k), (f/2 + sS), (-L/2 + 2*k + B), (f/2 + sS), 7);
					cad_add_line (hndDrawing, (L/2 - 2*k), (-f/2 - sS), (L/2 - 2*k - B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (L/2 - 2*k), (f/2 + sS), (L/2 - 2*k - B), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), (-f/2 - 2.5*sS), (-L/2 + 2*k + B/2 + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), -f/2, (-L/2 + 2*k + B/2 + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), (f/2 + 2.5*sS), (-L/2 + 2*k + B/2 + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), (-f/2 - 2.5*sS), (L/2 - 2*k - B/2 - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), -f/2, (L/2 - 2*k - B/2 - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), (f/2 + 2.5*sS), (L/2 - 2*k - B/2 - c/2), (f/2 + sS), 7);
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L, -dA/2, 0.8*L, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);		
					// Mittellinien fr Schelle 
					cad_add_line(hndDrawing, -0.8*L - sS/2, dy, 0.8*L + sS/2, dy, colMLinie);				
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -L/2 + 2*k + B/2, dy-f/2-2.5*sS-sS/2, -L/2 + 2*k + B/2, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, L/2 - 2*k - B/2, dy-f/2-2.5*sS-sS/2, L/2 - 2*k - B/2, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					retObj.xMassTop = (L/2 - 2*k);
					retObj.xMassBottom = L/2;
					retObj.xWidthLeft = 0.8*L;
					retObj.xWidthRight = 0.8*L;
					retObj.xDist = (L/2 - k);
					retObj.yDist = -Emass/2;
					retObj.L_PosNr = A/3;
					
				}
			}
		break;
		}
		
		case "LSL22":
		case "LXL22":
		{
			if (double (WSt) == 37)
			{
				
				var s3 = 12; 	// Tiefe Zwischenstueck	
				
				// Schellendaten (HZN-BASF)
				var strSQLStatement = "select * from BAS where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "BAS");
				var sS = dbgetdouble("BAS", "S");	// Dicke der Schelle
				var f = dbgetdouble("BAS", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("BAS", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("BAS", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("BAS", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("BAS", "B");	// Schellenbreite
				var bZ = 60;						// Breite Zwischenstueck
				
				if ((Rotation == 0) || (Rotation == 180))
				{
					
					// Schellen
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
					
										
					if (H == "190" || H == "193")		// 190 bei LSL22, 193 bei LXL22 
					{
						// Fuss T100 bei NH 190 bzw 193
						cad_begin_poly (hndDrawing, 1, 7);									// GP_s = 3 || 0
							cad_add_vertex (hndDrawing, -A/2, -Emass + GP_s);
							cad_add_vertex (hndDrawing, -A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, -Emass + GP_s + A);
							cad_add_vertex (hndDrawing, s1/2, -Emass + GP_s + A);
							cad_add_vertex (hndDrawing, s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, -Emass + GP_s);
						cad_end_poly(hndDrawing);
						// Zwischenstueck
						cad_add_rect (hndDrawing, -s3/2, (-Emass + GP_s + A), s3/2, (-dA/2 - sS), 7);				// GP_s = 3 || 0
					}
					else {
						// Fuss T100 bei NH 105/140 bzw 108/143
						cad_begin_poly (hndDrawing, 1, 7);									// GP_s = 3 || 0
							cad_add_vertex (hndDrawing, -A/2, -Emass + GP_s);
							cad_add_vertex (hndDrawing, -A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, -s1/2, -dA/2-sS);
							cad_add_vertex (hndDrawing, s1/2, -dA/2-sS);
							cad_add_vertex (hndDrawing, s1/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, (-Emass + GP_s + s1));
							cad_add_vertex (hndDrawing, A/2, -Emass + GP_s);
						cad_end_poly(hndDrawing);
					}
					
					// Gleitplatte bei LXL
					if (Typ == "LXL22") {
						cad_add_rect(hndDrawing, -GP_A/2, -Emass, GP_A/2, -Emass + GP_s, 7);					// GP_s = 3 || 0
					} // else (nothing)
					
					retObj.xMassTop = AS/2;
					if (GP_s == 0) {
						retObj.xMassBottom = A/2;
					}
					else {
						retObj.xMassBottom = GP_A/2;
					}	
					retObj.xWidthLeft = AS/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = s1/2;
					retObj.yDist = (-Emass + A/2);
					retObj.L_PosNr = A/2;
					
				}
				
				if ((Rotation == 90) || (Rotation == 270))
				{
					// Fuss T100 bei NH 105/140 bzw 108/143 ohne Zwischenstueck
					if (H != 190 && H != 193) {
							cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -dA/2 - sS, 7);
							cad_add_line (hndDrawing, -L/2, (-Emass + GP_s + s1), L/2, (-Emass + GP_s + s1), 7);
					}
					else { // Fuss T100 bei NH 190 bzw 193 mit Zwischenstueck
						cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -Emass + GP_s + A, 7);
						cad_add_line (hndDrawing, -L/2, (-Emass + GP_s + s1), L/2, (-Emass + GP_s + s1), 7);
					}
					
					if (H != 190 && H != 193){
						bZ = B;			// bz minus B = 0 bei NH 105, 108, 140, 143
					}
						
					// Schellen
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2), (-dA/2 - sS), (-L/2 + k + (bZ - B)/2 + B), -f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2), (-dA/2 - sS), (L/2 - k - (bZ - B)/2 - B), -f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2), (dA/2 + sS), (-L/2 + k + (bZ - B)/2 + B), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2), (dA/2 + sS), (L/2 - k - (bZ - B)/2 - B), f/2, 7);
					cad_add_line (hndDrawing, (-L/2 + k + (bZ - B)/2), (-f/2 - sS), (-L/2 + k + (bZ - B)/2 + B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (-L/2 + k + (bZ - B)/2), (f/2 + sS), (-L/2 + k + (bZ - B)/2 + B), (f/2 + sS), 7);
					cad_add_line (hndDrawing, (L/2 - k - (bZ - B)/2), (-f/2 - sS), (L/2 - k - (bZ - B)/2 - B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (L/2 - k - (bZ - B)/2), (f/2 + sS), (L/2 - k - (bZ - B)/2 - B), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), (-f/2 - 2.5*sS), (-L/2 + k + (bZ - B)/2 + B/2 + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), -f/2, (-L/2 + k + (bZ - B)/2 + B/2 + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + k + (bZ - B)/2 + B/2 - c/2), (f/2 + 2*sS), (-L/2 + k + (bZ - B)/2 + B/2 + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), (-f/2 - 2.5*sS), (L/2 - k - (bZ - B)/2 - B/2 - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), -f/2, (L/2 - k - (bZ - B)/2 - B/2 - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - k - (bZ - B)/2 - B/2 + c/2), (f/2 + 2*sS), (L/2 - k - (bZ - B)/2 - B/2 - c/2), (f/2 + sS), 7);
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L, -dA/2, 0.8*L, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);	
					
					// Mittellinie fr Schelle 
					cad_add_line(hndDrawing, -0.8*L - sS/2, dy, 0.8*L + sS/2, dy, colMLinie);				
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -L/2 + k + ((bZ - B)/2) + B/2, dy-f/2-2.5*sS-sS/2, -L/2 + k + ((bZ - B)/2) + B/2, dy+f/2+2*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, L/2 - k - ((bZ - B)/2) - B/2, dy-f/2-2.5*sS-sS/2, L/2 - k - ((bZ - B)/2) - B/2, dy+f/2+2*sS+sS/2, colMLinie);
					
					// Zwischenstueck
					if (H == 190 || H == 193)							{
						cad_add_rect (hndDrawing, (-L/2 + k), (-Emass + GP_s + A), (-L/2 + k + bZ), (-dA/2 - sS), 7);
						cad_add_rect (hndDrawing, (L/2 - k), (-Emass + GP_s + A), (L/2 - k - bZ), (-dA/2 - sS), 7);
					}
					
					// Gleitplatte bei LXL
					if (Typ == "LXL22") {
						cad_add_rect(hndDrawing, -GP_L/2, -Emass, GP_L/2, -Emass + GP_s, 7);
					} // else (nothing)
					
					retObj.xMassTop = (L/2 - k - (bZ - B)/2);
					if (GP_s == 0) {
						retObj.xMassBottom = L/2;
					}
					else {
						retObj.xMasssBottom = GP_L/2;
					}	
					retObj.xWidthLeft = 0.8*L;
					retObj.xWidthRight = 0.8*L;
					retObj.xDist = L/2;
					retObj.yDist = (-Emass + A/2);
					retObj.L_PosNr = A/3;
				}
			}
			else			// anderer Werkstoff als 37
			{
				// Schellendaten (HZN)
				var strSQLStatement = "select * from HZN where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "HZN");
				var sS = dbgetdouble("HZN", "S");	// Dicke der Schelle
				var f = dbgetdouble("HZN", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("HZN", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("HZN", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("HZN", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("HZN", "B");	// Schellenbreite
				
				var s2 = (s1 - 2);					// Stegdicke
				
				if ((Rotation == 0) || (Rotation == 180))
				{
					// Fuss aus 2 Platten 
					cad_begin_poly (hndDrawing, 1, 7);
						cad_add_vertex (hndDrawing, -A/2, -Emass);
						cad_add_vertex (hndDrawing, -A/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, -s2/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, -s2/2, (-dA/2 - sS));
						cad_add_vertex (hndDrawing, s2/2, (-dA/2 - sS));
						cad_add_vertex (hndDrawing, s2/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, A/2, (-Emass + s1));
						cad_add_vertex (hndDrawing, A/2, -Emass);
					cad_end_poly (hndDrawing);
					// Schelle
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					retObj.xMassTop = AS/2;
					retObj.xMassBottom = A/2;
					retObj.xWidthLeft = AS/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = s2/2;
					retObj.yDist = -Emass/2;
					retObj.L_PosNr = A/3;
					retObj.Naht = a;
					retObj.B_Lager = A/2;
				}
				else		// Rotation = 90 oder 270 Grad
				{
					// Fuss
					cad_add_rect (hndDrawing, -L/2, -Emass, L/2, (-Emass + s1), 7);
					cad_add_rect (hndDrawing, (-L/2 + k), (-Emass + s1), (L/2 - k), (-dA/2 - sS), 7);
					// Schellen
					cad_add_rect (hndDrawing, (-L/2 + 2*k), (-dA/2 - sS), (-L/2 + 2*k + B), -f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k), (-dA/2 - sS), (L/2 - 2*k - B), -f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k), (dA/2 + sS), (-L/2 + 2*k + B), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k), (dA/2 + sS), (L/2 - 2*k - B), f/2, 7);
					cad_add_line (hndDrawing, (-L/2 + 2*k), (-f/2 - sS), (-L/2 + 2*k + B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (-L/2 + 2*k), (f/2 + sS), (-L/2 + 2*k + B), (f/2 + sS), 7);
					cad_add_line (hndDrawing, (L/2 - 2*k), (-f/2 - sS), (L/2 - 2*k - B), (-f/2 - sS), 7);
					cad_add_line (hndDrawing, (L/2 - 2*k), (f/2 + sS), (L/2 - 2*k - B), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), (-f/2 - 2.5*sS), (-L/2 + 2*k + B/2 + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), -f/2, (-L/2 + 2*k + B/2 + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-L/2 + 2*k + B/2 - c/2), (f/2 + 2.5*sS), (-L/2 + 2*k + B/2 + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), (-f/2 - 2.5*sS), (L/2 - 2*k - B/2 - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), -f/2, (L/2 - 2*k - B/2 - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (L/2 - 2*k - B/2 + c/2), (f/2 + 2.5*sS), (L/2 - 2*k - B/2 - c/2), (f/2 + sS), 7);
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L, -dA/2, 0.8*L, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);		
					// Mittellinien fr Schelle 
					cad_add_line(hndDrawing, -0.8*L - sS/2, dy, 0.8*L + sS/2, dy, colMLinie);				
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -L/2 + 2*k + B/2, dy-f/2-2.5*sS-sS/2, -L/2 + 2*k + B/2, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, L/2 - 2*k - B/2, dy-f/2-2.5*sS-sS/2, L/2 - 2*k - B/2, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					retObj.xMassTop = (L/2 - 2*k);
					retObj.xMassBottom = L/2;
					retObj.xWidthLeft = 0.8*L;
					retObj.xWidthRight = 0.8*L;
					retObj.xDist = (L/2 - k);
					retObj.yDist = -Emass/2;
					retObj.L_PosNr = A/3;
				}
			}
			break;
		}
		
		case "LXL23":
		case "LSL23":
		{
			if (DN <= 500)
			{
				// Schellendaten (HZN)
				var strSQLStatement = "select * from HZN where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "HZN");
				var sS = dbgetdouble("HZN", "S");	// Dicke der Schelle
				var f = dbgetdouble("HZN", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("HZN", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("HZN", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("HZN", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("HZN", "B");	// Schellenbreite
				
				var aS = 0.4*DN;						// Abstand der Schraegen
			}
			else
			{
				// Schellendaten (HZL)
				var strSQLStatement = "select * from HZL where NENNWEITE="+DN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "HZL");
				var sS = dbgetdouble("HZL", "S");	// Dicke der Schelle
				var f = dbgetdouble("HZL", "B_");	// Abstand der Schellenhaelften
				var AS = dbgetdouble("HZL", "A");	// Aussenabmass der Schelle
				var z = dbgetdouble("HZL", "Z");	// Abstand Bohrung von Schellenaussenkante
				var c = dbgetdouble("HZL", "C");	// Bohrungsdurchmesser
				var B = dbgetdouble("HZL", "B");	// Schellenbreite
				
				var aS = 210;						// Abstand der Schraegen
			}
			
			var R = dA/2+sS;				// Radius der Freimachung
			var alpha = asindeg(aS/(2*R));	// Winkel der Schraegen
			var fR = 40;					// Fase Rippe
			
			if (Typid == "LXL")
			{
				Emass = Emass - 3;
			}
			
			if ((Rotation == 0) || (Rotation == 180))
			{
				// Buegel
				cad_begin_poly (hndDrawing, 0, 7);
					cad_add_vertex (hndDrawing, -(dA/2+sS)*sindeg(alpha), -(dA/2+sS)*cosdeg(alpha));
					cad_add_vertex (hndDrawing, -A/2, (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)));
					cad_add_vertex (hndDrawing, -A/2, -Emass);
					cad_add_vertex (hndDrawing, A/2, -Emass);
					cad_add_vertex (hndDrawing, A/2, (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)));
					cad_add_vertex (hndDrawing, (dA/2+sS)*sindeg(alpha), -(dA/2+sS)*cosdeg(alpha));
				cad_end_poly (hndDrawing);
				cad_add_arc (hndDrawing, 0, 0, (dA/2+sS), (270-alpha), (270+alpha), 7);
				// Schelle
				this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
				this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
				cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
				cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
				cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
				cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
				cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
				cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
				// Mittellinien fr Schrauben
				cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
				cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
				
				if (Typid == "LXL")
				{
					cad_add_rect (hndDrawing, -GP_A/2, -Emass, GP_A/2, (-Emass-GP_s), 7);
				}
				
				retObj.xMassTop = AS/2;
				retObj.xMassBottom = A/2;
				retObj.xWidthLeft = A/2;
				retObj.xWidthRight = AS/2;
				retObj.xDist = AS/2;
				retObj.yDist = (-f/2-sS);
				retObj.L_PosNr = A/4;
				retObj.Naht = a;
				retObj.B_Lager = A/2;
			}
			else		// 90 und 270
			{
				// Buegel
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, -L/2, (-(dA/2+sS)*cosdeg(alpha)));
					cad_add_vertex1 (hndDrawing, -L/2, (-Emass+2*s1), -2*s1);
					cad_add_vertex (hndDrawing, (-L/2+2*s1), -Emass);
					cad_add_vertex1 (hndDrawing, (L/2-2*s1), -Emass, -2*s1);
					cad_add_vertex (hndDrawing, L/2, (-Emass+2*s1));
					cad_add_vertex (hndDrawing, L/2, (-(dA/2+sS)*cosdeg(alpha)));
					cad_add_vertex (hndDrawing, (L/2-s1), (-(dA/2+sS)*cosdeg(alpha)));
					cad_add_vertex1 (hndDrawing, (L/2-s1), (-Emass+2*s1), s1);
					cad_add_vertex (hndDrawing, (L/2-2*s1), (-Emass+s1));
					cad_add_vertex1 (hndDrawing, (-L/2+2*s1), (-Emass+s1), s1);
					cad_add_vertex (hndDrawing, (-L/2+s1), (-Emass+2*s1));
					cad_add_vertex (hndDrawing, (-L/2+s1), (-(dA/2+sS)*cosdeg(alpha)));
				cad_end_poly (hndDrawing);
				cad_add_line (hndDrawing, -L/2, (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)), (-L/2+s1), (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)), 7);
				cad_add_line (hndDrawing, L/2, (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)), (L/2-s1), (-(dA/2+sS)*cosdeg(alpha)-(A/2-(dA/2+sS)*sindeg(alpha))/tandeg(alpha)), 7);
				// Rippe
				cad_add_line (hndDrawing, (-L/2+s1), (-dA/2-sS), (L/2-s1), (-dA/2-sS), 7);
				cad_add_line (hndDrawing, (-L/2+s1), (-Emass+s1+fR), (-L/2+s1+fR), (-Emass+s1), 7);
				cad_add_line (hndDrawing, (L/2-s1), (-Emass+s1+fR), (L/2-s1-fR), (-Emass+s1), 7);
				// Schelle 1
				cad_begin_poly (hndDrawing, 0, 7);
					cad_add_vertex (hndDrawing, (-L/2-k+B), (-dA/2-sS));
					cad_add_vertex (hndDrawing, (-L/2-k+B), -f/2);
					cad_add_vertex (hndDrawing, (-L/2-k), -f/2);
					cad_add_vertex (hndDrawing, (-L/2-k), (-dA/2-sS));
					cad_add_vertex (hndDrawing, (-L/2), (-dA/2-sS));
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, (-L/2-k), f/2, (-L/2-k+B), (dA/2+sS), 7);
				cad_add_line (hndDrawing, (-L/2-k), (-f/2-sS), (-L/2-k+B), (-f/2-sS), 7);
				cad_add_line (hndDrawing, (-L/2-k), (f/2+sS), (-L/2-k+B), (f/2+sS), 7);
				cad_add_rect (hndDrawing, (-L/2-k+B/2-c/2), (f/2+sS), (-L/2-k+B/2+c/2), (f/2+2*sS), 7);
				cad_add_rect (hndDrawing, (-L/2-k+B/2-c/2), (-f/2-sS), (-L/2-k+B/2+c/2), (-f/2-2.5*sS), 7);
				cad_add_rect (hndDrawing, (-L/2-k+B/2-c/2), -f/2, (-L/2-k+B/2+c/2), f/2, 7);
				// Schelle 2
				cad_begin_poly (hndDrawing, 0, 7);
					cad_add_vertex (hndDrawing, (L/2+k-B), (-dA/2-sS));
					cad_add_vertex (hndDrawing, (L/2+k-B), -f/2);
					cad_add_vertex (hndDrawing, (L/2+k), -f/2);
					cad_add_vertex (hndDrawing, (L/2+k), (-dA/2-sS));
					cad_add_vertex (hndDrawing, (L/2), (-dA/2-sS));
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, (L/2+k), f/2, (L/2+k-B), (dA/2+sS), 7);
				cad_add_line (hndDrawing, (L/2+k), (-f/2-sS), (L/2+k-B), (-f/2-sS), 7);
				cad_add_line (hndDrawing, (L/2+k), (f/2+sS), (L/2+k-B), (f/2+sS), 7);
				cad_add_rect (hndDrawing, (L/2+k-B/2+c/2), (f/2+sS), (L/2+k-B/2-c/2), (f/2+2*sS), 7);
				cad_add_rect (hndDrawing, (L/2+k-B/2+c/2), (-f/2-sS), (L/2+k-B/2-c/2), (-f/2-2.5*sS), 7);
				cad_add_rect (hndDrawing, (L/2+k-B/2+c/2), -f/2, (L/2+k-B/2-c/2), f/2, 7);
				
				// Rohr
				cad_add_rect(hndDrawing, -0.8*L-dA/10, -dA/2, 0.8*L+dA/10, dA/2, colRohr);		
				// Daemmung
				cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
				cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);	
				// Mittellinie fr Schellen  
				cad_add_line(hndDrawing, -0.8*L-dA/10 - sS/2, dy, 0.8*L+dA/10 + sS/2, dy, colMLinie);				
				// Mittellinien fr Schrauben
				cad_add_line(hndDrawing, -L/2 - k + B/2, dy-f/2-2.5*sS-sS/2, -L/2 - k + B/2, dy+f/2+2*sS+sS/2, colMLinie);
				cad_add_line(hndDrawing, L/2 + k - B/2, dy-f/2-2.5*sS-sS/2, L/2 + k - B/2, dy+f/2+2*sS+sS/2, colMLinie);
				
				if (Typid == "LXL")
				{
					cad_add_rect (hndDrawing, (-GP_L/2+2*s1), -Emass, (GP_L/2-2*s1), (-Emass-GP_s), 7);
				}
				
				retObj.xMassTop = (L/2+k);
				if (Typid == "LXL")
				{
					retObj.xMassBottom = (GP_L/2-2*s1);
				}
				retObj.xMassBottom = (L/2-2*s1);
				retObj.xWidthLeft = L/2;
				retObj.xWidthRight = 0.8*L+dA/10;
				retObj.xDist = L/2;
				retObj.yDist = (-Emass+2*s1);
				retObj.L_PosNr = A/2;
			}
			break;
		}	
		case "LSL24":
		case "LXL24":
		{
			// keine Werkstoffunterscheidung
			if (DN <= 700) {
				
				// Schellendaten HZN
				if (DN <= 500) {
					var strSQLStatement = "select * from HZN where NENNWEITE="+DN+" ";
					var numRet = dbselect("CASCADE", strSQLStatement, "HZN");
					var sS = dbgetdouble("HZN", "S");	// Dicke der Schelle
					var f = dbgetdouble("HZN", "B_");	// Abstand der Schellenhaelften
					var AS = dbgetdouble("HZN", "A");	// Aussenabmass der Schelle
					var z = dbgetdouble("HZN", "Z");	// Abstand Bohrung von Schellenaussenkante
					var c = dbgetdouble("HZN", "C");	// Bohrungsdurchmesser
					var B = dbgetdouble("HZN", "B");	// Schellenbreite
				}
				
				// Schellendaten HZL
				else {		// DN ab 550 bis 700
					var strSQLStatement = "select * from HZL where NENNWEITE="+DN+" ";
					var numRet = dbselect("CASCADE", strSQLStatement, "HZL");
					var sS = dbgetdouble("HZL", "S");	// Dicke der Schelle
					var f = dbgetdouble("HZL", "B_");	// Abstand der Schellenhaelften
					var AS = dbgetdouble("HZL", "A");	// Aussenabmass der Schelle
					var z = dbgetdouble("HZL", "Z");	// Abstand Bohrung von Schellenaussenkante
					var c = dbgetdouble("HZL", "C");	// Bohrungsdurchmesser
					var B = dbgetdouble("HZL", "B");	// Schellenbreite
				}
			
				var b = A-40;		// Ma fr Seitenteile
				var s2 = s1; 		// Dicke Seitenteile
				var h = int(Emass-s1- GP_s- sqrt (pow(dA/2+sS,2) - pow(b/2-s2,2)));		// Hhe Seitenteile // integer fr abrunden
				var l3 = b - 2*s2-1;	// Breite Rippe 
				var h3 = H - s1 - sS - GP_s - 1;		// Hhe Rippe
				var k = int((min(h3, l3))/3);   // Schrge Rippe
				var rR = dA/2+ sS + 1; 	// Radius Oberkante Rippe
				var alpha = asindeg(((l3-2*k)/2)/(dA/2+sS));		// Winkel fr Oberkante
				var x = cosdeg(alpha)*(dA/2+sS);		// Hilfsvar.
				var h3plus = h3 + dA/2 + sS - x;		// komplette Hhe der Rippe
				var l = L - 20;		// Breite Seitenteile
				var s3 = s1; 		// Dicke Rippen
				var t  = 10; 		// Abstand Schelle vom Rand
	
				if ((Rotation == 0) || (Rotation == 180))
				{
					// Schellen
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 180, dx, dy, daemmDicke, rohr, daemmung);
					this.add_HZx_H(hndDrawing, AS, dA, sS, f, 0, dx, dy, daemmDicke, rohr, daemmung);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (-f/2 - 3*sS), (-AS/2 + z + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), -f/2, (-AS/2 + z + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-AS/2 + z - c/2), (f/2 + 2.5*sS), (-AS/2 + z + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (-f/2 - 3*sS), (AS/2 - z - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), -f/2, (AS/2 - z - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (AS/2 - z + c/2), (f/2 + 2.5*sS), (AS/2 - z - c/2), (f/2 + sS), 7);
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, dx-AS/2+z, dy-f/2-3*sS-sS/2, dx-AS/2+z, dy+f/2+2.5*sS+sS/2, colMLinie);
					cad_add_line(hndDrawing, dx+AS/2-z, dy-f/2-3*sS-sS/2, dx+AS/2-z, dy+f/2+2.5*sS+sS/2, colMLinie);
					
					// Fussplatte
					cad_add_rect(hndDrawing, -A/2, -Emass + GP_s, A/2, -Emass + GP_s + s1, 7);
					
					// Gleitplatte bei LXL
					if (Typid == "LXL") {
						cad_add_rect(hndDrawing, -GP_A/2, -Emass, GP_A/2, -Emass + GP_s, 7);					// GP_s = 3 || 0
					} // else (nothing)
					
					// Seitenteile
					cad_add_rect(hndDrawing, -b/2, -Emass + GP_s + s1, -l3/2, -Emass + GP_s + s1 + h, 7);
					cad_add_rect(hndDrawing, b/2, -Emass + GP_s + s1, l3/2, -Emass + GP_s + s1 + h, 7);
					
					// Rippe
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, l3/2-k, -Emass + GP_s + s1 + h3plus);
					cad_add_vertex(hndDrawing, l3/2, -Emass + GP_s + s1 + h3plus-k);
					cad_add_vertex(hndDrawing, l3/2, -Emass + GP_s + s1 + k);
					cad_add_vertex(hndDrawing, l3/2-k, -Emass + GP_s + s1);
					cad_add_vertex(hndDrawing, -l3/2+k, -Emass+GP_s+s1);
					cad_add_vertex(hndDrawing, -l3/2, -Emass + GP_s + s1 + k);
					cad_add_vertex(hndDrawing, -l3/2, -Emass + GP_s + s1 + h3plus - k);
					cad_add_vertex(hndDrawing, -l3/2+k, -Emass + GP_s + s1 + h3plus);
					cad_end_poly(hndDrawing);
					// schrge Rippen-Oberkante
					cad_add_arc(hndDrawing, 0, 0, rR, 270-alpha, 270+alpha, 7); 		
					
					retObj.xMassTop = AS/2;
					if (GP_s == 0) {
						retObj.xMassBottom = A/2;
					}
					else {
						retObj.xMassBottom = GP_A/2;
					}	
					retObj.xWidthLeft = A/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = b/2;
					retObj.yDist = -Emass + 3*h3/4;
					retObj.L_PosNr = A/2;
					retObj.Naht = a;
					retObj.B_Lager = A/2;
				}
				
				if ((Rotation == 90) || (Rotation == 270))
				{
					// Fussplatte
					cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -Emass + GP_s + s1, 7);
					
					// Gleitplatte bei LXL
					if (Typid == "LXL") {
						cad_add_rect(hndDrawing, -GP_L/2, -Emass, GP_L/2, -Emass + GP_s, 7);
					} // else (nothing)
					
					// Seitenteile
					cad_add_rect(hndDrawing, -l/2, -Emass + GP_s + s1, l/2, -Emass + GP_s + s1 + h, 7);
					
					// Schellen
					cad_add_rect (hndDrawing, -l/2 + t, -Emass + GP_s + s1 + h, (-l/2 + t + B), -f/2, 7);
					cad_add_rect (hndDrawing, l/2 - t - B, -Emass + GP_s + s1 + h, l/2 - t, -f/2, 7);
					cad_add_rect (hndDrawing, -l/2 + t, (dA/2 + sS), (-l/2 + t + B), f/2, 7);
					cad_add_rect (hndDrawing, l/2 - t - B, (dA/2 + sS), l/2 - t, f/2, 7);
					cad_add_line (hndDrawing, -l/2 + t, (-f/2 - sS), -l/2 + t + B, (-f/2 - sS), 7);
					cad_add_line (hndDrawing, -l/2 + t, (f/2 + sS), -l/2 + t + B, (f/2 + sS), 7);
					cad_add_line (hndDrawing, l/2 - t - B, (-f/2 - sS), l/2 - t, (-f/2 - sS), 7);
					cad_add_line (hndDrawing, l/2 - t - B, (f/2 + sS), l/2 - t, (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (-l/2 + t + B/2 - c/2), (-f/2 - 2.5*sS), (-l/2 + t + B/2 + c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (-l/2 + t + B/2 - c/2), -f/2, (-l/2 + t + B/2 + c/2), f/2, 7);
					cad_add_rect (hndDrawing, (-l/2 + t + B/2 - c/2), (f/2 + 2*sS), (-l/2 + t + B/2 + c/2), (f/2 + sS), 7);
					cad_add_rect (hndDrawing, (l/2 - t - B/2 + c/2), (-f/2 - 2.5*sS), (l/2 - t - B/2 - c/2), (-f/2 - sS), 7);
					cad_add_rect (hndDrawing, (l/2 - t - B/2 + c/2), -f/2, (l/2 - t - B/2 - c/2), f/2, 7);
					cad_add_rect (hndDrawing, (l/2 - t - B/2 + c/2), (f/2 + 2*sS), (l/2 - t - B/2 - c/2), (f/2 + sS), 7);
					
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L-dA/10, -dA/2, 0.8*L+dA/10, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);	
					// Mittellinie fr Schellen  
					cad_add_line(hndDrawing, -0.8*L-dA/10 - sS/2, dy, 0.8*L+dA/10 + sS/2, dy, colMLinie);				
					
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -l/2 + t + B/2, dy-f/2-2.5*sS-sS/2, -l/2 +t + B/2, dy+f/2+2*sS+sS/2, colMLinie);
					
					/*
					ACHTUNG: 	Nchster Methodenaufruf absichtlich doppelt --> sonst folgt Fehler vom Betriebssystem bei 
								'shellexecuteexblocking( oFileComponents.strExecutable, strParams, oFileComponents.strPrgPath, 1, 256000 );    // show = 1 '
								in Zeile 1690 in Datei 'ThreeDCADOptionsController.es: '
					*/
					cad_add_line(hndDrawing, l/2 - t - B/2, dy-f/2-2.5*sS-sS/2, l/2 -t - B/2, dy+f/2+2*sS+sS/2, colMLinie);
					//cad_add_line(hndDrawing, l/2 - t - B/2, dy-f/2-2.5*sS-sS/2, l/2 -t - B/2, dy+f/2+2*sS+sS/2, colMLinie);
					
					
					retObj.xMassTop = (l/2 - t- B/2);
					if (GP_s == 0) {
						retObj.xMassBottom = L/2;
					}
					else {
						retObj.xMasssBottom = GP_L/2;
					}	
					retObj.xWidthLeft = L/2;
					retObj.xWidthRight = 0.8*L+dA/10;
					retObj.xDist = l/2;
					retObj.yDist = -Emass + h/2;
					retObj.L_PosNr = L/3;
				}
			}
			
			
		
		
			else
			{	// DN ab 800 bzw dA ab 813
				var sS = 12;						// Dicke der Schelle
				var fKnagge = 25;					// Abstand der Knaggen
				var eKnagge = 30;
				var LKnagge = 62;
				var bKnagge = 80; 					//  breite
				var dKnagge = 33;					// Bohrungsdurchmesser
				var hMutter = sS * 1.5;				// Hhe
				var bMutter = dKnagge * 1.4;		// Breite
				var l1Knagge = 58;					// Breite unten
				var l2Knagge = 62.2;					// Breite oben
				var	hKnagge = 45; 					// Hhe Knagge
				var sKnagge = 8; 					// Dicke Knagge	
				var eS = 2*(sqrt(pow((dA/2+sS),2)-pow((25/2),2))+(LKnagge -3.5 - eKnagge));
				var AS = eS + 2 * eKnagge; 			// Aussenabmass der Schelle
				var kS = 13; 						// Abstand der Schalenhlften 
				var b1 = 110; 						// Schellenbreite
				
				var b = A-40;		// Ma fr Seitenteile
				var s2 = s1; 		// Dicke Seitenteile
				var h = int(Emass-s1- GP_s- sqrt (pow(dA/2+sS,2) - pow(b/2-s2,2)));		// Hhe Seitenteile // integer fr abrunden
				var l3 = b - 2*s2-1;	// Breite Rippe 
				var h3 = H - s1 - sS - 1;		// Hhe Rippe
				var k = int((min(h3, l3))/3);   // Schrge Rippe
				var rR = dA/2+ sS + 1; 	// Radius Oberkante Rippe
				var alpha = asindeg(((l3-2*k)/2)/(dA/2+sS));		// Winkel fr Oberkante
				var x = cosdeg(alpha)*(dA/2+sS);		// Hilfsvar.
				var  h3plus = h3 + dA/2 + sS - x - 3;		// komplette Hhe der Rippe		// minus 3 wegen GP_s
				var l = L - 20;		// Breite Seitenteile
				var s3 = s1; 		// Dicke Rippen
				
				if ((Rotation == 0) || (Rotation == 180))
				{
					// Schellen
					var beta = asindeg(kS/dA);  		// Winkel fr Abstand der Schalenhlften  
					cad_add_arc(hndDrawing, 0, 0, dA/2, beta, 180-beta, 7);		// innerer Kreis
					cad_add_arc(hndDrawing, 0, 0, dA/2, 180+beta, -beta, 7);	// innerer Kreis
					cad_add_line(hndDrawing, -cosdeg(beta)*(dA/2), kS/2, -cosdeg(beta)*(dA/2+sS), kS/2, 7);
					cad_add_line(hndDrawing, cosdeg(beta)*(dA/2), kS/2, cosdeg(beta)*(dA/2+sS), kS/2, 7);
					cad_add_arc(hndDrawing, 0, 0, dA/2+sS, beta, 180-beta, 7);		// uerer Kreis
					cad_add_arc(hndDrawing, 0, 0, dA/2+sS, 180+beta, -beta, 7);	// uerer Kreis
					cad_add_line(hndDrawing, -cosdeg(beta)*(dA/2), -kS/2, -cosdeg(beta)*(dA/2+sS), -kS/2, 7);
					cad_add_line(hndDrawing, cosdeg(beta)*(dA/2), -kS/2, cosdeg(beta)*(dA/2+sS), -kS/2, 7);
					
					// Knagge links oben 
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, -((dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2);
					cad_add_vertex(hndDrawing, -(l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2);
					cad_add_vertex(hndDrawing, -(l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2 + hKnagge);
					cad_add_vertex(hndDrawing, -((dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))), fKnagge/2 + hKnagge);
					cad_end_poly(hndDrawing);
					
					cad_add_rect(hndDrawing, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - dKnagge/2, -fKnagge/2, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + dKnagge/2, fKnagge/2, 7);
					cad_add_rect(hndDrawing, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - bMutter/2 , fKnagge/2 + hKnagge, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + bMutter/2, fKnagge/2 + hKnagge + hMutter, 7); 
					cad_add_rect(hndDrawing, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - bMutter/2 , -fKnagge/2 - hKnagge, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + bMutter/2, -fKnagge/2 - hKnagge - hMutter, 7); 	
					cad_add_rect(hndDrawing, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - dKnagge/2, -fKnagge/2 - hKnagge - hMutter, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + dKnagge/2, -fKnagge/2 - hKnagge - hMutter - 30, 7);
					
					// Knagge links unten 
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, -((dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2);
					cad_add_vertex(hndDrawing, -(l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2);
					cad_add_vertex(hndDrawing, -(l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2 - hKnagge);
					cad_add_vertex(hndDrawing, -((dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))), -fKnagge/2 - hKnagge);
					cad_end_poly(hndDrawing);
					
					// Knagge rechts oben 
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, ((dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2);
					cad_add_vertex(hndDrawing, (l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2);
					cad_add_vertex(hndDrawing, (l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2 + hKnagge);
					cad_add_vertex(hndDrawing, ((dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))), fKnagge/2 + hKnagge);
					cad_end_poly(hndDrawing);
					
					cad_add_rect(hndDrawing, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - dKnagge/2, -fKnagge/2, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + dKnagge/2, fKnagge/2, 7);
					cad_add_rect(hndDrawing, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - bMutter/2 , fKnagge/2 + hKnagge, (l2Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))) + bMutter/2, fKnagge/2 + hKnagge + hMutter, 7); 
					cad_add_rect(hndDrawing, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - bMutter/2 , -fKnagge/2 - hKnagge, (l2Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))) + bMutter/2, -fKnagge/2 - hKnagge - hMutter, 7); 	
					cad_add_rect(hndDrawing, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) - dKnagge/2, -fKnagge/2 - hKnagge - hMutter, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))) + dKnagge/2, -fKnagge/2 - hKnagge - hMutter - 30, 7);
					
					// Knagge rechts unten
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, ((dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2);
					cad_add_vertex(hndDrawing, (l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2);
					cad_add_vertex(hndDrawing, (l1Knagge + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2 - hKnagge);
					cad_add_vertex(hndDrawing, ((dA/2 + sS) * cosdeg(asindeg((fKnagge/2 + hKnagge)/(dA/2 + sS)))), -fKnagge/2 - hKnagge);
					cad_end_poly(hndDrawing);
					
					// Rohr
					cad_add_arc (hndDrawing, dx, dy, dA/2, 0, 180, colRohr);		
					cad_add_arc(hndDrawing, dx + dA/4, dy, dA/4, 0, 180, colRohr);
					cad_add_arc (hndDrawing, dx, dy, dA/2, 180, 0, colRohr);		
					cad_add_arc(hndDrawing, dx - dA/4, dy, dA/4, 180, 0, colRohr);
					// Daemmung
					cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 0, 180, colDaemm);		
					cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 180, 0, colDaemm);	
					// Mittellinien
					cad_add_line(hndDrawing, dx+AS/2+sS/2, dy, dx-AS/2-sS/2, dy, colMLinie);
					cad_add_line(hndDrawing, dx, dy-1.5*sS - dA/2, dx, dy+1.5*sS + dA/2, colMLinie);
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2 + hKnagge + hMutter + sS/2, -(l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2 - hKnagge - hMutter - 30 - sS/2, colMLinie);
					cad_add_line(hndDrawing, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), fKnagge/2 + hKnagge + hMutter + sS/2, (l1Knagge/2 + (dA/2 + sS) * cosdeg(asindeg((fKnagge/2)/(dA/2 + sS)))), -fKnagge/2 - hKnagge - hMutter - 30 - sS/2, colMLinie);
					
					// Fussplatte
					cad_add_rect(hndDrawing, -A/2, -Emass + GP_s, A/2, -Emass + GP_s + s1, 7);
					
					// Gleitplatte bei LXL
					if (Typid == "LXL") {
					cad_add_rect(hndDrawing, -GP_A/2, -Emass, GP_A/2, -Emass + GP_s, 7);					// GP_s = 3 || 0
					} // else (nothing)
					
					// Seitenteile
					cad_add_rect(hndDrawing, -b/2, -Emass + GP_s + s1, -l3/2, -Emass + GP_s + s1 + h, 7);
					cad_add_rect(hndDrawing, b/2, -Emass + GP_s + s1, l3/2, -Emass + GP_s + s1 + h, 7);
					
					// Rippe
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, l3/2-k, -Emass + GP_s + s1 + h3plus);
					cad_add_vertex(hndDrawing, l3/2, -Emass + GP_s + s1 + h3plus-k);
					cad_add_vertex(hndDrawing, l3/2, -Emass + GP_s + s1 + k);
					cad_add_vertex(hndDrawing, l3/2-k, -Emass + GP_s + s1);
					cad_add_vertex(hndDrawing, -l3/2+k, -Emass+GP_s+s1);
					cad_add_vertex(hndDrawing, -l3/2, -Emass + GP_s + s1 + k);
					cad_add_vertex(hndDrawing, -l3/2, -Emass + GP_s + s1 + h3plus - k);
					cad_add_vertex(hndDrawing, -l3/2+k, -Emass + GP_s + s1 + h3plus);
					cad_end_poly(hndDrawing);
					// schrge Rippen-Oberkante
					cad_add_arc(hndDrawing, 0, 0, rR, 270-alpha, 270+alpha, 7); 
					
					
					retObj.xMassTop = eS/2+dKnagge;
					if (GP_s == 0) {
						retObj.xMassBottom = A/2;
					}
					else {
						retObj.xMassBottom = GP_A/2;
					}	
					retObj.xWidthLeft = AS/2;
					retObj.xWidthRight = AS/2;
					retObj.xDist = b/2;
					retObj.yDist = -Emass + h/2;
					retObj.L_PosNr = A/2;
				}
				
				if ((Rotation == 90) || (Rotation == 270))
				{
				
					// Fussplatte
					cad_add_rect (hndDrawing, -L/2, -Emass + GP_s, L/2, -Emass + GP_s + s1, 7);
					
					// Gleitplatte bei LXL
					if (Typid == "LXL") {
						cad_add_rect(hndDrawing, -GP_L/2, -Emass, GP_L/2, -Emass + GP_s, 7);
					} // else (nothing)
					
					// Seitenteile
					cad_add_rect(hndDrawing, -l/2, -Emass + GP_s + s1, l/2, -Emass + GP_s + s1 + h, 7);
					
					// untere Schale
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -l/2, -dA/2 - sS);
					cad_add_vertex(hndDrawing, -L/2, -dA/2 - sS);
					cad_add_vertex(hndDrawing, -L/2, -kS/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - dKnagge/2, -kS/2);
					cad_end_poly(hndDrawing);
					cad_add_line(hndDrawing, -L/2 + b1/2 + dKnagge/2, -kS/2, L/2 - b1/2 - dKnagge/2, -kS/2, 7);
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, l/2, -dA/2 - sS);
					cad_add_vertex(hndDrawing, L/2, -dA/2 - sS);
					cad_add_vertex(hndDrawing, L/2, -kS/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + dKnagge/2, -kS/2);
					cad_end_poly(hndDrawing);
					
					// obere Schalenhlften
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - dKnagge/2, kS/2);
					cad_add_vertex(hndDrawing, -L/2, kS/2);
					cad_add_vertex(hndDrawing, -L/2, dA/2 + sS);
					cad_add_vertex(hndDrawing, -L/2 + b1, dA/2 + sS);
					cad_add_vertex(hndDrawing, -L/2 + b1, kS/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + dKnagge/2, kS/2);
					cad_end_poly(hndDrawing);
					cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + dKnagge/2, kS/2);
					cad_add_vertex(hndDrawing, L/2, kS/2);
					cad_add_vertex(hndDrawing, L/2, dA/2 + sS);
					cad_add_vertex(hndDrawing, L/2 - b1, dA/2 + sS);
					cad_add_vertex(hndDrawing, L/2 - b1, kS/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - dKnagge/2, kS/2);
					cad_end_poly(hndDrawing);
					
					// Knaggen links
					cad_add_rect(hndDrawing, -L/2 + b1/2 - bMutter/2, fKnagge/2 + hKnagge, -L/2 + b1/2 + bMutter/2, fKnagge/2 + hKnagge + hMutter, 7);
					cad_add_rect(hndDrawing, -L/2 + b1/2 - dKnagge/2, -fKnagge/2 - hKnagge + sKnagge, -L/2 + b1/2 + dKnagge/2, fKnagge/2 + hKnagge - sKnagge, 7);
					cad_add_rect(hndDrawing, -L/2 + b1/2 - bMutter/2, -fKnagge/2 - hKnagge, -L/2 + b1/2 + bMutter/2, -fKnagge/2 - hKnagge - hMutter, 7);
					cad_add_rect(hndDrawing, -L/2 + b1/2 - dKnagge/2, -fKnagge/2 - hKnagge - hMutter, -L/2 + b1/2 + dKnagge/2, -fKnagge/2 - hKnagge - hMutter - 30, 7);
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2, -fKnagge/2-hKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2, -fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2 + 0.5*sKnagge, -fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2 + sKnagge, -fKnagge/2 - hKnagge + sKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2 - sKnagge, -fKnagge/2 - hKnagge + sKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2 - 0.5*sKnagge, -fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2, -fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2, -fKnagge/2-hKnagge);
					cad_end_poly(hndDrawing);
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2, fKnagge/2+hKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2, fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2 + 0.5*sKnagge, fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 - bKnagge/2 + sKnagge, fKnagge/2 + hKnagge - sKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2 - sKnagge, fKnagge/2 + hKnagge - sKnagge);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2 - 0.5*sKnagge, fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2, fKnagge/2);
					cad_add_vertex(hndDrawing, -L/2 + b1/2 + bKnagge/2, fKnagge/2 + hKnagge);
					cad_end_poly(hndDrawing);
					
					// Knaggen rechts
					cad_add_rect(hndDrawing, L/2 - b1/2 - bMutter/2, fKnagge/2 + hKnagge, L/2 - b1/2 + bMutter/2, fKnagge/2 + hKnagge + hMutter, 7);
					cad_add_rect(hndDrawing, L/2 - b1/2 - dKnagge/2, -fKnagge/2 - hKnagge + sKnagge, L/2 - b1/2 + dKnagge/2, fKnagge/2 + hKnagge - sKnagge, 7);
					cad_add_rect(hndDrawing, L/2 - b1/2 - bMutter/2, -fKnagge/2 - hKnagge, L/2 - b1/2 + bMutter/2, -fKnagge/2 - hKnagge - hMutter, 7);
					cad_add_rect(hndDrawing, L/2 - b1/2 - dKnagge/2, -fKnagge/2 - hKnagge - hMutter, L/2 - b1/2 + dKnagge/2, -fKnagge/2 - hKnagge - hMutter - 30, 7);
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2, -fKnagge/2-hKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2, -fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2 + 0.5*sKnagge, -fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2 + sKnagge, -fKnagge/2 - hKnagge + sKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2 - sKnagge, -fKnagge/2 - hKnagge + sKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2 - 0.5*sKnagge, -fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2, -fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2, -fKnagge/2-hKnagge);
					cad_end_poly(hndDrawing);
					cad_begin_poly(hndDrawing, 1, 7);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2, fKnagge/2+hKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2, fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2 + 0.5*sKnagge, fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 - bKnagge/2 + sKnagge, fKnagge/2 + hKnagge - sKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2 - sKnagge, fKnagge/2 + hKnagge - sKnagge);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2 - 0.5*sKnagge, fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2, fKnagge/2);
					cad_add_vertex(hndDrawing, L/2 - b1/2 + bKnagge/2, fKnagge/2 + hKnagge);
					cad_end_poly(hndDrawing);
					
					// Rohr
					cad_add_rect(hndDrawing, -0.8*L-dA/10, -dA/2, 0.8*L+dA/10, dA/2, colRohr);		
					// Daemmung
					cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
					cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);	
					// Mittellinie fr Schellen  
					cad_add_line(hndDrawing, -0.8*L-dA/10 - sS/2, dy, 0.8*L+dA/10 + sS/2, dy, colMLinie);				
					
					// Mittellinien fr Schrauben
					cad_add_line(hndDrawing, -L/2 + b1/2, fKnagge/2 + hKnagge + hMutter + sS/2, -L/2 + b1/2, -fKnagge/2 - hKnagge - hMutter - 30 - sS/2, colMLinie);
					cad_add_line(hndDrawing, L/2 - b1/2, fKnagge/2 + hKnagge + hMutter + sS/2, L/2 - b1/2, -fKnagge/2 - hKnagge - hMutter - 30 - sS/2, colMLinie);
					
					retObj.xMassTop = L/2;
					if (GP_s == 0) {
						retObj.xMassBottom = L/2;
					}
					else {
						retObj.xMasssBottom = GP_L/2;
					}	
					retObj.xWidthLeft = 0.8*L+dA/10;
					retObj.xWidthRight = 0.8*L+dA/10;
					retObj.xDist = l/2;
					retObj.yDist = -Emass + h/2;
					retObj.L_PosNr = L/3;
				}
			}
			break;
		}
		default:
			break;
	}
},


insertKVS2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)
{
	var F = cad_getdouble ("F");							// Laenge FSR
	var LGV = cad_getdouble ("LGV");						// Lastgruppe
	var LGR = cad_getdouble ("LGR");						// Lastgroesse
	var G = cad_getdouble ("G");							
	if (LGR > 17)
	{
		var gpx = G + 217.3;
	}
	else
	{
		var gpx = cad_getdouble ("GPX");					// Laenge Geradstueck Gehause unten re
	}
	var sN = cad_getdouble ("SN");							// Nennweg
	var sVOR = threeDparams["Blockierstellung0"];			// Vorspannweg
	var X_real = 0;											// Abstand Mitte FSR und Gewindestange
	var L = cad_getdouble ("L");							// Gehausebreite
	var H = cad_getdouble ("H");							// Gehausehoehe
	var C = cad_getdouble ("C"); 							// Breite Mittelteil		
	var A = cad_getdouble ("A");							// Hoehe FSR
	var B = cad_getdouble ("B");							// Breite FSR
	var n = cad_getdouble ("N");							// Breite Fuplatte
	var m = cad_getdouble ("M");							// Lnge Fuplatte
	var s = cad_getdouble ("S"); 							// Hhe Fuplatte
	var o = cad_getdouble ("O");							// Fuplatte: Ma fr 90 Ansicht
	var e2 = cad_getdouble ("E2");							// Abstand BP - Auenkante Fuplatte
	var e = cad_getdouble ("E_");							// Mitte FSR zu Mitte vorderer FP-Bohrung
	var t = cad_getdouble ("T");							// Abstand FP-Bohrungen
	var strSQLStatement = "select * from ZSM where LGV="+LGV+" ";		// Spannschloss-Daten
	var numRet = dbselect("CASCADE", strSQLStatement, "ZSM");
	var A_SS = dbgetdouble("ZSM", "A");
	var H_SS = dbgetdouble("ZSM", "H");
	var E_SS = dbgetdouble("ZSM", "E");
	
	if (LGR<18)
	{
		var spannschloss = F - (Emass-(H_SS - E_SS)/2);				// Spannschloss - Berechnung !!!!
	}
	else
	{
		var spannschloss = (H - 950) - (Emass-(H_SS - E_SS)/2);		// Spannschloss - Berechnung !!!!
	}
	
	var strSQLStatement = "select * from KHPARALLELOGRAMM where LGR="+LGR+" and SN="+sN+" ";
	var numRet = dbselect("CASCADE", strSQLStatement, "KHPARALLELOGRAMM");
	if (mumRet == 0)
	{
		var dx_Para = 0;
	}
	else
	{
		var dx_Para = (dbgetdouble("KHPARALLELOGRAMM", "b1_Para") - dbgetdouble("KHPARALLELOGRAMM", "R4_Para"));
	}
	
	X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gpx - G +dx_Para);
	
	if (LGR < 15)
	{
			A = B;
	}
	
	if (LGR < 18)
	{
		var F_korr = F;
	}
	else
	{
		var F_korr = (H - 950)
	}
	
	var TypNach = cadMacroParamObject.stkListNextPart;
	
	var Rotation_Int = int (Rotation);			// Switch hier unbedingt mit integer-Werten!!!
		
	switch (Rotation_Int)
    {
        case 0:
			// Ansicht 1 (0 Grad):
			if (LGR < 18)
			{
				cad_add_rect(hndDrawing, X_real+G-L, F, X_real+G, H, 7); 						// Mittelteil
			}
			else
			{
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, X_real+G, H);
					cad_add_vertex (hndDrawing, X_real+G-L, H);
					cad_add_vertex (hndDrawing, X_real+G-L, H-950);
					cad_add_vertex (hndDrawing, X_real+G-L+(L-A-(G-A/2)), H-950);
					cad_add_vertex (hndDrawing, X_real+G-L+(L-A-(G-A/2)), F);
					cad_add_vertex (hndDrawing, X_real+A/2, F);
					cad_add_vertex (hndDrawing, X_real+A/2, H-950);
					cad_add_vertex (hndDrawing, X_real+G, H-950);
				cad_end_poly (hndDrawing);
			}
			
			cad_add_rect(hndDrawing, X_real-A/2, s, X_real+A/2, F, 7);						// Federschutzrohr
			cad_add_rect(hndDrawing, (X_real-e-(m-t)/2), 0, (X_real-e-(m-t)/2+m), s, 7);	// Fuplatte
			if (spannschloss <= F_korr) {							// berarbeiteter Spannschlosseinbau
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 7);
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 254); // Spannschloss ausbrennen
				cad_add_rect(hndDrawing, -A_SS/2, 0, A_SS/2, s, 254);	// ausbrennen
			}
			else {			// Spannschloss ist lnger als Federschutzrohr
				
				cad_add_line(hndDrawing, -A_SS/2, F_korr, -A_SS/2, s, 7);
				cad_add_line(hndDrawing, A_SS/2, F_korr, A_SS/2, s, 7);
				cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -A_SS/2, 0);
					cad_add_vertex(hndDrawing, -A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, 0);
				cad_end_poly(hndDrawing);
				cad_add_rect (hndDrawing, -A_SS/2, F_korr-spannschloss, A_SS/2, F, 254); // Spannschloss ausbrennen
			}	
			retObj.xMassTop = A_SS/2;			// Malinienabstand oben
			retObj.xMassBottom = e2;			// Malinienabstand unten
			retObj.xWidthLeft = L-X_real-G;		// Ausdehnung nach Links
			retObj.xWidthRight = X_real+G;		// Ausdehnung nach Rechts
			retObj.xDist = X_real+G;			// Koordinaten der PosNr
			retObj.yDist = H-(H-F)/2;			// Koordinaten der PosNr
			retObj.L_PosNr = G;					// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (TypNach != "")
			{
				this.add_ZMM(hndDrawing, 0, Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;
		
        case 90:
			// Ansicht 2 (90 Grad):
			cad_add_rect(hndDrawing, -C/2, F_korr, C/2, H, 7);		// Mittelteil
			
			if (spannschloss <=F_korr) {							// berarbeiteter Spannschlosseinbau
				var d_ZRM = 0; 			// Durchmesser Gewindestange
				if (cadMacroParamObject.stkListNextPart == "ZRM") {
					d_ZRM = cad_getdouble ("D");
					cad_begin_poly(hndDrawing, 0, 7);	// Federschutzrohr
						cad_add_vertex(hndDrawing, -B/2, s);
						cad_add_vertex(hndDrawing, -B/2, F);
						cad_add_vertex(hndDrawing, B/2, F);
						cad_add_vertex(hndDrawing, B/2, s);
						cad_end_poly(hndDrawing);
						cad_add_rect(hndDrawing, -n/2, 0, -d_ZRM/2, s, 7);		// Fuplatte
						cad_add_rect(hndDrawing,  d_ZRM/2, 0, n/2, s, 7);		// Fuplatte
						cad_add_rect(hndDrawing, -n/2, 0, -o/2, s, 7);		// Fuplatte (offene Seite)
						cad_add_rect(hndDrawing,  o/2, 0, n/2, s, 7);		// Fuplatte (offene Seite)
				}
				else {
					cad_add_rect(hndDrawing, -B/2, s, B/2, F, 7);		// Federschutzrohr
					cad_add_rect(hndDrawing,  -n/2, 0, n/2, s, 7);		// Fuplatte
					cad_add_rect(hndDrawing, -n/2, 0, -o/2, s, 7);		// Fuplatte (offene Seite)
					cad_add_rect(hndDrawing,  o/2, 0, n/2, s, 7);		// Fuplatte (offene Seite)
				}
				
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 7);
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 254); // Spannschloss ausbrennen
				cad_add_rect(hndDrawing, -A_SS/2, 0, A_SS/2, s, 254);	// ausbrennen
			}
			else {			// Spannschloss ist lnger als Federschutzrohr
				
				cad_begin_poly(hndDrawing, 0, 7);	// Federschutzrohr
				cad_add_vertex(hndDrawing, -B/2, s);
				cad_add_vertex(hndDrawing, -B/2, F);
				cad_add_vertex(hndDrawing, B/2, F);
				cad_add_vertex(hndDrawing, B/2, s);
				cad_end_poly(hndDrawing);
				cad_add_rect(hndDrawing, -n/2, 0, -A_SS/2, s, 7);		// Fuplatte_links
				cad_add_rect(hndDrawing, A_SS/2, 0, n/2, s, 7);		// Fuplatte_rechts
				cad_add_rect(hndDrawing, -n/2, 0, -o/2, s, 7);		// Fuplatte (offene Seite)
				cad_add_rect(hndDrawing,  o/2, 0, n/2, s, 7);		// Fuplatte (offene Seite)
				cad_add_line(hndDrawing, -A_SS/2, F, -A_SS/2, s, 7);
				cad_add_line(hndDrawing, A_SS/2, F, A_SS/2, s, 7);
				cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -A_SS/2, 0);
					cad_add_vertex(hndDrawing, -A_SS/2, F-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, F-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, 0);
				cad_end_poly(hndDrawing);
				cad_add_rect (hndDrawing, -A_SS/2, F-spannschloss, A_SS/2, F, 254); // Spannschloss ausbrennen
			}	
			retObj.xMassTop = B/2;			// Malinienabstand oben
			retObj.xMassBottom = n/2;		// Malinienabstand unten
			retObj.xWidthLeft = n/2;		// Ausdehnung nach Links
			retObj.xWidthRight = n/2;		// Ausdehnung nach Rechts
			retObj.xDist = C/2;				// Koordinaten der PosNr
			retObj.yDist = H-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = 1.5*C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (TypNach != "")
			{
				this.add_ZMM(hndDrawing, 0, Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;
		
		case 180:
			// Ansicht 3 (180 Grad):
			if (LGR < 18)
			{
				cad_add_rect(hndDrawing, -(X_real+G-L), F, -(X_real+G), H, 7); 		// Mittelteil
			}
			else
			{
				cad_begin_poly (hndDrawing, 1, 7);
					cad_add_vertex (hndDrawing, -(X_real+G), H);
					cad_add_vertex (hndDrawing, -(X_real+G-L), H);
					cad_add_vertex (hndDrawing, -(X_real+G-L), H-950);
					cad_add_vertex (hndDrawing, -(X_real+G-L+(L-A-(G-A/2))), H-950);
					cad_add_vertex (hndDrawing, -(X_real+G-L+(L-A-(G-A/2))), F);
					cad_add_vertex (hndDrawing, -(X_real+A/2), F);
					cad_add_vertex (hndDrawing, -(X_real+A/2), H-950);
					cad_add_vertex (hndDrawing, -(X_real+G), H-950);
				cad_end_poly (hndDrawing);
			}
			cad_add_rect(hndDrawing, -(X_real-A/2), s, -(X_real+A/2), F, 7);		// Federschutzrohr
			cad_add_rect(hndDrawing, -(X_real-e-(m-t)/2), 0, -(X_real-e-(m-t)/2+m), s, 7);	// Fuplatte	
			if (spannschloss <=F_korr) {							// berarbeiteter Spannschlosseinbau
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 7);	
				cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F_korr, 254); // Spannschloss ausbrennen
				cad_add_rect(hndDrawing, -A_SS/2, 0, A_SS/2, s, 254);	// ausbrennen
			}
			else {			// Spannschloss ist lnger als Federschutzrohr
				cad_add_line(hndDrawing, -A_SS/2, F_korr, -A_SS/2, s, 7);
				cad_add_line(hndDrawing, A_SS/2, F_korr, A_SS/2, s, 7);
				cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -A_SS/2, 0);
					cad_add_vertex(hndDrawing, -A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, 0);
				cad_end_poly(hndDrawing);
				cad_add_rect (hndDrawing, -A_SS/2, F_korr-spannschloss, A_SS/2, F, 254); // Spannschloss ausbrennen
			}
			retObj.xMassTop = X_real+A/2;			// Malinienabstand oben
			retObj.xMassBottom = X_real+(t-e)+(M-t)2;		// Malinienabstand unten
			retObj.xWidthLeft = X_real+G;		// Ausdehnung nach Links
			retObj.xWidthRight = L-X_real-G;		// Ausdehnung nach Rechts
			retObj.xDist = L-X_real-G;				// Koordinaten der PosNr
			retObj.yDist = H-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = G;			// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (TypNach != "")
			{
				this.add_ZMM(hndDrawing, 0, Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;		
			
		case 270: 
			// Ansicht 4 (270 Grad):
			cad_add_rect(hndDrawing, -B/2, s, B/2, F, 7);		// Federschutzrohr
			cad_add_rect(hndDrawing, -C/2, F_korr, C/2, H, 7);	// Mittelteil
			cad_add_rect(hndDrawing, -n/2, 0, n/2, s, 7);		// Fuplatte
			if (spannschloss <=F_korr) {						// berarbeiteter Spannschlosseinbau
				// kein Spannschloss sichtbar
				//cad_add_rect (hndDrawing, -A_SS/2, Emass-(H_SS - E_SS)/2, A_SS/2, F, 254); // Spannschloss ausbrennen
				cad_add_rect(hndDrawing, -A_SS/2, 0, A_SS/2, F, 254);	// ausbrennen
			}
			else {			// Spannschloss ist lnger als Federschutzrohr
				cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -A_SS/2, 0);
					cad_add_vertex(hndDrawing, -A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, F_korr-spannschloss);
					cad_add_vertex(hndDrawing, A_SS/2, 0);
				cad_end_poly(hndDrawing);
				cad_add_rect (hndDrawing, -A_SS/2, F_korr-spannschloss, A_SS/2, F, 254); // Spannschloss ausbrennen
				
				this.add_ZMM(hndDrawing, 0, Emass-(H_SS-E_SS)/2, LGV);
				
			}
			retObj.xMassTop = B/2;			// Malinienabstand oben
			retObj.xMassBottom = n/2;		// Malinienabstand unten
			retObj.xWidthLeft = n/2;		// Ausdehnung nach Links
			retObj.xWidthRight = n/2;		// Ausdehnung nach Rechts
			retObj.xDist = C/2;				// Koordinaten der PosNr
			retObj.yDist = H-(H-F_korr)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = 1.5*C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;		
			
		default:
            break;			
    }
},
 
insertKHS2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)
{
		var L = cad_getdouble ("L");							// Gehausebreite
		var H = cad_getdouble ("H");							// Gehausehoehe
		var A = cad_getdouble ("A");							// Hoehe FSR
		var B = cad_getdouble ("B");							// Breite FSR
		var C = cad_getdouble ("C");
		var F = cad_getdouble ("F");							// Laenge FSR
		var G = cad_getdouble ("G");							// Abstand FSR von Gehaeuseoberkante
		var LGV = cad_getdouble ("LGV");						// Lastgruppe
		var LGR = cad_getdouble ("LGR");						// Lastgroesse
		var e = cad_getdouble ("E_");							// Abstand Gehaeuseoberkante bis Aufhaengebohrung
		var s = cad_getdouble("S");								// Hhe Fuplatte
		var n = cad_getdouble("N");								// Breite Fuplatte
		var sN = cad_getdouble ("SN");							// Nennweg
		var sVOR = threeDparams["Blockierstellung0"];			// Vorspannweg
		var gbx = cad_getdouble ("GBX");						// Laenge Geradstueck Gehause unten
		var X_real = 0;	
		var alpha = acosdeg((C/2)/(B/2));						// Winkel fr Federschutzrohr
		var strSQLStatement = "select * from ZSM where LGV="+LGV+" ";		// Spannschloss-Daten
		var numRet = dbselect("CASCADE", strSQLStatement, "ZSM");
		var A_SS = dbgetdouble("ZSM", "A");
		var H_SS = dbgetdouble("ZSM", "H");
		var E_SS = dbgetdouble("ZSM", "E");
				
		X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gbx);	// Abstand Gehauserueckseite und Gewindestange
		
		if (LGR < 15)
		{
			A = B;
		}
		
		var TypNach = cadMacroParamObject.stkListNextPart;
		
		var Rotation_Int = int (Rotation);			// Switch hier unbedingt mit integer-Werten!!!
		
		switch (Rotation_Int)
		{
			case 0:
				// Ansicht 1 (0 Grad):			
				cad_add_rect(hndDrawing, X_real-L, 0, X_real, s, 7);		// Unterplatte
				cad_begin_poly (hndDrawing, 1, 7);					// Gehaeuse Aussenkontur
					cad_add_vertex (hndDrawing, (X_real - L), s);
					cad_add_vertex (hndDrawing, X_real, s);
					cad_add_vertex (hndDrawing, X_real, H);
					cad_add_vertex (hndDrawing, (X_real - L), H);		// ohne Schraege
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, X_real, H-G-A/2, (X_real + F), H-G+A/2, 7);		// FSR
				retObj.xMassTop = L-X_real;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = L-X_real;		// Ausdehnung nach Links
				retObj.xWidthRight = X_real+F;		// Ausdehnung nach Rechts
				retObj.xDist = X_real+F;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = H-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = F/4;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;
				
			case 90:
				// Ansicht 2 (90 Grad):
				cad_add_rect(hndDrawing, -n/2, 0, n/2, s, 7);			//Fuplatte
				cad_add_rect(hndDrawing, -C/2, s, C/2, H, 7);		 // Mittelteil
					
				// Federschutzrohr:
				if (LGR < 15)
				{
					//rund 
					cad_add_arc(hndDrawing, 0, H-G, B/2, 180-alpha, 180+alpha, 7);	
					cad_add_arc(hndDrawing, 0, H-G, B/2, 0-alpha, alpha, 7);					
				}
				else
				{
					// eckig			
					if (A/2 < (H-G))
					{		
						if (LGR>=18)
						{
							cad_begin_poly (hndDrawing, 0, 7);	
								cad_add_vertex(hndDrawing, -C/2, H-G-A/2);
								cad_add_vertex(hndDrawing, -B/2, H-G-A/2);
								cad_add_vertex(hndDrawing, -B/2, H-G+A/2);
								cad_add_vertex(hndDrawing, B/2, H-G+A/2);
								cad_add_vertex(hndDrawing, B/2, H-G-A/2);									
								cad_add_vertex(hndDrawing, C/2, H-G-A/2);
							cad_end_poly(hndDrawing);
						}
						else
						{
							cad_add_rect(hndDrawing, -B/2, H-G-A/2, -C/2, H-G+A/2, 7);	
							cad_add_rect(hndDrawing, C/2, H-G-A/2, B/2, H-G+A/2, 7);						
						}
					}
					else
					{												
						cad_begin_poly (hndDrawing, 0, 7);	
							cad_add_vertex(hndDrawing, -C/2, H-G+A/2);
							cad_add_vertex(hndDrawing, -B/2, H-G+A/2);
							cad_add_vertex(hndDrawing, -B/2, H-G-A/2);
							cad_add_vertex(hndDrawing, B/2, H-G-A/2);
							cad_add_vertex(hndDrawing, B/2, H-G+A/2);
							cad_add_vertex(hndDrawing, C/2, H-G+A/2);	
						cad_end_poly(hndDrawing);	
					}								
				}				
				retObj.xMassTop = n/2;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
				retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
				retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = H-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = B/2;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;				
				
			case 180:
				// Ansicht 3 (180 Grad):	
				cad_add_rect(hndDrawing, -(X_real-L), 0, -X_real, s, 7);		// Unterplatte
				cad_begin_poly (hndDrawing, 1, 7);					// Gehaeuse Aussenkontur
					cad_add_vertex (hndDrawing, -(X_real - L), s);
					cad_add_vertex (hndDrawing, -X_real, s);
					cad_add_vertex (hndDrawing, -X_real, H);
					cad_add_vertex (hndDrawing, -(X_real - L), H);		// ohne Schraege
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -X_real, H-G-A/2, -(X_real + F), H-G+A/2, 7);		// FSR			
				retObj.xMassTop = X_real;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = X_real;			// Ausdehnung nach Links 
				retObj.xWidthRight = L-X_real;		// Ausdehnung nach Rechts
				retObj.xDist = L-X_real;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = H-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = F/4;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;
				
			case 270: 
				// Ansicht 4 (270 Grad):
				cad_add_rect(hndDrawing, -n/2, 0, n/2, s, 7);			//Fuplatte: always
				
				// Federschutzrohr und Mittelteil
				if (LGR < 15)
				{
					// Federschutzrohr rund
					if (B <= C)
					{ 
						cad_add_rect(hndDrawing, -C/2, s, C/2, H, 7);		 	// Mittelteil
					}
					else
					{
						var h = 2* sqrt(pow(B/2,2) - pow(C/2,2) );		// Lnge des zu entfernenden Mittelteil-Abschnitts
						cad_begin_poly(hndDrawing, 0, 7); 					// Mittelteil mit entfernten Kanten durch FSR
						cad_add_vertex(hndDrawing, -C/2, H-G+h/2); 
						cad_add_vertex(hndDrawing, -C/2, H);
						cad_add_vertex(hndDrawing, C/2, H);
						cad_add_vertex(hndDrawing, C/2, H-G+h/2);			
						cad_end_poly(hndDrawing);
						cad_begin_poly(hndDrawing, 0, 7); 					// untere Hlfte des Mittelteils (rundes FSR) 
						cad_add_vertex(hndDrawing, -C/2, H-G-h/2);
						cad_add_vertex(hndDrawing, -C/2, s);
						cad_add_vertex(hndDrawing, C/2, s);
						cad_add_vertex(hndDrawing, C/2, H-G-h/2);			
						cad_end_poly(hndDrawing);
					}
					cad_add_circle(hndDrawing, 0, H-G, B/2, 7);					
				}
				else
				{
					// Federschutzrohr eckig
					if (LGR>=18)
					{
						cad_begin_poly (hndDrawing, 1, 7);	
							cad_add_vertex(hndDrawing, -B/2, H-G-A/2);
							cad_add_vertex(hndDrawing, -B/2, H-G+A/2);
							cad_add_vertex(hndDrawing, B/2, H-G+A/2);
							cad_add_vertex(hndDrawing, B/2, H-G-A/2);									
						cad_end_poly(hndDrawing);
						if (A/2 < (H-G)) {
							cad_add_rect(hndDrawing, -C/2, s, C/2, H-G-A/2, 7);		// unterer Teil
						}
					}
					else
					{
						cad_add_rect(hndDrawing, -C/2, H-G+A/2, C/2, H, 7);		// oberer Teil
							if (A/2 < (H-G)) {
								cad_add_rect(hndDrawing, -C/2, s, C/2, H-G-A/2, 7);		// unterer Teil
							}
						cad_add_rect(hndDrawing, -B/2, H-G-A/2, B/2, H-G+A/2, 7);	
					}
				}
				retObj.xMassTop = n/2;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
				retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
				retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = H-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = B/2;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;		
				
			default:
				break;			
    }
	// Spannschloss --> immer sichtbar
	cad_add_rect (hndDrawing, -A_SS/2, (-Emass - (H_SS - E_SS)/2), A_SS/2, 0, 7);	
	cad_add_rect (hndDrawing, -A_SS/2, (-Emass - (H_SS - E_SS)/2), A_SS/2, 0, 254);	// ausbrennen
	
	if (TypNach != "")
	{
		this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
	}
},

insertKSx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Konstantstuetze
{
	var gbx = cad_getdouble ("GBX");							// Laenge Geradstueck Gehause unten
	var gri2 = cad_getdouble ("GRI2");
	var gra2 = cad_getdouble ("GRA2");
	var grn2 = cad_getdouble ("GRN2");
	var F = cad_getdouble ("F");								// Laenge FSR
	var L = cad_getdouble ("L");								// Gehausebreite
	var H = cad_getdouble ("H");								// Gehausehoehe
	var G = cad_getdouble ("G");
	var LGV = cad_getdouble ("LGV");							// Lastgruppe
	var LGR = cad_getdouble ("LGR");							// Lastgroesse
	var sN = cad_getdouble ("SN");								// Nennweg
	var sVOR = threeDparams["Blockierstellung0"];				// Vorspannweg
	var e = cad_getdouble ("E_");								// Abstand Bohrung vom Rand			
	var t = cad_getdouble ("T");								// Abstand Bohrungen in Fuplatte
	var s = cad_getdouble ("S");								// Hoehe Fuplatte
	var headUp = cad_getdouble("HGB")/4;						// Hoehe oberes Kopfstueck
	var l = cad_getdouble("L_");								// Breite oberes Kopfstueck
	var asr = cad_getdouble("ASR");
	var bsr = cad_getdouble("BSR");
	var hsr = cad_getdouble("HSR");
	var hgb = cad_getdouble("HGB");
	var p = cad_getdouble("P");
	var hsp = cad_getdouble("HSP");
	var X_real = 0;
	var A = cad_getdouble ("A");								// Hoehe FSR
	var B = cad_getdouble ("B");								// Breite FSR
	var C = cad_getdouble("C"); 
	var n = cad_getdouble("N");									// Fubreite
	var ms = cad_getdouble("MS");
	var alpha = acosdeg((C/2)/(B/2));
	var betha = 30-asindeg((sN/2-sVOR)/sN);						// Vorspannwinkel
	
	X_real = sN*cosdeg(30-betha) + gbx;
	
	if (LGR < 15)
	{
			A = B;
	}
		
	//Emass = 350;		// nur zu Testzwecken  
    	
	var Rotation_Int = int (Rotation);			// Switch hier unbedingt mit integer-Werten!!!
		
	switch (Rotation_Int)
    {
        case 0:
			// Ansicht 1 (0 Grad):
			cad_add_rect(hndDrawing, X_real-L, -Emass+s, X_real, -Emass+H, 7); 			// Mittelteil
			cad_add_rect(hndDrawing, X_real-L, -Emass, X_real, -Emass+s, 7);			// Fuplatte	
			cad_add_rect(hndDrawing, X_real, -Emass+G-A/2, X_real+F, -Emass+G+A/2, 7);	//Federschutzrohr
				
			if (Typid == "KSR")
			{
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -headUp-hsr, 7);  		// Sttze unter Kopf
				cad_add_line(hndDrawing, bsr/2, -headUp-hsr, X_real, -Emass+H, 7);			//Hebel
				cad_add_rect(hndDrawing, -(0.8*bsr)/2, -headUp, (0.8*bsr)/2, 0, 7);  		// oberes Kopfstck
				cad_add_rect(hndDrawing, -bsr/2, -headUp-hsr, bsr/2, -headUp, 7);			// unteres Kopfstck
				retObj.xMassTop = (0.8*bsr)/2;			// Malinienabstand oben
			}
			else
			{
				
				cad_add_rect(hndDrawing, - p/2, -hsp, p/2, 0, 7);		// Typid == KSP
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -hsp, 7);  		// Sttze unter Kopf
				cad_add_line(hndDrawing, p/2, -hsp, X_real, -Emass+H, 7);			//Hebel
				retObj.xMassTop = p/2;			// Malinienabstand oben
				
			}
			retObj.xMassBottom = L-X_real;		// Malinienabstand unten
			retObj.xWidthLeft = L-X_real;		// Ausdehnung nach Links
			retObj.xWidthRight = X_real+F;		// Ausdehnung nach Rechts
			retObj.xDist = X_real+F;				// x-Abstand der PosNrLinie vom BP
			retObj.yDist = -Emass+G;		// y-Abstand der PosNrLinie vom BP
			retObj.L_PosNr = F/4;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;
			
        case 90:
			// Ansicht 2 (90 Grad):
			cad_add_rect(hndDrawing, -C/2, -Emass+s, C/2, -Emass+H, 7);		 		// Mittelteil
			cad_add_rect(hndDrawing, -n/2, -Emass, n/2, -Emass+s, 7);				// Fuplatte
			
			
			if (Typid == "KSR")
			{
			
				cad_add_rect(hndDrawing, -l/2, -headUp, l/2, 0, 7);  					// oberes Kopfstck
				cad_add_rect(hndDrawing, -asr/2, -headUp-hsr, asr/2, -headUp, 7);		// unteres Kopfstck			
				cad_add_rect(hndDrawing, -ms/2, -Emass+H, ms/2, -headUp-hsr, 7);  		// Sttze unter Kopf	
				retObj.xMassTop = l/2;			// Malinienabstand oben
			}
			else
			{
				cad_add_rect(hndDrawing, - p/2, -hsp, p/2, 0, 7);		// Typid == KSP
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -hsp, 7);  		// Sttze unter Kopf				
				retObj.xMassTop = p/2;			// Malinienabstand oben
			}
				
			// Federschutzrohr:
			if (LGR < 15)
			{
				//rund 
				cad_add_arc(hndDrawing, 0, -Emass+G, B/2, 180-alpha, 180+alpha, 7);	
				cad_add_arc(hndDrawing, 0, -Emass+G, B/2, 0-alpha, alpha, 7);					
			}
			else
			{
				// eckig
				cad_add_rect(hndDrawing, -B/2, -Emass+G-A/2, -C/2, -Emass+G+A/2, 7);	
				cad_add_rect(hndDrawing, C/2, -Emass+G-A/2, B/2, -Emass+G+A/2, 7);	
			}
			
			retObj.xMassBottom = n/2;		// Malinienabstand unten
			retObj.xWidthLeft = n/2;		// Ausdehnung nach Links
			retObj.xWidthRight = n/2;		// Ausdehnung nach Rechts
			retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
			retObj.yDist = -Emass+G;		// y-Abstand der PosNrLinie vom BP
			retObj.L_PosNr = C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;			
		
		case 180:
			// Ansicht 3 (180 Grad):
			cad_add_rect(hndDrawing, -X_real+L, -Emass+s, -X_real, -Emass+H, 7); 			// Mittelteil
			cad_add_rect(hndDrawing, -X_real+L, -Emass, -X_real, -Emass+s, 7);				// Fuplatte	
			cad_add_rect(hndDrawing, -X_real, -Emass+G-A/2, -X_real-F, -Emass+G+A/2, 7);	//Federschutzrohr
			
			
			
			if (Typid == "KSR")
			{
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -headUp-hsr, 7);  		// Sttze unter Kopf
				cad_add_line(hndDrawing, -bsr/2, -headUp-hsr, -X_real, -Emass+H, 7);		//Hebel
				cad_add_rect(hndDrawing, -(0.8*bsr)/2, -headUp, (0.8*bsr)/2, 0, 7);  		// oberes Kopfstck
				cad_add_rect(hndDrawing, -bsr/2, -headUp-hsr, bsr/2, -headUp, 7);			// unteres Kopfstck
				retObj.xMassTop = (0.8*bsr)/2;			// Malinienabstand oben
			}
			else
			{
				
				cad_add_rect(hndDrawing, - p/2, -hsp, p/2, 0, 7);					// Typid == KSP
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -hsp, 7);  		// Sttze unter Kopf
				cad_add_line(hndDrawing, -p/2, -hsp, -X_real, -Emass+H, 7);			//Hebel
				retObj.xMassTop = p/2;			// Malinienabstand oben
			}
			retObj.xMassBottom = X_real;		// Malinienabstand unten
			retObj.xWidthLeft = X_real+F;		// Ausdehnung nach Links
			retObj.xWidthRight = L-X_real;		// Ausdehnung nach Rechts
			retObj.xDist = L-X_real;				// x-Abstand der PosNrLinie vom BP
			retObj.yDist = -Emass+G;		// y-Abstand der PosNrLinie vom BP
			retObj.L_PosNr = F/4;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;			
			
		case 270: 
			// Ansicht 4 (270 Grad):
			
			cad_add_rect(hndDrawing, -n/2, -Emass, n/2, -Emass+s, 7);				// Fuplatte
			
			if (Typid == "KSR")
			{
				cad_add_rect(hndDrawing, -l/2, -headUp, l/2, 0, 7);  					// oberes Kopfstck
				cad_add_rect(hndDrawing, -asr/2, -headUp-hsr, asr/2, -headUp, 7);		// unteres Kopfstck			
				cad_add_rect(hndDrawing, -ms/2, -Emass+H, ms/2, -headUp-hsr, 7);  		// Sttze unter Kopf		
				retObj.xMassTop = l/2;			// Malinienabstand oben
			}
			else
			{
				cad_add_rect(hndDrawing, - p/2, -hsp, p/2, 0, 7);		// Typid == KSP
				cad_add_rect(hndDrawing, -hgb/2, -Emass+H, hgb/2, -hsp, 7);  		// Sttze unter Kopf				
				retObj.xMassTop = p/2;			// Malinienabstand oben
			}
			
			if (LGR < 15)
			{
				//rund 
			
			
			if (B <= C)
			{ 
				cad_add_rect(hndDrawing, -C/2, -Emass+s, C/2, -Emass+H, 7);		 	// Mittelteil alt
			}
			else
			{
				var h = 2* sqrt(pow(B/2,2) - pow(C/2,2) );		// Lnge des zu entfernenden Mittelteil-Abschnitts
				cad_begin_poly(hndDrawing, 0, 7); 					// Mittelteil mit entfernten Kanten durch FSR
				cad_add_vertex(hndDrawing, -C/2, -Emass+G+h/2); 
				cad_add_vertex(hndDrawing, -C/2, -Emass+H);
				cad_add_vertex(hndDrawing, C/2, -Emass+H);
				cad_add_vertex(hndDrawing, C/2, -Emass+G+h/2);			
				cad_end_poly(hndDrawing);
				cad_begin_poly(hndDrawing, 0, 7); 					// untere Hlfte des Mittelteils (rundes FSR) 
				cad_add_vertex(hndDrawing, -C/2, -Emass+(G-h/2));
				cad_add_vertex(hndDrawing, -C/2, -Emass+s);
				cad_add_vertex(hndDrawing, C/2, -Emass+s);
				cad_add_vertex(hndDrawing, C/2, -Emass+(G-h/2));			
				cad_end_poly(hndDrawing);
			}
				
			// Federschutzrohr:
			cad_add_circle(hndDrawing, 0, -Emass+G, B/2, 7);					
			}
			else
			{
				// eckig
				cad_add_rect(hndDrawing, -C/2, -Emass+G+A/2, C/2, -Emass+H, 7);
				cad_add_rect(hndDrawing, -C/2, -Emass+s, C/2, -Emass+G-A/2, 7);
				
				// Federschutzrohr:
				cad_add_rect(hndDrawing, -B/2, -Emass+G-A/2, B/2, -Emass+G+A/2, 7);	
			}
			retObj.xMassBottom = n/2;		// Malinienabstand unten
			retObj.xWidthLeft = n/2;		// Ausdehnung nach Links
			retObj.xWidthRight = n/2;		// Ausdehnung nach Rechts
			retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
			retObj.yDist = -Emass+G;		// y-Abstand der PosNrLinie vom BP
			retObj.L_PosNr = C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;			
			
		default:
            break;			
    }
},

insertKVD2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// KVD
{
  
	var gbx = cad_getdouble ("GBX");						// Laenge Geradstueck Gehause unten li
	var gpx = cad_getdouble ("GPX");						// Laenge Geradstueck Gehause unten re
	var F = cad_getdouble ("F");							// Laenge FSR
	var LGV = cad_getdouble ("LGV");						// Lastgruppe
	var LGR = cad_getdouble ("LGR");						// Lastgroesse
	var sN = cad_getdouble ("SN");							// Nennweg
	var sVOR = threeDparams["Blockierstellung0"];			// Vorspannweg
	var X_real = 0;											// Abstand Mitte FSR und Gewindestange
	var L = cad_getdouble ("L");							// Gehausebreite
	var H = cad_getdouble ("H");							// Gehausehoehe
	var G = cad_getdouble ("G");							
	var a = cad_getdouble ("AL");							// Lnge Aufhngelasche
	var c1 = cad_getdouble ("C1");							// Dmr Aufhaengebohrung
	var c2 = cad_getdouble ("C2");							// Dmr zweite Laschenbohrung
	var e = cad_getdouble ("E_");							// Abstand Gehaeuseoberkante bis Aufhaengebohrung
	var t = cad_getdouble ("T");							// Abstand Laschenbohrungen
	var z = cad_getdouble ("Z");							// Abstand Aufhaengebohrung bis Laschenoberkante
	var aL = cad_getdouble("A_");							// Abstand zwischen den Laschen 
	var bL = cad_getdouble("B_"); 							// Breite der Lasche 
	var C = cad_getdouble("C"); 
	var A = cad_getdouble ("A");							// Hoehe FSR
	var B = cad_getdouble ("B");							// Breite FSR
	var strSQLStatement = "select * from ZSM where LGV="+LGV+" ";		// Spannschloss-Daten
	var numRet = dbselect("CASCADE", strSQLStatement, "ZSM");
	var A_SS = dbgetdouble("ZSM", "A");
	var H_SS = dbgetdouble("ZSM", "H");
	var E_SS = dbgetdouble("ZSM", "E");
	var t_SS = (A_SS / 1.6);								// Kopfhoehe (Naeherung)
	var e1_SS = (LGV + 4);									// Spaltbreite (Naeherung)
	var spannschloss = -e-H+F - (-Emass - (H_SS - E_SS)/2);			// Spannschloss - Berechnung !!!!
	
	var strSQLStatement = "select * from KHPARALLELOGRAMM where LGR="+LGR+" and SN="+sN+" ";
	var numRet = dbselect("CASCADE", strSQLStatement, "KHPARALLELOGRAMM");
	if (mumRet == 0)
	{
		var dx_Para = 0;
	}
	else
	{
		var dx_Para = (dbgetdouble("KHPARALLELOGRAMM", "b1_Para") - dbgetdouble("KHPARALLELOGRAMM", "R4_Para"));
	}
	
	X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gpx - G + dx_Para);
	
	if (LGR < 15)
	{
			A = B;
	}
	
	var TypNach = cadMacroParamObject.stkListNextPart;
	
	var Rotation_Int = int (Rotation);			// Switch hier unbedingt mit integer-Werten!!!
		
	switch (Rotation_Int)
    {
        case 0:
			// Ansicht 1 (0 Grad):
			cad_add_circle(hndDrawing, 0, 0, c1/2, 7);
			cad_add_circle(hndDrawing, t, 0, c2/2, 7);
			cad_add_rect(hndDrawing, -((a-t)/2), -e, t+(a-t)/2, z, 7);		// Aufhngelasche
			cad_add_rect(hndDrawing, -((a-t)/2), -e, t+(a-t)/2, z, 254);		// ausbrennen
			cad_add_rect(hndDrawing, X_real+G-L, -e-H+F, X_real+G, -e, 7); 	
			cad_add_rect(hndDrawing, X_real-A/2, -e-H, X_real+A/2, -e-H+F, 7);		// Federschutzrohr
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 7);	// Spannschloss
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 254);	// Ausbrennen Spannschloss
			if ((Rotation == 0) || (Rotation == 180))
			{
			cad_add_rect (hndDrawing, -e1_SS/2, -Emass - (H_SS - E_SS)/2 + t_SS, e1_SS/2, -Emass - (H_SS - E_SS)/2 + H_SS - t_SS, 7);
			cad_add_rect (hndDrawing, -e1_SS/2, -Emass - (H_SS - E_SS)/2 + t_SS, e1_SS/2, -Emass - (H_SS - E_SS)/2 + H_SS - t_SS, 254);
			}
			retObj.xMassTop = (a-t)/2;			// Malinienabstand oben
			retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
			retObj.xWidthLeft = L-X_real-G;		// Ausdehnung nach Links
			retObj.xWidthRight = X_real+G;		// Ausdehnung nach Rechts
			retObj.xDist = X_real+G;				// Koordinaten der PosNr
			retObj.yDist = -e-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = G;			// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (TypNach != "")
			{
				this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;
			
        case 90:
			// Ansicht 2 (90 Grad):
			cad_add_rect(hndDrawing, -aL/2-bL/2, -e, (aL+bL)/2, z, 7);
			cad_add_rect(hndDrawing, -C/2, -e-H+F, C/2, -e, 7);		// Mittelteil
			if (spannschloss <=F) {							// berarbeiteter Spannschlosseinbau
				cad_add_rect(hndDrawing, -B/2, -e-H, B/2, -e-H+F, 7);		// FSR
			}
			else {			// Spannschloss ist lnger als Federschutzrohr
				cad_begin_poly(hndDrawing, 0, 7);
					cad_add_vertex(hndDrawing, -A_SS/2, -e-H);
					cad_add_vertex(hndDrawing, -B/2, -e-H);
					cad_add_vertex(hndDrawing, -B/2, -e-H+F);
					cad_add_vertex(hndDrawing, B/2, -e-H+F);
					cad_add_vertex(hndDrawing, B/2, -e-H);
					cad_add_vertex(hndDrawing, A_SS/2, -e-H);
				cad_end_poly(hndDrawing);
			}	
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 7);	// Spannschloss
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 254);	// ausbrennen
			retObj.xMassTop = (aL+bL)/2;			// Malinienabstand oben
			retObj.xMassBottom = B/2;		// Malinienabstand unten
			retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
			retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
			retObj.xDist = C/2;				// Koordinaten der PosNr
			retObj.yDist = -e-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = 2*C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (TypNach != "")
			{
				this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;			
		
		case 180:
			// Ansicht 3 (180 Grad):
			cad_add_circle(hndDrawing, 0, 0, c1/2, 7);
			cad_add_circle(hndDrawing, -t, 0, c2/2, 7);
			cad_add_rect(hndDrawing, ((a-t)/2), -e, -t-(a-t)/2, z, 7);		// Aufhngelasche
			cad_add_rect(hndDrawing, ((a-t)/2), -e, -t-(a-t)/2, z, 254);
			cad_add_rect(hndDrawing, -X_real-G+L, -e-H+F, -X_real-G, -e, 7); 	
			cad_add_rect(hndDrawing, -X_real-A/2, -e-H, -X_real+A/2, -e-H+F, 7);		// Federschutzrohr		
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 7);	// Spannschloss
			cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e - H + F, 254);	 
			retObj.xMassTop = t+(a-t)/2;			// Malinienabstand oben
			retObj.xMassBottom = X_real+A/2;		// Malinienabstand unten
			retObj.xWidthLeft = X_real+G;		// Ausdehnung nach Links
			retObj.xWidthRight = L-X_real-G;		// Ausdehnung nach Rechts
			retObj.xDist = L-X_real-G;				// Koordinaten der PosNr
			retObj.yDist = -e-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = G;			// Lnge der PosNr-Linie
			retObj.index = 1;
			
			if (Typ != "")
			{
				this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
			}
			
			break;			
			
		case 270: 
			// Ansicht 4 (270 Grad):
			cad_add_rect(hndDrawing, -aL/2-bL/2, -e, (aL+bL)/2, z, 7);
			cad_add_rect(hndDrawing, -C/2, -e-H+F, C/2, -e, 7);
			cad_add_rect(hndDrawing, -B/2, -e-H, B/2, -e-H+F, 7); // FSR
			cad_add_rect(hndDrawing, -A_SS/2, -e-H, A_SS/2, -e-H+F, 254); // ausbrennen
						
			if (spannschloss <=F) {							// berarbeiteter Spannschlosseinbau
				cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e-H + F, 7);	// Spannschloss			
				cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e-H + F, 254);	// ausbrennen
			}
			else {
				cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e-H, 7);	// Spannschloss				
				cad_add_rect (hndDrawing, -A_SS/2, -Emass - (H_SS - E_SS)/2, A_SS/2, -e-H, 254);
				
				if (TypNach != "")
				{
					this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
				}
			}	
			retObj.xMassTop = (aL+bL)/2;	// Malinienabstand oben
			retObj.xMassBottom = B/2;		// Malinienabstand unten
			retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
			retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
			retObj.xDist = C/2;				// Koordinaten der PosNr
			retObj.yDist = -e-(H-F)/2;		// Koordinaten der PosNr
			retObj.L_PosNr = 2*C;			// Lnge der PosNr-Linie
			retObj.index = 1;
			break;			
			
		default:
            break;			
    }
	
	
}, 
  
insertKHD2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// KH Typ KHD
{
		var L = cad_getdouble ("L");							// Gehausebreite
		var H = cad_getdouble ("H");							// Gehausehoehe
		var gbx = cad_getdouble ("GBX");						// Laenge Geradstueck Gehause unten
		var gwi = cad_getdouble ("GWI");						// Winkel Gehause unten
		var A = cad_getdouble ("A");							// Hoehe FSR
		var B = cad_getdouble ("B");							// Breite FSR
		var C = cad_getdouble ("C");
		var F = cad_getdouble ("F");							// Laenge FSR
		var G = cad_getdouble ("G");							// Abstand FSR von Gehaeuseoberkante
		var LGV = cad_getdouble ("LGV");						// Lastgruppe
		var LGR = cad_getdouble ("LGR");						// Lastgroesse
		var e = cad_getdouble ("E_");							// Abstand Gehaeuseoberkante bis Aufhaengebohrung
		var sN = cad_getdouble ("SN");							// Nennweg
		var sVOR = threeDparams["Blockierstellung0"];			// Vorspannweg
		var c1z = cad_getdouble ("C1Z");						// Abstand Aufhaengebohrung bis Laschenkante
		var al = cad_getdouble ("AL");							// Laschenlaenge
		var z = cad_getdouble ("Z");							// Abstand Aufhaengebohrung bis Laschenoberkante
		var c1 = cad_getdouble ("C1");							// Dmr Aufhaengebohrung
		var c2 = cad_getdouble ("C2");							// Dmr zweite Laschenbohrung
		var t = cad_getdouble ("T");							// Abstand Laschenbohrungen
		var X_real = 0;	
		var alpha = acosdeg((C/2)/(B/2));						// Winkel fr Federschutzrohr
		
		var strSQLStatement = "select * from ZSM where LGV="+LGV+" ";		// Spannschloss-Daten
		var numRet = dbselect("CASCADE", strSQLStatement, "ZSM");
		var A_SS = dbgetdouble("ZSM", "A");
		var H_SS = dbgetdouble("ZSM", "H");
		var E_SS = dbgetdouble("ZSM", "E");
		var t_SS = (A_SS / 1.6);					// Kopfhoehe (Naeherung)
		var e1_SS = (LGV + 4);						// Spaltbreite (Naeherung)
		
		var TypNach = cadMacroParamObject.stkListNextPart;
		
		X_real = (sN*cosdeg(30-asindeg((sN/2-sVOR)/sN)) + gbx);	// Abstand Gehauserueckseite und Gewindestange
		
		if (LGR < 15)
		{
			A = B;
		}
		var Rotation_Int = int (Rotation);			// Switch hier unbedingt mit integer-Werten!!!
		
		switch (Rotation_Int)
		{
			case 0:
				// Ansicht 1 (0 Grad):			
				cad_begin_poly (hndDrawing, 1, 7);							// Gehaeuse Aussenkontur
					cad_add_vertex (hndDrawing, (X_real - L), -e);
					cad_add_vertex (hndDrawing, X_real, -e);
					cad_add_vertex (hndDrawing, X_real, (-e - H));
					//cad_add_vertex (hndDrawing, (X_real - gbx), (-e - H));	// mit Schraege
					//cad_add_vertex (hndDrawing, (X_real - L), (-e - H + (L-gbx)*tandeg(gwi)));
					cad_add_vertex (hndDrawing, (X_real - L), (-e - H));		// ohne Schraege
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, -c1z, z, (al - c1z), -e, 7);		// Aufhaengelasche
				cad_add_rect (hndDrawing, -c1z, z, (al - c1z), -e, 254);	// Ausbrennen Aufhaengelasche
				cad_add_circle (hndDrawing, 0, 0, c1/2, 7);					// Aufhngebohrung 1
				cad_add_circle (hndDrawing, t, 0, c2/2, 7);					// Aufhngebohrung 2
				cad_add_rect (hndDrawing, X_real, (-e - G + A/2), (X_real + F), (-e - G - A/2), 7);		// FSR
				
				retObj.xMassTop = L-X_real;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = L-X_real;		// Ausdehnung nach Links
				retObj.xWidthRight = X_real+F;		// Ausdehnung nach Rechts
				retObj.xDist = X_real+F;			// x-Abstand der PosNrLinie vom BP
				retObj.yDist = -e-G;				// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = F/4;				// Lnge der PosNr-Linie
				retObj.index = 1;
				break;
				
			case 90:
				// Ansicht 2 (90 Grad):
				cad_add_rect(hndDrawing, -C/2, -e-H, C/2, -e, 7);	// Mittelteil
				cad_add_rect(hndDrawing, -C/6, -e, C/6, z, 7); 		// Aufhngelasche
				
				// Federschutzrohr:
				if (LGR < 15)
				{
					//rund 
					cad_add_arc(hndDrawing, 0, -e-G, B/2, 180-alpha, 180+alpha, 7);	
					cad_add_arc(hndDrawing, 0, -e-G, B/2, 0-alpha, alpha, 7);					
				}
				else
				{
					// eckig			
					if (A/2 < (H-G))
					{		
						cad_add_rect(hndDrawing, -B/2, -e-G-A/2, -C/2, -e-G+A/2, 7);	
						cad_add_rect(hndDrawing, C/2, -e-G-A/2, B/2, -e-G+A/2, 7);						
					}
					else
					{													// tritt bei groen LGR auf
						cad_begin_poly (hndDrawing, 0, 7);	
							cad_add_vertex(hndDrawing, -C/2, -e-G+A/2);
							cad_add_vertex(hndDrawing, -B/2, -e-G+A/2);
							cad_add_vertex(hndDrawing, -B/2, -e-G-A/2);
							cad_add_vertex(hndDrawing, B/2, -e-G-A/2);
							cad_add_vertex(hndDrawing, B/2, -e-G+A/2);
							cad_add_vertex(hndDrawing, C/2, -e-G+A/2);	
						cad_end_poly(hndDrawing);	
					}								
				}
				retObj.xMassTop = C/6;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;	// Malinienabstand unten
				retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
				retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
				retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = -e-G;			// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = B/2;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;				
				
			case 180:
				// Ansicht 3 (180 Grad):	
				cad_begin_poly (hndDrawing, 1, 7);					// Gehaeuse Aussenkontur
					cad_add_vertex (hndDrawing, -(X_real - L), -e);
					cad_add_vertex (hndDrawing, -X_real, -e);
					cad_add_vertex (hndDrawing, -X_real, (-e - H));
					cad_add_vertex (hndDrawing, -(X_real - L), (-e - H));		// ohne Schraege
				cad_end_poly (hndDrawing);
				cad_add_rect (hndDrawing, c1z, z, -(al - c1z), -e, 7);	// Aufhaengelasche
				cad_add_rect (hndDrawing, c1z, z, -(al - c1z), -e, 254);	// ausbrennen
				cad_add_circle (hndDrawing, 0, 0, c1/2, 7);			// Aufhngebohrung 1
				cad_add_circle (hndDrawing, -t, 0, c2/2, 7);			// Aufhngebohrung 2
				cad_add_rect (hndDrawing, -X_real, (-e - G + A/2), -(X_real + F), (-e - G - A/2), 7);	// FSR
				
				// cad_add_rect (hndDrawing, -A_SS/2, (-Emass - (H_SS - E_SS)/2), A_SS/2, (-e - H), 7);	// Spannschloss vereinfacht 
				// cad_add_rect (hndDrawing, -A_SS/2, (-Emass - (H_SS - E_SS)/2), A_SS/2, (-e - H), 254);
				retObj.xMassTop = t+c1z;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = X_real;			// Ausdehnung nach Links
				retObj.xWidthRight = L-X_real;		// Ausdehnung nach Rechts
				retObj.xDist = L-X_real;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = -e-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = F/4;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;
				
			case 270: 
				// Ansicht 4 (270 Grad):
				cad_add_rect(hndDrawing, -C/6, -e, C/6, z, 7); 		// Aufhngelasche				
				
				if (LGR < 15)
				{
					//rund 
					if (B <= C)
					{
						cad_add_rect(hndDrawing, -C/2, -e-H, C/2, -e, 7);		 	// Mittelteil
					}
					else
					{
						var h = 2* sqrt(pow(B/2,2) - pow(C/2,2) );		// Lnge des zu entfernenden Mittelteil-Abschnitts
						cad_begin_poly(hndDrawing, 0, 7); 					// Mittelteil mit entfernten Kanten durch FSR
						cad_add_vertex(hndDrawing, -C/2, -e-G+h/2); 
						cad_add_vertex(hndDrawing, -C/2, -e);
						cad_add_vertex(hndDrawing, C/2, -e);
						cad_add_vertex(hndDrawing, C/2, -e-G+h/2);			
						cad_end_poly(hndDrawing);
						cad_begin_poly(hndDrawing, 0, 7); 					// untere Hlfte des Mittelteils (rundes FSR) 
						cad_add_vertex(hndDrawing, -C/2, -e-G-h/2);
						cad_add_vertex(hndDrawing, -C/2, -e-H);
						cad_add_vertex(hndDrawing, C/2, -e-H);
						cad_add_vertex(hndDrawing, C/2, -e-G-h/2);			
						cad_end_poly(hndDrawing);
					}
					// Federschutzrohr:
					cad_add_circle(hndDrawing, 0, -e-G, B/2, 7);					
				}
				else
				{
					// eckig
					cad_add_rect(hndDrawing, -C/2, -e-G+A/2, C/2, -e, 7);		// oberer Teil
					
					if (A/2 < (H-G)) {
						cad_add_rect(hndDrawing, -C/2, -e-H, C/2, -e-G-A/2, 7);		// unterer Teil
					}
							
					// Federschutzrohr:
					cad_add_rect(hndDrawing, -B/2, -e-G-A/2, B/2, -e-G+A/2, 7);	
				}
				retObj.xMassTop = C/6;			// Malinienabstand oben
				retObj.xMassBottom = A_SS/2;		// Malinienabstand unten
				retObj.xWidthLeft = B/2;		// Ausdehnung nach Links
				retObj.xWidthRight = B/2;		// Ausdehnung nach Rechts
				retObj.xDist = B/2;				// x-Abstand der PosNrLinie vom BP
				retObj.yDist = -e-G;		// y-Abstand der PosNrLinie vom BP
				retObj.L_PosNr = B/2;			// Lnge der PosNr-Linie
				retObj.index = 1;
				break;		
				
			default:
				break;			
    }
	
	// Spannschloss --> immer sichtbar
	if (A/2 < (H-G))
	{
		cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-H, 7);
		cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-H, 254);
	}
	else
	{
			if (Rotation == 90 ||Rotation == 270)
			{	
				cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-G-A/2, 7);
				cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-G-A/2, 254);		
			}	
			else
			{
				cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-H, 7);
				cad_add_rect (hndDrawing, -A_SS/2, -Emass-(H_SS-E_SS)/2, A_SS/2, -e-H, 254);
			}
	}
	if (Rotation == 0 ||Rotation == 180)
	{
		cad_add_rect (hndDrawing, -e1_SS/2, -Emass-(H_SS-E_SS)/2+t_SS, e1_SS/2, -Emass-(H_SS-E_SS)/2+H_SS-t_SS, 7);
		cad_add_rect (hndDrawing, -e1_SS/2, -Emass-(H_SS-E_SS)/2+t_SS, e1_SS/2, -Emass-(H_SS-E_SS)/2+H_SS-t_SS, 254);
	}
	
	if (TypNach != "")
	{
		this.add_ZMM(hndDrawing, 0, -Emass-(H_SS-E_SS)/2, LGV);
	}	
	
}, 

insertSSG2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Gelenkstrebe
{
	var A = cad_getdouble("A");			// Durchmesser 1
	var d = cad_getdouble("D_");		// Durchmesser 2
	var H = cad_getdouble("H");
	var M = cad_getdouble("M");
	var SWM = cad_getdouble("SWM");		// SW Mutter
	var mR = cad_getdouble("MR");
	var f = cad_getdouble("F");
	var g = cad_getdouble("G");
	
	//var L = cad_getdouble("L");
	
	var L = 0;
	if (threeDparams["E-Mass0"] == Emass)
	{
		L = cad_getdouble("L");
	}
	else
	{
		L = (cad_getdouble("L") - (threeDparams["E-Mass0"] - Emass));
	};
	
	var D = cad_getdouble("D");
	var D1 = cad_getdouble("D1");
	var mL = cad_getdouble("ML");
	var B = cad_getdouble("B");
	//var Emass3D = threeDparams["E-Mass0"];
	var Emass3D = Emass;
	var verbSt = 0.5*(Emass3D-L-mL-mR-(2*H));	// Verbindungsstck zwischen Mutter und Endteil
	var mitte = L-2*g-2*f;						// Mittelstck
	var length = 0;								// Variable fr aktuelle Entfernung vom BP
 
	// cad_add_circle(hndDrawing, 0, 0, 10, 7);		// find Basispunkt

	if (Rotation == 0 || Rotation == 180)
	{
   		// Koerperkanten
		// Endstck oben
		cad_begin_poly(hndDrawing, 0, 7);
			cad_add_vertex(hndDrawing, -M/2, -H);
			cad_add_vertex2(hndDrawing, -A/2, 0, -A/2);		// Radius negativ!
			cad_add_vertex(hndDrawing, A/2, 0);
			cad_add_vertex(hndDrawing, M/2, -H);
			cad_end_poly(hndDrawing);
		cad_add_circle(hndDrawing, 0, 0, d/2, 7);
		
		// Ausbrennen
		cad_begin_poly(hndDrawing, 1, 254);
			cad_add_vertex(hndDrawing, -M/2, -H);
			cad_add_vertex2(hndDrawing, -A/2, 0, -A/2);		// Radius negativ!
			cad_add_vertex(hndDrawing, A/2, 0);
			cad_add_vertex(hndDrawing, M/2, -H);
			cad_end_poly(hndDrawing);
		cad_add_circle(hndDrawing, 0, 0, d/2, 254);
		
		retObj.xMassTop = d/2;
		retObj.xMassBottom = d/2;
		retObj.index = 0;
	}
	else
	{
		// Koerperkanten
		// Endstck oben, Seitenansicht
		cad_add_rect(hndDrawing, -B/2, A/2, B/2, -H, 7);
		
		// Ausbrennen
		cad_add_rect(hndDrawing, -B/2, A/2, B/2, -H, 254);
		
		retObj.xMassTop = B/2;
		retObj.xMassBottom = B/2;
		retObj.index = 1;
	}
	
	// Hauptteil:
	length = -H;
	cad_add_rect(hndDrawing, -M/2, length, M/2, length-verbSt, 7);		// Verbindungsstck
	length = length - verbSt;
	cad_add_rect(hndDrawing, -SWM/2, length, SWM/2, length-mL, 7);		// Mutter
	length = length - mL;
	cad_add_rect(hndDrawing, -D1/2, length, D1/2, length-f, 7);			 
	length = length - f;
	cad_add_line(hndDrawing, -D1/2, length, -D/2, length-g , 7);		// Schrge
	cad_add_line(hndDrawing, D1/2, length, D/2, length-g , 7);			// Schrge
	length = length - g;
	cad_add_rect(hndDrawing, -D/2, length, D/2, length - mitte, 7);
	length = length - mitte;
	cad_add_line(hndDrawing, -D/2, length, -D1/2, length-g , 7);		// Schrge
	cad_add_line(hndDrawing, D/2, length, D1/2, length-g , 7);			// Schrge
	length = length - g;
	cad_add_rect(hndDrawing, -D1/2, length, D1/2, length-f, 7);			 
	length = length - f;
	cad_add_rect(hndDrawing, -SWM/2, length, SWM/2, length-mR, 7);		// Mutter
	length = length - mR;
	cad_add_rect(hndDrawing, -M/2, length, M/2, length-verbSt, 7);		// Verbindungsstck
	length = length - verbSt;
		
	if (Rotation == 0 || Rotation == 180)
	{
		// Koerperkanten
		// Endstck unten
		cad_begin_poly(hndDrawing, 0, 7);
			cad_add_vertex(hndDrawing, -M/2, length);
			cad_add_vertex2(hndDrawing, -A/2, length - H, A/2);		
			cad_add_vertex(hndDrawing, A/2, length - H);
			cad_add_vertex(hndDrawing, M/2, length);
			cad_end_poly(hndDrawing);
		cad_add_circle(hndDrawing, 0, length - H, d/2, 7);
		
		// Ausbrennen
		cad_begin_poly(hndDrawing, 0, 254);
			cad_add_vertex(hndDrawing, -M/2, length);
			cad_add_vertex2(hndDrawing, -A/2, length - H, A/2);		
			cad_add_vertex(hndDrawing, A/2, length - H);
			cad_add_vertex(hndDrawing, M/2, length);
			cad_end_poly(hndDrawing);
		cad_add_circle(hndDrawing, 0, length - H, d/2, 254);
	}
	else
	{
		// Koerperkanten
		// Endstck unten, Seitenansicht
		var y1 = -(double (Emass3D) -H);
		var y2 = -(double (Emass3D) +(A/2));
		cad_add_rect(hndDrawing, -B/2, y1, B/2, y2, 7);
		
		// Ausbrennen
		cad_add_rect(hndDrawing, -B/2, y1, B/2, y2, 254);
	}
	
	retObj.xWidthLeft = D/2;
	retObj.xWidthRight = D/2;
	retObj.xDist = D/2;
	retObj.yDist = -Emass/2;
	retObj.L_PosNr = D;

}, 


insertMBS2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)
{
		var A = cad_getdouble("A");		// Laenge
		var B = cad_getdouble("B");		// Breite
		var L = cad_getdouble("L");		// Laenge Bolzen
		var c = cad_getdouble("C");		// Dmr Bolzen
		var f = cad_getdouble("F");		// Spaltbreite
		var s = cad_getdouble("S");		// Bodendicke
		var a = cad_getdouble("SCH_A");	// a-Mass Kehlnaht
		
		if ((cadMacroParamObject.stkListNextPart == "MSN") || (cadMacroParamObject.stkListPrevPart == "MSN") || (cadMacroParamObject.stkListNextPart == "VGR") || (cadMacroParamObject.stkListPrevPart == "VGR"))
		{
			a = 0;
		}
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			// Koerperkanten
			cad_add_circle(hndDrawing, 0, 0, c/2, 7);
			
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, -A/2, -Emass);
				cad_add_vertex2(hndDrawing, -A/2, 0, -A/2);	
				cad_add_vertex(hndDrawing, A/2, 0);
				cad_add_vertex(hndDrawing, A/2, -Emass);
			cad_end_poly(hndDrawing);
			
			// Ausbrennen
			cad_add_circle(hndDrawing, 0, 0, c/2, 254);
			
			cad_begin_poly(hndDrawing, 1, 254);
				cad_add_vertex(hndDrawing, -A/2, -Emass);
				cad_add_vertex2(hndDrawing, -A/2, 0, -A/2);	
				cad_add_vertex(hndDrawing, A/2, 0);
				cad_add_vertex(hndDrawing, A/2, -Emass);
			cad_end_poly(hndDrawing);
			
			retObj.xMassTop = c/2;
			retObj.xMassBottom = A/2;
			retObj.xWidthLeft = A/2;
			retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = A;
			retObj.index = 1;
			retObj.Naht = a;
			retObj.B_Lager = A/2;
		}
		else
		{			
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, -B/2, A/2);
				cad_add_vertex(hndDrawing, -f/2, A/2);
				cad_add_vertex(hndDrawing, -f/2, -(Emass-s)); 
				cad_add_vertex(hndDrawing, f/2, -(Emass-s));
				cad_add_vertex(hndDrawing, f/2, A/2);
				cad_add_vertex(hndDrawing, B/2, A/2);
				cad_add_vertex(hndDrawing, B/2, -Emass);
				cad_add_vertex(hndDrawing, -B/2, -Emass);
			cad_end_poly(hndDrawing);
			
			//Querstange
			cad_add_rect(hndDrawing, -L/2, -c/2, -B/2, c/2, 7);
			cad_add_rect(hndDrawing, -f/2, -c/2, f/2, c/2, 7);
			cad_add_rect(hndDrawing, B/2, -c/2, L/2, c/2, 7);
			
			// Ausbrennen
			cad_add_rect(hndDrawing, -f/2, -c/2, f/2, c/2, 254);
			
			retObj.xMassTop = L/2;
			retObj.xMassBottom = B/2;
			retObj.xWidthLeft = L/2;
			retObj.xWidthRight = L/2;
			retObj.xDist = B/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = B;
			retObj.index = 0;
			retObj.Naht = a;
			retObj.B_Lager = B/2;
		}
 }, 

insertMSN2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	//Wechsellastschelle
{
		var dA = double(threeDparams["Rohraussendurchmesser"]);	// Dmr Rohr
		var J = double(threeDparams["Daemmdicke"]);				// Daemmdicke
		var d = cad_getdouble ("D_");							// Dmr RSB
		var t = cad_getdouble ("T");							// Dicke Kopfplatte
		var h = cad_getdouble ("H");							// Gesamthoehe Traeger
		var h1 = cad_getdouble ("H1");							// seitliche Hoehe Traeger
		var A = cad_getdouble ("A");							// Breite Traeger unten
		var B = cad_getdouble ("B");							// Laenge Joch
		var b = cad_getdouble ("B_");							// Breite Joch
		var h3 = cad_getdouble ("H3");							// Hoehe Joch
		var G = cad_getdouble ("G");							// Abstand Joch-Joch aussen
		var f = cad_getdouble ("F");							// Breite Kopfplatte
		var g = cad_getdouble ("G_");							// Laenge Kopfplatte
		var Ausf = cad_getdouble ("AUSFUEHRUNG");				// Anzahl der Buegel
		var C = cad_getdouble ("C");							// Abstand der aeusseren Buegel
		var alpha = acosdeg((Emass-t-h)/(dA/2));
		
		var rohr = Options["IDC_ROHR"];
		var daemm = Options["IDC_DAEMMUNG"];
		
		var colRohr = 5;										// blau
		var colDaemm = 5;										// blau
		var colLine = 1;										// rot
		
		if ((Rotation == 0) || (Rotation ==180))
		{
			if (Ausf != 1)
			{
				cad_add_rect (hndDrawing, (-dA/2-d), (-t-h), -A/2, (-t-h+h1), 7);
				cad_add_rect (hndDrawing, (-dA/2-d/2-b/2), (-t-h+h1), (-dA/2-d/2+b/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, -f/2, 0, f/2, -t, 7);
				cad_add_rect (hndDrawing, (dA/2+d/2+b/2), (-t-h+h1), (dA/2+d/2-b/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, (dA/2+d), (-t-h), A/2, (-t-h+h1), 7);
				cad_add_rect (hndDrawing, (-dA/2-d), (-t-h+h1+h3), -dA/2, (-t-h+h1+3.5*h3), 7);
				cad_add_rect (hndDrawing, (dA/2+d), (-t-h+h1+h3), dA/2, (-t-h+h1+3.5*h3), 7);
				cad_add_line (hndDrawing, (-dA/2-d), (-t-h+h1), (-dA/2-d), -Emass, 7);
				cad_add_line (hndDrawing, -dA/2, (-t-h+h1), -dA/2, -Emass, 7);
				cad_add_line  (hndDrawing, (dA/2+d), (-t-h+h1), (dA/2+d), -Emass, 7);
				cad_add_line  (hndDrawing, dA/2, (-t-h+h1), dA/2, -Emass, 7);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, 7);
				cad_add_arc (hndDrawing, 0, -Emass, (dA/2+d), 180, 0, 7);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, (90-alpha), (90+alpha), 7);
				cad_add_line (hndDrawing, (-dA/2*sindeg(alpha)), (-t-h), -dA/2, (-t-h), 7);
				cad_add_line (hndDrawing, (dA/2*sindeg(alpha)), (-t-h), dA/2, (-t-h), 7);
				cad_add_line (hndDrawing, (-dA/2-d/2+b/2), (-t-h+h1+h3), (-f/2+f/10), -t, 7);
				cad_add_line (hndDrawing, (dA/2+d/2-b/2), (-t-h+h1+h3), (f/2-f/10), -t, 7);
			}
			else
			{
				cad_add_line (hndDrawing, (-dA/2-d/2-b/2), (-t-h+h1), -A/2, (-t-h+h1), 7);
				cad_add_line (hndDrawing, -A/2, (-t-h+h1), -A/2, (-t-h), 7);
				cad_add_rect (hndDrawing, (-dA/2-d/2-b/2), (-t-h+h1), (-dA/2-d/2+b/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, -f/2, 0, f/2, -t, 7);
				cad_add_rect (hndDrawing, (dA/2+d/2+b/2), (-t-h+h1), (dA/2+d/2-b/2), (-t-h+h1+h3), 7);
				cad_add_line (hndDrawing, (dA/2+d/2+b/2), (-t-h+h1), A/2, (-t-h+h1), 7);
				cad_add_line (hndDrawing, A/2, (-t-h+h1), A/2, (-t-h), 7);
				cad_add_rect (hndDrawing, (-dA/2-d), (-t-h+h1+h3), -dA/2, (-t-h+h1+3.5*h3), 7);
				cad_add_rect (hndDrawing, (dA/2+d), (-t-h+h1+h3), dA/2, (-t-h+h1+3.5*h3), 7);
				cad_add_line (hndDrawing, (-dA/2-d), (-t-h), (-dA/2-d), -Emass, 7);
				cad_add_line (hndDrawing, -dA/2, (-t-h), -dA/2, -Emass, 7);
				cad_add_line  (hndDrawing, (dA/2+d), (-t-h), (dA/2+d), -Emass, 7);
				cad_add_line  (hndDrawing, dA/2, (-t-h), dA/2, -Emass, 7);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, 7);
				cad_add_arc (hndDrawing, 0, -Emass, (dA/2+d), 180, 0, 7);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, (90-alpha), (90+alpha), 7);
				cad_add_line (hndDrawing, (-dA/2*sindeg(alpha)), (-t-h), -A/2, (-t-h), 7);
				cad_add_line (hndDrawing, (dA/2*sindeg(alpha)), (-t-h), A/2, (-t-h), 7);
				cad_add_line (hndDrawing, (-dA/2-d/2+b/2), (-t-h+h1+h3), (-f/2+f/10), -t, 7);
				cad_add_line (hndDrawing, (dA/2+d/2-b/2), (-t-h+h1+h3), (f/2-f/10), -t, 7);
			}
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_circle (hndDrawing, 0, -Emass, dA/2, colRohr);		
				cad_add_arc (hndDrawing, dA/4, -Emass, dA/4, 0, 180, colRohr);
				cad_add_arc (hndDrawing, -dA/4, -Emass, dA/4, 180, 0, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_circle(hndDrawing, 0, -Emass, dA/2 + J , colDaemm);
			}
			// Mittellinie
			cad_add_line (hndDrawing, -dA/2, -Emass, dA/2, -Emass, colLine);
			cad_add_line (hndDrawing, 0, -Emass-dA/2, 0, -Emass+dA/2, colLine);
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = (dA/2+d);
			retObj.xWidthLeft = A/2;
			retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
			retObj.yDist = (-Emass+h);
			retObj.L_PosNr = f/2;
		}
		else
		{
			cad_add_rect (hndDrawing, -g/2, 0, g/2, -t, 7);
			cad_add_rect (hndDrawing, -G/2, -t, (-G/2+t), (-t-h+h1+h3), 7);
			cad_add_rect (hndDrawing, G/2, -t, (G/2-t), (-t-h+h1+h3), 7);
			cad_add_rect (hndDrawing, -B/2, (-t-h+h1+h3), B/2, (-t-h+h1), 7);
			cad_add_rect (hndDrawing, -G/2, (-t-h+h1), (-G/2+t), (-t-h), 7);
			cad_add_rect (hndDrawing, G/2, (-t-h+h1), (G/2-t), (-t-h), 7);
			if (Ausf == 1)
			{
				cad_add_rect (hndDrawing, -d/2, (-t-h+h1+3.5*h3), d/2, (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, -d/2, (-t-h+h1), d/2, (-Emass-dA/2-d), 7);
			}
			if (Ausf == 2)
			{
				cad_add_rect (hndDrawing, (-C/2-d/2), (-t-h+h1+3.5*h3), (-C/2+d/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, (C/2+d/2), (-t-h+h1+3.5*h3), (C/2-d/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, (-C/2-d/2), (-t-h+h1), (-C/2+d/2), (-Emass-dA/2-d), 7);
				cad_add_rect (hndDrawing, (C/2+d/2), (-t-h+h1), (C/2-d/2), (-Emass-dA/2-d), 7);
			}
			if (Ausf == 3)
			{
				cad_add_rect (hndDrawing, -d/2, (-t-h+h1+3.5*h3), d/2, (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, (-C/2-d/2), (-t-h+h1+3.5*h3), (-C/2+d/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, (C/2+d/2), (-t-h+h1+3.5*h3), (C/2-d/2), (-t-h+h1+h3), 7);
				cad_add_rect (hndDrawing, -d/2, (-t-h+h1), d/2, (-Emass-dA/2-d), 7);
				cad_add_rect (hndDrawing, (-C/2-d/2), (-t-h+h1), (-C/2+d/2), (-Emass-dA/2-d), 7);
				cad_add_rect (hndDrawing, (C/2+d/2), (-t-h+h1), (C/2-d/2), (-Emass-dA/2-d), 7);
			}
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_rect (hndDrawing, -4*G, -Emass-dA/2, 4*G, -Emass+dA/2, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_rect (hndDrawing, -2*G, -Emass-dA/2, 2*G, -Emass-dA/2-J, colRohr);
				cad_add_rect (hndDrawing, -2*G, -Emass+dA/2, 2*G, -Emass+dA/2+J, colRohr);
			}
			// Mittellinien
			cad_add_line (hndDrawing, -4*G, -Emass, 4*G, -Emass, colLine);
			
			retObj.xMassTop = g/2;
			retObj.xMassBottom = (C/2+d/2);
			retObj.xWidthLeft = B/2;
			retObj.xWidthRight = B/2;
			retObj.xDist = B/2;
			retObj.yDist = (-t-h+h1+h3/2);
			retObj.L_PosNr = g/2;
		}
},

insertZZx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// ZZK und ZZF
{
		var LG = threeDparams["Lastgroesse0"];
		if (Typid == "ZZF")
		{
			var strSQLStatement = "select * from ZZF where FS_LGR="+LG+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "ZZF");
			var D = dbgetdouble("ZZF", "D");	// Dmr Rohr
			var s = dbgetdouble("ZZF", "S");	// Plattendicke
			var m = dbgetdouble("ZZF", "M");	// Breite
			var dx = 0;
			//var test = dbgetstring("ZZF", "LGR_FST");
			
			var E_min = cad_getdouble ("E1MIN");
			if (Emass > E_min)
			{
				cad_add_rect(hndDrawing, dx-m/2, -Emass, dx+m/2, -Emass+s, 7);
				cad_add_rect(hndDrawing, dx-D/2, -Emass+s, dx+D/2, -s, 7);
				cad_add_rect(hndDrawing, dx-m/2, -s, dx+m/2, 0, 7);
			}
			else
			{
				cad_add_rect (hndDrawing, dx-m/2, -Emass, dx+m/2, 0, 7);
			}
		}
		else
		{
			var E1MIN = cad_getdouble ("E1MIN");
			var E1MAX = cad_getdouble ("E1MAX");
			var n12 = cad_getdouble ("N12");
			var u12 = cad_getdouble ("U12");
			
			if (Emass < E1MIN)
			{
				var Form = 0;
				var nForm_u = "n01";
				var nForm_o = "n01";
			}
			else if (Emass > E1MAX)
			{
				var Form = 2;
				var nForm_u = "n21";
				var nForm_o = "n21";
			}
			else
			{
				var Form = 1;
				var nForm_u = "n11";
				var nForm_o = "n12";
			}
			
			var strSQLStatement = "select * from ZZK where KS_LGR="+LG+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "ZZK");
			var D   = dbgetdouble("ZZK", "D");				// Dmr Rohr
			var s   = dbgetdouble("ZZK", "S");				// Plattendicke
			var m   = dbgetdouble("ZZK", "LP");				// Breite
			var n_u = dbgetdouble("ZZK", nForm_u);			// Tiefe untere Platte
			var n_o = dbgetdouble("ZZK", nForm_o);			// Tiefe obere Platte
			
			var strSQLStatement = "select * from KST_BMA where LGR="+LG+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "KST");
			var gbx = dbgetdouble("KST", "GBX");			// Abstand Hauptachse zu Gehaeuseaussenkante
			
			var strSQLStatement = "select * from KST_KMA where LGR="+LG+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "KST");
			var t = dbgetdouble("KST", "T");				// Abstand FP-Bohrungen
			var e = dbgetdouble("KST", "E_");				// Abstand Bohrung zu Aussenkante FP
			
			var sN = threeDparams["sN0"];					// Nennweg
			var sVOR = threeDparams["Blockierstellung0"];	// Blockierstellung
			
			var alpha1 = 30-asindeg((sN/2-sVOR)/sN);		// Vorspannwinkel
			var X_real = sN*cosdeg(30-alpha1) + gbx;		// Abstand Mittelachse (Auflage) zu Gehaeuseaussenkante
			
			var intRot = int(Rotation);
			
			switch (intRot)
			{	
				case 0:
					var dx = X_real - t/2 - e;
					
					if (Form != 0)
					{
						cad_add_rect(hndDrawing, dx-m/2, -Emass, dx+m/2, -Emass+s, 7);
						cad_add_rect(hndDrawing, dx-D/2, -Emass+s, dx+D/2, -s, 7);
						cad_add_rect(hndDrawing, dx-m/2, -s, dx+m/2, 0, 7);
					}
					else
					{
					cad_add_rect (hndDrawing, dx-m/2, -Emass, dx+m/2, 0, 7);
					}
					
				break;
				
				case 180:
					
					var dx = -X_real + t/2 + e;
					
					if (Form != 0)
					{
						cad_add_rect(hndDrawing, dx-m/2, -Emass, dx+m/2, -Emass+s, 7);
						cad_add_rect(hndDrawing, dx-D/2, -Emass+s, dx+D/2, -s, 7);
						cad_add_rect(hndDrawing, dx-m/2, -s, dx+m/2, 0, 7);
					}
					else
					{
					cad_add_rect (hndDrawing, dx-m/2, -Emass, dx+m/2, 0, 7);
					}
					
				break;
				
				case 90:
				case 270:
					
					if (Form != 0)
					{
						cad_add_rect(hndDrawing, -n_u/2, -Emass, n_u/2, -Emass+s, 7);
						cad_add_rect(hndDrawing, -D/2, -Emass+s, D/2, -s, 7);
						cad_add_rect(hndDrawing, -n_o/2, -s, n_o/2, 0, 7);
					}
					else
					{
						cad_add_rect (hndDrawing, -n12/2, -Emass, n12/2-u12, 0, 7);
						cad_add_rect (hndDrawing, n12/2, -Emass, -n12/2+u12, 0, 7);
					}
					
				break;
				
			default:
				break;
			}
			
		}
		
		retObj.xMassTop = m/2;
		retObj.xMassBottom = m/2;
		retObj.xWidthLeft = m/2;
        retObj.xWidthRight = m/2;
        retObj.xDist = (D/2 + dx);
		retObj.yDist = -Emass/2;
        retObj.L_PosNr = m/3;
},


 insertLUR2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// Lager Typ LUR
 {
		var H = cad_getdouble ("H");
		var DN = cad_getdouble ("DN");
		var A_Kasten = cad_getdouble("A");			// Kastenbreite
		//var s_Kasten = cad_getdouble("T");			// Kastendicke
		var s_Kasten = cad_getdouble("TF");		// Kastendicke
		var L = cad_getdouble("L");					// Laenge des Lagers
		if (DN < 400)
		{
		var h3 = 30;								// Abstand Kastenoberkante zu Rippe
		}
		else
		{
		var h3 = 35;								// Abstand Kastenoberkante zu Rippe
		}
		var hR = H - s_Kasten - 2*h3;				// Hoehe der Rippe (Naeherung)
		
		// Schellendaten
		if (DN <= 500)	// HZN
		{
			var strSQLStatement = "select * from HZN where NENNWEITE="+DN+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HZN");
			var s_Schelle = dbgetdouble("HZN", "S");	// Schellendicke
			var A_Schelle = dbgetdouble("HZN", "A");	// Schellenbreite
			var c = dbgetdouble("HZN", "Z");			// Abstand Bohrung zu Aussenkante Schelle
			var as = A_Schelle - 2*c;					// Schraubenabstand Schelle
			var f = dbgetdouble("HZN", "B_");			// Abstand der Schellenhaelften
			var ds = dbgetdouble("HZN", "C");			// Dmr Schraube
			var bs = dbgetdouble("HZN", "B");			// Schellenbreite
			
		}
		else			// HZL
		{
			var strSQLStatement = "select * from HZL where NENNWEITE="+DN+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HZL");
			var s_Schelle = dbgetdouble("HZL", "S");	// Schellendicke
			var A_Schelle = dbgetdouble("HZL", "A");	// Schellenbreite
			var c = dbgetdouble("HZL", "Z");			// Abstand Bohrung zu Aussenkante Schelle
			var as = A_Schelle - 2*c;					// Schraubenabstand Schelle
			var f = dbgetdouble("HZL", "B_");			// Abstand der Schellenhaelften
			var ds = dbgetdouble("HZL", "C");			// Dmr Schraube
			var bs = dbgetdouble("HZL", "B");			// Schellenbreite
		}
		
		var daemmDicke = config_getdouble("LAGER_BETRIEBSBEDINGUNGEN.IDC_DAEMMDICKE");
		var dA = cad_getdouble ("D");
		var h_Kasten = 0;
		
		var dx = 0;									// Versatz der Schelle in x-Richtung
		var dy = 0;									// Versatz der Schelle in y-Richtung
		
		var a = 0;									// Info SN
		// Linientypen
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// blau
		
		if (cadMacroParamObject.stkListPrevPart == "ZTN")
		{
			if (DN < 400)
			{
				a = 3;
			}
			else
			{
				a = 4;
			}
		}
		
		//h_Kasten = (Emass - (sqrt((dA/2+s_Schelle)^2 - (A_Kasten/2-s_Kasten)^2))); // so gehts nicht
		h_Kasten = (Emass - (sqrt(((dA/2+s_Schelle)*(dA/2+s_Schelle)) - ((A_Kasten/2-s_Kasten)*(A_Kasten/2-s_Kasten)))));
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, -A_Kasten/2, (-Emass + h_Kasten));
				cad_add_vertex (hndDrawing, (-A_Kasten/2 + s_Kasten), (-Emass + h_Kasten));
				cad_add_vertex3 (hndDrawing, (-A_Kasten/2 + s_Kasten), (-Emass + s_Kasten), -s_Kasten);
				cad_add_vertex3 (hndDrawing, (A_Kasten/2 - s_Kasten), (-Emass + s_Kasten), -s_Kasten);
				cad_add_vertex (hndDrawing, (A_Kasten/2 - s_Kasten), (-Emass + h_Kasten));
				cad_add_vertex (hndDrawing, A_Kasten/2, (-Emass + h_Kasten));
				cad_add_vertex3 (hndDrawing, A_Kasten/2, -Emass, (2*s_Kasten));
				cad_add_vertex3 (hndDrawing, -A_Kasten/2, -Emass, (2*s_Kasten));
			cad_end_poly (hndDrawing);
			
			this.add_HZx_H(hndDrawing, (as + 2*c), dA, s_Schelle, f, 180, dx, dy, daemmDicke);		// Schellenhaelfte unten
			this.add_HZx_H(hndDrawing, (as + 2*c), dA, s_Schelle, f, 0, dx, dy, daemmDicke);			// Schellenhaelfte oben
			
			cad_add_rect (hndDrawing, (-as/2 - ds/2), (f/2 + s_Schelle), (-as/2 + ds/2), (f/2 + 2*s_Schelle), 7);
			cad_add_rect (hndDrawing, (-as/2 - ds/2), -f/2, (-as/2 + ds/2), f/2, 7);
			cad_add_rect (hndDrawing, (-as/2 - ds/2), (-f/2 - s_Schelle), (-as/2 + ds/2), (-f/2 - 2.5*s_Schelle), 7);
			cad_add_rect (hndDrawing, (as/2 - ds/2), (f/2 + s_Schelle), (as/2 + ds/2), (f/2 + 2*s_Schelle), 7);
			cad_add_rect (hndDrawing, (as/2 - ds/2), -f/2, (as/2 + ds/2), f/2, 7);
			cad_add_rect (hndDrawing, (as/2 - ds/2), (-f/2 - s_Schelle), (as/2 + ds/2), (-f/2 - 2.5*s_Schelle), 7);
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, dx-A_Schelle/2+c, dy-f/2-2.5*s_Schelle-s_Schelle/2, dx-A_Schelle/2+c, dy+f/2+2*s_Schelle+s_Schelle/2, colMLinie);
			cad_add_line(hndDrawing, dx+A_Schelle/2-c, dy-f/2-2.5*s_Schelle-s_Schelle/2, dx+A_Schelle/2-c, dy+f/2+2*s_Schelle+s_Schelle/2, colMLinie);
			
			cad_add_rect (hndDrawing, (-A_Kasten/2 + s_Kasten), (-Emass + h_Kasten - h3), (A_Kasten/2 - s_Kasten), (-Emass + h_Kasten - h3 - hR), 7);
			
			retObj.xMassTop = A_Schelle/2;
			retObj.xMassBottom = (A_Kasten/2 + s_Kasten);
			retObj.xWidthLeft = A_Schelle/2;
			retObj.xWidthRight = A_Schelle/2;
			retObj.xDist = A_Kasten/2;
			retObj.yDist = (-Emass + h_Kasten/2);
			retObj.L_PosNr = A_Kasten/3;
			retObj.B_Lager = (A_Kasten-4*s_Kasten)/2;
			retObj.Naht = a;
			
		}
		else
		{	// Kasten
			cad_add_rect (hndDrawing, -L/2, -Emass, L/2, (-Emass + h_Kasten), 7);
			
			// Schelle li
			cad_add_rect (hndDrawing, (-L/2 + 10), (-Emass + h_Kasten), (-L/2 + 10 + bs), -f/2, 7);
			cad_add_rect (hndDrawing, (-L/2 + 10), f/2, (-L/2 + 10 + bs), (dA/2 + s_Schelle), 7);
			cad_add_line (hndDrawing, (-L/2 + 10), (-f/2 - s_Schelle), (-L/2 + 10 + bs), (-f/2 - s_Schelle), 7);
			cad_add_line (hndDrawing, (-L/2 + 10), (f/2 + s_Schelle), (-L/2 + 10 + bs), (f/2 + s_Schelle), 7);
			cad_add_rect (hndDrawing, (-L/2 + 10 + bs/2 - ds/2), (f/2 + s_Schelle), (-L/2 + 10 + bs/2 + ds/2), (f/2 + 2*s_Schelle), 7);
			cad_add_rect (hndDrawing, (-L/2 + 10 + bs/2 - ds/2), f/2, (-L/2 + 10 + bs/2 + ds/2), -f/2, 7);
			cad_add_rect (hndDrawing, (-L/2 + 10 + bs/2 - ds/2), (-f/2 - s_Schelle), (-L/2 + 10 + bs/2 + ds/2), (-f/2 - 2.5*s_Schelle), 7);
			
			// Schelle re
			cad_add_rect (hndDrawing, (L/2 - 10), (-Emass + h_Kasten), (L/2 - 10 - bs), -f/2, 7);
			cad_add_rect (hndDrawing, (L/2 - 10), f/2, (L/2 - 10 - bs), (dA/2 + s_Schelle), 7);
			cad_add_line (hndDrawing, (L/2 - 10), (-f/2 - s_Schelle), (L/2 - 10 - bs), (-f/2 - s_Schelle), 7);
			cad_add_line (hndDrawing, (L/2 - 10), (f/2 + s_Schelle), (L/2 - 10 - bs), (f/2 + s_Schelle), 7);
			cad_add_rect (hndDrawing, (L/2 - 10 - bs/2 + ds/2), (f/2 + s_Schelle), (L/2 - 10 - bs/2 - ds/2), (f/2 + 2*s_Schelle), 7);
			cad_add_rect (hndDrawing, (L/2 - 10 - bs/2 + ds/2), f/2, (L/2 - 10 - bs/2 - ds/2), -f/2, 7);
			cad_add_rect (hndDrawing, (L/2 - 10 - bs/2 + ds/2), (-f/2 - s_Schelle), (L/2 - 10 - bs/2 - ds/2), (-f/2 - 2.5*s_Schelle), 7);
			
			// Rohr
			cad_add_rect(hndDrawing, -0.8*L-dA/10, -dA/2, 0.8*L+dA/10, dA/2, colRohr);		
			// Daemmung
			cad_add_rect(hndDrawing, -0.6*L, dA/2, 0.6*L, dA/2+daemmDicke, colDaemm);		
			cad_add_rect(hndDrawing, -0.6*L, -dA/2, 0.6*L, -dA/2-daemmDicke, colDaemm);	
			// Mittellinie fr Schellen  
			cad_add_line(hndDrawing, -0.8*L-dA/10 - s_Schelle/2, dy, 0.8*L+dA/10 + s_Schelle/2, dy, colMLinie);				
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, -L/2 + 10 + bs/2, dy-f/2-2.5*s_Schelle-s_Schelle/2, -L/2 + 10 + bs/2, dy+f/2+2*s_Schelle+s_Schelle/2, colMLinie);
			cad_add_line(hndDrawing, L/2 - 10 - bs/2, dy-f/2-2.5*s_Schelle-s_Schelle/2, L/2 - 10 - bs/2, dy+f/2+2*s_Schelle+s_Schelle/2, colMLinie);
			
			retObj.xMassTop = (L/2 - 10);
			retObj.xMassBottom = L/2;
			retObj.xWidthLeft = 0.8*L+dA/10;
			retObj.xWidthRight = 0.8*L+dA/10;
			retObj.xDist = L/2;
			retObj.yDist = (-Emass + h_Kasten/2);
			retObj.L_PosNr = A_Kasten/3;
			
		}
 },
 
 insertHGx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	// Gripschelle
 {
		var dA = double (threeDparams["Rohraussendurchmesser"]);	// Rohraussendurchmesser
		var ao = cad_getdouble ("AO");			// Tangentenwinkel oben
		var au = cad_getdouble ("AU");			// Tangentenwinkel unten
		var d = cad_getdouble ("D_");			// Dmr RSB
		var c = cad_getdouble ("C");			// Abstand Bohrung Oberkante
		var B = cad_getdouble ("B");			// Breite Halteblech
		var f = cad_getdouble ("F_");			// Drm Aufnahmebohrung
		var sBl = cad_getdouble ("S_");			// Dicke Halteblech
		var sAug = cad_getdouble ("SAUG");		// Dicke des Auges
		var F = cad_getdouble ("F");			// Hoehe RSB ueber Rohrmitte
		var G1 = cad_getdouble ("G1");			// Hoehe RSB unter Rohrmitte
		var G2 = cad_getdouble ("G2");			// Hoehe komplett unter Rohrmitte
		var beta = cad_getdouble ("BETA");		// Winkel Herz
		var h = cad_getdouble ("H");			// Hoehe Herz
		var h1 = cad_getdouble ("H1");			// mittlere Hoehe Herz
		var b1 = cad_getdouble ("B1");			// Hoehe Freimachung Herz
		var r1 = cad_getdouble ("R");			// unterer Radius Herz
		var sT = cad_getdouble ("ST");			// Dicke Herz
		var q = cad_getdouble ("Q");			// Abstand der zwei Herzen
		var E_abs = cad_getdouble ("E_ABS");	// Hoehe Halteblech von Bohrung
		var e1 = cad_getdouble ("E1");			// Abstand innere RSB
		var e2 = cad_getdouble ("E2");			// Abstand aussere RSB
		
		var daemmDicke = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		// Linientypen
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// Daemmung: blau
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			// Koerperkanten
			// RSB
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, (180 - ao), (180 + au), 7);
			cad_add_arc (hndDrawing, 0, -Emass, (dA/2 + d), (180 - ao), (180 + au), 7);
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, -au, ao, 7);
			cad_add_arc (hndDrawing, 0, -Emass, (dA/2 + d), -au, ao, 7);
			
			cad_add_line (hndDrawing, -(dA/2*cosdeg(ao)), (-Emass + (dA/2)*sindeg(ao)), -sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao)), 7);
			cad_add_line (hndDrawing, -((dA/2 + d)*cosdeg(ao)), (-Emass + (dA/2 + d)*sindeg(ao)), -sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + d/sindeg(ao)), 7);
			cad_add_line (hndDrawing, (dA/2*cosdeg(ao)), (-Emass + (dA/2)*sindeg(ao)), sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao)), 7);
			cad_add_line (hndDrawing, ((dA/2 + d)*cosdeg(ao)), (-Emass + (dA/2 + d)*sindeg(ao)), sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + d/sindeg(ao)), 7);
			
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao)));
				cad_add_vertex (hndDrawing, sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)));
				cad_add_vertex (hndDrawing, ((F - ((dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)))*tandeg(ao) + sBl/2), (-Emass + F));
				cad_add_vertex (hndDrawing, ((F - ((dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)))*tandeg(ao) + sBl/2 + d*cosdeg(ao)), (-Emass + F - d*sindeg(ao)));
			cad_end_poly (hndDrawing);
			
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, -sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao)));
				cad_add_vertex (hndDrawing, -sBl/2, (-Emass + (dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)));
				cad_add_vertex (hndDrawing, -((F - ((dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)))*tandeg(ao) + sBl/2), (-Emass + F));
				cad_add_vertex (hndDrawing, -((F - ((dA/2)/sindeg(ao) - (sBl/2)/tandeg(ao) + sBl/tandeg(ao) + d/sindeg(ao)))*tandeg(ao) + sBl/2 + d*cosdeg(ao)), (-Emass + F - d*sindeg(ao)));
			cad_end_poly (hndDrawing);
			
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (-dA/2*cosdeg(au)), (-Emass - dA/2*sindeg(au)));
				cad_add_vertex (hndDrawing, ((G1-(dA/2-d)*sindeg(au))*tandeg(au)-dA/2*cosdeg(au)), (-Emass-G1+d*sindeg(au)));
				cad_add_vertex (hndDrawing, ((G1-(dA/2-d)*sindeg(au))*tandeg(au)-dA/2*cosdeg(au)-d*cosdeg(au)), (-Emass-G1));
				cad_add_vertex (hndDrawing, (-(dA/2 + d)*cosdeg(au)), (-Emass - (dA/2 + d)*sindeg(au)));
			cad_end_poly (hndDrawing);
			
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (dA/2*cosdeg(au)), (-Emass - dA/2*sindeg(au)));
				cad_add_vertex (hndDrawing, -((G1-(dA/2-d)*sindeg(au))*tandeg(au)-dA/2*cosdeg(au)), (-Emass-G1+d*sindeg(au)));
				cad_add_vertex (hndDrawing, -((G1-(dA/2-d)*sindeg(au))*tandeg(au)-dA/2*cosdeg(au)-d*cosdeg(au)), (-Emass-G1));
				cad_add_vertex (hndDrawing, ((dA/2 + d)*cosdeg(au)), (-Emass - (dA/2 + d)*sindeg(au)));
			cad_end_poly (hndDrawing);
			
			// Herz
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, (270 - beta), (270 + beta), 7);
			cad_add_line (hndDrawing, (-dA/2*sindeg(beta)), (-Emass-dA/2*cosdeg(beta)), (-dA/2*sindeg(beta)-d), (-Emass-dA/2*cosdeg(beta)), 7)
			cad_add_line (hndDrawing, (-dA/2*sindeg(beta)-d), (-Emass-dA/2*cosdeg(beta)), -d, (-Emass-dA/2-h), 7);
			cad_add_line (hndDrawing, -d, (-Emass-dA/2-h), d, (-Emass-dA/2-h), 7);
			cad_add_line (hndDrawing, (dA/2*sindeg(beta)), (-Emass-dA/2*cosdeg(beta)), (dA/2*sindeg(beta)+d), (-Emass-dA/2*cosdeg(beta)), 7)
			cad_add_line (hndDrawing, (dA/2*sindeg(beta)+d), (-Emass-dA/2*cosdeg(beta)), d, (-Emass-dA/2-h), 7);
			
			// Lasche
			cad_add_rect (hndDrawing, -sBl/2, (-Emass + dA/2), sBl/2, c, 7);
			cad_add_rect (hndDrawing, (-sBl/2 - sAug), -f, -sBl/2, f, 7);
			cad_add_rect (hndDrawing, (sBl/2 + sAug), -f, sBl/2, f, 7);
			
			// Ausbrennen
			// Lasche
			cad_add_rect (hndDrawing, -sBl/2, (-Emass + dA/2), sBl/2, c, 254);
			cad_add_rect (hndDrawing, (-sBl/2 - sAug), -f, -sBl/2, f, 254);
			cad_add_rect (hndDrawing, (sBl/2 + sAug), -f, sBl/2, f, 254);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, colRohr);		
				cad_add_arc(hndDrawing, 0, -Emass - dA/4, dA/4, 270, 90, colRohr);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 0, 180, colRohr);		
				cad_add_arc(hndDrawing, 0, -Emass + dA/4, dA/4, 90, 270, colRohr);
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke , 180, 0, colDaemm);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke , 0, 180, colDaemm);		
			}
			// Mittellinien fr Schelle
			cad_add_line(hndDrawing, 0, c + d/2, 0, -Emass - G2 - d/2, colMLinie);
			cad_add_line(hndDrawing, -dA/2 - d - d/2, -Emass, dA/2 + d + d/2, -Emass, colMLinie);
			
			retObj.xMassTop = sBl/2;
			retObj.xMassBottom = (dA/2 + d);
			if (daemmDicke > 50) {
				retObj.xWidthLeft = (dA/2 + d) + daemmDicke - 50;
				retObj.xWidthRight = (dA/2 + d) + daemmDicke - 50;
			}	
			else {
				retObj.xWidthLeft = (dA/2 + d);
				retObj.xWidthRight = (dA/2 + d);
			}	
			retObj.xDist = (dA/2 + d);
			retObj.yDist = -Emass;
			retObj.L_PosNr = 2*sBl;
			retObj.index = 2;
		}
		else
		{
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (-e2/2 - d/2), -E_abs);
				cad_add_vertex (hndDrawing, -B/2, -E_abs);
				cad_add_vertex (hndDrawing, -B/2, c);
				cad_add_vertex (hndDrawing, B/2, c);
				cad_add_vertex (hndDrawing, B/2, -E_abs);
				cad_add_vertex (hndDrawing, (e2/2 + d/2), -E_abs);
			cad_end_poly (hndDrawing);
			cad_add_line (hndDrawing, (-e2/2+d/2), -E_abs, (e2/2-d/2), -E_abs, 7);
			cad_add_circle (hndDrawing, 0, 0, f/2, 7);
			if (sAug != 0)
			{
				cad_add_circle (hndDrawing, 0, 0, f, 7);
			}
			cad_add_rect (hndDrawing, (-e2/2-d/2), (-Emass+(dA/2+d/2)/sindeg(ao)), (-e2/2+d/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, (e2/2-d/2), (-Emass+(dA/2+d/2)/sindeg(ao)), (e2/2+d/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, (-e1/2-d/2), (-Emass+dA/2), (-e1/2+d/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, (e1/2-d/2), (-Emass+dA/2), (e1/2+d/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, -B/2, (-Emass-dA/2-h1), B/2, (-Emass-dA/2-h1-b1), 7);
			cad_add_rect (hndDrawing, (-q/2-sT/2), (-Emass-dA/2), (-q/2+sT/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, (q/2-sT/2), (-Emass-dA/2), (q/2+sT/2), (-Emass-dA/2-h1), 7);
			cad_add_rect (hndDrawing, (q/2-sT/2), (-Emass-dA/2-h1-b1), (q/2+sT/2), (-Emass-dA/2-h1-b1-r1), 7)
			cad_add_rect (hndDrawing, (-q/2-sT/2), (-Emass-dA/2-h1-b1), (-q/2+sT/2), (-Emass-dA/2-h1-b1-r1), 7)
			cad_add_circle (hndDrawing, -e1/2, (-Emass-dA/2-h1-b1/2), d/2, 7);
			cad_add_circle (hndDrawing, e1/2, (-Emass-dA/2-h1-b1/2), d/2, 7);
			cad_add_circle (hndDrawing, -e1/2, (-Emass+(dA/2+d/2)/sindeg(ao)), d/2, 7);
			cad_add_circle (hndDrawing, e1/2, (-Emass+(dA/2+d/2)/sindeg(ao)), d/2, 7);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_rect(hndDrawing, -2*B-dA/10, -Emass + dA/2, 2*B+dA/10, -Emass - dA/2, colRohr);		
			}
			// Daemmung
			if (daemmung == "true")
			{
			cad_add_rect(hndDrawing, -1.25*B, -Emass + dA/2, 1.25*B, -Emass + dA/2+daemmDicke, colDaemm);		
			cad_add_rect(hndDrawing, -1.25*B, -Emass-dA/2, 1.25*B, -Emass-dA/2-daemmDicke, colDaemm);	
			}
			// Mittellinie fr Schellen  
			cad_add_line(hndDrawing, -2*B-dA/10 - d/2, -Emass, 2*B+dA/10 + d/2, -Emass, colMLinie);				
	
	
		// Vertikale Mittellinien AN / AUS:
		//cad_add_line (hndDrawing, -e1/2, (-Emass-dA/2-h1-b1/2)-d/2-d/4, -e1/2,  (-Emass+(dA/2+d/2)/sindeg(ao))+d/2+d/4, colMLinie);
		//cad_add_line (hndDrawing, e1/2, (-Emass-dA/2-h1-b1/2)-d/2-d/4, e1/2,  (-Emass+(dA/2+d/2)/sindeg(ao))+d/2+d/4, colMLinie);
			
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, -e1/2-d/2-d/4, (-Emass+(dA/2+d/2)/sindeg(ao)), -e1/2+d/2+d/4, (-Emass+(dA/2+d/2)/sindeg(ao)), colMLinie);
			cad_add_line(hndDrawing, -e1/2, (-Emass+(dA/2+d/2)/sindeg(ao))-d/2-d/4, -e1/2, (-Emass+(dA/2+d/2)/sindeg(ao))+d/2+d/4, colMLinie);
			cad_add_line (hndDrawing, e1/2-d/2-d/4, (-Emass+(dA/2+d/2)/sindeg(ao)), e1/2+d/2+d/4,  (-Emass+(dA/2+d/2)/sindeg(ao)), colMLinie);
			cad_add_line (hndDrawing, e1/2, (-Emass+(dA/2+d/2)/sindeg(ao))-d/2-d/4, e1/2,  (-Emass+(dA/2+d/2)/sindeg(ao))+d/2+d/4, colMLinie);
			cad_add_line(hndDrawing, -e1/2-d/2-d/4, (-Emass-dA/2-h1-b1/2), -e1/2+d/2+d/4, (-Emass-dA/2-h1-b1/2), colMLinie);
			cad_add_line(hndDrawing, -e1/2, (-Emass-dA/2-h1-b1/2)-d/2-d/4, -e1/2, (-Emass-dA/2-h1-b1/2)+d/2+d/4, colMLinie);
			cad_add_line (hndDrawing, e1/2-d/2-d/4, (-Emass-dA/2-h1-b1/2), e1/2+d/2+d/4,  (-Emass-dA/2-h1-b1/2), colMLinie);
			cad_add_line (hndDrawing, e1/2, (-Emass-dA/2-h1-b1/2)-d/2-d/4, e1/2,  (-Emass-dA/2-h1-b1/2)+d/2+d/4, colMLinie);
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = (e2/2 + d/2);
			retObj.xWidthLeft = 2*B+dA/10;
			retObj.xWidthRight = 2*B+dA/10;
			retObj.xDist = B/2;
			retObj.yDist = -E_abs/2;
			retObj.L_PosNr = B/2;
			retObj.index = 0;
			
		}
 },
 
 insertHBx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	// Buegelschelle
 {
		var dA = threeDparams["Rohraussendurchmesser"];		// Rohraussendurchmesser
		var A = cad_getdouble ("A");						// Jochbreite
		var H = cad_getdouble ("H");						// Jochhoehe
		var hJE = cad_getdouble ("HJE");					// seitliche Hoehe vom Joch
		var hJM = cad_getdouble ("HJM");					// mittlere Hoehe vom Joch
		var m = cad_getdouble ("M");						// Jochbreite oben
		var I = cad_getdouble ("I");						// Breite Jochsteg
		var t = cad_getdouble ("T");						// Sickentiefe in Joch
		var E3D = threeDparams["E-Mass0"];					// E-Mass aus 3D
		var b = cad_getdouble ("B_");						// Laschenabstand
		var z = cad_getdouble ("Z");						// Ueberstand
		var sJ = cad_getdouble ("SJ");						// Jochdicke
		var sL = sJ;										// Laschendicke
		var bL = 0;											// Laschenbreite innen
		var B = cad_getdouble ("B");						// Laschenbreite aussen
		var tL = cad_getdouble ("TL");						// Abstand Oberkante Joch zu Beginn Freimachung
		var ktL = cad_getdouble ("KTL");					// seitliche Laschenhoehe
		var c = cad_getdouble ("C");						// Bolzendurchmesser
		var sG = cad_getdouble ("SG");						// Gurtdicke
		var bG = cad_getdouble ("BG");						// Gurtbreite
		var tG = cad_getdouble ("TG");						// Gurtueberstand
		var lG = 0;											// Laenge Gurt (gerade)
		var BK = 0;											// Kopfbreite Gurt
		var dSp = cad_getdouble ("DSP");					// Dmr Schraube
		var RJ = 0;											// Radius Freimachung Joch
		
		var daemmDicke = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		// Linientypen
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// Daemmung: blau
		
		RJ = ((dA/2 + 2*t - (H - hJM)) / (cosdeg(15)));
		bL = (bG - 2*sJ);
		lG = (dA/2 + 2*t - (H - hJM) + hJE + tG - t );
		if ((bL + 2*(sG + sJ + 1)) < 100)
		{
			BK = 100;
		}
		else
		{
			BK = (bL + 2*(sG + sJ + 1));
		}
		
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			// Joch
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (-RJ*sindeg(15)), (-Emass + dA/2 + 2*t - (H - hJM)));
				cad_add_vertex (hndDrawing, -A/2, (-Emass + dA/2 + 2*t - (H - hJM)));
				cad_add_vertex (hndDrawing, -A/2, (-Emass + dA/2 + 2*t - (H - hJM) + hJE));
				cad_add_vertex (hndDrawing, (-A/2 + I), (-Emass + dA/2 + 2*t - (H - hJM) + hJE));
				cad_add_vertex (hndDrawing, -m/2, (-Emass + dA/2 + 2*t + hJM));
				cad_add_vertex (hndDrawing, m/2, (-Emass + dA/2 + 2*t + hJM));
				cad_add_vertex (hndDrawing, (A/2 - I), (-Emass + dA/2 + 2*t - (H - hJM) + hJE));
				cad_add_vertex (hndDrawing, A/2, (-Emass + dA/2 + 2*t - (H - hJM) + hJE));
				cad_add_vertex (hndDrawing, A/2, (-Emass + dA/2 + 2*t - (H - hJM)));
				cad_add_vertex (hndDrawing, RJ*sindeg(15), (-Emass + dA/2 + 2*t - (H - hJM)));
			cad_end_poly (hndDrawing);
			cad_add_arc (hndDrawing, 0, (-E3D), RJ, 75, 105, 7);
			cad_add_circle (hndDrawing, 0, (-Emass + dA/2 + 2*t + hJM - ktL/2), dSp/2, 7);
			
			// Lasche
			cad_add_rect (hndDrawing, (-b/2 - sL), (-Emass + dA/2 + 2*t + hJM), -b/2, z, 7);
			cad_add_rect (hndDrawing, (b/2 + sL), (-Emass + dA/2 + 2*t + hJM), b/2, z, 7);
			cad_add_rect (hndDrawing, (-b/2 - sL), (-Emass + dA/2 + 2*t + hJM - ktL - tL), -b/2, (-Emass + dA/2 + 2*t + hJM - ktL), 7);
			cad_add_rect (hndDrawing, (b/2 + sL), (-Emass + dA/2 + 2*t + hJM - ktL - tL), b/2, (-Emass + dA/2 + 2*t + hJM - ktL), 7);
			
			// Bolzen
			cad_add_rect (hndDrawing, (-b/2 - sL), -c/2, (-b/2 - 2*sL), c/2, 7);
			cad_add_rect (hndDrawing, -b/2, -c/2, b/2, c/2, 7);
			cad_add_rect (hndDrawing, (b/2 + sL), -c/2, (b/2 + 2*sL), c/2, 7);
			
			// Gurt
			cad_add_rect (hndDrawing, -dA/2, (-Emass + dA/2 + 2*t - (H - hJM) + hJE), (-dA/2 - sG), (-Emass + dA/2 + 2*t - (H - hJM) + hJE + (tG - t)), 7);
			cad_add_rect (hndDrawing, dA/2, (-Emass + dA/2 + 2*t - (H - hJM) + hJE), (dA/2 + sG), (-Emass + dA/2 + 2*t - (H - hJM) + hJE + (tG - t)), 7);
			cad_add_line (hndDrawing, -dA/2, (-Emass + dA/2 + 2*t - (H - hJM)), -dA/2, -Emass, 7);
			cad_add_line (hndDrawing, (-dA/2 - sG), (-Emass + dA/2 + 2*t - (H - hJM)), (-dA/2 - sG), -Emass, 7);
			cad_add_line (hndDrawing, dA/2, (-Emass + dA/2 + 2*t - (H - hJM)), dA/2, -Emass, 7);
			cad_add_line (hndDrawing, (dA/2 + sG), (-Emass + dA/2 + 2*t - (H - hJM)), (dA/2 + sG), -Emass, 7);
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, 7);
			cad_add_arc (hndDrawing, 0, -Emass, (dA/2 + sG), 180, 0, 7);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, colRohr);		
				cad_add_arc(hndDrawing, 0, -Emass - dA/4, dA/4, 270, 90, colRohr);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 0, 180, colRohr);		
				cad_add_arc(hndDrawing, 0, -Emass + dA/4, dA/4, 90, 270, colRohr);
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke , 180, 0, colDaemm);
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke , 0, 180, colDaemm);		
			}
			// Mittellinien fr Schelle
			cad_add_line(hndDrawing, 0, c + sG/2, 0, -Emass - dA/2-sG - sG/2, colMLinie);
			cad_add_line(hndDrawing, -dA/2 - sG - sG/2, -Emass, dA/2 + sG + sG/2, -Emass, colMLinie);
			// Mittellinie fr Schraube
			cad_add_line(hndDrawing, -dSp/2 - sG/3, (-Emass + dA/2 + 2*t + hJM - ktL/2), dSp/2 + sG/3, (-Emass + dA/2 + 2*t + hJM - ktL/2), colMLinie);
			
			retObj.xMassTop = (b/2 + sL);
			retObj.xMassBottom = (dA/2 + sG);
			if (daemmDicke > 50) {
				retObj.xWidthLeft = A/2 + daemmDicke - 50;
				retObj.xWidthRight = A/2 + daemmDicke - 50;
			}	
			else {
				retObj.xWidthLeft = A/2;
				retObj.xWidthRight = A/2;
			}	
			retObj.xDist = (dA/2 + sG);
			retObj.yDist = (-Emass + dA/3);
			retObj.L_PosNr = m;
			
		}
		else
		{
			// Lasche
			cad_add_circle (hndDrawing, 0, 0, c/2, 7);
			cad_add_line (hndDrawing, -bL/2, (-Emass + dA/2 + 2*t + hJM), -bL/2, z, 7);
			cad_add_line (hndDrawing, -bL/2, z, bL/2, z, 7);
			cad_add_line (hndDrawing, bL/2, z, bL/2, (-Emass + dA/2 + 2*t + hJM), 7);
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (-bL/2 - sJ), (-Emass + dA/2 + 2*t + hJM - ktL));
				cad_add_vertex (hndDrawing, -B/2, (-Emass + dA/2 + 2*t + hJM - ktL));
				cad_add_vertex (hndDrawing, -B/2, (-Emass + dA/2 + 2*t + hJM - ktL - tL));
				cad_add_vertex (hndDrawing, -BK/2, (-Emass + dA/2 + 2*t + hJM - ktL - tL));
			cad_end_poly (hndDrawing);
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, (bL/2 + sJ), (-Emass + dA/2 + 2*t + hJM - ktL));
				cad_add_vertex (hndDrawing, B/2, (-Emass + dA/2 + 2*t + hJM - ktL));
				cad_add_vertex (hndDrawing, B/2, (-Emass + dA/2 + 2*t + hJM - ktL - tL));
				cad_add_vertex (hndDrawing, BK/2, (-Emass + dA/2 + 2*t + hJM - ktL - tL));
			cad_end_poly (hndDrawing);
			
			cad_add_rect (hndDrawing, -bL/2, z, bL/2, -2*z, 254);
			
			// Gurt
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, -BK/2, (-Emass + lG));
				cad_add_vertex (hndDrawing, -BK/2, (-Emass + lG - tG + t));
				cad_add_vertex (hndDrawing, -bL/2, (-Emass + lG - tG + t));
				cad_add_vertex (hndDrawing, -bL/2, (-Emass + lG - tG + t - hJE - t - 5));
				cad_add_vertex (hndDrawing, -bG/2, (-Emass + lG - tG + t - hJE - t - 5));
				cad_add_vertex (hndDrawing, -bG/2, (-Emass - dA/2 - sG));
				cad_add_vertex (hndDrawing, bG/2, (-Emass - dA/2 - sG));
				cad_add_vertex (hndDrawing, bG/2, (-Emass + lG - tG + t - hJE - t - 5));
				cad_add_vertex (hndDrawing, bL/2, (-Emass + lG - tG + t - hJE - t - 5));
				cad_add_vertex (hndDrawing, bL/2, (-Emass + lG - tG + t));
				cad_add_vertex (hndDrawing, BK/2, (-Emass + lG - tG + t));
				cad_add_vertex (hndDrawing, BK/2, (-Emass + lG));
			cad_end_poly (hndDrawing);
			
			// Joch
			cad_add_rect (hndDrawing, -bL/2, (-Emass + dA/2 + 2*t - (H - hJM)), (-bL/2 - sJ), (-Emass + dA/2 + 2*t - (H - hJM) + hJE), 7);
			cad_add_rect (hndDrawing, bL/2, (-Emass + dA/2 + 2*t - (H - hJM)), (bL/2 + sJ), (-Emass + dA/2 + 2*t - (H - hJM) + hJE), 7);
			cad_add_rect (hndDrawing, -bL/2, (-Emass + dA/2 + 2*t + hJM), (-bL/2 - sJ), (-Emass + dA/2 + 2*t - (H - hJM) + hJE + tG - t), 7);
			cad_add_rect (hndDrawing, bL/2, (-Emass + dA/2 + 2*t + hJM), (bL/2 + sJ), (-Emass + dA/2 + 2*t - (H - hJM) + hJE + tG - t), 7);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_rect(hndDrawing, -2.5*bG-dA/10, -Emass + dA/2, 2.5*bG+dA/10, -Emass - dA/2, colRohr);		
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_add_rect(hndDrawing, -1.5*bG, -Emass + dA/2, 1.5*bG, -Emass + dA/2+daemmDicke, colDaemm);		
				cad_add_rect(hndDrawing, -1.5*bG, -Emass-dA/2, 1.5*bG, -Emass-dA/2-daemmDicke, colDaemm);	
			}
			// Mittellinien  
			cad_add_line(hndDrawing, -2.5*bG-dA/10 - sG/3, -Emass, 2.5*bG+dA/10 + sG/3, -Emass, colMLinie);				
			cad_add_line (hndDrawing, 0, z+sG/3, 0, -Emass-dA/2-sG-sG/3, colMLinie);
			cad_add_line (hndDrawing, -c/2-sG/3, 0, c/2+sG/3, 0, colMLinie);
			
			retObj.xMassTop = c/2;
			retObj.xMassBottom = bG/2;
			retObj.xWidthLeft = 2.5*bG+dA/10;
			retObj.xWidthRight = 2.5*bG+dA/10;
			retObj.xDist = bG/2;
			retObj.yDist = (-Emass + dA/3);
			retObj.L_PosNr = bG;
			retObj.index = 2;
			
		}
 }, 
 
 
 insertHDx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	// Dreilochschelle
 {
		var dA = threeDparams["Rohraussendurchmesser"];		// Rohraussendurchmesser
		var s = cad_getdouble ("S");						// Schellendicke
		var b = cad_getdouble ("B_");						// Schellenzwischenraum
		var B = cad_getdouble ("B");						// Schellenbreite
		var z = cad_getdouble ("Z");						// Ueberstand
		var LGV = selection_getdouble("TOPOCLASS.Schelle.lgv");
		var DN = selection_getdouble("TOPOCLASS.Schelle.nennweite");
		
		if (Typid == "HDN")
		{
			var strSQLStatement = "select * from HDN_MAS where lgv="+LGV+" and abs(DN_MIN)<="+DN+" and abs(DN_MAX)>="+DN+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HDN_MAS");
			var c = dbgetdouble("HDN_MAS", "C");				// Dmr Schraube aussen
		}
		else if (Typid == "HDV")
		{
			var strSQLStatement = "select * from HDV_MAS where lgv="+LGV+" and abs(DN_MIN)<="+DN+" and abs(DN_MAX)>="+DN+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HDV_MAS");
			var c = dbgetdouble("HDV_MAS", "C");				// Dmr Schraube aussen
		}
		else	//(Typid == "HDS")
		{
			var strSQLStatement = "select * from HDS_MAS where lgv="+LGV+" and abs(DN_MIN)<="+DN+" and abs(DN_MAX)>="+DN+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "HDS_MAS");
			var c = dbgetdouble("HDS_MAS", "C");				// Dmr Schraube aussen
		};
		
		var di = cad_getdouble ("DI");						// Dmr Schraube innen
		var ds = cad_getdouble ("DS");						// Abstand obere Schrauben
		
		var A = Emass + 2*z + (Emass - ds);					// Schellenlaenge
		
		var alpha1 = asindeg ((b/2) / (dA/2));				// Beginn des inneren Radius
		var alpha2 = asindeg ((b/2 + s) / (dA/2 + s));		// Beginn des aeusseren Radius
		var l1 = dA/2 * cosdeg (alpha1);					// Abstand Rohrmitte zu Beginn innerer Radius
		var l2 = (dA/2 + s) * cosdeg (alpha2);				// Abstand Rohrmitte zu Beginn aeusserer Radius
		var daemmDicke = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		// Linientypen	
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// Daemmung: blau
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			// Schellenhaelfte li
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, -b/2, (-Emass + l1));
				cad_add_vertex (hndDrawing, -b/2, z);
				cad_add_vertex (hndDrawing, (-b/2 - s), z);
				cad_add_vertex (hndDrawing, (-b/2 - s), (-Emass + l2));
			cad_end_poly (hndDrawing);
			
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, (90 + alpha1), (270 - alpha1), 7);
			cad_add_arc (hndDrawing, 0, -Emass, (dA/2 + s), (90 + alpha2), (270 - alpha2), 7);
			
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, -b/2, (-Emass - l1));
				cad_add_vertex (hndDrawing, -b/2, (-Emass - (Emass - ds) - z));
				cad_add_vertex (hndDrawing, (-b/2 - s), (-Emass - (Emass - ds) - z));
				cad_add_vertex (hndDrawing, (-b/2 - s), (-Emass - l2));
			cad_end_poly (hndDrawing);
			
			// Schellenhaelfte re
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, b/2, (-Emass + l1));
				cad_add_vertex (hndDrawing, b/2, z);
				cad_add_vertex (hndDrawing, (b/2 + s), z);
				cad_add_vertex (hndDrawing, (b/2 + s), (-Emass + l2));
			cad_end_poly (hndDrawing);
			
			cad_add_arc (hndDrawing, 0, -Emass, dA/2, (270 + alpha1), (90 - alpha1), 7);
			cad_add_arc (hndDrawing, 0, -Emass, (dA/2 + s), (270 + alpha2), (90 - alpha2), 7);
			
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, b/2, (-Emass - l1));
				cad_add_vertex (hndDrawing, b/2, (-Emass - (Emass - ds) - z));
				cad_add_vertex (hndDrawing, (b/2 + s), (-Emass - (Emass - ds) - z));
				cad_add_vertex (hndDrawing, (b/2 + s), (-Emass - l2));
			cad_end_poly (hndDrawing);
			
			//Schrauben schematisch
			cad_add_rect (hndDrawing, (-b/2 - 2*s), -c/2, (-b/2 - s), c/2, 7); 
			cad_add_rect (hndDrawing, -b/2, -c/2, b/2, c/2, 7);
			cad_add_rect (hndDrawing, (b/2 + s), c/2, (b/2 + 2.5*s), -c/2, 7);
			
			cad_add_rect (hndDrawing, (-b/2 - 2*s), (-di/2 - ds), (-b/2 - s), (di/2 - ds), 7); 
			cad_add_rect (hndDrawing, -b/2, (-di/2 - ds), b/2, (di/2 - ds), 7);
			cad_add_rect (hndDrawing, (b/2 + s), (di/2 - ds), (b/2 + 2.5*s), (-di/2 - ds), 7);
			
			cad_add_rect (hndDrawing, (-b/2 - 2*s), (-di/2 - ds - 2*(Emass - ds)), (-b/2 - s), (di/2 - ds - 2*(Emass - ds)), 7); 
			cad_add_rect (hndDrawing, -b/2, (-di/2 - ds - 2*(Emass - ds)), b/2, (di/2 - ds - 2*(Emass - ds)), 7);
			cad_add_rect (hndDrawing, (b/2 + s), (di/2 - ds - 2*(Emass - ds)), (b/2 + 2.5*s), (-di/2 - ds - 2*(Emass - ds)), 7);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 0, 180, colRohr);		
				cad_add_arc (hndDrawing, 0, -Emass, dA/2, 180, 0, colRohr);		
				cad_add_arc(hndDrawing, 0,  - Emass - dA/4, dA/4, 270, 90, colRohr);
				cad_add_arc(hndDrawing, 0, -Emass + dA/4, dA/4, 90, 270, colRohr);
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke, 180, 0, colDaemm);	
				cad_add_arc (hndDrawing, 0, -Emass, dA/2 + daemmDicke, 0, 180, colDaemm);		
			}
			// Mittellinien fr Schellen
			cad_add_line(hndDrawing, -dA/2-s-s/2, -Emass, dA/2+s+s/2, -Emass, colMLinie);
			cad_add_line(hndDrawing, 0, z+s/2, 0, z-A-s/2, colMLinie);
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, -b/2 - 2*s - s/2, 0, b/2 + 2.5*s + s/2, 0, colMLinie);
			cad_add_line(hndDrawing, -b/2 - 2*s - s/2, -ds, b/2 + 2.5*s + s/2, -ds, colMLinie);
			cad_add_line(hndDrawing, -b/2 - 2*s - s/2, - ds - 2*(Emass - ds), b/2 + 2.5*s + s/2, - ds - 2*(Emass - ds), colMLinie);
			
			retObj.xMassTop = (b/2 + s);
			retObj.xMassBottom = (dA/2 + s);
			retObj.xWidthLeft = (dA/2 + s);
			retObj.xWidthRight = (dA/2 + s);
			retObj.xDist = (b/2 + s);
			retObj.yDist = (-ds/2);
			retObj.L_PosNr = (b + 2*s);
			
		}
		else
		{
			// Seitenansicht
			cad_add_rect (hndDrawing, -B/2, z, B/2, (-A + z), 7);	// Koerperkanten
			cad_add_rect (hndDrawing, -B/2, z, B/2, (-A + z), 254);	// Ausbrennen
			cad_add_line (hndDrawing, (-0.4*B), (-Emass + dA/2), (0.4*B), (-Emass + dA/2),7);
			cad_add_line (hndDrawing, (-0.4*B), (-Emass - dA/2), (0.4*B), (-Emass - dA/2),7);
			cad_add_circle (hndDrawing, 0, 0, c/2, 7);
			cad_add_circle (hndDrawing, 0, -ds, di/2, 7);
			cad_add_circle (hndDrawing, 0, (-A + 2*z), di/2, 7);
			
			// Rohr
			if (rohr == "true")
			{
				cad_add_rect(hndDrawing, -4*B, -Emass-dA/2, 4*B, -Emass+dA/2, colRohr);
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_add_rect(hndDrawing, -2*B, -Emass+dA/2, 2*B, -Emass+dA/2+daemmDicke, colDaemm);		
				cad_add_rect(hndDrawing, -2*B, -Emass-dA/2, 2*B, -Emass-dA/2-daemmDicke, colDaemm);	
			}
			//Mittellinie fr Schellen  
			cad_add_line(hndDrawing, -4*B-s/2, -Emass, 4*B+s/2, -Emass, colMLinie);				
			cad_add_line(hndDrawing, 0, z+s/2, 0, z-A-s/2, colMLinie);
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, -c/2-s/2, 0, c/2+s/2, 0, colMLinie);
			cad_add_line(hndDrawing, -di/2-s/2, -ds, di/2+s/2, -ds, colMLinie);
			cad_add_line(hndDrawing, -di/2-s/2, - ds - 2*(Emass - ds), di/2+s/2, - ds - 2*(Emass - ds), colMLinie);
			
			retObj.xMassTop = c/2;
			retObj.xMassBottom = B/2;
			retObj.xWidthLeft = 4*B;
			retObj.xWidthRight = 4*B;
			retObj.xDist = B/2;
			retObj.yDist = (-ds/2);
			retObj.L_PosNr = B/2;
			retObj.index = 2;
			
		}
 },
 
 
 insertHZx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options)	// Zweilochschelle
 {
		var dA = double(threeDparams["Rohraussendurchmesser"]);	// Rohraussendurchmesser
		var s = cad_getdouble ("S");							// Schellendicke
		var b = cad_getdouble ("B_");							// Schellenzwischenraum
		var B = cad_getdouble ("B");							// Schellenbreite
		var z = cad_getdouble ("Z");							// Ueberstand
		var c = cad_getdouble ("C");							// Dmr Schraube
		var dx = 0;												// x-Versatz der Schelle
		var dy = 0;												// y-Versatz der Schelle
		var RWinkel = 0;										// Default (Einzelschelle)
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		var A = 0;												// Schellenlaenge
		
		var daemmDicke = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");
		var J = double(threeDparams["Daemmdicke"]);				// Daemmdicke
		
		// Linientypen
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// Daemmung: blau
		
		if (cadMacroParamObject.stkListPrevPart != "")
		{
			RWinkel = double(threeDparams["Rohrwinkel"]);		// Winkel des Rohrs aus 3D
		}
		
		if (RWinkel != 0)
		{
		var r1 = 0;
		if (floor (dA) + 1 - dA == 1)
		{
		r1 = dA/2;
		}
		else
		{
		r1 = (floor (dA) + 1) / 2;
		}
		A = (1.8*c+2*sqrt((r1+2.5*s)*(r1+2.5*s)-(2.5*s+b/2)*(2.5*s+b/2))+s)+2*z;
		Emass = (A-2*z)/2;
		}
		else
		{
		A = 2*Emass + 2*z;
		}
		
		dy = -Emass;
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			this.add_HZx_H(hndDrawing, A, dA, s, b, 90, dx, dy, J, rohr, daemmung);			// Schellenhaelfte re
			this.add_HZx_H(hndDrawing, A, dA, s, b, 270, dx, dy, J, rohr, daemmung);		// Schellenhaelfte li
			
			cad_add_rect (hndDrawing, (b/2 + s + 1.5*b + dx), (A/2 - z + c/2 + dy), (b/2 + s + dx), (A/2 - z - c/2 + dy), 7);	// Schraube oben
			cad_add_rect (hndDrawing, (b/2 + dx), (A/2 - z + c/2 + dy), (-b/2 + dx), (A/2 - z - c/2 + dy), 7);
			cad_add_rect (hndDrawing, -(b/2 + s + b) + dx, (A/2 - z + c/2 + dy), -(b/2 + s) + dx, (A/2 - z - c/2 + dy), 7);
			
			// Ausbrennen
			cad_add_rect (hndDrawing, (b/2 + dx), (A/2 - z + c/2 + dy), (-b/2 + dx), (A/2 - z - c/2 + dy), 7);
			
			cad_add_rect (hndDrawing, (b/2 + s + 1.5*b + dx), -(A/2 - z + c/2) + dy, (b/2 + s + dx), -(A/2 - z - c/2) + dy, 7);	// Schraube unten
			cad_add_rect (hndDrawing, (b/2 + dx), -(A/2 - z + c/2) + dy, (-b/2 + dx), -(A/2 - z - c/2) + dy, 7);
			cad_add_rect (hndDrawing, -(b/2 + s + b) + dx, -(A/2 - z + c/2) + dy, -(b/2 + s) + dx, -(A/2 - z - c/2) + dy, 7);
			
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, dx-b-s-b/2-s/2, dy+A/2-z, dx+b/2 + s + 1.5*b+s/2, dy+A/2-z, colMLinie);
			cad_add_line(hndDrawing, dx-b-s-b/2-s/2, dy-A/2+z, dx+b/2 + s + 1.5*b+s/2, dy-A/2+z, colMLinie);
			
			retObj.xMassTop = (b/2 + s);
			retObj.xMassBottom = (dA/2 + s);
			
			if (daemmDicke > 50) {
				retObj.xWidthLeft = (dA/2 + s) + daemmDicke - 50;
				retObj.xWidthRight = (dA/2 + s) + daemmDicke - 50;
			}	
			else {
				retObj.xWidthLeft = (dA/2 + s);
				retObj.xWidthRight = (dA/2 + s);
			}	
			retObj.xDist = (b/2 + s);
			retObj.yDist = -1.5*c;
			retObj.L_PosNr = (b + 2*s);
			retObj.index = 0;
			
		}
		else	// Seitenansicht (90 und 270)
		{
		
			if (Rotation == 270){
				var dir = -1;			// direction bei schrgem Rohrverlauf
			} else {
				var dir = 1;
			}		
			// Koerperkanten
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, (dir*(-B/2*cosdeg(RWinkel)+z*sindeg(RWinkel))), (B/2*sindeg(RWinkel)+z*cosdeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((B/2*cosdeg(RWinkel)+z*sindeg(RWinkel))), (-B/2*sindeg(RWinkel)+z*cosdeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((-2*Emass*sindeg(RWinkel)+B/2*cosdeg(RWinkel)-z*sindeg(RWinkel))), (-2*Emass*cosdeg(RWinkel)-z*cosdeg(RWinkel)-B/2*sindeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((-2*Emass*sindeg(RWinkel)-B/2*cosdeg(RWinkel)-z*sindeg(RWinkel))), (-2*Emass*cosdeg(RWinkel)-z*cosdeg(RWinkel)+B/2*sindeg(RWinkel)));
			cad_end_poly (hndDrawing);
			cad_add_circle (hndDrawing, 0, 0, c/2, 7);
			cad_add_circle (hndDrawing, dir*(-2*Emass*sindeg(RWinkel)), -2*Emass*cosdeg(RWinkel), c/2, 7);
			cad_add_line (hndDrawing, dir*((-z*sindeg(RWinkel)-(B/2-B/10)*cosdeg(RWinkel))), (-z*cosdeg(RWinkel)+(B/2-B/10)*sindeg(RWinkel)), dir*((-z*sindeg(RWinkel)+(B/2-B/10)*cosdeg(RWinkel))), (-z*cosdeg(RWinkel)-(B/2-B/10)*sindeg(RWinkel)), 7);
			cad_add_line (hndDrawing, dir*((-2*Emass*sindeg(RWinkel)-(-z*sindeg(RWinkel)+(B/2-B/10)*cosdeg(RWinkel)))), (-2*Emass*cosdeg(RWinkel)-(-z*cosdeg(RWinkel)-(B/2-B/10)*sindeg(RWinkel))), dir*((-2*Emass*sindeg(RWinkel)+(z*sindeg(RWinkel)+(B/2-B/10)*cosdeg(RWinkel)))), (-2*Emass*cosdeg(RWinkel)+(z*cosdeg(RWinkel)-(B/2-B/10)*sindeg(RWinkel))), 7);
			
			// Ausbrennen
			cad_begin_poly (hndDrawing, 1, 254);
				cad_add_vertex (hndDrawing, dir*((-B/2*cosdeg(RWinkel)+z*sindeg(RWinkel))), (B/2*sindeg(RWinkel)+z*cosdeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((B/2*cosdeg(RWinkel)+z*sindeg(RWinkel))), (-B/2*sindeg(RWinkel)+z*cosdeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((-2*Emass*sindeg(RWinkel)+B/2*cosdeg(RWinkel)-z*sindeg(RWinkel))), (-2*Emass*cosdeg(RWinkel)-z*cosdeg(RWinkel)-B/2*sindeg(RWinkel)));
				cad_add_vertex (hndDrawing, dir*((-2*Emass*sindeg(RWinkel)-B/2*cosdeg(RWinkel)-z*sindeg(RWinkel))), (-2*Emass*cosdeg(RWinkel)-z*cosdeg(RWinkel)+B/2*sindeg(RWinkel)));
			cad_end_poly (hndDrawing);
	
			var MPx = dx-sindeg(RWinkel)*(A/2-z);
			var MPy = dy+Emass - cosdeg(RWinkel)*(A/2-z);
			// Rohr
			if (rohr == "true")
			{
				cad_begin_poly(hndDrawing, 1, colRohr);
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2) - cosdeg(RWinkel)*(4*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2) + sindeg(RWinkel)*(4*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2) - cosdeg(RWinkel)*(4*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2) + sindeg(RWinkel)*(4*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2) + cosdeg(RWinkel)*(4*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2) - sindeg(RWinkel)*(4*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2) + cosdeg(RWinkel)*(4*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2) - sindeg(RWinkel)*(4*B));
				cad_end_poly(hndDrawing);
			}
			// Daemmung
			if (daemmung == "true")
			{
				cad_begin_poly(hndDrawing, 1, colDaemm);
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2) - cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2) + sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2+daemmDicke) - cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2+daemmDicke) + sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2+daemmDicke) + cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2+daemmDicke) - sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z+dA/2) + cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z+dA/2) - sindeg(RWinkel)*(2*B));
				cad_end_poly(hndDrawing);
				cad_begin_poly(hndDrawing, 1, colDaemm);
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2) - cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2) + sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2-daemmDicke) - cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2-daemmDicke) + sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2-daemmDicke) + cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2-daemmDicke) - sindeg(RWinkel)*(2*B));
					cad_add_vertex(hndDrawing, dir*(dx-sindeg(RWinkel)*(A/2-z-dA/2) + cosdeg(RWinkel)*(2*B)), dy+Emass-cosdeg(RWinkel)*(A/2-z-dA/2) - sindeg(RWinkel)*(2*B));
				cad_end_poly(hndDrawing);
			}
			//Mittellinie fr Schellen  
			cad_add_line(hndDrawing, dir*(MPx - cosdeg(RWinkel)*(4*B+s/2)), MPy + sindeg(RWinkel)*(4*B+s/2), dir*(MPx + cosdeg(RWinkel)*(4*B+s/2)), MPy - sindeg(RWinkel)*(4*B+s/2), colMLinie);
			cad_add_line(hndDrawing, dir*(dx+sindeg(RWinkel)*(z+s/2)), dy+Emass+cosdeg(RWinkel)*(z+s/2), dir*(dx-sindeg(RWinkel)*(A-z+s/2)), dy+Emass-cosdeg(RWinkel)*(A-z+s/2), colMLinie);
			// Mittellinien fr Schrauben
			cad_add_line(hndDrawing, dir*(dx-cosdeg(RWinkel)*(c/2+s/2)), dy+Emass+sindeg(RWinkel)*(c/2+s/2), dir*(dx+cosdeg(RWinkel)*(c/2+s/2)), dy+Emass-sindeg(RWinkel)*(c/2+s/2), colMLinie);
			cad_add_line(hndDrawing, dir*(dx-sindeg(RWinkel)*(2*Emass) - cosdeg(RWinkel)*(c/2+s/2)), dy+Emass - cosdeg(RWinkel)*(2*Emass) + sindeg(RWinkel)*(c/2+s/2), dir*(dx-sindeg(RWinkel)*(2*Emass) + cosdeg(RWinkel)*(c/2+s/2)), dy+Emass - cosdeg(RWinkel)*(2*Emass) - sindeg(RWinkel)*(c/2+s/2), colMLinie);
			var eMass_bottom_dist =  dir*(dx + sindeg(RWinkel)*(Emass*cosdeg(RWinkel)) + B/2);		// unterer Abstand der Emass-Linientypen
			var xRohr1L = dir*((dx-sindeg(RWinkel)*(A/2-z-dA/2) - cosdeg(RWinkel)*(4*B)));
			var xRohr2L = dir*((dx-sindeg(RWinkel)*(A/2-z+dA/2) - cosdeg(RWinkel)*(4*B)));
			var xRohr1R = dir*((dx-sindeg(RWinkel)*(A/2-z+dA/2) + cosdeg(RWinkel)*(4*B)));
			var xRohr2R = dir*((dx-sindeg(RWinkel)*(A/2-z-dA/2) + cosdeg(RWinkel)*(4*B)));
			
			retObj.xMassTop = c/2;
			retObj.xMassBottom = 0;
			//retObj.xMassBottom = eMass_bottom_dist;
			retObj.xWidthLeft = abs(min(xRohr1L, xRohr2L));			//	retObj.xWidthLeft = 4*B;
			retObj.xWidthRight = abs(max(xRohr1R, xRohr2R)); 		//	retObj.xWidthRight = 4*B;
			retObj.xDist = B/2-(dir*z*sindeg(RWinkel));
			retObj.yDist = -1.5*c;
			retObj.L_PosNr = B/2;
			retObj.index = 2;
			
		}
 },
  
  
 insertVPR2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)		// Kastenschelle VPR
 {
		var L = cad_getdouble ("SPANN");												// Spannweite
		var H = cad_getdouble ("H");													// Schellenhoehe
		var ha = cad_getdouble ("HA");													// seitliche Hoehe Seitenteil
		var d = cad_getdouble ("D_");													// Drm Bohrung
		var z = cad_getdouble ("Z");													// Ueberstand
		var k = cad_getdouble ("K");													// Seitenteil untere Breite
		var f = cad_getdouble ("F");													// Breite Gleitauflage
		var d_Rohr_string = cad_getstring("D_ROHR");
		var d_Rohr_double = cad_getdouble("D_ROHR");
		var J = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");	// Daemmdicke
		var dA = threeDparams["Rohraussendurchmesser"];									// Rohraussendurchmesser
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		var TH = Options.textheight;													// Texthoehe der Bemassung
		
		/*var strSQLStatement = "select * from ROHRD where abs(Bohr_VxR)="+d+" ";
		var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
		var d_Rohr_string = dbgetstring("ROHRD", "D");
		var d_Rohr_double = dbgetdouble("ROHRD", "D");
		*/
		
		var Text = cad_getstring ("D_") + "/" + d_Rohr_string;
		
		cad_begin_poly (hndDrawing, 1, 7);	// Aussenkontur
			cad_add_vertex (hndDrawing, (-L/2 - z), (-Emass + 3));
			cad_add_vertex (hndDrawing, (-L/2 - z), (-Emass + ha + 3));
			cad_add_vertex (hndDrawing, -k/2, (-Emass + 3 + H));
			cad_add_vertex (hndDrawing, k/2, (-Emass + 3 + H));
			cad_add_vertex (hndDrawing, (L/2 + z), (-Emass + 3 + ha));
			cad_add_vertex (hndDrawing, (L/2 + z), -Emass + 3);
		cad_end_poly (hndDrawing);
		cad_add_circle (hndDrawing, 0, 0, d/2, 7);
		
		cad_add_circle (hndDrawing, 0, 0, d_Rohr_double/2, 1);						// Rohr
		cad_add_circle (hndDrawing, 0, 0, (d_Rohr_double-d_Rohr_double/20)/2, 1);	// Rohr
		
		// Angabe Bohrungsdurchmesser und Rohrdurchmesser
		cad_add_circle (hndDrawing, d/2+TH/4+5, 0, TH/4, 4);
		cad_add_line (hndDrawing, d/2+5, -TH/2, d/2+5+TH/2, TH/2, 4);
		cad_add_text (hndDrawing, d/2+6+2*TH/3, -TH/2, 0, TH, Text, 4);
		
		cad_add_rect (hndDrawing, (-L/2 - f/2), -Emass, (-L/2 + f/2), (-Emass + 3), 7);
		cad_add_rect (hndDrawing, (L/2 - f/2), -Emass, (L/2 + f/2), (-Emass + 3), 7);
		
		// Rohr
		if (rohr == "true")
		{
			cad_add_rect (hndDrawing, -dA/2, -1.5*Emass, dA/2, -0.5*Emass+H, 5);
		}
		// Mittellinien
		cad_add_line (hndDrawing, 0, -1.5*Emass, 0, -0.5*Emass+H, 1);
		cad_add_line (hndDrawing, -d/2, 0, d/2, 0, 1);
		// Daemmung
		if (daemmung == "true")
		{
			cad_add_rect (hndDrawing, -dA/2-J, -4/3*Emass, -dA/2, -2/3*Emass+H, 5);
			cad_add_rect (hndDrawing, dA/2+J, -4/3*Emass, dA/2, -2/3*Emass+H, 5);
		}
		
		retObj.xMassTop = d/2;
		retObj.xMassBottom = (L/2 + z);
		retObj.xWidthLeft = (L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = (-Emass + ha/2);
		retObj.L_PosNr = z/2;
		retObj.yWidthBottom = (H - Emass);
		
 },
 
 
 insertVSR_VGR_2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options)	// Kastenschelle VSR oder VGR
 {
		var L = cad_getdouble ("SPANN");												// Spannweite
		var H = cad_getdouble ("H");													// Schellenhoehe
		var ha = cad_getdouble ("HA");													// seitliche Hoehe Seitenteil
		var d = cad_getdouble ("D_");													// Drm Bohrung
		var z = cad_getdouble ("Z");													// Ueberstand
		var k = cad_getdouble ("K");													// Seitenteil untere Breite
		var f = cad_getdouble ("F");													// Breite Gleitauflage
		var d_Rohr_string = ("D_Rohr");
		var d_Rohr_double = ("D_Rohr");
		
		var J = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");	// Daemmdicke
		var dA = threeDparams["Rohraussendurchmesser"];									// Rohraussendurchmesser
		
		var rohr = Options["IDC_ROHR"];													// Rohr an/aus
		var daemmung = Options["IDC_DAEMMUNG"];											// Daemmung an/aus
		
		var TH = Options.textheight;													// Texthoehe der Bemassung
		
		/*var strSQLStatement = "select * from ROHRD where abs(Bohr_VxR)="+d+" ";
		var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
		var d_Rohr_string = dbgetstring("ROHRD", "D");
		var d_Rohr_double = dbgetdouble("ROHRD", "D");
		*/
		
		var Text = cad_getstring ("D_") + "/" + d_Rohr_string;
		
		cad_begin_poly (hndDrawing, 1, 7);							// Aussenkontur
			cad_add_vertex (hndDrawing, (-L/2 - z), -Emass);
			cad_add_vertex (hndDrawing, (-L/2 - z), (-Emass + ha));
			cad_add_vertex (hndDrawing, -k/2, (-Emass + H));
			cad_add_vertex (hndDrawing, k/2, (-Emass + H));
			cad_add_vertex (hndDrawing, (L/2 + z), (-Emass + ha));
			cad_add_vertex (hndDrawing, (L/2 + z), -Emass);
		cad_end_poly (hndDrawing);
		
		cad_add_circle (hndDrawing, 0, 0, d/2, 7);									// Bohrung
		cad_add_circle (hndDrawing, 0, 0, d_Rohr_double/2, 1);						// Rohr
		cad_add_circle (hndDrawing, 0, 0, (d_Rohr_double-d_Rohr_double/20)/2, 1);	// Rohr
		
		// Angabe Bohrungsdurchmesser und Rohrdurchmesser
		if (Typid == "VSR")
			var dreh	= 0;
		else
			var dreh	= 180;
		if (Typid == "VSR")
			var dir		= 1;
		else
			var dir		= -1;
		cad_add_circle (hndDrawing, dir*(d/2+TH/4+5), 0, TH/4, 4);
		cad_add_line (hndDrawing, dir*(d/2+5), dir*-TH/2, dir*(d/2+5+TH/2), dir*TH/2, 4);
		cad_add_text (hndDrawing, dir*(d/2+6+2*TH/3), dir*-TH/2, dreh, TH, Text, 4);
		
		// Rohr
		if (rohr == "true")
		{
			cad_add_rect (hndDrawing, -dA/2, -1.5*Emass, dA/2, -0.5*Emass+H, 5);
		}
		// Mittellinien
		cad_add_line (hndDrawing, 0, -1.5*Emass, 0, -0.5*Emass+H, 1);
		cad_add_line (hndDrawing, -d/2, 0, d/2, 0, 1);
		// Daemmung
		if (daemmung == "true")
		{
			cad_add_rect (hndDrawing, -dA/2-J, -4/3*Emass, -dA/2, -2/3*Emass+H, 5);
			cad_add_rect (hndDrawing, dA/2+J, -4/3*Emass, dA/2, -2/3*Emass+H, 5);
		}
		
		retObj.xMassTop = d/2;
		retObj.xMassBottom = (L/2 + z);
		retObj.xWidthLeft = (L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = (-Emass + ha/2);
		retObj.L_PosNr = z/2;
		retObj.yWidthBottom = (H - Emass);
		//retObj.yWidthBottom = 0;
		
 },
 
 
 insertVKK2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	// Kastenschelle VKK
 {
		if (getstring("m_dSonderSpannweite", "DLGDATA.CA.SELECTION.TOPOCLASS.Schelle") == "")
			var L = cad_getdouble ("SPANN");											// Spannweite
		else
			var L = inputStringToDouble(getstring("m_dSonderSpannweite", "DLGDATA.CA.SELECTION.TOPOCLASS.Schelle"));
																						// Sonderspannweite
			
		var sT = cad_getdouble ("ST");													// Traegerdicke
		var ha = cad_getdouble ("HA");													// seitliche Hoehe Seitenteil
		var k = cad_getdouble ("K");													// Seitenteil untere Breite
		var d = cad_getdouble ("D_");													// Drm Bohrung
		var hm = cad_getdouble ("HM");													// Hoehe Seitenteil
		var z = cad_getdouble ("Z");													// Ueberstand
		var r = cad_getdouble ("R");													// Hoehe ueber Aufhaengebohrung
		var Bab = cad_getdouble ("BAB");												// Breite AHS
		var Lab = cad_getdouble ("LAB");												// Hoehe AHS
		var eab = cad_getdouble ("EAB");												// Abstand AHS
		var tab = cad_getdouble ("TAB");												// Ueberstand AHS
		var sTp = cad_getdouble ("STP");												// Dicke Tragplatte
		var PL = cad_getdouble ("PL");													// Breite Tragplatte
		var J = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");	// Daemmdicke
		var dA = threeDparams["Rohraussendurchmesser"];									// Rohraussendurchmesser
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		cad_begin_poly (hndDrawing, 0, 7);	// Aussenkontur
			cad_add_vertex (hndDrawing, (-eab/2 - Bab/2), (-Emass - sTp));
			cad_add_vertex (hndDrawing, (-L/2 - z), (-Emass - sTp));
			cad_add_vertex (hndDrawing, (-L/2 - z), (-Emass - sTp - ha));
			cad_add_vertex (hndDrawing, -k/2, (-Emass - sTp - hm));
			cad_add_vertex (hndDrawing, k/2, (-Emass - sTp - hm));
			cad_add_vertex (hndDrawing, (L/2 + z), (-Emass - sTp - ha));
			cad_add_vertex (hndDrawing, (L/2 + z), (-Emass - sTp));
			cad_add_vertex (hndDrawing, (eab/2 + Bab/2), (-Emass - sTp));
		cad_end_poly (hndDrawing);
		cad_add_line (hndDrawing, (-eab/2 + Bab/2), (-Emass - sTp), (eab/2 - Bab/2), (-Emass -sTp), 7);
		
		cad_add_line (hndDrawing, -PL/2, (-Emass - sTp), -PL/2, -Emass, 7);					// Tragplatte
		cad_add_line (hndDrawing, -PL/2, -Emass, (-eab/2 - Bab/2), -Emass, 7);
		cad_add_line (hndDrawing, PL/2, (-Emass - sTp), PL/2, -Emass, 7);
		cad_add_line (hndDrawing, PL/2, -Emass, (eab/2 + Bab/2), -Emass, 7);
		cad_add_line (hndDrawing, (-eab/2 + Bab/2), -Emass, (eab/2 - Bab/2), -Emass, 7);
		
		cad_add_rect (hndDrawing, (-eab/2 - Bab/2), (-Emass + tab), (-eab/2 + Bab/2), (-Emass + tab - Lab), 7);	// AHS
		cad_add_rect (hndDrawing, (eab/2 - Bab/2), (-Emass + tab), (eab/2 + Bab/2), (-Emass + tab - Lab), 7);
		
		cad_add_rect (hndDrawing, (-L/2 - sT/2), (-Emass - sTp), (-L/2 + sT/2), r, 7);		// Aufhaengung li
		cad_add_rect (hndDrawing, (L/2 - sT/2), (-Emass - sTp), (L/2 + sT/2), r, 7);		// Aufhaengung re
		
		cad_add_rect (hndDrawing, (-L/2 - sT/2), (-Emass - sTp), (-L/2 + sT/2), r, 254);	// Ausbrennen Aufhaengung li
		cad_add_rect (hndDrawing, (L/2 - sT/2), (-Emass - sTp), (L/2 + sT/2), r, 254);		// Ausbrennen Aufhaengung re
		
		// Rohr
		if (rohr == "true")
		{
			cad_add_rect (hndDrawing, -dA/2, -Emass+hm/2, dA/2, -Emass-sTp-1.5*hm, 5);
		}
		// Mittellinie
		cad_add_line (hndDrawing, 0, -Emass+hm/2, 0, -Emass-sTp-1.5*hm, 1);
		// Daemmung
		if (daemmung == "true")
		{
			cad_add_rect (hndDrawing, -dA/2-J, -Emass+hm/3, -dA/2, -Emass-sTP-4/3*hm, 5);
			cad_add_rect (hndDrawing, dA/2+J, -Emass+hm/3, dA/2, -Emass-sTP-4/3*hm, 5);
		}
		
		retObj.xMassTop = (L/2 + sT/2);
		retObj.xMassBottom = PL/2;
		retObj.xWidthLeft = (L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = (-Emass - 2*sTp);
		retObj.L_PosNr = z/2;
		retObj.yWidthBottom = (Emass + 4/3*hm + sTp);
		//retObj.yWidthBottom = 0;
		retObj.index = 2;
 },
 
 
 insertVKR2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)		// Kastenschelle VKR
  {
		if (getstring("m_dSonderSpannweite", "DLGDATA.CA.SELECTION.TOPOCLASS.Schelle") == "")
			var L = cad_getdouble ("SPANN");											// Spannweite
		else
			var L = inputStringToDouble(getstring("m_dSonderSpannweite", "DLGDATA.CA.SELECTION.TOPOCLASS.Schelle"));
																						// Sonderspannweite
		var sT = cad_getdouble ("ST");													// Trgerdicke
		var e = cad_getdouble ("E_");													// Abstand Bohrung zu Oberkante
		var d = cad_getdouble ("D_");													// Drm Bohrung
		var ha = cad_getdouble ("HA");													// seitliche Hhe Seitenteil
		var k = cad_getdouble ("K");													// Seitenteil untere Breite
		var d = cad_getdouble ("D_");													// Drm Bohrung
		var H = cad_getdouble ("H");													// Hoehe Seitenteil
		var z = cad_getdouble ("Z");													// Ueberstand
		var r = cad_getdouble ("R");													// Hoehe ueber Aufhaengebohrung
		var d_Rohr_string = ("D_Rohr");													// DMR Rundnocken
		var d_Rohr_double = ("D_Rohr");
		var J = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");	// Daemmdicke
		var dA = threeDparams["Rohraussendurchmesser"];									// Rohraussendurchmesser
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		var TH = Options.textheight;													// Texthoehe der Bemassung
		
		/*var strSQLStatement = "select * from ROHRD where abs(Bohr_VxR)="+d+" ";
		var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
		var d_Rohr_string = dbgetstring("ROHRD", "D");
		var d_Rohr_double = dbgetdouble("ROHRD", "D");
		*/
		
		var Text = cad_getstring ("D_") + "/" + d_Rohr_string;
		
		cad_begin_poly (hndDrawing, 1, 7);	// Aussenkontur
			cad_add_vertex (hndDrawing, (-L/2 - z), -(Emass - e));
			cad_add_vertex (hndDrawing, (-L/2 - z), (-(Emass - e)-ha));
			cad_add_vertex (hndDrawing, -k/2, (-H - (Emass - e)));
			cad_add_vertex (hndDrawing, k/2, (-H - (Emass - e)));
			cad_add_vertex (hndDrawing, (L/2 + z), (-ha - (Emass - e)));
			cad_add_vertex (hndDrawing, (L/2 + z), -(Emass - e));
		cad_end_poly (hndDrawing);
		
		cad_add_circle (hndDrawing, 0, -Emass, d/2, 7);								// Haltebohrung
		cad_add_circle (hndDrawing, 0, -Emass, d_Rohr_double/2, 1);						// Rohr
		cad_add_circle (hndDrawing, 0, -Emass, (d_Rohr_double-d_Rohr_double/20)/2, 1);	// Rohr
		
		// Angabe Bohrungsdurchmesser und Rohrdurchmesser
		cad_add_circle (hndDrawing, d/2+TH/4+5, -Emass, TH/4, 4);
		cad_add_line (hndDrawing, d/2+5, -Emass-TH/2, d/2+5+TH/2, -Emass+TH/2, 4);
		cad_add_text (hndDrawing, d/2+6+2*TH/3, -Emass-TH/2, 0, TH, Text, 4);
		
		cad_add_rect (hndDrawing, (-L/2 - sT/2), (-Emass + e), (-L/2 + sT/2), r, 7);	// Aufhaengung li
		cad_add_rect (hndDrawing, (L/2 - sT/2), (-Emass + e), (L/2 + sT/2), r, 7);		// Aufhaengung re
		
		cad_add_rect (hndDrawing, (-L/2 - sT/2), (-Emass + e), (-L/2 + sT/2), r, 254);	// Ausbrennen Aufhaengung li
		cad_add_rect (hndDrawing, (L/2 - sT/2), (-Emass + e), (L/2 + sT/2), r, 254);	// Ausbrennen Aufhaengung re
		
		// Rohr
		if (rohr == "true")
		{
			cad_add_rect (hndDrawing, -dA/2, -Emass+e+H/2, dA/2, -Emass+e-1.5*H, 5);
		}
		// Mittellinien
		cad_add_line (hndDrawing, 0, -Emass+e+H/2, 0, -Emass+e-1.5*H, 1);
		cad_add_line (hndDrawing, -d/2, -Emass, d/2, -Emass, 1);
		// Daemmung
		if (daemmung == "true")
		{
			cad_add_rect (hndDrawing, -dA/2-J, -Emass+e+H/3, -dA/2, -Emass+e-4/3*H, 5);
			cad_add_rect (hndDrawing, dA/2+J, -Emass+e+H/3, +dA/2, -Emass+e-4/3*H, 5);
		}
		
		retObj.xMassTop = (L/2 + sT/2);
		retObj.xMassBottom = d/2;
		retObj.xWidthLeft = (L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = (-Emass + e - ha/2);
		retObj.L_PosNr = z/2;
		retObj.yWidthBottom = (Emass + H - e);
		retObj.index = 2;
  },
  
  insertVBK2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	// Biegeschelle
  {
		var L = threeDparams["Spannweite"];												// Spannweite
		var z = cad_getdouble ("Z");													// Ueberstand
		var H = cad_getdouble ("H");													// Schellenhoehe
		var s = cad_getdouble ("S");													// Schellendicke
		var di = cad_getdouble ("DI");													// Drm innere Schrauben
		var c = cad_getdouble ("C");													// Dmr aeussere Schrauben
		var a = cad_getdouble ("A");													// Abstand innere Schrauben
		var Typ = cad_getdouble ("AUSFUEHR");											// Ausfhrung
		var e2 = cad_getdouble ("E2");													// Schraubenabstand bei Ausfuehrung 2
		var dA = threeDparams["Rohraussendurchmesser"];									// Rohraussendurchmesser
		var J = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");	// Daemmdicke
		
		var rohr = Options["IDC_ROHR"];
		var daemmung = Options["IDC_DAEMMUNG"];
		
		cad_add_rect (hndDrawing, (-z - L/2), 0, (L/2 + z), -H, 7);
		cad_add_rect (hndDrawing, (-z - L/2), 0, (L/2 + z), -H, 254);
		cad_add_line (hndDrawing, -dA/2-2*s, -(H/10), -dA/2-2*s, -(H - H/10), 8);
		cad_add_line (hndDrawing, dA/2+2*s, -(H/10), dA/2+2*s, -(H - H/10), 8);
		cad_add_circle (hndDrawing, -L/2, -Emass, c/2, 7);
		cad_add_circle (hndDrawing, L/2, -Emass, c/2, 7);
		
		// Rohr
		if (rohr == "true")
		{
			cad_add_rect (hndDrawing, -dA/2, H/2, dA/2, -1.5*H, 5);
		}
		// Mittellinie
		cad_add_line (hndDrawing, 0, H/2, 0, -1.5*H, 1);
		// Daemmung
		if (daemmung == "true")
		{
			cad_add_rect (hndDrawing, -dA/2-J, H/3, -dA/2, -4/3*H, 5);
			cad_add_rect (hndDrawing, dA/2+J, H/3, +dA/2, -4/3*H, 5);
		}
		
		if (Typ == 1)		// niedrige Ausfhrung Typ 1
		{
		cad_add_circle (hndDrawing, -a/2, -H/2, di/2, 7);
		cad_add_circle (hndDrawing, a/2, -H/2, di/2, 7);
		}
		else				// hohe Ausfhrung Typ 2
		{
		cad_add_circle (hndDrawing, -a/2, -(H - e2)/2, di/2, 7);
		cad_add_circle (hndDrawing, -a/2, -H/2 - e2/2, di/2, 7);
		cad_add_circle (hndDrawing, a/2, -(H - e2)/2, di/2, 7);
		cad_add_circle (hndDrawing, a/2, -H/2 - e2/2, di/2, 7);
		}
		
		retObj.xMassTop = (L/2 + z);
		retObj.xMassBottom = (L/2 + c/2);
		retObj.xWidthLeft = (L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = (Emass - H/2);
		retObj.L_PosNr = z;
		retObj.yWidthBottom = H + Options.textheight;
		retObj.index = 2;
		
  },
  
  
  insertZTN2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options)	// Traverse
  {
		// Achtung: Spannweite im Produkt ist nchst hhere Normspannweite bei Sonderspannweiten
		// Deshalb hier den Eingabewert nehmen.
		// var L = cad_getdouble ("SPANN");
		var L = threeDparams["Spannweite"];		// Spannweite

		var f = cad_getdouble ("F");			// Drm Bohrung in Lasche
		var z = cad_getdouble ("Z");			// Ueberstand
		var U = cad_getdouble ("U");			// Traegerhoehe
		var LGV = cad_getdouble ("LGV");		// Lastgruppe
		var LG = threeDparams["Lastgroesse0"];	// Lastgroesse FH
		var NW = threeDparams["Weg0"];	// Nennweg FH
		
		// Dmr FH
		var strSQLStatement = "select * from FHD where lastgr="+LG+" and nennw="+NW+" ";
		var numRet = dbselect("CASCADE", strSQLStatement, "FHD");
		var D = dbgetdouble("FHD", "D");				// Dmr Gehaeuse
		
		if (D == 0)
		{
			D = LGV;
		};
		
		cad_add_rect (hndDrawing, (-L/2 - z), -U, (L/2 + z), 0, 7);
		cad_add_line (hndDrawing, (-L/2 - z), (-U + U/12), (L/2 + z), (-U + U/12), 7);
		cad_add_line (hndDrawing, (-L/2 - z), -U/12, (L/2 + z), -U/12, 7);
		cad_add_line (hndDrawing, (-L/2 - 1.5*LGV), 0, (-L/2 - 1.5*LGV), Emass, 7);
		cad_add_arc (hndDrawing, -L/2, Emass, 1.5*LGV, 0, 180, 7);
		cad_add_line (hndDrawing, (-L/2 + 1.5*LGV), 0, (-L/2 + 1.5*LGV), Emass, 7);
		cad_add_circle (hndDrawing, -L/2, Emass, f/2, 7);
		cad_add_line (hndDrawing, (L/2 - 1.5*LGV), 0, (L/2 - 1.5*LGV), Emass, 7);
		cad_add_arc (hndDrawing, L/2, Emass, 1.5*LGV, 0, 180, 7);
		cad_add_line (hndDrawing, (L/2 + 1.5*LGV), 0, (L/2 + 1.5*LGV), Emass, 7);
		cad_add_circle (hndDrawing, L/2, Emass, f/2, 7);
		
		retObj.xMassTop = (L/2 + f/2);
		retObj.xMassBottom = (L/2 + z);
		retObj.xWidthLeft = D/2; //(L/2 + z);
		retObj.xWidthRight = (L/2 + z);
		retObj.xDist = (L/2 + z);
		retObj.yDist = -U/2;
		retObj.L_PosNr = z;
		retObj.yWidthBottom = 0;
		
  },


  insertFDT2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Doppelfederhnger mit Traverse
  {
		var H = cad_getdouble ("H");		// Gehusehhe FH
		var D = cad_getdouble ("D");		// Drm Gehuse FH
		var e = cad_getdouble ("E_");		// berstand FH zu Traverse
		var U = cad_getdouble ("U");		// Trgerhhe
		var E = cad_getdouble ("E");		// E aus Katalog ohne Vorspannung
		var B = cad_getdouble ("B");		// Oberkante Gehuse bis Oberkante Spannschloss ohne Vorspannung
		// Achtung: Spannweite im Produkt ist nchst hhere Normspannweite bei Sonderspannweiten
		// Deshalb hier den Eingabewert nehmen.
		// var L = cad_getdouble ("SPANN");
		var L = threeDparams["Spannweite"];	// Spannweite
		var LGV = cad_getdouble ("D_");		// Lastgruppe
		
		if ((Emass + B + e - 2*E - 3.2*LGV) > e)			// Ende der Ausparung Spannschloss unten
		{
			var SpU = (Emass + B + e - 2*E - 3.2*LGV);
		}
		else
		{
			var SpU = e;
		}
		
		cad_add_rect (hndDrawing, (-L/2 - D/2), (e - H), (-L/2 + D/2), e, 7);									// FH links
		cad_add_rect (hndDrawing, (L/2 + D/2), (e - H), (L/2 - D/2), e, 7);										// FH rechts
		cad_add_rect (hndDrawing, (-L/2 - LGV), e, (-L/2 + LGV), (Emass + B + e - E), 7);						// Spannschloss li
		cad_add_rect (hndDrawing, (-L/2 - LGV), e, (-L/2 + LGV), (Emass + B + e - E), 254);						// Spannschloss li ausbrennen
		cad_add_rect (hndDrawing, (-L/2 + 2*LGV/3), (Emass + B + e - E - 1.4*LGV), (-L/2 - 2*LGV/3), SpU, 7);
		cad_add_rect (hndDrawing, (-L/2 + 2*LGV/3), (Emass + B + e - E - 1.4*LGV), (-L/2 - 2*LGV/3), SpU, 254);
		cad_add_rect (hndDrawing, (L/2 + LGV), e, (L/2 - LGV), (Emass + B + e - E), 7);							// Spannschloss re
		cad_add_rect (hndDrawing, (L/2 + LGV), e, (L/2 - LGV), (Emass + B + e - E), 254);						// Spannschloss re ausbrennen
		cad_add_rect (hndDrawing, (L/2 - 2*LGV/3), (Emass + B + e - E - 1.4*LGV), (L/2 + 2*LGV/3), SpU, 7);
		cad_add_rect (hndDrawing, (L/2 - 2*LGV/3), (Emass + B + e - E - 1.4*LGV), (L/2 + 2*LGV/3), SpU, 254);
		
		cad_add_rect (hndDrawing, (-L/2 + D/2), -U, (L/2 - D/2), 0, 7);											// Traeger
		
		this.add_ZMM(hndDrawing, -L/2, Emass + B + e - E + 0.9*LGV, LGV);		// Mutter li
		this.add_ZMM(hndDrawing, L/2, Emass + B + e - E + 0.9*LGV, LGV);		// Mutter re
		
		retObj.xMassTop = L/2;
		retObj.xMassBottom = (L/2 - D/2);
		retObj.xWidthLeft = D/2;
		retObj.xWidthRight = (L/2 + D/2);
		retObj.xDist = (L/2 + D/2);
		retObj.yDist = (-Emass - U/2);
		retObj.L_PosNr = D/2;
		retObj.yWidthBottom = U/2;
		retObj.index = 2;
		
  },
  
  
  insertFSx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Federsttze
  {
		var m = cad_getdouble("M");		// Fussbreite
		var s = cad_getdouble("S");		// Fussdicke
		var A = cad_getdouble("A");		// Gehusehhe
		var D = cad_getdouble("D");		// Gehuseduchmesser
		var D1 = cad_getdouble("D1");	// Drm Sttzrohr
		var w = cad_getdouble("W");		// Tellerhhe
		var p = cad_getdouble("P");		// Tellerduchmesser
		
		cad_add_rect (hndDrawing, (-m/2), -Emass, m/2, (-Emass + s), 7);
		cad_add_rect (hndDrawing, (-D/2), (-Emass + s), D/2, -(Emass - A), 7);
		cad_add_rect (hndDrawing, (-D1/2), -(Emass - A), D1/2, -w, 7);
		
		if (Typid == "FSS")		// Fall FSS
		{
			cad_add_rect (hndDrawing, -p/2, -w, p/2, 0, 7);
			retObj.xMassTop = p/2;
		}
		else					// Fall FSP
		{
			cad_add_rect (hndDrawing, -p/2, -w, p/2, -2, 7);
			cad_add_rect (hndDrawing, -(p-20)/2, -2, (p-20)/2, 0, 7);
			retObj.xMassTop = (p/2-20);
		}
		
		retObj.xMassBottom = m/2;
		retObj.xWidthLeft = m/2;
		retObj.xWidthRight = m/2;
		retObj.xDist = D/2;
		retObj.yDist = -Emass/2;
		retObj.L_PosNr = D1;
		
  },

  
  insertFSG2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Gelenksttze
  {
		var A = cad_getdouble("A");			// Gehusehhe
		var B = cad_getdouble("B");			// Hhe Sttzrohr plus Auge (Mitte)
		var g = cad_getdouble("G");			// Augendicke
		var s = cad_getdouble("S");			// Fussdicke
		var D = cad_getdouble("D");			// Gehusedurchmesser
		var dR = cad_getdouble("DR");		// Sttzrohrdurchmesser
		var M = cad_getdouble("M");			// Fussbreite
		var f = cad_getdouble("F");			// Drm Bohrung Auge
		//var E = threeDparams["E-Mass0"];	// E-Mass
		var E = Emass;						// E-Mass
		
		cad_add_rect (hndDrawing, -dR/2, (-E + dR/2), dR/2, (-B - A), 7);
		cad_add_rect (hndDrawing, -M/2, (-B - A), M/2, (-B - A + s), 7);
		cad_add_rect (hndDrawing, -D/2, (-B - A + s), D/2, -B, 7);
		cad_add_rect (hndDrawing, -dR/2, -B, dR/2, -dR/2, 7);
		
		if ((Rotation == 90) || (Rotation == 270))	// Auge in Seitenansicht
		{
			cad_add_rect (hndDrawing, -g/2, -dR/2, g/2, dR/2, 7);
			cad_add_rect (hndDrawing, -g/2, (-E - dR/2), g/2, (-E + dR/2), 7);
			
			retObj.xMassTop = g/2;
			retObj.xMassBottom = g/2;
			retObj.xWidthLeft = M/2;
			retObj.xWidthRight = M/2;
			retObj.xDist = D/2;
			retObj.yDist = (-B - A/2);
			retObj.L_PosNr = dR;
			
		}
		
		else										// Auge in Draufsicht
		{
			cad_add_circle (hndDrawing, 0, 0, dR/2, 7);
			cad_add_circle (hndDrawing, 0, -E, dR/2, 7);
			cad_add_circle (hndDrawing, 0, 0, f/2, 7);
			cad_add_circle (hndDrawing, 0, -E, f/2, 7);
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = f/2;
			retObj.xWidthLeft = M/2;
			retObj.xWidthRight = M/2;
			retObj.xDist = D/2;
			retObj.yDist = (-B - A/2);
			retObj.L_PosNr = dR;
			
		}
  },
  
  insertZVx2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj)	// Verbindungslasche
  {
		var B = cad_getdouble("B");			// Breite 
		var f = cad_getdouble("F");			// Durchmesser oben
		var g = cad_getdouble("G");			// Durchmesser unten
		var z2 = cad_getdouble("Z2");		// Abstand MP2 von Oberkante
		var z1 = cad_getdouble("Z1");		// Abstand MP1 von Unterkante
		var s1 = cad_getdouble("S1"); 		// Dicke
		var E = threeDparams["E-Mass0"]; 	// Emass
		
		if (Rotation == 90 || Rotation == 270) 
		{
			
			cad_add_rect(hndDrawing, -B/2, -E-z1, B/2, z2, 7);
			cad_add_rect(hndDrawing, -B/2, -E-z1, B/2, z2, 254);
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = g/2;
			retObj.xWidthLeft = B/2;
			retObj.xWidthRight = B/2;
			retObj.xDist = B/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = B;
			retObj.index = 0;
			
		}
		
		else
		{
			// Koerperkanten
			cad_add_rect(hndDrawing, -s1/2, -E-z1, s1/2, z2, 7);
			
			// Ausbrennen
			cad_add_rect(hndDrawing, -s1/2, -E-z1, s1/2, z2, 254);
			
			retObj.xMassTop = s1/2;
			retObj.xMassBottom = s1/2;
			retObj.xWidthLeft = s1/2;
			retObj.xWidthRight = s1/2;
			retObj.xDist = s1/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = B;
			retObj.index = 2;
			
		}
  
  },
  
  
	insertZPK2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject)		//ZPK
	{
		var A = cad_getdouble("A");				// Breite gesamt
		var H = cad_getdouble("H");				// Hhe gesamt
		var E = Emass;							// E-Ma
		var D = cad_getdouble("D");				// Breite oberes Teil
		var s = cad_getdouble("S");				// Hhe unteres Teil
		var LGV = cad_getdouble("LGV");			// LGV
		var PosNr = threeDparams["PosNr0"]; 	// PosNr
		
		cad_add_rect(hndDrawing, -A/2, 0, A/2, s, 7);	// Koerperkanten
		cad_add_rect(hndDrawing, -A/2, 0, A/2, s, 254);	// Ausbrennen
		cad_add_rect(hndDrawing, -D/2, s, D/2, H, 7);	// Koerperkanten
		cad_add_rect(hndDrawing, -D/2, s, D/2, H, 254);	// Ausbrennen
		
		if (cadMacroParamObject.stkListNextPart != "")
		{
			this.add_ZMM(hndDrawing, 0, H + 0.9*LGV, LGV);
			this.add_ZMM(hndDrawing, 0, H + 1.8*LGV, LGV);
		};
		
		if (PosNr == 1)
		{
			if (LGV<36)
			{
				var SN_Gr = 3;
			};
			
			if (LGV>=36 && LGV<56)
			{
				var SN_Gr = 4;
			};
			
			if (LGV>=56)
			{
				var SN_Gr = 5;
			};
			
			this.add_Kehlnaht(hndDrawing, 1, 1.5*LGV, 0, Options.textheight, 1, SN_Gr, 7);
		};
		
		retObj.xMassTop = LGV/2;
		retObj.xMassBottom = A/2;
		retObj.xWidthLeft = A/2;
		retObj.xWidthRight = A/2;
		retObj.xDist = A/2;
		if (PosNr == 1)
		{
			retObj.yDist = s/2;
		}
		else
		{
			retObj.yDist = -s/2;
		};
		
		retObj.L_PosNr = A/2;
		retObj.index = 1;
		
	},
	
  
  
	insertZOM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)		// Oese
	{
		var A = cad_getdouble("A");			// Breite
		var H = cad_getdouble("H");			// Hhe
		var E = Emass;						// E-Ma
		var t = cad_getdouble("T");		
		var b = cad_getdouble("B");			// Kopfhhe
		var c = cad_getdouble("C");			// Drm fuer Bolzen
		var d1 = cad_getdouble("D1");		// Kopfbreite	
		var s = cad_getdouble("S");			// Oesenbreite
		var LGV = cad_getdouble("LGV");		// LGV
		
		if (Rotation == 90 || Rotation == 270)	// Vorderansicht
		{
			cad_begin_poly(hndDrawing, 0, 7);				// Aussenkontur
				cad_add_vertex(hndDrawing, -A/2, -Emass);
				cad_add_vertex(hndDrawing, -A/2, t+b);
				cad_add_vertex(hndDrawing, A/2, t+b);
				cad_add_vertex(hndDrawing, A/2, -Emass);
			cad_end_poly(hndDrawing);
			cad_add_arc (hndDrawing, 0, -Emass, ((A - c)/2 + c/2), 180, 0, 7);
			
			cad_begin_poly(hndDrawing, 0, 254);				// Aussenkontur Ausbrennen
				cad_add_vertex(hndDrawing, -A/2, -Emass);
				cad_add_vertex(hndDrawing, -A/2, t+b);
				cad_add_vertex(hndDrawing, A/2, t+b);
				cad_add_vertex(hndDrawing, A/2, -Emass);
			cad_end_poly(hndDrawing);
			cad_add_arc (hndDrawing, 0, -Emass, ((A - c)/2 + c/2), 180, 0, 254);
			
			cad_begin_poly (hndDrawing, 0, 7);				// Innenkontur
				cad_add_vertex (hndDrawing, -c/2, -Emass);
				cad_add_vertex (hndDrawing, -c/2, t);
				cad_add_vertex (hndDrawing, c/2, t);
				cad_add_vertex (hndDrawing, c/2, -Emass);
			cad_end_poly (hndDrawing);
			cad_add_arc (hndDrawing, 0, -Emass, c/2, 180, 0, 7);
			
			cad_begin_poly (hndDrawing, 0, 254);			// Innenkontur Ausbrennen
				cad_add_vertex (hndDrawing, -c/2, -Emass);
				cad_add_vertex (hndDrawing, -c/2, t);
				cad_add_vertex (hndDrawing, c/2, t);
				cad_add_vertex (hndDrawing, c/2, -Emass);
			cad_end_poly (hndDrawing);
			cad_add_arc (hndDrawing, 0, -Emass, c/2, 180, 0, 254);
			
			cad_add_line (hndDrawing, -A/2, t, -c/2, t, 7);
			cad_add_line (hndDrawing, A/2, t, c/2, t, 7);
			
			retObj.xMassTop = A/2;
			retObj.xMassBottom = c/2;
			retObj.xWidthLeft = A/2;
			retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
			if (cadMacroParamObject.stkListPrevPart == "")
				retObj.yDist = 0;
			else if (cadMacroParamObject.stkListPrevPart == "ZGW")
				retObj.yDist = -Emass/2;
			else
				retObj.yDist = Emass/2;
			retObj.L_PosNr = LGV;
			retObj.index = 1;
			
		}
		else	// Seitenansicht
		{
			// Koerperkanten
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, -d1/2, t+b);
				cad_add_vertex(hndDrawing, d1/2, t+b);
				cad_add_vertex(hndDrawing, d1/2, t);
				cad_add_vertex(hndDrawing, s/2, t);
				cad_add_vertex(hndDrawing, s/2, t-(H-b));
				cad_add_vertex(hndDrawing, -s/2, t-(H-b));
				cad_add_vertex(hndDrawing, -s/2, t);
				cad_add_vertex(hndDrawing, -d1/2, t);
			cad_end_poly(hndDrawing);
			
			// Ausbrennen
			cad_begin_poly(hndDrawing, 1, 254);
				cad_add_vertex(hndDrawing, -d1/2, t+b);
				cad_add_vertex(hndDrawing, d1/2, t+b);
				cad_add_vertex(hndDrawing, d1/2, t);
				cad_add_vertex(hndDrawing, s/2, t);
				cad_add_vertex(hndDrawing, s/2, t-(H-b));
				cad_add_vertex(hndDrawing, -s/2, t-(H-b));
				cad_add_vertex(hndDrawing, -s/2, t);
				cad_add_vertex(hndDrawing, -d1/2, t);
			cad_end_poly(hndDrawing);
			
			if ((cadMacroParamObject.stkListPrevPart != "") || (cadMacroParamObject.stkListNextPart != ""))
			{
			this.add_ZMM(hndDrawing, 0, (t+b)+0.9*LGV, LGV);
			}
			
			retObj.xMassTop = d1/2;
			retObj.xMassBottom = s/2;
			retObj.xWidthLeft = d1/2;
			retObj.xWidthRight = d1/2;
			if (cadMacroParamObject.stkListPrevPart == "" || cadMacroParamObject.stkListPrevPart == "ZGW")
				retObj.xDist = 0;
			else
				retObj.xDist = d1/2;
			if (cadMacroParamObject.stkListPrevPart == "ZGW")
				retObj.yDist = -Emass - B/2;
			else
				retObj.yDist = (t + b/2);
			retObj.L_PosNr = d1;
			retObj.index = 1;
			
		}			
	},
	
	
	insertZSM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// ZSM
	{
		var A = cad_getdouble("A");		// Breite
		var H = cad_getdouble("H");		// Hoehe
		var LGV = cad_getdouble("LGV");	// LGV
		var E = Emass;					// E-Ma
		var t = (A / 1.6);				// Kopfhoehe (Naeherung)
		var e1 = (LGV + 4);				// Spaltbreite (Naeherung)
		
		cad_add_rounded_rect(hndDrawing, -A/2, (-E/2 + H/2), A/2, (-E/2 - H/2), A/10, 7);	// Koerperkanten
		cad_add_rounded_rect(hndDrawing, -A/2, (-E/2 + H/2), A/2, (-E/2 - H/2), A/10, 254);	// Ausbrennen
		
		if (LGV <= 48)
		{
			cad_add_rounded_rect(hndDrawing, -e1/2, (-E/2 + H/2 - t), e1/2, (-E/2 - H/2 + t), A/10, 7);		// Koerperkanten
			cad_add_rounded_rect(hndDrawing, -e1/2, (-E/2 + H/2 - t), e1/2, (-E/2 - H/2 + t), A/10, 254);	// Ausbrennen
		}
		
		if (cadMacroParamObject.stkListPrevPart == "ZRM" || (cadMacroParamObject.stkListPrevPart == "" && cadMacroParamObject.stkListNextPart == "ZLM"))
		{
			this.add_ZMM(hndDrawing, 0, -E/2+H/2+0.9*LGV, LGV);
		}
		else
		{
			this.add_ZMM(hndDrawing, 0, -E/2-H/2, LGV);
		}
		
		retObj.xMassTop = LGV/2;
		retObj.xMassBottom = LGV/2;
		retObj.xWidthLeft = A/2;
		retObj.xWidthRight = A/2;
		retObj.xDist = A/2;
		retObj.yDist = -Emass/2;
		retObj.L_PosNr = LGV;
		retObj.index = 1;
		
	},
  
  
	insertZxM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject)	// ZRM oder ZLM
    {
        var d = cad_getdouble("D");			// Drm Gewindestange (LGV)
		var h = Emass;						// E-mass (ZRM auch verkuerzt)
		var colMLinie = 1;					// Mittellinie: rot
		
		cad_add_rect (hndDrawing, -d/2, 0, d/2, -h, 7);
		cad_add_rect (hndDrawing, -d/2, 0, d/2, -h, 254);
		
		cad_add_line (hndDrawing, 0,0,0,-h,1);
		
		if (cadMacroParamObject.stkListNextPart == "ZPK")
		{
			var strSQLStatement = " select * from ZPK where lgv="+d+" ";
			var numRet = dbselect("CASCADE", strSQLStatement, "ZPK");
			var E_ZPK = dbgetdouble("ZPK", "E");
			
			if (d<36)
			{
				var SN_Gr = 3;
			};
			
			if (d>=36 && d<56)
			{
				var SN_Gr = 4;
			};
			
			if (d>=56)
			{
				var SN_Gr = 5;
			};
			
			this.add_Kehlnaht(hndDrawing, 1, 1.5*d, -h + E_ZPK, Options.textheight, 1, SN_Gr, 7);
		};
		
		retObj.xMassTop = d/2;
		retObj.xMassBottom = d/2;
		retObj.xWidthLeft = d/2;
		retObj.xWidthRight = d/2;
		retObj.xDist = d/2;
		if (cadMacroParamObject.stkListPrevPart == "FHS")
		{
			retObj.yDist = (-Emass / 20);
		};
		if  ((cadMacroParamObject.stkListNextPart == "ZPK") || (cadMacroParamObject.stkListNextPart == "ZMM"))
		{
			retObj.yDist = -h + d/2;
		}
		else
		{
			retObj.yDist = -Emass/2;
		};
		retObj.L_PosNr = 2*d;
		retObj.index = 0;
		
    },
	
	insertZHM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// ZHM
	{
		var A = cad_getdouble("A");			// Breite (Durchmesser)
		var H = cad_getdouble("H");			// Hoehe
		var h = cad_getdouble("H_");		// Kopfhoehe
		var f = cad_getdouble("F");			// Breite Freimachung
		var LGV = cad_getdouble("LGV");		// Lastgruppe
		
		// Koerperkanten
		cad_add_rounded_rect(hndDrawing, -A/2, -H/2, A/2, H/2, A/10 , 7);
		if ((LGV < 56) && ((Rotation == 0) || (Rotation == 180)))
		{
		cad_add_rounded_rect(hndDrawing, -f/2, -(H-2*h)/2, f/2, (H-2*h)/2, A/10 , 7);
		}
		// Ausbrennen
		cad_add_rounded_rect(hndDrawing, -A/2, -H/2, A/2, H/2, A/10 , 254);
		if ((LGV < 56) && ((Rotation == 0) || (Rotation == 180)))
		{
		cad_add_rounded_rect(hndDrawing, -f/2, -(H-2*h)/2, f/2, (H-2*h)/2, A/20 , 254);
		}
		
		retObj.xMassTop = A/2;
		retObj.xMassBottom = A/2;
		retObj.xWidthLeft = A/2;
		retObj.xWidthRight = A/2;
		retObj.xDist = A/2;
		retObj.yDist = -Emass/2;
		retObj.L_PosNr = A;
		retObj.index = 1;
		
		if ((cadMacroParamObject.stkListPrevPart != "") || (cadMacroParamObject.stkListNextPart != ""))
		{
			this.add_ZMM(hndDrawing, 0, H/2+0.9*LGV, LGV);
			this.add_ZMM(hndDrawing, 0, -H/2, LGV);
		}
		
	},
	
	insertZGM2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// ZGM
	{
		var h4 = cad_getdouble("H4");				// vgl. Zeichnung
		var h2 = cad_getdouble("H2");				// Spalt fuer ZRM
		var h1 = cad_getdouble("H1");				// Kopfhoehe
		var A = cad_getdouble("A");					// max. Breite
		var b = cad_getdouble("B_");				// Spaltbreite
		var B = cad_getdouble("B");					// Gesamtbreite
		var c = cad_getdouble("C");					// Bolzenduchmesser
		var F = cad_getdouble("F");					// Hoehe bis Bolzenmitte
		var L = cad_getdouble("L");					// Bolzenlaenge
		var LGV = cad_getdouble("LGV");				// LGV
		var PosNr = threeDparams["PosNr0"];			// PosNr
		var Btr = threeDparams["Traegerbreite0"];	// Traegerbreite
		
		var PrevZKN = 0;
		var Typ_ZKN = "";
		
		if (cadMacroParamObject.stkListPrevPart == "ZKN")
		{
			PrevZKN = 1;
		}
		
		if (PrevZKN == 1 && LGV == 12)
		{
			Typ_ZKN = "ZKB";
		}
		else if (PrevZKN == 1 && ((LGV == 16 && Btr >= 100 && Btr <= 160) || (LGV == 20 && Btr >= 120 && Btr <= 180) ||(LGV == 24 && Btr >= 140 && Btr <= 200)))
		{
			Typ_ZKN = "ZKN1";
		}
		else
		{
			Typ_ZKN = "ZKN2";
		}
		
		if (Typ_ZKN == "ZKB" || (Typ_ZKN == "ZKN1" && ((LGV == 16 && Btr != 160) || (LGV == 20 && Btr != 180) || LGV == 24)))
		{
				Rotation = Rotation + 90;
		}
		
		if (left(cadMacroParamObject.stkListNextPart, 2) == "ZL")
		{
			Rotation = Rotation + 90;
		}
		
		if (Rotation == 360)
		{
			Rotation = 0;
		}
		
		if ((LGV <= 48) && ((Rotation == 0) || (Rotation == 180)))	// Schmiedeteil
		{
			// Kontur Koerperkanten
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, -b/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, -B/2, (-Emass - A/2));
				cad_add_vertex3(hndDrawing, -B/2, (F-Emass), LGV/3);
				cad_add_vertex3(hndDrawing, B/2, (F-Emass), LGV/3);
				cad_add_vertex(hndDrawing, B/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, h2/2, (-Emass + A/2));
			cad_end_poly(hndDrawing);
			cad_add_rect(hndDrawing, b/2, (-Emass + c/2), -b/2, (-Emass - c/2), 7);
			cad_add_rect(hndDrawing, B/2, (-Emass + c/2), (B/2 + (L - B)/2), (-Emass - c/2), 7);
			cad_add_rect(hndDrawing, -B/2, (-Emass + c/2), (-B/2 - (L - B)/2), (-Emass - c/2), 7);
			
			// Kontur Ausbrennen
			cad_begin_poly(hndDrawing, 1, 254);
				cad_add_vertex(hndDrawing, h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, -b/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, -B/2, (-Emass - A/2));
				cad_add_vertex3(hndDrawing, -B/2, (F-Emass), LGV/3);
				cad_add_vertex3(hndDrawing, B/2, (F-Emass), LGV/3);
				cad_add_vertex(hndDrawing, B/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass + A/2));
				cad_add_vertex(hndDrawing, h2/2, (-Emass + A/2));
			cad_end_poly(hndDrawing);
			cad_add_rect(hndDrawing, b/2, (-Emass + c/2), -b/2, (-Emass - c/2), 254);
			cad_add_rect(hndDrawing, B/2, (-Emass + c/2), (B/2 + (L - B)/2), (-Emass - c/2), 254);
			cad_add_rect(hndDrawing, -B/2, (-Emass + c/2), (-B/2 - (L - B)/2), (-Emass - c/2), 254);
			
			retObj.xMassTop = B/2;
			retObj.xMassBottom = 0;
			retObj.xWidthLeft = B/2;
			retObj.xWidthRight = B/2;
			retObj.xDist = B/2;
			if ((cadMacroParamObject.stkListPrevPart != "ZRM") && (cadMacroParamObject.stkListPrevPart != "ZLM"))
			{
				retObj.yDist = -Emass;
			}
			else
			{
				retObj.yDist = -Emass + F/2;
			}
			retObj.L_PosNr = 1.5*B;
			retObj.index = 1;
			
		}
		if ((LGV > 48) && ((Rotation == 0) || (Rotation == 180)))	// Brennteil
		{
			// Koerperkanten
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, -B/2, (-Emass - A/2));
				cad_add_vertex3(hndDrawing, -B/2, (-Emass + F), LGV/5);
				cad_add_vertex3(hndDrawing, B/2, (-Emass + F), LGV/5);
				cad_add_vertex(hndDrawing, B/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, h2/2, (-Emass - A/2 + h4));
			cad_end_poly(hndDrawing);
			cad_add_rect(hndDrawing, b/2, (-Emass + c/2), -b/2, (-Emass - c/2), 7);
			cad_add_rect(hndDrawing, B/2, (-Emass + c/2), (B/2 + (L - B)/2), (-Emass - c/2), 7);
			cad_add_rect(hndDrawing, -B/2, (-Emass + c/2), (-B/2 - (L - B)/2), (-Emass - c/2), 7);
			
			// Ausbrennen
			cad_begin_poly(hndDrawing, 1, 254);
				cad_add_vertex(hndDrawing, h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (F - Emass - h1));
				cad_add_vertex(hndDrawing, -h2/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, -b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, -B/2, (-Emass - A/2));
				cad_add_vertex3(hndDrawing, -B/2, (-Emass + F), LGV/5);
				cad_add_vertex3(hndDrawing, B/2, (-Emass + F), LGV/5);
				cad_add_vertex(hndDrawing, B/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2));
				cad_add_vertex(hndDrawing, b/2, (-Emass - A/2 + h4));
				cad_add_vertex(hndDrawing, h2/2, (-Emass - A/2 + h4));
			cad_end_poly(hndDrawing);
			cad_add_rect(hndDrawing, b/2, (-Emass + c/2), -b/2, (-Emass - c/2), 254);
			cad_add_rect(hndDrawing, B/2, (-Emass + c/2), (B/2 + (L - B)/2), (-Emass - c/2), 254);
			cad_add_rect(hndDrawing, -B/2, (-Emass + c/2), (-B/2 - (L - B)/2), (-Emass - c/2), 254);
			
			retObj.xMassTop = B/2;
			retObj.xMassBottom = 0;
			retObj.xWidthLeft = B/2;
			retObj.xWidthRight = B/2;
			retObj.xDist = B/2;
			if ((cadMacroParamObject.stkListPrevPart != "ZRM") && (cadMacroParamObject.stkListPrevPart != "ZLM"))
			{
				retObj.yDist = -Emass;
			}
			else
			{
				retObj.yDist = -Emass + F/2;
			}
			retObj.L_PosNr = LGV;
			retObj.index = 1;
		}
			
		if ((Rotation == 90) || (Rotation == 270))	// Seitenansicht nicht unterschieden
		{
			cad_add_rect(hndDrawing, -A/2, (-Emass - A/2), A/2, (-Emass + F), 7);	// Koerperkanten
			cad_add_rect(hndDrawing, -A/2, (-Emass - A/2), A/2, (-Emass + F), 254);	// Ausbrennen
			cad_add_circle(hndDrawing, 0, -Emass, c/2, 7); 
			
			retObj.xMassTop = A/2;
			retObj.xMassBottom = A/2;
			retObj.xWidthLeft = A/2;
			retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
			if ((cadMacroParamObject.stkListPrevPart != "ZRM") && (cadMacroParamObject.stkListPrevPart != "ZLM"))
			{
				retObj.yDist = -Emass;
			}
			else
			{
				retObj.yDist = -Emass + F/2;
			}
			retObj.L_PosNr = 1.5*B;
			retObj.index = 2;
			
		}
		
		if ((cadMacroParamObject.stkListPrevPart != "") || (cadMacroParamObject.stkListNextPart != ""))
		{
			this.add_ZMM(hndDrawing, 0, -Emass+F+0.9*LGV, LGV);
		}
		
	},
	
	insertZGW2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject, Options)	// ZGW
	{
		var B	=	cad_getdouble("B");
		var s	=	cad_getdouble("S");
		var g	=	cad_getdouble("G");
		var c	=	cad_getdouble("C");
		var b	=	cad_getdouble("B_");
		var m	=	cad_getdouble("M");
		var n	=	cad_getdouble("N");
		var k	=	cad_getdouble("K");
		var L	=	cad_getdouble("L");
		var LGV	=	cad_getdouble("LGV");
		var SN_Typ	=	cad_getdouble("SCH_V");
		var SN_Gr	=	cad_getdouble("SCH_A");
		
		if (Options.IDC_POSNR == "true")
			var PosNr = 1;
		
		if (LGV <= 16)
			var d	=	cad_getdouble("D_") - 1;
		else
			var d	=	cad_getdouble("D_") - 2;
		
		if (k == "NaN")
			k = 0;
		
		if ((Rotation == 0) || (Rotation == 180))
		{
			// Koerperkanten
			cad_begin_poly(hndDrawing, 1, 7);
				cad_add_vertex(hndDrawing, g/2, - c);
				cad_add_vertex(hndDrawing, -g/2, - c);
				cad_add_vertex(hndDrawing, -g/2, - 2*c);
				cad_add_vertex(hndDrawing, -b/2, -L + m);
				cad_add_vertex(hndDrawing, -b/2, -L + n);
				cad_add_vertex(hndDrawing, -g/2, -L);
				cad_add_vertex(hndDrawing, -B/2, -L);
				cad_add_vertex(hndDrawing, -B/2, -k);
				cad_add_vertex(hndDrawing, -B/2 + k, 0);
				cad_add_vertex(hndDrawing, B/2 - k, 0);
				cad_add_vertex(hndDrawing, B/2, -k);
				cad_add_vertex(hndDrawing, B/2, -L);
				cad_add_vertex(hndDrawing, g/2, -L);
				cad_add_vertex(hndDrawing, b/2, -L + n);
				cad_add_vertex(hndDrawing, b/2, -L + m);
				cad_add_vertex(hndDrawing, g/2, -2*c);
			cad_end_poly(hndDrawing);
			cad_add_rect(hndDrawing, b/2, (-Emass + d/2), -b/2, (-Emass - d/2), 7);
			cad_add_rect(hndDrawing, B/2, (-Emass + d/2), (B/2 + (L - B)/2), (-Emass - d/2), 7);
			cad_add_rect(hndDrawing, -B/2, (-Emass + d/2), (-B/2 - (L - B)/2), (-Emass - d/2), 7);
			if (k != 0)
				cad_add_line(hndDrawing, -B/2, -k, B/2, -k, 7);
			
			// Ausbrennen
			cad_add_rect(hndDrawing, b/2, (-Emass + c/2), -b/2, (-Emass - c/2), 254);
			
			retObj.xMassTop = B/2;
			retObj.xMassBottom = 0;
			retObj.xWidthLeft = B/2;
			retObj.xWidthRight = B/2;
			retObj.xDist = B/2;
			retObj.yDist = -c;
			retObj.L_PosNr = 1.5*B;
			retObj.index = 1;
		}
			
		if ((Rotation == 90) || (Rotation == 270))	// Seitenansicht
		{
			cad_add_rect(hndDrawing, -s/2, -L, s/2, -k, 7);		// Koerperkanten
			cad_add_line(hndDrawing, -s/2, -k, -s/2+k, 0, 7);
			cad_add_line(hndDrawing, -s/2+k, 0, s/2-k, 0, 7);
			cad_add_line(hndDrawing, s/2-k, 0, s/2, -k, 7);
			cad_add_rect(hndDrawing, -s/2, -L, s/2, -k, 254);	// Ausbrennen
			cad_add_circle(hndDrawing, 0, -Emass, d/2, 7);
			if (k != 0)
				cad_add_line(hndDrawing, -s/2, -k, s/2, -k, 7);
			
			retObj.xMassTop = s/2;
			retObj.xMassBottom = s/2;
			retObj.xWidthLeft = s/2;
			retObj.xWidthRight = s/2;
			retObj.xDist = s/2;
			retObj.yDist = -c;
			retObj.L_PosNr = 1.5*B;
			retObj.index = 2;
		}
		if (PosNr == 1)
		{
			if (SN_Typ == 1)
			{
				// add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
				this.add_Kehlnaht(hndDrawing, 1, min(B/2,s/2)-k, 0, Options.textheight, 1, SN_Gr, 7);
			}
			else
			{
				//add_HV_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
				this.add_HV_Naht(hndDrawing, 1, min(B/2,s/2)-k, 0, Options.textheight, 1, 7);
			}
		}
	},
	
	insertZLN2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	//ZLN
	{
		var LGV = cad_getdouble("LGV");						// Lastgruppe
		var s = cad_getdouble("S");							// Dicke
		var r = cad_getdouble("R");							// Radius
		var A = cad_getdouble("A");							// Breite
		var f = cad_getdouble("F");							// Dmr Bohrung
		var l1 = Emass-(sqrt(3)*A/2-2*r);					// Geradstueck bei LGV>=56
		var dx = A/2-3*r/(2*sqrt(3));						// x-Versatz Uebergang Schraege-Radius (von aussen)
		var dy = 0.5*sqrt(3)*A-3*r/2;						// y-Versatz Uebergang Schraege-Radius (von aussen)
		var a = cad_getdouble ("SCH_A");					// Info SN
		var nextPart = cadMacroParamObject.stkListNextPart;	// Nachfolger in StueLi
		
		if (a == 0)
		{
			a = 1;
		}
		
		if ((nextPart == "ZGM") || (nextPart == "FHD"))
		{
			Rotation = Rotation + 90;
		}
		
		if (Rotation == 360)
		{
			Rotation = 0;
		}
		
		if ((Rotation == 90) || (Rotation == 270))	// Seitenansicht
			{
			cad_add_rect (hndDrawing, s/2, 0, -s/2, (-Emass-r), 7);
			cad_add_rect (hndDrawing, s/2, 0, -s/2, (-Emass-r), 254);
			
            retObj.xMassTop = s/2;
			retObj.xMassBottom = s/2;
			retObj.xWidthLeft = s/2;
            retObj.xWidthRight = s/2;
			retObj.xDist = s/2;
            retObj.yDist = -(Emass/3);
            retObj.L_PosNr = 3*A/4;
			retObj.index = 2;
			retObj.Naht = a;
			
			}
			
		if ((LGV >= 56) && ((Rotation == 90) || (Rotation == 270)))	// zus. Linie
			{
			cad_add_line (hndDrawing, s/2, -l1, -s/2, -l1, 7);
			}
		
		if ((LGV < 56) && ((Rotation == 0) || (Rotation == 180)))	//Frontansicht
			{
			
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, 0, 0);
				cad_add_vertex (hndDrawing, -A/2, 0);
				cad_add_vertex2 (hndDrawing, -A/2, -Emass, r);
				cad_add_vertex (hndDrawing, A/2, -Emass);
				cad_add_vertex (hndDrawing, A/2, 0);
			cad_end_poly (hndDrawing);
			cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
			
			cad_begin_poly (hndDrawing, 1, 254);
				cad_add_vertex (hndDrawing, 0, 0);
				cad_add_vertex (hndDrawing, -A/2, 0);
				cad_add_vertex2 (hndDrawing, -A/2, -Emass, r);
				cad_add_vertex (hndDrawing, A/2, -Emass);
				cad_add_vertex (hndDrawing, A/2, 0);
			cad_end_poly (hndDrawing);
			
			retObj.xMassTop = A/2;
			retObj.xMassBottom = f/2;
            retObj.xWidthLeft = A/2;
            retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
            retObj.yDist = -Emass/15;
            retObj.L_PosNr = 3*A/4;
			retObj.index = 0;
			retObj.Naht = a;
			
			}
			
		if ((LGV >= 56) && ((Rotation == 0) || (Rotation == 180)))	// Frontansicht
			{
			cad_begin_poly (hndDrawing, 1, 7);
				cad_add_vertex (hndDrawing, A/2, 0);
				cad_add_vertex (hndDrawing, -A/2, 0);
				cad_add_vertex (hndDrawing, -A/2, -l1);
				cad_add_vertex1 (hndDrawing, (-A/2+dx), (-l1-dy), -r);
				cad_add_vertex (hndDrawing, (A/2-dx), (-l1-dy));
				cad_add_vertex (hndDrawing, A/2, -l1);
			cad_end_poly (hndDrawing);
			cad_add_circle (hndDrawing, 0, -Emass, f/2, 7);
			
			retObj.xMassTop = A/2;
			retObj.xMassBottom = f/2;
            retObj.xWidthLeft = A/2;
            retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
            retObj.yDist = -Emass/15;
            retObj.L_PosNr = A/2;
			retObj.index = 0;
			retObj.Naht = a;
			
			}
	},
	
	insertZLV2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options)	//ZLV
	{
		var r		=	cad_getdouble("R");			//	oberer Radius
		var beta	=	cad_getdouble("BETA");		//	seitlicher Winkel
		var A		=	cad_getdouble("A");			//	Laschenbreite
		var a		=	cad_getdouble("SCH_A");		//	Info SN
		var f		=	cad_getdouble("F");		 	//	Dmr der Bohrung
		var k		=	cad_getdouble("K");			//	Restbreite fuer K-Naht
		var s		=	cad_getdouble("S");			//	Blechdicke
		
		var h		=	Emass + r*sindeg(beta) - (A - 2*r*cosdeg(beta)) / (2*tandeg(beta));	//	Hoehe Geradstueck
		
		if (Rotation == 0 || Rotation == 180)		//	Frontansicht
		{
			cad_begin_poly (hndDrawing, 0, 7);
				cad_add_vertex (hndDrawing, r*cosdeg(beta), r*sindeg(beta));
				cad_add_vertex (hndDrawing, A/2, -Emass + h);
				cad_add_vertex (hndDrawing, A/2, -Emass);
				cad_add_vertex (hndDrawing, -A/2, -Emass);
				cad_add_vertex (hndDrawing, -A/2, -Emass + h);
				cad_add_vertex (hndDrawing, -r*cosdeg(beta), r*sindeg(beta));
			cad_end_poly (hndDrawing);
			
			cad_add_arc (hndDrawing, 0, 0, r, beta, 180 - beta, 7);
			
			cad_add_circle (hndDrawing, 0, 0, f/2, 7);
			
			cad_add_line (hndDrawing, -f, 0, f, 0, 1);
			cad_add_line (hndDrawing, 0, -f, 0, f, 1);
			
			if (k > 0)	// zusaetzliche Linie fuer K-Naht
			{
				cad_add_line (hndDrawing, -A/2, -Emass + (s - k)/2, A/2, -Emass + (s - k)/2, 7);
			}
			
			if (a == 0)	//	K-Naht
			{
				this.add_K_Naht (hndDrawing, 1, 0.4*A, -Emass, Options.textheight, -1, 7);
				//	add_K_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
			}
			else		// Kehlaht
			{
				this.add_Kehlnaht(hndDrawing, 1, 0.4*A, -Emass, Options.textheight, -1, a, 7);
				//	add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
			}
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = A/2;
			retObj.xWidthLeft = A/2;
			retObj.xWidthRight = A/2;
			retObj.xDist = A/2;
			retObj.yDist = -Emass + h;
			retObj.L_PosNr = A/2;
			retObj.index = 0;
		}
		else		//	Seitenansicht
		{
			cad_add_rect (hndDrawing, -s/2, -Emass + h, s/2, r, 7);
			cad_add_rect (hndDrawing, -s/2, -Emass + h, s/2, r, 254);
			
			if (a == 0)	//	K-Naht
			{
				cad_begin_poly (hndDrawing, 0, 7);
					cad_add_vertex (hndDrawing, s/2, -Emass + h);
					cad_add_vertex (hndDrawing, s/2, -Emass + (s - k)/2);
					cad_add_vertex (hndDrawing, k/2, -Emass);
					cad_add_vertex (hndDrawing, -k/2, -Emass);
					cad_add_vertex (hndDrawing, -s/2, -Emass +(s - k)/2);
					cad_add_vertex (hndDrawing, -s/2, -Emass + h);
				cad_end_poly (hndDrawing);
				
				retObj.xMassBottom = k/2;
				
				this.add_K_Naht (hndDrawing, 1, k/2, -Emass, Options.textheight, -1, 7);
				//	add_K_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
			}
			else		// Kehlaht
			{
				cad_add_rect (hndDrawing, -s/2, -Emass, s/2, -Emass + h, 7);
				
				retObj.xMassBottom = s/2;
				
				this.add_Kehlnaht(hndDrawing, 1, 0, -Emass, Options.textheight, -1, a, 7);
				//	add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
			}
			
			retObj.xMassTop = s/2;
			retObj.xWidthLeft = s/2;
			retObj.xWidthRight = s/2;
			retObj.xDist = s/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = s;
			retObj.index = 2;
		}
	},
	
	insertZLB2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, Options, cadMacroParamObject)	//ZLB
	{
		var Ar	=	cad_getdouble("AR");					//	rechter Abstand von Mitte
		var	Al	=	cad_getdouble("AL");					//	linker Abstand von Mitte
		var	r	=	cad_getdouble("R");						//	oberer Radius
		var	t	=	cad_getdouble("T");						//	Geradstueck
		var	s	=	cad_getdouble("S");						//	Dicke
		var	D	=	threeDparams["Rohraussendurchmesser"];	//	Rohrdurchmesser
		var a	=	cad_getdouble("SCH_A");					//	Info zur Schweissnaht
		var f	=	cad_getdouble("F");						//	Bohrungsdurchmesser
		
		if (D > 355.6)
		{
			var dA = D + 4;		//	korrigierter Rohrdurchmesser
		}
		else
		{
			var dA = D + 2;		//	korrigierter Rohrdurchmesser
		}
		
		var	R1	=	1.5*D;		// Radius Rohrbogen (Mitte)
		var	R2	=	R1 + dA/2;	// Radius Rohrbogen (aussen)
		
		var	y1l	=	-Emass - 1.5*D + sqrt(pow(1.5*D + 0.5*dA, 2) - pow(1.5*D + Al, 2)) + D/2;
		var	y1r	=	-Emass + (sqrt(pow(1.5*D + 0.5*dA, 2) - pow(1.5*D - Ar, 2)) - 1.5*D) + t;
		var	pl	=	(2*Al*pow(r, 2) + 2*pow(r, 2)*t) / (pow(y1l, 2) + pow(Al, 2) + 2*Al*t + pow(t, 2));
		var	pr	=	-2*Ar*pow(r, 2) / (pow(y1r, 2) + pow(Ar, 2));
		var	ql	=	(pow(r, 4) - pow(r, 2)*pow(y1l, 2)) / (pow(y1l, 2) + pow(Al, 2) + 2*Al*t + pow(t, 2));
		var	qr	=	(pow(r, 4) - pow(r, 2)*pow(y1r, 2)) / (pow(y1r, 2) + pow(Ar, 2));
		var	x1l	=	-pl/2 + sqrt(pow(pl/2, 2) - ql);
		var	x1r	=	-pr/2 + sqrt(pow(pr/2, 2) - qr);
		var	x2l	=	-pl/2 - sqrt(pow(pl/2, 2) - ql);
		var	x2r	=	-pr/2 - sqrt(pow(pr/2, 2) - qr);
		
		var	xl	=	min(x1l,x2l);
		var	xr	=	max(x1r,x2r);
		var	yl	=	(pow(r ,2) - xl*(-Al - t)) / y1l;
		var	yr	=	(-Ar*xr + pow(r, 2)) / y1r;
		
		if (Rotation == 0 || Rotation == 180)	// Frontansicht
		{
			if (Rotation == 0)
			{
				var	rot	=	1;
			}
			else
			{
				var	rot	=	-1;
			}
			
			cad_begin_poly(hndDrawing,0, 7);
				cad_add_vertex(hndDrawing, rot*xl, yl);
				cad_add_vertex(hndDrawing, rot*(-Al - t), y1l);
				cad_add_vertex(hndDrawing, rot*(-Al - t), y1l - D/2 + t);
				cad_add_vertex(hndDrawing, rot*(-Al), y1l - D/2);
			cad_end_poly(hndDrawing);
			
			cad_add_line(hndDrawing, rot*Ar, y1r - t, rot*Ar, y1r, 7);
			cad_add_line(hndDrawing, rot*Ar, y1r, rot*xr, yr, 7);
			
			cad_add_circle(hndDrawing, 0, 0, f/2, 7);
			
			this.add_Kreuz(hndDrawing, 2*f, 2*f, 0, 0, 1);
			// add_Kreuz : function(hndDrawing, lx, ly, dx, dy, lt)
			
			if (rot == 1)
			{
				cad_add_arc(hndDrawing, 0, 0, r, acosdeg(xr / r), 180 - acosdeg(abs(xl) / r), 7);
				cad_add_arc(hndDrawing, R1, -Emass - R1, R2, 180 - acosdeg((R1 - Ar) / R2), 180 - acosdeg((R1 + Al) / R2), 7);
				
				retObj.xWidthLeft = Al + t;
				retObj.xWidthRight = Ar;
			}
			else
			{
				cad_add_arc(hndDrawing, 0, 0, r, acosdeg(abs(xl) / r), 180 - acosdeg(xr / r), 7);
				cad_add_arc(hndDrawing, -R1, -Emass - R1, R2, acosdeg((R1 + Al) / R2), acosdeg((R1 - Ar) / R2), 7);
				
				retObj.xWidthLeft = Ar;
				retObj.xWidthRight = Al + t;
			}
			
			if (a != 0)
			{
				this.add_Kehlnaht(hndDrawing, 1, rot*Ar, y1r - t, Options.textheight, rot*(-1), a, 7);
				//	add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
			}
			else
			{
				this.add_K_Naht (hndDrawing, 1, rot*Ar, y1r - t, Options.textheight, rot*(-1), 7);
				//	add_K_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
			}
			
			retObj.xMassTop = f/2;
			retObj.xMassBottom = 0;
			retObj.xDist = r;
			retObj.yDist = -r/4;
			retObj.L_PosNr = r;
			retObj.index = 0;
			
		}
		else		// Seitenansicht
		{
			cad_add_rect(hndDrawing, -s/2, y1l - D/2, s/2, r, 7);
			cad_add_rect(hndDrawing, -s/2, y1l - D/2, s/2, r, 254);
			
			if (Rotation == 90)
			{
				cad_add_line(hndDrawing, -s/2, y1l - D/2 + t, s/2, y1l - D/2 + t, 7);
				cad_add_line(hndDrawing, -s/2, y1l + t, s/2, y1l + t, 7);
			}
			else
			{
				cad_add_line(hndDrawing, -s/2, y1r - t, s/2, y1r - t, 7);
				cad_add_line(hndDrawing, -s/2, y1r, s/2, y1r, 7);
			}
			
			if (a != 0)
			{
				this.add_Kehlnaht(hndDrawing, 1, s/2, y1r - 2*t, Options.textheight, (-1), a, 7);
				//	add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
			}
			else
			{
				this.add_K_Naht (hndDrawing, 1, s/2, y1r - 2*t, Options.textheight, (-1), 7);
				//	add_K_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
			}
			
			retObj.xMassTop = s/2;
			retObj.xMassBottom = s/2;
			retObj.xWidthLeft = s/2;
			retObj.xWidthRight = s/2;
			retObj.xDist = s/2;
			retObj.yDist = -Emass/2;
			retObj.L_PosNr = s;
			retObj.index = 2;
			
		}
	},
  
   	insertFHD2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	//FHD
    {
        var H = cad_getdouble("H");					// Gehaeusehoehe
        var A = cad_getdouble("A");					// Gehaeuseunterkante bis Bolzenmitte
		var a = cad_getdouble("A_");				// Laschenabstand
		var b = cad_getdouble("B_");				// Laschendicke
        var R = cad_getdouble("R");					// Bolzenmitte bis Laschenoberkante (r)
		var D = cad_getdouble("D");					// Gehaesuedurchmesser
        var hl = (A+R)-H;							// Laschenhoehe
		var LGV = cad_getdouble("D_");				// LGV
		
		var Btr = threeDparams["Traegerbreite0"];	// Traegerbreite
		
		var TypVor = cadMacroParamObject.stkListPrevPart;
		var TypNach = cadMacroParamObject.stkListNextPart;
		
		if (TypVor == "ZKN" && ((Btr!=82 && LGV==12) || (Btr!=160 && LGV==16) || (Btr!=180 && LGV==20) || (Btr>=140 && Btr <= 200 && LGV == 24)))
		{
			Rotation = Rotation + 90;
		}
		else
		{
			Rotation = Rotation;
		};
		
		this.add_haengerGehause(hndDrawing, 0, -(hl-R), Typid, LGV);
        this.add_lascheHaenger(hndDrawing, 0, -(hl-R), hl, Rotation, TypVor);
        this.add_spannschlossHaenger(hndDrawing, 0, -(hl-R)-H, Emass, TypNach);
		
		retObj.xMassTop = (a/2 + b);
		retObj.xMassBottom = 0;
		retObj.xWidthLeft = D/2;
        retObj.xWidthRight = D/2;
		retObj.xDist = D/2;
        retObj.yDist = -A/2;
        retObj.L_PosNr = (a + 2*b);
		retObj.index = 1;
    },
	
	insertFHG2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	// FHG
	{	
		var e = cad_getdouble("E_MASS");	// Einschraubtiefe Gewindestange
		var H = cad_getdouble("H");			// Gehaesehoehe
		var A = cad_getdouble("A");			// Gehaeseunterkante bis Bolzenmitte
		var D = cad_getdouble("D");			// Gehaesedurchmesser
		var d = cad_getdouble("D_");		// LGV
		
		var TypNach = cadMacroParamObject.stkListNextPart;
		var TypVor = cadMacroParamObject.stkListPrevPart;
		
		this.add_haengerGehause(hndDrawing, 0, e, Typid);
		this.add_spannschlossHaenger(hndDrawing, 0, e-H, Emass);
		
		if (TypVor == "ZRM")
		{
			this.add_ZMM(hndDrawing, 0, e + 0.9*d, d);
		};
		
		retObj.xMassTop = D/2;
		retObj.xMassBottom = 0;
		retObj.xWidthLeft = D/2;
        retObj.xWidthRight = D/2;
		retObj.xDist = D/2;
        retObj.yDist = -A/2;
        retObj.L_PosNr = d;
		retObj.index = 1;
		
	},
	
	insertFHS2D : function(hndDrawing, Typid, Rotation, Emass, threeDparams, retObj, cadMacroParamObject)	//FHS
	{
		var s = cad_getdouble("S");							// Dicke Fussplatte
		var B = cad_getdouble("B");							// B aus Katalog
		var A = cad_getdouble("A");							// Gehaeusehoehe
		var D = cad_getdouble("D");							// Gehaeusedurchmesser
		var d = cad_getdouble("D_");						// LGV
		var m = cad_getdouble("M");							// Fussplattenbeite
		var D1 = cad_getdouble("D1");						// Rohrdurchmesser
		var s_Vor = double(threeDparams["Vorspannweg0"]);	// Vorspannweg
		
		var TypNach = cadMacroParamObject.stkListNextPart;
		var TypVor = cadMacroParamObject.stkListPrevPart;
		
		// Koerperkanten
		cad_add_rect(hndDrawing, -D/2, s, D/2, A, 7);
		cad_add_rect(hndDrawing, -m/2, 0, m/2, s, 7);
		cad_add_rect(hndDrawing, -D1/2, A, D1/2, (A + B - s_Vor), 7);
		
		// Ausbrennen
		cad_add_rect(hndDrawing, -D/2, s, D/2, A, 254);
		cad_add_rect(hndDrawing, -m/2, 0, m/2, s, 254);
		cad_add_rect(hndDrawing, -D1/2, A, D1/2, (A + B - s_Vor), 254);
		
		// Muttern in LK
		if (TypNach == "ZRM")
		{
			this.add_ZMM(hndDrawing, 0, A + B -s_Vor + 0.9*d, d);
			this.add_ZMM(hndDrawing, 0, A + B -s_Vor + 1.8*d, d);
		};
		
		retObj.xMassTop = d/2;
		retObj.xMassBottom = m/2;
		retObj.xWidthLeft = m/2;
        retObj.xWidthRight = m/2;
		retObj.xDist = D/2;
        retObj.yDist = A/2;
        retObj.L_PosNr = d;
		retObj.index = 1;
		
	},
	
	add_ZMM : function(hndDrawing, dx, dy, M)	//Mutter
	{
		var h = 0.9*M;
		
		cad_add_rect (hndDrawing, dx-M, dy-h, dx+M, dy, 7);
		cad_add_rect (hndDrawing, dx-M, dy-h, dx+M, dy, 254);
		cad_add_line (hndDrawing, dx-2*M/3, dy-h, dx-2*M/3, dy, 7);
		cad_add_line (hndDrawing, dx+2*M/3, dy-h, dx+2*M/3, dy, 7);
	},
	
	add_HV_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
	{
		/*
		factorSN = Skalierfactor fuer Schweissnaht
		dx = Versatz in x-Richtung
		dy = Versatz in y-Richtung
		TH = Texthoehe
		lt = Linientyp
		seite = SN am oberen Ende der LK: seite = 1; unteres Ende: seite = (-1); 
		*/
		
		// HV-Naht Symbol
		cad_add_line (hndDrawing, dx, dy, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(3*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(2.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(2.5*TH)*factorSN, dy+(2.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(2.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(3*TH)*factorSN, dy+(2.5*TH)*seite*factorSN, lt);
		// Faehnchen
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_circle (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, TH/4*factorSN, lt);
	},
	
	add_K_Naht : function(hndDrawing, factorSN, dx, dy, TH, seite, lt)
	{
		/*
		factorSN = Skalierfactor fuer Schweissnaht
		dx = Versatz in x-Richtung
		dy = Versatz in y-Richtung
		TH = Texthoehe
		lt = Linientyp
		seite = SN am oberen Ende der LK: seite = 1; unteres Ende: seite = (-1); 
		*/
		
		// K-Naht Symbol
		cad_add_line (hndDrawing, dx, dy, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(3*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(2.5*TH)*factorSN, dy+(0.5*TH)*seite*factorSN, dx+(2.5*TH)*factorSN, dy+(2.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(2.5*TH)*factorSN, dy+(TH)*seite*factorSN, dx+(3*TH)*factorSN, dy+(0.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(2.5*TH)*factorSN, dy+(2*TH)*seite*factorSN, dx+(3*TH)*factorSN, dy+(2.5*TH)*seite*factorSN, lt);
		// Faehnchen
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_circle (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, TH/4*factorSN, lt);
	},
	
	add_Kehlnaht : function(hndDrawing, factorSN, dx, dy, TH, seite, a, lt)
	{
		/*
		factorSN = Skalierfactor fuer Schweissnaht
		dx = Versatz in x-Richtung
		dy = Versatz in y-Richtung
		TH = Texthoehe
		lt = Linientyp
		seite = SN am oberen Ende der LK: seite = 1; unteres Ende: seite = (-1);
		a = Groesse der Kehlnaht
		*/
		
		// Kehlaht Symbol
		cad_add_line (hndDrawing, dx, dy, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(4.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, lt);
		cad_add_line (hndDrawing, dx+(3.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(3.5*TH)*factorSN, dy+((1.5*TH)*seite+0.5*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(4*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(3.5*TH)*factorSN, dy+((1.5*TH)*seite+0.5*TH)*factorSN, lt);
		cad_add_text (hndDrawing, dx+(2.5*TH)*factorSN, dy+((1.5*TH)*seite+0.1*TH)*factorSN, 0, TH*factorSN, a, lt);
		// Faehnchen
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+1.5*TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_line (hndDrawing, dx+(1.5*TH)*factorSN, dy+((1.5*TH)*seite+TH)*factorSN, dx+(2*TH)*factorSN, dy+((1.5*TH)*seite+1.25*TH)*factorSN, lt);
		cad_add_circle (hndDrawing, dx+(1.5*TH)*factorSN, dy+(1.5*TH)*seite*factorSN, TH/4*factorSN, lt);
	},
	
	add_KH_KS_FP : function(hndDrawing, t, e, u, m, n, k, o, p, sN, sVOR, gbx, G, d, l, LGV, LGR, Typid)	//FH_FS-Fussplatte
	{
		/*
		t = 1. Abstand Bohrungsmittelpunkte
		e = KHS: Aussenkante FP bis Mitte Bohrung; KVS: Mitte FSR bis Mitte Bohrung
		u = 2. Abstand Bohrungsmittelpunkte
		n = Breite FP
		k = Bohrungsdurchmesser
		o = Breite Freimachung
		p = Tiefe Freimachung
		gbx = Gehaeseabmessung (bei KVS gpx)
		LGV = Lastgruppe
		LGR = Lastgroesse
		*/
		
		var strSQLStatement = "select * from KHPARALLELOGRAMM where LGR="+LGR+" and SN="+sN+" ";
		var numRet = dbselect("CASCADE", strSQLStatement, "KHPARALLELOGRAMM");
		if (mumRet == 0)
		{
			var dx_Para = 0;
		}
		else
		{
			var dx_Para = (dbgetdouble("KHPARALLELOGRAMM", "b1_Para") - dbgetdouble("KHPARALLELOGRAMM", "R4_Para"));
		}
		
		switch (Typid)
		{
			case "KHS":
				var X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gbx);
				cad_begin_poly (hndDrawing, 0, 7)
					cad_add_vertex (hndDrawing, (X_real-2*e-t+p-o/2), o/2);
					cad_add_vertex (hndDrawing, (X_real-2*e-t), o/2);
					cad_add_vertex (hndDrawing, (X_real-2*e-t), n/2);
					cad_add_vertex (hndDrawing, X_real, n/2);
					cad_add_vertex (hndDrawing, X_real, -n/2);
					cad_add_vertex (hndDrawing, X_real, -n/2);
					cad_add_vertex (hndDrawing, (X_real-2*e-t), -n/2);
					cad_add_vertex (hndDrawing, (X_real-2*e-t), -o/2);
					cad_add_vertex (hndDrawing, (X_real-2*e-t+p-o/2), -o/2);
				cad_end_poly (hndDrawing);
				cad_add_arc (hndDrawing, (X_real-2*e-t+p-o/2), 0, o/2, 270, 90, 7);
				cad_add_circle (hndDrawing, 0, 0, LGV/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), -u/2, k/2, 7);
				// Mittellinien
				var lt_mitte = 1;
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, LGV, LGV, 0, 0, lt_mitte);
				break;
			
			case "KVS":
				
				if (LGR > 17)
				{
					gbx = G + 217.3;
				}
				
				var X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gbx - G + dx_Para);
				cad_begin_poly (hndDrawing, 0, 7)
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2+p-o/2), o/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2), o/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2), n/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2+m), n/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2+m), -n/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2), -n/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2), -o/2);
					cad_add_vertex (hndDrawing, (X_real-e-(m-t)/2+p-o/2), -o/2);
				cad_end_poly (hndDrawing);
				cad_add_arc (hndDrawing, (X_real-e-(m-t)/2+p-o/2), 0, o/2, 270, 90, 7);
				cad_add_circle (hndDrawing, 0, 0, LGV/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e+t), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e+t), -u/2, k/2, 7);
				// Achsen FSR
				cad_add_line (hndDrawing, (X_real-o/2), 0, (X_real+o/2), 0, 1);
				cad_add_line (hndDrawing, X_real, o/2, X_real, -o/2, 1);
				// Mittellinien
				var lt_mitte = 1;
				this.add_Kreuz(hndDrawing, k, k, X_real-e, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e+t, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e+t, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, LGV, LGV, 0, 0, lt_mitte);
				break;
			
			case "KSR":
				var betha = 30-asindeg((sN/2-sVOR)/sN);						// Vorspannwinkel
				var X_real = sN*cosdeg(30-betha) + gbx;
				cad_add_rect (hndDrawing, (X_real-2*e-t), (-n/2), X_real, n/2, 7);
				cad_add_rect (hndDrawing, (-d/2), (-l/2), d/2, l/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), u/2, k/2, 7);
				// Mittellinien
				var lt_mitte = 1;
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, u/2, lt_mitte);
				cad_add_line (hndDrawing, 0, -l/2, 0, l/2, lt_mitte);
				break;
			
			case "KSP":
				var betha = 30-asindeg((sN/2-sVOR)/sN);						// Vorspannwinkel
				var X_real = sN*cosdeg(30-betha) + gbx;
				cad_add_rect (hndDrawing, (X_real-2*e-t), (-n/2), X_real, n/2, 7);
				cad_add_circle (hndDrawing, 0, 0, p/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), -u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e), u/2, k/2, 7);
				cad_add_circle (hndDrawing, (X_real-e-t), u/2, k/2, 7);
				// Mittellinien
				var lt_mitte = 1;
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e-t, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, -u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, k, k, X_real-e, u/2, lt_mitte);
				this.add_Kreuz(hndDrawing, p, p, 0, 0, lt_mitte);
				break;
			
			default:
				break;
		}
	},
	
	add_FH_FS_FP : function(hndDrawing, m, t, k, D, LGV, Typid)	//FH_FS-Fussplatte
	{
		/*
		m = FP-Breite
		t = Abstand Bohrungsmittelpunkte
		k = Spaltbreite
		D = Gehaeusedurchmesser
		LGV = Lastgruppe
		*/
		var dx = 0;									// Versatz in x-Richtung
		var dy = 0;									// Versatz in y-Richtung
		
		var diff = (k/2)/sqrt(2);
		
		if (LGV < 48)
		{
			var dFP = D;							// Groesse der Bohrung
		}
		else
		{
			var dFP = 2*LGV;						// Groesse der Bohrung
		}
		
		if ((Typid != "FSS") && (Typid != "FSP"))
		{
		cad_add_circle(hndDrawing, dx, dy, dFP/2, 7);
		}
		cad_begin_poly(hndDrawing, 0, 7);
			cad_add_vertex (hndDrawing, dx+(-t/2+diff), dy+(-t/2-diff));
			cad_add_vertex (hndDrawing, dx+(-m/2+2*diff), dy-m/2);
			cad_add_vertex (hndDrawing, dx+(m/2-2*diff), dy-m/2);
			cad_add_vertex (hndDrawing, dx+(t/2-diff), dy+(-t/2-diff));
		cad_end_poly (hndDrawing);
		cad_begin_poly (hndDrawing, 0, 7);
			cad_add_vertex (hndDrawing, dx+(t/2+diff), dy+(-t/2+diff));
			cad_add_vertex (hndDrawing, dx+m/2, dy+(-m/2+2*diff));
			cad_add_vertex (hndDrawing, dx+m/2, dy+(m/2-2*diff));
			cad_add_vertex (hndDrawing, dx+(t/2+diff), dy+(t/2-diff));
		cad_end_poly (hndDrawing);
		cad_begin_poly(hndDrawing, 0, 7);
			cad_add_vertex (hndDrawing, dx+(-t/2+diff), dy+(t/2+diff));
			cad_add_vertex (hndDrawing, dx+(-m/2+2*diff), dy+m/2);
			cad_add_vertex (hndDrawing, dx+(m/2-2*diff), dy+m/2);
			cad_add_vertex (hndDrawing, dx+(t/2-diff), dy+(t/2+diff));
		cad_end_poly (hndDrawing);
		cad_begin_poly (hndDrawing, 0, 7);
			cad_add_vertex (hndDrawing, dx+(-t/2-diff), dy+(-t/2+diff));
			cad_add_vertex (hndDrawing, dx-m/2, dy+(-m/2+2*diff));
			cad_add_vertex (hndDrawing, dx-m/2, dy+(m/2-2*diff));
			cad_add_vertex (hndDrawing, dx+(-t/2-diff), dy+(t/2-diff));
		cad_end_poly (hndDrawing);
		cad_add_arc (hndDrawing, dx+t/2, dy+t/2, k/2, 135, 315, 7);
		cad_add_arc (hndDrawing, dx-t/2, dy+t/2, k/2, 225, 45, 7);
		cad_add_arc (hndDrawing, dx-t/2, dy-t/2, k/2, 315, 135, 7);
		cad_add_arc (hndDrawing, dx+t/2, dy-t/2, k/2, 45, 225, 7);
		
		// Mittellinien
		var lt_mitte = 1;
		this.add_Kreuz(hndDrawing, k, k, -t/2, -t/2, lt_mitte);
		this.add_Kreuz(hndDrawing, k, k, -t/2, t/2, lt_mitte);
		this.add_Kreuz(hndDrawing, k, k, t/2, -t/2, lt_mitte);
		this.add_Kreuz(hndDrawing, k, k, t/2, t/2, lt_mitte);
		this.add_Kreuz(hndDrawing, m, m, 0, 0, lt_mitte);
	},
	
	add_Kreuz : function(hndDrawing, lx, ly, dx, dy, lt)		// Linienkreuz
	{
		/*
			lx	Laenge in x-Richtung
			ly	Laenge in y-Richtung
			dx	Versatz in x-Richtung
			dy	Versatz in y-Richtung
			lt	Linientyp
		*/
		cad_add_line (hndDrawing, -lx/2+dx, dy, lx/2+dx, dy, lt);
		cad_add_line (hndDrawing, dx, -ly/2+dy, dx, ly/2+dy, lt);
	},
	
	// -mw- NEU: separate Funktion, um die Bemassungen in die Fussplatte einzubauen:
	add_FH_FS_FP_MASSE : function(hndLayout, m, t, k, D, LGV)	// FH_FS-Fussplatte
	{
        var TH = m/11;	// Texthoehe @@@ Hr. Schubert, die mssten Sie berechnen !
        var TW = 0.75;  // Textbreite, kann so bleiben
        cad_set_dimtextheight(hndLayout, TH);
        cad_set_dimtextwidth(hndLayout, TW);

        /* Fr Horizontalbemaung:
            x1, y1: Koordinaten des Ansatzpunktes der linken Hilfslinie
            x2, y2: Koordinaten des Ansatzpunktes der rechten Hilfslinie
            x3, y3: Koordinaten des Ansatzpunktes der rechen Malinie an der Hilfslinie
           Fr Vertikalbemaung:
            x1
            y1
            x2 = x1
            y2 = -y1
            x3 > x1, x2
            y3 = y2
        */
        var diff = (k/2)/sqrt(2);
		
		// Fussplattenbeite
		var x11 = -m/2+2*diff;
        var y11 = m/2;
        var x21 = x11;
        var y21 = -y11;
        var x31 = -m/2-3.5*TH;
        var y31 = y21;
        var tn1 = m;         	// Angezeigter Masstext
        var nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
        var ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x11, y11, x21, y21, x31, y31, tn1);
		
		// Bohrungsabstand
		var x12 = -t/2;
        var y12 = t/2;
        var x22 = x12;
        var y22 = -y12;
        var x32 = -m/2-TH;
        var y32 = y22;
        var tn2 = t;         	// Angezeigter Masstext
        var nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
        var ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x12, y12, x22, y22, x32, y32, tn2);
		
		// Spaltbreite
		var x13 = m/2;
        var y13 = (-m/2+2*diff);
        var x23 = (m/2-2*diff);
        var y23 = -m/2;
		var x33 = (m/2-2*diff+(2.5*TH*cosdeg(45)));
        var y33 = -m/2-(2.5*TH*sindeg(45));
        var tn3 = k;         	// Angezeigter Masstext
        var nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
        var ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x13, y13, x23, y23, x33, y33, tn3);
		
    },
	
	add_KH_KS_FP_MASSE : function(hndLayout, t, e, u, m, n, k, o, p, sN, sVOR, gbx, G, d, l, LGV, LGR, Typid)	//KH_KS-Fussplatte
	{
		var TH = t/9;
        var TW = 0.75;
        cad_set_dimtextheight(hndLayout, TH);
        cad_set_dimtextwidth(hndLayout, TW);
		var x1, x2, x3, y1, y2, y3, tn, nDimTextType, ret;
		
		 /* Fr Horizontalbemaung:
            x1, y1: Koordinaten des Ansatzpunktes der linken Hilfslinie
            x2, y2: Koordinaten des Ansatzpunktes der rechten Hilfslinie
            x3, y3: Koordinaten des Ansatzpunktes der rechen Malinie an der Hilfslinie
           Fr Vertikalbemaung:
            x1
            y1
            x2 = x1
            y2 = -y1
            x3 > x1, x2
            y3 = y2
        */
		
		switch (Typid)
		{
			case "KSP":
			case "KSR":
			case "KHS":
				var X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gbx);
				if (Typid == "KHS")
				{
					// Tiefe der Freimachung
					x1 = X_real-2*e-t;
					y1 = -n/2;
					x2 = (X_real-2*e-t+p);
					y2 = 0;
					x3 = (X_real-2*e-t+p);
					y3 = (-n/2-2*TH);
					tn = p;         	// Angezeigter Masstext
					nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
					ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
					// Breite Freimachung
					x1 = X_real-2*e-t;
					y1 = o/2;
					x2 = x1;
					y2 = -y1;
					x3 = X_real-2*e-t-TH;
					y3 = y2;
					tn = o;         	// Angezeigter Masstext
					nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
					ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				}
				// Groesse Bohrung
				x1 = X_real-e-k/2;
				y1 = -u/2;
				x2 = X_real-e+k/2;
				y2 = -u/2;
				x3 = X_real-e+k/2;
				y3 = (-n/2-4*TH);
				tn = k;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Abstand Aussenkante zu 1. Bohrung
				x1 = X_real-e;
				y1 = u/2;
				x2 = X_real;
				y2 = n/2;
				x3 = X_real;
				y3 = n/2+TH;
				tn = e;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Bohrungsabstand t
				x1 = X_real-e-t;
				y1 = u/2;
				x2 = X_real-e;
				y2 = u/2;
				x3 = X_real-e;
				y3 = n/2+TH;
				tn = t;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Bohrungsabstand u
				x1 = X_real-e;
				y1 = u/2;
				x2 = x1;
				y2 = -y1;
				x3 = X_real+2*TH;
				y3 = y2;
				tn = u;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Breite FP
				x1 = X_real;
				y1 = n/2;
				x2 = x1;
				y2 = -y1;
				x3 = X_real+4*TH;
				y3 = y2;
				tn = n;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// X-Mass
				x1 = 0;
				y1 = 0;
				x2 = X_real;
				y2 = o/2;
				x3 = X_real;
				y3 = o/2+TH/2;
				tn = int(X_real);  	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				break;
				
			case "KVS":
				
				if (LGR > 17)
				{
					gbx = G + 217.3;
				}
				
				var strSQLStatement = "select * from KHPARALLELOGRAMM where LGR="+LGR+" and SN="+sN+" ";
				var numRet = dbselect("CASCADE", strSQLStatement, "KHPARALLELOGRAMM");
				if (mumRet == 0)
				{
					var dx_Para = 0;
				}
				else
				{
					var dx_Para = (dbgetdouble("KHPARALLELOGRAMM", "b1_Para") - dbgetdouble("KHPARALLELOGRAMM", "R4_Para"));
				}
				
				var X_real = (sN*cosdeg(asindeg((sN/2-sVOR)/sN)) + gbx - G +dx_Para);
				// Tiefe der Freimachung
				x1 = X_real-e-(m-t)/2;
				y1 = -n/2;
				x2 = X_real-e-(m-t)/2+p;
				y2 = 0;
				x3 = X_real-e-(m-t)/2+p;
				y3 = (-n/2-2*TH);
				tn = p;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Groesse Bohrung
				x1 = X_real-e+t-k/2;
				y1 = -u/2;
				x2 = X_real-e+t+k/2;
				y2 = -u/2;
				x3 = X_real-e+t+k/2;
				y3 = (-n/2-2*TH);
				tn = k;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Plattenlaenge m
				x1 = X_real-e-(m-t)/2;
				y1 = -n/2;
				x2 = X_real-e-(m-t)/2+m;
				y2 = -n/2;
				x3 = X_real-e-(m-t)/2+m;
				y3 = -n/2-4*TH;
				tn = m;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Bohrungsabstand t
				x1 = X_real-e;
				y1 = u/2;
				x2 = X_real-e+t;
				y2 = u/2;
				x3 = X_real-e+t;
				y3 = n/2+5*TH;
				tn = t;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Abstand FSR (Mitte) zu Bohrung
				x1 = X_real-e;
				y1 = u/2;
				x2 = X_real;
				y2 = o/2;
				x3 = X_real;
				y3 = n/2+3*TH;
				tn = e;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Abstand FSR (Mitte) zu Gewindestange (X-Mass)
				x1 = 0;
				y1 = 0;
				x2 = X_real;
				y2 = o/2;
				x3 = X_real;
				y3 = n/2+TH;
				tn = int(X_real);  	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Bohrungsabstand u
				x1 = X_real-e+t;
				y1 = u/2;
				x2 = x1;
				y2 = -y1;
				x3 = X_real-e+t+(m-t)/2+2*TH;
				y3 = y2;
				tn = u;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Breite FP
				x1 = X_real-e+t+(m-t)/2;
				y1 = n/2;
				x2 = x1;
				y2 = -y1;
				x3 = X_real-e+t+(m-t)/2+4*TH;
				y3 = y2;
				tn = n;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				// Breite Freimachung
				x1 = X_real-e-(m-t)/2;
				y1 = o/2;
				x2 = x1;
				y2 = -y1;
				x3 = X_real-e-(m-t)/2-TH;
				y3 = y2;
				tn = o;         	// Angezeigter Masstext
				nDimTextType = 0;   // Normale Bemassung (ohne Unterstrich)
				ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, x1, y1, x2, y2, x3, y3, tn);
				break;
				
			default:
				break;
		}

	},

    add_haengerGehause : function(hndDrawing, x, y, Typid, LGV)
    {
        var H = cad_getdouble("H");			// Gehaeusehoehe
        var D = cad_getdouble("D");			// Gehaeusedurchmesser
		var b = cad_getdouble("B_");		// Laschenbreite (anders verwendet)
        
        cad_add_rounded_rect(hndDrawing, x-D/2, y, x+D/2, y-H, b/4, 7);
		cad_add_rounded_rect(hndDrawing, x-D/2, y, x+D/2, y-H, b/4, 254);
		if (LGV > 42)
		{
			cad_add_line (hndDrawing, x-D/2, y-b, x+D/2, y-b, 7);
			cad_add_line (hndDrawing, x-D/2, y-H+b, x+D/2, y-H+b, 7);
		}
    },

    add_lascheHaenger : function(hndDrawing, x, y, hl, Rotation, TypVor)
    {
        var R = cad_getdouble("R");			// Bolzenmitte bis Laschenoberkante (r)
        var C = cad_getdouble("C");			// Bolzenduchmesser
        var bl = 3 * C;						// Bolzenlaenge
		var b = cad_getdouble ("B_");		// Laschendicke
		var a = cad_getdouble ("A_");		// Abstand Laschen
        
        if ((Rotation == 90) || (Rotation == 270)) // Ansicht 1
        {
            cad_add_rect(hndDrawing, x-bl/2, y, x+bl/2, y+hl, 7);
			cad_add_rect(hndDrawing, x-bl/2, y, x+bl/2, y+hl, 254);
            
			cad_add_circle(hndDrawing, x, y+hl-R, C/2, 7);
        }
        else // Ansicht 2
        {
			cad_add_rect(hndDrawing, x-a/2-b, y, x-a/2, y+hl, 7);
			cad_add_rect(hndDrawing, x+a/2, y, x+a/2+b, y+hl, 7);
			cad_add_rect(hndDrawing, x-a/2-2*b, y+hl-R-C/2, x-a/2-b, y+hl-R+C/2, 7);
			cad_add_rect(hndDrawing, x-a/2, y+hl-R-C/2, x+a/2, y+hl-R+C/2, 7);
			cad_add_rect(hndDrawing, x+a/2+b, y+hl-R-C/2, x+a/2+2*b, y+hl-R+C/2, 7);
        }
    },

    add_spannschlossHaenger : function(hndDrawing, x, y, EmassHaenger, TypNach)
    {
		var LG = cad_getint("LASTGR");
        var myLGV = this.add_FH_LG_LGV(hndDrawing, LG);
        // Daten Spannschloss
		var strSQLStatement = "select * from ZSM where LGV="+myLGV+" ";
        var numRet = dbselect("CASCADE", strSQLStatement, "ZSM");   // ZSM = Arbeitsbereich, in den Ergebnisse geschrieben werden
		
		if (numRet <= 0)
        {
            alert("Fehler in Makro Spannschloss!!!");
            return;
        }
        
		var A = dbgetdouble("ZSM", "A");
        var H = dbgetdouble("ZSM", "H");
        var E = cad_getdouble("E");			// E aus Katalog
        var B = cad_getdouble("B");			// B aus Katalog
		var t = (A / 1.6);					// Kopfhoehe (Naeherung)
		var e1 = (LGV + 4);					// Spaltbreite (Naeherung)
		
        var hs = B + (EmassHaenger - E);	// dargestellte Hoehe des Spannschlosses
        
		var y1 = 0;
		
		if ((hs-H+t) < 0)
		{
			y1 = y;
		}
		else
		{
			y1 = (y-hs+H-t);
		}
		
		// Koerperkanten
		cad_add_rect(hndDrawing, x+A/2, y, x-A/2, y-hs, 7);
		cad_add_rect(hndDrawing, x+e1/2, y1, x-e1/2, (y-hs+t), 7);
		// Ausbrennen
		cad_add_rect(hndDrawing, x+A/2, y, x-A/2, y-hs, 254);
		cad_add_rect(hndDrawing, x+e1/2, y1, x-e1/2, (y-hs+t), 254);
		
		if (TypNach != "")
		{
			this.add_ZMM(hndDrawing, 0, y-hs, myLGV);
		}
    },
	
	add_FH_LG_LGV : function(hndDrawing, LG)	// Zuordnung LGV zu Lastgroesse
	{
		switch (LG)
		{
			case 6:
				LGV = 16;
				break;
			case 7:
				LGV = 20;
				break;
			case 8:
				LGV = 24;
				break;
			case 9:
				LGV = 30;
				break;
			case 10:
				LGV = 36;
				break;
			case 11:
				LGV = 42;
				break;
			case 12:
				LGV = 48;
				break;
			case 13:
				LGV = 64;
				break;
			case 14:
				LGV = 72;
				break;
			case 15:
				LGV = 80;
				break;
			case 16:
				LGV = 90;
				break;
			default: LGV = 12;
		}
		return LGV;
	},
	
	add_HZx_H : function(hndDrawing, A, dA, s, b, rot, dx, dy, daemmDicke, rohr, daemm)	// Zweilochschellenhaelfte
	{
		// A	Aussenabmass der Schelle
		// dA	Rohraussendurchmesser
		// s	Schellenwanddicke
		// b	Abstand der Schellenhaelften
		// rot	Ausrichtung der Schellenhaelfte
		// dx	Versatz der Schellenhaelfte in x-Richtung
		// dy	Versatz der Schellenhaelfte in y-Richtung
		
		var alpha1 = asindeg ((b/2) / (dA/2));			// Beginn des inneren Radius
		var alpha2 = asindeg ((b/2 + s) / (dA/2 + s));	// Beginn des aeusseren Radius
		var l1 = dA/2 * cosdeg (alpha1);				// Abstand Rohrmitte zu Beginn innerer Radius
		var l2 = (dA/2 + s) * cosdeg (alpha2);			// Abstand Rohrmitte zu Beginn aeusserer Radius
		
		// Linientypen
		var colRohr = 5;		// Rohr: blau
		var colMLinie = 1;		// Mittellinien: rot
		var colDaemm = 5; 		// Daemmung: blau
		
		// var daemmDicke = config_getdouble("LAGER_BETRIEBSBEDINGUNGEN.IDC_DAEMMDICKE");
		// var daemmDicke = config_getdouble("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE");
		
		if (rot == 0)	// Schellenbauch zeigt nach oben
		{
			cad_add_line (hndDrawing, (-l2 + dx), (b/2 + s + dy), (-A/2 + dx), (b/2 + s + dy), 7);
			cad_add_line (hndDrawing, (-A/2+ dx), (b/2 + s+ dy), (-A/2+ dx), (b/2+ dy), 7);
			cad_add_line (hndDrawing, (-A/2+ dx), (b/2+ dy), (-l1+ dx), (b/2+ dy), 7);
			cad_add_arc (hndDrawing, dx, dy, dA/2, alpha1, (180 - alpha1), 7);
			cad_add_line (hndDrawing, (l1+ dx), (b/2+ dy), (A/2+ dx), (b/2+ dy), 7);
			cad_add_line (hndDrawing, (A/2+ dx), (b/2+ dy), (A/2+ dx), (b/2 + s+ dy), 7);
			cad_add_line (hndDrawing, (A/2+ dx), (b/2 + s+ dy), (l2+ dx), (b/2 + s+ dy), 7);
			cad_add_arc (hndDrawing, dx, dy, (dA/2 + s), alpha2, (180 - alpha2), 7);
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2, 0, 180, colRohr);		
				cad_add_arc(hndDrawing, dx + dA/4, dy, dA/4, 0, 180, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 0, 180, colDaemm);		
			}
			// Mittellinien fr 0 und 180
			cad_add_line(hndDrawing, dx+A/2+s/2, dy, dx-A/2-s/2, dy, colMLinie);
			cad_add_line(hndDrawing, dx, dy-1.5*s - dA/2, dx, dy+1.5*s + dA/2, colMLinie);
		}
		
		if (rot == 180)	// Schellenbauch zeigt nach unten
		{
			cad_add_line (hndDrawing, (-l2+ dx), -(b/2 + s)+ dy, (-A/2+ dx), -(b/2 + s)+ dy, 7);
			cad_add_line (hndDrawing, (-A/2+ dx), -(b/2 + s)+ dy, (-A/2+ dx), (-b/2+ dy), 7);
			cad_add_line (hndDrawing, (-A/2+ dx), (-b/2 + dy), (-l1+ dx), (-b/2+ dy), 7);
			cad_add_arc (hndDrawing, dx, dy, dA/2, (180 + alpha1), -alpha1, 7);
			cad_add_line (hndDrawing, (l1+ dx), (-b/2+ dy), (A/2+ dx), (-b/2+ dy), 7);
			cad_add_line (hndDrawing, (A/2+ dx), (-b/2+ dy), (A/2+ dx), -(b/2 + s) + dy, 7);
			cad_add_line (hndDrawing, (A/2+ dx), -(b/2 + s) + dy, (l2+ dx), -(b/2 + s) + dy, 7);
			cad_add_arc (hndDrawing, dx, dy, (dA/2 + s), (180 + alpha2), -alpha2, 7);
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2, 180, 0, colRohr);		
				cad_add_arc(hndDrawing, dx - dA/4, dy, dA/4, 180, 0, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 180, 0, colDaemm);
			}
		}
		
		if (rot == 90)	// Schellenbauch zeigt nach rechts
		{
			cad_add_line (hndDrawing, (b/2 + s + dx), (-l2 + dy), (b/2 + s + dx), (-A/2 + dy), 7);
			cad_add_line (hndDrawing, (b/2 + s + dx), (-A/2 + dy), (b/2 + dx), (-A/2 + dy), 7);
			cad_add_line (hndDrawing, (b/2 + dx), (-A/2 + dy), (b/2 + dx), (-l1 + dy), 7);
			cad_add_arc (hndDrawing, dx, dy, dA/2, (270 + alpha1), (90 - alpha1), 7);
			cad_add_line (hndDrawing, (b/2 + dx), (l1 + dy), (b/2 + dx), (A/2 + dy), 7);
			cad_add_line (hndDrawing, (b/2 + dx), (A/2 + dy), (b/2 + s + dx), (A/2 + dy), 7);
			cad_add_line (hndDrawing, (b/2 + s + dx), (A/2 + dy), (b/2 + s + dx), (l2 + dy), 7);
			cad_add_arc (hndDrawing, dx, dy, (dA/2 + s), (270 + alpha2), (90 - alpha2), 7);
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2, 0, 180, colRohr);		
				cad_add_arc(hndDrawing, dx, dy + dA/4, dA/4, 90, 270, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 0, 180, colDaemm);		
			}
			// Mittellinien fr 90 und 270
			cad_add_line(hndDrawing, dx, dy+A/2+s/2 , dx, dy-A/2-s/2, colMLinie);
			cad_add_line(hndDrawing, dx-1.5*s - dA/2, dy, dx+1.5*s + dA/2, dy, colMLinie);
		}
		
		if (rot == 270)	// Schellenbauch zeigt nach links
		{
			cad_add_line (hndDrawing, -(b/2 + s) + dx, (-l2 + dy), -(b/2 + s) + dx, (-A/2 + dy), 7);
			cad_add_line (hndDrawing, -(b/2 + s) + dx, (-A/2 + dy), (-b/2 + dx), (-A/2 + dy), 7);
			cad_add_line (hndDrawing, (-b/2 + dx), (-A/2 + dy), (-b/2 + dx), (-l1 + dy), 7);
			cad_add_arc (hndDrawing, dx, dy, dA/2, (90 + alpha1), (270 - alpha1), 7);
			cad_add_line (hndDrawing, (-b/2 + dx), (l1 + dy), (-b/2 + dx), (A/2 + dy), 7);
			cad_add_line (hndDrawing, (-b/2 + dx), (A/2 + dy), -(b/2 + s) + dx, (A/2 + dy), 7);
			cad_add_line (hndDrawing, -(b/2 + s) + dx, (A/2 + dy), -(b/2 + s) + dx, (l2 + dy), 7);
			cad_add_arc (hndDrawing, dx, dy, (dA/2 + s), (90 + alpha2), (270 - alpha2), 7);
			// Rohr
			if (rohr == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2, 180, 0, colRohr);		
				cad_add_arc(hndDrawing, dx, dy - dA/4, dA/4, 270, 90, colRohr);
			}
			// Daemmung
			if (daemm == "true")
			{
				cad_add_arc (hndDrawing, dx, dy, dA/2 + daemmDicke , 180, 0, colRohr);
			}
		}
	}
}