/**
 * UebersichtLastketteController
 */
UebersichtLastketteController = function() {
	UebersichtLastketteController.superclass.constructor.call(this);
}

EasyKat.extend( UebersichtLastketteController, CustomController,
{
	getStuecklisteAction : function()
	{
		if (getstring("STEELPARTS", "DLGDATA.CA.FINDATA") == 'todo')
		{
			// Stahlbauteile ergnzen
			// var x = caMainController.topologieKlasse;
			var finData = Object.fromStorage( "DLGDATA.CA.FINDATA.FINOBJECT");
			if (finData.sec_steel && finData.sec_steel.aSteeldata &&
				(finData.sec_steel.aSteeldata.length > 0))  {
				for (var i = 0; i < finData.sec_steel.aSteeldata.length; ++i) {
					SonderteilassiController.addStahlbauSonderteil(finData.sec_steel.aSteeldata[i], false)
				}				
			}
			setstring("STEELPARTS", "DLGDATA.CA.FINDATA", "")
		}
		// ----------------------------------------------------------------------------
		if (getstring ("COPYED_FLAG", "DLGDATA") == "true"){
			setstring ("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", "0");
			setstring ("IDC_EXTRAMARKIERUNG", "DLGDATA.CA.FORMS.EXTRAMARKIERUNG", "");
			setstring ("COPYED_FLAG", "DLGDATA", "false")
		}
		// ----------------------------------------------------------------------------
		
		var stkList = caMainController.topologieKlasse.getStuecklisteForDisplay(caMainController.presets.getPreisOptions(), caMainController);
        delete("IDC_STUECKLISTE", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE");

		echo stkList.toJSON();
	},

	getValuesAction : function()
    {
        var strBasepath = "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE";
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				IDC_ANLAGEN_POS_NR: getstring("IDC_ANLAGEN_POS_NR", strBasepath),
				IDC_ZEICHNUNGS_NR: getstring("IDC_ZEICHNUNGS_NR", strBasepath),
				IDC_BEMERKUNGEN: getstring("IDC_BEMERKUNGEN", strBasepath),
				IDC_ANFRAGEPOS: getstring("IDC_ANFRAGEPOS", strBasepath),
			},

			disabled: [
			]
		};

		echo response.toJSON();
	},

    deleteStklistItemAction : function()
    {
        var index = getdlgvar('index');
		caMainController.topologieKlasse.deleteStklistItem(index);
    },

	drehDichAction : function()
	{
        var strDrehteil = getdlgvar('drehteil');
		caMainController.topologieKlasse.setDrehung(strDrehteil);
	},
	
	// Just here to look inside the data
	setValuesAction : function()
	{
		var form = Object.fromStorage( "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE" );
		var tableData = EasyKat.decode(HttpRequest.get('IDC_STUECKLISTE'));
		
		//var table = form.IDC_STUECKLISTE;
		//caMainController.topologieKlasse.setStuecklistenDatenFromDisplay(table);
		caMainController.topologieKlasse.setStuecklistenDatenFromDisplay(tableData);

        //alert("Hallo");
        /*
        */
        var response = {
            success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
            validate: {
                message: ''
            }
        };

        echo response.toJSON();
	}
});