/**
 * Cascade Serverseitige Logik fr 3D CAD Optionen
 *
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category  3D CAD
 * @package
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */


/**
 * @constructor
 */
ThreeDCadOptionsController = function() {
	ThreeDCadOptionsController.superclass.constructor.call( this );
}


EasyKat.extend( ThreeDCadOptionsController, CustomController,
{
	/**
		action handler for get-values action to be evoked from ajax <br>
	*/
	getDefaultsAction : function() {

        var data = Object.fromStorage( "DLGDATA.CA.FORMS.THREEDCADOPTIONS" );
        /*
            {
				IDC_OUTQUAL: "SCHNELL",
				IDC_OUTFMT: "PDF",
				IDC_DETAILS: "DREI",
				IDC_STANGEN_GEKUERZT: "true",
				IDC_BEMASSUNG: "true",
				IDC_POSNR: "true",
				IDC_ROHR: "true",
				IDC_DAEMMUNG: "true"
            }
        */
        if (! data.IDC_OUTQUAL)
            // data.IDC_OUTQUAL = "SCHNELL";
			data.IDC_OUTQUAL = "HOCH";			// -mw- 18.6.2012 auf Wunsch Hr. Schubert
        if (! data.IDC_OUTFMT)
            data.IDC_OUTFMT = "PDF";
        if (! data.IDC_DETAILS)
            data.IDC_DETAILS = "DREI";
            
        /** leider liefern nich angehakte Checkboxen nicht false
            sondern Leerstring zurck ...
            ... im SetValues korrigieren
        **/
        if (! data.IDC_STANGEN_GEKUERZT)
            data.IDC_STANGEN_GEKUERZT = "true";
        if (! data.IDC_BEMASSUNG)
            data.IDC_BEMASSUNG = "true";
        if (! data.IDC_POSNR)
            data.IDC_POSNR = "true";
        if (! data.IDC_ROHR)
            data.IDC_ROHR = "true";
        if (! data.IDC_DAEMMUNG)
            data.IDC_DAEMMUNG = "true";
        if (! data.IDC_TRAEGER)
            data.IDC_TRAEGER = "true";
        
		var response = {
			success: true,
			data: data
		};

		echo JSON.stringify(response);
	},

	setValuesAction : function() 
	{
		// Besserer Weg um an Variablen zu kommen
		var data = Object.fromStorage("DLGDATA.CA.FORMS.THREEDCADOPTIONS");

        if (! data)
            data = {};

        if (! data.IDC_STANGEN_GEKUERZT)
            data.IDC_STANGEN_GEKUERZT = "false";
        if (! data.IDC_BEMASSUNG)
            data.IDC_BEMASSUNG = "false";
        if (! data.IDC_POSNR)
            data.IDC_POSNR = "false";
        if (! data.IDC_ROHR)
            data.IDC_ROHR = "false";
        if (! data.IDC_DAEMMUNG)
            data.IDC_DAEMMUNG = "false";
        if (! data.IDC_TRAEGER)
            data.IDC_TRAEGER = "false";
            
        data.toStorage("DLGDATA.CA.FORMS.THREEDCADOPTIONS", false); // kein Merge
	},
	
	getDateObject : function()
    {
        getdate('CURRENT_TIME','TEMP');
        /*	"YEAR"	"MONTH"	"DAY" "HOUR" "MINUTE" "SECOND"
            // Alles auf einmal: YYYYMMDD.HHMMSS
            "TIME"
        */
        var strDate     = getstring('TIME','TEMP.CURRENT_TIME');
        var strTagSAP   = getstring('DAY','TEMP.CURRENT_TIME');
        var strMonatSAP = getstring('MONTH','TEMP.CURRENT_TIME');
        if (strTagSAP.length <= 1)
            strTagSAP = "0" + strTagSAP;
        if (strMonatSAP.length <= 1)
            strMonatSAP = "0" + strMonatSAP;
        var strDateSAP    = strTagSAP + strMonatSAP + getstring('YEAR','TEMP.CURRENT_TIME');
        var strDateExport = getstring('YEAR','TEMP.CURRENT_TIME') + strMonatSAP + strTagSAP;

        var oDate = { datefile: strDate,
                      datesap : strDateSAP,
                      dateexport: strDateExport };
        return oDate;
    },

	/**
		direct 2D generation of dimension sheet <br>
		currently just test ....
	*/
    generateQuick2DCAD : function(caMainController)
    {
        var str3DParamsPath = "DLGDATA.CA.FORMS.THREEDCADOPTIONS";
        var stkList = [];
        var stkListPart = null, stkListNextPart = null, stkListPrevPart = null;
        var i = 0, j = 0, k = 0;
        var scale  = 1.0;   // Skalierung
        var angle  = 0.0;   // Drehwinkel
        var mirror = 0;     // nicht gespiegelt; (1 = X-Achse, 2 = Y-Achse, 3 = beide)

        var stangenGekuerzt = true;   
        if (getstring("IDC_STANGEN_GEKUERZT", str3DParamsPath) != "true")
            stangenGekuerzt = false;

        var bBemassung = true;
        if (getstring("IDC_BEMASSUNG", str3DParamsPath) != "true")
            bBemassung = false;

        var bPosnr = true;
        if (getstring("IDC_POSNR", str3DParamsPath) != "true")
            bPosnr = false;

        var bTraeger = true;
        if (getstring("IDC_TRAEGER", str3DParamsPath) != "true")
            bTraeger = false;

        // CAD Handle zum Einfgen anlegen
        var ret         = cad_init();
        var hndLayout   = cad_new_layout(); // die Gesamtzeichnung

        // Options-Objekt fr verschiedene Varianten / Detaillierungsgrade ...
        var options = {
                        IDC_STANGEN_GEKUERZT: getstring("IDC_STANGEN_GEKUERZT", str3DParamsPath),
                        IDC_DETAILS: getstring("IDC_DETAILS", str3DParamsPath),
                        IDC_BEMASSUNG: getstring("IDC_BEMASSUNG", str3DParamsPath),
                        IDC_POSNR: getstring("IDC_POSNR", str3DParamsPath),
                        IDC_ROHR: getstring("IDC_ROHR", str3DParamsPath),
                        IDC_DAEMMUNG: getstring("IDC_DAEMMUNG", str3DParamsPath),
                        IDC_TRAEGER: getstring("IDC_TRAEGER", str3DParamsPath),
                        textheight: 0
                      };

        caMainController.topologieKlasse.getStueckliste(stkList);

        var oLKWinkel = caMainController.topologieKlasse.getLKWinkel();
		var nSpannweite = caMainController.topologieKlasse.getSpannweite();

		var strRohrWinkel = caMainController.dataAccess.getSollwerteSchraegzug(1).Beta;
        if (abs(atod(strRohrWinkel) < 4))
            strRohrWinkel = "0";

        // Gekrzte Gewindestangen: 
        // E_kurz = jeweilige Mindestgewindestangenlnge + (E_ungekrzt / 15). 
        // Zu prfen: E_kurz nicht grer ist als E_ungekrzt. In diesem Fall wre E_ungekrzt zu verwenden.
        // Wenn E_kurz dargestellt wird, muss die Masszahl unterstrichen werden.
        var gewStangenlaengeZuschlag = oLKWinkel.dSystemEmass / 15;
        // @@@ Was ist eigentlich, wenn mehrere Gewndestangen verbaut wurden?
        var minGewindestangenLaengeOben  = 0;
        var minGewindestangenLaengeUnten = 0;

        if (caMainController.topologieKlassenName == "CaTopoHaengendEinfach")
        {
            if (caMainController.topologieKlasse.SegmentStrang)
            {
                minGewindestangenLaengeOben  = caMainController.topologieKlasse.SegmentStrang.minGewindestangenLaengeOben;
                minGewindestangenLaengeUnten = caMainController.topologieKlasse.SegmentStrang.minGewindestangenLaengeUnten;
            }
        }

        // Reduziertes Emass fr gekrzte Gewindestangendarstellung:
        // Muss leider vor dem groen Durchlauf unten gemacht werden.
        var gekuerzteLaenge = 0;
        var emassFuerDarstellung = 0;
        var dSystemEmassFuerDarstellung = oLKWinkel.dSystemEmass;
        if (stangenGekuerzt)
        {
            for (i = 0; i < stkList.length; i++)
            {
                if (stkList[i].produkt.m_Ptypid == "ZRM")
                {
                    if (stkList[i].funktion == "OVT")  // oben in der LK
                        gekuerzteLaenge = minGewindestangenLaengeOben + gewStangenlaengeZuschlag;
                    else
                        gekuerzteLaenge = minGewindestangenLaengeUnten + gewStangenlaengeZuschlag;

                    if  (stkList[i].produkt.getEmass() > gekuerzteLaenge)   // nur krzen, wenn gekrzte Lnge < Ist-Lnge
                    {
                        dSystemEmassFuerDarstellung = dSystemEmassFuerDarstellung - (stkList[i].produkt.getEmass() - gekuerzteLaenge);
                    }
                }
            }
        }
        // Texthhe: 1/50 der LK-Hhe
        // Achtung: Bei gekrzten Stangen muss hier die gekrzte Lnge angenommen werden
        // @Hr. Schubert: Hier knnen Sie die Texthhe anpassen:
        var dFaktor;
        if (dSystemEmassFuerDarstellung < 150)
            dFaktor = 4.0;
		else if (dSystemEmassFuerDarstellung < 250)
            dFaktor = 2.0;
        else if (dSystemEmassFuerDarstellung < 750)
            dFaktor = 1.1;
        else if (dSystemEmassFuerDarstellung < 1500)
            dFaktor = 0.7;
        else
            dFaktor = 0.6;
        options.textheight = (sqrt(dSystemEmassFuerDarstellung)) * dFaktor;
        var TH = options.textheight;	// Shortcut fr Texthoehe in Formeln
        var TW = 0.75;
        cad_set_dimtextheight(hndLayout, TH);
        cad_set_dimtextwidth(hndLayout, TW);

        var AnzTeile = stkList.length;
        var massPath = "TMP.CAD_ADDITIONAL_DATA";
        var threeDarray  = [];
        var threeDparams = {};

        var myTwoDCADGenerator = new TwoDCADGenerator(hndLayout, options);
        var hndDrawing = -1;
        var tempDrawing = "";
        var kuerzungOffset = 0, kuerzungOffsetOben = 0, kuerzungOffsetUnten = 0;
        var x = 0, y = 0, z = 0;
        var retObj = null;          // Rckgabeobjekt eines einzelnen WI-CAD-Makros
        var dimArr = [];            // Array von Bemaungsobjekten, die am Schluss eingefgt werden
        var partArr = [];           // Array von Einzelzeichnungen, die nachher in definierter Reihenfolge eingefgt werden, wegen des Ausbrennens ...
        var nMaxWidth = 0;
        var chain = "";             // ID der Bemaungskette
        var lowestPoint = 999999, xLinkerStrang = 0, xRechterStrang = 0;
        var cadMacroParamObject = null;
        var bUnderline = false;
		var nAnzGeometrierelevanteteile = 0;
		var actTypid = "";

        for (i = 0; i < AnzTeile; i++)
        {
            stkListPrevPart = stkListPart;
            stkListPart = stkList[i];
            if (i < (AnzTeile - 1))
                stkListNextPart = stkList[i+1];
            else
                stkListNextPart = null;

            if (!stkListPart.threeD)
                continue;   // Teil nicht 3D-relevant

			actTypid = stkListPart.produkt.m_Ptypid;
			
            // Masse fr das Makro ablegen:
            // berechnete Mae sind da nicht drin, aber dafr im 3DParams-Objekt !!!
            delete(massPath, "");
            stkListPart.produkt.getAdditionalDataToStore(massPath);

            // Manche Teile kommen mehrfach vor (2 Strnge), dann haben
            // wir hier mehrere Eintrge
            for (j = 0; j < stkListPart.threeD.length; j++)
            {
                // Hier wird i+1 als Posnr bergeben ... Im Grund mssten wir
                // die komplette 3D-Datengenerierung der Topologie laufen lassen um
                // zuverlssige Zahlen zu bekommen ....
                threeDarray = stkListPart.produkt.getCADDaten(0, i+1, stkListPart.threeD[j].rotation, "E");
                var tmp = threeDarray[0];
                for (k = 0; k < tmp.length; ++k)
                {
                    if (tmp[k])
                    {
                        var variable = tmp[k][0];
                        var value    = tmp[k][1];
                        threeDparams[variable] = value;
                    }
                }
                threeDparams["Rohrwinkel"] = strRohrWinkel;
				threeDparams["Spannweite"] = nSpannweite;

                tempDrawing = gettempfile("htmltemp", "dxf");
                hndDrawing  = cad_new_drawing();

                emassFuerDarstellung = stkListPart.produkt.getEmass();
                if ((stangenGekuerzt) && (actTypid == "ZRM"))
                {
                    if (stkListPart.funktion == "OVT")  // oben in der LK
                        gekuerzteLaenge = minGewindestangenLaengeOben + gewStangenlaengeZuschlag;
                    else
                        gekuerzteLaenge = minGewindestangenLaengeUnten + gewStangenlaengeZuschlag;

                    if  (stkListPart.produkt.getEmass() > gekuerzteLaenge)   // nur krzen, wenn gekrzte Lnge < Ist-Lnge
                    {
                        emassFuerDarstellung = gekuerzteLaenge;
                        // ab jetzt mssen alle folgenden Koordinaten nach oben geschoben werden
                    }
                }
                else if ((stangenGekuerzt) && ((actTypid == "FSG") || (actTypid == "SSG")))
                {
					var E_min = 0;
					if (actTypid == "FSG")
						E_min = stkListPart.produkt.nEminAbsolut;
					if (actTypid == "SSG")
						//E_min = stkListPart.produkt.m_Pemass - stkListPart.produkt.res_unten;
						E_min = cad_getdouble ("EMIN");
					if (stkListPart.produkt.m_Pemass >= (E_min + (stkListPart.produkt.m_Pemass/5)))
						gekuerzteLaenge = (E_min + (stkListPart.produkt.m_Pemass/5));
					else
						gekuerzteLaenge = stkListPart.produkt.m_Pemass;
					emassFuerDarstellung = gekuerzteLaenge;
				}
				
                cadMacroParamObject = { stkListNextPart: ((stkListNextPart) ? stkListNextPart.produkt.m_Ptypid : ""),
                                        stkListPrevPart: ((stkListPrevPart) ? stkListPrevPart.produkt.m_Ptypid : "")
                                      };

                retObj = myTwoDCADGenerator.insertProduct2D(hndDrawing,
                                stkListPart.produkt.m_Ptypid,
                                stkListPart.threeD[j].rotation,
                                emassFuerDarstellung,
                                threeDparams,
                                cadMacroParamObject
                                );
				nAnzGeometrierelevanteteile++;

                // stkListPart.threeD[j].xpos,      // axiale Verschiebung, anscheinend bei manchen H-Schellen?
                y = stkListPart.threeD[j].ypos;     // lateral zur Flussrichtung, wichtig bei doppelten
                z = stkListPart.threeD[j].zpos;     // Z-Koordinate (vertikal) !

                z = z + kuerzungOffset;     // Funktioniert nur, wenn die Teile von oben nach unten eingefgt werden!

                if ((z - (emassFuerDarstellung + retObj.yWidthBottom)) < lowestPoint)
                    lowestPoint = z  - (emassFuerDarstellung + retObj.yWidthBottom);
                if (y < xLinkerStrang)
                    xLinkerStrang = y;
                if (y > xRechterStrang)
                    xRechterStrang = y;

                if ((stangenGekuerzt) && ((actTypid == "ZRM")||(actTypid == "FSG")||(actTypid == "SSG")) &&
                    (stkListPart.produkt.getEmass() > gekuerzteLaenge))   // Erhhung des Offsets erst nach dem Einfgen der Gewindestange
                {
                    if (((stkListPart.threeD.length == 1) && (j == 0)) ||
                        ((stkListPart.threeD.length > 1) && (j == 1))) // Bei symm. LK den Offset nicht 2 mal (je 1 * pro STrang) erhhen ...
                    {
                        kuerzungOffset = kuerzungOffset + (stkListPart.produkt.getEmass() - gekuerzteLaenge);
                        if (stkListPart.funktion == "OVT")
                            kuerzungOffsetOben = kuerzungOffsetOben + (stkListPart.produkt.getEmass() - gekuerzteLaenge);
                        else
                            kuerzungOffsetUnten = kuerzungOffsetUnten + (stkListPart.produkt.getEmass() - gekuerzteLaenge);
                    }
                }

                ret = cad_save_drawing(hndDrawing, tempDrawing);
                ret = cad_close_drawing(hndDrawing);

				// Manche Teile mssen 180 gedreht werden, weil das Makro nur eine Variante abdeckt
                if (((stkListPart.produkt.m_Ptypid == "ZGM") && (stkListPart.funktion == "OBT")) ||
                    ((stkListPart.produkt.m_Ptypid == "MBS") && (stkListPart.produkt.m_Pcpartid == "IDL_C_MBS_O")) ||
                    ((stkListPart.produkt.m_Ptypid == "ZLN") && (stkListPart.funktion == "SCH")) ||
                    ((stkListPart.produkt.m_Ptypid == "MSN") && (stkListPart.produkt.m_Pcpartid == "IDL_C_MSN_O")) ||
                    ((stkListPart.produkt.m_Ptypid == "ZPK") && (stkListPart.produkt.m_Pcpartid == "IDL_C_ZPK_U")) ||
                    ((stkListPart.produkt.m_Ptypid == "VGR") && (stkListPart.position == "U"))||
					((stkListPart.produkt.m_Ptypid == "ZOM") && (stkListPart.funktion == "OBT"))
                    )
                {
                    angle = 180;
					if (stkListPart.produkt.m_Ptypid != "ZPK")		// ZPK unten wird in den threeD-Params schon verschoben
						zOffset = stkListPart.produkt.getEmass();
                }
                else
                {
                    angle = 0;
                    zOffset = 0;
                }

                // insert drawing
                partArr.push( { drawing:    tempDrawing,
                                y:          y,
                                z:          z - zOffset,
                                scale:      scale,
                                angle:      angle,
                                mirror:     mirror,
                                index:      retObj.index       // Reihenfolge zum Einfgen
                              });

                // Prfen, ob zum Produkt eine Schweissnaht ergnzt werden muss:
                if (retObj.Naht > 0)
                {
                    tempDrawingNaht = gettempfile("htmltemp", "dxf");
                    hndDrawingNaht  = cad_new_drawing();

                    var seite = 1;      // 1 falls oben, -1 falls unten
                    if (((stkListPart.produkt.m_Ptypid == "ZLN") && (stkListPart.funktion == "SCH")) ||
                        ((stkListPart.produkt.m_Ptypid == "MBS") && (stkListPart.produkt.m_Pcpartid == "IDL_C_MBS_U")))
                        seite = -1;
                    var lt = 7;         // schwarz /weiss
                    var factorSN = 1;   // mal probieren - Skalierfaktor
                    var dx = y;         // x,y Einfgepunkt in die Gesamtzeichnung
                    var dy = z - zOffset;
                    if (stkListPart.produkt.isLager() ||
                        ((stkListPart.produkt.m_Ptypid == "MBS") && (stkListPart.produkt.m_Pcpartid == "IDL_C_MBS_U")))
                    {
                        dx = dx + retObj.B_Lager;
                        dy = dy - stkListPart.produkt.getEmass();
                    }
                    if ((stkListPart.produkt.m_Ptypid == "MBS") && (stkListPart.produkt.m_Pcpartid == "IDL_C_MBS_O"))
                        dy = dy + stkListPart.produkt.getEmass();     // Teil wurde oben gedreht ...
                    if (retObj.Naht == 1)
                        myTwoDCADGenerator.add_K_Naht(hndDrawingNaht, factorSN, dx, dy, TH, seite, lt);
                    else
                        myTwoDCADGenerator.add_Kehlnaht(hndDrawingNaht, factorSN, dx, dy, TH, seite, retObj.Naht, lt);

                    ret = cad_save_drawing(hndDrawingNaht, tempDrawingNaht);
                    ret = cad_close_drawing(hndDrawingNaht);

                    ret = cad_insert_drawing_ex(hndLayout, tempDrawingNaht, 0, 0, 1.0, 0, 0);
                }


                // Positionsnummern, Bemassung ergnzen
                var PosNr = i+1; // @@@@@@ Besser komplette 3D-Datenerzeugung laufen lassen und Daten dort entnehmen?
                var xForPos = /* y + */ retObj.xDist;
                var yForPos = /* z + */ retObj.yDist;
                // Bei doppelt symm. LK darf nur der linke Strang bemasst werden.
                // Teile mit Emass 0 werden nicht bemat
                // @@@ bei asymmetrischen muss man den rechten auch irgendwie bemassen !?!?!?
                if (retObj && (j == 0))
                {
                    if (stkListPart.produkt.getEmass() > 0)
                    {
                        /* Fr Horizontalbemaung:
                            x1, y1: Koordinaten des Ansatzpunktes der linken Hilfslinie
                            x2, y2: Koordinaten des Ansatzpunktes der rechten Hilfslinie
                            x3, y3: Koordinaten des Ansatzpunktes der rechen Malinie an der Hilfslinie
                           Fr Vertikalbemaung:
                            x1
                            y1
                            x2 = x1
                            y2 = -y1
                            x3 > x1, x2
                            y3 = y2
                        */
                        var x1 = y - retObj.xMassTop;               // Ansatzpunkt obere (horiz.) Hilfslinie am Bauteil
                        var y1 = z;
                        var x2 = y - retObj.xMassBottom;            // Ansatzpunkt untere (horiz.) Hilfslinie am Bauteil
                        var y2 = z - emassFuerDarstellung;          // 
                        var x3 = y - 2 * retObj.xWidthLeft;         // Unterer Eckpunkt der vertikalen Bemaungslinie
                        var y3 = y2;
                        var tn = stkListPart.produkt.getEmass();      // Unterstreichen wenn gekrzt

                        bUnderline = false;
                        if (stkListPart.produkt.getEmass() != emassFuerDarstellung)
                            bUnderline = true;

                        if ((stkListPart.produkt.isLager() && caMainController.topologieKlasse.bDoppelt) ||
                            (stkListPart.produkt.m_Ptypid == "ZPK") ||
                            (stkListPart.produkt.m_Ptypid == "ZMM") ||
                            (stkListPart.produkt.m_Ptypid == "FHS") ||
                            (stkListPart.produkt.m_Ptypid == "KVS"))
                            chain = "SYSMA";
                        else
                            chain = "EMA";

                        // Bei manchen Bauteilen muss die Bemassung "nach oben gezogen" werden
                        if (((stkListPart.produkt.m_Ptypid == "ZPK") && (stkListPart.produkt.m_Pcpartid == "IDL_C_ZPK_O")) ||
                            ((stkListPart.produkt.m_Ptypid == "ZMM") && (stkListPart.produkt.m_Pcpartid == "IDL_C_ZMM_O")) ||
                            (stkListPart.produkt.m_Ptypid == "FHS") || (stkListPart.produkt.m_Ptypid == "FDT") || 
                            (stkListPart.produkt.m_Ptypid == "ZTN") ||
                            (stkListPart.produkt.m_Ptypid == "KVS"))
                        {
                            y1 = z + emassFuerDarstellung;
                            y2 = z;
                            y3 = y2;
                        }

                        // Wir mssen uns die Bemaungen merken und erst am Schlu ausrechnen,
                        // wie weit diese nach links/rechts rausgezogen werden
                        dimArr.push({ xWidthLeft: retObj.xWidthLeft,
                                      x1: x1,
                                      y1: y1,
                                      x2: x2,
                                      y2: y2,
                                      x3: x3,
                                      y3: y3,
                                      tn: tn,
                                      chain: chain,     // bestimmt, in welcher Kette die nachher landen
                                      underline: bUnderline
                                    });
                        if ((nMaxWidth < retObj.xWidthLeft) &&
                            !(stkListPart.produkt.isVschelle() || stkListPart.produkt.isTraverse()))
                            nMaxWidth = retObj.xWidthLeft;
                    }

                    // Positionsnummern jeweils als eigene sep. Zeichnungen einfgen,
                    // Da Malen auf dem Layout nicht geht ;-(
                    if (bPosnr)
                    {
                        var tempDrawing2 = gettempfile("htmltemp", "dxf");
                        var hndDrawing2  = cad_new_drawing();

                        cad_add_line(hndDrawing2, xForPos, yForPos, xForPos + retObj.L_PosNr, yForPos, 3);
                        cad_add_circle(hndDrawing2, xForPos + retObj.L_PosNr + 1.2*TH, yForPos, 1.2*TH, 3);
                        cad_add_text(hndDrawing2, xForPos + retObj.L_PosNr + TH/2, yForPos - TH/2, 0, TH, PosNr, 3)

                        ret = cad_save_drawing(hndDrawing2, tempDrawing2);
                        ret = cad_close_drawing(hndDrawing2);

                        // insert drawing
                        angle = 0;
                        ret = cad_insert_drawing_ex(hndLayout, tempDrawing2, y, z, scale, angle, mirror);
                    }
                }
            }
        }
        // Jetzt die Einzelzeichnungen einfgen, und zwar Layer fr Layer...
        // max. 20 Layer
        for (j = 0; j <= 20; j++)
        {
            for (i = 0; i < partArr.length; i++)
            {
                if (partArr[i].index == j)
                {
                    ret = cad_insert_drawing_ex(hndLayout, partArr[i].drawing, partArr[i].y, partArr[i].z,
                                            partArr[i].scale, partArr[i].angle, partArr[i].mirror);
                }
            }
        }

        // Sonderfall: Bei Einzel-Traverse, FDT oder V-Schelle muessen wir 2 Variablen von Hand bestimmen:
		var bBemassungSpannweite = false;
		if (caMainController.topologieKlasse.bDoppelt)
			bBemassungSpannweite = true;
        if ((nAnzGeometrierelevanteteile == 1) && stkList[0].produkt && 
			stkList[0].produkt.spannweite && (stkList[0].produkt.spannweite > 0))
        {
			// Achtung: Spannweite im Produkt ist nchst hhere Normspannweite bei Sonderspannweiten
			// Deshalb hier den Eingabewert nehmen.
			// Einfuegepunkt ZTN, V-Schellen: mittig, FDT: links
			/**
			if (stkList[0].produkt.m_Ptypid == "FDT")
			{
				xLinkerStrang  = 0;
				xRechterStrang = nSpannweite;
			}
			else
			{
			**/
				xLinkerStrang = - (nSpannweite / 2);
				xRechterStrang = (nSpannweite / 2);
			//}
			bBemassungSpannweite = true;
        }

       // Die Abstnde der Bemaungslinien sollen nicht kleiner als Textheight werden,
        // sonst geht die Beschriftung in die Malinie ...
        if (nMaxWidth < 6 * TH)
            nMaxWidth = 6 * TH;

        // Zu den Bemaungen noch die Hhenlevel ergnzen:
        var oHoehenmasse = caMainController.dataAccess.getHoehenMasse(caMainController.topologieKlasse.isDritteHLinie());
        // Die Maketten dafr nur wenn nicht Einzelprodukt ...
        if (partArr.length > 1)
        {
            if (caMainController.topologieKlasse.isDritteHLinie())
            {
                var h1 = atoi(oHoehenmasse.H1);
                var h2 = atoi(oHoehenmasse.H2) + kuerzungOffsetOben;
                var h3 = atoi(oHoehenmasse.H3) + kuerzungOffsetOben + kuerzungOffsetUnten;

                dimArr.push({ xWidthLeft: 0,
                              x1: xLinkerStrang - nMaxWidth,
                              y1: h1,
                              x2: xLinkerStrang - nMaxWidth,
                              y2: h2,
                              x3: 0,        // wird nachher berschrieben
                              y3: h2,
                              tn: atoi(oHoehenmasse.H1) - atoi(oHoehenmasse.H2),
                              chain: "SYSMA",
                              underline: (kuerzungOffsetOben > 0)
                            });
                dimArr.push({ xWidthLeft: 0,
                              x1: y - nMaxWidth,
                              y1: h2,
                              x2: y - nMaxWidth,
                              y2: h3,
                              x3: 0,        // wird nachher berschrieben
                              y3: h3,
                              tn: atoi(oHoehenmasse.H2) - atoi(oHoehenmasse.H3),
                              chain: "SYSMA",
                              underline: (kuerzungOffsetUnten > 0)
                            });
                if (bBemassung)
                {
                    this.CADMacroAddHeightInfo(hndLayout, xLinkerStrang - nMaxWidth, h1, nMaxWidth * 2, TH, TW, oHoehenmasse.H1);
                    this.CADMacroAddHeightInfo(hndLayout, xLinkerStrang - nMaxWidth, h2, nMaxWidth * 2, TH, TW, oHoehenmasse.H2);
                    this.CADMacroAddHeightInfo(hndLayout, xLinkerStrang - nMaxWidth, h3, nMaxWidth * 2, TH, TW, oHoehenmasse.H3);
                }
            }
            else
            {
                var h1 = atoi(oHoehenmasse.H1);
                var h2 = 0;
                var h3 = atoi(oHoehenmasse.H3) + kuerzungOffsetOben + kuerzungOffsetUnten;

                dimArr.push({ xWidthLeft: 0,
                              x1: xLinkerStrang - nMaxWidth,
                              y1: h1,
                              x2: xLinkerStrang - nMaxWidth,
                              y2: h3,
                              x3: 0,        // wird nachher berschrieben
                              y3: h3,
                              tn: atoi(oHoehenmasse.H1) - atoi(oHoehenmasse.H3),
                              chain: "SYSMA",
                              underline: (kuerzungOffsetOben + kuerzungOffsetUnten > 0)
                            });
                if (bBemassung)
                {
                    this.CADMacroAddHeightInfo(hndLayout, xLinkerStrang - nMaxWidth, h1, nMaxWidth * 2, TH, TW, oHoehenmasse.H1);
                    this.CADMacroAddHeightInfo(hndLayout, xLinkerStrang - nMaxWidth, h3, nMaxWidth * 2, TH, TW, oHoehenmasse.H3);
                }
            }
        }

        // Jetzt die Bemaungen aufbauen:
        // Wir haben mehrere Maketten, die sich unterschiedlich weit links rausziehen
        if (bBemassung)
        {
            var kettenAbstand, nDimTextType;
            for (i = 0; i < dimArr.length; i++)
            {
                var kettenAbstand = nMaxWidth * 1.5;    // Fr EMA
                if (dimArr[i].chain == "SYSMA")
                    kettenAbstand = nMaxWidth * 2;
                // Unterstrichene Mae bekommen Typ 6, die anderen Typ 0
                nDimTextType = 0;
                if (dimArr[i].underline)
                    nDimTextType = 6;
                ret = cad_insert_dimension(hndLayout, nDimTextType, 0, 0, dimArr[i].x1, dimArr[i].y1, dimArr[i].x2, dimArr[i].y2, xLinkerStrang - kettenAbstand, dimArr[i].y3, dimArr[i].tn);
            }

            // Bei Doppelten LK etc. eine Horizontalbemassung fr die Spannweite ergnzen:
            if (bBemassungSpannweite)
            {
                // Problem: Wir wissen nicht so genau, wo die LK unten aufhrt ....
                // Die x-Pos der Strnge mssen wir uns auch oben irgendwie merken ;-(
                // lowestPoint = 999999, xLinkerStrang = 0, xRechterStrang = 0;
                // var hdiff = h1 - h3;
                var abstand = dSystemEmassFuerDarstellung / 10;
				if (abstand < 100)
					abstand = 100;
                ret = cad_insert_dimension(hndLayout, 0, 0, 0, xLinkerStrang, lowestPoint - abstand, xRechterStrang, lowestPoint - abstand, xRechterStrang, lowestPoint - (2* abstand), xRechterStrang - xLinkerStrang);
            }
        }

        // PDF oder DXF? evtl. wandeln
        var outfile = gettempfile("htmltemp", "dxf");       // dwg wre hier auch mglich
        ret = cad_save_layout(hndLayout, outfile);
        // --> hier auch Ausgabe von Pixelformaten mglich, siehe CADBasic.b

        ret = cad_delete_layout(hndLayout);
        ret = cad_exit();

        return outfile;
    },

    generate2DHaengerFussDrawing : function(theHaenger, theZwischenstueck, LGV)
    {
        var ret;

        var ret         = cad_init();
        var hndLayout   = cad_new_layout(); // die Gesamtzeichnung
        var tempDrawing = gettempfile("htmltemp", "dxf");
        var hndDrawing  = cad_new_drawing();

        var options = {
                        textheight: 0
                      };
        var myTwoDCADGenerator = new TwoDCADGenerator(hndLayout, options);

        var m, t, k, D, e, u, n, o, p, sN, gbx, G, d, l, sVOR, LGR;

		var Typid = theHaenger["m_Ptypid"];
        
        // Schubert: hier das Zwischenstueck abfragen
        var Zwischenstueck;
        if (theZwischenstueck)  // wenn es berhaupt eines gibt
        {
            if ((theZwischenstueck.m_Ptypid == "ZZK") &&
                (theZwischenstueck.form == "1"))
            {
                Zwischenstueck = 1;
            }
        }

        if (theHaenger.isFHaenger())
        {
            var tmpPath = "TMP.FH_ADDITIONAL_DATA";
            theHaenger.getAdditionalDataToStore(tmpPath);

            m   = getdouble("M", tmpPath);
            t   = getdouble("T", tmpPath);
            k   = getdouble("K", tmpPath);
            D   = getdouble("D", tmpPath);

            myTwoDCADGenerator.add_FH_FS_FP(hndDrawing, m, t, k, D, LGV, Typid);	//FH_FS-Fussplatte
        }
        else // K-Haenger
        {
            var E_Kat	= theHaenger["estern"];
			var E_real	= theHaenger["m_Pemass"];		// @@@ Anpassung hier relevant? wenn ja, woher holen?
			if (E_Kat > E_real)
			{
                sVOR = E_Kat - E_real;
			}
			else
			{
                sVOR = E_real - E_Kat;
			}
			var tmpPath = "TMP.KH_ADDITIONAL_DATA";
            theHaenger.getAdditionalDataToStore(tmpPath);

			e	= getdouble("E_", tmpPath);
            t   = getdouble("T", tmpPath);
			
			if (Zwischenstueck == 1)
				{
					var zw_path = "TMP.CAD_ADDITIONAL_DATA";
					n	= getdouble("N11", zw_path);
					u	= getdouble("U11", zw_path);
				}
			else
				{
					n	= getdouble("N", tmpPath);
					u	= getdouble("U", tmpPath);
				}
			
			m	= getdouble("M", tmpPath);
            k   = getdouble("K", tmpPath);
            o	= getdouble("O", tmpPath);
			p	= getdouble("P", tmpPath);
			sN	= getdouble("SN", tmpPath);
			G	= getdouble("G", tmpPath);
			d = getdouble("D", tmpPath);
			l = getdouble("L_", tmpPath);
			LGR = getdouble("LGR", tmpPath);

			if ((Typid == "KHS") || (Typid == "KSR") || (Typid == "KSP"))
			{
                gbx	= getdouble("GBX", tmpPath);
            }
			if (Typid == "KVS")
			{
                gbx	= getdouble("GPX", tmpPath);
            }

            myTwoDCADGenerator.add_KH_KS_FP(hndDrawing, t, e, u, m, n, k, o, p, sN, sVOR, gbx, G, d, l, LGV, LGR, Typid);	//KH_KS-Fussplatte
        }

        ret = cad_save_drawing(hndDrawing, tempDrawing);
        ret = cad_close_drawing(hndDrawing);

        // insert drawing
        ret = cad_insert_drawing_ex(hndLayout, tempDrawing, 0, 0, 1.0, 0, 0);

        // Bemassungen einbauen
        if (theHaenger.isFHaenger())
        {
            myTwoDCADGenerator.add_FH_FS_FP_MASSE(hndLayout, m, t, k, D, LGV)	//FH_FS-Fussplatte
        }
        else
        {
            myTwoDCADGenerator.add_KH_KS_FP_MASSE(hndLayout, t, e, u, m, n, k, o, p, sN, sVOR, gbx, G, d, l, LGV, LGR, Typid)	//KH_KS-Fussplatte
        }

        var outfile = gettempfile("htmltemp", "dxf");       // dwg wre hier auch mglich
        ret = cad_save_layout(hndLayout, outfile);
        // --> hier auch Ausgabe von Pixelformaten mglich, siehe CADBasic.b

        ret = cad_delete_layout(hndLayout);
        ret = cad_exit();

        return outfile;
    },

    CADMacroAddHeightInfo : function(hndLayout, x1, y1, lw, th, tw, txt)
    {
        var scale  = 1.0;   // Skalierung
        var angle  = 0.0;   // Drehwinkel
        var mirror = 0;     // nicht gespiegelt; (1 = X-Achse, 2 = Y-Achse, 3 = beide)

        var tmpHeightDrawing = gettempfile("htmltemp", "dxf");
        var hnd  = cad_new_drawing();

        tw = 1.0;   /* @@@ */
        var x2 = x1 - lw;
        var mtl = txt.length;   // max(txt.length, 5);
        var x3 = x2 + th * (mtl + 0.5) * tw;
        var y3 = y1 + th;

        cad_begin_poly(hnd, 0, 4);
        cad_add_vertex(hnd, x3,  y3);
        cad_add_vertex(hnd, x2,  y3);
        cad_add_vertex(hnd, x2 + th/2.0, y1);
        cad_add_vertex(hnd, x2 + th, y3);
        cad_end_poly(hnd);

        cad_add_line(hnd, x1, y1, x2, y1, 4);

        cad_add_text(hnd, x2, y3 + th/2.0, 0.0, th, txt, 4);

        var ret = cad_save_drawing(hnd, tmpHeightDrawing);
        ret = cad_close_drawing(hnd);

        // insert drawing
        ret = cad_insert_drawing_ex(hndLayout, tmpHeightDrawing, 0, 0, scale, angle, mirror);
    },

	/**
		prfe, ob der Hnger an Zusatzlasten angepasst werden muss <br>
		wenn ja, dann versuch es, falls nicht erfolgreich liefere Meldung an Anwender zurck
		In allen anderen Fllen: liefere Leerstring zurck
		Diese Funktion kopiert Code aus dem IndexController, completeSelectionAction() !
	*/
    checkZusatzlasten : function()
    {
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		/*
		var VertiDir		  	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		if (VertiDir == "AUF")
			var sollast			= abs(caMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]));
		else
			var sollast			= abs(caMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]));
        */
		var sollast				= max(Math.abs(caMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(caMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
		var schaetzZusatzlast 	= caMainController.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
        var istZusatzlast 		= caMainController.topologieKlasse.calculateZusatzlast();
		var berZLast			= fround(atod(getstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT")),2); // fuer zweiten Durchlauf
		var LKTyp				= caMainController.dataAccess.getLastketteTyp(); 
		
		// Automatische Neuberechnung nur starten, wenn auch etwas relevantes da ist und der Hnger kein Dynamikteil ist
		if ((berZLast != istZusatzlast) && (LKTyp != "GELENKSTREBE") && (LKTyp != "STOSSBREMSE"))
        {
			// Ist-Wert neu setzen
			caMainController.dataAccess.setSollwerteZusatzLastEG(istZusatzlast);
			// Wir versuchen, den "Hnger" automatisch an die genderte Last anzupassen, ohne die LGV zu ndern.
			// Wenn dies nicht geht, dann muss der Anwender zurck zur Hngerauswahl
			if (! caMainController.recalcHaenger((sollast + schaetzZusatzlast), istZusatzlast))
			{
				var strErrorMessage = translate("ZUSATZLAST_AUS_EIGENGEWICHT") + ": " + istZusatzlast + "kN" + "<br>" + translate("IDP_ZUSATZLAST_VORSCHLAG");
				return strErrorMessage;
			}
        }

		return '';
	},

	/**
		action handler for cadTwoDAction action to be evoked from ajax <br>
		the action is evoked by a click on the '2D CAD' button in the 2DCAD options dialog
	*/
    cadTwoDAction : function()
    {
		var strMsg = this.checkZusatzlasten();
		if (strMsg != '') {
			var response = {
				success: 		true,		// meint nur, dass der Ajax - Aufruf an sich geklappt hat (auf der Transport-Ebene)
				errMsg: 		strMsg,
				//strGoBackPanel: 'systemcharakteristik'
				strGoBackPanel:	'sollwerte_halterungspunkt'
			};

			echo JSON.stringify(response);
			_global.MIMETYPE = 'application/json';
			return;		// Wichtig, damit die Response nicht nachher nochmal geschrieben wird
		}

		this.cadTwoDActionDoiIt("SELECT");
		return;
	},

	/**
		action handler for cadPreviewAction action to be evoked from ajax <br>
		the action is evoked by a click on the 'PRINT' button in the panel's toolbar
		NO LONGER ACTIVE ... print button was removed
	*/
    cadPreviewAction : function()
    {
		this.cadTwoDActionDoiIt("PREVIEW");
		return;
	},
	
	/**
		action handler for cadThreeDAction action to be evoked from ajax <br>
		the action is evoked by a click on the '3D CAD' button in the panel's toolbar
	*/
    cadThreeDAction : function()
    {
		var strMsg = this.checkZusatzlasten();
		if (strMsg != '') {
			var response = {
				success: 		true,		// meint nur, dass der Ajax - Aufruf an sich geklappt hat (auf der Transport-Ebene)
				errMsg: 		strMsg,
				//strGoBackPanel: 'systemcharakteristik'
				strGoBackPanel:	'sollwerte_halterungspunkt'
			};

			echo JSON.stringify(response);
			_global.MIMETYPE = 'application/json';
			return;		// Wichtig, damit die Response nicht nachher nochmal geschrieben wird
		}
	
	
        // set default base options to store
        var strPath = "DLGDATA.CA.FORMS.THREEDCADOPTIONS";

        this.setValuesAction();
        
        /** Options gemss Maske
        setstring( "IDC_STANGEN_GEKUERZT", strPath, "" );
        setstring( "IDC_DETAILS", strPath, "DREI" );
        setstring( "IDC_BEMASSUNG", strPath, "true" );
        setstring( "IDC_POSNR", strPath, "true" );
        setstring( "IDC_ROHR", strPath, "true" );
        **/
        
        // show 3D CAD
        this.show3DCAD(caMainController,
                        {   xmlFileToCreate: "",
                            createCadFile:   1,
                            cadFileToCreate: "",
                            createPdfFile:   0,
                            pdfFileToCreate: "",
                            addToListFile:   0,
                            listFileToAdd:   "",
                            generateShowOperation: true,
                            generateLayoutOperation: false,
                            multipleType:    "",
                            Quick2DFile:     ""
                        });
	},

	/**
		action handler for cadPreviewAction action to be evoked from ajax <br>
		the action is evoked by a click on the 'PRINT' button in the panel's toolbar
	*/
    cadTwoDActionDoiIt : function(strWoher)
    {
    
 		// set default base options to store, aber nur die ntigsten
        // wir nehmen ansonsten die letzten Einstellungen des Anwenders
		var strPath = "DLGDATA.CA.FORMS.THREEDCADOPTIONS";

        this.setValuesAction();
        
		// -mw- 18.6.2012 auf Wunsch Hr. Schubert
		//if (strWoher == "PREVIEW")
		//	setstring( "IDC_OUTQUAL", strPath, "SCHNELL");
        
        var Quick2DFile = "";
        // 1. Parameter hier nicht relevant...
        var oCadInfos = caMainController.topologieKlasse.getCadInfos((Quick2DFile != ""), false, false);
		// -mw- 18.6.2012 auf Wunsch Hr. Schubert
		/*
        if ((getstring( "IDC_OUTQUAL", strPath) == "SCHNELL") && (! oCadInfos.lagerEinzel))
        {
            Quick2DFile = this.generateQuick2DCAD(caMainController);
            if (Quick2DFile == "")
                return;
        }
		*/
        
        var bDXF = true;
        var bPDF = false;
        if (getstring( "IDC_OUTFMT", strPath) == "PDF")
        {
            bPDF = true;
            bDXF = false;
        }

        // Hier die Sprache Kommunikation benutzen, nicht die GUI-Sprache
		var strAktuelleSprache = getlanguage();
        var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();
		setlanguage(strSpracheKomm);

        // Generate Quick 2D CAD
        var oOptions = {   xmlFileToCreate: "",
                            createCadFile:   bDXF,
                            cadFileToCreate: "",
                            createPdfFile:   bPDF,
                            pdfFileToCreate: "",
                            addToListFile:   0,
                            listFileToAdd:   "",
                            generateShowOperation: false,
                            generateLayoutOperation: true,
                            multipleType:    "",
                            Quick2DFile:     Quick2DFile
                        };

        this.show3DCAD(caMainController, oOptions );

		setlanguage(strAktuelleSprache);
        
		var strMode = "offline";
		
        if (getstring("CATALOG.INTERNETSERVERINCDMODE","") == "false")  // Internet-Version
        {
			strMode = "online";
        }
        else
        {
            // Erzeugte Datei anzeigen
            if (bDXF)
            {
                // Bei DXF-Datei rufen wir expl. den Caviar auf ... 
                var DIR, FILE, PARAM;
                DIR	    = getstddirectory("PROGRAM");
                FILE	= "caviar.exe";
                PARAM	= oOptions.cadFileToCreate;
                var ret     = shellexecuteex(FILE,PARAM,DIR,"1");
            }
            else
			{
                shellexecuteex( oOptions.pdfFileToCreate, "", "", 1);    // show = 1, timeout
			}
        }

		// CAD-Dateien knnen in beliebigem Ordner erzeugt werden (catalog.ekw)
		// Link auf PDF-Datei mit absolutem Pfad funktioniert evtl. nicht direkt in Mozilla-Control
		// Darum: Datei immer zippen, zip-Datei im Temp-Ordner erzeugen und dann
		// als Link mit Alias bereitstellen.
		var strPrgDir = getstddirectory( "PROGRAM" );   // inkl. trailing Backslash
		var strTempDir = getstddirectory( "TEMP" );   // inkl. trailing Backslash
		var strCadFile = oOptions.pdfFileToCreate;
		if (bDXF)
			strCadFile = oOptions.cadFileToCreate;

		/*
			DXF-/PDF-Datei zippen ... 
			Plugin muss da stehen, sonst keine weiteren Initialisierungen mehr erforderlich!
		*/
		var oZip = new compress_plugin("catalog/plugin/zip/zip_plugin.dll", "zip_plugin");
		
		var zipFile 	= FileName.getTempFile("zip");
		oZip.create(zipFile, '');

		oZip.addFileAs( strCadFile, FileName.getFullName(strCadFile) );	// Param1: Datei die eingebaut wird; Param2: Welchen Namen hat sie im Zip
		oZip.close();

		var theLink = "tmp/" + FileName.getFullName(zipFile);
		
		// Im CD-Modus auf Anwenderwunsch die Messagebox unterdrcken
		if ((strMode == "offline") && (getstring("UNTERSTUETZUNG_PDF_CHECK","")!="true"))
			theLink = "";
			
		// Datei clientseitig ffnen, bei online
		var openFile 	= translate("IDC_FB_2D_FORMAT_DATEI_OEF");
		var openWar		= translate("IDC_FB_2D_FORMAT_DATEI_WAR");
		var response = {
			'success': 	true,
			'url': 	    theLink,
			'filetype': getstring( "IDC_OUTFMT", strPath),
			'title':    openFile,
			'message':  openWar,
			'linktext': openFile,
			'mode':     strMode
		};

        echo JSON.stringify(response);
        _global.MIMETYPE = 'application/json';

	},

    generateMultipleDrawingsForSapAction : function()
    {
        var response = {
            success : true,
            message : ''
        };

        this.generateMultipleDrawingsAction(response, "SAP");

        echo JSON.stringify(response);
        _global.MIMETYPE = 'application/json';
    },

    generateMultipleDrawingsForCrmAction : function()
    {
        logtraceln("***************************************************");
		logtraceln("Start CAD und Massenauszug Generierung fr CRM");
		logtraceln("**************************************************");
		
		var response = {
            success : true,
            message : ''
        };
		
		getdate('CURRENT_TIME','TEMP');
        var strYear  = getstring('YEAR','TEMP.CURRENT_TIME');
        var strMonth = getstring('MONTH','TEMP.CURRENT_TIME');
        var strDay   = getstring('DAY','TEMP.CURRENT_TIME');
        var strHour  = getstring('HOUR','TEMP.CURRENT_TIME');
        var strMin   = getstring('MINUTE','TEMP.CURRENT_TIME');
        var strSec   = getstring('SECOND','TEMP.CURRENT_TIME');
        if (strMonth.length < 2)
            strMonth = "0" + strMonth;
        if (strDay.length < 2)
            strDay = "0" + strDay;
        if (strHour.length < 2)
            strHour = "0" + strHour;
        if (strMin.length < 2)
            strMin = "0" + strMin;

        var strTime = strYear + strMonth + strDay + strHour + strMin + strSec;

		// Massenauszug abspeichern
		var strAngebNr = getstring("WI_ANGEBOTSNR",  "PROJECT.SETTINGS");
		strAngebNr = trimleft(strAngebNr, " ");
        strAngebNr = trimright(strAngebNr, " ");
		strAngebNr = replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});
		
		var strMassenauszugfile = getstddirectory( "TEMP" ) + strAngebNr+"_MASS_FL_"+strTime+".xls";
		var strMassenauszugfile_csv = getstddirectory( "TEMP" ) + strAngebNr+"_MASS_FL_"+strTime+".csv";
		
		var dokManager = new CaDokManager(caMainController);
		if(dokManager.xmlSetFileOutput(strMassenauszugfile) == true) {
			//var retDokGen = dokManager.writeDokFromProjectlist(0);
			//if(retDokGen)
			dokManager.writeDokFromProjectlist(0);
			if (dokManager.bError == false)
			{
				var aParam = [strMassenauszugfile,strMassenauszugfile_csv];
				ret = TransferFilestoCRM(aParam);
				if (! ret) {
					alert("Fehler beim Transfer Massenauszug in den Sharepoint!");
					echo JSON.stringify(response);
					_global.MIMETYPE = 'application/json';
				}
				else
				{
					// Massenauszug aus TEMP-Ordner lschen -> liegt bereits im SharePoint
					filecommand("unlink", strMassenauszugfile);
					filecommand("unlink", strMassenauszugfile_csv);
					//Massbild zeichnen
					this.generateMultipleDrawingsAction(response, "CRM");
					  
					logtraceln("***************************************************");
					logtraceln("Fertig CAD und Massenauszug Generierung fr CRM");
					logtraceln("***************************************************");
					
					echo JSON.stringify(response);
					_global.MIMETYPE = 'application/json';
				}
			}
			else
			{
				logtraceln("kein Massenauszug generiert! Geht nur bei Rohrhalterungen!");
				//Massbild zeichnen
				this.generateMultipleDrawingsAction(response, "CRM");
				  
				logtraceln("***************************************************");
				logtraceln("Fertig CAD und Massenauszug Generierung fr CRM");
				logtraceln("***************************************************");
				
				echo JSON.stringify(response);
				_global.MIMETYPE = 'application/json';
			}
		}
    },


    generateMultipleDrawingsFreeAction : function()
    {
        var response = {
            success : true,
            message : ''
        };

        var aPdfInputListe = this.generateMultipleDrawingsAction(response, "FREE");
		if ((response.message == "") && (aPdfInputListe.length > 0))	// (strPdfInputListe != ""))	// nur wenn kein Fehler aufgetreten:
			this.packPDF(aPdfInputListe);
		
        echo JSON.stringify(response);
        _global.MIMETYPE = 'application/json';
    },


    packPDF : function(aPdfInputListe)
    {
		// Alle PDF in Ordner packen
		//---------------------------------------------------
		var strUserExportPath  = getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS");

		// Diversa:
		// Wildcard mit Pfadangabe vorne geht nicht
		// Wildcard ohne Pfadangabe geht, wenn man den Ausfhrungsordner auf den Zielordner legt,
		//    aber dann sind die Dateien unzusammenhngend sortiert
		// Alle aufzhlen geht in der DOS-Box (getestet: 70 Stck), Problem: kann man den Pfad
		// weglassen, wenn man die Dosbox im Zielordner ausfhrt und die bat-Datei dort ablegt??
		// Alle aufzhlen ber Params geht nicht bei ca > 50 Dateien

		// @@@@ strUserExportPath ist UTF8 aus Maske .... Funktioniert das auch auf russisch/asiatisch? evtl. besser Funktion die gekrzten internen Namen liefert ...
		strUserExportPath = utf8toansi(strUserExportPath);

		if (strUserExportPath.charAt( strUserExportPath.length - 1 ) != "\\" )
			strUserExportPath += "\\";
		var strPattern  = "\"" + strUserExportPath + "*.pdf\"";
		var strPrgPath  = getstddirectory( "PROGRAM" ) + "catalog\\plugin\\";    // inkl. trailing Backslash
		var strExecutable = strPrgPath + "pdftk.exe";
		// filedialog(1, "TCA", "", "TCA-Files|*.TCA;*.tca||", strUserTcaPath);
		var Datei = filedialog(0, "PDF", "", "PDF-Files|*.PDF;*.pdf||", strUserExportPath);
		Datei = utf8toansi(Datei);  // @@@ Achtung kyrillisch etc ... @@@ Tool erzeugt Umlaute als DOS-Codes !!! Problem!!
		if (Datei != "")
		{
			/*
			delete("TEMP.FILES", "");
			getdirectory(strUserExportPath + "*.*", "TEMP.FILES");
			sortarray("TEMP.FILES", "FILENAME");

			var nLastPos = getsize("TEMP.FILES", "") - 1;
			var i, strPdfInputListe = "";
			for (i = 0; i <= nLastPos; ++i)
			{
				var eksPathFile = "TEMP.FILES[" + i + "]";
				var nameFile = getstring("FILENAME", eksPathFile);
				if ((toupper(right(nameFile, 4)) == ".PDF") &&
					(getstring("IS_DIRECTORY", eksPathFile) != "1"))
				{
					// Um zu verhindern, dass Umlaute in den Dateinamen vorkommen -> fhrt bei PDFTK zum Absturz
					var nameFileShort = FileName.getShortPath(strUserExportPath + nameFile);
					strPdfInputListe += " \"" + nameFileShort + "\"";
				}
			}
			*/

			// var strParams = " *.pdf cat output \"" + Datei + "\" ";  // dont_ask
			var strPdfInputListe = "";
			for (i=0; i < aPdfInputListe.length; i++)
				strPdfInputListe += " \"" + FileName.getShortPath(aPdfInputListe[i]) + "\"";
				
			var strParams = strPdfInputListe + " cat output \"" + Datei + "\" dont_ask ";

			var strFileLine = strExecutable + " " + strParams;
			var strBatfile  = gettempfile(strUserExportPath, "bat");
			writefile( strBatfile, strFileLine, "wc" );

			// Datei erzeugen
			// shellexecuteexblocking( strExecutable, strParams, strUserExportPath, 1, 256000 );    // show = 1
			shellexecuteexblocking( strBatfile, "", strUserExportPath, 1, 256000 );    // show = 1

			// PDF anzeigen
			// @@@ Check ob es angelegt wurde!!!
			shellexecuteex( Datei, "", "", 1 );    // show = 1
		}
    },

	/**
		action handler for show_three_d_options action to be evoked from ajax <br>
		the action is evoked by a click on the 'CAD' button in the 3DCAD options dialog
	*/
    generateMultipleDrawingsAction : function(response, strType)
    {
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strListfile     = gettempfile(getstddirectory( "TEMP" ), "txt");
        var i, nTransferCount = 0;
		var strPdfInputListe = "";
		var aPdfInputListe = [];

        setstring("CAD_GENERATOR_STATUS", "", "MSG_PREPARE_CAD");

        var oFileComponents = this.getFileComponents(strType);
        var strAngebNr      = getstring("WI_ANGEBOTSNR",  ProjectSettings);
        // In der Kundenversion gibts die Angebotsnummer nicht, da den Projektnamen verwenden
        if (getstring("VERSION","RIGHTS") == "CLIENTVERSION")
            strAngebNr      = getstring("PROJEKTNAME",  ProjectSettings);
		var strBenutzer		= getstring("WI_BENUTZER",  ProjectSettings);
        strAngebNr = trimleft(strAngebNr, " ");
        strAngebNr = trimright(strAngebNr, " ");
		strBenutzer = trimleft(trimright(strBenutzer, " "), " ");
        strAngebNr = replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});
		
        if ((strAngebNr == "") || (strBenutzer == ""))	// -Schu- auch Benutzer soll befuellt sein
        {
            if (getstring("VERSION","RIGHTS") == "SALESVERSION")
                response.message = translate("MSG_ERR_WI_ANGEBOTSNR");     
            else
                response.message = translate("MSG_ERR_WI_PROJEKTNAME"); 
            setstring("CAD_GENERATOR_STATUS", "", "MSG_CAD_FINISH");
            return "";
        }


        var bGeneratePDF = 1;
        var bGenerateDXF = 1;
        var generatePath = oFileComponents.strDataPath;

        if (strType == "FREE")
        {
            if (tolower(getstring("EXPORT_DXF_FORMAT_CHECK", "PROJECT.SETTINGS") != "true"))
                bGenerateDXF = 0;
            if (tolower(getstring("EXPORT_PDF_FORMAT_CHECK", "PROJECT.SETTINGS") != "true"))
                bGeneratePDF = 0;
			if (! bGenerateDXF && ! bGeneratePDF)
				bGeneratePDF = 1;
				
            generatePath = oFileComponents.strUserExportPath;

            if (!generatePath || generatePath.length <= 0)
            {
                response.message = translate("ERR_NO_EXPORT_PATH");
                setstring("CAD_GENERATOR_STATUS", "", "MSG_CAD_FINISH");
                return "";
            }
        }
        else    // SAP, CRM
        {
            bGenerateDXF = 0;
        }

        writefile( strListfile, "Flexperte: Massenerzeugung von Zeichnungen \r\n", "wc" );
        if (strType == "SAP")
            writefile( strListfile, "\"LOGIN\" \"KSYS\" \"NIL\" \r\n", "a" );

        // Hier die Sprache Kommunikation benutzen, nicht die GUI-Sprache
		var strAktuelleSprache = getlanguage();
        var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();
		setlanguage(strSpracheKomm);

        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";
			
            // Prfe SAP-Checkbox + Produktbereich!
            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strPos          = getstring("POS", Source);
            // Auf 4 Stellen auffllen, damit das Sortieren klappt
            if (strPos.length == 1)
                strPos = "000" + strPos;
            else if (strPos.length == 2)
                strPos = "00" + strPos;
            else if (strPos.length == 3)
                strPos = "0" + strPos;

            if (((strProductArea == "RH") || (strProductArea == "CA")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;
                delete(Target, "");
                copy(Source, Target);

                // set default base options to store
                // muss hier erfolgen, da sonst von Dialogspezifischen Einstellungen berschrieben!
                var strPath = "DLGDATA.CA.FORMS.THREEDCADOPTIONS";
                setstring( "IDC_STANGEN_GEKUERZT", strPath, "true" );
                setstring( "IDC_DETAILS", strPath, "DREI" );
                setstring( "IDC_BEMASSUNG", strPath, "true" );
                setstring( "IDC_POSNR", strPath, "true" );
                setstring( "IDC_ROHR", strPath, "true" );
                setstring( "IDC_DAEMMUNG", strPath, "false" );
				setstring( "IDC_TRAEGER", strPath, "true" );

                // Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
                tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher
                caMainController = tmpCaMainController;  // just  to be sure ...

                // Neue direkte 2D-Generierung
                var Quick2DFile = "";
                // 1. Parameter hier nicht relevant...
                var oCadInfos = caMainController.topologieKlasse.getCadInfos((Quick2DFile != ""), false, false);
				// -mw- 18.6.2012 auf Wunsch Hr. Schubert
				/*
                if ((! oCadInfos.lagerEinzel) &&
                    ((getstring("IDC_WI_QUICK_CAD_CHECK", "") == "true") || (strType == "SAP")))
                    Quick2DFile = this.generateQuick2DCAD(caMainController);
				*/
				
                var xmlFileToCreate = generatePath + "ZN_" + toupper(strAngebNr) + "_" + strPos + "_FL_" + oFileComponents.strTime + ".xml";
                var cadFileToCreate = generatePath + "ZN_" + toupper(strAngebNr) + "_" + strPos + "_FL_" + oFileComponents.strTime + ".dxf";
                var pdfFileToCreate = generatePath + "ZN_" + toupper(strAngebNr) + "_" + strPos + "_FL_" + oFileComponents.strTime + ".pdf";
				
				/*
				// Wenn die Markierung der Dateiname sein soll
				var MarkierungPos	= getstring("MARKIERUNG", Source);
				if (MarkierungPos == "")
					MarkierungPos = oFileComponents.strTime;
				var pdfFileToCreate = generatePath + MarkierungPos + ".pdf";
                */
				
				if (! bGenerateDXF)
                    cadFileToCreate = "";
                if (! bGeneratePDF)
                    pdfFileToCreate = "";

                setstring("CAD_GENERATOR_STATUS", "", translate("CAD_GEN_PROGRESS_DRAWING") + xmlFileToCreate);   

                this.show3DCAD(caMainController,
                                {   xmlFileToCreate: xmlFileToCreate,
                                    createCadFile:   bGenerateDXF,
                                    cadFileToCreate: cadFileToCreate,
                                    createPdfFile:   bGeneratePDF,
                                    pdfFileToCreate: pdfFileToCreate,
                                    addToListFile:   1,
                                    listFileToAdd:   strListfile,
                                    generateShowOperation: false,
                                    generateLayoutOperation: true,
                                    multipleType:    strType,
                                    Quick2DFile:     Quick2DFile
                                });

                if ((strType == "SAP") || (strType == "CRM"))
                    setstring("CACHE_DRAWING_FILE_PDF_SAP", Source, pdfFileToCreate);

                setstring("CACHE_DRAWING_FILE_PDF", Source, pdfFileToCreate);
                setstring("CACHE_DRAWING_FILE_DXF", Source, cadFileToCreate);

				if (bGeneratePDF)
				{
					// Datei existiert zu diesem Zeitpunkt noch nicht, Pfad ist aber schon gekrzt
					// var nameFileShort = FileName.getShortPath(pdfFileToCreate);
					strPdfInputListe += " \"" + pdfFileToCreate + "\"";
					aPdfInputListe.push(pdfFileToCreate);
				}
            }
        }

		setlanguage(strAktuelleSprache);

        var strPrgPath  = getstddirectory( "PROGRAM" );    // inkl. trailing Backslash
        var strExecutable = "\"" + strPrgPath + "CadView\\CADProzessor\\Cadprozessor.exe\"";
        // strListfile =  "\"" + strListfile + "\"";

        if (nTransferCount > 0)
        {
            // shellexecuteex( strExecutable, strListfile, strPrgPath, 1);    // show = 1, timeout
            this.processCadFileList(strListfile, strType);
        }
        else
        {
            if(strType == "CRM")
				response.message = "ERR_NO_POS_ROHRHALTERUNG"; // Im CRM wird keine Fehlermeldung bentigt
			else
				response.message = translate("ERR_NO_POS_ROHRHALTERUNG");
			
			setstring("CAD_GENERATOR_STATUS", "", "MSG_CAD_FINISH");
		}
		
		return aPdfInputListe;	// strPdfInputListe;
	},

    processCadFileList : function(strBatchInput, strType)
    {
        var ret = 0;

            // Eingabedatei lesen
            // ---------------------------------------------
        var strFileContent  = readfile(strBatchInput);
        var nAnzRows        = stringtoarray(strFileContent, "TMP.INPUTLINES", "\n");
        var strLine = "", i = 0, j = 0;
        var strExecutable, strParams, strPrgPath;
        var bInExe, bInParam, bInPath;
        var nAnzAufruf = 0;
        var nSapLogin  = false;

        /***
        if (! singleinstance())
        {
            logtrace("Not single instance: abort ...\n");
            alert("Die CAD-Generierung kann nicht mehrmals gleichzeitig laufen. Bitte OK clicken.");
            return;
        }
        ***/

        logtrace("Processing started ...\n");
        setstring("CAD_GENERATOR_STATUS", "", "MSG_START_CAD"); 
        // Status im Progressbar: alert("Die Erzeugung von CAD-Dateien wird gestartet. Bitte OK clicken.");

        // var netShare_PRODUKTIV = "\\\\aswi02_g\\USR\\sap\\Transfer\\KPRO\\P01_TEMP";
        // var netShare_KSYSTEM   = "\\\\Aswi01\\ifs\\usr\\sap\\Transfer\\KPRO\\K00_TEMP";
        // var netShare = netShare_KSYSTEM;

        var netShare	= toupper(getstring( "CATALOG.SAP.TRANSFERORDNER", "" ));	// "FLEXPERTERTW"
		var SAPSys		= toupper(getstring( "CATALOG.SAP.SAPINFO", "" ));
		SAPSys			= (rfind(SAPSys, "TEST") > -1 ? "_K" : "_P");	// "P" - Prduktiv / "K" - Test
		var username	= "";
        var passwd		= "";
		var connect		= "";
		if (strType == "SAP") {
			//var TMPGate		= netShare.split("\\");
			//var GATE		= toupper(TMPGate[TMPGate.length-1]);	// letzter Teil den Namens von "TRANSFERORDNER"
			var sqlstring 	= "SELECT * FROM TRANSFER WHERE GATE = '" + netShare + SAPSys + "' ";
			var dbName		= "CASCADE";
			var dbNameTable = "LogInfo";
			
			if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
					username	= dbgetstring(dbNameTable, "USER");
					passwd		= dbgetstring(dbNameTable, "PASS");
					connect		= dbgetstring(dbNameTable, "CONNECT");
					//connect		= "\\\\" + dbgetstring(dbNameTable, "CONNECT") + "\\";
			}
			
			netShare	= connect + tolower(netShare);
		
			/*
			var username = "r3sambaflexperte";
			var passwd   = "r3$ambaFlex4712";
			*/
		}
		
		var aPDFFilesforCRMTransferComplete= new Array();
        for (i = 0; i < nAnzRows; i++)
        {
            strExecutable = "";
            strParams     = "";
            strPrgPath    = "";

            bInExe   = false;
            bInParam = false;
            bInPath  = false;

            strLine = getstring("VALUE", "TMP.INPUTLINES["+i+"]");
            var nLength = strLine.length;

            j = 0;
            for (j; j < nLength; j++)
            {
                var x = strLine.charAt(j);
                if (strLine.charAt(j) == "\"")
                {
                    if (bInExe)
                        break;  // exe eingelesen
                    else
                        bInExe = true;
                }
                else
                {
                    if (bInExe)
                        strExecutable += strLine.charAt(j);
                }
            }
            j++;
            for (j; j < nLength; j++)
            {
                if (strLine.charAt(j) == "\"")
                {
                    if (bInParam)
                        break;  // Params eingelesen
                    else
                        bInParam = true;
                }
                else
                {
                    if (bInParam)
                        strParams += strLine.charAt(j);
                }
            }
            j++;
            for (j; j < nLength; j++)
            {
                if (strLine.charAt(j) == "\"")
                {
                    if (bInPath)
                        break;  // Prgpath eingelesen
                    else
                        bInPath = true;
                }
                else
                {
                    if (bInPath)
                        strPrgPath += strLine.charAt(j);
                }
            }

            if ((strExecutable != "") && (strParams != "") && (strPrgPath != ""))
            {
                if (strExecutable == "LOGIN")
                {
					ret = copyfile(strParams, strPrgPath, 0);     // 0 = vorhandene Datei berschreiben ...
                    nSapLogin  = true;
                    var res = FileName.addNetConnection(netShare, username, passwd);
                    if(res != "") {
                        alert("Fehler beim Zeichnungstransfer auf SAP-Laufwerk: " + res);
						break;
					}
                }
                else if (strExecutable == "copy")
                {
					if (strType == "CRM") {
						var aParam = [strParams];
						aPDFFilesforCRMTransferComplete.push(strParams);
						ret = TransferFilestoCRM(aParam);
						if (! ret) {
							alert("Fehler beim Zeichnungstransfer in den Sharepoint!");
							break;
						}
					}
					else {
						ret = copyfile(strParams, strPrgPath, 0);     // 0 = vorhandene Datei berschreiben ...
					}
                }
                else if (strExecutable == "unlink")
                {
                    ret = filecommand("unlink", strParams);
                }
                else
                {
                    nAnzAufruf++;
                    setstring("CAD_GENERATOR_STATUS", "", translate("CAD_GEN_PROGRESS_DIMSHEET") + " " +nAnzAufruf);   
                    logtrace("   ... process file " +nAnzAufruf+ ": " +strParams+ "\n");
                    shellexecuteexblocking( "\"" + strExecutable + "\"", "\"" + utf8toansi(strParams) + "\"", "\"" + strPrgPath + "\"", 0, 256000 );    // show = 1, timeout
                }
            }
        }
		
		if (strType == "CRM") 
		{
			
			var oDate = this.getDateObject();
			var ProjectSettings = "PROJECT.SETTINGS";
			var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
			strAngebNr = trimleft(strAngebNr, " ");
            strAngebNr = trimright(strAngebNr, " ");
            strAngebNr = replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});
				
			var strPrgPath  = getstddirectory( "PROGRAM" ) + "catalog\\plugin\\";    // inkl. trailing Backslash
			var strExecutable = strPrgPath + "pdftk.exe";
			
			var strPdfInputListeCRM = "";
			var DateiCRM="";
			
			if (aPDFFilesforCRMTransferComplete.length > 0)
			{
				for(i=0;i<aPDFFilesforCRMTransferComplete.length;i++)
				{
					strPdfInputListeCRM += " \"" + aPDFFilesforCRMTransferComplete[i] + " \"";
				}	
				
				DateiCRM = getstddirectory( "TEMP" ) + "\\" + strAngebNr + "_" + oDate.dateexport + "_ZG.pdf";

				if (DateiCRM != "")
				{
					var strParams = strPdfInputListeCRM + " cat output \"" + DateiCRM + "\" dont_ask ";

					var strFileLineCRM = strExecutable + " " + strParams;
					var strBatfile  = gettempfile(strUserExportPath, "bat");
					writefile( strBatfile, strFileLineCRM, "wc" );

					// Datei erzeugen
					// shellexecuteexblocking( strExecutable, strParams, strUserExportPath, 1, 256000 );    // show = 1
					shellexecuteexblocking( strBatfile, "", strUserExportPath, 0, 256000 );    // show = 1
				
				
					if(FileName.fileExists(DateiCRM))
					{
						var aParam = [DateiCRM];
						ret = TransferFilestoCRM(aParam);
						if (! ret) {
							alert("Fehler beim Zeichnungstransfer/Komplettzeichnung in den Sharepoint!");
							break;
						}
					}
				}
			}
		}

        logtrace("Processing finished ...\n");
        setstring("CAD_GENERATOR_STATUS", "", "MSG_CAD_FINISH");
        // @@@ Status im Progressbar: alert("Die Erzeugung von CAD-Dateien ist jetzt beendet. Bitte OK clicken und danach Aktualisieren.");

        if (nSapLogin)
            res = FileName.cancelNetConnection(netShare);

    },
    
    updateCadProgressAction : function()
    {
        var response = {
            success : true,
            message : '',
            status  : ''
        };

        var strStatus = getstring("CAD_GENERATOR_STATUS", "");
        response.status = strStatus;
        response.message = translate(strStatus);
                
        echo JSON.stringify(response);
        _global.MIMETYPE = 'application/json';    
    },

    writeTextParam : function(strOutFile, strID, strValue)
    {
        writefile( strOutFile, "\t\t\t<textparam id=\""+strID+"\" value=\""+strValue+"\" /> \r\n", "a" );
    },

    getFileComponents : function(strType)
    {
        var retObj = { bIniMode: true, strTime: "", strPrgPath: "", strExecutable: "", strModelPath: "", strDataPath: ""};

        retObj.strPrgPath  = getstddirectory( "PROGRAM" );    // inkl. trailing Backslash

        getdate('CURRENT_TIME','TEMP');
        var strYear  = getstring('YEAR','TEMP.CURRENT_TIME');
        var strMonth = getstring('MONTH','TEMP.CURRENT_TIME');
        var strDay   = getstring('DAY','TEMP.CURRENT_TIME');
        var strHour  = getstring('HOUR','TEMP.CURRENT_TIME');
        var strMin   = getstring('MINUTE','TEMP.CURRENT_TIME');
        var strSec   = getstring('SECOND','TEMP.CURRENT_TIME');
        if (strMonth.length < 2)
            strMonth = "0" + strMonth;
        if (strDay.length < 2)
            strDay = "0" + strDay;
        if (strHour.length < 2)
            strHour = "0" + strHour;
        if (strMin.length < 2)
            strMin = "0" + strMin;

        retObj.strTime  = strYear + strMonth + strDay +
                          strHour + strMin + strSec;

        retObj.strDataPath  = retObj.strPrgPath;
        retObj.strModelPath = retObj.strPrgPath;

		if ( checkexist( "CATALOG.3DCAD", "" ) )
		{
			var str3DCADMode = getstring( "CATALOG.3DCAD.MODE", "" );
			if ( ( str3DCADMode == "xml" ) || ( str3DCADMode == "XML" ) )
				retObj.bIniMode = false;
			// get model path
			var strPath = getstring( "CATALOG.3DCAD.MODELPATH", "" );
			if ( strPath.substring( 0, 2 ) == ".\\" )
			{
				// relative path
				strPath = strPath.substring( 2 );
				retObj.strModelPath += strPath;
			}
			else if ( strPath != "" )
				retObj.strModelPath = strPath;		// absolute path

			// get path for .ini-or .xml-file
			strPath = getstring( "CATALOG.3DCAD.DATAPATH", "" );
			if ( strPath.indexOf( "$TMP$" ) > -1 )
				strPath = strPath.replace( "$TMP$", getstddirectory( "TEMP" ) );
			else if ( strPath.indexOf( "$TEMP$" ) > -1 )
				strPath = strPath.replace( "$TEMP$", getstddirectory( "TEMP" ) );
			if ( strPath.indexOf( "$PROGDIR$" ) > -1 )
				strPath = strPath.replace( "$PROGDIR$", trimright(retObj.strPrgPath, "\\") );
			if ( strPath.substring( 0, 2 ) == ".\\" )
			{
				// relative path
				strPath = strPath.substring( 2 );
				retObj.strDataPath += strPath;
			}
			else if ( strPath != "" )
			{
				// ----------------------------------------------------------------------
				//dataDir	= strPath;			// absoluter Pfad aus catpaths
				var dataDir	= "";
				var IsNotTestsystem		= (getint("IS_TESTSYSTEM", "CATALOG.TESTSYSTEM") ? "" : "not");
				var strSQLStatement		= "select * from DATAPATH where LOCATION " + IsNotTestsystem + " like 'TESTSYSTEM' order by abs(SEQ_ID) ";
				var numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
				var CAD_DATAPATH		= "";
				var CAD_PATH_OPTIONS	= [];
				while (dbiseof("PATH") == 0)
				{
					CAD_DATAPATH		= dbgetstring("PATH", "CAD_DATAPATH");
					
					// hier stehen zum Teil absolute aber auch Netzwerkpfade drin
					if (left(CAD_DATAPATH, 1) == "\\")
						CAD_DATAPATH	= "\\" + CAD_DATAPATH;
					
					if ( CAD_DATAPATH.indexOf( "$TMP$" ) > -1 )
						CAD_DATAPATH = CAD_DATAPATH.replace( "$TMP$", getstddirectory( "TEMP" ) );
					else if ( CAD_DATAPATH.indexOf( "$TEMP$" ) > -1 )
						CAD_DATAPATH = CAD_DATAPATH.replace( "$TEMP$", getstddirectory( "TEMP" ) );
					CAD_PATH_OPTIONS.push(CAD_DATAPATH);
					if(FileName.dirExists(CAD_DATAPATH + "\\"))
						dataDir	= CAD_DATAPATH;		// Pfad aus DB existiert
					
					dbskip("PATH");
				}
				if (dataDir == "" && IsNotTestsystem == "")	// Vorgegebene Pfade fr Testsystem existieren noch nicht
				{
					for (var i=0; i<CAD_PATH_OPTIONS.length; i++){
						var DirExists = FileName.dirExists(CAD_PATH_OPTIONS[i] + "\\");
						if (!DirExists){
							myMainController = new CaController();
							DirExists = myMainController.dataAccess.CreatePath(CAD_PATH_OPTIONS[i]);
						}
						if (DirExists)
							break;
					}
					dataDir = CAD_PATH_OPTIONS[min(i, CAD_PATH_OPTIONS.length-1)];
				}
				if (dataDir == "")
					dataDir	= strPath;
				
				if ( dataDir.indexOf( "$TMP$" ) > -1 )
					dataDir = dataDir.replace( "$TMP$", getstddirectory( "TEMP" ) );
				else if ( dataDir.indexOf( "$TEMP$" ) > -1 )
					dataDir = dataDir.replace( "$TEMP$", getstddirectory( "TEMP" ) );
				
				retObj.strDataPath = dataDir;
				// ----------------------------------------------------------------------
				
				// ORIGINAL
				/*
				retObj.strDataPath = strPath;		// absolute path
				*/
			}
			// Damit das CAD wenigstens immer funktioniert:
            if (!FileName.dirExists(retObj.strDataPath))
                retObj.strDataPath = getstddirectory( "TEMP" );

			// get executable
			strPath = getstring( "CATALOG.3DCAD.EXECUTABLE", "" );
			if ( strPath.substring( 0, 2 ) == ".\\" )
			{
				// relative path
				strPath = strPath.substring( 2 );
				retObj.strExecutable = "\"" + retObj.strPrgPath + strPath + "\"";
			}
			else if ( strPath != "" )
			{
				// absolute path
				retObj.strExecutable = "\"" + strPath + "\"";
			}
		}
		else
		{
			// defaults
			retObj.bIniMode = false;
			retObj.strModelPath += "cad\\projekt\\Auswahl\\";
		}

        retObj.strProjectPath  = retObj.strPrgPath;
        retObj.strTransferPath = retObj.strPrgPath;
		if ( checkexist( "CATALOG.SAP", "" ) &&
             (getstring("SAP_ENABLED", "RIGHTS") == "1") )
		{
			// get project path
			var strPath = getstring( "CATALOG.SAP.PROJEKTORDNER", "" );
            // nur absolute Pfade werden untersttzt
			if ( strPath != "" )
            {
				// ----------------------------------------------------------------------
				//dataDir	= strPath;			// absoluter Pfad aus catpaths
				var dataDir	= "";
				var IsNotTestsystem		= (getint("IS_TESTSYSTEM", "CATALOG.TESTSYSTEM") ? "" : "not");
				var strSQLStatement		= "select * from DATAPATH where LOCATION " + IsNotTestsystem + " like 'TESTSYSTEM' order by abs(SEQ_ID) ";
				var numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
				var PROJEKTORDNER		= "";
				var PROJEKTORDNER_OPTIONS	= [];
				while (dbiseof("PATH") == 0)
				{
					PROJEKTORDNER		= dbgetstring("PATH", "PATH_PROJEKTORDNER");
					if ( PROJEKTORDNER.indexOf( "$TMP$" ) > -1 )
						PROJEKTORDNER = PROJEKTORDNER.replace( "$TMP$", getstddirectory( "TEMP" ) );
					else if ( PROJEKTORDNER.indexOf( "$TEMP$" ) > -1 )
						PROJEKTORDNER = PROJEKTORDNER.replace( "$TEMP$", getstddirectory( "TEMP" ) );
					PROJEKTORDNER_OPTIONS.push(PROJEKTORDNER);
					if(FileName.dirExists(PROJEKTORDNER + "\\"))
						dataDir	= PROJEKTORDNER;		// Pfad aus DB existiert
					
					dbskip("PATH");
				}
				if (dataDir == "" && IsNotTestsystem == "")	// Vorgegebene Pfade fr Testsystem existieren noch nicht
				{
					for (var i=0; i<PROJEKTORDNER_OPTIONS.length; i++){
						var DirExists = FileName.dirExists(PROJEKTORDNER_OPTIONS[i] + "\\");
						if (!DirExists)
							myMainController = new CaController();
							DirExists = myMainController.dataAccess.CreatePath(PROJEKTORDNER_OPTIONS[i]);
						if (DirExists)
							break;
					}
					dataDir = PROJEKTORDNER_OPTIONS[min(i, PROJEKTORDNER_OPTIONS.length-1)];
				}
				if (dataDir == "")
					dataDir	= strPath;
				
				if ( dataDir.indexOf( "$TMP$" ) > -1 )
					dataDir = dataDir.replace( "$TMP$", getstddirectory( "TEMP" ) );
				else if ( dataDir.indexOf( "$TEMP$" ) > -1 )
					dataDir = dataDir.replace( "$TEMP$", getstddirectory( "TEMP" ) );
				
				strPath = dataDir;
				// ----------------------------------------------------------------------
				
				if ( strPath.charAt( strPath.length - 1 ) != "\\" )
                    strPath += "\\";
                var strAngebNr   = getstring("WI_ANGEBOTSNR",  "PROJECT.SETTINGS");
                strAngebNr = trimleft(strAngebNr, " ");
                strAngebNr = trimright(strAngebNr, " ");
                strAngebNr = replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});

                // das hier wird nicht nur im Auftragsfall aufgerufen, soll aber nur im Auftragsfall gemacht werden
                if ((strAngebNr != "") && (strType == "SAP"))   
                {
                    // Prfen ob Pfad da ist, notfalls anlegen ...
                    var strAuftragsPfad = strPath + strAngebNr;
                    if (!FileName.dirExists(strAuftragsPfad))
                    {
                        var ret = filecommand("mkdir", strAuftragsPfad);
                        if (ret == 0)
                            alert(replace(translate("ERR_FOLDER_ANGEBOT"), "#x#", strAuftragsPfad));
                    }
                    retObj.strProjectPath = strAuftragsPfad;		// absolute path
                }
                else
                    retObj.strProjectPath = strPath;
            }

			// get transfer path for sap
			strPath = getstring( "CATALOG.SAP.TRANSFERORDNER", "" );
            // nur absolute Pfade werden untersttzt
			if ( strPath != "" ){
				var strSQLStatement		= "select * from TRANSFER where GATE='" + toupper(strPath) + "' order by abs(SEQ_ID) ";
				var numRet				= dbselect("CASCADE", strSQLStatement, "CONNECT");
				retObj.strTransferPath	= dbgetstring("CONNECT", "CONNECT") + strPath;		// absolute path
			}
		}

        // retObj.strUserExportPath  = utf8toansi(getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS"));
        // @@@ Prfen, ob getShortPath mit UTF8-coded Pfaden klarkommt ...
        retObj.strUserExportPath  = FileName.getShortPath(getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS"));

		// paths must end with a '\'
		if ( retObj.strDataPath.charAt( retObj.strDataPath.length - 1 ) != "\\" )
			retObj.strDataPath += "\\";
		if ( retObj.strModelPath.charAt( retObj.strModelPath.length - 1 ) != "\\" )
			retObj.strModelPath += "\\";
		if ( retObj.strProjectPath.charAt( retObj.strProjectPath.length - 1 ) != "\\" )
			retObj.strProjectPath += "\\";
		if ( retObj.strTransferPath.charAt( retObj.strTransferPath.length - 1 ) != "\\" )
			retObj.strTransferPath += "\\";
		if ( (retObj.strUserExportPath.length > 0) &&
             (retObj.strUserExportPath.charAt( retObj.strUserExportPath.length - 1 ) != "\\" ))
			retObj.strUserExportPath += "\\";

		// we must have an executable
		if ( retObj.strExecutable == "" )
		{
			if ( retObj.bIniMode )
				retObj.strExecutable = "\"" + retObj.strPrgPath + "CAD\\MoView.exe\"";
			else retObj.strExecutable = "\"" + retObj.strPrgPath + "CadView\\CadGenPlusExt.exe\"";
		}

        return retObj;
    },

	/**
		show 3D CAD model<br>
		- build configuration file and write it to disk<br>
		- evoke CAD viewer with this configuration file
        Controller als Parameter, da evtl. auch mehrere LK's nacheinander gedruckt werden...
	*/
	show3DCAD : function( myMainController, oGenerateOptions )  // , strCADFile, bShow
	{
		// new tag '3DCAD' for settings of 3DCAD
		// mode: control file mode for 3D CAD viewer
		//      valid entrys: - 'ini' -> this function creates an inifile and the old moview is called with that file
		// 		   		      - 'xml' -> this function creates an xmlfile and the new CadGenPlus is called with that file
		// ModelPath: path to CAD models -> must be a valid path entry;
		//            paths can be relative (must start with '.\') or absolute paths (must NOT start with '.\')
		// DataPath: path where to put the generated control files to -> must be a valid path entry;
		//           paths can be relative (must start with '.\') or absolute paths (must NOT start with '.\')
		//           you can also provide the values $TMP$ and $TEMP$ (are both expanded to the user's current TMP directory)
		// Executable: path and filename of program to generate and show CAD drawings
		//            paths can be relative (must start with '.\') or absolute paths (must NOT start with '.\')

        var bQuick2D = false;
        if (oGenerateOptions.Quick2DFile != "")
            bQuick2D = true;

        var oFileComponents = this.getFileComponents(oGenerateOptions.multipleType);

        var strRand     = rand();

        // CAD-File to create (dxf):
        if (oGenerateOptions.createCadFile && (oGenerateOptions.cadFileToCreate == ""))
            oGenerateOptions.cadFileToCreate = oFileComponents.strDataPath + "ZN_" + oFileComponents.strTime + "_" + strRand + ".dxf";

        // PDF-File to create (pdf):
        if (oGenerateOptions.createPdfFile && (oGenerateOptions.pdfFileToCreate == ""))
            oGenerateOptions.pdfFileToCreate = oFileComponents.strDataPath + "ZN_" + oFileComponents.strTime + "_" + strRand + ".pdf";

        var strHaengerTyp = "";
        var HaengerDaten = myMainController.topologieKlasse.getHaengerDaten();
        if (HaengerDaten.HaengertypCode.length >= 3)
            strHaengerTyp = left(HaengerDaten.HaengertypCode, 3);
        var bHaengerMitFussplatte = false;
        if ((strHaengerTyp == "FSS") || (strHaengerTyp == "FSP") || (strHaengerTyp == "FHS") || (strHaengerTyp == "KHS") ||
            (strHaengerTyp == "KVS") || (strHaengerTyp == "KSR") || (strHaengerTyp == "KSP"))
            bHaengerMitFussplatte = true;

        var strHaengerFussDrawing = "";
        if (bQuick2D && bHaengerMitFussplatte)
        {
            var theHaenger = myMainController.topologieKlasse.getCurrentHaenger();
            var theZwischenstueck = null;
            if ((strHaengerTyp == "FSS") || (strHaengerTyp == "FSP") ||
                (strHaengerTyp == "KSR") || (strHaengerTyp == "KSP"))
            {
                if (myMainController.topologieKlasse.Zwischenstueck)
                    theZwischenstueck = myMainController.topologieKlasse.Zwischenstueck;
            }
            strHaengerFussDrawing = this.generate2DHaengerFussDrawing(theHaenger, theZwischenstueck, myMainController.topologieKlasse.a_lgv);
        }

		if ( oFileComponents.bIniMode )
		{
			// paths and names
			var strOutFile = oFileComponents.strDataPath + "CAD_" + strRand + ".ini";

			// write header
			writefile(strOutFile, "[Header] \r\n", "wc");	// write, create
			writefile(strOutFile, "Infile=" + oFileComponents.strModelPath + "Auswahl_LKtyp.StvModel \r\n", "a");

			writefile(strOutFile, "Outsections=0 \r\n", "a");
			writefile(strOutFile, "ShowLog=0 \r\n", "a");
			writefile(strOutFile, "Sequential=0 \r\n", "a");
			writefile(strOutFile, "Check=0 \r\n", "a");
			writefile(strOutFile, " \r\n", "a");
			writefile(strOutFile, "[Params] \r\n", "a");
		}
		else
		{
			// paths and names
            var strOutFile = oGenerateOptions.xmlFileToCreate;
            if (strOutFile == "")
                strOutFile = oFileComponents.strDataPath + "ZG_" + oFileComponents.strTime + "_" + strRand + ".xml";
			var date = new Date();

            var bLageplanVorhanden = false;
            if ((getstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                (getstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN") != "") ||
                ((getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN") != "") &&
                 (getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN") != "0")) ||
                (getstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN") != ""))
                bLageplanVorhanden = true;

            var oCadInfos = myMainController.topologieKlasse.getCadInfos(bQuick2D, bHaengerMitFussplatte, bLageplanVorhanden);
			
			// -Sch- Festlegung des Dateinamens zum Export
			var Mark		= getstring("IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE");
			var Schelle		= getstring("m_Ptyp", "DLGDATA.CA.SELECTION.TOPOCLASS.Schelle");
			var Lager		= getstring("m_Ptyp", "DLGDATA.CA.SELECTION.TOPOCLASS.Lager");
			var Zubehoer	= getstring("m_Ptyp", "DLGDATA.CA.SELECTION.TOPOCLASS.Zubehoer");
			//var Haenger		= getstring("m_Ptyp", "DLGDATA.CA.SELECTION.TOPOCLASS.Haenger");
			if (getstring("m_Ptypid", "DLGDATA.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger") != "")
				var Haenger		= getstring("m_Ptypid", "DLGDATA.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger");
			else
				var Haenger		= getstring("m_Ptyp", "DLGDATA.CA.SELECTION.TOPOCLASS.Haenger");
			
			if ((Schelle != "" && Haenger != "") || (Zubehoer != "" && Haenger != "") || (Lager != "" && Haenger != ""))
				var DatNam	= translate ('LASTKETTE');
			else if (Mark != "")
				var DatNam	=	Mark;
			else if (Schelle != "")
				var DatNam	=	Schelle;
			else if (Lager != "")
				var DatNam	=	Lager;
			else if (Zubehoer != "")
				var DatNam	=	Zubehoer;
			else if (Haenger != "")
				var DatNam	=	Haenger;
			else
				var DatNam	=	translate ('LASTKETTE');
			
			// adjust with real values
			writefile( strOutFile, "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \r\n", "wc" );
			writefile( strOutFile, "<caddata> \r\n", "a" );
  			writefile( strOutFile, "  <control> \r\n", "a" );
			writefile( strOutFile, "\t<group value=\"RTW\"/> \r\n", "a" );
			writefile( strOutFile, "\t<model value=\"" + oFileComponents.strModelPath + oCadInfos.headModel + "\"/> \r\n", "a" );
			writefile( strOutFile, "\t<displayname value=\"" + DatNam + "\"/> \r\n", "a" );
            if (oGenerateOptions.generateShowOperation)
            {
                writefile( strOutFile, "\t<operation type =\"show\"> \r\n", "a" );
                writefile( strOutFile, "\t\t<gui option=\"language\" value=\"DE\"/> \r\n", "a" );
                writefile( strOutFile, "\t</operation> \r\n", "a" );
            }
/*
			writefile( strOutFile, "<operation type ="create">
			writefile( strOutFile, "<output file=".\LK_2D_Ansicht.dxf"  type="DXF" is3D="false" dimensions="true" >
			writefile( strOutFile, "<hiddenLine value="false"/>
			writefile( strOutFile, "<projection value="FRONT"/>
			writefile( strOutFile, "</output>
			writefile( strOutFile, "</operation>
*/
            if (oGenerateOptions.generateLayoutOperation)
            {
                var AchsKSInfo	 = myMainController.dataAccess.getAchsKSInfo();
				var Zusatzlast   = myMainController.topologieKlasse.calculateZusatzlast();	// aus Eigengewicht
				var Zusatzlast2	 = caMainController.dataAccess.getSollwerteZusatzLast(1, AchsKSInfo[6]);	// "echte" Zusatzlast
                var SchelleDaten = myMainController.topologieKlasse.getSchelleDaten();
                var oLKinfo      = myMainController.dataAccess.getLKinfoDaten();
                var oLKWinkel    = myMainController.topologieKlasse.getLKWinkel();
                var oOptions     = myMainController.presets.getPreisOptions();
                var LKMatInfo    = myMainController.topologieKlasse.getLastkettenIdent(myMainController);

                var ncolAnz = 1;
                if (oCadInfos.lagerEinzel || right(oCadInfos.rahmenDxf, 2) == "RL")	// auch LK-RL haben 2. Ansicht
                    ncolAnz = 2;

                var ngridAnz = 4;

                if (bHaengerMitFussplatte || oCadInfos.lagerFuss)
                    ngridAnz = 5;

                writefile( strOutFile, "\t<operation type=\"layout\"> \r\n", "a" );
                if (oGenerateOptions.cadFileToCreate != "")
                    writefile( strOutFile, "\t\t<output file=\"" + oGenerateOptions.cadFileToCreate + "\" type=\"DXF\" /> \r\n", "a" );

                if (oGenerateOptions.pdfFileToCreate != "")
                {
                    writefile( strOutFile, "\t\t<output file=\"" + oGenerateOptions.pdfFileToCreate + "\" type=\"PDF\" > \r\n", "a" );

					// A3 quer:
                    writefile( strOutFile, "\t\t<pixopt width=\"420\" height=\"297\" /> \r\n", "a" );
                    // A4 quer:
                    //writefile( strOutFile, "\t\t<pixopt width=\"297\" height=\"210\" /> \r\n", "a" );

                    writefile( strOutFile, "\t\t</output> \r\n", "a" );
                }

                writefile( strOutFile, "\t\t<base file=\"_basewit.dxf\" /> \r\n", "a" );
                if (oGenerateOptions.pdfFileToCreate != "")
                    writefile( strOutFile, "\t\t<mapping file=\"wi_bw.ini\" /> \r\n", "a" );
                else
                    writefile( strOutFile, "\t\t<mapping file=\"wi_color.ini\" /> \r\n", "a" );
                writefile( strOutFile, "\t\t<logging file=\"_LK1.log\" /> \r\n", "a" );
                writefile( strOutFile, "\t\t<layout scheme=\"multigrid\" grids=\""+ngridAnz+"\" scaling=\"optimal\"> \r\n", "a" );
				//writefile( strOutFile, "\t\t<frame file=\".\\Rahmen\\"+oCadInfos.rahmenDxf+"_"+strAktuelleSprache+".dxf\" infofile=\".\\Rahmen\\"+oCadInfos.rahmenIni+"\" /> \r\n", "a" ); // SPRACHABHAENGIGE DXF_RAHMEN                
                // SPRACHUNABHNGIGER DXF-RAHMEN
				writefile( strOutFile, "\t\t<frame file=\".\\Rahmen\\"+oCadInfos.rahmenDxf+".dxf\" infofile=\".\\Rahmen\\"+oCadInfos.rahmenIni+"\" /> \r\n", "a" );
                writefile( strOutFile, "\t\t<grids> \r\n", "a" );

            // --------- START GRIDS
                if (bQuick2D)
                {
                    writefile( strOutFile, "\t\t  <grid id=\"grid1\" rows=\"1\" cols=\"1\" type=\"master\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t  <view id=\"FRONT\" type=\"file\" file=\""+oGenerateOptions.Quick2DFile+"\"  mappingid=\"FRONT\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid2\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    if (bLageplanVorhanden)
                        writefile( strOutFile, "\t\t\t  <view id=\"LAGE\" type=\"file\" file=\".\\Rahmen\\lageplan1.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
                    else
                        writefile( strOutFile, "\t\t\t  <view id=\"LAGE\" type=\"file\" file=\".\\Rahmen\\empty.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid3\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" ); 
                    writefile( strOutFile, "\t\t\t  <view id=\"ISO\" type=\"file\" file=\".\\Rahmen\\empty.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\"  /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid4\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    //writefile( strOutFile, "\t\t\t  <view id=\"KOORD\" type=\"file\" file=\".\\Rahmen\\rh_koord.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
					writefile( strOutFile, "\t\t\t  <view id=\"KOORD\" type=\"file\" file=\".\\Rahmen\\"+caMainController.dataAccess.getKSImage()+".dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    // Neu: Kundenlogo
                    writefile( strOutFile, "\t\t  <grid id=\"gridlogo\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t  <view id=\"LOGO\" type=\"file\" file=\""+getstddirectory( "PROGRAM" )+"CADView\\Rahmen\\logo_wit.dxf\"  mappingid=\"TOP\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    if (ngridAnz == 5)      // Zustzliche Ansicht der Fuplatte als eigene generierte DXF-Datei
                    {
                        writefile( strOutFile, "\t\t  <grid id=\"grid5\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                        writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                        writefile( strOutFile, "\t\t\t  <view id=\"FUSS\" type=\"file\" file=\""+strHaengerFussDrawing+"\"  mappingid=\"TOP\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                        writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                        writefile( strOutFile, "\t\t  </grid> \r\n", "a" );
                    }
                }
                else
                {
                    writefile( strOutFile, "\t\t  <grid id=\"grid1\" rows=\"1\" cols=\""+ncolAnz+"\" type=\"master\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t  <view id=\"FRONT\" type=\"projection\" mappingid=\"FRONT\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    if (oCadInfos.lagerEinzel || right(oCadInfos.rahmenDxf, 2) == "RL")	// auch LK-RL haben 2. Ansicht
                        writefile( strOutFile, "\t\t\t  <view id=\"LEFT\" type=\"projection\" mappingid=\"LEFT\" row=\"1\" col=\"2\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid2\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    if (bLageplanVorhanden)
                        writefile( strOutFile, "\t\t\t  <view id=\"LAGE\" type=\"file\" file=\".\\Rahmen\\lageplan1.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
                    else
                        writefile( strOutFile, "\t\t\t  <view id=\"LAGE\" type=\"file\" file=\".\\Rahmen\\empty.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid3\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t  <view id=\"ISO\" type=\"projection\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    writefile( strOutFile, "\t\t  <grid id=\"grid4\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    // vorerst kein KS auf DB bei Lager in senkr. Leitung
					if (left(AchsKSInfo[9],5) == "LG_RV" && oCadInfos.rahmenDxf == "Rahmen-wit_LG_RL")
						writefile( strOutFile, "\t\t\t  <view id=\"KOORD\" type=\"file\" file=\".\\Rahmen\\empty.dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
					else
						writefile( strOutFile, "\t\t\t  <view id=\"KOORD\" type=\"file\" file=\".\\Rahmen\\"+caMainController.dataAccess.getKSImage()+".dxf\" mappingid=\"ISO\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
					writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    // Neu: Kundenlogo
                    writefile( strOutFile, "\t\t  <grid id=\"gridlogo\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t  <view id=\"LOGO\" type=\"file\" file=\""+getstddirectory( "PROGRAM" )+"CADView\\Rahmen\\logo_wit.dxf\"  mappingid=\"TOP\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                    writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                    writefile( strOutFile, "\t\t  </grid> \r\n", "a" );

                    if (ngridAnz == 5)      // Zustzliche Ansicht der Fuplatte als Top-Ansicht
                    {
                        writefile( strOutFile, "\t\t  <grid id=\"grid5\" rows=\"1\" cols=\"1\" type=\"independent\"> \r\n", "a" );
                        writefile( strOutFile, "\t\t\t<views> \r\n", "a" );
                        //writefile( strOutFile, "\t\t\t  <view id=\"TOP\" type=\"projection\" mappingid=\"TOP\" row=\"1\" col=\"1\" scale=\"1.0\" dimensions=\"true\" /> \r\n", "a" );
                        writefile( strOutFile, "\t\t\t  <view id=\"FUSS\" type=\"file\" file=\".\\Rahmen\\Fuss_" + oCadInfos.lagerFussTyp + ".dxf\" mappingid=\"TOP\" row=\"1\" col=\"1\" scale=\"1.0\" /> \r\n", "a" );
						writefile( strOutFile, "\t\t\t</views> \r\n", "a" );
                        writefile( strOutFile, "\t\t  </grid> \r\n", "a" );
                    }
                }
            // --------- ENDE GRIDS

                writefile( strOutFile, "\t\t</grids> \r\n", "a" );
                writefile( strOutFile, "\t\t<textblocks /> \r\n", "a" );
                writefile( strOutFile, "\t\t  <textparams> \r\n", "a" );

                this.writeTextParam(strOutFile, "Application", "Flexperte");
                this.writeTextParam(strOutFile, "DATE", date.toDateString());
                this.writeTextParam(strOutFile, "vers", getstring("VERSION","CATALOG"));


                // Hauptbemerkung im Zeichnungskopf:
                //this.writeTextParam(strOutFile, "bem1", utf8toansi(oLKinfo.bemerkung));    // Bemerkung aus bersicht Lastkette
				this.writeTextParam(strOutFile, "bem1", oLKinfo.bemerkung);    // Bemerkung aus bersicht Lastkette
				
				// Hinweise zu Knaggen / Rundnocken bei Vertikalschellen
				var strBemLieferumfang	= "";
				var Schelle_SUB			= left(SchelleDaten.typ, 1) + right(SchelleDaten.typ, 1);
				if (Schelle_SUB == "VK")		// VBK / VKK
					strBemLieferumfang	= "*) " + translate("ID_CA_ARTIKEL_KNAGGEN_K_LIEFER");
				else if (Schelle_SUB == "VR"){	// VGR / VSR / VPR
					var strSQLStatement	= "select * from " + SchelleDaten.typ + " where nennweite = " + SchelleDaten.nennweite + " ";   // order by ...
					var numRet			= dbselect("CASCADE", strSQLStatement, "SCHEL_PRODUKT_SELECT");
					var dBohr			= dbgetdouble("SCHEL_PRODUKT_SELECT", "d_");
					strSQLStatement		= "select * from ROHRD where Bohr_VxR = " + dBohr + " ";
					numRet				= dbselect("CASCADE", strSQLStatement, "D_SELECT");
					var dNocken			= dbgetdouble("D_SELECT", "D");
					strBemLieferumfang	= "*) " + translate("ID_CA_ARTIKEL_RUNDNOCKEN_K_LIERFER") + " (dN=" + dNocken + "mm)";
				}
				this.writeTextParam(strOutFile, "bem_lieferumfang", strBemLieferumfang);
				
                // Zusatzinfos links unten:
                // Bem2: Schrgzug
                // 140814 - Schu - weitere Verwendung fr Hinweis auf Listenauswahl von Rollenlagern
				var strBem2 = "";
                if (oLKWinkel.a_Schraegzug > 0)		// sollte bei Festpunkt nie der Fall sein
                {
                    //if (oLKWinkel.a_Schraegzug_50 > oLKWinkel.Grenzwert)
					if (!oLKWinkel.bErlaubt && !oLKWinkel.bMoeglich)
                        strBem2 += translate("IDP_SCHRAEGZUG_VORSP_ZU_GROSS") + " ";
                    else if (oLKWinkel.a_Schraegzug_100 > oLKWinkel.Grenzwert)
                        strBem2 += translate("IDP_SCHRAEGZUG_VORSP_50") + " ";
                }
				else if ((right(SchelleDaten.LagerTyp,2)*1 >= 23 || right(SchelleDaten.LagerTyp,2)*1 <= 2)
							&& (left(SchelleDaten.typ,3) == "FLN" || left(SchelleDaten.typ,3) == "FVN"
								|| left(SchelleDaten.typ,3) == "FLV" || left(SchelleDaten.typ,2) == "FS"))
					strBem2 += translate("ID_HINWEIS_FEST_RUTSCHSI") + " ";
				
                if (oOptions.SONDERANSTRICH_TEXT != "")
                    this.writeTextParam(strOutFile, "bem3", utf8toansi(translate("IDC_WI_SONDERANSTRICH_LABEL")) + " " + utf8toansi(oOptions.SONDERANSTRICH_TEXT));    // Sonderanstrich
                else
                    this.writeTextParam(strOutFile, "bem3", "");
				
                if ((HaengerDaten.Haengertyp == "F") && (HaengerDaten.Beschichtung == "TERROSON"))
                    this.writeTextParam(strOutFile, "bem4", utf8toansi(translate("FEDER_TERROSONBESCHICHTET")));    // Terrosonbeschichtung
                else if ((HaengerDaten.Haengertyp == "K") &&  (HaengerDaten.Beschichtung == "TERROSON"))
                    this.writeTextParam(strOutFile, "bem4", utf8toansi(translate("FEDER_TERROSONBESCHICHTET")));    // Terrosonbeschichtung
				else
                    this.writeTextParam(strOutFile, "bem4", "");
				
                /* Wegen anderer Betriebsdaten bei Lagern einzel kann man hier nicht einfach
                   auf die Dialogdaten zugreifen ...
                */
                var strNennweite  = SchelleDaten.nennweite;
                var strRaD        = SchelleDaten.aussendurch;
                var strDaemmdicke = SchelleDaten.Daemmdicke;
                var strMediumtemp = SchelleDaten.MediumTemperatur;
                
				//var test	= myMainController.dataAccess.getNennweite(0);
				
				// Vorne "kein RuT" nicht angewhlt, aber hinten bei Schelle "ohne" gewhlt: Daten RuT trotzdem ausgeben ...
                if ((strNennweite == "") && ! myMainController.dataAccess.isLastketteMitLagerMoeglich() &&
                    myMainController.dataAccess.getLastketteMitSchelle())
                {
                    strNennweite  = myMainController.dataAccess.getNennweite(0);
                    strRaD        = myMainController.dataAccess.getRohrAussendurchmesser(0);
                    strDaemmdicke = myMainController.dataAccess.getDaemmdicke(0);
                    strMediumtemp = myMainController.dataAccess.getMediumTemperatur(0);
                }

				/*  19.1.2009: Vorgabe zur Ausgabe der last bei FH:
				1) Unblockiert:
						z-Last = "-"

				2) Mittig blockiert aus Typanalyse (kann nur 1 Hnger sein):
						z-Last = - (fMin + fMax) / 2

				3) Mittig blockiert aus RH-Auswahl 
				a)      1 Hnger:
								z-Last = - (fMin + fMax) / 2
				b)      2 Hnger:
								z-Last = - 2 * (fMin + fMax) / 2

				4) Blockiert aus RH-Auswahl 
				a)      1 Hnger:
								z-Last = Eingegebene Last negativ
				b)      2 Hnger:
								z-Last = Eingegebene Last negativ
				*/
				
				//var vLast  = -1 * abs(myMainController.dataAccess.getSollwerteLast("vertikal", 1));
				var vLast  = -1 * abs(myMainController.dataAccess.getSollwerteLast("vertikal-", 1, AchsKSInfo[6]));
                //var vBeweg = abs(myMainController.dataAccess.getSollwerteBewegung("vertikal", 1));
				var vBeweg			= myMainController.dataAccess.getSollwerteBewegung("vertikal+", 1, AchsKSInfo[6]);
				var vBeweg_minus	= myMainController.dataAccess.getSollwerteBewegung("vertikal-", 1, AchsKSInfo[6]);
                /*
				if (myMainController.dataAccess.getSollwerteRichtungBewegung() == "AB")
                {
                    vBeweg = -1 * vBeweg;
                }
				*/
                if (HaengerDaten.Blockierung == "BLOCK_MITTIG")
                {
					// 12.1.09: Bei KH soll da die eingegene Last ausgegeben werden
                    if (HaengerDaten.Haengertyp == "F")
                    {
                        vLast  = -1 * HaengerDaten.anz_haenger * HaengerDaten.kaltlast;
                    }

					if (int(vBeweg) == 0)
						vBeweg = "-";
					//else
						//vBeweg = "+-" + fround(abs(vBeweg) / 2, 0);   // HaengerDaten.wegreserve_oben;
                }
                if (HaengerDaten.Blockierung == "BLOCK_NEIN")   // derzeit nur FH
                {
                    vLast  = "-";
                    vBeweg = "-";
					HaengerDaten.lastaenderung = "-";
                }
                
				// neuer Part Lager, Rollenlager, Sattel, AHS, KSY
                if (myMainController.topologieKlasse.Abhebesicherung || myMainController.topologieKlasse.Rollenlager
					|| myMainController.topologieKlasse.Sattel || myMainController.topologieKlasse.Klemmsystem
					|| myMainController.topologieKlasse.Gleitelement || oCadInfos.lagerEinzel)
				{
					var LG_Session	= myMainController.topologieKlasse.getDlgLagerSession();
					var dataPath	= "DLGDATA.CA.FORMS.LAGER2DATA";
					this.writeTextParam(strOutFile, "axbew", "-" + abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_minus.axial) +
										"/+" + abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_plus.axial));
					this.writeTextParam(strOutFile, "latbew", "-" + abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_minus.quer) +
										"/+" + abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_plus.quer));
					this.writeTextParam(strOutFile, "senkla", "-" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_minus.schief) +
										"/+" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_plus.schief));
					this.writeTextParam(strOutFile, "axla", "-" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_minus.axial) +
										"/+" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_plus.axial));
					this.writeTextParam(strOutFile, "latla", "-" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_minus.quer) +
										"/+" + abs(LG_Session.SollwerteHalterungspunkt.oTable.last_plus.quer));
					var axbew_zul_SAT	= "-";
					var axbew_zul_AHS	= "-";
					var axbew_zul_LG	= "-";
					var latbew_zul		= "-";
					var senkla_zul_ab	= "-";	// ab	... abhebend
					var senkla_zul_auf	= "-";	// auf	... aufliegend
					var axla_zul		= "-";
					var latla_zul		= "-";
					var Profilart		= "-";
					var Traegergroesse	= "-";
					var Gurtdicke		= "-";
					
					strNennweite  = "-";
					strRaD        = "-";
					strDaemmdicke = "-";
					strMediumtemp = "-";
					
					if (myMainController.topologieKlasse.Sattel || myMainController.topologieKlasse.Lager)
					{
						// allgemeine Angaben
						strNennweite  = (LG_Session.SollwerteRohrUmTeil.bAussenDuMesserSonder ? "-" : 
											LG_Session.SollwerteRohrUmTeil.strSelNennweiteCombo);
						strRaD        = (LG_Session.SollwerteRohrUmTeil.bAussenDuMesserSonder ? LG_Session.SollwerteRohrUmTeil.dAussenDuMesserSonder :
											LG_Session.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
						strDaemmdicke = LG_Session.SollwerteRohrUmTeil.dDaemmDicke;
						strMediumtemp = LG_Session.SollwerteRohrUmTeil.dTemperaturMedium;
						if (myMainController.topologieKlasse.Sattel)	// Sattel
						{
							axbew_zul_SAT = (!LG_Session.AuswahlSattel.bSonderLength*1 ? LG_Session.AuswahlSattel.strSelComboLength :
												(LG_Session.AuswahlSattel.dSonderLength)) - 50;
							senkla_zul_ab	= LG_Session.AuswahlSattel.oSearchResult.oResultSattel.F_AB_CALCULATION;
							senkla_zul_auf	= LG_Session.AuswahlSattel.oSearchResult.oResultSattel.F_AUFL_CALCULATION;
							latla_zul		= LG_Session.AuswahlSattel.oSearchResult.oResultSattel.F_QUER_CALCULATION;
						}
						else	// Lager
						{
							if (!LG_Session.AuswahlStandard.oSearchResult.oResultGleitelement){
								axbew_zul_LG	= LG_Session.AuswahlStandard.oSearchResult.oResultLager.W_AXIAL;
								latbew_zul		= (LG_Session.AuswahlStandard.oSearchResult.oResultLager.W_QUER != "-" ?
													LG_Session.AuswahlStandard.oSearchResult.oResultLager.W_QUER : "-");
							}
							else{
								axbew_zul_LG	= LG_Session.AuswahlStandard.oSearchResult.oResultLager.W_LGX_AXIAL;
								latbew_zul		= LG_Session.AuswahlStandard.oSearchResult.oResultLager.W_LGX_QUER;
							}
							senkla_zul_ab	= (!LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_AB_CALCULATION ? "-" : 
												LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_AB_CALCULATION);
							senkla_zul_auf	= LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_AUFL_CALCULATION;
							latla_zul		= (!LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_QUER_CALCULATION ? "-" :
												LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_QUER_CALCULATION);
							axla_zul		= (LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_AXIAL_CALCULATION*1 != 0 ?
												LG_Session.AuswahlStandard.oSearchResult.oResultLager.F_AXIAL_CALCULATION : "-");
							if (LG_Session.AuswahlStandard.oSearchResult.oResultAbhebesicherung){
								senkla_zul_ab	= min(senkla_zul_ab, LG_Session.AuswahlStandard.oSearchResult.oResultAbhebesicherung.F_AB);
								latla_zul		= min(latla_zul, LG_Session.AuswahlStandard.oSearchResult.oResultAbhebesicherung.F_QUER);
							}
							// fr Festpunkte die zulssigen 1,4 mm nur auf DB schreiben, wenn auch
							// tatschlich Bewegungen vorhanden sind (nur ber "FIN" mglich
							if (LG_Session.Systemcharakteristik.strSelRadioLager == "LAGER_FS"){
								if (abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_plus.axial) == 0 &&
									abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_minus.axial) == 0)
										axbew_zul_LG	= "-";
								if (abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_plus.quer) == 0 &&
									abs(LG_Session.SollwerteHalterungspunkt.oTable.bewegung_minus.quer) == 0)
										latbew_zul		= "-";
								// Achtung - fr schraubbare FP nicht relevant
								if (LG_Session.AuswahlStandard.strSelRadioFixed != "SCHRAUBBAR"){
									Profilart		= LG_Session.AuswahlStandard.strSelComboBeamArt;
									Traegergroesse	= LG_Session.AuswahlStandard.strSelComboBeamSize;
									Gurtdicke		= LG_Session.AuswahlStandard.dBeamThickness;
								}
							}
						}
					}
					// Rollenlager ohne Sattel aber keine Listenauswahl
					else if (myMainController.topologieKlasse.Rollenlager && !LG_Session.Systemcharakteristik.bSel_krT){
						strRaD        = LG_Session.AuswahlRollenlager.dSupportDiameter;
					}
					// Rollenlager Listenauswahl
					else if (LG_Session.Systemcharakteristik.bSel_krT){
						strBem2			+= translate ("ID_HINWEIS_LISTENWAHL_RL") + " ";
					}
					
					if (myMainController.topologieKlasse.Abhebesicherung)
					{
						if (myMainController.topologieKlasse.Abhebesicherung.m_Ptypid != "LAW"){
							var TmpSplit	= myMainController.topologieKlasse.Abhebesicherung.m_Ptyp.split(".");
							if (right(myMainController.topologieKlasse.Abhebesicherung.m_Ptypid, 1) == "J"){
								TmpSplit	= TmpSplit[1];
							}
							else{
								TmpSplit	= TmpSplit[2];
							}
							TmpSplit		= TmpSplit.split("-");
							axbew_zul_AHS	= TmpSplit[0]*1 - (myMainController.topologieKlasse.Abhebesicherung.oData.DEL_AXBEW_ZUL)*1;
							// Korrektur der Abhebelast hier nicht notwendig, da schon in Auslegung RL bercksichtigt
						}
						else{
							latbew_zul	= myMainController.topologieKlasse.Abhebesicherung.oData.W_QUER;
						}
					}
					if (myMainController.topologieKlasse.Rollenlager)
					{
						if (myMainController.topologieKlasse.Klemmsystem){
							Profilart		= LG_Session.AuswahlStandard.strSelComboBeamArt;
							if (Profilart.length > 3)
								Profilart	= translate("ID_" + left(Profilart, rfind(Profilart, "_PROFIL")+6));
							Traegergroesse	= LG_Session.AuswahlStandard.strSelComboBeamSize;
							Gurtdicke		= LG_Session.AuswahlStandard.dBeamThickness;
						}
						else{
							Profilart		= "-";
							Traegergroesse	= "-";
							Gurtdicke		= "-";
						}
						if (!LG_Session.Systemcharakteristik.bSel_krT){
							latbew_zul = myMainController.topologieKlasse.Rollenlager.oData.W_QUER;
							if (senkla_zul_auf == "-" || (myMainController.topologieKlasse.Rollenlager.oData.F_AUFL_CALCULATION < senkla_zul_auf))
								senkla_zul_auf	= myMainController.topologieKlasse.Rollenlager.oData.F_AUFL_CALCULATION;
							if (senkla_zul_ab == "-" ||  (myMainController.topologieKlasse.Rollenlager.oData.F_AB_CALCULATION < senkla_zul_ab))
								senkla_zul_ab	= myMainController.topologieKlasse.Rollenlager.oData.F_AB_CALCULATION;
							if (latla_zul == "-" || (myMainController.topologieKlasse.Rollenlager.oData.F_QUER_CALCULATION < latla_zul))
								latla_zul	= myMainController.topologieKlasse.Rollenlager.oData.F_QUER_CALCULATION;
						}
					}
					if (myMainController.topologieKlasse.Klemmsystem && myMainController.topologieKlasse.Lager)
					{
						Profilart		= LG_Session.AuswahlStandard.strSelComboBeamArt;
						if (Profilart.length > 3)
							Profilart	= translate("ID_" + left(Profilart, rfind(Profilart, "_PROFIL")+6));
						Traegergroesse	= LG_Session.AuswahlStandard.strSelComboBeamSize;
						Gurtdicke		= LG_Session.AuswahlStandard.dBeamThickness;
						if (latla_zul == "-" ||  (myMainController.topologieKlasse.Klemmsystem.oData.F_QUER < latla_zul))
							latla_zul	= myMainController.topologieKlasse.Klemmsystem.oData.F_QUER;
					
						if (myMainController.topologieKlasse.Klemmsystem.oData.F_AB == "-" ||
							(senkla_zul_ab == "-" || myMainController.topologieKlasse.Klemmsystem.oData.F_AB*1 < senkla_zul_ab))
							senkla_zul_ab	= myMainController.topologieKlasse.Klemmsystem.oData.F_AB;
						
						if (myMainController.topologieKlasse.Klemmsystem.oData.W_QUER != "-" && 
							(latbew_zul == "-" || myMainController.topologieKlasse.Klemmsystem.oData.W_QUER*1 < latbew_zul))
							latbew_zul	= myMainController.topologieKlasse.Klemmsystem.oData.W_QUER;
					}
					else if (myMainController.topologieKlasse.Klemmsystem && !myMainController.topologieKlasse.Lager && !myMainController.topologieKlasse.Rollenlager)
					{
						Profilart		= LG_Session.AuswahlStandard.strSelComboBeamArt;
						if (Profilart.length > 3)
								Profilart	= translate("ID_" + left(Profilart, rfind(Profilart, "_PROFIL")+6));
						Traegergroesse	= LG_Session.AuswahlStandard.strSelComboBeamSize;
						Gurtdicke		= LG_Session.AuswahlStandard.dBeamThickness;
						
						latla_zul		= LG_Session.Klemmsystem.oSearchResult.oResultKlemmsystem.F_QUER;
						senkla_zul_ab	= LG_Session.Klemmsystem.oSearchResult.oResultKlemmsystem.F_AB;
						latbew_zul		= LG_Session.Klemmsystem.oSearchResult.oResultKlemmsystem.W_QUER;
					}
					else if (myMainController.topologieKlasse.Gleitelement && !myMainController.topologieKlasse.Lager)
					{
						senkla_zul_auf	= myMainController.topologieKlasse.Gleitelement.oData.F_AUFL_PTFE;
					}
					
					var axbew_zul	= axbew_zul_SAT;
					if (axbew_zul_AHS != "-" && (axbew_zul == "-" || axbew_zul_AHS*1 < axbew_zul*1))
						axbew_zul	= axbew_zul_AHS;
					if (axbew_zul_LG != "-" && (axbew_zul == "-" || axbew_zul_LG*1 < axbew_zul*1))
						axbew_zul	= axbew_zul_LG;
					
					// Korrektur der zul. Laterallast
					if(left(myMainController.topologieKlasse.Rollenlager.strBaureihe, 3) == "RDL" ||
						left(myMainController.topologieKlasse.Rollenlager.strBaureihe, 3) == "RKL")
						latla_zul = "-";
					// Korrektur der zul. Abhebelast
					if ((myMainController.topologieKlasse.Rollenlager && !myMainController.topologieKlasse.Abhebesicherung && !LG_Session.AuswahlSattel.bActuator) ||
						(myMainController.topologieKlasse.Lager && LG_Session.Systemcharakteristik.strSelRadioLager != "LAGER_FS"
							&& !myMainController.topologieKlasse.Klemmsystem && !myMainController.topologieKlasse.Abhebesicherung
							&& right(LG_Session.AuswahlStandard.strSelComboFunction, 2) != "2W" && right(LG_Session.AuswahlStandard.strSelComboFunction, 2) != "4W"))
						senkla_zul_ab	= "-";
					
					this.writeTextParam(strOutFile, "axbew_zul", axbew_zul);
					this.writeTextParam(strOutFile, "latbew_zul", latbew_zul);
					this.writeTextParam(strOutFile, "senkla_zul", "-" + senkla_zul_auf + "/+" + senkla_zul_ab);
					this.writeTextParam(strOutFile, "latla_zul", "+/- " + latla_zul);
					this.writeTextParam(strOutFile, "axla_zul", "+/- " + axla_zul);
					this.writeTextParam(strOutFile, "LAGER_PROFILART", Profilart);
					this.writeTextParam(strOutFile, "LAGER_TRAEGERGROESSE", Traegergroesse);
					this.writeTextParam(strOutFile, "GURTDICKE", Gurtdicke);
				}
				
				else if (oCadInfos.lagerEinzel) // erstmal oben mit reinjagen / was ist mit den Vertriebstexten?
                {
                    // Weitere (andere) Daten des Lagers bertragen ...
                    var myLager = myMainController.topologieKlasse.Lager;
                    if (myLager)
                    {
                        var lagerMatInfo  = myLager.getASTLDaten(myMainController);
                        if (lagerMatInfo && lagerMatInfo.aTexte && (lagerMatInfo.aTexte.length > 1))
                        {
                            this.writeTextParam(strOutFile, "Vertiebstext_Z1", utf8toansi(lagerMatInfo.aTexte[0]));
                            this.writeTextParam(strOutFile, "Vertiebstext_Z2", utf8toansi(lagerMatInfo.aTexte[1]));
                        }
                        else
                        {
                            this.writeTextParam(strOutFile, "Vertiebstext_Z1", "");
                            this.writeTextParam(strOutFile, "Vertiebstext_Z2", ""); // myLager.m_Ptyp
                        }
                        // Solldaten:
                        this.writeTextParam(strOutFile, "xbew", (! abs(myLager.wx) ? "-" : myLager.wx) );
                        this.writeTextParam(strOutFile, "ybew", (! abs(myLager.wy) ? "-" : myLager.wy) );
                        this.writeTextParam(strOutFile, "zla", (! abs(myLager.m_fz) ? "-" : myLager.m_fz) );
                        this.writeTextParam(strOutFile, "zla_ab", (! abs(myLager.fz) ? "-" : myLager.fz) );
                        this.writeTextParam(strOutFile, "xlan", (! abs(myLager.m_fx) ? "-" : myLager.m_fx) );
                        this.writeTextParam(strOutFile, "xlap", (! abs(myLager.fx) ? "-" : myLager.fx) );
                        this.writeTextParam(strOutFile, "ylan", (! abs(myLager.fy) ? "-" : myLager.fy) );
                        // Istdaten:
                        this.writeTextParam(strOutFile, "LAGER_AUFLAGELAST", myLager.strFZ);
                        this.writeTextParam(strOutFile, "LAGER_ABHEBELAST_FAB", myLager.strFAB);
                        this.writeTextParam(strOutFile, "LAGER_QUERLAST_FX", myLager.strFX);
                        this.writeTextParam(strOutFile, "LAGER_AXIALLAST", myLager.strFY);
                        this.writeTextParam(strOutFile, "ZUL_VERSCHIEBUNG_X", myLager.strWX);
                        this.writeTextParam(strOutFile, "ZUL_VERSCHIEBUNG_Y", myLager.strWY);
						/*
                        if (myLager.isConfigurable())
                        {
                            var strTraegerID = myLager.strProfilform;
                            if ( !strTraegerID )
                                strTraegerID = 'T';
                            this.writeTextParam(strOutFile, "LAGER_PROFILART", strTraegerID);
                            this.writeTextParam(strOutFile, "LAGER_TRAEGERGROESSE", myLager.strTraegergroesse);
                            this.writeTextParam(strOutFile, "GURTDICKE", myLager.strFlanschdicke);
                        }
                        else
                        {*/
                            this.writeTextParam(strOutFile, "LAGER_PROFILART", "-");
                            this.writeTextParam(strOutFile, "LAGER_TRAEGERGROESSE", "-");
                            this.writeTextParam(strOutFile, "GURTDICKE", "-");
                        //}
                    }
                    // Weitere (andere) Daten des Klemmsystems bertragen ...
                    var myKlemmsystem = myMainController.topologieKlasse.Klemmsystem;
                    if (myKlemmsystem)
                    {
                        var lagerMatInfo  = myKlemmsystem.getASTLDaten(myMainController);
                        if (lagerMatInfo && lagerMatInfo.aTexte && (lagerMatInfo.aTexte.length > 1))
                        {
                            this.writeTextParam(strOutFile, "Vertiebstext_Z1", lagerMatInfo.aTexte[0]);
                            this.writeTextParam(strOutFile, "Vertiebstext_Z2", lagerMatInfo.aTexte[1]);
                        }
                        else
                        {
                            this.writeTextParam(strOutFile, "Vertiebstext_Z1", "");
                            this.writeTextParam(strOutFile, "Vertiebstext_Z2", ""); // myLager.m_Ptyp
                        }
                        // Solldaten:
                        // Abhebelast - myKlemmsystem.strFZ
                        // Querlast - myKlemmsystem.strFX
                        this.writeTextParam(strOutFile, "xbew", "");
                        this.writeTextParam(strOutFile, "ybew", "");
                        this.writeTextParam(strOutFile, "zla", "");
                        this.writeTextParam(strOutFile, "zla_ab", "");
                        this.writeTextParam(strOutFile, "xlan", "");
                        this.writeTextParam(strOutFile, "xlap", "");
                        this.writeTextParam(strOutFile, "ylan", "");
                        // Istdaten:
                        this.writeTextParam(strOutFile, "LAGER_AUFLAGELAST", "");
                        this.writeTextParam(strOutFile, "LAGER_ABHEBELAST_FAB", myKlemmsystem.strFZ);
                        this.writeTextParam(strOutFile, "LAGER_QUERLAST_FX", myKlemmsystem.strFX);
                        this.writeTextParam(strOutFile, "LAGER_AXIALLAST", "");
                        this.writeTextParam(strOutFile, "ZUL_VERSCHIEBUNG_X", "");
                        this.writeTextParam(strOutFile, "ZUL_VERSCHIEBUNG_Y", "");

						var strTraegerID = myKlemmsystem.oData.PROFILFORM;
                        if ( !strTraegerID )
							strTraegerID = 'T';
						this.writeTextParam(strOutFile, "LAGER_PROFILART", strTraegerID);
						this.writeTextParam(strOutFile, "LAGER_TRAEGERGROESSE", myKlemmsystem.oData.TRAEGERBREITE);
						this.writeTextParam(strOutFile, "GURTDICKE", myKlemmsystem.oData.TG);
                        
                    }
                }
                else    // Achtung: doppelte Belegung von Variablen ...
                {
					this.writeTextParam(strOutFile, tolower(AchsKSInfo[2]) + "bew",  "-" + myMainController.dataAccess.getSollwerteBewegung("lateral-", 1, AchsKSInfo[8]) + "/+" + myMainController.dataAccess.getSollwerteBewegung("lateral+", 1, AchsKSInfo[8]));
                    this.writeTextParam(strOutFile, tolower(AchsKSInfo[1]) + "bew",  "-" + myMainController.dataAccess.getSollwerteBewegung("horizontal-", 1, AchsKSInfo[7]) + "/+" + myMainController.dataAccess.getSollwerteBewegung("horizontal+", 1, AchsKSInfo[7]));
					if (left(strHaengerTyp, 2) == "SS"){	// Dynamikteile habe ggf. 3 Lastflle - H,HZ,HS
						var SSDoppel	= myMainController.dataAccess.getLastketteLastabtragung();
						SSDoppel		= (right(SSDoppel, 6) == "DOPPEL" ? 2 : 1);
						var SSWarmlast	= "";
						var LF_HS_pl	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "HS+", 1, AchsKSInfo[6]);
						var LF_HS_mi	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "HS-", 1, AchsKSInfo[6]);
						if (LF_HS_pl == 0 && LF_HS_mi == 0){
							var LF_HZ_pl = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "HZ+", 1, AchsKSInfo[6]);
							var LF_HZ_mi = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "HZ-", 1, AchsKSInfo[6]);
							if (LF_HZ_pl == 0 && LF_HZ_mi == 0){
								var LF_H_pl = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "+", 1, AchsKSInfo[6]);
								var LF_H_mi = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "-", 1, AchsKSInfo[6]);
								this.writeTextParam(strOutFile, tolower(AchsKSInfo[0]) + "la",   "-" + LF_H_mi + "/+" + LF_H_pl + " (H)");
								SSWarmlast	= (max(abs(LF_H_mi), abs(LF_H_pl)) / (SSDoppel*1)) + " (H)";
							}
							else{
								this.writeTextParam(strOutFile, tolower(AchsKSInfo[0]) + "la",   "-" + LF_HZ_mi + "/+" + LF_HZ_pl + " (HZ)");
								SSWarmlast	= (max(abs(LF_HZ_mi), abs(LF_HZ_pl)) / (SSDoppel*1)) + " (HZ)";
							}
						}
						else{
							this.writeTextParam(strOutFile, tolower(AchsKSInfo[0]) + "la",   "-" + LF_HS_mi + "/+" + LF_HS_pl + " (HS)");
							SSWarmlast	= (max(abs(LF_HS_mi), abs(LF_HS_pl)) / (SSDoppel*1)) + " (HS)";
						}
					}
					else
						this.writeTextParam(strOutFile, tolower(AchsKSInfo[0]) + "la",   "-" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "-", 1, AchsKSInfo[6]) + "/+" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[3] + "+", 1, AchsKSInfo[6]));
                }
				// jetzt ist klar was drin steht
				this.writeTextParam(strOutFile, "bem2", (strBem2));
				
				// Hinweise zum Anzugsmoment von KSY und HV
				var strBem_HV	= "";
				var strBem_KSY	= "";
				if (typeof (LG_Session) == 'object'){
					if (LG_Session.AuswahlStandard.bHoehenverstellbar*1)
						strBem_HV	= translate("IDC_HOEHENVERSTELLUNG_LABEL") + ": Ma = 90Nm";
					if (LG_Session.Klemmsystem.oSearchResult.oResultKlemmsystem)
						strBem_KSY	= translate("IDC_KLEMMSYSTEM") + ": Ma = 70Nm";	//LL oder FL Klemmung -> M12
					else if (LG_Session.Systemcharakteristik.strSelRadioLager == "LAGER_FS" &&
							LG_Session.AuswahlStandard.strSelRadioFixed != "SCHRAUBBAR"){
						if (right(SchelleDaten.LagerTyp, 2)*1 < 23)
							strBem_KSY	= translate("IDC_KLEMMSYSTEM") + ": Ma = 70Nm";	// KPT 12
						else
							strBem_KSY	= translate("IDC_KLEMMSYSTEM") + ": Ma = 90Nm"; // KPT 16
					}
				}
				this.writeTextParam(strOutFile, "bem_hv", strBem_HV);
				this.writeTextParam(strOutFile, "bem_ksy", strBem_KSY);
                
				this.writeTextParam(strOutFile, "laest", HaengerDaten.Lasteinstellung);  // translate("IDC_LABEL_" + myMainController.dataAccess.getSollwerteArtSollast() + "LAST" ) );    // Lasteinstellung: kalt / warm
                this.writeTextParam(strOutFile, "geskg", myMainController.topologieKlasse.gesamtGewicht);
                this.writeTextParam(strOutFile, "dn",    strNennweite);
                this.writeTextParam(strOutFile, "da",    strRaD);
                this.writeTextParam(strOutFile, "j",     strDaemmdicke);
                this.writeTextParam(strOutFile, "mt",    strMediumtemp);
                
				this.writeTextParam(strOutFile, tolower(AchsKSInfo[0]) + "bew",  "-" + myMainController.dataAccess.getSollwerteBewegung("vertikal-", 1, AchsKSInfo[6]) + "/+" + myMainController.dataAccess.getSollwerteBewegung("vertikal+", 1, AchsKSInfo[6]));
                if (left(strHaengerTyp, 2) == "SS"){
					var LF_HS_pl_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "HS+", 1, AchsKSInfo[7]);
					var LF_HS_mi_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "HS-", 1, AchsKSInfo[7]);
					var LF_HS_pl_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "HS+", 1, AchsKSInfo[8]);
					var LF_HS_mi_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "HS-", 1, AchsKSInfo[8]);
					if (LF_HS_pl_ax == 0 && LF_HS_mi_ax == 0 && LF_HS_pl_q == 0 && LF_HS_mi_q == 0){
						var LF_HZ_pl_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "HZ+", 1, AchsKSInfo[7]);
						var LF_HZ_mi_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "HZ-", 1, AchsKSInfo[7]);
						var LF_HZ_pl_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "HZ+", 1, AchsKSInfo[8]);
						var LF_HZ_mi_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "HZ-", 1, AchsKSInfo[8]);
						if (LF_HZ_pl_ax == 0 && LF_HZ_mi_ax == 0 && LF_HZ_pl_q == 0 && LF_HZ_mi_q == 0){
							var LF_H_pl_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "+", 1, AchsKSInfo[7]);
							var LF_H_mi_ax	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "-", 1, AchsKSInfo[7]);
							var LF_H_pl_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "+", 1, AchsKSInfo[8]);
							var LF_H_mi_q	 = myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "-", 1, AchsKSInfo[8]);
							this.writeTextParam(strOutFile, tolower(AchsKSInfo[1]) + "la",   "-" + LF_H_mi_ax + "/+" + LF_H_pl_ax + " (H)");
							this.writeTextParam(strOutFile, tolower(AchsKSInfo[2]) + "la",   "-" + LF_H_mi_q + "/+" + LF_H_pl_q + " (H)");
						}
						else{
							this.writeTextParam(strOutFile, tolower(AchsKSInfo[1]) + "la",   "-" + LF_HZ_mi_ax + "/+" + LF_HZ_pl_ax + " (HZ)");
							this.writeTextParam(strOutFile, tolower(AchsKSInfo[2]) + "la",   "-" + LF_HZ_mi_q + "/+" + LF_HZ_pl_q + " (HZ)");
						}
					}
					else{
						this.writeTextParam(strOutFile, tolower(AchsKSInfo[1]) + "la",   "-" + LF_HS_mi_ax + "/+" + LF_HS_pl_ax + " (HS)");
						this.writeTextParam(strOutFile, tolower(AchsKSInfo[2]) + "la",   "-" + LF_HS_mi_q + "/+" + LF_HS_pl_q + " (HS)");
					}
				}
				else{
					this.writeTextParam(strOutFile, tolower(AchsKSInfo[1]) + "la",   "-" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "-", 1, AchsKSInfo[7]) + "/+" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[4] + "+", 1, AchsKSInfo[7]));
					this.writeTextParam(strOutFile, tolower(AchsKSInfo[2]) + "la",   "-" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "-", 1, AchsKSInfo[8]) + "/+" + myMainController.dataAccess.getSollwerteLast(AchsKSInfo[5] + "+", 1, AchsKSInfo[8]));
				}
				
                for (var ula = 0; ula < 3; ula++)
				{
					if (ula == 0)
						this.writeTextParam(strOutFile, tolower(AchsKSInfo[ula]) + "ula", "-" + myMainController.dataAccess.getSollwerteUeberLast(1, AchsKSInfo[ula+6]));
					else
						this.writeTextParam(strOutFile, tolower(AchsKSInfo[ula]) + "ula", myMainController.dataAccess.getSollwerteUeberLast(1, AchsKSInfo[ula+6]));
				}
				//this.writeTextParam(strOutFile, tolower(oLKWinkel.VertiAchse) + "ula", "-" + myMainController.dataAccess.getSollwerteUeberLast(1, oLKWinkel.IDVertiAchse));
				//this.writeTextParam(strOutFile, tolower(oLKWinkel.HoriAchse) + "ula", "-" + myMainController.dataAccess.getSollwerteUeberLast(1, oLKWinkel.IDHoriAchse));
				//this.writeTextParam(strOutFile, tolower(oLKWinkel.LatAchse) + "ula", "-" + myMainController.dataAccess.getSollwerteUeberLast(1, oLKWinkel.IDLatAchse));
				//this.writeTextParam(strOutFile, "wla",   HaengerDaten.warmlast + (left(strHaengerTyp, 2) == "SS" ? " (H)" : ""));     // Warmlast / Kaltlast
				//this.writeTextParam(strOutFile, "wla",   (left(strHaengerTyp, 2) == "SS" ? max(abs(LF_H_mi),abs(LF_H_pl)) + " (H)" : HaengerDaten.warmlast));     // Warmlast / Kaltlast
				this.writeTextParam(strOutFile, "wla",   (left(strHaengerTyp, 2) == "SS" ? SSWarmlast : HaengerDaten.warmlast));     // Warmlast / Kaltlast
				//this.writeTextParam(strOutFile, "kla",   (left(strHaengerTyp, 2) == "SS" ? max(abs(LF_H_mi),abs(LF_H_pl)) + " (H)" : HaengerDaten.kaltlast));     // Warmlast / Kaltlast
				this.writeTextParam(strOutFile, "kla",   (left(strHaengerTyp, 2) == "SS" ? SSWarmlast : HaengerDaten.kaltlast));     // Warmlast / Kaltlast
                //this.writeTextParam(strOutFile, "kla",   HaengerDaten.kaltlast + (left(strHaengerTyp, 2) == "SS" ? " (H)" : ""));
                this.writeTextParam(strOutFile, "gla",   sprintf("%.2f", Zusatzlast));
                this.writeTextParam(strOutFile, "ula",   abs(Zusatzlast2));
                this.writeTextParam(strOutFile, "laae",  HaengerDaten.lastaenderung);       // Lastnderung
                this.writeTextParam(strOutFile, "laju",  HaengerDaten.lastjustierung);      // Lastjustierung
                this.writeTextParam(strOutFile, "fr",    HaengerDaten.federrate);           // Federrate
                this.writeTextParam(strOutFile, "wego",  HaengerDaten.wegreserve_oben);     // Wegreserve oben / unten
                this.writeTextParam(strOutFile, "wegu",  HaengerDaten.wegreserve_unten);
                this.writeTextParam(strOutFile, "rwinkel", myMainController.dataAccess.getSollwerteSchraegzug(1).Beta);
                this.writeTextParam(strOutFile, "sz",    oLKWinkel.a_Schraegzug);
				this.writeTextParam(strOutFile, "sz_a",    oLKWinkel.a_Schraegzug_Axial);
				this.writeTextParam(strOutFile, "sz_l",    oLKWinkel.a_Schraegzug_Lateral);
                //this.writeTextParam(strOutFile, "sz0",   oLKWinkel.a_Schraegzug_100);
                //this.writeTextParam(strOutFile, "sz50",  oLKWinkel.a_Schraegzug_50);
				this.writeTextParam(strOutFile, "v_dir1",  AchsKSInfo[1]);
				this.writeTextParam(strOutFile, "v_dir2",  AchsKSInfo[2]);
				this.writeTextParam(strOutFile, "vs_a",    oLKWinkel.strVorspannung_ax);
				this.writeTextParam(strOutFile, "vs_l",    oLKWinkel.strVorspannung_lat);

                // HaengerDaten.verstellreserve_oben, HaengerDaten.verstellreserve_unten
                // gibt es nur bei SSG und manchen Sttzen, es geht um die Verstellung des E_mass
                this.writeTextParam(strOutFile, "reso",  HaengerDaten.verstellreserve_oben);    // Verstellreserve oben / unten
                this.writeTextParam(strOutFile, "resu",  HaengerDaten.verstellreserve_unten);

                this.writeTextParam(strOutFile, "A",  getstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "B",  getstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "C",  getstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "D",  getstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "E",  getstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "F",  getstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN"));
                this.writeTextParam(strOutFile, "G",  getstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN"));



                var ProjectSettings = "PROJECT.SETTINGS";
                var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
                var strBenutzer  = getstring("WI_BENUTZER",    ProjectSettings);
                var strKundenNr  = getstring("WI_KDNR",        ProjectSettings);
                var strProjektNr = getstring("WI_PROJEKTNR",   ProjectSettings);
                var strASNr      = getstring("WI_ASNR",        ProjectSettings);

                var strSystem    = getstring("WI_SYSTEM",      ProjectSettings);
                var strProjektName = getstring("PROJEKTNAME",  ProjectSettings);
                var strKdName    = getstring("FIRMENNAME_VON", ProjectSettings);
                var strKdName2   = getstring("FIRMENNAME_VON_2", ProjectSettings);

                var strPosnr     = getstring("POS", "DLGDATA");
                var strQty       = getstring("QTY", "DLGDATA");
                var strKdmat     = getstring("CUSTOMER_CODE", "DLGDATA");

                // Bearbeiter / Prfung:
                this.writeTextParam(strOutFile, "barb",   strBenutzer);   // Bearbeiter
                this.writeTextParam(strOutFile, "barbda", date.toDateString());
                this.writeTextParam(strOutFile, "pr",     "");					// @@@ Prfer     --> als Eingabefelder vorsehen
                this.writeTextParam(strOutFile, "prda",   date.toDateString());	// @@@ Prfdatum  --> als Eingabefelder vorsehen

                this.writeTextParam(strOutFile, "kunde1",  strKdName);
                this.writeTextParam(strOutFile, "kunde2",  strKdName2);
                this.writeTextParam(strOutFile, "projekt", strProjektName); // Projektname aus Maske Projektdaten
                this.writeTextParam(strOutFile, "system",  strSystem);
                // Markierung ggf. auf 2 Zeilen aufteilen (Platz 110 Zeichen je Zeile)
				var kennz	= trimright(trimleft(oLKinfo.markierung, " "), " ");
				var kennz1	= trimright(trimleft(oLKinfo.extramarkierung.replace("\n", " "), " "), " ");
				// Verschiedene Mglichkeiten
				if (kennz.length <= 110 && kennz1.length <= 110){}	// alles i.O. -> do nothing
				else if ((kennz.length + kennz1.length) <= 217){	// alles passt hin (3 zustzliche Zeichen " / ")
					var TmpKennz	= kennz + " / " + kennz1;
					kennz			= left(TmpKennz, 110);
					kennz1			= right(TmpKennz, TmpKennz.length - 110);
				}
				else{	// mindestens eine Zeile zu lang
					kennz	= (kennz.length <= 110 ? kennz : translate("ID_VERGL_LISTE"));
					kennz1	= (kennz1.length <= 110 ? kennz1 : translate("EXTRAMARKIERUNG") + " " + translate("ID_VORHANDEN"));
				}
				
				this.writeTextParam(strOutFile, "kennz",   kennz);
                this.writeTextParam(strOutFile, "kennz1",  kennz1);
				
				if (strKdmat.length <= 35)	// es ist Platz fr 35 Zeichen
					this.writeTextParam(strOutFile, "kdmat",   strKdmat);
				else
					this.writeTextParam(strOutFile, "kdmat",   translate("ID_VERGL_LISTE"));
                if (oLKinfo.zeichnungsnr.length <= 35)	// es ist Platz fr 35 Zeichen
					this.writeTextParam(strOutFile, "kdzn",    oLKinfo.zeichnungsnr);
				else
					this.writeTextParam(strOutFile, "kdzn",    translate("ID_VERGL_LISTE"));
				
                this.writeTextParam(strOutFile, "aanr", strAngebNr);
                this.writeTextParam(strOutFile, "pnr",  strPosnr);
                this.writeTextParam(strOutFile, "stck", strQty);

                // Revisionen:
                var RevisionTable = "PROJECT.REVISIONS.REVISION_TABELLE_ITEMS";
                var RevisionTableSize = getsize(RevisionTable, "");
                if (RevisionTableSize > 0)
                {
                    this.writeTextParam(strOutFile, "rnr1", getstring("NR", arraypath(RevisionTable,0)));
                    this.writeTextParam(strOutFile, "rna1", getstring("USER", arraypath(RevisionTable,0)));
                    this.writeTextParam(strOutFile, "rda1", getstring("DATE", arraypath(RevisionTable,0)));
                }
                else
                {
                    this.writeTextParam(strOutFile, "rnr1", "");
                    this.writeTextParam(strOutFile, "rna1", "");
                    this.writeTextParam(strOutFile, "rda1", "");
                }
                if (RevisionTableSize > 1)
                {
                    this.writeTextParam(strOutFile, "rnr2", getstring("NR", arraypath(RevisionTable,1)));
                    this.writeTextParam(strOutFile, "rna2", getstring("USER", arraypath(RevisionTable,1)));
                    this.writeTextParam(strOutFile, "rda2", getstring("DATE", arraypath(RevisionTable,1)));
                }
                else
                {
                    this.writeTextParam(strOutFile, "rnr2", "");
                    this.writeTextParam(strOutFile, "rna2", "");
                    this.writeTextParam(strOutFile, "rda2", "");
                }
                if (RevisionTableSize > 2)
                {
                    this.writeTextParam(strOutFile, "rnr3", getstring("NR", arraypath(RevisionTable,2)));
                    this.writeTextParam(strOutFile, "rna3", getstring("USER", arraypath(RevisionTable,2)));
                    this.writeTextParam(strOutFile, "rda3", getstring("DATE", arraypath(RevisionTable,2)));
                }
                else
                {
                    this.writeTextParam(strOutFile, "rnr3", "");
                    this.writeTextParam(strOutFile, "rna3", "");
                    this.writeTextParam(strOutFile, "rda3", "");
                }

                // Texte fr die Stckliste:
                var stkList = [];
                var oMatInfo, strWerkname, nAnzRow;
                myMainController.topologieKlasse.getStueckliste(stkList);

                this.writeTextParam(strOutFile, "ekg0", LKMatInfo.matnr);

                for (var i = 0, j = 1; i < stkList.length; i++, j++)
                {
                    // 2008-04-23 Neu: Bestimme auch die Materialnummern der Produkte
					oMatInfo = stkList[i].produkt.getASTLDaten(myMainController);
					
					if (stkList[i].produkt.m_Pwerkstoff == "W_SONST")
						strWerkname = stkList[i].produkt.m_Pwerkname;
					else
						strWerkname = Werknamen[stkList[i].produkt.m_Pwerkstoff];
					
					// Bei Sonderteilen komplette Beschreibung ausgeben ...
                    if (stkList[i].funktion == "SON")
                    {
                        // in separater Funktion aufbauen
						
						// -Schu- Achtung wir muessen Platz sparen
						// auf dem Datenblatt ist deutlich mehr Platz als in FL-StueLi
						// 40 Zeichen fr Benennung; Oberflaechenschutz nach Bemerkung verschieben
						j = this.getSonTeilStueLiPos(i, j, oMatInfo.aTexte, oMatInfo.matnr, strWerkname, stkList[i].anz, sprintf("%.2f", stkList[i].produkt.m_Pgewicht * stkList[i].anz), strOutFile);
					}
					else
					{
						this.writeTextParam(strOutFile, "p"+j, i+1);
						this.writeTextParam(strOutFile, "s"+j, stkList[i].anz);
						this.writeTextParam(strOutFile, "ben"+j, utf8toansi(stkList[i].produkt.m_Ptyp));
						this.writeTextParam(strOutFile, "wst"+j, strWerkname);
						this.writeTextParam(strOutFile, "din"+j, stkList[i].produkt.m_Pzusinfo);
						this.writeTextParam(strOutFile, "znr"+j, utf8toansi(translate(stkList[i].produkt.m_Pzeichnr)));
						this.writeTextParam(strOutFile, "ekg"+j, oMatInfo.matnr);
						this.writeTextParam(strOutFile, "gkg"+j, sprintf("%.2f", stkList[i].produkt.m_Pgewicht * stkList[i].anz));
					}
				}
                // Weiter auffllen bis einschl. 20
                for (; i < 30; i++, j++)
                {

                    this.writeTextParam(strOutFile, "p"+j, "");
                    this.writeTextParam(strOutFile, "s"+j, "");
                    this.writeTextParam(strOutFile, "ben"+j, "");
                    this.writeTextParam(strOutFile, "wst"+j, "");
                    this.writeTextParam(strOutFile, "din"+j, "");
                    this.writeTextParam(strOutFile, "znr"+j, "");
                    this.writeTextParam(strOutFile, "ekg"+j, "");
                    this.writeTextParam(strOutFile, "gkg"+j, "");
                }
				
				// Block fr Teile mit Ansicht der Fussplatte
				if (oCadInfos.lagerFuss){
					for (var i = 0; i < stkList.length; i++){
						switch (stkList[i].produkt.m_Ptypid){
							case 'FSN' :
							case 'FSD' :
								this.writeTextParam(strOutFile, "f_fs_e", stkList[i].produkt.oData.E1);
								this.writeTextParam(strOutFile, "f_fs_b", stkList[i].produkt.oData.A);
								this.writeTextParam(strOutFile, "f_fs_k", stkList[i].produkt.oData.K);
								this.writeTextParam(strOutFile, "f_fs_s", stkList[i].produkt.oData.TF);
								this.writeTextParam(strOutFile, "f_fs_d", stkList[i].produkt.oData.D2);
								break;
							case 'FSS' :
							case 'FSP' :
							case 'FHS' :
								if (stkList[i+1].produkt.m_Ptypid != "ZZF"){	// sonst Werte doppelt
									var PartTyp	= stkList[i].produkt.m_Ptypid;
									if (left(PartTyp, 2) == "FS")
										PartTyp	= "FST";
									var strSQLStatement = "select * from "+PartTyp+" where abs(LASTGR)="+HaengerDaten.lastgroesse*1+" and abs(NENNW)="+HaengerDaten.nennweg+" ";
									var numRet = dbselect("CASCADE", strSQLStatement, PartTyp);
									this.writeTextParam(strOutFile, "f_fs_e", dbgetdouble(PartTyp, "T"));
									this.writeTextParam(strOutFile, "f_fs_b", dbgetdouble(PartTyp, "M"));
									this.writeTextParam(strOutFile, "f_fs_k", dbgetdouble(PartTyp, "K"));
									this.writeTextParam(strOutFile, "f_fs_s", dbgetdouble(PartTyp, "S"));
									this.writeTextParam(strOutFile, "f_fs_d", dbgetdouble(PartTyp, "D"));
								}
								break;
							case 'ZZF' :
								var strSQLStatement = "select * from ZZF where abs(LGR_FST)="+HaengerDaten.lastgroesse*1+" ";
								var numRet = dbselect("CASCADE", strSQLStatement, "ZZF");
								this.writeTextParam(strOutFile, "f_fs_e", dbgetdouble("ZZF", "T"));
								this.writeTextParam(strOutFile, "f_fs_b", dbgetdouble("ZZF", "M"));
								this.writeTextParam(strOutFile, "f_fs_k", dbgetdouble("ZZF", "K"));
								this.writeTextParam(strOutFile, "f_fs_s", dbgetdouble("ZZF", "S"));
								this.writeTextParam(strOutFile, "f_fs_d", dbgetdouble("ZZF", "D"));
								break;
							case 'KSR' :
							case 'KSP' :
								if (stkList[i+1].produkt.m_Ptypid != "ZZK"){	// sonst Werte doppelt
									var strSQLStatement = "select * from KST_KMA where abs(LGR)="+HaengerDaten.leistungsgroesse*1+" ";
									var numRet = dbselect("CASCADE", strSQLStatement, "KST_KMA");
									this.writeTextParam(strOutFile, "f_ks_e", dbgetdouble("KST_KMA", "E_"));
									this.writeTextParam(strOutFile, "f_ks_t", dbgetdouble("KST_KMA", "T"));
									this.writeTextParam(strOutFile, "f_ks_k", dbgetdouble("KST_KMA", "K"));
									this.writeTextParam(strOutFile, "f_ks_s", dbgetdouble("KST_KMA", "S"));
									this.writeTextParam(strOutFile, "f_ks_n", dbgetdouble("KST_KMA", "N"));
									this.writeTextParam(strOutFile, "f_ks_u", dbgetdouble("KST_KMA", "U"));
									this.writeTextParam(strOutFile, "f_ks_l", dbgetdouble("KST_KMA", "L"));
								}
								this.writeTextParam(strOutFile, "f_ks_x", myMainController.topologieKlasse.Haenger.X);
								break;
							case 'ZZK' :
								var strSQLStatement = "select * from ZZK where abs(LGR_KST)="+HaengerDaten.leistungsgroesse*1+" ";
								var numRet = dbselect("CASCADE", strSQLStatement, "ZZK");
								this.writeTextParam(strOutFile, "f_ks_e", dbgetdouble("ZZK", "T1"));
								this.writeTextParam(strOutFile, "f_ks_t", dbgetdouble("ZZK", "T"));
								this.writeTextParam(strOutFile, "f_ks_k", dbgetdouble("ZZK", "K"));
								this.writeTextParam(strOutFile, "f_ks_s", dbgetdouble("ZZK", "S"));
								this.writeTextParam(strOutFile, "f_ks_n", stkList[i].produkt.form*1 != 1 ? dbgetdouble("ZZK", "N12") : dbgetdouble("ZZK", "N11"));
								this.writeTextParam(strOutFile, "f_ks_u", stkList[i].produkt.form*1 != 1 ? dbgetdouble("ZZK", "U12") : dbgetdouble("ZZK", "U11"));
								this.writeTextParam(strOutFile, "f_ks_l", dbgetdouble("ZZK", "LP"));
								break;
							case 'KHS' :
							case 'KVS' :
								var PartTyp	= stkList[i].produkt.m_Ptypid + "_KMA";
								var strSQLStatement = "select * from "+PartTyp+" where abs(LGR)="+HaengerDaten.leistungsgroesse*1+" ";
								var numRet = dbselect("CASCADE", strSQLStatement, PartTyp);
								this.writeTextParam(strOutFile, "f_kh_e", dbgetdouble(PartTyp, "E_"));
								this.writeTextParam(strOutFile, "f_kh_k", dbgetdouble(PartTyp, "K"));
								this.writeTextParam(strOutFile, "f_kh_s", dbgetdouble(PartTyp, "S"));
								this.writeTextParam(strOutFile, "f_kh_o", dbgetdouble(PartTyp, "O"));
								this.writeTextParam(strOutFile, "f_kh_u", dbgetdouble(PartTyp, "U"));
								this.writeTextParam(strOutFile, "f_kh_n", dbgetdouble(PartTyp, "N"));
								var PartTyp	= stkList[i].produkt.m_Ptypid + "_EMA";
								var strSQLStatement = "select * from "+PartTyp+" where abs(LGR)="+HaengerDaten.leistungsgroesse*1+" and abs(SN)="+HaengerDaten.nennweg*1+" ";
								this.writeTextParam(strOutFile, "f_kh_t", dbgetdouble(PartTyp, "T"));
								this.writeTextParam(strOutFile, "f_kh_x", myMainController.topologieKlasse.SegmentStrang.Haenger.X);
								break;
							case 'LGV' :
								if (oCadInfos.lagerFussTyp != 'LGV1'){	// LGV1 gibt es nur einen Typ - feste Werte im DXF
									this.writeTextParam(strOutFile, "f_lgv_a", stkList[i].produkt.oData.A);
									this.writeTextParam(strOutFile, "f_lgv_b", stkList[i].produkt.oData.B);
									this.writeTextParam(strOutFile, "f_lgv_c", stkList[i].produkt.oData.C);
									this.writeTextParam(strOutFile, "f_lgv_dl", stkList[i].produkt.oData.DL);
									this.writeTextParam(strOutFile, "f_lgv_l", stkList[i].produkt.oData.L);
									this.writeTextParam(strOutFile, "f_lgv_es", stkList[i].produkt.oData.ES);
								}
								break;
							default :
								break;
						}
					}
				}
				
				// Feste Texte des Rahmens werden aus dem Dictionary gelesen:
				var strSQLStatement = "select * from Rahmentexte ";
				var strID = "";
				if (dbselect("CASCADE", strSQLStatement, "RAHMENTEXTE") > 0)
				{
					while (dbiseof("RAHMENTEXTE") == 0)
					{
						strID = dbgetstring("RAHMENTEXTE", "ID");
						// this.writeTextParam(strOutFile, strID, utf8toansi((strID)));
						this.writeTextParam(strOutFile, strID, translate(strID));
						dbskip("RAHMENTEXTE");
					}
				}
				
                writefile( strOutFile, "\t\t  </textparams> \r\n", "a" );
                writefile( strOutFile, "\t\t</layout> \r\n", "a" );
                writefile( strOutFile, "\t</operation> \r\n", "a" );

            }   // ENDE Operation LAYOUT

			writefile( strOutFile, "  </control> \r\n", "a" );
		}

		// get params
		// the resulting array is an array of unknown length that contains the 3DCAD params
		
		// write params to file
		var aParams = myMainController.topologieKlasse.getCADDaten();
		var nSize = aParams.length;
		if ( oFileComponents.bIniMode )
		{
			for( var i = 0; i < nSize; i++ )
				writefile( strOutFile, aParams[i][0] + "=" + aParams[i][1] + " \r\n", "a" );
		}
		else
		{
			writefile( strOutFile, "  <params ordered=\"false\"> \r\n", "a" );
			for( var i = 0; i < nSize; i++ )
				writefile( strOutFile, "\t<param id=\"" + aParams[i][0] + "\" value=\"" + aParams[i][1] + "\"/> \r\n", "a" );
			writefile( strOutFile, "  </params> \r\n", "a");
			writefile( strOutFile, "</caddata> \r\n", "a");
		}

        // execute CAD program
        var strParams =  "\"" + strOutFile + "\"";

        if (oGenerateOptions.addToListFile && (oGenerateOptions.listFileToAdd != ""))
        {
            var strProjectCopy = replace(oGenerateOptions.pdfFileToCreate, oFileComponents.strDataPath, oFileComponents.strProjectPath);
            var strTransferCopy = replace(oGenerateOptions.pdfFileToCreate, oFileComponents.strDataPath, oFileComponents.strTransferPath);

			writefile( oGenerateOptions.listFileToAdd, oFileComponents.strExecutable + " " + strParams + " \"" + oFileComponents.strPrgPath + "\" \r\n", "a");
            if (oGenerateOptions.multipleType == "SAP") {
                writefile( oGenerateOptions.listFileToAdd, "\"copy\"" + " \"" + oGenerateOptions.pdfFileToCreate + "\" \"" + strProjectCopy + "\" \r\n", "a");
                writefile( oGenerateOptions.listFileToAdd, "\"copy\"" + " \"" + oGenerateOptions.pdfFileToCreate + "\" \"" + strTransferCopy + "\" \r\n", "a");
                writefile( oGenerateOptions.listFileToAdd, "\"unlink\"" + strParams +" \"NIL\" \r\n", "a");     // XML-File lschen
            }
			else if (oGenerateOptions.multipleType == "CRM") {
                writefile( oGenerateOptions.listFileToAdd, "\"copy\"" + " \"" + oGenerateOptions.pdfFileToCreate + "\" \"" + strProjectCopy + "\" \r\n", "a");
                writefile( oGenerateOptions.listFileToAdd, "\"unlink\"" + strParams +" \"NIL\" \r\n", "a");     // XML-File lschen
			}
            else
                writefile( oGenerateOptions.listFileToAdd, "\"unlink\"" + strParams +" \"NIL\" \r\n", "a");     // XML-File lschen
        }
        else if (oGenerateOptions.generateShowOperation)
            shellexecuteex( oFileComponents.strExecutable, strParams, oFileComponents.strPrgPath, 1 );    // show = 1
        else
        {
            shellexecuteexblocking( oFileComponents.strExecutable, strParams, oFileComponents.strPrgPath + "CadView", 1, 256000 );    // show = 1
            ret = filecommand("unlink", strOutFile);    // XML-Datei lschen
        }
		
    },
	
	getSonTeilStueLiPos : function(i, j, aTexte, matnr, strWerkname, anz, gewicht, strOutFile)
	{
		var SpaltenBreite	= 40;								// Anz der verfuegbaren Zeichen
		var AnzZeichen		= 0;								// Zaehlen der vorhandenen Zeichen
		var nAnzRow			= aTexte.length;					// Zeilenanzahl des Sonderteils
		var Text_ges		= "";								// Text aller Zeilen ausser Oberflaechenschutz
		var aTexte_neu		= new Array();						// Feld fuer neugeordnete Texte
		
		var strSpracheKommu		=	getlanguage();
		var strAktuelleSprache	=	getstring("EKCURRENTLANGUAGE", "");
		
		// finde die Zeile wo der Oberflaechenschutz definiert ist (falls vorhanden)
		setlanguage(strAktuelleSprache);
		//var OberflSchutz		=	utf8toansi(translate("OBERFLAECHE"));
		var OberflSchutz		=	translate("OBERFLAECHE");
		var LaengeOberflSchutz	=	OberflSchutz.length;
		setlanguage(strSpracheKommu);
		var ObText				=	"";
		for (var k = 0; k < nAnzRow; k++)
		{
			var aktZeile			=	trimleft(aTexte[k]," ");
			if (toupper(left(aktZeile, LaengeOberflSchutz)) == toupper(OberflSchutz))
			{
				var ZNrOb	=	k;
				var ZObSch	=	aktZeile.split(" ");
				ObText		=	OberflSchutz + " " + ZObSch[(ZObSch.length)-1];
			}
			else
				Text_ges += aktZeile + " ";
		}
		
		// Zeilen neu sortierten
		k = 0;
		var kk		= 0;
		Text_ges	= trimright(Text_ges, " ");
		Text_ges	= Text_ges.split(" ");
		var Test	= Text_ges[k].length;
		while (k < Text_ges.length)
		{
			if (!aTexte_neu[kk])
				aTexte_neu[kk] = "";
			if ((AnzZeichen + Text_ges[k].length + 1) <= SpaltenBreite)
			{
				AnzZeichen		+= (Text_ges[k].length + 1);
				aTexte_neu[kk]	+= Text_ges[k] + " ";
				//var test	= aTexte_neu[kk].length;
				k++;
			}
			else
			{
				kk++;
				AnzZeichen = 0;
			}
			//k++;
		}
		
		// alte Textanordnung loeschen und neue setzen
		delete aTexte;
		aTexte = aTexte_neu;
		
		// StueLi Felder stetzen
		k = aTexte.length;
		for (; k > 0; --k)
		{
			this.writeTextParam(strOutFile, "p"+j, "");
			this.writeTextParam(strOutFile, "s"+j, "");
			this.writeTextParam(strOutFile, "ben"+j, aTexte[k-1]);
			this.writeTextParam(strOutFile, "wst"+j, "");
			this.writeTextParam(strOutFile, "din"+j, "");
			this.writeTextParam(strOutFile, "znr"+j, "");
			this.writeTextParam(strOutFile, "ekg"+j, "");
			this.writeTextParam(strOutFile, "gkg"+j, "");
			
			if (k == 1)
			{
				this.writeTextParam(strOutFile, "p"+j, i+1);
				this.writeTextParam(strOutFile, "s"+j, anz);
				//this.writeTextParam(strOutFile, "ben"+j, utf8toansi(aTexte[k-1]));
				this.writeTextParam(strOutFile, "ben"+j, aTexte[k-1]);
				this.writeTextParam(strOutFile, "wst"+j, strWerkname);
				this.writeTextParam(strOutFile, "din"+j, "");
				if (ObText != "")
					//this.writeTextParam(strOutFile, "znr"+j, utf8toansi(ObText));
					this.writeTextParam(strOutFile, "znr"+j, ObText);
				else
					this.writeTextParam(strOutFile, "znr"+j, translate("SONDERTEIL"));
				this.writeTextParam(strOutFile, "ekg"+j, matnr);
				this.writeTextParam(strOutFile, "gkg"+j, gewicht);
			}
			j++;
		}
		//var retObj = { i: i, j: j };
		return (j-1);
	}

});
