SystemmasseController = function() {
	SystemmasseController.superclass.constructor.call(this);
}

EasyKat.extend( SystemmasseController, CustomController,
{
	getFormFieldsAction : function() {
		// Felder
		var fields = [];

        var lkTyp             = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung   = caMainController.dataAccess.getLastketteLastabtragung();

        if ((lkTyp == "EINZEL_HAENGER") || (lkTyp == "EINZEL_SCHELLE") ||
            (lkTyp == "EINZEL_ZUBEHOER") || (lkTyp == "EINZEL_LAGER") ||
			(left(lkTyp, 5) == "LAGER"))
        {
            var strLevelOBEN   = getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL");
            var strLevelUNTEN  = getstring("UNTEN", "DLGDATA.CA.FORMS.HOEHENLEVEL");
			
			var LAGER_BauF		= getstring ("strBauF",		"DLGDATA.CA.SELECTION.TOPOCLASS.Lager");
			var LAGER_Baureihe	= getstring ("strBaureihe",	"DLGDATA.CA.SELECTION.TOPOCLASS.Lager");
			var isLagerDoppelt	= false;
			
			if (LAGER_Baureihe == "FSD" ||
				(right(LAGER_Baureihe, 1) == "F" && (left(LAGER_BauF, 1) == "2" || left(LAGER_BauF, 1) == "4"))){
				isLagerDoppelt	= true;
			}
			if (isLagerDoppelt)
				var strLevelMITTE  = getstring("MITTE", "DLGDATA.CA.FORMS.HOEHENLEVEL");
			
			// wir brauchen zuknftig noch mehr Unterscheidungen 3W / 2W90 / Einbaulage / ...
			
            fields.push( {
                allowBlank: false,
                id: 'OBEN',
                name: 'OBEN',
                fieldLabel: translate('IDC_LABEL_SYSTEMNIVEAU_OBEN'),
                width:75,
                blankText: translate('IDC_LABEL_SYSTEMNIVEAU_OBEN_HELP'),
                value: strLevelOBEN
            });
			if (isLagerDoppelt){
				fields.push( {
					allowBlank: false,
					id: 'MITTE',
					name: 'MITTE',
					fieldLabel: translate('IDC_LABEL_SYSTEMNIVEAU_MITTE'),
					width:75,
					blankText: translate('IDC_LABEL_SYSTEMNIVEAU_MITTE_HELP'),
					value: strLevelMITTE
				});
			}
            fields.push( {
                allowBlank: false,
                id: 'UNTEN',
                name: 'UNTEN',
                fieldLabel: translate('IDC_LABEL_SYSTEMNIVEAU_UNTEN'),
                width:75,
                blankText: translate('IDC_LABEL_SYSTEMNIVEAU_UNTEN_HELP'),
                value: strLevelUNTEN
            });
        }
        else if ((lkTyp == "GELENKSTREBE") || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
        {
            var strLevelBA   = getstring("BA",   "DLGDATA.CA.FORMS.HOEHENLEVEL");
            var strLevelRMT   = getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL");

            if (caMainController.topologieKlasse.bHaengend)
            {
                fields.push( {
                    allowBlank: false,
                    id: 'BA',
                    name: 'BA',
                    fieldLabel: translate("BAUANSCHLUSS"),
                    width:75,
                    blankText: translate("MSG_BAUANSCHLUSS_LEVEL"),
                    value: strLevelBA
                });
                fields.push( {
                    allowBlank: false,
                    id: 'RMT',
                    name: 'RMT',
                    fieldLabel: translate("IDC_LABEL_LEVEL_ROHRMITTE"),
                    width:75,
                    blankText: translate("IDP_LEVEL_ROHRMITTE_ANGEBEN"),
                    value: strLevelRMT
                });
            }
            else
            {
                fields.push( {
                    allowBlank: false,
                    id: 'RMT',
                    name: 'RMT',
                    fieldLabel: translate("IDC_LABEL_LEVEL_ROHRMITTE"),
                    width:75,
                    blankText: translate("IDP_LEVEL_ROHRMITTE_ANGEBEN"),
                    value: strLevelRMT
                });
                fields.push( {
                    allowBlank: false,
                    id: 'BA',
                    name: 'BA',
                    fieldLabel: translate("BAUANSCHLUSS"),
                    width:75,
                    blankText: translate("MSG_BAUANSCHLUSS_LEVEL"),
                    value: strLevelBA
                });
            }
        }
        else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
            (lkLastabtragung == "STUETZEND_DOPPEL"))
        {
            var strLevelUBA   = getstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL");
            var strLevelRMT   = getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL");

            fields.push( {
                allowBlank: false,
                id: 'RMT',
                name: 'RMT',
                fieldLabel: translate("IDC_LABEL_LEVEL_ROHRMITTE"),
                width:75,
                blankText: translate("IDP_LEVEL_ROHRMITTE_ANGEBEN"),
                value: strLevelRMT
            });
            fields.push( {
                allowBlank: false,
                id: 'UBA',
                name: 'UBA',
                fieldLabel: translate("IDC_LABEL_LEVEL_UNTERER_BAUANSCHLUSS"),
                width:75,
                blankText: translate("MSG_BAUANSCHLUSS_LEVEL"),
                value: strLevelUBA
            });
        }
        else
        {
            // @@@@@@@@@@@ Systematisieren, auch fr asymmetrische und verzweigte!
            var strLevelOBA   = getstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL");
            var strLevelHAENG = getstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL");
            var strLevelRMT   = getstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL");

            // @@@@@@ SegmentStrang klappt nicht bei asymmetrisch doppel ...
            // wir mssen wissen, auf welchem Strang wir hier eigentlich operieren ....
            var bisDritteHLinie = caMainController.topologieKlasse.isDritteHLinie();

            fields.push( {
                allowBlank: false,
                id: 'OBA',
                name: 'OBA',
                fieldLabel: translate("IDC_LABEL_LEVEL_OBERER_BAUANSCHLUSS"),
                width:75,
                blankText: translate("MSG_OBERER_BAUANSCHLUSS_LEVEL"),
                value: strLevelOBA
            });
            if (bisDritteHLinie)
            {
                fields.push( {
                    allowBlank: false,
                    id: 'HAENG',
                    name: 'HAENG',
                    fieldLabel: translate("IDC_LABEL_LEVEL_HAENGER"),
                    width:75,
                    blankText: translate("MSG_HAENGER_LEVEL"),
                    value: strLevelHAENG
                });
            }
            fields.push( {
                allowBlank: false,
                id: 'RMT',
                name: 'RMT',
                fieldLabel: translate("IDC_LABEL_LEVEL_ROHRMITTE"),
                width:75,
                blankText: translate("IDP_LEVEL_ROHRMITTE_ANGEBEN"),
                value: strLevelRMT
            });
        }

		echo fields.toJSON();
		// _global.MIMETYPE = "text/x-json";
	},

    // @@@ Diverse Actions sind hier erforderlich:
    // (1) Abhngig von der Topologie viele Systemlevel ...
    //     z.B. doppelt asymmetrisch mit FHG --> 2 Pakete mit 3 Massen
    //          atypische LK's erfordern einen zustzlichen Systemlevel
    // (2) Dementsprechend oft Nachfrage nach Aufteilung der Gewindestangen erforderlich:
    //     z.B. doppelt asymmetrisch mit 2 FHG --> 4 Abfragen !!
    // (3) Nach Abfrage Systemlevel muss erst geprft werden, ob die
    //     Anpassung ohne weitere Rckfrage erfolgen kann
    //     JA : -> Gewindestangen anpassen
    //          eventuell gibts noch eine Meldung,
    //          -> diese bringen und dann den Dialog beenden
    //     Nein: Tabelle zur Eingabe der Gewindestangenlngen aufblenden
    //          zu jedem Paket die Gesamtlnge anzeigen, sowie die Min-Gew.stangenlnge
    //          Dynamisch nach Eingaben in einer Zelle die anderen Zellen rckrechnen
    //          (dabei auch Mingew.stangenlaengen beachten)
    //          -> Gewindestangen anlegen
    //  d.h. die Save-Action liefert entweder OK und optional eine Meldung
    //  zurck (dann wurde alles erledigt) oder Listen / Arrays mit Vorschlagswerten
    //  fr die Aufteilung der Gewindestangen, jeweils auch optional mit Meldung
    //  dann ist weiterer Dialog ntig und danach erfolgt dann erst
    //  das Anlegen der Gewindestangen.
	saveAction : function()
    {
        var lkTyp             = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung   = caMainController.dataAccess.getLastketteLastabtragung();
        var strMessage        = "";

        if ((lkTyp == "EINZEL_HAENGER") || (lkTyp == "EINZEL_SCHELLE") ||
            (lkTyp == "EINZEL_ZUBEHOER")  || (lkTyp == "EINZEL_LAGER") ||
			(left(lkTyp, 5) == "LAGER"))
        {
            var strLevelOBEN	= getdlgvar('OBEN');
			var strLevelMITTE	= getdlgvar('MITTE');
            var strLevelUNTEN	= getdlgvar('UNTEN');
			
            // Prfen, wo verschoben wurde:
            var woVerschoben = "";
			if (strLevelMITTE != "" && strLevelMITTE != getstring("MITTE",  "DLGDATA.CA.FORMS.HOEHENLEVEL"))
				woVerschoben	= "MITTE";	//FSD bzw. Fhrung 2W / 4W
            else if (strLevelOBEN != getstring("OBEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL"))
                woVerschoben	= "OBEN";	// das ist die Rohrmitte, auer bei FSD bzw. Fhrung 2W / 4W
			else
				woVerschoben	= "UNTEN";
			
            setstring("OBEN",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelOBEN);
			setstring("MITTE",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelMITTE);
            setstring("UNTEN",  "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelUNTEN);
			
            // Gibt nichts anzupassen, es wird nur verschoben ...
            strMessage = caMainController.topologieKlasse.berechneFlexibleTeileAusSystemmass(woVerschoben);
        }
        else if ((lkTyp == "GELENKSTUETZE") || (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE"))
        {
            var strLevelBA = getdlgvar('BA');
            var strLevelRMT = getdlgvar('RMT');

            // Hier spielts keine Rolle, Zwischenstck wird angepasst:
            var woVerschoben = "OBEN";

            setstring("BA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelBA);
            setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelRMT);

            // Zwischenstck anpassen ...
            strMessage = caMainController.topologieKlasse.berechneFlexibleTeileAusSystemmass(woVerschoben);
        }
        else if ((lkLastabtragung == "STUETZEND_EINFACH") || (lkLastabtragung == "STUETZEND_DOPPEL"))
        {
            var strLevelUBA = getdlgvar('UBA');
            var strLevelRMT = getdlgvar('RMT');

            // Hier spielts keine Rolle, Zwischenstck wird angepasst:
            var woVerschoben = "OBEN";

            setstring("UBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelUBA);
            setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelRMT);

            // Zwischenstck anpassen ...
            strMessage = caMainController.topologieKlasse.berechneFlexibleTeileAusSystemmass(woVerschoben);
        }
        else
        {
			var strLevelOBA = getdlgvar('OBA');
            var strLevelHAENG = getdlgvar('HAENG');
            var strLevelRMT = getdlgvar('RMT');
			
            // Hier spielts keine Rolle, Gewindestange wird angepasst:
            var woVerschoben = "OBEN";
			
            setstring("OBA",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelOBA);
            setstring("HAENG", "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelHAENG);
            setstring("RMT",   "DLGDATA.CA.FORMS.HOEHENLEVEL", strLevelRMT);
			
            // Gewindestangen anpassen ...
            strMessage = caMainController.topologieKlasse.berechneFlexibleTeileAusSystemmass(woVerschoben);
        }

		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			message: strMessage
		};
		
		echo response.toJSON(); 

	}
});