/**
 * SystemcharakteristikController
 */
SystemcharakteristikController = function() {
	SystemcharakteristikController.superclass.constructor.call(this);
};

EasyKat.extend(SystemcharakteristikController, CustomController, {
	getValuesAction : function() 
    {
        var strLKTyp    = caMainController.dataAccess.getLastketteTyp();
        if ((strLKTyp == "") || (strLKTyp == "UNKNOWN"))
            strLKTyp = "BEWEGLICH";
        var strLKRohrv  = caMainController.dataAccess.getLastketteRohrverlauf();
        if ((strLKRohrv == "") || (strLKRohrv == "UNKNOWN"))
			strLKRohrv = "HORIZONTAL";
		var strLKLastab = caMainController.dataAccess.getLastketteLastabtragung();
        if ((strLKLastab == "") || (strLKLastab == "UNKNOWN"))
            strLKLastab = "HAENGEND_EINFACH";
		
		// Rohrrichtung / Koordinatensystem
		var RR_KS = caMainController.dataAccess.getInfoRRKSDefault(strLKRohrv);
		
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				IDC_LASTKETTE: strLKTyp,
				IDC_ROHRVERLAUF: strLKRohrv,
				IDC_LASTABTRAGUNG: strLKLastab,
				IDC_ROHRRICHTUNG: (RR_KS.strPipeDir + "_ACHSE"),
				SENKR_ACHSE: RR_KS.VertiDir,
				SENKR_RICHT: RR_KS.PosDir,
				KOORD_IMG_VAR: RR_KS.KoordImgVar,
				SCHRAEG_ALPHA: RR_KS.SCHRAEG_ALPHA,
				SCHRAEG_BETA: RR_KS.SCHRAEG_BETA
			}
			/*,
			UI-Logik gehrt, wenn es mglich ist, ins UI. Hier ist es mglich.
			disabled: [
				'IDC_GELENKSTUETZE',
				'IDC_GELENKSTREBE',
				'HAENGEND_VERZWEIGT',
				'SONDERFAELLE'
			]
			*/
		};
		
		echo response.toJSON(); 
	},
	
	setValuesAction : function() 
    {
        // alter, nicht mehr erforderlicher weg um variablen auszulesen:
		var  ret = getdlgvar("IDC_ROHRVERLAUF");
		//alert(ret);

		// Besserer Weg um an Variablen zu kommen
		var submitVars = Object.fromStorage("DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");

/**
        var strTest = "var lG=RUNDEN(1.011*273)+0.932*10+55+8; alert(lG); var res=2*lG + PI()/2*(RUNDEN(1.011*273)+8); alert(res);";
        var result = eval(strTest);
        alert("res: "+res);
**/
		// Jetzt ist es ganz einfach fr uns die Checkboxen abzufragen
		if ( (submitVars.IDC_LASTKETTE == "EINZEL_HAENGER") ||
             (submitVars.IDC_LASTKETTE == "EINZEL_LAGER") ||
             (submitVars.IDC_LASTKETTE == "EINZEL_ZUBEHOER") ) {
            delete("DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "");
		}
	}
});