/**
 * Systemcharakteristik2Controller
 */
Systemcharakteristik2Controller = function() {
	Systemcharakteristik2Controller.superclass.constructor.call(this);
};

EasyKat.extend(Systemcharakteristik2Controller, CustomController, {
	getValuesAction : function() 
    {
        var strLKTyp = caMainController.dataAccess.getLastketteTyp();
        if ( ( strLKTyp == "" ) || ( strLKTyp == "UNKNOWN" ) )
            strLKTyp = "EINZEL_LAGER";  // 09/2008: Wunsch -schm- "EINZEL_KLEMMSYSTEM";
		var strLKRohrv  = caMainController.dataAccess.getLastketteRohrverlauf();
        if ((strLKRohrv == "") || (strLKRohrv == "UNKNOWN"))
			strLKRohrv = "HORIZONTAL";
		
		// Rohrrichtung / Koordinatensystem
		var RR_KS = caMainController.dataAccess.getInfoRRKSDefault(strLKRohrv);
    
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: 
			{
				IDC_LASTKETTE: strLKTyp,
				IDC_ROHRVERLAUF: strLKRohrv,
				IDC_ROHRRICHTUNG: (RR_KS.strPipeDir + "_ACHSE"),
				SENKR_ACHSE: RR_KS.VertiDir,
				SENKR_RICHT: RR_KS.PosDir,
				KOORD_IMG_VAR: RR_KS.KoordImgVar,
				SCHRAEG_ALPHA: RR_KS.SCHRAEG_ALPHA,
				SCHRAEG_BETA: RR_KS.SCHRAEG_BETA
			}
		};
		
		echo response.toJSON(); 
	},
	
	setValuesAction : function() 
    {
		// kopiere nach Systemcharakteristik
		var submitVars = Object.fromStorage( "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK2" );
		setstring( "IDC_LASTKETTE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.IDC_LASTKETTE );
		if (submitVars.IDC_LASTKETTE == "EINZEL_LAGER")
		{
			setstring( "IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.IDC_ROHRRICHTUNG );
			setstring( "IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.IDC_ROHRVERLAUF );
			setstring( "KOORD_IMG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.KOORD_IMG );
			setstring( "KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.KOORD_IMG_VAR );
			setstring( "SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.SCHRAEG_ALPHA );
			setstring( "SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.SCHRAEG_BETA );
			setstring( "SENKR_ACHSE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.SENKR_ACHSE );
			setstring( "SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", submitVars.SENKR_RICHT );
		}
	}
});