SonderteilController = function() {
	SonderteilController.superclass.constructor.call(this);
}

EasyKat.extend( SonderteilController, CustomController,
{
	storePath : "DLGDATA.CA.FORMS.SONDERTEIL",
	
	checkValuesAction: function(myData) {
		var data = Object.fromStorage( this.storePath );
        var message = "";
        var bOK = true;
        
        // In Kundenversion Preis und Matnr generell disablen!!
        // @@@@ In Version mit Preisen sind Preis und Matnr verpflichtend ???
        // (data.PREIS == "") ||
        // (data.WI_MATNR == "") ||

        var GEWICHT    = trimleft(getdlgvar("GEWICHT"), " ");
        var STUECKZAHL = trimleft(getdlgvar("STUECKZAHL"), " ");
        var ZEICHNR_BEMERKUNG = trimleft(getdlgvar("ZEICHNR_BEMERKUNG"), " ");
        var EINBAUMASS = trimleft(getdlgvar("EINBAUMASS"), " ");
        var RH_TYP     = trimleft(getdlgvar("RH_TYP"), " ");
        var WERKSTOFF  = trimleft(getdlgvar("WERKSTOFF"), " ");
        var PREIS      = trimleft(getdlgvar("PREIS"), " ");
        var WI_MATNR   = trimleft(getdlgvar("WI_MATNR"), " ");

        if ((GEWICHT == "") ||
            (STUECKZAHL == "") ||
            (ZEICHNR_BEMERKUNG == ""))
        {
            message = translate("IDP_ERROR_SONDERTEIL_NOT_COMPLETE");
            bOK = false;
        }
        
		var response = {
			msg: message,
			ok: bOK
		};
		echo response.toJSON();
		
	},

	reloadValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );
        
		// Dieser Handler wird aufgerufen bei bernahme vom Assi in die Sonderteilmaske
		// Zu diesem Zeitpunkt steht im Store fr die Sonderteildaten u.U. noch "Freie Eingabe",
		// whrend in der Maske sicher schon "Auswahlassi" selektiert ist. Um diese Einstellung 
		// nicht zu berschreiben, wird das Datamember leer gesetzt:
        data.IDC_EINGABEART_STKL = "";

		// Dass wir vom Assi kommen, wissen wir schon ...
		if (atoi(data.OBFL_ERLAUBT) > 0) // ((data.LAENGE > 0) || (data.BREITE > 0))
			data.IDC_ROHMASSPOS = "true";
		else
			data.IDC_ROHMASSPOS = "false";

        
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: data,
			disabled: [
			]
		};

		echo response.toJSON();
    },
    
	getValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );
        
        if (data.mode == "insert")
        {
            delete("DLGDATA.CA.FORMS.SONDERTEIL", "");
            var workSonderteil = new Sonderteil();
            caMainController.dataAccess.setSonderteilToDataObject(data, workSonderteil);
            data.STKPOS = translate("NEW");
			data.IDC_ROHMASSPOS = "false";
            data.toStorage("DLGDATA.CA.FORMS.SONDERTEIL", false);   // kein merge
        }
        else
        {
            var stkList = [];
            caMainController.topologieKlasse.getStueckliste(stkList);
            if (stkList.length >= (data.recordId - 1))
            {
                var workSonderteil = stkList[(data.recordId - 1)].produkt;  
                caMainController.dataAccess.setSonderteilToDataObject(data, workSonderteil);
                // STKPOS gem gew. Pos setzen ...
                data.STKPOS = data.recordId;
                
                // Store setzen: Nicht alle Variablen (Lnge, Breite) werden in dieser Maske bearbeitet
                // darum mssen wir hier auch den Store initialisieren ...
                data.toStorage("DLGDATA.CA.FORMS.SONDERTEIL", false);   // kein merge
                
				if (workSonderteil.bAssistent && (workSonderteil.bOberflaechenschutzFrei > 0))
					data.IDC_ROHMASSPOS = "true";
				else
					data.IDC_ROHMASSPOS = "false";
            }
            // else @@@ irgendwas ist ziemlich schief gelaufen ....
        }

        data.CALCULATION_ENABLED = getstring("CALCULATION_ENABLED","RIGHTS");
        
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: data,
			disabled: [
			]
		};

		echo response.toJSON();
	},

	setValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );

        data.STUECKZAHL = trimleft(data.STUECKZAHL, " ");
        data.RH_TYP     = trimleft(data.RH_TYP, " ");
        data.ZEICHNR_BEMERKUNG = trimleft(data.ZEICHNR_BEMERKUNG, " ");
        data.EINBAUMASS = trimleft(data.EINBAUMASS, " ");
        data.GEWICHT    = trimleft(data.GEWICHT, " ");
        data.WERKSTOFF  = trimleft(data.WERKSTOFF, " ");
        data.PREIS      = trimleft(data.PREIS, " ");
        data.WI_MATNR   = trimleft(data.WI_MATNR, " ");
		data.OBFLSCHUTZ_FREI = trimleft(data.OBFLSCHUTZ_FREI, " ");

        if (data.mode == "insert")
        {
            var workSonderteil = new Sonderteil();
            caMainController.dataAccess.setDataObjectToSonderteil(data, workSonderteil);
            caMainController.topologieKlasse.Sonderteile.push(workSonderteil);
        }
        else
        {
            var stkList = [];
            caMainController.topologieKlasse.getStueckliste(stkList);
            if (stkList.length >= (data.recordId - 1))
            {
                // Das geht, weil Javascript mit Referenzen arbeitet, Daten gehen
                // direkt durch ins Sonderteilobjekt, das im Array in der Topo steht ...
                var workSonderteil = stkList[(data.recordId - 1)].produkt;  
                // -Schu- wenn das Teil erst ein Rohmass-"Assi"-Teil war und zu "Freier Eingabe" gendert wird
				// bleibt das Teil ein Rohmass-Teil wird aber mit fester Mat.-Nr. bergeben
				// das muss korrigiert werden, weil das sonst im SAP zu einem StLi-Fehler fhrt und die
				// StLi gar nicht korrekt angelegt wird
				if ((data.IDC_EINGABEART_STKL == "FREIE_EINGABE") && ((atoi(data.OBFL_ERLAUBT) > 0) || (data.IDC_ROHMASSPOS == "true")))
				{
					data.BREITE			= 0;
					data.IDC_ROHMASSPOS	= "false";
					data.LAENGE			= 0;
					data.MAX_BREITE		= 0;
					data.MAX_LAENGE		= 0;
					data.OBFL_ERLAUBT	= 0;
					data.OBFLSCHUTZ		= "";
					data.STAHLBAU		= "";
				}
				
                caMainController.dataAccess.setDataObjectToSonderteil(data, workSonderteil);
            }
            // else @@@ irgendwas ist ziemlich schief gelaufen ....
        }
        
        // Systemmasse neu berechnen ...
        var woVerschoben = "OBEN";
        strMessage = caMainController.topologieKlasse.berechneFlexibleTeileAusSystemmass(woVerschoben);

	}
});