SonderteilassiController = function() {
	SonderteilassiController.superclass.constructor.call(this);
}

EasyKat.extend( SonderteilassiController, CustomController,
{
	storePath : "DLGDATA.CA.FORMS.ASSISTENT_SONDERTEIL",

	// Wird aufgerufen aus dem UebersichtLastketteCOntroller ...
	addStahlbauSonderteil : function(steelPart, beFIN_Import)
    {	
		var i;
		var strAktuelleSprache = getlanguage();
		
		// Werkstoff wird noch nicht bergeben
		// wenn das gndert wird muss geprft werden, in welcher Form die Info kommt (S235JR oder 1.0038 oder ...)
		if (steelPart.steel_werk == '')
			steelPart.steel_werk = 'empty';
		
		//var strKlasse	= '';
		var strKlasse	= 'EMPTY';
		var strTyp		= '';
		var analyseTyp	= steelPart.steel_typ;
		var bSPEC		= (rfind(analyseTyp, '-SPEC') != -1 ? true : false);
		var TypSPEC		= "";
		if (bSPEC){
			TypSPEC		= left(steelPart.steel_typ, rfind(analyseTyp, '-SPEC') - 1);
			analyseTyp	= right(steelPart.steel_typ, steelPart.steel_typ.length - (rfind(analyseTyp, '-SPEC') + 4));
		}
		else{
			TypSPEC		= left(steelPart.steel_typ, rfind(analyseTyp, '/') - 1);
			analyseTyp	= right(steelPart.steel_typ, steelPart.steel_typ.length - rfind(analyseTyp, '/'));
		}
		
		analyseTyp		= replace(analyseTyp, '/', '');
		analyseTyp		= replace(analyseTyp, ',', '.');
		var analyseTyp1	= left(analyseTyp, 1);
		var analyseTyp2	= left(analyseTyp, 2);
		var analyseTypR	= right(analyseTyp, 1);
		var aSpalte		= [];
		var strSpalteWerkst;
	
	// Zahlen aus STEEL_TYP extrahieren
		var aZ = [];
		var minD = '';
		var strZ = '';
		i=0;
		while (i < analyseTyp.length)
		{
			if ((analyseTyp[i] >= '0') && (analyseTyp[i] <= '9'))
				break;
			i++;
		}
		while (i < analyseTyp.length && ((analyseTyp[i] >= '0' && analyseTyp[i] <= '9') || analyseTyp[i] == 'x' || analyseTyp[i] == '.'))
		{
			strZ += analyseTyp[i];
			i++;
		}
		aZ = strZ.split('x');

	// Spaltennamen und -werte fr SELECT in SAP_Ms
	// array enthlt Spaltenname, Wert, Spaltenname, Wert, ...
		if (steelPart.steel_art == 'BOX') {
			strKlasse = 'BLE';
			strSpalteWerkst = 'MERKM_4';
			minD = min(min(steelPart.steel_mass[0], steelPart.steel_mass[1]),
				steelPart.steel_mass[2]);
			aSpalte.push('MERKM_1');
			aSpalte.push('' + minD);
			aSpalte.push('MERKM_4');
			if (steelPart.steel_werk == 'empty')
				aSpalte.push('1.0038');
			else
				aSpalte.push(steelPart.steel_werk);
		}
		else if (steelPart.steel_art == 'CYLI') {
			strKlasse = 'PRR';
			strSpalteWerkst = 'MERKM_2';
			aSpalte.push('MERKM_1');
			aSpalte.push(steelPart.steel_mass[0]);
			aSpalte.push('MERKM_2');
			if (steelPart.steel_werk == 'empty')
				aSpalte.push('1.0533');
			else
				aSpalte.push(steelPart.steel_werk);
		}
		else {
			if (steelPart.steel_klass == 'BEAM') {
				strKlasse = 'PRT';
				strSpalteWerkst = 'MERKM_4';
				if (analyseTyp2 == 'HE')
					strTyp = 'HE' + analyseTypR;
				else
					strTyp = 'IPE';
				aSpalte.push('MERKM_6');
				aSpalte.push(strTyp);
				aSpalte.push('MERKM_7');
				aSpalte.push(aZ[0]);
			}
			else if (steelPart.steel_klass == 'DINI') {
				strKlasse = 'PRT';
				strSpalteWerkst = 'MERKM_4';
				strTyp = 'INP';
				aSpalte.push('MERKM_6');
				aSpalte.push(strTyp);
				aSpalte.push('MERKM_7');
				aSpalte.push(aZ[0]);
			}
			else if (steelPart.steel_klass == 'DINT') {
				strKlasse = 'PRT';
				strSpalteWerkst = 'MERKM_4';
				strTyp = 'T';
				aSpalte.push('MERKM_6');
				aSpalte.push(strTyp);
				aSpalte.push('MERKM_7');
				aSpalte.push(aZ[0]);
			}
			else if (steelPart.steel_klass == 'DINU') {
				strKlasse = 'PRU';
				strSpalteWerkst = 'MERKM_5';
				strTyp = 'U';
				aSpalte.push('MERKM_7');
				aSpalte.push(strTyp);
				aSpalte.push('MERKM_1');
				aSpalte.push(aZ[0]);
				if (steelPart.steel_mass.length > 1) {
					aSpalte.push('MERKM_2');
					aSpalte.push(aZ[1]);
				}
			}
			else if (steelPart.steel_klass == 'ANG') {
				strKlasse = 'PRW';
				strSpalteWerkst = 'MERKM_6';
				var aTmp = analyseTyp.split('x');
				if (aTmp.length == 2)
					strTyp = 'LG';
				else
					strTyp = 'LU';
				//if (steelPart.steel_mass.length == 2) {
				if (aZ.length == 2) {
					aSpalte.push('MERKM_2');
					aSpalte.push(aZ[0]);
					aSpalte.push('MERKM_4');
					aSpalte.push(aZ[1]);
				}
				else
				{
					aSpalte.push('MERKM_2');
					aSpalte.push(aZ[0]);
					aSpalte.push('MERKM_3');
					aSpalte.push(aZ[1]);
					aSpalte.push('MERKM_4');
					aSpalte.push(aZ[2]);
				}
				aSpalte.push('MERKM_8');
				aSpalte.push(strTyp);
				//@@@ Werkstoff wird festgeschrieben !!
				aSpalte.push('MERKM_6');
				if (steelPart.steel_werk == 'empty')
					aSpalte.push('1.0038');
				else
					aSpalte.push(steelPart.steel_werk);
			}
			else if (steelPart.steel_klass == 'BOX' && toupper(analyseTyp2) == 'FL') {	// Flachstahl - wenn wir hier nichts finden, knnen wir Blech nehmen
				strKlasse = 'PRF';
				strTyp = 'FLACH';
				strSpalteWerkst = 'MERKM_3';
				aSpalte.push('MERKM_1');
				aSpalte.push(aZ[0]);
				aSpalte.push('MERKM_2');
				aSpalte.push(aZ[1]);
				aSpalte.push('MERKM_3');
				if (steelPart.steel_werk == 'empty')
					aSpalte.push('1.0038');
				else
					aSpalte.push(steelPart.steel_werk);
			}
			else if (steelPart.steel_klass == 'BOX') {
				strKlasse = 'PRX';
				strTyp = 'HOHLPROFIL';
				strSpalteWerkst = 'MERKM_5';
				aSpalte.push('MERKM_1');
				aSpalte.push(aZ[0]);
				aSpalte.push('MERKM_2');
				aSpalte.push(aZ[1]);
				aSpalte.push('MERKM_3');
				aSpalte.push(aZ[2]);
			}
			else if (steelPart.steel_klass == 'TUBE') {
				strKlasse = 'ROM';
				strTyp = 'ROM';
				strSpalteWerkst = 'MERKM_6';
				aSpalte.push('MERKM_2');
				aSpalte.push(aZ[0]);
				aSpalte.push('MERKM_3');
				aSpalte.push(aZ[1]);
				aSpalte.push('MERKM_6');
				if (steelPart.steel_werk == 'empty')
					aSpalte.push('1.0254');
				else
					aSpalte.push(steelPart.steel_werk);
			}
			else if (steelPart.steel_klass == 'RBAR') {
				strKlasse		= 'PRR';
				strSpalteWerkst	= 'MERKM_2';
				aSpalte.push('MERKM_1');
				aSpalte.push(aZ[0]);
				aSpalte.push(strSpalteWerkst);
				if (steelPart.steel_werk == 'empty')
					aSpalte.push('1.0533');
				else
					aSpalte.push(steelPart.steel_werk);
			}
		}

	// SELECT zusammenbauen
        var strSQLStatement = "select * from MATERIAL where KLASSE='" + strKlasse + "' ";
        for (i=0 ; i < aSpalte.length ; i+=2)
        {
			strSQLStatement += " and " + aSpalte[i] + "='" + aSpalte[i+1] +"' ";
        }

        var numRet = dbselect("SAP_M", strSQLStatement, "SPART");
		
		var bInDB	= (numRet == 0 ? false : true);		// gibt es das gesuchte Teil in der FL-DB?

	// Daten aus DB bertragen
		var sonderteil = new Sonderteil();
        sonderteil.nAnzahl          = (!steelPart.steel_anzahl ? '1' : steelPart.steel_anzahl);  
		sonderteil.bAssistent 		= (bInDB ? 1 : 0);
        sonderteil.RHTyp            = (bInDB ? 'FP_ST' : 'FP_ZU');
        sonderteil.m_Pemass         = 0;
        //sonderteil.m_Pgewicht       = atoi(dbgetstring("SPART", "GEWICHT"));
		sonderteil.m_Pgewicht       = (bInDB ? atod(dbgetstring("SPART", "GEWICHT")) : 0.001);
		
		sonderteil.Typ				= strKlasse;
        
        sonderteil.m_Pwerkname      = (bInDB ? dbgetstring("SPART", strSpalteWerkst) : steelPart.steel_werk);
        sonderteil.m_Pwerkstoff     = "W_SONST";
        sonderteil.WIMatnr          = (bInDB ? dbgetstring("SPART", "MAT_NR") : "");
        sonderteil.RMBreite = 0;
        if (steelPart.steel_art == 'CYLI') 
		{
			sonderteil.RMLaenge = atoi(steelPart.steel_mass[1]);
		}
		else if (steelPart.steel_art == 'BOX')
		{
			if (steelPart.steel_mass[0] == minD)
			{
				sonderteil.RMLaenge = max(steelPart.steel_mass[1], steelPart.steel_mass[2]);
				sonderteil.RMBreite = min(steelPart.steel_mass[1], steelPart.steel_mass[2]);
			}
			else if (steelPart.steel_mass[1] == minD)
			{
				sonderteil.RMLaenge = max(steelPart.steel_mass[0], steelPart.steel_mass[2]);
				sonderteil.RMBreite = min(steelPart.steel_mass[0], steelPart.steel_mass[2]);
			}
			else
			{
				sonderteil.RMLaenge = max(steelPart.steel_mass[0], steelPart.steel_mass[1]);
				sonderteil.RMBreite = min(steelPart.steel_mass[0], steelPart.steel_mass[1]);
			}
		}
		else if (bInDB)
		{
			sonderteil.RMLaenge = (atoi(steelPart.steel_mass[0]) < 0 ? 0 : atoi(steelPart.steel_mass[0]));
		}
		else
			sonderteil.RMLaenge = "";
		
		sonderteil.strFertigungsverfahren = (bInDB ? dbgetstring("SPART", "STAHLBAU") : "");
		if (toupper(dbgetstring("SPART", "OBERFL_FREI")) == "X")
			sonderteil.bOberflaechenschutzFrei = 1;
		else
			sonderteil.bOberflaechenschutzFrei = 0;
		sonderteil.RMMaxLaenge = (bInDB ? atoi(dbgetstring("SPART", "MAX_LAENGE")) : "");
		sonderteil.RMMaxBreite = (bInDB ? atoi(dbgetstring("SPART", "MAX_BREITE")) : "");

		sonderteil.m_strMasse = 0;
		if (steelPart.steel_art == 'BOX')
		{
			//sonderteil.m_strMasse = sonderteil.RMBreite * sonderteil.RMLaenge * minD * 7.85 / 1000000.0;
			sonderteil.m_Pgewicht = fround(sonderteil.RMBreite * sonderteil.RMLaenge * minD * 7.85 / 1000000.0, 2);
		}
		else if (bInDB)
		{
			//sonderteil.m_strMasse = sonderteil.m_Pgewicht * sonderteil.RMLaenge / 1000.0;
			sonderteil.m_Pgewicht = fround(sonderteil.m_Pgewicht * sonderteil.RMLaenge / 1000.0, 2);
		}
		
		if (getstring("PRICES_ENABLED", "RIGHTS") == "1" && bInDB)
        {
			// Fremdwaehrungen: Im Kundenpreis steht immer der eingegebene Preis in Fremdwhrung;
			// Im Standard-Feld m_Ppreis steht dann der umgerechnete Euro-preis, der auch zum Aufsummieren
			// in der LK benutzt wird (dort nur Euro).
			var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
			if (dCurrencyFactor < 0.01)
				dCurrencyFactor = 1.0;
            sonderteil.m_dKundenPreis   = fround(sonderteil.m_Pgewicht * dbgetstring("SPART", "PREIS"), 2);
            sonderteil.m_bPreisVorgabe  = 1;
            sonderteil.m_Ppreis         = fround(sonderteil.m_dKundenPreis / dCurrencyFactor, 2);
        }
		
		sonderteil.m_Pcpartid = '';  // @@@ TODO data.DATA_LOGICID;
        
		var StueliTyp	=	(bInDB ? translate(dbgetstring("SPART", "STUELI_BEZ_EN")) : steelPart.steel_typ) ;
		var Einheit_mm	=	(bInDB ? translate("IDC_BERECHNETE_LAENGE_EINHEIT") : "");
		var NewLine		=	"";
		var Leer		=	" ";
		for (var i = 0; i < 2; i++)
		{
			switch (strKlasse)
			{
				case "BLE":
					sonderteil.Artikeltext = (bInDB ? StueliTyp + " " + minD + NewLine + Leer + sonderteil.RMBreite + "x" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					break;
				case "ROM":
					sonderteil.Artikeltext = (bInDB ? StueliTyp + " " + strZ + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					break;
				case "PRR":
					sonderteil.Artikeltext = (bInDB ? StueliTyp + " " + aSpalte[1] + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					break;
				case "PRX":
					sonderteil.Artikeltext = (bInDB ? StueliTyp + " " + strZ + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					break;
				case "PRF":
				case "PRW":
					sonderteil.Artikeltext = (bInDB ? StueliTyp + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					break;
				default:
					sonderteil.Artikeltext = (bInDB ? strTyp + " " + strZ + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : steelPart.steel_typ);
					//sonderteil.Artikeltext = (bInDB ? strTyp + " " + strZ + NewLine + Leer + "l=" + sonderteil.RMLaenge + Einheit_mm : replaceSpecialChars(steelPart.steel_typ, {FuerCSV : 0, FuerDateiname : 1}));
					break;
			}
				
			if (sonderteil.Artikeltext.length > 20)
			{
				if (!bInDB){
					var Text				= sonderteil.Artikeltext;
					sonderteil.Artikeltext	= "";
					var X20					= ceil(Text.length / 20);
					var TextPart			= left(Text, 20);
					for (var txt=1; txt<=X20; txt++){
						sonderteil.Artikeltext	+= TextPart + (txt != X20 ? Leer : "");
						TextPart	= right(Text, Text.length - txt*20);
						TextPart	= (TextPart.length <= 20 ? TextPart : left(TextPart, 20));
					}
					i = 2;
				}
				
				NewLine	= "\n";
				Leer	= "";
			}
			else
				i = 2;
		}
		
		sonderteil.Artikeltext = sonderteil.Artikeltext.split('\n');

        sonderteil.m_Poberfl        = "OB_LEER";   
		sonderteil.m_PoberflFrei 	= "";
		if (sonderteil.bOberflaechenschutzFrei)	
		{
			sonderteil.m_Poberfl = "OB_ROH"; // @@@ Preis gilt ja nur fr roh
			sonderteil.Artikeltext[sonderteil.Artikeltext.length] = translate("OBERFLAECHENSCHUTZ") + " " + translate(OberflaechenschutzTransID[sonderteil.m_Poberfl]);
			if (sonderteil.m_Poberfl == "OB_SONST")
			{
				sonderteil.m_PoberflFrei = ''; // @@@ TODO data.OBFLSCHUTZ_FREI;
				sonderteil.Artikeltext[sonderteil.Artikeltext.length] = translate("OBERFLAECHENSCHUTZ") + " " + data.OBFLSCHUTZ_FREI;
			}
		}
        
        sonderteil.m_Ptyp       = "";
        if (sonderteil.Artikeltext > 0)
            sonderteil.m_Ptyp = sonderteil.Artikeltext[0];

        sonderteil.m_Ptypid 	= "SON";
        sonderteil.m_Pzeichnr 	= "SONDERTEIL";   // hier nur ID eintragen, spter dann bersetzen

		if (!beFIN_Import)
			caMainController.topologieKlasse.Sonderteile.push(sonderteil);
		else
			return (sonderteil);
	},
	
	selectValues : function(data)
    {
        data.itemLists = {};

        var strAktuelleSprache = getlanguage();
        if ((strAktuelleSprache != "DE") && (strAktuelleSprache != "EN"))
            strAktuelleSprache = "EN";
        
        var strSQLStatement = "select distinct PRODUKTGRUPPE as RESULT_TRANS, PRODUKTGRUPPE as RESULT from SONDERTEILE_TYPEN order by abs(SEQ_ID) ";
        this.selectValuesSingleCombo(data, strSQLStatement, "PRODUKTGRUPPE", "items_produktgruppe");

        strSQLStatement = "select distinct ART as RESULT_TRANS, ART as RESULT from SONDERTEILE_TYPEN where PRODUKTGRUPPE='"+data.PRODUKTGRUPPE+"' order by abs(SEQ_ID) ";
        this.selectValuesSingleCombo(data, strSQLStatement, "ART", "items_art");

        strSQLStatement = "select distinct TYP_ANZEIGE_ID as RESULT_TRANS, TYP_DB as RESULT from SONDERTEILE_TYPEN where PRODUKTGRUPPE='"+data.PRODUKTGRUPPE+"' and ART='"+data.ART+"' order by abs(SEQ_ID) ";
        this.selectValuesSingleCombo(data, strSQLStatement, "TYP", "items_typ");

        // Anhand von TYP die Klasse bestimmen 
        var strKlasse = "", strBild = "";
        strSQLStatement = "select KLASSE, NAME_BILD from SONDERTEILE_TYPEN where PRODUKTGRUPPE='"+data.PRODUKTGRUPPE+"' and TYP_DB='"+data.TYP+"' ";
        var numRet  = dbselect("SAP_V", strSQLStatement, "KLASSE");
        if (numRet > 0)
		{
            strKlasse = data.KLASSE = dbgetstring("KLASSE", "KLASSE");	// geht das
            strBild   = dbgetstring("KLASSE", "NAME_BILD");
			if (strBild != "")
				data["NAME_BILD"] = "catalog/client/custom/img/specpart/" + strBild;
			else
				data["NAME_BILD"] = "catalog/client/custom/img/specpart/Empty.gif";
        }
        // Weitere variable Merkmale auslesen ....
        strSQLStatement = "select * from SONDERTEILE_TYPEN_MERKMALE where TYP_DB='"+data.TYP+"' order by abs(SEQ_ID) ";
        numRet  = dbselect("SAP_V", strSQLStatement, "MERKMALE");
        var merkmal = "", spalte = "";
        var i = 1, spalteTyp = "", spalteWerk = "";
        while (dbiseof("MERKMALE") == 0)
        {
            merkmal = dbgetstring("MERKMALE", "MERKMAL");
            spalte  = dbgetstring("MERKMALE", "SPALTE");
            if (merkmal == "TYP")
                spalteTyp = spalte;
            if (merkmal == "WERKSTOFF")
                spalteWerk = spalte;
            
            dbskip("MERKMALE");
        }
        dbgotop("MERKMALE");
        while (dbiseof("MERKMALE") == 0)
        {
            merkmal = dbgetstring("MERKMALE", "MERKMAL");
            spalte  = dbgetstring("MERKMALE", "SPALTE");
            
            // Fr jedes Merkmal die mglichen Werte bestimmen, ausser fr TYP
            if (merkmal != "TYP")
            {
                data["ASS_SELECT_SPALTE_"+i] = spalte;
                data["ASS_SELECT_NAME_"+i] = translate(merkmal);
                this.selectValuesVariableAttribute(data, strKlasse, merkmal, spalte, spalteTyp, i);
                i++;
            }
                
            dbskip("MERKMALE");
        }
        // restliche leer initialisieren
        for ( ; i<=5 ; i++)
        {
            data["ASS_SELECT_"+i] = "";
            data["ASS_SELECT_SPALTE_"+i] = "";
            data["ASS_SELECT_NAME_"+i] = "";
            data.itemLists["ASS_SELECT_ITEMS_"+i] = [];
        }

        // Jetzt die Sichtbarkeit der Editfelder festlegen:
        data.visible_laenge = "0";
        data.visible_breite = "0";
        strSQLStatement = "select * from SONDERTEILE_RM_WERTE where KLASSE='"+strKlasse+"' and TYP_DB='"+data.TYP+"' ";
        var numRet  = dbselect("SAP_V", strSQLStatement, "ROHMASSE");
        var item    = "";
        while (dbiseof("ROHMASSE") == 0)
        {
            item = dbgetstring("ROHMASSE", "RM_WERT");
            if (item == "LAENGE")
                data.visible_laenge = "1";
            if (item == "BREITE")
                data.visible_breite = "1";
            dbskip("ROHMASSE");
        }
        
        // Spalte merken, in der der Werkstoff steht
        setstring("SPALTEWERK", this.storePath, spalteWerk);
        
        // finaler Schlag: Tabelle initialisieren
        data.aGrid = [];
        strSQLStatement = "select * from MATERIAL where KLASSE='"+strKlasse+"' ";
        if (spalteTyp == "")
            strSQLStatement += " and MAT_NR!='//' ";
        else
            strSQLStatement += " and MERKM_"+spalteTyp+"='"+data.TYP+"' ";
        for (i=1 ; i<=5 ; i++)
        {
            if ((data["ASS_SELECT_SPALTE_"+i] != "") &&
                (data["ASS_SELECT_"+i] != "ALL"))
            {
                strSQLStatement += " and MERKM_"+data["ASS_SELECT_SPALTE_"+i]+"='"+data["ASS_SELECT_"+i]+"' ";
            }
        }
        var numRet  = dbselect("SAP_M", strSQLStatement, "ASSI");
        i = 0;
		var konfig, gewicht, max_laenge, max_breite;
        while (dbiseof("ASSI") == 0)
        {
            mat_nr       = dbgetstring("ASSI", "MAT_NR");
            mat_kurz_txt = translate(dbgetstring("ASSI", "STUELI_BEZ_" + strAktuelleSprache));
            if (mat_kurz_txt == "")
                mat_kurz_txt = dbgetstring("ASSI", "MAT_KURZ_TXT_" + strAktuelleSprache);
			else	// noch weitere Infos (Werkstoff, Dicke, ...) setzten
			{
				switch (strKlasse)
				{
					case "BLE":
						mat_kurz_txt += " " + dbgetstring("ASSI", "MERKM_1") + " - " + dbgetstring("ASSI", "MERKM_4");
						break;
					case "PRR":
						mat_kurz_txt += " " + dbgetstring("ASSI", "MERKM_1") + " - " + dbgetstring("ASSI", "MERKM_2");
						break;
					case "ROM":
						mat_kurz_txt += " " + dbgetstring("ASSI", "MERKM_2") + "x" + dbgetstring("ASSI", "MERKM_3");
						break;
					case "PRX":
						mat_kurz_txt += " " + dbgetstring("ASSI", "MERKM_1") + "x" + dbgetstring("ASSI", "MERKM_2") + "x" + dbgetstring("ASSI", "MERKM_3");
						break;
					default:
						break;
				}
			}
            konfig       = dbgetstring("ASSI", "KONFIG");
            gewicht      = dbgetstring("ASSI", "GEWICHT");
            max_laenge      = dbgetstring("ASSI", "MAX_LAENGE");
            max_breite      = dbgetstring("ASSI", "MAX_BREITE");
            
            if ((data.visible_laenge == "1") && (data.visible_breite == "1"))
                gewicht += " [kg/m2]";
            else if ((data.visible_laenge == "1") || (data.visible_breite == "1"))
                gewicht += " [kg/m]";
            else
                gewicht += " [kg]";

            data.aGrid.push({ id: i,
                              mat_nr: mat_nr,
                              mat_kurz_txt: mat_kurz_txt,
                              konfig: konfig,
                              gewicht: gewicht,
                              preis: '',             // fehlt uns leider ;-(
							  max_laenge: max_laenge,
							  max_breite: max_breite
                            });
            i++;
            dbskip("ASSI");
        }

    },
    
	selectValuesVariableAttribute : function(data, strKlasse, merkmal, spalte, spalteTyp, indexMerkmal)
    {
        var aItems  = [];
        var strSQLStatement = "select distinct MERKM_"+spalte+" as RESULT from MATERIAL where KLASSE='"+strKlasse+"' and MERKM_"+spalteTyp+"='"+data.TYP+"' order by abs(MERKM_"+spalte+") ";
        if (spalteTyp == "")
            strSQLStatement = "select distinct MERKM_"+spalte+" as RESULT from MATERIAL where KLASSE='"+strKlasse+"' and MAT_NR!='//' order by abs(MERKM_"+spalte+") ";
        var numRet  = dbselect("SAP_M", strSQLStatement, "ASSI");
        var item    = "";
        var attrValueName = "ASS_SELECT_"+indexMerkmal;
        var attrPossibleValuesName = "ASS_SELECT_ITEMS_"+indexMerkmal;
        var bFound  = false;
        aItems.push(["ALL", translate("ALL")]);
        while (dbiseof("ASSI") == 0)
        {
            item        = dbgetstring("ASSI", "RESULT");
            if (item == data[attrValueName])
                bFound = true;
            aItems.push([item, translate(item)]);
            dbskip("ASSI");
        }
        data.itemLists[attrPossibleValuesName] = aItems;
        if (!bFound && (aItems.length > 0))
            data[attrValueName] = aItems[0][0];
        else if (!bFound)
            data[attrValueName] = "";
    },

	selectValuesSingleCombo : function(data, strSQLStatement, attrValueName, attrPossibleValuesName)
    {
        var aItems  = [];
        var numRet  = dbselect("SAP_V", strSQLStatement, "ASSI");
        var item    = "", item_trans = "";
        var bFound  = false;
        while (dbiseof("ASSI") == 0)
        {
            item        = dbgetstring("ASSI", "RESULT");
            item_trans  = dbgetstring("ASSI", "RESULT_TRANS");
            if (item == data[attrValueName])
                bFound = true;
            aItems.push([item, translate(item_trans)]);
            
            dbskip("ASSI");
        }
        data.itemLists[attrPossibleValuesName] = aItems;
        if (!bFound && (aItems.length > 0))
            data[attrValueName] = aItems[0][0];
        else if (!bFound)
            data[attrValueName] = "";
    },
    
	getValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );
        
        this.selectValues(data);

        // itemListen Beispiel:
        /* 
        data.itemLists = {
            items_art: [[ "PROFIL", "Profil" ],
                        [ "ROHR", "Rohr" ]],
            items_typ: [[ "HEB_DIN_1025-2", "HEB DIN 1025-2" ],
                        [ "HEB_BLABLA", "HEB BlaBla" ]]
        };
        */

        data.CALLER_ID = "RH";

		var myData = {
            success: true,
			data: data,
			disabled: [
			]
		};

		echo myData.toJSON();
	},

	updateValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );
        
        this.selectValues(data);

		var myData = {
            success: true,
			data: data,
			disabled: [
			]
		};

		echo myData.toJSON();
	},

	setValuesAction : function()
    {
        var data = Object.fromStorage( this.storePath );
        /* data:
            PRODUKTGRUPPE
            ART
            TYP
            ASS_SELECT_1/2/3/4/5
            LAENGE
            BREITE
        */

        var strAktuelleSprache = getlanguage();
        if ((strAktuelleSprache != "DE") && (strAktuelleSprache != "EN"))
            strAktuelleSprache = "EN";
        
        setstring("LAENGE",  "DLGDATA.CA.FORMS.SONDERTEIL", "");
        setstring("BREITE",  "DLGDATA.CA.FORMS.SONDERTEIL", "");
        
        if (data.TABLE_SELECTED_MAT == "")
            return;
        var strSQLStatement = "select * from MATERIAL where MAT_NR='"+data.TABLE_SELECTED_MAT+"' ";
        var numRet  = dbselect("SAP_M", strSQLStatement, "MAT_SELECT");
        var calcGewicht = 0;
        if (numRet > 0)
        {
            var strKlasse		= dbgetstring("MAT_SELECT", "KLASSE");
			if (strKlasse == "PRT" || strKlasse == "PRU" || strKlasse == "PRW" ||
				strKlasse == "PRX" || strKlasse == "PRR" || strKlasse == "ROM" || strKlasse == "BLE")
			{
				var StueliTyp		=	translate(dbgetstring("MAT_SELECT", "STUELI_BEZ_EN"));
				var Einheit_mm		=	translate("IDC_BERECHNETE_LAENGE_EINHEIT");
				var NewLine			=	"";
				var Leer			=	" ";
				var j				=	0;
				var mat_kurz_txt	=	"";
				for (var i = 0; i < 2; i++)
				{
					switch (strKlasse)
					{
						case "BLE":
							var minD = dbgetstring("MAT_SELECT", "MERKM_1");
							mat_kurz_txt = StueliTyp + " " + minD + NewLine + Leer + data.BREITE + "x" + data.LAENGE + Einheit_mm;
							break;
						case "ROM":
							var strZ = dbgetstring("MAT_SELECT", "MERKM_2") + "x" + dbgetstring("MAT_SELECT", "MERKM_3");
							mat_kurz_txt = StueliTyp + " " + strZ + NewLine + Leer + "l=" + data.LAENGE + Einheit_mm;
							break;
						case "PRR":
							mat_kurz_txt = StueliTyp + " " + dbgetstring("MAT_SELECT", "MERKM_1") + NewLine + Leer + "l=" + data.LAENGE;
							break;
						case "PRX":
							var strZ = dbgetstring("MAT_SELECT", "MERKM_1") + "x" + dbgetstring("MAT_SELECT", "MERKM_2");
							mat_kurz_txt = StueliTyp + " " + strZ + NewLine + Leer + "l=" + data.LAENGE + Einheit_mm;
							break;
						default:
							var strTyp	= "";
							var strZ	= "";
							while (j < StueliTyp.length)
							{
								if ((StueliTyp[j] >= '0') && (StueliTyp[j] <= '9'))
									break;
								strTyp += StueliTyp[j];
								j++;
							}
							while (j < StueliTyp.length && ((StueliTyp[j] >= '0' && StueliTyp[j] <= '9') || StueliTyp[j] == '.' || StueliTyp[j] == 'X'))
							{
								strZ += StueliTyp[j];
								j++;
							}
							strZ	= trimleft(trimright(strZ, " "), " ");
							strTyp	= trimleft(trimright(strTyp, " "), " ");
							mat_kurz_txt = strTyp + " " + strZ + NewLine + Leer + "l=" + data.LAENGE + Einheit_mm;
							break;
					}
					if (mat_kurz_txt.length > 20)
					{
						NewLine	= "\n";
						Leer	= "";
					}
					else
						i = 2;
				}
			}
			else
			{
				var mat_kurz_txt 	= dbgetstring("MAT_SELECT", "STUELI_BEZ_" + strAktuelleSprache);
				if (mat_kurz_txt == "")
					mat_kurz_txt 	= dbgetstring("MAT_SELECT", "MAT_KURZ_TXT_" + strAktuelleSprache);
            }
			var konfig       	= dbgetstring("MAT_SELECT", "KONFIG");
            var gewicht      	= dbgetstring("MAT_SELECT", "GEWICHT");
            var strStahlbau  	= dbgetstring("MAT_SELECT", "STAHLBAU");
            var strObflErlaubt  = dbgetstring("MAT_SELECT", "OBERFL_FREI");
            var strMaxLaenge  	= dbgetstring("MAT_SELECT", "MAX_LAENGE");
            var strMaxBreite 	= dbgetstring("MAT_SELECT", "MAX_BREITE");
            var strMasse 		= dbgetstring("MAT_SELECT", "MASSE");
            var strEmass 		= dbgetstring("MAT_SELECT", "EMASS");
            var strLogicID 		= dbgetstring("MAT_SELECT", "LOGICID");
			var nObflErlaubt	= 0;
			if (strObflErlaubt.toUpperCase() == "X")
				nObflErlaubt	= 1;

			// Pfad frs Sonderteil (nicht Assi) befllen, steht dann dort im data-Objekt zur Verfgung:
			setstring("STAHLBAU",  			"DLGDATA.CA.FORMS.SONDERTEIL", strStahlbau);
			setstring("OBFL_ERLAUBT",  		"DLGDATA.CA.FORMS.SONDERTEIL", nObflErlaubt);
			setstring("MAX_LAENGE",  		"DLGDATA.CA.FORMS.SONDERTEIL", strMaxLaenge);
			setstring("MAX_BREITE",  		"DLGDATA.CA.FORMS.SONDERTEIL", strMaxBreite);
			
			var retObj = caMainController.topologieKlasse.getSonderteilDaten();
			var strVorgabeObfl = "OB_ROH";
			if (retObj && retObj.OBERFL_CODE && (retObj.OBERFL_CODE != ''))
				strVorgabeObfl = retObj.OBERFL_CODE;
			setstring("OBFLSCHUTZ",  		"DLGDATA.CA.FORMS.SONDERTEIL", strVorgabeObfl);	// Nach jeder Auswahl zurcksetzen, der Preis gilt nur hierfr!
			setstring("OBFLSCHUTZ_FREI",  	"DLGDATA.CA.FORMS.SONDERTEIL", "");			// Nach jeder Auswahl zurcksetzen, der Preis gilt nur hierfr!

            if (data.visible_laenge == "1")
            {
                setstring("LAENGE",  "DLGDATA.CA.FORMS.SONDERTEIL", data.LAENGE);
            }
            if (data.visible_breite == "1")
            {
                setstring("BREITE",  "DLGDATA.CA.FORMS.SONDERTEIL", data.BREITE);
            }

			if (left(data.TYP, 3) == "ZRM")
			{
				var lengthFormat = sprintf("%.4d", data.LAENGE);
				mat_kurz_txt = replace(mat_kurz_txt, "xxxx", lengthFormat);
			}
			else if (strKlasse != "PRT" && strKlasse != "PRU" && strKlasse != "PRW" &&
						strKlasse != "PRX" && strKlasse != "PRR" && strKlasse != "ROM" && strKlasse != "BLE")
			{
				if ((data.visible_laenge == "1") && (data.visible_breite == "1"))
					mat_kurz_txt += ": " +  data.LAENGE + "x" + data.BREITE + "mm";
				else if (data.visible_laenge == "1")
					mat_kurz_txt += ": L=" +  data.LAENGE + "mm";
				else if (data.visible_breite == "1")
					mat_kurz_txt += ": L=" +  data.BREITE + "mm";
			}
			
            if ((data.visible_laenge == "1") && (data.visible_breite == "1"))
                calcGewicht = sprintf("%.2f", atod(gewicht) * (atod(data.LAENGE)/1000) * (atod(data.BREITE)/1000));
            else if (data.visible_laenge == "1")
                calcGewicht = sprintf("%.2f", atod(gewicht) * (atod(data.LAENGE)/1000));
            else if (data.visible_breite == "1")
                calcGewicht = sprintf("%.2f", atod(gewicht) * (atod(data.BREITE)/1000));
            else
                calcGewicht = gewicht;

            // Spalte merken, in der der Werkstoff steht
            var strWerkstoff = "";
            var spalteWerk = getstring("SPALTEWERK", this.storePath);
            if (spalteWerk != "") 
                strWerkstoff = dbgetstring("MAT_SELECT", "MERKM_"+spalteWerk);

			var dPreisEuro  = 0;
			var dPreisFremd = 0;
			var dLPreis = dbgetdouble("MAT_SELECT", "PREIS");
			if (dLPreis > 0)
			{
				var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
				if (dCurrencyFactor < 0.01)
					dCurrencyFactor = 1.0;
					
				if ((data.visible_laenge == "1") || (data.visible_breite == "1"))
					dPreisEuro  = fround(dLPreis * atod(calcGewicht), 2);
				else
					dPreisEuro  = dLPreis;
				dPreisFremd = dPreisEuro * dCurrencyFactor;
			}
			
            setstring("ZEICHNR_BEMERKUNG", "DLGDATA.CA.FORMS.SONDERTEIL", mat_kurz_txt);
            setstring("EINBAUMASS",  "DLGDATA.CA.FORMS.SONDERTEIL", "");
            setstring("GEWICHT",     "DLGDATA.CA.FORMS.SONDERTEIL", calcGewicht);
            setstring("WERKSTOFF",   "DLGDATA.CA.FORMS.SONDERTEIL", strWerkstoff);
            setstring("PREIS",       "DLGDATA.CA.FORMS.SONDERTEIL", ""+dPreisFremd);
            setstring("WI_MATNR",    "DLGDATA.CA.FORMS.SONDERTEIL", data.TABLE_SELECTED_MAT);

            setstring("DATA_MASSE",     "DLGDATA.CA.FORMS.SONDERTEIL", strMasse);
            setstring("DATA_EMASS",     "DLGDATA.CA.FORMS.SONDERTEIL", strEmass);
            setstring("DATA_LOGICID",   "DLGDATA.CA.FORMS.SONDERTEIL", strLogicID);
            
            var RH_TYP = "FP_ST";  //Stahlbau, mal als Annahme
            if (data.PRODUKTGRUPPE == "LAGER")
                RH_TYP = "FP_LS";
            else if (data.PRODUKTGRUPPE == "ZUBEHOER")
                RH_TYP = "FP_ZU";
            else if (data.PRODUKTGRUPPE == "SEKUNDAERSTAHLBAU")
                RH_TYP = "FP_ST";
            
            setstring("RH_TYP", "DLGDATA.CA.FORMS.SONDERTEIL", RH_TYP);  
            
            // Nur fr den Aufruf aus der freien Position heraus:
            data.FP_ARTIKELTEXT = mat_kurz_txt;
            data.FP_MATNR = data.TABLE_SELECTED_MAT;
            data.FP_PREIS = ""+dPreisFremd;
            data.FP_GEWICHT = ""+calcGewicht;
            data.IDC_ROHMASSPOS = ""+nObflErlaubt;
            data.RH_TYP = RH_TYP;
        }
        else
        {
            data.FP_ARTIKELTEXT = '';
            data.FP_MATNR = '';
			data.FP_PREIS = '';
            data.FP_GEWICHT = '';
            data.IDC_ROHMASSPOS = '0';
            data.RH_TYP = '';
        }

		var myData = {
            success: true,
			data: data,
			disabled: [
			]
		};

		echo myData.toJSON();
	}
});