/**
 * SollwerteZubehoerEinzelController
 */
SollwerteZubehoerEinzelController = function() {
	SollwerteZubehoerEinzelController.superclass.constructor.call(this);
};

EasyKat.extend(SollwerteZubehoerEinzelController, CustomController, {

	getValuesAction : function() 
    {
        var strLast = getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
        var passendeLGV = caMainController.sucheLGVzuLast(strLast);
        
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				IDC_LAST: strLast,
				LGV: passendeLGV.defaultLgv
			},
			
			disabled: [
			]
		};
		
		echo response.toJSON(); 
	},

	getLgvAction : function() 
    {
		var last = getdlgvar('betriebslast');
        if (last == "") // Fall: Dialog wird neu aufgeblendet, Feld Last ist noch nicht belegt, wird es aber gleich
            last = getstring("IDC_LAST", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
            
        var passendeLGV = caMainController.sucheLGVzuLast(last);
				
		echo passendeLGV.toJSON(); 
	},
	
	setValuesAction : function() 
    {
        var strLGV = getstring("LGV", "DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL");
		var last = getdlgvar('IDC_LAST');
        if (last != "") 
        {
            // Check: Wenn User last eingibt und direkt auf weiter clickt, wird clientseitiges
            // getLGV u.U. zu spt ausgefhrt:
            var passendeLGV = caMainController.sucheLGVzuLast(last);
            if ((strLGV - 0) < (passendeLGV.defaultLgv - 0))
                strLGV = passendeLGV.defaultLgv;
        }
        
        caMainController.topologieKlasse.a_lgv = strLGV;
	}
});