/**
 * SollwerteZubehoerEinzelController
 */
SollwerteSpannweiteController = function() {
	SollwerteSpannweiteController.superclass.constructor.call(this);
};

EasyKat.extend(SollwerteSpannweiteController, CustomController, {

	getValuesAction : function() 
    {
        var NormSpannweite = getstring("SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");
        var passendeSpannweiten = caMainController.suchePassendeSpannweiten();
        
        var defaultSpannweite = passendeSpannweiten.defaultSpannweite;
        if (NormSpannweite != "")
            defaultSpannweite = NormSpannweite;

        var SonderSpannweite = getstring("IDC_SPANNWEITE_EINZEL_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");
        var SonderCheck = getstring("IDC_SPANNWEITE_EINZEL_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");

        // Wenn nicht eh schon Sonderspannweite und die zuselektierende nicht in der
        // Liste ist, dann setze Sonder ...
        // Achtung: Checkboxen liefern leer falls off, on, falls gecheckt !!!!
        if ((SonderCheck == "") &&
            (findInArray((defaultSpannweite - 0), passendeSpannweiten.spannweiten) < 0))
        {
            SonderCheck = "true";
            SonderSpannweite = defaultSpannweite;
        }
		
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				SPANNWEITE							:	defaultSpannweite,
                IDC_SPANNWEITE_EINZEL_SONDER		:	SonderSpannweite,
                IDC_SPANNWEITE_EINZEL_SONDER_CHECK	:	SonderCheck
			},
			
			disabled: [
			]
		};
		
		echo response.toJSON(); 
	},

	getSpannweitenAction : function() 
    {
        var passendeSpannweiten = caMainController.suchePassendeSpannweiten();

		echo passendeSpannweiten.toJSON(); 
	},
	
	setValuesAction : function() 
    {
        var NormSpannweite		= getstring("SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");
        var SonderSpannweite	= getstring("IDC_SPANNWEITE_EINZEL_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");
        var SonderCheck			= getstring("IDC_SPANNWEITE_EINZEL_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE");
        var CheckSpannweite		= NormSpannweite;
		var bSonder = 0; 
        if ((SonderCheck != "") && (SonderSpannweite != "")){
            bSonder			= 1;
			CheckSpannweite	= SonderSpannweite
		}
		
		var ret = caMainController.setSpannweite(NormSpannweite, SonderSpannweite, bSonder);
        if (ret < 0)
        {
            // FDT: Fall -1 = Fehler bei bestimme Mass und Gewicht - eventuell anderen Text bringen
            var response = {
                success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
                validate: {
                    message: translate("MSG_ERR_SPANNWEITE_AUSSERHALB_BEREICH")
                }
            };
            
            echo response.toJSON();
        }
	}
});