/**
 * SollwerteRohrumschliessendesTeilController
 */
SollwerteRohrumschliessendesTeilController = function() {
	SollwerteRohrumschliessendesTeilController.superclass.constructor.call(this);
};

EasyKat.extend(SollwerteRohrumschliessendesTeilController, CustomController, 
{
	storePath : "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL",
	
	getValuesAction : function() 
    {

        var isSonderRAD     = caMainController.dataAccess.getVorgabeSonderRAD();
        var isSonderSpann   = caMainController.dataAccess.getVorgabeSonderSpann();
        var sonderRADCheck  = "false";
        if (isSonderRAD)
            sonderRADCheck  = "true";
        var sonderSpannCheck = "false";
        if (isSonderSpann)
            sonderSpannCheck = "true";

        var b_nennweite     = caMainController.dataAccess.getNennweite(0);
        // hier caMainController.dataAccess.getRohrAussendurchmesser(0); besser nicht benutzten,
        // wurde evtl. von vorherigem SOnderdurchm. berschrieben ...
        var b_aussendurch   = GetRADfromNennweite(b_nennweite);    
        var b_sonderRAD     = "";
        if (isSonderRAD)
            b_sonderRAD     = caMainController.dataAccess.getRohrAussendurchmesser(0);
        if (b_nennweite == "")
        {
            b_nennweite     = "100";
            b_aussendurch   = "114,3";
        }
        var b_daemmdicke    = caMainController.dataAccess.getDaemmdicke(0);
        var b_spannweite    = caMainController.dataAccess.getNormSpannweite(0);
        var b_sonderSpann   = "";
        if (isSonderSpann)
            b_sonderSpann   = caMainController.dataAccess.getSpannweite(0);
        var b_medientemp    = caMainController.dataAccess.getMediumTemperatur(0);
        var b_umgebungtemp  = caMainController.dataAccess.getUmgebungsTemperatur(0);
        var b_referenztemp  = caMainController.dataAccess.getReferenzTemperatur(0);
        if (b_medientemp == "")
        {
            b_medientemp    = "25";
            b_umgebungtemp  = "25";
            b_referenztemp  = "20";
        }

        var aDisabled = [];
        if ((! caMainController.topologieKlasse.bDoppelt) ||
            caMainController.topologieKlasse.isFDTAuswahl())
        {
            aDisabled = ['IDC_SPANNWEITE', 'IDC_SPANNWEITE_SONDER_CHECK', 'IDC_SPANNWEITE_SONDER'];
            sonderSpannCheck = "false";
            b_sonderSpann   = "";
            b_spannweite    = "";
        }
        else
        {
            if (isSonderSpann)
                aDisabled = ['IDC_SPANNWEITE'];
            else
                aDisabled = ['IDC_SPANNWEITE_SONDER'];
        }
        var aEnabled = ['IDC_SPANNWEITE', 'IDC_SPANNWEITE_SONDER_CHECK', 'IDC_SPANNWEITE_SONDER'];
        
        // Vormals gewhlter Werkstoff wird nicht gesetzt, er wrde in der
        // Maske ohnehin anhand der Temperatur gleich neu gesetzt werden ...

		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				'IDC_SPANNWEITE':               b_spannweite,
				'IDC_DAEMMDICKE':               b_daemmdicke,
                'IDC_AUSSENDURCHMESSER_SONDER_CHECK': sonderRADCheck,
                'IDC_AUSSENDURCHMESSER_SONDER': b_sonderRAD,
                'IDC_SPANNWEITE_SONDER_CHECK':  sonderSpannCheck,
                'IDC_SPANNWEITE_SONDER':        b_sonderSpann,
                'IDC_NENNWEITE_DN':             b_nennweite,
                'IDC_AUSSENDURCHMESSER':        b_aussendurch, 
                'IDC_TEMPERATUR_MEDIUM':        b_medientemp, 
                'IDC_TEMPERATUR_UMGEBUNG':      b_umgebungtemp,
                'IDC_TEMPERATUR_REFERENZ':      b_referenztemp
			},
            enabled: aEnabled,
			disabled: aDisabled
		};
		
		echo response.toJSON(); 
	},
	
	setValuesAction : function() 
    {
        var lkTyp      = caMainController.dataAccess.getLastketteTyp();
        var submitVars = Object.fromStorage(this.storePath);

        if ((caMainController.topologieKlasse.bDoppelt || 
             caMainController.topologieKlasse.bVertikal) &&
            (! caMainController.topologieKlasse.isFDTAuswahl()))
        {
            if (((submitVars.IDC_SPANNWEITE_SONDER_CHECK != "") && (submitVars.IDC_SPANNWEITE_SONDER == "")) ||
                ((submitVars.IDC_SPANNWEITE_SONDER_CHECK == "") && (submitVars.IDC_SPANNWEITE == "")))
            {
                var response = {
                    success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
                    validate: {
                        message: translate("MSG_ERR_SPANNWEITE")
                    }
                };
                
                echo response.toJSON(); 
            }
        }
        
        // Alles OK? Im Fall Sonderdurchmesser die nchstgrere Nennweite finden:
        if (submitVars.IDC_AUSSENDURCHMESSER_SONDER_CHECK != "")
        {
			// Erst mal prfen, ob wir nicht knapp an der nchsten Nennweite liegen
			var rohrData = GetNextNennweiteFromRAD(submitVars.IDC_AUSSENDURCHMESSER_SONDER);

            if (rohrData.success)
            {
                submitVars.IDC_NENNWEITE_DN = rohrData.DN;
                submitVars.IDC_AUSSENDURCHMESSER = rohrData.D;
                setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_NENNWEITE_DN", "DLGDATA.CA.FORMS", rohrData.DN);
                setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER", "DLGDATA.CA.FORMS", rohrData.D);
				if (rohrData.setStdDN)
				{
					submitVars.IDC_AUSSENDURCHMESSER_SONDER_CHECK = "";
					submitVars.IDC_AUSSENDURCHMESSER_SONDER = "";
					setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER_CHECK", "DLGDATA.CA.FORMS", "");
					setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER", "DLGDATA.CA.FORMS", "");
                    
                    // Hinweis ablegen, der dann im Fenster Auswahl Schellentyp gezeigt wird:
                    setstring("HINWEIS_SONDERDRUCH", "TMP", translate("IDP_ABWEICHUNG_DMR_KLEIN"));
				}
            }
			else
			{
                var response = {
                    success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
                    validate: {
                        message: translate("MSG_ERR_SONDERDURCHMESSER_ZU_GROSS")
                    }
                };
                
                echo response.toJSON(); 			
			}
        }
        
        // Prfung ob der gewhlte Werkstoff zulssig ist ... erforderlich wenn der
        // Anwender eine Temperatur ndert und dann direkt auf Weiter clickt
        var strMedienTemp   = caMainController.dataAccess.getMediumTemperatur(false);
        var strRefTemp      = caMainController.dataAccess.getReferenzTemperatur(false);
        var strActWerkstoff = caMainController.dataAccess.getSchellenWerkstoffVorgabe();
        var retObj          = caMainController.getPassendeWerkstoffe(strMedienTemp, strRefTemp, strActWerkstoff);
        for (var i = 0; i < retObj.aDisabled.length; i++) {
            if (retObj.aDisabled[i] == strActWerkstoff) {
                strActWerkstoff = retObj.strRecommended;
                caMainController.dataAccess.setSchellenWerkstoffVorgabe(strActWerkstoff);
            }
        }
        
	},
	
	getReferenzTemperaturValuesAction : function() 
    {
        var strRefTemp      = getdlgvar('refTemp');
        var strMedienTemp   = getdlgvar('medienTemp');
        var actWerkstoff    = getdlgvar('actWerkstoff');
        
        var retObj = caMainController.getPassendeWerkstoffe(strMedienTemp, strRefTemp, actWerkstoff);
        
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			disabled: retObj.aDisabled,
            recommended: retObj.strRecommended
		};
		echo response.toJSON(); 
	}
});